# EXIP-0003 : Secure Storage of Sensitive Application Data On Chain

```
Number:  EXIP-0003
Title:   Secure Storage of Sensitive Application Data On Chain
Type:    Research
Status:  Draft
Authors: ElixiumNetwork <team@elixium.app>
Created: 2018-11-09
```

## Abstract

We're creating a decentralized application network, and often times, applications contain sensitive data required to operate
correctly. We need to be able to provide a solution for our applications to contain this sensitive data without revealing
it to node maintainers.

## Motivation

Environment variables are one example of sensitive data that is sometimes required to run applications. An environment variable
may be an access key / token that allows the application to perform some behavior on behalf of the account owner, and these 
keys should be kept secret -- otherwise a malicious actor could harvest keys from applications running on the chain and use
them to adversely affect the owners of the keys.

In a traditional client/server model application, the server is either owned by or rented out to the person/group who is
running the application. This server is often protected by a firewall and the source code for the application that the server
is running was rarely public. The server would also have a password that only the owners of the server / application would
know -- and it would be dangerous if the attacker obtained access to the server, because then they could modify code and steal
sensitive environment variables at will.

In our decentralized model, the servers are nodes themselves. Every node runs the source code of any given application, meaning
that every node will need access to any sensitive data / environment variables that may be attached to the node. Our challenge
is to find a way to provide the application with this data during runtime _without disclosing the information to the node_.
It must be impossible for a node to learn anything about the sensitive data it is running, lest an attacker run a node in
order to harvest credentials or sensitive data from applications they run.

## Body

I propose that we allow each application that is deployed to the network to have an environment variable / sensitive data
configuration file which is encrypted in such a way that it is possible for the source code to read the data, but impossible
for nodes to read it. More research needs to be done in order to decide how exactly we want to do this.


## References

This is a section for references such as links to other documents (EXIPs)
or to reference implementations.
