# EXIP-0002 : More Highly Reactive Difficulty Scaling Algorithm

```
Number:  EXIP-0002
Title:   More Highly Reactive Difficulty Scaling Algorithm
Type:    Standard
Status:  Accepted
Authors: ElixiumNetwork <team@elixium.app>
Created: 2018-11-06
```

## Abstract

The current difficulty scaling algorithm in Elixium is vulnerable to miner-manipulated difficulty oscillation. EXIP-0002 suggests changes to the difficulty scaling algorithm to make the network more resilient against this type of manipulation.

## Motivation

We're currently using the same [difficulty scaling algorithm that Bitcoin uses](https://en.bitcoin.it/wiki/Difficulty). This algorithm works well for Bitcoin because of its network's massive amount of hashing power -- making it difficult for miners to manipulate. In the case of Elixium, we're going to have to move away from this algorithm because it will be easily manipulated as miners can join / leave and (early on) cause large oscillations in mining difficulty.

Oscillations in mining difficulty are a huge problem, they could cause Elixium to have massive block delays -- instead of a block getting propagated every 2 minutes, it could grow to a new block every 3 days, in the following (pretty likely) scenario:

1. Difficulty is set to 10 and the network is happily chugging along.
2. Mining pool / group of miners with massive hashing power start mining Elixium (lets say, collectively, they have 10x the hashing power of the rest of the network).
3. They quickly reach a new epoch and the difficulty scales proportionately to the new hashrate (becomes lets say a difficulty of 20).
4. Now that mining has become more difficult, miners leave and go mine a different coin.
5. We're now early in an epoch where the mining difficulty is 10x what the network hashrate can handle in order to produce a block every 2 minutes, so blocks are now produced every 20 minutes instead of every 2 minutes, and the entire network moves very slowly until the next epoch, where the difficulty will scale back down.
6. Miners see that the difficulty scaled back down, so they start mining Elixium again, and now we oscillate back up to a high difficulty and repeat the cycle.

Here's an excellent explanation of this issue, cited from the Masari WWHM Paper: 
> This algorithm is rather naive and assumes that the
network hash rate doesn't change much between adjustment periods. This simple
algorithm uses the most recent 720 blocks (approximately 1 day with a 2 minute
block time) as a sample size for difficulties (Di) and uses the timestamps (Ti) from
these blocks to get the total solve time (S). The difficulties are summed such that
`d = sigma(720, i=1, Di)` and the total solve time is found such that S = T720
T1. From this
information the network hash rate (h) is estimated as h = d=S. The next difficulty is
then calculated by multiplying the target time (t) by the estimated hash rate t  h. In
practice this should work such that if the network hash rate is around 4,000 hashes per
second over a consistent period of time then the difficulty should be around 480,000
to keep a steady 120 second block time as 4,000 * 120 = 480,000. This means that it
should take around 480,000 tries before a miner solves a block. If a new miner comes
in with a drastically higher hash rate, say 15,000 hashes per second then it would
only take the new miner around 32 seconds to find a block at the current difficulty as
480,000 / 15,000 = 32. This new miner can then continue mining 32 second blocks until
the difficulty adjusts 720 blocks later, which would take approximately 6.4 hours at
that rate. After the difficulty finally retargets, the difficulty would be about 2,280,000
as (4,000 + 15,000) * 120 = 2,280,000. The attacking miner can then leave the network
as he is no longer reaping the benefits from the slow difficulty adjustment. With this
newly increased difficulty for what is now a small amount of hashing power leaves
block times at around 570 seconds on average as 2,280,000 / 4,000 = 570

We want to find a difficulty scaling algorithm that quickly scales and rebounds from these oscillations and implement it into Elixium.

## Body

We're currently operating using a ~~Simple Moving Average (SMA)~~ Simple Lookback Average difficulty algorithm, where every 10,080 blocks (roughly 2 weeks) we find the average time it took to solve each block and compare it to our target solvetime. We then scale the difficulty based on the difference in actual average solvetime vs target solvetime. This new difficulty is then used on each block for the next 10,080 blocks, as opposed to SMA where difficulty is recalculated after every block based on a previous block window. When T is target solvetime, A is average solvetime, and D is current difficulty, our difficulty algorithm is:

```
D' = D + log(T / A) / log(16)
```

After further research, I've come to the realization that Elixium is currently vulnerable to [multiple timestamp manipulation attacks](https://github.com/zawy12/difficulty-algorithms/issues/30). We're currently using no FTL (future time limit) meaning that miners are able to specify _any_ timestamp they want on a block. The reason this is an issue is because we're comparing epoch timestamps when recalculating difficulty, e.g. last epoch timestamp minus this epoch timestamp. A miner can use this to lower difficulty by mining a block at the end of an epoch with a ridiculously far in the future timestamp. This will go into the difficulty algorithm and make it look like the current epoch took extremely long to complete, so the difficulty will be rebalanced by severely reducing the difficulty to mine blocks.

This can be fixed by enforcing a FTL so that blocks are only valid given if they are mined with a timestamp that fits within the timeframe -- meaning that miners can only lower difficulty by a low percentage if they create timestamps with the max FTL, and they can only do it in alternating epochs since the difficulty would adjust after one epoch.

Another solution to this is to use an algorithm that sums the solvetimes of each block rather than just looking at the entire epoch as a whole.

### Proposed Action
1. Enforce a Future Time Limit (FTL) so that consensus rejects blocks that are 'too far in the future' (we can't enforce exact timestamps because [decentralized time synchronization is really hard](http://webee.technion.ac.il/shimkin/PAPERS/CohenShimkin2010.pdf))
2. Ditch the Simple Lookback Average algorithm and move to a Moving Average algorithm. After looking through performance of these algorithms, it seems that WWHM (suggested by [@hlongvu](https://github.com/hlongvu) [here](https://github.com/ElixiumNetwork/elixium_core/issues/59)) is doing the best in terms of stability vs responsiveness to load changes. Masari implements WWHM and fits exactly with out desired blocktimes, so it would be trivial to implement WWHM into Elixium. 

## References

1. [LWMA (Linearly Weighted Moving Average)](https://github.com/zawy12/difficulty-algorithms/issues/3)
2. [EMA](https://github.com/zawy12/difficulty-algorithms/issues/21)
3. [Revisiting Difficulty Control for Blockchain
Systems](https://eprint.iacr.org/2017/731.pdf)
4. [WWHM Whitepaper](https://getmasari.org/research-papers/wwhm.pdf)
