# EXIP-0001 : Smooth Token Emission

```
Number:  EXIP-0001
Title:   Smooth Token Emission
Type:    Standard
Status:  Accepted
Authors: ElixiumNetwork <team@elixium.app>
Created: 2018-11-06
```

## Abstract

EXIP-0001 proposed a means of smooth token emission for Elixium, moving away from the Bitcoin implementation of infinitely halving block rewards.

## Motivation

Satoshi's method of minting coins through block rewards and halving the reward at given intervals worked well for Bitcoin, but this method causes pre-defined mining breakpoints or 'epochs' where miners may get discouraged from mining when block rewards are halved yet blocks require the same computational energy to mine.

In order to combat this, I propose we use a weighted smooth emission algorithm similar to that of CryptoNote as a means of distributing tokens.

## Body

Our emission algorithm emits a high block reward early on, in order to incentivize early adoption, and scales down over time.

This emission algorithm allows us to specify the total number of tokens we want to exist, as well as a specific block by which we want all tokens to be distributed. The algorithm takes these values into consideration as it smoothly scales the block reward every block.

Where x is total token supply, t is block at full emission, i is block index, and s is the sigma of the total_token_supply, the smooth emission algorithm is as follows:
(x * max{0, t - i}) / s

I've defined the total existing tokens to be 1 billion and have specified an emission period of 2,628,000 blocks (~ 10 years), but this is subject to change as we see fit.

## References

1. [Reference Implementation](https://github.com/ElixiumNetwork/elixium_core/blob/9dec732133da38ffba7b0353c777ef1c008f568f/lib/block.ex#L149)
2. [Mathematical Background (Math Stackexchange)](https://math.stackexchange.com/a/2982412/611622)
3. [CryptoNote Smooth Emission](https://cryptonote.org/inside#smooth-emission)
