## 国际化

Element 组件内部默认使用中文，若希望使用其他语言，则需要进行多语言设置。以英文为例，在 main.js 中：

```javascript
import { i18n } from 'element-react'
import locale from 'element-react/src/locale/lang/en'

i18n.use(locale);
```

如果使用其它语言，默认情况下中文语言包依旧是被引入的，可以使用 webpack 的 NormalModuleReplacementPlugin 替换默认语言包。

**webpack.config.js**
```javascript
{
  plugins: [
    new webpack.NormalModuleReplacementPlugin(/element-react[\/\\]src[\/\\]locale[\/\\]lang[\/\\]zh-CN/, 'element-react/src/locale/lang/en')
  ]
}
```

目前 Element 内置了以下语言：
<ul class="language-list">
  <li>简体中文（zh-CN）</li>
  <li>英语（en）</li>
  <li>德语（de）</li>
  <li>葡萄牙语（pt）</li>
  <li>西班牙语（es）</li>
  <li>丹麦语（da）</li>
  <li>法语（fr）</li>
  <li>挪威语（nb-NO）</li>
  <li>繁体中文（zh-TW）</li>
  <li>意大利语（it）</li>
  <li>韩语（ko）</li>
  <li>日语（ja）</li>
  <li>荷兰语（nl）</li>
  <li>越南语（vi）</li>
  <li>俄语（ru-RU）</li>
  <li>土耳其语（tr-TR）</li>
  <li>巴西葡萄牙语（pt-br）</li>
  <li>波斯语（fa）</li>
  <li>泰语（th）</li>
  <li>印尼语（id）</li>
  <li>保加利亚语（bg）</li>
  <li>波兰语（pl）</li>
  <li>芬兰语（fi）</li>
  <li>瑞典语（sv-SE）</li>
  <li>希腊语（el）</li>
  <li>斯洛伐克语（sk）</li>
</ul>

如果你需要使用其他的语言，欢迎贡献 PR：只需在 [这里](https://github.com/ElemeFE/element/tree/master/src/locale/lang) 添加一个语言配置文件即可。
