# Element React Contributing Guide

We are very graceful that you are interested in contributing to `element-react`. Before submitting your contribution though, please make sure to take a moment and read through the following guidelines.

## Issue Guidelines

- Before submitting an issue, please check if similar problems have already been issued.

- The title of the issue should be written as `[Component Name]: Issue caption.` (e.g. `Button: Fix xxx bug`)

- Please specify which version of `element-react` and `element-theme-default` you are using, and other related information.

## Pull Request Guidelines

- Fork this repository to your own account. Do not create branches here.

- Make sure pull request will be merged into `master`.

- Commit info should be formatted as `[Component Name]: Info about commit.` (e.g. `Button: Fix xxx bug`)

- Make sure that your changes pass `npm test`, `npm run lint` and `npm run build`.

- **Rebase** your commits to make your pull request meaningful.
