/******************************************************************************
The MIT License(MIT)

Embedded Template Library.
https://github.com/ETLCPP/etl
https://www.etlcpp.com

Copyright(c) 2017 John Wellbelove

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files(the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and / or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions :

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
******************************************************************************/

#if 0
#error THIS HEADER IS A GENERATOR. DO NOT INCLUDE.
#endif

//***************************************************************************
// THIS FILE HAS BEEN AUTO GENERATED. DO NOT EDIT THIS FILE.
//***************************************************************************

//***************************************************************************
// To generate to header file, run this at the command line.
// Note: You will need Python and COG installed.
//
// python -m cogapp -d -e -omessage_router.h -DHandlers=<n> message_router_generator.h
// Where <n> is the maximum number of messages to support.
//
// e.g.
// To generate handlers for up to 16 messages...
// python -m cogapp -d -e -omessage_router.h -DHandlers=16 message_router_generator.h
//
// See generate.bat
//***************************************************************************

#ifndef ETL_MESSAGE_ROUTER_INCLUDED
#define ETL_MESSAGE_ROUTER_INCLUDED

#include "platform.h"
#include "message.h"
#include "shared_message.h"
#if ETL_HAS_VIRTUAL_MESSAGES
  #include "message_packet.h"
#endif
#include "message_types.h"
#include "alignment.h"
#include "error_handler.h"
#include "exception.h"
#include "largest.h"
#include "nullptr.h"
#include "placement_new.h"
#include "successor.h"
#include "type_traits.h"

#include <stdint.h>

namespace etl
{
  //***************************************************************************
  /// Base exception class for message router
  //***************************************************************************
  class message_router_exception : public etl::exception
  {
  public:

    message_router_exception(string_type reason_, string_type file_name_, numeric_type line_number_)
      : etl::exception(reason_, file_name_, line_number_)
    {
    }
  };

  //***************************************************************************
  /// Router id is out of the legal range.
  //***************************************************************************
  class message_router_illegal_id : public etl::message_router_exception
  {
  public:

    message_router_illegal_id(string_type file_name_, numeric_type line_number_)
      : message_router_exception(ETL_ERROR_TEXT("message router:illegal id", ETL_MESSAGE_ROUTER_FILE_ID"A"), file_name_, line_number_)
    {
    }
  };

  //***************************************************************************
  /// Forward declare null message router functionality.
  //***************************************************************************
  class imessage_router;

  etl::imessage_router& get_null_message_router();

  //***************************************************************************
  /// This is the base of all message routers.
  //***************************************************************************
  class imessage_router : public etl::successor<imessage_router>
  {
  public:

    virtual ~imessage_router() {}
    virtual void receive(const etl::imessage&) = 0;
    virtual bool accepts(etl::message_id_t) const = 0;
    virtual bool is_null_router() const = 0;
    virtual bool is_producer() const = 0;
    virtual bool is_consumer() const = 0;

    //********************************************
    virtual void receive(etl::message_router_id_t destination_router_id, const etl::imessage& message)
    {
      if ((destination_router_id == get_message_router_id()) || (destination_router_id == imessage_router::ALL_MESSAGE_ROUTERS))
      {
        receive(message);
      }
    }

    //********************************************
    virtual void receive(etl::shared_message shared_msg)
    {
      receive(shared_msg.get_message());
    }

    //********************************************
    virtual void receive(etl::message_router_id_t destination_router_id, etl::shared_message shared_msg)
    {
      if ((destination_router_id == get_message_router_id()) || (destination_router_id == imessage_router::ALL_MESSAGE_ROUTERS))
      {
        receive(shared_msg);
      }
    }

    //********************************************
    bool accepts(const etl::imessage& msg) const
    {
      return accepts(msg.get_message_id());
    }

    //********************************************
    etl::message_router_id_t get_message_router_id() const
    {
      return message_router_id;
    }

    enum
    {
      NULL_MESSAGE_ROUTER = 255,
      MESSAGE_BUS         = 254,
      ALL_MESSAGE_ROUTERS = 253,
      MESSAGE_BROKER      = 252,
      MESSAGE_ROUTER      = 251,
      MAX_MESSAGE_ROUTER  = 249
    };

  protected:

    imessage_router(etl::message_router_id_t id_)
      : message_router_id(id_)
    {
    }

    imessage_router(etl::message_router_id_t id_, imessage_router& successor_)
      : successor(successor_)
      , message_router_id(id_)
    {
    }

  private:

    // Disabled.
    imessage_router(const imessage_router&);
    imessage_router& operator =(const imessage_router&);

    etl::message_router_id_t  message_router_id;
  };

  //***************************************************************************
  /// This router can be used as a sink for messages or a 'null source' router.
  //***************************************************************************
  class null_message_router : public imessage_router
  {
  public:

    //********************************************
    null_message_router()
      : imessage_router(imessage_router::NULL_MESSAGE_ROUTER)
    {
    }

    //********************************************
    null_message_router(etl::imessage_router& successor_)
      : imessage_router(imessage_router::NULL_MESSAGE_ROUTER, successor_)
    {
    }
    
    //********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
    }

    //********************************************
    using etl::imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      if (has_successor())
      {
        return get_successor().accepts(id);
      }
      else
      {
        return false;
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    static null_message_router& instance()
    {
      static null_message_router nmr;
      return nmr;
    }
  };

  //***********************************************
  /// null message router functionality.
  inline etl::imessage_router& get_null_message_router()
  {
    return etl::null_message_router::instance();
  }

  //***************************************************************************
  /// This router can be used as a producer-only of messages, such an interrupt routine.
  //***************************************************************************
  class message_producer : public imessage_router
  {
  public:

    //********************************************
    message_producer()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //********************************************
    message_producer(etl::imessage_router& successor_)
      : imessage_router(imessage_router::NULL_MESSAGE_ROUTER, successor_)
    {
    }

    //********************************************
    message_producer(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //********************************************
    message_producer(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
    }

    //********************************************
    using etl::imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      if (has_successor())
      {
        return get_successor().accepts(id);
      }
      else
      {
        return false;
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return false;
    }
  };

  //***************************************************************************
  /// Is T ultimately derived from etl::imessage_router?
  //***************************************************************************
  template <typename T>
  struct is_message_router : public etl::bool_constant<etl::is_base_of<etl::imessage_router, typename etl::remove_cvref<T>::type>::value>
  {
  };

  //***************************************************************************
  /// Send a message to a router.
  //***************************************************************************
  template <typename TRouter, typename TMessage>
  static
  typename etl::enable_if<etl::is_message_router<TRouter>::value && etl::is_message<TMessage>::value, void>::type
    send_message(TRouter&        destination,
                 const TMessage& message)
  {
    destination.receive(message);
  }

  //***************************************************************************
  /// Send a shared message to a router.
  //***************************************************************************
  template <typename TRouter>
  static
  typename etl::enable_if<etl::is_message_router<TRouter>::value, void>::type
    send_message(TRouter&            destination,
                 etl::shared_message message)
  {
    destination.receive(message);
  }

  //***************************************************************************
  /// Send a message to a router with a particular id.
  //***************************************************************************
  template <typename TRouter, typename TMessage>
  static
  typename etl::enable_if<etl::is_message_router<TRouter>::value && etl::is_message<TMessage>::value, void>::type
    send_message(TRouter&                 destination,
                 etl::message_router_id_t id,
                 const TMessage&          message)
  {
    destination.receive(id, message);
  }

  //***************************************************************************
  /// Send a shared message to a router with a particular id.
  //***************************************************************************
  template <typename TRouter>
  static
  typename etl::enable_if<etl::is_message_router<TRouter>::value, void>::type
    send_message(TRouter&                 destination,
                 etl::message_router_id_t id,
                 etl::shared_message      message)
  {
    destination.receive(id, message);
  }

//*************************************************************************************************
// For C++17 and above.
//*************************************************************************************************
#if ETL_USING_CPP17 && !defined(ETL_MESSAGE_ROUTER_FORCE_CPP03_IMPLEMENTATION)
  //***************************************************************************
  // The definition for all message types.
  //***************************************************************************
  template <typename TDerived, typename... TMessageTypes>
  class message_router : public imessage_router
  {
  public:

#if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<TMessageTypes...> message_packet;
#endif

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const bool was_handled = (receive_message_type<TMessageTypes>(msg) || ...);

      if (!was_handled)
      {
        if (has_successor())
        {
          get_successor().receive(msg);
        }
        else
        {
          static_cast<TDerived*>(this)->on_receive_unknown(msg);
        }
      }
    }

    template <typename TMessage, typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value, int>::type = 0>
    void receive(const TMessage& msg)
    {
      if constexpr (etl::is_one_of<TMessage, TMessageTypes...>::value)
      {
        static_cast<TDerived*>(this)->on_receive(msg);
      }
      else
      {
        if (has_successor())
        {
          get_successor().receive(msg);
        }
        else
        {
          static_cast<TDerived*>(this)->on_receive_unknown(msg);
        }
      }
    }

    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      return (accepts_type<TMessageTypes>(id) || ...);
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }

  private:

    //********************************************
    template <typename TMessage>
    bool receive_message_type(const etl::imessage& msg)
    {
      if (TMessage::ID == msg.get_message_id())
      {
        static_cast<TDerived*>(this)->on_receive(static_cast<const TMessage&>(msg));
        return true;
      }
      else
      {
        return false;
      }
    }

    //********************************************
    template <typename TMessage>
    bool accepts_type(etl::message_id_t id) const
    {
      if (TMessage::ID == id)
      {
        return true;
      }
      else
      {
        if (has_successor())
        {
          return get_successor().accepts(id);
        }
        else
        {
          return false;
        }
      }
    }
  };
#else
//*************************************************************************************************
// For C++14 and below.
//*************************************************************************************************
  //***************************************************************************
  // The definition for all 16 message types.
  //***************************************************************************
  template <typename TDerived,
            typename T1, typename T2 = void, typename T3 = void, typename T4 = void, 
            typename T5 = void, typename T6 = void, typename T7 = void, typename T8 = void, 
            typename T9 = void, typename T10 = void, typename T11 = void, typename T12 = void, 
            typename T13 = void, typename T14 = void, typename T15 = void, typename T16 = void>
  class message_router  : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,  T16> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const etl::message_id_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        case T7::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T7&>(msg)); break;
        case T8::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T8&>(msg)); break;
        case T9::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T9&>(msg)); break;
        case T10::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T10&>(msg)); break;
        case T11::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T11&>(msg)); break;
        case T12::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T12&>(msg)); break;
        case T13::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T13&>(msg)); break;
        case T14::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T14&>(msg)); break;
        case T15::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T15&>(msg)); break;
        case T16::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T16&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }

    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: case T7::ID: case T8::ID: 
        case T9::ID: case T10::ID: case T11::ID: case T12::ID: case T13::ID: case T14::ID: case T15::ID: case T16::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 15 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10, typename T11, typename T12, 
            typename T13, typename T14, typename T15>
  class message_router<TDerived, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,  T15> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        case T7::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T7&>(msg)); break;
        case T8::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T8&>(msg)); break;
        case T9::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T9&>(msg)); break;
        case T10::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T10&>(msg)); break;
        case T11::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T11&>(msg)); break;
        case T12::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T12&>(msg)); break;
        case T13::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T13&>(msg)); break;
        case T14::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T14&>(msg)); break;
        case T15::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T15&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: case T7::ID: case T8::ID: 
        case T9::ID: case T10::ID: case T11::ID: case T12::ID: case T13::ID: case T14::ID: case T15::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 14 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10, typename T11, typename T12, 
            typename T13, typename T14>
  class message_router<TDerived, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,  T14> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        case T7::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T7&>(msg)); break;
        case T8::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T8&>(msg)); break;
        case T9::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T9&>(msg)); break;
        case T10::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T10&>(msg)); break;
        case T11::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T11&>(msg)); break;
        case T12::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T12&>(msg)); break;
        case T13::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T13&>(msg)); break;
        case T14::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T14&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: case T7::ID: case T8::ID: 
        case T9::ID: case T10::ID: case T11::ID: case T12::ID: case T13::ID: case T14::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 13 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10, typename T11, typename T12, 
            typename T13>
  class message_router<TDerived, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,  T13> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        case T7::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T7&>(msg)); break;
        case T8::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T8&>(msg)); break;
        case T9::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T9&>(msg)); break;
        case T10::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T10&>(msg)); break;
        case T11::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T11&>(msg)); break;
        case T12::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T12&>(msg)); break;
        case T13::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T13&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: case T7::ID: case T8::ID: 
        case T9::ID: case T10::ID: case T11::ID: case T12::ID: case T13::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 12 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10, typename T11, typename T12>
  class message_router<TDerived, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11,  T12> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        case T7::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T7&>(msg)); break;
        case T8::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T8&>(msg)); break;
        case T9::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T9&>(msg)); break;
        case T10::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T10&>(msg)); break;
        case T11::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T11&>(msg)); break;
        case T12::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T12&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: case T7::ID: case T8::ID: 
        case T9::ID: case T10::ID: case T11::ID: case T12::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 11 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10, typename T11>
  class message_router<TDerived, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10,  T11> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        case T7::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T7&>(msg)); break;
        case T8::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T8&>(msg)); break;
        case T9::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T9&>(msg)); break;
        case T10::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T10&>(msg)); break;
        case T11::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T11&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: case T7::ID: case T8::ID: 
        case T9::ID: case T10::ID: case T11::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 10 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10>
  class message_router<TDerived, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, void, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9,  T10> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        case T7::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T7&>(msg)); break;
        case T8::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T8&>(msg)); break;
        case T9::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T9&>(msg)); break;
        case T10::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T10&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: case T7::ID: case T8::ID: 
        case T9::ID: case T10::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 9 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9>
  class message_router<TDerived, T1, T2, T3, T4, T5, T6, T7, T8, T9, void, void, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8,  T9> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        case T7::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T7&>(msg)); break;
        case T8::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T8&>(msg)); break;
        case T9::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T9&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8, T9>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: case T7::ID: case T8::ID: 
        case T9::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 8 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8>
  class message_router<TDerived, T1, T2, T3, T4, T5, T6, T7, T8, void, void, void, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5, T6, T7,  T8> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        case T7::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T7&>(msg)); break;
        case T8::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T8&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7, T8>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: case T7::ID: case T8::ID: 
        
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 7 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7>
  class message_router<TDerived, T1, T2, T3, T4, T5, T6, T7, void, void, void, void, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5, T6,  T7> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        case T7::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T7&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6, T7>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: case T7::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 6 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6>
  class message_router<TDerived, T1, T2, T3, T4, T5, T6, void, void, void, void, void, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4, T5,  T6> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        case T6::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T6&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5, T6>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: case T6::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 5 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4, 
            typename T5>
  class message_router<TDerived, T1, T2, T3, T4, T5, void, void, void, void, void, void, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3, T4,  T5> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        case T5::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T5&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4, T5>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4, T5>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: case T5::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 4 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3, typename T4>
  class message_router<TDerived, T1, T2, T3, T4, void, void, void, void, void, void, void, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2, T3,  T4> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        case T4::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T4&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3, T4>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3, T4>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: case T4::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 3 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2, typename T3>
  class message_router<TDerived, T1, T2, T3, void, void, void, void, void, void, void, void, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1, T2,  T3> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        case T3::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T3&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2, T3>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2, T3>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: case T3::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 2 message types.
  //***************************************************************************
  template <typename TDerived, 
            typename T1, typename T2>
  class message_router<TDerived, T1, T2, void, void, void, void, void, void, void, void, void, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet<T1,  T2> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        case T2::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T2&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1, T2>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1, T2>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: case T2::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };

  //***************************************************************************
  // Specialisation for 1 message type.
  //***************************************************************************
  template <typename TDerived, 
            typename T1>
  class message_router<TDerived, T1, void, void, void, void, void, void, void, void, void, void, void, void, void, void, void>
   : public imessage_router
  {
  public:

  #if ETL_HAS_VIRTUAL_MESSAGES
    typedef etl::message_packet< T1> message_packet;
  #endif

    //**********************************************
    message_router(etl::message_router_id_t id_)
      : imessage_router(id_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router(etl::message_router_id_t id_, etl::imessage_router& successor_)
      : imessage_router(id_, successor_)
    {
      ETL_ASSERT(id_ <= etl::imessage_router::MAX_MESSAGE_ROUTER, ETL_ERROR(etl::message_router_illegal_id));
    }

    //**********************************************
    message_router()
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER)
    {
    }

    //**********************************************
    message_router(etl::imessage_router& successor_)
      : imessage_router(etl::imessage_router::MESSAGE_ROUTER, successor_)
    {
    }

    //**********************************************
    using etl::imessage_router::receive;

    void receive(const etl::imessage& msg) ETL_OVERRIDE
    {
      const size_t id = msg.get_message_id();

      switch (id)
      {
        case T1::ID: static_cast<TDerived*>(this)->on_receive(static_cast<const T1&>(msg)); break;
        default:
        {
           if (has_successor())
           {
             get_successor().receive(msg);
           }
           else
           {
             static_cast<TDerived*>(this)->on_receive_unknown(msg);
           }
           break;
        }
      }
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && etl::is_one_of<TMessage, T1>::value, void>::type
      receive(const TMessage& msg)
    {
      static_cast<TDerived*>(this)->on_receive(msg);
    }

    template <typename TMessage>
    typename etl::enable_if<etl::is_base_of<imessage, TMessage>::value && !etl::is_one_of<TMessage, T1>::value, void>::type
      receive(const TMessage& msg)
    {
      if (has_successor())
      {
        get_successor().receive(msg);
      }
      else
      {
        static_cast<TDerived*>(this)->on_receive_unknown(msg);
      }
    }


    //**********************************************
    using imessage_router::accepts;

    bool accepts(etl::message_id_t id) const ETL_OVERRIDE
    {
      switch (id)
      {
        case T1::ID: 
          return true;
        default:
        {
          if (has_successor())
          {
            return get_successor().accepts(id);
          }
          else
          {
            return false;
          }
        }
      }
    }

    //********************************************
    ETL_DEPRECATED bool is_null_router() const ETL_OVERRIDE
    {
      return false;
    }

    //********************************************
    bool is_producer() const ETL_OVERRIDE
    {
      return true;
    }

    //********************************************
    bool is_consumer() const ETL_OVERRIDE
    {
      return true;
    }
  };
#endif
}

#endif
