<?php

use App\Http\Controllers\UserController;
use App\Http\Controllers\RestaurantController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\OfferController;
use App\Http\Controllers\FavoriteController;
use Illuminate\Support\Facades\Route;

// USER ROUTES:        
Route::resource('users', UserController::class);
Route::get('users/search/{name}', [UserController::class, 'findByName']);

// CATEGORIES ROUTES:
Route::resource('categories', CategoryController::class);
Route::get('categories/search/{name}', [CategoryController::class, 'findByName']);

// RESTAURANT ROUTES:
Route::resource('restaurants', RestaurantController::class);
Route::get('restaurants/search/{name}', [RestaurantController::class, 'findByName']);

// REVIEW ROUTES:
Route::resource('reviews', ReviewController::class);

// OFFER ROUTES:        
Route::resource('offers', OfferController::class);
Route::get('offers/search/{name}', [OfferController::class, 'findByName']);

// FAVORITE ROUTES:
Route::apiResource('favorites', FavoriteController::class);


/* Automatic HTTP GET request route generated by Laravel Sancturn that manage the authentication of the users.

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum'); */