<?php
/* This file is part of DBSR.
 *
 * DBSR is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DBSR is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DBSR.  If not, see <http://www.gnu.org/licenses/>.
 */
class DBSR{const VERSION='2.2.0';const OPTION_CASE_INSENSITIVE=0;const OPTION_EXTENSIVE_SEARCH=1;const OPTION_SEARCH_PAGE_SIZE=2;const OPTION_VAR_MATCH_STRICT=3;const OPTION_FLOATS_PRECISION=4;const OPTION_CONVERT_CHARSETS=5;const OPTION_VAR_CAST_REPLACE=6;const OPTION_DB_WRITE_CHANGES=7;const OPTION_HANDLE_SERIALIZE=8;const OPTION_REVERSED_FILTERS=9;const OPTION_LOCK_TABLES=10;public static function createClass($className){if(!class_exists($className,false)){$classArray=explode('\\',$className);if(count($classArray)>1){$className=array_pop($classArray);$namespace=implode('\\',$classArray);eval('namespace '.$namespace.' { class '.$className.' {} }');}else{eval('class '.$className.' {}');}}}public static function getPHPType($mysql_type){$types=array('/^\s*BOOL(EAN)?\s*$/i'=>'boolean','/^\s*TINYINT\s*(?:\(\s*\d+\s*\)\s*)?$/i'=>'integer','/^\s*SMALLINT\s*(?:\(\s*\d+\s*\)\s*)?$/i'=>'integer','/^\s*MEDIUMINT\s*(?:\(\s*\d+\s*\)\s*)?$/i'=>'integer','/^\s*INT(EGER)?\s*(?:\(\s*\d+\s*\)\s*)?$/i'=>'integer','/^\s*BIGINT\s*(?:\(\s*\d+\s*\)\s*)?$/i'=>'integer','/^\s*FLOAT\s*(?:\(\s*\d+\s*(?:,\s*\d+\s*)?\)\s*)?$/i'=>'float','/^\s*DOUBLE(\s+PRECISION)?\s*(?:\(\s*\d+\s*(?:,\s*\d+\s*)?\)\s*)?$/i'=>'float','/^\s*REAL\s*(?:\(\s*\d+\s*(?:,\s*\d+\s*)?\)\s*)?$/i'=>'float','/^\s*DEC(IMAL)?\s*(?:\(\s*\d+\s*(?:,\s*\d+\s*)?\)\s*)?$/i'=>'float','/^\s*NUMERIC\s*(?:\(\s*\d+\s*(?:,\s*\d+\s*)?\)\s*)?$/i'=>'float','/^\s*FIXED\s*(?:\(\s*\d+\s*(?:,\s*\d+\s*)?\)\s*)?$/i'=>'float',);foreach($types as $regex=>$type){if(preg_match($regex,$mysql_type)){return $type;}}return 'string';}protected $pdo;private $_pdo_charset;private $_pdo_collation;private $_dbr_callback;protected $options=array(self::OPTION_CASE_INSENSITIVE=>false,self::OPTION_EXTENSIVE_SEARCH=>false,self::OPTION_SEARCH_PAGE_SIZE=>10000,self::OPTION_VAR_MATCH_STRICT=>true,self::OPTION_FLOATS_PRECISION=>5,self::OPTION_CONVERT_CHARSETS=>true,self::OPTION_VAR_CAST_REPLACE=>true,self::OPTION_DB_WRITE_CHANGES=>true,self::OPTION_HANDLE_SERIALIZE=>true,self::OPTION_REVERSED_FILTERS=>false,self::OPTION_LOCK_TABLES=>true,);protected $filters=array();protected $search=array();protected $replace=array();protected $search_converted=array();public function __construct(PDO$pdo){if(!extension_loaded('pcre')){throw new RuntimeException('The pcre (Perl-compatible regular expressions) extension is required for DBSR to work!');}if($pdo->getAttribute(PDO::ATTR_DRIVER_NAME)!='mysql'){throw new InvalidArgumentException('The given PDO instance is not representing an MySQL database!');}$this->pdo=$pdo;}public function getOption($option){return isset($this->options[$option])?$this->options[$option]:null;}public function setOption($option,$value){if(!isset($this->options[$option])){return false;}switch($option){case static ::OPTION_SEARCH_PAGE_SIZE:if(is_int($value)&&$value>0){$this->options[$option]=$value;return true;}else{return false;}case static ::OPTION_FLOATS_PRECISION:if(is_int($value)&&$value>=0){$this->options[$option]=$value;return true;}else{return false;}default:if(gettype($this->options[$option])==gettype($value)){$this->options[$option]=$value;return true;}else{return false;}}}public function setFilters(array$filters){$filters_parsed=array();foreach($filters as $key=>$value){if(is_int($key)){if(is_string($value)){$filters_parsed[$value]=true;}elseif(is_array($value)){if(!count($value)){continue;}foreach($value as $v){if(!is_string($v)){throw new InvalidArgumentException('Only strings qualify as column names!');}}if(isset($filters_parsed['.'])){$filters_parsed['.']=array_values(array_unique(array_merge($filters_parsed['.'],array_values($value))));}else{$filters_parsed['.']=array_values(array_unique($value));}}else{throw new InvalidArgumentException('The filter array can only contain strings or arrays!');}}else{if(is_string($value)){if(isset($filters_parsed[$key])){$filters_parsed[$key]=array_values(array_unique(array_merge($filters_parsed[$key],array($value))));}else{$filters_parsed[$key]=array($value);}}elseif(is_array($value)){if(!count($value)){continue;}foreach($value as $v){if(!is_string($v)){throw new InvalidArgumentException('Only strings qualify as column names!');}}if(isset($filters_parsed[$key])){$filters_parsed[$key]=array_values(array_unique(array_merge($filters_parsed[$key],array_values($value))));}else{$filters_parsed[$key]=array_values(array_unique($value));}}else{throw new InvalidArgumentException('The filter array can only contain strings or arrays!');}}}$this->filters=$filters_parsed;}public function resetFilters(){$this->filters=array();}public function isFiltered($table,$column=null){if($this->getOption(static ::OPTION_REVERSED_FILTERS)){if($column==null){return false;}else{return!(isset($this->filters[$table])&&$this->filters[$table]===true||isset($this->filters[$table])&&in_array($column,$this->filters[$table],true)||isset($this->filters['.'])&&in_array($column,$this->filters['.'],true));}}else{if($column==null){return isset($this->filters[$table])&&$this->filters[$table]===true;}else{return isset($this->filters[$table])&&$this->filters[$table]===true||isset($this->filters[$table])&&in_array($column,$this->filters[$table],true)||isset($this->filters['.'])&&in_array($column,$this->filters['.'],true);}}}public function setValues(array$search,array$replace){if(count($search)==0||count($replace)==0||count($search)!=count($replace)){throw new InvalidArgumentException('The number of search- and replace-values is invalid!');}$search=array_values($search);$replace=array_values($replace);for($i=0;$i<count($search);$i++){if($search[$i]===$replace[$i]){array_splice($search,$i,1);array_splice($replace,$i,1);$i--;}}if(count($search)==0){throw new InvalidArgumentException('All given search- and replace-values are identical!');}$this->search=$search;$this->replace=$replace;}public function exec(){if(!ini_get('safe_mode')&&ini_get('max_execution_time')!='0'){set_time_limit(0);}return $this->DBRunner(array($this,'searchReplace'));}protected function DBRunner($callback){$this->_dbr_callback=$callback;$result=0;$unserialize_callback_func=ini_set('unserialize_callback_func',__CLASS__.'::createClass');$pdo_attributes=array(PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION);foreach($pdo_attributes as $attribute=>$value){$pdo_attributes[$attribute]=$this->pdo->getAttribute($attribute);$this->pdo->setAttribute($attribute,$value);}try{$this->_pdo_charset=$this->pdo->query('SELECT @@character_set_client;',PDO::FETCH_COLUMN,0)->fetch();$this->_pdo_collation=$this->pdo->query('SELECT @@collation_connection;',PDO::FETCH_COLUMN,0)->fetch();$tables=$this->pdo->query('SHOW TABLES;',PDO::FETCH_COLUMN,0)->fetchAll();if(count($tables)==0){throw new Exception('Database does not contain any tables.');}if($this->getOption(static ::OPTION_LOCK_TABLES)){$this->pdo->query('LOCK TABLES `'.implode('` WRITE, `',$tables).'` WRITE;');}foreach($tables as $table){if(!$this->isFiltered($table)){$result+=$this->_DBRTable($table,$callback);}}}catch(Exception$e){}if($this->getOption(static ::OPTION_LOCK_TABLES)){$this->pdo->query('UNLOCK TABLES');}foreach($pdo_attributes as $attribute=>$value){$this->pdo->setAttribute($attribute,$value);}ini_set('unserialize_callback_func',$unserialize_callback_func);if(isset($e)&&$e instanceof Exception){throw $e;}else{return $result;}}private function _DBRTable($table){$columns_info=$this->pdo->query('SHOW FULL COLUMNS FROM `'.$table.'`;',PDO::FETCH_NAMED);$columns=array();$keys=array();foreach($columns_info as $column_info){$columns[$column_info['Field']]=array('null'=>($column_info['Null']=='YES'),'type'=> static ::getPHPType($column_info['Type']),'charset'=>preg_replace('/^([a-z\d]+)_[\w\d]+$/i','$1',$column_info['Collation']),'collation'=>$column_info['Collation'],);$keys[$column_info['Key']][$column_info['Field']]=$columns[$column_info['Field']];}if(isset($keys['PRI'])){$keys=$keys['PRI'];}elseif(isset($keys['UNI'])){$keys=$keys['UNI'];}else{$keys=$columns;}foreach($columns as $column=>$column_info){if($this->isFiltered($table,$column)){unset($columns[$column]);}}if(!$this->getOption(static ::OPTION_EXTENSIVE_SEARCH)){$where=$this->_DBRWhereSearch($columns);}else{$where='';}if(count($columns)==0){return;}if($this->getOption(static ::OPTION_CONVERT_CHARSETS)){foreach($columns as $column=>$column_info){if(!isset($this->search_converted[$column_info['charset']])&&$column_info['type']=='string'&&!empty($column_info['charset'])&&$column_info['charset']!=$this->_pdo_charset){foreach($this->search as $i=>$item){if(is_string($item)){$this->search_converted[$column_info['charset']][$i]=$this->pdo->query('SELECT CONVERT(_'.$this->_pdo_charset.$this->pdo->quote($item).' USING '.$column_info['charset'].');',PDO::FETCH_COLUMN,0)->fetch();}else{$this->search_converted[$column_info['charset']][$i]=$item;}}}}}$row_count=(int)$this->pdo->query('SELECT COUNT(*) FROM `'.$table.'`'.$where.';',PDO::FETCH_COLUMN,0)->fetch();$row_change_count=0;$page_size=$this->getOption(static ::OPTION_SEARCH_PAGE_SIZE);for($page_start=0;$page_start<$row_count;$page_start+=$page_size){$rows=$this->pdo->query('SELECT * FROM `'.$table.'`'.$where.'LIMIT '.$page_start.', '.$page_size.';',PDO::FETCH_ASSOC);foreach($rows as $row){if($this->_DBRRow($table,$columns,$keys,$row)>0){$row_change_count++;}}}return $row_change_count;}private function _DBRRow($table,array$columns,array$keys,array$row){$changeset=array();foreach($columns+$keys as $column=>$column_info){if(!settype($row[$column],$column_info['type'])){throw new UnexpectedValueException('Failed to convert `'.$table.'`.`'.$column.'` value to a '.$column_info['type'].' for value "'.$row[$column].'"!');}}foreach($columns as $column=>$column_info){$value=&$row[$column];if($this->getOption(static ::OPTION_CONVERT_CHARSETS)&&isset($this->search_converted[$column_info['charset']])){$value_new=call_user_func($this->_dbr_callback,$value,$this->search_converted[$column_info['charset']],$this->replace);}else{$value_new=call_user_func($this->_dbr_callback,$value);}if($value_new!==$value){$changeset[$column]=$value_new;}}if(count($changeset)>0&&$this->getOption(static ::OPTION_DB_WRITE_CHANGES)){$where=$this->_DBRWhereRow($keys,$row);$updates=array();foreach($changeset as $column=>$value_new){switch($columns[$column]['type']){case 'integer':$updates[]='`'.$column.'` = '.(int)$value_new;break;case 'float':$updates[]='`'.$column.'` = '.(string)round((float)$value_new,$this->getOption(static ::OPTION_FLOATS_PRECISION));break;case 'string':default:$update_string=$this->pdo->quote((string)$value_new);if(!empty($columns[$column]['charset'])&&$this->_pdo_charset!=$columns[$column]['charset']){if($this->getOption(static ::OPTION_CONVERT_CHARSETS)){$update_string='CONVERT(_'.$this->_pdo_charset.$update_string.' USING '.$columns[$column]['charset'].')';}else{$update_string='BINARY '.$update_string;}}if(!empty($columns[$column]['collation'])&&$this->getOption(static ::OPTION_CONVERT_CHARSETS)&&$this->_pdo_collation!=$columns[$column]['collation']){$update_string.=' COLLATE '.$columns[$column]['collation'];}$updates[]='`'.$column.'` = '.$update_string;break;}}$this->pdo->query('UPDATE `'.$table.'` SET '.implode(', ',$updates).$where.';');}return count($changeset);}private function _DBRWhereSearch(array&$columns){$where=array();foreach($columns as $column=>$column_info){$where_column=false;foreach($this->search as $item){if($where_component=$this->_DBRWhereColumn($column,$column_info,$item,false)){$where[]=$where_component;$where_column=true;}}if(!$where_column){unset($columns[$column]);}}if(count($where)>0){return ' WHERE '.implode(' OR ',$where).' ';}else{if(count($columns)!=0){throw new LogicException('No WHERE-clause was constructed, yet there are valid columns left!');}return false;}}private function _DBRWhereRow(array$keys,array$row){$where=array();foreach($keys as $key=>$key_info){$where[]=$this->_DBRWhereColumn($key,$key_info,$row[$key],true);}return ' WHERE '.implode(' AND ',$where).' ';}private function _DBRWhereColumn($column,array$column_info,$value,$string_exact){switch($column_info['type']){case 'integer':if(!$this->getOption(static ::OPTION_VAR_MATCH_STRICT)||is_int($value)){return '`'.$column.'` = '.(int)$value;}break;case 'float':if(!$this->getOption(static ::OPTION_VAR_MATCH_STRICT)||is_float($value)){return 'ABS(`'.$column.'` - '.(float)$value.') < POW(1, -'.$this->getOption(static ::OPTION_FLOATS_PRECISION).')';}break;case 'string':default:if(is_float($value)){$value=round($value,$this->getOption(static ::OPTION_FLOATS_PRECISION));}if(!$string_exact){$value='%'.(string)$value.'%';}$where_string=$this->pdo->quote((string)$value);if(!empty($column_info['charset'])&&$this->_pdo_charset!=$column_info['charset']){if($this->getOption(static ::OPTION_CONVERT_CHARSETS)){$where_string='CONVERT(_'.$this->_pdo_charset.$where_string.' USING '.$column_info['charset'].')';}else{$where_string='BINARY '.$where_string;}}if(!empty($column_info['collation'])&&$this->getOption(static ::OPTION_CONVERT_CHARSETS)&&$this->_pdo_collation!=$column_info['collation']){if($this->getOption(static ::OPTION_CASE_INSENSITIVE)){$where_string.=' COLLATE '.preg_replace('/_cs$/i','_ci',$column_info['collation']);}else{$where_string.=' COLLATE '.$column_info['collation'];}}$column='`'.$column.'`';if(!empty($column_info['collation'])&&$this->getOption(static ::OPTION_CASE_INSENSITIVE)&&preg_replace('/^.*_([a-z]+)$/i','$1',$column_info['collation'])=='cs'){$column.=' COLLATE '.preg_replace('/_cs$/i','_ci',$column_info['collation']);}$where_string=$column.' '.($string_exact?'=':'LIKE').' '.$where_string;if(!empty($column_info['charset'])&&!$this->getOption(static ::OPTION_CONVERT_CHARSETS)&&$this->_pdo_charset!=$column_info['charset']){$where_string='BINARY '.$where_string;}return $where_string;}return false;}protected function searchReplace($value){$new_value=$value;switch(true){case is_array($value):$new_value=array();foreach($value as $key=>$element){$new_value[$this->searchReplace($key)]=$this->searchReplace($element);}break;case is_bool($value):for($i=0;$i<count($this->search);$i++){if($new_value===$this->search[$i]||!$this->getOption(static ::OPTION_VAR_MATCH_STRICT)&&$new_value==$this->search[$i]){$new_value=$this->replace[$i];}}break;case is_float($value):$float_precision=pow(10,-1*$this->getOption(static ::OPTION_FLOATS_PRECISION));for($i=0;$i<count($this->search);$i++){if(is_float($this->search[$i])&&abs($new_value-$this->search[$i])<$float_precision||!$this->getOption(static ::OPTION_VAR_MATCH_STRICT)&&($new_value==$this->search[$i]||abs($new_value-(float)$this->search[$i])<$float_precision)){$new_value=$this->replace[$i];}}break;case is_int($value):for($i=0;$i<count($this->search);$i++){if($new_value===$this->search[$i]||!$this->getOption(static ::OPTION_VAR_MATCH_STRICT)&&$new_value==$this->search[$i]){$new_value=$this->replace[$i];}}break;case is_object($value):$new_value=unserialize($this->searchReplace(preg_replace('/^O:\\d+:/','O:0:',serialize($new_value))));break;case is_string($value):$serialized_regex='/^(?:a:\\d+:\\{.*\\}|b:[01];|d:\\d+\\.\\d+;|i:\\d+;|N;|O:\\d+:"[a-zA-Z_\\x7F-\\xFF][a-zA-Z0-9_\\x7F-\\xFF]*(?:\\\\[a-zA-Z_\\x7F-\\xFF][a-zA-Z0-9_\\x7F-\\xFF]*)*":\\d+:\\{.*\\}|s:\\d+:".*";)$/Ss';$unserialized=@unserialize($new_value);if($this->getOption(static ::OPTION_HANDLE_SERIALIZE)&&($unserialized!==false||$new_value===serialize(false))&&!is_object($unserialized)){$new_value=serialize($this->searchReplace($unserialized));}elseif($this->getOption(static ::OPTION_HANDLE_SERIALIZE)&&(is_object($unserialized)||preg_match($serialized_regex,$new_value))){if($changed_value=preg_replace_callback('/b:([01]);/S',array($this,'_searchReplace_preg_callback_boolean'),$new_value)){$new_value=$changed_value;}if($changed_value=preg_replace_callback('/i:(\\d+);/S',array($this,'_searchReplace_preg_callback_integer'),$new_value)){$new_value=$changed_value;}if($changed_value=preg_replace_callback('/d:(\\d+)\.(\\d+);/S',array($this,'_searchReplace_preg_callback_float'),$new_value)){$new_value=$changed_value;}if($changed_value=preg_replace_callback('/O:\\d+:"([a-zA-Z_\\x7F-\\xFF][a-zA-Z0-9_\\x7F-\\xFF]*(?:\\\\[a-zA-Z_\\x7F-\\xFF][a-zA-Z0-9_\\x7F-\\xFF]*)*)":(\\d+):{(.*)}/Ss',array($this,'_searchReplace_preg_callback_objectname'),$new_value)){$new_value=$changed_value;}if($changed_value=preg_replace_callback('/s:\\d+:"(.*?|a:\\d+:{.*}|b:[01];|d:\\d+\\.\\d+;|i:\d+;|N;|O:\\d+:"[a-zA-Z_\\x7F-\\xFF][a-zA-Z0-9_\\x7F-\\xFF]*":\\d+:{.*}|s:\\d+:".*";)";/Ss',array($this,'_searchReplace_preg_callback_string'),$new_value)){$new_value=$changed_value;}if($new_value==$value){for($i=0;$i<count($this->search);$i++){if(is_string($this->search[$i])||!$this->getOption(static ::OPTION_VAR_MATCH_STRICT)){$new_value=$this->getOption(static ::OPTION_CASE_INSENSITIVE)?str_ireplace((string)$this->search[$i],(string)$this->replace[$i],$new_value):str_replace((string)$this->search[$i],(string)$this->replace[$i],$new_value);}}}}else{for($i=0;$i<count($this->search);$i++){if(is_string($this->search[$i])||!$this->getOption(static ::OPTION_VAR_MATCH_STRICT)){$new_value=$this->getOption(static ::OPTION_CASE_INSENSITIVE)?str_ireplace((string)$this->search[$i],(string)$this->replace[$i],$new_value):str_replace((string)$this->search[$i],(string)$this->replace[$i],$new_value);}}}break;}return $new_value;}private function _searchReplace_preg_callback_boolean($matches){$result=$this->searchReplace((boolean)$matches[1]);if(static ::OPTION_VAR_CAST_REPLACE){$result=(boolean)$result;}return serialize($result);}private function _searchReplace_preg_callback_integer($matches){$result=$this->searchReplace((integer)$matches[1]);if(static ::OPTION_VAR_CAST_REPLACE){$result=(integer)$result;}return serialize($result);}private function _searchReplace_preg_callback_float($matches){$result=$this->searchReplace((float)($matches[1].'.'.$matches[2]));if(static ::OPTION_VAR_CAST_REPLACE){$result=(float)$result;}return serialize($result);}private function _searchReplace_preg_callback_objectname($matches){$name=preg_replace('/[^a-zA-Z0-9_\\x7F-\\xFF\\\\]+/','',(string)$this->searchReplace($matches[1]));return 'O:'.strlen($name).':"'.$name.'":'.$matches[2].':{'.$matches[3].'}';}private function _searchReplace_preg_callback_string($matches){$result=$this->searchReplace($matches[1]);if(static ::OPTION_VAR_CAST_REPLACE){$result=(string)$result;}return serialize($result);}}class DBSR_GUI_Resources{public static $css_stylecss='normal:@font-face{font-family:\'Source Sans Pro\'; font-style:normal; font-weight:normal; src:local(\'SourceSansPro-Regular\'),url(?resource=webfonts/SourceSansPro-Regular.woff) format(\'woff\')}@font-face{font-family:\'Source Sans Pro\'; font-style:normal; font-weight:bold; src:local(\'SourceSansPro-Bold\'),url(?resource=webfonts/SourceSansPro-Bold.woff) format(\'woff\')}@font-face{font-family:\'Source Code Pro\'; font-style:normal; font-weight:normal; src:local(\'SourceCodePro-Regular\'),url(?resource=webfonts/SourceCodePro-Regular.woff) format(\'woff\')}@font-face{font-family:\'Source Code Pro\'; font-style:normal; font-weight:bold; src:local(\'SourceCodePro-Bold\'),url(?resource=webfonts/SourceCodePro-Bold.woff) format(\'woff\')}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0; padding:0; border:0; font-size:100%; font:inherit; vertical-align:baseline}article,aside,details,figcaption,figure,footer,header,hgroup,menu,nav,section{display:block}body{line-height:1}ol,ul{list-style:none}blockquote,q{quotes:none}blockquote:before,blockquote:after,q:before,q:after{content:\'\'; content:none}table{border-collapse:collapse; border-spacing:0}.ui-helper-hidden{display:none}.ui-helper-hidden-accessible{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.ui-helper-reset{margin:0;padding:0;border:0;outline:0;line-height:1.3;text-decoration:none;font-size:100%;list-style:none}.ui-helper-clearfix:before,.ui-helper-clearfix:after{content:"";display:table;border-collapse:collapse}.ui-helper-clearfix:after{clear:both}.ui-helper-zfix{width:100%;height:100%;top:0;left:0;position:absolute;opacity:0;filter:Alpha(Opacity=0)}.ui-front{z-index:100}.ui-state-disabled{cursor:default!important;pointer-events:none}.ui-icon{display:inline-block;vertical-align:middle;margin-top:-.25em;position:relative;text-indent:-99999px;overflow:hidden;background-repeat:no-repeat}.ui-widget-icon-block{left:50%;margin-left:-8px;display:block}.ui-widget-overlay{position:fixed;top:0;left:0;width:100%;height:100%}.ui-autocomplete{position:absolute;top:0;left:0;cursor:default}.ui-menu{list-style:none;padding:0;margin:0;display:block;outline:0}.ui-menu .ui-menu{position:absolute}.ui-menu .ui-menu-item{margin:0;cursor:pointer;list-style-image:url("data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7")}.ui-menu .ui-menu-item-wrapper{position:relative;padding:3px 1em 3px .4em}.ui-menu .ui-menu-divider{margin:5px 0;height:0;font-size:0;line-height:0;border-width:1px 0 0 0}.ui-menu .ui-state-focus,.ui-menu .ui-state-active{margin:-1px}.ui-menu-icons{position:relative}.ui-menu-icons .ui-menu-item-wrapper{padding-left:2em}.ui-menu .ui-icon{position:absolute;top:0;bottom:0;left:.2em;margin:auto 0}.ui-menu .ui-menu-icon{left:auto;right:0}.ui-widget{font-family:Arial,Helvetica,sans-serif;font-size:1em}.ui-widget .ui-widget{font-size:1em}.ui-widget input,.ui-widget select,.ui-widget textarea,.ui-widget button{font-family:Arial,Helvetica,sans-serif;font-size:1em}.ui-widget.ui-widget-content{border:1px solid #c5c5c5}.ui-widget-content{border:1px solid #ddd;background:#fff;color:#333}.ui-widget-content a{color:#333}.ui-widget-header{border:1px solid #ddd;background:#e9e9e9;color:#333;font-weight:bold}.ui-widget-header a{color:#333}.ui-state-default,.ui-widget-content .ui-state-default,.ui-widget-header .ui-state-default,.ui-button,html .ui-button.ui-state-disabled:hover,html .ui-button.ui-state-disabled:active{border:1px solid #c5c5c5;background:#f6f6f6;font-weight:normal;color:#454545}.ui-state-default a,.ui-state-default a:link,.ui-state-default a:visited,a.ui-button,a:link.ui-button,a:visited.ui-button,.ui-button{color:#454545;text-decoration:none}.ui-state-hover,.ui-widget-content .ui-state-hover,.ui-widget-header .ui-state-hover,.ui-state-focus,.ui-widget-content .ui-state-focus,.ui-widget-header .ui-state-focus,.ui-button:hover,.ui-button:focus{border:1px solid #ccc;background:#ededed;font-weight:normal;color:#2b2b2b}.ui-state-hover a,.ui-state-hover a:hover,.ui-state-hover a:link,.ui-state-hover a:visited,.ui-state-focus a,.ui-state-focus a:hover,.ui-state-focus a:link,.ui-state-focus a:visited,a.ui-button:hover,a.ui-button:focus{color:#2b2b2b;text-decoration:none}.ui-visual-focus{box-shadow:0 0 3px 1px rgb(94,158,214)}.ui-state-active,.ui-widget-content .ui-state-active,.ui-widget-header .ui-state-active,a.ui-button:active,.ui-button:active,.ui-button.ui-state-active:hover{border:1px solid #003eff;background:#007fff;font-weight:normal;color:#fff}.ui-icon-background,.ui-state-active .ui-icon-background{border:#003eff;background-color:#fff}.ui-state-active a,.ui-state-active a:link,.ui-state-active a:visited{color:#fff;text-decoration:none}.ui-state-highlight,.ui-widget-content .ui-state-highlight,.ui-widget-header .ui-state-highlight{border:1px solid #dad55e;background:#fffa90;color:#777620}.ui-state-checked{border:1px solid #dad55e;background:#fffa90}.ui-state-highlight a,.ui-widget-content .ui-state-highlight a,.ui-widget-header .ui-state-highlight a{color:#777620}.ui-state-error,.ui-widget-content .ui-state-error,.ui-widget-header .ui-state-error{border:1px solid #f1a899;background:#fddfdf;color:#5f3f3f}.ui-state-error a,.ui-widget-content .ui-state-error a,.ui-widget-header .ui-state-error a{color:#5f3f3f}.ui-state-error-text,.ui-widget-content .ui-state-error-text,.ui-widget-header .ui-state-error-text{color:#5f3f3f}.ui-priority-primary,.ui-widget-content .ui-priority-primary,.ui-widget-header .ui-priority-primary{font-weight:bold}.ui-priority-secondary,.ui-widget-content .ui-priority-secondary,.ui-widget-header .ui-priority-secondary{opacity:.7;filter:Alpha(Opacity=70);font-weight:normal}.ui-state-disabled,.ui-widget-content .ui-state-disabled,.ui-widget-header .ui-state-disabled{opacity:.35;filter:Alpha(Opacity=35);background-image:none}.ui-state-disabled .ui-icon{filter:Alpha(Opacity=35)}.ui-icon{width:16px;height:16px}.ui-icon,.ui-widget-content .ui-icon{background-image:none}.ui-widget-header .ui-icon{background-image:none}.ui-state-hover .ui-icon,.ui-state-focus .ui-icon,.ui-button:hover .ui-icon,.ui-button:focus .ui-icon{background-image:none}.ui-state-active .ui-icon,.ui-button:active .ui-icon{background-image:none}.ui-state-highlight .ui-icon,.ui-button .ui-state-highlight.ui-icon{background-image:none}.ui-state-error .ui-icon,.ui-state-error-text .ui-icon{background-image:none}.ui-button .ui-icon{background-image:none}.ui-icon-blank{background-position:16px 16px}.ui-icon-caret-1-n{background-position:0 0}.ui-icon-caret-1-ne{background-position:-16px 0}.ui-icon-caret-1-e{background-position:-32px 0}.ui-icon-caret-1-se{background-position:-48px 0}.ui-icon-caret-1-s{background-position:-65px 0}.ui-icon-caret-1-sw{background-position:-80px 0}.ui-icon-caret-1-w{background-position:-96px 0}.ui-icon-caret-1-nw{background-position:-112px 0}.ui-icon-caret-2-n-s{background-position:-128px 0}.ui-icon-caret-2-e-w{background-position:-144px 0}.ui-icon-triangle-1-n{background-position:0 -16px}.ui-icon-triangle-1-ne{background-position:-16px -16px}.ui-icon-triangle-1-e{background-position:-32px -16px}.ui-icon-triangle-1-se{background-position:-48px -16px}.ui-icon-triangle-1-s{background-position:-65px -16px}.ui-icon-triangle-1-sw{background-position:-80px -16px}.ui-icon-triangle-1-w{background-position:-96px -16px}.ui-icon-triangle-1-nw{background-position:-112px -16px}.ui-icon-triangle-2-n-s{background-position:-128px -16px}.ui-icon-triangle-2-e-w{background-position:-144px -16px}.ui-icon-arrow-1-n{background-position:0 -32px}.ui-icon-arrow-1-ne{background-position:-16px -32px}.ui-icon-arrow-1-e{background-position:-32px -32px}.ui-icon-arrow-1-se{background-position:-48px -32px}.ui-icon-arrow-1-s{background-position:-65px -32px}.ui-icon-arrow-1-sw{background-position:-80px -32px}.ui-icon-arrow-1-w{background-position:-96px -32px}.ui-icon-arrow-1-nw{background-position:-112px -32px}.ui-icon-arrow-2-n-s{background-position:-128px -32px}.ui-icon-arrow-2-ne-sw{background-position:-144px -32px}.ui-icon-arrow-2-e-w{background-position:-160px -32px}.ui-icon-arrow-2-se-nw{background-position:-176px -32px}.ui-icon-arrowstop-1-n{background-position:-192px -32px}.ui-icon-arrowstop-1-e{background-position:-208px -32px}.ui-icon-arrowstop-1-s{background-position:-224px -32px}.ui-icon-arrowstop-1-w{background-position:-240px -32px}.ui-icon-arrowthick-1-n{background-position:1px -48px}.ui-icon-arrowthick-1-ne{background-position:-16px -48px}.ui-icon-arrowthick-1-e{background-position:-32px -48px}.ui-icon-arrowthick-1-se{background-position:-48px -48px}.ui-icon-arrowthick-1-s{background-position:-64px -48px}.ui-icon-arrowthick-1-sw{background-position:-80px -48px}.ui-icon-arrowthick-1-w{background-position:-96px -48px}.ui-icon-arrowthick-1-nw{background-position:-112px -48px}.ui-icon-arrowthick-2-n-s{background-position:-128px -48px}.ui-icon-arrowthick-2-ne-sw{background-position:-144px -48px}.ui-icon-arrowthick-2-e-w{background-position:-160px -48px}.ui-icon-arrowthick-2-se-nw{background-position:-176px -48px}.ui-icon-arrowthickstop-1-n{background-position:-192px -48px}.ui-icon-arrowthickstop-1-e{background-position:-208px -48px}.ui-icon-arrowthickstop-1-s{background-position:-224px -48px}.ui-icon-arrowthickstop-1-w{background-position:-240px -48px}.ui-icon-arrowreturnthick-1-w{background-position:0 -64px}.ui-icon-arrowreturnthick-1-n{background-position:-16px -64px}.ui-icon-arrowreturnthick-1-e{background-position:-32px -64px}.ui-icon-arrowreturnthick-1-s{background-position:-48px -64px}.ui-icon-arrowreturn-1-w{background-position:-64px -64px}.ui-icon-arrowreturn-1-n{background-position:-80px -64px}.ui-icon-arrowreturn-1-e{background-position:-96px -64px}.ui-icon-arrowreturn-1-s{background-position:-112px -64px}.ui-icon-arrowrefresh-1-w{background-position:-128px -64px}.ui-icon-arrowrefresh-1-n{background-position:-144px -64px}.ui-icon-arrowrefresh-1-e{background-position:-160px -64px}.ui-icon-arrowrefresh-1-s{background-position:-176px -64px}.ui-icon-arrow-4{background-position:0 -80px}.ui-icon-arrow-4-diag{background-position:-16px -80px}.ui-icon-extlink{background-position:-32px -80px}.ui-icon-newwin{background-position:-48px -80px}.ui-icon-refresh{background-position:-64px -80px}.ui-icon-shuffle{background-position:-80px -80px}.ui-icon-transfer-e-w{background-position:-96px -80px}.ui-icon-transferthick-e-w{background-position:-112px -80px}.ui-icon-folder-collapsed{background-position:0 -96px}.ui-icon-folder-open{background-position:-16px -96px}.ui-icon-document{background-position:-32px -96px}.ui-icon-document-b{background-position:-48px -96px}.ui-icon-note{background-position:-64px -96px}.ui-icon-mail-closed{background-position:-80px -96px}.ui-icon-mail-open{background-position:-96px -96px}.ui-icon-suitcase{background-position:-112px -96px}.ui-icon-comment{background-position:-128px -96px}.ui-icon-person{background-position:-144px -96px}.ui-icon-print{background-position:-160px -96px}.ui-icon-trash{background-position:-176px -96px}.ui-icon-locked{background-position:-192px -96px}.ui-icon-unlocked{background-position:-208px -96px}.ui-icon-bookmark{background-position:-224px -96px}.ui-icon-tag{background-position:-240px -96px}.ui-icon-home{background-position:0 -112px}.ui-icon-flag{background-position:-16px -112px}.ui-icon-calendar{background-position:-32px -112px}.ui-icon-cart{background-position:-48px -112px}.ui-icon-pencil{background-position:-64px -112px}.ui-icon-clock{background-position:-80px -112px}.ui-icon-disk{background-position:-96px -112px}.ui-icon-calculator{background-position:-112px -112px}.ui-icon-zoomin{background-position:-128px -112px}.ui-icon-zoomout{background-position:-144px -112px}.ui-icon-search{background-position:-160px -112px}.ui-icon-wrench{background-position:-176px -112px}.ui-icon-gear{background-position:-192px -112px}.ui-icon-heart{background-position:-208px -112px}.ui-icon-star{background-position:-224px -112px}.ui-icon-link{background-position:-240px -112px}.ui-icon-cancel{background-position:0 -128px}.ui-icon-plus{background-position:-16px -128px}.ui-icon-plusthick{background-position:-32px -128px}.ui-icon-minus{background-position:-48px -128px}.ui-icon-minusthick{background-position:-64px -128px}.ui-icon-close{background-position:-80px -128px}.ui-icon-closethick{background-position:-96px -128px}.ui-icon-key{background-position:-112px -128px}.ui-icon-lightbulb{background-position:-128px -128px}.ui-icon-scissors{background-position:-144px -128px}.ui-icon-clipboard{background-position:-160px -128px}.ui-icon-copy{background-position:-176px -128px}.ui-icon-contact{background-position:-192px -128px}.ui-icon-image{background-position:-208px -128px}.ui-icon-video{background-position:-224px -128px}.ui-icon-script{background-position:-240px -128px}.ui-icon-alert{background-position:0 -144px}.ui-icon-info{background-position:-16px -144px}.ui-icon-notice{background-position:-32px -144px}.ui-icon-help{background-position:-48px -144px}.ui-icon-check{background-position:-64px -144px}.ui-icon-bullet{background-position:-80px -144px}.ui-icon-radio-on{background-position:-96px -144px}.ui-icon-radio-off{background-position:-112px -144px}.ui-icon-pin-w{background-position:-128px -144px}.ui-icon-pin-s{background-position:-144px -144px}.ui-icon-play{background-position:0 -160px}.ui-icon-pause{background-position:-16px -160px}.ui-icon-seek-next{background-position:-32px -160px}.ui-icon-seek-prev{background-position:-48px -160px}.ui-icon-seek-end{background-position:-64px -160px}.ui-icon-seek-start{background-position:-80px -160px}.ui-icon-seek-first{background-position:-80px -160px}.ui-icon-stop{background-position:-96px -160px}.ui-icon-eject{background-position:-112px -160px}.ui-icon-volume-off{background-position:-128px -160px}.ui-icon-volume-on{background-position:-144px -160px}.ui-icon-power{background-position:0 -176px}.ui-icon-signal-diag{background-position:-16px -176px}.ui-icon-signal{background-position:-32px -176px}.ui-icon-battery-0{background-position:-48px -176px}.ui-icon-battery-1{background-position:-64px -176px}.ui-icon-battery-2{background-position:-80px -176px}.ui-icon-battery-3{background-position:-96px -176px}.ui-icon-circle-plus{background-position:0 -192px}.ui-icon-circle-minus{background-position:-16px -192px}.ui-icon-circle-close{background-position:-32px -192px}.ui-icon-circle-triangle-e{background-position:-48px -192px}.ui-icon-circle-triangle-s{background-position:-64px -192px}.ui-icon-circle-triangle-w{background-position:-80px -192px}.ui-icon-circle-triangle-n{background-position:-96px -192px}.ui-icon-circle-arrow-e{background-position:-112px -192px}.ui-icon-circle-arrow-s{background-position:-128px -192px}.ui-icon-circle-arrow-w{background-position:-144px -192px}.ui-icon-circle-arrow-n{background-position:-160px -192px}.ui-icon-circle-zoomin{background-position:-176px -192px}.ui-icon-circle-zoomout{background-position:-192px -192px}.ui-icon-circle-check{background-position:-208px -192px}.ui-icon-circlesmall-plus{background-position:0 -208px}.ui-icon-circlesmall-minus{background-position:-16px -208px}.ui-icon-circlesmall-close{background-position:-32px -208px}.ui-icon-squaresmall-plus{background-position:-48px -208px}.ui-icon-squaresmall-minus{background-position:-64px -208px}.ui-icon-squaresmall-close{background-position:-80px -208px}.ui-icon-grip-dotted-vertical{background-position:0 -224px}.ui-icon-grip-dotted-horizontal{background-position:-16px -224px}.ui-icon-grip-solid-vertical{background-position:-32px -224px}.ui-icon-grip-solid-horizontal{background-position:-48px -224px}.ui-icon-gripsmall-diagonal-se{background-position:-64px -224px}.ui-icon-grip-diagonal-se{background-position:-80px -224px}.ui-corner-all,.ui-corner-top,.ui-corner-left,.ui-corner-tl{border-top-left-radius:3px}.ui-corner-all,.ui-corner-top,.ui-corner-right,.ui-corner-tr{border-top-right-radius:3px}.ui-corner-all,.ui-corner-bottom,.ui-corner-left,.ui-corner-bl{border-bottom-left-radius:3px}.ui-corner-all,.ui-corner-bottom,.ui-corner-right,.ui-corner-br{border-bottom-right-radius:3px}.ui-widget-overlay{background:#aaa;opacity:.3;filter:Alpha(Opacity=30)}.ui-widget-shadow{-webkit-box-shadow:0 0 5px #666;box-shadow:0 0 5px #666}@charset \'utf-8\';.liteAccordion{text-align:left; font-size:16px; line-height:24px; font:\'Helvetica Neue\',Verdana,Arial,sans-serif; -webkit-backface-visibility:hidden; -webkit-perspective:1000; -webkit-tap-highlight-color:transparent}.liteAccordion{padding:0; margin:0; border:0; box-sizing:content-box}.liteAccordion > ol{position:relative; overflow:hidden; height:100%; margin:0; padding:0; list-style-type:none}.liteAccordion > ol > li{list-style-type:none}.liteAccordion .slide > h2{color:black; font-size:16px; font-weight:normal; margin:0; z-index:100; position:absolute; top:0; left:0; -webkit-backface-visibility:hidden; -webkit-transform:translateX(-100%) rotate(-90deg); -webkit-transform-origin:right top; -moz-transform:translateX(-100%) rotate(-90deg); -moz-transform-origin:right top; -o-transform:translateX(-100%) rotate(-90deg); -o-transform-origin:right top; transform:translateX(-100%) rotate(-90deg); transform-origin:right top}.liteAccordion .slide > h2 span{display:block; padding-right:8%; text-align:right; height:90%; margin-top:5px; -webkit-user-select:none; -khtml-user-select:none; -moz-user-select:none; -ms-user-select:none; user-select:none}.liteAccordion .slide > h2 b{display:inline-block; position:absolute; top:13%; left:10%; text-align:center; -webkit-transform:rotate(90deg); -moz-transform:rotate(90deg); -o-transform:rotate(90deg); transform:rotate(90deg)}.liteAccordion .slide > h2:hover{cursor:pointer}.liteAccordion .slide > div{height:100%; position:absolute; top:0; z-index:10; overflow:hidden; background:white}.liteAccordion .ap-caption{padding:10px 15px; position:absolute; bottom:20px; right:30px; z-index:3; background:black; background:rgba(0,0,0,0.7); color:white; -webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px}.liteAccordion noscript p{padding:10px; margin:0; background:white}.liteAccordion.basic .slide > h2{background:#333; color:white; line-height:225%}.liteAccordion.dark{border:9px solid #353535; border-bottom-width:8px; padding:5px 5px 6px 0; background:#030303; -webkit-box-shadow:0 -1px 0 #5b5b5b inset,0 5px 15px rgba(0,0,0,0.4); -moz-box-shadow:0 -1px 0 #5b5b5b inset,0 5px 15px rgba(0,0,0,0.4); -ms-box-shadow:0 -1px 0 #5b5b5b inset,0 5px 15px rgba(0,0,0,0.4); -o-box-shadow:0 -1px 0 #5b5b5b inset,0 5px 15px rgba(0,0,0,0.4); box-shadow:0 -1px 0 #5b5b5b inset,0 5px 15px rgba(0,0,0,0.4)}.liteAccordion.dark .slide > h2{background:#030303; text-shadow:0 -1px 0 #030303; line-height:265%}.liteAccordion.dark .slide > h2 span{background:#353535; color:white}.liteAccordion.dark .slide > h2 b{background:#353535; color:#030303; text-shadow:-1px 1px 0 #5b5b5b}.liteAccordion.dark .slide > h2.selected span,.liteAccordion.dark .slide > h2.selected span:hover{background:#353535; background:-moz-linear-gradient(left,#353535 0%,#555555 100%); background:-webkit-gradient(linear,left top,right top,color-stop(0%,#353535),color-stop(100%,#555555)); background:-webkit-linear-gradient(left,#353535 0%,#555555 100%); background:-o-linear-gradient(left,#353535 0%,#555555 100%); background:-ms-linear-gradient(left,#353535 0%,#555555 100%); background:linear-gradient(left,#353535 0%,#555555 100%); filter:progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#353535\',endColorstr=\'#555555\',GradientType=1 )}.liteAccordion.dark .slide > h2.selected b{background:#383838; background:-moz-linear-gradient(top,#3a3a3a 0%,#363636 100%); background:-webkit-gradient(linear,left top,left bottom,color-stop(0%,#3a3a3a),color-stop(100%,#363636)); background:-webkit-linear-gradient(top,#3a3a3a 0%,#363636 100%); background:-o-linear-gradient(top,#3a3a3a 0%,#363636 100%); background:-ms-linear-gradient(top,#3a3a3a 0%,#363636 100%); background:linear-gradient(top,#3a3a3a 0%,#363636 100%)}.liteAccordion.dark .slide > div{background:#030303; margin-left:5px}.liteAccordion.light{border:9px solid white; border-bottom-width:8px; padding:5px 5px 6px 0; background:#a0a0a0; -webkit-box-shadow:-1px -1px 0 #c0c0c0,1px 1px 0 #c0c0c0,0 5px 15px rgba(0,0,0,0.4); -moz-box-shadow:-1px -1px 0 #c0c0c0,1px 1px 0 #c0c0c0,0 5px 15px rgba(0,0,0,0.4); -ms-box-shadow:-1px -1px 0 #c0c0c0,1px 1px 0 #c0c0c0,0 5px 15px rgba(0,0,0,0.4); -o-box-shadow:-1px -1px 0 #c0c0c0,1px 1px 0 #c0c0c0,0 5px 15px rgba(0,0,0,0.4); box-shadow:-1px -1px 0 #c0c0c0,1px 1px 0 #c0c0c0,0 5px 15px rgba(0,0,0,0.4)}.liteAccordion.light .slide > h2{background:#a0a0a0; text-shadow:0 -1px 0 white; line-height:265%}.liteAccordion.light .slide > h2 span{background:#fcfcfc; background:-moz-linear-gradient(left,#fcfcfc 0%,#ededed 100%); background:-webkit-gradient(linear,left top,right top,color-stop(0%,#fcfcfc),color-stop(100%,#ededed)); background:-webkit-linear-gradient(left,#fcfcfc 0%,#ededed 100%); background:-o-linear-gradient(left,#fcfcfc 0%,#ededed 100%); background:-ms-linear-gradient(left,#fcfcfc 0%,#ededed 100%); background:linear-gradient(left,#fcfcfc 0%,#ededed 100%); filter:progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#fcfcfc\',endColorstr=\'#ededed\',GradientType=1 ); -webkit-box-shadow:-1px -1px 0 #909090 inset,1px 1px 0 #909090 inset; -moz-box-shadow:-1px -1px 0 #909090 inset,1px 1px 0 #909090 inset; -o-box-shadow:-1px -1px 0 #909090 inset,1px 1px 0 #909090 inset; box-shadow:-1px -1px 0 #909090 inset,1px 1px 0 #909090 inset; color:#909090}.liteAccordion.light .slide > h2 b{background:#ffffff; color:#909090; text-shadow:-1px 1px 0 white}.liteAccordion.light .slide > h2.selected span,.liteAccordion.light .slide h2.selected span:hover,.liteAccordion.light .slide > h2.selected b{background:#ffffff}.liteAccordion.light .slide > div{background:#a0a0a0; margin-left:5px}.liteAccordion.stitch{position:relative; padding:5px 0 5px 5px; border:11px solid #353535; background:#353535; -webkit-box-shadow:0 -1px 0 #5b5b5b inset,0 5px 15px rgba(0,0,0,0.4); -moz-box-shadow:0 -1px 0 #5b5b5b inset,0 5px 15px rgba(0,0,0,0.4); -o-box-shadow:0 -1px 0 #5b5b5b inset,0 5px 15px rgba(0,0,0,0.4); box-shadow:0 -1px 0 #5b5b5b inset,0 5px 15px rgba(0,0,0,0.4)}.liteAccordion.stitch:before{content:\'\'; width:100%; height:100%; position:absolute; top:-9px; left:-9px; background:#353535; border:9px solid transparent; -webkit-border-image:url(\'bg_stitch.png\') 9 repeat; -moz-border-image:url(\'bg_stitch.png\') 9 repeat; -o-border-image:url(\'bg_stitch.png\') 9 repeat; border-image:url(\'bg_stitch.png\') 9 repeat}.liteAccordion.stitch .slide > h2{background:#353535}.liteAccordion.stitch .slide > h2 span{height:auto; padding-right:5%; color:white; text-shadow:-1px 1px 0 #5b5b5b; border:9px solid transparent; background-image:url(\'bg_noise.png\'); margin-top:0; -webkit-border-image:url(\'bg_stitch.png\') 9 repeat; -moz-border-image:url(\'bg_stitch.png\') 9 repeat; -o-border-image:url(\'bg_stitch.png\') 9 repeat; border-image:url(\'bg_stitch.png\') 9 repeat}.liteAccordion.stitch .slide > h2.selected:after{content:\'\'; display:block; height:11px; width:11px; position:absolute; bottom:-3px; right:38px; -webkit-transform:rotate(45deg); -moz-transform:rotate(45deg); -o-transform:rotate(45deg); transform:rotate(45deg); -ms-filter:"progid:DXImageTransform.Microsoft.BasicImage(rotation=2)"; filter:progid:DXImageTransform.Microsoft.BasicImage(rotation=2); border:9px solid transparent; border-top:0; border-left:0; -webkit-border-image:url(\'bg_stitch.png\') 9 repeat; -moz-border-image:url(\'bg_stitch.png\') 9 repeat; -o-border-image:url(\'bg_stitch.png\') 9 repeat; border-image:url(\'bg_stitch.png\') 9 repeat; background-image:url(\'bg_noise.png\')}.liteAccordion.stitch .slide:nth-child(1) > h2 span,.liteAccordion.stitch .slide:nth-child(1) > h2:after{background-color:#c25252}.liteAccordion.stitch .slide:nth-child(2) > h2 span,.liteAccordion.stitch .slide:nth-child(2) > h2:after{background-color:#ca9859}.liteAccordion.stitch .slide:nth-child(3) > h2 span,.liteAccordion.stitch .slide:nth-child(3) > h2:after{background-color:#96ba5f}.liteAccordion.stitch .slide:nth-child(4) > h2 span,.liteAccordion.stitch .slide:nth-child(4) > h2:after{background-color:#59abb7}.liteAccordion.stitch .slide:nth-child(5) > h2 span,.liteAccordion.stitch .slide:nth-child(5) > h2:after{background-color:#bb6098}.liteAccordion.stitch .slide > h2 b{top:19%; color:white; text-shadow:1px 1px 0 #5b5b5b}.liteAccordion.stitch .slide > div{margin-right:6px}.liteAccordion.stitch.rounded > ol{-webkit-border-radius:0; -moz-border-radius:0; -ms-border-radius:0; border-radius:0}.liteAccordion.rounded,.rounded > ol{-webkit-border-radius:6px; -moz-border-radius:6px; -ms-border-radius:6px; border-radius:6px}.liteAccordion.rounded .slide > h2 span{-webkit-border-radius:4px; -moz-border-radius:4px; -ms-border-radius:4px; border-radius:4px}.liteAccordion.ie.stitch .slide > h2{}.liteAccordion.ie.stitch .slide > h2 span{}.liteAccordion.ie.stitch .slide > h2.selected:after{display:none}.liteAccordion.ie.stitch .slide-0 > h2 span{background-color:#c25252}.liteAccordion.ie.stitch .slide-1 > h2 span{background-color:#ca9859}.liteAccordion.ie.stitch .slide-2 > h2 span{background-color:#96ba5f}.liteAccordion.ie.stitch .slide-3 > h2 span{background-color:#59abb7}.liteAccordion.ie.stitch .slide-4 > h2 span{background-color:#bb6098}.liteAccordion.ie.stitch .slide-5 > h2 span{background-color:#c25252}.liteAccordion.ie.stitch .slide-6 > h2 span{background-color:#ca9859}.liteAccordion.ie.stitch .slide-7 > h2 span{background-color:#96ba5f}.liteAccordion.ie.stitch .slide-8 > h2 span{background-color:#59abb7}.liteAccordion.ie.stitch .slide-9 > h2 span{background-color:#bb6098}.liteAccordion.ie .slide > h2,.liteAccordion.ie .slide > h2 span,.liteAccordion.ie .slide > h2 b{filter:none; -ms-filter:none; -ms-transform:none}.liteAccordion.ie7 .slide > h2{filter:progid:DXImageTransform.Microsoft.BasicImage(rotation=3)}.liteAccordion.ie7 .slide > h2 b{filter:progid:DXImageTransform.Microsoft.BasicImage(rotation=1)}.liteAccordion.ie8 .slide > h2{-ms-filter:"progid:DXImageTransform.Microsoft.BasicImage(rotation=3)"}.liteAccordion.ie8 .slide > h2 b{-ms-filter:"progid:DXImageTransform.Microsoft.BasicImage(rotation=1)"}.liteAccordion.ie9 .slide > h2{-ms-transform:translateX(-100%) rotate(-90deg); -ms-transform-origin:right top}.liteAccordion.ie9 .slide > h2 b{-ms-transform:rotate(90deg)}.liteAccordion.ie7 .slide > h2 b,.liteAccordion.ie8 .slide > h2 b{top:44%; left:5%}.liteAccordion.ie7.stitch .slide > h2 b,.liteAccordion.ie8.stitch .slide > h2 b{top:36%}.liteAccordion.ie9.stitch{box-shadow:0 5px 15px rgba(0,0,0,0.4)}html{width:100%; height:100%; background-color:#F2F2F2}body{position:relative; width:90%; height:94%; margin:0 auto 0; min-width:900px; min-height:650px; font-family:\'Source Sans Pro\',Verdana,Geneva,sans-serif; font-size:16px}h2{font-size:24px; font-weight:bolder; margin-top:15px}p{margin:10px 0}code,input[type="text"],textarea{font-family:\'Source Code Pro\',\'Consolas\',\'Courier New\',monospace}body > h1{height:4%; margin-top:0.75%; margin-left:2%; font-family:\'Source Code Pro\',\'Consolas\',\'Courier New\',monospace; font-weight:normal; font-size:26px; text-shadow:2px 2px 2px #999999}body > .version{position:absolute; top:0; right:0; height:4%; margin-top:0.75%; margin-left:2%; font-family:\'Source Code Pro\',\'Consolas\',\'Courier New\',monospace; font-weight:normal; font-size:12px; text-shadow:2px 2px 2px #999999}#container{width:100%; height:96% !important; margin-top:0.75%; border:1px solid #333333; box-shadow:0 0 20px #737373; background-color:#FFFFFF}#container .slide > h2{width:48px !important; height:100% !important; -webkit-transform:none; -moz-transform:none; -ms-transform:none; -o-transform:none; transform:none; font-family:\'Source Code Pro\',\'Consolas\',\'Courier New\',monospace}#container .slide > h2 span{height:44px; width:99999px; margin-top:25px; margin-left:4px; padding-right:0; vertical-align:baseline; -webkit-transform:translateX(-100%) rotate(-90deg); -moz-transform:translateX(-100%) rotate(-90deg); -ms-transform:translateX(-100%) rotate(-90deg); -o-transform:translateX(-100%) rotate(-90deg); transform:translateX(-100%) rotate(-90deg); -webkit-transform-origin:right top; -moz-transform-origin:right top; -ms-transform-origin:right top; -o-transform-origin:right top; transform-origin:right top}#container .slide > h2 b{top:auto; bottom:10px; left:18px; font-size:22px; -webkit-transform:none; -moz-transform:none; -ms-transform:none; -o-transform:none; transform:none}#container .slide > div{height:100%; overflow:auto}#container .slide > div > div{position:relative; height:auto; min-height:100%; min-height:-webkit-calc(100% - 2px); min-height:-moz-calc(100% - 2px); min-height:-ms-calc(100% - 2px); min-height:-o-calc(100% - 2px); min-height:calc(100% - 2px); padding:1px 0}#container .slide > div form{margin:40px 40px 0}div.blockUI.blockOverlay{background-color:#000; opacity:0.6; cursor:wait}div.blockUI.blockMsg{width:30%; top:40%; left:35%; text-align:center; padding:5px; opacity:0.6; cursor:wait; color:#fff; background-color:#000; -webkit-border-radius:10px; -moz-border-radius:10px; -ms-border-radius:10px; -o-border-radius:10px; border-radius:10px}.errormessage{color:red; font-weight:bolder; font-size:14px}i,.html-suggestions{font-style:italic}table{border-collapse:collapse}table td,table th{border:1px solid #919191; font-size:1em; padding:5px 10px 3px; vertical-align:middle}input[type="text"],input[type="password"]{min-width:180px}.values-switch{color:#808080}.values-switch a{color:#808080}.values-switch a:hover{color:#737373}.values-switch a.active{font-weight:bold; color:#8C8C8C}.values-switch a.active:hover{color:#8C8C8C}';public static $faviconico='base64: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';public static $js_scriptjs='normal:!function(a,b){"use strict";"object"==typeof module&&"object"==typeof module.exports?module.exports=a.document?b(a,!0):function(a){if(!a.document)throw Error("jQuery requires a window with a document");return b(a)}:b(a)}("undefined"!=typeof window?window:this,function(a,b){"use strict";var c=[],d=a.document,e=Object.getPrototypeOf,f=c.slice,g=c.concat,h=c.push,i=c.indexOf,j={},k=j.toString,l=j.hasOwnProperty,m=l.toString,n=m.call(Object),o={};function p(a,b){var c=(b=b||d).createElement("script");c.text=a,b.head.appendChild(c).parentNode.removeChild(c)}function v(a,b){return b.toUpperCase()}var q="3.1.1",r=function(a,b){return new r.fn.init(a,b)},s=/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g,t=/^-ms-/,u=/-([a-z])/g;function w(a){var b=!!a&&"length"in a&&a.length,c=r.type(a);return"function"!==c&&!r.isWindow(a)&&("array"===c||0===b||"number"==typeof b&&0<b&&b-1 in a)}r.fn=r.prototype={jquery:q,constructor:r,length:0,toArray:function(){return f.call(this)},get:function(a){return null==a?f.call(this):a<0?this[a+this.length]:this[a]},pushStack:function(a){var b=r.merge(this.constructor(),a);return b.prevObject=this,b},each:function(a){return r.each(this,a)},map:function(a){return this.pushStack(r.map(this,function(b,c){return a.call(b,c,b)}))},slice:function(){return this.pushStack(f.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(a){var b=this.length,c=+a+(a<0?b:0);return this.pushStack(0<=c&&c<b?[this[c]]:[])},end:function(){return this.prevObject||this.constructor()},push:h,sort:c.sort,splice:c.splice},r.extend=r.fn.extend=function(){var a,b,c,d,e,f,g=arguments[0]||{},h=1,i=arguments.length,j=!1;for("boolean"==typeof g&&(j=g,g=arguments[h]||{},h++),"object"==typeof g||r.isFunction(g)||(g={}),h===i&&(g=this,h--);h<i;h++)if(null!=(a=arguments[h]))for(b in a)c=g[b],g!==(d=a[b])&&(j&&d&&(r.isPlainObject(d)||(e=r.isArray(d)))?(f=e?(e=!1,c&&r.isArray(c)?c:[]):c&&r.isPlainObject(c)?c:{},g[b]=r.extend(j,f,d)):void 0!==d&&(g[b]=d));return g},r.extend({expando:"jQuery"+(q+Math.random()).replace(/\\D/g,""),isReady:!0,error:function(a){throw Error(a)},noop:function(){},isFunction:function(a){return"function"===r.type(a)},isArray:Array.isArray,isWindow:function(a){return null!=a&&a===a.window},isNumeric:function(a){var b=r.type(a);return("number"===b||"string"===b)&&!isNaN(a-parseFloat(a))},isPlainObject:function(a){var b,c;return!(!a||"[object Object]"!==k.call(a)||(b=e(a))&&("function"!=typeof(c=l.call(b,"constructor")&&b.constructor)||m.call(c)!==n))},isEmptyObject:function(a){var b;for(b in a)return!1;return!0},type:function(a){return null==a?a+"":"object"==typeof a||"function"==typeof a?j[k.call(a)]||"object":typeof a},globalEval:function(a){p(a)},camelCase:function(a){return a.replace(t,"ms-").replace(u,v)},nodeName:function(a,b){return a.nodeName&&a.nodeName.toLowerCase()==b.toLowerCase()},each:function(a,b){var c,d=0;if(w(a))for(c=a.length;d<c&&!1!==b.call(a[d],d,a[d]);d++);else for(d in a)if(!1===b.call(a[d],d,a[d]))break;return a},trim:function(a){return null==a?"":(a+"").replace(s,"")},makeArray:function(a,b){var c=b||[];return null!=a&&(w(Object(a))?r.merge(c,"string"==typeof a?[a]:a):h.call(c,a)),c},inArray:function(a,b,c){return null==b?-1:i.call(b,a,c)},merge:function(a,b){for(var c=+b.length,d=0,e=a.length;d<c;d++)a[e++]=b[d];return a.length=e,a},grep:function(a,b,c){for(var e=[],f=0,g=a.length,h=!c;f<g;f++)!b(a[f],f)!=h&&e.push(a[f]);return e},map:function(a,b,c){var d,e,f=0,h=[];if(w(a))for(d=a.length;f<d;f++)null!=(e=b(a[f],f,c))&&h.push(e);else for(f in a)null!=(e=b(a[f],f,c))&&h.push(e);return g.apply([],h)},guid:1,proxy:function(a,b){var c,d,e;if("string"==typeof b&&(c=a[b],b=a,a=c),r.isFunction(a))return d=f.call(arguments,2),(e=function(){return a.apply(b||this,d.concat(f.call(arguments)))}).guid=a.guid=a.guid||r.guid++,e},now:Date.now,support:o}),"function"==typeof Symbol&&(r.fn[Symbol.iterator]=c[Symbol.iterator]),r.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(a,b){j["[object "+b+"]"]=b.toLowerCase()});var x=function(a){function aa(a,b,c){var d="0x"+b-65536;return d!=d||c?b:d<0?String.fromCharCode(65536+d):String.fromCharCode(d>>10|55296,1023&d|56320)}function da(){m()}var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u="sizzle"+ +new Date,v=a.document,w=0,x=0,y=ha(),z=ha(),A=ha(),B=function(a,b){return a===b&&(l=!0),0},C={}.hasOwnProperty,D=[],E=D.pop,F=D.push,G=D.push,H=D.slice,I=function(a,b){for(var c=0,d=a.length;c<d;c++)if(a[c]===b)return c;return-1},J="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",K="[\\\\x20\\\\t\\\\r\\\\n\\\\f]",L="(?:\\\\\\\\.|[\\\\w-]|[^\\0-\\\\xa0])+",M="\\\\["+K+"*("+L+")(?:"+K+"*([*^$|!~]?=)"+K+"*(?:\'((?:\\\\\\\\.|[^\\\\\\\\\'])*)\'|\\"((?:\\\\\\\\.|[^\\\\\\\\\\"])*)\\"|("+L+"))|)"+K+"*\\\\]",N=":("+L+")(?:\\\\(((\'((?:\\\\\\\\.|[^\\\\\\\\\'])*)\'|\\"((?:\\\\\\\\.|[^\\\\\\\\\\"])*)\\")|((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|"+M+")*)|.*)\\\\)|)",O=RegExp(K+"+","g"),P=RegExp("^"+K+"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)"+K+"+$","g"),Q=RegExp("^"+K+"*,"+K+"*"),R=RegExp("^"+K+"*([>+~]|"+K+")"+K+"*"),S=RegExp("="+K+"*([^\\\\]\'\\"]*?)"+K+"*\\\\]","g"),T=RegExp(N),U=RegExp("^"+L+"$"),V={ID:RegExp("^#("+L+")"),CLASS:RegExp("^\\\\.("+L+")"),TAG:RegExp("^("+L+"|[*])"),ATTR:RegExp("^"+M),PSEUDO:RegExp("^"+N),CHILD:RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\("+K+"*(even|odd|(([+-]|)(\\\\d*)n|)"+K+"*(?:([+-]|)"+K+"*(\\\\d+)|))"+K+"*\\\\)|)","i"),bool:RegExp("^(?:"+J+")$","i"),needsContext:RegExp("^"+K+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\("+K+"*((?:-\\\\d)?\\\\d*)"+K+"*\\\\)|)(?=[^-]|$)","i")},W=/^(?:input|select|textarea|button)$/i,X=/^h\\d$/i,Y=/^[^{]+\\{\\s*\\[native \\w/,Z=/^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,$=/[+~]/,_=RegExp("\\\\\\\\([\\\\da-f]{1,6}"+K+"?|("+K+")|.)","ig"),ba=/([\\0-\\x1f\\x7f]|^-?\\d)|^-$|[^\\0-\\x1f\\x7f-\\uFFFF\\w-]/g,ca=function(a,b){return b?"\\0"===a?"\\ufffd":a.slice(0,-1)+"\\\\"+a.charCodeAt(a.length-1).toString(16)+" ":"\\\\"+a},ea=ta(function(a){return!0===a.disabled&&("form"in a||"label"in a)},{dir:"parentNode",next:"legend"});try{G.apply(D=H.call(v.childNodes),v.childNodes),D[v.childNodes.length].nodeType}catch(fa){G={apply:D.length?function(a,b){F.apply(a,H.call(b))}:function(a,b){for(var c=a.length,d=0;a[c++]=b[d++];);a.length=c-1}}}function ga(a,b,d,e){var f,h,j,k,l,o,r,s=b&&b.ownerDocument,w=b?b.nodeType:9;if(d=d||[],"string"!=typeof a||!a||1!==w&&9!==w&&11!==w)return d;if(!e&&((b?b.ownerDocument||b:v)!==n&&m(b),b=b||n,p)){if(11!==w&&(l=Z.exec(a)))if(f=l[1]){if(9===w){if(!(j=b.getElementById(f)))return d;if(j.id===f)return d.push(j),d}else if(s&&(j=s.getElementById(f))&&t(b,j)&&j.id===f)return d.push(j),d}else{if(l[2])return G.apply(d,b.getElementsByTagName(a)),d;if((f=l[3])&&c.getElementsByClassName&&b.getElementsByClassName)return G.apply(d,b.getElementsByClassName(f)),d}if(c.qsa&&!A[a+" "]&&(!q||!q.test(a))){if(1!==w)s=b,r=a;else if("object"!=b.nodeName.toLowerCase()){for((k=b.getAttribute("id"))?k=k.replace(ba,ca):b.setAttribute("id",k=u),h=(o=g(a)).length;h--;)o[h]="#"+k+" "+sa(o[h]);r=o.join(","),s=$.test(a)&&qa(b.parentNode)||b}if(r)try{return G.apply(d,s.querySelectorAll(r)),d}catch(x){}finally{k===u&&b.removeAttribute("id")}}}return i(a.replace(P,"$1"),b,d,e)}function ha(){var a=[];function b(c,e){return a.push(c+" ")>d.cacheLength&&delete b[a.shift()],b[c+" "]=e}return b}function ia(a){return a[u]=!0,a}function ja(a){var b=n.createElement("fieldset");try{return!!a(b)}catch(c){return!1}finally{b.parentNode&&b.parentNode.removeChild(b),b=null}}function ka(a,b){for(var c=a.split("|"),e=c.length;e--;)d.attrHandle[c[e]]=b}function la(a,b){var c=b&&a,d=c&&1===a.nodeType&&1===b.nodeType&&a.sourceIndex-b.sourceIndex;if(d)return d;if(c)for(;c=c.nextSibling;)if(c===b)return-1;return a?1:-1}function oa(a){return function(b){return"form"in b?b.parentNode&&!1===b.disabled?"label"in b?"label"in b.parentNode?b.parentNode.disabled===a:b.disabled===a:b.isDisabled===a||b.isDisabled!==!a&&ea(b)===a:b.disabled===a:"label"in b&&b.disabled===a}}function pa(a){return ia(function(b){return b=+b,ia(function(c,d){for(var e,f=a([],c.length,b),g=f.length;g--;)c[e=f[g]]&&(c[e]=!(d[e]=c[e]))})})}function qa(a){return a&&void 0!==a.getElementsByTagName&&a}for(b in c=ga.support={},f=ga.isXML=function(a){var b=a&&(a.ownerDocument||a).documentElement;return!!b&&"HTML"!==b.nodeName},m=ga.setDocument=function(a){var b,e,g=a?a.ownerDocument||a:v;return g!==n&&9===g.nodeType&&g.documentElement&&(o=(n=g).documentElement,p=!f(n),v!==n&&(e=n.defaultView)&&e.top!==e&&(e.addEventListener?e.addEventListener("unload",da,!1):e.attachEvent&&e.attachEvent("onunload",da)),c.attributes=ja(function(a){return a.className="i",!a.getAttribute("className")}),c.getElementsByTagName=ja(function(a){return a.appendChild(n.createComment("")),!a.getElementsByTagName("*").length}),c.getElementsByClassName=Y.test(n.getElementsByClassName),c.getById=ja(function(a){return o.appendChild(a).id=u,!n.getElementsByName||!n.getElementsByName(u).length}),c.getById?(d.filter.ID=function(a){var b=a.replace(_,aa);return function(a){return a.getAttribute("id")===b}},d.find.ID=function(a,b){if(void 0!==b.getElementById&&p){var c=b.getElementById(a);return c?[c]:[]}}):(d.filter.ID=function(a){var b=a.replace(_,aa);return function(a){var c=void 0!==a.getAttributeNode&&a.getAttributeNode("id");return c&&c.value===b}},d.find.ID=function(a,b){if(void 0!==b.getElementById&&p){var c,d,e,f=b.getElementById(a);if(f){if((c=f.getAttributeNode("id"))&&c.value===a)return[f];for(e=b.getElementsByName(a),d=0;f=e[d++];)if((c=f.getAttributeNode("id"))&&c.value===a)return[f]}return[]}}),d.find.TAG=c.getElementsByTagName?function(a,b){return void 0!==b.getElementsByTagName?b.getElementsByTagName(a):c.qsa?b.querySelectorAll(a):void 0}:function(a,b){var c,d=[],e=0,f=b.getElementsByTagName(a);if("*"!==a)return f;for(;c=f[e++];)1===c.nodeType&&d.push(c);return d},d.find.CLASS=c.getElementsByClassName&&function(a,b){if(void 0!==b.getElementsByClassName&&p)return b.getElementsByClassName(a)},r=[],q=[],(c.qsa=Y.test(n.querySelectorAll))&&(ja(function(a){o.appendChild(a).innerHTML="<a id=\'"+u+"\'></a><select id=\'"+u+"-\\r\\\\\' msallowcapture=\'\'><option selected=\'\'></option></select>",a.querySelectorAll("[msallowcapture^=\'\']").length&&q.push("[*^$]="+K+"*(?:\'\'|\\"\\")"),a.querySelectorAll("[selected]").length||q.push("\\\\["+K+"*(?:value|"+J+")"),a.querySelectorAll("[id~="+u+"-]").length||q.push("~="),a.querySelectorAll(":checked").length||q.push(":checked"),a.querySelectorAll("a#"+u+"+*").length||q.push(".#.+[+~]")}),ja(function(a){a.innerHTML="<a href=\'\' disabled=\'disabled\'></a><select disabled=\'disabled\'><option/></select>";var b=n.createElement("input");b.setAttribute("type","hidden"),a.appendChild(b).setAttribute("name","D"),a.querySelectorAll("[name=d]").length&&q.push("name"+K+"*[*^$|!~]?="),2!==a.querySelectorAll(":enabled").length&&q.push(":enabled",":disabled"),o.appendChild(a).disabled=!0,2!==a.querySelectorAll(":disabled").length&&q.push(":enabled",":disabled"),a.querySelectorAll("*,:x"),q.push(",.*:")})),(c.matchesSelector=Y.test(s=o.matches||o.webkitMatchesSelector||o.mozMatchesSelector||o.oMatchesSelector||o.msMatchesSelector))&&ja(function(a){c.disconnectedMatch=s.call(a,"*"),s.call(a,"[s!=\'\']:x"),r.push("!=",N)}),q=q.length&&RegExp(q.join("|")),r=r.length&&RegExp(r.join("|")),b=Y.test(o.compareDocumentPosition),t=b||Y.test(o.contains)?function(a,b){var c=9===a.nodeType?a.documentElement:a,d=b&&b.parentNode;return a===d||!(!d||1!==d.nodeType||!(c.contains?c.contains(d):a.compareDocumentPosition&&16&a.compareDocumentPosition(d)))}:function(a,b){if(b)for(;b=b.parentNode;)if(b===a)return!0;return!1},B=b?function(a,b){if(a===b)return l=!0,0;var d=!a.compareDocumentPosition-!b.compareDocumentPosition;return d||(1&(d=(a.ownerDocument||a)===(b.ownerDocument||b)?a.compareDocumentPosition(b):1)||!c.sortDetached&&b.compareDocumentPosition(a)===d?a===n||a.ownerDocument===v&&t(v,a)?-1:b===n||b.ownerDocument===v&&t(v,b)?1:k?I(k,a)-I(k,b):0:4&d?-1:1)}:function(a,b){if(a===b)return l=!0,0;var c,d=0,e=a.parentNode,f=b.parentNode,g=[a],h=[b];if(!e||!f)return a===n?-1:b===n?1:e?-1:f?1:k?I(k,a)-I(k,b):0;if(e===f)return la(a,b);for(c=a;c=c.parentNode;)g.unshift(c);for(c=b;c=c.parentNode;)h.unshift(c);for(;g[d]===h[d];)d++;return d?la(g[d],h[d]):g[d]===v?-1:h[d]===v?1:0}),n},ga.matches=function(a,b){return ga(a,null,null,b)},ga.matchesSelector=function(a,b){if((a.ownerDocument||a)!==n&&m(a),b=b.replace(S,"=\'$1\']"),c.matchesSelector&&p&&!A[b+" "]&&(!r||!r.test(b))&&(!q||!q.test(b)))try{var d=s.call(a,b);if(d||c.disconnectedMatch||a.document&&11!==a.document.nodeType)return d}catch(e){}return 0<ga(b,n,null,[a]).length},ga.contains=function(a,b){return(a.ownerDocument||a)!==n&&m(a),t(a,b)},ga.attr=function(a,b){(a.ownerDocument||a)!==n&&m(a);var e=d.attrHandle[b.toLowerCase()],f=e&&C.call(d.attrHandle,b.toLowerCase())?e(a,b,!p):void 0;return void 0!==f?f:c.attributes||!p?a.getAttribute(b):(f=a.getAttributeNode(b))&&f.specified?f.value:null},ga.escape=function(a){return(a+"").replace(ba,ca)},ga.error=function(a){throw Error("Syntax error, unrecognized expression: "+a)},ga.uniqueSort=function(a){var b,d=[],e=0,f=0;if(l=!c.detectDuplicates,k=!c.sortStable&&a.slice(0),a.sort(B),l){for(;b=a[f++];)b===a[f]&&(e=d.push(f));for(;e--;)a.splice(d[e],1)}return k=null,a},e=ga.getText=function(a){var b,c="",d=0,f=a.nodeType;if(f){if(1===f||9===f||11===f){if("string"==typeof a.textContent)return a.textContent;for(a=a.firstChild;a;a=a.nextSibling)c+=e(a)}else if(3===f||4===f)return a.nodeValue}else for(;b=a[d++];)c+=e(b);return c},(d=ga.selectors={cacheLength:50,createPseudo:ia,match:V,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(a){return a[1]=a[1].replace(_,aa),a[3]=(a[3]||a[4]||a[5]||"").replace(_,aa),"~="===a[2]&&(a[3]=" "+a[3]+" "),a.slice(0,4)},CHILD:function(a){return a[1]=a[1].toLowerCase(),"nth"===a[1].slice(0,3)?(a[3]||ga.error(a[0]),a[4]=+(a[4]?a[5]+(a[6]||1):2*("even"===a[3]||"odd"===a[3])),a[5]=+(a[7]+a[8]||"odd"===a[3])):a[3]&&ga.error(a[0]),a},PSEUDO:function(a){var b,c=!a[6]&&a[2];return V.CHILD.test(a[0])?null:(a[3]?a[2]=a[4]||a[5]||"":c&&T.test(c)&&(b=g(c,!0))&&(b=c.indexOf(")",c.length-b)-c.length)&&(a[0]=a[0].slice(0,b),a[2]=c.slice(0,b)),a.slice(0,3))}},filter:{TAG:function(a){var b=a.replace(_,aa).toLowerCase();return"*"===a?function(){return!0}:function(a){return a.nodeName&&a.nodeName.toLowerCase()==b}},CLASS:function(a){var b=y[a+" "];return b||(b=RegExp("(^|"+K+")"+a+"("+K+"|$)"))&&y(a,function(a){return b.test("string"==typeof a.className&&a.className||void 0!==a.getAttribute&&a.getAttribute("class")||"")})},ATTR:function(a,b,c){return function(d){var e=ga.attr(d,a);return null==e?"!="===b:!b||(e+="","="===b?e===c:"!="===b?e!==c:"^="===b?c&&0==e.indexOf(c):"*="===b?c&&!!~e.indexOf(c):"$="===b?c&&e.slice(-c.length)===c:"~="===b?!!~(" "+e.replace(O," ")+" ").indexOf(c):"|="===b&&(e===c||e.slice(0,c.length+1)===c+"-"))}},CHILD:function(a,b,c,d,e){var f="nth"!==a.slice(0,3),g="last"!==a.slice(-4),h="of-type"===b;return 1===d&&0===e?function(a){return!!a.parentNode}:function(b,c,i){var j,k,l,m,n,o,p=f!=g?"nextSibling":"previousSibling",q=b.parentNode,r=h&&b.nodeName.toLowerCase(),s=!i&&!h,t=!1;if(q){if(f){for(;p;){for(m=b;m=m[p];)if(h?m.nodeName.toLowerCase()===r:1===m.nodeType)return!1;o=p="only"===a&&!o&&"nextSibling"}return!0}if(o=[g?q.firstChild:q.lastChild],g&&s){for(t=(n=(j=(k=(l=(m=q)[u]||(m[u]={}))[m.uniqueID]||(l[m.uniqueID]={}))[a]||[])[0]===w&&j[1])&&j[2],m=n&&q.childNodes[n];m=++n&&m&&m[p]||(t=n=0)||o.pop();)if(1===m.nodeType&&++t&&m===b){k[a]=[w,n,t];break}}else if(s&&(t=n=(j=(k=(l=(m=b)[u]||(m[u]={}))[m.uniqueID]||(l[m.uniqueID]={}))[a]||[])[0]===w&&j[1]),!1===t)for(;(m=++n&&m&&m[p]||(t=n=0)||o.pop())&&((h?m.nodeName.toLowerCase()!==r:1!==m.nodeType)||!++t||(s&&((k=(l=m[u]||(m[u]={}))[m.uniqueID]||(l[m.uniqueID]={}))[a]=[w,t]),m!==b)););return(t-=e)===d||t%d==0&&0<=t/d}}},PSEUDO:function(a,b){var c,e=d.pseudos[a]||d.setFilters[a.toLowerCase()]||ga.error("unsupported pseudo: "+a);return e[u]?e(b):1<e.length?(c=[a,a,"",b],d.setFilters.hasOwnProperty(a.toLowerCase())?ia(function(a,c){for(var d,f=e(a,b),g=f.length;g--;)a[d=I(a,f[g])]=!(c[d]=f[g])}):function(a){return e(a,0,c)}):e}},pseudos:{not:ia(function(a){var b=[],c=[],d=h(a.replace(P,"$1"));return d[u]?ia(function(a,b,c,e){for(var f,g=d(a,null,e,[]),h=a.length;h--;)(f=g[h])&&(a[h]=!(b[h]=f))}):function(a,e,f){return b[0]=a,d(b,null,f,c),b[0]=null,!c.pop()}}),has:ia(function(a){return function(b){return 0<ga(a,b).length}}),contains:ia(function(a){return a=a.replace(_,aa),function(b){return!!~(b.textContent||b.innerText||e(b)).indexOf(a)}}),lang:ia(function(a){return U.test(a||"")||ga.error("unsupported lang: "+a),a=a.replace(_,aa).toLowerCase(),function(b){var c;do{if(c=p?b.lang:b.getAttribute("xml:lang")||b.getAttribute("lang"))return(c=c.toLowerCase())===a||0==c.indexOf(a+"-")}while((b=b.parentNode)&&1===b.nodeType);return!1}}),target:function(b){var c=a.location&&a.location.hash;return c&&c.slice(1)===b.id},root:function(a){return a===o},focus:function(a){return a===n.activeElement&&(!n.hasFocus||n.hasFocus())&&!!(a.type||a.href||~a.tabIndex)},enabled:oa(!1),disabled:oa(!0),checked:function(a){var b=a.nodeName.toLowerCase();return"input"==b&&!!a.checked||"option"==b&&!!a.selected},selected:function(a){return a.parentNode&&a.parentNode.selectedIndex,!0===a.selected},empty:function(a){for(a=a.firstChild;a;a=a.nextSibling)if(a.nodeType<6)return!1;return!0},parent:function(a){return!d.pseudos.empty(a)},header:function(a){return X.test(a.nodeName)},input:function(a){return W.test(a.nodeName)},button:function(a){var b=a.nodeName.toLowerCase();return"input"==b&&"button"===a.type||"button"==b},text:function(a){var b;return"input"==a.nodeName.toLowerCase()&&"text"===a.type&&(null==(b=a.getAttribute("type"))||"text"==b.toLowerCase())},first:pa(function(){return[0]}),last:pa(function(a,b){return[b-1]}),eq:pa(function(a,b,c){return[c<0?c+b:c]}),even:pa(function(a,b){for(var c=0;c<b;c+=2)a.push(c);return a}),odd:pa(function(a,b){for(var c=1;c<b;c+=2)a.push(c);return a}),lt:pa(function(a,b,c){for(var d=c<0?c+b:c;0<=--d;)a.push(d);return a}),gt:pa(function(a,b,c){for(var d=c<0?c+b:c;++d<b;)a.push(d);return a})}}).pseudos.nth=d.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})d.pseudos[b]=function(a){return function(b){return"input"==b.nodeName.toLowerCase()&&b.type===a}}(b);for(b in{submit:!0,reset:!0})d.pseudos[b]=function(a){return function(b){var c=b.nodeName.toLowerCase();return("input"==c||"button"==c)&&b.type===a}}(b);function ra(){}function sa(a){for(var b=0,c=a.length,d="";b<c;b++)d+=a[b].value;return d}function ta(a,b,c){var d=b.dir,e=b.next,f=e||d,g=c&&"parentNode"===f,h=x++;return b.first?function(b,c,e){for(;b=b[d];)if(1===b.nodeType||g)return a(b,c,e);return!1}:function(b,c,i){var j,k,l,m=[w,h];if(i){for(;b=b[d];)if((1===b.nodeType||g)&&a(b,c,i))return!0}else for(;b=b[d];)if(1===b.nodeType||g)if(k=(l=b[u]||(b[u]={}))[b.uniqueID]||(l[b.uniqueID]={}),e&&e===b.nodeName.toLowerCase())b=b[d]||b;else{if((j=k[f])&&j[0]===w&&j[1]===h)return m[2]=j[2];if((k[f]=m)[2]=a(b,c,i))return!0}return!1}}function ua(a){return 1<a.length?function(b,c,d){for(var e=a.length;e--;)if(!a[e](b,c,d))return!1;return!0}:a[0]}function wa(a,b,c,d,e){for(var f,g=[],h=0,i=a.length,j=null!=b;h<i;h++)(f=a[h])&&(c&&!c(f,d,e)||(g.push(f),j&&b.push(h)));return g}function xa(a,b,c,d,e,f){return d&&!d[u]&&(d=xa(d)),e&&!e[u]&&(e=xa(e,f)),ia(function(f,g,h,i){var j,k,l,m=[],n=[],o=g.length,p=f||function(a,b,c){for(var d=0,e=b.length;d<e;d++)ga(a,b[d],c);return c}(b||"*",h.nodeType?[h]:h,[]),q=!a||!f&&b?p:wa(p,m,a,h,i),r=c?e||(f?a:o||d)?[]:g:q;if(c&&c(q,r,h,i),d)for(j=wa(r,n),d(j,[],h,i),k=j.length;k--;)(l=j[k])&&(r[n[k]]=!(q[n[k]]=l));if(f){if(e||a){if(e){for(j=[],k=r.length;k--;)(l=r[k])&&j.push(q[k]=l);e(null,r=[],j,i)}for(k=r.length;k--;)(l=r[k])&&-1<(j=e?I(f,l):m[k])&&(f[j]=!(g[j]=l))}}else r=wa(r===g?r.splice(o,r.length):r),e?e(null,g,r,i):G.apply(g,r)})}function ya(a){for(var b,c,e,f=a.length,g=d.relative[a[0].type],h=g||d.relative[" "],i=g?1:0,k=ta(function(a){return a===b},h,!0),l=ta(function(a){return-1<I(b,a)},h,!0),m=[function(a,c,d){var e=!g&&(d||c!==j)||((b=c).nodeType?k:l)(a,c,d);return b=null,e}];i<f;i++)if(c=d.relative[a[i].type])m=[ta(ua(m),c)];else{if((c=d.filter[a[i].type].apply(null,a[i].matches))[u]){for(e=++i;e<f&&!d.relative[a[e].type];e++);return xa(1<i&&ua(m),1<i&&sa(a.slice(0,i-1).concat({value:" "===a[i-2].type?"*":""})).replace(P,"$1"),c,i<e&&ya(a.slice(i,e)),e<f&&ya(a=a.slice(e)),e<f&&sa(a))}m.push(c)}return ua(m)}function za(a,b){var c=0<b.length,e=0<a.length,f=function(f,g,h,i,k){var l,o,q,r=0,s="0",t=f&&[],u=[],v=j,x=f||e&&d.find.TAG("*",k),y=w+=null==v?1:Math.random()||.1,z=x.length;for(k&&(j=g===n||g||k);s!==z&&null!=(l=x[s]);s++){if(e&&l){for(o=0,g||l.ownerDocument===n||(m(l),h=!p);q=a[o++];)if(q(l,g||n,h)){i.push(l);break}k&&(w=y)}c&&((l=!q&&l)&&r--,f&&t.push(l))}if(r+=s,c&&s!==r){for(o=0;q=b[o++];)q(t,u,g,h);if(f){if(0<r)for(;s--;)t[s]||u[s]||(u[s]=E.call(i));u=wa(u)}G.apply(i,u),k&&!f&&0<u.length&&1<r+b.length&&ga.uniqueSort(i)}return k&&(w=y,j=v),t};return c?ia(f):f}return ra.prototype=d.filters=d.pseudos,d.setFilters=new ra,g=ga.tokenize=function(a,b){var c,e,f,g,h,i,j,k=z[a+" "];if(k)return b?0:k.slice(0);for(h=a,i=[],j=d.preFilter;h;){for(g in c&&!(e=Q.exec(h))||(e&&(h=h.slice(e[0].length)||h),i.push(f=[])),c=!1,(e=R.exec(h))&&(c=e.shift(),f.push({value:c,type:e[0].replace(P," ")}),h=h.slice(c.length)),d.filter)!(e=V[g].exec(h))||j[g]&&!(e=j[g](e))||(c=e.shift(),f.push({value:c,type:g,matches:e}),h=h.slice(c.length));if(!c)break}return b?h.length:h?ga.error(a):z(a,i).slice(0)},h=ga.compile=function(a,b){var c,d=[],e=[],f=A[a+" "];if(!f){for(c=(b=b||g(a)).length;c--;)(f=ya(b[c]))[u]?d.push(f):e.push(f);(f=A(a,za(e,d))).selector=a}return f},i=ga.select=function(a,b,c,e){var f,i,j,k,l,m="function"==typeof a&&a,n=!e&&g(a=m.selector||a);if(c=c||[],1===n.length){if(2<(i=n[0]=n[0].slice(0)).length&&"ID"===(j=i[0]).type&&9===b.nodeType&&p&&d.relative[i[1].type]){if(!(b=(d.find.ID(j.matches[0].replace(_,aa),b)||[])[0]))return c;m&&(b=b.parentNode),a=a.slice(i.shift().value.length)}for(f=V.needsContext.test(a)?0:i.length;f--&&(j=i[f],!d.relative[k=j.type]);)if((l=d.find[k])&&(e=l(j.matches[0].replace(_,aa),$.test(i[0].type)&&qa(b.parentNode)||b))){if(i.splice(f,1),!(a=e.length&&sa(i)))return G.apply(c,e),c;break}}return(m||h(a,n))(e,b,!p,c,!b||$.test(a)&&qa(b.parentNode)||b),c},c.sortStable=u.split("").sort(B).join("")===u,c.detectDuplicates=!!l,m(),c.sortDetached=ja(function(a){return 1&a.compareDocumentPosition(n.createElement("fieldset"))}),ja(function(a){return a.innerHTML="<a href=\'#\'></a>","#"===a.firstChild.getAttribute("href")})||ka("type|href|height|width",function(a,b,c){if(!c)return a.getAttribute(b,"type"==b.toLowerCase()?1:2)}),c.attributes&&ja(function(a){return a.innerHTML="<input/>",a.firstChild.setAttribute("value",""),""===a.firstChild.getAttribute("value")})||ka("value",function(a,b,c){if(!c&&"input"==a.nodeName.toLowerCase())return a.defaultValue}),ja(function(a){return null==a.getAttribute("disabled")})||ka(J,function(a,b,c){var d;if(!c)return!0===a[b]?b.toLowerCase():(d=a.getAttributeNode(b))&&d.specified?d.value:null}),ga}(a);r.find=x,r.expr=x.selectors,r.expr[":"]=r.expr.pseudos,r.uniqueSort=r.unique=x.uniqueSort,r.text=x.getText,r.isXMLDoc=x.isXML,r.contains=x.contains,r.escapeSelector=x.escape;function y(a,b,c){for(var d=[],e=void 0!==c;(a=a[b])&&9!==a.nodeType;)if(1===a.nodeType){if(e&&r(a).is(c))break;d.push(a)}return d}function z(a,b){for(var c=[];a;a=a.nextSibling)1===a.nodeType&&a!==b&&c.push(a);return c}var A=r.expr.match.needsContext,B=/^<([a-z][^\\/\\0>:\\x20\\t\\r\\n\\f]*)[\\x20\\t\\r\\n\\f]*\\/?>(?:<\\/\\1>|)$/i,C=/^.[^:#\\[\\.,]*$/;function D(a,b,c){return r.isFunction(b)?r.grep(a,function(a,d){return!!b.call(a,d,a)!==c}):b.nodeType?r.grep(a,function(a){return a===b!==c}):"string"!=typeof b?r.grep(a,function(a){return-1<i.call(b,a)!==c}):C.test(b)?r.filter(b,a,c):(b=r.filter(b,a),r.grep(a,function(a){return-1<i.call(b,a)!==c&&1===a.nodeType}))}r.filter=function(a,b,c){var d=b[0];return c&&(a=":not("+a+")"),1===b.length&&1===d.nodeType?r.find.matchesSelector(d,a)?[d]:[]:r.find.matches(a,r.grep(b,function(a){return 1===a.nodeType}))},r.fn.extend({find:function(a){var b,c,d=this.length,e=this;if("string"!=typeof a)return this.pushStack(r(a).filter(function(){for(b=0;b<d;b++)if(r.contains(e[b],this))return!0}));for(c=this.pushStack([]),b=0;b<d;b++)r.find(a,e[b],c);return 1<d?r.uniqueSort(c):c},filter:function(a){return this.pushStack(D(this,a||[],!1))},not:function(a){return this.pushStack(D(this,a||[],!0))},is:function(a){return!!D(this,"string"==typeof a&&A.test(a)?r(a):a||[],!1).length}});var E,F=/^(?:\\s*(<[\\w\\W]+>)[^>]*|#([\\w-]+))$/;(r.fn.init=function(a,b,c){var e,f;if(!a)return this;if(c=c||E,"string"!=typeof a)return a.nodeType?(this[0]=a,this.length=1,this):r.isFunction(a)?void 0!==c.ready?c.ready(a):a(r):r.makeArray(a,this);if(!(e="<"===a[0]&&">"===a[a.length-1]&&3<=a.length?[null,a,null]:F.exec(a))||!e[1]&&b)return!b||b.jquery?(b||c).find(a):this.constructor(b).find(a);if(e[1]){if(b=b instanceof r?b[0]:b,r.merge(this,r.parseHTML(e[1],b&&b.nodeType?b.ownerDocument||b:d,!0)),B.test(e[1])&&r.isPlainObject(b))for(e in b)r.isFunction(this[e])?this[e](b[e]):this.attr(e,b[e]);return this}return(f=d.getElementById(e[2]))&&(this[0]=f,this.length=1),this}).prototype=r.fn,E=r(d);var H=/^(?:parents|prev(?:Until|All))/,I={children:!0,contents:!0,next:!0,prev:!0};function J(a,b){for(;(a=a[b])&&1!==a.nodeType;);return a}r.fn.extend({has:function(a){var b=r(a,this),c=b.length;return this.filter(function(){for(var a=0;a<c;a++)if(r.contains(this,b[a]))return!0})},closest:function(a,b){var c,d=0,e=this.length,f=[],g="string"!=typeof a&&r(a);if(!A.test(a))for(;d<e;d++)for(c=this[d];c&&c!==b;c=c.parentNode)if(c.nodeType<11&&(g?-1<g.index(c):1===c.nodeType&&r.find.matchesSelector(c,a))){f.push(c);break}return this.pushStack(1<f.length?r.uniqueSort(f):f)},index:function(a){return a?"string"==typeof a?i.call(r(a),this[0]):i.call(this,a.jquery?a[0]:a):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(a,b){return this.pushStack(r.uniqueSort(r.merge(this.get(),r(a,b))))},addBack:function(a){return this.add(null==a?this.prevObject:this.prevObject.filter(a))}}),r.each({parent:function(a){var b=a.parentNode;return b&&11!==b.nodeType?b:null},parents:function(a){return y(a,"parentNode")},parentsUntil:function(a,b,c){return y(a,"parentNode",c)},next:function(a){return J(a,"nextSibling")},prev:function(a){return J(a,"previousSibling")},nextAll:function(a){return y(a,"nextSibling")},prevAll:function(a){return y(a,"previousSibling")},nextUntil:function(a,b,c){return y(a,"nextSibling",c)},prevUntil:function(a,b,c){return y(a,"previousSibling",c)},siblings:function(a){return z((a.parentNode||{}).firstChild,a)},children:function(a){return z(a.firstChild)},contents:function(a){return a.contentDocument||r.merge([],a.childNodes)}},function(a,b){r.fn[a]=function(c,d){var e=r.map(this,b,c);return"Until"!==a.slice(-5)&&(d=c),d&&"string"==typeof d&&(e=r.filter(d,e)),1<this.length&&(I[a]||r.uniqueSort(e),H.test(a)&&e.reverse()),this.pushStack(e)}});var K=/[^\\x20\\t\\r\\n\\f]+/g;function M(a){return a}function N(a){throw a}function O(a,b,c){var d;try{a&&r.isFunction(d=a.promise)?d.call(a).done(b).fail(c):a&&r.isFunction(d=a.then)?d.call(a,b,c):b.call(void 0,a)}catch(a){c.call(void 0,a)}}r.Callbacks=function(a){a="string"==typeof a?function(a){var b={};return r.each(a.match(K)||[],function(a,c){b[c]=!0}),b}(a):r.extend({},a);function i(){for(e=a.once,d=b=!0;g.length;h=-1)for(c=g.shift();++h<f.length;)!1===f[h].apply(c[0],c[1])&&a.stopOnFalse&&(h=f.length,c=!1);a.memory||(c=!1),b=!1,e&&(f=c?[]:"")}var b,c,d,e,f=[],g=[],h=-1,j={add:function(){return f&&(c&&!b&&(h=f.length-1,g.push(c)),function d(b){r.each(b,function(b,c){r.isFunction(c)?a.unique&&j.has(c)||f.push(c):c&&c.length&&"string"!==r.type(c)&&d(c)})}(arguments),c&&!b&&i()),this},remove:function(){return r.each(arguments,function(a,b){for(var c;-1<(c=r.inArray(b,f,c));)f.splice(c,1),c<=h&&h--}),this},has:function(a){return a?-1<r.inArray(a,f):0<f.length},empty:function(){return f=f&&[],this},disable:function(){return e=g=[],f=c="",this},disabled:function(){return!f},lock:function(){return e=g=[],c||b||(f=c=""),this},locked:function(){return!!e},fireWith:function(a,c){return e||(c=[a,(c=c||[]).slice?c.slice():c],g.push(c),b||i()),this},fire:function(){return j.fireWith(this,arguments),this},fired:function(){return!!d}};return j},r.extend({Deferred:function(b){var c=[["notify","progress",r.Callbacks("memory"),r.Callbacks("memory"),2],["resolve","done",r.Callbacks("once memory"),r.Callbacks("once memory"),0,"resolved"],["reject","fail",r.Callbacks("once memory"),r.Callbacks("once memory"),1,"rejected"]],d="pending",e={state:function(){return d},always:function(){return f.done(arguments).fail(arguments),this},catch:function(a){return e.then(null,a)},pipe:function(){var a=arguments;return r.Deferred(function(b){r.each(c,function(c,d){var e=r.isFunction(a[d[4]])&&a[d[4]];f[d[1]](function(){var a=e&&e.apply(this,arguments);a&&r.isFunction(a.promise)?a.promise().progress(b.notify).done(b.resolve).fail(b.reject):b[d[0]+"With"](this,e?[a]:arguments)})}),a=null}).promise()},then:function(b,d,e){var f=0;function g(b,c,d,e){return function(){var h=this,i=arguments,j=function(){var a,j;if(!(b<f)){if((a=d.apply(h,i))===c.promise())throw new TypeError("Thenable self-resolution");j=a&&("object"==typeof a||"function"==typeof a)&&a.then,r.isFunction(j)?e?j.call(a,g(f,c,M,e),g(f,c,N,e)):(f++,j.call(a,g(f,c,M,e),g(f,c,N,e),g(f,c,M,c.notifyWith))):(d!==M&&(h=void 0,i=[a]),(e||c.resolveWith)(h,i))}},k=e?j:function(){try{j()}catch(a){r.Deferred.exceptionHook&&r.Deferred.exceptionHook(a,k.stackTrace),f<=b+1&&(d!==N&&(h=void 0,i=[a]),c.rejectWith(h,i))}};b?k():(r.Deferred.getStackHook&&(k.stackTrace=r.Deferred.getStackHook()),a.setTimeout(k))}}return r.Deferred(function(a){c[0][3].add(g(0,a,r.isFunction(e)?e:M,a.notifyWith)),c[1][3].add(g(0,a,r.isFunction(b)?b:M)),c[2][3].add(g(0,a,r.isFunction(d)?d:N))}).promise()},promise:function(a){return null!=a?r.extend(a,e):e}},f={};return r.each(c,function(a,b){var g=b[2],h=b[5];e[b[1]]=g.add,h&&g.add(function(){d=h},c[3-a][2].disable,c[0][2].lock),g.add(b[3].fire),f[b[0]]=function(){return f[b[0]+"With"](this===f?void 0:this,arguments),this},f[b[0]+"With"]=g.fireWith}),e.promise(f),b&&b.call(f,f),f},when:function(a){function h(a){return function(c){d[a]=this,e[a]=1<arguments.length?f.call(arguments):c,--b||g.resolveWith(d,e)}}var b=arguments.length,c=b,d=Array(c),e=f.call(arguments),g=r.Deferred();if(b<=1&&(O(a,g.done(h(c)).resolve,g.reject),"pending"===g.state()||r.isFunction(e[c]&&e[c].then)))return g.then();for(;c--;)O(e[c],h(c),g.reject);return g.promise()}});var P=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;r.Deferred.exceptionHook=function(b,c){a.console&&a.console.warn&&b&&P.test(b.name)&&a.console.warn("jQuery.Deferred exception: "+b.message,b.stack,c)},r.readyException=function(b){a.setTimeout(function(){throw b})};var Q=r.Deferred();function R(){d.removeEventListener("DOMContentLoaded",R),a.removeEventListener("load",R),r.ready()}r.fn.ready=function(a){return Q.then(a).catch(function(a){r.readyException(a)}),this},r.extend({isReady:!1,readyWait:1,holdReady:function(a){a?r.readyWait++:r.ready(!0)},ready:function(a){(!0===a?--r.readyWait:r.isReady)||((r.isReady=!0)!==a&&0<--r.readyWait||Q.resolveWith(d,[r]))}}),r.ready.then=Q.then,"complete"===d.readyState||"loading"!==d.readyState&&!d.documentElement.doScroll?a.setTimeout(r.ready):(d.addEventListener("DOMContentLoaded",R),a.addEventListener("load",R));function T(a){return 1===a.nodeType||9===a.nodeType||!+a.nodeType}var S=function(a,b,c,d,e,f,g){var h=0,i=a.length,j=null==c;if("object"===r.type(c))for(h in e=!0,c)S(a,b,h,c[h],!0,f,g);else if(void 0!==d&&(e=!0,r.isFunction(d)||(g=!0),j&&(b=g?(b.call(a,d),null):(j=b,function(a,b,c){return j.call(r(a),c)})),b))for(;h<i;h++)b(a[h],c,g?d:d.call(a[h],h,b(a[h],c)));return e?a:j?b.call(a):i?b(a[0],c):f};function U(){this.expando=r.expando+U.uid++}U.uid=1,U.prototype={cache:function(a){var b=a[this.expando];return b||(b={},T(a)&&(a.nodeType?a[this.expando]=b:Object.defineProperty(a,this.expando,{value:b,configurable:!0}))),b},set:function(a,b,c){var d,e=this.cache(a);if("string"==typeof b)e[r.camelCase(b)]=c;else for(d in b)e[r.camelCase(d)]=b[d];return e},get:function(a,b){return void 0===b?this.cache(a):a[this.expando]&&a[this.expando][r.camelCase(b)]},access:function(a,b,c){return void 0===b||b&&"string"==typeof b&&void 0===c?this.get(a,b):(this.set(a,b,c),void 0!==c?c:b)},remove:function(a,b){var c,d=a[this.expando];if(void 0!==d){if(void 0!==b){c=(b=r.isArray(b)?b.map(r.camelCase):(b=r.camelCase(b))in d?[b]:b.match(K)||[]).length;for(;c--;)delete d[b[c]]}void 0!==b&&!r.isEmptyObject(d)||(a.nodeType?a[this.expando]=void 0:delete a[this.expando])}},hasData:function(a){var b=a[this.expando];return void 0!==b&&!r.isEmptyObject(b)}};var V=new U,W=new U,X=/^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/,Y=/[A-Z]/g;function $(a,b,c){var d;if(void 0===c&&1===a.nodeType)if(d="data-"+b.replace(Y,"-$&").toLowerCase(),"string"==typeof(c=a.getAttribute(d))){try{c=function(a){return"true"===a||"false"!==a&&("null"===a?null:a===+a+""?+a:X.test(a)?JSON.parse(a):a)}(c)}catch(e){}W.set(a,b,c)}else c=void 0;return c}r.extend({hasData:function(a){return W.hasData(a)||V.hasData(a)},data:function(a,b,c){return W.access(a,b,c)},removeData:function(a,b){W.remove(a,b)},_data:function(a,b,c){return V.access(a,b,c)},_removeData:function(a,b){V.remove(a,b)}}),r.fn.extend({data:function(a,b){var c,d,e,f=this[0],g=f&&f.attributes;if(void 0!==a)return"object"==typeof a?this.each(function(){W.set(this,a)}):S(this,function(b){var c;if(f&&void 0===b){if(void 0!==(c=W.get(f,a)))return c;if(void 0!==(c=$(f,a)))return c}else this.each(function(){W.set(this,a,b)})},null,b,1<arguments.length,null,!0);if(this.length&&(e=W.get(f),1===f.nodeType&&!V.get(f,"hasDataAttrs"))){for(c=g.length;c--;)g[c]&&((d=g[c].name).indexOf("data-")||(d=r.camelCase(d.slice(5)),$(f,d,e[d])));V.set(f,"hasDataAttrs",!0)}return e},removeData:function(a){return this.each(function(){W.remove(this,a)})}}),r.extend({queue:function(a,b,c){var d;if(a)return b=(b||"fx")+"queue",d=V.get(a,b),c&&(!d||r.isArray(c)?d=V.access(a,b,r.makeArray(c)):d.push(c)),d||[]},dequeue:function(a,b){b=b||"fx";var c=r.queue(a,b),d=c.length,e=c.shift(),f=r._queueHooks(a,b);"inprogress"===e&&(e=c.shift(),d--),e&&("fx"===b&&c.unshift("inprogress"),delete f.stop,e.call(a,function(){r.dequeue(a,b)},f)),!d&&f&&f.empty.fire()},_queueHooks:function(a,b){var c=b+"queueHooks";return V.get(a,c)||V.access(a,c,{empty:r.Callbacks("once memory").add(function(){V.remove(a,[b+"queue",c])})})}}),r.fn.extend({queue:function(a,b){var c=2;return"string"!=typeof a&&(b=a,a="fx",c--),arguments.length<c?r.queue(this[0],a):void 0===b?this:this.each(function(){var c=r.queue(this,a,b);r._queueHooks(this,a),"fx"===a&&"inprogress"!==c[0]&&r.dequeue(this,a)})},dequeue:function(a){return this.each(function(){r.dequeue(this,a)})},clearQueue:function(a){return this.queue(a||"fx",[])},promise:function(a,b){function h(){--d||e.resolveWith(f,[f])}var c,d=1,e=r.Deferred(),f=this,g=this.length;for("string"!=typeof a&&(b=a,a=void 0),a=a||"fx";g--;)(c=V.get(f[g],a+"queueHooks"))&&c.empty&&(d++,c.empty.add(h));return h(),e.promise(b)}});function da(a,b,c,d){var e,f,g={};for(f in b)g[f]=a.style[f],a.style[f]=b[f];for(f in e=c.apply(a,d||[]),b)a.style[f]=g[f];return e}var _="[+-]?(?:\\\\d*\\\\.|)\\\\d+(?:[eE][+-]?\\\\d+|)",aa=RegExp("^(?:([+-])=|)("+_+")([a-z%]*)$","i"),ba=["Top","Right","Bottom","Left"],ca=function(a,b){return"none"===(a=b||a).style.display||""===a.style.display&&r.contains(a.ownerDocument,a)&&"none"===r.css(a,"display")};function ea(a,b,c,d){var e,f=1,g=20,h=d?function(){return d.cur()}:function(){return r.css(a,b,"")},i=h(),j=c&&c[3]||(r.cssNumber[b]?"":"px"),k=(r.cssNumber[b]||"px"!==j&&+i)&&aa.exec(r.css(a,b));if(k&&k[3]!==j)for(j=j||k[3],c=c||[],k=+i||1;k/=f=f||".5",r.style(a,b,k+j),f!==(f=h()/i)&&1!==f&&--g;);return c&&(k=+k||+i||0,e=c[1]?k+(c[1]+1)*c[2]:+c[2],d&&(d.unit=j,d.start=k,d.end=e)),e}var fa={};function ha(a,b){for(var c,d,e=[],f=0,g=a.length;f<g;f++)(d=a[f]).style&&(c=d.style.display,b?("none"===c&&(e[f]=V.get(d,"display")||null,e[f]||(d.style.display="")),""===d.style.display&&ca(d)&&(e[f]=function(a){var b,c=a.ownerDocument,d=a.nodeName,e=fa[d];return e||(b=c.body.appendChild(c.createElement(d)),e=r.css(b,"display"),b.parentNode.removeChild(b),"none"===e&&(e="block"),fa[d]=e)}(d))):"none"!==c&&(e[f]="none",V.set(d,"display",c)));for(f=0;f<g;f++)null!=e[f]&&(a[f].style.display=e[f]);return a}r.fn.extend({show:function(){return ha(this,!0)},hide:function(){return ha(this)},toggle:function(a){return"boolean"==typeof a?a?this.show():this.hide():this.each(function(){ca(this)?r(this).show():r(this).hide()})}});var ia=/^(?:checkbox|radio)$/i,ja=/<([a-z][^\\/\\0>\\x20\\t\\r\\n\\f]+)/i,ka=/^$|\\/(?:java|ecma)script/i,la={option:[1,"<select multiple=\'multiple\'>","</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ma(a,b){var c=void 0!==a.getElementsByTagName?a.getElementsByTagName(b||"*"):void 0!==a.querySelectorAll?a.querySelectorAll(b||"*"):[];return void 0===b||b&&r.nodeName(a,b)?r.merge([a],c):c}function na(a,b){for(var c=0,d=a.length;c<d;c++)V.set(a[c],"globalEval",!b||V.get(b[c],"globalEval"))}la.optgroup=la.option,la.tbody=la.tfoot=la.colgroup=la.caption=la.thead,la.th=la.td;var oa=/<|&#?\\w+;/;function pa(a,b,c,d,e){for(var f,g,h,i,j,k,l=b.createDocumentFragment(),m=[],n=0,o=a.length;n<o;n++)if((f=a[n])||0===f)if("object"===r.type(f))r.merge(m,f.nodeType?[f]:f);else if(oa.test(f)){for(g=g||l.appendChild(b.createElement("div")),h=(ja.exec(f)||["",""])[1].toLowerCase(),i=la[h]||la._default,g.innerHTML=i[1]+r.htmlPrefilter(f)+i[2],k=i[0];k--;)g=g.lastChild;r.merge(m,g.childNodes),(g=l.firstChild).textContent=""}else m.push(b.createTextNode(f));for(l.textContent="",n=0;f=m[n++];)if(d&&-1<r.inArray(f,d))e&&e.push(f);else if(j=r.contains(f.ownerDocument,f),g=ma(l.appendChild(f),"script"),j&&na(g),c)for(k=0;f=g[k++];)ka.test(f.type||"")&&c.push(f);return l}!function(){var b=d.createDocumentFragment().appendChild(d.createElement("div")),c=d.createElement("input");c.setAttribute("type","radio"),c.setAttribute("checked","checked"),c.setAttribute("name","t"),b.appendChild(c),o.checkClone=b.cloneNode(!0).cloneNode(!0).lastChild.checked,b.innerHTML="<textarea>x</textarea>",o.noCloneChecked=!!b.cloneNode(!0).lastChild.defaultValue}();var qa=d.documentElement,ra=/^key/,sa=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,ta=/^([^.]*)(?:\\.(.+)|)/;function ua(){return!0}function va(){return!1}function wa(){try{return d.activeElement}catch(a){}}function xa(a,b,c,d,e,f){var g,h;if("object"==typeof b){for(h in"string"!=typeof c&&(d=d||c,c=void 0),b)xa(a,h,c,d,b[h],f);return a}if(null==d&&null==e?(e=c,d=c=void 0):null==e&&("string"==typeof c?(e=d,d=void 0):(e=d,d=c,c=void 0)),!1===e)e=va;else if(!e)return a;return 1===f&&(g=e,(e=function(a){return r().off(a),g.apply(this,arguments)}).guid=g.guid||(g.guid=r.guid++)),a.each(function(){r.event.add(this,b,e,d,c)})}r.event={global:{},add:function(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q=V.get(a);if(q)for(c.handler&&(c=(f=c).handler,e=f.selector),e&&r.find.matchesSelector(qa,e),c.guid||(c.guid=r.guid++),(i=q.events)||(i=q.events={}),(g=q.handle)||(g=q.handle=function(b){return void 0!==r&&r.event.triggered!==b.type?r.event.dispatch.apply(a,arguments):void 0}),j=(b=(b||"").match(K)||[""]).length;j--;)n=p=(h=ta.exec(b[j])||[])[1],o=(h[2]||"").split(".").sort(),n&&(l=r.event.special[n]||{},n=(e?l.delegateType:l.bindType)||n,l=r.event.special[n]||{},k=r.extend({type:n,origType:p,data:d,handler:c,guid:c.guid,selector:e,needsContext:e&&r.expr.match.needsContext.test(e),namespace:o.join(".")},f),(m=i[n])||((m=i[n]=[]).delegateCount=0,l.setup&&!1!==l.setup.call(a,d,o,g)||a.addEventListener&&a.addEventListener(n,g)),l.add&&(l.add.call(a,k),k.handler.guid||(k.handler.guid=c.guid)),e?m.splice(m.delegateCount++,0,k):m.push(k),r.event.global[n]=!0)},remove:function(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q=V.hasData(a)&&V.get(a);if(q&&(i=q.events)){for(j=(b=(b||"").match(K)||[""]).length;j--;)if(n=p=(h=ta.exec(b[j])||[])[1],o=(h[2]||"").split(".").sort(),n){for(l=r.event.special[n]||{},m=i[n=(d?l.delegateType:l.bindType)||n]||[],h=h[2]&&RegExp("(^|\\\\.)"+o.join("\\\\.(?:.*\\\\.|)")+"(\\\\.|$)"),g=f=m.length;f--;)k=m[f],!e&&p!==k.origType||c&&c.guid!==k.guid||h&&!h.test(k.namespace)||d&&d!==k.selector&&("**"!==d||!k.selector)||(m.splice(f,1),k.selector&&m.delegateCount--,l.remove&&l.remove.call(a,k));g&&!m.length&&(l.teardown&&!1!==l.teardown.call(a,o,q.handle)||r.removeEvent(a,n,q.handle),delete i[n])}else for(n in i)r.event.remove(a,n+b[j],c,d,!0);r.isEmptyObject(i)&&V.remove(a,"handle events")}},dispatch:function(a){var c,d,e,f,g,h,b=r.event.fix(a),i=Array(arguments.length),j=(V.get(this,"events")||{})[b.type]||[],k=r.event.special[b.type]||{};for(i[0]=b,c=1;c<arguments.length;c++)i[c]=arguments[c];if(b.delegateTarget=this,!k.preDispatch||!1!==k.preDispatch.call(this,b)){for(h=r.event.handlers.call(this,b,j),c=0;(f=h[c++])&&!b.isPropagationStopped();)for(b.currentTarget=f.elem,d=0;(g=f.handlers[d++])&&!b.isImmediatePropagationStopped();)b.rnamespace&&!b.rnamespace.test(g.namespace)||(b.handleObj=g,b.data=g.data,void 0!==(e=((r.event.special[g.origType]||{}).handle||g.handler).apply(f.elem,i))&&!1===(b.result=e)&&(b.preventDefault(),b.stopPropagation()));return k.postDispatch&&k.postDispatch.call(this,b),b.result}},handlers:function(a,b){var c,d,e,f,g,h=[],i=b.delegateCount,j=a.target;if(i&&j.nodeType&&!("click"===a.type&&1<=a.button))for(;j!==this;j=j.parentNode||this)if(1===j.nodeType&&("click"!==a.type||!0!==j.disabled)){for(f=[],g={},c=0;c<i;c++)void 0===g[e=(d=b[c]).selector+" "]&&(g[e]=d.needsContext?-1<r(e,this).index(j):r.find(e,this,null,[j]).length),g[e]&&f.push(d);f.length&&h.push({elem:j,handlers:f})}return j=this,i<b.length&&h.push({elem:j,handlers:b.slice(i)}),h},addProp:function(a,b){Object.defineProperty(r.Event.prototype,a,{enumerable:!0,configurable:!0,get:r.isFunction(b)?function(){if(this.originalEvent)return b(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[a]},set:function(b){Object.defineProperty(this,a,{enumerable:!0,configurable:!0,writable:!0,value:b})}})},fix:function(a){return a[r.expando]?a:new r.Event(a)},special:{load:{noBubble:!0},focus:{trigger:function(){if(this!==wa()&&this.focus)return this.focus(),!1},delegateType:"focusin"},blur:{trigger:function(){if(this===wa()&&this.blur)return this.blur(),!1},delegateType:"focusout"},click:{trigger:function(){if("checkbox"===this.type&&this.click&&r.nodeName(this,"input"))return this.click(),!1},_default:function(a){return r.nodeName(a.target,"a")}},beforeunload:{postDispatch:function(a){void 0!==a.result&&a.originalEvent&&(a.originalEvent.returnValue=a.result)}}}},r.removeEvent=function(a,b,c){a.removeEventListener&&a.removeEventListener(b,c)},r.Event=function(a,b){return this instanceof r.Event?(a&&a.type?(this.originalEvent=a,this.type=a.type,this.isDefaultPrevented=a.defaultPrevented||void 0===a.defaultPrevented&&!1===a.returnValue?ua:va,this.target=a.target&&3===a.target.nodeType?a.target.parentNode:a.target,this.currentTarget=a.currentTarget,this.relatedTarget=a.relatedTarget):this.type=a,b&&r.extend(this,b),this.timeStamp=a&&a.timeStamp||r.now(),void(this[r.expando]=!0)):new r.Event(a,b)},r.Event.prototype={constructor:r.Event,isDefaultPrevented:va,isPropagationStopped:va,isImmediatePropagationStopped:va,isSimulated:!1,preventDefault:function(){var a=this.originalEvent;this.isDefaultPrevented=ua,a&&!this.isSimulated&&a.preventDefault()},stopPropagation:function(){var a=this.originalEvent;this.isPropagationStopped=ua,a&&!this.isSimulated&&a.stopPropagation()},stopImmediatePropagation:function(){var a=this.originalEvent;this.isImmediatePropagationStopped=ua,a&&!this.isSimulated&&a.stopImmediatePropagation(),this.stopPropagation()}},r.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,char:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(a){var b=a.button;return null==a.which&&ra.test(a.type)?null!=a.charCode?a.charCode:a.keyCode:!a.which&&void 0!==b&&sa.test(a.type)?1&b?1:2&b?3:4&b?2:0:a.which}},r.event.addProp),r.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(a,b){r.event.special[a]={delegateType:b,bindType:b,handle:function(a){var c,e=a.relatedTarget,f=a.handleObj;return e&&(e===this||r.contains(this,e))||(a.type=f.origType,c=f.handler.apply(this,arguments),a.type=b),c}}}),r.fn.extend({on:function(a,b,c,d){return xa(this,a,b,c,d)},one:function(a,b,c,d){return xa(this,a,b,c,d,1)},off:function(a,b,c){var d,e;if(a&&a.preventDefault&&a.handleObj)return d=a.handleObj,r(a.delegateTarget).off(d.namespace?d.origType+"."+d.namespace:d.origType,d.selector,d.handler),this;if("object"!=typeof a)return!1!==b&&"function"!=typeof b||(c=b,b=void 0),!1===c&&(c=va),this.each(function(){r.event.remove(this,a,c,b)});for(e in a)this.off(e,b,a[e]);return this}});var ya=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\\/\\0>\\x20\\t\\r\\n\\f]*)[^>]*)\\/>/gi,za=/<script|<style|<link/i,Aa=/checked\\s*(?:[^=]|=\\s*.checked.)/i,Ba=/^true\\/(.*)/,Ca=/^\\s*<!(?:\\[CDATA\\[|--)|(?:\\]\\]|--)>\\s*$/g;function Da(a,b){return r.nodeName(a,"table")&&r.nodeName(11!==b.nodeType?b:b.firstChild,"tr")&&a.getElementsByTagName("tbody")[0]||a}function Ea(a){return a.type=(null!==a.getAttribute("type"))+"/"+a.type,a}function Fa(a){var b=Ba.exec(a.type);return b?a.type=b[1]:a.removeAttribute("type"),a}function Ga(a,b){var c,d,e,f,g,h,i,j;if(1===b.nodeType){if(V.hasData(a)&&(f=V.access(a),g=V.set(b,f),j=f.events))for(e in delete g.handle,g.events={},j)for(c=0,d=j[e].length;c<d;c++)r.event.add(b,e,j[e][c]);W.hasData(a)&&(h=W.access(a),i=r.extend({},h),W.set(b,i))}}function Ia(a,b,c,d){b=g.apply([],b);var e,f,h,i,j,k,l=0,m=a.length,n=m-1,q=b[0],s=r.isFunction(q);if(s||1<m&&"string"==typeof q&&!o.checkClone&&Aa.test(q))return a.each(function(e){var f=a.eq(e);s&&(b[0]=q.call(this,e,f.html())),Ia(f,b,c,d)});if(m&&(f=(e=pa(b,a[0].ownerDocument,!1,a,d)).firstChild,1===e.childNodes.length&&(e=f),f||d)){for(i=(h=r.map(ma(e,"script"),Ea)).length;l<m;l++)j=e,l!==n&&(j=r.clone(j,!0,!0),i&&r.merge(h,ma(j,"script"))),c.call(a[l],j,l);if(i)for(k=h[h.length-1].ownerDocument,r.map(h,Fa),l=0;l<i;l++)j=h[l],ka.test(j.type||"")&&!V.access(j,"globalEval")&&r.contains(k,j)&&(j.src?r._evalUrl&&r._evalUrl(j.src):p(j.textContent.replace(Ca,""),k))}return a}function Ja(a,b,c){for(var d,e=b?r.filter(b,a):a,f=0;null!=(d=e[f]);f++)c||1!==d.nodeType||r.cleanData(ma(d)),d.parentNode&&(c&&r.contains(d.ownerDocument,d)&&na(ma(d,"script")),d.parentNode.removeChild(d));return a}r.extend({htmlPrefilter:function(a){return a.replace(ya,"<$1></$2>")},clone:function(a,b,c){var d,e,f,g,h=a.cloneNode(!0),i=r.contains(a.ownerDocument,a);if(!(o.noCloneChecked||1!==a.nodeType&&11!==a.nodeType||r.isXMLDoc(a)))for(g=ma(h),d=0,e=(f=ma(a)).length;d<e;d++)!function(a,b){var c=b.nodeName.toLowerCase();"input"==c&&ia.test(a.type)?b.checked=a.checked:"input"!=c&&"textarea"!=c||(b.defaultValue=a.defaultValue)}(f[d],g[d]);if(b)if(c)for(f=f||ma(a),g=g||ma(h),d=0,e=f.length;d<e;d++)Ga(f[d],g[d]);else Ga(a,h);return 0<(g=ma(h,"script")).length&&na(g,!i&&ma(a,"script")),h},cleanData:function(a){for(var b,c,d,e=r.event.special,f=0;void 0!==(c=a[f]);f++)if(T(c)){if(b=c[V.expando]){if(b.events)for(d in b.events)e[d]?r.event.remove(c,d):r.removeEvent(c,d,b.handle);c[V.expando]=void 0}c[W.expando]&&(c[W.expando]=void 0)}}}),r.fn.extend({detach:function(a){return Ja(this,a,!0)},remove:function(a){return Ja(this,a)},text:function(a){return S(this,function(a){return void 0===a?r.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=a)})},null,a,arguments.length)},append:function(){return Ia(this,arguments,function(a){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||Da(this,a).appendChild(a)})},prepend:function(){return Ia(this,arguments,function(a){var b;1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(b=Da(this,a)).insertBefore(a,b.firstChild)})},before:function(){return Ia(this,arguments,function(a){this.parentNode&&this.parentNode.insertBefore(a,this)})},after:function(){return Ia(this,arguments,function(a){this.parentNode&&this.parentNode.insertBefore(a,this.nextSibling)})},empty:function(){for(var a,b=0;null!=(a=this[b]);b++)1===a.nodeType&&(r.cleanData(ma(a,!1)),a.textContent="");return this},clone:function(a,b){return a=null!=a&&a,b=null==b?a:b,this.map(function(){return r.clone(this,a,b)})},html:function(a){return S(this,function(a){var b=this[0]||{},c=0,d=this.length;if(void 0===a&&1===b.nodeType)return b.innerHTML;if("string"==typeof a&&!za.test(a)&&!la[(ja.exec(a)||["",""])[1].toLowerCase()]){a=r.htmlPrefilter(a);try{for(;c<d;c++)1===(b=this[c]||{}).nodeType&&(r.cleanData(ma(b,!1)),b.innerHTML=a);b=0}catch(e){}}b&&this.empty().append(a)},null,a,arguments.length)},replaceWith:function(){var a=[];return Ia(this,arguments,function(b){var c=this.parentNode;r.inArray(this,a)<0&&(r.cleanData(ma(this)),c&&c.replaceChild(b,this))},a)}}),r.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(a,b){r.fn[a]=function(a){for(var c,d=[],e=r(a),f=e.length-1,g=0;g<=f;g++)c=g===f?this:this.clone(!0),r(e[g])[b](c),h.apply(d,c.get());return this.pushStack(d)}});var Ka=/^margin/,La=RegExp("^("+_+")(?!px)[a-z%]+$","i"),Ma=function(b){var c=b.ownerDocument.defaultView;return c&&c.opener||(c=a),c.getComputedStyle(b)};function Na(a,b,c){var d,e,f,g,h=a.style;return(c=c||Ma(a))&&(""!==(g=c.getPropertyValue(b)||c[b])||r.contains(a.ownerDocument,a)||(g=r.style(a,b)),!o.pixelMarginRight()&&La.test(g)&&Ka.test(b)&&(d=h.width,e=h.minWidth,f=h.maxWidth,h.minWidth=h.maxWidth=h.width=g,g=c.width,h.width=d,h.minWidth=e,h.maxWidth=f)),void 0!==g?g+"":g}function Oa(a,b){return{get:function(){return a()?void delete this.get:(this.get=b).apply(this,arguments)}}}!function(){function b(){var b;i&&(i.style.cssText="box-sizing:border-box;position:relative;display:block;margin:auto;border:1px;padding:1px;top:1%;width:50%",i.innerHTML="",qa.appendChild(h),b=a.getComputedStyle(i),c="1%"!==b.top,g="2px"===b.marginLeft,e="4px"===b.width,i.style.marginRight="50%",f="4px"===b.marginRight,qa.removeChild(h),i=null)}var c,e,f,g,h=d.createElement("div"),i=d.createElement("div");i.style&&(i.style.backgroundClip="content-box",i.cloneNode(!0).style.backgroundClip="",o.clearCloneStyle="content-box"===i.style.backgroundClip,h.style.cssText="border:0;width:8px;height:0;top:0;left:-9999px;padding:0;margin-top:1px;position:absolute",h.appendChild(i),r.extend(o,{pixelPosition:function(){return b(),c},boxSizingReliable:function(){return b(),e},pixelMarginRight:function(){return b(),f},reliableMarginLeft:function(){return b(),g}}))}();var Pa=/^(none|table(?!-c[ea]).+)/,Qa={position:"absolute",visibility:"hidden",display:"block"},Ra={letterSpacing:"0",fontWeight:"400"},Sa=["Webkit","Moz","ms"],Ta=d.createElement("div").style;function Ua(a){if(a in Ta)return a;for(var b=a[0].toUpperCase()+a.slice(1),c=3;c--;)if((a=Sa[c]+b)in Ta)return a}function Va(a,b,c){var d=aa.exec(b);return d?Math.max(0,d[2]-(c||0))+(d[3]||"px"):b}function Wa(a,b,c,d,e){for(var g=0,f=c===(d?"border":"content")?4:"width"===b?1:0;f<4;f+=2)"margin"===c&&(g+=r.css(a,c+ba[f],!0,e)),d?("content"===c&&(g-=r.css(a,"padding"+ba[f],!0,e)),"margin"!==c&&(g-=r.css(a,"border"+ba[f]+"Width",!0,e))):(g+=r.css(a,"padding"+ba[f],!0,e),"padding"!==c&&(g+=r.css(a,"border"+ba[f]+"Width",!0,e)));return g}function Xa(a,b,c){var d,e=!0,f=Ma(a),g="border-box"===r.css(a,"boxSizing",!1,f);if(a.getClientRects().length&&(d=a.getBoundingClientRect()[b]),d<=0||null==d){if(((d=Na(a,b,f))<0||null==d)&&(d=a.style[b]),La.test(d))return d;e=g&&(o.boxSizingReliable()||d===a.style[b]),d=parseFloat(d)||0}return d+Wa(a,b,c||(g?"border":"content"),e,f)+"px"}function Ya(a,b,c,d,e){return new Ya.prototype.init(a,b,c,d,e)}r.extend({cssHooks:{opacity:{get:function(a,b){if(b){var c=Na(a,"opacity");return""===c?"1":c}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{float:"cssFloat"},style:function(a,b,c,d){if(a&&3!==a.nodeType&&8!==a.nodeType&&a.style){var e,f,g,h=r.camelCase(b),i=a.style;return b=r.cssProps[h]||(r.cssProps[h]=Ua(h)||h),g=r.cssHooks[b]||r.cssHooks[h],void 0===c?g&&"get"in g&&void 0!==(e=g.get(a,!1,d))?e:i[b]:("string"===(f=typeof c)&&(e=aa.exec(c))&&e[1]&&(c=ea(a,b,e),f="number"),void(null!=c&&c==c&&("number"===f&&(c+=e&&e[3]||(r.cssNumber[h]?"":"px")),o.clearCloneStyle||""!==c||b.indexOf("background")||(i[b]="inherit"),g&&"set"in g&&void 0===(c=g.set(a,c,d))||(i[b]=c))))}},css:function(a,b,c,d){var e,f,g,h=r.camelCase(b);return b=r.cssProps[h]||(r.cssProps[h]=Ua(h)||h),(g=r.cssHooks[b]||r.cssHooks[h])&&"get"in g&&(e=g.get(a,!0,c)),void 0===e&&(e=Na(a,b,d)),"normal"===e&&b in Ra&&(e=Ra[b]),""===c||c?(f=parseFloat(e),!0===c||isFinite(f)?f||0:e):e}}),r.each(["height","width"],function(a,b){r.cssHooks[b]={get:function(a,c,d){if(c)return!Pa.test(r.css(a,"display"))||a.getClientRects().length&&a.getBoundingClientRect().width?Xa(a,b,d):da(a,Qa,function(){return Xa(a,b,d)})},set:function(a,c,d){var e,f=d&&Ma(a),g=d&&Wa(a,b,d,"border-box"===r.css(a,"boxSizing",!1,f),f);return g&&(e=aa.exec(c))&&"px"!==(e[3]||"px")&&(a.style[b]=c,c=r.css(a,b)),Va(0,c,g)}}}),r.cssHooks.marginLeft=Oa(o.reliableMarginLeft,function(a,b){if(b)return(parseFloat(Na(a,"marginLeft"))||a.getBoundingClientRect().left-da(a,{marginLeft:0},function(){return a.getBoundingClientRect().left}))+"px"}),r.each({margin:"",padding:"",border:"Width"},function(a,b){r.cssHooks[a+b]={expand:function(c){for(var d=0,e={},f="string"==typeof c?c.split(" "):[c];d<4;d++)e[a+ba[d]+b]=f[d]||f[d-2]||f[0];return e}},Ka.test(a)||(r.cssHooks[a+b].set=Va)}),r.fn.extend({css:function(a,b){return S(this,function(a,b,c){var d,e,f={},g=0;if(r.isArray(b)){for(d=Ma(a),e=b.length;g<e;g++)f[b[g]]=r.css(a,b[g],!1,d);return f}return void 0!==c?r.style(a,b,c):r.css(a,b)},a,b,1<arguments.length)}}),(r.Tween=Ya).prototype={constructor:Ya,init:function(a,b,c,d,e,f){this.elem=a,this.prop=c,this.easing=e||r.easing._default,this.options=b,this.start=this.now=this.cur(),this.end=d,this.unit=f||(r.cssNumber[c]?"":"px")},cur:function(){var a=Ya.propHooks[this.prop];return a&&a.get?a.get(this):Ya.propHooks._default.get(this)},run:function(a){var b,c=Ya.propHooks[this.prop];return this.options.duration?this.pos=b=r.easing[this.easing](a,this.options.duration*a,0,1,this.options.duration):this.pos=b=a,this.now=(this.end-this.start)*b+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),c&&c.set?c.set(this):Ya.propHooks._default.set(this),this}},Ya.prototype.init.prototype=Ya.prototype,Ya.propHooks={_default:{get:function(a){var b;return 1!==a.elem.nodeType||null!=a.elem[a.prop]&&null==a.elem.style[a.prop]?a.elem[a.prop]:(b=r.css(a.elem,a.prop,""))&&"auto"!==b?b:0},set:function(a){r.fx.step[a.prop]?r.fx.step[a.prop](a):1!==a.elem.nodeType||null==a.elem.style[r.cssProps[a.prop]]&&!r.cssHooks[a.prop]?a.elem[a.prop]=a.now:r.style(a.elem,a.prop,a.now+a.unit)}}},Ya.propHooks.scrollTop=Ya.propHooks.scrollLeft={set:function(a){a.elem.nodeType&&a.elem.parentNode&&(a.elem[a.prop]=a.now)}},r.easing={linear:function(a){return a},swing:function(a){return.5-Math.cos(a*Math.PI)/2},_default:"swing"},r.fx=Ya.prototype.init,r.fx.step={};var Za,$a,_a=/^(?:toggle|show|hide)$/,ab=/queueHooks$/;function bb(){$a&&(a.requestAnimationFrame(bb),r.fx.tick())}function cb(){return a.setTimeout(function(){Za=void 0}),Za=r.now()}function db(a,b){var c,d=0,e={height:a};for(b=b?1:0;d<4;d+=2-b)e["margin"+(c=ba[d])]=e["padding"+c]=a;return b&&(e.opacity=e.width=a),e}function eb(a,b,c){for(var d,e=(hb.tweeners[b]||[]).concat(hb.tweeners["*"]),f=0,g=e.length;f<g;f++)if(d=e[f].call(c,b,a))return d}function hb(a,b,c){var d,e,f=0,g=hb.prefilters.length,h=r.Deferred().always(function(){delete i.elem}),i=function(){if(e)return!1;for(var b=Za||cb(),c=Math.max(0,j.startTime+j.duration-b),f=1-(c/j.duration||0),g=0,i=j.tweens.length;g<i;g++)j.tweens[g].run(f);return h.notifyWith(a,[j,f,c]),f<1&&i?c:(h.resolveWith(a,[j]),!1)},j=h.promise({elem:a,props:r.extend({},b),opts:r.extend(!0,{specialEasing:{},easing:r.easing._default},c),originalProperties:b,originalOptions:c,startTime:Za||cb(),duration:c.duration,tweens:[],createTween:function(b,c){var d=r.Tween(a,j.opts,b,c,j.opts.specialEasing[b]||j.opts.easing);return j.tweens.push(d),d},stop:function(b){var c=0,d=b?j.tweens.length:0;if(e)return this;for(e=!0;c<d;c++)j.tweens[c].run(1);return b?(h.notifyWith(a,[j,1,0]),h.resolveWith(a,[j,b])):h.rejectWith(a,[j,b]),this}}),k=j.props;for(function(a,b){var c,d,e,f,g;for(c in a)if(e=b[d=r.camelCase(c)],f=a[c],r.isArray(f)&&(e=f[1],f=a[c]=f[0]),c!==d&&(a[d]=f,delete a[c]),(g=r.cssHooks[d])&&"expand"in g)for(c in f=g.expand(f),delete a[d],f)c in a||(a[c]=f[c],b[c]=e);else b[d]=e}(k,j.opts.specialEasing);f<g;f++)if(d=hb.prefilters[f].call(j,a,k,j.opts))return r.isFunction(d.stop)&&(r._queueHooks(j.elem,j.opts.queue).stop=r.proxy(d.stop,d)),d;return r.map(k,eb,j),r.isFunction(j.opts.start)&&j.opts.start.call(a,j),r.fx.timer(r.extend(i,{elem:a,anim:j,queue:j.opts.queue})),j.progress(j.opts.progress).done(j.opts.done,j.opts.complete).fail(j.opts.fail).always(j.opts.always)}r.Animation=r.extend(hb,{tweeners:{"*":[function(a,b){var c=this.createTween(a,b);return ea(c.elem,a,aa.exec(b),c),c}]},tweener:function(a,b){for(var c,d=0,e=(a=r.isFunction(a)?(b=a,["*"]):a.match(K)).length;d<e;d++)c=a[d],hb.tweeners[c]=hb.tweeners[c]||[],hb.tweeners[c].unshift(b)},prefilters:[function(a,b,c){var d,e,f,g,h,i,j,k,l="width"in b||"height"in b,m=this,n={},o=a.style,p=a.nodeType&&ca(a),q=V.get(a,"fxshow");for(d in c.queue||(null==(g=r._queueHooks(a,"fx")).unqueued&&(g.unqueued=0,h=g.empty.fire,g.empty.fire=function(){g.unqueued||h()}),g.unqueued++,m.always(function(){m.always(function(){g.unqueued--,r.queue(a,"fx").length||g.empty.fire()})})),b)if(e=b[d],_a.test(e)){if(delete b[d],f=f||"toggle"===e,e===(p?"hide":"show")){if("show"!==e||!q||void 0===q[d])continue;p=!0}n[d]=q&&q[d]||r.style(a,d)}if((i=!r.isEmptyObject(b))||!r.isEmptyObject(n))for(d in l&&1===a.nodeType&&(c.overflow=[o.overflow,o.overflowX,o.overflowY],null==(j=q&&q.display)&&(j=V.get(a,"display")),"none"===(k=r.css(a,"display"))&&(j?k=j:(ha([a],!0),j=a.style.display||j,k=r.css(a,"display"),ha([a]))),("inline"===k||"inline-block"===k&&null!=j)&&"none"===r.css(a,"float")&&(i||(m.done(function(){o.display=j}),null==j&&(k=o.display,j="none"===k?"":k)),o.display="inline-block")),c.overflow&&(o.overflow="hidden",m.always(function(){o.overflow=c.overflow[0],o.overflowX=c.overflow[1],o.overflowY=c.overflow[2]})),i=!1,n)i||(q?"hidden"in q&&(p=q.hidden):q=V.access(a,"fxshow",{display:j}),f&&(q.hidden=!p),p&&ha([a],!0),m.done(function(){for(d in p||ha([a]),V.remove(a,"fxshow"),n)r.style(a,d,n[d])})),i=eb(p?q[d]:0,d,m),d in q||(q[d]=i.start,p&&(i.end=i.start,i.start=0))}],prefilter:function(a,b){b?hb.prefilters.unshift(a):hb.prefilters.push(a)}}),r.speed=function(a,b,c){var e=a&&"object"==typeof a?r.extend({},a):{complete:c||!c&&b||r.isFunction(a)&&a,duration:a,easing:c&&b||b&&!r.isFunction(b)&&b};return r.fx.off||d.hidden?e.duration=0:"number"!=typeof e.duration&&(e.duration in r.fx.speeds?e.duration=r.fx.speeds[e.duration]:e.duration=r.fx.speeds._default),null!=e.queue&&!0!==e.queue||(e.queue="fx"),e.old=e.complete,e.complete=function(){r.isFunction(e.old)&&e.old.call(this),e.queue&&r.dequeue(this,e.queue)},e},r.fn.extend({fadeTo:function(a,b,c,d){return this.filter(ca).css("opacity",0).show().end().animate({opacity:b},a,c,d)},animate:function(a,b,c,d){function g(){var b=hb(this,r.extend({},a),f);(e||V.get(this,"finish"))&&b.stop(!0)}var e=r.isEmptyObject(a),f=r.speed(b,c,d);return g.finish=g,e||!1===f.queue?this.each(g):this.queue(f.queue,g)},stop:function(a,b,c){function d(a){var b=a.stop;delete a.stop,b(c)}return"string"!=typeof a&&(c=b,b=a,a=void 0),b&&!1!==a&&this.queue(a||"fx",[]),this.each(function(){var b=!0,e=null!=a&&a+"queueHooks",f=r.timers,g=V.get(this);if(e)g[e]&&g[e].stop&&d(g[e]);else for(e in g)g[e]&&g[e].stop&&ab.test(e)&&d(g[e]);for(e=f.length;e--;)f[e].elem!==this||null!=a&&f[e].queue!==a||(f[e].anim.stop(c),b=!1,f.splice(e,1));!b&&c||r.dequeue(this,a)})},finish:function(a){return!1!==a&&(a=a||"fx"),this.each(function(){var b,c=V.get(this),d=c[a+"queue"],e=c[a+"queueHooks"],f=r.timers,g=d?d.length:0;for(c.finish=!0,r.queue(this,a,[]),e&&e.stop&&e.stop.call(this,!0),b=f.length;b--;)f[b].elem===this&&f[b].queue===a&&(f[b].anim.stop(!0),f.splice(b,1));for(b=0;b<g;b++)d[b]&&d[b].finish&&d[b].finish.call(this);delete c.finish})}}),r.each(["toggle","show","hide"],function(a,b){var c=r.fn[b];r.fn[b]=function(a,d,e){return null==a||"boolean"==typeof a?c.apply(this,arguments):this.animate(db(b,!0),a,d,e)}}),r.each({slideDown:db("show"),slideUp:db("hide"),slideToggle:db("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(a,b){r.fn[a]=function(a,c,d){return this.animate(b,a,c,d)}}),r.timers=[],r.fx.tick=function(){var a,b=0,c=r.timers;for(Za=r.now();b<c.length;b++)(a=c[b])()||c[b]!==a||c.splice(b--,1);c.length||r.fx.stop(),Za=void 0},r.fx.timer=function(a){r.timers.push(a),a()?r.fx.start():r.timers.pop()},r.fx.interval=13,r.fx.start=function(){$a=$a||(a.requestAnimationFrame?a.requestAnimationFrame(bb):a.setInterval(r.fx.tick,r.fx.interval))},r.fx.stop=function(){a.cancelAnimationFrame?a.cancelAnimationFrame($a):a.clearInterval($a),$a=null},r.fx.speeds={slow:600,fast:200,_default:400},r.fn.delay=function(b,c){return b=r.fx&&r.fx.speeds[b]||b,c=c||"fx",this.queue(c,function(c,d){var e=a.setTimeout(c,b);d.stop=function(){a.clearTimeout(e)}})},function(){var a=d.createElement("input"),c=d.createElement("select").appendChild(d.createElement("option"));a.type="checkbox",o.checkOn=""!==a.value,o.optSelected=c.selected,(a=d.createElement("input")).value="t",a.type="radio",o.radioValue="t"===a.value}();var ib,jb=r.expr.attrHandle;r.fn.extend({attr:function(a,b){return S(this,r.attr,a,b,1<arguments.length)},removeAttr:function(a){return this.each(function(){r.removeAttr(this,a)})}}),r.extend({attr:function(a,b,c){var d,e,f=a.nodeType;if(3!==f&&8!==f&&2!==f)return void 0===a.getAttribute?r.prop(a,b,c):(1===f&&r.isXMLDoc(a)||(e=r.attrHooks[b.toLowerCase()]||(r.expr.match.bool.test(b)?ib:void 0)),void 0!==c?null===c?void r.removeAttr(a,b):e&&"set"in e&&void 0!==(d=e.set(a,c,b))?d:(a.setAttribute(b,c+""),c):e&&"get"in e&&null!==(d=e.get(a,b))?d:null==(d=r.find.attr(a,b))?void 0:d)},attrHooks:{type:{set:function(a,b){if(!o.radioValue&&"radio"===b&&r.nodeName(a,"input")){var c=a.value;return a.setAttribute("type",b),c&&(a.value=c),b}}}},removeAttr:function(a,b){var c,d=0,e=b&&b.match(K);if(e&&1===a.nodeType)for(;c=e[d++];)a.removeAttribute(c)}}),ib={set:function(a,b,c){return!1===b?r.removeAttr(a,c):a.setAttribute(c,c),c}},r.each(r.expr.match.bool.source.match(/\\w+/g),function(a,b){var c=jb[b]||r.find.attr;jb[b]=function(a,b,d){var e,f,g=b.toLowerCase();return d||(f=jb[g],jb[g]=e,e=null!=c(a,b,d)?g:null,jb[g]=f),e}});var kb=/^(?:input|select|textarea|button)$/i,lb=/^(?:a|area)$/i;function mb(a){return(a.match(K)||[]).join(" ")}function nb(a){return a.getAttribute&&a.getAttribute("class")||""}r.fn.extend({prop:function(a,b){return S(this,r.prop,a,b,1<arguments.length)},removeProp:function(a){return this.each(function(){delete this[r.propFix[a]||a]})}}),r.extend({prop:function(a,b,c){var d,e,f=a.nodeType;if(3!==f&&8!==f&&2!==f)return 1===f&&r.isXMLDoc(a)||(b=r.propFix[b]||b,e=r.propHooks[b]),void 0!==c?e&&"set"in e&&void 0!==(d=e.set(a,c,b))?d:a[b]=c:e&&"get"in e&&null!==(d=e.get(a,b))?d:a[b]},propHooks:{tabIndex:{get:function(a){var b=r.find.attr(a,"tabindex");return b?parseInt(b,10):kb.test(a.nodeName)||lb.test(a.nodeName)&&a.href?0:-1}}},propFix:{for:"htmlFor",class:"className"}}),o.optSelected||(r.propHooks.selected={get:function(a){var b=a.parentNode;return b&&b.parentNode&&b.parentNode.selectedIndex,null},set:function(a){var b=a.parentNode;b&&(b.selectedIndex,b.parentNode&&b.parentNode.selectedIndex)}}),r.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){r.propFix[this.toLowerCase()]=this}),r.fn.extend({addClass:function(a){var b,c,d,e,f,g,h,i=0;if(r.isFunction(a))return this.each(function(b){r(this).addClass(a.call(this,b,nb(this)))});if("string"==typeof a&&a)for(b=a.match(K)||[];c=this[i++];)if(e=nb(c),d=1===c.nodeType&&" "+mb(e)+" "){for(g=0;f=b[g++];)~d.indexOf(" "+f+" ")||(d+=f+" ");e!==(h=mb(d))&&c.setAttribute("class",h)}return this},removeClass:function(a){var b,c,d,e,f,g,h,i=0;if(r.isFunction(a))return this.each(function(b){r(this).removeClass(a.call(this,b,nb(this)))});if(!arguments.length)return this.attr("class","");if("string"==typeof a&&a)for(b=a.match(K)||[];c=this[i++];)if(e=nb(c),d=1===c.nodeType&&" "+mb(e)+" "){for(g=0;f=b[g++];)for(;~d.indexOf(" "+f+" ");)d=d.replace(" "+f+" "," ");e!==(h=mb(d))&&c.setAttribute("class",h)}return this},toggleClass:function(a,b){var c=typeof a;return"boolean"==typeof b&&"string"==c?b?this.addClass(a):this.removeClass(a):r.isFunction(a)?this.each(function(c){r(this).toggleClass(a.call(this,c,nb(this),b),b)}):this.each(function(){var b,d,e,f;if("string"==c)for(d=0,e=r(this),f=a.match(K)||[];b=f[d++];)e.hasClass(b)?e.removeClass(b):e.addClass(b);else void 0!==a&&"boolean"!=c||((b=nb(this))&&V.set(this,"__className__",b),this.setAttribute&&this.setAttribute("class",!b&&!1!==a&&V.get(this,"__className__")||""))})},hasClass:function(a){for(var c,d=0,b=" "+a+" ";c=this[d++];)if(1===c.nodeType&&~(" "+mb(nb(c))+" ").indexOf(b))return!0;return!1}});var ob=/\\r/g;r.fn.extend({val:function(a){var b,c,d,e=this[0];return arguments.length?(d=r.isFunction(a),this.each(function(c){var e;1===this.nodeType&&(null==(e=d?a.call(this,c,r(this).val()):a)?e="":"number"==typeof e?e+="":r.isArray(e)&&(e=r.map(e,function(a){return null==a?"":a+""})),(b=r.valHooks[this.type]||r.valHooks[this.nodeName.toLowerCase()])&&"set"in b&&void 0!==b.set(this,e,"value")||(this.value=e))})):e?(b=r.valHooks[e.type]||r.valHooks[e.nodeName.toLowerCase()])&&"get"in b&&void 0!==(c=b.get(e,"value"))?c:"string"==typeof(c=e.value)?c.replace(ob,""):null==c?"":c:void 0}}),r.extend({valHooks:{option:{get:function(a){var b=r.find.attr(a,"value");return null!=b?b:mb(r.text(a))}},select:{get:function(a){for(var b,c,e=a.options,f=a.selectedIndex,g="select-one"===a.type,h=g?null:[],i=g?f+1:e.length,d=f<0?i:g?f:0;d<i;d++)if(((c=e[d]).selected||d===f)&&!c.disabled&&(!c.parentNode.disabled||!r.nodeName(c.parentNode,"optgroup"))){if(b=r(c).val(),g)return b;h.push(b)}return h},set:function(a,b){for(var c,d,e=a.options,f=r.makeArray(b),g=e.length;g--;)((d=e[g]).selected=-1<r.inArray(r.valHooks.option.get(d),f))&&(c=!0);return c||(a.selectedIndex=-1),f}}}}),r.each(["radio","checkbox"],function(){r.valHooks[this]={set:function(a,b){if(r.isArray(b))return a.checked=-1<r.inArray(r(a).val(),b)}},o.checkOn||(r.valHooks[this].get=function(a){return null===a.getAttribute("value")?"on":a.value})});var pb=/^(?:focusinfocus|focusoutblur)$/;r.extend(r.event,{trigger:function(b,c,e,f){var g,i,j,k,m,n,o=[e||d],p=l.call(b,"type")?b.type:b,q=l.call(b,"namespace")?b.namespace.split("."):[],h=i=e=e||d;if(3!==e.nodeType&&8!==e.nodeType&&!pb.test(p+r.event.triggered)&&(~p.indexOf(".")&&(p=(q=p.split(".")).shift(),q.sort()),k=!~p.indexOf(":")&&"on"+p,(b=b[r.expando]?b:new r.Event(p,"object"==typeof b&&b)).isTrigger=f?2:3,b.namespace=q.join("."),b.rnamespace=b.namespace?RegExp("(^|\\\\.)"+q.join("\\\\.(?:.*\\\\.|)")+"(\\\\.|$)"):null,b.result=void 0,b.target||(b.target=e),c=null==c?[b]:r.makeArray(c,[b]),n=r.event.special[p]||{},f||!n.trigger||!1!==n.trigger.apply(e,c))){if(!f&&!n.noBubble&&!r.isWindow(e)){for(j=n.delegateType||p,pb.test(j+p)||(h=h.parentNode);h;h=h.parentNode)o.push(h),i=h;i===(e.ownerDocument||d)&&o.push(i.defaultView||i.parentWindow||a)}for(g=0;(h=o[g++])&&!b.isPropagationStopped();)b.type=1<g?j:n.bindType||p,(m=(V.get(h,"events")||{})[b.type]&&V.get(h,"handle"))&&m.apply(h,c),(m=k&&h[k])&&m.apply&&T(h)&&(b.result=m.apply(h,c),!1===b.result&&b.preventDefault());return b.type=p,f||b.isDefaultPrevented()||n._default&&!1!==n._default.apply(o.pop(),c)||!T(e)||k&&r.isFunction(e[p])&&!r.isWindow(e)&&((i=e[k])&&(e[k]=null),e[r.event.triggered=p](),r.event.triggered=void 0,i&&(e[k]=i)),b.result}},simulate:function(a,b,c){var d=r.extend(new r.Event,c,{type:a,isSimulated:!0});r.event.trigger(d,null,b)}}),r.fn.extend({trigger:function(a,b){return this.each(function(){r.event.trigger(a,b,this)})},triggerHandler:function(a,b){var c=this[0];if(c)return r.event.trigger(a,b,c,!0)}}),r.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(a,b){r.fn[b]=function(a,c){return 0<arguments.length?this.on(b,null,a,c):this.trigger(b)}}),r.fn.extend({hover:function(a,b){return this.mouseenter(a).mouseleave(b||a)}}),o.focusin="onfocusin"in a,o.focusin||r.each({focus:"focusin",blur:"focusout"},function(a,b){function c(a){r.event.simulate(b,a.target,r.event.fix(a))}r.event.special[b]={setup:function(){var d=this.ownerDocument||this,e=V.access(d,b);e||d.addEventListener(a,c,!0),V.access(d,b,(e||0)+1)},teardown:function(){var d=this.ownerDocument||this,e=V.access(d,b)-1;e?V.access(d,b,e):(d.removeEventListener(a,c,!0),V.remove(d,b))}}});var qb=a.location,rb=r.now(),sb=/\\?/;r.parseXML=function(b){var c;if(!b||"string"!=typeof b)return null;try{c=(new a.DOMParser).parseFromString(b,"text/xml")}catch(d){c=void 0}return c&&!c.getElementsByTagName("parsererror").length||r.error("Invalid XML: "+b),c};var tb=/\\[\\]$/,ub=/\\r?\\n/g,vb=/^(?:submit|button|image|reset|file)$/i,wb=/^(?:input|select|textarea|keygen)/i;r.param=function(a,b){function e(a,b){var c=r.isFunction(b)?b():b;d[d.length]=encodeURIComponent(a)+"="+encodeURIComponent(null==c?"":c)}var c,d=[];if(r.isArray(a)||a.jquery&&!r.isPlainObject(a))r.each(a,function(){e(this.name,this.value)});else for(c in a)!function xb(a,b,c,d){var e;if(r.isArray(b))r.each(b,function(b,e){c||tb.test(a)?d(a,e):xb(a+"["+("object"==typeof e&&null!=e?b:"")+"]",e,c,d)});else if(c||"object"!==r.type(b))d(a,b);else for(e in b)xb(a+"["+e+"]",b[e],c,d)}(c,a[c],b,e);return d.join("&")},r.fn.extend({serialize:function(){return r.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var a=r.prop(this,"elements");return a?r.makeArray(a):this}).filter(function(){var a=this.type;return this.name&&!r(this).is(":disabled")&&wb.test(this.nodeName)&&!vb.test(a)&&(this.checked||!ia.test(a))}).map(function(a,b){var c=r(this).val();return null==c?null:r.isArray(c)?r.map(c,function(a){return{name:b.name,value:a.replace(ub,"\\r\\n")}}):{name:b.name,value:c.replace(ub,"\\r\\n")}}).get()}});var yb=/%20/g,zb=/#.*$/,Ab=/([?&])_=[^&]*/,Bb=/^(.*?):[ \\t]*([^\\r\\n]*)$/gm,Db=/^(?:GET|HEAD)$/,Eb=/^\\/\\//,Fb={},Gb={},Ib=d.createElement("a");function Jb(a){return function(b,c){"string"!=typeof b&&(c=b,b="*");var d,e=0,f=b.toLowerCase().match(K)||[];if(r.isFunction(c))for(;d=f[e++];)"+"===d[0]?(d=d.slice(1)||"*",(a[d]=a[d]||[]).unshift(c)):(a[d]=a[d]||[]).push(c)}}function Kb(a,b,c,d){var e={},f=a===Gb;function g(h){var i;return e[h]=!0,r.each(a[h]||[],function(a,h){var j=h(b,c,d);return"string"!=typeof j||f||e[j]?f?!(i=j):void 0:(b.dataTypes.unshift(j),g(j),!1)}),i}return g(b.dataTypes[0])||!e["*"]&&g("*")}function Lb(a,b){var c,d,e=r.ajaxSettings.flatOptions||{};for(c in b)void 0!==b[c]&&((e[c]?a:d=d||{})[c]=b[c]);return d&&r.extend(!0,a,d),a}Ib.href=qb.href,r.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:qb.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(qb.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":"*/*",text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\\bxml\\b/,html:/\\bhtml/,json:/\\bjson\\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":r.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(a,b){return b?Lb(Lb(a,r.ajaxSettings),b):Lb(r.ajaxSettings,a)},ajaxPrefilter:Jb(Fb),ajaxTransport:Jb(Gb),ajax:function(b,c){"object"==typeof b&&(c=b,b=void 0),c=c||{};var e,f,g,h,i,j,k,l,m,n,o=r.ajaxSetup({},c),p=o.context||o,q=o.context&&(p.nodeType||p.jquery)?r(p):r.event,s=r.Deferred(),t=r.Callbacks("once memory"),u=o.statusCode||{},v={},w={},x="canceled",y={readyState:0,getResponseHeader:function(a){var b;if(k){if(!h)for(h={};b=Bb.exec(g);)h[b[1].toLowerCase()]=b[2];b=h[a.toLowerCase()]}return null==b?null:b},getAllResponseHeaders:function(){return k?g:null},setRequestHeader:function(a,b){return null==k&&(a=w[a.toLowerCase()]=w[a.toLowerCase()]||a,v[a]=b),this},overrideMimeType:function(a){return null==k&&(o.mimeType=a),this},statusCode:function(a){var b;if(a)if(k)y.always(a[y.status]);else for(b in a)u[b]=[u[b],a[b]];return this},abort:function(a){var b=a||x;return e&&e.abort(b),A(0,b),this}};if(s.promise(y),o.url=((b||o.url||qb.href)+"").replace(Eb,qb.protocol+"//"),o.type=c.method||c.type||o.method||o.type,o.dataTypes=(o.dataType||"*").toLowerCase().match(K)||[""],null==o.crossDomain){j=d.createElement("a");try{j.href=o.url,j.href=j.href,o.crossDomain=Ib.protocol+"//"+Ib.host!=j.protocol+"//"+j.host}catch(z){o.crossDomain=!0}}if(o.data&&o.processData&&"string"!=typeof o.data&&(o.data=r.param(o.data,o.traditional)),Kb(Fb,o,c,y),k)return y;for(m in(l=r.event&&o.global)&&0==r.active++&&r.event.trigger("ajaxStart"),o.type=o.type.toUpperCase(),o.hasContent=!Db.test(o.type),f=o.url.replace(zb,""),o.hasContent?o.data&&o.processData&&!(o.contentType||"").indexOf("application/x-www-form-urlencoded")&&(o.data=o.data.replace(yb,"+")):(n=o.url.slice(f.length),o.data&&(f+=(sb.test(f)?"&":"?")+o.data,delete o.data),!1===o.cache&&(f=f.replace(Ab,"$1"),n=(sb.test(f)?"&":"?")+"_="+rb+++n),o.url=f+n),o.ifModified&&(r.lastModified[f]&&y.setRequestHeader("If-Modified-Since",r.lastModified[f]),r.etag[f]&&y.setRequestHeader("If-None-Match",r.etag[f])),(o.data&&o.hasContent&&!1!==o.contentType||c.contentType)&&y.setRequestHeader("Content-Type",o.contentType),y.setRequestHeader("Accept",o.dataTypes[0]&&o.accepts[o.dataTypes[0]]?o.accepts[o.dataTypes[0]]+("*"!==o.dataTypes[0]?", */*; q=0.01":""):o.accepts["*"]),o.headers)y.setRequestHeader(m,o.headers[m]);if(o.beforeSend&&(!1===o.beforeSend.call(p,y,o)||k))return y.abort();if(x="abort",t.add(o.complete),y.done(o.success),y.fail(o.error),e=Kb(Gb,o,c,y)){if(y.readyState=1,l&&q.trigger("ajaxSend",[y,o]),k)return y;o.async&&0<o.timeout&&(i=a.setTimeout(function(){y.abort("timeout")},o.timeout));try{k=!1,e.send(v,A)}catch(z){if(k)throw z;A(-1,z)}}else A(-1,"No Transport");function A(b,c,d,h){var j,m,n,v,w,x=c;k||(k=!0,i&&a.clearTimeout(i),e=void 0,g=h||"",y.readyState=0<b?4:0,j=200<=b&&b<300||304===b,d&&(v=function(a,b,c){for(var d,e,f,g,h=a.contents,i=a.dataTypes;"*"===i[0];)i.shift(),void 0===d&&(d=a.mimeType||b.getResponseHeader("Content-Type"));if(d)for(e in h)if(h[e]&&h[e].test(d)){i.unshift(e);break}if(i[0]in c)f=i[0];else{for(e in c){if(!i[0]||a.converters[e+" "+i[0]]){f=e;break}g=g||e}f=f||g}if(f)return f!==i[0]&&i.unshift(f),c[f]}(o,y,d)),v=function(a,b,c,d){var e,f,g,h,i,j={},k=a.dataTypes.slice();if(k[1])for(g in a.converters)j[g.toLowerCase()]=a.converters[g];for(f=k.shift();f;)if(a.responseFields[f]&&(c[a.responseFields[f]]=b),!i&&d&&a.dataFilter&&(b=a.dataFilter(b,a.dataType)),i=f,f=k.shift())if("*"===f)f=i;else if("*"!==i&&i!==f){if(!(g=j[i+" "+f]||j["* "+f]))for(e in j)if((h=e.split(" "))[1]===f&&(g=j[i+" "+h[0]]||j["* "+h[0]])){!0===g?g=j[e]:!0!==j[e]&&(f=h[0],k.unshift(h[1]));break}if(!0!==g)if(g&&a.throws)b=g(b);else try{b=g(b)}catch(l){return{state:"parsererror",error:g?l:"No conversion from "+i+" to "+f}}}return{state:"success",data:b}}(o,v,y,j),j?(o.ifModified&&((w=y.getResponseHeader("Last-Modified"))&&(r.lastModified[f]=w),(w=y.getResponseHeader("etag"))&&(r.etag[f]=w)),204===b||"HEAD"===o.type?x="nocontent":304===b?x="notmodified":(x=v.state,m=v.data,j=!(n=v.error))):(n=x,!b&&x||(x="error",b<0&&(b=0))),y.status=b,y.statusText=(c||x)+"",j?s.resolveWith(p,[m,x,y]):s.rejectWith(p,[y,x,n]),y.statusCode(u),u=void 0,l&&q.trigger(j?"ajaxSuccess":"ajaxError",[y,o,j?m:n]),t.fireWith(p,[y,x]),l&&(q.trigger("ajaxComplete",[y,o]),--r.active||r.event.trigger("ajaxStop")))}return y},getJSON:function(a,b,c){return r.get(a,b,c,"json")},getScript:function(a,b){return r.get(a,void 0,b,"script")}}),r.each(["get","post"],function(a,b){r[b]=function(a,c,d,e){return r.isFunction(c)&&(e=e||d,d=c,c=void 0),r.ajax(r.extend({url:a,type:b,dataType:e,data:c,success:d},r.isPlainObject(a)&&a))}}),r._evalUrl=function(a){return r.ajax({url:a,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,throws:!0})},r.fn.extend({wrapAll:function(a){var b;return this[0]&&(r.isFunction(a)&&(a=a.call(this[0])),b=r(a,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&b.insertBefore(this[0]),b.map(function(){for(var a=this;a.firstElementChild;)a=a.firstElementChild;return a}).append(this)),this},wrapInner:function(a){return r.isFunction(a)?this.each(function(b){r(this).wrapInner(a.call(this,b))}):this.each(function(){var b=r(this),c=b.contents();c.length?c.wrapAll(a):b.append(a)})},wrap:function(a){var b=r.isFunction(a);return this.each(function(c){r(this).wrapAll(b?a.call(this,c):a)})},unwrap:function(a){return this.parent(a).not("body").each(function(){r(this).replaceWith(this.childNodes)}),this}}),r.expr.pseudos.hidden=function(a){return!r.expr.pseudos.visible(a)},r.expr.pseudos.visible=function(a){return!!(a.offsetWidth||a.offsetHeight||a.getClientRects().length)},r.ajaxSettings.xhr=function(){try{return new a.XMLHttpRequest}catch(b){}};var Ob={0:200,1223:204},Pb=r.ajaxSettings.xhr();o.cors=!!Pb&&"withCredentials"in Pb,o.ajax=Pb=!!Pb,r.ajaxTransport(function(b){var c,d;if(o.cors||Pb&&!b.crossDomain)return{send:function(e,f){var g,h=b.xhr();if(h.open(b.type,b.url,b.async,b.username,b.password),b.xhrFields)for(g in b.xhrFields)h[g]=b.xhrFields[g];for(g in b.mimeType&&h.overrideMimeType&&h.overrideMimeType(b.mimeType),b.crossDomain||e["X-Requested-With"]||(e["X-Requested-With"]="XMLHttpRequest"),e)h.setRequestHeader(g,e[g]);c=function(a){return function(){c&&(c=d=h.onload=h.onerror=h.onabort=h.onreadystatechange=null,"abort"===a?h.abort():"error"===a?"number"!=typeof h.status?f(0,"error"):f(h.status,h.statusText):f(Ob[h.status]||h.status,h.statusText,"text"!==(h.responseType||"text")||"string"!=typeof h.responseText?{binary:h.response}:{text:h.responseText},h.getAllResponseHeaders()))}},h.onload=c(),d=h.onerror=c("error"),void 0!==h.onabort?h.onabort=d:h.onreadystatechange=function(){4===h.readyState&&a.setTimeout(function(){c&&d()})},c=c("abort");try{h.send(b.hasContent&&b.data||null)}catch(i){if(c)throw i}},abort:function(){c&&c()}}}),r.ajaxPrefilter(function(a){a.crossDomain&&(a.contents.script=!1)}),r.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\\b(?:java|ecma)script\\b/},converters:{"text script":function(a){return r.globalEval(a),a}}}),r.ajaxPrefilter("script",function(a){void 0===a.cache&&(a.cache=!1),a.crossDomain&&(a.type="GET")}),r.ajaxTransport("script",function(a){var b,c;if(a.crossDomain)return{send:function(e,f){b=r("<script>").prop({charset:a.scriptCharset,src:a.url}).on("load error",c=function(a){b.remove(),c=null,a&&f("error"===a.type?404:200,a.type)}),d.head.appendChild(b[0])},abort:function(){c&&c()}}});var Qb=[],Rb=/(=)\\?(?=&|$)|\\?\\?/;function Sb(a){return r.isWindow(a)?a:9===a.nodeType&&a.defaultView}r.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var a=Qb.pop()||r.expando+"_"+rb++;return this[a]=!0,a}}),r.ajaxPrefilter("json jsonp",function(b,c,d){var e,f,g,h=!1!==b.jsonp&&(Rb.test(b.url)?"url":"string"==typeof b.data&&0==(b.contentType||"").indexOf("application/x-www-form-urlencoded")&&Rb.test(b.data)&&"data");if(h||"jsonp"===b.dataTypes[0])return e=b.jsonpCallback=r.isFunction(b.jsonpCallback)?b.jsonpCallback():b.jsonpCallback,h?b[h]=b[h].replace(Rb,"$1"+e):!1!==b.jsonp&&(b.url+=(sb.test(b.url)?"&":"?")+b.jsonp+"="+e),b.converters["script json"]=function(){return g||r.error(e+" was not called"),g[0]},b.dataTypes[0]="json",f=a[e],a[e]=function(){g=arguments},d.always(function(){void 0===f?r(a).removeProp(e):a[e]=f,b[e]&&(b.jsonpCallback=c.jsonpCallback,Qb.push(e)),g&&r.isFunction(f)&&f(g[0]),g=f=void 0}),"script"}),o.createHTMLDocument=function(){var a=d.implementation.createHTMLDocument("").body;return a.innerHTML="<form></form><form></form>",2===a.childNodes.length}(),r.parseHTML=function(a,b,c){return"string"!=typeof a?[]:("boolean"==typeof b&&(c=b,b=!1),b||(o.createHTMLDocument?((e=(b=d.implementation.createHTMLDocument("")).createElement("base")).href=d.location.href,b.head.appendChild(e)):b=d),g=!c&&[],(f=B.exec(a))?[b.createElement(f[1])]:(f=pa([a],b,g),g&&g.length&&r(g).remove(),r.merge([],f.childNodes)));var e,f,g},r.fn.load=function(a,b,c){var d,e,f,g=this,h=a.indexOf(" ");return-1<h&&(d=mb(a.slice(h)),a=a.slice(0,h)),r.isFunction(b)?(c=b,b=void 0):b&&"object"==typeof b&&(e="POST"),0<g.length&&r.ajax({url:a,type:e||"GET",dataType:"html",data:b}).done(function(a){f=arguments,g.html(d?r("<div>").append(r.parseHTML(a)).find(d):a)}).always(c&&function(a,b){g.each(function(){c.apply(this,f||[a.responseText,b,a])})}),this},r.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(a,b){r.fn[b]=function(a){return this.on(b,a)}}),r.expr.pseudos.animated=function(a){return r.grep(r.timers,function(b){return a===b.elem}).length},r.offset={setOffset:function(a,b,c){var d,e,f,g,h,i,k=r.css(a,"position"),l=r(a),m={};"static"===k&&(a.style.position="relative"),h=l.offset(),f=r.css(a,"top"),i=r.css(a,"left"),e=("absolute"===k||"fixed"===k)&&!!~(f+i).indexOf("auto")?(g=(d=l.position()).top,d.left):(g=parseFloat(f)||0,parseFloat(i)||0),r.isFunction(b)&&(b=b.call(a,c,r.extend({},h))),null!=b.top&&(m.top=b.top-h.top+g),null!=b.left&&(m.left=b.left-h.left+e),"using"in b?b.using.call(a,m):l.css(m)}},r.fn.extend({offset:function(a){if(arguments.length)return void 0===a?this:this.each(function(b){r.offset.setOffset(this,a,b)});var b,c,d,e,f=this[0];return f?f.getClientRects().length?(d=f.getBoundingClientRect()).width||d.height?(c=Sb(e=f.ownerDocument),b=e.documentElement,{top:d.top+c.pageYOffset-b.clientTop,left:d.left+c.pageXOffset-b.clientLeft}):d:{top:0,left:0}:void 0},position:function(){if(this[0]){var a,b,c=this[0],d={top:0,left:0};return"fixed"===r.css(c,"position")?b=c.getBoundingClientRect():(a=this.offsetParent(),b=this.offset(),r.nodeName(a[0],"html")||(d=a.offset()),d={top:d.top+r.css(a[0],"borderTopWidth",!0),left:d.left+r.css(a[0],"borderLeftWidth",!0)}),{top:b.top-d.top-r.css(c,"marginTop",!0),left:b.left-d.left-r.css(c,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){for(var a=this.offsetParent;a&&"static"===r.css(a,"position");)a=a.offsetParent;return a||qa})}}),r.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(a,b){var c="pageYOffset"===b;r.fn[a]=function(d){return S(this,function(a,d,e){var f=Sb(a);return void 0===e?f?f[b]:a[d]:void(f?f.scrollTo(c?f.pageXOffset:e,c?e:f.pageYOffset):a[d]=e)},a,d,arguments.length)}}),r.each(["top","left"],function(a,b){r.cssHooks[b]=Oa(o.pixelPosition,function(a,c){if(c)return c=Na(a,b),La.test(c)?r(a).position()[b]+"px":c})}),r.each({Height:"height",Width:"width"},function(a,b){r.each({padding:"inner"+a,content:b,"":"outer"+a},function(c,d){r.fn[d]=function(e,f){var g=arguments.length&&(c||"boolean"!=typeof e),h=c||(!0===e||!0===f?"margin":"border");return S(this,function(b,c,e){var f;return r.isWindow(b)?d.indexOf("outer")?b.document.documentElement["client"+a]:b["inner"+a]:9===b.nodeType?(f=b.documentElement,Math.max(b.body["scroll"+a],f["scroll"+a],b.body["offset"+a],f["offset"+a],f["client"+a])):void 0===e?r.css(b,c,h):r.style(b,c,e,h)},b,g?e:void 0,g)}})}),r.fn.extend({bind:function(a,b,c){return this.on(a,null,b,c)},unbind:function(a,b){return this.off(a,null,b)},delegate:function(a,b,c,d){return this.on(b,a,c,d)},undelegate:function(a,b,c){return 1===arguments.length?this.off(a,"**"):this.off(b,a||"**",c)}}),r.parseJSON=JSON.parse,"function"==typeof define&&define.amd&&define("jquery",[],function(){return r});var Tb=a.jQuery,Ub=a.$;return r.noConflict=function(b){return a.$===r&&(a.$=Ub),b&&a.jQuery===r&&(a.jQuery=Tb),r},b||(a.jQuery=a.$=r),r}),function(){"use strict";function setup($){$.fn._fadeIn=$.fn.fadeIn;var noOp=$.noop||function(){},msie=/MSIE/.test(navigator.userAgent),ie6=/MSIE 6.0/.test(navigator.userAgent)&&!/MSIE 8.0/.test(navigator.userAgent),setExpr=(document.documentMode,$.isFunction(document.createElement("div").style.setExpression));$.blockUI=function(opts){install(window,opts)},$.unblockUI=function(opts){remove(window,opts)},$.growlUI=function(title,message,timeout,onClose){var $m=$(\'<div class="growlUI"></div>\');title&&$m.append("<h1>"+title+"</h1>"),message&&$m.append("<h2>"+message+"</h2>"),void 0===timeout&&(timeout=3e3);function callBlock(opts){opts=opts||{},$.blockUI({message:$m,fadeIn:void 0!==opts.fadeIn?opts.fadeIn:700,fadeOut:void 0!==opts.fadeOut?opts.fadeOut:1e3,timeout:void 0!==opts.timeout?opts.timeout:timeout,centerY:!1,showOverlay:!1,onUnblock:onClose,css:$.blockUI.defaults.growlCSS})}callBlock();$m.css("opacity");$m.mouseover(function(){callBlock({fadeIn:0,timeout:3e4});var displayBlock=$(".blockMsg");displayBlock.stop(),displayBlock.fadeTo(300,1)}).mouseout(function(){$(".blockMsg").fadeOut(1e3)})},$.fn.block=function(opts){if(this[0]===window)return $.blockUI(opts),this;var fullOpts=$.extend({},$.blockUI.defaults,opts||{});return this.each(function(){var $el=$(this);fullOpts.ignoreIfBlocked&&$el.data("blockUI.isBlocked")||$el.unblock({fadeOut:0})}),this.each(function(){"static"==$.css(this,"position")&&(this.style.position="relative",$(this).data("blockUI.static",!0)),this.style.zoom=1,install(this,opts)})},$.fn.unblock=function(opts){return this[0]===window?($.unblockUI(opts),this):this.each(function(){remove(this,opts)})},$.blockUI.version=2.7,$.blockUI.defaults={message:"<h1>Please wait...</h1>",title:null,draggable:!0,theme:!1,css:{padding:0,margin:0,width:"30%",top:"40%",left:"35%",textAlign:"center",color:"#000",border:"3px solid #aaa",backgroundColor:"#fff",cursor:"wait"},themedCSS:{width:"30%",top:"40%",left:"35%"},overlayCSS:{backgroundColor:"#000",opacity:.6,cursor:"wait"},cursorReset:"default",growlCSS:{width:"350px",top:"10px",left:"",right:"10px",border:"none",padding:"5px",opacity:.6,cursor:"default",color:"#fff",backgroundColor:"#000","-webkit-border-radius":"10px","-moz-border-radius":"10px","border-radius":"10px"},iframeSrc:/^https/i.test(window.location.href||"")?"javascript:false":"about:blank",forceIframe:!1,baseZ:1e3,centerX:!0,centerY:!0,allowBodyStretch:!0,bindEvents:!0,constrainTabKey:!0,fadeIn:200,fadeOut:400,timeout:0,showOverlay:!0,focusInput:!0,focusableElements:":input:enabled:visible",onBlock:null,onUnblock:null,onOverlayClick:null,quirksmodeOffsetHack:4,blockMsgClass:"blockMsg",ignoreIfBlocked:!1};var pageBlock=null,pageBlockEls=[];function install(el,opts){var css,themedCSS,node,data,z,lyr3,s,lyr1,lyr2,layers,$par,expr,t,l,fixT,fixL,cb,cb1,cb2,to,full=el==window,msg=opts&&void 0!==opts.message?opts.message:void 0;(opts=$.extend({},$.blockUI.defaults,opts||{})).ignoreIfBlocked&&$(el).data("blockUI.isBlocked")||(opts.overlayCSS=$.extend({},$.blockUI.defaults.overlayCSS,opts.overlayCSS||{}),css=$.extend({},$.blockUI.defaults.css,opts.css||{}),opts.onOverlayClick&&(opts.overlayCSS.cursor="pointer"),themedCSS=$.extend({},$.blockUI.defaults.themedCSS,opts.themedCSS||{}),msg=void 0===msg?opts.message:msg,full&&pageBlock&&remove(window,{fadeOut:0}),msg&&"string"!=typeof msg&&(msg.parentNode||msg.jquery)&&(node=msg.jquery?msg[0]:msg,data={},$(el).data("blockUI.history",data),data.el=node,data.parent=node.parentNode,data.display=node.style.display,data.position=node.style.position,data.parent&&data.parent.removeChild(node)),$(el).data("blockUI.onUnblock",opts.onUnblock),z=opts.baseZ,lyr1=msie||opts.forceIframe?$(\'<iframe class="blockUI" style="z-index:\'+z+++\';display:none;border:none;margin:0;padding:0;position:absolute;width:100%;height:100%;top:0;left:0" src="\'+opts.iframeSrc+\'"></iframe>\'):$(\'<div class="blockUI" style="display:none"></div>\'),lyr2=opts.theme?$(\'<div class="blockUI blockOverlay ui-widget-overlay" style="z-index:\'+z+++\';display:none"></div>\'):$(\'<div class="blockUI blockOverlay" style="z-index:\'+z+++\';display:none;border:none;margin:0;padding:0;width:100%;height:100%;top:0;left:0"></div>\'),opts.theme&&full?(s=\'<div class="blockUI \'+opts.blockMsgClass+\' blockPage ui-dialog ui-widget ui-corner-all" style="z-index:\'+(z+10)+\';display:none;position:fixed">\',opts.title&&(s+=\'<div class="ui-widget-header ui-dialog-titlebar ui-corner-all blockTitle">\'+(opts.title||"&nbsp;")+"</div>"),s+=\'<div class="ui-widget-content ui-dialog-content"></div>\',s+="</div>"):opts.theme?(s=\'<div class="blockUI \'+opts.blockMsgClass+\' blockElement ui-dialog ui-widget ui-corner-all" style="z-index:\'+(z+10)+\';display:none;position:absolute">\',opts.title&&(s+=\'<div class="ui-widget-header ui-dialog-titlebar ui-corner-all blockTitle">\'+(opts.title||"&nbsp;")+"</div>"),s+=\'<div class="ui-widget-content ui-dialog-content"></div>\',s+="</div>"):s=full?\'<div class="blockUI \'+opts.blockMsgClass+\' blockPage" style="z-index:\'+(z+10)+\';display:none;position:fixed"></div>\':\'<div class="blockUI \'+opts.blockMsgClass+\' blockElement" style="z-index:\'+(z+10)+\';display:none;position:absolute"></div>\',lyr3=$(s),msg&&(opts.theme?(lyr3.css(themedCSS),lyr3.addClass("ui-widget-content")):lyr3.css(css)),opts.theme||lyr2.css(opts.overlayCSS),lyr2.css("position",full?"fixed":"absolute"),(msie||opts.forceIframe)&&lyr1.css("opacity",0),layers=[lyr1,lyr2,lyr3],$par=$(full?"body":el),$.each(layers,function(){this.appendTo($par)}),opts.theme&&opts.draggable&&$.fn.draggable&&lyr3.draggable({handle:".ui-dialog-titlebar",cancel:"li"}),expr=setExpr&&(!$.support.boxModel||0<$("object,embed",full?null:el).length),(ie6||expr)&&(full&&opts.allowBodyStretch&&$.support.boxModel&&$("html,body").css("height","100%"),!ie6&&$.support.boxModel||full||(t=sz(el,"borderTopWidth"),l=sz(el,"borderLeftWidth"),fixT=t?"(0 - "+t+")":0,fixL=l?"(0 - "+l+")":0),$.each(layers,function(i,o){var expression,s=o[0].style;s.position="absolute",i<2?(full?s.setExpression("height","Math.max(document.body.scrollHeight, document.body.offsetHeight) - (jQuery.support.boxModel?0:"+opts.quirksmodeOffsetHack+\') + "px"\'):s.setExpression("height",\'this.parentNode.offsetHeight + "px"\'),full?s.setExpression("width",\'jQuery.support.boxModel && document.documentElement.clientWidth || document.body.clientWidth + "px"\'):s.setExpression("width",\'this.parentNode.offsetWidth + "px"\'),fixL&&s.setExpression("left",fixL),fixT&&s.setExpression("top",fixT)):opts.centerY?(full&&s.setExpression("top",\'(document.documentElement.clientHeight || document.body.clientHeight) / 2 - (this.offsetHeight / 2) + (blah = document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop) + "px"\'),s.marginTop=0):!opts.centerY&&full&&(expression="((document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop) + "+(opts.css&&opts.css.top?parseInt(opts.css.top,10):0)+\') + "px"\',s.setExpression("top",expression))})),msg&&(opts.theme?lyr3.find(".ui-widget-content").append(msg):lyr3.append(msg),(msg.jquery||msg.nodeType)&&$(msg).show()),(msie||opts.forceIframe)&&opts.showOverlay&&lyr1.show(),opts.fadeIn?(cb=opts.onBlock?opts.onBlock:noOp,cb1=opts.showOverlay&&!msg?cb:noOp,cb2=msg?cb:noOp,opts.showOverlay&&lyr2._fadeIn(opts.fadeIn,cb1),msg&&lyr3._fadeIn(opts.fadeIn,cb2)):(opts.showOverlay&&lyr2.show(),msg&&lyr3.show(),opts.onBlock&&opts.onBlock.bind(lyr3)()),bind(1,el,opts),full?(pageBlock=lyr3[0],pageBlockEls=$(opts.focusableElements,pageBlock),opts.focusInput&&setTimeout(focus,20)):function(el,x,y){var p=el.parentNode,s=el.style,l=(p.offsetWidth-el.offsetWidth)/2-sz(p,"borderLeftWidth"),t=(p.offsetHeight-el.offsetHeight)/2-sz(p,"borderTopWidth");x&&(s.left=0<l?l+"px":"0");y&&(s.top=0<t?t+"px":"0")}(lyr3[0],opts.centerX,opts.centerY),opts.timeout&&(to=setTimeout(function(){full?$.unblockUI(opts):$(el).unblock(opts)},opts.timeout),$(el).data("blockUI.timeout",to)))}function remove(el,opts){var count,els,full=el==window,$el=$(el),data=$el.data("blockUI.history"),to=$el.data("blockUI.timeout");to&&(clearTimeout(to),$el.removeData("blockUI.timeout")),opts=$.extend({},$.blockUI.defaults,opts||{}),bind(0,el,opts),null===opts.onUnblock&&(opts.onUnblock=$el.data("blockUI.onUnblock"),$el.removeData("blockUI.onUnblock")),els=full?$("body").children().filter(".blockUI").add("body > .blockUI"):$el.find(">.blockUI"),opts.cursorReset&&(1<els.length&&(els[1].style.cursor=opts.cursorReset),2<els.length&&(els[2].style.cursor=opts.cursorReset)),full&&(pageBlock=pageBlockEls=null),opts.fadeOut?(count=els.length,els.stop().fadeOut(opts.fadeOut,function(){0==--count&&reset(els,data,opts,el)})):reset(els,data,opts,el)}function reset(els,data,opts,el){var body,w,cssW,$el=$(el);$el.data("blockUI.isBlocked")||(els.each(function(i,o){this.parentNode&&this.parentNode.removeChild(this)}),data&&data.el&&(data.el.style.display=data.display,data.el.style.position=data.position,data.el.style.cursor="default",data.parent&&data.parent.appendChild(data.el),$el.removeData("blockUI.history")),$el.data("blockUI.static")&&$el.css("position","static"),"function"==typeof opts.onUnblock&&opts.onUnblock(el,opts),w=(body=$(document.body)).width(),cssW=body[0].style.width,body.width(w-1).width(w),body[0].style.width=cssW)}function bind(b,el,opts){var events,full=el==window,$el=$(el);!b&&(full&&!pageBlock||!full&&!$el.data("blockUI.isBlocked"))||($el.data("blockUI.isBlocked",b),full&&opts.bindEvents&&(!b||opts.showOverlay)&&(events="mousedown mouseup keydown keypress keyup touchstart touchend touchmove",b?$(document).bind(events,opts,handler):$(document).unbind(events,handler)))}function handler(e){if("keydown"===e.type&&e.keyCode&&9==e.keyCode&&pageBlock&&e.data.constrainTabKey){var fwd=!e.shiftKey&&e.target===pageBlockEls[pageBlockEls.length-1],back=e.shiftKey&&e.target===pageBlockEls[0];if(fwd||back)return setTimeout(function(){focus(back)},10),!1}var opts=e.data,target=$(e.target);return target.hasClass("blockOverlay")&&opts.onOverlayClick&&opts.onOverlayClick(e),0<target.parents("div."+opts.blockMsgClass).length||0===target.parents().children().filter("div.blockUI").length}function focus(back){var e;!pageBlockEls||(e=pageBlockEls[!0===back?pageBlockEls.length-1:0])&&e.focus()}function sz(el,p){return parseInt($.css(el,p),10)||0}}"function"==typeof define&&define.amd&&define.amd.jQuery?define(["jquery"],setup):setup(jQuery)}(),function(b){function a(g,l){var i={containerWidth:960,containerHeight:320,headerWidth:48,activateOn:"click",firstSlide:1,slideSpeed:800,onTriggerSlide:function(m){},onSlideAnimComplete:function(){},autoPlay:!1,pauseOnHover:!1,cycleSpeed:6e3,easing:"swing",theme:"basic",rounded:!1,enumerateSlides:!1,linkable:!1},h=b.extend({},i,l),c=g.children("ol").children("li"),j=c.children(":first-child"),k=c.length,f=h.containerWidth-k*h.headerWidth,e={play:function(m){var n=d.nextSlide(m&&m);d.playing||(d.playing=setInterval(function(){j.eq(n()).trigger("click.liteAccordion")},h.cycleSpeed))},stop:function(){clearInterval(d.playing),d.playing=0},next:function(){e.stop(),j.eq(d.currentSlide===k-1?0:d.currentSlide+1).trigger("click.liteAccordion")},prev:function(){e.stop(),j.eq(d.currentSlide-1).trigger("click.liteAccordion")},destroy:function(){e.stop(),b(window).off(".liteAccordion"),g.attr("style","").removeClass("liteAccordion basic dark light stitch").removeData("liteAccordion").off(".liteAccordion").find("li > :first-child").off(".liteAccordion").filter(".selected").removeClass("selected").end().find("b").remove(),c.removeClass("slide").children().attr("style","")},debug:function(){return{elem:g,defaults:i,settings:h,methods:e,core:d}}},d={setStyles:function(){g.width(h.containerWidth).height(h.containerHeight).addClass("liteAccordion").addClass(h.rounded&&"rounded").addClass(h.theme),c.addClass("slide").children(":first-child").height(h.headerWidth),d.setSlidePositions()},setSlidePositions:function(){var m=j.filter(".selected");m.length||j.eq(h.firstSlide-1).addClass("selected"),j.each(function(n){var q=b(this),p=n*h.headerWidth,o=j.first().next(),r=parseInt(o.css("marginLeft"),10)||parseInt(o.css("marginRight"),10)||0;m.length?n>j.index(m)&&(p+=f):n>=h.firstSlide&&(p+=f),q.css("left",p).width(h.containerHeight).next().width(f-r).css({left:p,paddingLeft:h.headerWidth}),h.enumerateSlides&&q.append("<b>"+(n+1)+"</b>")})},bindEvents:function(){"click"===h.activateOn?j.on("click.liteAccordion",d.triggerSlide):"mouseover"===h.activateOn&&j.on("click.liteAccordion mouseover.liteAccordion",d.triggerSlide),h.linkable&&b(window).on("hashchange.liteAccordion",function(n){var m=c.filter(function(){return b(this).attr("data-slide-name")===window.location.hash.split("#")[1]});m.length&&d.triggerSlide.call(m.children("h2")[0],n)}),h.pauseOnHover&&h.autoPlay&&g.on("mouseover.liteAccordion",function(){d.playing&&e.stop()}).on("mouseout.liteAccordion",function(){d.playing||e.play(d.currentSlide)})},currentSlide:h.firstSlide-1,nextSlide:function(m){var n=m+1||d.currentSlide+1;return function(){return n++%k}},playing:0,slideAnimCompleteFlag:!1,triggerSlide:function(o){var n=b(this),m={elem:n,index:j.index(n),next:n.next(),prev:n.parent().prev().children("h2"),parent:n.parent()};if(h.linkable&&m.parent.attr("data-slide-name")&&m.parent.attr("data-slide-name")!==window.location.hash.split("#")[1])return window.location.hash="#"+m.parent.attr("data-slide-name");d.currentSlide=m.index,d.slideAnimCompleteFlag=!1,h.onTriggerSlide.call(m.next,n),n.hasClass("selected")&&n.position().left<f/2?d.animSlide.call(m):d.animSlideGroup(m),h.autoPlay&&(e.stop(),e.play(j.index(j.filter(".selected"))))},animSlide:function(m){var n=this;void 0===this.pos&&(this.pos=f),j.removeClass("selected").filter(this.elem).addClass("selected"),this.index&&(this.elem.add(this.next).stop(!0).animate({left:this.pos+this.index*h.headerWidth},h.slideSpeed,h.easing,function(){d.slideAnimCompleteFlag||(h.onSlideAnimComplete.call(m?m.next:n.prev.next()),d.slideAnimCompleteFlag=!0)}),j.removeClass("selected").filter(this.prev).addClass("selected"))},animSlideGroup:function(m){b.each(["left","right"],function(o,p){var r,q="left"===p?(r=":lt("+(m.index+1)+")",0):(r=":gt("+m.index+")",f);c.filter(r).children("h2").each(function(){var t=b(this),s={elem:t,index:j.index(t),next:t.next(),prev:t.parent().prev().children("h2"),pos:q};d.animSlide.call(s,m)})}),j.removeClass("selected").filter(m.elem).addClass("selected")},ieClass:function(m){m<7&&e.destroy(),10<=m||(7!==m&&8!==m||c.each(function(n){b(this).addClass("slide-"+n)}),g.addClass("ie ie"+m))},init:function(){var n=navigator.userAgent,m=n.indexOf("MSIE");-1!=m&&(n=n.slice(5+m,7+m),d.ieClass(+n)),d.setStyles(),d.bindEvents(),h.cycleSpeed<h.slideSpeed&&(h.cycleSpeed=h.slideSpeed),h.autoPlay&&e.play()}};return d.init(),e}b.fn.liteAccordion=function(e){var d=this,c=d.data("liteAccordion");return"object"!=typeof e&&e?"string"==typeof e&&c[e]?"debug"===e?c[e].call(d):(c[e].call(d),d):void 0:d.each(function(){var f;c||(f=new a(d,e),d.data("liteAccordion",f))})}}(jQuery),function(t){"function"==typeof define&&define.amd?define(["jquery"],t):t(jQuery)}(function(t){t.ui=t.ui||{},t.ui.version="1.12.1";var e=0,i=Array.prototype.slice;t.cleanData=function(e){return function(i){for(var s,n,o=0;null!=(n=i[o]);o++)try{(s=t._data(n,"events"))&&s.remove&&t(n).triggerHandler("remove")}catch(a){}e(i)}}(t.cleanData),t.widget=function(e,i,s){var n,o,a,r={},l=e.split(".")[0],h=l+"-"+(e=e.split(".")[1]);return s||(s=i,i=t.Widget),t.isArray(s)&&(s=t.extend.apply(null,[{}].concat(s))),t.expr[":"][h.toLowerCase()]=function(e){return!!t.data(e,h)},t[l]=t[l]||{},n=t[l][e],o=t[l][e]=function(t,e){return this._createWidget?void(arguments.length&&this._createWidget(t,e)):new o(t,e)},t.extend(o,n,{version:s.version,_proto:t.extend({},s),_childConstructors:[]}),(a=new i).options=t.widget.extend({},a.options),t.each(s,function(e,s){return t.isFunction(s)?void(r[e]=function(){function t(){return i.prototype[e].apply(this,arguments)}function n(t){return i.prototype[e].apply(this,t)}return function(){var e,i=this._super,o=this._superApply;return this._super=t,this._superApply=n,e=s.apply(this,arguments),this._super=i,this._superApply=o,e}}()):void(r[e]=s)}),o.prototype=t.widget.extend(a,{widgetEventPrefix:n&&a.widgetEventPrefix||e},r,{constructor:o,namespace:l,widgetName:e,widgetFullName:h}),n?(t.each(n._childConstructors,function(e,i){var s=i.prototype;t.widget(s.namespace+"."+s.widgetName,o,i._proto)}),delete n._childConstructors):i._childConstructors.push(o),t.widget.bridge(e,o),o},t.widget.extend=function(e){for(var s,n,o=i.call(arguments,1),a=0,r=o.length;a<r;a++)for(s in o[a])n=o[a][s],o[a].hasOwnProperty(s)&&void 0!==n&&(e[s]=t.isPlainObject(n)?t.isPlainObject(e[s])?t.widget.extend({},e[s],n):t.widget.extend({},n):n);return e},t.widget.bridge=function(e,s){var n=s.prototype.widgetFullName||e;t.fn[e]=function(o){var a="string"==typeof o,r=i.call(arguments,1),l=this;return a?this.length||"instance"!==o?this.each(function(){var i,s=t.data(this,n);return"instance"===o?(l=s,!1):s?t.isFunction(s[o])&&"_"!=o[0]?(i=s[o].apply(s,r))!==s&&void 0!==i?(l=i&&i.jquery?l.pushStack(i.get()):i,!1):void 0:t.error("no such method \'"+o+"\' for "+e+" widget instance"):t.error("cannot call methods on "+e+" prior to initialization; attempted to call method \'"+o+"\'")}):l=void 0:(r.length&&(o=t.widget.extend.apply(null,[o].concat(r))),this.each(function(){var e=t.data(this,n);e?(e.option(o||{}),e._init&&e._init()):t.data(this,n,new s(o,this))})),l}},t.Widget=function(){},t.Widget._childConstructors=[],t.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{classes:{},disabled:!1,create:null},_createWidget:function(i,s){s=t(s||this.defaultElement||this)[0],this.element=t(s),this.uuid=e++,this.eventNamespace="."+this.widgetName+this.uuid,this.bindings=t(),this.hoverable=t(),this.focusable=t(),this.classesElementLookup={},s!==this&&(t.data(s,this.widgetFullName,this),this._on(!0,this.element,{remove:function(t){t.target===s&&this.destroy()}}),this.document=t(s.style?s.ownerDocument:s.document||s),this.window=t(this.document[0].defaultView||this.document[0].parentWindow)),this.options=t.widget.extend({},this.options,this._getCreateOptions(),i),this._create(),this.options.disabled&&this._setOptionDisabled(this.options.disabled),this._trigger("create",null,this._getCreateEventData()),this._init()},_getCreateOptions:function(){return{}},_getCreateEventData:t.noop,_create:t.noop,_init:t.noop,destroy:function(){var e=this;this._destroy(),t.each(this.classesElementLookup,function(t,i){e._removeClass(i,t)}),this.element.off(this.eventNamespace).removeData(this.widgetFullName),this.widget().off(this.eventNamespace).removeAttr("aria-disabled"),this.bindings.off(this.eventNamespace)},_destroy:t.noop,widget:function(){return this.element},option:function(e,i){var s,n,o,a=e;if(0===arguments.length)return t.widget.extend({},this.options);if("string"==typeof e)if(a={},e=(s=e.split(".")).shift(),s.length){for(n=a[e]=t.widget.extend({},this.options[e]),o=0;s.length-1>o;o++)n[s[o]]=n[s[o]]||{},n=n[s[o]];if(e=s.pop(),1===arguments.length)return void 0===n[e]?null:n[e];n[e]=i}else{if(1===arguments.length)return void 0===this.options[e]?null:this.options[e];a[e]=i}return this._setOptions(a),this},_setOptions:function(t){var e;for(e in t)this._setOption(e,t[e]);return this},_setOption:function(t,e){return"classes"===t&&this._setOptionClasses(e),this.options[t]=e,"disabled"===t&&this._setOptionDisabled(e),this},_setOptionClasses:function(e){var i,s,n;for(i in e)n=this.classesElementLookup[i],e[i]!==this.options.classes[i]&&n&&n.length&&(s=t(n.get()),this._removeClass(n,i),s.addClass(this._classes({element:s,keys:i,classes:e,add:!0})))},_setOptionDisabled:function(t){this._toggleClass(this.widget(),this.widgetFullName+"-disabled",null,!!t),t&&(this._removeClass(this.hoverable,null,"ui-state-hover"),this._removeClass(this.focusable,null,"ui-state-focus"))},enable:function(){return this._setOptions({disabled:!1})},disable:function(){return this._setOptions({disabled:!0})},_classes:function(e){function i(i,o){for(var a,r=0;i.length>r;r++)a=n.classesElementLookup[i[r]]||t(),a=e.add?t(t.unique(a.get().concat(e.element.get()))):t(a.not(e.element).get()),n.classesElementLookup[i[r]]=a,s.push(i[r]),o&&e.classes[i[r]]&&s.push(e.classes[i[r]])}var s=[],n=this;return e=t.extend({element:this.element,classes:this.options.classes||{}},e),this._on(e.element,{remove:"_untrackClassesElement"}),e.keys&&i(e.keys.match(/\\S+/g)||[],!0),e.extra&&i(e.extra.match(/\\S+/g)||[]),s.join(" ")},_untrackClassesElement:function(e){var i=this;t.each(i.classesElementLookup,function(s,n){-1!==t.inArray(e.target,n)&&(i.classesElementLookup[s]=t(n.not(e.target).get()))})},_removeClass:function(t,e,i){return this._toggleClass(t,e,i,!1)},_addClass:function(t,e,i){return this._toggleClass(t,e,i,!0)},_toggleClass:function(t,e,i,s){s="boolean"==typeof s?s:i;var n="string"==typeof t||null===t,o={extra:n?e:i,keys:n?t:e,element:n?this.element:t,add:s};return o.element.toggleClass(this._classes(o),s),this},_on:function(e,i,s){var n,o=this;"boolean"!=typeof e&&(s=i,i=e,e=!1),s?(i=n=t(i),this.bindings=this.bindings.add(i)):(s=i,i=this.element,n=this.widget()),t.each(s,function(s,a){function r(){return e||!0!==o.options.disabled&&!t(this).hasClass("ui-state-disabled")?("string"==typeof a?o[a]:a).apply(o,arguments):void 0}"string"!=typeof a&&(r.guid=a.guid=a.guid||r.guid||t.guid++);var l=s.match(/^([\\w:-]*)\\s*(.*)$/),h=l[1]+o.eventNamespace,c=l[2];c?n.on(h,c,r):i.on(h,r)})},_off:function(e,i){i=(i||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace,e.off(i).off(i),this.bindings=t(this.bindings.not(e).get()),this.focusable=t(this.focusable.not(e).get()),this.hoverable=t(this.hoverable.not(e).get())},_delay:function(t,e){var s=this;return setTimeout(function(){return("string"==typeof t?s[t]:t).apply(s,arguments)},e||0)},_hoverable:function(e){this.hoverable=this.hoverable.add(e),this._on(e,{mouseenter:function(e){this._addClass(t(e.currentTarget),null,"ui-state-hover")},mouseleave:function(e){this._removeClass(t(e.currentTarget),null,"ui-state-hover")}})},_focusable:function(e){this.focusable=this.focusable.add(e),this._on(e,{focusin:function(e){this._addClass(t(e.currentTarget),null,"ui-state-focus")},focusout:function(e){this._removeClass(t(e.currentTarget),null,"ui-state-focus")}})},_trigger:function(e,i,s){var n,o,a=this.options[e];if(s=s||{},(i=t.Event(i)).type=(e===this.widgetEventPrefix?e:this.widgetEventPrefix+e).toLowerCase(),i.target=this.element[0],o=i.originalEvent)for(n in o)n in i||(i[n]=o[n]);return this.element.trigger(i,s),!(t.isFunction(a)&&!1===a.apply(this.element[0],[i].concat(s))||i.isDefaultPrevented())}},t.each({show:"fadeIn",hide:"fadeOut"},function(e,i){t.Widget.prototype["_"+e]=function(s,n,o){"string"==typeof n&&(n={effect:n});var a,r=n?!0!==n&&"number"!=typeof n&&n.effect||i:e;"number"==typeof(n=n||{})&&(n={duration:n}),a=!t.isEmptyObject(n),n.complete=o,n.delay&&s.delay(n.delay),a&&t.effects&&t.effects.effect[r]?s[e](n):r!==e&&s[r]?s[r](n.duration,n.easing,o):s.queue(function(i){t(this)[e](),o&&o.call(s[0]),i()})}}),t.widget,function(){function e(t,e,i){return[parseFloat(t[0])*(u.test(t[0])?e/100:1),parseFloat(t[1])*(u.test(t[1])?i/100:1)]}function i(e,i){return parseInt(t.css(e,i),10)||0}var n,o=Math.max,a=Math.abs,r=/left|center|right/,l=/top|center|bottom/,h=/[\\+\\-]\\d+(\\.[\\d]+)?%?/,c=/^\\w+/,u=/%$/,d=t.fn.position;t.position={scrollbarWidth:function(){if(void 0!==n)return n;var e,i,s=t("<div style=\'display:block;position:absolute;width:50px;height:50px;overflow:hidden;\'><div style=\'height:100px;width:auto;\'></div></div>"),o=s.children()[0];return t("body").append(s),e=o.offsetWidth,s.css("overflow","scroll"),e===(i=o.offsetWidth)&&(i=s[0].clientWidth),s.remove(),n=e-i},getScrollInfo:function(e){var i=e.isWindow||e.isDocument?"":e.element.css("overflow-x"),s=e.isWindow||e.isDocument?"":e.element.css("overflow-y"),n="scroll"===i||"auto"===i&&e.width<e.element[0].scrollWidth;return{width:"scroll"===s||"auto"===s&&e.height<e.element[0].scrollHeight?t.position.scrollbarWidth():0,height:n?t.position.scrollbarWidth():0}},getWithinInfo:function(e){var i=t(e||window),s=t.isWindow(i[0]),n=!!i[0]&&9===i[0].nodeType;return{element:i,isWindow:s,isDocument:n,offset:!s&&!n?t(e).offset():{left:0,top:0},scrollLeft:i.scrollLeft(),scrollTop:i.scrollTop(),width:i.outerWidth(),height:i.outerHeight()}}},t.fn.position=function(n){if(!n||!n.of)return d.apply(this,arguments);n=t.extend({},n);var u,p,f,g,m,v=t(n.of),b=t.position.getWithinInfo(n.within),y=t.position.getScrollInfo(b),w=(n.collision||"flip").split(" "),k={},_=function(e){var i=e[0];return 9===i.nodeType?{width:e.width(),height:e.height(),offset:{top:0,left:0}}:t.isWindow(i)?{width:e.width(),height:e.height(),offset:{top:e.scrollTop(),left:e.scrollLeft()}}:i.preventDefault?{width:0,height:0,offset:{top:i.pageY,left:i.pageX}}:{width:e.outerWidth(),height:e.outerHeight(),offset:e.offset()}}(v);return v[0].preventDefault&&(n.at="left top"),p=_.width,f=_.height,g=_.offset,m=t.extend({},g),t.each(["my","at"],function(){var t,e,i=(n[this]||"").split(" ");1===i.length&&(i=r.test(i[0])?i.concat(["center"]):l.test(i[0])?["center"].concat(i):["center","center"]),i[0]=r.test(i[0])?i[0]:"center",i[1]=l.test(i[1])?i[1]:"center",t=h.exec(i[0]),e=h.exec(i[1]),k[this]=[t?t[0]:0,e?e[0]:0],n[this]=[c.exec(i[0])[0],c.exec(i[1])[0]]}),1===w.length&&(w[1]=w[0]),"right"===n.at[0]?m.left+=p:"center"===n.at[0]&&(m.left+=p/2),"bottom"===n.at[1]?m.top+=f:"center"===n.at[1]&&(m.top+=f/2),u=e(k.at,p,f),m.left+=u[0],m.top+=u[1],this.each(function(){var s,r,l=t(this),h=l.outerWidth(),c=l.outerHeight(),d=i(this,"marginLeft"),_=i(this,"marginTop"),x=h+d+i(this,"marginRight")+y.width,C=c+_+i(this,"marginBottom")+y.height,D=t.extend({},m),T=e(k.my,l.outerWidth(),l.outerHeight());"right"===n.my[0]?D.left-=h:"center"===n.my[0]&&(D.left-=h/2),"bottom"===n.my[1]?D.top-=c:"center"===n.my[1]&&(D.top-=c/2),D.left+=T[0],D.top+=T[1],s={marginLeft:d,marginTop:_},t.each(["left","top"],function(e,i){t.ui.position[w[e]]&&t.ui.position[w[e]][i](D,{targetWidth:p,targetHeight:f,elemWidth:h,elemHeight:c,collisionPosition:s,collisionWidth:x,collisionHeight:C,offset:[u[0]+T[0],u[1]+T[1]],my:n.my,at:n.at,within:b,elem:l})}),n.using&&(r=function(t){var e=g.left-D.left,i=e+p-h,s=g.top-D.top,r=s+f-c,u={target:{element:v,left:g.left,top:g.top,width:p,height:f},element:{element:l,left:D.left,top:D.top,width:h,height:c},horizontal:i<0?"left":0<e?"right":"center",vertical:r<0?"top":0<s?"bottom":"middle"};p<h&&p>a(e+i)&&(u.horizontal="center"),f<c&&f>a(s+r)&&(u.vertical="middle"),u.important=o(a(e),a(i))>o(a(s),a(r))?"horizontal":"vertical",n.using.call(this,t,u)}),l.offset(t.extend(D,{using:r}))})},t.ui.position={fit:{left:function(t,e){var i,s=e.within,n=s.isWindow?s.scrollLeft:s.offset.left,a=s.width,r=t.left-e.collisionPosition.marginLeft,l=n-r,h=r+e.collisionWidth-a-n;e.collisionWidth>a?0<l&&h<=0?(i=t.left+l+e.collisionWidth-a-n,t.left+=l-i):t.left=!(0<h&&l<=0)&&h<l?n+a-e.collisionWidth:n:0<l?t.left+=l:0<h?t.left-=h:t.left=o(t.left-r,t.left)},top:function(t,e){var i,s=e.within,n=s.isWindow?s.scrollTop:s.offset.top,a=e.within.height,r=t.top-e.collisionPosition.marginTop,l=n-r,h=r+e.collisionHeight-a-n;e.collisionHeight>a?0<l&&h<=0?(i=t.top+l+e.collisionHeight-a-n,t.top+=l-i):t.top=!(0<h&&l<=0)&&h<l?n+a-e.collisionHeight:n:0<l?t.top+=l:0<h?t.top-=h:t.top=o(t.top-r,t.top)}},flip:{left:function(t,e){var i,s,n=e.within,o=n.offset.left+n.scrollLeft,r=n.width,l=n.isWindow?n.scrollLeft:n.offset.left,h=t.left-e.collisionPosition.marginLeft,c=h-l,u=h+e.collisionWidth-r-l,d="left"===e.my[0]?-e.elemWidth:"right"===e.my[0]?e.elemWidth:0,p="left"===e.at[0]?e.targetWidth:"right"===e.at[0]?-e.targetWidth:0,f=-2*e.offset[0];c<0?((i=t.left+d+p+f+e.collisionWidth-r-o)<0||a(c)>i)&&(t.left+=d+p+f):0<u&&((0<(s=t.left-e.collisionPosition.marginLeft+d+p+f-l)||u>a(s))&&(t.left+=d+p+f))},top:function(t,e){var i,s,n=e.within,o=n.offset.top+n.scrollTop,r=n.height,l=n.isWindow?n.scrollTop:n.offset.top,h=t.top-e.collisionPosition.marginTop,c=h-l,u=h+e.collisionHeight-r-l,p="top"===e.my[1]?-e.elemHeight:"bottom"===e.my[1]?e.elemHeight:0,f="top"===e.at[1]?e.targetHeight:"bottom"===e.at[1]?-e.targetHeight:0,g=-2*e.offset[1];c<0?((s=t.top+p+f+g+e.collisionHeight-r-o)<0||a(c)>s)&&(t.top+=p+f+g):0<u&&((0<(i=t.top-e.collisionPosition.marginTop+p+f+g-l)||u>a(i))&&(t.top+=p+f+g))}},flipfit:{left:function(){t.ui.position.flip.left.apply(this,arguments),t.ui.position.fit.left.apply(this,arguments)},top:function(){t.ui.position.flip.top.apply(this,arguments),t.ui.position.fit.top.apply(this,arguments)}}}}(),t.ui.position,t.ui.keyCode={BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38},t.fn.extend({uniqueId:function(){var t=0;return function(){return this.each(function(){this.id||(this.id="ui-id-"+ ++t)})}}(),removeUniqueId:function(){return this.each(function(){/^ui-id-\\d+$/.test(this.id)&&t(this).removeAttr("id")})}}),t.ui.safeActiveElement=function(t){var e;try{e=t.activeElement}catch(i){e=t.body}return(e=e||t.body).nodeName||(e=t.body),e},t.widget("ui.menu",{version:"1.12.1",defaultElement:"<ul>",delay:300,options:{icons:{submenu:"ui-icon-caret-1-e"},items:"> *",menus:"ul",position:{my:"left top",at:"right top"},role:"menu",blur:null,focus:null,select:null},_create:function(){this.activeMenu=this.element,this.mouseHandled=!1,this.element.uniqueId().attr({role:this.options.role,tabIndex:0}),this._addClass("ui-menu","ui-widget ui-widget-content"),this._on({"mousedown .ui-menu-item":function(t){t.preventDefault()},"click .ui-menu-item":function(e){var i=t(e.target),s=t(t.ui.safeActiveElement(this.document[0]));!this.mouseHandled&&i.not(".ui-state-disabled").length&&(this.select(e),e.isPropagationStopped()||(this.mouseHandled=!0),i.has(".ui-menu").length?this.expand(e):!this.element.is(":focus")&&s.closest(".ui-menu").length&&(this.element.trigger("focus",[!0]),this.active&&1===this.active.parents(".ui-menu").length&&clearTimeout(this.timer)))},"mouseenter .ui-menu-item":function(e){var i,s;this.previousFilter||(i=t(e.target).closest(".ui-menu-item"),s=t(e.currentTarget),i[0]===s[0]&&(this._removeClass(s.siblings().children(".ui-state-active"),null,"ui-state-active"),this.focus(e,s)))},mouseleave:"collapseAll","mouseleave .ui-menu":"collapseAll",focus:function(t,e){var i=this.active||this.element.find(this.options.items).eq(0);e||this.focus(t,i)},blur:function(e){this._delay(function(){t.contains(this.element[0],t.ui.safeActiveElement(this.document[0]))||this.collapseAll(e)})},keydown:"_keydown"}),this.refresh(),this._on(this.document,{click:function(t){this._closeOnDocumentClick(t)&&this.collapseAll(t),this.mouseHandled=!1}})},_destroy:function(){var i=this.element.find(".ui-menu-item").removeAttr("role aria-disabled").children(".ui-menu-item-wrapper").removeUniqueId().removeAttr("tabIndex role aria-haspopup");this.element.removeAttr("aria-activedescendant").find(".ui-menu").addBack().removeAttr("role aria-labelledby aria-expanded aria-hidden aria-disabled tabIndex").removeUniqueId().show(),i.children().each(function(){var e=t(this);e.data("ui-menu-submenu-caret")&&e.remove()})},_keydown:function(e){var i,s,n,o,a=!0;switch(e.keyCode){case t.ui.keyCode.PAGE_UP:this.previousPage(e);break;case t.ui.keyCode.PAGE_DOWN:this.nextPage(e);break;case t.ui.keyCode.HOME:this._move("first","first",e);break;case t.ui.keyCode.END:this._move("last","last",e);break;case t.ui.keyCode.UP:this.previous(e);break;case t.ui.keyCode.DOWN:this.next(e);break;case t.ui.keyCode.LEFT:this.collapse(e);break;case t.ui.keyCode.RIGHT:this.active&&!this.active.is(".ui-state-disabled")&&this.expand(e);break;case t.ui.keyCode.ENTER:case t.ui.keyCode.SPACE:this._activate(e);break;case t.ui.keyCode.ESCAPE:this.collapse(e);break;default:a=!1,s=this.previousFilter||"",o=!1,n=96<=e.keyCode&&e.keyCode<=105?""+(e.keyCode-96):String.fromCharCode(e.keyCode),clearTimeout(this.filterTimer),n===s?o=!0:n=s+n,i=this._filterMenuItems(n),(i=o&&-1!==i.index(this.active.next())?this.active.nextAll(".ui-menu-item"):i).length||(n=String.fromCharCode(e.keyCode),i=this._filterMenuItems(n)),i.length?(this.focus(e,i),this.previousFilter=n,this.filterTimer=this._delay(function(){delete this.previousFilter},1e3)):delete this.previousFilter}a&&e.preventDefault()},_activate:function(t){this.active&&!this.active.is(".ui-state-disabled")&&(this.active.children("[aria-haspopup=\'true\']").length?this.expand(t):this.select(t))},refresh:function(){var i,s,n,o,a=this,r=this.options.icons.submenu,l=this.element.find(this.options.menus);this._toggleClass("ui-menu-icons",null,!!this.element.find(".ui-icon").length),s=l.filter(":not(.ui-menu)").hide().attr({role:this.options.role,"aria-hidden":"true","aria-expanded":"false"}).each(function(){var e=t(this),i=e.prev(),s=t("<span>").data("ui-menu-submenu-caret",!0);a._addClass(s,"ui-menu-icon","ui-icon "+r),i.attr("aria-haspopup","true").prepend(s),e.attr("aria-labelledby",i.attr("id"))}),this._addClass(s,"ui-menu","ui-widget ui-widget-content ui-front"),(i=l.add(this.element).find(this.options.items)).not(".ui-menu-item").each(function(){var e=t(this);a._isDivider(e)&&a._addClass(e,"ui-menu-divider","ui-widget-content")}),o=(n=i.not(".ui-menu-item, .ui-menu-divider")).children().not(".ui-menu").uniqueId().attr({tabIndex:-1,role:this._itemRole()}),this._addClass(n,"ui-menu-item")._addClass(o,"ui-menu-item-wrapper"),i.filter(".ui-state-disabled").attr("aria-disabled","true"),this.active&&!t.contains(this.element[0],this.active[0])&&this.blur()},_itemRole:function(){return{menu:"menuitem",listbox:"option"}[this.options.role]},_setOption:function(t,e){var i;"icons"===t&&(i=this.element.find(".ui-menu-icon"),this._removeClass(i,null,this.options.icons.submenu)._addClass(i,null,e.submenu)),this._super(t,e)},_setOptionDisabled:function(t){this._super(t),this.element.attr("aria-disabled",t+""),this._toggleClass(null,"ui-state-disabled",!!t)},focus:function(t,e){var i,s,n;this.blur(t,t&&"focus"===t.type),this._scrollIntoView(e),this.active=e.first(),s=this.active.children(".ui-menu-item-wrapper"),this._addClass(s,null,"ui-state-active"),this.options.role&&this.element.attr("aria-activedescendant",s.attr("id")),n=this.active.parent().closest(".ui-menu-item").children(".ui-menu-item-wrapper"),this._addClass(n,null,"ui-state-active"),t&&"keydown"===t.type?this._close():this.timer=this._delay(function(){this._close()},this.delay),(i=e.children(".ui-menu")).length&&t&&/^mouse/.test(t.type)&&this._startOpening(i),this.activeMenu=e.parent(),this._trigger("focus",t,{item:e})},_scrollIntoView:function(e){var i,s,n,o,a,r;this._hasScroll()&&(i=parseFloat(t.css(this.activeMenu[0],"borderTopWidth"))||0,s=parseFloat(t.css(this.activeMenu[0],"paddingTop"))||0,n=e.offset().top-this.activeMenu.offset().top-i-s,o=this.activeMenu.scrollTop(),a=this.activeMenu.height(),r=e.outerHeight(),n<0?this.activeMenu.scrollTop(o+n):a<n+r&&this.activeMenu.scrollTop(o+n-a+r))},blur:function(t,e){e||clearTimeout(this.timer),this.active&&(this._removeClass(this.active.children(".ui-menu-item-wrapper"),null,"ui-state-active"),this._trigger("blur",t,{item:this.active}),this.active=null)},_startOpening:function(t){clearTimeout(this.timer),"true"===t.attr("aria-hidden")&&(this.timer=this._delay(function(){this._close(),this._open(t)},this.delay))},_open:function(e){var i=t.extend({of:this.active},this.options.position);clearTimeout(this.timer),this.element.find(".ui-menu").not(e.parents(".ui-menu")).hide().attr("aria-hidden","true"),e.show().removeAttr("aria-hidden").attr("aria-expanded","true").position(i)},collapseAll:function(e,i){clearTimeout(this.timer),this.timer=this._delay(function(){var s=i?this.element:t(e&&e.target).closest(this.element.find(".ui-menu"));s.length||(s=this.element),this._close(s),this.blur(e),this._removeClass(s.find(".ui-state-active"),null,"ui-state-active"),this.activeMenu=s},this.delay)},_close:function(t){(t=t||(this.active?this.active.parent():this.element)).find(".ui-menu").hide().attr("aria-hidden","true").attr("aria-expanded","false")},_closeOnDocumentClick:function(e){return!t(e.target).closest(".ui-menu").length},_isDivider:function(t){return!/[^\\-\\u2014\\u2013\\s]/.test(t.text())},collapse:function(t){var e=this.active&&this.active.parent().closest(".ui-menu-item",this.element);e&&e.length&&(this._close(),this.focus(t,e))},expand:function(t){var e=this.active&&this.active.children(".ui-menu ").find(this.options.items).first();e&&e.length&&(this._open(e.parent()),this._delay(function(){this.focus(t,e)}))},next:function(t){this._move("next","first",t)},previous:function(t){this._move("prev","last",t)},isFirstItem:function(){return this.active&&!this.active.prevAll(".ui-menu-item").length},isLastItem:function(){return this.active&&!this.active.nextAll(".ui-menu-item").length},_move:function(t,e,i){var s;this.active&&(s="first"===t||"last"===t?this.active["first"===t?"prevAll":"nextAll"](".ui-menu-item").eq(-1):this.active[t+"All"](".ui-menu-item").eq(0)),s&&s.length&&this.active||(s=this.activeMenu.find(this.options.items)[e]()),this.focus(i,s)},nextPage:function(e){var i,s,n;return this.active?void(this.isLastItem()||(this._hasScroll()?(s=this.active.offset().top,n=this.element.height(),this.active.nextAll(".ui-menu-item").each(function(){return(i=t(this)).offset().top-s-n<0}),this.focus(e,i)):this.focus(e,this.activeMenu.find(this.options.items)[this.active?"last":"first"]()))):void this.next(e)},previousPage:function(e){var i,s,n;return this.active?void(this.isFirstItem()||(this._hasScroll()?(s=this.active.offset().top,n=this.element.height(),this.active.prevAll(".ui-menu-item").each(function(){return 0<(i=t(this)).offset().top-s+n}),this.focus(e,i)):this.focus(e,this.activeMenu.find(this.options.items).first()))):void this.next(e)},_hasScroll:function(){return this.element.outerHeight()<this.element.prop("scrollHeight")},select:function(e){this.active=this.active||t(e.target).closest(".ui-menu-item");var i={item:this.active};this.active.has(".ui-menu").length||this.collapseAll(e,!0),this._trigger("select",e,i)},_filterMenuItems:function(e){var i=e.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g,"\\\\$&"),s=RegExp("^"+i,"i");return this.activeMenu.find(this.options.items).filter(".ui-menu-item").filter(function(){return s.test(t.trim(t(this).children(".ui-menu-item-wrapper").text()))})}}),t.widget("ui.autocomplete",{version:"1.12.1",defaultElement:"<input>",options:{appendTo:null,autoFocus:!1,delay:300,minLength:1,position:{my:"left top",at:"left bottom",collision:"none"},source:null,change:null,close:null,focus:null,open:null,response:null,search:null,select:null},requestIndex:0,pending:0,_create:function(){var e,i,s,n=this.element[0].nodeName.toLowerCase(),o="textarea"==n,a="input"==n;this.isMultiLine=o||!a&&this._isContentEditable(this.element),this.valueMethod=this.element[o||a?"val":"text"],this.isNewMenu=!0,this._addClass("ui-autocomplete-input"),this.element.attr("autocomplete","off"),this._on(this.element,{keydown:function(n){if(this.element.prop("readOnly"))i=s=e=!0;else{i=s=e=!1;var o=t.ui.keyCode;switch(n.keyCode){case o.PAGE_UP:e=!0,this._move("previousPage",n);break;case o.PAGE_DOWN:e=!0,this._move("nextPage",n);break;case o.UP:e=!0,this._keyEvent("previous",n);break;case o.DOWN:e=!0,this._keyEvent("next",n);break;case o.ENTER:this.menu.active&&(e=!0,n.preventDefault(),this.menu.select(n));break;case o.TAB:this.menu.active&&this.menu.select(n);break;case o.ESCAPE:this.menu.element.is(":visible")&&(this.isMultiLine||this._value(this.term),this.close(n),n.preventDefault());break;default:i=!0,this._searchTimeout(n)}}},keypress:function(s){if(e)return e=!1,void(this.isMultiLine&&!this.menu.element.is(":visible")||s.preventDefault());if(!i){var n=t.ui.keyCode;switch(s.keyCode){case n.PAGE_UP:this._move("previousPage",s);break;case n.PAGE_DOWN:this._move("nextPage",s);break;case n.UP:this._keyEvent("previous",s);break;case n.DOWN:this._keyEvent("next",s)}}},input:function(t){return s?(s=!1,void t.preventDefault()):void this._searchTimeout(t)},focus:function(){this.selectedItem=null,this.previous=this._value()},blur:function(t){return this.cancelBlur?void delete this.cancelBlur:(clearTimeout(this.searching),this.close(t),void this._change(t))}}),this._initSource(),this.menu=t("<ul>").appendTo(this._appendTo()).menu({role:null}).hide().menu("instance"),this._addClass(this.menu.element,"ui-autocomplete","ui-front"),this._on(this.menu.element,{mousedown:function(e){e.preventDefault(),this.cancelBlur=!0,this._delay(function(){delete this.cancelBlur,this.element[0]!==t.ui.safeActiveElement(this.document[0])&&this.element.trigger("focus")})},menufocus:function(e,i){var s,n;return this.isNewMenu&&(this.isNewMenu=!1,e.originalEvent&&/^mouse/.test(e.originalEvent.type))?(this.menu.blur(),void this.document.one("mousemove",function(){t(e.target).trigger(e.originalEvent)})):(n=i.item.data("ui-autocomplete-item"),!1!==this._trigger("focus",e,{item:n})&&e.originalEvent&&/^key/.test(e.originalEvent.type)&&this._value(n.value),void((s=i.item.attr("aria-label")||n.value)&&t.trim(s).length&&(this.liveRegion.children().hide(),t("<div>").text(s).appendTo(this.liveRegion))))},menuselect:function(e,i){var s=i.item.data("ui-autocomplete-item"),n=this.previous;this.element[0]!==t.ui.safeActiveElement(this.document[0])&&(this.element.trigger("focus"),this.previous=n,this._delay(function(){this.previous=n,this.selectedItem=s})),!1!==this._trigger("select",e,{item:s})&&this._value(s.value),this.term=this._value(),this.close(e),this.selectedItem=s}}),this.liveRegion=t("<div>",{role:"status","aria-live":"assertive","aria-relevant":"additions"}).appendTo(this.document[0].body),this._addClass(this.liveRegion,null,"ui-helper-hidden-accessible"),this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete")}})},_destroy:function(){clearTimeout(this.searching),this.element.removeAttr("autocomplete"),this.menu.element.remove(),this.liveRegion.remove()},_setOption:function(t,e){this._super(t,e),"source"===t&&this._initSource(),"appendTo"===t&&this.menu.element.appendTo(this._appendTo()),"disabled"===t&&e&&this.xhr&&this.xhr.abort()},_isEventTargetInWidget:function(e){var i=this.menu.element[0];return e.target===this.element[0]||e.target===i||t.contains(i,e.target)},_closeOnClickOutside:function(t){this._isEventTargetInWidget(t)||this.close()},_appendTo:function(){var e=this.options.appendTo;return(e=e&&(e.jquery||e.nodeType?t(e):this.document.find(e).eq(0)))&&e[0]||(e=this.element.closest(".ui-front, dialog")),e.length||(e=this.document[0].body),e},_initSource:function(){var e,i,s=this;t.isArray(this.options.source)?(e=this.options.source,this.source=function(i,s){s(t.ui.autocomplete.filter(e,i.term))}):"string"==typeof this.options.source?(i=this.options.source,this.source=function(e,n){s.xhr&&s.xhr.abort(),s.xhr=t.ajax({url:i,data:e,dataType:"json",success:function(t){n(t)},error:function(){n([])}})}):this.source=this.options.source},_searchTimeout:function(t){clearTimeout(this.searching),this.searching=this._delay(function(){var e=this.term===this._value(),i=this.menu.element.is(":visible"),s=t.altKey||t.ctrlKey||t.metaKey||t.shiftKey;e&&(!e||i||s)||(this.selectedItem=null,this.search(null,t))},this.options.delay)},search:function(t,e){return t=null!=t?t:this._value(),this.term=this._value(),t.length<this.options.minLength?this.close(e):!1!==this._trigger("search",e)?this._search(t):void 0},_search:function(t){this.pending++,this._addClass("ui-autocomplete-loading"),this.cancelSearch=!1,this.source({term:t},this._response())},_response:function(){var e=++this.requestIndex;return t.proxy(function(t){e===this.requestIndex&&this.__response(t),this.pending--,this.pending||this._removeClass("ui-autocomplete-loading")},this)},__response:function(t){t=t&&this._normalize(t),this._trigger("response",null,{content:t}),!this.options.disabled&&t&&t.length&&!this.cancelSearch?(this._suggest(t),this._trigger("open")):this._close()},close:function(t){this.cancelSearch=!0,this._close(t)},_close:function(t){this._off(this.document,"mousedown"),this.menu.element.is(":visible")&&(this.menu.element.hide(),this.menu.blur(),this.isNewMenu=!0,this._trigger("close",t))},_change:function(t){this.previous!==this._value()&&this._trigger("change",t,{item:this.selectedItem})},_normalize:function(e){return e.length&&e[0].label&&e[0].value?e:t.map(e,function(e){return"string"==typeof e?{label:e,value:e}:t.extend({},e,{label:e.label||e.value,value:e.value||e.label})})},_suggest:function(e){var i=this.menu.element.empty();this._renderMenu(i,e),this.isNewMenu=!0,this.menu.refresh(),i.show(),this._resizeMenu(),i.position(t.extend({of:this.element},this.options.position)),this.options.autoFocus&&this.menu.next(),this._on(this.document,{mousedown:"_closeOnClickOutside"})},_resizeMenu:function(){var t=this.menu.element;t.outerWidth(Math.max(t.width("").outerWidth()+1,this.element.outerWidth()))},_renderMenu:function(e,i){var s=this;t.each(i,function(t,i){s._renderItemData(e,i)})},_renderItemData:function(t,e){return this._renderItem(t,e).data("ui-autocomplete-item",e)},_renderItem:function(e,i){return t("<li>").append(t("<div>").text(i.label)).appendTo(e)},_move:function(t,e){return this.menu.element.is(":visible")?this.menu.isFirstItem()&&/^previous/.test(t)||this.menu.isLastItem()&&/^next/.test(t)?(this.isMultiLine||this._value(this.term),void this.menu.blur()):void this.menu[t](e):void this.search(null,e)},widget:function(){return this.menu.element},_value:function(){return this.valueMethod.apply(this.element,arguments)},_keyEvent:function(t,e){this.isMultiLine&&!this.menu.element.is(":visible")||(this._move(t,e),e.preventDefault())},_isContentEditable:function(t){if(!t.length)return!1;var e=t.prop("contentEditable");return"inherit"===e?this._isContentEditable(t.parent()):"true"===e}}),t.extend(t.ui.autocomplete,{escapeRegex:function(t){return t.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g,"\\\\$&")},filter:function(e,i){var s=RegExp(t.ui.autocomplete.escapeRegex(i),"i");return t.grep(e,function(t){return s.test(t.label||t.value||t)})}}),t.widget("ui.autocomplete",t.ui.autocomplete,{options:{messages:{noResults:"No search results.",results:function(t){return t+(1<t?" results are":" result is")+" available, use up and down arrow keys to navigate."}}},__response:function(e){var i;this._superApply(arguments),this.options.disabled||this.cancelSearch||(i=e&&e.length?this.options.messages.results(e.length):this.options.messages.noResults,this.liveRegion.children().hide(),t("<div>").text(i).appendTo(this.liveRegion))}}),t.ui.autocomplete}),jQuery(function($){$.ajax({type:"POST",url:"?ajax&initialize",dataType:"json",success:function(response,status,xhr){for(i in response.data)$(".data-"+i).each(function(){$(this).is("input")?$(this).is(":checkbox")?$(this).prop("checked",response.data[i]):$(this).val(response.data[i]):(null===response.data[i]&&(response.data[i]=""),$(this).text(response.data[i]))});$("span.prefix-colon:not(:empty)").each(function(){":"!=$(this).text().substring(0,1)&&$(this).text(":"+$(this).text())}),response.selfdestruct?($("#selfdestruct").prop("disabled",!1),$("#selfdestruct").change(function(){$("#container .slide:last-child > div form input:submit").val($(this).is(":checked")?"Self-destruct":"Restart")})):$(\'#selfdestruct, label[for="selfdestruct"]\').remove()}});var windowWidth=$("body").width(),liteAccordionOptions={containerWidth:windowWidth,enumerateSlides:!0,linkable:!1};$("#container").liteAccordion(liteAccordionOptions),$(window).on("resize orientationChanged",function(){var currentWidth=$("body").width();windowWidth!=currentWidth&&($("#container").liteAccordion("destroy").liteAccordion($.extend(liteAccordionOptions,{containerWidth:currentWidth})),windowWidth=currentWidth)}),$(window).trigger("resize"),$.blockUI.defaults.css={},$.blockUI.defaults.overlayCSS={},$.blockUI.defaults.growlCSS={},$("#container .slide:not(:first-child) > div > div").block({message:null,overlayCSS:{cursor:"default"}}),$("#container .values-switch a").click(function(e){return $(this).parents("table").find("tbody").not("."+$(this).attr("class").replace(/\\s/,".")).css("display","none"),$(this).parents("table").find("tbody."+$(this).attr("class").replace(/\\s/,".")).css("display","table-row-group"),$(this).siblings().css("font-weight","normal"),$(this).css("font-weight","bolder"),!1}),$("#container .values-switch a.values-raw").click(),$("#addField").click(function(){var i=$("#srFields").children().length;$("#srFields").append(\'<tr><td><textarea name="search[\'+i+\']" rows="10" cols="50"></textarea></td><td><textarea name="replace[\'+i+\']" rows="10" cols="50"></textarea></td></tr>\'),1<$("#srFields").children().length&&$("#removeField").prop("disabled",!1)}),$("#removeField").click(function(){1<$("#srFields").children().length&&$("#srFields").children(":last-child").remove(),1==$("#srFields").children().length&&$(this).prop("disabled",!0)}),$("#container .slide > div form input.prev").click(function(e){return $(this).parents(".slide").prev(".slide").children("h2").click(),!1}),$("#container .slide:not(:last-child) > div form").submit(function(e){var slideTimeout,$this=$(this),$next=$this.parents(".slide").next(".slide").children("div").children("div"),$nexts=($this.parents(".slide").prev(".slide").children("div").children("div"),$this.parents(".slide").siblings(".slide").slice($this.parents(".slide").index()).children("div").children("div")),$prevs=$this.parents(".slide").siblings(".slide").slice(0,$this.parents(".slide").index()).children("div").children("div");return $next.parents(".slide").is(":last-child")&&$this.find("#confirmed").is(":not(:checked)")?$this.find(".errormessage").text("Please confirm the data stated above is correct!"):window.DBSR_stepping||(window.DBSR_stepping=!0,$nexts.block({message:null,overlayCSS:{cursor:"default"}}),$next.block({message:"Processing data from previous step..."}),$next.parents(".slide").is(":last-child")?($next.block({message:"Executing search and replace..."}),$this.parents(".slide").next(".slide").children("h2").not(".selected").click(),$("#container .slide:not(:last-child) > div > div").block({message:null,overlayCSS:{cursor:"default"}})):slideTimeout=setTimeout(function(){$this.parents(".slide").next(".slide").children("h2").not(".selected").click()},400),$.ajax({type:"POST",url:"?ajax&step",data:$this.serialize(),dataType:"json",success:function(response,status,xhr){if(clearTimeout(slideTimeout),response.valid){if($this.find(".errormessage").text(""),response.error&&$next.find(".errormessage").text(response.error),response.data)for(i in response.data)$("#container .data-"+i).each(function(){$(this).is("input")?$(this).is(":checkbox")?$(this).prop("checked",response.data[i]):$(this).val(response.data[i]):$(this).text(response.data[i])});if(response.html)for(i in response.html)$("#container .html-"+i).each(function(){$(this).html(response.html[i])});$("#container .values-switch a.values-raw").click(),$next.unblock(),$this.parents(".slide").next(".slide").children("h2").not(".selected").click(),window.DBSR_stepping=!1}else $this.find(".errormessage").text(response.error),$this.parents(".slide").children("div").children("div").unblock(),$this.parents(".slide").children("h2").not(".selected").click(),$nexts.block({message:null,overlayCSS:{cursor:"default"}}),$prevs.unblock(),window.DBSR_stepping=!1},error:function(response,status,xhr){$next.block({message:"Error processing request: "+status}),$this.parents(".slide").next(".slide").children("h2").not(".selected").click(),window.DBSR_stepping=!1}})),!1}),$("#container .slide:last-child > div form input:submit").click(function(e){return $("#selfdestruct").is(":checked")?($("#container .slide:last-child > div > div").block({message:"Self-destruction in progress..."}),$.ajax({type:"POST",url:"?ajax&selfdestruct",dataType:"json",success:function(response,status,xhr){response?$("#container .slide:last-child > div > div").block({message:"Self-destruction succesful!",css:{cursor:"default"},overlayCSS:{cursor:"default"}}):$("#container .slide:last-child > div > div").block({message:"Failed to self-destruct, please delete this file manually!",css:{cursor:"default"},overlayCSS:{cursor:"default"}})},error:function(response,status,xhr){$("#container .slide:last-child > div > div").block({message:"Error while self-destructing: "+status,overlayCSS:{cursor:"default"}})}})):($("#confirmed").prop("checked",!1),$("#container .slide:last-child > div > div").block({message:null,overlayCSS:{cursor:"default"}}),$("#container .slide:first-child > div > div").unblock(),$("#container .slide:first-child h2").click()),!1});var cache={};$("input.autocomplete").autocomplete({minLength:1,source:function(request,response){var spu=$("#db_user").val()+"@"+$("#db_host").val()+":"+$("#db_port").val(),id=$(this.element).attr("id"),term=request.term;spu in cache&&id in cache[spu]&&term in cache[spu][id]?response(cache[spu][id][term]):(request.id=id,$.ajax({type:"POST",url:"?ajax&autocomplete",data:$.param(request)+"&"+$(this.element[0].form).serialize(),dataType:"json",success:function(data,status,xhr){0<data.length&&(cache[spu]||(cache[spu]={}),cache[spu][id]||(cache[spu][id]={}),cache[spu][id][term]=data),response(data)}}))}})});';public static $templatehtml='normal:<!DOCTYPE html><html lang="en"><head><meta charset="UTF-8" /><title>DBSR: Database Search and Replace</title><meta name="description" content="DBSR provides functionality for commiting search-and-replace-operations on MySQL databases." /><link href="?resource=favicon.ico" rel="shortcut icon" /><link href="?resource=css/style.css" rel="stylesheet" type="text/css" /><script type="text/javascript" src="?resource=js/script.js"></script></head><body><h1>DBSR: Database Search and Replace</h1><p class="version">DBSR version <span class="data-DBSR_version">VERSION</span> GUI</p><noscript><p>This page requires JavaScript to work properly!</p></noscript><div id="container"><ol><li><h2><span>Database connection information</span></h2><div><div><form method="post"><h2>Database connection information</h2><p> Enter the connection details for the database server below. </p><table><tbody><tr><td><label for="db_host">Hostname</label></td><td><input name="db_host" id="db_host" type="text" class="data-db_host" /></td></tr><tr><td><label for="db_port">Port number</label></td><td><input name="db_port" id="db_port" type="text" class="data-db_port" /></td></tr><tr><td><label for="db_user">Username</label></td><td><input name="db_user" id="db_user" type="text" class="data-db_user" /></td></tr><tr><td><label for="db_pass">Password</label></td><td><input name="db_pass" id="db_pass" type="password" class="data-db_pass" /></td></tr><tr><td><label for="db_name">Database</label></td><td><input name="db_name" id="db_name" type="text" class="data-db_name autocomplete" /></td></tr><tr><td><label for="db_char">Charset</label></td><td><input name="db_char" id="db_char" type="text" class="data-db_char autocomplete" /></td></tr></tbody></table><p><input type="hidden" name="step" value="1" /><input type="submit" value="Next" /></p><p class="errormessage"></p></form></div></div></li><li><h2><span>Search and replace options</span></h2><div><div><form method="post"><h2>Search and replace options</h2><p> You have selected the database "<span class="data-db_name">DATABASE NAME</span>" on <span class="data-db_host">DATABASE HOST</span><span class="data-db_port prefix-colon">:PORT</span>. The connection will use the <span class="data-db_char">DATABASE CHARSET</span> character set. </p><p> Please enter the search and replaces values in the form below. </p><table><thead><tr><th>Search for:</th><th>Replace with:</th></tr></thead><tfoot><tr><td colspan="2"><input type="button" value="+" id="addField" /><input type="button" value="-" id="removeField" disabled="disabled" /><span class="note-right" style="float: right;">Note that all values are processed in order and thus may replace preceding values.</span></td></tr></tfoot><tbody id="srFields"><tr><td><textarea name="search[0]" rows="10" cols="50"></textarea></td><td><textarea name="replace[0]" rows="10" cols="50"></textarea></td></tr></tbody></table><p> When searching for a specific string it\'s sometimes useful to enter escaped sequences such as "<code>\\n</code>" or <code>\\x5C</code>".<br /> Checking the box below will make DBSR interpret all escaped sequences as PHP would in a double-quoted string.<br /><input type="checkbox" name="escapedvalues" id="escapedvalues" class="data-escapedvalues" /><label for="escapedvalues">Interpret PHP escaped sequences.</label></p><p> Case-insensitive search is disabled by default since most databases and filesystems are case-sensitive.<br /> Toggeling this settings might come in handy when running search-and-replace actions for user input.<br /><input type="checkbox" name="dbsr_caseinsensitive" id="dbsr_caseinsensitive" class="data-dbsr_caseinsensitive" /><label for="dbsr_caseinsensitive">Case-insensitive search.</label></p><p> For performance reasons, DBSR normally only processes rows which contain one or more of the plain search strings.<br /> Checking the box below will make DBSR search through <b>every</b> field in the entire database, even if the search string does not occur in it.<br /> This may be useful when due to serialization the exact search strings do not occour in the database or when using DBSR to repair currupted serialized strings.<br /><i>Note:</i> This makes DBSR a lot slower. In most cases, when there are no special characters in your search value, you shouldn\'t use this option.<br /><input type="checkbox" name="dbsr_extensivesearch" id="dbsr_extensivesearch" class="data-dbsr_extensivesearch" /><label for="dbsr_extensivesearch">Run an extended search.</label></p><p><input type="hidden" name="step" value="2" /><input type="button" value="Previous" class="prev" /><input type="submit" value="Next" /></p><p class="errormessage"></p></form></div></div></li><li><h2><span>Confirmation</span></h2><div><div><form method="post"><h2>Confirmation</h2><p> You selected the database "<span class="data-db_name">DATABASE NAME</span>" on <span class="data-db_host">DATABASE HOST</span><span class="data-db_port">:PORT</span>. The connection will use the <span class="data-db_char">DATABASE CHARSET</span> character set. </p><p>The following strings will be used for search-and-replace:</p><table><thead><tr><th>Search for:</th><th>Replace with:</th></tr></thead><tfoot><tr><td colspan="2"><span class="values-switch"> View as <a href="#" class="values-raw">raw values</a>, <a href="#" class="values-escaped">PHP escaped values</a> or <a href="#" class="values-hex">hex values</a></span></td></tr></tfoot><tbody class="values-raw html-values_raw"><tr><td><code>RAW SEARCH VALUE</code></td><td><code>RAW REPLACE VALUE</code></td></tr></tbody><tbody class="values-escaped html-values_escaped"><tr><td><code>ESCAPED SEARCH VALUE</code></td><td><code>ESCAPED REPLACE VALUE</code></td></tr></tbody><tbody class="values-hex html-values_hex"><tr><td><code>HEX SEARCH VALUE</code></td><td><code>HEX REPLACE VALUE</code></td></tr></tbody></table><div class="html-suggestions"></div><p> It is highly recommended to make a backup of your database before using DBSR!<br /> If you haven\'t done so yet, do it now! Remember Murphy\'s law! </p><p><input type="checkbox" name="confirmed" id="confirmed" /><label for="confirmed">Yes, I have read the warnings above and checked that the search and replaces values are correct.</label></p><p><input type="hidden" name="step" value="3" /><input type="button" value="Previous" class="prev" /><input type="submit" value="Start!" /></p><p class="errormessage"></p></form></div></div></li><li><h2><span>Results</span></h2><div><div><form method="post"><h2>Results</h2><p><span class="data-result">RESULT</span> occurence(s) found and replaced. </p><p><input type="checkbox" name="selfdestruct" id="selfdestruct" disabled="disabled" /><label for="selfdestruct">Delete DBSR from the web server.</label><br /><input type="submit" value="Restart" /></p><p class="errormessage"></p></form></div></div></li></ol></div></body></html> ';public static $webfonts_SourceCodeProBoldwoff='base64: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';public static $webfonts_SourceCodeProRegularwoff='base64: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';public static $webfonts_SourceSansProBoldwoff='base64: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';public static $webfonts_SourceSansProRegularwoff='base64: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';public static function getResource($resource){$resource=preg_replace('/[^\w]/','',preg_replace('#[/\\\\]#','_',$resource));if(isset(static ::$$resource)){switch(substr(static ::$$resource,0,6)){case 'base64':return base64_decode(substr(static ::$$resource,7));default:case 'normal':return substr(static ::$$resource,7);}}else{return FALSE;}}}class DBSR_GUI{const FORMAT_STRING_PLAINHTML=0;const FORMAT_STRING_PHPESCAPE=1;const FORMAT_STRING_HEXEDITOR=2;protected $options=array();protected $maxStep=0;public static function formatString($string,$format=self::FORMAT_STRING_PLAINHTML){if(!is_string($string)){return false;}$result='';switch($format){case static ::FORMAT_STRING_PHPESCAPE:$result.='"';for($i=0;$i<strlen($string);$i++){switch($string[$i]){case "\n":$result.='\\n';break;case "\r":$result.='\\r';break;case "\t":$result.='\\t';break;case "\x0B":$result.='\\v';break;case "\x1B":$result.='\\e';break;case "\x0C":$result.='\\f';break;case '\\':$result.='\\\\';break;case "\"":$result.='\\"';break;default:$ord=ord($string[$i]);if($ord>=32&&$ord<127){$result.=htmlspecialchars($string[$i]);}else{$result.='\\x'.str_pad(strtoupper(dechex($ord)),2,'0',STR_PAD_LEFT);}break;}}$result.='"';break;case static ::FORMAT_STRING_HEXEDITOR:static $pad='.';static $from='';static $to='';if($from===''){for($i=0;$i<=0xFF;$i++){$from.=chr($i);$to.=($i>=0x20&&$i<=0x7E)?chr($i):$pad;}}$width=max(min(strlen($string),strlen($string)>48?16:8),1);$hex=str_split(bin2hex($string),$width*2);$chars=str_split(strtr($string,$from,$to),$width);$offset=0;$leftpad=strlen((string)strlen($string));foreach($hex as $i=>$line){$result.='<b>';$result.=str_pad($offset,$leftpad,' ',STR_PAD_LEFT);$result.='</b> : ';$result.=str_pad(implode(' ',str_split($line,2)),3*$width,' ',STR_PAD_RIGHT);$result.=' [<i>';$result.=htmlspecialchars(str_pad($chars[$i],$width,' ',STR_PAD_RIGHT));$result.='</i>]<br />'."\n";$offset+=$width;}break;case static ::FORMAT_STRING_PLAINHTML:default:$result=htmlspecialchars($string);break;}return $result;}public static function levenshtein($str1,$str2){$len1=strlen($str1);$len2=strlen($str2);$i=0;do{if(substr($str1,$i,1)!=substr($str2,$i,1)){break;}$i++;$len1--;$len2--;}while($len1>0&&$len2>0);if($i>0){$str1=substr($str1,$i);$str2=substr($str2,$i);}$i=0;do{if(substr($str1,$len1-1,1)!=substr($str2,$len2-1,1)){break;}$i++;$len1--;$len2--;}while($len1>0&&$len2>0);if($i>0){$str1=substr($str1,0,$len1);$str2=substr($str2,0,$len2);}if($len1==0){return $len2;}if($len2==0){return $len1;}$v0=range(0,$len1);$v1=array();for($i=1;$i<=$len2;$i++){$v1[0]=$i;$str2j=substr($str2,$i-1,1);for($j=1;$j<=$len1;$j++){$cost=(substr($str1,$j-1,1)==$str2j)?0:1;$m_min=$v0[$j]+1;$b=$v1[$j-1]+1;$c=$v0[$j-1]+$cost;if($b<$m_min){$m_min=$b;}if($c<$m_min){$m_min=$c;}$v1[$j]=$m_min;}$vTmp=$v0;$v0=$v1;$v1=$vTmp;}return $v0[$len1];}public static function getResource($resource){if(class_exists('DBSR_GUI_Resources',false)){return DBSR_GUI_Resources::getResource($resource);}if(preg_match('/\\.\\.[\\/\\\\]/',$resource)){return false;}$resource=str_replace('/',\DIRECTORY_SEPARATOR,$resource);$resource=__DIR__.\DIRECTORY_SEPARATOR.'DBSR_GUI_Resources'.\DIRECTORY_SEPARATOR.$resource;if(!is_readable($resource)||!is_file($resource)){return false;}return@file_get_contents($resource);}public static function getPDO($db_host=null,$db_port=null,$db_user=null,$db_pass=null,$db_name=null,$db_char=null){$pdo_options=array(PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,);$dsn='mysql:';if(!empty($db_host)){$dsn.='host='.$db_host;if(!empty($db_port)){$dsn.=':'.$db_port;}$dsn.=';';}if(!empty($db_name)){$dsn.='dbname='.$db_name.';';}if(!empty($db_char)){$pdo_options[PDO::MYSQL_ATTR_INIT_COMMAND]='SET NAMES '.$db_char;$dsn.='charset='.$db_char.';';}return new PDO($dsn,$db_user,$db_pass,$pdo_options);}public static function detectConfig(){$variables=array('db_host'=>'DB_HOST','db_user'=>'DB_USER','db_pass'=>'DB_PASSWORD','db_name'=>'DB_NAME','db_char'=>'DB_CHARSET','wp_prefix'=>'$table_prefix',);$configfiles=array('database.conf.php','wp-config.php','..'.\DIRECTORY_SEPARATOR.'database.conf.php','..'.\DIRECTORY_SEPARATOR.'wp-config.php',);$detected=array();foreach($configfiles as $configfile){if(count($variables)>0){if(file_exists($configfile)&&($config=file_get_contents($configfile))){$config_blocks=array($config);$regex_block='/(?:[iI][fF]\s*\(\s*[sS][tT][rR][iI]?(?:[sS][tT][rR]|[pP][oO][sS])\s*\(\s*\$_SERVER\s*\[\s*[\'"]SERVER_NAME[\'"]\s*\]\s*,\s*[\'"]((?:[^\'"]|\\\\\'|\\\\")*)[\'"]\s*\)[^\)]*\)|[eE][lL][sS][eE])\s*(\{(?:[^\{\}]*|\2)*\})/ms';if(preg_match_all($regex_block,$config,$matches,PREG_SET_ORDER)){foreach($matches as&$match){array_shift($match);if($match[0]==''||stripos($_SERVER['SERVER_NAME'],$match[0])!==false){array_unshift($config_blocks,$match[1]);break;}}}foreach($config_blocks as $config_block){if(count($variables)>0){foreach($variables as $varname=>$variable){if(count($variables)>0){if($variable[0]=='$'){$regex_variable='/'.preg_quote($variable).'\s*=\s*[\'"](([^\'"]|\\\\\'|\\\\")*)[\'"]\s*;/';}else{$regex_variable='/[dD][eE][fF][iI][nN][eE]\s*\(\s*[\'"]'.preg_quote($variable).'[\'"]\s*,\s*[\'"](([^\'"]|\\\\\'|\\\\")*)[\'"]\s*\)\s*;/';}if(preg_match($regex_variable,$config_block,$matches)){$detected[$varname]=$matches[1];unset($variables[$varname]);}}}}}}}}if(isset($detected['db_host'])&&preg_match('/^(.*):(\d+)$/',$detected['db_host'],$matches)){$detected['db_host']=$matches[1];$detected['db_port']=$matches[2];}if(isset($detected['db_host'])&&!isset($detected['db_port'])){$detected['db_port']=null;}return $detected;}public static function autoComplete($id,$term,$arguments){switch($id){case 'db_name':try{$pdo=static ::getPDO(@$arguments['db_host'],@$arguments['db_port'],@$arguments['db_user'],@$arguments['db_pass'],null,null);$result=$pdo->query('SHOW DATABASES;',PDO::FETCH_COLUMN,0);$databases=array();foreach($result as $r){if(strtolower(substr($r,0,strlen($term)))==strtolower($term)){$databases[]=$r;}}return $databases;}catch(Exception$e){return array();}break;case 'db_char':try{$pdo=static ::getPDO(@$arguments['db_host'],@$arguments['db_port'],@$arguments['db_user'],@$arguments['db_pass'],null,null);$result=$pdo->query('SHOW CHARACTER SET;',PDO::FETCH_COLUMN,0);$charsets=array();foreach($result as $r){if(strtolower(substr($r,0,strlen($term)))==strtolower($term)){$charsets[]=$r;}}return $charsets;}catch(Exception$e){return array();}break;default:return array();}}public function __construct(){$this->resetStep();}public function completeStep($step,$arguments){if($step>$this->maxStep+1){return array('valid'=>false,'error'=>'First complete step '.($this->maxStep+1).'!');}switch($step){case 1:if(!isset($arguments['db_host'])||empty($arguments['db_host'])){return array('valid'=>false,'error'=>'Please enter a hostname!',);}if(!isset($arguments['db_name'])||empty($arguments['db_name'])){return array('valid'=>false,'error'=>'Please enter a database name!',);}if(!isset($arguments['db_char'])||empty($arguments['db_char'])){return array('valid'=>false,'error'=>'Please enter a character set!',);}try{$pdo=static ::getPDO(@$arguments['db_host'],@$arguments['db_port'],@$arguments['db_user'],@$arguments['db_pass'],@$arguments['db_name'],@$arguments['db_char']);$pdo->query('SHOW TABLES;');}catch(Exception$e){return array('valid'=>false,'error'=>$e->getMessage(),);}$this->maxStep=$step;$this->options['db_host']=@$arguments['db_host'];$this->options['db_port']=@$arguments['db_port'];$this->options['db_user']=@$arguments['db_user'];$this->options['db_pass']=@$arguments['db_pass'];$this->options['db_name']=@$arguments['db_name'];$this->options['db_char']=@$arguments['db_char'];return array('valid'=>true,'data'=>array('db_host'=>@$arguments['db_host'],'db_port'=>@$arguments['db_port'],'db_user'=>@$arguments['db_user'],'db_pass'=>@$arguments['db_pass'],'db_name'=>@$arguments['db_name'],'db_char'=>@$arguments['db_char'],),);case 2:if(!is_array(@$arguments['search'])||count(@$arguments['search'])==0){return array('valid'=>false,'error'=>'Missing search values!',);}if(!is_array(@$arguments['replace'])||count(@$arguments['replace'])==0||count(@$arguments['search'])!=count(@$arguments['replace'])){return array('valid'=>false,'error'=>'Missing replace values!',);}$arguments['search']=array_values(@$arguments['search']);$arguments['replace']=array_values(@$arguments['replace']);$escapedvalues=isset($arguments['escapedvalues'])&&strtolower($arguments['escapedvalues'])=='on';if($escapedvalues){for($i=0;$i<count($arguments['search']);$i++){$arguments['search'][$i]=stripcslashes($arguments['search'][$i]);$arguments['replace'][$i]=stripcslashes($arguments['replace'][$i]);}}for($i=0;$i<count($arguments['search']);$i++){if(empty($arguments['search'][$i])){return array('valid'=>false,'error'=>'Search-value cannot be empty!',);}if($arguments['search'][$i]===$arguments['replace'][$i]){array_splice($arguments['search'],$i,1);array_splice($arguments['replace'],$i,1);$i--;}}if(count($arguments['search'])==0){return array('valid'=>false,'error'=>'All given search- and replace-values are identical!',);}$this->maxStep=$step;$this->options['search']=$arguments['search'];$this->options['replace']=$arguments['replace'];$this->options['escapedvalues']=$escapedvalues;$this->options['dbsr_caseinsensitive']=isset($arguments['dbsr_caseinsensitive'])&&strtolower($arguments['dbsr_caseinsensitive'])=='on';$this->options['dbsr_extensivesearch']=isset($arguments['dbsr_extensivesearch'])&&strtolower($arguments['dbsr_extensivesearch'])=='on';$values=array();foreach(array('values_raw'=> static ::FORMAT_STRING_PLAINHTML,'values_escaped'=> static ::FORMAT_STRING_PHPESCAPE,'values_hex'=> static ::FORMAT_STRING_HEXEDITOR,)as $name=>$type){$values[$name]='';for($i=0;$i<count($arguments['search']);$i++){$values[$name].='<tr><td><code>';$values[$name].= static ::formatString($arguments['search'][$i],$type);$values[$name].='</code></td><td><code>';$values[$name].= static ::formatString($arguments['replace'][$i],$type);$values[$name].='</code></td></tr>';}}$suggestions=$this->getSuggestions();if(count($suggestions)>0){$values['suggestions']='<p>'.implode('</p><p>',$suggestions).'</p>';}else{$values['suggestions']='';}return array('valid'=>true,'data'=>array('escapedvalues'=>$this->options['escapedvalues'],'dbsr_caseinsensitive'=>$this->options['dbsr_caseinsensitive'],'dbsr_extensivesearch'=>$this->options['dbsr_extensivesearch'],),'html'=>$values,);case 3:if(!isset($arguments['confirmed'])||strtolower($arguments['confirmed'])!='on'){return array('valid'=>false,'error'=>'Please confirm the data stated above is correct!',);}try{$pdo=static ::getPDO($this->options['db_host'],$this->options['db_port'],$this->options['db_user'],$this->options['db_pass'],$this->options['db_name'],$this->options['db_char']);$dbsr=new DBSR($pdo);$dbsr->setOption(DBSR::OPTION_CASE_INSENSITIVE,$this->options['dbsr_caseinsensitive']);$dbsr->setOption(DBSR::OPTION_EXTENSIVE_SEARCH,$this->options['dbsr_extensivesearch']);$dbsr->setValues($this->options['search'],$this->options['replace']);$this->resetStep();$result=$dbsr->exec();return array('valid'=>true,'data'=>array('result'=>$result,),);}catch(Exception$e){return array('valid'=>true,'error'=>$e->getMessage(),'errorCode'=>$e->getCode(),'errorFile'=>$e->getFile(),'errorLine'=>$e->getLine(),'errorTrace'=>$e->getTrace(),);}default:return array('valid'=>false,'error'=>'Unknown step!',);}}public function resetStep(){$this->maxStep=0;}protected function getSuggestions(){$messages=array();$pdo=static ::getPDO($this->options['db_host'],$this->options['db_port'],$this->options['db_user'],$this->options['db_pass'],$this->options['db_name'],$this->options['db_char']);$config=static ::detectConfig();$wp_prefix=!empty($config['wp_prefix'])?$config['wp_prefix']:'wp_';$domain_regex='/^https?:\\/\\/([a-z0-9](?:[-a-z0-9]*[a-z0-9])?(?:\\.[a-z0-9](?:[-a-z0-9]*[a-z0-9])?)*)\\/?$/iS';$domain=false;$specialchars=false;$newlines=false;$spelling_probes=array($_SERVER['SERVER_NAME'],__DIR__,);try{$result=$pdo->query('SELECT `option_value` FROM `'.$wp_prefix.'options` WHERE `option_name` = \'siteurl\'',PDO::FETCH_COLUMN,0)->fetch();if(!empty($result)){$result=preg_replace($domain_regex,'$1',$result);if(!in_array($result,$spelling_probes)){$spelling_probes[]=$result;}$result=preg_replace('/^www\\.(.+)$/i','$1',$result);if(!in_array($result,$spelling_probes)){$spelling_probes[]=$result;}}}catch(PDOException$e){}try{$result=$pdo->query('SELECT `option_value` FROM `'.$wp_prefix.'options` WHERE `option_name` = \'recently_edited\'',PDO::FETCH_COLUMN,0)->fetch();if(!empty($result)){$result=preg_replace('/^(\\/.*)\\/wp-content\\/.*$/i','$1',preg_replace('/^.*s:\d+:"([^"]+)";.*$/i','$1',$result));if(strpos($result,'"')===false&&!in_array($result,$spelling_probes)){$spelling_probes[]=$result;}}}catch(PDOException$e){}for($i=0;$i<count($this->options['search']);$i++){if(!$domain&&preg_match($domain_regex,$this->options['search'][$i])&&preg_match($domain_regex,$this->options['replace'][$i])){$domain=true;$messages[]='It seems you\'re going to replace a domain name.<br />Be aware that it is recommended to omit any pre- and suffixes (such as <code>http://</code> or a trailing slash) to ensure <b>all</b> occurences of the domain name will be replaced.';}else{foreach($spelling_probes as $probe){if($this->options['dbsr_caseinsensitive']){if(strtolower($this->options['search'][$i])!=strtolower($probe)&& static ::levenshtein(strtolower($this->options['search'][$i]),strtolower($probe))<4){$messages[]='I suspect you might have made a typo in the '.($i+1).'th search-value. Did you mean "<code>'.htmlspecialchars($probe).'</code>"?';}if(strtolower($this->options['replace'][$i])!=strtolower($probe)&& static ::levenshtein(strtolower($this->options['replace'][$i]),strtolower($probe))<4){$messages[]='I suspect you might have made a typo in the '.($i+1).'th replace-value. Did you mean "<code>'.htmlspecialchars($probe).'</code>"?';}}else{if($this->options['search'][$i]!=$probe&& static ::levenshtein($this->options['search'][$i],$probe)<4){$messages[]='I suspect you might have made a typo in the '.($i+1).'th search-value. Did you mean "<code>'.htmlspecialchars($probe).'</code>"?';}if($this->options['replace'][$i]!=$probe&& static ::levenshtein($this->options['replace'][$i],$probe)<4){$messages[]='I suspect you might have made a typo in the '.($i+1).'th replace-value. Did you mean "<code>'.htmlspecialchars($probe).'</code>"?';}}}}for($j=0;$j<strlen($this->options['search'][$i])&&!$specialchars;$j++){$ord=ord($this->options['search'][$i][$j]);if($ord<9||($ord>10&&$ord<13)||($ord>13&&$ord<32)||$ord>=127){$messages[]='There are some non-ASCII characters in your search value(s).<br />Be aware that DBSR does not provide any transliteration support, thus leaving character encoding entirely up to your browser and the database. Be sure to set the correct charset, and optionally use the "extended search" option of DBSR.';$specialchars=true;}}for($j=0;$j<strlen($this->options['replace'][$i])&&!$specialchars;$j++){$ord=ord($this->options['replace'][$i][$j]);if($ord<9||($ord>10&&$ord<13)||($ord>13&&$ord<32)||$ord>=127){$messages[]='There are some non-ASCII characters in your replace value(s).<br />Be aware that DBSR does not provide any transliteration support, thus leaving character encoding entirely up to your browser and the database. Be sure to set the correct charset, and optionally use the "extended search" option of DBSR.';$specialchars=true;}}if(!$newlines&&!$this->options['escapedvalues']){if(strpos($this->options['search'][$i],"\n")!==false){$newlines=true;$messages[]='You\'ve used '.(strpos($_SESSION['search'][$i],"\r\n")!==false?'Windows-style ("<code>\r\n</code>")':'Unix-style ("<code>\n</code>")').' line endings. If this is not what you want, go back and change it.';}if(!$newlines&&strpos($this->options['replace'][$i],"\n")!==false){$newlines=true;$messages[]='You\'ve used '.(strpos($_SESSION['replace'][$i],"\r\n")!==false?'Windows-style ("<code>\r\n</code>")':'Unix-style ("<code>\n</code>")').' line endings. If this is not what you want, go back and change it.';}}}return $messages;}}class Bootstrapper{private static $is_initialized=false;public static function exception_error_handler($errno,$errstr,$errfile,$errline){if(($errno&error_reporting())!=0){throw new ErrorException($errstr,0,$errno,$errfile,$errline);}}public static function autoloader($class_name){if(class_exists($class_name)){return true;}$include_paths=explode(PATH_SEPARATOR,get_include_path());foreach($include_paths as $include_path){if(empty($include_path)||!is_dir($include_path)){continue;}$include_path=rtrim($include_path,'\\/'.\DIRECTORY_SEPARATOR).\DIRECTORY_SEPARATOR;foreach(array('.php','.php5','.inc.php','.inc.php5','.inc')as $extension){$count=substr_count($class_name,'_');for($i=0;$i<=$count;$i++){$filename=$include_path.preg_replace('/_/',\DIRECTORY_SEPARATOR,$class_name,$i).$extension;if(is_readable($filename)){include_once $filename;if(class_exists($class_name)){return true;}}}}}return false;}protected static function stripslashes_recursive($value){return is_array($value)?array_map(array(__CLASS__,'stripslashes_recursive'),$value):(is_string($value)?stripslashes($value):$value);}public static function initialize(){if(static ::$is_initialized){return;}set_error_handler(array(__CLASS__,'exception_error_handler'));if(!defined('DEBUG')){define('DEBUG',false);}error_reporting(DEBUG?E_ALL:0);set_include_path(get_include_path().PATH_SEPARATOR.realpath(__DIR__));spl_autoload_register(array(__CLASS__,'autoloader'));if(function_exists('get_magic_quotes_gpc')&&@get_magic_quotes_gpc()){$_POST=static ::stripslashes_recursive($_POST);$_GET=static ::stripslashes_recursive($_GET);$_COOKIE=static ::stripslashes_recursive($_COOKIE);$_REQUEST=static ::stripslashes_recursive($_REQUEST);@ini_set('magic_quotes_gpc',false);}if(function_exists('set_magic_quotes_runtime')){@set_magic_quotes_runtime(false);}@ini_set('memory_limit','-1');@ini_set('pcre.recursion_limit','100');@ini_set('default_charset','UTF-8');if(extension_loaded('mbstring')){@mb_internal_encoding('UTF-8');}if(version_compare(PHP_VERSION,'5.6','<')&&extension_loaded('iconv')){@iconv_set_encoding('internal_encoding','UTF-8');}date_default_timezone_set('UTC');static ::$is_initialized=true;}public static function sessionDestroy(){$_SESSION=array();session_destroy();session_commit();}public static function sessionStart(){$security_data=array('server_ip'=>@$_SERVER['SERVER_ADDR'],'server_file'=>__FILE__,'client_ip'=>$_SERVER['REMOTE_ADDR'],'client_ua'=>$_SERVER['HTTP_USER_AGENT']);@ini_set('sessions.gc_maxlifetime',(string)(60*60*24));session_name('DBSR_session');session_start();if(session_id()==''||!isset($_SESSION['_session_security_data'])){$_SESSION['_session_security_data']=$security_data;}else{if($_SESSION['_session_security_data']!==$security_data){static ::sessionDestroy();static ::sessionStart();}}}}Bootstrapper::initialize();Bootstrapper::sessionStart();function DBSR_GUI_ExceptionHandler($e){if(isset($_GET['ajax'])){header('Content-Type: application/json');exit(json_encode(array('error'=>$e->getMessage(),'errorCode'=>$e->getCode(),'errorFile'=>$e->getFile(),'errorLine'=>$e->getLine(),'errorTrace'=>$e->getTrace(),)));}else{throw $e;}}set_exception_handler('DBSR_GUI_ExceptionHandler');if(!isset($_GET['ajax'])&&!isset($_GET['resource'])){Bootstrapper::sessionDestroy();Bootstrapper::sessionStart();}if(!isset($_SESSION['DBSR_GUI'])){$_SESSION['DBSR_GUI']=new DBSR_GUI();}$dbsr_gui=$_SESSION['DBSR_GUI'];if(isset($_GET['ajax'])){header('Content-Type: application/json');if(!extension_loaded('json')){exit('{"error":"The PHP JSON extension is not available!"}');}if(isset($_GET['initialize'])){exit(json_encode(array('data'=>DBSR_GUI::detectConfig()+array('DBSR_version'=>DBSR::VERSION,),'selfdestruct'=>class_exists('DBSR_GUI_Resources',false)&&realpath(__FILE__)==realpath($_SERVER['SCRIPT_FILENAME'])&&is_writable(__FILE__),)));}if(isset($_GET['autocomplete'])){exit(json_encode(DBSR_GUI::autoComplete($_POST['id'],$_POST['term'],$_POST)));}if(isset($_GET['step'])){exit(json_encode($dbsr_gui->completeStep((int)$_POST['step'],$_POST)));}if(isset($_GET['selfdestruct'])){exit(json_encode(class_exists('DBSR_GUI_Resources',false)&&realpath(__FILE__)==realpath($_SERVER['SCRIPT_FILENAME'])&&@unlink(__FILE__)));}header('HTTP/1.1 400 Bad Request');exit(json_encode(array('error'=>'Unknown action!')));}else{if(!isset($_GET['resource'])){$_GET['resource']='template.html';}if($resource=DBSR_GUI::getResource($_GET['resource'])){switch(strtolower(preg_replace('/^.*\.(\w+)$/','$1',$_GET['resource']))){case 'html':header('Content-Type: text/html; charset=UTF-8');if(isset($_SERVER['HTTP_USER_AGENT'])&&strpos($_SERVER['HTTP_USER_AGENT'],'MSIE')!==false){header('X-UA-Compatible: IE=edge,chrome=IE8');}break;case 'css':header('Content-Type: text/css');break;case 'js':header('Content-Type: text/javascript');break;case 'png':header('Content-Type: image/png');break;case 'woff':header('Content-Type: application/x-font-woff');break;case 'otf':header('Content-Type: application/x-font-otf');break;case 'eot':header('Content-Type: application/x-font-eot');break;case 'ttf':header('Content-Type: application/x-font-ttf');break;case 'svg':header('Content-Type: image/svg+xml');break;case 'ico':header('Content-Type: image/vnd.microsoft.icon');break;}header('Content-Disposition: inline; filename='.basename($_GET['resource']));if(extension_loaded('zlib')&&ini_get('output_handler')!='ob_gzhandler'){@ini_set('zlib.output_compression',true);}if(class_exists('DBSR_GUI_Resources',false)){header('Expires: '.gmdate('D, d M Y H:i:s \\G\\M\\T',time()+7*24*60*60));}exit($resource);}else{header('HTTP/1.1 404 Not Found');exit;}}