# -*- coding:utf-8 -*-
"""
@Author  :   g1879
@Contact :   g1879@qq.com
"""
from http.cookiejar import Cookie
from typing import Union

from requests import Session
from requests.cookies import RequestsCookieJar
from requests.structures import CaseInsensitiveDict

from DrissionPage.base import DrissionElement, BasePage
from DrissionPage.chromium_element import ChromiumElement
from DrissionPage.chromium_base import ChromiumBase


class ResponseData(object):

    def __init__(self, request_id: str, response: dict, body: str, tab: str, target: str):
        self.requestId: str = ...
        self.response: CaseInsensitiveDict = ...
        self.rawBody: str = ...
        self._body: Union[str, dict, bytes] = ...
        self._base64_body: bool = ...
        self.tab: str = ...
        self.target: str = ...
        self.method: str = ...
        self._postData: dict = ...
        self._rawPostData: str = ...
        self.url: str = ...
        self.status: str = ...
        self.statusText: str = ...
        self.headersText: str = ...
        self.mimeType: str = ...
        self.requestHeadersText: str = ...
        self.connectionReused: str = ...
        self.connectionId: str = ...
        self.remoteIPAddress: str = ...
        self.remotePort: str = ...
        self.fromDiskCache: str = ...
        self.fromServiceWorker: str = ...
        self.fromPrefetchCache: str = ...
        self.encodedDataLength: str = ...
        self.timing: str = ...
        self.serviceWorkerResponseSource: str = ...
        self.responseTime: str = ...
        self.cacheStorageCacheName: str = ...
        self.protocol: str = ...
        self.securityState: str = ...
        self.securityDetails: str = ...

    def __getattr__(self, item: str) -> Union[str, None]: ...

    def __getitem__(self, item: str) -> Union[str, None]: ...

    def __repr__(self) -> str: ...

    @property
    def headers(self) -> Union[CaseInsensitiveDict, None]: ...

    @property
    def requestHeaders(self) -> Union[CaseInsensitiveDict, None]: ...

    @requestHeaders.setter
    def requestHeaders(self, val: dict) -> None: ...

    @property
    def postData(self) -> Union[dict, str, None]: ...

    @postData.setter
    def postData(self, val: Union[str, dict]) -> None: ...

    @property
    def body(self) -> Union[str, dict, bytes]: ...


def get_ele_txt(e: DrissionElement) -> str: ...


def format_html(text: str) -> str: ...


def location_in_viewport(page: ChromiumBase, loc_x: int, loc_y: int) -> bool: ...


def offset_scroll(ele: ChromiumElement, offset_x: int, offset_y: int) -> tuple: ...


def make_absolute_link(link, page: BasePage = None) -> str: ...


def is_js_func(func: str) -> bool: ...


def cookie_to_dict(cookie: Union[Cookie, str, dict]) -> dict: ...


def cookies_to_tuple(cookies: Union[RequestsCookieJar, list, tuple, str, dict]) -> tuple: ...


def set_session_cookies(session: Session, cookies: Union[RequestsCookieJar, list, tuple, str, dict]) -> None: ...


def set_browser_cookies(page: ChromiumBase, cookies: Union[RequestsCookieJar, list, tuple, str, dict]) -> None: ...


def is_cookie_in_driver(page: ChromiumBase, cookie: dict) -> bool: ...
