# -*- coding:utf-8 -*-
"""
@Author  :   g1879
@Contact :   g1879@qq.com
"""
from typing import Union, Tuple

from .chromium_base import ChromiumBase
from .chromium_driver import ChromiumDriver
from .chromium_element import ChromiumElement
from .chromium_page import ChromiumPage


class ActionChains:

    def __init__(self, page: ChromiumBase):
        self.page: ChromiumPage = ...
        self._dr: ChromiumDriver = ...
        self.modifier: int = ...
        self.curr_x: int = ...
        self.curr_y: int = ...

    def move_to(self, ele_or_loc: Union[ChromiumElement, Tuple[int, int], str],
                offset_x: int = 0, offset_y: int = 0) -> ActionChains: ...

    def move(self, offset_x: int = 0, offset_y: int = 0) -> ActionChains: ...

    def click(self, on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def r_click(self, on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def m_click(self, on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def db_click(self, on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def hold(self, on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def release(self, on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def r_hold(self, on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def r_release(self, on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def m_hold(self, on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def m_release(self, on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def _hold(self, on_ele: Union[ChromiumElement, str] = None, button: str = 'left',
              count: int = 1) -> ActionChains: ...

    def _release(self, button: str) -> ActionChains: ...

    def scroll(self, delta_x: int = 0, delta_y: int = 0,
               on_ele: Union[ChromiumElement, str] = None) -> ActionChains: ...

    def up(self, pixel: int) -> ActionChains: ...

    def down(self, pixel: int) -> ActionChains: ...

    def left(self, pixel: int) -> ActionChains: ...

    def right(self, pixel: int) -> ActionChains: ...

    def key_down(self, key: str) -> ActionChains: ...

    def key_up(self, key: str) -> ActionChains: ...

    def type(self, text: Union[str, list, tuple]) -> ActionChains: ...

    def wait(self, second: float) -> ActionChains: ...

    def _get_key_data(self, key: str, action: str) -> dict: ...


def location_to_client(page, lx: int, ly: int) -> tuple: ...
