#pragma once

#define CSR_SSTATUS 0x100
#define CSR_SIE 0x104
#define CSR_STVEC 0x105
#define CSR_SIP 0x144
#define CSR_SSCRATCH 0x140

#define CSR_TVEC CSR_STVEC
#define CSR_SCRATCH CSR_SSCRATCH

#define CSR_STATUS CSR_SSTATUS
#define CSR_IE CSR_SIE
#define CSR_IP CSR_SIP

#define SR_FS 0x00006000
#define SR_VS 0x00000600
#define SR_FS_VS (SR_FS | SR_VS) /* Vector and Floating-Point Unit */

#define SATP_MODE_39 0x8000000000000000ULL
#define SATP_MODE_48 0x9000000000000000ULL
#define SATP_MODE_57 0xa000000000000000ULL

#define PAGE_OFFSET 0xffffffc000000000
#define KERNEL_LINK_OFFSET 0x1000000
#define KERNEL_VIRT_START (PAGE_OFFSET + KERNEL_LINK_OFFSET)