use core::ops::Deref;

#[repr(align(128))]
pub struct Crc64Table {
    pub table: [u64; 256],
    pub poly: u64,
}

impl Crc64Table {
    pub const fn new(poly: u64, table: [u64; 256]) -> Self {
        Self { poly, table }
    }
}

impl Deref for Crc64Table {
    type Target = [u64; 256];

    fn deref(&self) -> &Self::Target {
        &self.table
    }
}

pub const CRC64_TABLE: Crc64Table = Crc64Table::new(
    0x42F0E1EBA9EA3693,
    [
        0x0000000000000000,
        0x42f0e1eba9ea3693,
        0x85e1c3d753d46d26,
        0xc711223cfa3e5bb5,
        0x493366450e42ecdf,
        0x0bc387aea7a8da4c,
        0xccd2a5925d9681f9,
        0x8e224479f47cb76a,
        0x9266cc8a1c85d9be,
        0xd0962d61b56fef2d,
        0x17870f5d4f51b498,
        0x5577eeb6e6bb820b,
        0xdb55aacf12c73561,
        0x99a54b24bb2d03f2,
        0x5eb4691841135847,
        0x1c4488f3e8f96ed4,
        0x663d78ff90e185ef,
        0x24cd9914390bb37c,
        0xe3dcbb28c335e8c9,
        0xa12c5ac36adfde5a,
        0x2f0e1eba9ea36930,
        0x6dfeff5137495fa3,
        0xaaefdd6dcd770416,
        0xe81f3c86649d3285,
        0xf45bb4758c645c51,
        0xb6ab559e258e6ac2,
        0x71ba77a2dfb03177,
        0x334a9649765a07e4,
        0xbd68d2308226b08e,
        0xff9833db2bcc861d,
        0x388911e7d1f2dda8,
        0x7a79f00c7818eb3b,
        0xcc7af1ff21c30bde,
        0x8e8a101488293d4d,
        0x499b3228721766f8,
        0x0b6bd3c3dbfd506b,
        0x854997ba2f81e701,
        0xc7b97651866bd192,
        0x00a8546d7c558a27,
        0x4258b586d5bfbcb4,
        0x5e1c3d753d46d260,
        0x1cecdc9e94ace4f3,
        0xdbfdfea26e92bf46,
        0x990d1f49c77889d5,
        0x172f5b3033043ebf,
        0x55dfbadb9aee082c,
        0x92ce98e760d05399,
        0xd03e790cc93a650a,
        0xaa478900b1228e31,
        0xe8b768eb18c8b8a2,
        0x2fa64ad7e2f6e317,
        0x6d56ab3c4b1cd584,
        0xe374ef45bf6062ee,
        0xa1840eae168a547d,
        0x66952c92ecb40fc8,
        0x2465cd79455e395b,
        0x3821458aada7578f,
        0x7ad1a461044d611c,
        0xbdc0865dfe733aa9,
        0xff3067b657990c3a,
        0x711223cfa3e5bb50,
        0x33e2c2240a0f8dc3,
        0xf4f3e018f031d676,
        0xb60301f359dbe0e5,
        0xda050215ea6c212f,
        0x98f5e3fe438617bc,
        0x5fe4c1c2b9b84c09,
        0x1d14202910527a9a,
        0x93366450e42ecdf0,
        0xd1c685bb4dc4fb63,
        0x16d7a787b7faa0d6,
        0x5427466c1e109645,
        0x4863ce9ff6e9f891,
        0x0a932f745f03ce02,
        0xcd820d48a53d95b7,
        0x8f72eca30cd7a324,
        0x0150a8daf8ab144e,
        0x43a04931514122dd,
        0x84b16b0dab7f7968,
        0xc6418ae602954ffb,
        0xbc387aea7a8da4c0,
        0xfec89b01d3679253,
        0x39d9b93d2959c9e6,
        0x7b2958d680b3ff75,
        0xf50b1caf74cf481f,
        0xb7fbfd44dd257e8c,
        0x70eadf78271b2539,
        0x321a3e938ef113aa,
        0x2e5eb66066087d7e,
        0x6cae578bcfe24bed,
        0xabbf75b735dc1058,
        0xe94f945c9c3626cb,
        0x676dd025684a91a1,
        0x259d31cec1a0a732,
        0xe28c13f23b9efc87,
        0xa07cf2199274ca14,
        0x167ff3eacbaf2af1,
        0x548f120162451c62,
        0x939e303d987b47d7,
        0xd16ed1d631917144,
        0x5f4c95afc5edc62e,
        0x1dbc74446c07f0bd,
        0xdaad56789639ab08,
        0x985db7933fd39d9b,
        0x84193f60d72af34f,
        0xc6e9de8b7ec0c5dc,
        0x01f8fcb784fe9e69,
        0x43081d5c2d14a8fa,
        0xcd2a5925d9681f90,
        0x8fdab8ce70822903,
        0x48cb9af28abc72b6,
        0x0a3b7b1923564425,
        0x70428b155b4eaf1e,
        0x32b26afef2a4998d,
        0xf5a348c2089ac238,
        0xb753a929a170f4ab,
        0x3971ed50550c43c1,
        0x7b810cbbfce67552,
        0xbc902e8706d82ee7,
        0xfe60cf6caf321874,
        0xe224479f47cb76a0,
        0xa0d4a674ee214033,
        0x67c58448141f1b86,
        0x253565a3bdf52d15,
        0xab1721da49899a7f,
        0xe9e7c031e063acec,
        0x2ef6e20d1a5df759,
        0x6c0603e6b3b7c1ca,
        0xf6fae5c07d3274cd,
        0xb40a042bd4d8425e,
        0x731b26172ee619eb,
        0x31ebc7fc870c2f78,
        0xbfc9838573709812,
        0xfd39626eda9aae81,
        0x3a28405220a4f534,
        0x78d8a1b9894ec3a7,
        0x649c294a61b7ad73,
        0x266cc8a1c85d9be0,
        0xe17dea9d3263c055,
        0xa38d0b769b89f6c6,
        0x2daf4f0f6ff541ac,
        0x6f5faee4c61f773f,
        0xa84e8cd83c212c8a,
        0xeabe6d3395cb1a19,
        0x90c79d3fedd3f122,
        0xd2377cd44439c7b1,
        0x15265ee8be079c04,
        0x57d6bf0317edaa97,
        0xd9f4fb7ae3911dfd,
        0x9b041a914a7b2b6e,
        0x5c1538adb04570db,
        0x1ee5d94619af4648,
        0x02a151b5f156289c,
        0x4051b05e58bc1e0f,
        0x87409262a28245ba,
        0xc5b073890b687329,
        0x4b9237f0ff14c443,
        0x0962d61b56fef2d0,
        0xce73f427acc0a965,
        0x8c8315cc052a9ff6,
        0x3a80143f5cf17f13,
        0x7870f5d4f51b4980,
        0xbf61d7e80f251235,
        0xfd913603a6cf24a6,
        0x73b3727a52b393cc,
        0x31439391fb59a55f,
        0xf652b1ad0167feea,
        0xb4a25046a88dc879,
        0xa8e6d8b54074a6ad,
        0xea16395ee99e903e,
        0x2d071b6213a0cb8b,
        0x6ff7fa89ba4afd18,
        0xe1d5bef04e364a72,
        0xa3255f1be7dc7ce1,
        0x64347d271de22754,
        0x26c49cccb40811c7,
        0x5cbd6cc0cc10fafc,
        0x1e4d8d2b65facc6f,
        0xd95caf179fc497da,
        0x9bac4efc362ea149,
        0x158e0a85c2521623,
        0x577eeb6e6bb820b0,
        0x906fc95291867b05,
        0xd29f28b9386c4d96,
        0xcedba04ad0952342,
        0x8c2b41a1797f15d1,
        0x4b3a639d83414e64,
        0x09ca82762aab78f7,
        0x87e8c60fded7cf9d,
        0xc51827e4773df90e,
        0x020905d88d03a2bb,
        0x40f9e43324e99428,
        0x2cffe7d5975e55e2,
        0x6e0f063e3eb46371,
        0xa91e2402c48a38c4,
        0xebeec5e96d600e57,
        0x65cc8190991cb93d,
        0x273c607b30f68fae,
        0xe02d4247cac8d41b,
        0xa2dda3ac6322e288,
        0xbe992b5f8bdb8c5c,
        0xfc69cab42231bacf,
        0x3b78e888d80fe17a,
        0x7988096371e5d7e9,
        0xf7aa4d1a85996083,
        0xb55aacf12c735610,
        0x724b8ecdd64d0da5,
        0x30bb6f267fa73b36,
        0x4ac29f2a07bfd00d,
        0x08327ec1ae55e69e,
        0xcf235cfd546bbd2b,
        0x8dd3bd16fd818bb8,
        0x03f1f96f09fd3cd2,
        0x41011884a0170a41,
        0x86103ab85a2951f4,
        0xc4e0db53f3c36767,
        0xd8a453a01b3a09b3,
        0x9a54b24bb2d03f20,
        0x5d45907748ee6495,
        0x1fb5719ce1045206,
        0x919735e51578e56c,
        0xd367d40ebc92d3ff,
        0x1476f63246ac884a,
        0x568617d9ef46bed9,
        0xe085162ab69d5e3c,
        0xa275f7c11f7768af,
        0x6564d5fde549331a,
        0x279434164ca30589,
        0xa9b6706fb8dfb2e3,
        0xeb46918411358470,
        0x2c57b3b8eb0bdfc5,
        0x6ea7525342e1e956,
        0x72e3daa0aa188782,
        0x30133b4b03f2b111,
        0xf7021977f9cceaa4,
        0xb5f2f89c5026dc37,
        0x3bd0bce5a45a6b5d,
        0x79205d0e0db05dce,
        0xbe317f32f78e067b,
        0xfcc19ed95e6430e8,
        0x86b86ed5267cdbd3,
        0xc4488f3e8f96ed40,
        0x0359ad0275a8b6f5,
        0x41a94ce9dc428066,
        0xcf8b0890283e370c,
        0x8d7be97b81d4019f,
        0x4a6acb477bea5a2a,
        0x089a2aacd2006cb9,
        0x14dea25f3af9026d,
        0x562e43b4931334fe,
        0x913f6188692d6f4b,
        0xd3cf8063c0c759d8,
        0x5dedc41a34bbeeb2,
        0x1f1d25f19d51d821,
        0xd80c07cd676f8394,
        0x9afce626ce85b507,
    ],
);

pub const CRC64_ROCKSOFT_TABLE: Crc64Table = Crc64Table::new(
    0x9A6C9329AC4BC9B5,
    [
        0x0000000000000000,
        0x7f6ef0c830358979,
        0xfedde190606b12f2,
        0x81b31158505e9b8b,
        0xc962e5739841b68f,
        0xb60c15bba8743ff6,
        0x37bf04e3f82aa47d,
        0x48d1f42bc81f2d04,
        0xa61cecb46814fe75,
        0xd9721c7c5821770c,
        0x58c10d24087fec87,
        0x27affdec384a65fe,
        0x6f7e09c7f05548fa,
        0x1010f90fc060c183,
        0x91a3e857903e5a08,
        0xeecd189fa00bd371,
        0x78e0ff3b88be6f81,
        0x078e0ff3b88be6f8,
        0x863d1eabe8d57d73,
        0xf953ee63d8e0f40a,
        0xb1821a4810ffd90e,
        0xceecea8020ca5077,
        0x4f5ffbd87094cbfc,
        0x30310b1040a14285,
        0xdefc138fe0aa91f4,
        0xa192e347d09f188d,
        0x2021f21f80c18306,
        0x5f4f02d7b0f40a7f,
        0x179ef6fc78eb277b,
        0x68f0063448deae02,
        0xe943176c18803589,
        0x962de7a428b5bcf0,
        0xf1c1fe77117cdf02,
        0x8eaf0ebf2149567b,
        0x0f1c1fe77117cdf0,
        0x7072ef2f41224489,
        0x38a31b04893d698d,
        0x47cdebccb908e0f4,
        0xc67efa94e9567b7f,
        0xb9100a5cd963f206,
        0x57dd12c379682177,
        0x28b3e20b495da80e,
        0xa900f35319033385,
        0xd66e039b2936bafc,
        0x9ebff7b0e12997f8,
        0xe1d10778d11c1e81,
        0x606216208142850a,
        0x1f0ce6e8b1770c73,
        0x8921014c99c2b083,
        0xf64ff184a9f739fa,
        0x77fce0dcf9a9a271,
        0x08921014c99c2b08,
        0x4043e43f0183060c,
        0x3f2d14f731b68f75,
        0xbe9e05af61e814fe,
        0xc1f0f56751dd9d87,
        0x2f3dedf8f1d64ef6,
        0x50531d30c1e3c78f,
        0xd1e00c6891bd5c04,
        0xae8efca0a188d57d,
        0xe65f088b6997f879,
        0x9931f84359a27100,
        0x1882e91b09fcea8b,
        0x67ec19d339c963f2,
        0xd75adabd7a6e2d6f,
        0xa8342a754a5ba416,
        0x29873b2d1a053f9d,
        0x56e9cbe52a30b6e4,
        0x1e383fcee22f9be0,
        0x6156cf06d21a1299,
        0xe0e5de5e82448912,
        0x9f8b2e96b271006b,
        0x71463609127ad31a,
        0x0e28c6c1224f5a63,
        0x8f9bd7997211c1e8,
        0xf0f5275142244891,
        0xb824d37a8a3b6595,
        0xc74a23b2ba0eecec,
        0x46f932eaea507767,
        0x3997c222da65fe1e,
        0xafba2586f2d042ee,
        0xd0d4d54ec2e5cb97,
        0x5167c41692bb501c,
        0x2e0934dea28ed965,
        0x66d8c0f56a91f461,
        0x19b6303d5aa47d18,
        0x980521650afae693,
        0xe76bd1ad3acf6fea,
        0x09a6c9329ac4bc9b,
        0x76c839faaaf135e2,
        0xf77b28a2faafae69,
        0x8815d86aca9a2710,
        0xc0c42c4102850a14,
        0xbfaadc8932b0836d,
        0x3e19cdd162ee18e6,
        0x41773d1952db919f,
        0x269b24ca6b12f26d,
        0x59f5d4025b277b14,
        0xd846c55a0b79e09f,
        0xa72835923b4c69e6,
        0xeff9c1b9f35344e2,
        0x90973171c366cd9b,
        0x1124202993385610,
        0x6e4ad0e1a30ddf69,
        0x8087c87e03060c18,
        0xffe938b633338561,
        0x7e5a29ee636d1eea,
        0x0134d92653589793,
        0x49e52d0d9b47ba97,
        0x368bddc5ab7233ee,
        0xb738cc9dfb2ca865,
        0xc8563c55cb19211c,
        0x5e7bdbf1e3ac9dec,
        0x21152b39d3991495,
        0xa0a63a6183c78f1e,
        0xdfc8caa9b3f20667,
        0x97193e827bed2b63,
        0xe877ce4a4bd8a21a,
        0x69c4df121b863991,
        0x16aa2fda2bb3b0e8,
        0xf86737458bb86399,
        0x8709c78dbb8deae0,
        0x06bad6d5ebd3716b,
        0x79d4261ddbe6f812,
        0x3105d23613f9d516,
        0x4e6b22fe23cc5c6f,
        0xcfd833a67392c7e4,
        0xb0b6c36e43a74e9d,
        0x9a6c9329ac4bc9b5,
        0xe50263e19c7e40cc,
        0x64b172b9cc20db47,
        0x1bdf8271fc15523e,
        0x530e765a340a7f3a,
        0x2c608692043ff643,
        0xadd397ca54616dc8,
        0xd2bd67026454e4b1,
        0x3c707f9dc45f37c0,
        0x431e8f55f46abeb9,
        0xc2ad9e0da4342532,
        0xbdc36ec59401ac4b,
        0xf5129aee5c1e814f,
        0x8a7c6a266c2b0836,
        0x0bcf7b7e3c7593bd,
        0x74a18bb60c401ac4,
        0xe28c6c1224f5a634,
        0x9de29cda14c02f4d,
        0x1c518d82449eb4c6,
        0x633f7d4a74ab3dbf,
        0x2bee8961bcb410bb,
        0x548079a98c8199c2,
        0xd53368f1dcdf0249,
        0xaa5d9839ecea8b30,
        0x449080a64ce15841,
        0x3bfe706e7cd4d138,
        0xba4d61362c8a4ab3,
        0xc52391fe1cbfc3ca,
        0x8df265d5d4a0eece,
        0xf29c951de49567b7,
        0x732f8445b4cbfc3c,
        0x0c41748d84fe7545,
        0x6bad6d5ebd3716b7,
        0x14c39d968d029fce,
        0x95708ccedd5c0445,
        0xea1e7c06ed698d3c,
        0xa2cf882d2576a038,
        0xdda178e515432941,
        0x5c1269bd451db2ca,
        0x237c997575283bb3,
        0xcdb181ead523e8c2,
        0xb2df7122e51661bb,
        0x336c607ab548fa30,
        0x4c0290b2857d7349,
        0x04d364994d625e4d,
        0x7bbd94517d57d734,
        0xfa0e85092d094cbf,
        0x856075c11d3cc5c6,
        0x134d926535897936,
        0x6c2362ad05bcf04f,
        0xed9073f555e26bc4,
        0x92fe833d65d7e2bd,
        0xda2f7716adc8cfb9,
        0xa54187de9dfd46c0,
        0x24f29686cda3dd4b,
        0x5b9c664efd965432,
        0xb5517ed15d9d8743,
        0xca3f8e196da80e3a,
        0x4b8c9f413df695b1,
        0x34e26f890dc31cc8,
        0x7c339ba2c5dc31cc,
        0x035d6b6af5e9b8b5,
        0x82ee7a32a5b7233e,
        0xfd808afa9582aa47,
        0x4d364994d625e4da,
        0x3258b95ce6106da3,
        0xb3eba804b64ef628,
        0xcc8558cc867b7f51,
        0x8454ace74e645255,
        0xfb3a5c2f7e51db2c,
        0x7a894d772e0f40a7,
        0x05e7bdbf1e3ac9de,
        0xeb2aa520be311aaf,
        0x944455e88e0493d6,
        0x15f744b0de5a085d,
        0x6a99b478ee6f8124,
        0x224840532670ac20,
        0x5d26b09b16452559,
        0xdc95a1c3461bbed2,
        0xa3fb510b762e37ab,
        0x35d6b6af5e9b8b5b,
        0x4ab846676eae0222,
        0xcb0b573f3ef099a9,
        0xb465a7f70ec510d0,
        0xfcb453dcc6da3dd4,
        0x83daa314f6efb4ad,
        0x0269b24ca6b12f26,
        0x7d0742849684a65f,
        0x93ca5a1b368f752e,
        0xeca4aad306bafc57,
        0x6d17bb8b56e467dc,
        0x12794b4366d1eea5,
        0x5aa8bf68aecec3a1,
        0x25c64fa09efb4ad8,
        0xa4755ef8cea5d153,
        0xdb1bae30fe90582a,
        0xbcf7b7e3c7593bd8,
        0xc399472bf76cb2a1,
        0x422a5673a732292a,
        0x3d44a6bb9707a053,
        0x759552905f188d57,
        0x0afba2586f2d042e,
        0x8b48b3003f739fa5,
        0xf42643c80f4616dc,
        0x1aeb5b57af4dc5ad,
        0x6585ab9f9f784cd4,
        0xe436bac7cf26d75f,
        0x9b584a0fff135e26,
        0xd389be24370c7322,
        0xace74eec0739fa5b,
        0x2d545fb4576761d0,
        0x523aaf7c6752e8a9,
        0xc41748d84fe75459,
        0xbb79b8107fd2dd20,
        0x3acaa9482f8c46ab,
        0x45a459801fb9cfd2,
        0x0d75adabd7a6e2d6,
        0x721b5d63e7936baf,
        0xf3a84c3bb7cdf024,
        0x8cc6bcf387f8795d,
        0x620ba46c27f3aa2c,
        0x1d6554a417c62355,
        0x9cd645fc4798b8de,
        0xe3b8b53477ad31a7,
        0xab69411fbfb21ca3,
        0xd407b1d78f8795da,
        0x55b4a08fdfd90e51,
        0x2ada5047efec8728,
    ],
);
