# Notifier Chian 通知链

## 1.原理概要

&emsp;&emsp;通知链是内核中各个子系统之间或子系统内部各个模块之间的事件通知机制。通知链本质上是一个事件处理函数的列表，每个通知链都与某个类型的事件相关（例如 reboot 事件）。当特定的事件发生时，就会调用相应事件的通知链中的回调函数，使子系统/模块对事件响应，并进行相对应的处理。

&emsp;&emsp;通知链和订阅功能有些类似，可以理解为：有个“通知者”维护了一个列表，“订阅者”将自己的回调函数注册进这个列表（“订阅者”当然也可以注销自己的回调函数）。当某个事件发生需要通知时，“通知者”就遍历这个列表中所有的回调函数并进行调用，这样所有注册的“订阅者”就能针对这个事件做出自己的响应和处理。

## 2.核心功能

### 2.1 注册回调函数

&emsp;&emsp;将回调函数封装成特定的结构体，并将该结构体注册到指定的通知链当中。相关方法为 `register`，由“订阅者”使用。

### 2.2 注销回调函数

&emsp;&emsp;将回调函数从指定的通知链当中进行注销，即从通知链中删去该回调函数。相关方法为 `unregister`，由“订阅者”使用。

### 2.3 事件通知

&emsp;&emsp;当某个事件发生时，该事件相关的通知链通过该方法来进行事件通知。`call_chain` 这个方法会遍历通知链中的所有元素，并依次调用注册的回调函数。该方法由“通知者”使用。

## 3.通知链类型

&emsp;&emsp;每种通知链都有相对应的 `register`，`unregister` 以及 `call_chain` 的接口，其功能同上面所述的核心功能。

- `AtomicNotifierChain`：原子的通知链，不可睡眠，建议用于中断上下文。
- `BlockingNotifierChain`：可阻塞的通知链，可以睡眠，建议用在进程上下文。
- `RawNotifierChain`：原始的通知链，由调用者自行考虑线程安全。

## 4. 其它问题

&emsp;&emsp;`BlockingNotifierChain` 暂时没实现可睡眠的功能。
