# V0.1.9

:::{note}
本文作者：何懿聪 <heyicong@dragonos.org>

DragonOS官方论坛：[bbs.dragonos.org.cn](https://bbs.dragonos.org.cn)

2024年3月13日
:::

## 贡献者名单

DragonOS V0.1.9版本由以下小伙伴贡献代码：

- 龙进 <longjin@DragonOS.org>
- 何懿聪 <heyicong@dragonos.rog>
- 裕依 <68320855+yuyi2439@users.noreply.github.com>
- R0ronoa <84278015+2447742618@users.noreply.github.com>
- 池克俭 <39649411+Chiichen@users.noreply.github.com>
- 吴宇健 <wuyujian@dragonos.org>
- zhaoyao73 <zhaoyao73@users.noreply.github.com>
- 胡兆朋 <105195940+MemoryShore@users.noreply.github.com>
- 周瀚杰 <zhouhanjie@dragonos.org>
- 栗子 <im.lechain@gmail.com>
- Xshine <gshine@m.scnu.edu.cn>
- Chenzx <109664121+schulice@users.noreply.github.com>
- MContour <m-contour@qq.com>
- Donkey Kane <109840258+xiaolin2004@users.noreply.github.com>
- Luo Jia / Zhouqi Jiang <luojia@hust.edu.cn>
- Wu Mianzhi <31810920+Hdksg10@users.noreply.github.com>
- Xiaoye Zheng <xiaoyez@zju.edu.cn>
- Plucky923 <107762234+Plucky923@users.noreply.github.com>
- 许梓毫 <xuzihao@dragonos.org>

## 赞助商列表

- **[中国雅云](https://yacloud.net)** 雅安大数据产业园为DragonOS提供了云服务器支持。


## 赞助者名单

感谢以下同学的赞赏，我们将不断努力！


- David Wen
- 万晓兰
- 龙进
- 吴宇健


两千元以下：

- [Seele.Clover](https://github.com/seeleclover)
- [FindWangHao](https://github.com/FindWangHao)
- [ferchiel](https://github.com/ferchiel)
- 叶锦毅
- 林
- Albert
- [TerryLeeSCUT · GitHub](https://github.com/TerryLeeSCUT)
- slientbard
- 悟
- 匿名热心人士

## 更新内容-内核

### 新特性

- refactor: 重构进程管理模块 ([#380](https://github.com/DragonOS-Community/DragonOS/pull/380))
- feature: 完善设备驱动模型 ([#401](https://github.com/DragonOS-Community/DragonOS/pull/401))
- feature: 实现e1000e网卡驱动 ([#393](https://github.com/DragonOS-Community/DragonOS/pull/393))
- feature: DragonOS虚拟化框架([#389](https://github.com/DragonOS-Community/DragonOS/pull/389))
- feature: 支持syscall快速系统调用指令([#417](https://github.com/DragonOS-Community/DragonOS/pull/417))
- refactor: 重写apic驱动 ([#425](https://github.com/DragonOS-Community/DragonOS/pull/425))
- feature: 线程机制与futex ([#411](https://github.com/DragonOS-Community/DragonOS/pull/411))
- feature: DragonStub引导DragonOS内核 ([#460](https://github.com/DragonOS-Community/DragonOS/pull/460))
- feature: 实现Epoll IO多路复用机制 ([#455](https://github.com/DragonOS-Community/DragonOS/pull/455))
- feature: 帧缓冲抽象以及vesafb驱动 ([#483](https://github.com/DragonOS-Community/DragonOS/pull/483))
- feature: 增加early io remap的fixmap功能 ([#495](https://github.com/DragonOS-Community/DragonOS/pull/495))
- feature: 实现内核日志系统 ([#489](https://github.com/DragonOS-Community/DragonOS/pull/489))
- refactor: 使用Rust重写x86_64下内核初始化代码([#507](https://github.com/DragonOS-Community/DragonOS/pull/507))
- feature: 新增riscv64架构的内存管理等([#506](https://github.com/DragonOS-Community/DragonOS/pull/506))
- refactor: 中断管理模块重构完成([#554](https://github.com/DragonOS-Community/DragonOS/pull/554))
- refactor: 重构tty模块，实现unix兼容tty([#577](https://github.com/DragonOS-Community/DragonOS/pull/577))
- featurn: 实现若干POSIX标准系统调用

### bugfix

- bugfix: 修正由于init proc union导致的无法运行的问题 && 修正由于内核线程启动后默认sleep的行为导致init进程无法正常运行的bug ([#381](https://github.com/DragonOS-Community/DragonOS/pull/381))
- bugfix: 修复了Flusher Drop的时候没有自动刷新TLB的bug([#384](https://github.com/DragonOS-Community/DragonOS/pull/384))
- bugfix: multiboot2启动的信息因为没及时转存导致后面无法从其中进行查询的bug ([#405](https://github.com/DragonOS-Community/DragonOS/pull/405))
- bugfix: 修复bus/device manager对卸载逻辑的处理错误 ([#385](https://github.com/DragonOS-Community/DragonOS/pull/385))
- bugfix: 解决waitqueue sleep的时候,由于preempt count不为0,导致sched失败,从而导致该waitqueue下一次wakeup时,会把pcb多次加入调度队列的bug ([#419](https://github.com/DragonOS-Community/DragonOS/pull/419))
- bugfix: 修正fork的时候没有正确拷贝vm holes的bug ([#433](https://github.com/DragonOS-Community/DragonOS/pull/433))
- bugfix: 当物理机具有多个memory area的时候,无法正确使用这些区域的问题.以及在内核代码处出现内存空洞而导致无法正常运行的问题. ([#448](https://github.com/DragonOS-Community/DragonOS/pull/448))
- bugfix: 修复因rsdp v1 v2版本问题，导致ACPI无法正常初始化的bug ([#454](https://github.com/DragonOS-Community/DragonOS/pull/454))
- bugfix: 修正由于bus的driver、device强弱引用关系 不正确从而导致对象被释放的bug ([#483](https://github.com/DragonOS-Community/DragonOS/pull/483))
- bugfix: 修复文件关闭后epoll还持有对应描述符的文件弱引用的bug ([#455](https://github.com/DragonOS-Community/DragonOS/pull/455))
- bugfix: 修复无法sleep的问题以及进程处于block(true)状态时无法被信号唤醒&唤醒后不处理信号的问题 ([#470](https://github.com/DragonOS-Community/DragonOS/pull/470))

## 更新内容-用户环境

### 新特性

- feature: 新增init程序dragonreach ([#391](https://github.com/DragonOS-Community/DragonOS/pull/391))
- featurn: 新增shell程序NovaShell ([#456](https://github.com/DragonOS-Community/DragonOS/pull/456))
- featurn: 新增文本编辑器Held ([#583](https://github.com/DragonOS-Community/DragonOS/pull/583))
- featurn: 能够支持gcc，tar，redis等程序运行

## 源码、发布版镜像下载

&emsp;&emsp;您可以通过以下方式获得源代码:

### 通过Git获取

- 您可以访问[https://github.com/DragonOS-Community/DragonOS/releases](https://github.com/DragonOS-Community/DragonOS/releases)下载发布版的代码，以及编译好的，可运行的磁盘镜像。

### 通过DragonOS软件镜像站获取

&emsp;&emsp;为解决国内访问GitHub慢、不稳定的问题，同时为了方便开发者们下载DragonOS的每个版本的代码，我们特意搭建了镜像站，您可以通过以下地址访问镜像站：

&emsp;&emsp;您可以通过镜像站获取到DragonOS的代码压缩包，以及编译好的可运行的磁盘镜像。

- [https://mirrors.DragonOS.org.cn](https://mirrors.DragonOS.org.cn)
- [https://git.mirrors.DragonOS.org.cn](https://git.mirrors.DragonOS.org.cn)

## 开放源代码声明

:::{note}
为促进DragonOS项目的健康发展，DragonOS以GPLv2开源协议进行发布。所有能获得到DragonOS源代码以及相应的软件制品（包括但不限于二进制副本、文档）的人，都能享有我们通过GPLv2协议授予您的权利，同时您也需要遵守协议中规定的义务。

这是一个相当严格的，保护开源软件健康发展，不被侵占的协议。

对于大部分的善意的人们而言，您不会违反我们的开源协议。

我们鼓励DragonOS的自由传播、推广，但是请确保所有行为没有侵犯他人的合法权益，也没有违反GPLv2协议。

请特别注意，对于违反开源协议的，尤其是**商业闭源使用以及任何剽窃、学术不端行为将会受到严肃的追责**。（这是最容易违反我们的开源协议的场景）。

并且，请注意，按照GPLv2协议的要求，基于DragonOS修改或二次开发的软件，必须同样采用GPLv2协议开源，并标明其基于DragonOS进行了修改。亦需保证这些修改版本的用户能方便的获取到DragonOS的原始版本。

您必须使得DragonOS的开发者们，能够以同样的方式，从公开渠道获取到您二次开发的版本的源代码，否则您将违反GPLv2协议。

关于协议详细内容，还敬请您请阅读项目根目录下的**LICENSE**文件。请注意，按照GPLv2协议的要求，**只有英文原版才具有法律效力**。任何翻译版本都仅供参考。
:::

### 开源软件使用情况

&emsp;&emsp;DragonOS在开发的过程中，参考了Linux社区的一些设计，或者引入了他们的部分思想，亦或是受到了他们的启发。我们在这里对Linux社区以及Linux社区的贡献者们致以最衷心的感谢！

## 当前版本的所有提交记录

```text
commit af59116e1b8643862598607dbc6ef7233f3791b5
Author: MemoryShore <105195940+MemoryShore@users.noreply.github.com>
Date:   Tue Mar 12 17:52:14 2024 +0800

    Update NovaShell version to c6454d3220 (#593)

commit 59fdb447ee4f7b53b1d9c56ec1442aa8c597ac2b
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Mar 12 16:32:33 2024 +0800

    fix: 键盘中断上下文不再直接操作tty,而是由专门的kthread来渲染 (#592)
  
    fix: 键盘中断上下文不再直接操作tty,而是由专门的kthread来渲染
    1.修正psmouse 日志
    2. 键盘中断上下文不再直接操作tty,而是由专门的kthread来渲染
    3. 由于调度器设计问题,load balance会由于时序问题导致错误.因此暂时只启用单核.

commit 818a64c77613a9c2152739f1cddad78d61e4a94f
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Mar 12 15:33:01 2024 +0800

    暂时禁用load balance (#591)
  
    原因见issue: https://github.com/DragonOS-Community/DragonOS/issues/571

commit 4374bd1d1177dbf94112aee3ea3f8e8c335a599c
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Mon Mar 11 19:40:52 2024 +0800

    修复get_random一个问题，添加Held配置文件 (#583)

commit 52bcb59e9286def2b66d766f6bf6f46745795ec8
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Mon Mar 11 15:13:37 2024 +0800

    完善Tty的RawMode (#577)
  
    * 完善rowmode，改掉一部分bug
  
    * 增加两个ansi拓展功能功能，以及标记部分函数nerve inline
  
    * 修改do_signal和其他中断上下文锁未关中断，以及拓展tty功能，修改tty几个算法bug
  
    * 修改两个锁
  
    * 修改syscall_64
  
    * update

commit 840045af94ea3391f29e87e968db5d9c48316981
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Mar 10 21:45:34 2024 +0800

    引入clippy，并根据clippy的提示，修改部分代码 (#575)

commit f4a82aa55c55e1a9233e99a5598e180f0858d877
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Mar 10 20:42:41 2024 +0800

    Update Novashell version to 473d5c403c (#574)
  
    - fix: 用户输入不正确的;以及单独输入单引号和双引号造成系统重启
    - 修改命令解析算法
    - fix: 输出多余的光标和命令信息

commit 4f8f484930ed3c09ecf4b5b05b1dea14f7b05d8b
Author: 栗子 <im.lechain@gmail.com>
Date:   Sat Mar 9 21:20:12 2024 +0800

    修复Archlinux下的bootstrap脚本问题， (#552)
  
    * 修复Archlinux下的bootstrap脚本问题，
  
    由于archlinux 的 texinfo版本太新导致的gcc docs构建失败
    使用 MAKEINFO=true 的make环境变量跳过gcc docs构建，绕过问题
  
  
    ---------
  
    Co-authored-by: longjin <longjin@dragonos.org>

commit 3055390c25bb7b12279df174689ba09ec50c7d46
Author: Jomo <xuzihao@dragonos.org>
Date:   Sat Mar 9 11:40:44 2024 +0800

    完善重映射过程中获取新映射区域时的map_flags (#569)

commit 5c4224e5a8244cb0fb32512e70354362fccd6321
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Mar 8 23:23:06 2024 +0800

    在riscv上实现异常处理，能够进入异常处理程序 (#564)

commit c3dc6f2ff9169c309d1cbf47dcb9e4528d509b2f
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Mar 8 23:22:48 2024 +0800

    删除一些过时的C代码 (#565)
  
    * 删除C版本的crc库
  
    * 删除lockref
  
    * 删除过时的libc文档以及wait.c
  
    * 删除过时的C版本kfifo代码及文档
  
    * 移除未用到的lz4库
  
    * 删除内核的stdlib.c
  
    * 删除fabs.c
  
    * fmt
  
    * 使得put_string系统调用能够通过tty输出颜色
    暂且这样改，这一部分应该是用户层面提供的功能，后续删除
  
    ---------
  
    Co-authored-by: GnoCiYeH <heyicong@dragonos.org>

commit 5eeefb8c80e5580641d295724f8d2190bd54979c
Author: Chenzx <109664121+schulice@users.noreply.github.com>
Date:   Fri Mar 8 16:01:22 2024 +0800

    实现SYS_RMDIR (#566)
  
    * 实现rmdir系统调用，整理do_remove_dir逻辑

commit 338f6903262c5031abad3c8e361813355a27fcdb
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Mar 5 17:22:04 2024 +0800

    `riscv`: 初始化irq (#560)
  
    完成riscv的irqchip初始化的代码。
  
    这是该功能的第一个PR。由于还需要实现timer驱动才能测试，因此该功能将会通过2~3个PR来完成。

commit bc6f0a967c8cb1e9379ced184b25a7722fbda2a4
Author: 裕依 <68320855+yuyi2439@users.noreply.github.com>
Date:   Mon Mar 4 14:20:01 2024 +0800

    移除relibc和old libc以及旧的shell (#529)
  
    移除relibc和old libc以及旧的shell

commit f3b05a97ec061e766247b18dc12e2a413b977b14
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Mon Mar 4 14:10:26 2024 +0800

    将tty输出接入串口 (#555)

commit cf45dede2e46d9341cec75871fdc1bc5961ba5a2
Author: MContour <m-contour@qq.com>
Date:   Sun Mar 3 17:20:11 2024 +0800

    让 DragonOS 仓库管理 service 文件 (#548)
  
    * feat: create `user/services` folder to store service files

commit e28411791f090c421fe4b6fa5956fb1bd362a8d9
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Mar 3 16:31:08 2024 +0800

    完成中断管理模块重构 (#554)
  
    - 支持中断共享
    - 把现有驱动程序移植到新的irq模块
    - 使用`ProcessorId`标识处理器id
    - 尚未实现threaded_irq
  
    性能上，edge irq flow handler里面，对于锁的使用，可能有点问题。为了获取/修改common data还有其他几个结构体的状态，进行了多次加锁和放锁，导致性能降低。这是接下来需要优化的点。

commit 44d051e5864adff6f4ace8a234ef57852840f365
Author: Donkey Kane <109840258+xiaolin2004@users.noreply.github.com>
Date:   Sun Mar 3 15:22:45 2024 +0800

    Modify dadk config to switch NovaShell revision (#550)

commit 0e7c46939604a02e739546200bea847f4951a963
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Fri Mar 1 15:07:00 2024 +0800

    修改事件等待队列对于retain使用方法出错导致唤醒错误 (#551)

commit be60c929c8285d3050e022aa23312a84129e54b2
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Wed Feb 28 20:18:49 2024 +0800

    修改tty几个bug (#549)
  
    * 更改ioctl一处逻辑错误
  
    * 删除不必要的impl
  
    * 修改一处bug，并且加入tty的link，为pty做准备
  
    * 修改一处因为vc的pos和x计算错误导致的溢出

commit 52da9a59374752b4d01907b052135a0d317781dd
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Mon Feb 26 15:27:19 2024 +0800

    完成与Linux兼容的Ntty (#517)
  
    * 已经完成的功能：
    - 写：printf能够正常在tty输出
    - 读：与键盘驱动接上
    - 信号： 能够正常通过ctrl向前台进程发送信号
  
    * 支持目前的shell，改动printk使其与新版tty兼容。
  
    * 删除原有tty文件夹，并更改新tty文件名
  
    * 添加clear清屏程序
  
    * 实现tty部分ioctl，更改部分问题

commit 9993c0fc61e9603f631bd6748ff0b4fecb7bd483
Author: R0ronoa <84278015+2447742618@users.noreply.github.com>
Date:   Mon Feb 26 15:03:13 2024 +0800

    添加i8042驱动 改正serio设备文件结构 (#538)
  
    * 添加i8042驱动 改正serio设备文件结构

commit d2b28acb4d1f160779b25d76afca49ed60ad5d48
Author: 栗子 <im.lechain@gmail.com>
Date:   Sun Feb 25 19:57:30 2024 +0800

    tools/bootstrap.sh: fix archlinux and zsh issue (#535)
  
    1. archlinux上没有libssl-dev包，相对应的包名是openssl
    2. zsh用户使用bootstrap.sh 会因为 source ~/.zshrc
       导致bash执行很多zsh built-in 指令出现非常多错误
    3. mkdir命令加-p选项避免对象目录存在时（反复执行脚本）报错
    4. 修复简单错误(typo gcc 为 binutils)
    5. 修复bootstrap.sh等脚本无法在非tools/目录执行的错误

commit 7d66c3134c1c5566ac8f8b7524e98650d0480a4a
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Feb 19 21:40:37 2024 +0800

    添加简单的cpumask (#533)

commit b2ca6800f9d943e5d3656d9b50a099da768775a7
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Feb 19 19:50:03 2024 +0800

    添加动态申请的bitmap (#532)

commit 0e2c2e8b48369b201f44e0933f775b932b6776ef
Author: 裕依 <68320855+yuyi2439@users.noreply.github.com>
Date:   Mon Feb 19 19:31:17 2024 +0800

    修正systemerror号 (#527)
  
    修正systemerror号

commit 4cfa009b87c8431a41fab740ffdbd7b008965c9a
Author: Jomo <xuzihao@dragonos.org>
Date:   Mon Feb 19 14:54:11 2024 +0800

    实现mremap系统调用 (#518)
  
    * mremap系统调用

commit 27b967a38a6dd7a266c43b5e705c29dfbbd71ae4
Author: 裕依 <68320855+yuyi2439@users.noreply.github.com>
Date:   Mon Feb 19 14:53:34 2024 +0800

    添加pread&pwrite (#528)
  
    添加pread&pwrite

commit 701589559f912deb03eb5176d049d9d07fb29447
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Feb 19 11:17:23 2024 +0800

    删除无用的C版本bitree和ida/idr. (#526)
  
    这些数据结构不再使用,将其删除.

commit 196b75dc17b5cc2ed84301bce776e496ddfe1ed1
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Feb 19 00:56:58 2024 +0800

    把irqdesc添加到sysfs (#525)
  
    * 把irqdesc添加到sysfs

commit 3bc96fa4a9c01d91cddeb152fe78d6408351c29f
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Feb 19 00:36:36 2024 +0800

    添加irqdesc的抽象，并在系统初始化时创建irqdesc (#522)
  
    * 添加irqdesc的抽象，并在系统初始化时创建irqdesc

commit ce5850adbf74ec6c6717bbb5b1749f1fbff4ca0d
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Feb 18 20:41:41 2024 +0800

    添加irqchip这一层的数据结构(尚未接入真实的芯片) (#520)
  
    * 添加irqchip这一层的数据结构(尚未接入真实的芯片)

commit ca318c376bd9e39f8fe71f304974f7e99e8e01f4
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Feb 17 01:51:10 2024 +0800

    update dragonreach to 3d99c3a9d9 (#519)

commit 472f0b3931eadda2bbcc67889d612790f147190b
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Feb 13 12:14:12 2024 +0800

    update dragonreach to 40362c48d6 (#516)

commit d90848514bea7efd5898f5824b98f1bf2e54de8d
Author: Luo Jia / Zhouqi Jiang <luojia@hust.edu.cn>
Date:   Sat Feb 10 23:20:50 2024 +0800

    riscv: 更新sbi-rt至0.0.3版本 (#512)
  
    先前使用git仓库链接的最新更新已发布至crates.io网站
  
    Signed-off-by: Zhouqi Jiang <luojia@hust.edu.cn>

commit 4ad52e57e612a88ab09413c7ac0072db96a93632
Author: 裕依2439 <68320855+yuyi2439@users.noreply.github.com>
Date:   Wed Feb 7 18:06:15 2024 +0800

    添加socketpair (#505)
  
    * 添加对socketpair系统调用的处理
  
    ---------
  
    Co-authored-by: LoGin <longjin@DragonOS.org>

commit cb23beb255d8e32b45d879ac19386a3597ca4115
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Feb 7 17:15:17 2024 +0800

    riscv: probe sbi extensions (#511)

commit f2022a8a1cc4a8e2a85e9061e036e9c491a2fa00
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Feb 7 13:29:47 2024 +0800

    使用rust编写中断/异常的入口 (#509)
  
    * 使用rust编写中断/异常的入口

commit d14e28a8a9b023ee8df7c2e8eee43e523134dbb2
Author: Luo Jia / Zhouqi Jiang <me@luojia.cc>
Date:   Wed Feb 7 11:38:15 2024 +0800

    riscv: 使用sbi-rt库完成SBI操作 (#510)
  
    未来的其它SBI操作也将使用sbi-rt
  
    Signed-off-by: Zhouqi Jiang <luojia@hust.edu.cn>

commit fccbe87dcae0f8e8fde611ef60b1f7923126d526
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Feb 5 14:50:15 2024 +0800

    删除关于zulip的表述,替换为社区论坛 (#508)

commit 5b59005f930266d0e9c0092373e894826150f862
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Feb 4 15:46:24 2024 +0800

    x86_64: 使用Rust重写内核初始化代码 (#507)
  
    * x86_64: 使用Rust重写内核初始化代码

commit 453452cc02e2766a28d87dd47bdee37caddc4c44
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Feb 4 14:35:18 2024 +0800

    初始化riscv的内存管理模块，并且设置保留内存 (#506)

commit a02ce654cf0166720f8569827d0c5b2dfd0ca95a
Author: Chiichen <chiichen@qq.com>
Date:   Sun Jan 28 20:29:01 2024 +0800

    支持对动态链接文件的加载，支持通过musl工具链编写用户空间程序 (#504)
  
    支持对动态链接文件的加载，支持通过musl工具链编写用户空间程序

commit 5d549a76ab0cf66651a6614be92dcb481fe7af2a
Author: Chiichen <chiichen@qq.com>
Date:   Fri Jan 26 20:45:08 2024 +0800

    修改一处常量定义 (#503)
  
    * 修改一处常量定义
  
    * 修复ELF加载程序对用户程序加载地址判断不正确的地方
  
    ---------
  
    Co-authored-by: longjin <longjin@DragonOS.org>

commit 9284987850c1da2ce607a539eeae8a353a8f6df9
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Jan 26 18:08:39 2024 +0800

    riscv: 完成UEFI初始化,能正确设置memblock的信息 (#501)
  
    * riscv: 完成UEFI初始化,能正确设置memblock的信息
  
    * sbi增加reset功能
  
    * 把虚拟CPU修改为sifive-u54，使qemu能更正确地模拟硬件行为
  
    * 修复内存页面映射未设置“DIRTY”、”ACCESSED“、”GLOBAL“位，导致真机page fault的问题

commit a381e482cbe742b2e4bbeaacae134a8131bf3f91
Author: R0ronoa <84278015+2447742618@users.noreply.github.com>
Date:   Wed Jan 24 19:17:22 2024 +0800

    实现Ps/2鼠标驱动 (#500)
  
    实现Ps/2鼠标驱动

commit 8d72b68da9339ec97e1b8929bcf2946f0fd83cd5
Author: Jomo <xuzihao@dragonos.org>
Date:   Wed Jan 24 16:13:15 2024 +0800

    实现内核日志系统 (#489)
  
    * 实现写日志和读取日志，并且能够在用户态下执行dmesg命令查看日志
  
    * 通过klogctl实现dmesg
  
    * 改用ConstGenericRingBuffer作内核缓冲区
  
    * 更改缓冲区容量
  
    * 将能够输出到控制台的日志级别改为日志级别枚举类，使用SpinLock控制KMSG，使用枚举类定义SYSLOG_ACTION，将do_syslog系统调用接口放在syscall.rs
  
    * fix warning
  
    * 完善do_syslog注释
  
    * 将KMSG接入kinfo、kdebug等
  
    * fix warning
  
    * 修复显示的秒数不正确，·以及无法通过CI的问题

commit d46c6d27941a26de14f55a2bbf956219bcc70871
Author: 裕依2439 <68320855+yuyi2439@users.noreply.github.com>
Date:   Tue Jan 23 23:36:52 2024 +0800

    修复tty的buf满时始终阻塞的问题 (#493)
  
    * 修复tty的buf满时始终阻塞的问题

commit 43ef2a0d2b6ec427f6775cd4593c56897dd5bf6d
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Jan 21 18:45:07 2024 +0800

    添加riscv64的github workflow (#499)
  
    * 添加riscv64的github workflow

commit 7a29d4fcbcd89a226289c7bf541c2c78623de3ad
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Jan 21 15:38:12 2024 +0800

    riscv64: 映射uefi systemtable,并完善了riscv64页表填写的部分内容 (#498)
  
    * 从fdt的chosen段获取几个需要的字段
  
    * merge patch-early-ioremap
  
    * feature: 增加early io remap的fixmap功能
  
    允许在内存管理初始化之前,使用fixmap功能,映射一些物理内存,并记录.
  
    * riscv64: 映射uefi systemtable,并完善了riscv64页表填写的部分内容
  
    * 更新仓库网址

commit 3e3c6316aaac5a8a2932bd1746ec8b900dc5e2c6
Author: Chiichen <chiichen@qq.com>
Date:   Sun Jan 21 01:38:45 2024 +0800

    fix: 修复了ps2和tty初始化顺序的错误 (#497)
  
    * 修复了ps2和tty初始化顺序的错误

commit 74ffde667e5e7f4ac8ce6d5a5ec2c1403f36cbb0
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Jan 21 01:21:55 2024 +0800

    feature: 增加early io remap的fixmap功能 (#495)
  
    允许在内存管理初始化之前,使用fixmap功能,映射一些物理内存,并记录.

commit 1f58c8f5cff8e82441b66789c3dc7c009d52f29a
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Jan 18 22:39:58 2024 +0800

    Update mini-backtrace版本到e0b1d90940 (#494)
  
    内容:
  
    [https://github.com/DragonOS-Community/mini-backtrace/pull/1](https://github.com/DragonOS-Community/mini-backtrace/pull/1)
  
    Co-authored-by: Yao Zhao <dragonlinux@gmail.com>

commit c75ef4e2126c180bf04c08635ffa5a278619c035
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Jan 18 00:09:36 2024 +0800

    添加early ioremap支持 (#492)
  
    * 使用early io remap来映射早期的vesa缓冲区

commit d8e29bffeee4fe4fe76ead3c761dd03f5395e6c2
Author: R0ronoa <84278015+2447742618@users.noreply.github.com>
Date:   Wed Jan 17 23:57:49 2024 +0800

    增加serio总线和相关trait (#488)
  
    * 新增serio总线和相关trait
  
    * 补充SerioDeviceManager和SerioDriverManager

commit 6994f6b113f6fea7b997ec07130a7bdaecfd67b7
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Jan 15 18:13:22 2024 +0800

    完成bitmap的static bitmap功能，能够静态声明bitmap (#490)
  
    * 完成bitmap的static bitmap功能，能够静态声明bitmap

commit dcf232f378b36fad754799fc121a70cadc8d5cb3
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Jan 14 17:00:42 2024 +0800

    当找不到内核日志缓冲区的时候，重试 (#491)

commit 45626c859f95054b76d8b59afcbd24c6b235026f
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Jan 3 18:00:47 2024 +0800

    riscv: 解析dtb，获取可用内存空间并添加到memblock (#486)

commit 02343d0b5b47c07e7f4ec3818940795b1009fae1
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Jan 2 14:16:10 2024 +0800

    增加/dev/fb0，能够在用户程序读写帧缓冲区 (#485)

commit e7071df6a47c100381a8bc2000022e82d422361a
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Jan 1 11:53:49 2024 +0800

    把opengrok.ringotek.cn替换为code.dragonos.org.cn (#484)

commit c566df451ce6dbf2af684333e68b39fdfff86498
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Jan 1 11:46:51 2024 +0800

    添加帧缓冲区抽象并实现vesafb的驱动 (#483)
  
    - 添加bootparams对象
    - 修正由于bus的driver、device强弱引用关系 不正确从而导致对象被释放的bug
    - 添加vesafb的驱动
    - 实现framebuffer抽象层
    - 为通用帧缓冲区抽象实现sysfs的属性
    - 修改设备号DeviceNumber的定义
    - 仿照linux，添加initcall，并在第一个内核线程中，调用他们。

commit e3eb08d4d7148d6dad369e2ef27979d1bcf85bd6
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Dec 30 16:23:26 2023 +0800

    fix: 修复安装musl-gcc的脚本没能正确设置x86_64下的环境变量的问题 (#482)

commit 81294aa2e6b257f0de5e3c28c3f3c89798330836
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Dec 27 20:32:25 2023 +0800

    fix: 修正bootstrap脚本安装docker后会使得当前终端进入root的问题 (#481)

commit cfd642e2835eded086b6e944427e4a88f03e2fff
Author: MemoryShore <105195940+MemoryShore@users.noreply.github.com>
Date:   Wed Dec 27 15:07:01 2023 +0800

    更新nova shell的revision为64ad1b282a (#477)
  
    - 修复tab补全时始终基于根目录的问题
    - 修复touch命令提示已存在文件的bug

commit 5e948c56506aa0554d212341a7630587d55ebb87
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Wed Dec 27 15:02:29 2023 +0800

    修正pipe逻辑，将pipe接入epoll。 (#478)

commit 0d6cf65aa124ee55bfee44cbb5196917ea6522fa
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Dec 27 14:27:12 2023 +0800

    Patch fix sched and net lockdep error (#479)
  
    - fix: 修复调度器,软中断,定时器,网络子系统的部分锁的使用不符合锁依赖安全规范的问题
    - fix: 修复创建pcb时内核栈爆栈的问题
    - 把异常的trap gate改成intr gate
  
    ---------
  
    Co-authored-by: GnoCiYeH <heyicong@dragonos.org>

commit 91e9d4ab55ef960f57a1b6287bc523ca4341f67a
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Dec 25 23:12:27 2023 +0800

    实现unified-init库，支持收集初始化函数到一个数组，并统一初始化 (#474)
  
    * 添加“统一初始化”的过程宏，并把SystemError独立成crate
  
    * 使用unified-init来初始化fbmem
  
    * 更新workflow，增加内核自动化静态测试

commit f110d330d5493f383067b4e82ebbfb72f40457b2
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Dec 25 21:54:00 2023 +0800

    修复bootstrap在安装riscv gcc依赖时出现冲突的问题 (#476)

commit 406099704eb939ae23b18f0cfb3ed36c534c1c84
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Mon Dec 25 18:08:12 2023 +0800

    增加epoll机制 (#455)
  
    * ## 增加epoll机制
    - 增加epoll机制
    - 添加事件等待队列，提升socket性能
    - 优化poll，删除不能poll的文件系统中的poll方法
  
    * 添加细节注释
  
    * 修复文件关闭后epoll还持有对应描述符的文件弱引用的bug
  
    * 将EPollEvent设计为POSIX标准
  
    * 修改s到us转换的计算错误

commit 070e991008b268b7103236a46b8651a983522869
Author: R0ronoa <84278015+2447742618@users.noreply.github.com>
Date:   Fri Dec 22 16:01:23 2023 +0800

    解决由于Makefile问题导致make run-uefi无法正常启动的问题 (#473)

commit 08a2ee408498b0db4c76c57b149f1cf047758f3c
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Dec 20 17:24:05 2023 +0800

    添加FrameBuffer的接口抽象&完善设备驱动模型的class相关代码 (#472)
  
    * 添加FrameBuffer的接口抽象（参考Linux 6.1.9）
  
    * feature: 完善设备驱动模型的class的抽象,并创建graphics class
  
    * feature: 完善设备驱动模型中Device对class的处理,使得能够在class下注册设备
  
    目前注册了fbcon设备,但是由于虚拟终端还没写,因此fbcon的到终端以及帧缓冲区的映射还没加上去.

commit 8612b6ce7afc903999ccf0b65bd65019484d2fad
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Dec 19 11:56:14 2023 +0800

    bugfix: 修复无法sleep的问题以及进程处于block(true)状态时无法被信号唤醒&唤醒后不处理信号的问题 (#470)

commit 24ff1faffb3d610cd55e3c658fd50ea0a0efedfb
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Dec 18 17:44:53 2023 +0800

    doc: 修改Rust代码注释风格文档 (#471)

commit 111c5407ccb7774695c8047cf895481d3387fda9
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Dec 17 21:08:03 2023 +0800

    设置idle进程的时间片为0，降低调度延迟 (#469)

commit 666cffedab3da9684e5abf5eebcbddae63590364
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Dec 16 22:26:26 2023 +0800

    riscv: 映射内核到指定的虚拟地址，使得kinfo能正常工作 (#468)
  
    * riscv: 映射内核到指定的虚拟地址，使得kinfo能正常工作

commit cf442324231632df3c3b0da3d2c8e19087863aa0
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Dec 13 14:44:57 2023 +0800

    修复x86下第二次编译的时候内核没有拷贝到磁盘的问题 (#467)

commit 1a72a751b18cf5bbe7b5b9e91aff530de0c18501
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Dec 7 02:13:22 2023 +0800

    在riscv输出hello world (#466)
  
    增加了以下内容：
    - SBI驱动
    - 把内核的rust工具链升级到2023-08-15版本
    - 输出riscv的helloworld
    - 设置内核是PIC的

commit fca83acef4ba261453f7c71960eacf83d0cf51f4
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Dec 4 22:10:10 2023 +0800

    修复cache-toolchain.yml的格式问题 (#464)

commit 6c7f966c2f3e3ed299168fc97ae346a85cc6e322
Author: MemoryShore <105195940+MemoryShore@users.noreply.github.com>
Date:   Mon Dec 4 22:07:30 2023 +0800

    NovaShell替换为默认shell (#456)
  
    * NovaShell替换为默认shell
  
    * delete some envvar
  
    * 自动从dragonos镜像站更新dadk
  
    * 更新github ci环境
  
    * 修复yml格式问题
  
    * 更新novashell到95738b235f
  
    ---------
  
    Co-authored-by: longjin <longjin@DragonOS.org>

commit 09d2bf52a6d048929a879748ae26e4fdea45e5d5
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Dec 3 21:27:43 2023 +0800

    update-dragon-stub-bf2617 (#463)

commit af3543100543b9ac6159dc9f9367a76ff670b1f3
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Dec 3 17:16:03 2023 +0800

    使用submodule引入DragonStub (#462)
  
    * 修正构建系统文档: 使用repo工具克隆代码
  
    * 使用submodule管理

commit 83ed0ebc293d5a10245089f627f52770fd5b9dd4
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Dec 3 14:51:21 2023 +0800

    修正构建系统文档: 使用repo工具克隆代码 (#461)

commit 01090de77ef263b81edf449b77320d5fa28569de
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Dec 3 14:40:13 2023 +0800

    使用DragonStub引导riscv下的DragonOS内核 (#460)

commit 4fda81ce81939d83b74c8042d6fb4223deff3685
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Nov 25 12:07:39 2023 +0800

    使得DragonOS kernel 能为riscv64编译通过(尚未能启动) (#457)
  
    * 使得DragonOS kernel 能为riscv64编译通过(尚未能启动)
  
    * 修正了系统调用号声明不正确的问题，同时添加了编译配置文档

commit a1fd1cf1cbe6934221f95213ce02b21f21add225
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Nov 23 21:12:16 2023 +0800

    把tar的二进制镜像源更换为国内源 (#458)

commit cc5feaf67b914ecf701abcba70c01da149755491
Author: Jomo <2512364506@qq.com>
Date:   Thu Nov 23 21:04:32 2023 +0800

    bugfix: 修复因rsdp v1 v2版本问题，导致ACPI无法正常初始化的bug (#454)
  
    bugfix: 修复因rsdp v1 v2版本问题，导致ACPI无法正常初始化的bug

commit c89d0c12377cd406a9b7465d7c087aeb9faefa51
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Nov 21 20:24:43 2023 +0800

    修复bootstrap的一系列脚本忘了source最新的shell rc的问题 (#453)

commit c75089286e9d49cef8d039446bf570c1bd4d2550
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Nov 21 13:42:18 2023 +0800

    调整脚本,使得能够创建riscv的磁盘镜像,并引导进入riscv下的grub (#450)
  
    * 安装musl toolchain以及riscv相关的工具链
  
    * 调整脚本,使得能够创建riscv的磁盘镜像,并引导进入riscv下的grub
  
    ```shell
    export ARCH=riscv64
    make write_diskimage
    make qemu
    ```
  
    即可在serial_opt.txt看到进入grub的提示信息

commit 48a3baa9b1d24dd1fc037cd9961945708c5c9b71
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Nov 21 13:42:06 2023 +0800

    安装musl toolchain以及riscv相关的工具链 (#449)

commit 84e7f7100664123d8ebc6b0f983c96242d15c396
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Nov 20 15:51:41 2023 +0800

    添加赞助商雅安数字经济运营有限公司的信息到readme (#451)

commit 99dbf38d2e279ea70e9e186753fd37001dbb749f
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Nov 19 11:42:53 2023 +0800

    bugfix: 当物理机具有多个memory area的时候,无法正确使用这些区域的问题.以及在内核代码处出现内存空洞而导致无法正常运行的问题. (#448)
  
    * bugfix: 当物理机具有多个memory area的时候,无法正确使用这些区域的问题.以及在内核代码处出现内存空洞而导致无法正常运行的问题.
  
    解决方案:
    1. 分区域把空闲页添加到buddy
    2. 将内核链接到16M的位置,以避免uefi带来的内存空洞.
  
    这个值是因为我看到linux的救援内核也是在16M的地址,因此猜测厂商不会使用这块内存.
    尽管uefi规范讲的是固件可以采用任何地址,内核需要使用内核重定位技术去避免遇到内存空洞,但我没有这么做.

commit 46e234aef65c081393fb7652e0ad2bae26786ce4
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Nov 17 21:25:15 2023 +0800

    使用cargo管理一些C文件的编译，并且移动部分汇编到arch目录 (#447)
  
    * 使用cargo管理main.c的编译
  
    * 使用build-scripts编译架构相关的c代码
  
    * 删除elf.h

commit e4600f7f7d8f2295dbf970812ab1fcab81eb6eae
Author: Jomo <2512364506@qq.com>
Date:   Fri Nov 17 21:23:01 2023 +0800

    Kconfig (#432)
  
    * 内核编译配置
  
    * 将kernel.config的解析代码搬入crate
  
    * 将设置feature函数放入CargoHandler中

commit 11f78b73e7b18ef04e05e63612f8027eda0740e7
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Nov 17 20:05:57 2023 +0800

    使用kernel-build脚本来编译所有的asm文件 (#445)

commit e4fb6c9754e535861a5e67db29fb6e8c2e9c8469
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Nov 17 12:26:10 2023 +0800

    美化readme (#446)
  
    * 美化readme

commit e26ca418df7af685226d12d7f22fe1785ba163e4
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Nov 17 11:26:26 2023 +0800

    把内核构建脚本单独独立成一个crate (#444)

commit a0c98cd4df88474f2efd927930862df50e016b73
Author: Jomo <xuzihao@dragonos.org>
Date:   Thu Nov 16 21:37:04 2023 +0800

    解决textui framework初始化成功后串口无法正常换行 (#443)

commit edaf015400f83967c2fc940f07be0dbb5792246f
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Nov 15 17:17:56 2023 +0800

    默认安装gnu tar到dragonos的/usr/bin目录下 (#442)

commit 0fb515b011967be01006cf88d788793dbbce2967
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Nov 15 15:39:35 2023 +0800

    完善pipe系统调用以及openat系统调用 (#441)

commit bf4a48994a2b284ee34aa49a66b4dec1b6ebc07c
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Nov 13 23:02:21 2023 +0800

    新增系统调用，并对照linux-6.1.9改写sys_wait4 (#440)
  
    * 1. 新增以下系统调用
                - SYS_LSTAT
                - SYS_READV
                - SYS_ACCESS
                - SYS_UNLINK
                - SYS_CHMOD
                - SYS_FCHMOD
                - SYS_UMASK
                - SYS_SYSINFO
                - SYS_CLOCK_GETTIME
                - SYS_FCHMODAT
                - SYS_FACCESSAT
  
    2. 修改sys_wait4,使得其部分符合Linux的行为(还是有些地方不符合的,详情请对比linux-6.1.9的sys_wait4接口)

commit 9b0abe6da72176086c3188e0599fda950562668f
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Nov 12 21:23:48 2023 +0800

    添加access、faccessat、faccessat2 (#439)

commit 0d9b7d9240ef65c3e603a371db57a80d26a7b9dd
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Nov 12 18:44:15 2023 +0800

    添加prlimit64系统调用 (#438)
  
    注意: 目前仅支持读取默认的rlimit值,尚不支持设置rlimit值.

commit 4a2d7191a3a6208b72e1d163c0235f566720f79a
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Nov 12 17:53:36 2023 +0800

    bugfix: 解决shell在exec的时候传递的argv不正确的bug (#437)

commit 709498cac1f2134b2a5e089366ee7136ee029369
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Nov 12 17:40:45 2023 +0800

    feat: sys_readlink && sys_readlinkat (#436)

commit be8cdf4b8edcd9579572672411f4489039dea313
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Nov 12 16:36:17 2023 +0800

    增加getrusage，并把apic timer的频率调整为系统HZ (#435)

commit 02e249f30bfe08b8a5cde1226ca0161f9e370927
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Nov 12 14:11:33 2023 +0800

    添加uid、gid的系统调用（暴力封装返回0） (#434)

commit ea8ad4d42e52016fe581a2451165146f109dfd6e
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Nov 12 13:40:17 2023 +0800

    修正fork的时候没有正确拷贝vm holes的bug (#433)

commit c47fe90440fb7c6c82953e28a4b9597b22924758
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Nov 9 18:20:27 2023 +0800

    增加accept4系统调用 (#431)

commit 393f691574844544e76231379e4938e9046be7b9
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Nov 9 16:48:45 2023 +0800

    增加gettid以及线程组group leader相关的逻辑 (#430)
  
    * 增加gettid以及线程组group leader相关的逻辑

commit 0facf623d638816d7d01a700e19a52c3c16a8fa1
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Nov 9 00:10:34 2023 +0800

    修正文件open和写入的错误 (#429)
  
    1. 修正文件open的时候可能错误的把inode清空的问题(如果当前inode是mknod创建的)
    2. 修正fat和block device中,对文件写入部分的错误问题

commit 04babc3faba81997149ed11fda2ed03b4bbf4700
Author: MemoryShore <105195940+MemoryShore@users.noreply.github.com>
Date:   Wed Nov 8 21:42:51 2023 +0800

    实现fat文件系统的truncate方法 (#428)

commit df2f5051ac645f600f2aefcaff3a9608b2c0de3f
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Nov 8 20:01:51 2023 +0800

    添加read the docs yml文件 (#427)

commit 5eaf536d5b81c234f9aea560e0c9d994fac3eb76
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Nov 8 19:41:08 2023 +0800

    添加初始化DragonOS的Rust-Musl工具链的脚本. (#426)

commit 7b32f5080f42bcbf7d2421013f3ea53c776a063c
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Nov 7 21:39:27 2023 +0800

    增加内存分配日志监视器 (#424)
  
    * 完成内存日志监视，并输出日志到文件
    * 修复进程退出后,procfs查看进程status文件会崩溃的问题
    * 修复signal唤醒进程的判断条件问题

commit 70a4e5550a9fb49b537092287c3ddc36448c5b78
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Nov 7 20:32:06 2023 +0800

    使用rust重写了apic的驱动 (#425)
  
    * 使用rust重写了apic的驱动。
  
    * 修正signal和调度器的部分加锁逻辑，增加回退策略。
  
    * 把pcb的flags字段替换为无锁的
  
    * 使用cargo管理apic的编译
  
    * 删除makefile中指定PIC的变量
  
    ---------
  
    Co-authored-by: Gou Ngai <ymd7823@outlook.com>
    Co-authored-by: 櫻井桃華 <89176634+TihayaKousaka@users.noreply.github.com>

commit 4935c74f326cd4e0854959c0ec8ab1d726c05e41
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Nov 6 17:27:05 2023 +0800

    添加自定义的crc库(支持crc64) (#423)

commit 1effcfe519c06f04303340281fe9f62096184a74
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Sun Nov 5 23:15:46 2023 +0800

    修复readdir以及读磁盘时buf传错问题 (#422)
  
    * 修复readdir以及读磁盘时buf传错问题
  
    * fix potential memory problem
  
    ---------
  
    Co-authored-by: longjin <longjin@DragonOS.org>

commit 1603395155fc166de0ac5f80369526e196526ed2
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Sat Nov 4 21:39:44 2023 +0800

    支持syscall快速系统调用指令 (#417)
  
    * 支持syscall快速系统调用指令
  
    ---------
  
    Co-authored-by: LoGin <longjin@DragonOS.org>

commit 2f6f547ae05c19871138e558ba6943ff07f4c68c
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Sat Nov 4 21:35:25 2023 +0800

    Patch fix sched (#419)
  
    1.解决waitqueue sleep的时候,由于preempt count不为0,导致sched失败,从而导致该waitqueue下一次wakeup时,会把pcb多次加入调度队列的bug
    2.修复socket inode 的read和write方法里面没有使用no_preempt的问题
    3. 修复cpu0的内核栈由于脏数据导致new_idle的时候set pcb报错的问题
  
    ---------
  
    Co-authored-by: longjin <longjin@DragonOS.org>

commit 8058ccb307bbaf06a5810af32bcba3e41ab9fb93
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Nov 3 21:01:09 2023 +0800

    修复bootstrap.sh未能自动更换gcc镜像源, 未能自动安装docker的问题 (#418)

commit d470019b1e675a04473cbb3c3eeaf180c8665e6d
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Nov 1 22:12:19 2023 +0800

    patch add mini backtrace (#416)
  
    * support rust panic backtrace
  
    mini-backtrace has llvm's unwind cpp source to support backtrace/unwind.
    as unwind/backtrace needs dynamically allocates memory, mini-backtrace
    uses stack memory to capture fixed number of backtrace to avoid heap
    allocation.
    as unwind library needed, it needs to turn on eh_frame_hdr
  
    * 修改忘了生成kernel.elf的问题
  
    * 设置backtrace是默认的feature
  
    ---------
  
    Co-authored-by: Yao Zhao <dragonlinux@gmail.com>

commit 8b3d1688daac2aaf4e87403ecda5467a01464f81
Author: yuyi2439 <68320855+yuyi2439@users.noreply.github.com>
Date:   Wed Nov 1 21:11:55 2023 +0800

    把pci驱动的读取acpi mcfg的代码，调整为从新的acpi驱动来读取 (#413)
  
    * 把pci驱动的读取acpi mcfg的代码，调整为从新的acpi驱动来读取

commit 971462be94ba0a5c74af7a5f9653dfabd4932a63
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Wed Nov 1 20:55:57 2023 +0800

    添加thread和futex机制 (#411)
  
    * 初步实现clone系统调用
  
    * 实现了线程，初步实现futex机制，添加了几个小的系统调用
  
    * 更改pcb引用计数问题
  
    * 解决死锁bug
  
    ---------
  
    Co-authored-by: LoGin <longjin@DragonOS.org>

commit 665f4a7707e33f3b4d2fde77113fa3d13b5b52c4
Author: Chiichen <39649411+Chiichen@users.noreply.github.com>
Date:   Wed Nov 1 14:18:00 2023 +0800

    更新了使用clangd的.gitignore (#415)
  
    Co-authored-by: chiichen <chiichen@qq.com>

commit 77799ccaaca276fe127448d169f0e035837cce44
Author: Wu Mianzhi <31810920+Hdksg10@users.noreply.github.com>
Date:   Mon Oct 30 00:08:52 2023 +0800

    完成e1000e驱动 (#393)
  
    * 测试RESET
  
    * 测试RESET
  
    * 基于轮询的实现
  
    * 规范化部分unsafe的使用
  
    * 完成中断处理函数，同时去除了不必要的内存拷贝行为，准备编写napi机制
  
    * 实现现有协议栈下的部分napi机制；修复了内存泄漏的问题；添加了一部分代码注释
  
    * 去除部分无用代码
  
    * 去除一些无用代码
  
    * 适配新的驱动模型
  
    * 完成msi中断测试
  
    * 去除一些无用代码
  
    * 格式化代码
  
    * 增加了一些注释，提高代码可读性
  
    * 去除无关文件
  
    * 优化了读取mac地址的方式，提高可读性

commit fbe6becd6dd3cd72643707e0088f20364ac1b166
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Oct 26 23:08:39 2023 +0800

    添加rust重构版本的HPET驱动和tsc驱动,并使用HPET校准tsc频率和cpu总线频率 (#412)
  
    * 添加rust重构版本的HPET驱动和tsc驱动,并使用HPET校准tsc频率和cpu总线频率
  
    * 把hpet.c移动到arch文件夹下

commit ad1d649eddee4aa8ac81b2f44bc99da462a6a813
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Tue Oct 24 19:59:01 2023 +0800

    更新系统调用号 (#410)
  
    * 更新系统调用号
  
    * 更改DragonReach和relibc版本
  
    * update
  
    * update
  
    * fix warning
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit f4082b86b15989a1d43e62050c6ba9b363c91ece
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Oct 24 16:40:49 2023 +0800

    更改系统调用的寄存器传参顺序 (#409)

commit 40314b30ab2a7e1fd06a05a00f693e644e446035
Author: Xiaoye Zheng <xiaoyez@zju.edu.cn>
Date:   Tue Oct 24 14:31:56 2023 +0800

    DragonOS虚拟化 (#389)
  
    * try some ioctl flow & kvm device
  
    * add sys ioctl
  
    * 删掉一些debug信息
  
    * 修改run-qemu.sh脚本，在QEMU中enable vmx
  
    * 修改cr0,cr4,msr寄存器enable VMX operations
  
    * enable vmx operation
  
    * allocate memory for vmcs with bug
  
    * allocate memory for vmcs
  
    * cpu virt-50%
  
    * single vcpu virt
  
    * add vmcs fields
  
    * CPU virt overall flow with bug
  
    * run vmlaunch success
  
    * run CPU virt with bug
  
    * 成功运行non-root模式的guest
  
    * 成功运行vmexit,进入vmx_return函数
  
    * 成功运行vmlaunch, vmexit, vmresume
  
    * vmexit handler with bug
  
    * 完成vmexit cpuid handler
  
    * fix vmresume guest状态恢复的bug
  
    * 增加vm ioctl
  
    * refactor kvm 50%
  
    * refactor kvm 80%
  
    * FIXME: kvm vmlaunch failed
  
    * vmlaunch success
  
    * FIXME: output error
  
    * update guest_rsp
  
    * cpu virt refactor
  
    * add mmu related struct
  
    * add usermemory region workflow
  
    * add mem-virt workflow
  
    * add mem-virt
  
    * refactor code
  
    * add vcpu ioctl set_regs
  
    * rename hypervisor to vm & solve some deadlock bugs
  
    * workout mem pipeline
  
    * fix vmcs control setting bugs
  
    * refactor segment regs initialization
  
    * resovle conficts
  
    * resovle conficts
  
    * format code

commit 485e2487616b1d33776b63724d4abc1ae8f506e8
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Oct 24 14:19:26 2023 +0800

    修改脚本,只有当磁盘未安装Grub的时候,才执行grub-install. 节省编译时间 (#408)

commit 46795849a29eef77fd6f7af548d05ee6e654c5bb
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Oct 24 13:56:57 2023 +0800

    修复bootstrap.sh安装顺序导致的问题 (#407)

commit 3c82aa56d1b784ea7371100b3e906365be8332fd
Author: Chiichen <39649411+Chiichen@users.noreply.github.com>
Date:   Tue Oct 24 12:02:20 2023 +0800

    Signal refactor (#402)
  
    * 初步完成对 signal_types 和 部分signal代码的初始化
  
    * 重构了一部分架构相关代码进入 arch 中
  
    * 基本修改完成，编译通过，后续补上系统调用
  
    * signal基本完成，能实现 Sigaction 系统调用
  
    * 增加了一组枚举抽象
  
    * 进一步重构了一部分C风格的代码
  
    * 继续重构了一部分C风格代码
  
    * 继续完善了一部分逻辑
  
    * 修改了部分代码逻辑
  
    * 补充了 fork 中复制信号信息的逻辑
  
    * 修复了 kallsysms 未转义引号的问题
  
    * 修复了无法跳转到 sigreturn 的bug
  
    * 调通了 signal
  
    * 实现了 signal 架构抽象层的 trait
  
    * 为信号提供了默认处理函数
  
    * 基本完成了 signal 的大体逻辑
  
    * 修复了 Sigreturn 的一个小错误，格式化
  
    * 修复了一个编译器漏报错误
  
    * 删除了多余的代码
  
    * 修改测试程序为链接 relibc
  
    * 修复了信号处理过程中浮点寄存器错误保存的问题
  
    * 修复了一个结构体错误引起的无法在relibc下正确运行的错误
  
    * 修复了链接 relibc 时无法正常从信号处理返回的 bug
  
    * 修复了 signal 处理流程中 rsp 指针错误导致的浮点运算触发GP
  
    * 修复了一个死锁问题，解决了默认处理函数无法进入调度导致的bug
  
    * 修复了一些错误
  
    * 修改了 relibc 依赖版本号
  
    * 删除了多余的 imports
  
    * 删除一些debug日志
  
    * 删除内核 signal.h 文件
  
    * 删除一个依赖项
  
    * 删除了 binding 相关依赖项

commit d7f5742a206c6c25ed30009796eb8248429f0a1e
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Oct 23 21:40:39 2023 +0800

    初步编写cpu信息获取的代码 (#406)
  
    1. 启动时从acpi获取所有的cpu信息并存到SMP_BOOT_DATA
    2. 注册cpu subsystem/bus到sysfs(暂时未添加内容)
  
    todo:
    1. build_cpu_map(在X86_64SmpManager中)
    2. 实现cpu mask
    3. 把cpu设备注册到sysfs

commit 7eda31b2f07c6ef41dc0d2bd13051f0fce5e5976
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Oct 22 22:00:16 2023 +0800

    在Sysfs中引入ACPI Firmware (#405)
  
    - bugfix: multiboot2启动的信息因为没及时转存导致后面无法从其中进行查询的bug
    - feature: 把acpi表、acpi bus加入sysfs

commit 01bd5258cf467326819c77584713fbc6ffe4fb32
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Oct 22 12:22:41 2023 +0800

    解决shell无法输入大写字母'P'的问题 (#404)

commit a03c4f9dee5705207325c56629c0ccd219168f10
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Oct 20 22:11:33 2023 +0800

    设备驱动模型：完善platform bus相关内容。并注册串口到sysfs (#403)
  
    * 完成初始化platform bus
    * 删除旧的sysfs
    * 把uart驱动移动到tty/serial文件夹下
    * 完成将串口挂载到sysfs
    * 修复vfs系统调用未能follow symlink的问题
    * 修复shell未能正确获取pwd的问题

commit 06d5e247267cb65b84a80f219853ccd0f384b16e
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Oct 11 00:53:15 2023 +0800

    完善设备驱动模型，基于kset、kobj来维护对象之间的关系 (#401)
  
    * 使用kobj和kset管理/sys文件夹下的对象
  
    * 修改notifier，把action从u64换为泛型。
  
    * 完善设备驱动模型，基于kset、kobj来维护对象之间的关系

commit 6abb8bd7c0ee7746f0b6cf682a0c4d112a2ef6a3
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Oct 9 01:55:58 2023 +0800

    在github workflow的工具链配置文件里面添加rust-src组件 (#400)

commit 9e9ffedfc59cd89f4cdbd7984abbb2ac19ea9575
Author: Plucky923 <107762234+Plucky923@users.noreply.github.com>
Date:   Mon Oct 9 01:11:14 2023 +0800

    syscall: 完善syscall代码 (#387)
  
    * syscall: 完善syscall代码
  
    修改代码使这段代码可以使用语法糖。修改SYS_READ和SYS_WRITE的安全检查为userbuffer
  
    Signed-off-by: plucky <m202372036@hust.edu.cn>
  
    * syscall: 修改SYS_READ和SYS_WRITE的权限检查为userbuffer
  
    Signed-off-by: plucky <m202372036@hust.edu.cn>
  
    * syscall: 有不知道如何修改的错误
  
    Signed-off-by: plucky <m202372036@hust.edu.cn>
  
    * syscall: 修改SYS_READ和SYS_WRITE并编译通过
  
    Signed-off-by: plucky <m202372036@hust.edu.cn>

commit 865f4ba4cdce23b154844d6d297f75033f3dcf70
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Mon Oct 9 01:10:14 2023 +0800

    修改shell执行exec时传参错误问题 (#399)
  
    * 修改shell执行exec时传参错误问题

commit b7b843beddea12cdedda90f6129b7c9980876112
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Mon Oct 9 00:58:08 2023 +0800

    wait4系统调用支持options字段 (#398)

commit 2dbef7859f0af395ccec348f17cf0b79ed56e003
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Mon Oct 9 00:28:08 2023 +0800

    命名管道系统调用以及文件系统兼容特殊文件类型的接口 (#397)
  
    * 修复pipe2在读端或写端关闭后还阻塞问题。
  
    * 实现命名管道机制，增加特殊文件类型兼容普通文件系统的接口。
  
    * 普通文件系统能够适配特殊文件(命名管道等)

commit 34e6d6c80f36494088db3284f85d1a2c63aa18a8
Author: yuyi2439 <68320855+yuyi2439@users.noreply.github.com>
Date:   Sun Oct 8 14:26:17 2023 +0800

    实现free指令+修复 mountfs的内存泄露问题(#394)
  
    * 实现meminfo文件
  
    * 成功实现free指令，添加了一些string有关函数，并进行一些无影响的小改动
  
  
    * 解决内存泄露的问题：mountfs inode的wrap方法使用了Arc::into_raw而没有from_raw，导致inode始终无法释放
  
    ---------
  
    Co-authored-by: LoGin <longjin@DragonOS.org>
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit afc95d5c2541c27c762091ad38fdffabe355db5a
Author: YJwu2023 <yujianwu2019@gmail.com>
Date:   Tue Oct 3 12:09:29 2023 +0800

    完善pci中断的设计 (#392)
  
    * 完善pci中断的设计

commit 876cb89ecf7c1bf1646bfc392efcbafacad2262f
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Tue Oct 3 12:03:34 2023 +0800

    修复pipe2在读端或写端关闭后还阻塞问题 (#396)
  
    * 修复pipe2在读端或写端关闭后还阻塞问题。
  
    * update
  
    * update
  
    * 修改cloexec
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit fba5623183378da6b120caafca120615328efa2e
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Oct 2 20:46:19 2023 +0800

    引入intertrait库，支持trait之间的互相转换 (#395)
  
    * 能过编译（test还没法跑）
  
    * 初始化intertrait转换库
  
    * update license of intertrait

commit bb0e4d4131046a69bbccdc0cdf1d5db51a2c6126
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Sat Sep 30 16:36:06 2023 +0800

    使用DragonReach启动shell，修改getdents (#391)
  
    * 使用DragonReach启动shell，修改getdents
  
    * 更改关闭pipe时断言报错问题，以及DragonReach启动shell阶段版本
  
    * 修改目录结构
  
    * update
  
    * 解决小问题
  
    * 调整dragon reach版本号
  
    * 设置make clean的时候不清空应用程序的缓存。
    指定relibc版本号
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 0dd8ff43325b494ea777dbe6e552fdc77b9dabc8
Author: YJwu2023 <yujianwu2019@gmail.com>
Date:   Thu Sep 21 23:23:57 2023 +0800

    添加中断 (#370)
  
    * 添加中断
  
    * dhcp更改为全局socketset
  
    * 解决异常中断的问题，使得能够使用中断来处理网卡数据
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 6b4e7a2972cc06663754c0e35a0e541987006fa4
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Sep 19 19:46:59 2023 +0800

    增加kernfs (#386)
  
    * 增加kernfs
  
    * kernfs文档

commit ae5ede03bebe5c4b593ad7a350f0945f1367be7c
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Sep 18 07:38:04 2023 +0800

    bugfix: bus/device manager对卸载逻辑的处理错误 (#385)
  
    * 移动位置
  
    * bugfix: bus/device manager对卸载逻辑的处理错误

commit 7ae679ddd6481897a86523a52fad3b060254fa5b
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Sep 17 15:41:01 2023 +0800

    ahci内存越界问题修复+ mm的bug修复+在rust中解析acpi table (#384)
  
    * bugfix: 修复了Flusher Drop的时候没有自动刷新TLB的bug
  
    * 解决进程管理未初始化时，trap.c尝试打印pid导致错误的问题
  
    * 设置kmalloc默认强制清0
  
    * 修复ahci驱动的内存越界问题
    * 修复mmio buddy忘记归还buddy block的问题
    * 新增acpi模块,暂时能解析acpi tables

commit 11110997465e858757da54b5ce28d7c22690aaff
Author: hanjiezhou <zhouhanjie@dragonos.org>
Date:   Sat Sep 16 20:14:56 2023 +0800

    修改 tty 中resize bug (#383)

commit 71474bc6829b3cd831df7ce24ea059557996524d
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Sep 16 16:16:43 2023 +0800

    修复drop fd时，文件描述符引用不为0的问题 (#382)

commit de71ec259cd21c782f4031b01635eb8ad3df1943
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Sep 15 19:44:11 2023 +0800

    修正由于init proc union导致的无法运行的问题 && 修正由于内核线程启动后默认sleep的行为导致init进程无法正常运行的bug (#381)
  
    1. 修正由于init proc union导致的无法运行的问题
    2. 修正由于内核线程启动后默认sleep的行为导致init进程无法正常运行的bug

commit 1496ba7b24a5e6954291ca9643b9f3cec567479a
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Sep 15 14:58:19 2023 +0800

    进程管理模块重构完成 (#380)
  
    * 添加新版pcb的数据结构 (#273)
  
    * 将pcb中的内容分类，分别加锁 (#305)
  
    * 进程管理重构：完成fork的主体逻辑 (#309)
  
    1.完成fork的主体逻辑
    2.将文件系统接到新的pcb上
    3.经过思考,暂时弃用signal机制,待进程管理重构完成后,重写signal机制.原因是原本的signal机制太烂了
  
    * chdir getcwd pid pgid ppid (#310)
  
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>
  
    * 删除旧的fork以及signal的代码，并调整fork/vfork/execve系统调用 (#325)
  
    1.删除旧的fork
    2.删除signal相关代码,等进程管理重构结束之后,再重新写.
    3.调整了fork/vfork/execve系统调用
  
    * 实现切换进程的代码 (#331)
  
  
  
    * 实现切换进程的代码
  
    * Patch modify preempt (#332)
  
    * 修改设置preempt的代码
  
    * 删除rust的list和refcount
  
    * 为每个核心初始化idle进程 (#333)
  
    * 为每个核心初始化idle进程
  
    * 完成了新的内核线程机制 (#335)
  
    * 调度器的pcb替换为新的Arc<ProcessControlBlock>，把调度器队列锁从 RwSpinLock 替换为了 SpinLock (#336)
  
    * 把调度器的pcb替换为新的Arc<ProcessControlBlock>
  
    * 把调度器队列锁从 RwSpinLock 替换为了 SpinLock ，修改了签名以通过编译
  
    * 修正一些双重加锁、细节问题
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>
  
    * github workflow自动检查代码是否格式化
  
    * cache toolchain yml
  
    * 调整rust版本的waitqueue中的pcb为新版的pcb (#343)
  
    * 解决设置rust workspace带来的“工具链不一致”的问题 (#344)
  
  
    * 解决设置rust workspace带来的“工具链不一致”的问题
  
    更改workflow
  
    * 调整pcb的sched_info和rwlock，以避免调度器死锁问题 (#341)
  
    * 调整pcb的sched_info和rwlock，以避免调度器死锁问题
  
    * 修改为在 WriterGuard 中维护 Irq_guard
  
    * 修正了 write_irqsave方法
  
    * 优化了代码
  
    * 把 set state 操作从 wakup 移动到 sched_enqueue 中
  
    * 修正为在 wakeup 中设置 running ，以保留 set_state 的私有性
  
    * 移除了 process_wakeup
  
    * 实现进程退出的逻辑 (#340)
  
    实现进程退出的逻辑
  
    * 标志进程sleep
  
    * 修复wakeup的问题
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>
  
    * rust 重构 completion (#350)
  
    * 完成了completion的基本结构，待完善上级调用
  
    * 用SpinLock保护结构体并发安全
  
    * 修改原子变量为u32，修复符号错误
  
    * irq guard
  
    * 修改为具有内部可变性的结构体
  
    * temp fix
  
    * 修复了由于进程持有自旋锁导致的不被调度的问题
  
    * 对 complete 系列方法上锁，保护 done 数据并发安全
  
    * 移除了未使用的依赖
  
    * 重写显示刷新驱动 (#363)
  
    * 重构显示刷新驱动
  
    * Patch refactor process management (#366)
  
    * 维护进程树
  
    * 维护进程树
  
    * 更改代码结构
  
    * 新建进程时，设置cwd
  
    * 调整adopt childern函数，降低开销
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>
  
    * waitqueue兼容C部分 (#351)
  
    * PATH
  
    * safe init
  
    * waitqueue兼容C部分
  
    * waitqueue兼容C部分
  
    * 删除semaphore.c,在ps2_keyboard中使用waitqueue
  
    * 删除semaphore.c,在ps2_keyboard中使用waitqueue
  
    * current_pcb的C兼容
  
    * current_pcb的C兼容
  
    * current_pcb的C兼容
  
    * fmt
  
    * current_pcb的兼容
  
    * 针对修改
  
    * 调整代码
  
    * fmt
  
    * 删除pcb的set flags
  
    * 更改函数名
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>
  
    * merge master
  
    * Patch debug process management refactor (#372)
  
    * 能够调通，执行完textui_init
  
    * 能跑到initial kernel thread
  
    * fmt
  
    * 能够正常初始化所有服务（尚未能切换到用户程序）
  
    * 删除部分无用的extern
  
    * 存在问题：ap处理器启动后，bsp的smp_init函数return之后就出错了，怀疑是栈损坏
  
    * 解决smp启动由于未换栈导致的内存访问错误
  
    * debug
  
    * 1
  
    * 1
  
    * lock no preempt
  
    * 调通
  
    * 优化代码，删除一些调试日志
  
    * fix
  
    * 使用rust重写wait4 (#377)
  
    * 维护进程树
  
    * 维护进程树
  
    * 更改代码结构
  
    * 新建进程时，设置cwd
  
    * 调整adopt childern函数，降低开销
  
    * wait4
  
    * 删除c_sys_wait4
  
    * 使用userbuffer保护裸指针
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>
  
    * 消除warning
  
    * 1. 修正未设置cpu executing的问题
  
    * 修正kthread机制可能存在的内存泄露问题
  
    * 删除pcb文档
  
    * 删除C的tss struct
  
    ---------
  
    Co-authored-by: Bullet <93781792+GP-Bullet@users.noreply.github.com>
    Co-authored-by: Chiichen <39649411+Chiichen@users.noreply.github.com>
    Co-authored-by: hanjiezhou <zhouhanjie@dragonos.org>
    Co-authored-by: GnoCiYeH <118462160+GnoCiYeH@users.noreply.github.com>
    Co-authored-by: houmkh <1119644616@qq.com>

commit b087521e07f601b30e3d48df788fcc2f09f19566
Author: Chiichen <39649411+Chiichen@users.noreply.github.com>
Date:   Wed Sep 13 18:01:52 2023 +0800

    完善设备驱动模型&调试串口驱动 (#379)
  
    * 完成了基本架构重构，正在进行兼容
  
    * 重构了所有 Device Driver ，还没有接上具体设备
  
    * 基本把 Uart 接上了，还没有测试
  
    * 初步完成系统设备初始化
  
    * 初步重构 BlockDevice ，使其兼容新的 Device 结构
  
    * 修改文件系统内的部分函数调用以满足重构后的接口
  
    * 测试完 Uart 设备的功能
  
    * 移除了自动添加的文件
  
    * 修复了 warning 和部分格式
  
    * 解决warning，并且修正sysfs初始化的位置
  
    * Patch fix
  
    * 删除了 sysinfo 的默认实现
  
    * 删除了字符设备读写的 offset 参数
  
    * 修复了 warning 和一些小逻辑错误
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 9029414af2089cbe7d2d2097be2e116c09beb6dd
Author: zhaoyao73 <zhaoyao73@users.noreply.github.com>
Date:   Wed Sep 13 01:49:03 2023 -0400

    use demangled names (#375)
  
    there is no change for c symbols
      rust symbols name will be more readable

commit 22c9db312a5f02b48a1bf7853dc53434da65e28a
Author: hanjiezhou <zhouhanjie@dragonos.org>
Date:   Wed Sep 13 00:58:01 2023 +0800

    Patch pipe2 (#364)

commit 68312d3c68b9df288589f9636417745d46520ad2
Author: Xshine <gshine@m.scnu.edu.cn>
Date:   Wed Sep 13 00:26:41 2023 +0800

    修正造成 http server 的错误 (#378)
  
    * 修正造成 http server 的错误

commit 285de542f3ddb09bfdcad0a7022bd722f4f1cace
Author: zhaoyao73 <zhaoyao73@users.noreply.github.com>
Date:   Wed Sep 6 06:08:52 2023 -0400

    modify kernel link script (#373)
  
    put rust text between _text and _etext, so rust symbols are included in
    kallsyms, traceback could use them.
  
    modify grub_auto_install.sh to add arch linux support

commit 3b0bf43bbb196a74a64cee8ecd2d4eb884c5e9ee
Author: zhaoyao73 <zhaoyao73@users.noreply.github.com>
Date:   Mon Sep 4 00:57:52 2023 -0400

    fix compiler warnings in pci_irq.c (#371)
  
    Co-authored-by: Yao Zhao <dragonlinux@gmail.com>

commit 607783d7414735d1dc54afb0c7346ed8e13303a2
Author: zhaoyao73 <zhaoyao73@users.noreply.github.com>
Date:   Sun Sep 3 01:36:02 2023 -0400

    fix pci_irq.c - memory leak - wrong irq_name allocated length (#367)
  
    add function declaration to avoid compiling warning
  
    add extra packages need for build
  
    Co-authored-by: Yao Zhao <dragonlinux@gmail.com>

commit d9113303d8e1d449a122f7a5f66453fbe7c26a46
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Sep 3 13:33:27 2023 +0800

    relibc与旧的C库同时开始编译 (#369)

commit 4895ff6968ae8f24c7a0d55dce6ae23082d60e3b
Author: yuyi2439 <68320855+yuyi2439@users.noreply.github.com>
Date:   Sat Sep 2 00:27:41 2023 +0800

    fix: DragonOS-Community/DragonOS#358 (#361)

commit 8479f19979aa9ddc4e383651cc56a7a24bd94e21
Author: GnoCiYeH <118462160+GnoCiYeH@users.noreply.github.com>
Date:   Fri Sep 1 21:46:36 2023 +0800

    添加rust-gdb调试内核文档 (#357)
  
    * 编写使用GDB调试内核文档

commit 863a3cff06e618a5f0fc03920dfd5732452344c9
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Aug 31 20:25:00 2023 +0800

    添加与rust std接口相同的once库 (#353)

commit a3ef8f8ad5248e3424113871950eb9c80eeeb99e
Author: GnoCiYeH <118462160+GnoCiYeH@users.noreply.github.com>
Date:   Thu Aug 31 19:52:32 2023 +0800

    修改RamFS目前存在的BUG (#354)
  
    * 修改RamFS目前存在的BUG

commit c757940bd61b0125e037a59eb77565e42470201b
Author: YJwu2023 <yujianwu2019@gmail.com>
Date:   Thu Aug 31 17:54:49 2023 +0800

    优化makefile (#352)

commit 2dd9f0c7503d1a325713764fedbce06fcab3a06b
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Aug 28 15:54:52 2023 +0800

    mmio buddy新增guard，把映射的职责交由其守卫进行处理，并且守卫被drop的时候自动释放内存 (#346)
  
    * mmio buddy新增guard，把映射的职责交由其守卫进行处理，并且守卫被drop的时候自动释放内存

commit 8d94ea66a3eb3e02039730c8d08e9bead8c344b8
Author: YJwu2023 <yujianwu2019@gmail.com>
Date:   Mon Aug 28 15:43:07 2023 +0800

    Patch ahci (#348)
  
    * Modify the ahci module and delete the useless c code
  
    修改ahci使其不再依赖旧的pci函数
    删除旧的pci、msi函数代码

commit f5df0e79c67a9508bc6a50fccded9dec78e7ed9d
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Aug 28 15:29:00 2023 +0800

    解决userbufferwriter的长度错误问题，并修复gettimeofday的pagefault问题 (#349)
  
    * 解决userbufferwriter的长度错误问题，并修复gettimeofday的pagefault问题

commit ddb9d91712b6e87aa15b9cc4a8fdec8ae0996a5e
Author: Xshine <gshine@m.scnu.edu.cn>
Date:   Sun Aug 27 15:54:19 2023 +0800

    将 io 移动至 vfs 目录，并修正引用路径 (#339)
  
    * 将 io 移动至 vfs 目录，并修正引用路径
  
    * fix bug in makefile

commit e92d02281005bac31fe80e9070ac4a2a6cef0419
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Aug 26 21:36:13 2023 +0800

    解决设置rust workspace带来的“工具链不一致”的问题 (#345)
  
    更改workflow

commit 9a367aa7eb1576a235f5f52ee542132a1e5e39df
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Aug 24 18:50:52 2023 +0800

    添加github workflow，检查代码是否已经格式化 (#342)
  
    * 添加github workflow，检查代码是否已经格式化

commit f09a98329c4ec77010de86d126516310b407455a
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Aug 23 16:09:29 2023 +0800

    1. 修复bootstrap.sh在安装libssl-dev之前，安装dadk，从而导致错误的问题 (#338)
  
    1. 修复bootstrap.sh在安装libssl-dev之前，安装dadk，从而导致错误的问题
    2. 构建系统的文档，补充对vnc端口的说明

commit 4537ffb7e9afb2d96f2adcee32c8ac84b056d2e5
Author: Chiichen <39649411+Chiichen@users.noreply.github.com>
Date:   Mon Aug 21 18:37:31 2023 +0800

    实现了对用户空间传入指针抽象的UserBufferReader/Writer，来检验用户空间指针地址并提供一定的功能抽象 (#326)
  
    * 构建了 Userbuffer 对用户空间传入的指针进行了抽象，并提供了读写操作
  
    * 分成了Reader和Writer，增加了从地址读和写入到指定地址的功能
  
    * 删除了多余的注释
  
    * 增加了直接获取BufferWriter切片的函数
  
    * 通过 where 的一个 Trick 实现了 const generic 和后续功能
  
    * 替换为了 core::slice::align_to 实现&[u8}转&[T]
  
    * 移除了 userbuffer.rs
  
    * 提供了独立获取缓冲区中不同偏移量位置的数据的函数
  
    * 替换了部分系统调用(还未测试
  
    * 简化了代码
  
    * 修复内存越界的bug
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit abe3a6ea3c543425e2cad12722e8a658b324d515
Author: hanjiezhou <zhouhanjie@dragonos.org>
Date:   Sun Aug 20 00:19:36 2023 +0800

    Patch refactor scm and textui (#289)
  
    * 重构屏幕管理器和textui框架
  
    * 切换字体为spleen，并增加对字体的抽象
  
    * 修正文档
  
    ---------
  
    Co-authored-by: longjin <longjin@RinGoTek.cn>

```
