# V0.1.8

:::{note}
本文作者：龙进 <longjin@DragonOS.org>


2023年8月16日
:::

## 贡献者名单

DragonOS V0.1.8版本由以下小伙伴贡献代码：

- 龙进 <longjin@DragonOS.org>
- 侯嘉滢 <houjiaying@DragonOS.org>
- 吴宇健 <wuyujian@DragonOS.org>
- 黄厅 <huangting@DragonOS.org>
- 孔维超 <kongweichao@DragonOS.org>
- 蔡嘉鑫 <caijiaxin@DragonOS.org>
- 池克俭 <chikejhian@DragonOS.org>
- zhaoyao73 <dragonlinux@gmail.com>
- 周瀚杰 <zhouhanjie@DragonOS.org>
- Bullet <93781792+GP-Bullet@users.noreply.github.com>
- 櫻井桃華 <89176634+TihayaKousaka@users.noreply.github.com>
- Tptogiar <2528891112@qq.com>

## 赞助者名单

感谢以下同学的赞赏，我们将不断努力！

- 万晓兰
- David Wen
- [Seele.Clover](https://github.com/seeleclover)
- [FindWangHao](https://github.com/FindWangHao)
- [ferchiel](https://github.com/ferchiel)
- 叶锦毅
- 林
- Albert
- [TerryLeeSCUT · GitHub](https://github.com/TerryLeeSCUT)
- slientbard
- 悟
- 匿名热心人士

## 更新内容-内核

### 新特性

- refactor: 重构系统调用模块 (#267)
- feature: 添加AlignBox和int_like宏 (#272)
- refactor: 新的ipi功能&kick_cpu功能的重写 (#274)
- feature: 实现gettimeofday()系统调用和clocksource+timekeeping子模块 (#278)
- refactor: PCI设备中断重构，并删去USB相关代码 (#285)
- feature: 注册串口设备，创建字符设备框架(#290)
- refactor: 新的内存管理模块 (#303)
- feature: 新的二进制加载器、elf解析器 (#303)
- feature: 增加 ListenTable 来检测端口占用 (#291)
- feature: 替换 local_irq_save 为 IrqFlagsGuard 实现 (#317)
- feature: 实现系统调用Fstat (#295)
- feature: 实现内核通知链 notifier chain (#316)
- feature: 增加fcntl系统调用 (#323)
- feature: 添加per cpu变量支持 (#327)
- feature: spinlock守卫新增leak,spinlock新增force unlock功能.(#329)

### bugfix
- bugfix: 修复无法正常读取stdin的问题 (#264)
- bugfix: 修复了当传入ahci驱动的缓冲区地址为用户缓冲区时,产生的内存越界问题.(采用分配内核缓冲区的方式临时解决) (#265)
- bugfix: 解决由于local_irq_save、local_irq_restore函数的汇编不规范导致影响栈行为的bug。 (#303)
- bugfix: 解决local_irq_save未关中断的错误 (#303)
- bugfix: 解决arch_try_cmpxchg对于指针处理的错误 (#307)
- bugfix: 修复了wait4的异常报错 (#312)
- bugfix: 修正null设备以及zero设备无法open、行为不符合预期的问题 (#314)
- bugfix: 修正fat文件系统未能正确的扩展文件大小的bug (#323)
- bugfix: 修正rwlock有的地方由于未使用ManuallyDrop导致的use after free问题 (#329)


## 更新内容-用户环境

### 新特性
- feature: 新增http server (#265)

### bugfix
- bugfix: 解决链接时，由于crt*.o未按照升序排列导致init段链接错误的问题 (#265)


## 更新内容-其他

- bugfix: 固定编译工具链、修复由于新版rust编译器问题导致的报错。 (#258)
- feature: Makefile: 根目录下添加make help命令 (#271)
- doc: 更新github issue模板 (#277)
- bugfix: 解决relibc的头文件没能识别__dragonos__定义的问题 (#315)
- feature: 设置内核、relibc的远程为dragonos的git镜像站，防止国内网络问题导致编译失败 (#318)
- feature: 自动安装、更新dadk (#319)

## 更新内容-软件移植

- feature: 移植了sqlite3 (#323)

## 源码、发布版镜像下载

&emsp;&emsp;您可以通过以下方式获得源代码:

### 通过Git获取

- 您可以访问[https://github.com/DragonOS-Community/DragonOS/releases](https://github.com/DragonOS-Community/DragonOS/releases)下载发布版的代码，以及编译好的，可运行的磁盘镜像。
- 我们在gitee上也有镜像仓库可供下载：[https://gitee.com/DragonOS/DragonOS](https://gitee.com/DragonOS/DragonOS)

### 通过DragonOS软件镜像站获取

&emsp;&emsp;为解决国内访问GitHub慢、不稳定的问题，同时为了方便开发者们下载DragonOS的每个版本的代码，我们特意搭建了镜像站，您可以通过以下地址访问镜像站：

&emsp;&emsp;您可以通过镜像站获取到DragonOS的代码压缩包，以及编译好的可运行的磁盘镜像。

- [https://mirrors.DragonOS.org](https://mirrors.DragonOS.org)
- [https://git.mirrors.DragonOS.org](https://git.mirrors.DragonOS.org)
- 国内镜像加速： [https://mirrors.ringotek.cn/](https://mirrors.ringotek.cn/)

## 开放源代码声明


:::{note}
为促进DragonOS项目的健康发展，DragonOS以GPLv2开源协议进行发布。所有能获得到DragonOS源代码以及相应的软件制品（包括但不限于二进制副本、文档）的人，都能享有我们通过GPLv2协议授予您的权利，同时您也需要遵守协议中规定的义务。

这是一个相当严格的，保护开源软件健康发展，不被侵占的协议。

对于大部分的善意的人们而言，您不会违反我们的开源协议。

我们鼓励DragonOS的自由传播、推广，但是请确保所有行为没有侵犯他人的合法权益，也没有违反GPLv2协议。

请特别注意，对于违反开源协议的，尤其是**商业闭源使用以及任何剽窃、学术不端行为将会受到严肃的追责**。（这是最容易违反我们的开源协议的场景）。

并且，请注意，按照GPLv2协议的要求，基于DragonOS修改或二次开发的软件，必须同样采用GPLv2协议开源，并标明其基于DragonOS进行了修改。亦需保证这些修改版本的用户能方便的获取到DragonOS的原始版本。

您必须使得DragonOS的开发者们，能够以同样的方式，从公开渠道获取到您二次开发的版本的源代码，否则您将违反GPLv2协议。

关于协议详细内容，还敬请您请阅读项目根目录下的**LICENSE**文件。请注意，按照GPLv2协议的要求，**只有英文原版才具有法律效力**。任何翻译版本都仅供参考。
:::

### 开源软件使用情况

&emsp;&emsp;DragonOS在开发的过程中，参考了一些开源项目的设计，或者引入了他们的部分代码，亦或是受到了他们的启发。现将他们列在下面。我们对这些开源项目的贡献者们致以最衷心的感谢！

格式：<项目名> - <链接> - <开源协议>

- Linux - 	https://git.kernel.org/ - GPLv2
- skiftOS - https://github.com/skiftOS/skift - MIT
- FYSOS - https://github.com/fysnet/FYSOS - [FYSOS' License](https://github.com/fysnet/FYSOS/blob/9a8968e3d6600de34539c028c843f4c06d134039/license.txt)
- LemonOS - https://github.com/LemonOSProject/LemonOS.git - BSD 2-Clause License
- LZ4 - https://github.com/lz4/lz4 - BSD 2-Clause license
- SerenityOS - https://github.com/SerenityOS/serenity.git - BSD 2-Clause license
- MINE - 《一个64位操作系统的设计与实现》田宇; 人民邮电出版社
- chcore - 《现代操作系统：设计与实现》陈海波，夏虞斌; 机械工业出版社
- SimpleKernel - https://github.com/Simple-XX/SimpleKernel - MIT
- rcore-fs - https://github.com/rcore-os/rcore-fs.git - MIT
- redox - https://gitlab.redox-os.org/redox-os/redox - MIT

## 当前版本的所有提交记录

```text
commit 40176b1c6603d487b7eb66fb81e641f0932ab90a
Author: longjin <longjin@RinGoTek.cn>
Date:   Tue Aug 15 15:06:57 2023 +0000

    删除无用代码,并把about app的版本号更新为0.1.8

commit 67b481888770c6469f572f244a4f97e42da77d1f
Author: houmkh <1119644616@qq.com>
Date:   Mon Aug 14 12:18:46 2023 +0800

    移动fstat (#330)
    
    * 移动fstat

commit 90a0a49048fdaf5e31320d0c87f8bed8db1bd882
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Aug 14 01:24:49 2023 +0800

    修正rwlock有的地方由于未使用ManuallyDrop导致的use after free && spinlock守卫新增leak,spinlock新增force unlock功能.(#329)
    
    1.修正rwlock有的地方由于未使用ManuallyDrop导致的use after free
    2. spinlock守卫新增leak,spinlock新增force unlock功能.

commit c3dad0011d331d782670e14723aa48e98fbac787
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Aug 13 16:28:24 2023 +0800

    添加per cpu变量支持 (#327)

commit 42c97fa7f4fee7eeefeda5d2b7ed14f598a58493
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Aug 8 23:45:04 2023 +0800

    删除旧的libELF (#324)

commit 6d81180b3b7328466b976b69c5f7782aa66d8a89
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Aug 8 23:39:22 2023 +0800

    移植sqlite3,并修复一些bug (#323)
    
    * bugfix: 程序加载器映射内存时，计算要映射的大小不正确的问题。
    
    * 修正brk系统调用不符合规范的地方
    
    * bugfix: 修正fat文件系统未能正确的扩展文件大小的bug
    
    * 增加fcntl系统调用
    
    * 移植sqlite3

commit 26887c6334cdca2d13ad71dec27fb69faa0a57be
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Aug 7 01:38:52 2023 +0800

    bugfix: 解决取消低地址映射时，错误的把重映射的物理页释放，从而导致的use after free问题。 (#321)

commit 729a96ef47f473d535d8317a2ace5ba141fd282a
Author: Xshine <gshine@m.scnu.edu.cn>
Date:   Sun Aug 6 12:53:47 2023 +0800

    实现内核通知链 notifier chain (#316)
    
    * 实现通知链块结构
    
    * 实现通知链的基本功能
    
    * 实现 atomic notifier chain
    
    * 实现 blocking notifier chain
    
    * 使用 rust 范式完成功能
    
    * 支持回调次数 nr_to_call
    
    * 移动至 libs 目录
    
    * 完善通知链相关方法
    
    * 修正相关格式
    
    * 文档编写
    
    * 更改文档路径

commit be63f3b2b6b472daa3ee17180aa607409cb9d182
Author: houmkh <1119644616@qq.com>
Date:   Sat Aug 5 18:52:46 2023 +0800

    实现系统调用Fstat (#295)
    
    * fstat
    
    * 修改syscall.rs中的verify_area

commit 9550910ae1de900e0291a84d268e8873fa142902
Author: Chiichen <39649411+Chiichen@users.noreply.github.com>
Date:   Sat Aug 5 18:30:55 2023 +0800

     替换 local_irq_save 为 IrqFlagsGuard 实现 (#317)

commit abf3f634bf7e13e829556e962e7c73a85d163335
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Aug 5 15:30:06 2023 +0800

    自动安装、更新dadk (#319)
    
    * auto install/auto update dadk

commit d6fd9c1e8025dd679339f9156477cb7d26d3db0d
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Aug 5 15:04:08 2023 +0800

    设置内核、relibc的远程为dragonos的git镜像站，防止国内网络问题导致编译失败 (#318)

commit 1a62e7767c1215f9668915b42de770e7993711bf
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Aug 2 18:11:05 2023 +0800

    解决relibc的头文件没能识别__dragonos__定义的问题 (#315)

commit 06500303303ec14711b4f995e2058e12703f0f2c
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Aug 2 17:33:16 2023 +0800

    修正null设备以及zero设备无法open、行为不符合预期的问题 (#314)

commit 4da3758acf0327d429dfce3d313b50c2e0fc7723
Author: Chiichen <39649411+Chiichen@users.noreply.github.com>
Date:   Wed Aug 2 14:29:59 2023 +0800

    修复了wait4的异常报错 (#312)
    
    * 修复了wait4的异常报错

commit 821bb9a2dcfd28f9878d53ba722bdf164cf00f69
Author: Xshine <caijiaxin@dragonos.org>
Date:   Fri Jul 28 17:51:05 2023 +0800

    增加 ListenTable 来检测端口占用 (#291)
    
    * 增加 ListenTable 来检测端口占用
    
    
    * 使用Arc封装GlobalSocketHandle
    
    * 删除 listen 处的端口检测逻辑，延至实现端口复用时完成
    
    * 设立两张表，分别记录TCP和UDP的端口占用
    
    * 实现 meatadata 相关逻辑
    
    * 实现socket关闭时，端口在表中移除
    
    * 使用端口管理器重构端口记录表
    
    * 修正与RawSocket相关的端口管理逻辑
    
    * 补充测试文件
    
    * 修正 unbind_port 在逻辑错误
    
    * 修正格式问题
    
    ---------
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 7cc4a02c7ff7bafd798b185beb7b0c2986b9f32f
Author: zhaoyao73 <zhaoyao73@users.noreply.github.com>
Date:   Fri Jul 28 03:44:45 2023 -0400

    fix arch_try_cmpxchg macro declaration (#307)
    
    fix arch_try_cmpxchg in atomic_cmpxchg
    
    Co-authored-by: Yao Zhao <dragonlinux@gmail.com>

commit a30434f5201ca4c60b9515c8c23444fea3b5a8c6
Author: zhaoyao73 <zhaoyao73@users.noreply.github.com>
Date:   Tue Jul 25 10:02:42 2023 -0400

    fix some script bugs (#304)
    
    add arch linux prerequisited packages
    
    Co-authored-by: Yao Zhao <dragonlinux@gmail.com>

commit 40fe15e0953f989ccfeb74826d61621d43dea6bb
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Jul 22 16:27:02 2023 +0800

    新的内存管理模块 (#303)
    
    &emsp;&emsp;实现了具有优秀架构设计的新的内存管理模块，对内核空间和用户空间的内存映射、分配、释放、管理等操作进行了封装，使得内核开发者可以更加方便地进行内存管理。
    
    &emsp;&emsp;内存管理模块主要由以下类型的组件组成：
    
    - **硬件抽象层（MemoryManagementArch）** - 提供对具体处理器架构的抽象，使得内存管理模块可以在不同的处理器架构上运行
    - **页面映射器（PageMapper）**- 提供对虚拟地址和物理地址的映射，以及页表的创建、填写、销毁、权限管理等操作。分为两种类型：内核页表映射器（KernelMapper）和用户页表映射器（位于具体的用户地址空间结构中）
    - **页面刷新器（PageFlusher）** - 提供对页表的刷新操作（整表刷新、单页刷新、跨核心刷新）
    - **页帧分配器（FrameAllocator）** - 提供对页帧的分配、释放、管理等操作。具体来说，包括BumpAllocator、BuddyAllocator
    - **小对象分配器** - 提供对小内存对象的分配、释放、管理等操作。指的是内核里面的SlabAllocator （SlabAllocator的实现目前还没有完成）
    - **MMIO空间管理器** - 提供对MMIO地址空间的分配、管理操作。（目前这个模块待进一步重构）
    - **用户地址空间管理机制** - 提供对用户地址空间的管理。
        - VMA机制 - 提供对用户地址空间的管理，包括VMA的创建、销毁、权限管理等操作
        - 用户映射管理 - 与VMA机制共同作用，管理用户地址空间的映射
    - **系统调用层** - 提供对用户空间的内存管理系统调用，包括mmap、munmap、mprotect、mremap等
    - **C接口兼容层** - 提供对原有的C代码的接口，是的C代码能够正常运行。
    
    
    除上面的新增内容以外，其它的更改内容：
    - 新增二进制加载器，以及elf的解析器
    - 解决由于local_irq_save、local_irq_restore函数的汇编不规范导致影响栈行为的bug。
    - 解决local_irq_save未关中断的错误。
    - 修复sys_gettimeofday对timezone参数的处理的bug
    
    ---------
    
    Co-authored-by: kong <kongweichao@dragonos.org>

commit bb5f098a864cee36b7d2c1ab9c029c0280d94a8a
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Jul 22 16:24:55 2023 +0800

    Revert "新的内存管理模块 (#301)" (#302)
    
    This reverts commit d8ad0a5e7724469abd5cc3cf271993538878033e.

commit d8ad0a5e7724469abd5cc3cf271993538878033e
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Jul 22 16:22:17 2023 +0800

    新的内存管理模块 (#301)
    
    &emsp;&emsp;实现了具有优秀架构设计的新的内存管理模块，对内核空间和用户空间的内存映射、分配、释放、管理等操作进行了封装，使得内核开发者可以更加方便地进行内存管理。
    
    &emsp;&emsp;内存管理模块主要由以下类型的组件组成：
    
    - **硬件抽象层（MemoryManagementArch）** - 提供对具体处理器架构的抽象，使得内存管理模块可以在不同的处理器架构上运行
    - **页面映射器（PageMapper）**- 提供对虚拟地址和物理地址的映射，以及页表的创建、填写、销毁、权限管理等操作。分为两种类型：内核页表映射器（KernelMapper）和用户页表映射器（位于具体的用户地址空间结构中）
    - **页面刷新器（PageFlusher）** - 提供对页表的刷新操作（整表刷新、单页刷新、跨核心刷新）
    - **页帧分配器（FrameAllocator）** - 提供对页帧的分配、释放、管理等操作。具体来说，包括BumpAllocator、BuddyAllocator
    - **小对象分配器** - 提供对小内存对象的分配、释放、管理等操作。指的是内核里面的SlabAllocator （SlabAllocator的实现目前还没有完成）
    - **MMIO空间管理器** - 提供对MMIO地址空间的分配、管理操作。（目前这个模块待进一步重构）
    - **用户地址空间管理机制** - 提供对用户地址空间的管理。
        - VMA机制 - 提供对用户地址空间的管理，包括VMA的创建、销毁、权限管理等操作
        - 用户映射管理 - 与VMA机制共同作用，管理用户地址空间的映射
    - **系统调用层** - 提供对用户空间的内存管理系统调用，包括mmap、munmap、mprotect、mremap等
    - **C接口兼容层** - 提供对原有的C代码的接口，是的C代码能够正常运行。
    
    
    除上面的新增内容以外，其它的更改内容：
    - 新增二进制加载器，以及elf的解析器
    - 解决由于local_irq_save、local_irq_restore函数的汇编不规范导致影响栈行为的bug。
    - 解决local_irq_save未关中断的错误。
    - 修复sys_gettimeofday对timezone参数的处理的bug

commit 0663027b111ffb6ff93becd60ffef1e2b8fbd4c6
Author: TingHuang <92705854+TingSHub@users.noreply.github.com>
Date:   Wed Jul 12 12:49:45 2023 +0800

    注册串口设备，创建字符设备框架(#290)
    
    * 按照rust规范修改两个函数名称
    
    * 修改一些函数句柄以符合rust规范
    
    * 添加字符设备相关
    
    * 添加字符设备相关文件
    
    * 添加字符设备驱动框架代码
    
    * 将串口注册
    
    * 规范代码

commit cc36cf4a186be834e6c2ab857b9b9501ddb8b1eb
Author: YJwu2023 <yujianwu2019@gmail.com>
Date:   Sat Jul 8 17:22:42 2023 +0800

    PCI设备中断重构，删去USB相关代码 (#285)
    
    * 修复ecam无法获取MCFG table的问题
    
    * 完善pcie
    
    * 完善irq的错误检测机制

commit 2311e2f30048d09250afc3e2e4e7029627996655
Author: 櫻井桃華 <89176634+TihayaKousaka@users.noreply.github.com>
Date:   Fri Jul 7 22:50:46 2023 +0800

    修改makefile通过编译 (#287)

commit 36fd013004ee0bd5fc7cfb452ba22531a83a859c
Author: houmkh <1119644616@qq.com>
Date:   Sat Jun 17 22:48:15 2023 +0800

    实现gettimeofday()系统调用和clocksource+timekeeping子模块 (#278)
    
    - 实现gettimeofday()系统调用
    - 实现clocksource+timekeeping子模块部分功能
    - 实现了timespec转换成日期时间

commit a55ac7b928a6ca08483bbb3355bea55f1446ccab
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Jun 6 17:44:54 2023 +0800

    Update issue templates (#277)

commit 5f57834372f6cb720ba14103effa4799e195a963
Author: Tptogiar <2528891112@qq.com>
Date:   Tue Jun 6 16:41:02 2023 +0800

    Makefile: 根目录下添加make help命令 (#271)
    
    * Makefile: 根目录下添加make help命令
    
    * Makefile: 补充根目录Makefile的help命令

commit aa0367d69e15989684109c5b454e85da9ecb1975
Author: LoGin <longjin@DragonOS.org>
Date:   Tue May 30 10:21:11 2023 +0800

    新的ipi功能&kick_cpu功能的重写 (#274)

commit bb24249faabc5006784aa98ca17b4cbdcb788c65
Author: LoGin <longjin@DragonOS.org>
Date:   Sun May 28 23:00:37 2023 +0800

    添加AlignBox和int_like宏 (#272)

commit ab5c8ca46db8e7d4793a9791292122b0b9684274
Author: login <longjin@DragonOS.org>
Date:   Wed May 24 17:05:33 2023 +0800

    重构系统调用模块 (#267)
    
    * 完成系统调用模块重构
    
    * 更新github workflow

commit 660a04cef803fd73e9b294b30a96421b021a4b9b
Author: login <longjin@DragonOS.org>
Date:   Sat May 13 21:17:12 2023 +0800

    新增http server (#265)
    
    * 1.修复了当传入ahci驱动的缓冲区地址为用户缓冲区时,产生的内存越界问题.(采用分配内核缓冲区的方式临时解决)
    2.新增http server
    
    * 把libssl-dev添加到bootstrap.sh
    
    * http_server增加对父级相对路径的安全检查，防止访问系统内的其他文件
    
    * 检查空指针情况
    
    * 解决由于链接时，crt*.o未按照升序排列导致init段链接错误的问题

commit 49249f4ec94fad7baf923aed68d9a7b2da3de3d4
Author: Bullet <93781792+GP-Bullet@users.noreply.github.com>
Date:   Sat May 13 09:55:24 2023 +0800

    把调度器实例的裸指针改为Option (#262)

commit bfafc102798ab1968ccf6b04315d8d3359a70ca8
Author: login <longjin@DragonOS.org>
Date:   Thu May 11 17:41:42 2023 +0800

    修复读取stdin时，无法正常读取的问题。 (#264)

commit 7285c927d95bb4b5c692c51a8f86c47009d07667
Author: login <longjin@DragonOS.org>
Date:   Thu May 11 16:17:58 2023 +0800

    添加dadk支持 (#263)
    
    * 引入dadk，使用dadk0.1.1来编译test-relibc程序
    
    * 由于gitee仓库体积限制导致无法继续使用gitee上的rust索引，因此更换为清华源
    
    * github workflow的环境中，安装dadk
    
    * Auto configure dragonos rust toolchain

commit b11bb1b25676f528ec1b0e1da0af82b4652f70c4
Author: login <longjin@DragonOS.org>
Date:   Sun May 7 22:20:33 2023 +0800

    固定编译工具链、修复由于新版rust编译器问题导致的报错。 (#258)
    
    * 固定编译工具链、修复由于新版rust编译器问题导致的报错。
    
    * 完善github workflow环境配置

```