# V0.1.6

:::{note}
本文作者：龙进 <longjin@DragonOS.org>


2023年4月2日
:::

## 贡献者名单

DragonOS V0.1.6版本由以下小伙伴贡献代码：

- 龙进 <longjin@DragonOS.org>
- 关锦权 <guanjinquan@DragonOS.org>
- 苏琎韬 <sujintao@DragonOS.org>
- 侯嘉滢 <houjiaying@DragonOS.org>
- 吴宇健 <wuyujian@DragonOS.org>
- Mork <91721145+MorkCarpenter@users.noreply.github.com>
- WaferJay <17383312+WaferJay@users.noreply.github.com>
- HoshuChiu <129569557+HoshuChiu@users.noreply.github.com>

## 赞助者名单

感谢以下同学的赞赏，我们将不断努力！

- 万晓兰
- David Wen
- [Seele.Clover](https://github.com/seeleclover)
- [FindWangHao](https://github.com/FindWangHao)
- 叶锦毅
- 林
- Albert
- [TerryLeeSCUT · GitHub](https://github.com/TerryLeeSCUT)
- slientbard
- 悟
- 匿名热心人士

## 更新内容-内核

- softirq: 重构了软中断 (#223)
- timer: 重构了系统定时器 (#223)
- stdio: 新增tty设备，用于标准输入输出 (#202) (#217)
- lib: 第一套键盘扫描码的状态机 (#216) (#219)
- syscall: 新增dup,dup2系统调用 (#224)
- syscall: 新增SystemError枚举类型，使得错误处理更清晰 (#205)
- driver: 新增x87浮点处理器支持 (#212)
- driver: VirtIO网卡能够正常发送、接收数据 (#204)
- filesystem: 修正了FAT32判断逻辑，解决了文件系统为FAT12/16时系统无法正常启动的问题。 (#211)
- filesystem: 新增VFS文档，以及修改文档配置 (#209)
- textui: 修复由于textui加锁，更改了preempt_count导致“进程长时间连续输出字符”的情况下，进程调度器不运行的问题。 (#203)
- scheduler: 解决由于在中断上下文以外，sched_enqueue时，未关中断导致cpu_queue双重加锁的问题 (#201)


## 更新内容-用户环境

### 新增仓库

- 新增子项目：[dsc](https://github.com/DragonOS-Community/dsc.git)
- 移植relibc: [DragonOS-relibc](https://github.com/DragonOS-Community/relibc.git)

## 更新内容-其他

- build: 添加了qemu使用VNC作为图像输出的选项 (#222)

## 更新内容-软件移植

无

## 源码、发布版镜像下载

&emsp;&emsp;您可以通过以下方式获得源代码:

### 通过Git获取

- 您可以访问[https://github.com/DragonOS-Community/DragonOS/releases](https://github.com/DragonOS-Community/DragonOS/releases)下载发布版的代码，以及编译好的，可运行的磁盘镜像。
- 我们在gitee上也有镜像仓库可供下载：[https://gitee.com/DragonOS/DragonOS](https://gitee.com/DragonOS/DragonOS)

### 通过DragonOS软件镜像站获取

&emsp;&emsp;为解决国内访问GitHub慢、不稳定的问题，同时为了方便开发者们下载DragonOS的每个版本的代码，我们特意搭建了镜像站，您可以通过以下地址访问镜像站：

&emsp;&emsp;您可以通过镜像站获取到DragonOS的代码压缩包，以及编译好的可运行的磁盘镜像。

- [https://mirrors.DragonOS.org](https://mirrors.DragonOS.org)
- [https://mirrors.DragonOS.org.cn](https://mirrors.DragonOS.org.cn)
- 国内镜像加速： [https://mirrors.ringotek.cn/] (https://mirrors.ringotek.cn/)

## 开放源代码声明


:::{note}
为促进DragonOS项目的健康发展，DragonOS以GPLv2开源协议进行发布。所有能获得到DragonOS源代码以及相应的软件制品（包括但不限于二进制副本、文档）的人，都能享有我们通过GPLv2协议授予您的权利，同时您也需要遵守协议中规定的义务。

这是一个相当严格的，保护开源软件健康发展，不被侵占的协议。

对于大部分的善意的人们而言，您不会违反我们的开源协议。

我们鼓励DragonOS的自由传播、推广，但是请确保所有行为没有侵犯他人的合法权益，也没有违反GPLv2协议。

请特别注意，对于违反开源协议的，尤其是**商业闭源使用以及任何剽窃、学术不端行为将会受到严肃的追责**。（这是最容易违反我们的开源协议的场景）。

并且，请注意，按照GPLv2协议的要求，基于DragonOS修改或二次开发的软件，必须同样采用GPLv2协议开源，并标明其基于DragonOS进行了修改。亦需保证这些修改版本的用户能方便的获取到DragonOS的原始版本。

您必须使得DragonOS的开发者们，能够以同样的方式，从公开渠道获取到您二次开发的版本的源代码，否则您将违反GPLv2协议。

关于协议详细内容，还敬请您请阅读项目根目录下的**LICENSE**文件。请注意，按照GPLv2协议的要求，**只有英文原版才具有法律效力**。任何翻译版本都仅供参考。
:::

### 开源软件使用情况

&emsp;&emsp;DragonOS在开发的过程中，参考了一些开源项目的设计，或者引入了他们的部分代码，亦或是受到了他们的启发。现将他们列在下面。我们对这些开源项目的贡献者们致以最衷心的感谢！

格式：<项目名> - <链接> - <开源协议>

- Linux - 	https://git.kernel.org/ - GPLv2
- skiftOS - https://github.com/skiftOS/skift - MIT
- FYSOS - https://github.com/fysnet/FYSOS - [FYSOS' License](https://github.com/fysnet/FYSOS/blob/9a8968e3d6600de34539c028c843f4c06d134039/license.txt)
- LemonOS - https://github.com/LemonOSProject/LemonOS.git - BSD 2-Clause License
- LZ4 - https://github.com/lz4/lz4 - BSD 2-Clause license
- SerenityOS - https://github.com/SerenityOS/serenity.git - BSD 2-Clause license
- MINE - 《一个64位操作系统的设计与实现》田宇; 人民邮电出版社
- chcore - 《现代操作系统：设计与实现》陈海波，夏虞斌; 机械工业出版社
- SimpleKernel - https://github.com/Simple-XX/SimpleKernel - MIT
- rcore-fs - https://github.com/rcore-os/rcore-fs.git - MIT
- redox - https://gitlab.redox-os.org/redox-os/redox - MIT

## 当前版本的所有提交记录

```text
commit bacd691c9ef0502b5cc618aad50517f9e59df5e0
Author: login <longjin@DragonOS.org>
Date:   Sun Apr 2 17:09:33 2023 +0800

    软中断&定时器重构 (#223)
    
    * 软中断&定时器重构
    
    Co-authored-by: houmkh<houjiaying@DragonOS.org>
    
    * 修改timer的clock()
    
    * 删除debug信息
    
    ---------
    
    Co-authored-by: houmkh <1119644616@qq.com>

commit 6d345b774223b0daaf0ee629c7fb595a1912a9e2
Author: HoshuChiu <129569557+HoshuChiu@users.noreply.github.com>
Date:   Sun Apr 2 15:55:24 2023 +0800

    添加了qemu使用VNC作为图像输出的选项 (#222)
    
    * 添加了qemu使用VNC作为图像输出的选项
    
    * 设置vnc端口为5900
    
    ---------
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 2b771e32f5795e0fdda458e3bb2651ef6b9673ac
Author: Gou Ngai <sujintao@dragonos.org>
Date:   Sun Apr 2 15:43:53 2023 +0800

    Add dup,dup2 (#224)
    
    * dup,dup2
    
    * fix: sys_dup2语义与posix不一致的问题
    
    ---------
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit d7b31a969ff091224a4929496f0278d024f78c77
Author: Gou Ngai <sujintao@dragonos.org>
Date:   Fri Mar 31 18:23:58 2023 +0800

    Patch keyboard capslock alt (#219)
    
    * keyboard-alt-capslock
    
    * 解决键盘输入'%'字符的时候无法回显的bug
    
    ---------
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 20e3152e1eea97f87d644c3023391e172bc83c93
Author: login <longjin@DragonOS.org>
Date:   Fri Mar 31 12:54:37 2023 +0800

    将TTY与stdio进行连接,实现基本的stdio功能 (#217)
    
    * 将stdio与tty接上

commit 5fb12ce447710edf8566f250655a06cb27519fca
Author: Gou Ngai <sujintao@dragonos.org>
Date:   Thu Mar 30 18:19:02 2023 +0800

    第一套键盘扫描码的状态机 (#216)
    
    第一套键盘扫描码的状态机
    ---------
    
    Co-authored-by: guanjinquan <1666320330@qq.com>
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 676b8ef62e1a0a1e52d65b40c53c1636a2954040
Author: Mork <91721145+MorkCarpenter@users.noreply.github.com>
Date:   Wed Mar 29 21:24:11 2023 +0800

    部分函数从返回值为Result<<>,i32>修改为Result<<>,SystemError> (#210)
    
    * 将Result<<>,i32>替换为Result<<>,SystemError>
    * bugfix: 显示双缓冲区初始化的时候，连续注册了两次Video Softirq的问题。
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 64aea4b3494bee7375e1c1ee5739c9fab0db0cb7
Author: Gou Ngai <sujintao@dragonos.org>
Date:   Tue Mar 28 20:44:26 2023 +0800

    增加x87FPU支持 (#212)
    
    * remove `ret_from_syscall`
    *修复ps2键盘驱动程序inode在进程fork的时候导致死锁的问题.
    *更新: VFS每次拷贝文件描述符的时候,都会去调用inode的open函数
    
    ---------
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 2286eda6526ed1b46afd79b47dc701034b9e903d
Author: WaferJay <17383312+WaferJay@users.noreply.github.com>
Date:   Mon Mar 27 09:32:43 2023 +0800

    修正了FAT32判断逻辑，解决了文件系统为FAT12/16时系统无法正常启动的问题。 (#211)
    
    * fix(fat): fix determination of fat type casue crash if fs is fat12/16
    
    * refactor(fat): split BiosParameterBlock.validate() into BiosParameterBlockFAT32.validate() and BiosParameterBlockLegacy.validate()
    
    * 调整“最大允许的簇号”的常量放置的位置。
    
    ---------
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 45b8371173b070028457f7ee64be33f68b4f9ada
Author: login <longjin@DragonOS.org>
Date:   Sat Mar 25 14:51:16 2023 +0800

    新增VFS文档，以及修改文档配置 (#209)
    
    * 1.新增vfs设计文档
    2.修改文档版权标志为"2022-2023, DragonOS Community"
    3.修改电脑版文档页面的宽度为90%
    
    * layout.html末尾加空行

commit 73c607aaddf6e4634cad179a81d3f1bc589f7220
Author: YJwu2023 <119829947+YJwu2023@users.noreply.github.com>
Date:   Sat Mar 18 20:43:37 2023 +0800

    VirtIO网卡能够正常发送、接收数据 (#204)
    
    * virtio-net小修改
    
    * 移动volatile.rs到libs文件夹
    
    * 使用virtio-drivers 0.3.0
    
    * bugfix: 初始化BAR之后，未正确设置command register的问题
    
    
    ---------
    
    Co-authored-by: longjin <longjin@dragonos.org>

commit 4454d1a2dd1f1078750151c028a794cfd9a04a1b
Author: login <longjin@DragonOS.org>
Date:   Sat Mar 18 20:26:05 2023 +0800

    新增SystemError枚举类型，使得错误处理更清晰 (#205)

commit 0d48c3c9c21a2dd470d0e1e58b507db60e0887bb
Author: login <longjin@DragonOS.org>
Date:   Thu Mar 16 19:48:59 2023 +0800

    new: tty设备（尚未与stdio接上） (#202)

commit 790d45764090bce3bbfb96b42b2818100a8cef9a
Author: login <longjin@DragonOS.org>
Date:   Wed Mar 15 11:42:41 2023 +0800

    修复由于textui加锁，更改了preempt_count导致“进程长时间连续输出字符”的情况下，进程调度器不运行的问题。 (#203)

commit c2e757d8cbeed01b16f48bea48ed8447685e6f1a
Author: login <longjin@DragonOS.org>
Date:   Mon Mar 13 22:22:23 2023 +0800

    解决由于在中断上下文以外，sched_enqueue时，未关中断导致cpu_queue双重加锁的问题 (#201)

```