# V0.1.3

:::{note}
本文作者：龙进 <longjin@RinGoTek.cn>

2023年1月8日
:::

## 贡献者名单

DragonOS V0.1.3版本由以下小伙伴贡献代码：

- 龙进 <longjin@RinGoTek.cn>
- 吴宇健 <wuyujian@DragonOS.org>
- 关锦权 <guanjinquan@DragonOS.org>
- Gou Ngai <sujintao@DragonOS.org>

## 赞助者名单

感谢以下同学的赞赏，我们将不断努力！

- David Wen
- [Seele.Clover](https://github.com/seeleclover)
- TerryLeeSCUT 
- 悟
- slientbard

## 更新内容-内核

- syscall: new: 增加getpid系统调用 (#120)
- signal: update: 对于除了SIGKILL以外的信号，也将他们加入SigQueue (#120)
- rtc: refactor: 使用Rust重构RTC驱动 (#118)
- doc: new: 新增signal的文档 (#126)
- Spinlock: new: 新增rust写的RawSpinlock (#127)
- arch: update: 在lib.rs中，将arch模块的路径进行更改，使得其他模块使用arch的代码时，不需要指定arch::x86_64 (#128)
- mm: bugfix: 修复页面分配器在初始化时，ZONE_NORMAL_INDEX始终为0的bug (#129)
- scheduler: new: 使用Rust重构CFS调度器 (#131)
- smp: 删除已经在smp中废弃的HPET中断转发函数 (#131)
- process: bugfix: 修复init进程忘记设定fs gs寄存器的问题。 (#132)
- vfs: update: 将VFS文件夹重命名为vfs (#133)
- lockref: new: 新增rust版本的lockref (#135)
- cpu: new: new:Rust封装cpu_relax(),通过pause指令，让cpu休息一会儿,降低空转功耗. (#135)
- 使用rust重构softirq机制 (#138)


## 更新内容-用户环境

- libc: bugfix: 注册信号处理函数时，总是注册sigkill的问题 (#120)
- libc: new: 增加了raise、kill、abort (#120)
- libc: new: 新增arch文件夹，在下面新增crt0 crti crtn文件 (#134)
- libc: new: 新增`fflush()`, `fprintf()`, `stdin`, `stdout`, `stderr`, `ferror()`, `fopen()`, `fclose()`, `putchar()`, `puts()` (#136)
- libc: new: 简单添加了`fopen()`对mode参数的处理。请注意，它没有完全遵循posix，也与Linux的不一致，将来使用Rust的时候完善它。 (#141)
- 移植: new: 新增了gmp, mpfr, mpc的移植构建脚本 (#136)
- 移植: new: 新增了gcc、binutils的交叉编译构建脚本以及gcc-11.3.0, binutils-2.38的补丁（在DragonOS-community下的仓库中）(#136)
- compile: update: 更改编译器的Include路径，使得include时不需要加`<libc/src/include/>`前缀 (#124)

## 更新内容-其他

- bugfix: 修复docker安装时异常退出的bug (#116)
- new: 新增目标为x86_64-elf的GCC裸机编译器，并使用它来编译DragonOS (#111)
- update: 更新Docker编译镜像至版本`dragonos/dragonos-dev:v1.2`, 并支持从Dockerfile构建这个编译镜像 (#111)
- bugfix: 修复MBR磁盘镜像未设置启动标志的bug (#111)
- update: 更新github workflow，增加cache，加快build check的速度
- bugfix: 修复下载grub2.06时的提示错误 (#125)

## 更新内容-软件移植

- new: gcc 11.3.0 userland cross-compiler， 提交：`64a5b1cbf28e3305560e166c1b6624e99745c720`, 仓库：[https://github.com/DragonOS-Community/gcc](https://github.com/DragonOS-Community/gcc)
- new: binutils 2.38 cross-compile tools， 提交：`a0ae560e0065862a9867b9e1f8364749ef38d99e`, 仓库：[https://github.com/DragonOS-Community/binutils](https://github.com/DragonOS-Community/binutils)
- new: gmp 6.2.1, 提交：`dd9eee5778fb6027fafa4fe850aff21b1a71c18e`, 仓库：[https://github.com/DragonOS-Community/gmp-6.2.1](https://github.com/DragonOS-Community/gmp-6.2.1)
- new: mpfr 4.1.1, 提交：`fa8e30cdc2e838fdd82b60fec31fcfc5e118aad6`, 仓库：[https://github.com/DragonOS-Community/mpfr](https://github.com/DragonOS-Community/mpfr)
- new: mpc 1.2.1, （无需打补丁即可移植），仓库：[https://github.com/DragonOS-Community/mpc](https://github.com/DragonOS-Community/mpc)


## 源码、发布版镜像下载

&emsp;&emsp;您可以通过以下方式获得源代码:

### 通过Git获取

- 您可以访问[https://github.com/fslongjin/DragonOS/releases](https://github.com/fslongjin/DragonOS/releases)下载发布版的代码，以及编译好的，可运行的磁盘镜像。
- 我们在gitee上也有镜像仓库可供下载：[https://gitee.com/DragonOS/DragonOS](https://gitee.com/DragonOS/DragonOS)

### 通过DragonOS软件镜像站获取

&emsp;&emsp;为解决国内访问GitHub慢、不稳定的问题，同时为了方便开发者们下载DragonOS的每个版本的代码，我们特意搭建了镜像站，您可以通过以下地址访问镜像站：

&emsp;&emsp;您可以通过镜像站获取到DragonOS的代码压缩包，以及编译好的可运行的磁盘镜像。

- [https://mirrors.DragonOS.org](https://mirrors.DragonOS.org)
- [https://mirrors.DragonOS.org.cn](https://mirrors.DragonOS.org.cn)
- 国内镜像加速： [https://mirrors.ringotek.cn/] (https://mirrors.ringotek.cn/)

## 开放源代码声明


:::{note}
为促进DragonOS项目的健康发展，DragonOS以GPLv2开源协议进行发布。所有能获得到DragonOS源代码以及相应的软件制品（包括但不限于二进制副本、文档）的人，都能享有我们通过GPLv2协议授予您的权利，同时您也需要遵守协议中规定的义务。

这是一个相当严格的，保护开源软件健康发展，不被侵占的协议。

对于大部分的善意的人们而言，您不会违反我们的开源协议。

我们鼓励DragonOS的自由传播、推广，但是请确保所有行为没有侵犯他人的合法权益，也没有违反GPLv2协议。

请特别注意，对于违反开源协议的，尤其是**商业闭源使用以及任何剽窃、学术不端行为将会受到严肃的追责**。（这是最容易违反我们的开源协议的场景）。

并且，请注意，按照GPLv2协议的要求，基于DragonOS修改或二次开发的软件，必须同样采用GPLv2协议开源，并标明其基于DragonOS进行了修改。亦需保证这些修改版本的用户能方便的获取到DragonOS的原始版本。

您必须使得DragonOS的开发者们，能够以同样的方式，从公开渠道获取到您二次开发的版本的源代码，否则您将违反GPLv2协议。

关于协议详细内容，还敬请您请阅读项目根目录下的**LICENSE**文件。请注意，按照GPLv2协议的要求，**只有英文原版才具有法律效力**。任何翻译版本都仅供参考。
:::

### 开源软件使用情况

&emsp;&emsp;DragonOS在开发的过程中，参考了一些开源项目的设计，或者引入了他们的部分代码，亦或是受到了他们的启发。现将他们列在下面。我们对这些开源项目的贡献者们致以最衷心的感谢！

格式：<项目名> - <链接> - <开源协议>

- Linux - 	https://git.kernel.org/ - GPLv2
- skiftOS - https://github.com/skiftOS/skift - MIT
- FYSOS - https://github.com/fysnet/FYSOS - [FYSOS' License](https://github.com/fysnet/FYSOS/blob/9a8968e3d6600de34539c028c843f4c06d134039/license.txt)
- LemonOS - https://github.com/LemonOSProject/LemonOS.git - BSD 2-Clause License
- LZ4 - https://github.com/lz4/lz4 - BSD 2-Clause license
- SerenityOS - https://github.com/SerenityOS/serenity.git - BSD 2-Clause license
- MINE - 《一个64位操作系统的设计与实现》田宇; 人民邮电出版社
- chcore - 《现代操作系统：设计与实现》陈海波，夏虞斌; 机械工业出版社
- SimpleKernel - https://github.com/Simple-XX/SimpleKernel - MIT
- rcore-fs - https://github.com/rcore-os/rcore-fs.git - MIT

## 当前版本的所有提交记录

```text
commit a8b621c8d1fe77251b8e4eafe258dc0ee7366dd5
Author: login <longjin@ringotek.cn>
Date:   Sun Jan 8 15:47:44 2023 +0800

    修正由于libc中具有crti.S和crtn.S，造成的与x86_64-elf-gcc不兼容的问题 (#144)

commit 9358ff0f6f7daa18d6fab4497de025736b3d6725
Author: login <longjin@ringotek.cn>
Date:   Sun Jan 8 15:06:52 2023 +0800

    Add v0.1.3 changelog (#143)
    
    * new: 0.1.3发行日志
    
    * 新增输出指定时间范围内的贡献者名单的脚本
    
    * 更新bootloader文档
    
    * update: 简介文档
    
    * new: 镜像站文档
    
    * update: 功能特性文档

commit fd91905f022b3ceaa59e666d1ff42d91fb8d40ef
Author: login <longjin@ringotek.cn>
Date:   Sun Jan 8 11:38:59 2023 +0800

    解决编译gcc、binutils的脚本中，变量名称错误的问题 (#142)

commit 62e4613978193aaf5d949a331df0398f2d085a30
Author: Gou Ngai <94795048+AlbertSanoe@users.noreply.github.com>
Date:   Sat Jan 7 23:15:37 2023 +0800

    使用rust重构softirq机制；解决Rtc驱动的编译警告问题 (#138)
    
    * 使用rust重构softirq机制
    * 解决Rtc驱动的编译警告问题
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit e9fdc57bf878f1bc5cc5743dfaeeaef743439291
Author: login <longjin@ringotek.cn>
Date:   Sat Jan 7 22:36:49 2023 +0800

    简单添加了fopen对mode参数的处理。请注意，它没有完全遵循posix，也与Linux的不一致，将来使用Rust的时候完善它。 (#141)

commit 2224c93ea968bc74621f7e124b4aca04875b3e6a
Author: guanjinquan <1666320330@qq.com>
Date:   Fri Jan 6 21:29:23 2023 +0800

    完善libc，构建了OS-specific工具链，编译了基于gcc-11.3.0的DragonOS userland compiler，移植了mpfr,gmp,mpc库 (#134)
    
    * 修改include路径
    
    * 添加了创建libsysapi.a和/bin/sysroot/usr/include/+lib/的代码
    
    * 修补.gitignore
    
    * 删除多余项
    
    * 优化脚本可读性
    
    * 新增crt0 crti crtn
    
    * 编译binutils所需的东西
    
    * fflush()和fprintf()的简单实现
    
    * 应用程序启动前，调用初始化libc的函数
    
    * 自动创建sysroot
    
    * 添加了stderr的初始化
    
    * 修改了stderr的初始化
    
    * 内核添加对stdio的简略处理
    
    * 格式化代码
    
    * 修正打开stdio文件描述符的问题
    
    * bugfix: 修复fprintf忘记释放buf的问题
    
    * 修复shell错误地把入口设置为main而不是_start的问题
    
    * 新增__cxa_atexit  (gcc要求libc提供这个）
    
    * 增加putchar puts
    
    * 更新写入磁盘镜像的脚本，默认无参数时，使用legacy方式安装
    
    * 更新编译脚本
    
    * stdio增加eof的定义
    
    * 新增extern cplusplus
    
    * mpfr gmp mpc 构建脚本
    
    * 更新libsysapi.a为libc.a
    
    * 加上ferror fopen fclose
    
    * 更新移植的软件的构建脚本
    
    * 更改build_gcc_toolchain.sh中的-save参数名为-save-cache
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 61de2cdc3f29cdc6c441f128119e01e003e6f3ca
Author: login <longjin@ringotek.cn>
Date:   Tue Jan 3 23:09:25 2023 +0800

    新增rust版本的lockref (#135)
    
    * new:Rust封装cpu_relax(),通过pause指令，让cpu休息一会儿。降低空转功耗
    
    * new: Rust版本的lockref
    
    * Rust的RawSpinlock新增is_locked()和set_value()方法。
    
    * lockref文档

commit 2726f101b4cc787bbd36a69afffb0112f3a6567f
Author: login <longjin@ringotek.cn>
Date:   Tue Jan 3 21:01:56 2023 +0800

    删除无用的cfs.h (#136)

commit 587086d3f299f7394559d547c828191be20cfc11
Author: login <longjin@ringotek.cn>
Date:   Sun Jan 1 16:53:57 2023 +0800

    1、在文件系统目录下增加mod.rs 2、将VFS的路径改为vfs(#133)
    
    2、将VFS的路径改为vfs

commit 843e442971a47693f37a5f8d3452c383f7325359
Author: login <longjin@ringotek.cn>
Date:   Sat Dec 31 18:43:05 2022 +0800

    修复init进程忘记设定fs gs寄存器的问题。 (#132)

commit 74bde36e014ff501241bf40dd83653db47a2c8e4
Author: guanjinquan <1666320330@qq.com>
Date:   Sat Dec 31 17:35:39 2022 +0800

    Patch porting gcc v2 (#124)
    
    * 更改编译器的Include路径，使得include时不需要加`<libc/src/include/>`前缀
    
    * 修改include路径
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit d4f3de93a23e4bd4f000a3663768d47d094bf188
Author: login <longjin@ringotek.cn>
Date:   Sat Dec 31 17:26:12 2022 +0800

    使用Rust重构CFS调度器 (#131)
    
    * 新建调度器的文件
    
    * 把softirq vector移动到c文件中（原来在.h)
    
    * 将进程切换方式改为“中断返回时切换”
    
    * new:使用rust重构CFS
    
    * 删除已经在smp中废弃的HPET中断转发函数
    
    * 代码格式化
    
    * 删除多余的dunce依赖

commit 156949680c83f2d7e3b21ed68b11698b88eaf396
Author: login <longjin@ringotek.cn>
Date:   Sat Dec 31 13:47:49 2022 +0800

    bugfix:修复当使用sched()运行调度器，在切换进程的时候，由于不在中断上下文内，导致当前进程的上下文丢失的问题。 (#130)
    
    bugfix:修复当使用sched()运行调度器，在切换进程的时候，由于不在中断上下文内，导致当前进程的上下文丢失的问题。
    bugfix:修复切换进程的宏的汇编代码的损坏部分，未声明rax寄存器，从而导致的编译器未定义行为问题。

commit 882f0b7e7498dbff8de527b2b9159b7f6e6359c9
Author: YJwu2023 <119829947+YJwu2023@users.noreply.github.com>
Date:   Wed Dec 28 19:35:17 2022 +0800

    修复内存bug与grub安装脚本的错误 (#129)
    
    * 修复内存bug与grub安装脚本的错误
    
    * 修改小bug

commit adc1846b06fb862caed049f435fc0061488a6ff9
Author: login <longjin@ringotek.cn>
Date:   Mon Dec 26 13:13:12 2022 +0800

    内核：在lib.rs中，将arch模块的路径进行更改，使得其他模块使用arch的代码时，不需要指定arch::x86_64 (#128)

commit ac643d420b22f9d454ecefccd51ed34a9664586b
Author: login <longjin@ringotek.cn>
Date:   Sun Dec 25 23:53:35 2022 +0800

    new:新增rust写的RawSpinlock (#127)

commit 998390210549b47e6bdcc3fdab49eff4086ad18b
Author: login <longjin@ringotek.cn>
Date:   Sat Dec 24 23:30:26 2022 +0800

    新增signal文档 (#126)
    
    * 新增signal文档

commit a7f5ca7b67160557abf84a1169dd60093220aeb0
Author: YJwu2023 <119829947+YJwu2023@users.noreply.github.com>
Date:   Sat Dec 24 23:29:36 2022 +0800

    修复下载grub2.06时的提示错误 (#125)
    
    * 修复grub下载显示提示显示错误

commit 82762007da41148e1ed1df465211eb5c8ba2c15e
Author: login <longjin@ringotek.cn>
Date:   Fri Dec 23 18:11:47 2022 +0800

    Update makefile.yml

commit b975025ec8854ca232152f4ee44cc2226891a34c
Author: login <longjin@ringotek.cn>
Date:   Fri Dec 23 11:45:19 2022 +0800

    Update makefile.yml

commit ad2bb74d949bfcb2935e43ac7b261d7ecce23389
Author: login <longjin@ringotek.cn>
Date:   Fri Dec 23 11:21:22 2022 +0800

    Update makefile.yml

commit 6b7776d189ab5f19fbab20d6c5c9ed3ab20c7ab6
Author: login <longjin@ringotek.cn>
Date:   Fri Dec 23 10:59:15 2022 +0800

    修正smp的makefile中没有替换AS的问题

commit beb12a188b6c6bc4196796ac2ae1ecd7d8ed8223
Author: login <longjin@ringotek.cn>
Date:   Fri Dec 23 10:57:39 2022 +0800

    Update makefile.yml

commit d65c527730e5c8a75f6dad0f996c093040699ee3
Author: login <longjin@ringotek.cn>
Date:   Thu Dec 22 22:58:28 2022 +0800

    Update makefile.yml (#121)

commit 5ed4cd460200cb19aae8c3c67dfd77e1e9f0e105
Author: guanjinquan <75822481+guanjinquan@users.noreply.github.com>
Date:   Thu Dec 22 21:09:12 2022 +0800

    Patch gcc toolchain (#111)
    
    * 添加了GCC_cross_compile——tool_chain
    
    * - 解决环境变量路径拼接时，多了`/`的问题
    - apt安装时增加-y,不需用户确认
    
    * 解决添加环境变量的命令有误的问题
    
    * 修正编译错误时，还会执行下一步的问题
    
    * new: 编译完成后清理临时文件
    
    * 更新makefile
    
    * 调整：把grub安装在 $HOME/opt/dragonos-grub下
    
    * new: 新增dockerfile
    
    * 将镜像源换成中科大的（原因是清华的总是ban掉用于构建镜像的服务器的ip）
    
    * 修改为基于debian bullseye构建
    
    * 取消指定版本
    
    * 修复MBR磁盘镜像未设置启动标志的bug
    
    * 取消在docker中安装grub
    
    * 安装grub的过程改到客户机上进行
    
    * bootstrap.sh 添加--no-docker
    
    * 使用新版的docker编译镜像
    
    * 修补, 添加了一些关于gcc的check
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit ba0d93d8b26034abc54bcaf3f0ff04863bbd076e
Author: Gou Ngai <94795048+AlbertSanoe@users.noreply.github.com>
Date:   Mon Dec 19 15:04:37 2022 +0800

    refactor rtc module in rust (#118)
    
    * 用rust重构rtc模块
    
    * refactor the rtc module by rust
    
    * rtc-updated
    
    * rtc-updated-4
    
    * rtc

commit c588d6f77f4b38939701b946228218ea81a7c8dc
Author: login <longjin@ringotek.cn>
Date:   Mon Dec 19 15:03:44 2022 +0800

    Patch add abort func (#120)
    
    * 对于除了sigkill以外的信号，也加入队列
    
    * bugfix:libc中，注册信号处理函数时，总是注册sigkill的问题
    
    * 增加getpid系统调用
    
    * 增加了raise、kill、abort

commit 47f0d12a1f1a1aa11be8e751ecdbf76f0cb596d9
Author: YJwu2023 <119829947+YJwu2023@users.noreply.github.com>
Date:   Mon Dec 19 14:53:51 2022 +0800

    修复docker安装时异常退出的bug (#119)
    
    * 修复docker安装时异常退出的bug
    
    * 修复grub编译脚本的小bug

commit 978043e47d1143ca2d5cf22b20793f032e8eb5a5
Author: login <longjin@ringotek.cn>
Date:   Sun Dec 18 15:09:15 2022 +0800

    修复当系统中不存在dosfstools时，无法正确格式化磁盘镜像的问题 (#117)
    
    * 修复当系统中不存在dosfstools时，无法正确格式化磁盘镜像的问题

commit f9127772dc372a2e607388fdd6818d3f9c4c6d28
Author: YJwu2023 <119829947+YJwu2023@users.noreply.github.com>
Date:   Sat Dec 17 23:43:23 2022 +0800

    修复docker安装时异常退出的bug (#116)

```