# V0.1.2

:::{note}
本文作者：龙进 <longjin@RinGoTek.cn>

2022年12月17日
:::

## 贡献者名单

DragonOS V0.1.2版本由以下小伙伴贡献代码：

- 龙进 <longjin@ringotek.cn>
- 吴宇健 <wuyujian@DragonOS.org>
- Gou Ngai <sujintao@DragonOS.org>
- 黄厅 <huangting@DragonOS.org>
- 王文聪 <1297389017@qq.com>

## 赞助者名单

感谢以下同学的赞赏，我们将不断努力！

- David Wen
- [Seele.Clover](https://github.com/seeleclover)
- TerryLeeSCUT 
- 悟
- slientbard

其中，非常感谢**Seele.Clover**给予DragonOS项目人民币500元的赞助与支持！我们对于每一笔赞助款项，将仔细登记，并确保其能被妥善的使用。

## 更新内容-内核

- 删除rust_helloworld文件 (#113)
- Signal: 允许用户注册信号处理函数，能够进入自定义的handler。(#112)
    - 支持kill命令
    - 允许用户自定义信号处理函数
    - 新增2个系统调用：`SYS_SIGACTION` , `SYS_RT_SIGRETURN`
    - libc增加`signal()`,`sigaction()`函数。
    - 暂时只支持旧版的sighandler，即：只有1个参数的`void handler(int signum)`类型的信号处理函数。对于另一种信号处理函数`void handler(int signum, siginfo_t *info, void* data)`，尚不支持传递第三个参数。
- 在内核代码中加入自定义的stdint.h文件 (#109)
- 调整编译grub的脚本的部分 (#108)
- 新增32、64位uefi启动 (#105)(#101)
- 使用编译安装的grub-2.06，解决客户机上grub版本不对导致的编译无法运行的问题。
- 增加了timekeeping模块 (#106)
- bugfix: 修复rtc时钟对BCD码进行转换的时候，忘了处理day字段的问题 (#104)
- new: 开发过程文档（完成了一半）
- bootstrap.sh解决下载rust慢的问题
- 更新“构建系统”文档
- procfs->status增加显示preempt和虚拟运行时间 (#100)
- ffz函数：获取u64中的第一个值为0的bit (#100)
- 解决由于编译器优化导致local_irq_restore无法获取到正确的rflags的值的问题
- 使用Rust重构串口驱动 (#99)

## 更新内容-用户环境

- about app: 显示当前构建的git commit sha1以及构建时间(#114)
- shell: 修复shell的exec命令对绝对路径的拼接错误问题(#114)
- shell: exec命令增加"&"后台运行选项 (#100)
- new: 测试signal用的app
- 将libc目录进行调整，加入cargo作为rust的包管理器


## 源码、发布版镜像下载

&emsp;&emsp;您可以通过以下方式获得源代码:

### 通过Git获取

- 您可以访问[https://github.com/fslongjin/DragonOS/releases](https://github.com/fslongjin/DragonOS/releases)下载发布版的代码，以及编译好的，可运行的磁盘镜像。
- 我们在gitee上也有镜像仓库可供下载：[https://gitee.com/DragonOS/DragonOS](https://gitee.com/DragonOS/DragonOS)

### 通过DragonOS软件镜像站获取

&emsp;&emsp;为解决国内访问GitHub慢、不稳定的问题，同时为了方便开发者们下载DragonOS的每个版本的代码，我们特意搭建了镜像站，您可以通过以下地址访问镜像站：

&emsp;&emsp;您可以通过镜像站获取到DragonOS的代码压缩包，以及编译好的可运行的磁盘镜像。

- [https://mirrors.DragonOS.org](https://mirrors.DragonOS.org)
- [https://mirrors.DragonOS.org.cn](https://mirrors.DragonOS.org.cn)


## 开放源代码声明


:::{note}
为促进DragonOS项目的健康发展，DragonOS以GPLv2开源协议进行发布。所有能获得到DragonOS源代码以及相应的软件制品（包括但不限于二进制副本、文档）的人，都能享有我们通过GPLv2协议授予您的权利，同时您也需要遵守协议中规定的义务。

这是一个相当严格的，保护开源软件健康发展，不被侵占的协议。

对于大部分的善意的人们而言，您不会违反我们的开源协议。

我们鼓励DragonOS的自由传播、推广，但是请确保所有行为没有侵犯他人的合法权益，也没有违反GPLv2协议。

请特别注意，对于违反开源协议的，尤其是**商业闭源使用以及任何剽窃、学术不端行为将会受到严肃的追责**。（这是最容易违反我们的开源协议的场景）。

并且，请注意，按照GPLv2协议的要求，基于DragonOS修改或二次开发的软件，必须同样采用GPLv2协议开源，并标明其基于DragonOS进行了修改。亦需保证这些修改版本的用户能方便的获取到DragonOS的原始版本。

您必须使得DragonOS的开发者们，能够以同样的方式，从公开渠道获取到您二次开发的版本的源代码，否则您将违反GPLv2协议。

关于协议详细内容，还敬请您请阅读项目根目录下的**LICENSE**文件。请注意，按照GPLv2协议的要求，**只有英文原版才具有法律效力**。任何翻译版本都仅供参考。
:::

### 开源软件使用情况

&emsp;&emsp;DragonOS在开发的过程中，参考了一些开源项目的设计，或者引入了他们的部分代码，亦或是受到了他们的启发。现将他们列在下面。我们对这些开源项目的贡献者们致以最衷心的感谢！

格式：<项目名> - <链接> - <开源协议>

- Linux - 	https://git.kernel.org/ - GPLv2
- skiftOS - https://github.com/skiftOS/skift - MIT
- FYSOS - https://github.com/fysnet/FYSOS - [FYSOS' License](https://github.com/fysnet/FYSOS/blob/9a8968e3d6600de34539c028c843f4c06d134039/license.txt)
- LemonOS - https://github.com/LemonOSProject/LemonOS.git - BSD 2-Clause License
- LZ4 - https://github.com/lz4/lz4 - BSD 2-Clause license
- SerenityOS - https://github.com/SerenityOS/serenity.git - BSD 2-Clause license
- MINE - 《一个64位操作系统的设计与实现》田宇; 人民邮电出版社
- chcore - 《现代操作系统：设计与实现》陈海波，夏虞斌; 机械工业出版社
- SimpleKernel - https://github.com/Simple-XX/SimpleKernel - MIT

## 当前版本的所有提交记录

```text
commit 7a818da88a1c7a1760de7671141b0ce1ca4e3dde
Author: login <longjin@ringotek.cn>
Date:   Sat Dec 17 17:49:12 2022 +0800

    Patch about auto gen version string (#114)
    
    * new: about app中，显示当前构建的git commit sha1以及构建时间
    
    * bugfix: 修复shell的exec命令对绝对路径的拼接错误问题

commit 83a7aaa46bbc411c43d4fc099c6c8884efbe4771
Author: login <longjin@ringotek.cn>
Date:   Sat Dec 17 16:31:50 2022 +0800

    删除rust_helloworld文件 (#113)

commit 6efd4740336205c9bfdd8b164e667cee2f38781e
Author: login <longjin@ringotek.cn>
Date:   Sat Dec 17 16:27:50 2022 +0800

    允许用户自定义信号处理函数 (#112)
    
    * new: 用户注册信号处理函数，能够进入自定义的handler
    
    * 修复忘了传信号的数字给用户的处理函数的bug
    
    * new:sigreturn
    
    * 删除注释

commit 0e0c187484281768391e131495f0655e40d70cf7
Author: login <longjin@ringotek.cn>
Date:   Fri Dec 16 16:20:09 2022 +0800

    在内核代码中加入自定义的stdint.h文件 (#109)

commit d02e6ea4112ad520aa4090ff73cdf592e14c0a82
Author: login <longjin@ringotek.cn>
Date:   Wed Dec 14 20:01:55 2022 +0800

    调整编译grub的脚本的部分 (#108)
    
    1、bugfix: 修复编译grub的脚本的部分错误
    2、将grub下载源替换为tuna
    3、优化写入磁盘镜像的脚本
    4、将bios文件夹改名为legacy

commit 38b341b8aa671f75ac26d05059aa2e9a09e653b7
Author: YJwu2023 <119829947+YJwu2023@users.noreply.github.com>
Date:   Wed Dec 14 16:58:49 2022 +0800

    新增32位uefi启动 (#105)
    
    * 新增32位uefi启动
    
    * 修复小bug
    
    * 增加grub本地编译安装
    
    * 增加本地grub编译安装脚本
    
    * 修正小错误
    
    * 修复空文件夹不上传的bug

commit 01876902fbf6ed43992cc7d153bd8c505cb5224b
Author: Gou Ngai <94795048+AlbertSanoe@users.noreply.github.com>
Date:   Wed Dec 14 15:13:54 2022 +0800

    增加了timekeeping模块 (#106)
    
    * 增加了timekeeping模块
    
    * 格式化文档和细节更改
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 728aca308917a7d4d0ba10fe8174e9408d77a9a6
Author: login <longjin@ringotek.cn>
Date:   Sun Dec 11 22:59:47 2022 +0800

    bugfix: 修复rtc时钟对BCD码进行转换的时候，忘了处理day字段的问题 (#104)

commit 237e95c6ddce72d72ae7fedfeca412fab82b3622
Author: wwc-15172310230 <78997674+wwc-15172310230@users.noreply.github.com>
Date:   Sun Dec 11 22:22:10 2022 +0800

    调整user下libs的libc目录结构 (#103)
    
    * 调整user下libs的libc目录结构
    
    * 修正.gitignore文件的问题
    
    * 修复无法编译的问题
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 2291ffdece1dc5a703602f79f74df8a4854d215b
Author: login <longjin@ringotek.cn>
Date:   Sun Dec 11 20:09:58 2022 +0800

    文档更新 (#102)
    
    * new: 开发过程文档（完成了一半）
    
    * bootstrap.sh解决下载rust慢的问题
    
    * 更新“构建系统”文档

commit 7f439c5ddbd2ecffc112149d16983975f523052c
Author: YJwu2023 <119829947+YJwu2023@users.noreply.github.com>
Date:   Fri Dec 9 16:08:54 2022 +0800

    增加uefi启动 (#101)
    
    * 增加uefi启动
    
    * 修改脚本
    
    * uefi修改
    
    * 删除错误的注释
    
    * 修正写入磁盘镜像的脚本
    
    * 修改X86_64为x86_64
    
    Co-authored-by: longjin <longjin@RinGoTek.cn>

commit 1a2eaa402f05f82aaeebe1e03824534a0a425d4d
Author: login <longjin@ringotek.cn>
Date:   Thu Dec 8 22:59:51 2022 +0800

    signal的处理(kill命令)以及一些其他的改进 (#100)
    
    * 将entry.S中冗余的ret_from_syscall代码删除，改为jmp Restore_all
    
    * new: 增加判断pt_regs是否来自用户态的函数
    
    * new: rust的cli和sti封装
    
    * 将原有的判断pt_regs是否来自用户态的代码，统一改为调用user_mode函数
    
    * ffz函数：获取u64中的第一个值为0的bit
    
    * spinlock增加 spinlock irq spin_unlock_irq
    
    * 临时解决显示刷新线程迟迟不运行的问题
    
    * 更改ffi_convert的生命周期标签
    
    * new: 测试signal用的app
    
    * 解决由于编译器优化导致local_irq_restore无法获取到正确的rflags的值的问题
    
    * new: exec命令增加"&"后台运行选项
    
    * procfs->status增加显示preempt和虚拟运行时间
    
    * 更改引用计数的FFIBind2Rust trait中的生命周期标签
    
    * new: signal处理(kill)
    
    * 更正在review中发现的一些细节问题

commit f8b55f6d3fcbf152a1cb6d6fc722bf1607418b28
Author: TingHuang <92705854+TingSHub@users.noreply.github.com>
Date:   Tue Dec 6 22:15:03 2022 +0800

    Patch uart (#99)
    
    * 添加UART驱动相关文件
    
    * 添加驱动核心文件，将rust编写的驱动代码加入Package中
    
    * 添加glib.h文件生成rust代码，添加uart驱动代码
    
    * 添加串口发送及接收相关代码
    
    * 添加字符串发送函数,未实现具体功能
    
    * 为调用uart驱动的代码添加rust接口
    
    * 添加字符串发送函数，修改C语言调用接口
    
    * 添加rust串口驱动
    
    * 添加uart.h头文件，将串口端口类型改为enum
    
    * 添加注释，规范代码

commit 036acc52ce9d0fb9e7d92768ff74939a29c07f32
Author: login <longjin@ringotek.cn>
Date:   Tue Nov 29 21:46:13 2022 +0800

    将entry.S中冗余的ret_from_syscall代码删除，改为jmp Restore_all (#98)
    
    * 将entry.S中冗余的ret_from_syscall代码删除，改为jmp Restore_all

```