# V0.1.10

:::{note}
本文作者：龙进 <longjin@DragonOS.org>

DragonOS官方论坛：[bbs.dragonos.org.cn](https://bbs.dragonos.org.cn)

2024年5月13日
:::

## 简介

&emsp;&emsp;本次版本更新，引入了42个feature类型的PR，24个bug修复，5个文档更新，以及一些软件移植、ci相关的内容。

&emsp;&emsp;当前版本核心看点：

- 对调度子系统进行了重构
- 能在riscv64下运行到hello world应用程序
- 内存管理子系统引入了匿名页反向映射、写时拷贝以及延迟分配的特性
- 文件系统引入了大量的新的系统接口
- 实现了pty，并能运行简单的ssh服务端


## 赞助商列表

- **[中国雅云](https://yacloud.net)** 雅安大数据产业园为DragonOS提供了云服务器支持。

## 更新内容-内核

- feat(fs): 实现了sys_rename (#578)
- feat(fs): 实现get_pathname (#615)
- feat(kernel): 实现uname系统调用 (#614)
- feat(fs): 添加mount系统调用 (#561)
- feat(smp): 重写SMP模块 (#633)
- feat(fs): 添加Statx系统调用 (#632)
- feat(riscv64): 添加flush tlb的ipi (#636)
- feat(fs): 实现SYS_LINK和SYS_LINKAT (#611)
- fix(fs): mkdir输出错误信息; 
- fix(clippy): 修复内核的clippy检查报错 (#637)
- feat(net): 实现socketpair (#576)
- feat(process/riscv): 进程管理初始化 (#654)
- fix(time): 修复clock_gettime返回类型错误，修复小时间间隔duration返回0问题 (#664)
- fix(driver/base): 把Device trait的set_class改为设置Weak指针，以避免循环引用问题。 (#666)
- feat(textui): 支持绘制24位深和16位深显示缓冲区 (#640)
- fix(driver/tty): 修复tty设备显示在/sys目录下的bug (#668)
- feat(fs): 新加结构体POSIXSTATFS与SuperBlock用于处理statfs系统调用 (#667)
- feat(driver/rtc):实现了rtc的抽象，并且把x86的cmos rtc接入到设备驱动模型 (#674)
- fix(net): 修复udp bind的时候，对port0处理不正确的问题(#676)
- fix(fs/ramfs): 修复了ramfs中move_to未更新parent字段的bug (#673)
- feat(mm): 实现页面反向映射 (#670)
- fix(misc): 修复get_ramdom的长度错误问题() (#677)
- feat(process/riscv): riscv64: switch process (#678)
- fix(misc): 使nproc可以正确获取到cpu核心数 (#689)
- fix(time): 修复jiffy时钟过快问题，启用gettimeofday测试，修改mount测试 (#680)
- feat(driver/pty): 实现pty，附带测试程序 (#685)
- feat(process/riscv): 实现copy-thread (#696)
- feat(sched): 重写调度模块 (#679)
- fix(riscv): 把内核编译target改为riscv64gc & 获取time csr的频率 & 修正浮点保存与恢复的汇编的问题 (#699)
- feat(lock): 实现robust futex (#682)
- feat(fs): BlockCache-read cache支持 (#521)
- feat(mm): 实现SystemV共享内存 (#690)
- chore(tools): add bootstrap support for Centos/RHEL8/fedora (#713)
- feat(driver/pty): 完善pty，目前pty能够支持ssh (#708)
- fix(smp): 修复smp启动的时候，损坏0号核心的idle进程的内核栈的问题 (#711)
- feat(driver/riscv): 初始化riscv-sbi-timer (#716)
- doc: Update DragonOS description and introduction (#717)
- feat(riscv): 让riscv64能正常切换进程，并运行完所有的initcall (#721)
- feat(net): 实现tcp backlog功能 (#714)
- feat(mm): 添加slab内存分配器 (#683)
- feat(fs): 引入Umount系统调用 (#719)
- doc: Update build instructions for riscv64 architecture (#725)
- fix(fs): socket统一改用`GlobalSocketHandle`,并且修复fcntl SETFD的错误 (#730)
- feat: alarm系统调用实现 (#710)
- feat(tty): add dummy console (#735)
- fix(driver/pci): pci: 统一使用ecam root (#744)
- feat(driver/pci): pci: 添加pci root manager来管理pci root，并使得riscv能够正常扫描pci设备. (#745)
- build: 将smoltcp升级到0.11.0版本 (#740)
- fix(unified-init): 修复unified-init导致cargo check失败的问题 (#747)
- chore: Update virtio-drivers to commit 61ece509c4 and modify max_queue_size implementation (#748)
- feat(net): 实现raw socket的poll (#739)
- feat(mm): 实现缺页中断处理，支持页面延迟分配和写时拷贝，以及用户栈自动拓展 (#715)
- feat(driver): 把virtio添加到sysfs (#752)
- fix(dog): 添加CC环境变量，解决编译时找不到musl-gcc的问题 (#753)
- doc(community): add description of conventional commit standard (#754)
- feat(driver/virtio): riscv: 添加virtio-blk driver,并在riscv下能够正确挂载FAT32 (#761)
- feat(fs): add sys_dup3 (#755)
- feat(riscv): riscv下能够运行hello world用户程序 (#770)
- feat(sched): add sched_yield (#766)
- refactor(process): 调整arch_switch_to_user函数，把riscv和x86_64的共用逻辑抽取出来。 (#773)
- feat(driver/acpi_pm): Implement ACPI PM Timer (#772)
- chore: 适配dadk 0.1.11 (#777)
- fix(libs/lib_ui): fix the display errors when system initialize (#779)
- fix(riscv/process): 把riscv的调度时钟节拍率与HZ同步，并且修复切换到用户态的时候忘了在内核态关中断的bug (#780)
- fix: (riscv/timer): 修复riscv下没有更新墙上时钟以及没有处理软中断的bug (#783)
- feat(mm): add slab usage calculation (#768)
- feat(bitmap): Add bit and for AllocBitMap (#793)
- fix(mm): 修复vma映射标志错误 (#801)
- feat:(riscv/intr) 实现riscv plic驱动,能处理外部中断 (#799)
- doc(sched):调度子系统文档即cfs文档 (#807)
- fix(net): Fix TCP Unresponsiveness and Inability to Close Connections (#791)
- fix: disable mm debug log to prevent system lockup due to thingbuf issue (#808)
- feat(driver/pci): add pci bus into sysfs (#792)
- doc: Add Gentoo Linux In build_system.md (#810)

## 更新内容-用户环境

### 新特性/新应用移植

- 添加core utils到系统 (#624)
- 移植dns查询工具dog的--tcp功能 (#652)


## 更新内容-CI

- 引入triagebot对issue和PR进行分类
- 添加clippy检测的自动化工作流 (#649)
- ci: import issue checker (#750)
- ci: update the match regex of issue checker (#784)
- ci: 添加支持gentoo系统的一键安装脚本 (#809)

## 源码、发布版镜像下载

&emsp;&emsp;您可以通过以下方式获得源代码:

### 通过Git获取

- 您可以访问DragonOS的仓库获取源代码：[https://github.com/DragonOS-Community/DragonOS](https://github.com/DragonOS-Community/DragonOS)
- 您可以访问[https://github.com/DragonOS-Community/DragonOS/releases](https://github.com/DragonOS-Community/DragonOS/releases)下载发布版的代码。

### 通过DragonOS软件镜像站获取

&emsp;&emsp;为解决国内访问GitHub慢、不稳定的问题，同时为了方便开发者们下载DragonOS的每个版本的代码，我们特意搭建了镜像站，您可以通过以下地址访问镜像站：

&emsp;&emsp;您可以通过镜像站获取到DragonOS的代码压缩包，以及编译好的可运行的磁盘镜像。

- [https://mirrors.DragonOS.org.cn](https://mirrors.DragonOS.org.cn)
- [https://git.mirrors.DragonOS.org.cn](https://git.mirrors.DragonOS.org.cn)

## 开放源代码声明

:::{note}
为促进DragonOS项目的健康发展，DragonOS以GPLv2开源协议进行发布。所有能获得到DragonOS源代码以及相应的软件制品（包括但不限于二进制副本、文档）的人，都能享有我们通过GPLv2协议授予您的权利，同时您也需要遵守协议中规定的义务。

这是一个相当严格的，保护开源软件健康发展，不被侵占的协议。

对于大部分的善意的人们而言，您不会违反我们的开源协议。

我们鼓励DragonOS的自由传播、推广，但是请确保所有行为没有侵犯他人的合法权益，也没有违反GPLv2协议。

请特别注意，对于违反开源协议的，尤其是**商业闭源使用以及任何剽窃、学术不端行为将会受到严肃的追责**。（这是最容易违反我们的开源协议的场景）。

并且，请注意，按照GPLv2协议的要求，基于DragonOS修改或二次开发的软件，必须同样采用GPLv2协议开源，并标明其基于DragonOS进行了修改。亦需保证这些修改版本的用户能方便的获取到DragonOS的原始版本。

您必须使得DragonOS的开发者们，能够以同样的方式，从公开渠道获取到您二次开发的版本的源代码，否则您将违反GPLv2协议。

关于协议详细内容，还敬请您请阅读项目根目录下的**LICENSE**文件。请注意，按照GPLv2协议的要求，**只有英文原版才具有法律效力**。任何翻译版本都仅供参考。
:::

### 开源软件使用情况

&emsp;&emsp;DragonOS在开发的过程中，参考了Linux社区的一些设计，或者引入了他们的部分思想，亦或是受到了他们的启发。我们在这里对Linux社区以及Linux社区的贡献者们致以最衷心的感谢！

## 当前版本的所有提交记录

```text
commit 9a0802fd2ddda39e96342997abbfc30bf65f1f0e
Author: donjuanplatinum <113148619+donjuanplatinum@users.noreply.github.com>
Date:   Mon May 13 15:36:23 2024 +0800

    doc: Add Gentoo Linux In build_system.md (#810)
    
    * 增加安装文档中的Gentoo Linux提示

commit 1f4877a4c512eb5ad232436128a0c52287b39aaa
Author: 曾俊 <110876916+ZZJJWarth@users.noreply.github.com>
Date:   Mon May 13 15:27:08 2024 +0800

    feat(driver/pci): add pci bus into sysfs (#792)
    
    把pci设备加入sysfs

commit 1df85daf8f1b4426fe09d489d815997cdf989a87
Author: donjuanplatinum <113148619+donjuanplatinum@users.noreply.github.com>
Date:   Sun May 12 22:58:59 2024 +0800

    添加支持gentoo系统的一键安装脚本 (#809)

commit 352ee04918f4585ad4f8a896ca6e18b1ef7d7934
Author: LoGin <longjin@DragonOS.org>
Date:   Sat May 11 18:02:13 2024 +0800

    fix: disable mm debug log to prevent system lockup due to thingbuf issue (#808)

commit 37cef00bb404c9cc01509c12df57548029967dc2
Author: Samuel Dai <samuka007@qq.com>
Date:   Sat May 11 17:17:43 2024 +0800

    fix(net): Fix TCP Unresponsiveness and Inability to Close Connections (#791)
    
    * fix(net): Improve stability. 为RawSocket与UdpSocket实现close时调用close方法，符合smoltcp的行为。为SocketInode实现drop，保证程序任何情况下退出时都能正确close对应socket, 释放被占用的端口。
    
    * fix(net): Correct socket close behavior.

commit b941261d943fac38d3154495e19ec99c90ebea8d
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Tue May 7 22:01:01 2024 +0800

    docs(sched):调度子系统文档即cfs文档 (#807)
    
    * 调度子系统文档以及cfs文档

commit 0102d69fdd231e472d7bb3d609a41ae56a3799ee
Author: LoGin <longjin@DragonOS.org>
Date:   Wed May 1 21:11:32 2024 +0800

    feat:(riscv/intr) 实现riscv plic驱动,能处理外部中断 (#799)
    
    * feat:(riscv/intr) 实现riscv plic驱动,能处理外部中断
    
    - 实现riscv plic驱动,能处理外部中断
    - 能收到virtio-blk的中断
    - 实现fasteoi interrupt handler

commit 17dc558977663433bd0181aa73ad131a1a265c1f
Author: MemoryShore <105195940+MemoryShore@users.noreply.github.com>
Date:   Wed May 1 21:09:51 2024 +0800

    修复vma映射标志错误 (#801)

commit 7db6e06354328ea7c6164723f504e8ba58d0c4a4
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Apr 30 18:45:01 2024 +0800

    feat(bitmap): Add bit and for AllocBitMap (#793)

commit 7401bec5e3c42015399a46e29c370abe7c7388b5
Author: laokengwt <143977175+laokengwt@users.noreply.github.com>
Date:   Mon Apr 29 23:03:33 2024 +0800

    feat(mm): add slab usage calculation (#768)
    
    * Add slab free space calculation and add it to freeram of sysinfo

commit bde4a334c1ff2ae27989de4f6f8b45f5154b684d
Author: 曾俊 <110876916+ZZJJWarth@users.noreply.github.com>
Date:   Mon Apr 29 18:55:17 2024 +0800

    修复了未初始化时ui显示模块内存越界的问题，优化了代码结构 (#789)

commit 0722a06a09ed52cb980a6147123453f86d0ea267
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Apr 28 19:40:09 2024 +0800

    fix: (riscv/timer): 修复riscv下没有更新墙上时钟以及没有处理软中断的bug (#783)

commit ab53b2eb75fe79167aa100e655b3589ee306f793
Author: Chiichen <chiichen@qq.com>
Date:   Sun Apr 28 19:37:58 2024 +0800

    ci: update the match regex of issue checker (#784)
    
    The previous regex can not successfully match the pattern like `feat(driver/pci)`, which has a slash in the scope

commit 942cf26b48c8b024a6fa7867bb0c8ae39bb1ae09
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Apr 28 16:49:40 2024 +0800

    fix(riscv/process): 把riscv的调度时钟节拍率与HZ同步，并且修复切换到用户态的时候忘了在内核态关中断的bug (#780)

commit 13b057cc0fda0cf9630c98d246937b85fa01a7c9
Author: 曾俊 <110876916+ZZJJWarth@users.noreply.github.com>
Date:   Sun Apr 28 16:49:19 2024 +0800

    fix(libs/lib_ui): fix the display errors when system initialize (#779)
    
    * 修复了系统初启动时会花屏的bug

commit 182b778a3ca8c633b605ae7dd90a5e9f1131cc6d
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Apr 28 13:39:51 2024 +0800

    chore: 适配dadk 0.1.11 (#777)
    
    * chore: 适配dadk 0.1.11

commit dd8e74ef0d7f91a141bd217736bef4fe7dc6df3d
Author: Mingtao Huang <114841534+1037827920@users.noreply.github.com>
Date:   Sun Apr 28 13:25:12 2024 +0800

    feat(driver/acpi_pm): Implement ACPI PM Timer (#772)
    
    * feat: Implement ACPI PM Timer

commit f75cb0f8ed754d94c3b2924519b785db3321c1d9
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Apr 27 15:35:24 2024 +0800

    refactor(process): 调整arch_switch_to_user函数，把riscv和x86_64的共用逻辑抽取出来。 (#773)
    
    * refactor(process): Extract common logic for riscv and x86_64 in arch_switch_to_user to run_init_process
    
    调整arch_switch_to_user函数，把riscv和x86_64的共用逻辑抽取出来。写成run_init_process函数，并且能够尝试运行多个不同的init程序，直到某个运行成功

commit 173c4567cf4fb2276ef3f4614b69da7913fc8381
Author: zwb0x00 <163394849+zwb0x00@users.noreply.github.com>
Date:   Fri Apr 26 15:33:29 2024 +0800

    feat(sched): add sched_yield (#766)
    
    * 实现sched_yield系统调用

commit 471d65cf158c9bf741c21f5d0ab92efe7bf1c3d4
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Apr 26 11:59:47 2024 +0800

    feat(riscv): riscv下能够运行hello world用户程序 (#770)
    
    * feat(riscv): riscv下能够运行hello world用户程序

commit 40348dd8d5a008ecc9eb3aab931933e4eba0e6da
Author: zwb0x00 <163394849+zwb0x00@users.noreply.github.com>
Date:   Tue Apr 23 19:35:02 2024 +0800

    feat(fs): add sys_dup3 (#755)
    
    * feat(fs): add sys_dup3

commit 3b799d13beeb80900d728937308e47f8011835e1
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Apr 23 19:14:41 2024 +0800

    Create FUNDING.yml (#763)

commit 731bc2b32d7b37298883d7a15b6dca659b436ee4
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Apr 23 17:19:54 2024 +0800

    feat(virtio): riscv: 添加virtio-blk driver,并在riscv下能够正确挂载FAT32 (#761)

commit 0c1ef30087d10035c256fed08097f5897041979d
Author: Chiichen <chiichen@qq.com>
Date:   Tue Apr 23 00:27:05 2024 +0800

    docs(community): add description of conventional commit standard (#754)
    
    * docs(community): add description of conventional commit standard
    
    * docs: add index

commit 70c991af204167db26ec1d9494efcff010893482
Author: laokengwt <143977175+laokengwt@users.noreply.github.com>
Date:   Mon Apr 22 17:40:03 2024 +0800

    fix(dog): 添加CC环境变量，解决编译时找不到musl-gcc的问题 (#753)

commit e32effb1507773d32c216d9e77b963786e275c06
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Apr 22 15:11:47 2024 +0800

    feat(driver): 把virtio添加到sysfs (#752)

commit a17651b14b86dd70655090381db4a2f710853aa1
Author: MemoryShore <105195940+MemoryShore@users.noreply.github.com>
Date:   Mon Apr 22 15:10:47 2024 +0800

    feat(mm): 实现缺页中断处理，支持页面延迟分配和写时拷贝，以及用户栈自动拓展 (#715)
    
    * 实现缺页中断处理
    
    * 完善页表拷贝逻辑
    
    * 优化代码结构
    
    * 完善缺页异常信息
    
    * 修改大页映射逻辑
    
    * 修正大页映射错误
    
    * 添加缺页中断支持标志
    
    * 实现用户栈自动拓展功能

commit cb02d0bbc213867ac845b7e8a0fb337f723d396a
Author: Chiichen <chiichen@qq.com>
Date:   Sun Apr 21 23:23:21 2024 +0800

    ci: import issue checker (#750)
    
    * ci: supprot auto tag on pull request
    
    * ci: update issue checker config
    
    * ci: update issue checker & block merge while

commit 93c379703e3be210799953bc0686d02f97119b39
Author: sun5etop <146408999+sun5etop@users.noreply.github.com>
Date:   Sun Apr 21 13:36:44 2024 +0800

    feat(net): 实现raw socket的poll (#739)
    
    feat(net): 实现raw socket的poll

commit b502fbf0b9c575a4c04e103d0fb708c4e383ab06
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Apr 21 13:30:29 2024 +0800

    chore: Update virtio-drivers to commit 61ece509c4 and modify max_queue_size implementation (#748)

commit d770de5d53ce9b598fb0024800a347b081f92a73
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Apr 21 13:12:31 2024 +0800

    fix: 修复unified-init导致cargo check失败的问题 (#747)

commit 881ff6f95e4addc373d815d66cb912bf721c20e6
Author: yuyi2439 <68320855+yuyi2439@users.noreply.github.com>
Date:   Sun Apr 21 11:39:00 2024 +0800

    将smoltcp升级到0.11.0版本 (#740)

commit 370472f7288b568c7b80815f5b150daf4496446c
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Apr 21 11:27:36 2024 +0800

    pci: 添加pci root manager来管理pci root，并使得riscv能够正常扫描pci设备. (#745)
    
    * pci: 添加pci root manager来管理pci root.
    pci: 使得riscv能够正常扫描pci设备.
    
    * doc: 添加注释

commit 2709e017d0d216d61b2caed3c7286459de7794c7
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Apr 20 18:31:56 2024 +0800

    pci: 统一使用ecam root (#744)

commit 418ad41fd84c15ed7e132e56970150ac38fc24a9
Author: LoGin <longjin@DragonOS.org>
Date:   Wed Apr 17 10:03:22 2024 +0800

    Feat(tty): add dummy console (#735)
    
    使得riscv能暂时完成stdio_init(将来需要实现riscv的串口console)

commit 1012552dea71bf04cf1d329d570c4c9ca9b2a2f8
Author: Saga1718 <161323888+Saga1718@users.noreply.github.com>
Date:   Tue Apr 16 21:37:42 2024 +0800

    删除无用的hid代码 (#734)

commit fbd63a301c5648f906eeb802f10ac03518ba1264
Author: SMALLC <121806694+SMALLC04@users.noreply.github.com>
Date:   Tue Apr 16 21:34:36 2024 +0800

    feat: alarm系统调用实现 (#710)
    
    * alarm系统调用实现

commit d623e90231ef6a31d091c3f611c0af3a83d3343b
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Mon Apr 15 22:01:32 2024 +0800

    socket统一改用`GlobalSocketHandle`,并且修复fcntl SETFD的错误 (#730)
    
    * socket统一改用`GlobalSocketHandle`,并且修复fcntl SETFD的错误
    
    ---------
    
    Co-authored-by: longjin <longjin@DragonOS.org>

commit 7162a8358d94c7799dd2b5300192b6a794b23d79
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Apr 15 13:20:46 2024 +0800

    doc: Update build instructions for riscv64 architecture (#725)

commit 1074eb34e784aa2adfc5b9e0d89fa4b7e6ea03ef
Author: Samuel Dai <samuka007@qq.com>
Date:   Mon Apr 15 13:02:04 2024 +0800

    feat(filesystem): 引入Umount系统调用 (#719)
    
    * feat(filesystem): 引入Umount系统调用
    
    * 将所有ENOSYS误用更正
    
    * 修复了一个使同一个挂载点可以挂载2个文件系统的bug
    
    * 统一注释，增强程序稳定性，统一接口。注意：Umount时在fatfs的路径要使用大写，此受限于当前文件系统设计。

commit ceeb2e943ca7645609920ec7ad8bfceea2b13de6
Author: laokengwt <143977175+laokengwt@users.noreply.github.com>
Date:   Mon Apr 15 12:51:14 2024 +0800

    feat(mm): 添加slab内存分配器 (#683)
    
    feat(mm): 添加slab内存分配器
    ---------
    
    Co-authored-by: longjin <longjin@DragonOS.org>

commit c719ddc6312acd7976e0f6fd449a94ff9abad5a6
Author: Saga1718 <161323888+Saga1718@users.noreply.github.com>
Date:   Sun Apr 14 23:51:47 2024 +0800

    feat(net): 实现tcp backlog功能 (#714)
    
    * feat:实现tcp的backlog功能

commit 9621ab16ef27bc94f223e6254fafb9bb07d46d57
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Apr 14 20:39:20 2024 +0800

    让riscv64能正常切换进程，并运行完所有的initcall (#721)

commit 9fab312ea9921618629924ab15c28c2d255b21c6
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Apr 12 15:27:44 2024 +0800

    Update DragonOS description and introduction (#717)

commit f049d1af01da7b92f312245ed411b22475b76065
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Apr 12 14:46:47 2024 +0800

    初始化riscv-sbi-timer (#716)

commit 3959e94df38073fdb80b199777015f95611ba05f
Author: 曾俊 <110876916+ZZJJWarth@users.noreply.github.com>
Date:   Wed Apr 10 19:00:32 2024 +0800

    bugfix: 修复smp启动的时候，损坏0号核心的idle进程的内核栈的问题 (#711)
    
    ---------
    
    Co-authored-by: longjin <longjin@DragonOS.org>
    Co-authored-by: heyicong <heyicong@dragonos.org>

commit 9365e8017b39582eca620ba93c64f1b3c87c73d4
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Wed Apr 10 19:00:12 2024 +0800

    完善pty，目前pty能够支持ssh (#708)

commit 4b0170bd6bb374d0e9699a0076cc23b976ad6db7
Author: Chiichen <chiichen@qq.com>
Date:   Wed Apr 10 18:58:54 2024 +0800

    chore(tools): add bootstrap support for Centos/RHEL8/fedora (#713)
    
    Co-authored-by: kejianchi <kejianchi@tencent.com>

commit 15b94df01adc7e8931961b9b9a89db4e7c014b64
Author: Jomo <xuzihao@dragonos.org>
Date:   Wed Apr 10 10:58:07 2024 +0800

    add xuzihao (#712)

commit 6fc066ac11d2f9a3ac629d57487a6144fda1ac63
Author: Jomo <2512364506@qq.com>
Date:   Sun Apr 7 14:04:19 2024 +0800

    实现SystemV共享内存 (#690)
    
    * 实现SystemV共享内存
    
    * 测试shm
    
    * 添加测试程序
    
    * 完善细节
    
    * 修正shm的时间数据错误的问题
    
    * fix: devfs的metadata权限为0x777的错误
    
    ---------
    
    Co-authored-by: longjin <longjin@DragonOS.org>

commit eb49bb993a39964f92494ec3effafed3fb9adfd8
Author: 曾俊 <110876916+ZZJJWarth@users.noreply.github.com>
Date:   Sun Apr 7 14:03:51 2024 +0800

    BlockCache-read cache支持 (#521)
    
    支持block cache的读缓存

commit 06560afa2aa4db352526f4be8b6262719b8b3eac
Author: hmt <114841534+1037827920@users.noreply.github.com>
Date:   Sat Apr 6 22:26:34 2024 +0800

    Patch feat robust futex (#682)
    
    * feat: 实现robust lock机制
    
    * 前面更改vscode,修改回来
    
    * 修改dadk的路径
    
    * 提交.gitnore和.cargo，删除LICENSE，修改README
    
    * 修改一个warn
    
    * 删除.rustc_info.json
    
    * 删除target文件夹
    
    * 恢复DragonOS的LICENSE，删除Cargo.lock
    
    * 将校验用户空间地址的代码写入函数内；将部分match分支用ok_or代替
    
    * 修改wakeup函数获取running queue时unwrap一个None值发生panic
    
    * 测试程序使用syscalls库进行系统调用

commit 23ef2b33d1e3cfd2506eb7449a33df4ec42f11d3
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Apr 6 22:13:26 2024 +0800

    riscv: 把内核编译target改为riscv64gc & 获取time csr的频率 & 修正浮点保存与恢复的汇编的问题 (#699)
    
    * 1. 把内核编译target改为riscv64gc
    2. fix: 修正浮点保存与恢复的汇编的问题
    
    * riscv: 获取time csr的频率

commit f0c87a897fe813b7f06bf5a9e93c43ad9519dafd
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Fri Apr 5 17:54:48 2024 +0800

    重写调度模块 (#679)
    
    ## PR：重写调度模块
    ---
    ### 完成的部分
    - 实现cfs调度策略
    - 搭建框架，后续功能可以迭代开发
    - 目前能跑，未测试性能
    
    ### 需要后续接力的部分
    - 实现组内调度（task_group）
    - 实现跨核负载均衡（pelt算法）
    - 接入sysfs，实现参数动态调节（sched_stat等）
    - nice值以及priority等参数的设置及调优

commit e8eab1ac824e1b1e638e50debb8326dfed4f05e5
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Apr 5 16:37:08 2024 +0800

    riscv: copy-thread (#696)

commit dfe53cf087ef4c7b6db63d992906b062dc63e93f
Author: GnoCiYeH <heyicong@dragonos.org>
Date:   Fri Apr 5 00:21:55 2024 +0800

    实现pty，附带测试程序 (#685)
    
    * 实现pty，附带测试程序
    
    * fmt ** clippy
    
    * 将file层的锁粒度缩小，从而不使用no_preempt。更改pipe在sleep部分的bug
    
    * 修复拼写错误

commit b8ed38251dc255b0c525801b5dbf37d3b0d0d61e
Author: Donkey Kane <109840258+xiaolin2004@users.noreply.github.com>
Date:   Fri Apr 5 00:06:26 2024 +0800

    修复jiffy时钟过快问题，启用gettimeofday测试，修改mount测试 (#680)
    
    1. 把clock tick rate与hpet频率关联起来
    2. 修复墙上时间同步错误的问题
    3. 启用时间watch dog.
    4. 修复时间流逝速度异常
    
    ---------
    
    Co-authored-by: longjin <longjin@DragonOS.org>

commit 9430523b465b19db4dd476e9fd3038bdc2aa0c8d
Author: yuyi2439 <68320855+yuyi2439@users.noreply.github.com>
Date:   Thu Apr 4 12:41:19 2024 +0800

    使nproc可以正确获取到cpu核心数 (#689)

commit 9b96c5b547c337502db7ec820312f119f95eece1
Author: LoGin <longjin@DragonOS.org>
Date:   Sun Mar 31 22:53:01 2024 +0800

    riscv64: switch process (#678)
    
    * riscv64: switch process
    
    * fixname

commit 7d580ef99d2a52250b384afd49c7f87ab66a8c84
Author: Val213 <112376067+val213@users.noreply.github.com>
Date:   Sun Mar 31 18:01:32 2024 +0800

    修复get_ramdom的长度错误问题() (#677)

commit 56cc4dbe27e132aac5c61b8bd4f4ec9a223b49ee
Author: Jomo <2512364506@qq.com>
Date:   Sun Mar 31 16:33:49 2024 +0800

    实现页面反向映射 (#670)
    
    * 实现页面反向映射
    
    * 完善PAGE_MANAGER初始化时机 && 封装lock函数 && 删掉过时注释

commit 924d64de8def99488f57dc618de763f7aca4a68b
Author: BrahmaMantra <140599389+BrahmaMantra@users.noreply.github.com>
Date:   Sun Mar 31 15:19:12 2024 +0800

    修复了ramfs中move_to未更新parent字段的bug (#673)
    
    修复了ramfs中move_to未更新parent字段的bug
    
    ---------
    
    Co-authored-by: Samuel Dai <samuka007@qq.com>

commit 9d9a09841ce2d650a41fed776916c0a11d52f92e
Author: sun5etop <146408999+sun5etop@users.noreply.github.com>
Date:   Sun Mar 31 15:11:10 2024 +0800

    修复udp bind的时候，对port0处理不正确的问题(#676)

commit da152319797436368304cbc3f85a3b9ec049134b
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Mar 28 00:28:13 2024 +0800

    实现了rtc的抽象，并且把x86的cmos rtc接入到设备驱动模型 (#674)
    
    * 实现了rtc的抽象，并且把x86的cmos rtc接入到设备驱动模型。

commit 597ecc08c2444dcc8f527eb021932718b69c9cc5
Author: TTaq <103996388+TTaq@users.noreply.github.com>
Date:   Tue Mar 26 18:28:26 2024 +0800

    新加结构体POSIXSTATFS与SuperBlock用于处理statfs系统调用 (#667)
    
    * 新加结构体POSIXSTATFS与SuperBlock用于处理statfs系统调用

commit 0cb807346cb3c47924538585087d9fc846cf5e6f
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Mar 26 18:26:02 2024 +0800

    修复tty设备显示在/sys目录下的bug (#668)

commit 2755467c790d6510fa97cbf052ce8e91ad1372c6
Author: 曾俊 <110876916+ZZJJWarth@users.noreply.github.com>
Date:   Mon Mar 25 16:39:36 2024 +0800

    支持绘制24位深和16位深显示缓冲区 (#640)
    
    * 修复了初始化时显示，边界条件的一个bug
    
    * 解决了内存未初始前字体显示的兼容性问题
    * 支持绘制24位深和16位深显示缓冲区

commit 4256da7fb6ad25a3caab6f656607aaf047cb6446
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Mar 25 15:47:05 2024 +0800

    把Device trait的set_class改为设置Weak指针，以避免循环引用问题。 (#666)

commit 5c20e05a2eb82da6dd73104fcf51d538500c2856
Author: LoGin <longjin@DragonOS.org>
Date:   Mon Mar 25 13:59:00 2024 +0800

    修改bug report模版label (#665)

commit 7c958c9ef0cd25eb15abb21d0d3420aac1c67c88
Author: Val213 <112376067+val213@users.noreply.github.com>
Date:   Mon Mar 25 13:04:53 2024 +0800

    移植dns查询工具dog的--tcp功能 (#652)
    
    * add dog, modify user/Makefile and user.sysconfig
    
    * add dog, modify user/Makefile and user.sysconfig
    
    * fix tty unicode
    
    * 修正无法正确编译dog的问题
    
    ---------
    
    Co-authored-by: val213 <val213666@gmail.com>
    Co-authored-by: GnoCiYeH <heyicong@dragonos.org>
    Co-authored-by: longjin <longjin@DragonOS.org>

commit 911132c4b8ea0e9c49a4e84b9fa1db114102acbb
Author: Donkey Kane <109840258+xiaolin2004@users.noreply.github.com>
Date:   Mon Mar 25 13:04:32 2024 +0800

    修复clock_gettime返回类型错误，修复小时间间隔duration返回0问题 (#664)
    
    * 修复clock_gettime返回类型错误，修正wtm初始化逻辑
    
    * 修复duration在小时间间隔下为0的问题
    
    * 临时修复时间流逝速度异常，在test-mount中加入运行时间检测

commit 401699735b5ec29768c3c0c47df6c529991f108f
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Mar 23 16:25:56 2024 +0800

    riscv: 进程管理初始化 (#654)

commit 6046f77591cf23dc9cc53b68b25c0d74f94fa493
Author: 裕依 <68320855+yuyi2439@users.noreply.github.com>
Date:   Sat Mar 23 15:56:49 2024 +0800

    Patch socketpair (#576)
    
    * 将sockets分成inet和unix域
    - 添加File端点
    - 添加SocketPair trait并将Socket trait中的pair相关方法移动
    - 添加对SockAddrUn的处理
    
    * 精简SocketHandleItem
    
    * 重构socketpair相关逻辑
    - 将File端点换成Inode端点
    - 尝试使用SocketInode进行socketpair(未成功)
    
    
    * 将SocketPair trait合并到Socket trait中，去除downcast

commit 3660256a9ee94abc30b5b22508cbd48c44c86089
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Mar 23 11:51:30 2024 +0800

    只对x86_64进行clippy check (#651)

commit 4e4c8c41e90989c1f732995511e0f9a77a33f650
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Mar 22 23:56:30 2024 +0800

    添加clippy检测的自动化工作流 (#649)
    
    * 添加clippy检测的自动化工作流
    
    * fmt
    
    * 1

commit b5b571e02693d91eb6918d3b7561e088c3e7ee81
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Mar 22 23:26:39 2024 +0800

    修复内核的clippy检查报错 (#637)
    
    修复内核的clippy检查报错
    ---------
    
    Co-authored-by: Samuel Dai <947309196@qq.com>
    Co-authored-by: Donkey Kane <109840258+xiaolin2004@users.noreply.github.com>
    Co-authored-by: themildwind <107623059+themildwind@users.noreply.github.com>
    Co-authored-by: GnoCiYeH <heyicong@dragonos.org>
    Co-authored-by: MemoryShore <105195940+MemoryShore@users.noreply.github.com>
    Co-authored-by: 曾俊 <110876916+ZZJJWarth@users.noreply.github.com>
    Co-authored-by: sun5etop <146408999+sun5etop@users.noreply.github.com>
    Co-authored-by: hmt <114841534+1037827920@users.noreply.github.com>
    Co-authored-by: laokengwt <143977175+laokengwt@users.noreply.github.com>
    Co-authored-by: TTaq <103996388+TTaq@users.noreply.github.com>
    Co-authored-by: Jomo <2512364506@qq.com>
    Co-authored-by: Samuel Dai <samuka007@qq.com>
    Co-authored-by: sspphh <112558065+sspphh@users.noreply.github.com>

commit 4695947e1b601c83641676485571d42c692a2bbd
Author: Chenzx <109664121+schulice@users.noreply.github.com>
Date:   Fri Mar 22 18:27:07 2024 +0800

    实现SYS_LINK和SYS_LINKAT (#611)
    
    * 实现do_linkat及SYS_LINK和SYS_LINKAT
    
    * 未在riscv上测试，添加target_arch
    
    * 将c字符串检查移动到vfs/syscall.rs，修改do_linkat()逻辑
    
    * 修改部分注释

commit 70f159a3988eab656ea1d2b204fde87948526ecf
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Mar 21 21:35:39 2024 +0800

    riscv64: 添加flush tlb的ipi (#636)
    
    * riscv64: 添加flush tlb的ipi
    
    * update triagebot

commit b4eb05a17f0f65668f69e7979660874ef8e01a2e
Author: TTaq <103996388+TTaq@users.noreply.github.com>
Date:   Thu Mar 21 19:59:10 2024 +0800

    Statx (#632)
    
    
    * 实现statx及测试的应用程序

commit 8cb2e9b344230227fe5f3ab3ebeb2522f1c5e289
Author: LoGin <longjin@DragonOS.org>
Date:   Thu Mar 21 19:19:32 2024 +0800

    重写SMP模块 (#633)
    
    * 修复cpumask的迭代器的错误。
    
    * 能进系统（AP核心还没有初始化自身）
    
    * 初始化ap core
    
    * 修改percpu
    
    * 删除无用的cpu.c
    
    * riscv64编译通过

commit 1d37ca6d172e01a98fa6785d2b3e07fb8202a4a9
Author: Donkey Kane <109840258+xiaolin2004@users.noreply.github.com>
Date:   Wed Mar 20 15:31:20 2024 +0800

    添加mount系统调用 (#561)
    
    * Modify dadk config to switch NovaShell revision
    
    * finish primary build of mount(2), usable now
    
    * 使用read_from_cstr函数优化代码可读性 , 针对文件系统新增错误EUNSUPFS
    
    * small changes
    
    * 添加系统调用文档
    
    * cargo fmt
    
    * Revert "small changes"
    
    This reverts commit e1991314ce687faa2d652479e8ef64f5bea25fa1.
    
    * 修复用户程序参数传入错误
    
    * Revert "small changes"
    
    This reverts commit e1991314ce687faa2d652479e8ef64f5bea25fa1.
    
    * 解决合并冲突，最终提交
    
    * 将dadk_config切换为相对路径以修复依赖问题
    
    * Update settings.json
    
    * Delete user/apps/test-mount/LICENSE
    
    * 换用更好的c字符串读取函数，优化系统调用函数注释，修复错误处理bug，删除无用文件，修改测试程序readme
    
    * 修改用户程序readme
    
    * 代码格式化，初级版本
    
    * 初级版本，未实现文件系统管理器，未支持设备挂载
    
    * 为文件系统添加name方法，返回文件系统名字字符串，为挂载查询服务
    
    * mount系统调用：添加统一文件系统初始化管理器
    
    * null
    
    * 解除冲突
    
    * 删除无用kdebug

commit 1cd9bb43f0256aecf19a090dd71e4ac2b86a5e29
Author: LoGin <longjin@DragonOS.org>
Date:   Tue Mar 19 21:31:02 2024 +0800

    添加core utils到系统 (#624)

commit 8c6f21840f820a161d4386000aea1d79e3bc8d13
Author: sspphh <112558065+sspphh@users.noreply.github.com>
Date:   Tue Mar 19 17:01:20 2024 +0800

    实现uname系统调用 (#614)
    
    * 实现uname系统调用
    
    Co-authored-by: longjin <longjin@DragonOS.org>

commit 82df0a13109e400602ddaec049d04ae230eb485b
Author: hmt <114841534+1037827920@users.noreply.github.com>
Date:   Tue Mar 19 16:45:44 2024 +0800

    fix: mkdir输出错误信息; feat: 实现get_pathname (#615)
    
    * fix: mkdir输出错误信息; feat: 实现get_pathname
    
    * fix: 将处理路径的操作放入vfs而不是在syscall/mod.rs中
    
    * 调整入参类型
    
    ---------
    
    Co-authored-by: longjin <longjin@DragonOS.org>

commit 9e481b3bfe303e0b104694da9750ae978dfeecae
Author: TTaq <103996388+TTaq@users.noreply.github.com>
Date:   Mon Mar 18 14:47:59 2024 +0800

    实现了sys_rename (#578)
    
    * 基本实现了rename的系统调用
    
    * 实现相对路径的mv
    
    * confilct resolve
    
    * make fmt
    
    * 更改校验位置，
     增加了SYS_RENAMEAT与SYS_RENAMEAT2两个系统调用，其实现与SYS_RENAME基本一致
    
    * 删除了fat中的link
    
    * fix
    
    * 修改注释格式，删除管道文件判断
    
    * 1

commit c3c73444516b7b47b6327cd66f5453133f47998d
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Mar 16 22:28:59 2024 +0800

    更新triagebot配置 (#616)
    
    * 更新triagebot配置

commit 4fd916113e576a1c5d8ca9faae7a9d6b25afb9ae
Author: LoGin <longjin@DragonOS.org>
Date:   Sat Mar 16 18:09:32 2024 +0800

    triagebot-add-shortcut (#612)

commit fbc174499f5200924c732263e461c79b4a936c5b
Author: LoGin <longjin@DragonOS.org>
Date:   Fri Mar 15 20:06:24 2024 +0800

    添加triagebot文件 (#608)
    
    * 添加triagebot文件

```