# V0.1.0

:::{note}
本文作者：龙进 <longjin@RinGoTek.cn>

2022年11月6日
:::

## 前言

&emsp;&emsp;DragonOS从2022年1月15日开始开发，到如今已经经历了将近300天。在这么多个日夜里，已经数不清到底花了多少时间在DragonOS的开发之中，
我基本上把所有的空闲时间都给了DragonOS，保守估计总工时已经在1000小时以上。能够发布第一个版本，我感到十分有成就感。

&emsp;&emsp;在2022年7月以来，陆陆续续的，有来自6所高校或企业的小伙伴/大佬加入了DragonOS的开发。我当时非常的欣喜，我想，也许在大家的一同努力下，我们能创造出
一个真正具有实用性的操作系统呢！我们累计召开了14次交流讨论会。我相信，在大家的共同努力下，将来，我们一定能创造出真正独立自主的、开放的、面向服务器领域应用的开源操作系统，并在生产环境中得到应用。

&emsp;&emsp;尽管DragonOS目前只是一个玩具水平的操作系统，只是“比本科生毕业设计难度略高的”操作系统。但是，请不要小看它，它的内在的架构设计，瞄准了Linux5.18及以后的发行版，
虽尚未能达到Linux的水平，但我们正努力追赶。得益于Linux的相关资料，DragonOS在架构设计之时，学习了Linux的很多设计思想，相关组件都尽量考虑了可扩展性与可移植性。

&emsp;&emsp;千里之行，始于足下。DragonOS V0.1.0版本的发布，是一个全新的开始。**希望在未来的十年里，我们能与众多伙伴们一同努力，在2032年，将DragonOS建设成为具有实用意义的，能够在服务器领域取得广泛应用的开源操作系统！**

&emsp;&emsp;**百舸争流，奋楫者先；中流击水，勇进者胜。** 我相信，在接下来的时间里，在社区开发者们的不断努力下，我们的目标，终将成为现实！


## 特别鸣谢

&emsp;&emsp;在DragonOS V0.1.0版本的发布之际，我想对我的老师、前辈以及学校表示衷心的感谢！

- **佛山市南海区大沥镇中心小学 姚志城老师**： 您是带领我接触计算机，学会编程的领路人。十年前，与您交谈时，您说过：“我们国家目前还没有自主的、成熟的操作系统”。这句话，为我的梦想埋下了种子。您培养了我对计算机的热爱，因此我选择了软件工程这个专业。感谢当年您的教导，师恩难忘！

- **佛山市南海区石门实验学校**： 在石实就读的三年里，非常感谢石实的“扬长教育”理念，在老师们的培养下，让我充分发挥了自己的个性和特长，也取得了不错的成绩。在石实的三年里，我学会了C++、Java以及简单的算法，也自己开发了几个安卓app，积累了将近6千行的代码量。

- **佛山市南海区石门中学**：“任重道远，毋忘奋斗”是石中的校训，我想，这句校训，也应当成为我们每个新时代青年人的座右铭。在石门中学的三年，家国情怀教育对我产生了很大的影响。我想，我们作为新时代的青年，更应当肩负起时代的重任，奋勇拼搏，为祖国的发展，为民族的自强，为人类的未来，努力奋斗！

- **华南理工大学**：“博学慎思，明辨笃行”，在华工，我得到了进一步的学习与发展。开拓了自己的视野，学会了跟很多人打交道。并且，在软件学院，我遇到了一群认真负责的老师。非常感谢学院对我的支持，支持我们成立项目组。我相信，在学院的支持下，能让DragonOS取得更好的发展，走的更远！

- **华南理工大学软件学院 王国华老师**：王老师是我《操作系统》课程的老师，在她的指导下，我对操作系统的原理有了更深的理解，并参加了“泛珠三角+大学生计算机作品赛“，在2022年6月的广东省选拔赛中，DragonOS取得了一等奖、最佳创新奖的好成绩。

- **华南理工大学软件学院 汤峰老师**： 汤老师是我们在校内的项目组的指导老师。在她的悉心指导下，我们将不断前行，保持我们前进的方向，持续构建开源社区。我由衷地感谢汤老师的指导！

- **[Yaotian Feng](https://github.com/Codetector1374)**： 在Bilibili上认识了这位非常厉害的老哥，解答了我的很多问题，很多次在我毫无头绪的debug了几天之后，几句话点醒了我，让我找到解决问题的路径。并且，他也跟我分享了容易踩坑的地方，让我在将要踩坑的时候能够有个心理预期，不至于那么难受哈哈哈哈。

## 贡献者名单

DragonOS V0.1.0版本的发布，离不开以下小伙伴们的共同努力：

- 龙进 <longjin@RinGoTek.cn>
- zzy666-hw <zzy666@mail.ustc.edu.cn>
- 关锦权 <guanjinquan@DragonOS.org>
- 周于喆 <zhouyuzhe@DragonOS.org>
- kkkkkong <kongweichao@DragonOS.org>
- houmkh <jiaying.hou@qq.com>
- wang904 <1234366@qq.com>
- Liric Mechan <i@liric.cn>
- Mustang <handsomepd@qq.com>
- Eugene <caima12138@foxmail.com>
- kun <1582068144@qq.com>
- zhujikuan <1335289286@qq.com>
- Alloc Alice <1548742234@qq.com>

## 赞助者名单

感谢以下同学的赞赏，我们将不断努力！

- TerryLeeSCUT 
- 悟
- slientbard

## 内核

### 遵循的一些标准规范

- 启动引导：Multiboot2
- 系统接口：posix 2008

### 硬件架构

- 目前支持在x86-64架构的处理器上运行
### Bootloader

- 使用Grub 2.06作为bootloader

### 内存管理

- 实现了基于bitmap的页分配器
- 实现了slab分配器，用来分配小块的、具有对齐要求的内存
- 抽象出VMA（虚拟内存区域）
- 实现VMA反向映射机制
- 实现MMIO地址空间自动映射机制

### 多核

- 支持多核引导。也就是说，在DragonOS启动后，将会启动AP处理器。但是，为了简化其他内核模块的实现，目前AP处理器上，暂时没有任务在运行。
- 粗略实现了IPI（处理器核间通信）框架

### 进程管理

- 支持进程的创建、回收
- 内核线程
- kthread机制
- 用户态、内核态进程/线程的fork/vfork（注意，用户态的fork和内核态的有一定的区别，内核态的fork更复杂）
- exec 让进程去执行一个新的可执行文件
- 进程的定时睡眠（sleep)（支持spin/rdtsc高精度睡眠、支持上下文切换方式的睡眠）

### 同步原语

- spinlock 自旋锁
- mutex 互斥量
- atomic 原子变量
- wait_queue 等待队列
- semaphore 信号量

### 调度相关

- CFS调度器
- 单核调度（暂时不支持多核负载均衡）
- completion “完成”机制，让一个进程能等待某个任务的完成。

### IPC进程间通信

- 匿名管道

### 文件系统

- VFS虚拟文件系统的基本功能
- FAT32文件系统（尚不支持删除文件夹）
- devfs设备文件系统。目前只将键盘文件注册到其中。
- rootfs根文件系统，在真实的磁盘文件系统被挂载前，为其他的伪文件系统提供支持。
- 挂载点抽象。目前实现了文件系统的挂载，使用类似于栈的方式管理所有的挂载点。（将来需要优化这部分）

### 异常及中断处理

- 处理器异常的捕获
- 对APIC的支持
- softirq软中断机制
- 能够对内核栈进行traceback

### 内核数据结构

- 普通的二叉树
- kfifo先进先出缓冲区
- 循环链表
- IDR 映射数据结构
- IDA ID分配数据组件

### 屏幕显示

- VESA VBE显示芯片驱动
- 实现了屏幕管理器，支持多个显示框架注册到屏幕管理器中。
- 实现了TextUI文本界面框架，能够渲染文本到屏幕上。并且预留了上下滚动翻页、多显示窗口的支持。
- printk

### 内核实用库

- 字符串操作库
- ELF可执行文件支持组件
- 基础数学库
- CRC函数库

### 软件移植

- 移植了LZ4压缩库（V1.9.3），为将来实现页面压缩机制打下基础。

### 内核测试

- ktest单元测试框架
- 支持使用串口（COM1）输出屏幕内容到文件之中。

### 驱动程序支持

- IDE硬盘
- AHCI硬盘（SATA Native)
- ACPI 高级电源配置模块
- PCI总线驱动
- XHCI主机控制器驱动（usb3.0)
- ps/2键盘
- ps/2鼠标
- HPET高精度定时器
- RTC时钟
- local APIC定时器
- UART串口（支持RS-232)
- VBE显示
- 虚拟tty设备

### 系统调用

DragonOS目前一共有22个有效的系统调用。

- SYS_PUT_STRING 往屏幕上打印字符
- SYS_OPEN 打开文件
- SYS_CLOSE 关闭文件
- SYS_READ 读取文件
- SYS_WRITE 写入文件
- SYS_LSEEK 调整文件指针
- SYS_FORK fork系统调用
- SYS_VFORK vfork系统调用
- SYS_BRK 调整堆大小为指定值
- SYS_SBRK 调整堆大小为相对值
- SYS_REBOOT 重启 （将来sysfs完善后，将删除这个系统调用，请勿过度依赖这个系统调用）
- SYS_CHDIR 切换进程的工作目录
- SYS_GET_DENTS 获取目录中的目录项的元数据
- SYS_EXECVE 让当前进程执行新的程序文件
- SYS_WAIT4 等待进程退出
- SYS_EXIT 退出当前进程
- SYS_MKDIR 创建文件夹
- SYS_NANOSLEEP 纳秒级睡眠（最长1秒）在小于500ns时，能够进行高精度睡眠
- SYS_CLOCK 获取当前cpu时间
- SYS_PIPE 创建管道
- SYS_MSTAT 获取系统当前的内存状态信息
- SYS_UNLINK_AT 删除文件夹或删除文件链接

### Rust支持

- 实现了一个简单的rust语言的hello world，计划在接下来的版本中，逐步转向使用rust进行开发。

## 用户环境

### LibC

&emsp;&emsp;LibC是应用程序与操作系统交互的纽带。DragonOS的LibC实现了一些简单的功能。

- malloc堆内存分配器
- 基础数学库
- 简单的几个与文件相关的函数
- pipe
- fork/vfork
- clock
- sleep
- printf

### Shell命令行程序

- 基于简单的字符串匹配的解析（不是通过编译课程学的的那一套东西做的，因此比较简单，粗暴）
- 支持的命令：ls,cd,mkdir,exec,about,rmdir,rm,cat,touch,reboot

### 用户态驱动程序

- 用户态键盘驱动程序


## 源码、发布版镜像下载

&emsp;&emsp;您可以通过以下方式获得源代码:

### 通过Git获取

- 您可以访问[https://github.com/fslongjin/DragonOS/releases](https://github.com/fslongjin/DragonOS/releases)下载发布版的代码，以及编译好的，可运行的磁盘镜像。
- 我们在gitee上也有镜像仓库可供下载：[https://gitee.com/DragonOS/DragonOS](https://gitee.com/DragonOS/DragonOS)

### 通过DragonOS软件镜像站获取

&emsp;&emsp;为解决国内访问GitHub慢、不稳定的问题，同时为了方便开发者们下载DragonOS的每个版本的代码，我们特意搭建了镜像站，您可以通过以下地址访问镜像站：

&emsp;&emsp;您可以通过镜像站获取到DragonOS的代码压缩包，以及编译好的可运行的磁盘镜像。

- [https://mirrors.DragonOS.org](https://mirrors.DragonOS.org)
- [https://mirrors.DragonOS.org.cn](https://mirrors.DragonOS.org.cn)


## 开放源代码声明


:::{note}
为促进DragonOS项目的健康发展，DragonOS以GPLv2开源协议进行发布。所有能获得到DragonOS源代码以及相应的软件制品（包括但不限于二进制副本、文档）的人，都能享有我们通过GPLv2协议授予您的权利，同时您也需要遵守协议中规定的义务。

这是一个相当严格的，保护开源软件健康发展，不被侵占的协议。

对于大部分的善意的人们而言，您不会违反我们的开源协议。

我们鼓励DragonOS的自由传播、推广，但是请确保所有行为没有侵犯他人的合法权益，也没有违反GPLv2协议。

请特别注意，对于违反开源协议的，尤其是**商业闭源使用以及任何剽窃、学术不端行为将会受到严肃的追责**。（这是最容易违反我们的开源协议的场景）。

并且，请注意，按照GPLv2协议的要求，基于DragonOS修改或二次开发的软件，必须同样采用GPLv2协议开源，并标明其基于DragonOS进行了修改。亦需保证这些修改版本的用户能方便的获取到DragonOS的原始版本。

您必须使得DragonOS的开发者们，能够以同样的方式，从公开渠道获取到您二次开发的版本的源代码，否则您将违反GPLv2协议。

关于协议详细内容，还敬请您请阅读项目根目录下的**LICENSE**文件。请注意，按照GPLv2协议的要求，**只有英文原版才具有法律效力**。任何翻译版本都仅供参考。
:::

### 开源软件使用情况

&emsp;&emsp;DragonOS在开发的过程中，参考了一些开源项目的设计，或者引入了他们的部分代码，亦或是受到了他们的启发。现将他们列在下面。我们对这些开源项目的贡献者们致以最衷心的感谢！

格式：<项目名> - <链接> - <开源协议>

- Linux - 	https://git.kernel.org/ - GPLv2
- skiftOS - https://github.com/skiftOS/skift - MIT
- FYSOS - https://github.com/fysnet/FYSOS - [FYSOS' License](https://github.com/fysnet/FYSOS/blob/9a8968e3d6600de34539c028c843f4c06d134039/license.txt)
- LemonOS - https://github.com/LemonOSProject/LemonOS.git - BSD 2-Clause License
- LZ4 - https://github.com/lz4/lz4 - BSD 2-Clause license
- SerenityOS - https://github.com/SerenityOS/serenity.git - BSD 2-Clause license
- MINE - 《一个64位操作系统的设计与实现》田宇; 人民邮电出版社
- chcore - 《现代操作系统：设计与实现》陈海波，夏虞斌; 机械工业出版社
- SimpleKernel - https://github.com/Simple-XX/SimpleKernel - MIT
