Требуется переработать текст. От помощи не откажусь :)

# VoltageControl
Arduino библиотека контроля напряжения.


### Шаблон
Класс является шаблонным и применяет 1 параметр: `uint8_t _id = 0`.
 Первый не обязательный параметр прозрачно передаёт `uint8_t` значение в вызываемые колбеки, что позволяет идентифицировать класс при использовании нескольких экземпляров класса на один колбек. Например пин чтение АЦП:
```c
VoltageControl<A1> Volt1;
VoltageControl<A2> Volt2;
//...
Volt1.SetRequest(OnRequestVoltage);
Volt2.SetRequest(OnRequestVoltage);
//...
int32_t OnRequestVoltage(uint8_t id)
{
	return analogRead(id);
}
```


### Конструктор
Для удобства, класс имеет два конструктора.

```c
`VoltageControl()`
```
Конструктор класса без параметров. При использовании требуется передать настройки через `Set` методы.
 * Параметры: нет.


```c
VoltageControl(request_t callback_req, uint16_t interval_req, response_t callback_res, bool once, uint32_t coefficient, int32_t vmin, int32_t vmax)
```
Конструктор класса с указанием всех настроек.
 * Параметры: Колбэк-функция чтения АЦП, Интервал чтения АЦП в мс., Колбэк-функцию результата измерения, Флаг одиночного вызова см. описание `SetResponse()`, Коэффициент перевода значения АЦП, Минимально допустимое напряжение, Максимально допустимое напряжение.


### Колбеки
```c
int32_t OnRequestVoltage(uint8_t id)
```
Когда классу будет необходимо прочитать значение АЦП будет вызвана эта колбэк-функция. Вы можете выполнить или встроенный метод чтения АЦП ( `analogRead()` ), напрямую работать с регистрами или читать внешний АЦП по любой доступной шине.
 * Параметры: Переданный ID.
 * Вернуть: Сырое значение АЦП.


```c
void OnResponseVoltage(uint8_t id, int32_t value, int8_t state)
```
Когда нужно уведомить основную программу о изменениях, будет выхвана эта колбэк-функция. Вы можете принять решение о ветвлении кода и выполнить все необходимое здесь.
 * Параметры: Переданный ID, Текущее напряжение в мВ, Состояние напряжения, см. описание `GetValid()`.
 * Вернуть: нет.


### Методы класса
```c
void SetRequest(request_t callback, uint16_t interval)
```
Метод указывает на колбэк-функцию чтения АЦП.
 * Параметры: Колбэк-функция, Интервал опроса в мс.
 * Вернуть: нет.


```c
void SetResponse(response_t callback, bool once = false)
```
Метод указывает на колбэк-функцию результата измерения напряжения. Если `once = true`, то вызов колбэк-функции будет происходить только при смене состояния ( пониженное, повышенное, нормальное напряжение ), в противном случае вызов будет происходить при каждом измерении АЦП.
 * Параметры: Колбэк-функция, Флаг одиночного вызова при изменении.
 * Вернуть: нет.


```c
void SetCoefficient(uint32_t coefficient)
```
Метод определяет коэффициент перевода значения АЦП в микровольты.
 * Параметры: Значение коэффициента.
 * Вернуть: нет.


```c
void SetMin(uint32_t vmin)
```
Метод определяет минимально допустимое напряжение.
 * Параметры: Напряжение в мВ.
 * Вернуть: нет.


```c
void SetMax(uint32_t vmax)
```
Метод определяет максимально допустимое напряжение.
 * Параметры: Напряжение в мВ.
 * Вернуть: нет.


```c
void SetStart()
```
Метод устанавливает флаг запуска работы класса.
 * Параметры: нет.
 * Вернуть: нет.


```c
void SetStop()
```
Метод устанавливает флаг остановки работы класса.
 * Параметры: нет.
 * Вернуть: нет.


```c
int8_t GetValid()
```
Метод проверяет напряжение и возвращает результат в виде числа.
 * Параметры: нет.
 * Вернуть: Число `-1` - Меньше допустимого, `0` - В рамках допустимо, `1` - Больше допустимого.


```c
int32_t GetVoltage()
```
Метод возвращает текущее напряжение.
 * Параметры: нет.
 * Вернуть: Напряжение в мВ.


```c
void Processing(uint32_t currentTime = millis())
```
Метод обработки числа. В случае, если в Вашей `loop` функции есть определение текущего времени, то целесообразнее передать это время в качестве параметра.
 * Параметры: Текущая отметка времени.
 * Вернуть: нет.


```c
static inline uint32_t GetCoefficient(float vref, float r1 = 0, float r2 = 1, float quantization = 1024)
```
Утилита, которая помогает рассчитать коэффициент для метода `SetCoefficient()`. Если делитель не используется, то указывается только vref.
 * Параметры: Опорное напряжение в микровольтах, Сопротивление верхнего резистора в омах, Сопротивление нижнего резистора в омах, Уровень квантования АЦП.
 * Вернуть: Коэффициент пересчёта.


### Заключение
