#! /usr/bin/env node
"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.subclean = exports.SubClean = void 0;
var fs_1 = require("fs");
var subtitle_1 = require("subtitle");
var path_1 = require("path");
var string_decoder_1 = require("string_decoder");
var iconv = require("iconv-lite");
var help_1 = require("./help");
var https_1 = require("https");
var getEncoding = require('detect-file-encoding-and-language');
var argv = require('minimist')(process.argv.slice(2));
var updateNotifier = require('update-notifier');
var pkg = require('../package.json');
var SubClean = /** @class */ (function () {
    function SubClean() {
        var _a;
        this.noFileOutput = false;
        this.silent = false;
        // For debugging
        this.actions_count = 0;
        this.nodes_count = 0;
        this.filter_count = 0;
        this.log_data = '';
        this.args = {
            input: argv._.shift() || argv.i || argv['input'] || '',
            output: argv.o || argv['output'] || '',
            overwrite: argv.w || argv.overwrite || false,
            clean: argv.c || argv.clean || false,
            debug: argv.debug || false,
            help: argv.help || false,
            nocheck: argv.n || argv['no-check'] || false,
            silent: argv.silent || argv.s || false,
            version: argv.version || argv.v || false,
            update: argv.update || false,
            sweep: argv.sweep || '',
            depth: (_a = argv.depth) !== null && _a !== void 0 ? _a : 10,
            ne: argv['ne'] || true,
            lang: argv['lang'] || '',
            nochains: argv.nochains || false,
            testing: argv.testing || false,
            uf: argv.uf || 'default'
        };
        if (argv['debug'])
            console.log(argv);
        this.silent = this.args.silent;
        if (typeof this.args.sweep !== 'string') {
            this.args.sweep = '.';
        }
        if (this.args.testing === true) {
            this.log('[WARN] Testing is enabled! File will not be saved');
        }
        this.fd = path_1.join(__dirname, '../filters');
        this.blacklist = [];
        this.supported = ['srt', 'vtt'];
        this.loaded = [];
        this.queue = [];
    }
    /**
     *
     * @param dir Top level directory to get files in
     * @param depth How many sub-directories to look through
     * @returns
     */
    SubClean.prototype.getFiles = function (dir, depth) {
        var _this = this;
        if (depth === void 0) { depth = 5; }
        if (this.args.debug)
            console.log('getFiles' + [dir, depth]);
        return new Promise(function (done) { return __awaiter(_this, void 0, void 0, function () {
            var subdirs, files;
            var _this = this;
            return __generator(this, function (_a) {
                subdirs = fs_1.readdirSync(dir);
                files = [];
                subdirs.map(function (subdir) { return __awaiter(_this, void 0, void 0, function () {
                    var res, data, _a, _i, data_1, item;
                    return __generator(this, function (_b) {
                        switch (_b.label) {
                            case 0:
                                res = path_1.resolve(dir, subdir);
                                data = [];
                                if (!fs_1.statSync(res).isDirectory()) return [3 /*break*/, 4];
                                if (!(depth > 0)) return [3 /*break*/, 2];
                                return [4 /*yield*/, this.getFiles(res, depth - 1)];
                            case 1:
                                _a = _b.sent();
                                return [3 /*break*/, 3];
                            case 2:
                                _a = [];
                                _b.label = 3;
                            case 3:
                                data = _a;
                                return [3 /*break*/, 5];
                            case 4:
                                data = [res];
                                _b.label = 5;
                            case 5:
                                // Filter out files that are not supported subtitles
                                for (_i = 0, data_1 = data; _i < data_1.length; _i++) {
                                    item = data_1[_i];
                                    if (this.supported.includes(path_1.extname(item).substr(1))) {
                                        files.push(item);
                                    }
                                }
                                return [2 /*return*/];
                        }
                    });
                }); });
                return [2 /*return*/, done(files)];
            });
        }); });
    };
    /**
     * Log a message to the console, only if subclean is not in silent mode
     * @param msg Message
     */
    SubClean.prototype.log = function (msg) {
        if (!this.silent)
            console.log(msg);
        this.log_data += msg + "\n";
    };
    /**
     * Kill the script after printing an error
     * @param e Error Message
     */
    SubClean.prototype.kill = function (e, err) {
        if (err === void 0) { err = true; }
        this.log((err ? '[Error] ' : '') + ("" + e));
        process.exit(0);
    };
    // TODO: Auto-generate help text
    SubClean.prototype.help = function () {
        this.kill(help_1.help_text, false);
    };
    /**
     * Add a file (with config) to the queue.
     * A check will be made to ensure it is not already in the queue
     * @param config
     * @returns
     */
    SubClean.prototype.addToQueue = function (config) {
        var exists = this.queue.find(function (item) { return item.input === config.input; });
        if (exists)
            return this.log("[Error] Duplicate in queue '" + config.input + "'");
        else {
            config.directory = path_1.dirname(config.input);
            config.ext = path_1.extname(config.input).substr(1);
            this.queue.push(config);
        }
    };
    /**
     * This is where files will be fetched and arguments validated
     * Extra information that might be needed for cleaning will also be filled
     * @returns
     */
    SubClean.prototype.prepare = function () {
        return __awaiter(this, void 0, void 0, function () {
            var notifier, filename, match, files, _i, files_1, file, error_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 6, , 7]);
                        // Display help message
                        if (this.args.help)
                            this.help();
                        if (!this.args.update) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.updateFilters()];
                    case 1:
                        _a.sent();
                        this.kill('[Info] Updated all filters', false);
                        _a.label = 2;
                    case 2:
                        // Notify if there's a new update
                        if (this.args.nocheck === false && this.noFileOutput === true) {
                            notifier = updateNotifier({ pkg: pkg, updateCheckInterval: 1000 * 60 * 60 });
                            if (notifier.update) {
                                this.log("[Info] Update available: " + pkg.version + " -> " + notifier.update.latest);
                                this.log('[Info] https://github.com/DrKain/subclean/releases');
                            }
                        }
                        // Log the current version
                        if (this.args.version) {
                            return [2 /*return*/, this.kill('You are using subclean@' + pkg.version, false)];
                        }
                        // Just in case
                        if (typeof this.args.depth !== 'number')
                            this.args.depth = 10;
                        if (this.args.depth > 25)
                            this.args.depth = 25;
                        if (this.args.depth < 0)
                            this.args.depth = 1;
                        // Not really wildcard support, more of a shortcut
                        // TODO: Custom regex match for getFiles() to properly support wildcards
                        if (this.args.input === '*') {
                            this.args.depth = 1;
                            this.args.sweep = '.';
                        }
                        // Extract language codes
                        if (this.args.input !== '') {
                            filename = path_1.basename(this.args.input);
                            match = filename.match(/\.(\w+)\.srt$/);
                            if (match) {
                                this.log("[Info] Language codes matched: " + match);
                                this.args.lang = match[1];
                            }
                        }
                        if (!this.args.sweep) return [3 /*break*/, 4];
                        // Validate the sweep directory exists
                        this.args.sweep = path_1.resolve(this.args.sweep);
                        if (this.args.debug) {
                            this.log('[Info] Sweep target: ' + this.args.sweep);
                            this.log('[Info] Depth: ' + this.args.depth);
                        }
                        if (!fs_1.existsSync(this.args.sweep))
                            this.kill(this.args.sweep + " is not a valid path", true);
                        // Fetch files and add them to the queue
                        this.log("[Info] Scanning for subtitle files. This may take a few minutes with large collections");
                        return [4 /*yield*/, this.getFiles(this.args.sweep, this.args.depth)];
                    case 3:
                        files = _a.sent();
                        for (_i = 0, files_1 = files; _i < files_1.length; _i++) {
                            file = files_1[_i];
                            this.addToQueue(__assign(__assign({}, this.args), { overwrite: true, input: file, output: file }));
                        }
                        // Log how many items were added
                        this.log("[Info] Added " + this.queue.length + " files to the queue");
                        return [3 /*break*/, 5];
                    case 4:
                        // Display an error if the user did not specify an input file
                        if (this.args.input === '') {
                            return [2 /*return*/, this.kill('Missing arguments. Use --help for details', true)];
                        }
                        // If an output file is not set, generate a default path
                        if (this.args.output === '') {
                            // You will still need to enable --overwrite to overwrite the file
                            this.args.output = this.args.input;
                        }
                        // Make sure the input file exists
                        if (!fs_1.existsSync(this.args.input)) {
                            this.kill('Input file does not exist', true);
                        }
                        // Make sure it's not a directory
                        if (fs_1.statSync(this.args.input).isDirectory()) {
                            this.kill('Input file was detected to be a directory. Please use --sweep "path/to/media" to clean whole directories.', true);
                        }
                        // Prevent accidentally overwriting a file
                        if (fs_1.existsSync(this.args.output) && this.args.overwrite === false) {
                            this.kill("Ouput file already exists. Pass -w to overwrite", true);
                        }
                        this.addToQueue(this.args);
                        _a.label = 5;
                    case 5: return [3 /*break*/, 7];
                    case 6:
                        error_1 = _a.sent();
                        if (this.args.debug)
                            console.log(error_1);
                        this.kill("" + error_1, true);
                        return [3 /*break*/, 7];
                    case 7: return [2 /*return*/];
                }
            });
        });
    };
    SubClean.prototype.writeLogs = function () {
        try {
            var target = path_1.join(this.getPath(), 'logs', 'latest.txt');
            this.saveFile(this.log_data, target);
        }
        catch (error) {
            this.log("[error] " + error);
        }
    };
    /**
     * Load all the items in a blacklist filter into the current blacklist
     * @param file Target blacklist file
     */
    SubClean.prototype.loadBlacklist = function (file) {
        return __awaiter(this, void 0, void 0, function () {
            var target, internal, items, _a, _b, e_1;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        target = path_1.join(this.fd, file + ".json");
                        if (this.loaded.includes(file))
                            return [2 /*return*/];
                        _c.label = 1;
                    case 1:
                        _c.trys.push([1, 3, , 4]);
                        internal = false;
                        target = path_1.join(this.getPath(), 'filters', file);
                        if (!target.endsWith('.json'))
                            target += '.json';
                        // Let people know where subclean is looking for
                        if (this.args.debug && this.args.uf === 'appdata') {
                            this.log('[Debug] Checking: ' + target);
                        }
                        // If the appdata file doesn't exist, use the internal filters
                        if (!fs_1.existsSync(target) || this.args.uf === 'internal') {
                            target = path_1.join(this.fd, file + ".json");
                            internal = true;
                        }
                        // If it still doesn't exist, return
                        if (!fs_1.existsSync(target)) {
                            if (file !== 'custom')
                                this.log('[Info] Unable to locate filter: ' + file);
                            return [2 /*return*/];
                        }
                        _b = (_a = JSON).parse;
                        return [4 /*yield*/, this.readFile(target)];
                    case 2:
                        items = _b.apply(_a, [_c.sent()]);
                        this.blacklist = __spreadArray(__spreadArray([], this.blacklist), items);
                        this.loaded.push(file);
                        if (this.args.debug) {
                            this.filter_count += items.length;
                            this.log("[Filter] [" + (internal ? 'int' : 'app') + "] Added " + items.length + " items from filter '" + file + "'");
                        }
                        return [3 /*break*/, 4];
                    case 3:
                        e_1 = _c.sent();
                        this.log('[Error] Failed to load a filter: ' + file);
                        return [3 /*break*/, 4];
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    SubClean.prototype.getFileEncoding = function (input) {
        var _this = this;
        return new Promise(function (resolve) {
            try {
                getEncoding(input).then(function (data) {
                    data.encoding = data.encoding.toLowerCase();
                    resolve(data);
                });
            }
            catch (error) {
                _this.log("[Error] " + error);
                resolve({
                    encoding: 'unknown',
                    language: 'unknown',
                    confidence: { encoding: 0, language: 0 }
                });
            }
        });
    };
    SubClean.prototype.readFile = function (target, encoding) {
        var _this = this;
        if (encoding === void 0) { encoding = 'utf-8'; }
        return new Promise(function (resolve) {
            try {
                var data = fs_1.readFileSync(target);
                var decoded = iconv.decode(data, encoding);
                if (_this.args.debug)
                    _this.log("[debug] readFile: [" + encoding + "] " + target);
                resolve(decoded);
            }
            catch (error) {
                _this.log(error);
                resolve('');
            }
        });
    };
    /**
     * Clean raw subtitle text instead of a file
     * @param text Raw subtitle text
     * @param config Config for cleaning the file
     * @returns string Cleaned subtitle text
     */
    SubClean.prototype.cleanRaw = function (text, config) {
        var _this = this;
        return new Promise(function (resolve, reject) { return __awaiter(_this, void 0, void 0, function () {
            var ok;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.ensureDirs()];
                    case 1:
                        _a.sent();
                        // Load the blacklist
                        this.loadBlacklist('main');
                        this.loadBlacklist('users');
                        this.loadBlacklist('custom');
                        Object.assign(this.args, config || {});
                        return [4 /*yield*/, this.testData(text)];
                    case 2:
                        ok = _a.sent();
                        if (!ok)
                            return [2 /*return*/, reject('Error: Unable to parse subtitles')];
                        return [2 /*return*/, this.clean(this.args, text).then(resolve).catch(reject)];
                }
            });
        }); });
    };
    SubClean.prototype.testData = function (data) {
        return new Promise(function (resolve) {
            try {
                subtitle_1.parseSync(data);
                resolve(true);
            }
            catch (error) {
                resolve(false);
            }
        });
    };
    SubClean.prototype.verifyFileData = function (data) {
        var _this = this;
        var original = data;
        return new Promise(function (resolve) { return __awaiter(_this, void 0, void 0, function () {
            var spacingFix, error_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 3, , 4]);
                        return [4 /*yield*/, this.testData(data)];
                    case 1:
                        // If the raw data can be parsed then we have no problem
                        if ((_a.sent()) === true) {
                            return [2 /*return*/, resolve(data)];
                        }
                        spacingFix = data.replace(/\r/g, ' ');
                        return [4 /*yield*/, this.testData(spacingFix)];
                    case 2:
                        if ((_a.sent()) === true) {
                            this.log('[Info] Fixed spacing in subtitle file');
                            return [2 /*return*/, resolve(spacingFix)];
                        }
                        /*
                        If both fail, throw an error and return the original data.
                        This function can be used for fixes at another date
                        */
                        throw Error('verifyFileData failed');
                    case 3:
                        error_2 = _a.sent();
                        this.log(error_2);
                        resolve(original);
                        return [3 /*break*/, 4];
                    case 4: return [2 /*return*/];
                }
            });
        }); });
    };
    /**
     * Clean a subtitle file using the desired config
     * @param item Queue item
     * @returns IArguments
     */
    SubClean.prototype.clean = function (item, text) {
        var _this = this;
        return new Promise(function (done, reject) { return __awaiter(_this, void 0, void 0, function () {
            var fileData, _a, encoding, language, nodes_1, hits_1, codes, _i, _b, c, _c, codes_1, code, filter, deleted_nodes_1, cleaned, ll, error_3;
            var _this = this;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _d.trys.push([0, 10, , 11]);
                        fileData = void 0;
                        if (!(text == undefined)) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.getFileEncoding(item.input)];
                    case 1:
                        _a = _d.sent(), encoding = _a.encoding, language = _a.language;
                        this.log("[Info] Encoding: " + encoding + ", Language: " + language);
                        if (encoding !== 'utf-8') {
                            this.log('[Info] File encoding is not utf-8, this will be fixed');
                        }
                        return [4 /*yield*/, this.readFile(item.input, encoding)];
                    case 2:
                        // Parse the subtitle file
                        fileData = _d.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        fileData = text;
                        _d.label = 4;
                    case 4: return [4 /*yield*/, this.verifyFileData(fileData)];
                    case 5:
                        // Ensure the data can be parsed, also tries to fix bad data
                        fileData = _d.sent();
                        nodes_1 = subtitle_1.parseSync(fileData);
                        hits_1 = 0;
                        // For debugging
                        this.nodes_count += nodes_1.length;
                        codes = [];
                        for (_i = 0, _b = item.lang.split(','); _i < _b.length; _i++) {
                            c = _b[_i];
                            if (!codes.includes(c) && c.length === 2)
                                codes.push(c);
                        }
                        if (!(codes.length > 0)) return [3 /*break*/, 9];
                        if (this.args.debug)
                            this.log('[Info] Attempting to load language filters: ' + codes.join(','));
                        _c = 0, codes_1 = codes;
                        _d.label = 6;
                    case 6:
                        if (!(_c < codes_1.length)) return [3 /*break*/, 9];
                        code = codes_1[_c];
                        filter = code + "-main.json";
                        return [4 /*yield*/, this.loadBlacklist(filter)];
                    case 7:
                        _d.sent();
                        _d.label = 8;
                    case 8:
                        _c++;
                        return [3 /*break*/, 6];
                    case 9:
                        // Remove ads
                        nodes_1.forEach(function (node, index) {
                            _this.blacklist.forEach(function (mark) {
                                var regex = null;
                                _this.actions_count++;
                                var text = node.data.text;
                                /**
                                 * Clean chained nodes based on current match
                                 * https://github.com/DrKain/subclean/pull/20
                                 */
                                var handle_chain = function () {
                                    var removed = [];
                                    var range = index + 1 + "-" + (index + 1);
                                    if (index > 0 && item.nochains) {
                                        var prev = nodes_1[index - 1];
                                        if (text.includes(prev.data.text)) {
                                            for (var i = index - 1; i > 0; i--) {
                                                var check = nodes_1[i].data.text;
                                                if (check.length === 0)
                                                    continue; // Ignore empty string nodes
                                                if (!text.includes(check))
                                                    break; // Chain stopped
                                                hits_1++;
                                                removed.push(nodes_1[i].data.text);
                                                range = index + 1 - removed.length + "-" + (index + 1);
                                                nodes_1[i].data.text = '';
                                            }
                                        }
                                    }
                                    return { nodes: removed, range: range };
                                };
                                // Clean the current node
                                var cleanNode = function () {
                                    // Requires --nochains param
                                    var chain = handle_chain();
                                    if (chain.nodes.length > 1) {
                                        _this.log("[Match] Chain found at " + chain.range + " (" + mark + ")");
                                        hits_1 += chain.nodes.length;
                                    }
                                    else {
                                        _this.log("[Match] Advertising found in node " + (index + 1) + " (" + mark + ")");
                                        hits_1++;
                                        node.data.text = '';
                                    }
                                    // Log the line for debugging
                                    if (_this.args.debug)
                                        _this.log('[Line] ' + text);
                                };
                                if (mark.startsWith('/') && mark.endsWith('/')) {
                                    // remove first and last characters
                                    regex = new RegExp(mark.substring(1, mark.length - 1), 'i');
                                    if (regex.exec(text))
                                        cleanNode();
                                }
                                else {
                                    // Plain text matches
                                    if (node.data.text.toLowerCase().includes(mark))
                                        cleanNode();
                                }
                            });
                        });
                        // Remove empty nodes when requested
                        if (this.args.ne) {
                            deleted_nodes_1 = [];
                            nodes_1.forEach(function (node, index) {
                                if (node.data.text === '') {
                                    deleted_nodes_1.push(index + 1);
                                    delete nodes_1[index];
                                }
                            });
                            // Only log if we actually deleted nodes
                            if (deleted_nodes_1.length > 0) {
                                this.log("[Info] Removed empty nodes: " + deleted_nodes_1.join(', '));
                            }
                        }
                        // Remove input file
                        if (item.clean && this.args.testing == false) {
                            fs_1.unlinkSync(item.input);
                        }
                        cleaned = subtitle_1.stringifySync(nodes_1, { format: item.ext });
                        // Write cleaned file
                        if (this.args.testing === false) {
                            this.saveFile(cleaned, item.output);
                        }
                        if (hits_1 > 0) {
                            ll = ["[Done] Removed " + hits_1 + " node(s)", "and wrote to " + item.output + "\n"];
                            if (this.noFileOutput || item.output === '')
                                ll.pop();
                            this.log(ll.join(' '));
                        }
                        else
                            this.log('[Done] No advertising found\n');
                        if (this.args.debug) {
                            this.log('[Debug] ' + this.actions_count.toLocaleString() + ' checks');
                            this.log('[Debug] ' + this.filter_count.toLocaleString() + ' filters applied');
                            this.log('[Debug] ' + this.nodes_count.toLocaleString() + ' text nodes');
                            this.writeLogs();
                        }
                        // Resolve the promise
                        done(cleaned);
                        return [3 /*break*/, 11];
                    case 10:
                        error_3 = _d.sent();
                        if (("" + error_3).includes('expected timestamp at')) {
                            this.log("[Error] Unable to parse \"" + item.input + "\"");
                            this.log("[Error] Please create an issue on GitHub with a copy of this file.\n");
                            this.log('[Error] I highly recommend finding another subtitle in the mean time.');
                        }
                        reject(error_3);
                        return [3 /*break*/, 11];
                    case 11: return [2 /*return*/];
                }
            });
        }); });
    };
    SubClean.prototype.getPath = function () {
        var _a, _b, _c, _d;
        var target = '';
        // NOTE: This was suggested by github co-pilot and is untested.
        switch (process.platform) {
            case 'win32':
                target = path_1.join((_b = (_a = process.env.APPDATA) !== null && _a !== void 0 ? _a : process.env.LOCALAPPDATA) !== null && _b !== void 0 ? _b : '', 'subclean');
                break;
            case 'darwin':
                target = path_1.join((_c = process.env.HOME) !== null && _c !== void 0 ? _c : '', 'Library', 'Application Support', 'subclean');
                break;
            default:
                target = path_1.join((_d = process.env.HOME) !== null && _d !== void 0 ? _d : '', 'subclean');
                break;
        }
        return target;
    };
    SubClean.prototype.saveFile = function (data, location) {
        var _this = this;
        return new Promise(function (resolve) { return __awaiter(_this, void 0, void 0, function () {
            var decoder, sample, out;
            return __generator(this, function (_a) {
                try {
                    if (this.noFileOutput === false) {
                        if (this.args.testing === false && location !== '') {
                            this.log('[Info] Save file: ' + location);
                            decoder = new string_decoder_1.StringDecoder('utf8');
                            sample = Buffer.from(data);
                            out = decoder.write(sample);
                            fs_1.writeFileSync(location, out);
                        }
                    }
                    resolve(true);
                }
                catch (error) {
                    this.log('[Error] ' + location);
                    this.log('[error] Failed to save: ' + error);
                    resolve(false);
                }
                return [2 /*return*/];
            });
        }); });
    };
    SubClean.prototype.downloadFilter = function (name) {
        var _this = this;
        return new Promise(function (resolve) {
            var url = "https://raw.githubusercontent.com/DrKain/subclean/main/filters/" + name + ".json";
            var save_to = path_1.join(_this.getPath(), 'filters', name + ".json");
            var current = 0;
            if (fs_1.existsSync(save_to))
                current = fs_1.statSync(save_to).size;
            https_1.get(url, function (res) {
                var data = '';
                res.on('data', function (chunk) { return (data += chunk); });
                res.on('end', function () { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                if (!data.includes('404: Not Found')) return [3 /*break*/, 1];
                                this.log('[Info] 404 from filter, deleting ' + name);
                                fs_1.unlinkSync(save_to);
                                resolve(false);
                                return [3 /*break*/, 3];
                            case 1: return [4 /*yield*/, this.saveFile(data, save_to)];
                            case 2:
                                _a.sent();
                                if (fs_1.statSync(save_to).size !== current) {
                                    this.log("[Info] Downloaded new filters for: " + name);
                                }
                                resolve(name);
                                _a.label = 3;
                            case 3: return [2 /*return*/];
                        }
                    });
                }); });
            }).on('error', function (err) {
                _this.log("[Error] " + err);
                resolve(false);
            });
        });
    };
    SubClean.prototype.ensureDirs = function () {
        var _this = this;
        return new Promise(function (resolve) { return __awaiter(_this, void 0, void 0, function () {
            var $app, $filters, $logs, ftr;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        // If no file output, return instantly
                        if (this.noFileOutput) {
                            if (this.args.debug)
                                this.log('noFileOutput is true');
                            return [2 /*return*/, resolve(0)];
                        }
                        $app = this.getPath();
                        $filters = path_1.join($app, 'filters');
                        $logs = path_1.join($app, 'logs');
                        ftr = false;
                        // Ensure user directories exist
                        if (!fs_1.existsSync($app)) {
                            this.log('First time running, downloading filters');
                            fs_1.mkdirSync($app);
                            ftr = true;
                        }
                        if (!fs_1.existsSync($filters))
                            fs_1.mkdirSync($filters);
                        if (!fs_1.existsSync($logs))
                            fs_1.mkdirSync($logs);
                        if (!(ftr && this.noFileOutput === false)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.updateFilters()];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2:
                        resolve(1);
                        return [2 /*return*/];
                }
            });
        }); });
    };
    SubClean.prototype.updateFilters = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve) { return __awaiter(_this, void 0, void 0, function () {
                        var $app, $filters, queue, valid, dedupe, files, _i, files_2, file, codes, _a, _b, c, _c, valid_1, c, _d, codes_2, c, _e, queue_1, file, result, error_4;
                        return __generator(this, function (_f) {
                            switch (_f.label) {
                                case 0:
                                    $app = this.getPath();
                                    $filters = path_1.join($app, 'filters');
                                    queue = ['main', 'users'];
                                    valid = ['ar', 'de', 'nl', 'ru'];
                                    dedupe = function (arr) {
                                        return arr.filter(function (value, index, a) { return a.indexOf(value) === index; });
                                    };
                                    _f.label = 1;
                                case 1:
                                    _f.trys.push([1, 7, , 8]);
                                    // Make sure the appdata dir exists
                                    return [4 /*yield*/, this.ensureDirs()];
                                case 2:
                                    // Make sure the appdata dir exists
                                    _f.sent();
                                    files = fs_1.readdirSync($filters);
                                    for (_i = 0, files_2 = files; _i < files_2.length; _i++) {
                                        file = files_2[_i];
                                        queue.push(file.replace('.json', ''));
                                    }
                                    codes = [];
                                    for (_a = 0, _b = this.args.lang.split(','); _a < _b.length; _a++) {
                                        c = _b[_a];
                                        if (!codes.includes(c) && c.length === 2)
                                            codes.push(c);
                                    }
                                    // Or use "all" to download all filters --update --lang=all
                                    if (this.args.lang.toLowerCase() === 'all') {
                                        codes = [];
                                        for (_c = 0, valid_1 = valid; _c < valid_1.length; _c++) {
                                            c = valid_1[_c];
                                            codes.push(c);
                                        }
                                    }
                                    // Loop through add to queue
                                    for (_d = 0, codes_2 = codes; _d < codes_2.length; _d++) {
                                        c = codes_2[_d];
                                        queue.push(c + "-main");
                                    }
                                    if (codes.length > 0)
                                        this.log('[Info] Received language codes: ' + codes.join(','));
                                    // De-dupe the queue
                                    queue = dedupe(queue);
                                    this.log('[Info] Filter download queue: ' + queue.join(','));
                                    _e = 0, queue_1 = queue;
                                    _f.label = 3;
                                case 3:
                                    if (!(_e < queue_1.length)) return [3 /*break*/, 6];
                                    file = queue_1[_e];
                                    if (!(file !== 'custom')) return [3 /*break*/, 5];
                                    return [4 /*yield*/, this.downloadFilter(file.replace('.json', ''))];
                                case 4:
                                    result = _f.sent();
                                    if (!result)
                                        this.log('[Info] Filter download failed: ' + file);
                                    else
                                        this.log('[Info] Updated filter: ' + file);
                                    _f.label = 5;
                                case 5:
                                    _e++;
                                    return [3 /*break*/, 3];
                                case 6:
                                    resolve(1);
                                    return [3 /*break*/, 8];
                                case 7:
                                    error_4 = _f.sent();
                                    this.log("[Error] " + error_4);
                                    resolve(0);
                                    return [3 /*break*/, 8];
                                case 8: return [2 /*return*/];
                            }
                        });
                    }); })];
            });
        });
    };
    SubClean.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b, _i, index, item, name_1, error_5;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0: return [4 /*yield*/, this.ensureDirs()];
                    case 1:
                        _c.sent();
                        // Load the blacklist
                        this.loadBlacklist('main');
                        this.loadBlacklist('users');
                        this.loadBlacklist('custom');
                        // Prepare files
                        return [4 /*yield*/, this.prepare()];
                    case 2:
                        // Prepare files
                        _c.sent();
                        if (this.queue.length > 1)
                            this.log('[Info] Starting queue...\n');
                        _a = [];
                        for (_b in this.queue)
                            _a.push(_b);
                        _i = 0;
                        _c.label = 3;
                    case 3:
                        if (!(_i < _a.length)) return [3 /*break*/, 8];
                        index = _a[_i];
                        item = this.queue[index];
                        name_1 = path_1.basename(item.input);
                        if (this.args.debug)
                            name_1 = item.input;
                        // If we are only cleaning one file, don't log the queue details
                        if (this.queue.length > 1) {
                            this.log("[Clean] [" + (+index + 1) + "/" + this.queue.length + "] Cleaning \"" + name_1 + "\"");
                        }
                        _c.label = 4;
                    case 4:
                        _c.trys.push([4, 6, , 7]);
                        return [4 /*yield*/, this.clean(item)];
                    case 5:
                        _c.sent();
                        return [3 /*break*/, 7];
                    case 6:
                        error_5 = _c.sent();
                        this.log("[Error] " + error_5);
                        return [3 /*break*/, 7];
                    case 7:
                        _i++;
                        return [3 /*break*/, 3];
                    case 8: return [2 /*return*/];
                }
            });
        });
    };
    return SubClean;
}());
exports.SubClean = SubClean;
if (require.main === module) {
    new SubClean().init();
}
else {
    exports.subclean = new SubClean();
    exports.subclean.noFileOutput = true;
    exports.subclean.silent = true;
}
__exportStar(require("./interface"), exports);
