
# 👨‍💼 Employee Management System V2

## Overview
This **Employee Management System** aims to enhance HR processes for a growing company with over 200 employees. By moving from an inefficient Excel-based system to a centralized Java EE application, we aim to streamline various HR functions.

## 🚀 Features
- **Employee Management**: Easily manage employee records.
- **Recruitment**: Publish job offers and track applications.
- **Leave Management**: Submit and track leave requests.
- **Family Allowance Calculation**: Automatically calculate allowances.
- **Reporting**: Generate key reports for management.
- **Notifications**: Receive alerts for important updates.



## 🛠️ Technologies Used
- **Java EE** (JSP, Servlets)
- **JPA** ORM for database interactions
- **PostgreSQL** for data storage
- **Tomcat 10** as the web server
- **Maven** for dependency management
- **MVC Architecture** for modular code organization
- **Repository** and **Service** layers

## 📊 Class Diagram
[View Class Diagram](https://lucid.app/lucidchart/f53bccdc-e194-4cf1-9a8f-1827929e486e/edit?view_items=MYSfFlOmoGkX&invitationId=inv_7adfdd25-9c07-4819-a4b5-6866750f1ad6)

# 👨‍💼 Employee Management System JUnite

## 🧪 Unit Tests
The project includes unit tests for core functionalities to ensure the system works as expected. These tests cover both success and error scenarios, with an emphasis on isolating components using **JUnit** and **Mockito**.

### Tested Components:
1. **Employee Management (CRUD)**: 
   - Create, Read, Update, and Delete operations for managing employee records.
2. **Job Offers**:
   - Create, publish, and delete job offers.
3. **Leave Management**:
   - Apply for leave, approve, or reject leave requests.
   - Test cases include date validation and leave balance verification.
4. **Family Allowances**:
   - Calculation of family allowances based on employee's dependents.
   - Test for correct allowance computation and error handling for missing data.

Tests ensure proper functioning in both nominal (success) and edge cases (errors or missing data).

### Technologies for Unit Testing:
- **JUnit 5** for unit test execution.
- **Mockito** for mocking dependencies in tests.
- **Maven** for managing test dependencies and automating test execution.
## 📜 License
This project is licensed under the MIT License.

## 📈 Presentation

[Project Presentation](https://www.canva.com/design/DAGSP4Ce82w/_UKGB7K__KWdkqt-t04pGA/edit)



## 🗂️ Project Planning
[View Project Planning](https://douaa123.atlassian.net/jira/software/c/projects/ET/boards/12/backlog)




