# Contributing to Bait-User WordPress Plugin

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## We Develop with Github
We use GitHub to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [Github Flow](https://guides.github.com/introduction/flow/index.html), So All Code Changes Happen Through Pull Requests
Pull requests are the best way to propose changes to the codebase. We actively welcome your pull requests:

1. Fork the repo and create your branch from `master`(or other branch incase of a bug).
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Any contributions you make will be under the Mozilla Public License
In short, when you submit code changes, your submissions are understood to be under the same Mozilla Public License Version 2.0 that covers the project. Feel free to contact the maintainers if that's a concern.

## Report bugs using Github's [issues](https://github.com/Doononthon/Wordpress-Bait-user/issues)
We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/DoonOnthon/Wordpress-Bait-user/issues/new); it's that easy!

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give sample code if you can.
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)</br>
For more information click here : <a href="https://github.com/DoonOnthon/Wordpress-Bait-user/blob/main/CONTRIBUTING.md">CONTRIBUTE</a></br>
People *love* thorough bug reports. I'm not even kidding.

## Use a Consistent Coding Style
- Just follow the ongoing coding style.
- You can try running `npm run lint` for style unification

## License
By contributing, you agree that your contributions will be licensed under its Mozilla Public License Version 2.0 License.

## References
Please ensure to follow the project's roadmap and guidelines stated in the README for working on issues.

Thank you for contributing to the Bait-User WordPress plugin, where we aim to enhance WordPress security with innovative solutions!
