## Pull Request Title

Provide a concise title that clearly describes your pull request.

## Description

Describe your changes in detail. Include any relevant information such as what bugs were fixed, what features were added, and any other context for the reviewer.

## Related Issues

If this pull request is related to any existing issues, please list them here (e.g., Fixes #123, Closes #456).

## Roadmap Alignment

Does this pull request align with a feature or task on the project roadmap? If so, specify the version and feature (e.g., "Aligns with Version 1.3.x, Feature: Logging and Reporting"). Otherwise, state "Not applicable."

## Type of Changes

Please check the boxes that apply to your pull request:

- [ ] Bugfix
- [ ] New Feature
- [ ] Enhancement
- [ ] Documentation

## How Has This Been Tested?

Describe the tests that you ran to verify your changes. Include details of the test environment, any automated tests, and how you manually tested.

## Screenshots (if applicable)

If your changes involve any UI updates, please provide screenshots here.

## Checklist

Please go over all the following points and make sure they are true:

- [ ] I have reviewed the roadmap and ensured my changes align where applicable.
- [ ] I have added tests that prove my fix is effective or that my feature works.
- [ ] I have included necessary documentation updates.
- [ ] My changes do not introduce any breaking changes.
- [ ] I have commented my code, particularly in hard-to-understand areas.
- [ ] I have followed the [Contributing Guidelines](link_to_contributing_guidelines) for this project.

## Additional Notes

Include any additional information or considerations for the reviewers, such as known issues, future considerations, etc.
