{
  $Project$
  $Workfile$
  $Revision$
  $DateUTC$
  $Id$

  This file is part of the Indy (Internet Direct) project, and is offered
  under the dual-licensing agreement described on the Indy website.
  (http://www.indyproject.org/)

  Copyright:
   (c) 1993-2005, Chad Z. Hower and the Indy Pit Crew. All rights reserved.
}
{
  $Log$
}
{
  Rev 1.8    28.09.2004 21:38:44  Andreas Hausladen
  commented out unused function ErrMsg

  Rev 1.7    2004-05-07 16:52:50  Mattias
  Minor cleanup

  Rev 1.6    2004-05-07 16:34:36  Mattias
  Implemented  OpenSSL locking callbacks

  Rev 1.5    10/16/03 11:16:44 PM  RLebeau
  Updated to better support C++Builder by adding an $EXTERNSYM define to
  'time_t' so that it won't be included in the auto-generated HPP file.  The
  native time.h header file is used instead.

  Rev 1.4    10/17/2003 1:08:12 AM  DSiders
  Added localization comments.

  Rev 1.3    12/9/2002 12:48:42 PM  JPMugaas
  Fixed stupid compile error for the moment.  The Macros in err.h have to be
  sorted out later.

  Rev 1.1    12/8/2002 07:25:52 PM  JPMugaas
  Added published host and port properties.

  Rev 1.0    11/13/2002 08:01:32 AM  JPMugaas
}
unit IdSSLOpenSSLHeaders;

{
  Author: Gregor Ibic (gregor.ibic@intelicom.si)
  Copyright: (c) Gregor Ibic, Intelicom d.o.o and Indy Working Group.
}
{
Note to self::
===== Win32 with mingw32 ====
Configuring for mingw
    no-camellia     [default]  OPENSSL_NO_CAMELLIA (skip dir)
    no-capieng      [default]  OPENSSL_NO_CAPIENG (skip dir)
    no-cms          [default]  OPENSSL_NO_CMS (skip dir)
    no-gmp          [default]  OPENSSL_NO_GMP (skip dir)
    no-jpake        [experimental] OPENSSL_NO_JPAKE (skip dir)
    no-krb5         [krb5-flavor not specified] OPENSSL_NO_KRB5
    no-mdc2         [default]  OPENSSL_NO_MDC2 (skip dir)
    no-montasm      [default] 
    no-rc5          [default]  OPENSSL_NO_RC5 (skip dir)
    no-rfc3779      [default]  OPENSSL_NO_RFC3779 (skip dir)
    no-seed         [default]  OPENSSL_NO_SEED (skip dir)
    no-shared       [default] 
    no-zlib         [default] 
    no-zlib-dynamic [default] 
IsMK1MF=1
CC            =gcc
CFLAG         =-DOPENSSL_THREADS  -DDSO_WIN32 -mno-cygwin -DL_ENDIAN -fomit-frame-pointer -O3 -march=i486 -Wall -D_WIN32_WINNT=0x333 -DOPENSSL_BN_ASM_PART_WORDS -DOPENSSL_IA32_SSE2 -DSHA1_ASM -DMD5_ASM -DRMD160_ASM -DAES_ASM
EX_LIBS       =-lwsock32 -lgdi32
CPUID_OBJ     =x86cpuid-cof.o
BN_ASM        =bn86-cof.o co86-cof.o 
DES_ENC       =dx86-cof.o yx86-cof.o
AES_ASM_OBJ   =ax86-cof.o
BF_ENC        =bx86-cof.o
CAST_ENC      =cx86-cof.o
RC4_ENC       =rx86-cof.o rc4_skey.o
RC5_ENC       =r586-cof.o
MD5_OBJ_ASM   =mx86-cof.o
SHA1_OBJ_ASM  =sx86-cof.o s512sse2-cof.o
RMD160_OBJ_ASM=rm86-cof.o
PROCESSOR     =
RANLIB        =true
ARFLAGS       =
PERL          =perl
THIRTY_TWO_BIT mode
DES_PTR used
DES_RISC1 used
DES_UNROLL used
BN_LLONG mode
RC4_INDEX mode
RC4_CHUNK is undefined

Configured for mingw.
Generating x86 for GNU assember
Bignum
DES
crypt
Blowfish
CAST5
RC4
MD5
SHA1
RIPEMD160
RC5\32
CPUID
Generating makefile
Generating DLL definition files
Building the libraries
Building OpenSSL
===== Win64 ======
Targeting Windows Server 2003 X64 RETAIL

perl Configure VC-WIN64A

W:\openssl\openssl-0.9.8k>perl Configure VC-WIN64A
Configuring for VC-WIN64A
    no-camellia     [default]  OPENSSL_NO_CAMELLIA (skip dir)
    no-capieng      [default]  OPENSSL_NO_CAPIENG (skip dir)
    no-cms          [default]  OPENSSL_NO_CMS (skip dir)
    no-gmp          [default]  OPENSSL_NO_GMP (skip dir)
    no-jpake        [experimental] OPENSSL_NO_JPAKE (skip dir)
    no-krb5         [krb5-flavor not specified] OPENSSL_NO_KRB5
    no-mdc2         [default]  OPENSSL_NO_MDC2 (skip dir)
    no-montasm      [default]
    no-rc5          [default]  OPENSSL_NO_RC5 (skip dir)
    no-rfc3779      [default]  OPENSSL_NO_RFC3779 (skip dir)
    no-seed         [default]  OPENSSL_NO_SEED (skip dir)
    no-shared       [default]
    no-zlib         [default]
    no-zlib-dynamic [default]
IsMK1MF=1
CC            =cl
CFLAG         =-DOPENSSL_THREADS  -DDSO_WIN32
EX_LIBS       =
CPUID_OBJ     =
BN_ASM        =bn_asm.o
DES_ENC       =des_enc.o fcrypt_b.o
AES_ASM_OBJ   =aes_core.o aes_cbc.o
BF_ENC        =bf_enc.o
CAST_ENC      =c_enc.o
RC4_ENC       =rc4_enc.o rc4_skey.o
RC5_ENC       =rc5_enc.o
MD5_OBJ_ASM   =
SHA1_OBJ_ASM  =
RMD160_OBJ_ASM=
PROCESSOR     =
RANLIB        =true
ARFLAGS       =
PERL          =perl
SIXTY_FOUR_BIT mode
DES_INT used
RC4_CHUNK is unsigned long long

Configured for VC-WIN64A.

W:\openssl\openssl-0.9.8k>ms\do_win64a

W:\openssl\openssl-0.9.8k>perl util\mkfiles.pl  1>MINFO

W:\openssl\openssl-0.9.8k>perl ms\uplink.pl win64a  1>ms\uptable.asm

W:\openssl\openssl-0.9.8k>ml64 -c -Foms\uptable.obj ms\uptable.asm
Microsoft (R) Macro Assembler (AMD64) Version 8.00.40310.39
Copyright (C) Microsoft Corporation.  All rights reserved.

 Assembling: ms\uptable.asm

W:\openssl\openssl-0.9.8k>perl util\mk1mf.pl no-asm VC-WIN64A  1>ms\nt.mak

W:\openssl\openssl-0.9.8k>perl util\mk1mf.pl dll no-asm VC-WIN64A  1>ms\ntdll.ma
k

W:\openssl\openssl-0.9.8k>perl util\mkdef.pl 32 libeay  1>ms\libeay32.def

W:\openssl\openssl-0.9.8k>perl util\mkdef.pl 32 ssleay  1>ms\ssleay32.def

CFLAG= /MD /Ox /W3 /Gs0 /GF /Gy /nologo
-DWIN32_LEAN_AND_MEAN -DL_ENDIAN -DDSO_WIN32 -DOPENSSL_SYSNAME_WIN32
-DOPENSSL_SYSNAME_WINNT -DUNICODE -D_UNICODE -D_CRT_SECURE_NO_DEPRECATE
-D_CRT_NONSTDC_NO_DEPRECATE -DOPENSSL_USE_APPLINK -I. /Fdout32dll
-DOPENSSL_NO_CAMELLIA -DOPENSSL_NO_SEED -DOPENSSL_NO_RC5 -DOPENSSL_NO_MDC2
-DOPENSSL_NO_CMS -DOPENSSL_NO_JPAKE -DOPENSSL_NO_CAPIENG -DOPENSSL_NO_KRB5
-DOPENSSL_NO_DYNAMIC_ENGINE

}

interface

{$I IdCompilerDefines.inc}

{$IFNDEF USE_OPENSSL}
  {$message error Should not compile if USE_OPENSSL is not defined!!!}
{$ENDIF}
{$WRITEABLECONST OFF}

{$IFNDEF FPC}
  {$IFDEF WIN32}
    {$ALIGN OFF}
  {$ENDIF}
  {$IFDEF WIN64}
    {$ALIGN ON}
  {$ENDIF}
  {$IFNDEF WIN32_OR_WIN64}
    {$IFNDEF VCL_CROSS_COMPILE}
      {$message error error alignment!}
    {$ENDIF}
  {$ENDIF}
{$ELSE}
  {$packrecords C}
{$ENDIF}

//THe OpenSSL developers use a IF 0 and an IF 1 convention for selectively
//enabling or disabling things.
{$DEFINE USE_THIS}
{.$DEFINE OMIT_THIS}
{
IMPORTANT!!!!

A lot of IFDEF's and defines have to used because OpenSSL has a number of options'
and those can effect the API.  The options are determined by a "configure" script
that generates apporpriate make files with the appropriate defines.  If you do
custom compiles of OpenSSL or if it's compiled differently that what I assume,
you will need to add or deactivate the defines.

my $x86_gcc_des="DES_PTR DES_RISC1 DES_UNROLL";

# MD2_CHAR slags pentium pros
my $x86_gcc_opts="RC4_INDEX MD2_INT";
...
# This is what $depflags will look like with the above defaults
# (we need this to see if we should advise the user to run "make depend"):
my $default_depflags = " -DOPENSSL_NO_CAMELLIA -DOPENSSL_NO_CAPIENG -DOPENSSL_NO_CMS -DOPENSSL_NO_GMP -DOPENSSL_NO_JPAKE -DOPENSSL_NO_MDC2 -DOPENSSL_NO_RC5 -DOPENSSL_NO_RFC3779 -DOPENSSL_NO_SEED";

}

// # Our development configs
// "purify",	"purify gcc:-g -DPURIFY -Wall::(unknown)::-lsocket -lnsl::::",
// "debug",	"gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DBN_CTX_DEBUG -DCRYPTO_MDEBUG -DOPENSSL_NO_ASM -ggdb -g2 -Wformat -Wshadow -Wmissing-prototypes -Wmissing-declarations -Werror::(unknown)::-lefence::::",
// "debug-ben",	"gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DBN_CTX_DEBUG -DCRYPTO_MDEBUG -DPEDANTIC -DDEBUG_SAFESTACK -O2 -pedantic -Wall -Wshadow -Werror -pipe::(unknown):::::bn86-elf.o co86-elf.o",
// "debug-ben-openbsd","gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DBN_CTX_DEBUG -DCRYPTO_MDEBUG -DPEDANTIC -DDEBUG_SAFESTACK -DOPENSSL_OPENBSD_DEV_CRYPTO -DOPENSSL_NO_ASM -O2 -pedantic -Wall -Wshadow -Werror -pipe::(unknown)::::",
// "debug-ben-openbsd-debug","gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DBN_CTX_DEBUG -DCRYPTO_MDEBUG -DPEDANTIC -DDEBUG_SAFESTACK -DOPENSSL_OPENBSD_DEV_CRYPTO -DOPENSSL_NO_ASM -g3 -O2 -pedantic -Wall -Wshadow -Werror -pipe::(unknown)::::",
// "debug-ben-debug",	"gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DBN_CTX_DEBUG -DCRYPTO_MDEBUG -DPEDANTIC -DDEBUG_SAFESTACK -g3 -O2 -pedantic -Wall -Wshadow -Werror -pipe::(unknown)::::::",
// "debug-ben-strict",	"gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DBN_CTX_DEBUG -DCRYPTO_MDEBUG -DCONST_STRICT -O2 -Wall -Wshadow -Werror -Wpointer-arith -Wcast-qual -Wwrite-strings -pipe::(unknown)::::::",
// "debug-rse","cc:-DTERMIOS -DL_ENDIAN -pipe -O -g -ggdb3 -Wall::(unknown):::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}",
// "debug-bodo",	"gcc:-DL_ENDIAN -DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DBIO_PAIR_DEBUG -DPEDANTIC -g -march=i486 -pedantic -Wshadow -Wall -Wcast-align -Wstrict-prototypes -Wmissing-prototypes -Wno-long-long -Wundef -Wconversion -pipe::-D_REENTRANT:::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}",
// "debug-ulf", "gcc:-DTERMIOS -DL_ENDIAN -march=i486 -Wall -DBN_DEBUG -DBN_DEBUG_RAND -DREF_CHECK -DCONF_DEBUG -DBN_CTX_DEBUG -DCRYPTO_MDEBUG -DOPENSSL_NO_ASM -g -Wformat -Wshadow -Wmissing-prototypes -Wmissing-declarations:::CYGWIN32:::${no_asm}:win32:cygwin-shared:::.dll",
// "debug-steve64", "gcc:-m64 -DL_ENDIAN -DTERMIO -DREF_CHECK -DCONF_DEBUG -DDEBUG_SAFESTACK -DCRYPTO_MDEBUG_ALL -DPEDANTIC -DOPENSSL_NO_DEPRECATED -g -pedantic -Wall -Werror -Wno-long-long -Wsign-compare -DMD32_REG_T=int::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG RC4_CHUNK BF_PTR2 DES_INT DES_UNROLL:${x86_64_asm}:dlfcn:linux-shared:-fPIC:-m64:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-steve32", "gcc:-m32 -DL_ENDIAN -DREF_CHECK -DCONF_DEBUG -DDEBUG_SAFESTACK -DCRYPTO_MDEBUG_ALL -DPEDANTIC -DOPENSSL_NO_DEPRECATED -g -pedantic -Wno-long-long -Wall -Werror -Wshadow -pipe::-D_REENTRANT::-rdynamic -ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:linux-shared:-fPIC:-m32:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-steve",	"gcc:-DL_ENDIAN -DREF_CHECK -DCONF_DEBUG -DDEBUG_SAFESTACK -DCRYPTO_MDEBUG_ALL -DPEDANTIC -m32 -g -pedantic -Wno-long-long -Wall -Werror -Wshadow -pipe::-D_REENTRANT::-rdynamic -ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:linux-shared",
// "debug-steve-opt",	"gcc:-DL_ENDIAN -DREF_CHECK -DCONF_DEBUG -DDEBUG_SAFESTACK -DCRYPTO_MDEBUG_ALL -DPEDANTIC -m32 -O3 -g -pedantic -Wno-long-long -Wall -Werror -Wshadow -pipe::-D_REENTRANT::-rdynamic -ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:linux-shared",
// "debug-steve-linux-pseudo64",	"gcc:-DL_ENDIAN -DREF_CHECK -DCONF_DEBUG -DBN_CTX_DEBUG -DDEBUG_SAFESTACK -DCRYPTO_MDEBUG_ALL -DOPENSSL_NO_ASM -g -mcpu=i486 -Wall -Werror -Wshadow -pipe::-D_REENTRANT::-rdynamic -ldl:SIXTY_FOUR_BIT:${no_asm}:dlfcn:linux-shared",
// "debug-levitte-linux-elf","gcc:-DLEVITTE_DEBUG -DREF_CHECK -DCONF_DEBUG -DBN_DEBUG -DBN_DEBUG_RAND -DCRYPTO_MDEBUG -DENGINE_CONF_DEBUG -DL_ENDIAN -DTERMIO -D_POSIX_SOURCE -DPEDANTIC -ggdb -g3 -mcpu=i486 -pedantic -ansi -Wall -Wshadow -Wcast-align -Wstrict-prototypes -Wmissing-prototypes -Wno-long-long -Wundef -Wconversion -pipe::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-levitte-linux-noasm","gcc:-DLEVITTE_DEBUG -DREF_CHECK -DCONF_DEBUG -DBN_DEBUG -DBN_DEBUG_RAND -DCRYPTO_MDEBUG -DENGINE_CONF_DEBUG -DOPENSSL_NO_ASM -DL_ENDIAN -DTERMIO -D_POSIX_SOURCE -DPEDANTIC -ggdb -g3 -mcpu=i486 -pedantic -ansi -Wall -Wshadow -Wcast-align -Wstrict-prototypes -Wmissing-prototypes -Wno-long-long -Wundef -Wconversion -pipe::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${no_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-levitte-linux-elf-extreme","gcc:-DLEVITTE_DEBUG -DREF_CHECK -DCONF_DEBUG -DBN_DEBUG -DBN_DEBUG_RAND -DCRYPTO_MDEBUG -DENGINE_CONF_DEBUG -DL_ENDIAN -DTERMIO -D_POSIX_SOURCE -DPEDANTIC -ggdb -g3 -mcpu=i486 -pedantic -ansi -Wall -W -Wundef -Wshadow -Wcast-align -Wstrict-prototypes -Wmissing-prototypes -Wno-long-long -Wundef -Wconversion -pipe::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-levitte-linux-noasm-extreme","gcc:-DLEVITTE_DEBUG -DREF_CHECK -DCONF_DEBUG -DBN_DEBUG -DBN_DEBUG_RAND -DCRYPTO_MDEBUG -DENGINE_CONF_DEBUG -DOPENSSL_NO_ASM -DL_ENDIAN -DTERMIO -D_POSIX_SOURCE -DPEDANTIC -ggdb -g3 -mcpu=i486 -pedantic -ansi -Wall -W -Wundef -Wshadow -Wcast-align -Wstrict-prototypes -Wmissing-prototypes -Wno-long-long -Wundef -Wconversion -pipe::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${no_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-geoff","gcc:-DBN_DEBUG -DBN_DEBUG_RAND -DBN_STRICT -DPURIFY -DOPENSSL_NO_DEPRECATED -DOPENSSL_NO_ASM -DOPENSSL_NO_INLINE_ASM -DL_ENDIAN -DTERMIO -DPEDANTIC -O1 -ggdb2 -Wall -Werror -Wundef -pedantic -Wshadow -Wpointer-arith -Wbad-function-cast -Wcast-align -Wsign-compare -Wmissing-prototypes -Wmissing-declarations -Wno-long-long::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${no_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-linux-pentium","gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG -DL_ENDIAN -DTERMIO -g -mcpu=pentium -Wall::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn",
// "debug-linux-ppro","gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG -DL_ENDIAN -DTERMIO -g -mcpu=pentiumpro -Wall::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn",
// "debug-linux-elf","gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG -DL_ENDIAN -DTERMIO -g -march=i486 -Wall::-D_REENTRANT::-lefence -ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-linux-elf-noefence","gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG -DL_ENDIAN -DTERMIO -g -march=i486 -Wall::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "dist",		"cc:-O::(unknown)::::::",

// # Basic configs that should work on any (32 and less bit) box
// "gcc",		"gcc:-O3::(unknown):::BN_LLONG:::",
// "cc",		"cc:-O::(unknown)::::::",

// ####VOS Configurations
// "vos-gcc","gcc:-O3 -Wall -D_POSIX_C_SOURCE=200112L -D_BSD -DB_ENDIAN::(unknown):VOS:-Wl,-map:BN_LLONG:${no_asm}:::::.so:",
// "debug-vos-gcc","gcc:-O0 -g -Wall -D_POSIX_C_SOURCE=200112L -D_BSD -DB_ENDIAN -DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG::(unknown):VOS:-Wl,-map:BN_LLONG:${no_asm}:::::.so:",

// #### Solaris x86 with GNU C setups
// # -DOPENSSL_NO_INLINE_ASM switches off inline assembler. We have to do it
// # here because whenever GNU C instantiates an assembler template it
// # surrounds it with #APP #NO_APP comment pair which (at least Solaris
// # 7_x86) /usr/ccs/bin/as fails to assemble with "Illegal mnemonic"
// # error message.
// "solaris-x86-gcc","gcc:-O3 -fomit-frame-pointer -march=pentium -Wall -DL_ENDIAN -DOPENSSL_NO_INLINE_ASM::-D_REENTRANT::-lsocket -lnsl -ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:solaris-shared:-fPIC:-shared:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// # -shared -static-libgcc might appear controversial, but modules taken
// # from static libgcc do not have relocations and linking them into our
// # shared objects doesn't have any negative side-effects. On the contrary,
// # doing so makes it possible to use gcc shared build with Sun C. Given
// # that gcc generates faster code [thanks to inline assembler], I would
// # actually recommend to consider using gcc shared build even with vendor
// # compiler:-)
// #						<appro@fy.chalmers.se>
// "solaris64-x86_64-gcc","gcc:-m64 -O3 -Wall -DL_ENDIAN -DMD32_REG_T=int::-D_REENTRANT::-lsocket -lnsl -ldl:SIXTY_FOUR_BIT_LONG RC4_CHUNK BF_PTR2 DES_INT DES_UNROLL:${x86_64_asm}:dlfcn:solaris-shared:-fPIC:-m64 -shared -static-libgcc:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
//
// #### Solaris x86 with Sun C setups
// "solaris-x86-cc","cc:-fast -O -Xa::-D_REENTRANT::-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_PTR DES_UNROLL BF_PTR:${no_asm}:dlfcn:solaris-shared:-KPIC:-G -dy -z text:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "solaris64-x86_64-cc","cc:-fast -xarch=amd64 -xstrconst -Xa -DL_ENDIAN::-D_REENTRANT::-lsocket -lnsl -ldl:SIXTY_FOUR_BIT_LONG RC4_CHUNK BF_PTR2 DES_INT DES_UNROLL:${x86_64_asm}:dlfcn:solaris-shared:-KPIC:-xarch=amd64 -G -dy -z text:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// #### SPARC Solaris with GNU C setups
// "solaris-sparcv7-gcc","gcc:-O3 -fomit-frame-pointer -Wall -DB_ENDIAN -DBN_DIV2W::-D_REENTRANT::-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR:${no_asm}:dlfcn:solaris-shared:-fPIC:-shared:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "solaris-sparcv8-gcc","gcc:-mv8 -O3 -fomit-frame-pointer -Wall -DB_ENDIAN -DBN_DIV2W::-D_REENTRANT::-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::sparcv8.o:des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:solaris-shared:-fPIC:-shared:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// # -m32 should be safe to add as long as driver recognizes -mcpu=ultrasparc
// "solaris-sparcv9-gcc","gcc:-m32 -mcpu=ultrasparc -O3 -fomit-frame-pointer -Wall -DB_ENDIAN -DBN_DIV2W::-D_REENTRANT:ULTRASPARC:-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::sparcv8plus.o:des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:solaris-shared:-fPIC:-shared:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "solaris64-sparcv9-gcc","gcc:-m64 -mcpu=ultrasparc -O3 -Wall -DB_ENDIAN::-D_REENTRANT:ULTRASPARC:-lsocket -lnsl -ldl:SIXTY_FOUR_BIT_LONG RC4_CHAR RC4_CHUNK DES_INT DES_PTR DES_RISC1 DES_UNROLL BF_PTR:::des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:solaris-shared:-fPIC:-m64 -shared:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// ####
// "debug-solaris-sparcv8-gcc","gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG_ALL -O -g -mv8 -Wall -DB_ENDIAN::-D_REENTRANT::-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::sparcv8.o::::::::::dlfcn:solaris-shared:-fPIC:-shared:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-solaris-sparcv9-gcc","gcc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG_ALL -DPEDANTIC -O -g -mcpu=ultrasparc -pedantic -ansi -Wall -Wshadow -Wno-long-long -D__EXTENSIONS__ -DB_ENDIAN -DBN_DIV2W::-D_REENTRANT:ULTRASPARC:-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::sparcv8plus.o:des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:solaris-shared:-fPIC:-shared:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// #### SPARC Solaris with Sun C setups
// # SC4.0 doesn't pass 'make test', upgrade to SC5.0 or SC4.2.
// # SC4.2 is ok, better than gcc even on bn as long as you tell it -xarch=v8
// # SC5.0 note: Compiler common patch 107357-01 or later is required!
// "solaris-sparcv7-cc","cc:-xO5 -xstrconst -xdepend -Xa -DB_ENDIAN -DBN_DIV2W::-D_REENTRANT::-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_PTR DES_RISC1 DES_UNROLL BF_PTR:${no_asm}:dlfcn:solaris-shared:-KPIC:-G -dy -z text:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "solaris-sparcv8-cc","cc:-xarch=v8 -xO5 -xstrconst -xdepend -Xa -DB_ENDIAN -DBN_DIV2W::-D_REENTRANT::-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_PTR DES_RISC1 DES_UNROLL BF_PTR::sparcv8.o:des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:solaris-shared:-KPIC:-G -dy -z text:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "solaris-sparcv9-cc","cc:-xtarget=ultra -xarch=v8plus -xO5 -xstrconst -xdepend -Xa -DB_ENDIAN -DBN_DIV2W::-D_REENTRANT:ULTRASPARC:-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK_LL DES_PTR DES_RISC1 DES_UNROLL BF_PTR::sparcv8plus.o:des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:solaris-shared:-KPIC:-G -dy -z text:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "solaris64-sparcv9-cc","cc:-xtarget=ultra -xarch=v9 -xO5 -xstrconst -xdepend -Xa -DB_ENDIAN::-D_REENTRANT:ULTRASPARC:-lsocket -lnsl -ldl:SIXTY_FOUR_BIT_LONG RC4_CHAR RC4_CHUNK DES_INT DES_PTR DES_RISC1 DES_UNROLL BF_PTR:::des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:solaris-shared:-KPIC:-xarch=v9 -G -dy -z text:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR):/usr/ccs/bin/ar rs",
// ####
// "debug-solaris-sparcv8-cc","cc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG_ALL -xarch=v8 -g -O -xstrconst -Xa -DB_ENDIAN -DBN_DIV2W::-D_REENTRANT::-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_PTR DES_RISC1 DES_UNROLL BF_PTR::sparcv8.o::::::::::dlfcn:solaris-shared:-KPIC:-G -dy -z text:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-solaris-sparcv9-cc","cc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG_ALL -xtarget=ultra -xarch=v8plus -g -O -xstrconst -Xa -DB_ENDIAN -DBN_DIV2W::-D_REENTRANT:ULTRASPARC:-lsocket -lnsl -ldl:BN_LLONG RC4_CHAR RC4_CHUNK_LL DES_PTR DES_RISC1 DES_UNROLL BF_PTR::sparcv8plus.o::::::::::dlfcn:solaris-shared:-KPIC:-G -dy -z text:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// #### SunOS configs, assuming sparc for the gcc one.
// #"sunos-cc", "cc:-O4 -DNOPROTO -DNOCONST::(unknown):SUNOS::DES_UNROLL:${no_asm}::",
// "sunos-gcc","gcc:-O3 -mv8 -Dssize_t=int::(unknown):SUNOS::BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL DES_PTR DES_RISC1:${no_asm}::",

// #### IRIX 5.x configs
// # -mips2 flag is added by ./config when appropriate.
// "irix-gcc","gcc:-O3 -DTERMIOS -DB_ENDIAN::(unknown):::BN_LLONG MD2_CHAR RC4_INDEX RC4_CHAR RC4_CHUNK DES_UNROLL DES_RISC2 DES_PTR BF_PTR:${no_asm}:dlfcn:irix-shared:::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "irix-cc", "cc:-O2 -use_readonly_const -DTERMIOS -DB_ENDIAN::(unknown):::BN_LLONG RC4_CHAR RC4_CHUNK DES_PTR DES_RISC2 DES_UNROLL BF_PTR:${no_asm}:dlfcn:irix-shared:::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// #### IRIX 6.x configs
// # Only N32 and N64 ABIs are supported. If you need O32 ABI build, invoke
// # './Configure irix-cc -o32' manually.
// "irix-mips3-gcc","gcc:-mabi=n32 -O3 -DTERMIOS -DB_ENDIAN -DBN_DIV3W::-D_SGI_MP_SOURCE:::MD2_CHAR RC4_INDEX RC4_CHAR RC4_CHUNK_LL DES_UNROLL DES_RISC2 DES_PTR BF_PTR SIXTY_FOUR_BIT::bn-mips3.o::::::::::dlfcn:irix-shared::-mabi=n32:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "irix-mips3-cc", "cc:-n32 -mips3 -O2 -use_readonly_const -G0 -rdata_shared -DTERMIOS -DB_ENDIAN -DBN_DIV3W::-D_SGI_MP_SOURCE:::DES_PTR RC4_CHAR RC4_CHUNK_LL DES_RISC2 DES_UNROLL BF_PTR SIXTY_FOUR_BIT::bn-mips3.o::::::::::dlfcn:irix-shared::-n32:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// # N64 ABI builds.
// "irix64-mips4-gcc","gcc:-mabi=64 -mips4 -O3 -DTERMIOS -DB_ENDIAN -DBN_DIV3W::-D_SGI_MP_SOURCE:::RC4_CHAR RC4_CHUNK DES_RISC2 DES_UNROLL SIXTY_FOUR_BIT_LONG::bn-mips3.o::::::::::dlfcn:irix-shared::-mabi=64:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "irix64-mips4-cc", "cc:-64 -mips4 -O2 -use_readonly_const -G0 -rdata_shared -DTERMIOS -DB_ENDIAN -DBN_DIV3W::-D_SGI_MP_SOURCE:::RC4_CHAR RC4_CHUNK DES_RISC2 DES_UNROLL SIXTY_FOUR_BIT_LONG::bn-mips3.o::::::::::dlfcn:irix-shared::-64:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// #### Unified HP-UX ANSI C configs.
// # Special notes:
// # - Originally we were optimizing at +O4 level. It should be noted
// #   that the only difference between +O3 and +O4 is global inter-
// #   procedural analysis. As it has to be performed during the link
// #   stage the compiler leaves behind certain pseudo-code in lib*.a
// #   which might be release or even patch level specific. Generating
// #   the machine code for and analyzing the *whole* program appears
// #   to be *extremely* memory demanding while the performance gain is
// #   actually questionable. The situation is intensified by the default
// #   HP-UX data set size limit (infamous 'maxdsiz' tunable) of 64MB
// #   which is way too low for +O4. In other words, doesn't +O3 make
// #   more sense?
// # - Keep in mind that the HP compiler by default generates code
// #   suitable for execution on the host you're currently compiling at.
// #   If the toolkit is ment to be used on various PA-RISC processors
// #   consider './config +DAportable'.
// # - +DD64 is chosen in favour of +DA2.0W because it's meant to be
// #   compatible with *future* releases.
// # - If you run ./Configure hpux-parisc-[g]cc manually don't forget to
// #   pass -D_REENTRANT on HP-UX 10 and later.
// # - -DMD32_XARRAY triggers workaround for compiler bug we ran into in
// #   32-bit message digests. (For the moment of this writing) HP C
// #   doesn't seem to "digest" too many local variables (they make "him"
// #   chew forever:-). For more details look-up MD32_XARRAY comment in
// #   crypto/sha/sha_lcl.h.
// #					<appro@fy.chalmers.se>
// #
// # Since there is mention of this in shlib/hpux10-cc.sh
// "hpux-parisc-cc-o4","cc:-Ae +O4 +ESlit -z -DB_ENDIAN -DBN_DIV2W -DMD32_XARRAY::-D_REENTRANT::-ldld:BN_LLONG DES_PTR DES_UNROLL DES_RISC1:${no_asm}:dl:hpux-shared:+Z:-b:.sl.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "hpux-parisc-gcc","gcc:-O3 -DB_ENDIAN -DBN_DIV2W::-D_REENTRANT::-Wl,+s -ldld:BN_LLONG DES_PTR DES_UNROLL DES_RISC1:${no_asm}:dl:hpux-shared:-fPIC:-shared:.sl.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "hpux-parisc2-gcc","gcc:-march=2.0 -O3 -DB_ENDIAN -D_REENTRANT::::-Wl,+s -ldld:SIXTY_FOUR_BIT RC4_CHAR RC4_CHUNK DES_PTR DES_UNROLL DES_RISC1::pa-risc2.o::::::::::dl:hpux-shared:-fPIC:-shared:.sl.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "hpux64-parisc2-gcc","gcc:-O3 -DB_ENDIAN -D_REENTRANT::::-ldl:SIXTY_FOUR_BIT_LONG MD2_CHAR RC4_INDEX RC4_CHAR DES_UNROLL DES_RISC1 DES_INT::pa-risc2W.o::::::::::dlfcn:hpux-shared:-fpic:-shared:.sl.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// # More attempts at unified 10.X and 11.X targets for HP C compiler.
// #
// # Chris Ruemmler <ruemmler@cup.hp.com>
// # Kevin Steves <ks@hp.se>
// "hpux-parisc-cc","cc:+O3 +Optrs_strongly_typed -Ae +ESlit -DB_ENDIAN -DBN_DIV2W -DMD32_XARRAY::-D_REENTRANT::-Wl,+s -ldld:MD2_CHAR RC4_INDEX RC4_CHAR DES_UNROLL DES_RISC1 DES_INT:${no_asm}:dl:hpux-shared:+Z:-b:.sl.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "hpux-parisc1_0-cc","cc:+DAportable +O3 +Optrs_strongly_typed -Ae +ESlit -DB_ENDIAN -DMD32_XARRAY::-D_REENTRANT::-Wl,+s -ldld:MD2_CHAR RC4_INDEX RC4_CHAR DES_UNROLL DES_RISC1 DES_INT:${no_asm}:dl:hpux-shared:+Z:-b:.sl.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "hpux-parisc2-cc","cc:+DA2.0 +DS2.0 +O3 +Optrs_strongly_typed -Ae +ESlit -DB_ENDIAN -DMD32_XARRAY -D_REENTRANT::::-Wl,+s -ldld:SIXTY_FOUR_BIT MD2_CHAR RC4_INDEX RC4_CHAR DES_UNROLL DES_RISC1 DES_INT::pa-risc2.o::::::::::dl:hpux-shared:+Z:-b:.sl.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "hpux64-parisc2-cc","cc:+DD64 +O3 +Optrs_strongly_typed -Ae +ESlit -DB_ENDIAN -DMD32_XARRAY -D_REENTRANT::::-ldl:SIXTY_FOUR_BIT_LONG MD2_CHAR RC4_INDEX RC4_CHAR DES_UNROLL DES_RISC1 DES_INT::pa-risc2W.o::::::::::dlfcn:hpux-shared:+Z:+DD64 -b:.sl.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// # HP/UX IA-64 targets
// "hpux-ia64-cc","cc:-Ae +DD32 +O2 +Olit=all -z -DB_ENDIAN -D_REENTRANT::::-ldl:SIXTY_FOUR_BIT MD2_CHAR RC4_INDEX DES_UNROLL DES_RISC1 DES_INT:${ia64_asm}:dlfcn:hpux-shared:+Z:+DD32 -b:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// # Frank Geurts <frank.geurts@nl.abnamro.com> has patiently assisted with
// # with debugging of the following config.
// "hpux64-ia64-cc","cc:-Ae +DD64 +O3 +Olit=all -z -DB_ENDIAN -D_REENTRANT::::-ldl:SIXTY_FOUR_BIT_LONG MD2_CHAR RC4_INDEX DES_UNROLL DES_RISC1 DES_INT:${ia64_asm}:dlfcn:hpux-shared:+Z:+DD64 -b:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// # GCC builds...
// "hpux-ia64-gcc","gcc:-O3 -DB_ENDIAN -D_REENTRANT::::-ldl:SIXTY_FOUR_BIT MD2_CHAR RC4_INDEX DES_UNROLL DES_RISC1 DES_INT:${ia64_asm}:dlfcn:hpux-shared:-fpic:-shared:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "hpux64-ia64-gcc","gcc:-mlp64 -O3 -DB_ENDIAN -D_REENTRANT::::-ldl:SIXTY_FOUR_BIT_LONG MD2_CHAR RC4_INDEX DES_UNROLL DES_RISC1 DES_INT:${ia64_asm}:dlfcn:hpux-shared:-fpic:-mlp64 -shared:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// # Legacy HPUX 9.X configs...
// "hpux-cc",	"cc:-DB_ENDIAN -DBN_DIV2W -DMD32_XARRAY -Ae +ESlit +O2 -z::(unknown)::-Wl,+s -ldld:DES_PTR DES_UNROLL DES_RISC1:${no_asm}:dl:hpux-shared:+Z:-b:.sl.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "hpux-gcc",	"gcc:-DB_ENDIAN -DBN_DIV2W -O3::(unknown)::-Wl,+s -ldld:DES_PTR DES_UNROLL DES_RISC1:${no_asm}:dl:hpux-shared:-fPIC:-shared:.sl.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// #### HP MPE/iX http://jazz.external.hp.com/src/openssl/
// "MPE/iX-gcc",	"gcc:-D_ENDIAN -DBN_DIV2W -O3 -D_POSIX_SOURCE -D_SOCKET_SOURCE -I/SYSLOG/PUB::(unknown):MPE:-L/SYSLOG/PUB -lsyslog -lsocket -lcurses:BN_LLONG DES_PTR DES_UNROLL DES_RISC1:::",

// # DEC Alpha OSF/1/Tru64 targets.
// #
// #	"What's in a name? That which we call a rose
// #	 By any other word would smell as sweet."
// #
// # - William Shakespeare, "Romeo & Juliet", Act II, scene II.
// #
// # For gcc, the following gave a %50 speedup on a 164 over the 'DES_INT' version
// #
// "osf1-alpha-gcc", "gcc:-O3::(unknown):::SIXTY_FOUR_BIT_LONG RC4_CHUNK DES_UNROLL DES_RISC1:${no_asm}:dlfcn:alpha-osf1-shared:::.so",
// "osf1-alpha-cc",  "cc:-std1 -tune host -O4 -readonly_strings::(unknown):::SIXTY_FOUR_BIT_LONG RC4_CHUNK:${no_asm}:dlfcn:alpha-osf1-shared:::.so",
// "tru64-alpha-cc", "cc:-std1 -tune host -fast -readonly_strings::-pthread:::SIXTY_FOUR_BIT_LONG RC4_CHUNK:${no_asm}:dlfcn:alpha-osf1-shared::-msym:.so",

// ####
// #### Variety of LINUX:-)
// ####
// # *-generic* is endian-neutral target, but ./config is free to
// # throw in -D[BL]_ENDIAN, whichever appropriate...
// "linux-generic32","gcc:-DTERMIO -O3 -fomit-frame-pointer -Wall::-D_REENTRANT::-ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_INT DES_UNROLL BF_PTR:${no_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "linux-ppc",	"gcc:-DB_ENDIAN -DTERMIO -O3 -Wall::-D_REENTRANT::-ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_RISC1 DES_UNROLL::linux_ppc32.o::::::::::dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// #### IA-32 targets...
// "linux-ia32-icc",	"icc:-DL_ENDIAN -DTERMIO -O2 -no_cpprt::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:linux-shared:-KPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "linux-elf",	"gcc:-DL_ENDIAN -DTERMIO -O3 -fomit-frame-pointer -Wall::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "linux-aout",	"gcc:-DL_ENDIAN -DTERMIO -O3 -fomit-frame-pointer -march=i486 -Wall::(unknown):::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_out_asm}",
// ####
// "linux-generic64","gcc:-DTERMIO -O3 -Wall::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG RC4_CHAR RC4_CHUNK DES_INT DES_UNROLL BF_PTR:${no_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "linux-ppc64",	"gcc:-m64 -DB_ENDIAN -DTERMIO -O3 -Wall::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG RC4_CHAR RC4_CHUNK DES_RISC1 DES_UNROLL::linux_ppc64.o::::::::::dlfcn:linux-shared:-fPIC:-m64:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "linux-ia64",	"gcc:-DL_ENDIAN -DTERMIO -O3 -Wall::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG RC4_CHUNK:${ia64_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "linux-ia64-ecc","ecc:-DL_ENDIAN -DTERMIO -O2 -Wall -no_cpprt::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG RC4_CHUNK:${ia64_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "linux-ia64-icc","icc:-DL_ENDIAN -DTERMIO -O2 -Wall -no_cpprt::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG RC4_CHUNK:${ia64_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "linux-x86_64",	"gcc:-m64 -DL_ENDIAN -DTERMIO -O3 -Wall -DMD32_REG_T=int::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG RC4_CHUNK BF_PTR2 DES_INT DES_UNROLL:${x86_64_asm}:dlfcn:linux-shared:-fPIC:-m64:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// #### SPARC Linux setups
// # Ray Miller <ray.miller@computing-services.oxford.ac.uk> has patiently
// # assisted with debugging of following two configs.
// "linux-sparcv8","gcc:-mv8 -DB_ENDIAN -DTERMIO -O3 -fomit-frame-pointer -Wall -DBN_DIV2W::-D_REENTRANT::-ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::sparcv8.o:des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// # it's a real mess with -mcpu=ultrasparc option under Linux, but
// # -Wa,-Av8plus should do the trick no matter what.
// "linux-sparcv9","gcc:-m32 -mcpu=ultrasparc -DB_ENDIAN -DTERMIO -O3 -fomit-frame-pointer -Wall -Wa,-Av8plus -DBN_DIV2W::-D_REENTRANT:ULTRASPARC:-ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::sparcv8plus.o:des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:linux-shared:-fPIC:-m32:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// # GCC 3.1 is a requirement
// "linux64-sparcv9","gcc:-m64 -mcpu=ultrasparc -DB_ENDIAN -DTERMIO -O3 -fomit-frame-pointer -Wall::-D_REENTRANT:ULTRASPARC:-ldl:SIXTY_FOUR_BIT_LONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::::::::::::dlfcn:linux-shared:-fPIC:-m64:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// #### Alpha Linux with GNU C and Compaq C setups
// # Special notes:
// # - linux-alpha+bwx-gcc is ment to be used from ./config only. If you
// #   ought to run './Configure linux-alpha+bwx-gcc' manually, do
// #   complement the command line with -mcpu=ev56, -mcpu=ev6 or whatever
// #   which is appropriate.
// # - If you use ccc keep in mind that -fast implies -arch host and the
// #   compiler is free to issue instructions which gonna make elder CPU
// #   choke. If you wish to build "blended" toolkit, add -arch generic
// #   *after* -fast and invoke './Configure linux-alpha-ccc' manually.
// #
// #					<appro@fy.chalmers.se>
// #
// "linux-alpha-gcc","gcc:-O3 -DL_ENDIAN -DTERMIO::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG RC4_CHUNK DES_RISC1 DES_UNROLL:${no_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "linux-alpha+bwx-gcc","gcc:-O3 -DL_ENDIAN -DTERMIO::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG RC4_CHAR RC4_CHUNK DES_RISC1 DES_UNROLL:${no_asm}:dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "linux-alpha-ccc","ccc:-fast -readonly_strings -DL_ENDIAN -DTERMIO::-D_REENTRANT:::SIXTY_FOUR_BIT_LONG RC4_CHUNK DES_INT DES_PTR DES_RISC1 DES_UNROLL:${no_asm}",
// "linux-alpha+bwx-ccc","ccc:-fast -readonly_strings -DL_ENDIAN -DTERMIO::-D_REENTRANT:::SIXTY_FOUR_BIT_LONG RC4_CHAR RC4_CHUNK DES_INT DES_PTR DES_RISC1 DES_UNROLL:${no_asm}",

// #### *BSD [do see comment about ${BSDthreads} above!]
// "BSD-generic32","gcc:-DTERMIOS -O3 -fomit-frame-pointer -Wall::${BSDthreads}:::BN_LLONG RC2_CHAR RC4_INDEX DES_INT DES_UNROLL:${no_asm}:dlfcn:bsd-gcc-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "BSD-x86",	"gcc:-DL_ENDIAN -DTERMIOS -O3 -fomit-frame-pointer -Wall::${BSDthreads}:::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_out_asm}:dlfcn:bsd-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "BSD-x86-elf",	"gcc:-DL_ENDIAN -DTERMIOS -O3 -fomit-frame-pointer -Wall::${BSDthreads}:::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:bsd-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "debug-BSD-x86-elf",	"gcc:-DL_ENDIAN -DTERMIOS -O3 -Wall -g::${BSDthreads}:::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:bsd-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "BSD-sparcv8",	"gcc:-DB_ENDIAN -DTERMIOS -O3 -mv8 -Wall::${BSDthreads}:::BN_LLONG RC2_CHAR RC4_INDEX DES_INT DES_UNROLL::sparcv8.o:des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:bsd-gcc-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// "BSD-generic64","gcc:-DTERMIOS -O3 -Wall::${BSDthreads}:::SIXTY_FOUR_BIT_LONG RC4_CHUNK DES_INT DES_UNROLL:${no_asm}:dlfcn:bsd-gcc-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// # -DMD32_REG_T=int doesn't actually belong in sparc64 target, it
// # simply *happens* to work around a compiler bug in gcc 3.3.3,
// # triggered by RIPEMD160 code.
// "BSD-sparc64",	"gcc:-DB_ENDIAN -DTERMIOS -O3 -DMD32_REG_T=int -Wall::${BSDthreads}:::SIXTY_FOUR_BIT_LONG RC2_CHAR RC4_CHUNK DES_INT DES_PTR DES_RISC2 BF_PTR:::des_enc-sparc.o fcrypt_b.o:::::::::dlfcn:bsd-gcc-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "BSD-ia64",	"gcc:-DL_ENDIAN -DTERMIOS -O3 -Wall::${BSDthreads}:::SIXTY_FOUR_BIT_LONG RC4_CHUNK:${ia64_asm}:dlfcn:bsd-gcc-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "BSD-x86_64",	"gcc:-DL_ENDIAN -DTERMIOS -O3 -DMD32_REG_T=int -Wall::${BSDthreads}:::SIXTY_FOUR_BIT_LONG RC4_CHUNK DES_INT DES_UNROLL:${x86_64_asm}:dlfcn:bsd-gcc-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// "bsdi-elf-gcc",     "gcc:-DPERL5 -DL_ENDIAN -fomit-frame-pointer -O3 -march=i486 -Wall::(unknown)::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:bsd-gcc-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// "nextstep",	"cc:-O -Wall:<libc.h>:(unknown):::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:::",
// "nextstep3.3",	"cc:-O3 -Wall:<libc.h>:(unknown):::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:::",

// # NCR MP-RAS UNIX ver 02.03.01
// "ncr-scde","cc:-O6 -Xa -Hoff=BEHAVED -686 -Hwide -Hiw::(unknown)::-lsocket -lnsl -lc89:${x86_gcc_des} ${x86_gcc_opts}:::",

// # QNX
// "qnx4",	"cc:-DL_ENDIAN -DTERMIO::(unknown):::${x86_gcc_des} ${x86_gcc_opts}:",
// "qnx6",	"cc:-DL_ENDIAN -DTERMIOS::(unknown)::-lsocket:${x86_gcc_des} ${x86_gcc_opts}:",

// #### SCO/Caldera targets.
// #
// # Originally we had like unixware-*, unixware-*-pentium, unixware-*-p6, etc.
// # Now we only have blended unixware-* as it's the only one used by ./config.
// # If you want to optimize for particular microarchitecture, bypass ./config
// # and './Configure unixware-7 -Kpentium_pro' or whatever appropriate.
// # Note that not all targets include assembler support. Mostly because of
// # lack of motivation to support out-of-date platforms with out-of-date
// # compiler drivers and assemblers. Tim Rice <tim@multitalents.net> has
// # patiently assisted to debug most of it.
// #
// # UnixWare 2.0x fails destest with -O.
// "unixware-2.0","cc:-DFILIO_H -DNO_STRINGS_H::-Kthread::-lsocket -lnsl -lresolv -lx:${x86_gcc_des} ${x86_gcc_opts}:::",
// "unixware-2.1","cc:-O -DFILIO_H::-Kthread::-lsocket -lnsl -lresolv -lx:${x86_gcc_des} ${x86_gcc_opts}:::",
// "unixware-7","cc:-O -DFILIO_H -Kalloca::-Kthread::-lsocket -lnsl:BN_LLONG MD2_CHAR RC4_INDEX ${x86_gcc_des}:${x86_elf_asm}:dlfcn:svr5-shared:-Kpic::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "unixware-7-gcc","gcc:-DL_ENDIAN -DFILIO_H -O3 -fomit-frame-pointer -march=pentium -Wall::-D_REENTRANT::-lsocket -lnsl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:gnu-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// # SCO 5 - Ben Laurie <ben@algroup.co.uk> says the -O breaks the SCO cc.
// "sco5-cc",  "cc:-belf::(unknown)::-lsocket -lnsl:${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:svr3-shared:-Kpic::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "sco5-gcc",  "gcc:-O3 -fomit-frame-pointer::(unknown)::-lsocket -lnsl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:svr3-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",

// #### IBM's AIX.
// "aix3-cc",  "cc:-O -DB_ENDIAN -qmaxmem=16384::(unknown):AIX::BN_LLONG RC4_CHAR:::",
// "aix-gcc",  "gcc:-O -DB_ENDIAN::-pthread:AIX::BN_LLONG RC4_CHAR::aix_ppc32.o::::::::::dlfcn:aix-shared::-shared -Wl,-G:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)::-X 32",
// "aix64-gcc","gcc:-maix64 -O -DB_ENDIAN::-pthread:AIX::SIXTY_FOUR_BIT_LONG RC4_CHAR::aix_ppc64.o::::::::::dlfcn:aix-shared::-maix64 -shared -Wl,-G:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)::-X64",
// # Below targets assume AIX 5. Idea is to effectively disregard $OBJECT_MODE
// # at build time. $OBJECT_MODE is respected at ./config stage!
// "aix-cc",   "cc:-q32 -O -DB_ENDIAN -qmaxmem=16384 -qro -qroconst::-qthreaded:AIX::BN_LLONG RC4_CHAR::aix_ppc32.o::::::::::dlfcn:aix-shared::-q32 -G:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)::-X 32",
// "aix64-cc", "cc:-q64 -O -DB_ENDIAN -qmaxmem=16384 -qro -qroconst::-qthreaded:AIX::SIXTY_FOUR_BIT_LONG RC4_CHAR::aix_ppc64.o::::::::::dlfcn:aix-shared::-q64 -G:.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)::-X 64",

// #
// # Cray T90 and similar (SDSC)
// # It's Big-endian, but the algorithms work properly when B_ENDIAN is NOT
// # defined.  The T90 ints and longs are 8 bytes long, and apparently the
// # B_ENDIAN code assumes 4 byte ints.  Fortunately, the non-B_ENDIAN and
// # non L_ENDIAN code aligns the bytes in each word correctly.
// #
// # The BIT_FIELD_LIMITS define is to avoid two fatal compiler errors:
// #'Taking the address of a bit field is not allowed. '
// #'An expression with bit field exists as the operand of "sizeof" '
// # (written by Wayne Schroeder <schroede@SDSC.EDU>)
// #
// # j90 is considered the base machine type for unicos machines,
// # so this configuration is now called "cray-j90" ...
// "cray-j90", "cc: -DBIT_FIELD_LIMITS -DTERMIOS::(unknown):CRAY::SIXTY_FOUR_BIT_LONG DES_INT:::",

// #
// # Cray T3E (Research Center Juelich, beckman@acl.lanl.gov)
// #
// # The BIT_FIELD_LIMITS define was written for the C90 (it seems).  I added
// # another use.  Basically, the problem is that the T3E uses some bit fields
// # for some st_addr stuff, and then sizeof and address-of fails
// # I could not use the ams/alpha.o option because the Cray assembler, 'cam'
// # did not like it.
// "cray-t3e", "cc: -DBIT_FIELD_LIMITS -DTERMIOS::(unknown):CRAY::SIXTY_FOUR_BIT_LONG RC4_CHUNK DES_INT:::",

// # DGUX, 88100.
// "dgux-R3-gcc",	"gcc:-O3 -fomit-frame-pointer::(unknown):::RC4_INDEX DES_UNROLL:::",
// "dgux-R4-gcc",	"gcc:-O3 -fomit-frame-pointer::(unknown)::-lnsl -lsocket:RC4_INDEX DES_UNROLL:::",
// "dgux-R4-x86-gcc",	"gcc:-O3 -fomit-frame-pointer -DL_ENDIAN::(unknown)::-lnsl -lsocket:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}",

// # Sinix/ReliantUNIX RM400
// # NOTE: The CDS++ Compiler up to V2.0Bsomething has the IRIX_CC_BUG optimizer problem. Better use -g  */
// "ReliantUNIX","cc:-KPIC -g -DTERMIOS -DB_ENDIAN::-Kthread:SNI:-lsocket -lnsl -lc -L/usr/ucblib -lucb:BN_LLONG DES_PTR DES_RISC2 DES_UNROLL BF_PTR:${no_asm}:dlfcn:reliantunix-shared:::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)",
// "SINIX","cc:-O::(unknown):SNI:-lsocket -lnsl -lc -L/usr/ucblib -lucb:RC4_INDEX RC4_CHAR:::",
// "SINIX-N","/usr/ucb/cc:-O2 -misaligned::(unknown)::-lucb:RC4_INDEX RC4_CHAR:::",

// # SIEMENS BS2000/OSD: an EBCDIC-based mainframe
// "BS2000-OSD","c89:-O -XLLML -XLLMK -XL -DB_ENDIAN -DTERMIOS -DCHARSET_EBCDIC::(unknown)::-lsocket -lnsl:THIRTY_TWO_BIT DES_PTR DES_UNROLL MD2_CHAR RC4_INDEX RC4_CHAR BF_PTR:::",

// # OS/390 Unix an EBCDIC-based Unix system on IBM mainframe
// # You need to compile using the c89.sh wrapper in the tools directory, because the
// # IBM compiler does not like the -L switch after any object modules.
// #
// "OS390-Unix","c89.sh:-O -DB_ENDIAN -DCHARSET_EBCDIC -DNO_SYS_PARAM_H  -D_ALL_SOURCE::(unknown):::THIRTY_TWO_BIT DES_PTR DES_UNROLL MD2_CHAR RC4_INDEX RC4_CHAR BF_PTR:::",

// # Win64 targets, WIN64I denotes IA-64 and WIN64A - AMD64
// "VC-WIN64I","cl::::WIN64I::SIXTY_FOUR_BIT RC4_CHUNK_LL DES_INT EXPORT_VAR_AS_FN:${no_asm}:win32",
// "VC-WIN64A","cl::::WIN64A::SIXTY_FOUR_BIT RC4_CHUNK_LL DES_INT EXPORT_VAR_AS_FN:${no_asm}:win32",

// # Visual C targets
// "VC-NT","cl::::WINNT::BN_LLONG RC4_INDEX EXPORT_VAR_AS_FN ${x86_gcc_opts}:${no_asm}:win32",
// "VC-CE","cl::::WINCE::BN_LLONG RC4_INDEX EXPORT_VAR_AS_FN ${x86_gcc_opts}:${no_asm}:win32",
// "VC-WIN32","cl::::WIN32::BN_LLONG RC4_INDEX EXPORT_VAR_AS_FN ${x86_gcc_opts}:${no_asm}:win32",

// # Borland C++ 4.5
// "BC-32","bcc32::::WIN32::BN_LLONG DES_PTR RC4_INDEX EXPORT_VAR_AS_FN:${no_asm}:win32",

// # MinGW
// "mingw", "gcc:-mno-cygwin -DL_ENDIAN -fomit-frame-pointer -O3 -march=i486 -Wall -D_WIN32_WINNT=0x333:::MINGW32:-lwsock32 -lgdi32:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts} EXPORT_VAR_AS_FN:${x86_coff_asm}:win32:cygwin-shared:-D_WINDLL -DOPENSSL_USE_APPLINK:-mno-cygwin -shared:.dll.a",

// # UWIN
// "UWIN", "cc:-DTERMIOS -DL_ENDIAN -O -Wall:::UWIN::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${no_asm}:win32",

// # Cygwin
// "Cygwin-pre1.3", "gcc:-DTERMIOS -DL_ENDIAN -fomit-frame-pointer -O3 -m486 -Wall::(unknown):CYGWIN32::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${no_asm}:win32",
// "Cygwin", "gcc:-DTERMIOS -DL_ENDIAN -fomit-frame-pointer -O3 -march=i486 -Wall:::CYGWIN32::BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_coff_asm}:dlfcn:cygwin-shared:-D_WINDLL:-shared:.dll.a",
// "debug-Cygwin", "gcc:-DTERMIOS -DL_ENDIAN -march=i486 -Wall -DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG -DOPENSSL_NO_ASM -g -Wformat -Wshadow -Wmissing-prototypes -Wmissing-declarations -Werror:::CYGWIN32:::${no_asm}:dlfcn:cygwin-shared:-D_WINDLL:-shared:.dll.a",

// # NetWare from David Ward (dsward@novell.com)
// # requires either MetroWerks NLM development tools, or gcc / nlmconv
// # NetWare defaults socket bio to WinSock sockets. However,
// # the builds can be configured to use BSD sockets instead.
// # netware-clib => legacy CLib c-runtime support
// "netware-clib", "mwccnlm::::::${x86_gcc_opts}::",
// "netware-clib-bsdsock", "mwccnlm::::::${x86_gcc_opts}::",
// "netware-clib-gcc", "i586-netware-gcc:-nostdinc -I/ndk/nwsdk/include/nlm -I/ndk/ws295sdk/include -DL_ENDIAN -DNETWARE_CLIB -DOPENSSL_SYSNAME_NETWARE -O2 -Wall:::::${x86_gcc_opts}::",
// "netware-clib-bsdsock-gcc", "i586-netware-gcc:-nostdinc -I/ndk/nwsdk/include/nlm -DNETWARE_BSDSOCK -DNETDB_USE_INTERNET -DL_ENDIAN -DNETWARE_CLIB -DOPENSSL_SYSNAME_NETWARE -O2 -Wall:::::${x86_gcc_opts}::",
// # netware-libc => LibC/NKS support
// "netware-libc", "mwccnlm::::::BN_LLONG ${x86_gcc_opts}::",
// "netware-libc-bsdsock", "mwccnlm::::::BN_LLONG ${x86_gcc_opts}::",
// "netware-libc-gcc", "i586-netware-gcc:-nostdinc -I/ndk/libc/include -I/ndk/libc/include/winsock -DL_ENDIAN -DNETWARE_LIBC -DOPENSSL_SYSNAME_NETWARE -DTERMIO -O2 -Wall:::::BN_LLONG ${x86_gcc_opts}::",
// "netware-libc-bsdsock-gcc", "i586-netware-gcc:-nostdinc -I/ndk/libc/include -DNETWARE_BSDSOCK -DL_ENDIAN -DNETWARE_LIBC -DOPENSSL_SYSNAME_NETWARE -DTERMIO -O2 -Wall:::::BN_LLONG ${x86_gcc_opts}::",

// # DJGPP
// "DJGPP", "gcc:-I/dev/env/WATT_ROOT/inc -DTERMIOS -DL_ENDIAN -fomit-frame-pointer -O2 -Wall:::MSDOS:-L/dev/env/WATT_ROOT/lib -lwatt:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_out_asm}:",

// # Ultrix from Bernhard Simon <simon@zid.tuwien.ac.at>
// "ultrix-cc","cc:-std1 -O -Olimit 2500 -DL_ENDIAN::(unknown):::::::",
// "ultrix-gcc","gcc:-O3 -DL_ENDIAN::(unknown):::BN_LLONG::::",
// # K&R C is no longer supported; you need gcc on old Ultrix installations
// ##"ultrix","cc:-O2 -DNOPROTO -DNOCONST -DL_ENDIAN::(unknown):::::::",

// ##### MacOS X (a.k.a. Rhapsody or Darwin) setup
// "rhapsody-ppc-cc","cc:-O3 -DB_ENDIAN::(unknown):MACOSX_RHAPSODY::BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR:${no_asm}::",
// "darwin-ppc-cc","cc:-arch ppc -O3 -DB_ENDIAN::-D_REENTRANT:MACOSX:-Wl,-search_paths_first%:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::osx_ppc32.o::::::::::dlfcn:darwin-shared:-fPIC -fno-common:-arch ppc -dynamiclib:.\$(SHLIB_MAJOR).\$(SHLIB_MINOR).dylib",
// "darwin64-ppc-cc","cc:-arch ppc64 -O3 -DB_ENDIAN::-D_REENTRANT:MACOSX:-Wl,-search_paths_first%:SIXTY_FOUR_BIT_LONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::osx_ppc64.o::::::::::dlfcn:darwin-shared:-fPIC -fno-common:-arch ppc64 -dynamiclib:.\$(SHLIB_MAJOR).\$(SHLIB_MINOR).dylib",
// "darwin-i386-cc","cc:-arch i386 -O3 -fomit-frame-pointer -DL_ENDIAN::-D_REENTRANT:MACOSX:-Wl,-search_paths_first%:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR:${no_asm}:dlfcn:darwin-shared:-fPIC -fno-common:-arch i386 -dynamiclib:.\$(SHLIB_MAJOR).\$(SHLIB_MINOR).dylib",
// "debug-darwin-i386-cc","cc:-arch i386 -g3 -DL_ENDIAN::-D_REENTRANT:MACOSX:-Wl,-search_paths_first%:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR:${no_asm}:dlfcn:darwin-shared:-fPIC -fno-common:-arch i386 -dynamiclib:.\$(SHLIB_MAJOR).\$(SHLIB_MINOR).dylib",
// "darwin64-x86_64-cc","cc:-arch x86_64 -O3 -fomit-frame-pointer -DL_ENDIAN -DMD32_REG_T=int -Wall::-D_REENTRANT:MACOSX:-Wl,-search_paths_first%:SIXTY_FOUR_BIT_LONG RC4_CHAR RC4_CHUNK BF_PTR2 DES_INT DES_UNROLL:${no_asm}:dlfcn:darwin-shared:-fPIC -fno-common:-arch x86_64 -dynamiclib:.\$(SHLIB_MAJOR).\$(SHLIB_MINOR).dylib",
// "debug-darwin-ppc-cc","cc:-DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG -DB_ENDIAN -g -Wall -O::-D_REENTRANT:MACOSX::BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::osx_ppc32.o::::::::::dlfcn:darwin-shared:-fPIC -fno-common:-dynamiclib:.\$(SHLIB_MAJOR).\$(SHLIB_MINOR).dylib",

// ##### A/UX
// "aux3-gcc","gcc:-O2 -DTERMIO::(unknown):AUX:-lbsd:RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR:::",

// ##### Sony NEWS-OS 4.x
// "newsos4-gcc","gcc:-O -DB_ENDIAN::(unknown):NEWS4:-lmld -liberty:BN_LLONG RC4_CHAR RC4_CHUNK DES_PTR DES_RISC1 DES_UNROLL BF_PTR::::",

// ##### GNU Hurd
// "hurd-x86",  "gcc:-DL_ENDIAN -DTERMIOS -O3 -fomit-frame-pointer -march=i486 -Wall::-D_REENTRANT::-ldl:BN_LLONG ${x86_gcc_des} ${x86_gcc_opts}:${x86_elf_asm}:dlfcn:linux-shared:-fPIC",

// ##### OS/2 EMX
// "OS2-EMX", "gcc::::::::",

// ##### VxWorks for various targets
// "vxworks-ppc405","ccppc:-g -msoft-float -mlongcall -DCPU=PPC405 -I\$(WIND_BASE)/target/h:::VXWORKS:-r:::::",
// "vxworks-ppc750","ccppc:-ansi -nostdinc -DPPC750 -D_REENTRANT -fvolatile -fno-builtin -fno-for-scope -fsigned-char -Wall -msoft-float -mlongcall -DCPU=PPC604 -I\$(WIND_BASE)/target/h \$(DEBUG_FLAG):::VXWORKS:-r:::::",
// "vxworks-ppc750-debug","ccppc:-ansi -nostdinc -DPPC750 -D_REENTRANT -fvolatile -fno-builtin -fno-for-scope -fsigned-char -Wall -msoft-float -mlongcall -DCPU=PPC604 -I\$(WIND_BASE)/target/h -DBN_DEBUG -DREF_CHECK -DCONF_DEBUG -DCRYPTO_MDEBUG -DPEDANTIC -DDEBUG_SAFESTACK -DDEBUG -g:::VXWORKS:-r:::::",
// "vxworks-ppc860","ccppc:-nostdinc -msoft-float -DCPU=PPC860 -DNO_STRINGS_H -I\$(WIND_BASE)/target/h:::VXWORKS:-r:::::",
// "vxworks-mipsle","ccmips:-B\$(WIND_BASE)/host/\$(WIND_HOST_TYPE)/lib/gcc-lib/ -DL_ENDIAN -EL -Wl,-EL -mips2 -mno-branch-likely -G 0 -fno-builtin -msoft-float -DCPU=MIPS32 -DMIPSEL -DNO_STRINGS_H -I\$(WIND_BASE)/target/h:::VXWORKS:-r::${no_asm}::::::ranlibmips:",

// ##### Compaq Non-Stop Kernel (Tandem)
// "tandem-c89","c89:-Ww -D__TANDEM -D_XOPEN_SOURCE -D_XOPEN_SOURCE_EXTENDED=1 -D_TANDEM_SOURCE -DB_ENDIAN::(unknown):::THIRTY_TWO_BIT:::",

{enable if you want FIPS support and are using an openssl library with FIPS support compiled in.}
{$DEFINE OPENSSL_FIPS}
//use this only for Safe Stack define and some define changes in OpenSSL 1.0
//defines.

{$UNDEF OPENSSL_1_0}

{$IFDEF WIN32}
  {$DEFINE OPENSSL_SYSNAME_WIN32}
  {$DEFINE OPENSSL_SYS_WIN32}
  {$DEFINE L_ENDIAN}
  {$DEFINE DSO_WIN32}

  {$DEFINE BN_LLONG}
  {$DEFINE RC4_INDEX}
  {$DEFINE EXPORT_VAR_AS_FN}
  {$DEFINE RC4_INDEX}
  {$DEFINE MD2_INT}

  {$DEFINE _CRT_SECURE_NO_DEPRECATE}
  {$DEFINE _CRT_NONSTDC_NO_DEPRECATE}
  {$DEFINE BN_ASM}
  {$DEFINE MD5_ASM}
  {$DEFINE SHA1_ASM}
  {$DEFINE RMD160_ASM}
  {$DEFINE OPENSSL_NO_CMS}
  {$DEFINE OPENSSL_NO_GMP}
  {$DEFINE OPENSSL_NO_CAMELLIA}
  {$DEFINE OPENSSL_NO_RC5}
  {$DEFINE OPENSSL_NO_MD2}
  {$DEFINE OPENSSL_NO_MDC2}
  {$DEFINE OPENSSL_NO_KRB5}
  {$DEFINE OPENSSL_NO_MDC}
  {$DEFINE OPENSSL_NO_DYNAMIC_ENGINE}
  {$DEFINE OPENSSL_NO_RFC3779}
  {$DEFINE OPENSSL_NO_SEED}

  {$DEFINE OPENSSL_NO_CAPIENG}
  {$DEFINE OPENSSL_NO_JPAKE}
  {$DEFINE OPENSSL_1_0}
{$ENDIF}

{$IFDEF WINCE}
  {$DEFINE BN_LLONG}
  {$DEFINE RC4_INDEX}
  {$DEFINE EXPORT_VAR_AS_FN}
  {$DEFINE RC4_INDEX}
  {$DEFINE MD2_INT}
  {$DEFINE OPENSSL_NO_CMS}
  {$DEFINE OPENSSL_NO_CAMELLIA}
  {$DEFINE OPENSSL_NO_RC5}
  {$DEFINE OPENSSL_NO_MD2}
  {$DEFINE OPENSSL_NO_MDC2}
  {$DEFINE OPENSSL_NO_KRB5}
  {$DEFINE OPENSSL_NO_DYNAMIC_ENGINE}

  {$DEFINE EXPORT_VAR_AS_FN}
  {$DEFINE OPENSSL_NO_RFC3779}
  {$DEFINE OPENSSL_NO_SEED}
  {$DEFINE OPENSSL_NO_CAPIENG}
  {$DEFINE OPENSSL_NO_JPAKE}
{$ENDIF}

{$IFDEF WIN64}
   //"VC-WIN64A","cl::::WIN64A::-SIXTY_FOUR_BIT RC4_CHUNK_LL DES_INT EXPORT_VAR_AS_FN:${no_asm}:win32",
  {$DEFINE SIXTY_FOUR_BIT}
  {$DEFINE RC4_CHUNK_LL}
  {$DEFINE DES_INT}
  {$DEFINE EXPORT_VAR_AS_FN}

  {$DEFINE L_ENDIAN}

  {$DEFINE DSO_WIN32}
  {$DEFINE OPENSSL_SYSNAME_WIN32}
  {$DEFINE OPENSSL_SYSNAME_WINNT}
  {$DEFINE UNICODE}
  {$DEFINE _UNICODE}
  {$DEFINE _CRT_SECURE_NO_DEPRECATE}
  {$DEFINE _CRT_NONSTDC_NO_DEPRECATE}
  {$DEFINE OPENSSL_NO_CAMELLIA}
  {$DEFINE OPENSSL_NO_RC5}
  {$DEFINE OPENSSL_NO_MD2}
  {$DEFINE OPENSSL_NO_MDC2}
  {$DEFINE OPENSSL_NO_KRB5}
  {$DEFINE OPENSSL_NO_DYNAMIC_ENGINE}

  {$DEFINE EXPORT_VAR_AS_FN}
  {$DEFINE OPENSSL_NO_GMP}
  {$DEFINE OPENSSL_NO_RFC3779}
  {$DEFINE OPENSSL_NO_SEED}
  {$DEFINE OPENSSL_NO_CAPIENG}
  {$DEFINE OPENSSL_NO_JPAKE}
  {$DEFINE OPENSSL_1_0}
{$ENDIF}

{$IFDEF UNIX}
//attempt to get this right from FreeBSD CVS
//Makefile compile options.  The file is located
//at http://www.freebsd.org/cgi/cvsweb.cgi/src/crypto/openssl/ .
  {$DEFINE OPENSSL_NO_CAMELLIA}
  {$DEFINE OPENSSL_NO_GMP}
  {$DEFINE OPENSSL_NO_MD2}
  {$DEFINE OPENSSL_NO_MDC2}
  {$DEFINE OPENSSL_NO_RC5}
  {$DEFINE OPENSSL_NO_SEED}
   {$DEFINE OPENSSL_NO_RFC3779}

  {$DEFINE OPENSSL_NO_CAPIENG}
  {$DEFINE OPENSSL_NO_JPAKE}
{$ENDIF}

//#if (defined(OPENSSL_NO_RSA) || defined(OPENSSL_NO_MD5)) && !defined(OPENSSL_NO_SSL2)
//#define OPENSSL_NO_SSL2
//#endif
{$IFDEF OPENSSL_NO_RSA}
  {$IFNDEF OPENSSL_NO_SSL2}
    {$DEFINE OPENSSL_NO_SSL2}
  {$ENDIF}
{$ENDIF}
{$IFDEF OPENSSL_NO_MD5}
  {$IFNDEF OPENSSL_NO_SSL2}
    {$DEFINE OPENSSL_NO_SSL2}
  {$ENDIF}
{$ENDIF}

{$IFDEF WIN64}
  {$DEFINE SYS_WIN}
{$ENDIF}
{$IFDEF WIN32}
  {$DEFINE SYS_WIN}
{$ENDIF}
{$IFDEF WINCE}
  {$DEFINE SYS_WIN}
{$ENDIF}

{$IFNDEF SIXTY_FOUR_BIT}
  {$IFNDEF SIXTY_FOUR_BIT_LONG}
//I've over simplified this because we don't support 8 or 16bit architectures
    {$DEFINE THIRTY_TWO_BIT}
  {$ENDIF}
{$ENDIF}
{$IFDEF OPENSSL_1_0}
  {$DEFINE DEBUG_SAFESTACK}
  {$UNDEF OPENSSL_NO_SEED}
  {$UNDEF OPENSSL_NO_MDC2}
  {$UNDEF OPENSSL_NO_CMS}
  {$UNDEF OPENSSL_NO_CAPIENG}
{$ENDIF}

// the following emits are a workaround to a
// name conflict with Win32 API header files
(*$HPPEMIT '#include <time.h>'*)
{$IFDEF SYS_WIN}
(*$HPPEMIT '#undef X509_NAME'*)
(*$HPPEMIT '#undef X509_EXTENSIONS'*)
(*$HPPEMIT '#undef X509_CERT_PAIR'*)
(*$HPPEMIT '#undef PKCS7_ISSUER_AND_SERIAL'*)
(*$HPPEMIT '#undef OCSP_RESPONSE'*)
(*$HPPEMIT '#undef OCSP_REQUEST'*)
(*$HPPEMIT '#undef PKCS7_SIGNER_INFO'*)
(*$HPPEMIT '#undef OCSP_REQUEST'*)
(*$HPPEMIT '#undef OCSP_RESPONSE'*)
{$ENDIF}

// the following emits are a workaround to allow
// compiling in C++ without having to re-define
// OpenSSL data types and without having to
// include the OpenSSL header files
{$IFDEF HAS_DIRECTIVE_HPPEMIT_NAMESPACE}
{$HPPEMIT OPENNAMESPACE}
{$ELSE}
(*$HPPEMIT 'namespace Idsslopensslheaders'*)
(*$HPPEMIT '{'*)
{$ENDIF}
(*$HPPEMIT '	struct SSL;'*)
(*$HPPEMIT '	typedef SSL* PSSL;'*)
(*$HPPEMIT '	struct SSL_CTX;'*)
(*$HPPEMIT '	typedef SSL_CTX* PSSL_CTX;'*)
(*$HPPEMIT '	struct SSL_METHOD;'*)
(*$HPPEMIT '	typedef SSL_METHOD* PSSL_METHOD;'*)
(*$HPPEMIT '	struct X509;'*)
(*$HPPEMIT '	typedef X509* PX509;'*)
(*$HPPEMIT '	struct X509_NAME;'*)
(*$HPPEMIT '	typedef X509_NAME* PX509_NAME;'*)
{$IFDEF HAS_DIRECTIVE_HPPEMIT_NAMESPACE}
{$HPPEMIT CLOSENAMESPACE}
{$ELSE}
(*$HPPEMIT '}'*)
{$ENDIF}

// RLebeau: why are the following types not being placed in
// the Idsslopensslheaders namespace with the types above?
(*$HPPEMIT 'struct RSA;'*)
(*$HPPEMIT 'typedef RSA* PRSA;'*)
(*$HPPEMIT 'struct DSA;'*)
(*$HPPEMIT 'typedef DSA* PDSA;'*)
(*$HPPEMIT 'struct DH;'*)
(*$HPPEMIT 'typedef DH* PDH;'*)
(*$HPPEMIT 'typedef void* PEC_KEY;'*)

uses
  IdException,
  IdGlobal,
  {$IFDEF WINDOWS}
  Windows,
  IdWinsock2,
  {$ENDIF}
  {$IFDEF USE_VCL_POSIX}
  Posix.SysSocket,
  Posix.SysTime,
  Posix.SysTypes,
  {$ENDIF}
  {$IFDEF KYLIXCOMPAT}
  libc,
  {$ENDIF}
  {$IFDEF USE_BASEUNIX}
  baseunix,
  sockets,
  {$ENDIF}
  SysUtils, 
  IdCTypes;

//temp for compile tests
{.$DEFINE SSLEAY_MACROS}

const
  {$IFNDEF HAS_PAnsiChar}
  cNull: TIdAnsiChar = 0;
  {$ENDIF}

  {$EXTERNALSYM CONF_MFLAGS_IGNORE_ERRORS}
  CONF_MFLAGS_IGNORE_ERRORS = $1;
  {$EXTERNALSYM CONF_MFLAGS_IGNORE_RETURN_CODES}
  CONF_MFLAGS_IGNORE_RETURN_CODES = $2;
  {$EXTERNALSYM CONF_MFLAGS_SILENT}
  CONF_MFLAGS_SILENT = $4;
  {$EXTERNALSYM CONF_MFLAGS_NO_DSO}
  CONF_MFLAGS_NO_DSO = $8;
  {$EXTERNALSYM CONF_MFLAGS_IGNORE_MISSING_FILE}
  CONF_MFLAGS_IGNORE_MISSING_FILE = $10;
  {$EXTERNALSYM CONF_MFLAGS_DEFAULT_SECTION}
  CONF_MFLAGS_DEFAULT_SECTION = $20;
  {$EXTERNALSYM CONF_F_CONF_DUMP_FP}
  CONF_F_CONF_DUMP_FP = 104;
  {$EXTERNALSYM CONF_F_CONF_LOAD}
  CONF_F_CONF_LOAD = 100;
  {$EXTERNALSYM CONF_F_CONF_LOAD_BIO}
  CONF_F_CONF_LOAD_BIO = 102;
  {$EXTERNALSYM CONF_F_CONF_LOAD_FP}
  CONF_F_CONF_LOAD_FP = 103;
  {$EXTERNALSYM CONF_F_CONF_MODULES_LOAD}
  CONF_F_CONF_MODULES_LOAD = 116;
  {$EXTERNALSYM CONF_F_DEF_LOAD}
  CONF_F_DEF_LOAD = 120;
  {$EXTERNALSYM CONF_F_DEF_LOAD_BIO}
  CONF_F_DEF_LOAD_BIO = 121;
  {$EXTERNALSYM CONF_F_MODULE_INIT}
  CONF_F_MODULE_INIT = 115;
  {$EXTERNALSYM CONF_F_MODULE_LOAD_DSO}
  CONF_F_MODULE_LOAD_DSO = 117;
  {$EXTERNALSYM CONF_F_CONF_PARSE_LIST}
  CONF_F_CONF_PARSE_LIST = 119;
  {$EXTERNALSYM CONF_F_MODULE_RUN}
  CONF_F_MODULE_RUN = 118;
  {$EXTERNALSYM CONF_F_NCONF_DUMP_BIO}
  CONF_F_NCONF_DUMP_BIO = 105;
  {$EXTERNALSYM CONF_F_NCONF_DUMP_FP}
  CONF_F_NCONF_DUMP_FP = 106;
  {$EXTERNALSYM CONF_F_NCONF_GET_NUMBER}
  CONF_F_NCONF_GET_NUMBER = 107;
  {$EXTERNALSYM CONF_F_NCONF_GET_NUMBER_E}
  CONF_F_NCONF_GET_NUMBER_E = 112;
  {$EXTERNALSYM CONF_F_NCONF_GET_SECTION}
  CONF_F_NCONF_GET_SECTION = 108;
  {$EXTERNALSYM CONF_F_NCONF_GET_STRING}
  CONF_F_NCONF_GET_STRING = 109;
  {$EXTERNALSYM CONF_F_NCONF_LOAD}
  CONF_F_NCONF_LOAD = 113;
  {$EXTERNALSYM CONF_F_NCONF_LOAD_BIO}
  CONF_F_NCONF_LOAD_BIO = 110;
  {$EXTERNALSYM CONF_F_NCONF_LOAD_FP}
  CONF_F_NCONF_LOAD_FP = 114;
  {$EXTERNALSYM CONF_F_NCONF_NEW}
  CONF_F_NCONF_NEW = 111;
  {$EXTERNALSYM CONF_F_STR_COPY}
  CONF_F_STR_COPY = 101;

//* Reason codes. */
  {$EXTERNALSYM CONF_R_ERROR_LOADING_DSO}
  CONF_R_ERROR_LOADING_DSO = 110;
  {$EXTERNALSYM CONF_R_LIST_CANNOT_BE_NULL}
  CONF_R_LIST_CANNOT_BE_NULL = 115;
  {$EXTERNALSYM CONF_R_MISSING_CLOSE_SQUARE_BRACKET}
  CONF_R_MISSING_CLOSE_SQUARE_BRACKET = 100;
  {$EXTERNALSYM CONF_R_MISSING_EQUAL_SIGN}
  CONF_R_MISSING_EQUAL_SIGN = 101;
  {$EXTERNALSYM CONF_R_MISSING_FINISH_FUNCTION}
  CONF_R_MISSING_FINISH_FUNCTION = 111;
  {$EXTERNALSYM CONF_R_MISSING_INIT_FUNCTION}
  CONF_R_MISSING_INIT_FUNCTION = 112;
  {$EXTERNALSYM CONF_R_MODULE_INITIALIZATION_ERROR}
  CONF_R_MODULE_INITIALIZATION_ERROR = 109;
  {$EXTERNALSYM CONF_R_NO_CLOSE_BRACE}
  CONF_R_NO_CLOSE_BRACE = 102;
  {$EXTERNALSYM CONF_R_NO_CONF}
  CONF_R_NO_CONF = 105;
  {$EXTERNALSYM CONF_R_NO_CONF_OR_ENVIRONMENT_VARIABLE}
  CONF_R_NO_CONF_OR_ENVIRONMENT_VARIABLE = 106;
  {$EXTERNALSYM CONF_R_NO_SECTION}
  CONF_R_NO_SECTION = 107;
  {$EXTERNALSYM CONF_R_NO_SUCH_FILE}
  CONF_R_NO_SUCH_FILE = 114;
  {$EXTERNALSYM CONF_R_NO_VALUE}
  CONF_R_NO_VALUE = 108;
  {$EXTERNALSYM CONF_R_UNABLE_TO_CREATE_NEW_SECTION}
  CONF_R_UNABLE_TO_CREATE_NEW_SECTION = 103;
  {$EXTERNALSYM CONF_R_UNKNOWN_MODULE_NAME}
  CONF_R_UNKNOWN_MODULE_NAME = 113;
  {$EXTERNALSYM CONF_R_VARIABLE_HAS_NO_VALUE}
  CONF_R_VARIABLE_HAS_NO_VALUE = 104;

  {$EXTERNALSYM ASN1_F_A2D_ASN1_OBJECT}
  ASN1_F_A2D_ASN1_OBJECT = 100;
  {$EXTERNALSYM ASN1_F_A2I_ASN1_ENUMERATED}
  ASN1_F_A2I_ASN1_ENUMERATED = 236;
  {$EXTERNALSYM ASN1_F_A2I_ASN1_INTEGER}
  ASN1_F_A2I_ASN1_INTEGER = 101;
  {$EXTERNALSYM ASN1_F_A2I_ASN1_STRING}
  ASN1_F_A2I_ASN1_STRING = 102;
  {$EXTERNALSYM ASN1_F_ASN1_COLLATE_PRIMITIVE}
  ASN1_F_ASN1_COLLATE_PRIMITIVE = 103;
  {$EXTERNALSYM ASN1_F_ASN1_D2I_BIO}
  ASN1_F_ASN1_D2I_BIO = 104;
  {$EXTERNALSYM ASN1_F_ASN1_D2I_FP}
  ASN1_F_ASN1_D2I_FP = 105;
  {$EXTERNALSYM ASN1_F_ASN1_DUP}
  ASN1_F_ASN1_DUP = 106;
  {$EXTERNALSYM ASN1_F_ASN1_ENUMERATED_SET}
  ASN1_F_ASN1_ENUMERATED_SET = 232;
  {$EXTERNALSYM ASN1_F_ASN1_ENUMERATED_TO_BN}
  ASN1_F_ASN1_ENUMERATED_TO_BN = 233;
  {$EXTERNALSYM ASN1_F_ASN1_GENERALIZEDTIME_NEW}
  ASN1_F_ASN1_GENERALIZEDTIME_NEW = 222;
  {$EXTERNALSYM ASN1_F_ASN1_GET_OBJECT}
  ASN1_F_ASN1_GET_OBJECT = 107;
  {$EXTERNALSYM ASN1_F_ASN1_HEADER_NEW}
  ASN1_F_ASN1_HEADER_NEW = 108;
  {$EXTERNALSYM ASN1_F_ASN1_I2D_BIO}
  ASN1_F_ASN1_I2D_BIO = 109;
  {$EXTERNALSYM ASN1_F_ASN1_I2D_FP}
  ASN1_F_ASN1_I2D_FP = 110;
  {$EXTERNALSYM ASN1_F_ASN1_INTEGER_SET}
  ASN1_F_ASN1_INTEGER_SET = 111;
  {$EXTERNALSYM ASN1_F_ASN1_INTEGER_TO_BN}
  ASN1_F_ASN1_INTEGER_TO_BN = 112;
  {$EXTERNALSYM ASN1_F_ASN1_OBJECT_NEW}
  ASN1_F_ASN1_OBJECT_NEW = 113;

  {$EXTERNALSYM ASN1_F_ASN1_OUTPUT_DATA}
  ASN1_F_ASN1_OUTPUT_DATA= 207;

  {$EXTERNALSYM ASN1_F_ASN1_PACK_STRING}
  ASN1_F_ASN1_PACK_STRING = 245;
  {$EXTERNALSYM ASN1_F_ASN1_PBE_SET}
  ASN1_F_ASN1_PBE_SET = 253;
  {$EXTERNALSYM ASN1_F_ASN1_SEQ_PACK}
  ASN1_F_ASN1_SEQ_PACK = 246;
  {$EXTERNALSYM ASN1_F_ASN1_SEQ_UNPACK}
  ASN1_F_ASN1_SEQ_UNPACK = 247;
  {$EXTERNALSYM ASN1_F_ASN1_SIGN}
  ASN1_F_ASN1_SIGN = 114;
  {$EXTERNALSYM ASN1_F_ASN1_STRING_NEW}
  ASN1_F_ASN1_STRING_NEW = 115;
  {$EXTERNALSYM ASN1_F_ASN1_STRING_TYPE_NEW}
  ASN1_F_ASN1_STRING_TYPE_NEW = 116;
  {$EXTERNALSYM ASN1_F_ASN1_TYPE_GET_INT_OCTETSTRING}
  ASN1_F_ASN1_TYPE_GET_INT_OCTETSTRING = 117;
  {$EXTERNALSYM ASN1_F_ASN1_TYPE_GET_OCTETSTRING}
  ASN1_F_ASN1_TYPE_GET_OCTETSTRING = 118;
  {$EXTERNALSYM ASN1_F_ASN1_TYPE_NEW}
  ASN1_F_ASN1_TYPE_NEW = 119;
  {$EXTERNALSYM ASN1_F_ASN1_UNPACK_STRING}
  ASN1_F_ASN1_UNPACK_STRING = 248;
  {$EXTERNALSYM ASN1_F_ASN1_UTCTIME_NEW}
  ASN1_F_ASN1_UTCTIME_NEW = 120;
  {$EXTERNALSYM ASN1_F_ASN1_VERIFY}
  ASN1_F_ASN1_VERIFY = 121;
  {$EXTERNALSYM ASN1_F_B64_READ_ASN1}
  ASN1_F_B64_READ_ASN1 = 208;
  {$EXTERNALSYM ASN1_F_B64_WRITE_ASN1}
  ASN1_F_B64_WRITE_ASN1 = 209;
  {$EXTERNALSYM ASN1_F_BIO_NEW_NDEF}
  ASN1_F_BIO_NEW_NDEF = 212;
  {$EXTERNALSYM ASN1_F_BITSTR_CB}
  ASN1_F_BITSTR_CB = 180;
  {$EXTERNALSYM ASN1_F_SMIME_READ_ASN1}
  ASN1_F_SMIME_READ_ASN1 = 210;
  {$EXTERNALSYM ASN1_F_SMIME_TEXT}
  ASN1_F_SMIME_TEXT = 211;


  {$EXTERNALSYM ASN1_F_AUTHORITY_KEYID_NEW}
  ASN1_F_AUTHORITY_KEYID_NEW = 237;
  {$EXTERNALSYM ASN1_F_BASIC_CONSTRAINTS_NEW}
  ASN1_F_BASIC_CONSTRAINTS_NEW = 226;
  {$EXTERNALSYM ASN1_F_BN_TO_ASN1_ENUMERATED}
  ASN1_F_BN_TO_ASN1_ENUMERATED = 234;
  {$EXTERNALSYM ASN1_F_BN_TO_ASN1_INTEGER}
  ASN1_F_BN_TO_ASN1_INTEGER = 122;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_BIT_STRING}
  ASN1_F_D2I_ASN1_BIT_STRING = 123;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_BMPSTRING}
  ASN1_F_D2I_ASN1_BMPSTRING = 124;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_BOOLEAN}
  ASN1_F_D2I_ASN1_BOOLEAN = 125;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_BYTES}
  ASN1_F_D2I_ASN1_BYTES = 126;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_ENUMERATED}
  ASN1_F_D2I_ASN1_ENUMERATED = 235;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_GENERALIZEDTIME}
  ASN1_F_D2I_ASN1_GENERALIZEDTIME = 223;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_HEADER}
  ASN1_F_D2I_ASN1_HEADER = 127;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_INTEGER}
  ASN1_F_D2I_ASN1_INTEGER = 128;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_OBJECT}
  ASN1_F_D2I_ASN1_OBJECT = 129;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_OCTET_STRING}
  ASN1_F_D2I_ASN1_OCTET_STRING = 130;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_PRINT_TYPE}
  ASN1_F_D2I_ASN1_PRINT_TYPE = 131;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_SET}
  ASN1_F_D2I_ASN1_SET = 132;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_TIME}
  ASN1_F_D2I_ASN1_TIME = 224;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_TYPE}
  ASN1_F_D2I_ASN1_TYPE = 133;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_TYPE_BYTES}
  ASN1_F_D2I_ASN1_TYPE_BYTES = 134;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_UINTEGER}
  ASN1_F_D2I_ASN1_UINTEGER = 280;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_UTCTIME}
  ASN1_F_D2I_ASN1_UTCTIME = 135;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_UTF8STRING}
  ASN1_F_D2I_ASN1_UTF8STRING = 266;
  {$EXTERNALSYM ASN1_F_D2I_ASN1_VISIBLESTRING}
  ASN1_F_D2I_ASN1_VISIBLESTRING = 267;
  {$EXTERNALSYM ASN1_F_D2I_AUTHORITY_KEYID}
  ASN1_F_D2I_AUTHORITY_KEYID = 238;
  {$EXTERNALSYM ASN1_F_D2I_BASIC_CONSTRAINTS}
  ASN1_F_D2I_BASIC_CONSTRAINTS = 227;
  {$EXTERNALSYM ASN1_F_D2I_DHPARAMS}
  ASN1_F_D2I_DHPARAMS = 136;
  {$EXTERNALSYM ASN1_F_D2I_DIST_POINT}
  ASN1_F_D2I_DIST_POINT = 276;
  {$EXTERNALSYM ASN1_F_D2I_DIST_POINT_NAME}
  ASN1_F_D2I_DIST_POINT_NAME = 277;
  {$EXTERNALSYM ASN1_F_D2I_DSAPARAMS}
  ASN1_F_D2I_DSAPARAMS = 137;
  {$EXTERNALSYM ASN1_F_D2I_DSAPRIVATEKEY}
  ASN1_F_D2I_DSAPRIVATEKEY = 138;
  {$EXTERNALSYM ASN1_F_D2I_DSAPUBLICKEY}
  ASN1_F_D2I_DSAPUBLICKEY = 139;
  {$EXTERNALSYM ASN1_F_D2I_GENERAL_NAME}
  ASN1_F_D2I_GENERAL_NAME = 230;
  {$EXTERNALSYM ASN1_F_D2I_NETSCAPE_CERT_SEQUENCE}
  ASN1_F_D2I_NETSCAPE_CERT_SEQUENCE = 228;
  {$EXTERNALSYM ASN1_F_D2I_NETSCAPE_PKEY}
  ASN1_F_D2I_NETSCAPE_PKEY = 140;
  {$EXTERNALSYM ASN1_F_D2I_NETSCAPE_RSA}
  ASN1_F_D2I_NETSCAPE_RSA = 141;
  {$EXTERNALSYM ASN1_F_D2I_NETSCAPE_RSA_2}
  ASN1_F_D2I_NETSCAPE_RSA_2 = 142;
  {$EXTERNALSYM ASN1_F_D2I_NETSCAPE_SPKAC}
  ASN1_F_D2I_NETSCAPE_SPKAC = 143;
  {$EXTERNALSYM ASN1_F_D2I_NETSCAPE_SPKI}
  ASN1_F_D2I_NETSCAPE_SPKI = 144;
  {$EXTERNALSYM ASN1_F_D2I_NOTICEREF}
  ASN1_F_D2I_NOTICEREF = 268;
  {$EXTERNALSYM ASN1_F_D2I_PBE2PARAM}
  ASN1_F_D2I_PBE2PARAM = 262;
  {$EXTERNALSYM ASN1_F_D2I_PBEPARAM}
  ASN1_F_D2I_PBEPARAM = 249;
  {$EXTERNALSYM ASN1_F_D2I_PBKDF2PARAM}
  ASN1_F_D2I_PBKDF2PARAM = 263;
  {$EXTERNALSYM ASN1_F_D2I_PKCS12}
  ASN1_F_D2I_PKCS12 = 254;
  {$EXTERNALSYM ASN1_F_D2I_PKCS12_BAGS}
  ASN1_F_D2I_PKCS12_BAGS = 255;
  {$EXTERNALSYM ASN1_F_D2I_PKCS12_MAC_DATA}
  ASN1_F_D2I_PKCS12_MAC_DATA = 256;
  {$EXTERNALSYM ASN1_F_D2I_PKCS12_SAFEBAG}
  ASN1_F_D2I_PKCS12_SAFEBAG = 257;
  {$EXTERNALSYM ASN1_F_D2I_PKCS7}
  ASN1_F_D2I_PKCS7 = 145;
  {$EXTERNALSYM ASN1_F_D2I_PKCS7_DIGEST}
  ASN1_F_D2I_PKCS7_DIGEST = 146;
  {$EXTERNALSYM ASN1_F_D2I_PKCS7_ENCRYPT}
  ASN1_F_D2I_PKCS7_ENCRYPT = 147;
  {$EXTERNALSYM ASN1_F_D2I_PKCS7_ENC_CONTENT}
  ASN1_F_D2I_PKCS7_ENC_CONTENT = 148;
  {$EXTERNALSYM ASN1_F_D2I_PKCS7_ENVELOPE}
  ASN1_F_D2I_PKCS7_ENVELOPE = 149;
  {$EXTERNALSYM ASN1_F_D2I_PKCS7_ISSUER_AND_SERIAL}
  ASN1_F_D2I_PKCS7_ISSUER_AND_SERIAL = 150;
  {$EXTERNALSYM ASN1_F_D2I_PKCS7_RECIP_INFO}
  ASN1_F_D2I_PKCS7_RECIP_INFO = 151;
  {$EXTERNALSYM ASN1_F_D2I_PKCS7_SIGNED}
  ASN1_F_D2I_PKCS7_SIGNED = 152;
  {$EXTERNALSYM ASN1_F_D2I_PKCS7_SIGNER_INFO}
  ASN1_F_D2I_PKCS7_SIGNER_INFO = 153;
  {$EXTERNALSYM ASN1_F_D2I_PKCS7_SIGN_ENVELOPE}
  ASN1_F_D2I_PKCS7_SIGN_ENVELOPE = 154;
  {$EXTERNALSYM ASN1_F_D2I_PKCS8_PRIV_KEY_INFO}
  ASN1_F_D2I_PKCS8_PRIV_KEY_INFO = 250;
  {$EXTERNALSYM ASN1_F_D2I_PKEY_USAGE_PERIOD}
  ASN1_F_D2I_PKEY_USAGE_PERIOD = 239;
  {$EXTERNALSYM ASN1_F_D2I_POLICYINFO}
  ASN1_F_D2I_POLICYINFO = 269;
  {$EXTERNALSYM ASN1_F_D2I_POLICYQUALINFO}
  ASN1_F_D2I_POLICYQUALINFO = 270;
  {$EXTERNALSYM ASN1_F_D2I_PRIVATEKEY}
  ASN1_F_D2I_PRIVATEKEY = 155;
  {$EXTERNALSYM ASN1_F_D2I_PUBLICKEY}
  ASN1_F_D2I_PUBLICKEY = 156;
  {$EXTERNALSYM ASN1_F_D2I_RSAPRIVATEKEY}
  ASN1_F_D2I_RSAPRIVATEKEY = 157;
  {$EXTERNALSYM ASN1_F_D2I_RSAPUBLICKEY}
  ASN1_F_D2I_RSAPUBLICKEY = 158;
  {$EXTERNALSYM ASN1_F_D2I_SXNET}
  ASN1_F_D2I_SXNET = 241;
  {$EXTERNALSYM ASN1_F_D2I_SXNETID}
  ASN1_F_D2I_SXNETID = 243;
  {$EXTERNALSYM ASN1_F_D2I_USERNOTICE}
  ASN1_F_D2I_USERNOTICE = 271;
  {$EXTERNALSYM ASN1_F_D2I_X509}
  ASN1_F_D2I_X509 = 159;
  {$EXTERNALSYM ASN1_F_D2I_X509_ALGOR}
  ASN1_F_D2I_X509_ALGOR = 160;
  {$EXTERNALSYM ASN1_F_D2I_X509_ATTRIBUTE}
  ASN1_F_D2I_X509_ATTRIBUTE = 161;
  {$EXTERNALSYM ASN1_F_D2I_X509_CINF}
  ASN1_F_D2I_X509_CINF = 162;
  {$EXTERNALSYM ASN1_F_D2I_X509_CRL}
  ASN1_F_D2I_X509_CRL = 163;
  {$EXTERNALSYM ASN1_F_D2I_X509_CRL_INFO}
  ASN1_F_D2I_X509_CRL_INFO = 164;
  {$EXTERNALSYM ASN1_F_D2I_X509_EXTENSION}
  ASN1_F_D2I_X509_EXTENSION = 165;
  {$EXTERNALSYM ASN1_F_D2I_X509_KEY}
  ASN1_F_D2I_X509_KEY = 166;
  {$EXTERNALSYM ASN1_F_D2I_X509_NAME}
  ASN1_F_D2I_X509_NAME = 167;
  {$EXTERNALSYM ASN1_F_D2I_X509_NAME_ENTRY}
  ASN1_F_D2I_X509_NAME_ENTRY = 168;
  {$EXTERNALSYM ASN1_F_D2I_X509_PKEY}
  ASN1_F_D2I_X509_PKEY = 169;
  {$EXTERNALSYM ASN1_F_D2I_X509_PUBKEY}
  ASN1_F_D2I_X509_PUBKEY = 170;
  {$EXTERNALSYM ASN1_F_D2I_X509_REQ}
  ASN1_F_D2I_X509_REQ = 171;
  {$EXTERNALSYM ASN1_F_D2I_X509_REQ_INFO}
  ASN1_F_D2I_X509_REQ_INFO = 172;
  {$EXTERNALSYM ASN1_F_D2I_X509_REVOKED}
  ASN1_F_D2I_X509_REVOKED = 173;
  {$EXTERNALSYM ASN1_F_D2I_X509_SIG}
  ASN1_F_D2I_X509_SIG = 174;
  {$EXTERNALSYM ASN1_F_D2I_X509_VAL}
  ASN1_F_D2I_X509_VAL = 175;
  {$EXTERNALSYM ASN1_F_DIST_POINT_NAME_NEW}
  ASN1_F_DIST_POINT_NAME_NEW = 278;
  {$EXTERNALSYM ASN1_F_DIST_POINT_NEW}
  ASN1_F_DIST_POINT_NEW = 279;
  {$EXTERNALSYM ASN1_F_GENERAL_NAME_NEW}
  ASN1_F_GENERAL_NAME_NEW = 231;
  {$EXTERNALSYM ASN1_F_I2D_ASN1_HEADER}
  ASN1_F_I2D_ASN1_HEADER = 176;
  {$EXTERNALSYM ASN1_F_I2D_ASN1_TIME}
  ASN1_F_I2D_ASN1_TIME = 225;
  {$EXTERNALSYM ASN1_F_I2D_DHPARAMS}
  ASN1_F_I2D_DHPARAMS = 177;
  {$EXTERNALSYM ASN1_F_I2D_DSAPARAMS}
  ASN1_F_I2D_DSAPARAMS = 178;
  {$EXTERNALSYM ASN1_F_I2D_DSAPRIVATEKEY}
  ASN1_F_I2D_DSAPRIVATEKEY = 179;
  {$EXTERNALSYM ASN1_F_I2D_DSAPUBLICKEY}
  ASN1_F_I2D_DSAPUBLICKEY = 180;
  {$EXTERNALSYM ASN1_F_I2D_NETSCAPE_RSA}
  ASN1_F_I2D_NETSCAPE_RSA = 181;
  {$EXTERNALSYM ASN1_F_I2D_PKCS7}
  ASN1_F_I2D_PKCS7 = 182;
  {$EXTERNALSYM ASN1_F_I2D_PRIVATEKEY}
  ASN1_F_I2D_PRIVATEKEY = 183;
  {$EXTERNALSYM ASN1_F_I2D_PUBLICKEY}
  ASN1_F_I2D_PUBLICKEY = 184;
  {$EXTERNALSYM ASN1_F_I2D_RSAPRIVATEKEY}
  ASN1_F_I2D_RSAPRIVATEKEY = 185;
  {$EXTERNALSYM ASN1_F_I2D_RSAPUBLICKEY}
  ASN1_F_I2D_RSAPUBLICKEY = 186;
  {$EXTERNALSYM ASN1_F_I2D_X509_ATTRIBUTE}
  ASN1_F_I2D_X509_ATTRIBUTE = 187;
  {$EXTERNALSYM ASN1_F_I2T_ASN1_OBJECT}
  ASN1_F_I2T_ASN1_OBJECT = 188;
  {$EXTERNALSYM ASN1_F_NETSCAPE_CERT_SEQUENCE_NEW}
  ASN1_F_NETSCAPE_CERT_SEQUENCE_NEW = 229;
  {$EXTERNALSYM ASN1_F_NETSCAPE_PKEY_NEW}
  ASN1_F_NETSCAPE_PKEY_NEW = 189;
  {$EXTERNALSYM ASN1_F_NETSCAPE_SPKAC_NEW}
  ASN1_F_NETSCAPE_SPKAC_NEW = 190;
  {$EXTERNALSYM ASN1_F_NETSCAPE_SPKI_NEW}
  ASN1_F_NETSCAPE_SPKI_NEW = 191;
  {$EXTERNALSYM ASN1_F_NOTICEREF_NEW}
  ASN1_F_NOTICEREF_NEW = 272;
  {$EXTERNALSYM ASN1_F_PBE2PARAM_NEW}
  ASN1_F_PBE2PARAM_NEW = 264;
  {$EXTERNALSYM ASN1_F_PBEPARAM_NEW}
  ASN1_F_PBEPARAM_NEW = 251;
  {$EXTERNALSYM ASN1_F_PBKDF2PARAM_NEW}
  ASN1_F_PBKDF2PARAM_NEW = 265;
  {$EXTERNALSYM ASN1_F_PKCS12_BAGS_NEW}
  ASN1_F_PKCS12_BAGS_NEW = 258;
  {$EXTERNALSYM ASN1_F_PKCS12_MAC_DATA_NEW}
  ASN1_F_PKCS12_MAC_DATA_NEW = 259;
  {$EXTERNALSYM ASN1_F_PKCS12_NEW}
  ASN1_F_PKCS12_NEW = 260;
  {$EXTERNALSYM ASN1_F_PKCS12_SAFEBAG_NEW}
  ASN1_F_PKCS12_SAFEBAG_NEW = 261;
  {$EXTERNALSYM ASN1_F_PKCS5_PBE2_SET}
  ASN1_F_PKCS5_PBE2_SET = 281;
  {$EXTERNALSYM ASN1_F_PKCS7_DIGEST_NEW}
  ASN1_F_PKCS7_DIGEST_NEW = 192;
  {$EXTERNALSYM ASN1_F_PKCS7_ENCRYPT_NEW}
  ASN1_F_PKCS7_ENCRYPT_NEW = 193;
  {$EXTERNALSYM ASN1_F_PKCS7_ENC_CONTENT_NEW}
  ASN1_F_PKCS7_ENC_CONTENT_NEW = 194;
  {$EXTERNALSYM ASN1_F_PKCS7_ENVELOPE_NEW}
  ASN1_F_PKCS7_ENVELOPE_NEW = 195;
  {$EXTERNALSYM ASN1_F_PKCS7_ISSUER_AND_SERIAL_NEW}
  ASN1_F_PKCS7_ISSUER_AND_SERIAL_NEW = 196;
  {$EXTERNALSYM ASN1_F_PKCS7_NEW}
  ASN1_F_PKCS7_NEW = 197;
  {$EXTERNALSYM ASN1_F_PKCS7_RECIP_INFO_NEW}
  ASN1_F_PKCS7_RECIP_INFO_NEW = 198;
  {$EXTERNALSYM ASN1_F_PKCS7_SIGNED_NEW}
  ASN1_F_PKCS7_SIGNED_NEW = 199;
  {$EXTERNALSYM ASN1_F_PKCS7_SIGNER_INFO_NEW}
  ASN1_F_PKCS7_SIGNER_INFO_NEW = 200;
  {$EXTERNALSYM ASN1_F_PKCS7_SIGN_ENVELOPE_NEW}
  ASN1_F_PKCS7_SIGN_ENVELOPE_NEW = 201;
  {$EXTERNALSYM ASN1_F_PKCS8_PRIV_KEY_INFO_NEW}
  ASN1_F_PKCS8_PRIV_KEY_INFO_NEW = 252;
  {$EXTERNALSYM ASN1_F_PKEY_USAGE_PERIOD_NEW}
  ASN1_F_PKEY_USAGE_PERIOD_NEW = 240;
  {$EXTERNALSYM ASN1_F_POLICYINFO_NEW}
  ASN1_F_POLICYINFO_NEW = 273;
  {$EXTERNALSYM ASN1_F_POLICYQUALINFO_NEW}
  ASN1_F_POLICYQUALINFO_NEW = 274;
  {$EXTERNALSYM ASN1_F_SXNETID_NEW}
  ASN1_F_SXNETID_NEW = 244;
  {$EXTERNALSYM ASN1_F_SXNET_NEW}
  ASN1_F_SXNET_NEW = 242;
  {$EXTERNALSYM ASN1_F_USERNOTICE_NEW}
  ASN1_F_USERNOTICE_NEW = 275;
  {$EXTERNALSYM ASN1_F_X509_ALGOR_NEW}
  ASN1_F_X509_ALGOR_NEW = 202;
  {$EXTERNALSYM ASN1_F_X509_ATTRIBUTE_NEW}
  ASN1_F_X509_ATTRIBUTE_NEW = 203;
  {$EXTERNALSYM ASN1_F_X509_CINF_NEW}
  ASN1_F_X509_CINF_NEW = 204;
  {$EXTERNALSYM ASN1_F_X509_CRL_INFO_NEW}
  ASN1_F_X509_CRL_INFO_NEW = 205;
  {$EXTERNALSYM ASN1_F_X509_CRL_NEW}
  ASN1_F_X509_CRL_NEW = 206;
  {$EXTERNALSYM ASN1_F_X509_DHPARAMS_NEW}
  ASN1_F_X509_DHPARAMS_NEW = 207;
  {$EXTERNALSYM ASN1_F_X509_EXTENSION_NEW}
  ASN1_F_X509_EXTENSION_NEW = 208;
  {$EXTERNALSYM ASN1_F_X509_INFO_NEW}
  ASN1_F_X509_INFO_NEW = 209;
  {$EXTERNALSYM ASN1_F_X509_KEY_NEW}
  ASN1_F_X509_KEY_NEW = 210;
  {$EXTERNALSYM ASN1_F_X509_NAME_ENTRY_NEW}
  ASN1_F_X509_NAME_ENTRY_NEW = 211;
  {$EXTERNALSYM ASN1_F_X509_NAME_NEW}
  ASN1_F_X509_NAME_NEW = 212;
  {$EXTERNALSYM ASN1_F_X509_NEW}
  ASN1_F_X509_NEW = 213;
  {$EXTERNALSYM ASN1_F_X509_PKEY_NEW}
  ASN1_F_X509_PKEY_NEW = 214;
  {$EXTERNALSYM ASN1_F_X509_PUBKEY_NEW}
  ASN1_F_X509_PUBKEY_NEW = 215;
  {$EXTERNALSYM ASN1_F_X509_REQ_INFO_NEW}
  ASN1_F_X509_REQ_INFO_NEW = 216;
  {$EXTERNALSYM ASN1_F_X509_REQ_NEW}
  ASN1_F_X509_REQ_NEW = 217;
  {$EXTERNALSYM ASN1_F_X509_REVOKED_NEW}
  ASN1_F_X509_REVOKED_NEW = 218;
  {$EXTERNALSYM ASN1_F_X509_SIG_NEW}
  ASN1_F_X509_SIG_NEW = 219;
  {$EXTERNALSYM ASN1_F_X509_VAL_FREE}
  ASN1_F_X509_VAL_FREE = 220;
  {$EXTERNALSYM ASN1_F_X509_VAL_NEW}
  ASN1_F_X509_VAL_NEW = 221;
  {$EXTERNALSYM ASN1_OBJECT_FLAG_CRITICAL}
  ASN1_OBJECT_FLAG_CRITICAL = $02;
  {$EXTERNALSYM ASN1_OBJECT_FLAG_DYNAMIC}
  ASN1_OBJECT_FLAG_DYNAMIC = $01;
  {$EXTERNALSYM ASN1_OBJECT_FLAG_DYNAMIC_DATA}
  ASN1_OBJECT_FLAG_DYNAMIC_DATA = $08;
  {$EXTERNALSYM ASN1_OBJECT_FLAG_DYNAMIC_STRINGS}
  ASN1_OBJECT_FLAG_DYNAMIC_STRINGS = $04;
  {$EXTERNALSYM ASN1_R_ADDING_OBJECT}
  ASN1_R_ADDING_OBJECT = 171;
  {$EXTERNALSYM ASN1_R_ASN1_PARSE_ERROR}
  ASN1_R_ASN1_PARSE_ERROR= 198;
  {$EXTERNALSYM ASN1_R_ASN1_SIG_PARSE_ERROR}
  ASN1_R_ASN1_SIG_PARSE_ERROR = 199;

  {$EXTERNALSYM ASN1_R_AUX_ERROR}
  ASN1_R_AUX_ERROR = 100;
  {$EXTERNALSYM ASN1_R_BAD_CLASS}
  ASN1_R_BAD_CLASS = 101;
  {$EXTERNALSYM ASN1_R_BAD_OBJECT_HEADER}
  ASN1_R_BAD_OBJECT_HEADER = 102;
  {$EXTERNALSYM ASN1_R_BAD_PASSWORD_READ}
  ASN1_R_BAD_PASSWORD_READ = 103;
  {$EXTERNALSYM ASN1_R_BAD_TAG}
  ASN1_R_BAD_TAG = 104;
  {$EXTERNALSYM ASN1_R_BMPSTRING_IS_WRONG_LENGTH}
  ASN1_R_BMPSTRING_IS_WRONG_LENGTH = 210;
  {$EXTERNALSYM ASN1_R_BN_LIB}
  ASN1_R_BN_LIB	= 105;
  {$EXTERNALSYM ASN1_R_BOOLEAN_IS_WRONG_LENGTH}
  ASN1_R_BOOLEAN_IS_WRONG_LENGTH = 106;
  {$EXTERNALSYM ASN1_R_BUFFER_TOO_SMALL}
  ASN1_R_BUFFER_TOO_SMALL = 107;
  {$EXTERNALSYM ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER}
  ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER = 108;
  {$EXTERNALSYM ASN1_R_DATA_IS_WRONG}
  ASN1_R_DATA_IS_WRONG = 109;
  {$EXTERNALSYM ASN1_R_DECODE_ERROR}
  ASN1_R_DECODE_ERROR	= 110;
  {$EXTERNALSYM ASN1_R_DECODING_ERROR}
  ASN1_R_DECODING_ERROR = 111;
  {$EXTERNALSYM ASN1_R_DEPTH_EXCEEDED}
  ASN1_R_DEPTH_EXCEEDED	= 174;
  {$EXTERNALSYM ASN1_R_ENCODE_ERROR}
  ASN1_R_ENCODE_ERROR = 112;
  {$EXTERNALSYM ASN1_R_ERROR_GETTING_TIME}
  ASN1_R_ERROR_GETTING_TIME	= 173;
  {$EXTERNALSYM ASN1_R_ERROR_LOADING_SECTION}
  ASN1_R_ERROR_LOADING_SECTION = 172;
  {$EXTERNALSYM ASN1_R_ERROR_PARSING_SET_ELEMENT}
  ASN1_R_ERROR_PARSING_SET_ELEMENT = 113;
  {$EXTERNALSYM ASN1_R_ERROR_SETTING_CIPHER_PARAMS}
  ASN1_R_ERROR_SETTING_CIPHER_PARAMS = 114;
  {$EXTERNALSYM ASN1_R_EXPECTING_AN_INTEGER}
  ASN1_R_EXPECTING_AN_INTEGER = 115;
  {$EXTERNALSYM ASN1_R_EXPECTING_AN_OBJECT}
  ASN1_R_EXPECTING_AN_OBJECT = 116;
  {$EXTERNALSYM ASN1_R_EXPECTING_A_BOOLEAN}
  ASN1_R_EXPECTING_A_BOOLEAN = 117;
  {$EXTERNALSYM ASN1_R_EXPECTING_A_TIME}
  ASN1_R_EXPECTING_A_TIME	= 118;
  {$EXTERNALSYM ASN1_R_EXPLICIT_LENGTH_MISMATCH}
  ASN1_R_EXPLICIT_LENGTH_MISMATCH = 119;
  {$EXTERNALSYM ASN1_R_EXPLICIT_TAG_NOT_CONSTRUCTED}
  ASN1_R_EXPLICIT_TAG_NOT_CONSTRUCTED	= 120;
  {$EXTERNALSYM ASN1_R_FIELD_MISSING}
  ASN1_R_FIELD_MISSING = 121;
  {$EXTERNALSYM ASN1_R_FIRST_NUM_TOO_LARGE}
  ASN1_R_FIRST_NUM_TOO_LARGE = 122;
  {$EXTERNALSYM ASN1_R_HEADER_TOO_LONG}
  ASN1_R_HEADER_TOO_LONG = 123;
  {$EXTERNALSYM ASN1_R_ILLEGAL_BITSTRING_FORMAT}
  ASN1_R_ILLEGAL_BITSTRING_FORMAT = 175;
  {$EXTERNALSYM ASN1_R_ILLEGAL_BOOLEAN}
  ASN1_R_ILLEGAL_BOOLEAN = 176;
  {$EXTERNALSYM ASN1_R_ILLEGAL_CHARACTERS}
  ASN1_R_ILLEGAL_CHARACTERS = 124;
  {$EXTERNALSYM ASN1_R_ILLEGAL_FORMAT}
  ASN1_R_ILLEGAL_FORMAT = 177;
  {$EXTERNALSYM ASN1_R_ILLEGAL_HEX}
  ASN1_R_ILLEGAL_HEX = 178;
  {$EXTERNALSYM ASN1_R_ILLEGAL_IMPLICIT_TAG}
  ASN1_R_ILLEGAL_IMPLICIT_TAG = 179;
  {$EXTERNALSYM ASN1_R_ILLEGAL_INTEGER}
  ASN1_R_ILLEGAL_INTEGER = 180;
  {$EXTERNALSYM ASN1_R_ILLEGAL_NESTED_TAGGING}
  ASN1_R_ILLEGAL_NESTED_TAGGING	= 181;
  {$EXTERNALSYM ASN1_R_ILLEGAL_NULL}
  ASN1_R_ILLEGAL_NULL = 125;
  {$EXTERNALSYM ASN1_R_ILLEGAL_NULL_VALUE}
  ASN1_R_ILLEGAL_NULL_VALUE	= 182;
  {$EXTERNALSYM ASN1_R_ILLEGAL_OBJECT}
  ASN1_R_ILLEGAL_OBJECT = 183;
  {$EXTERNALSYM ASN1_R_ILLEGAL_OPTIONAL_ANY}
  ASN1_R_ILLEGAL_OPTIONAL_ANY = 126;
  {$EXTERNALSYM ASN1_R_ILLEGAL_OPTIONS_ON_ITEM_TEMPLATE}
  ASN1_R_ILLEGAL_OPTIONS_ON_ITEM_TEMPLATE = 170;
  {$EXTERNALSYM ASN1_R_ILLEGAL_TAGGED_ANY}
  ASN1_R_ILLEGAL_TAGGED_ANY = 127;
  {$EXTERNALSYM ASN1_R_ILLEGAL_TIME_VALUE}
  ASN1_R_ILLEGAL_TIME_VALUE = 184;
  {$EXTERNALSYM ASN1_R_INTEGER_NOT_ASCII_FORMAT}
  ASN1_R_INTEGER_NOT_ASCII_FORMAT = 185;
  {$EXTERNALSYM ASN1_R_INTEGER_TOO_LARGE_FOR_LONG}
  ASN1_R_INTEGER_TOO_LARGE_FOR_LONG = 128;
  {$EXTERNALSYM ASN1_R_INVALID_BMPSTRING_LENGTH}
  ASN1_R_INVALID_BMPSTRING_LENGTH = 129;
  {$EXTERNALSYM ASN1_R_INVALID_DIGIT}
  ASN1_R_INVALID_DIGIT = 130;
  {$EXTERNALSYM ASN1_R_INVALID_MIME_TYPE}
  ASN1_R_INVALID_MIME_TYPE = 200;
  {$EXTERNALSYM ASN1_R_INVALID_MODIFIER}
  ASN1_R_INVALID_MODIFIER = 186;
  {$EXTERNALSYM ASN1_R_INVALID_NUMBER}
  ASN1_R_INVALID_NUMBER = 187;
  {$EXTERNALSYM ASN1_R_INVALID_OBJECT_ENCODING}
  ASN1_R_INVALID_OBJECT_ENCODING = 212;

  {$EXTERNALSYM ASN1_R_INVALID_SEPARATOR}
  ASN1_R_INVALID_SEPARATOR = 131;
  {$EXTERNALSYM ASN1_R_INVALID_TIME_FORMAT}
  ASN1_R_INVALID_TIME_FORMAT = 132;
  {$EXTERNALSYM ASN1_R_INVALID_UNIVERSALSTRING_LENGTH}
  ASN1_R_INVALID_UNIVERSALSTRING_LENGTH	= 133;
  {$EXTERNALSYM ASN1_R_INVALID_UTF8STRING}
  ASN1_R_INVALID_UTF8STRING	= 134;
  {$EXTERNALSYM ASN1_R_IV_TOO_LARGE}
  ASN1_R_IV_TOO_LARGE	= 135;
  {$EXTERNALSYM ASN1_R_LENGTH_ERROR}
  ASN1_R_LENGTH_ERROR	= 136;
  {$EXTERNALSYM ASN1_R_LIST_ERROR}
  ASN1_R_LIST_ERROR	= 188;
  {$EXTERNALSYM ASN1_R_MIME_NO_CONTENT_TYPE}
  ASN1_R_MIME_NO_CONTENT_TYPE	= 201;
  {$EXTERNALSYM ASN1_R_MIME_PARSE_ERROR}
  ASN1_R_MIME_PARSE_ERROR	= 202;
  {$EXTERNALSYM ASN1_R_MIME_SIG_PARSE_ERROR}
  ASN1_R_MIME_SIG_PARSE_ERROR	= 203;
  {$EXTERNALSYM ASN1_R_MISSING_EOC}
  ASN1_R_MISSING_EOC = 137;
  {$EXTERNALSYM ASN1_R_MISSING_SECOND_NUMBER}
  ASN1_R_MISSING_SECOND_NUMBER = 138;
  {$EXTERNALSYM ASN1_R_MISSING_VALUE}
  ASN1_R_MISSING_VALUE = 189;
  {$EXTERNALSYM ASN1_R_MSTRING_NOT_UNIVERSAL}
  ASN1_R_MSTRING_NOT_UNIVERSAL = 139;
  {$EXTERNALSYM ASN1_R_MSTRING_WRONG_TAG}
  ASN1_R_MSTRING_WRONG_TAG = 140;
  {$EXTERNALSYM ASN1_R_NESTED_ASN1_STRING}
  ASN1_R_NESTED_ASN1_STRING	= 197;
  {$EXTERNALSYM ASN1_R_NON_HEX_CHARACTERS}
  ASN1_R_NON_HEX_CHARACTERS = 141;
  {$EXTERNALSYM ASN1_R_NOT_ASCII_FORMAT}
  ASN1_R_NOT_ASCII_FORMAT	= 190;
  {$EXTERNALSYM ASN1_R_NOT_ENOUGH_DATA}
  ASN1_R_NOT_ENOUGH_DATA = 142;
  {$EXTERNALSYM ASN1_R_NO_CONTENT_TYPE}
  ASN1_R_NO_CONTENT_TYPE = 204;
  {$EXTERNALSYM ASN1_R_NO_MATCHING_CHOICE_TYPE}
  ASN1_R_NO_MATCHING_CHOICE_TYPE = 143;
  {$EXTERNALSYM ASN1_R_NO_MULTIPART_BODY_FAILURE}
  ASN1_R_NO_MULTIPART_BODY_FAILURE = 205;
  {$EXTERNALSYM ASN1_R_NO_MULTIPART_BOUNDARY}
  ASN1_R_NO_MULTIPART_BOUNDARY = 206;
  {$EXTERNALSYM ASN1_R_NO_SIG_CONTENT_TYPE}
  ASN1_R_NO_SIG_CONTENT_TYPE = 207;
  {$EXTERNALSYM ASN1_R_NULL_IS_WRONG_LENGTH}
  ASN1_R_NULL_IS_WRONG_LENGTH	= 144;
  {$EXTERNALSYM ASN1_R_OBJECT_NOT_ASCII_FORMAT}
  ASN1_R_OBJECT_NOT_ASCII_FORMAT = 191;
  {$EXTERNALSYM ASN1_R_ODD_NUMBER_OF_CHARS}
  ASN1_R_ODD_NUMBER_OF_CHARS = 145;
  {$EXTERNALSYM ASN1_R_PRIVATE_KEY_HEADER_MISSING}
  ASN1_R_PRIVATE_KEY_HEADER_MISSING = 146;
  {$EXTERNALSYM ASN1_R_SECOND_NUMBER_TOO_LARGE}
  ASN1_R_SECOND_NUMBER_TOO_LARGE = 147;
  {$EXTERNALSYM ASN1_R_SEQUENCE_LENGTH_MISMATCH}
  ASN1_R_SEQUENCE_LENGTH_MISMATCH = 148;
  {$EXTERNALSYM ASN1_R_SEQUENCE_NOT_CONSTRUCTED}
  ASN1_R_SEQUENCE_NOT_CONSTRUCTED	= 149;
  {$EXTERNALSYM ASN1_R_SEQUENCE_OR_SET_NEEDS_CONFIG}
  ASN1_R_SEQUENCE_OR_SET_NEEDS_CONFIG = 192;
  {$EXTERNALSYM ASN1_R_SHORT_LINE}
  ASN1_R_SHORT_LINE = 150;
  {$EXTERNALSYM ASN1_R_SIG_INVALID_MIME_TYPE}
  ASN1_R_SIG_INVALID_MIME_TYPE = 208;
  {$EXTERNALSYM ASN1_R_STREAMING_NOT_SUPPORTED}
  ASN1_R_STREAMING_NOT_SUPPORTED = 209;
  {$EXTERNALSYM ASN1_R_STRING_TOO_LONG}
  ASN1_R_STRING_TOO_LONG = 151;
  {$EXTERNALSYM ASN1_R_STRING_TOO_SHORT}
  ASN1_R_STRING_TOO_SHORT	= 152;
  {$EXTERNALSYM ASN1_R_TAG_VALUE_TOO_HIGH}
  ASN1_R_TAG_VALUE_TOO_HIGH	= 153;
  {$EXTERNALSYM ASN1_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD}
  ASN1_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD = 154;
  {$EXTERNALSYM ASN1_R_TIME_NOT_ASCII_FORMAT}
  ASN1_R_TIME_NOT_ASCII_FORMAT = 193;
  {$EXTERNALSYM ASN1_R_TOO_LONG}
  ASN1_R_TOO_LONG = 155;
  {$EXTERNALSYM ASN1_R_TYPE_NOT_CONSTRUCTED}
  ASN1_R_TYPE_NOT_CONSTRUCTED	= 156;
  {$EXTERNALSYM ASN1_R_UNABLE_TO_DECODE_RSA_KEY}
  ASN1_R_UNABLE_TO_DECODE_RSA_KEY	= 157;
  {$EXTERNALSYM ASN1_R_UNABLE_TO_DECODE_RSA_PRIVATE_KEY}
  ASN1_R_UNABLE_TO_DECODE_RSA_PRIVATE_KEY	= 158;
  {$EXTERNALSYM ASN1_R_UNEXPECTED_EOC}
  ASN1_R_UNEXPECTED_EOC	= 159;
  {$EXTERNALSYM ASN1_R_UNIVERSALSTRING_IS_WRONG_LENGTH}
  ASN1_R_UNIVERSALSTRING_IS_WRONG_LENGTH = 211;
  {$EXTERNALSYM ASN1_R_UNKNOWN_FORMAT}
  ASN1_R_UNKNOWN_FORMAT	= 160;
  {$EXTERNALSYM ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM}
  ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM	= 161;
  {$EXTERNALSYM ASN1_R_UNKNOWN_OBJECT_TYPE}
  ASN1_R_UNKNOWN_OBJECT_TYPE = 162;
  {$EXTERNALSYM ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE}
  ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE = 163;
  {$EXTERNALSYM ASN1_R_UNKNOWN_TAG}
  ASN1_R_UNKNOWN_TAG = 194;
  {$EXTERNALSYM ASN1_R_UNKOWN_FORMAT}
  ASN1_R_UNKOWN_FORMAT = 195;
  {$EXTERNALSYM ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE}
  ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE = 164;
  {$EXTERNALSYM ASN1_R_UNSUPPORTED_CIPHER}
  ASN1_R_UNSUPPORTED_CIPHER = 165;
  {$EXTERNALSYM ASN1_R_UNSUPPORTED_ENCRYPTION_ALGORITHM}
  ASN1_R_UNSUPPORTED_ENCRYPTION_ALGORITHM = 166;
  {$EXTERNALSYM ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE}
  ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE = 167;
  {$EXTERNALSYM ASN1_R_UNSUPPORTED_TYPE}
  ASN1_R_UNSUPPORTED_TYPE = 196;
  {$EXTERNALSYM ASN1_R_WRONG_TAG}
  ASN1_R_WRONG_TAG = 168;
  {$EXTERNALSYM ASN1_R_WRONG_TYPE}
  ASN1_R_WRONG_TYPE = 169;

  {$EXTERNALSYM ASN1_STRING_FLAG_BITS_LEFT}
  ASN1_STRING_FLAG_BITS_LEFT = $08;
  {$EXTERNALSYM ASN1_STRING_FLAG_NDEF}
  ASN1_STRING_FLAG_NDEF = $010;
//* This flag is used by the CMS code to indicate that a string is not
// * complete and is a place holder for content when it had all been
// * accessed. The flag will be reset when content has been written to it.
// */
  {$EXTERNALSYM ASN1_STRING_FLAG_CONT}
  ASN1_STRING_FLAG_CONT = $020;
  {$EXTERNALSYM ASN1_LONG_UNDEF}
  ASN1_LONG_UNDEF = $7fffffff; //0x7fffffffL

  {$EXTERNALSYM UB_NAME}
  UB_NAME = 32768;
  {$EXTERNALSYM UB_COMMON_NAME}
  UB_COMMON_NAME = 64;
  {$EXTERNALSYM UB_LOCALITY_NAME}
  UB_LOCALITY_NAME = 128;
  {$EXTERNALSYM UB_STATE_NAME}
  UB_STATE_NAME  = 128;
  {$EXTERNALSYM UB_ORGANIZATION_NAME}
  UB_ORGANIZATION_NAME = 64;
  {$EXTERNALSYM UB_ORGANIZATION_UNIT_NAME}
  UB_ORGANIZATION_UNIT_NAME = 64;
  {$EXTERNALSYM UB_TITLE}
  UB_TITLE = 64;
  {$EXTERNALSYM UB_EMAIL_ADDRESS}
  UB_EMAIL_ADDRESS = 128;

  {$EXTERNALSYM ASN1_STRFLGS_ESC_2253}
  ASN1_STRFLGS_ESC_2253 = 1;
  {$EXTERNALSYM ASN1_STRFLGS_ESC_CTRL}
  ASN1_STRFLGS_ESC_CTRL = 2;
  {$EXTERNALSYM ASN1_STRFLGS_ESC_MSB}
  ASN1_STRFLGS_ESC_MSB = 4;
  {$EXTERNALSYM ASN1_STRFLGS_ESC_QUOTE}
  ASN1_STRFLGS_ESC_QUOTE = 8;

  {$EXTERNALSYM ASN1_STRFLGS_UTF8_CONVERT}
  ASN1_STRFLGS_UTF8_CONVERT = $10;
  {$EXTERNALSYM ASN1_STRFLGS_IGNORE_TYPE}
  ASN1_STRFLGS_IGNORE_TYPE = $20;
  {$EXTERNALSYM ASN1_STRFLGS_SHOW_TYPE}
  ASN1_STRFLGS_SHOW_TYPE = $40;
  {$EXTERNALSYM ASN1_STRFLGS_DUMP_ALL}
  ASN1_STRFLGS_DUMP_ALL = $80;
  {$EXTERNALSYM ASN1_STRFLGS_DUMP_UNKNOWN}
  ASN1_STRFLGS_DUMP_UNKNOWN = $100;
  {$EXTERNALSYM ASN1_STRFLGS_DUMP_DER}
  ASN1_STRFLGS_DUMP_DER = $200;
  {$EXTERNALSYM ASN1_STRFLGS_RFC2253}
  ASN1_STRFLGS_RFC2253  = ASN1_STRFLGS_ESC_2253 or
                                  ASN1_STRFLGS_ESC_CTRL or
                                  ASN1_STRFLGS_ESC_MSB or
                                  ASN1_STRFLGS_UTF8_CONVERT or
                                  ASN1_STRFLGS_DUMP_UNKNOWN or
                                  ASN1_STRFLGS_DUMP_DER;

  {$EXTERNALSYM BIO_BIND_NORMAL}
  BIO_BIND_NORMAL = 0;
  {$EXTERNALSYM BIO_BIND_REUSEADDR}
  BIO_BIND_REUSEADDR = 2;
  {$EXTERNALSYM BIO_BIND_REUSEADDR_IF_UNUSED}
  BIO_BIND_REUSEADDR_IF_UNUSED = 1;
  {$EXTERNALSYM BIO_CB_CTRL}
  BIO_CB_CTRL = $06;
  {$EXTERNALSYM BIO_CB_FREE}
  BIO_CB_FREE = $01;
  {$EXTERNALSYM BIO_CB_GETS}
  BIO_CB_GETS = $05;
  {$EXTERNALSYM BIO_CB_PUTS}
  BIO_CB_PUTS = $04;
  {$EXTERNALSYM BIO_CB_READ}
  BIO_CB_READ = $02;
  {$EXTERNALSYM BIO_CB_RETURN}
  BIO_CB_RETURN = $80;
  {$EXTERNALSYM BIO_CB_WRITE}
  BIO_CB_WRITE = $03;
  {$EXTERNALSYM BIO_CLOSE}
  BIO_CLOSE = $01;
  {$EXTERNALSYM BIO_CONN_S_BEFORE}
  BIO_CONN_S_BEFORE = 1;
  {$EXTERNALSYM BIO_CONN_S_BLOCKED_CONNECT}
  BIO_CONN_S_BLOCKED_CONNECT = 7;
  {$EXTERNALSYM BIO_CONN_S_CONNECT}
  BIO_CONN_S_CONNECT = 5;
  {$EXTERNALSYM BIO_CONN_S_CREATE_SOCKET}
  BIO_CONN_S_CREATE_SOCKET = 4;
  {$EXTERNALSYM BIO_CONN_S_GET_IP}
  BIO_CONN_S_GET_IP = 2;
  {$EXTERNALSYM BIO_CONN_S_GET_PORT}
  BIO_CONN_S_GET_PORT = 3;
  {$EXTERNALSYM BIO_CONN_S_NBIO}
  BIO_CONN_S_NBIO = 8;
  {$EXTERNALSYM BIO_CONN_S_OK}
  BIO_CONN_S_OK = 6;
  {$EXTERNALSYM BIO_CTRL_DUP}
  BIO_CTRL_DUP = 12;
  {$EXTERNALSYM BIO_CTRL_EOF}
  BIO_CTRL_EOF = 2;
  {$EXTERNALSYM BIO_CTRL_FLUSH}
  BIO_CTRL_FLUSH = 11;
  {$EXTERNALSYM BIO_CTRL_GET}
  BIO_CTRL_GET = 5;
  {$EXTERNALSYM BIO_CTRL_GET_CALLBACK}
  BIO_CTRL_GET_CALLBACK = 15;
  {$EXTERNALSYM BIO_CTRL_GET_CLOSE}
  BIO_CTRL_GET_CLOSE = 8;
  {$EXTERNALSYM BIO_CTRL_INFO}
  BIO_CTRL_INFO = 3;
  {$EXTERNALSYM BIO_CTRL_PENDING}
  BIO_CTRL_PENDING = 10;
  {$EXTERNALSYM BIO_CTRL_POP}
  BIO_CTRL_POP = 7;
  {$EXTERNALSYM BIO_CTRL_PUSH}
  BIO_CTRL_PUSH = 6;
  {$EXTERNALSYM BIO_CTRL_RESET}
  BIO_CTRL_RESET = 1;
  {$EXTERNALSYM BIO_CTRL_SET}
  BIO_CTRL_SET = 4;
  {$EXTERNALSYM BIO_CTRL_SET_CALLBACK}
  BIO_CTRL_SET_CALLBACK = 14;
  {$EXTERNALSYM BIO_CTRL_SET_CLOSE}
  BIO_CTRL_SET_CLOSE = 9;
  {$EXTERNALSYM BIO_CTRL_SET_FILENAME}
  BIO_CTRL_SET_FILENAME = 30;
  //* dgram BIO stuff */
  {$EXTERNALSYM BIO_CTRL_DGRAM_CONNECT}
  BIO_CTRL_DGRAM_CONNECT = 31;  //* BIO dgram special */
  {$EXTERNALSYM BIO_CTRL_DGRAM_SET_CONNECTED}
  BIO_CTRL_DGRAM_SET_CONNECTED = 32;  //* allow for an externally
					                            //* connected socket to be
					                           //* passed in */
  {$EXTERNALSYM BIO_CTRL_DGRAM_SET_RECV_TIMEOUT}
  BIO_CTRL_DGRAM_SET_RECV_TIMEOUT = 33; //* setsockopt, essentially */
  {$EXTERNALSYM BIO_CTRL_DGRAM_GET_RECV_TIMEOUT}
  BIO_CTRL_DGRAM_GET_RECV_TIMEOUT = 34; //* getsockopt, essentially */
  {$EXTERNALSYM BIO_CTRL_DGRAM_SET_SEND_TIMEOUT}
  BIO_CTRL_DGRAM_SET_SEND_TIMEOUT = 35; //* setsockopt, essentially */
  {$EXTERNALSYM BIO_CTRL_DGRAM_GET_SEND_TIMEOUT}
  BIO_CTRL_DGRAM_GET_SEND_TIMEOUT = 36; //* getsockopt, essentially */

  {$EXTERNALSYM BIO_CTRL_DGRAM_GET_RECV_TIMER_EXP}
  BIO_CTRL_DGRAM_GET_RECV_TIMER_EXP = 37; //* flag whether the last */
  {$EXTERNALSYM BIO_CTRL_DGRAM_GET_SEND_TIMER_EXP}
  BIO_CTRL_DGRAM_GET_SEND_TIMER_EXP = 38; //* I/O operation tiemd out */


//* #ifdef IP_MTU_DISCOVER */
  {$EXTERNALSYM BIO_CTRL_DGRAM_MTU_DISCOVER}
  BIO_CTRL_DGRAM_MTU_DISCOVER = 39; //* set DF bit on egress packets */
//* #endif */

  {$EXTERNALSYM BIO_CTRL_DGRAM_QUERY_MTU}
  BIO_CTRL_DGRAM_QUERY_MTU    = 40; //* as kernel for current MTU */
  {$EXTERNALSYM BIO_CTRL_DGRAM_GET_MTU}
  BIO_CTRL_DGRAM_GET_MTU      = 41; //* get cached value for MTU */
  {$EXTERNALSYM BIO_CTRL_DGRAM_SET_MTU}
  BIO_CTRL_DGRAM_SET_MTU      = 42; //* set cached value for
					                          // * MTU. want to use this
				                            // * if asking the kernel
					                         // * fails */

  {$EXTERNALSYM BIO_CTRL_DGRAM_MTU_EXCEEDED}
  BIO_CTRL_DGRAM_MTU_EXCEEDED  = 43; //* check whether the MTU
					     // * was exceed in the
					     // * previous write
					     // * operation */
  {$EXTERNALSYM BIO_CTRL_DGRAM_GET_PEER}
  BIO_CTRL_DGRAM_GET_PEER      = 46;

  {$EXTERNALSYM BIO_CTRL_DGRAM_SET_PEER}
  BIO_CTRL_DGRAM_SET_PEER      = 44; //* Destination for the data */
  {$EXTERNALSYM BIO_CTRL_DGRAM_SET_NEXT_TIMEOUT}
  BIO_CTRL_DGRAM_SET_NEXT_TIMEOUT = 45; //* Next DTLS handshake timeout to

  {$EXTERNALSYM BIO_CTRL_WPENDING}
  BIO_CTRL_WPENDING = 13;
  {$EXTERNALSYM BIO_C_DESTROY_BIO_PAIR}
  BIO_C_DESTROY_BIO_PAIR = 139;
  {$EXTERNALSYM BIO_C_DO_STATE_MACHINE}
  BIO_C_DO_STATE_MACHINE = 101;
  {$EXTERNALSYM BIO_C_FILE_SEEK}
  BIO_C_FILE_SEEK = 128;
  {$EXTERNALSYM BIO_C_FILE_TELL}
  BIO_C_FILE_TELL = 133;
  {$EXTERNALSYM BIO_C_GET_ACCEPT}
  BIO_C_GET_ACCEPT = 124;
  {$EXTERNALSYM BIO_C_GET_BIND_MODE}
  BIO_C_GET_BIND_MODE = 132;
  {$EXTERNALSYM BIO_C_GET_BUFF_NUM_LINES}
  BIO_C_GET_BUFF_NUM_LINES = 116;
  {$EXTERNALSYM BIO_C_GET_BUF_MEM_PTR}
  BIO_C_GET_BUF_MEM_PTR = 115;
  {$EXTERNALSYM BIO_C_GET_CIPHER_CTX}
  BIO_C_GET_CIPHER_CTX = 129;
  {$EXTERNALSYM BIO_C_GET_CIPHER_STATUS}
  BIO_C_GET_CIPHER_STATUS = 113;
  {$EXTERNALSYM BIO_C_GET_CONNECT}
  BIO_C_GET_CONNECT = 123;
  {$EXTERNALSYM BIO_C_GET_FD}
  BIO_C_GET_FD = 105;
  {$EXTERNALSYM BIO_C_GET_FILE_PTR}
  BIO_C_GET_FILE_PTR = 107;
  {$EXTERNALSYM BIO_C_GET_MD}
  BIO_C_GET_MD = 112;
  {$EXTERNALSYM BIO_C_GET_MD_CTX}
  BIO_C_GET_MD_CTX = 120;

  {$EXTERNALSYM BIO_C_GET_PROXY_PARAM}
  BIO_C_GET_PROXY_PARAM = 121;
  {$EXTERNALSYM BIO_C_GET_READ_REQUEST}
  BIO_C_GET_READ_REQUEST = 141;
  {$EXTERNALSYM BIO_C_GET_SOCKS}
  BIO_C_GET_SOCKS = 134;

  {$EXTERNALSYM BIO_C_GET_SSL}
  BIO_C_GET_SSL = 110;
  {$EXTERNALSYM BIO_C_GET_SSL_NUM_RENEGOTIATES}
  BIO_C_GET_SSL_NUM_RENEGOTIATES = 126;
  {$EXTERNALSYM BIO_C_GET_WRITE_BUF_SIZE}
  BIO_C_GET_WRITE_BUF_SIZE = 137;
  {$EXTERNALSYM BIO_C_GET_WRITE_GUARANTEE}
  BIO_C_GET_WRITE_GUARANTEE = 140;
  {$EXTERNALSYM BIO_C_MAKE_BIO_PAIR}
  BIO_C_MAKE_BIO_PAIR = 138;
  {$EXTERNALSYM BIO_C_SET_ACCEPT}
  BIO_C_SET_ACCEPT = 118;
  {$EXTERNALSYM BIO_C_SET_BIND_MODE}
  BIO_C_SET_BIND_MODE = 131;
  {$EXTERNALSYM BIO_C_SET_BUFF_READ_DATA}
  BIO_C_SET_BUFF_READ_DATA = 122;
  {$EXTERNALSYM BIO_C_SET_BUFF_SIZE}
  BIO_C_SET_BUFF_SIZE = 117;
  {$EXTERNALSYM BIO_C_SET_BUF_MEM}
  BIO_C_SET_BUF_MEM = 114;
  {$EXTERNALSYM BIO_C_SET_BUF_MEM_EOF_RETURN}
  BIO_C_SET_BUF_MEM_EOF_RETURN = 130;
  {$EXTERNALSYM BIO_C_SET_CONNECT}
  BIO_C_SET_CONNECT = 100;
  {$EXTERNALSYM BIO_C_SET_FD}
  BIO_C_SET_FD = 104;
  {$EXTERNALSYM BIO_C_SET_FILENAME}
  BIO_C_SET_FILENAME = 108;
  {$EXTERNALSYM BIO_C_SET_FILE_PTR}
  BIO_C_SET_FILE_PTR = 106;
  {$EXTERNALSYM BIO_C_SET_MD}
  BIO_C_SET_MD = 111;
  {$EXTERNALSYM BIO_C_SET_NBIO}
  BIO_C_SET_NBIO = 102;
  {$EXTERNALSYM BIO_C_SET_PROXY_PARAM}
  BIO_C_SET_PROXY_PARAM = 103;
  {$EXTERNALSYM BIO_C_SET_SOCKS}
  BIO_C_SET_SOCKS = 135;
  {$EXTERNALSYM BIO_C_SET_SSL}
  BIO_C_SET_SSL = 109;
  {$EXTERNALSYM BIO_C_SET_SSL_RENEGOTIATE_BYTES}
  BIO_C_SET_SSL_RENEGOTIATE_BYTES = 125;
  {$EXTERNALSYM BIO_C_SET_SSL_RENEGOTIATE_TIMEOUT}
  BIO_C_SET_SSL_RENEGOTIATE_TIMEOUT = 127;
  {$EXTERNALSYM BIO_C_SET_WRITE_BUF_SIZE}
  BIO_C_SET_WRITE_BUF_SIZE = 136;
  {$EXTERNALSYM BIO_C_SHUTDOWN_WR}
  BIO_C_SHUTDOWN_WR = 142;
  {$EXTERNALSYM BIO_C_NREAD0}
  BIO_C_NREAD0 = 143;
  {$EXTERNALSYM BIO_C_NREAD}
  BIO_C_NREAD = 144;
  {$EXTERNALSYM BIO_C_NWRITE0}
  BIO_C_NWRITE0 = 145;
  {$EXTERNALSYM BIO_C_NWRITE}
  BIO_C_NWRITE = 146;
  {$EXTERNALSYM BIO_C_RESET_READ_REQUEST}
  BIO_C_RESET_READ_REQUEST = 147;
  {$EXTERNALSYM BIO_C_SET_MD_CTX}
  BIO_C_SET_MD_CTX = 148;
  {$EXTERNALSYM BIO_C_SSL_MODE}
  BIO_C_SSL_MODE = 119;
  {$EXTERNALSYM BIO_FLAGS_BASE64_NO_NL}
  BIO_FLAGS_BASE64_NO_NL = $100;
  {$EXTERNALSYM BIO_FLAGS_IO_SPECIAL}
  BIO_FLAGS_IO_SPECIAL = $04;
  {$EXTERNALSYM BIO_FLAGS_READ}
  BIO_FLAGS_READ = $01;
  {$EXTERNALSYM BIO_FLAGS_WRITE}
  BIO_FLAGS_WRITE = $02;
  {$EXTERNALSYM BIO_FLAGS_RWS}
  BIO_FLAGS_RWS = BIO_FLAGS_READ or
                          BIO_FLAGS_WRITE or
                          BIO_FLAGS_IO_SPECIAL;
  {$EXTERNALSYM BIO_FLAGS_SHOULD_RETRY}
  BIO_FLAGS_SHOULD_RETRY = $08;
  {$EXTERNALSYM BIO_FP_APPEND}
  BIO_FP_APPEND = $08;
  {$EXTERNALSYM BIO_FP_READ}
  BIO_FP_READ = $02;
  {$EXTERNALSYM BIO_FP_TEXT}
  BIO_FP_TEXT = $10;
  {$EXTERNALSYM BIO_FP_WRITE}
  BIO_FP_WRITE = $04;
  {$EXTERNALSYM BIO_F_ACPT_STATE}
  BIO_F_ACPT_STATE = 100;
  {$EXTERNALSYM BIO_F_BIO_ACCEPT}
  BIO_F_BIO_ACCEPT = 101;
  {$EXTERNALSYM BIO_F_BIO_BER_GET_HEADER}
  BIO_F_BIO_BER_GET_HEADER = 102;
  {$EXTERNALSYM BIO_F_BIO_CTRL}
  BIO_F_BIO_CTRL = 103;
  {$EXTERNALSYM BIO_F_BIO_GETHOSTBYNAME}
  BIO_F_BIO_GETHOSTBYNAME = 120;
  {$EXTERNALSYM BIO_F_BIO_GETS}
  BIO_F_BIO_GETS = 104;
  {$EXTERNALSYM BIO_F_BIO_GET_ACCEPT_SOCKET}
  BIO_F_BIO_GET_ACCEPT_SOCKET = 105;
  {$EXTERNALSYM BIO_F_BIO_GET_HOST_IP}
  BIO_F_BIO_GET_HOST_IP = 106;
  {$EXTERNALSYM BIO_F_BIO_GET_PORT}
  BIO_F_BIO_GET_PORT = 107;
  {$EXTERNALSYM BIO_F_BIO_MAKE_PAIR}
  BIO_F_BIO_MAKE_PAIR = 121;
  {$EXTERNALSYM BIO_F_BIO_NEW}
  BIO_F_BIO_NEW = 108;
  {$EXTERNALSYM BIO_F_BIO_NEW_FILE}
  BIO_F_BIO_NEW_FILE = 109;
  {$EXTERNALSYM BIO_F_BIO_PUTS}
  BIO_F_BIO_PUTS = 110;
  {$EXTERNALSYM BIO_F_BIO_READ}
  BIO_F_BIO_READ = 111;
  {$EXTERNALSYM BIO_F_BIO_SOCK_INIT}
  BIO_F_BIO_SOCK_INIT = 112;
  {$EXTERNALSYM BIO_F_BIO_WRITE}
  BIO_F_BIO_WRITE = 113;
  {$EXTERNALSYM BIO_F_BUFFER_CTRL}
  BIO_F_BUFFER_CTRL = 114;
  {$EXTERNALSYM BIO_F_CONN_STATE}
  BIO_F_CONN_STATE = 115;
  {$EXTERNALSYM BIO_F_FILE_CTRL}
  BIO_F_FILE_CTRL = 116;
  {$EXTERNALSYM BIO_F_MEM_WRITE}
  BIO_F_MEM_WRITE = 117;
  {$EXTERNALSYM BIO_F_SSL_NEW}
  BIO_F_SSL_NEW = 118;
  {$EXTERNALSYM BIO_F_WSASTARTUP}
  BIO_F_WSASTARTUP = 119;
  {$EXTERNALSYM BIO_GHBN_CTRL_CACHE_SIZE}
  BIO_GHBN_CTRL_CACHE_SIZE = 3;
  {$EXTERNALSYM BIO_GHBN_CTRL_FLUSH}
  BIO_GHBN_CTRL_FLUSH = 5;
  {$EXTERNALSYM BIO_GHBN_CTRL_GET_ENTRY}
  BIO_GHBN_CTRL_GET_ENTRY = 4;
  {$EXTERNALSYM BIO_GHBN_CTRL_HITS}
  BIO_GHBN_CTRL_HITS = 1;
  {$EXTERNALSYM BIO_GHBN_CTRL_MISSES}
  BIO_GHBN_CTRL_MISSES = 2;
  {$EXTERNALSYM BIO_NOCLOSE}
  BIO_NOCLOSE = $00;
  {$EXTERNALSYM BIO_RR_CONNECT}
  BIO_RR_CONNECT = $02;
  {$EXTERNALSYM BIO_RR_SSL_X509_LOOKUP}
  BIO_RR_SSL_X509_LOOKUP = $01;
  {$EXTERNALSYM BIO_R_ACCEPT_ERROR}
  BIO_R_ACCEPT_ERROR = 100;
  {$EXTERNALSYM BIO_R_BAD_FOPEN_MODE}
  BIO_R_BAD_FOPEN_MODE = 101;
  {$EXTERNALSYM BIO_R_BAD_HOSTNAME_LOOKUP}
  BIO_R_BAD_HOSTNAME_LOOKUP = 102;
  {$EXTERNALSYM BIO_R_BROKEN_PIPE}
  BIO_R_BROKEN_PIPE = 124;
  {$EXTERNALSYM BIO_R_CONNECT_ERROR}
  BIO_R_CONNECT_ERROR = 103;
  {$EXTERNALSYM BIO_R_ERROR_SETTING_NBIO}
  BIO_R_ERROR_SETTING_NBIO = 104;
  {$EXTERNALSYM BIO_R_ERROR_SETTING_NBIO_ON_ACCEPTED_SOCKET}
  BIO_R_ERROR_SETTING_NBIO_ON_ACCEPTED_SOCKET = 105;
  {$EXTERNALSYM BIO_R_ERROR_SETTING_NBIO_ON_ACCEPT_SOCKET}
  BIO_R_ERROR_SETTING_NBIO_ON_ACCEPT_SOCKET = 106;
  {$EXTERNALSYM BIO_R_GETHOSTBYNAME_ADDR_IS_NOT_AF_INET}
  BIO_R_GETHOSTBYNAME_ADDR_IS_NOT_AF_INET = 107;
  {$EXTERNALSYM BIO_R_INVALID_ARGUMENT}
  BIO_R_INVALID_ARGUMENT = 125;
  {$EXTERNALSYM BIO_R_INVALID_IP_ADDRESS}
  BIO_R_INVALID_IP_ADDRESS = 108;
  {$EXTERNALSYM BIO_R_IN_USE}
  BIO_R_IN_USE = 123;
  {$EXTERNALSYM BIO_R_KEEPALIVE}
  BIO_R_KEEPALIVE = 109;
  {$EXTERNALSYM BIO_R_NBIO_CONNECT_ERROR}
  BIO_R_NBIO_CONNECT_ERROR = 110;
  {$EXTERNALSYM BIO_R_NO_ACCEPT_PORT_SPECIFIED}
  BIO_R_NO_ACCEPT_PORT_SPECIFIED = 111;
  {$EXTERNALSYM BIO_R_NO_HOSTNAME_SPECIFIED}
  BIO_R_NO_HOSTNAME_SPECIFIED = 112;
  {$EXTERNALSYM BIO_R_NO_PORT_DEFINED}
  BIO_R_NO_PORT_DEFINED = 113;
  {$EXTERNALSYM BIO_R_NO_PORT_SPECIFIED}
  BIO_R_NO_PORT_SPECIFIED = 114;
  {$EXTERNALSYM BIO_R_NULL_PARAMETER}
  BIO_R_NULL_PARAMETER = 115;
  {$EXTERNALSYM BIO_R_TAG_MISMATCH}
  BIO_R_TAG_MISMATCH = 116;
  {$EXTERNALSYM BIO_R_UNABLE_TO_BIND_SOCKET}
  BIO_R_UNABLE_TO_BIND_SOCKET = 117;
  {$EXTERNALSYM BIO_R_UNABLE_TO_CREATE_SOCKET}
  BIO_R_UNABLE_TO_CREATE_SOCKET = 118;
  {$EXTERNALSYM BIO_R_UNABLE_TO_LISTEN_SOCKET}
  BIO_R_UNABLE_TO_LISTEN_SOCKET = 119;
  {$EXTERNALSYM BIO_R_UNINITIALIZED}
  BIO_R_UNINITIALIZED = 120;
  {$EXTERNALSYM BIO_R_UNSUPPORTED_METHOD}
  BIO_R_UNSUPPORTED_METHOD = 121;
  {$EXTERNALSYM BIO_R_WSASTARTUP}
  BIO_R_WSASTARTUP = 122;
  {$EXTERNALSYM BIO_TYPE_ACCEPT}
  BIO_TYPE_ACCEPT = 13 or $0400 or $0100;
  {$EXTERNALSYM BIO_TYPE_BASE64}
  BIO_TYPE_BASE64 = 11 or $0200;
  {$EXTERNALSYM BIO_TYPE_BER}
  BIO_TYPE_BER = 18 or $0200;
  {$EXTERNALSYM BIO_TYPE_BIO}
  BIO_TYPE_BIO = 19 or $0400;
  {$EXTERNALSYM BIO_TYPE_BUFFER}
  BIO_TYPE_BUFFER = 9 or $0200;
  {$EXTERNALSYM BIO_TYPE_CIPHER}
  BIO_TYPE_CIPHER = 10 or $0200;
  {$EXTERNALSYM BIO_TYPE_CONNECT}
  BIO_TYPE_CONNECT = 12 or $0400 or $0100;
  {$EXTERNALSYM BIO_TYPE_DESCRIPTOR}
  BIO_TYPE_DESCRIPTOR = $0100;
  {$EXTERNALSYM BIO_TYPE_FD}
  BIO_TYPE_FD = 4 or $0400 or $0100;
  {$EXTERNALSYM BIO_TYPE_FILE}
  BIO_TYPE_FILE = 2 or $0400;
  {$EXTERNALSYM BIO_TYPE_FILTER}
  BIO_TYPE_FILTER = $0200;
  {$EXTERNALSYM BIO_TYPE_MD}
  BIO_TYPE_MD = 8 or $0200;
  {$EXTERNALSYM BIO_TYPE_MEM}
  BIO_TYPE_MEM = 1 or $0400;
  {$EXTERNALSYM BIO_TYPE_NBIO_TEST}
  BIO_TYPE_NBIO_TEST = 16 or $0200;
  {$EXTERNALSYM BIO_TYPE_NONE}
  BIO_TYPE_NONE = 0;
  {$EXTERNALSYM BIO_TYPE_NULL}
  BIO_TYPE_NULL = 6 or $0400;
  {$EXTERNALSYM BIO_TYPE_NULL_FILTER}
  BIO_TYPE_NULL_FILTER = 17 or $0200;
  {$EXTERNALSYM BIO_TYPE_PROXY_CLIENT}
  BIO_TYPE_PROXY_CLIENT = 14 or $0200;
  {$EXTERNALSYM BIO_TYPE_PROXY_SERVER}
  BIO_TYPE_PROXY_SERVER = 15 or $0200;
  {$EXTERNALSYM BIO_TYPE_SOCKET}
  BIO_TYPE_SOCKET = 5 or $0400 or $0100;
  {$EXTERNALSYM BIO_TYPE_SOURCE_SINK}
  BIO_TYPE_SOURCE_SINK = $0400;
  {$EXTERNALSYM BIO_TYPE_SSL}
  BIO_TYPE_SSL = 7 or $0200;
  {$EXTERNALSYM BIO_TYPE_LINEBUFFER}
  BIO_TYPE_LINEBUFFER = 20 or $0200;
  {$EXTERNALSYM BIO_TYPE_DGRAM}
  BIO_TYPE_DGRAM = 21 or $0400 or $0100;
  {$EXTERNALSYM BIO_TYPE_COMP}
  BIO_TYPE_COMP = 23 or $0200;

  {$IFDEF SIXTY_FOUR_BIT_LONG}
  {$EXTERNALSYM BN_BITS}
  BN_BITS = 128;
  {$EXTERNALSYM BN_BYTES}
  BN_BYTES = 8;
  {$EXTERNALSYM BN_BITS2}
  BN_BITS2 = 64;
  {$EXTERNALSYM BN_BITS4}
  BN_BITS4 = 32;
  {$EXTERNALSYM BN_DEC_FMT1}
  BN_DEC_FMT1 = '%lu'; {Do not localize}
  {$EXTERNALSYM BN_DEC_FMT2}
  BN_DEC_FMT2 = '%019lu'; {Do not localize}
  {$EXTERNALSYM BN_DEC_NUM}
  BN_DEC_NUM = 19;
  {$ENDIF}
  {$IFDEF SIXTY_FOUR_BIT}
    {$UNDEF BN_LLONG}
    {$UNDEF BN_ULLONG}
  {$EXTERNALSYM OPENSSL_BN_BITS}
  OPENSSL_BN_BITS = 128;
  {$EXTERNALSYM OPENSSL_BN_BYTES}
  OPENSSL_BN_BYTES = 8;
  {$EXTERNALSYM OPENSSL_BN_BITS2}
  OPENSSL_BN_BITS2 = 64;
  {$EXTERNALSYM OPENSSL_BN_BITS4}
  OPENSSL_BN_BITS4 = 32;
  {$EXTERNALSYM OPENSSL_BN_DEC_FMT1}
  OPENSSL_BN_DEC_FMT1 = '%llu';  {Do not localize}
  {$EXTERNALSYM OPENSSL_BN_DEC_FMT2}
  OPENSSL_BN_DEC_FMT2 = '%019llu';  {Do not localize}
  {$EXTERNALSYM OPENSSL_BN_DEC_NUM}
  OPENSSL_BN_DEC_NUM = 19;
  {$ENDIF}
  {$IFDEF THIRTY_TWO_BIT}
  {$EXTERNALSYM BN_BITS}
  BN_BITS = 64;
  {$EXTERNALSYM BN_BYTES}
  BN_BYTES = 4;
  {$EXTERNALSYM BN_BITS2}
  BN_BITS2 = 32;
  {$EXTERNALSYM BN_BITS4}
  BN_BITS4 = 16;
  {$EXTERNALSYM BN_DEC_FMT1}
  BN_DEC_FMT1 = '%lu';  {Do not localize}
  {$EXTERNALSYM BN_DEC_FMT2}
  BN_DEC_FMT2 = '%09lu';  {Do not localize}
  {$EXTERNALSYM BN_DEC_NUM}
  BN_DEC_NUM = 9;
  {$ENDIF}
  {$EXTERNALSYM BN_CTX_NUM}
  BN_CTX_NUM = 12;
  {$IFNDEF OPENSSL_NO_DEPRECATED}
  {$EXTERNALSYM BN_DEFAULT_BITS}
  BN_DEFAULT_BITS = 1280;
  {$ENDIF}
  {$EXTERNALSYM BN_FLG_FREE}
  BN_FLG_FREE = $8000;
  {$EXTERNALSYM BN_FLG_MALLOCED}
  BN_FLG_MALLOCED = $01;
  {$EXTERNALSYM BN_FLG_STATIC_DATA}
  BN_FLG_STATIC_DATA = $02;
  {$EXTERNALSYM BN_FLG_CONSTTIME}
  BN_FLG_CONSTTIME = $04;
  //* avoid leaking exponent information through timing,
  //* BN_mod_exp_mont() will call BN_mod_exp_mont_consttime,
  //* BN_div() will call BN_div_no_branch,
  // * BN_mod_inverse() will call BN_mod_inverse_no_branch.
  // */
  {$IFNDEF OPENSSL_NO_DEPRECATED}
  {$EXTERNALSYM BN_FLG_EXP_CONSTTIME}
  BN_FLG_EXP_CONSTTIME = BN_FLG_CONSTTIME; //* deprecated name for the flag */
                                      //* avoid leaking exponent information through timings
                                      //* (BN_mod_exp_mont() will call BN_mod_exp_mont_consttime) */
 {$ENDIF}
  {$EXTERNALSYM BN_F_BN_BLINDING_CONVERT}
  BN_F_BN_BLINDING_CONVERT = 100;
  {$EXTERNALSYM BN_F_BN_BLINDING_INVERT}
  BN_F_BN_BLINDING_INVERT = 101;
  {$EXTERNALSYM BN_F_BN_BLINDING_NEW}
  BN_F_BN_BLINDING_NEW = 102;
  {$EXTERNALSYM BN_F_BN_BLINDING_UPDATE}
  BN_F_BN_BLINDING_UPDATE = 103;
  {$EXTERNALSYM BN_F_BN_BN2DEC}
  BN_F_BN_BN2DEC = 104;
  {$EXTERNALSYM BN_F_BN_BN2HEX}
  BN_F_BN_BN2HEX = 105;
  {$EXTERNALSYM BN_F_BN_CTX_NEW}
  BN_F_BN_CTX_NEW = 106;
  {$EXTERNALSYM BN_F_BN_DIV}
  BN_F_BN_DIV = 107;
  {$EXTERNALSYM BN_F_BN_DIV_NO_BRANCH}
  BN_F_BN_DIV_NO_BRANCH = 138;
  {$EXTERNALSYM BN_F_BN_EXPAND2}
  BN_F_BN_EXPAND2 = 108;
  {$EXTERNALSYM BN_F_BN_MOD_EXP_MONT}
  BN_F_BN_MOD_EXP_MONT = 109;
  {$EXTERNALSYM BN_F_BN_MOD_INVERSE}
  BN_F_BN_MOD_INVERSE = 110;
  {$EXTERNALSYM BN_F_BN_MOD_INVERSE_NO_BRANCH}
  BN_F_BN_MOD_INVERSE_NO_BRANCH = 139;
  {$EXTERNALSYM BN_F_BN_MOD_MUL_RECIPROCAL}
  BN_F_BN_MOD_MUL_RECIPROCAL = 111;
  {$EXTERNALSYM BN_F_BN_MPI2BN}
  BN_F_BN_MPI2BN = 112;
  {$EXTERNALSYM BN_F_BN_NEW}
  BN_F_BN_NEW = 113;
  {$EXTERNALSYM BN_F_BN_RAND}
  BN_F_BN_RAND = 114;
  {$EXTERNALSYM BN_F_BN_USUB}
  BN_F_BN_USUB = 115;
  {$EXTERNALSYM BN_MASK2}
  BN_MASK2 = $ffffffff;
  {$EXTERNALSYM BN_MASK2h}
  BN_MASK2h = $ffff0000;
  {$EXTERNALSYM BN_MASK2h1}
  BN_MASK2h1 = $ffff8000;
  {$EXTERNALSYM BN_MASK2l}
  BN_MASK2l = $ffff;
  {$EXTERNALSYM BN_R_ARG2_LT_ARG3}
  BN_R_ARG2_LT_ARG3 = 100;
  {$EXTERNALSYM BN_R_BAD_RECIPROCAL}
  BN_R_BAD_RECIPROCAL = 101;
  {$EXTERNALSYM BN_R_CALLED_WITH_EVEN_MODULUS}
  BN_R_CALLED_WITH_EVEN_MODULUS = 102;
  {$EXTERNALSYM BN_R_DIV_BY_ZERO}
  BN_R_DIV_BY_ZERO = 103;
  {$EXTERNALSYM BN_R_ENCODING_ERROR}
  BN_R_ENCODING_ERROR = 104;
  {$EXTERNALSYM BN_R_EXPAND_ON_STATIC_BIGNUM_DATA}
  BN_R_EXPAND_ON_STATIC_BIGNUM_DATA = 105;
  {$EXTERNALSYM BN_R_INVALID_LENGTH}
  BN_R_INVALID_LENGTH = 106;
  {$EXTERNALSYM BN_R_NOT_INITIALIZED}
  BN_R_NOT_INITIALIZED = 107;
  {$EXTERNALSYM BN_R_NO_INVERSE}
  BN_R_NO_INVERSE = 108;
  {$EXTERNALSYM BN_TBIT}
  BN_TBIT = $80000000;
  {$EXTERNALSYM BUFSIZ}
  BUFSIZ = 1024;
  {$EXTERNALSYM BUF_F_BUF_MEM_GROW}
  BUF_F_BUF_MEM_GROW = 100;
  {$EXTERNALSYM BUF_F_BUF_MEM_NEW}
  BUF_F_BUF_MEM_NEW = 101;
  {$EXTERNALSYM BUF_F_BUF_STRDUP}
  BUF_F_BUF_STRDUP = 102;

  //function codes
  {$EXTERNALSYM RAND_F_ENG_RAND_GET_RAND_METHOD}
  RAND_F_ENG_RAND_GET_RAND_METHOD			= 108;
  {$EXTERNALSYM RAND_F_FIPS_RAND}
  RAND_F_FIPS_RAND				= 103;
  {$EXTERNALSYM RAND_F_FIPS_RAND_BYTES}
  RAND_F_FIPS_RAND_BYTES				= 102;
  {$EXTERNALSYM RAND_F_FIPS_RAND_GET_RAND_METHOD}
  RAND_F_FIPS_RAND_GET_RAND_METHOD		= 109;
  {$EXTERNALSYM RAND_F_FIPS_RAND_SET_DT}
  RAND_F_FIPS_RAND_SET_DT				= 106;
  {$EXTERNALSYM RAND_F_FIPS_SET_DT}
  RAND_F_FIPS_SET_DT				 = 104;
  {$EXTERNALSYM RAND_F_FIPS_SET_PRNG_SEED}
  RAND_F_FIPS_SET_PRNG_SEED			 = 107;
  {$EXTERNALSYM RAND_F_FIPS_SET_TEST_MODE}
  RAND_F_FIPS_SET_TEST_MODE			 = 105;
  {$EXTERNALSYM RAND_F_RAND_GET_RAND_METHOD}
  RAND_F_RAND_GET_RAND_METHOD			= 101;
  {$EXTERNALSYM RAND_F_SSLEAY_RAND_BYTES}
  RAND_F_SSLEAY_RAND_BYTES			= 100;

//* Reason codes. */
  {$EXTERNALSYM RAND_R_NON_FIPS_METHOD}
  RAND_R_NON_FIPS_METHOD			 = 105;
  {$EXTERNALSYM RAND_R_NOT_IN_TEST_MODE}
  RAND_R_NOT_IN_TEST_MODE				 = 106;
  {$EXTERNALSYM RAND_R_NO_KEY_SET}
  RAND_R_NO_KEY_SET				 = 107;
  {$EXTERNALSYM RAND_R_PRNG_ASKING_FOR_TOO_MUCH}
  RAND_R_PRNG_ASKING_FOR_TOO_MUCH			 = 101;
  {$EXTERNALSYM RAND_R_PRNG_ERROR}
  RAND_R_PRNG_ERROR				= 108;
  {$EXTERNALSYM RAND_R_PRNG_KEYED}
  RAND_R_PRNG_KEYED				 = 109;
  {$EXTERNALSYM RAND_R_PRNG_NOT_REKEYED}
  RAND_R_PRNG_NOT_REKEYED				= 102;
  {$EXTERNALSYM RAND_R_PRNG_NOT_RESEEDED}
  RAND_R_PRNG_NOT_RESEEDED			 = 103;
  {$EXTERNALSYM RAND_R_PRNG_NOT_SEEDED}
  RAND_R_PRNG_NOT_SEEDED				 = 100;
  {$EXTERNALSYM RAND_R_PRNG_SEED_MUST_NOT_MATCH_KEY}
  RAND_R_PRNG_SEED_MUST_NOT_MATCH_KEY		 = 110;
  {$EXTERNALSYM RAND_R_PRNG_STUCK}
  RAND_R_PRNG_STUCK				 = 104;

  {$EXTERNALSYM B_ASN1_BIT_STRING}
  B_ASN1_BIT_STRING = $0400;
  {$EXTERNALSYM B_ASN1_BMPSTRING}
  B_ASN1_BMPSTRING = $0800;
  {$EXTERNALSYM B_ASN1_GENERALSTRING}
  B_ASN1_GENERALSTRING = $0080;
  {$EXTERNALSYM B_ASN1_GRAPHICSTRING}
  B_ASN1_GRAPHICSTRING = $0020;
  {$EXTERNALSYM B_ASN1_IA5STRING}
  B_ASN1_IA5STRING = $0010;
  {$EXTERNALSYM B_ASN1_ISO64STRING}
  B_ASN1_ISO64STRING = $0040;
  {$EXTERNALSYM B_ASN1_NUMERICSTRING}
  B_ASN1_NUMERICSTRING = $0001;
  {$EXTERNALSYM B_ASN1_OCTET_STRING}
  B_ASN1_OCTET_STRING = $0200;
  {$EXTERNALSYM B_ASN1_PRINTABLESTRING}
  B_ASN1_PRINTABLESTRING = $0002;
  {$EXTERNALSYM B_ASN1_T61STRING}
  B_ASN1_T61STRING = $0004;
  {$EXTERNALSYM B_ASN1_TELETEXSTRING}
  B_ASN1_TELETEXSTRING = $0008;
  {$EXTERNALSYM B_ASN1_UNIVERSALSTRING}
  B_ASN1_UNIVERSALSTRING = $0100;
  {$EXTERNALSYM B_ASN1_UNKNOWN}
  B_ASN1_UNKNOWN = $1000;
  {$EXTERNALSYM B_ASN1_UTF8STRING}
  B_ASN1_UTF8STRING = $2000;
  {$EXTERNALSYM B_ASN1_VIDEOTEXSTRING}
  B_ASN1_VIDEOTEXSTRING = $0008;
  {$EXTERNALSYM B_ASN1_VISIBLESTRING}
  B_ASN1_VISIBLESTRING = $0040;
  {$EXTERNALSYM B_ASN1_UTCTIME}
  B_ASN1_UTCTIME = $4000;
  {$EXTERNALSYM B_ASN1_GENERALIZEDTIME}
  B_ASN1_GENERALIZEDTIME = $8000;
  {$EXTERNALSYM B_ASN1_SEQUENCE}
  B_ASN1_SEQUENCE = $10000;
  {$EXTERNALSYM B_ASN1_TIME}
  B_ASN1_TIME = B_ASN1_UTCTIME or
  {$EXTERNALSYM B_ASN1_PRINTABLE}
                        B_ASN1_GENERALIZEDTIME;

  {$EXTERNALSYM B_ASN1_PRINTABLE}
  B_ASN1_PRINTABLE = B_ASN1_NUMERICSTRING or
  {$EXTERNALSYM B_ASN1_DIRECTORYSTRING}
        B_ASN1_PRINTABLESTRING or
  {$EXTERNALSYM B_ASN1_DIRECTORYSTRING}
        B_ASN1_T61STRING or
  {$EXTERNALSYM B_ASN1_DIRECTORYSTRING}
        B_ASN1_IA5STRING or
  {$EXTERNALSYM B_ASN1_DIRECTORYSTRING}
        B_ASN1_BIT_STRING or
  {$EXTERNALSYM B_ASN1_DIRECTORYSTRING}
        B_ASN1_UNIVERSALSTRING or
  {$EXTERNALSYM B_ASN1_DIRECTORYSTRING}
        B_ASN1_BMPSTRING or
  {$EXTERNALSYM B_ASN1_DIRECTORYSTRING}
        B_ASN1_UTF8STRING or
  {$EXTERNALSYM B_ASN1_DIRECTORYSTRING}
        B_ASN1_SEQUENCE or
  {$EXTERNALSYM B_ASN1_DIRECTORYSTRING}
        B_ASN1_UNKNOWN;
  {$EXTERNALSYM B_ASN1_DIRECTORYSTRING}
  B_ASN1_DIRECTORYSTRING = B_ASN1_PRINTABLESTRING or
  {$EXTERNALSYM B_ASN1_DISPLAYTEXT}
              B_ASN1_TELETEXSTRING or
  {$EXTERNALSYM B_ASN1_DISPLAYTEXT}
              B_ASN1_BMPSTRING or
  {$EXTERNALSYM B_ASN1_DISPLAYTEXT}
              B_ASN1_UNIVERSALSTRING or
  {$EXTERNALSYM B_ASN1_DISPLAYTEXT}
              B_ASN1_UTF8STRING;
  {$EXTERNALSYM B_ASN1_DISPLAYTEXT}
  B_ASN1_DISPLAYTEXT = B_ASN1_IA5STRING or
  {$EXTERNALSYM MBSTRING_FLAG}
          B_ASN1_VISIBLESTRING or
  {$EXTERNALSYM MBSTRING_FLAG}
          B_ASN1_BMPSTRING or
  {$EXTERNALSYM MBSTRING_FLAG}
          B_ASN1_UTF8STRING;
  {$EXTERNALSYM MBSTRING_FLAG}
  MBSTRING_FLAG = $1000;
  {$EXTERNALSYM MBSTRING_UTF8}
  MBSTRING_UTF8 = MBSTRING_FLAG;
  {$EXTERNALSYM MBSTRING_ASC}
  MBSTRING_ASC = MBSTRING_FLAG or 1;
  {$EXTERNALSYM MBSTRING_BMP}
  MBSTRING_BMP = MBSTRING_FLAG or 2;
  {$EXTERNALSYM MBSTRING_UNIV}
  MBSTRING_UNIV = MBSTRING_FLAG or 4;
  {$EXTERNALSYM SMIME_OLDMIME}
  SMIME_OLDMIME	= $400;
  {$EXTERNALSYM SMIME_CRLFEOL}
  SMIME_CRLFEOL	=	$800;
  {$EXTERNALSYM SMIME_STREAM}
  SMIME_STREAM  =	$1000;

  {$EXTERNALSYM _CLOCKS_PER_SEC_}
  _CLOCKS_PER_SEC_ = 1000;
  {$EXTERNALSYM _CLOCKS_PER_SEC_}
  {$EXTERNALSYM CLOCKS_PER_SEC}
  CLOCKS_PER_SEC = _CLOCKS_PER_SEC_;
  {$EXTERNALSYM CLOCKS_PER_SEC}
  {$EXTERNALSYM CLK_TCK}
  CLK_TCK = CLOCKS_PER_SEC;
  {$EXTERNALSYM CLK_TCK}
//* Function codes. */
  {$EXTERNALSYM COMP_F_BIO_ZLIB_FLUSH}
  COMP_F_BIO_ZLIB_FLUSH = 99;
  {$EXTERNALSYM COMP_F_BIO_ZLIB_NEW}
  COMP_F_BIO_ZLIB_NEW	= 100;
  {$EXTERNALSYM COMP_F_BIO_ZLIB_READ}
  COMP_F_BIO_ZLIB_READ = 101;
  {$EXTERNALSYM COMP_F_BIO_ZLIB_WRITE}
  COMP_F_BIO_ZLIB_WRITE	= 102;

//* Reason codes. */
  {$EXTERNALSYM COMP_R_ZLIB_DEFLATE_ERROR}
  COMP_R_ZLIB_DEFLATE_ERROR = 99;
  {$EXTERNALSYM COMP_R_ZLIB_INFLATE_ERROR}
  COMP_R_ZLIB_INFLATE_ERROR = 100;
  {$EXTERNALSYM COMP_R_ZLIB_NOT_SUPPORTED}
  COMP_R_ZLIB_NOT_SUPPORTED = 101;

  {$EXTERNALSYM CRYPTO_EX_INDEX_BIO}
  CRYPTO_EX_INDEX_BIO = 0;
  {$EXTERNALSYM CRYPTO_EX_INDEX_SSL}
  CRYPTO_EX_INDEX_SSL = 1;
  {$EXTERNALSYM CRYPTO_EX_INDEX_SSL_CTX}
  CRYPTO_EX_INDEX_SSL_CTX = 2;
  {$EXTERNALSYM CRYPTO_EX_INDEX_SSL_SESSION}
  CRYPTO_EX_INDEX_SSL_SESSION = 3;
  {$EXTERNALSYM CRYPTO_EX_INDEX_X509_STORE}
  CRYPTO_EX_INDEX_X509_STORE = 4;
  {$EXTERNALSYM CRYPTO_EX_INDEX_X509_STORE_CTX}
  CRYPTO_EX_INDEX_X509_STORE_CTX = 5;
  {$EXTERNALSYM CRYPTO_EX_INDEX_RSA}
  CRYPTO_EX_INDEX_RSA = 6;
  {$EXTERNALSYM CRYPTO_EX_INDEX_DSA}
  CRYPTO_EX_INDEX_DSA	= 7;
  {$EXTERNALSYM CRYPTO_EX_INDEX_DH}
  CRYPTO_EX_INDEX_DH = 8;
  {$EXTERNALSYM CRYPTO_EX_INDEX_ENGINE}
  CRYPTO_EX_INDEX_ENGINE = 9;
  {$EXTERNALSYM CRYPTO_EX_INDEX_X509}
  CRYPTO_EX_INDEX_X509 = 10;
  {$EXTERNALSYM CRYPTO_EX_INDEX_UI}
  CRYPTO_EX_INDEX_UI = 11;
  {$EXTERNALSYM CRYPTO_EX_INDEX_ECDSA}
  CRYPTO_EX_INDEX_ECDSA	= 12;
  {$EXTERNALSYM CRYPTO_EX_INDEX_ECDH}
  CRYPTO_EX_INDEX_ECDH = 13;
  {$EXTERNALSYM CRYPTO_EX_INDEX_COMP}
  CRYPTO_EX_INDEX_COMP = 14;
  {$EXTERNALSYM CRYPTO_EX_INDEX_STORE}
  CRYPTO_EX_INDEX_STORE	= 15;
  {$EXTERNALSYM CRYPTO_EX_INDEX_USER}
  CRYPTO_EX_INDEX_USER = 100;

  {$EXTERNALSYM CRYPTO_F_CRYPTO_GET_EX_NEW_INDEX}
  CRYPTO_F_CRYPTO_GET_EX_NEW_INDEX = 100;
  {$EXTERNALSYM CRYPTO_F_CRYPTO_GET_NEW_DYNLOCKID}
  CRYPTO_F_CRYPTO_GET_NEW_DYNLOCKID	= 103;
  {$EXTERNALSYM CRYPTO_F_CRYPTO_GET_NEW_LOCKID}
  CRYPTO_F_CRYPTO_GET_NEW_LOCKID = 101;
  {$EXTERNALSYM CRYPTO_F_CRYPTO_SET_EX_DATA}
  CRYPTO_F_CRYPTO_SET_EX_DATA = 102;
  {$EXTERNALSYM CRYPTO_F_DEF_ADD_INDEX}
  CRYPTO_F_DEF_ADD_INDEX = 104;
  {$EXTERNALSYM CRYPTO_F_DEF_GET_CLASS}
  CRYPTO_F_DEF_GET_CLASS = 105;
  {$EXTERNALSYM CRYPTO_F_INT_DUP_EX_DATA}
  CRYPTO_F_INT_DUP_EX_DATA = 106;
  {$EXTERNALSYM CRYPTO_F_INT_FREE_EX_DATA}
  CRYPTO_F_INT_FREE_EX_DATA	= 107;
  {$EXTERNALSYM CRYPTO_F_INT_NEW_EX_DATA}
  CRYPTO_F_INT_NEW_EX_DATA = 108;
  {$EXTERNALSYM CRYPTO_R_NO_DYNLOCK_CREATE_CALLBACK}
  CRYPTO_R_NO_DYNLOCK_CREATE_CALLBACK = 100;

  {$EXTERNALSYM CRYPTO_LOCK}
  CRYPTO_LOCK = 1;
  {$EXTERNALSYM CRYPTO_LOCK_ERR}
  CRYPTO_LOCK_ERR = 1;
  {$EXTERNALSYM CRYPTO_LOCK_ERR_HASH}
  CRYPTO_LOCK_ERR_HASH = 2;
  {$EXTERNALSYM CRYPTO_LOCK_X509}
  CRYPTO_LOCK_X509 = 3;
  {$EXTERNALSYM CRYPTO_LOCK_X509_INFO}
  CRYPTO_LOCK_X509_INFO = 4;
  {$EXTERNALSYM CRYPTO_LOCK_X509_PKEY}
  CRYPTO_LOCK_X509_PKEY = 5;
  {$EXTERNALSYM CRYPTO_LOCK_X509_CRL}
  CRYPTO_LOCK_X509_CRL = 6;
  {$EXTERNALSYM CRYPTO_LOCK_X509_REQ}
  CRYPTO_LOCK_X509_REQ = 7;
  {$EXTERNALSYM CRYPTO_LOCK_DSA}
  CRYPTO_LOCK_DSA = 8;
  {$EXTERNALSYM CRYPTO_LOCK_RSA}
  CRYPTO_LOCK_RSA = 9;
  {$EXTERNALSYM CRYPTO_LOCK_EVP_PKEY}
  CRYPTO_LOCK_EVP_PKEY = 10;
  {$EXTERNALSYM CRYPTO_LOCK_X509_STORE}
  CRYPTO_LOCK_X509_STORE = 11;
  {$EXTERNALSYM CRYPTO_LOCK_SSL_CTX}
  CRYPTO_LOCK_SSL_CTX = 12;
  {$EXTERNALSYM CRYPTO_LOCK_SSL_CERT}
  CRYPTO_LOCK_SSL_CERT = 13;
  {$EXTERNALSYM CRYPTO_LOCK_SSL_SESSION}
  CRYPTO_LOCK_SSL_SESSION = 14;
  {$EXTERNALSYM CRYPTO_LOCK_SSL_SESS_CERT}
  CRYPTO_LOCK_SSL_SESS_CERT = 15;
  {$EXTERNALSYM CRYPTO_LOCK_SSL}
  CRYPTO_LOCK_SSL = 16;
  {$EXTERNALSYM CRYPTO_LOCK_SSL_METHOD}
  CRYPTO_LOCK_SSL_METHOD = 17;
  {$EXTERNALSYM CRYPTO_LOCK_RAND}
  CRYPTO_LOCK_RAND = 18;
//  CRYPTO_LOCK_RAND = 17;
  {$EXTERNALSYM CRYPTO_LOCK_RAND2}
  CRYPTO_LOCK_RAND2 = 19;
  {$EXTERNALSYM CRYPTO_LOCK_MALLOC}
  CRYPTO_LOCK_MALLOC = 20;
//was CRYPTO_LOCK_MALLOC = 18;
  {$EXTERNALSYM CRYPTO_LOCK_BIO}
  CRYPTO_LOCK_BIO	= 21;
//was   CRYPTO_LOCK_BIO = 19;
  {$EXTERNALSYM CRYPTO_LOCK_GETHOSTBYNAME}
  CRYPTO_LOCK_GETHOSTBYNAME = 22;
//was  CRYPTO_LOCK_GETHOSTBYNAME = 20;
  {$EXTERNALSYM CRYPTO_LOCK_GETSERVBYNAME}
  CRYPTO_LOCK_GETSERVBYNAME = 23;
//was  CRYPTO_LOCK_GETSERVBYNAME = 21;
  {$EXTERNALSYM CRYPTO_LOCK_READDIR}
  CRYPTO_LOCK_READDIR = 24;
//was  CRYPTO_LOCK_READDIR = 22;
  {$EXTERNALSYM CRYPTO_LOCK_RSA_BLINDING}
  CRYPTO_LOCK_RSA_BLINDING = 25;
//was  CRYPTO_LOCK_RSA_BLINDING = 23;
  {$EXTERNALSYM CRYPTO_LOCK_DH}
  CRYPTO_LOCK_DH = 26;
  {$EXTERNALSYM CRYPTO_LOCK_MALLOC2}
  CRYPTO_LOCK_MALLOC2 = 27;
  {$EXTERNALSYM CRYPTO_LOCK_DSO}
  CRYPTO_LOCK_DSO = 28;
  {$EXTERNALSYM CRYPTO_LOCK_DYNLOCK}
  CRYPTO_LOCK_DYNLOCK = 29;
  {$EXTERNALSYM CRYPTO_LOCK_ENGINE}
  CRYPTO_LOCK_ENGINE = 30;
  {$EXTERNALSYM CRYPTO_LOCK_UI}
  CRYPTO_LOCK_UI = 31;
  {$EXTERNALSYM CRYPTO_LOCK_ECDSA}
  CRYPTO_LOCK_ECDSA = 32;
  {$EXTERNALSYM CRYPTO_LOCK_EC}
  CRYPTO_LOCK_EC = 33;
  {$EXTERNALSYM CRYPTO_LOCK_ECDH}
  CRYPTO_LOCK_ECDH = 34;
  {$EXTERNALSYM CRYPTO_LOCK_BN}
  CRYPTO_LOCK_BN = 35;
  {$EXTERNALSYM CRYPTO_LOCK_EC_PRE_COMP}
  CRYPTO_LOCK_EC_PRE_COMP	= 36;
  {$EXTERNALSYM CRYPTO_LOCK_STORE}
  CRYPTO_LOCK_STORE = 37;
  {$EXTERNALSYM CRYPTO_LOCK_COMP}
  CRYPTO_LOCK_COMP = 38;
  {$IFNDEF OPENSSL_FIPS}
  {$EXTERNALSYM CRYPTO_NUM_LOCKS}
  CRYPTO_NUM_LOCKS = 39;
// was  OPENSSL_CRYPTO_NUM_LOCKS = 24;
  {$ELSE}
  {$EXTERNALSYM CRYPTO_LOCK_FIPS}
  CRYPTO_LOCK_FIPS = 39;
  {$EXTERNALSYM CRYPTO_LOCK_FIPS2}
  CRYPTO_LOCK_FIPS2 = 40;
  {$EXTERNALSYM CRYPTO_NUM_LOCKS}
  CRYPTO_NUM_LOCKS = 41;
  {$ENDIF}
  {$EXTERNALSYM CRYPTO_MEM_CHECK_DISABLE}
  CRYPTO_MEM_CHECK_DISABLE = $3;
  {$EXTERNALSYM CRYPTO_MEM_CHECK_ENABLE}
  CRYPTO_MEM_CHECK_ENABLE = $2;
  {$EXTERNALSYM CRYPTO_MEM_CHECK_OFF}
  CRYPTO_MEM_CHECK_OFF = $0;
  {$EXTERNALSYM CRYPTO_MEM_CHECK_ON}
  CRYPTO_MEM_CHECK_ON = $1;
  {$EXTERNALSYM CRYPTO_READ}
  CRYPTO_READ = 4;
  {$EXTERNALSYM CRYPTO_UNLOCK}
  CRYPTO_UNLOCK = 2;
  {$EXTERNALSYM CRYPTO_WRITE}
  CRYPTO_WRITE = 8;
  {$EXTERNALSYM V_CRYPTO_MDEBUG_TIME}
  V_CRYPTO_MDEBUG_TIME = $1;
  {$EXTERNALSYM V_CRYPTO_MDEBUG_THREAD}
  V_CRYPTO_MDEBUG_THREAD = $2;
  {$IFNDEF OPENSSL_NO_AES}
  {$EXTERNALSYM AES_ENCRYPT}
  AES_ENCRYPT = 1;
  {$EXTERNALSYM AES_DECRYPT}
  AES_DECRYPT = 0;
  {$EXTERNALSYM AES_MAXNR}
  AES_MAXNR = 14;
  {$EXTERNALSYM AES_BLOCK_SIZE}
  AES_BLOCK_SIZE = 16;
  {$ENDIF}
//* These values are used as commands to DSO_ctrl() */
  {$EXTERNALSYM DSO_CTRL_GET_FLAGS}
  DSO_CTRL_GET_FLAGS = 1;
  {$EXTERNALSYM DSO_CTRL_SET_FLAGS}
  DSO_CTRL_SET_FLAGS = 2;
  {$EXTERNALSYM DSO_CTRL_OR_FLAGS}
  DSO_CTRL_OR_FLAGS	= 3;

///* By default, DSO_load() will translate the provided filename into a form
// * typical for the platform (more specifically the DSO_METHOD) using the
// * dso_name_converter function of the method. Eg. win32 will transform "blah"
// * into "blah.dll", and dlfcn will transform it into "libblah.so". The
// * behaviour can be overriden by setting the name_converter callback in the DSO
// * object (using DSO_set_name_converter()). This callback could even utilise
// * the DSO_METHOD's converter too if it only wants to override behaviour for
// * one or two possible DSO methods. However, the following flag can be set in a
// * DSO to prevent *any* native name-translation at all - eg. if the caller has
// * prompted the user for a path to a driver library so the filename should be
// * interpreted as-is. */
  {$EXTERNALSYM DSO_FLAG_NO_NAME_TRANSLATION}
  DSO_FLAG_NO_NAME_TRANSLATION	 = $01;
///* An extra flag to give if only the extension should be added as
// * translation.  This is obviously only of importance on Unix and
// * other operating systems where the translation also may prefix
// * the name with something, like 'lib', and ignored everywhere else.
// * This flag is also ignored if DSO_FLAG_NO_NAME_TRANSLATION is used
// * at the same time. */
  {$EXTERNALSYM DSO_FLAG_NAME_TRANSLATION_EXT_ONLY}
  DSO_FLAG_NAME_TRANSLATION_EXT_ONLY = $02;

///* The following flag controls the translation of symbol names to upper
// * case.  This is currently only being implemented for OpenVMS.
// */
  {$EXTERNALSYM DSO_FLAG_UPCASE_SYMBOL}
  DSO_FLAG_UPCASE_SYMBOL		 = $10;

//* This flag loads the library with public symbols.
// * Meaning: The exported symbols of this library are public
// * to all libraries loaded after this library.
// * At the moment only implemented in unix.
// */
  {$EXTERNALSYM DSO_FLAG_GLOBAL_SYMBOLS}
  DSO_FLAG_GLOBAL_SYMBOLS	 = $20;
  //seed.h
  {$IFNDEF OPENSSL_NO_SEED}
     {$IFDEF AES_LONG} //* look whether we need 'long' to get 32 bits */
       {$DEFINE SEED_LONG}
     {$ENDIF}
  {$EXTERNALSYM SEED_BLOCK_SIZE}
  SEED_BLOCK_SIZE = 16;
  {$EXTERNALSYM SEED_KEY_LENGTH}
  SEED_KEY_LENGTH = 16;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_CAST}
  {$EXTERNALSYM CAST_BLOCK}
  CAST_BLOCK = 8;
  {$EXTERNALSYM CAST_DECRYPT}
  CAST_DECRYPT = 0;
  {$EXTERNALSYM CAST_ENCRYPT}
  CAST_ENCRYPT = 1;
  {$EXTERNALSYM CAST_KEY_LENGTH}
  CAST_KEY_LENGTH = 16;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_DES}
  {$EXTERNALSYM DES_CBC_MODE}
  DES_CBC_MODE = 0;
  {$EXTERNALSYM DES_DECRYPT}
  DES_DECRYPT = 0;
  {$EXTERNALSYM DES_ENCRYPT}
  DES_ENCRYPT = 1;
  {$EXTERNALSYM DES_PCBC_MODE}
  DES_PCBC_MODE = 1;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_DH}
  //the OpenSSL developers probably only wanted to make sure this was defined.
  {$EXTERNALSYM DH_MAX_MODULUS_BITS}
  DH_MAX_MODULUS_BITS = 10000;
  {$EXTERNALSYM DH_FIPS_MIN_MODULUS_BITS}
  DH_FIPS_MIN_MODULUS_BITS = 1024;
  {$EXTERNALSYM DH_FLAG_CACHE_MONT_P}
  DH_FLAG_CACHE_MONT_P = $01;
  {$EXTERNALSYM DH_FLAG_NO_EXP_CONSTTIME}
  DH_FLAG_NO_EXP_CONSTTIME = $02;
  {$EXTERNALSYM DH_GENERATOR_2}
  DH_GENERATOR_2 = 2;
  {$EXTERNALSYM DH_GENERATOR_5}
  DH_GENERATOR_5 = 5;
  {$EXTERNALSYM DH_CHECK_P_NOT_PRIME}
  DH_CHECK_P_NOT_PRIME = $01;
  {$EXTERNALSYM DH_CHECK_P_NOT_STRONG_PRIME}
  DH_CHECK_P_NOT_STRONG_PRIME = $02;
  {$EXTERNALSYM DH_UNABLE_TO_CHECK_GENERATOR}
  DH_UNABLE_TO_CHECK_GENERATOR = $04;
  {$EXTERNALSYM DH_NOT_SUITABLE_GENERATOR}
  DH_NOT_SUITABLE_GENERATOR = $08;
  {$EXTERNALSYM DH_CHECK_PUBKEY_TOO_SMALL}
  DH_CHECK_PUBKEY_TOO_SMALL = $01;
  {$EXTERNALSYM DH_CHECK_PUBKEY_TOO_LARGE}
  DH_CHECK_PUBKEY_TOO_LARGE = $02;
  {$EXTERNALSYM DH_CHECK_P_NOT_SAFE_PRIME}
  DH_CHECK_P_NOT_SAFE_PRIME = DH_CHECK_P_NOT_STRONG_PRIME;
  {$EXTERNALSYM DH_F_DHPARAMS_PRINT}
  DH_F_DHPARAMS_PRINT = 100;
  {$EXTERNALSYM DH_F_DHPARAMS_PRINT_FP}
  DH_F_DHPARAMS_PRINT_FP = 101;
  {$EXTERNALSYM DH_F_COMPUTE_KEY}
  DH_F_COMPUTE_KEY = 102;
  {$EXTERNALSYM DH_F_GENERATE_KEY}
  DH_F_GENERATE_KEY = 103;
  {$EXTERNALSYM DH_F_GENERATE_PARAMETERS}
  DH_F_GENERATE_PARAMETERS = 104;
  {$EXTERNALSYM DH_F_DH_NEW_METHOD}
  DH_F_DH_NEW_METHOD = 105;
  {$EXTERNALSYM DH_F_DH_NEW}
  DH_F_DH_NEW = 105;
  {$EXTERNALSYM DH_F_DH_BUILTIN_GENPARAMS}
  DH_F_DH_BUILTIN_GENPARAMS = 106;
  {$EXTERNALSYM DH_F_DH_COMPUTE_KEY}
  DH_F_DH_COMPUTE_KEY	= 107;
  //was   DH_F_DH_COMPUTE_KEY = 102;
  {$EXTERNALSYM DH_F_DH_GENERATE_KEY}
  DH_F_DH_GENERATE_KEY = 108;
  //was   DH_F_DH_GENERATE_KEY = 103;
  {$EXTERNALSYM DH_F_DH_GENERATE_PARAMETERS}
  DH_F_DH_GENERATE_PARAMETERS	= 109;
  //was   DH_F_DH_GENERATE_PARAMETERS = 104;
  {$EXTERNALSYM DH_R_NO_PRIVATE_VALUE}
  DH_R_NO_PRIVATE_VALUE = 100;
  {$EXTERNALSYM DH_R_BAD_GENERATOR}
  DH_R_BAD_GENERATOR = 101;
  {$EXTERNALSYM DH_R_INVALID_PUBKEY}
  DH_R_INVALID_PUBKEY = 102;
  {$EXTERNALSYM DH_R_MODULUS_TOO_LARGE}
  DH_R_MODULUS_TOO_LARGE = 103;
  {$EXTERNALSYM DH_R_KEY_SIZE_TOO_SMALL}
  DH_R_KEY_SIZE_TOO_SMALL	= 104;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_DSA}
  //I think the OpenSSL developers wanted to make sure this was defined.
  {$EXTERNALSYM DSA_MAX_MODULUS_BITS}
  DSA_MAX_MODULUS_BITS = 10000;
  {$EXTERNALSYM DSA_FIPS_MIN_MODULUS_BITS}
  DSA_FIPS_MIN_MODULUS_BITS = 1024;
  {$EXTERNALSYM DSA_FLAG_CACHE_MONT_P}
  DSA_FLAG_CACHE_MONT_P = $01;
  {$EXTERNALSYM DSA_FLAG_NO_EXP_CONSTTIME}
  DSA_FLAG_NO_EXP_CONSTTIME = $02; //* new with 0.9.7h; the built-in DSA
///* If this flag is set the DSA method is FIPS compliant and can be used
// * in FIPS mode. This is set in the validated module method. If an
// * application sets this flag in its own methods it is its reposibility
// * to ensure the result is compliant.
// */
  {$EXTERNALSYM DSA_FLAG_FIPS_METHOD}
  DSA_FLAG_FIPS_METHOD = $0400;
///* If this flag is set the operations normally disabled in FIPS mode are
// * permitted it is then the applications responsibility to ensure that the
// * usage is compliant.
// */
  {$EXTERNALSYM DSA_FLAG_NON_FIPS_ALLOW}
  DSA_FLAG_NON_FIPS_ALLOW	= $0400;
  {$EXTERNALSYM DSA_F_D2I_DSA_SIG}
  DSA_F_D2I_DSA_SIG = 110;
  {$EXTERNALSYM DSA_F_DSAPARAMS_PRINT}
  DSA_F_DSAPARAMS_PRINT = 100;
  {$EXTERNALSYM DSA_F_DSAPARAMS_PRINT_FP}
  DSA_F_DSAPARAMS_PRINT_FP = 101;
  {$EXTERNALSYM DSA_F_DSA_BUILTIN_KEYGEN}
  DSA_F_DSA_BUILTIN_KEYGEN = 119;
  {$EXTERNALSYM DSA_F_DSA_BUILTIN_PARAMGEN}
  DSA_F_DSA_BUILTIN_PARAMGEN = 118;
  {$EXTERNALSYM DSA_F_DSA_DO_SIGN}
  DSA_F_DSA_DO_SIGN = 112;
  {$EXTERNALSYM DSA_F_DSA_DO_VERIFY}
  DSA_F_DSA_DO_VERIFY = 113;
  {$EXTERNALSYM DSA_F_DSA_IS_PRIME}
  DSA_F_DSA_IS_PRIME = 102;
  {$EXTERNALSYM DSA_F_DSA_NEW}
  DSA_F_DSA_NEW = 103;
  {$EXTERNALSYM DSA_F_DSA_PRINT}
  DSA_F_DSA_PRINT = 104;
  {$EXTERNALSYM DSA_F_DSA_PRINT_FP}
  DSA_F_DSA_PRINT_FP = 105;
  {$EXTERNALSYM DSA_F_DSA_SIGN}
  DSA_F_DSA_SIGN = 106;
  {$EXTERNALSYM DSA_F_DSA_SIGN_SETUP}
  DSA_F_DSA_SIGN_SETUP = 107;
  {$EXTERNALSYM DSA_F_DSA_SIG_NEW}
  DSA_F_DSA_SIG_NEW = 109;
  {$EXTERNALSYM DSA_F_DSA_VERIFY}
  DSA_F_DSA_VERIFY = 108;
  {$EXTERNALSYM DSA_F_DSA_GENERATE_PARAMETERS}
  DSA_F_DSA_GENERATE_PARAMETERS	= 117;
  {$EXTERNALSYM DSA_F_I2D_DSA_SIG}
  DSA_F_I2D_DSA_SIG = 111;
  {$EXTERNALSYM DSA_F_SIG_CB}
  DSA_F_SIG_CB = 114;
  {$EXTERNALSYM DSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE}
  DSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE = 100;
  {$EXTERNALSYM DSA_R_MISSING_PARAMETERS}
  DSA_R_MISSING_PARAMETERS = 101;
  {$EXTERNALSYM DSA_R_BAD_Q_VALUE}
  DSA_R_BAD_Q_VALUE = 102;
  {$EXTERNALSYM DSA_R_MODULUS_TOO_LARGE}
  DSA_R_MODULUS_TOO_LARGE = 103;
  {$EXTERNALSYM DSA_R_NON_FIPS_METHOD}
  DSA_R_NON_FIPS_METHOD	= 104;
  {$EXTERNALSYM DSA_R_OPERATION_NOT_ALLOWED_IN_FIPS_MODE}
  DSA_R_OPERATION_NOT_ALLOWED_IN_FIPS_MODE = 105;
  {$EXTERNALSYM DSA_R_KEY_SIZE_TOO_SMALL}
  DSA_R_KEY_SIZE_TOO_SMALL = 106;
  {$ENDIF}
  {$IFNDEF NO_EC}
  {$EXTERNALSYM ECC_MAX_FIELD_BITS}
  ECC_MAX_FIELD_BITS = 661;
  {$EXTERNALSYM EC_NAMED_CURVE}
  EC_NAMED_CURVE = $001;
  {$EXTERNALSYM POINT_CONVERSION_COMPRESSED}
  POINT_CONVERSION_COMPRESSED = 2;
  {$EXTERNALSYM POINT_CONVERSION_UNCOMPRESSED}
  POINT_CONVERSION_UNCOMPRESSED = 4;
  {$EXTERNALSYM POINT_CONVERSION_HYBRID}
  POINT_CONVERSION_HYBRID = 6;
  {$EXTERNALSYM EC_PKEY_NO_PARAMETERS}
  EC_PKEY_NO_PARAMETERS = $001;
  {$EXTERNALSYM EC_PKEY_NO_PUBKEY}
  EC_PKEY_NO_PUBKEY = $002;
//* Error codes for the EC functions. */
//* Function codes. */
  {$EXTERNALSYM EC_F_COMPUTE_WNAF}
  EC_F_COMPUTE_WNAF = 143;
  {$EXTERNALSYM EC_F_D2I_ECPARAMETERS}
  EC_F_D2I_ECPARAMETERS = 144;
  {$EXTERNALSYM EC_F_D2I_ECPKPARAMETERS}
  EC_F_D2I_ECPKPARAMETERS = 145;
  {$EXTERNALSYM EC_F_D2I_ECPRIVATEKEY}
  EC_F_D2I_ECPRIVATEKEY = 146;
  {$EXTERNALSYM EC_F_ECPARAMETERS_PRINT}
  EC_F_ECPARAMETERS_PRINT = 147;
  {$EXTERNALSYM EC_F_ECPARAMETERS_PRINT_FP}
  EC_F_ECPARAMETERS_PRINT_FP = 148;
  {$EXTERNALSYM EC_F_ECPKPARAMETERS_PRINT}
  EC_F_ECPKPARAMETERS_PRINT = 149;
  {$EXTERNALSYM EC_F_ECPKPARAMETERS_PRINT_FP}
  EC_F_ECPKPARAMETERS_PRINT_FP = 150;
  {$EXTERNALSYM EC_F_ECP_NIST_MOD_192}
  EC_F_ECP_NIST_MOD_192 = 203;
  {$EXTERNALSYM EC_F_ECP_NIST_MOD_224}
  EC_F_ECP_NIST_MOD_224 = 204;
  {$EXTERNALSYM EC_F_ECP_NIST_MOD_256}
  EC_F_ECP_NIST_MOD_256 = 205;
  {$EXTERNALSYM EC_F_ECP_NIST_MOD_521}
  EC_F_ECP_NIST_MOD_521 = 206;
  {$EXTERNALSYM EC_F_EC_ASN1_GROUP2CURVE}
  EC_F_EC_ASN1_GROUP2CURVE = 153;
  {$EXTERNALSYM EC_F_EC_ASN1_GROUP2FIELDID}
  EC_F_EC_ASN1_GROUP2FIELDID = 154;
  {$EXTERNALSYM EC_F_EC_ASN1_GROUP2PARAMETERS}
  EC_F_EC_ASN1_GROUP2PARAMETERS = 155;
  {$EXTERNALSYM EC_F_EC_ASN1_GROUP2PKPARAMETERS}
  EC_F_EC_ASN1_GROUP2PKPARAMETERS = 156;
  {$EXTERNALSYM EC_F_EC_ASN1_PARAMETERS2GROUP}
  EC_F_EC_ASN1_PARAMETERS2GROUP = 157;
  {$EXTERNALSYM EC_F_EC_ASN1_PKPARAMETERS2GROUP}
  EC_F_EC_ASN1_PKPARAMETERS2GROUP = 158;
  {$EXTERNALSYM EC_F_EC_EX_DATA_SET_DATA}
  EC_F_EC_EX_DATA_SET_DATA = 211;
  {$EXTERNALSYM EC_F_EC_GF2M_MONTGOMERY_POINT_MULTIPLY}
  EC_F_EC_GF2M_MONTGOMERY_POINT_MULTIPLY = 208;
  {$EXTERNALSYM EC_F_EC_GF2M_SIMPLE_GROUP_CHECK_DISCRIMINANT}
  EC_F_EC_GF2M_SIMPLE_GROUP_CHECK_DISCRIMINANT = 159;
  {$EXTERNALSYM EC_F_EC_GF2M_SIMPLE_GROUP_SET_CURVE}
  EC_F_EC_GF2M_SIMPLE_GROUP_SET_CURVE = 195;
  {$EXTERNALSYM EC_F_EC_GF2M_SIMPLE_OCT2POINT}
  EC_F_EC_GF2M_SIMPLE_OCT2POINT = 160;
  {$EXTERNALSYM EC_F_EC_GF2M_SIMPLE_POINT2OCT}
  EC_F_EC_GF2M_SIMPLE_POINT2OCT = 161;
  {$EXTERNALSYM EC_F_EC_GF2M_SIMPLE_POINT_GET_AFFINE_COORDINATES}
  EC_F_EC_GF2M_SIMPLE_POINT_GET_AFFINE_COORDINATES = 162;
  {$EXTERNALSYM EC_F_EC_GF2M_SIMPLE_POINT_SET_AFFINE_COORDINATES}
  EC_F_EC_GF2M_SIMPLE_POINT_SET_AFFINE_COORDINATES = 163;
  {$EXTERNALSYM EC_F_EC_GF2M_SIMPLE_SET_COMPRESSED_COORDINATES}
  EC_F_EC_GF2M_SIMPLE_SET_COMPRESSED_COORDINATES = 164;
  {$EXTERNALSYM EC_F_EC_GFP_MONT_FIELD_DECODE}
  EC_F_EC_GFP_MONT_FIELD_DECODE = 133;
  {$EXTERNALSYM EC_F_EC_GFP_MONT_FIELD_ENCODE}
  EC_F_EC_GFP_MONT_FIELD_ENCODE = 134;
  {$EXTERNALSYM EC_F_EC_GFP_MONT_FIELD_MUL}
  EC_F_EC_GFP_MONT_FIELD_MUL = 131;
  {$EXTERNALSYM EC_F_EC_GFP_MONT_FIELD_SET_TO_ONE}
  EC_F_EC_GFP_MONT_FIELD_SET_TO_ONE = 209;
  {$EXTERNALSYM EC_F_EC_GFP_MONT_FIELD_SQR}
  EC_F_EC_GFP_MONT_FIELD_SQR = 132;
  {$EXTERNALSYM EC_F_EC_GFP_MONT_GROUP_SET_CURVE}
  EC_F_EC_GFP_MONT_GROUP_SET_CURVE = 189;
  {$EXTERNALSYM EC_F_EC_GFP_MONT_GROUP_SET_CURVE_GFP}
  EC_F_EC_GFP_MONT_GROUP_SET_CURVE_GFP = 135;
  {$EXTERNALSYM EC_F_EC_GFP_NIST_FIELD_MUL}
  EC_F_EC_GFP_NIST_FIELD_MUL = 200;
  {$EXTERNALSYM EC_F_EC_GFP_NIST_FIELD_SQR}
  EC_F_EC_GFP_NIST_FIELD_SQR = 201;
  {$EXTERNALSYM EC_F_EC_GFP_NIST_GROUP_SET_CURVE}
  EC_F_EC_GFP_NIST_GROUP_SET_CURVE = 202;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_GROUP_CHECK_DISCRIMINANT}
  EC_F_EC_GFP_SIMPLE_GROUP_CHECK_DISCRIMINANT = 165;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_GROUP_SET_CURVE}
  EC_F_EC_GFP_SIMPLE_GROUP_SET_CURVE = 166;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_GROUP_SET_CURVE_GFP}
  EC_F_EC_GFP_SIMPLE_GROUP_SET_CURVE_GFP = 100;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_GROUP_SET_GENERATOR}
  EC_F_EC_GFP_SIMPLE_GROUP_SET_GENERATOR = 101;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_MAKE_AFFINE}
  EC_F_EC_GFP_SIMPLE_MAKE_AFFINE = 102;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_OCT2POINT}
  EC_F_EC_GFP_SIMPLE_OCT2POINT = 103;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_POINT2OCT}
  EC_F_EC_GFP_SIMPLE_POINT2OCT = 104;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_POINTS_MAKE_AFFINE}
  EC_F_EC_GFP_SIMPLE_POINTS_MAKE_AFFINE = 137;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_POINT_GET_AFFINE_COORDINATES}
  EC_F_EC_GFP_SIMPLE_POINT_GET_AFFINE_COORDINATES = 167;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_POINT_GET_AFFINE_COORDINATES_GFP}
  EC_F_EC_GFP_SIMPLE_POINT_GET_AFFINE_COORDINATES_GFP = 105;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_POINT_SET_AFFINE_COORDINATES}
  EC_F_EC_GFP_SIMPLE_POINT_SET_AFFINE_COORDINATES = 168;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_POINT_SET_AFFINE_COORDINATES_GFP}
  EC_F_EC_GFP_SIMPLE_POINT_SET_AFFINE_COORDINATES_GFP = 128;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_SET_COMPRESSED_COORDINATES}
  EC_F_EC_GFP_SIMPLE_SET_COMPRESSED_COORDINATES = 169;
  {$EXTERNALSYM EC_F_EC_GFP_SIMPLE_SET_COMPRESSED_COORDINATES_GFP}
  EC_F_EC_GFP_SIMPLE_SET_COMPRESSED_COORDINATES_GFP = 129;
  {$EXTERNALSYM EC_F_EC_GROUP_CHECK}
  EC_F_EC_GROUP_CHECK = 170;
  {$EXTERNALSYM EC_F_EC_GROUP_CHECK_DISCRIMINANT}
  EC_F_EC_GROUP_CHECK_DISCRIMINANT = 171;
  {$EXTERNALSYM EC_F_EC_GROUP_COPY}
  EC_F_EC_GROUP_COPY = 106;
  {$EXTERNALSYM EC_F_EC_GROUP_GET0_GENERATOR}
  EC_F_EC_GROUP_GET0_GENERATOR = 139;
  {$EXTERNALSYM EC_F_EC_GROUP_GET_COFACTOR}
  EC_F_EC_GROUP_GET_COFACTOR = 140;
  {$EXTERNALSYM EC_F_EC_GROUP_GET_CURVE_GF2M}
  EC_F_EC_GROUP_GET_CURVE_GF2M = 172;
  {$EXTERNALSYM EC_F_EC_GROUP_GET_CURVE_GFP}
  EC_F_EC_GROUP_GET_CURVE_GFP = 130;
  {$EXTERNALSYM EC_F_EC_GROUP_GET_DEGREE}
  EC_F_EC_GROUP_GET_DEGREE = 173;
  {$EXTERNALSYM EC_F_EC_GROUP_GET_ORDER}
  EC_F_EC_GROUP_GET_ORDER = 141;
  {$EXTERNALSYM EC_F_EC_GROUP_GET_PENTANOMIAL_BASIS}
  EC_F_EC_GROUP_GET_PENTANOMIAL_BASIS = 193;
  {$EXTERNALSYM EC_F_EC_GROUP_GET_TRINOMIAL_BASIS}
  EC_F_EC_GROUP_GET_TRINOMIAL_BASIS = 194;
  {$EXTERNALSYM EC_F_EC_GROUP_NEW}
  EC_F_EC_GROUP_NEW = 108;
  {$EXTERNALSYM EC_F_EC_GROUP_NEW_BY_CURVE_NAME}
  EC_F_EC_GROUP_NEW_BY_CURVE_NAME = 174;
  {$EXTERNALSYM EC_F_EC_GROUP_NEW_FROM_DATA}
  EC_F_EC_GROUP_NEW_FROM_DATA = 175;
  {$EXTERNALSYM EC_F_EC_GROUP_PRECOMPUTE_MULT}
  EC_F_EC_GROUP_PRECOMPUTE_MULT = 142;
  {$EXTERNALSYM EC_F_EC_GROUP_SET_CURVE_GF2M}
  EC_F_EC_GROUP_SET_CURVE_GF2M = 176;
  {$EXTERNALSYM EC_F_EC_GROUP_SET_CURVE_GFP}
  EC_F_EC_GROUP_SET_CURVE_GFP = 109;
  {$EXTERNALSYM EC_F_EC_GROUP_SET_EXTRA_DATA}
  EC_F_EC_GROUP_SET_EXTRA_DATA = 110;
  {$EXTERNALSYM EC_F_EC_GROUP_SET_GENERATOR}
  EC_F_EC_GROUP_SET_GENERATOR = 111;
  {$EXTERNALSYM EC_F_EC_KEY_CHECK_KEY}
  EC_F_EC_KEY_CHECK_KEY = 177;
  {$EXTERNALSYM EC_F_EC_KEY_COPY}
  EC_F_EC_KEY_COPY = 178;
  {$EXTERNALSYM EC_F_EC_KEY_GENERATE_KEY}
  EC_F_EC_KEY_GENERATE_KEY = 179;
  {$EXTERNALSYM EC_F_EC_KEY_NEW}
  EC_F_EC_KEY_NEW = 182;
  {$EXTERNALSYM EC_F_EC_KEY_PRINT}
  EC_F_EC_KEY_PRINT = 180;
  {$EXTERNALSYM EC_F_EC_KEY_PRINT_FP}
  EC_F_EC_KEY_PRINT_FP = 181;
  {$EXTERNALSYM EC_F_EC_POINTS_MAKE_AFFINE}
  EC_F_EC_POINTS_MAKE_AFFINE = 136;
  {$EXTERNALSYM EC_F_EC_POINTS_MUL}
  EC_F_EC_POINTS_MUL = 138;
  {$EXTERNALSYM EC_F_EC_POINT_ADD}
  EC_F_EC_POINT_ADD = 112;
  {$EXTERNALSYM EC_F_EC_POINT_CMP}
  EC_F_EC_POINT_CMP = 113;
  {$EXTERNALSYM EC_F_EC_POINT_COPY}
  EC_F_EC_POINT_COPY = 114;
  {$EXTERNALSYM EC_F_EC_POINT_DBL}
  EC_F_EC_POINT_DBL = 115;
  {$EXTERNALSYM EC_F_EC_POINT_GET_AFFINE_COORDINATES_GF2M}
  EC_F_EC_POINT_GET_AFFINE_COORDINATES_GF2M = 183;
  {$EXTERNALSYM EC_F_EC_POINT_GET_AFFINE_COORDINATES_GFP}
  EC_F_EC_POINT_GET_AFFINE_COORDINATES_GFP = 116;
  {$EXTERNALSYM EC_F_EC_POINT_GET_JPROJECTIVE_COORDINATES_GFP}
  EC_F_EC_POINT_GET_JPROJECTIVE_COORDINATES_GFP = 117;
  {$EXTERNALSYM EC_F_EC_POINT_INVERT}
  EC_F_EC_POINT_INVERT = 210;
  {$EXTERNALSYM EC_F_EC_POINT_IS_AT_INFINITY}
  EC_F_EC_POINT_IS_AT_INFINITY = 118;
  {$EXTERNALSYM EC_F_EC_POINT_IS_ON_CURVE}
  EC_F_EC_POINT_IS_ON_CURVE = 119;
  {$EXTERNALSYM EC_F_EC_POINT_MAKE_AFFINE}
  EC_F_EC_POINT_MAKE_AFFINE = 120;
  {$EXTERNALSYM EC_F_EC_POINT_MUL}
  EC_F_EC_POINT_MUL = 184;
  {$EXTERNALSYM EC_F_EC_POINT_NEW}
  EC_F_EC_POINT_NEW = 121;
  {$EXTERNALSYM EC_F_EC_POINT_OCT2POINT}
  EC_F_EC_POINT_OCT2POINT = 122;
  {$EXTERNALSYM EC_F_EC_POINT_POINT2OCT}
  EC_F_EC_POINT_POINT2OCT = 123;
  {$EXTERNALSYM EC_F_EC_POINT_SET_AFFINE_COORDINATES_GF2M}
  EC_F_EC_POINT_SET_AFFINE_COORDINATES_GF2M = 185;
  {$EXTERNALSYM EC_F_EC_POINT_SET_AFFINE_COORDINATES_GFP}
  EC_F_EC_POINT_SET_AFFINE_COORDINATES_GFP = 124;
  {$EXTERNALSYM EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GF2M}
  EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GF2M = 186;
  {$EXTERNALSYM EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GFP}
  EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GFP = 125;
  {$EXTERNALSYM EC_F_EC_POINT_SET_JPROJECTIVE_COORDINATES_GFP}
  EC_F_EC_POINT_SET_JPROJECTIVE_COORDINATES_GFP = 126;
  {$EXTERNALSYM EC_F_EC_POINT_SET_TO_INFINITY}
  EC_F_EC_POINT_SET_TO_INFINITY = 127;
  {$EXTERNALSYM EC_F_EC_PRE_COMP_DUP}
  EC_F_EC_PRE_COMP_DUP = 207;
  {$EXTERNALSYM EC_F_EC_PRE_COMP_NEW}
  EC_F_EC_PRE_COMP_NEW = 196;
  {$EXTERNALSYM EC_F_EC_WNAF_MUL}
  EC_F_EC_WNAF_MUL = 187;
  {$EXTERNALSYM EC_F_EC_WNAF_PRECOMPUTE_MULT}
  EC_F_EC_WNAF_PRECOMPUTE_MULT = 188;
  {$EXTERNALSYM EC_F_I2D_ECPARAMETERS}
  EC_F_I2D_ECPARAMETERS = 190;
  {$EXTERNALSYM EC_F_I2D_ECPKPARAMETERS}
  EC_F_I2D_ECPKPARAMETERS = 191;
  {$EXTERNALSYM EC_F_I2D_ECPRIVATEKEY}
  EC_F_I2D_ECPRIVATEKEY = 192;
  {$EXTERNALSYM EC_F_I2O_ECPUBLICKEY}
  EC_F_I2O_ECPUBLICKEY = 151;
  {$EXTERNALSYM EC_F_O2I_ECPUBLICKEY}
  EC_F_O2I_ECPUBLICKEY = 152;
//* Reason codes. */
  {$EXTERNALSYM EC_R_ASN1_ERROR}
  EC_R_ASN1_ERROR = 115;
  {$EXTERNALSYM EC_R_ASN1_UNKNOWN_FIELD}
  EC_R_ASN1_UNKNOWN_FIELD = 116;
  {$EXTERNALSYM EC_R_BUFFER_TOO_SMALL}
  EC_R_BUFFER_TOO_SMALL = 100;
  {$EXTERNALSYM EC_R_D2I_ECPKPARAMETERS_FAILURE}
  EC_R_D2I_ECPKPARAMETERS_FAILURE = 117;
  {$EXTERNALSYM EC_R_DISCRIMINANT_IS_ZERO}
  EC_R_DISCRIMINANT_IS_ZERO = 118;
  {$EXTERNALSYM EC_R_EC_GROUP_NEW_BY_NAME_FAILURE}
  EC_R_EC_GROUP_NEW_BY_NAME_FAILURE = 119;
  {$EXTERNALSYM EC_R_FIELD_TOO_LARGE}
  EC_R_FIELD_TOO_LARGE = 138;
  {$EXTERNALSYM EC_R_GROUP2PKPARAMETERS_FAILURE}
  EC_R_GROUP2PKPARAMETERS_FAILURE = 120;
  {$EXTERNALSYM EC_R_I2D_ECPKPARAMETERS_FAILURE}
  EC_R_I2D_ECPKPARAMETERS_FAILURE = 121;
  {$EXTERNALSYM EC_R_INCOMPATIBLE_OBJECTS}
  EC_R_INCOMPATIBLE_OBJECTS = 101;
  {$EXTERNALSYM EC_R_INVALID_ARGUMENT}
  EC_R_INVALID_ARGUMENT = 112;
  {$EXTERNALSYM EC_R_INVALID_COMPRESSED_POINT}
  EC_R_INVALID_COMPRESSED_POINT = 110;
  {$EXTERNALSYM EC_R_INVALID_COMPRESSION_BIT}
  EC_R_INVALID_COMPRESSION_BIT = 109;
  {$EXTERNALSYM EC_R_INVALID_ENCODING}
  EC_R_INVALID_ENCODING = 102;
  {$EXTERNALSYM EC_R_INVALID_FIELD}
  EC_R_INVALID_FIELD = 103;
  {$EXTERNALSYM EC_R_INVALID_FORM}
  EC_R_INVALID_FORM = 104;
  {$EXTERNALSYM EC_R_INVALID_GROUP_ORDER}
  EC_R_INVALID_GROUP_ORDER = 122;
  {$EXTERNALSYM EC_R_INVALID_PENTANOMIAL_BASIS}
  EC_R_INVALID_PENTANOMIAL_BASIS = 132;
  {$EXTERNALSYM EC_R_INVALID_PRIVATE_KEY}
  EC_R_INVALID_PRIVATE_KEY = 123;
  {$EXTERNALSYM EC_R_INVALID_TRINOMIAL_BASIS}
  EC_R_INVALID_TRINOMIAL_BASIS = 137;
  {$EXTERNALSYM EC_R_MISSING_PARAMETERS}
  EC_R_MISSING_PARAMETERS = 124;
  {$EXTERNALSYM EC_R_MISSING_PRIVATE_KEY}
  EC_R_MISSING_PRIVATE_KEY = 125;
  {$EXTERNALSYM EC_R_NOT_A_NIST_PRIME}
  EC_R_NOT_A_NIST_PRIME = 135;
  {$EXTERNALSYM EC_R_NOT_A_SUPPORTED_NIST_PRIME}
  EC_R_NOT_A_SUPPORTED_NIST_PRIME = 136;
  {$EXTERNALSYM EC_R_NOT_IMPLEMENTED}
  EC_R_NOT_IMPLEMENTED = 126;
  {$EXTERNALSYM EC_R_NOT_INITIALIZED}
  EC_R_NOT_INITIALIZED = 111;
  {$EXTERNALSYM EC_R_NO_FIELD_MOD}
  EC_R_NO_FIELD_MOD = 133;
  {$EXTERNALSYM EC_R_PASSED_NULL_PARAMETER}
  EC_R_PASSED_NULL_PARAMETER = 134;
  {$EXTERNALSYM EC_R_PKPARAMETERS2GROUP_FAILURE}
  EC_R_PKPARAMETERS2GROUP_FAILURE = 127;
  {$EXTERNALSYM EC_R_POINT_AT_INFINITY}
  EC_R_POINT_AT_INFINITY = 106;
  {$EXTERNALSYM EC_R_POINT_IS_NOT_ON_CURVE}
  EC_R_POINT_IS_NOT_ON_CURVE = 107;
  {$EXTERNALSYM EC_R_SLOT_FULL}
  EC_R_SLOT_FULL = 108;
  {$EXTERNALSYM EC_R_UNDEFINED_GENERATOR}
  EC_R_UNDEFINED_GENERATOR = 113;
  {$EXTERNALSYM EC_R_UNDEFINED_ORDER}
  EC_R_UNDEFINED_ORDER = 128;
  {$EXTERNALSYM EC_R_UNKNOWN_GROUP}
  EC_R_UNKNOWN_GROUP = 129;
  {$EXTERNALSYM EC_R_UNKNOWN_ORDER}
  EC_R_UNKNOWN_ORDER = 114;
  {$EXTERNALSYM EC_R_UNSUPPORTED_FIELD}
  EC_R_UNSUPPORTED_FIELD = 131;
  {$EXTERNALSYM EC_R_WRONG_ORDER}
  EC_R_WRONG_ORDER = 130;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_ECDSA}
  {$EXTERNALSYM ECDSA_F_ECDSA_DATA_NEW_METHOD}
  ECDSA_F_ECDSA_DATA_NEW_METHOD = 100;
  {$EXTERNALSYM ECDSA_F_ECDSA_DO_SIGN}
  ECDSA_F_ECDSA_DO_SIGN = 101;
  {$EXTERNALSYM ECDSA_F_ECDSA_DO_VERIFY}
  ECDSA_F_ECDSA_DO_VERIFY = 102;
  {$EXTERNALSYM ECDSA_F_ECDSA_SIGN_SETUP}
  ECDSA_F_ECDSA_SIGN_SETUP = 103;
  {$EXTERNALSYM ECDSA_R_BAD_SIGNATURE}
  ECDSA_R_BAD_SIGNATURE = 100;
  {$EXTERNALSYM ECDSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE}
  ECDSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE = 101;
  {$EXTERNALSYM ECDSA_R_ERR_EC_LIB}
  ECDSA_R_ERR_EC_LIB = 102;
  {$EXTERNALSYM ECDSA_R_MISSING_PARAMETERS}
  ECDSA_R_MISSING_PARAMETERS = 103;
  {$EXTERNALSYM ECDSA_R_RANDOM_NUMBER_GENERATION_FAILED}
  ECDSA_R_RANDOM_NUMBER_GENERATION_FAILED = 104;
  {$EXTERNALSYM ECDSA_R_SIGNATURE_MALLOC_FAILED}
  ECDSA_R_SIGNATURE_MALLOC_FAILED = 105;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_ECDH}
  {$EXTERNALSYM ECDH_F_ECDH_COMPUTE_KEY}
  ECDH_F_ECDH_COMPUTE_KEY = 100;
  {$EXTERNALSYM ECDH_F_ECDH_DATA_NEW_METHOD}
  ECDH_F_ECDH_DATA_NEW_METHOD = 101;
  {$EXTERNALSYM ECDH_R_KDF_FAILED}
  ECDH_R_KDF_FAILED = 102;
  {$EXTERNALSYM ECDH_R_NO_PRIVATE_VALUE}
  ECDH_R_NO_PRIVATE_VALUE = 100;
  {$EXTERNALSYM ECDH_R_POINT_ARITHMETIC_FAILURE}
  ECDH_R_POINT_ARITHMETIC_FAILURE = 101;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_BF}
  {$EXTERNALSYM BF_BLOCK}
  BF_BLOCK = 8;
  {$EXTERNALSYM BF_DECRYPT}
  BF_DECRYPT = 0;
  {$EXTERNALSYM BF_ENCRYPT}
  BF_ENCRYPT = 1;
  {$EXTERNALSYM BF_ROUNDS}
  BF_ROUNDS = 16;
  {$ENDIF}
  {$EXTERNALSYM EVP_MAX_MD_SIZE}
  EVP_MAX_MD_SIZE = 64; //* longest known is SHA512 */  - value I found, 16+20;
  {$EXTERNALSYM EVP_MAX_KEY_LENGTH}
  EVP_MAX_KEY_LENGTH = 32; //value I found, 24;
  {$EXTERNALSYM EVP_MAX_IV_LENGTH}
  EVP_MAX_IV_LENGTH = 16; //value I found, 8;
  {$EXTERNALSYM EVP_MAX_BLOCK_LENGTH}
  EVP_MAX_BLOCK_LENGTH=32;
  {$EXTERNALSYM NID_dhKeyAgreement}
  NID_dhKeyAgreement = 28;

  {$EXTERNALSYM NID_dsa}
  NID_dsa = 116;

  {$EXTERNALSYM NID_dsa_2}
  NID_dsa_2 = 67;

  {$EXTERNALSYM NID_dsaWithSHA}
  NID_dsaWithSHA = 66;

  {$EXTERNALSYM NID_dsaWithSHA1}
  NID_dsaWithSHA1 = 113;

  {$EXTERNALSYM NID_dsaWithSHA1_2}
  NID_dsaWithSHA1_2 = 70;

  {$EXTERNALSYM EVP_PKEY_MO_SIGN}
  EVP_PKEY_MO_SIGN = $0001;
  {$EXTERNALSYM EVP_PKEY_MO_VERIFY}
  EVP_PKEY_MO_VERIFY = $0002;

  {$EXTERNALSYM EVP_PKEY_MO_ENCRYPT}
  EVP_PKEY_MO_ENCRYPT = $0004;
  {$EXTERNALSYM EVP_PKEY_MO_DECRYPT}
  EVP_PKEY_MO_DECRYPT = $0008;

  {$EXTERNALSYM EVP_MD_FLAG_FIPS}
  EVP_MD_FLAG_FIPS = $0400;
  //* Note if suitable for use in FIPS mode */
  {$EXTERNALSYM EVP_MD_FLAG_PKEY_DIGEST}
  EVP_MD_FLAG_PKEY_DIGEST	= $0002; //* digest is a "clone" digest used
//					* which is a copy of an existing
//					* one for a specific public key type.
//					* EVP_dss1() etc */
//* Digest uses EVP_PKEY_METHOD for signing instead of MD specific signing */

  {$EXTERNALSYM EVP_MD_FLAG_PKEY_METHOD_SIGNATURE}
  EVP_MD_FLAG_PKEY_METHOD_SIGNATURE	= $0004;  //note: conflicts with FIPS

//* DigestAlgorithmIdentifier flags... */

  {$EXTERNALSYM EVP_MD_FLAG_DIGALGID_MASK}
  EVP_MD_FLAG_DIGALGID_MASK		= $0018;

//* NULL or absent parameter accepted. Use NULL */

  {$EXTERNALSYM EVP_MD_FLAG_DIGALGID_NULL}
  EVP_MD_FLAG_DIGALGID_NULL	 = $0000;

//* NULL or absent parameter accepted. Use NULL for PKCS#1 otherwise absent */

  {$EXTERNALSYM EVP_MD_FLAG_DIGALGID_ABSENT}
  EVP_MD_FLAG_DIGALGID_ABSENT	 = $0008;

//* Custom handling via ctrl */

  {$EXTERNALSYM EVP_MD_FLAG_DIGALGID_CUSTOM}
  EVP_MD_FLAG_DIGALGID_CUSTOM	 = $0018;

  {$EXTERNALSYM EVP_MD_FLAG_SVCTX}
  EVP_MD_FLAG_SVCTX	= $0800;
  //* pass EVP_MD_SVCTX to sign/verify */

//* Digest ctrls */

  {$EXTERNALSYM EVP_MD_CTRL_DIGALGID}
  EVP_MD_CTRL_DIGALGID	  = $1;
  {$EXTERNALSYM EVP_MD_CTRL_MICALG}
  EVP_MD_CTRL_MICALG			= $2;

//* Minimum Algorithm specific ctrl value */

  {$EXTERNALSYM EVP_MD_CTRL_ALG_CTRL}
	EVP_MD_CTRL_ALG_CTRL		 =	$1000;

  {$EXTERNALSYM NID_undef}
  NID_undef = 0;
  {$EXTERNALSYM NID_rsaEncryption}
  NID_rsaEncryption = 6;
  {$EXTERNALSYM NID_rsa}
  NID_rsa = 19;
  {$EXTERNALSYM NID_X9_62_id_ecPublicKey}
  NID_X9_62_id_ecPublicKey = 408;

  {$EXTERNALSYM EVP_PKEY_NONE}
  EVP_PKEY_NONE = NID_undef;
  {$EXTERNALSYM EVP_PKEY_RSA}
  EVP_PKEY_RSA = NID_rsaEncryption;
  {$EXTERNALSYM EVP_PKEY_RSA2}
  EVP_PKEY_RSA2 = NID_rsa;
  {$EXTERNALSYM EVP_PKEY_DSA}
  EVP_PKEY_DSA = NID_dsa;
  {$EXTERNALSYM EVP_PKEY_DSA1}
  EVP_PKEY_DSA1 = NID_dsa_2;
  {$EXTERNALSYM EVP_PKEY_DSA2}
  EVP_PKEY_DSA2 = NID_dsaWithSHA;
  {$EXTERNALSYM EVP_PKEY_DSA3}
  EVP_PKEY_DSA3 = NID_dsaWithSHA1;
  {$EXTERNALSYM EVP_PKEY_DSA4}
  EVP_PKEY_DSA4 = NID_dsaWithSHA1_2;

  {$EXTERNALSYM EVP_PKEY_DH}
  EVP_PKEY_DH = NID_dhKeyAgreement;
  {$EXTERNALSYM EVP_PKEY_EC}
  EVP_PKEY_EC = NID_X9_62_id_ecPublicKey;

  {$EXTERNALSYM EVP_PKT_SIGN}
  EVP_PKT_SIGN = $0010;
  {$EXTERNALSYM EVP_PKT_ENC}
  EVP_PKT_ENC = $0020;
  {$EXTERNALSYM EVP_PKT_EXCH}
  EVP_PKT_EXCH = $0040;
  {$EXTERNALSYM EVP_PKT_EXP}
  EVP_PKT_EXP = $1000;

  {$EXTERNALSYM EVP_PKS_RSA}
  EVP_PKS_RSA = $0100;
  {$EXTERNALSYM EVP_PKS_DSA}
  EVP_PKS_DSA = $0200;
  {$EXTERNALSYM EVP_PKS_EC}
  EVP_PKS_EC	= $0400;

  {$EXTERNALSYM EVP_PK_RSA}
  EVP_PK_RSA = $0001;
  {$EXTERNALSYM EVP_PK_DSA}
  EVP_PK_DSA = $0002;
  {$EXTERNALSYM EVP_PK_DH}
  EVP_PK_DH = $0004;
  {$EXTERNALSYM EVP_PK_EC}
  EVP_PK_EC = $0008;

  {$EXTERNALSYM EVP_BLOWFISH_KEY_SIZE}
  EVP_BLOWFISH_KEY_SIZE = 16;
  {$EXTERNALSYM EVP_CAST5_KEY_SIZE}
  EVP_CAST5_KEY_SIZE = 16;
  {$EXTERNALSYM EVP_RC2_KEY_SIZE}
  EVP_RC2_KEY_SIZE = 16;
  {$EXTERNALSYM EVP_RC4_KEY_SIZE}
  EVP_RC4_KEY_SIZE = 16;
  {$EXTERNALSYM EVP_RC5_32_12_16_KEY_SIZE}
  EVP_RC5_32_12_16_KEY_SIZE = 16;
  {$EXTERNALSYM EVP_MD_CTX_FLAG_ONESHOT}
  EVP_MD_CTX_FLAG_ONESHOT = $0001;
  //* digest update will be called
	//* once only */
  {$EXTERNALSYM EVP_MD_CTX_FLAG_CLEANED}
  EVP_MD_CTX_FLAG_CLEANED	= $0002;
  //* context has already been
	//* cleaned */
  {$EXTERNALSYM EVP_MD_CTX_FLAG_REUSE}
  EVP_MD_CTX_FLAG_REUSE	=	$0004;
  //* Don't free up ctx->md_data
	//* in EVP_MD_CTX_cleanup */
  //OpenSSL 1.0.0.
  //* FIPS and pad options are ignored in 1.0.0, definitions are here
// * so we don't accidentally reuse the values for other purposes.
// */

  {$EXTERNALSYM EVP_MD_CTX_FLAG_NON_FIPS_ALLOW}
 EVP_MD_CTX_FLAG_NON_FIPS_ALLOW = $0008;	//* Allow use of non FIPS digest
//						 * in FIPS mode */

//* The following PAD options are also currently ignored in 1.0.0, digest
// * parameters are handled through EVP_DigestSign*() and EVP_DigestVerify*()
// * instead.
// */


  {$EXTERNALSYM EVP_MD_CTX_FLAG_PAD_MASK}
  EVP_MD_CTX_FLAG_PAD_MASK = $F0;	//* RSA mode to use */
  {$EXTERNALSYM EVP_MD_CTX_FLAG_PAD_PKCS1}
  EVP_MD_CTX_FLAG_PAD_PKCS1 = $00;	//* PKCS#1 v1.5 mode */
  {$EXTERNALSYM EVP_MD_CTX_FLAG_PAD_X931}
  EVP_MD_CTX_FLAG_PAD_X931 = $10;	//* X9.31 mode */
  {$EXTERNALSYM EVP_MD_CTX_FLAG_PAD_PSS}
  EVP_MD_CTX_FLAG_PAD_PSS = $20;	//* PSS mode */
//#define M_EVP_MD_CTX_FLAG_PSS_SALT(ctx) \
//		((ctx->flags>>16) &0xFFFF) /* seed length */
  {$EXTERNALSYM EVP_MD_CTX_FLAG_PSS_MDLEN}
  EVP_MD_CTX_FLAG_PSS_MDLEN = $FFFF;	//* salt len same as digest */
  {$EXTERNALSYM EVP_MD_CTX_FLAG_PSS_MREC}
  EVP_MD_CTX_FLAG_PSS_MREC = $FFFE;	//* salt max or auto recovered */
  {$EXTERNALSYM EVP_MD_CTX_FLAG_NO_INIT}
   EVP_MD_CTX_FLAG_NO_INIT = $0100; //* Don't initialize md_data */

  //* Modes for ciphers */
  {$EXTERNALSYM EVP_CIPH_STREAM_CIPHER}
  EVP_CIPH_STREAM_CIPHER = $0;
  {$EXTERNALSYM EVP_CIPH_ECB_MODE}
  EVP_CIPH_ECB_MODE	= $1;
  {$EXTERNALSYM EVP_CIPH_CBC_MODE}
  EVP_CIPH_CBC_MODE	= $2;
  {$EXTERNALSYM EVP_CIPH_CFB_MODE}
  EVP_CIPH_CFB_MODE	= $3;
  {$EXTERNALSYM EVP_CIPH_OFB_MODE}
  EVP_CIPH_OFB_MODE	= $4;
  {$EXTERNALSYM EVP_CIPH_CTR_MODE}
  EVP_CIPH_CTR_MODE	= $5;
  {$EXTERNALSYM EVP_CIPH_GCM_MODE}
  EVP_CIPH_GCM_MODE	=	$6;
  {$EXTERNALSYM EVP_CIPH_CCM_MODE}
  EVP_CIPH_CCM_MODE	=	$7;
  {$EXTERNALSYM EVP_CIPH_XTS_MODE}
  EVP_CIPH_XTS_MODE	= $10001;
  {$EXTERNALSYM EVP_CIPH_MODE}
	EVP_CIPH_MODE	= $F0007;

//* Set if variable length cipher */
  {$EXTERNALSYM EVP_CIPH_VARIABLE_LENGTH}
  EVP_CIPH_VARIABLE_LENGTH = $8;
//* Set if the iv handling should be done by the cipher itself */
  {$EXTERNALSYM EVP_CIPH_CUSTOM_IV}
  EVP_CIPH_CUSTOM_IV = $10;
//* Set if the cipher's init() function should be called if key is NULL */
  {$EXTERNALSYM EVP_CIPH_ALWAYS_CALL_INIT}
  EVP_CIPH_ALWAYS_CALL_INIT	= $20;
//* Call ctrl() to init cipher parameters */
  {$EXTERNALSYM EVP_CIPH_CTRL_INIT}
  EVP_CIPH_CTRL_INIT = $40;
//* Don't use standard key length function */
  {$EXTERNALSYM EVP_CIPH_CUSTOM_KEY_LENGTH}
  EVP_CIPH_CUSTOM_KEY_LENGTH = $80;
//* Don't use standard block padding */
  {$EXTERNALSYM EVP_CIPH_NO_PADDING}
  EVP_CIPH_NO_PADDING	= $100;
//* cipher handles random key generation */
  {$EXTERNALSYM EVP_CIPH_RAND_KEY}
  EVP_CIPH_RAND_KEY	= $200;
//* cipher has its own additional copying logic */
  {$EXTERNALSYM EVP_CIPH_CUSTOM_COPY}
  EVP_CIPH_CUSTOM_COPY	 = $400;
//* Allow use default ASN1 get/set iv */
  {$EXTERNALSYM EVP_CIPH_FLAG_DEFAULT_ASN1}
  EVP_CIPH_FLAG_DEFAULT_ASN1 = $1000;
//* Buffer length in bits not bytes: CFB1 mode only */
  {$EXTERNALSYM EVP_CIPH_FLAG_LENGTH_BITS}
  EVP_CIPH_FLAG_LENGTH_BITS	= $2000;
//* Note if suitable for use in FIPS mode */
  {$EXTERNALSYM EVP_CIPH_FLAG_FIPS}
  EVP_CIPH_FLAG_FIPS	 = $4000;
//* Allow non FIPS cipher in FIPS mode */
  {$EXTERNALSYM EVP_CIPH_FLAG_NON_FIPS_ALLOW}
  EVP_CIPH_FLAG_NON_FIPS_ALLOW = $8000;
///* Cipher handles any and all padding logic as well
// * as finalisation.
// */
  {$EXTERNALSYM EVP_CIPH_FLAG_CUSTOM_CIPHER}
  EVP_CIPH_FLAG_CUSTOM_CIPHER	= $100000;
  {$EXTERNALSYM EVP_CIPH_FLAG_AEAD_CIPHER}
  EVP_CIPH_FLAG_AEAD_CIPHER = $200000;

  {$EXTERNALSYM EVP_CTRL_INIT}
  EVP_CTRL_INIT	= $0;
  {$EXTERNALSYM EVP_CTRL_SET_KEY_LENGTH}
  EVP_CTRL_SET_KEY_LENGTH = $1;
  {$EXTERNALSYM EVP_CTRL_GET_RC2_KEY_BITS}
  EVP_CTRL_GET_RC2_KEY_BITS	= $2;
  {$EXTERNALSYM EVP_CTRL_SET_RC2_KEY_BITS}
  EVP_CTRL_SET_RC2_KEY_BITS = $3;
  {$EXTERNALSYM EVP_CTRL_GET_RC5_ROUNDS}
  EVP_CTRL_GET_RC5_ROUNDS	= $4;
  {$EXTERNALSYM EVP_CTRL_SET_RC5_ROUNDS}
  EVP_CTRL_SET_RC5_ROUNDS = $5;
  {$EXTERNALSYM EVP_CTRL_RAND_KEY}
  EVP_CTRL_RAND_KEY	= $6;
  {$EXTERNALSYM EVP_CTRL_PBE_PRF_NID}
  EVP_CTRL_PBE_PRF_NID	 = $7;
  {$EXTERNALSYM EVP_CTRL_COPY}
  EVP_CTRL_COPY	= $8;
  {$EXTERNALSYM EVP_CTRL_GCM_SET_IVLEN}
  EVP_CTRL_GCM_SET_IVLEN = $9;
  {$EXTERNALSYM EVP_CTRL_GCM_GET_TAG}
  EVP_CTRL_GCM_GET_TAG = $10;
  {$EXTERNALSYM EVP_CTRL_GCM_SET_TAG}
  EVP_CTRL_GCM_SET_TAG = $11;
  {$EXTERNALSYM EVP_CTRL_GCM_SET_IV_FIXED}
  EVP_CTRL_GCM_SET_IV_FIXED = $12;
  {$EXTERNALSYM EVP_CTRL_GCM_IV_GEN}
  EVP_CTRL_GCM_IV_GEN = $13;
  {$EXTERNALSYM EVP_CTRL_CCM_SET_IVLEN}
  EVP_CTRL_CCM_SET_IVLEN = EVP_CTRL_GCM_SET_IVLEN;
  {$EXTERNALSYM EVP_CTRL_CCM_GET_TAG}
  EVP_CTRL_CCM_GET_TAG = EVP_CTRL_GCM_GET_TAG;
  {$EXTERNALSYM EVP_CTRL_CCM_SET_TAG}
  EVP_CTRL_CCM_SET_TAG = EVP_CTRL_GCM_SET_TAG;
  {$EXTERNALSYM EVP_CTRL_CCM_SET_L}
  EVP_CTRL_CCM_SET_L = $14;
  {$EXTERNALSYM EVP_CTRL_CCM_SET_MSGLEN}
  EVP_CTRL_CCM_SET_MSGLEN = $15;

///* AEAD cipher deduces payload length and returns number of bytes
// * required to store MAC and eventual padding. Subsequent call to
// * EVP_Cipher even appends/verifies MAC.
// */
  {$EXTERNALSYM EVP_CTRL_AEAD_TLS1_AAD}
  EVP_CTRL_AEAD_TLS1_AAD = $16;
//* Used by composite AEAD ciphers, no-op in GCM, CCM... */
  {$EXTERNALSYM EVP_CTRL_AEAD_SET_MAC_KEY}
  EVP_CTRL_AEAD_SET_MAC_KEY	= $17;
//* Set the GCM invocation field, decrypt only */
  {$EXTERNALSYM EVP_CTRL_GCM_SET_IV_INV}
  EVP_CTRL_GCM_SET_IV_INV	= $18;
//* PBE type */

//* GCM TLS constants */
//* Length of fixed part of IV derived from PRF */
  {$EXTERNALSYM EVP_GCM_TLS_FIXED_IV_LEN}
  EVP_GCM_TLS_FIXED_IV_LEN = 4;
//* Length of explicit part of IV part of TLS records */
  {$EXTERNALSYM EVP_GCM_TLS_EXPLICIT_IV_LEN}
  EVP_GCM_TLS_EXPLICIT_IV_LEN	= 8;
//* Length of tag for TLS */
  {$EXTERNALSYM EVP_GCM_TLS_TAG_LEN}
  EVP_GCM_TLS_TAG_LEN = 16;

//* Can appear as the outermost AlgorithmIdentifier */
  {$EXTERNALSYM EVP_PBE_TYPE_OUTER}
  EVP_PBE_TYPE_OUTER = $0;
//* Is an PRF type OID */
  {$EXTERNALSYM EVP_PBE_TYPE_PRF}
  EVP_PBE_TYPE_PRF = $1;

  {$EXTERNALSYM ASN1_PKEY_ALIAS}
  ASN1_PKEY_ALIAS	 = $1;
  {$EXTERNALSYM ASN1_PKEY_DYNAMIC}
  ASN1_PKEY_DYNAMIC	= $2;
  {$EXTERNALSYM ASN1_PKEY_SIGPARAM_NULL}
  ASN1_PKEY_SIGPARAM_NULL	= $4;
  {$EXTERNALSYM ASN1_PKEY_CTRL_PKCS7_SIGN}
  ASN1_PKEY_CTRL_PKCS7_SIGN	= $1;
  {$EXTERNALSYM ASN1_PKEY_CTRL_PKCS7_ENCRYPT}
  ASN1_PKEY_CTRL_PKCS7_ENCRYPT = $2;
  {$EXTERNALSYM ASN1_PKEY_CTRL_DEFAULT_MD_NID}
  ASN1_PKEY_CTRL_DEFAULT_MD_NID	= $3;
  {$EXTERNALSYM ASN1_PKEY_CTRL_CMS_SIGN}
  ASN1_PKEY_CTRL_CMS_SIGN	= $5;
  {$EXTERNALSYM ASN1_PKEY_CTRL_CMS_ENVELOPE}
  ASN1_PKEY_CTRL_CMS_ENVELOPE	= $7;

  {$EXTERNALSYM EVP_PKEY_OP_UNDEFINED}
  EVP_PKEY_OP_UNDEFINED	 = 0;
  {$EXTERNALSYM EVP_PKEY_OP_PARAMGEN}
  EVP_PKEY_OP_PARAMGEN	 =(1 shl 1);
  {$EXTERNALSYM EVP_PKEY_OP_KEYGEN}
  EVP_PKEY_OP_KEYGEN = (1 shl 2);
  {$EXTERNALSYM EVP_PKEY_OP_SIGN}
  EVP_PKEY_OP_SIGN	 = (1 shl 3);
  {$EXTERNALSYM EVP_PKEY_OP_VERIFY}
  EVP_PKEY_OP_VERIFY  = (1 shl 4);
  {$EXTERNALSYM EVP_PKEY_OP_VERIFYRECOVER}
  EVP_PKEY_OP_VERIFYRECOVER = (1 shl 5);
  {$EXTERNALSYM EVP_PKEY_OP_SIGNCTX}
  EVP_PKEY_OP_SIGNCTX = (1 shl 6);
  {$EXTERNALSYM EVP_PKEY_OP_VERIFYCTX}
  EVP_PKEY_OP_VERIFYCTX = (1 shl 7);
  {$EXTERNALSYM EVP_PKEY_OP_ENCRYPT}
  EVP_PKEY_OP_ENCRYPT	 = (1 shl 8);
  {$EXTERNALSYM EVP_PKEY_OP_DECRYPT}
  EVP_PKEY_OP_DECRYPT	 = (1 shl 9);
  {$EXTERNALSYM EVP_PKEY_OP_DERIVE}
  EVP_PKEY_OP_DERIVE	 = (1 shl 10);

  {$EXTERNALSYM EVP_PKEY_OP_TYPE_SIG}
  EVP_PKEY_OP_TYPE_SIG =
  {$EXTERNALSYM EVP_PKEY_OP_TYPE_CRYPT}
    (EVP_PKEY_OP_SIGN or EVP_PKEY_OP_VERIFY or EVP_PKEY_OP_VERIFYRECOVER
  {$EXTERNALSYM EVP_PKEY_OP_TYPE_CRYPT}
    or EVP_PKEY_OP_SIGNCTX or EVP_PKEY_OP_VERIFYCTX);

  {$EXTERNALSYM EVP_PKEY_OP_TYPE_CRYPT}
 EVP_PKEY_OP_TYPE_CRYPT = (EVP_PKEY_OP_ENCRYPT or EVP_PKEY_OP_DECRYPT);

//  EVP_PKEY_OP_TYPE_NOGEN =
//	(EVP_PKEY_OP_SIG or EVP_PKEY_OP_CRYPT or EVP_PKEY_OP_DERIVE);
//  guessing from above.  THere may be a typo in the header.
  {$EXTERNALSYM EVP_PKEY_OP_TYPE_NOGEN}
  EVP_PKEY_OP_TYPE_NOGEN =
  {$EXTERNALSYM EVP_PKEY_OP_TYPE_GEN}
	(EVP_PKEY_OP_TYPE_SIG or EVP_PKEY_OP_TYPE_CRYPT or EVP_PKEY_OP_DERIVE);

  {$EXTERNALSYM EVP_PKEY_OP_TYPE_GEN}
  EVP_PKEY_OP_TYPE_GEN =
		(EVP_PKEY_OP_PARAMGEN or EVP_PKEY_OP_KEYGEN);

  {$EXTERNALSYM EVP_PKEY_CTRL_MD}
  EVP_PKEY_CTRL_MD	=	1;
  {$EXTERNALSYM EVP_PKEY_CTRL_PEER_KEY}
  EVP_PKEY_CTRL_PEER_KEY	 = 2;

  {$EXTERNALSYM EVP_PKEY_CTRL_PKCS7_ENCRYPT}
  EVP_PKEY_CTRL_PKCS7_ENCRYPT	= 3;
  {$EXTERNALSYM EVP_PKEY_CTRL_PKCS7_DECRYPT}
  EVP_PKEY_CTRL_PKCS7_DECRYPT	= 4;

  {$EXTERNALSYM EVP_PKEY_CTRL_PKCS7_SIGN}
  EVP_PKEY_CTRL_PKCS7_SIGN	= 5;

  {$EXTERNALSYM EVP_PKEY_CTRL_SET_MAC_KEY}
  EVP_PKEY_CTRL_SET_MAC_KEY	= 6;

  {$EXTERNALSYM EVP_PKEY_CTRL_DIGESTINIT}
  EVP_PKEY_CTRL_DIGESTINIT	= 7;

//* Used by GOST key encryption in TLS */

  {$EXTERNALSYM EVP_PKEY_CTRL_SET_IV}
  EVP_PKEY_CTRL_SET_IV 	= 8;
  {$EXTERNALSYM EVP_PKEY_CTRL_CMS_ENCRYPT}
  EVP_PKEY_CTRL_CMS_ENCRYPT	= 9;
  {$EXTERNALSYM EVP_PKEY_CTRL_CMS_DECRYPT}
  EVP_PKEY_CTRL_CMS_DECRYPT = 10;
  {$EXTERNALSYM EVP_PKEY_CTRL_CMS_SIGN}
  EVP_PKEY_CTRL_CMS_SIGN	 = 11;
  {$EXTERNALSYM EVP_PKEY_CTRL_CIPHER}
  EVP_PKEY_CTRL_CIPHER	 = 12;
  {$EXTERNALSYM EVP_PKEY_ALG_CTRL}
  EVP_PKEY_ALG_CTRL		= $1000;

  {$EXTERNALSYM EVP_PKEY_FLAG_AUTOARGLEN}
  EVP_PKEY_FLAG_AUTOARGLEN	= 2;
///* Method handles all operations: don't assume any digest related
// * defaults.
// */
  {$EXTERNALSYM EVP_PKEY_FLAG_SIGCTX_CUSTOM}
  EVP_PKEY_FLAG_SIGCTX_CUSTOM	= 4;
  {$EXTERNALSYM EVP_F_AESNI_INIT_KEY}
  EVP_F_AESNI_INIT_KEY				= 165;
  {$EXTERNALSYM EVP_F_AESNI_XTS_CIPHER}
  EVP_F_AESNI_XTS_CIPHER				= 176;
  {$EXTERNALSYM EVP_F_AES_INIT_KEY}
  EVP_F_AES_INIT_KEY = 133;
  {$EXTERNALSYM EVP_F_ALG_MODULE_INIT}
  EVP_F_ALG_MODULE_INIT	= 138;
  {$EXTERNALSYM EVP_F_AES_XTS}
  EVP_F_AES_XTS = 172;
  {$EXTERNALSYM EVP_F_AES_XTS_CIPHER}
  EVP_F_AES_XTS_CIPHER = 175;
  {$EXTERNALSYM EVP_F_CAMELLIA_INIT_KEY}
  EVP_F_CAMELLIA_INIT_KEY = 159;
  {$EXTERNALSYM EVP_F_CMAC_INIT}
  EVP_F_CMAC_INIT	= 173;
  {$EXTERNALSYM EVP_F_D2I_PKEY}
  EVP_F_D2I_PKEY = 100;
  {$EXTERNALSYM EVP_F_DO_SIGVER_INIT}
  EVP_F_DO_SIGVER_INIT = 161;
  {$EXTERNALSYM EVP_F_DO_EVP_ENC_ENGINE}
  EVP_F_DO_EVP_ENC_ENGINE = 140;
  {$EXTERNALSYM EVP_F_DSAPKEY2PKCS8}
  EVP_F_DSAPKEY2PKCS8	= 134;
  {$EXTERNALSYM EVP_F_DSA_PKEY2PKCS8}
  EVP_F_DSA_PKEY2PKCS8 = 135;
  {$EXTERNALSYM EVP_F_ECDSA_PKEY2PKCS8}
  EVP_F_ECDSA_PKEY2PKCS8 = 129;
  {$EXTERNALSYM EVP_F_ECKEY_PKEY2PKCS8}
  EVP_F_ECKEY_PKEY2PKCS8 = 132;
  {$EXTERNALSYM EVP_F_EVP_CIPHERINIT_EX}
  EVP_F_EVP_CIPHERINIT_EX	= 123;
  {$EXTERNALSYM EVP_F_EVP_CIPHER_CTX_COPY}
  EVP_F_EVP_CIPHER_CTX_COPY = 163;
  {$EXTERNALSYM EVP_F_EVP_CIPHER_CTX_CTRL}
  EVP_F_EVP_CIPHER_CTX_CTRL	= 124;
  {$EXTERNALSYM EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH}
  EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH	= 122;
  {$EXTERNALSYM EVP_F_EVP_DECRYPTFINAL_EX}
  EVP_F_EVP_DECRYPTFINAL_EX	= 101;
  //was EVP_F_EVP_DECRYPTFINAL = 101;
  {$EXTERNALSYM EVP_F_EVP_DIGESTINIT_EX}
  EVP_F_EVP_DIGESTINIT_EX	= 128;
  {$EXTERNALSYM EVP_F_EVP_ENCRYPTFINAL_EX}
  EVP_F_EVP_ENCRYPTFINAL_EX	= 127;
  {$EXTERNALSYM EVP_F_EVP_MD_CTX_COPY_EX}
  EVP_F_EVP_MD_CTX_COPY_EX = 110;
  {$EXTERNALSYM EVP_F_EVP_MD_SIZE}
  EVP_F_EVP_MD_SIZE = 162;
  //was EVP_F_EVP_MD_CTX_COPY = 110;
  {$EXTERNALSYM EVP_F_EVP_OPENINIT}
  EVP_F_EVP_OPENINIT = 102;
  {$EXTERNALSYM EVP_F_EVP_PBE_ALG_ADD}
  EVP_F_EVP_PBE_ALG_ADD	= 115;
  {$EXTERNALSYM EVP_F_EVP_PBE_ALG_ADD_TYPE}
  EVP_F_EVP_PBE_ALG_ADD_TYPE = 160;
  {$EXTERNALSYM EVP_F_EVP_PBE_CIPHERINIT}
  EVP_F_EVP_PBE_CIPHERINIT = 116;
  {$EXTERNALSYM EVP_F_EVP_PKCS82PKEY}
  EVP_F_EVP_PKCS82PKEY = 111;
  {$EXTERNALSYM EVP_F_EVP_PKEY2PKCS8_BROKEN}
  EVP_F_EVP_PKEY2PKCS8_BROKEN	= 113;
  //was  EVP_F_EVP_PKEY2PKCS8 = 113;
  {$EXTERNALSYM EVP_F_EVP_PKCS82PKEY_BROKEN}
  EVP_F_EVP_PKCS82PKEY_BROKEN = 136;
  {$EXTERNALSYM EVP_F_EVP_PKEY_COPY_PARAMETERS}
  EVP_F_EVP_PKEY_COPY_PARAMETERS = 103;
  {$EXTERNALSYM EVP_F_EVP_PKEY_CTX_CTRL}
  EVP_F_EVP_PKEY_CTX_CTRL	= 137;
  {$EXTERNALSYM EVP_F_EVP_PKEY_CTX_CTRL_STR}
  EVP_F_EVP_PKEY_CTX_CTRL_STR = 150;
  {$EXTERNALSYM EVP_F_EVP_PKEY_CTX_DUP}
  EVP_F_EVP_PKEY_CTX_DUP = 156;
  {$EXTERNALSYM EVP_F_EVP_PKEY_DECRYPT}
  EVP_F_EVP_PKEY_DECRYPT = 104;
  {$EXTERNALSYM EVP_F_EVP_PKEY_DECRYPT_INIT}
  EVP_F_EVP_PKEY_DECRYPT_INIT = 138;
  {$EXTERNALSYM EVP_F_EVP_PKEY_DECRYPT_OLD}
  EVP_F_EVP_PKEY_DECRYPT_OLD = 151;
  {$EXTERNALSYM EVP_F_EVP_PKEY_DERIVE}
  EVP_F_EVP_PKEY_DERIVE = 153;
  {$EXTERNALSYM EVP_F_EVP_PKEY_DERIVE_INIT}
  EVP_F_EVP_PKEY_DERIVE_INIT = 154;
  {$EXTERNALSYM EVP_F_EVP_PKEY_DERIVE_SET_PEER}
  EVP_F_EVP_PKEY_DERIVE_SET_PEER = 155;
  {$EXTERNALSYM EVP_F_EVP_PKEY_ENCRYPT}
  EVP_F_EVP_PKEY_ENCRYPT = 105;
  {$EXTERNALSYM EVP_F_EVP_PKEY_ENCRYPT_INIT}
  EVP_F_EVP_PKEY_ENCRYPT_INIT	= 139;
  {$EXTERNALSYM EVP_F_EVP_PKEY_ENCRYPT_OLD}
  EVP_F_EVP_PKEY_ENCRYPT_OLD = 152;
  {$EXTERNALSYM EVP_F_EVP_PKEY_GET1_DH}
  EVP_F_EVP_PKEY_GET1_DH = 119;
  {$EXTERNALSYM EVP_F_EVP_PKEY_GET1_DSA}
  EVP_F_EVP_PKEY_GET1_DSA	= 120;
  {$EXTERNALSYM EVP_F_EVP_PKEY_GET1_ECDSA}
  EVP_F_EVP_PKEY_GET1_ECDSA	= 130;
  {$EXTERNALSYM EVP_F_EVP_PKEY_GET1_EC_KEY}
  EVP_F_EVP_PKEY_GET1_EC_KEY = 131;
  {$EXTERNALSYM EVP_F_EVP_PKEY_GET1_RSA}
  EVP_F_EVP_PKEY_GET1_RSA	= 121;
  {$EXTERNALSYM EVP_F_EVP_PKEY_KEYGEN}
  EVP_F_EVP_PKEY_KEYGEN	= 146;
  {$EXTERNALSYM EVP_F_EVP_PKEY_KEYGEN_INIT}
  EVP_F_EVP_PKEY_KEYGEN_INIT = 147;
  {$EXTERNALSYM EVP_F_EVP_PKEY_NEW}
  EVP_F_EVP_PKEY_NEW = 106;
  {$EXTERNALSYM EVP_F_EVP_PKEY_PARAMGEN}
  EVP_F_EVP_PKEY_PARAMGEN				= 148;
  {$EXTERNALSYM EVP_F_EVP_PKEY_PARAMGEN_INIT}
  EVP_F_EVP_PKEY_PARAMGEN_INIT			= 149;
  {$EXTERNALSYM EVP_F_EVP_PKEY_SIGN}
  EVP_F_EVP_PKEY_SIGN				= 140;
  {$EXTERNALSYM EVP_F_EVP_PKEY_SIGN_INIT}
  EVP_F_EVP_PKEY_SIGN_INIT			= 141;
  {$EXTERNALSYM EVP_F_EVP_PKEY_VERIFY}
  EVP_F_EVP_PKEY_VERIFY				= 142;
  {$EXTERNALSYM EVP_F_EVP_PKEY_VERIFY_INIT}
  EVP_F_EVP_PKEY_VERIFY_INIT			= 143;
  {$EXTERNALSYM EVP_F_EVP_PKEY_VERIFY_RECOVER}
  EVP_F_EVP_PKEY_VERIFY_RECOVER		 = 144;
  {$EXTERNALSYM EVP_F_EVP_PKEY_VERIFY_RECOVER_INIT}
  EVP_F_EVP_PKEY_VERIFY_RECOVER_INIT		= 145;
  {$EXTERNALSYM EVP_F_EVP_RIJNDAEL}
  EVP_F_EVP_RIJNDAEL = 126;
  {$EXTERNALSYM EVP_F_EVP_SIGNFINAL}
  EVP_F_EVP_SIGNFINAL = 107;
  {$EXTERNALSYM EVP_F_EVP_VERIFYFINAL}
  EVP_F_EVP_VERIFYFINAL = 108;
  {$EXTERNALSYM EVP_F_FIPS_CIPHERINIT}
  EVP_F_FIPS_CIPHERINIT				= 166;
  {$EXTERNALSYM EVP_F_FIPS_CIPHER_CTX_COPY}
  EVP_F_FIPS_CIPHER_CTX_COPY			= 170;
  {$EXTERNALSYM EVP_F_FIPS_CIPHER_CTX_CTRL}
  EVP_F_FIPS_CIPHER_CTX_CTRL		  = 167;
  {$EXTERNALSYM EVP_F_FIPS_CIPHER_CTX_SET_KEY_LENGTH}
  EVP_F_FIPS_CIPHER_CTX_SET_KEY_LENGTH		= 171;
  {$EXTERNALSYM EVP_F_FIPS_DIGESTINIT}
  EVP_F_FIPS_DIGESTINIT				 = 168;
  {$EXTERNALSYM EVP_F_FIPS_MD_CTX_COPY}
  EVP_F_FIPS_MD_CTX_COPY				= 169;
  {$EXTERNALSYM EVP_F_HMAC_INIT_EX}
  EVP_F_HMAC_INIT_EX				 = 174;
  {$EXTERNALSYM EVP_F_INT_CTX_NEW}
  EVP_F_INT_CTX_NEW				 = 157;
  {$EXTERNALSYM EVP_F_PKCS5_PBE_KEYIVGEN}
  EVP_F_PKCS5_PBE_KEYIVGEN = 117;
  {$EXTERNALSYM EVP_F_PKCS5_V2_PBKDF2_KEYIVGEN}
  EVP_F_PKCS5_V2_PBKDF2_KEYIVGEN = 164;

  {$EXTERNALSYM EVP_F_PKCS5_V2_PBE_KEYIVGEN}
  EVP_F_PKCS5_V2_PBE_KEYIVGEN	= 118;
  {$EXTERNALSYM EVP_F_PKCS8_SET_BROKEN}
  EVP_F_PKCS8_SET_BROKEN = 112;
  {$EXTERNALSYM EVP_F_PKEY_SET_TYPE}
  EVP_F_PKEY_SET_TYPE			 = 158;

  //was EVP_F_EVP_PKCS8_SET_BROKEN = 112;
  {$EXTERNALSYM EVP_F_RC2_MAGIC_TO_METH}
  EVP_F_RC2_MAGIC_TO_METH	= 109;
  {$EXTERNALSYM EVP_F_RC5_CTRL}
  EVP_F_RC5_CTRL = 125;
  {$EXTERNALSYM EVP_R_AES_IV_SETUP_FAILED}
  EVP_R_AES_IV_SETUP_FAILED		 = 162;
  {$EXTERNALSYM EVP_R_AES_KEY_SETUP_FAILED}
  EVP_R_AES_KEY_SETUP_FAILED	 = 143;
  {$EXTERNALSYM EVP_R_ASN1_LIB}
  EVP_R_ASN1_LIB					 = 140;
  {$EXTERNALSYM EVP_R_BAD_BLOCK_LENGTH}
  EVP_R_BAD_BLOCK_LENGTH				= 136;
  {$EXTERNALSYM EVP_R_BAD_DECRYPT}
  EVP_R_BAD_DECRYPT = 100;
  {$EXTERNALSYM EVP_R_BN_DECODE_ERROR}
  EVP_R_BN_DECODE_ERROR = 112;
  {$EXTERNALSYM EVP_R_BN_PUBKEY_ERROR}
  EVP_R_BN_PUBKEY_ERROR = 113;
  {$EXTERNALSYM EVP_R_BUFFER_TOO_SMALL}
  EVP_R_BUFFER_TOO_SMALL = 155;
  {$EXTERNALSYM EVP_R_CIPHER_PARAMETER_ERROR}
  EVP_R_CIPHER_PARAMETER_ERROR = 122;
  {$EXTERNALSYM EVP_R_COMMAND_NOT_SUPPORTED}
  EVP_R_COMMAND_NOT_SUPPORTED	= 147;
  {$EXTERNALSYM EVP_R_DECODE_ERROR}
  EVP_R_DECODE_ERROR = 114;
  {$EXTERNALSYM EVP_R_DIFFERENT_KEY_TYPES}
  EVP_R_DIFFERENT_KEY_TYPES = 101;
  {$EXTERNALSYM EVP_R_DIFFERENT_PARAMETERS}
  EVP_R_DIFFERENT_PARAMETERS = 153;
  {$EXTERNALSYM EVP_R_DISABLED_FOR_FIPS}
  EVP_R_DISABLED_FOR_FIPS	= 163; //was 144;

  {$EXTERNALSYM EVP_R_ENCODE_ERROR}
  EVP_R_ENCODE_ERROR = 115;
  {$EXTERNALSYM EVP_R_ERROR_LOADING_SECTION}
  EVP_R_ERROR_LOADING_SECTION = 165;
  {$EXTERNALSYM EVP_R_ERROR_SETTING_FIPS_MODE}
  EVP_R_ERROR_SETTING_FIPS_MODE = 166;

  {$EXTERNALSYM EVP_R_EVP_PBE_CIPHERINIT_ERROR}
  EVP_R_EVP_PBE_CIPHERINIT_ERROR = 119;
  {$EXTERNALSYM EVP_R_EXPECTING_AN_RSA_KEY}
  EVP_R_EXPECTING_AN_RSA_KEY = 127;
  {$EXTERNALSYM EVP_R_EXPECTING_A_DH_KEY}
  EVP_R_EXPECTING_A_DH_KEY = 128;
  {$EXTERNALSYM EVP_R_EXPECTING_A_DSA_KEY}
  EVP_R_EXPECTING_A_DSA_KEY	= 129;
  {$EXTERNALSYM EVP_R_EXPECTING_A_ECDSA_KEY}
  EVP_R_EXPECTING_A_ECDSA_KEY	= 141;
  {$EXTERNALSYM EVP_R_EXPECTING_A_EC_KEY}
  EVP_R_EXPECTING_A_EC_KEY = 142;
  {$EXTERNALSYM EVP_R_FIPS_MODE_NOT_SUPPORTED}
  EVP_R_FIPS_MODE_NOT_SUPPORTED	= 167;
  {$EXTERNALSYM EVP_R_INITIALIZATION_ERROR}
  EVP_R_INITIALIZATION_ERROR = 134;
  {$EXTERNALSYM EVP_R_INPUT_NOT_INITIALIZED}
  EVP_R_INPUT_NOT_INITIALIZED = 111;
  {$EXTERNALSYM EVP_R_INVALID_DIGEST}
  EVP_R_INVALID_DIGEST = 152;
  {$EXTERNALSYM EVP_R_INVALID_KEY_LENGTH}
  EVP_R_INVALID_KEY_LENGTH = 130;
  {$EXTERNALSYM EVP_R_INVALID_OPERATION}
  EVP_R_INVALID_OPERATION	= 148;
  {$EXTERNALSYM EVP_R_INVALID_FIPS_MODE}
  EVP_R_INVALID_FIPS_MODE	= 168; //was: 148;
  {$EXTERNALSYM EVP_R_IV_TOO_LARGE}
  EVP_R_IV_TOO_LARGE = 102;
  {$EXTERNALSYM EVP_R_KEYGEN_FAILURE}
  EVP_R_KEYGEN_FAILURE = 120;
  {$EXTERNALSYM EVP_R_MESSAGE_DIGEST_IS_NULL}
  EVP_R_MESSAGE_DIGEST_IS_NULL = 159;
  {$EXTERNALSYM EVP_R_METHOD_NOT_SUPPORTED}
  EVP_R_METHOD_NOT_SUPPORTED	 = 144;
  {$EXTERNALSYM EVP_R_MISSING_PARMATERS}
  EVP_R_MISSING_PARMATERS = 103;
  {$EXTERNALSYM EVP_R_NO_CIPHER_SET}
  EVP_R_NO_CIPHER_SET			= 131;
  {$EXTERNALSYM EVP_R_NO_DEFAULT_DIGEST}
  EVP_R_NO_DEFAULT_DIGEST	= 158;
  {$EXTERNALSYM EVP_R_NO_DIGEST_SET}
  EVP_R_NO_DIGEST_SET			= 139;
  {$EXTERNALSYM EVP_R_NO_DSA_PARAMETERS}
  EVP_R_NO_DSA_PARAMETERS = 116;
  {$EXTERNALSYM EVP_R_NO_KEY_SET}
  EVP_R_NO_KEY_SET				= 154;
  {$EXTERNALSYM EVP_R_NO_OPERATION_SET}
  EVP_R_NO_OPERATION_SET		= 149;
  {$EXTERNALSYM EVP_R_NO_SIGN_FUNCTION_CONFIGURED}
  EVP_R_NO_SIGN_FUNCTION_CONFIGURED = 104;
  {$EXTERNALSYM EVP_R_NO_VERIFY_FUNCTION_CONFIGURED}
  EVP_R_NO_VERIFY_FUNCTION_CONFIGURED = 105;
  {$EXTERNALSYM EVP_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE}
  EVP_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE = 150;
  {$EXTERNALSYM EVP_R_OPERATON_NOT_INITIALIZED}
  EVP_R_OPERATON_NOT_INITIALIZED = 151;
  {$EXTERNALSYM EVP_R_PKCS8_UNKNOWN_BROKEN_TYPE}
  EVP_R_PKCS8_UNKNOWN_BROKEN_TYPE = 117;
  {$EXTERNALSYM EVP_R_PRIVATE_KEY_DECODE_ERROR}
  EVP_R_PRIVATE_KEY_DECODE_ERROR = 145;
  {$EXTERNALSYM EVP_R_PRIVATE_KEY_ENCODE_ERROR}
  EVP_R_PRIVATE_KEY_ENCODE_ERROR = 146;
  {$EXTERNALSYM EVP_R_PUBLIC_KEY_NOT_RSA}
  EVP_R_PUBLIC_KEY_NOT_RSA = 106;
  {$EXTERNALSYM EVP_R_TOO_LARGE}
  EVP_R_TOO_LARGE	= 164;
  {$EXTERNALSYM EVP_R_UNKNOWN_CIPHER}
  EVP_R_UNKNOWN_CIPHER = 160;
  {$EXTERNALSYM EVP_R_UNKNOWN_DIGEST}
  EVP_R_UNKNOWN_DIGEST = 161;
  {$EXTERNALSYM EVP_R_UNKNOWN_OPTION}
  EVP_R_UNKNOWN_OPTION				= 169; //149;
  {$EXTERNALSYM EVP_R_UNKNOWN_PBE_ALGORITHM}
  EVP_R_UNKNOWN_PBE_ALGORITHM = 121;
  {$EXTERNALSYM EVP_R_UNSUPPORTED_CIPHER}
  EVP_R_UNSUPPORTED_CIPHER = 107;
  {$EXTERNALSYM EVP_R_UNSUPORTED_NUMBER_OF_ROUNDS}
  EVP_R_UNSUPORTED_NUMBER_OF_ROUNDS	= 135;

  {$EXTERNALSYM EVP_R_UNSUPPORTED_KEYLENGTH}
  EVP_R_UNSUPPORTED_KEYLENGTH = 123;
  {$EXTERNALSYM EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION}
  EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION = 124;
  {$EXTERNALSYM EVP_R_UNSUPPORTED_KEY_SIZE}
  EVP_R_UNSUPPORTED_KEY_SIZE = 108;
  {$EXTERNALSYM EVP_R_UNSUPPORTED_PRF}
  EVP_R_UNSUPPORTED_PRF = 125;
  {$EXTERNALSYM EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM}
  EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM = 118;
  {$EXTERNALSYM EVP_R_UNSUPPORTED_SALT_TYPE}
  EVP_R_UNSUPPORTED_SALT_TYPE = 126;
  {$EXTERNALSYM EVP_R_WRONG_FINAL_BLOCK_LENGTH}
  EVP_R_WRONG_FINAL_BLOCK_LENGTH = 109;
  {$EXTERNALSYM EVP_R_WRONG_PUBLIC_KEY_TYPE}
  EVP_R_WRONG_PUBLIC_KEY_TYPE = 110;
  {$EXTERNALSYM EVP_R_SEED_KEY_SETUP_FAILED}
  EVP_R_SEED_KEY_SETUP_FAILED = 162;
  {$IFDEF OPENSSL_FIPS}
//* Function codes. */
  {$EXTERNALSYM FIPS_F_DH_BUILTIN_GENPARAMS}
  FIPS_F_DH_BUILTIN_GENPARAMS	= 100;
  {$EXTERNALSYM FIPS_F_DSA_BUILTIN_PARAMGEN}
  FIPS_F_DSA_BUILTIN_PARAMGEN	  = 101;
  {$EXTERNALSYM FIPS_F_DSA_DO_SIGN}
  FIPS_F_DSA_DO_SIGN				= 102;
  {$EXTERNALSYM FIPS_F_DSA_DO_VERIFY}
  FIPS_F_DSA_DO_VERIFY				= 103;
  {$EXTERNALSYM FIPS_F_EVP_CIPHERINIT_EX}
  FIPS_F_EVP_CIPHERINIT_EX		= 124;
  {$EXTERNALSYM FIPS_F_EVP_DIGESTINIT_EX}
  FIPS_F_EVP_DIGESTINIT_EX			= 125;
  {$EXTERNALSYM FIPS_F_FIPS_CHECK_DSA}
  FIPS_F_FIPS_CHECK_DSA				 = 104;
  {$EXTERNALSYM FIPS_F_FIPS_CHECK_INCORE_FINGERPRINT}
  FIPS_F_FIPS_CHECK_INCORE_FINGERPRINT		= 105;
  {$EXTERNALSYM FIPS_F_FIPS_CHECK_RSA}
  FIPS_F_FIPS_CHECK_RSA				= 106;
  {$EXTERNALSYM FIPS_F_FIPS_DSA_CHECK}
  FIPS_F_FIPS_DSA_CHECK				= 107;
  {$EXTERNALSYM FIPS_F_FIPS_MODE_SET}
  FIPS_F_FIPS_MODE_SET				 = 108;
  {$EXTERNALSYM FIPS_F_FIPS_PKEY_SIGNATURE_TEST}
  FIPS_F_FIPS_PKEY_SIGNATURE_TEST			= 109;
  {$EXTERNALSYM FIPS_F_FIPS_SELFTEST_AES}
  FIPS_F_FIPS_SELFTEST_AES			= 110;
  {$EXTERNALSYM FIPS_F_FIPS_SELFTEST_DES}
  FIPS_F_FIPS_SELFTEST_DES			= 111;
  {$EXTERNALSYM FIPS_F_FIPS_SELFTEST_DSA}
  FIPS_F_FIPS_SELFTEST_DSA			 = 112;
  {$EXTERNALSYM FIPS_F_FIPS_SELFTEST_HMAC}
  FIPS_F_FIPS_SELFTEST_HMAC			 = 113;
  {$EXTERNALSYM FIPS_F_FIPS_SELFTEST_RNG}
  FIPS_F_FIPS_SELFTEST_RNG			 = 114;
  {$EXTERNALSYM FIPS_F_FIPS_SELFTEST_SHA1}
  FIPS_F_FIPS_SELFTEST_SHA1			 = 115;
  {$EXTERNALSYM FIPS_F_HASH_FINAL}
  FIPS_F_HASH_FINAL				= 123;
  {$EXTERNALSYM FIPS_F_RSA_BUILTIN_KEYGEN}
  FIPS_F_RSA_BUILTIN_KEYGEN			= 116;
  {$EXTERNALSYM FIPS_F_RSA_EAY_PRIVATE_DECRYPT}
  FIPS_F_RSA_EAY_PRIVATE_DECRYPT			= 117;
  {$EXTERNALSYM FIPS_F_RSA_EAY_PRIVATE_ENCRYPT}
  FIPS_F_RSA_EAY_PRIVATE_ENCRYPT			= 118;
  {$EXTERNALSYM FIPS_F_RSA_EAY_PUBLIC_DECRYPT}
  FIPS_F_RSA_EAY_PUBLIC_DECRYPT			 = 119;
  {$EXTERNALSYM FIPS_F_RSA_EAY_PUBLIC_ENCRYPT}
  FIPS_F_RSA_EAY_PUBLIC_ENCRYPT			 = 120;
  {$EXTERNALSYM FIPS_F_RSA_X931_GENERATE_KEY_EX}
  FIPS_F_RSA_X931_GENERATE_KEY_EX			= 121;
  {$EXTERNALSYM FIPS_F_SSLEAY_RAND_BYTES}
  FIPS_F_SSLEAY_RAND_BYTES		 = 122;
//* Reason codes. */
  {$EXTERNALSYM FIPS_R_CANNOT_READ_EXE}
  FIPS_R_CANNOT_READ_EXE			   = 103;
  {$EXTERNALSYM FIPS_R_CANNOT_READ_EXE_DIGEST}
  FIPS_R_CANNOT_READ_EXE_DIGEST			= 104;
  {$EXTERNALSYM FIPS_R_CONTRADICTING_EVIDENCE}
  FIPS_R_CONTRADICTING_EVIDENCE			 = 114;
  {$EXTERNALSYM FIPS_R_EXE_DIGEST_DOES_NOT_MATCH}
  FIPS_R_EXE_DIGEST_DOES_NOT_MATCH		 = 105;
  {$EXTERNALSYM FIPS_R_FINGERPRINT_DOES_NOT_MATCH}
  FIPS_R_FINGERPRINT_DOES_NOT_MATCH		 = 110;
  {$EXTERNALSYM FIPS_R_FINGERPRINT_DOES_NOT_MATCH_NONPIC_RELOCATED}
  FIPS_R_FINGERPRINT_DOES_NOT_MATCH_NONPIC_RELOCATED = 111;
  {$EXTERNALSYM FIPS_R_FINGERPRINT_DOES_NOT_MATCH_SEGMENT_ALIASING}
  FIPS_R_FINGERPRINT_DOES_NOT_MATCH_SEGMENT_ALIASING = 112;
  {$EXTERNALSYM FIPS_R_FIPS_MODE_ALREADY_SET}
  FIPS_R_FIPS_MODE_ALREADY_SET			 = 102;
  {$EXTERNALSYM FIPS_R_FIPS_SELFTEST_FAILED}
  FIPS_R_FIPS_SELFTEST_FAILED			 = 106;
  {$EXTERNALSYM FIPS_R_INVALID_KEY_LENGTH}
  FIPS_R_INVALID_KEY_LENGTH			 = 109;
  {$EXTERNALSYM FIPS_R_KEY_TOO_SHORT}
  FIPS_R_KEY_TOO_SHORT				 = 108;
  {$EXTERNALSYM FIPS_R_NON_FIPS_METHOD}
  FIPS_R_NON_FIPS_METHOD				 = 100;
  {$EXTERNALSYM FIPS_R_PAIRWISE_TEST_FAILED}
  FIPS_R_PAIRWISE_TEST_FAILED			 = 107;
  {$EXTERNALSYM FIPS_R_RSA_DECRYPT_ERROR}
  FIPS_R_RSA_DECRYPT_ERROR			 = 115;
  {$EXTERNALSYM FIPS_R_RSA_ENCRYPT_ERROR}
  FIPS_R_RSA_ENCRYPT_ERROR			 = 116;
  {$EXTERNALSYM FIPS_R_SELFTEST_FAILED}
  FIPS_R_SELFTEST_FAILED				 = 101;
  {$EXTERNALSYM FIPS_R_TEST_FAILURE}
  FIPS_R_TEST_FAILURE				 = 117;
  {$EXTERNALSYM FIPS_R_UNSUPPORTED_PLATFORM}
  FIPS_R_UNSUPPORTED_PLATFORM			 = 113;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_ENGINE}
//* These flags are used to control combinations of algorithm (methods)
// * by bitwise "OR"ing. */
  {$EXTERNALSYM ENGINE_METHOD_RSA : TIdC_UINT}
  ENGINE_METHOD_RSA : TIdC_UINT = $0001;
  {$EXTERNALSYM ENGINE_METHOD_DSA   : TIdC_UINT}
  ENGINE_METHOD_DSA	: TIdC_UINT = $0002;
  {$EXTERNALSYM ENGINE_METHOD_DH : TIdC_UINT}
  ENGINE_METHOD_DH : TIdC_UINT = $0004;
  {$EXTERNALSYM ENGINE_METHOD_RAND : TIdC_UINT}
  ENGINE_METHOD_RAND : TIdC_UINT = $0008;
  {$EXTERNALSYM ENGINE_METHOD_ECDH : TIdC_UINT}
  ENGINE_METHOD_ECDH : TIdC_UINT = $0010;
  {$EXTERNALSYM ENGINE_METHOD_ECDSA   : TIdC_UINT}
  ENGINE_METHOD_ECDSA	: TIdC_UINT = $0020;
  {$EXTERNALSYM ENGINE_METHOD_CIPHERS   : TIdC_UINT}
  ENGINE_METHOD_CIPHERS	: TIdC_UINT = $0040;
  {$EXTERNALSYM ENGINE_METHOD_DIGESTS   : TIdC_UINT}
  ENGINE_METHOD_DIGESTS	: TIdC_UINT = $0080;
  {$EXTERNALSYM ENGINE_METHOD_STORE   : TIdC_UINT}
  ENGINE_METHOD_STORE	: TIdC_UINT = $0100;
  {$EXTERNALSYM ENGINE_METHOD_PKEY_METHS : TIdC_UINT}
  ENGINE_METHOD_PKEY_METHS : TIdC_UINT = $0200;
  {$EXTERNALSYM ENGINE_METHOD_PKEY_ASN1_METHS   : TIdC_UINT}
  ENGINE_METHOD_PKEY_ASN1_METHS	: TIdC_UINT = $0400;

//* Obvious all-or-nothing cases. */
  {$EXTERNALSYM ENGINE_METHOD_ALL   : TIdC_UINT}
  ENGINE_METHOD_ALL	: TIdC_UINT = $FFFF;
  {$EXTERNALSYM ENGINE_METHOD_NONE : TIdC_UINT}
  ENGINE_METHOD_NONE : TIdC_UINT = $0000;
  {$EXTERNALSYM ENGINE_TABLE_FLAG_NOINIT : TIdC_UINT}
  ENGINE_TABLE_FLAG_NOINIT : TIdC_UINT = $0001;

  {$EXTERNALSYM ENGINE_FLAGS_MANUAL_CMD_CTRL : TIdC_INT}
  ENGINE_FLAGS_MANUAL_CMD_CTRL : TIdC_INT = $0002;
  {$EXTERNALSYM ENGINE_FLAGS_BY_ID_COPY   : TIdC_INT}
  ENGINE_FLAGS_BY_ID_COPY	: TIdC_INT = $0004;
  {$EXTERNALSYM ENGINE_CMD_FLAG_NUMERIC   : TIdC_UINT}
  ENGINE_CMD_FLAG_NUMERIC	: TIdC_UINT = $0001;
  {$EXTERNALSYM ENGINE_CMD_FLAG_STRING : TIdC_UINT}
  ENGINE_CMD_FLAG_STRING : TIdC_UINT = $0002;
  {$EXTERNALSYM ENGINE_CMD_FLAG_NO_INPUT : TIdC_UINT}
  ENGINE_CMD_FLAG_NO_INPUT : TIdC_UINT = $0004;
  {$EXTERNALSYM ENGINE_CMD_FLAG_INTERNAL : TIdC_UINT}
  ENGINE_CMD_FLAG_INTERNAL : TIdC_UINT = $0008;

  {$EXTERNALSYM ENGINE_CTRL_SET_LOGSTREAM}
  ENGINE_CTRL_SET_LOGSTREAM	= 1;
  {$EXTERNALSYM ENGINE_CTRL_SET_PASSWORD_CALLBACK}
  ENGINE_CTRL_SET_PASSWORD_CALLBACK = 2;
  {$EXTERNALSYM ENGINE_CTRL_HUP}
  ENGINE_CTRL_HUP	= 3;
  //* Close and reinitialise any
	// handles/connections etc. */
  {$EXTERNALSYM ENGINE_CTRL_SET_USER_INTERFACE}
  ENGINE_CTRL_SET_USER_INTERFACE = 4; //* Alternative to callback */
  {$EXTERNALSYM _CALLBACK_DATA}
  _CALLBACK_DATA = 5;
  //* User-specific data, used
	//  when calling the password
	//  callback and the user
	//  interface */
  {$EXTERNALSYM D_CONFIGURATION}
  D_CONFIGURATION	= 6;
  //* Load a configuration, given
	//a string that represents a
	//file name or so */
  {$EXTERNALSYM D_SECTION}
  D_SECTION	= 7;
  ///* Load data from a given
	//section in the already loaded
	//configuration */

////* Returns non-zero if the supplied ENGINE has a ctrl() handler. If "not", then
// * all the remaining control commands will return failure, so it is worth
// * checking this first if the caller is trying to "discover" the engine's
// * capabilities and doesn't want errors generated unnecessarily. */
  {$EXTERNALSYM ENGINE_CTRL_HAS_CTRL_FUNCTION}
  ENGINE_CTRL_HAS_CTRL_FUNCTION	= 10;
///* Returns a positive command number for the first command supported by the
// * engine. Returns zero if no ctrl commands are supported. */
  {$EXTERNALSYM ENGINE_CTRL_GET_FIRST_CMD_TYPE}
  ENGINE_CTRL_GET_FIRST_CMD_TYPE = 11;
///* The 'long' argument specifies a command implemented by the engine, and the
// * return value is the next command supported, or zero if there are no more. */
  {$EXTERNALSYM ENGINE_CTRL_GET_NEXT_CMD_TYPE}
  ENGINE_CTRL_GET_NEXT_CMD_TYPE = 12;
///* The 'void*' argument is a command name (cast from 'const char *'), and the
// * return value is the command that corresponds to it. */
  {$EXTERNALSYM ENGINE_CTRL_GET_CMD_FROM_NAME}
  ENGINE_CTRL_GET_CMD_FROM_NAME = 13;
///* The next two allow a command to be converted into its corresponding string
// * form. In each case, the 'long' argument supplies the command. In the NAME_LEN
// * case, the return value is the length of the command name (not counting a
// * trailing EOL). In the NAME case, the 'void*' argument must be a string buffer
// * large enough, and it will be populated with the name of the command (WITH a
// * trailing EOL). */
  {$EXTERNALSYM ENGINE_CTRL_GET_NAME_LEN_FROM_CMD}
  ENGINE_CTRL_GET_NAME_LEN_FROM_CMD = 14;
  {$EXTERNALSYM ENGINE_CTRL_GET_NAME_FROM_CMD}
  ENGINE_CTRL_GET_NAME_FROM_CMD	= 15;
//* The next two are similar but give a "short description" of a command. */
  {$EXTERNALSYM ENGINE_CTRL_GET_DESC_LEN_FROM_CMD}
  ENGINE_CTRL_GET_DESC_LEN_FROM_CMD	= 16;
  {$EXTERNALSYM ENGINE_CTRL_GET_DESC_FROM_CMD}
  ENGINE_CTRL_GET_DESC_FROM_CMD = 17;
///* With this command, the return value is the OR'd combination of
// * ENGINE_CMD_FLAG_*** values that indicate what kind of input a given
// * engine-specific ctrl command expects. */
  {$EXTERNALSYM ENGINE_CTRL_GET_CMD_FLAGS}
  ENGINE_CTRL_GET_CMD_FLAGS	= 18;

///* ENGINE implementations should start the numbering of their own control
// * commands from this value. (ie. ENGINE_CMD_BASE, ENGINE_CMD_BASE + 1, etc). */
  {$EXTERNALSYM ENGINE_CMD_BASE}
  ENGINE_CMD_BASE = 200;

///* NB: These 2 nCipher "chil" control commands are deprecated, and their
// * functionality is now available through ENGINE-specific control commands
// * (exposed through the above-mentioned 'CMD'-handling). Code using these 2
// * commands should be migrated to the more general command handling before these
// * are removed. */

//* Flags specific to the nCipher "chil" engine */
  {$EXTERNALSYM ENGINE_CTRL_CHIL_SET_FORKCHECK}
  ENGINE_CTRL_CHIL_SET_FORKCHECK = 100;
///* Depending on the value of the (long)i argument, this sets or
// * unsets the SimpleForkCheck flag in the CHIL API to enable or
// * disable checking and workarounds for applications that fork().
// */
  {$EXTERNALSYM ENGINE_CTRL_CHIL_NO_LOCKING}
  ENGINE_CTRL_CHIL_NO_LOCKING	=	101;
///* This prevents the initialisation function from providing mutex
// * callbacks to the nCipher library. */

///* Binary/behaviour compatibility levels */
  {$EXTERNALSYM OSSL_DYNAMIC_VERSION   : TIdC_UINT}
  OSSL_DYNAMIC_VERSION	: TIdC_UINT = $00020000;
///* Binary versions older than this are too old for us (whether we're a loader or
// * a loadee) */
  {$EXTERNALSYM OSSL_DYNAMIC_OLDEST   : TIdC_UINT}
  OSSL_DYNAMIC_OLDEST	: TIdC_UINT = $00020000;
//* Function codes. */
  {$EXTERNALSYM ENGINE_F_DYNAMIC_CTRL}
  ENGINE_F_DYNAMIC_CTRL	= 180;
  {$EXTERNALSYM ENGINE_F_DYNAMIC_GET_DATA_CTX}
  ENGINE_F_DYNAMIC_GET_DATA_CTX = 181;
  {$EXTERNALSYM ENGINE_F_DYNAMIC_LOAD}
  ENGINE_F_DYNAMIC_LOAD = 182;
  {$EXTERNALSYM ENGINE_F_DYNAMIC_SET_DATA_CTX}
  ENGINE_F_DYNAMIC_SET_DATA_CTX	= 183;
  {$EXTERNALSYM ENGINE_F_ENGINE_ADD}
  ENGINE_F_ENGINE_ADD	= 105;
  {$EXTERNALSYM ENGINE_F_ENGINE_BY_ID}
  ENGINE_F_ENGINE_BY_ID	= 106;
  {$EXTERNALSYM ENGINE_F_ENGINE_CMD_IS_EXECUTABLE}
  ENGINE_F_ENGINE_CMD_IS_EXECUTABLE	= 170;
  {$EXTERNALSYM ENGINE_F_ENGINE_CTRL}
  ENGINE_F_ENGINE_CTRL = 142;
  {$EXTERNALSYM ENGINE_F_ENGINE_CTRL_CMD}
  ENGINE_F_ENGINE_CTRL_CMD = 178;
  {$EXTERNALSYM ENGINE_F_ENGINE_CTRL_CMD_STRING}
  ENGINE_F_ENGINE_CTRL_CMD_STRING	= 171;
  {$EXTERNALSYM ENGINE_F_ENGINE_FINISH}
  ENGINE_F_ENGINE_FINISH = 107;
  {$EXTERNALSYM ENGINE_F_ENGINE_FREE_UTIL}
  ENGINE_F_ENGINE_FREE_UTIL	= 108;
  {$EXTERNALSYM ENGINE_F_ENGINE_GET_CIPHER}
  ENGINE_F_ENGINE_GET_CIPHER = 185;
  {$EXTERNALSYM ENGINE_F_ENGINE_GET_DEFAULT_TYPE}
  ENGINE_F_ENGINE_GET_DEFAULT_TYPE = 177;
  {$EXTERNALSYM ENGINE_F_ENGINE_GET_DIGEST}
  ENGINE_F_ENGINE_GET_DIGEST = 186;
  {$EXTERNALSYM ENGINE_F_ENGINE_GET_NEXT}
  ENGINE_F_ENGINE_GET_NEXT = 115;
  {$EXTERNALSYM ENGINE_F_ENGINE_GET_PKEY_ASN1_METH}
  ENGINE_F_ENGINE_GET_PKEY_ASN1_METH = 193;
  {$EXTERNALSYM ENGINE_F_ENGINE_GET_PKEY_METH}
  ENGINE_F_ENGINE_GET_PKEY_METH	= 192;
  {$EXTERNALSYM ENGINE_F_ENGINE_GET_PREV}
  ENGINE_F_ENGINE_GET_PREV = 116;
  {$EXTERNALSYM ENGINE_F_ENGINE_INIT}
  ENGINE_F_ENGINE_INIT = 119;
  {$EXTERNALSYM ENGINE_F_ENGINE_LIST_ADD}
  ENGINE_F_ENGINE_LIST_ADD = 120;
  {$EXTERNALSYM ENGINE_F_ENGINE_LIST_REMOVE}
  ENGINE_F_ENGINE_LIST_REMOVE	= 121;
  {$EXTERNALSYM ENGINE_F_ENGINE_LOAD_PRIVATE_KEY}
  ENGINE_F_ENGINE_LOAD_PRIVATE_KEY = 150;
  {$EXTERNALSYM ENGINE_F_ENGINE_LOAD_PUBLIC_KEY}
  ENGINE_F_ENGINE_LOAD_PUBLIC_KEY	= 151;
 //was ENGINE_F_ENGINE_LOAD_SSL_CLIENT_CERT = 192;
  {$EXTERNALSYM ENGINE_F_ENGINE_LOAD_SSL_CLIENT_CERT}
  ENGINE_F_ENGINE_LOAD_SSL_CLIENT_CERT = 194;

  {$EXTERNALSYM ENGINE_F_ENGINE_NEW}
  ENGINE_F_ENGINE_NEW	= 122;
  {$EXTERNALSYM ENGINE_F_ENGINE_REMOVE}
  ENGINE_F_ENGINE_REMOVE = 123;
  {$EXTERNALSYM ENGINE_F_ENGINE_SET_DEFAULT_STRING}
  ENGINE_F_ENGINE_SET_DEFAULT_STRING = 189;
  {$EXTERNALSYM ENGINE_F_ENGINE_SET_DEFAULT_TYPE}
  ENGINE_F_ENGINE_SET_DEFAULT_TYPE = 126;
  {$EXTERNALSYM ENGINE_F_ENGINE_SET_ID}
  ENGINE_F_ENGINE_SET_ID = 129;
  {$EXTERNALSYM ENGINE_F_ENGINE_SET_NAME}
  ENGINE_F_ENGINE_SET_NAME = 130;
  {$EXTERNALSYM ENGINE_F_ENGINE_TABLE_REGISTER}
  ENGINE_F_ENGINE_TABLE_REGISTER = 184;
  {$EXTERNALSYM ENGINE_F_ENGINE_UNLOAD_KEY}
  ENGINE_F_ENGINE_UNLOAD_KEY = 152;
  {$EXTERNALSYM ENGINE_F_ENGINE_UNLOCKED_FINISH}
  ENGINE_F_ENGINE_UNLOCKED_FINISH	= 191;
  {$EXTERNALSYM ENGINE_F_ENGINE_UP_REF}
  ENGINE_F_ENGINE_UP_REF = 190;
  {$EXTERNALSYM ENGINE_F_INT_CTRL_HELPER}
  ENGINE_F_INT_CTRL_HELPER = 172;
  {$EXTERNALSYM ENGINE_F_INT_ENGINE_CONFIGURE}
  ENGINE_F_INT_ENGINE_CONFIGURE	= 188;
  {$EXTERNALSYM ENGINE_F_INT_ENGINE_MODULE_INIT}
  ENGINE_F_INT_ENGINE_MODULE_INIT	= 187;
  {$EXTERNALSYM ENGINE_F_LOG_MESSAGE}
  ENGINE_F_LOG_MESSAGE = 141;
//* Reason codes. */
  {$EXTERNALSYM ENGINE_R_ALREADY_LOADED}
  ENGINE_R_ALREADY_LOADED	= 100;
  {$EXTERNALSYM ENGINE_R_ARGUMENT_IS_NOT_A_NUMBER}
  ENGINE_R_ARGUMENT_IS_NOT_A_NUMBER	= 133;
  {$EXTERNALSYM ENGINE_R_CMD_NOT_EXECUTABLE}
  ENGINE_R_CMD_NOT_EXECUTABLE	= 134;
  {$EXTERNALSYM ENGINE_R_COMMAND_TAKES_INPUT}
  ENGINE_R_COMMAND_TAKES_INPUT = 135;
  {$EXTERNALSYM ENGINE_R_COMMAND_TAKES_NO_INPUT}
  ENGINE_R_COMMAND_TAKES_NO_INPUT	= 136;
  {$EXTERNALSYM ENGINE_R_CONFLICTING_ENGINE_ID}
  ENGINE_R_CONFLICTING_ENGINE_ID = 103;
  {$EXTERNALSYM ENGINE_R_CTRL_COMMAND_NOT_IMPLEMENTED}
  ENGINE_R_CTRL_COMMAND_NOT_IMPLEMENTED = 119;
  {$EXTERNALSYM ENGINE_R_DH_NOT_IMPLEMENTED}
  ENGINE_R_DH_NOT_IMPLEMENTED	= 139;
  {$EXTERNALSYM ENGINE_R_DSA_NOT_IMPLEMENTED}
  ENGINE_R_DSA_NOT_IMPLEMENTED = 140;
  {$EXTERNALSYM ENGINE_R_DSO_FAILURE}
  ENGINE_R_DSO_FAILURE = 104;
  {$EXTERNALSYM ENGINE_R_DSO_NOT_FOUND}
  ENGINE_R_DSO_NOT_FOUND = 132;
  {$EXTERNALSYM ENGINE_R_ENGINES_SECTION_ERROR}
  ENGINE_R_ENGINES_SECTION_ERROR = 148;
//was:  ENGINE_R_ENGINE_CONFIGURATION_ERROR = 101;
  {$EXTERNALSYM ENGINE_R_ENGINE_CONFIGURATION_ERROR}
  ENGINE_R_ENGINE_CONFIGURATION_ERROR	= 102;

  {$EXTERNALSYM ENGINE_R_ENGINE_IS_NOT_IN_LIST}
  ENGINE_R_ENGINE_IS_NOT_IN_LIST = 105;
  {$EXTERNALSYM ENGINE_R_ENGINE_SECTION_ERROR}
  ENGINE_R_ENGINE_SECTION_ERROR	= 149;
  {$EXTERNALSYM ENGINE_R_FAILED_LOADING_PRIVATE_KEY}
  ENGINE_R_FAILED_LOADING_PRIVATE_KEY	= 128;
  {$EXTERNALSYM ENGINE_R_FAILED_LOADING_PUBLIC_KEY}
  ENGINE_R_FAILED_LOADING_PUBLIC_KEY = 129;
  {$EXTERNALSYM ENGINE_R_FINISH_FAILED}
  ENGINE_R_FINISH_FAILED = 106;
  {$EXTERNALSYM ENGINE_R_GET_HANDLE_FAILED}
  ENGINE_R_GET_HANDLE_FAILED = 107;
  {$EXTERNALSYM ENGINE_R_ID_OR_NAME_MISSING}
  ENGINE_R_ID_OR_NAME_MISSING	= 108;
  {$EXTERNALSYM ENGINE_R_INIT_FAILED}
  ENGINE_R_INIT_FAILED = 109;
  {$EXTERNALSYM ENGINE_R_INTERNAL_LIST_ERROR}
  ENGINE_R_INTERNAL_LIST_ERROR = 110;
  {$EXTERNALSYM ENGINE_R_INVALID_ARGUMENT}
  ENGINE_R_INVALID_ARGUMENT = 143;
  {$EXTERNALSYM ENGINE_R_INVALID_CMD_NAME}
  ENGINE_R_INVALID_CMD_NAME	= 137;
  {$EXTERNALSYM ENGINE_R_INVALID_CMD_NUMBER}
  ENGINE_R_INVALID_CMD_NUMBER	= 138;
  {$EXTERNALSYM ENGINE_R_INVALID_INIT_VALUE}
  ENGINE_R_INVALID_INIT_VALUE	= 151;
  {$EXTERNALSYM ENGINE_R_INVALID_STRING}
  ENGINE_R_INVALID_STRING	= 150;
  {$EXTERNALSYM ENGINE_R_NOT_INITIALISED}
  ENGINE_R_NOT_INITIALISED = 117;
  {$EXTERNALSYM ENGINE_R_NOT_LOADED}
  ENGINE_R_NOT_LOADED	= 112;
  {$EXTERNALSYM ENGINE_R_NO_CONTROL_FUNCTION}
  ENGINE_R_NO_CONTROL_FUNCTION = 120;
  {$EXTERNALSYM ENGINE_R_NO_INDEX}
  ENGINE_R_NO_INDEX	= 144;
  {$EXTERNALSYM ENGINE_R_NO_LOAD_FUNCTION}
  ENGINE_R_NO_LOAD_FUNCTION	= 125;
  {$EXTERNALSYM ENGINE_R_NO_REFERENCE}
  ENGINE_R_NO_REFERENCE	= 130;
  {$EXTERNALSYM ENGINE_R_NO_SUCH_ENGINE}
  ENGINE_R_NO_SUCH_ENGINE	= 116;
  {$EXTERNALSYM ENGINE_R_NO_UNLOAD_FUNCTION}
  ENGINE_R_NO_UNLOAD_FUNCTION	= 126;
  {$EXTERNALSYM ENGINE_R_PROVIDE_PARAMETERS}
  ENGINE_R_PROVIDE_PARAMETERS	= 113;
  {$EXTERNALSYM ENGINE_R_RSA_NOT_IMPLEMENTED}
  ENGINE_R_RSA_NOT_IMPLEMENTED = 141;
  {$EXTERNALSYM ENGINE_R_UNIMPLEMENTED_CIPHER}
  ENGINE_R_UNIMPLEMENTED_CIPHER	= 146;
  {$EXTERNALSYM ENGINE_R_UNIMPLEMENTED_DIGEST}
  ENGINE_R_UNIMPLEMENTED_DIGEST	= 147;
  {$EXTERNALSYM ENGINE_R_UNIMPLEMENTED_PUBLIC_KEY_METHOD}
  ENGINE_R_UNIMPLEMENTED_PUBLIC_KEY_METHOD = 101;
  {$EXTERNALSYM ENGINE_R_VERSION_INCOMPATIBILITY}
  ENGINE_R_VERSION_INCOMPATIBILITY = 145;
{$ENDIF}
  {$EXTERNALSYM MSS_EXIT_FAILURE}
  MSS_EXIT_FAILURE = 1;
  {$EXTERNALSYM MSS_EXIT_SUCCESS}
  MSS_EXIT_SUCCESS = 0;
  {$EXTERNALSYM FILENAME_MAX}
  FILENAME_MAX = 1024;
  {$EXTERNALSYM FOPEN_MAX}
  FOPEN_MAX = 20;
  {$IFNDEF OPENSSL_NO_IDEA}
  {$EXTERNALSYM IDEA_BLOCK}
  IDEA_BLOCK = 8;
  {$EXTERNALSYM IDEA_DECRYPT}
  IDEA_DECRYPT = 0;
  {$EXTERNALSYM IDEA_ENCRYPT}
  IDEA_ENCRYPT = 1;
  {$EXTERNALSYM IDEA_KEY_LENGTH}
  IDEA_KEY_LENGTH = 16;
  {$ENDIF}
  {$EXTERNALSYM IS_SEQUENCE}
  IS_SEQUENCE = 0;
  {$EXTERNALSYM IS_SET}
  IS_SET = 1;
  {$EXTERNALSYM KRBDES_DECRYPT}
  KRBDES_DECRYPT = DES_DECRYPT;
  {$EXTERNALSYM KRBDES_ENCRYPT}
  KRBDES_ENCRYPT = DES_ENCRYPT;
  {$EXTERNALSYM LH_LOAD_MULT}
  LH_LOAD_MULT = 256;
  {$EXTERNALSYM L_ctermid}
  L_ctermid = 16;
  {$EXTERNALSYM L_cuserid}
  L_cuserid = 9;
  {$EXTERNALSYM L_tmpnam}
  L_tmpnam = 1024;
  //chamellia.h
  {$IFNDEF OPENSSL_NO_CAMELLIA}
  {$EXTERNALSYM CAMELLIA_ENCRYPT}
  CAMELLIA_ENCRYPT = 1;
  {$EXTERNALSYM CAMELLIA_DECRYPT}
  CAMELLIA_DECRYPT	= 0;
//* This should be a hidden type, but EVP requires that the size be known */

  {$EXTERNALSYM CAMELLIA_BLOCK_SIZE}
  CAMELLIA_BLOCK_SIZE = 16;
   {$EXTERNALSYM CAMELLIA_TABLE_BYTE_LEN}
  CAMELLIA_TABLE_BYTE_LEN = 272;
   {$EXTERNALSYM CAMELLIA_TABLE_WORD_LEN}
  CAMELLIA_TABLE_WORD_LEN = (CAMELLIA_TABLE_BYTE_LEN / 4);
  {$ENDIF}
  //whrlpool.h
  {$EXTERNALSYM WHIRLPOOL_DIGEST_LENGTH}
  WHIRLPOOL_DIGEST_LENGTH = (512 div 8);
  {$EXTERNALSYM WHIRLPOOL_BBLOCK}
  WHIRLPOOL_BBLOCK	= 512;
  {$EXTERNALSYM WHIRLPOOL_COUNTER}
  WHIRLPOOL_COUNTER	= (256 div 8);
  {$IFNDEF OPENSSL_NO_MD2}
  {$EXTERNALSYM MD2_BLOCK}
  MD2_BLOCK = 16;
  {$EXTERNALSYM MD2_DIGEST_LENGTH}
  MD2_DIGEST_LENGTH = 16;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MD4}
  {$EXTERNALSYM MD4_CBLOCK}
  MD4_CBLOCK  = 64;
  {$EXTERNALSYM MD4_LBLOCK}
  MD4_LBLOCK = (MD4_CBLOCK div 4);
  {$EXTERNALSYM MD4_DIGEST_LENGTH}
  MD4_DIGEST_LENGTH = 16;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MD5}
  {$EXTERNALSYM MD5_CBLOCK}
  MD5_CBLOCK = 64;
  {$EXTERNALSYM MD5_LBLOCK}
  MD5_LBLOCK = 16; //(MD5_CBLOCK/4);
  {$EXTERNALSYM MD5_DIGEST_LENGTH}
  MD5_DIGEST_LENGTH = 16;
  {$ENDIF}
   {$IFNDEF OPENSSL_NO_MDC2}
  {$EXTERNALSYM OPENSSL_MDC2_BLOCK}
  OPENSSL_MDC2_BLOCK = 8;
  {$EXTERNALSYM OPENSSL_MDC2_DIGEST_LENGTH}
  OPENSSL_MDC2_DIGEST_LENGTH = 16;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_SHA}
  {$EXTERNALSYM SHA_LBLOCK}
  SHA_LBLOCK = 16;
  {$EXTERNALSYM SHA_CBLOCK}
  SHA_CBLOCK = 64; //(SHA_LBLOCK * 4);
  {$EXTERNALSYM SHA_DIGEST_LENGTH}
  SHA_DIGEST_LENGTH = 20;
  {$EXTERNALSYM SHA_LAST_BLOCK}
  SHA_LAST_BLOCK = ( SHA_CBLOCK -8);
  {$EXTERNALSYM SHA256_CBLOCK}
  SHA256_CBLOCK = ( SHA_LBLOCK * 4);
  {$EXTERNALSYM SHA224_DIGEST_LENGTH}
  SHA224_DIGEST_LENGTH = 28;
  {$EXTERNALSYM SHA256_DIGEST_LENGTH}
  SHA256_DIGEST_LENGTH = 32;
  {$EXTERNALSYM SHA384_DIGEST_LENGTH}
  SHA384_DIGEST_LENGTH = 48;
  {$EXTERNALSYM SHA512_DIGEST_LENGTH}
  SHA512_DIGEST_LENGTH = 64;
    {$IFNDEF OPENSSL_NO_SHA512}
  {$EXTERNALSYM SHA512_CBLOCK}
  SHA512_CBLOCK = (SHA_LBLOCK*8);
    {$ENDIF}
  {$ENDIF}
  {$EXTERNALSYM LN_SMIMECapabilities}
  LN_SMIMECapabilities = 'S/MIME Capabilities';  {Do not localize}
  {$EXTERNALSYM LN_X500}
  LN_X500 = 'X500';  {Do not localize}
  {$EXTERNALSYM LN_X509}
  LN_X509 = 'X509';  {Do not localize}
  {$EXTERNALSYM LN_algorithm}
  LN_algorithm = 'algorithm';  {Do not localize}
  {$EXTERNALSYM LN_authority_key_identifier}
  LN_authority_key_identifier = 'X509v3 Authority Key Identifier';  {Do not localize}
  {$EXTERNALSYM LN_basic_constraints}
  LN_basic_constraints = 'X509v3 Basic Constraints';  {Do not localize}
  {$EXTERNALSYM LN_bf_cbc}
  LN_bf_cbc = 'bf-cbc';  {Do not localize}
  {$EXTERNALSYM LN_bf_cfb64}
  LN_bf_cfb64 = 'bf-cfb';  {Do not localize}
  {$EXTERNALSYM LN_bf_ecb}
  LN_bf_ecb = 'bf-ecb';  {Do not localize}
  {$EXTERNALSYM LN_bf_ofb64}
  LN_bf_ofb64 = 'bf-ofb';  {Do not localize}
  {$EXTERNALSYM LN_cast5_cbc}
  LN_cast5_cbc = 'cast5-cbc';  {Do not localize}
  {$EXTERNALSYM LN_cast5_cfb64}
  LN_cast5_cfb64 = 'cast5-cfb';  {Do not localize}
  {$EXTERNALSYM LN_cast5_ecb}
  LN_cast5_ecb = 'cast5-ecb';  {Do not localize}
  {$EXTERNALSYM LN_cast5_ofb64}
  LN_cast5_ofb64 = 'cast5-ofb';  {Do not localize}
  {$EXTERNALSYM LN_certBag}
  LN_certBag = 'certBag';  {Do not localize}
  {$EXTERNALSYM LN_certificate_policies}
  LN_certificate_policies = 'X509v3 Certificate Policies';  {Do not localize}
  {$EXTERNALSYM LN_client_auth}
  LN_client_auth = 'TLS Web Client Authentication';  {Do not localize}
  {$EXTERNALSYM LN_code_sign}
  LN_code_sign = 'Code Signing';  {Do not localize}
  {$EXTERNALSYM LN_commonName}
  LN_commonName = 'commonName';  {Do not localize}
  {$EXTERNALSYM LN_countryName}
  LN_countryName = 'countryName';  {Do not localize}
  {$EXTERNALSYM LN_crlBag}
  LN_crlBag = 'crlBag';  {Do not localize}
  {$EXTERNALSYM LN_crl_distribution_points}
  LN_crl_distribution_points = 'X509v3 CRL Distribution Points';  {Do not localize}
  {$EXTERNALSYM LN_crl_number}
  LN_crl_number = 'X509v3 CRL Number';  {Do not localize}
  {$EXTERNALSYM LN_crl_reason}
  LN_crl_reason = 'CRL Reason Code';  {Do not localize}
  {$EXTERNALSYM LN_delta_crl}
  LN_delta_crl = 'X509v3 Delta CRL Indicator';  {Do not localize}
  {$EXTERNALSYM LN_des_cbc}
  LN_des_cbc = 'des-cbc';  {Do not localize}
  {$EXTERNALSYM LN_des_cfb64}
  LN_des_cfb64 = 'des-cfb';  {Do not localize}
  {$EXTERNALSYM LN_des_ecb}
  LN_des_ecb = 'des-ecb';  {Do not localize}
  {$EXTERNALSYM LN_des_ede}
  LN_des_ede = 'des-ede';  {Do not localize}
  {$EXTERNALSYM LN_des_ede3}
  LN_des_ede3 = 'des-ede3';  {Do not localize}
  {$EXTERNALSYM LN_des_ede3_cbc}
  LN_des_ede3_cbc = 'des-ede3-cbc';  {Do not localize}
  {$EXTERNALSYM LN_des_ede3_cfb64}
  LN_des_ede3_cfb64 = 'des-ede3-cfb';  {Do not localize}
  {$EXTERNALSYM LN_des_ede3_ofb64}
  LN_des_ede3_ofb64 = 'des-ede3-ofb';  {Do not localize}
  {$EXTERNALSYM LN_des_ede_cbc}
  LN_des_ede_cbc = 'des-ede-cbc';  {Do not localize}
  {$EXTERNALSYM LN_des_ede_cfb64}
  LN_des_ede_cfb64 = 'des-ede-cfb';  {Do not localize}
  {$EXTERNALSYM LN_des_ede_ofb64}
  LN_des_ede_ofb64 = 'des-ede-ofb';  {Do not localize}
  {$EXTERNALSYM LN_des_ofb64}
  LN_des_ofb64 = 'des-ofb';  {Do not localize}
  {$EXTERNALSYM LN_description}
  LN_description = 'description';  {Do not localize}
  {$EXTERNALSYM LN_desx_cbc}
  LN_desx_cbc = 'desx-cbc';  {Do not localize}
  {$EXTERNALSYM LN_dhKeyAgreement}
  LN_dhKeyAgreement = 'dhKeyAgreement';  {Do not localize}
  {$EXTERNALSYM LN_dsa}
  LN_dsa = 'dsaEncryption';  {Do not localize}
  {$EXTERNALSYM LN_dsaWithSHA}
  LN_dsaWithSHA = 'dsaWithSHA';  {Do not localize}
  {$EXTERNALSYM LN_dsaWithSHA1}
  LN_dsaWithSHA1 = 'dsaWithSHA1';  {Do not localize}
  {$EXTERNALSYM LN_dsaWithSHA1_2}
  LN_dsaWithSHA1_2 = 'dsaWithSHA1-old';  {Do not localize}
  {$EXTERNALSYM LN_dsa_2}
  LN_dsa_2 = 'dsaEncryption-old';  {Do not localize}
  {$EXTERNALSYM LN_email_protect}
  LN_email_protect = 'E-mail Protection';  {Do not localize}
  {$EXTERNALSYM LN_ext_key_usage}
  LN_ext_key_usage = 'X509v3 Extended Key Usage';  {Do not localize}
  {$EXTERNALSYM LN_friendlyName}
  LN_friendlyName = 'friendlyName';  {Do not localize}
  {$EXTERNALSYM LN_givenName}
  LN_givenName = 'givenName';  {Do not localize}
  {$EXTERNALSYM LN_hmacWithSHA1}
  LN_hmacWithSHA1 = 'hmacWithSHA1';  {Do not localize}
  {$EXTERNALSYM LN_id_pbkdf2}
  LN_id_pbkdf2 = 'PBKDF2';  {Do not localize}
  {$EXTERNALSYM LN_id_qt_cps}
  LN_id_qt_cps = 'Policy Qualifier CPS';  {Do not localize}
  {$EXTERNALSYM LN_id_qt_unotice}
  LN_id_qt_unotice = 'Policy Qualifier User Notice';  {Do not localize}
  {$EXTERNALSYM LN_idea_cbc}
  LN_idea_cbc = 'idea-cbc';  {Do not localize}
  {$EXTERNALSYM LN_idea_cfb64}
  LN_idea_cfb64 = 'idea-cfb';  {Do not localize}
  {$EXTERNALSYM LN_idea_ecb}
  LN_idea_ecb = 'idea-ecb';  {Do not localize}
  {$EXTERNALSYM LN_idea_ofb64}
  LN_idea_ofb64 = 'idea-ofb';  {Do not localize}
  {$EXTERNALSYM LN_initials}
  LN_initials = 'initials';  {Do not localize}
  {$EXTERNALSYM LN_invalidity_date}
  LN_invalidity_date = 'Invalidity Date';  {Do not localize}
  {$EXTERNALSYM LN_issuer_alt_name}
  LN_issuer_alt_name = 'X509v3 Issuer Alternative Name';  {Do not localize}
  {$EXTERNALSYM LN_keyBag}
  LN_keyBag = 'keyBag';  {Do not localize}
  {$EXTERNALSYM LN_key_usage}
  LN_key_usage = 'X509v3 Key Usage';  {Do not localize}
  {$EXTERNALSYM LN_localKeyID}
  LN_localKeyID = 'localKeyID';  {Do not localize}
  {$EXTERNALSYM LN_localityName}
  LN_localityName = 'localityName';  {Do not localize}
  {$EXTERNALSYM LN_md2}
  LN_md2 = 'md2';  {Do not localize}
  {$EXTERNALSYM LN_md2WithRSAEncryption}
  LN_md2WithRSAEncryption = 'md2WithRSAEncryption';  {Do not localize}
  {$EXTERNALSYM LN_md4}
  LN_md4 = 'md4'; {Do not localize}
  {$EXTERNALSYM LN_md5}
  LN_md5 = 'md5';  {Do not localize}
  {$EXTERNALSYM LN_md5WithRSA}
  LN_md5WithRSA = 'md5WithRSA';  {Do not localize}
  {$EXTERNALSYM LN_md5WithRSAEncryption}
  LN_md5WithRSAEncryption = 'md5WithRSAEncryption';  {Do not localize}
  {$EXTERNALSYM LN_md5_sha1}
  LN_md5_sha1 = 'md5-sha1';  {Do not localize}
  {$EXTERNALSYM LN_mdc2}
  LN_mdc2 = 'mdc2';  {Do not localize}
  {$EXTERNALSYM LN_mdc2WithRSA}
  LN_mdc2WithRSA = 'mdc2withRSA';  {Do not localize}
  {$EXTERNALSYM LN_ms_code_com}
  LN_ms_code_com = 'Microsoft Commercial Code Signing';  {Do not localize}
  {$EXTERNALSYM LN_ms_code_ind}
  LN_ms_code_ind = 'Microsoft Individual Code Signing';  {Do not localize}
  {$EXTERNALSYM LN_ms_ctl_sign}
  LN_ms_ctl_sign = 'Microsoft Trust List Signing';  {Do not localize}
  {$EXTERNALSYM LN_ms_efs}
  LN_ms_efs = 'Microsoft Encrypted File System';  {Do not localize}
  {$EXTERNALSYM LN_ms_sgc}
  LN_ms_sgc = 'Microsoft Server Gated Crypto';  {Do not localize}
  {$EXTERNALSYM LN_netscape}
  LN_netscape = 'Netscape Communications Corp.';  {Do not localize}
  {$EXTERNALSYM LN_netscape_base_url}
  LN_netscape_base_url = 'Netscape Base Url';  {Do not localize}
  {$EXTERNALSYM LN_netscape_ca_policy_url}
  LN_netscape_ca_policy_url = 'Netscape CA Policy Url';  {Do not localize}
  {$EXTERNALSYM LN_netscape_ca_revocation_url}
  LN_netscape_ca_revocation_url = 'Netscape CA Revocation Url';  {Do not localize}
  {$EXTERNALSYM LN_netscape_cert_extension}
  LN_netscape_cert_extension = 'Netscape Certificate Extension';  {Do not localize}
  {$EXTERNALSYM LN_netscape_cert_sequence}
  LN_netscape_cert_sequence = 'Netscape Certificate Sequence';  {Do not localize}
  {$EXTERNALSYM LN_netscape_cert_type}
  LN_netscape_cert_type = 'Netscape Cert Type';  {Do not localize}
  {$EXTERNALSYM LN_netscape_comment}
  LN_netscape_comment = 'Netscape Comment';  {Do not localize}
  {$EXTERNALSYM LN_netscape_data_type}
  LN_netscape_data_type = 'Netscape Data Type';  {Do not localize}
  {$EXTERNALSYM LN_netscape_renewal_url}
  LN_netscape_renewal_url = 'Netscape Renewal Url';  {Do not localize}
  {$EXTERNALSYM LN_netscape_revocation_url}
  LN_netscape_revocation_url = 'Netscape Revocation Url';  {Do not localize}
  {$EXTERNALSYM LN_netscape_ssl_server_name}
  LN_netscape_ssl_server_name = 'Netscape SSL Server Name';  {Do not localize}
  {$EXTERNALSYM LN_ns_sgc}
  LN_ns_sgc = 'Netscape Server Gated Crypto';  {Do not localize}
  {$EXTERNALSYM LN_organizationName}
  LN_organizationName = 'organizationName';  {Do not localize}
  {$EXTERNALSYM LN_organizationalUnitName}
  LN_organizationalUnitName = 'organizationalUnitName';  {Do not localize}
  {$EXTERNALSYM LN_pbeWithMD2AndDES_CBC}
  LN_pbeWithMD2AndDES_CBC = 'pbeWithMD2AndDES-CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbeWithMD2AndRC2_CBC}
  LN_pbeWithMD2AndRC2_CBC = 'pbeWithMD2AndRC2-CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbeWithMD5AndCast5_CBC}
  LN_pbeWithMD5AndCast5_CBC = 'pbeWithMD5AndCast5CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbeWithMD5AndDES_CBC}
  LN_pbeWithMD5AndDES_CBC = 'pbeWithMD5AndDES-CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbeWithMD5AndRC2_CBC}
  LN_pbeWithMD5AndRC2_CBC = 'pbeWithMD5AndRC2-CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbeWithSHA1AndDES_CBC}
  LN_pbeWithSHA1AndDES_CBC = 'pbeWithSHA1AndDES-CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbeWithSHA1AndRC2_CBC}
  LN_pbeWithSHA1AndRC2_CBC = 'pbeWithSHA1AndRC2-CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbe_WithSHA1And128BitRC2_CBC}
  LN_pbe_WithSHA1And128BitRC2_CBC = 'pbeWithSHA1And128BitRC2-CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbe_WithSHA1And128BitRC4}
  LN_pbe_WithSHA1And128BitRC4 = 'pbeWithSHA1And128BitRC4';  {Do not localize}
  {$EXTERNALSYM LN_pbe_WithSHA1And2_Key_TripleDES_CBC}
  LN_pbe_WithSHA1And2_Key_TripleDES_CBC = 'pbeWithSHA1And2-KeyTripleDES-CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbe_WithSHA1And3_Key_TripleDES_CBC}
  LN_pbe_WithSHA1And3_Key_TripleDES_CBC = 'pbeWithSHA1And3-KeyTripleDES-CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbe_WithSHA1And40BitRC2_CBC}
  LN_pbe_WithSHA1And40BitRC2_CBC = 'pbeWithSHA1And40BitRC2-CBC';  {Do not localize}
  {$EXTERNALSYM LN_pbe_WithSHA1And40BitRC4}
  LN_pbe_WithSHA1And40BitRC4 = 'pbeWithSHA1And40BitRC4';  {Do not localize}
  {$EXTERNALSYM LN_pbes2}
  LN_pbes2 = 'PBES2';  {Do not localize}
  {$EXTERNALSYM LN_pbmac1}
  LN_pbmac1 = 'PBMAC1';  {Do not localize}
  {$EXTERNALSYM LN_pkcs}
  LN_pkcs = 'pkcs';  {Do not localize}
  {$EXTERNALSYM LN_pkcs3}
  LN_pkcs3 = 'pkcs3';  {Do not localize}
  {$EXTERNALSYM LN_pkcs7}
  LN_pkcs7 = 'pkcs7';  {Do not localize}
  {$EXTERNALSYM LN_pkcs7_data}
  LN_pkcs7_data = 'pkcs7-data';  {Do not localize}
  {$EXTERNALSYM LN_pkcs7_digest}
  LN_pkcs7_digest = 'pkcs7-digestData';  {Do not localize}
  {$EXTERNALSYM LN_pkcs7_encrypted}
  LN_pkcs7_encrypted = 'pkcs7-encryptedData';  {Do not localize}
  {$EXTERNALSYM LN_pkcs7_enveloped}
  LN_pkcs7_enveloped = 'pkcs7-envelopedData';  {Do not localize}
  {$EXTERNALSYM LN_pkcs7_signed}
  LN_pkcs7_signed = 'pkcs7-signedData';  {Do not localize}
  {$EXTERNALSYM LN_pkcs7_signedAndEnveloped}
  LN_pkcs7_signedAndEnveloped = 'pkcs7-signedAndEnvelopedData';  {Do not localize}
  {$EXTERNALSYM LN_pkcs8ShroudedKeyBag}
  LN_pkcs8ShroudedKeyBag = 'pkcs8ShroudedKeyBag';  {Do not localize}
  {$EXTERNALSYM LN_pkcs9}
  LN_pkcs9 = 'pkcs9';  {Do not localize}
  {$EXTERNALSYM LN_pkcs9_challengePassword}
  LN_pkcs9_challengePassword = 'challengePassword';  {Do not localize}
  {$EXTERNALSYM LN_pkcs9_contentType}
  LN_pkcs9_contentType = 'contentType';  {Do not localize}
  {$EXTERNALSYM LN_pkcs9_countersignature}
  LN_pkcs9_countersignature = 'countersignature';  {Do not localize}
  {$EXTERNALSYM LN_pkcs9_emailAddress}
  LN_pkcs9_emailAddress = 'emailAddress';  {Do not localize}
  {$EXTERNALSYM LN_pkcs9_extCertAttributes}
  LN_pkcs9_extCertAttributes = 'extendedCertificateAttributes';  {Do not localize}
  {$EXTERNALSYM LN_pkcs9_messageDigest}
  LN_pkcs9_messageDigest = 'messageDigest';  {Do not localize}
  {$EXTERNALSYM LN_pkcs9_signingTime}
  LN_pkcs9_signingTime = 'signingTime';  {Do not localize}
  {$EXTERNALSYM LN_pkcs9_unstructuredAddress}
  LN_pkcs9_unstructuredAddress = 'unstructuredAddress';  {Do not localize}
  {$EXTERNALSYM LN_pkcs9_unstructuredName}
  LN_pkcs9_unstructuredName = 'unstructuredName';  {Do not localize}
  {$EXTERNALSYM LN_private_key_usage_period}
  LN_private_key_usage_period = 'X509v3 Private Key Usage Period';  {Do not localize}
  {$EXTERNALSYM LN_rc2_40_cbc}
  LN_rc2_40_cbc = 'rc2-40-cbc';  {Do not localize}
  {$EXTERNALSYM LN_rc2_64_cbc}
  LN_rc2_64_cbc = 'rc2-64-cbc';  {Do not localize}
  {$EXTERNALSYM LN_rc2_cbc}
  LN_rc2_cbc = 'rc2-cbc';  {Do not localize}
  {$EXTERNALSYM LN_rc2_cfb64}
  LN_rc2_cfb64 = 'rc2-cfb';  {Do not localize}
  {$EXTERNALSYM LN_rc2_ecb}
  LN_rc2_ecb = 'rc2-ecb';  {Do not localize}
  {$EXTERNALSYM LN_rc2_ofb64}
  LN_rc2_ofb64 = 'rc2-ofb';  {Do not localize}
  {$EXTERNALSYM LN_rc4}
  LN_rc4 = 'rc4';  {Do not localize}
  {$EXTERNALSYM LN_rc4_40}
  LN_rc4_40 = 'rc4-40';  {Do not localize}
  {$EXTERNALSYM LN_rc5_cbc}
  LN_rc5_cbc = 'rc5-cbc';  {Do not localize}
  {$EXTERNALSYM LN_rc5_cfb64}
  LN_rc5_cfb64 = 'rc5-cfb';  {Do not localize}
  {$EXTERNALSYM LN_rc5_ecb}
  LN_rc5_ecb = 'rc5-ecb';  {Do not localize}
  {$EXTERNALSYM LN_rc5_ofb64}
  LN_rc5_ofb64 = 'rc5-ofb';  {Do not localize}
  {$EXTERNALSYM LN_ripemd160}
  LN_ripemd160 = 'ripemd160';  {Do not localize}
  {$EXTERNALSYM LN_ripemd160WithRSA}
  LN_ripemd160WithRSA = 'ripemd160WithRSA';  {Do not localize}
  {$EXTERNALSYM LN_rle_compression}
  LN_rle_compression = 'run length compression';  {Do not localize}
  {$EXTERNALSYM LN_rsa}
  LN_rsa = 'rsa';  {Do not localize}
  {$EXTERNALSYM LN_rsaEncryption}
  LN_rsaEncryption = 'rsaEncryption';  {Do not localize}
  {$EXTERNALSYM LN_rsadsi}
  LN_rsadsi = 'rsadsi';  {Do not localize}
  {$EXTERNALSYM LN_safeContentsBag}
  LN_safeContentsBag = 'safeContentsBag';  {Do not localize}
  {$EXTERNALSYM LN_sdsiCertificate}
  LN_sdsiCertificate = 'sdsiCertificate';  {Do not localize}
  {$EXTERNALSYM LN_secretBag}
  LN_secretBag = 'secretBag';  {Do not localize}
  {$EXTERNALSYM LN_serialNumber}
  LN_serialNumber = 'serialNumber';  {Do not localize}
  {$EXTERNALSYM LN_server_auth}
  LN_server_auth = 'TLS Web Server Authentication';  {Do not localize}
  {$EXTERNALSYM LN_sha}
  LN_sha = 'sha';  {Do not localize}
  {$EXTERNALSYM LN_sha1}
  LN_sha1 = 'sha1';  {Do not localize}
  {$EXTERNALSYM LN_sha1WithRSA}
  LN_sha1WithRSA = 'sha1WithRSA';  {Do not localize}
  {$EXTERNALSYM LN_sha1WithRSAEncryption}
  LN_sha1WithRSAEncryption = 'sha1WithRSAEncryption';  {Do not localize}
  {$EXTERNALSYM LN_shaWithRSAEncryption}
  LN_shaWithRSAEncryption = 'shaWithRSAEncryption';  {Do not localize}
  {$EXTERNALSYM LN_sha256WithRSAEncryption}
  LN_sha256WithRSAEncryption = 'sha256WithRSAEncryption'; {Do not localize}
  {$EXTERNALSYM LN_sha384WithRSAEncryption}
  LN_sha384WithRSAEncryption = 'sha384WithRSAEncryption'; {Do not localize}
  {$EXTERNALSYM LN_sha512WithRSAEncryption}
  LN_sha512WithRSAEncryption = 'sha512WithRSAEncryption'; {do not localize}
  {$EXTERNALSYM LN_sha224WithRSAEncryption}
  LN_sha224WithRSAEncryption = 'sha224WithRSAEncryption'; {Do not localize}
  {$EXTERNALSYM LN_stateOrProvinceName}
  LN_stateOrProvinceName = 'stateOrProvinceName';  {Do not localize}
  {$EXTERNALSYM LN_subject_alt_name}
  LN_subject_alt_name = 'X509v3 Subject Alternative Name';  {Do not localize}
  {$EXTERNALSYM LN_subject_key_identifier}
  LN_subject_key_identifier = 'X509v3 Subject Key Identifier';  {Do not localize}
  {$EXTERNALSYM LN_surname}
  LN_surname = 'surname';  {Do not localize}
  {$EXTERNALSYM LN_sxnet}
  LN_sxnet = 'Strong Extranet ID';  {Do not localize}
  {$EXTERNALSYM LN_time_stamp}
  LN_time_stamp = 'Time Stamping';  {Do not localize}
  {$EXTERNALSYM LN_title}
  LN_title = 'title';  {Do not localize}
  {$EXTERNALSYM LN_undef}
  LN_undef = 'undefined';  {Do not localize}
  {$EXTERNALSYM LN_uniqueIdentifier}
  LN_uniqueIdentifier = 'uniqueIdentifier';  {Do not localize}
  {$EXTERNALSYM LN_x509Certificate}
  LN_x509Certificate = 'x509Certificate';  {Do not localize}
  {$EXTERNALSYM LN_x509Crl}
  LN_x509Crl = 'x509Crl';  {Do not localize}
  {$EXTERNALSYM LN_zlib_compression}
  LN_zlib_compression = 'zlib compression';  {Do not localize}
  {$EXTERNALSYM NID_SMIMECapabilities}
  NID_SMIMECapabilities = 167;
  {$EXTERNALSYM NID_X500}
  NID_X500 = 11;
  {$EXTERNALSYM NID_X509}
  NID_X509 = 12;
  {$EXTERNALSYM NID_algorithm}
  NID_algorithm = 38;
  {$EXTERNALSYM NID_authority_key_identifier}
  NID_authority_key_identifier = 90;
  {$EXTERNALSYM NID_basic_constraints}
  NID_basic_constraints = 87;
  {$EXTERNALSYM NID_bf_cbc}
  NID_bf_cbc = 91;
  {$EXTERNALSYM NID_bf_cfb64}
  NID_bf_cfb64 = 93;
  {$EXTERNALSYM NID_bf_ecb}
  NID_bf_ecb = 92;
  {$EXTERNALSYM NID_bf_ofb64}
  NID_bf_ofb64 = 94;
  {$EXTERNALSYM NID_cast5_cbc}
  NID_cast5_cbc = 108;
  {$EXTERNALSYM NID_cast5_cfb64}
  NID_cast5_cfb64 = 110;
  {$EXTERNALSYM NID_cast5_ecb}
  NID_cast5_ecb = 109;
  {$EXTERNALSYM NID_cast5_ofb64}
  NID_cast5_ofb64 = 111;
  {$EXTERNALSYM NID_certBag}
  NID_certBag = 152;
  {$EXTERNALSYM NID_certificate_policies}
  NID_certificate_policies = 89;
  {$EXTERNALSYM NID_client_auth}
  NID_client_auth = 130;
  {$EXTERNALSYM NID_code_sign}
  NID_code_sign = 131;
  {$EXTERNALSYM NID_commonName}
  NID_commonName = 13;
  {$EXTERNALSYM NID_countryName}
  NID_countryName = 14;
  {$EXTERNALSYM NID_crlBag}
  NID_crlBag = 153;
  {$EXTERNALSYM NID_crl_distribution_points}
  NID_crl_distribution_points = 103;
  {$EXTERNALSYM NID_crl_number}
  NID_crl_number = 88;
  {$EXTERNALSYM NID_crl_reason}
  NID_crl_reason = 141;
  {$EXTERNALSYM NID_delta_crl}
  NID_delta_crl = 140;
  {$EXTERNALSYM NID_des_cbc}
  NID_des_cbc = 31;
  {$EXTERNALSYM NID_des_cfb64}
  NID_des_cfb64 = 30;
  {$EXTERNALSYM NID_des_ecb}
  NID_des_ecb = 29;
  {$EXTERNALSYM NID_des_ede}
  NID_des_ede = 32;
  {$EXTERNALSYM NID_des_ede3}
  NID_des_ede3 = 33;
  {$EXTERNALSYM NID_des_ede3_cbc}
  NID_des_ede3_cbc = 44;
  {$EXTERNALSYM NID_des_ede3_cfb64}
  NID_des_ede3_cfb64 = 61;
  {$EXTERNALSYM NID_des_ede3_ofb64}
  NID_des_ede3_ofb64 = 63;
  {$EXTERNALSYM NID_des_ede_cbc}
  NID_des_ede_cbc = 43;
  {$EXTERNALSYM NID_des_ede_cfb64}
  NID_des_ede_cfb64 = 60;
  {$EXTERNALSYM NID_des_ede_ofb64}
  NID_des_ede_ofb64 = 62;
  {$EXTERNALSYM NID_des_ofb64}
  NID_des_ofb64 = 45;
  {$EXTERNALSYM NID_description}
  NID_description = 107;
  {$EXTERNALSYM NID_desx_cbc}
  NID_desx_cbc = 80;
  {$EXTERNALSYM NID_email_protect}
  NID_email_protect = 132;
  {$EXTERNALSYM NID_ext_key_usage}
  NID_ext_key_usage = 126;
  {$EXTERNALSYM NID_friendlyName}
  NID_friendlyName = 156;
  {$EXTERNALSYM NID_givenName}
  NID_givenName = 99;
  {$EXTERNALSYM NID_hmacWithSHA1}
  NID_hmacWithSHA1 = 163;
  {$EXTERNALSYM NID_id_kp}
  NID_id_kp = 128;
  {$EXTERNALSYM NID_id_pbkdf2}
  NID_id_pbkdf2 = 69;
  {$EXTERNALSYM NID_id_pkix}
  NID_id_pkix = 127;
  {$EXTERNALSYM NID_id_qt_cps}
  NID_id_qt_cps = 164;
  {$EXTERNALSYM NID_id_qt_unotice}
  NID_id_qt_unotice = 165;
  {$EXTERNALSYM NID_idea_cbc}
  NID_idea_cbc = 34;
  {$EXTERNALSYM NID_idea_cfb64}
  NID_idea_cfb64 = 35;
  {$EXTERNALSYM NID_idea_ecb}
  NID_idea_ecb = 36;
  {$EXTERNALSYM NID_idea_ofb64}
  NID_idea_ofb64 = 46;
  {$EXTERNALSYM NID_initials}
  NID_initials = 101;
  {$EXTERNALSYM NID_invalidity_date}
  NID_invalidity_date = 142;
  {$EXTERNALSYM NID_issuer_alt_name}
  NID_issuer_alt_name = 86;
  {$EXTERNALSYM NID_keyBag}
  NID_keyBag = 150;
  {$EXTERNALSYM NID_key_usage}
  NID_key_usage = 83;
  {$EXTERNALSYM NID_ld_ce}
  NID_ld_ce = 81;
  {$EXTERNALSYM NID_localKeyID}
  NID_localKeyID = 157;
  {$EXTERNALSYM NID_localityName}
  NID_localityName = 15;
  {$EXTERNALSYM NID_md2}
  NID_md2 = 3;
  {$EXTERNALSYM NID_md2WithRSAEncryption}
  NID_md2WithRSAEncryption = 7;
  {$EXTERNALSYM NID_md4}
  NID_md4 = 257;
  {$EXTERNALSYM NID_md4WithRSAEncryption}
  NID_md4WithRSAEncryption = 396;
  {$EXTERNALSYM NID_md5}
  NID_md5 = 4;
  {$EXTERNALSYM NID_md5WithRSA}
  NID_md5WithRSA = 104;
  {$EXTERNALSYM NID_md5WithRSAEncryption}
  NID_md5WithRSAEncryption = 8;
  {$EXTERNALSYM NID_md5_sha1}
  NID_md5_sha1 = 114;
  {$EXTERNALSYM NID_mdc2}
  NID_mdc2 = 95;
  {$EXTERNALSYM NID_mdc2WithRSA}
  NID_mdc2WithRSA = 96;
  {$EXTERNALSYM NID_ms_code_com}
  NID_ms_code_com = 135;
  {$EXTERNALSYM NID_ms_code_ind}
  NID_ms_code_ind = 134;
  {$EXTERNALSYM NID_ms_ctl_sign}
  NID_ms_ctl_sign = 136;
  {$EXTERNALSYM NID_ms_efs}
  NID_ms_efs = 138;
  {$EXTERNALSYM NID_ms_sgc}
  NID_ms_sgc = 137;
  {$EXTERNALSYM NID_netscape}
  NID_netscape = 57;
  {$EXTERNALSYM NID_netscape_base_url}
  NID_netscape_base_url = 72;
  {$EXTERNALSYM NID_netscape_ca_policy_url}
  NID_netscape_ca_policy_url = 76;
  {$EXTERNALSYM NID_netscape_ca_revocation_url}
  NID_netscape_ca_revocation_url = 74;
  {$EXTERNALSYM NID_netscape_cert_extension}
  NID_netscape_cert_extension = 58;
  {$EXTERNALSYM NID_netscape_cert_sequence}
  NID_netscape_cert_sequence = 79;
  {$EXTERNALSYM NID_netscape_cert_type}
  NID_netscape_cert_type = 71;
  {$EXTERNALSYM NID_netscape_comment}
  NID_netscape_comment = 78;
  {$EXTERNALSYM NID_netscape_data_type}
  NID_netscape_data_type = 59;
  {$EXTERNALSYM NID_netscape_renewal_url}
  NID_netscape_renewal_url = 75;
  {$EXTERNALSYM NID_netscape_revocation_url}
  NID_netscape_revocation_url = 73;
  {$EXTERNALSYM NID_netscape_ssl_server_name}
  NID_netscape_ssl_server_name = 77;
  {$EXTERNALSYM NID_ns_sgc}
  NID_ns_sgc = 139;
  {$EXTERNALSYM NID_organizationName}
  NID_organizationName = 17;
  {$EXTERNALSYM NID_organizationalUnitName}
  NID_organizationalUnitName = 18;
  {$EXTERNALSYM NID_pbeWithMD2AndDES_CBC}
  NID_pbeWithMD2AndDES_CBC = 9;
  {$EXTERNALSYM NID_pbeWithMD2AndRC2_CBC}
  NID_pbeWithMD2AndRC2_CBC = 168;
  {$EXTERNALSYM NID_pbeWithMD5AndCast5_CBC}
  NID_pbeWithMD5AndCast5_CBC = 112;
  {$EXTERNALSYM NID_pbeWithMD5AndDES_CBC}
  NID_pbeWithMD5AndDES_CBC = 10;
  {$EXTERNALSYM NID_pbeWithMD5AndRC2_CBC}
  NID_pbeWithMD5AndRC2_CBC = 169;
  {$EXTERNALSYM NID_pbeWithSHA1AndDES_CBC}
  NID_pbeWithSHA1AndDES_CBC = 170;
  {$EXTERNALSYM NID_pbeWithSHA1AndRC2_CBC}
  NID_pbeWithSHA1AndRC2_CBC = 68;
  {$EXTERNALSYM NID_pbe_WithSHA1And128BitRC2_CBC}
  NID_pbe_WithSHA1And128BitRC2_CBC = 148;
  {$EXTERNALSYM NID_pbe_WithSHA1And128BitRC4}
  NID_pbe_WithSHA1And128BitRC4 = 144;
  {$EXTERNALSYM NID_pbe_WithSHA1And2_Key_TripleDES_CBC}
  NID_pbe_WithSHA1And2_Key_TripleDES_CBC = 147;
  {$EXTERNALSYM NID_pbe_WithSHA1And3_Key_TripleDES_CBC}
  NID_pbe_WithSHA1And3_Key_TripleDES_CBC = 146;
  {$EXTERNALSYM NID_pbe_WithSHA1And40BitRC2_CBC}
  NID_pbe_WithSHA1And40BitRC2_CBC = 149;
  {$EXTERNALSYM NID_pbe_WithSHA1And40BitRC4}
  NID_pbe_WithSHA1And40BitRC4 = 145;
  {$EXTERNALSYM NID_pbes2}
  NID_pbes2 = 161;
  {$EXTERNALSYM NID_pbmac1}
  NID_pbmac1 = 162;
  {$EXTERNALSYM NID_pkcs}
  NID_pkcs = 2;
  {$EXTERNALSYM NID_pkcs3}
  NID_pkcs3 = 27;
  {$EXTERNALSYM NID_pkcs7}
  NID_pkcs7 = 20;
  {$EXTERNALSYM NID_pkcs7_data}
  NID_pkcs7_data = 21;
  {$EXTERNALSYM NID_pkcs7_digest}
  NID_pkcs7_digest = 25;
  {$EXTERNALSYM NID_pkcs7_encrypted}
  NID_pkcs7_encrypted = 26;
  {$EXTERNALSYM NID_pkcs7_enveloped}
  NID_pkcs7_enveloped = 23;
  {$EXTERNALSYM NID_pkcs7_signed}
  NID_pkcs7_signed = 22;
  {$EXTERNALSYM NID_pkcs7_signedAndEnveloped}
  NID_pkcs7_signedAndEnveloped = 24;
  {$EXTERNALSYM NID_pkcs8ShroudedKeyBag}
  NID_pkcs8ShroudedKeyBag = 151;
  {$EXTERNALSYM NID_pkcs9}
  NID_pkcs9 = 47;
  {$EXTERNALSYM NID_pkcs9_challengePassword}
  NID_pkcs9_challengePassword = 54;
  {$EXTERNALSYM NID_pkcs9_contentType}
  NID_pkcs9_contentType = 50;
  {$EXTERNALSYM NID_pkcs9_countersignature}
  NID_pkcs9_countersignature = 53;
  {$EXTERNALSYM NID_pkcs9_emailAddress}
  NID_pkcs9_emailAddress = 48;
  {$EXTERNALSYM NID_pkcs9_extCertAttributes}
  NID_pkcs9_extCertAttributes = 56;
  {$EXTERNALSYM NID_pkcs9_messageDigest}
  NID_pkcs9_messageDigest = 51;
  {$EXTERNALSYM NID_pkcs9_signingTime}
  NID_pkcs9_signingTime = 52;
  {$EXTERNALSYM NID_pkcs9_unstructuredAddress}
  NID_pkcs9_unstructuredAddress = 55;
  {$EXTERNALSYM NID_pkcs9_unstructuredName}
  NID_pkcs9_unstructuredName = 49;
  {$EXTERNALSYM NID_private_key_usage_period}
  NID_private_key_usage_period = 84;
  {$EXTERNALSYM NID_rc2_40_cbc}
  NID_rc2_40_cbc = 98;
  {$EXTERNALSYM NID_rc2_64_cbc}
  NID_rc2_64_cbc = 166;
  {$EXTERNALSYM NID_rc2_cbc}
  NID_rc2_cbc = 37;
  {$EXTERNALSYM NID_rc2_cfb64}
  NID_rc2_cfb64 = 39;
  {$EXTERNALSYM NID_rc2_ecb}
  NID_rc2_ecb = 38;
  {$EXTERNALSYM NID_rc2_ofb64}
  NID_rc2_ofb64 = 40;
  {$EXTERNALSYM NID_rc4}
  NID_rc4 = 5;
  {$EXTERNALSYM NID_rc4_40}
  NID_rc4_40 = 97;
  {$EXTERNALSYM NID_rc5_cbc}
  NID_rc5_cbc = 120;
  {$EXTERNALSYM NID_rc5_cfb64}
  NID_rc5_cfb64 = 122;
  {$EXTERNALSYM NID_rc5_ecb}
  NID_rc5_ecb = 121;
  {$EXTERNALSYM NID_rc5_ofb64}
  NID_rc5_ofb64 = 123;
  {$EXTERNALSYM NID_ripemd160}
  NID_ripemd160 = 117;
  {$EXTERNALSYM NID_ripemd160WithRSA}
  NID_ripemd160WithRSA = 119;
  {$EXTERNALSYM NID_rle_compression}
  NID_rle_compression = 124;
  {$EXTERNALSYM NID_rsadsi}
  NID_rsadsi = 1;
  {$EXTERNALSYM NID_safeContentsBag}
  NID_safeContentsBag = 155;
  {$EXTERNALSYM NID_sdsiCertificate}
  NID_sdsiCertificate = 159;
  {$EXTERNALSYM NID_secretBag}
  NID_secretBag = 154;
  {$EXTERNALSYM NID_serialNumber}
  NID_serialNumber = 105;
  {$EXTERNALSYM NID_server_auth}
  NID_server_auth = 129;
  {$EXTERNALSYM NID_sha}
  NID_sha = 41;
  {$EXTERNALSYM NID_sha1}
  NID_sha1 = 64;
  {$EXTERNALSYM NID_sha1WithRSA}
  NID_sha1WithRSA = 115;
  {$EXTERNALSYM NID_sha1WithRSAEncryption}
  NID_sha1WithRSAEncryption = 65;
  {$EXTERNALSYM NID_sha256WithRSAEncryption}
  NID_sha256WithRSAEncryption = 668;
  {$EXTERNALSYM NID_sha384WithRSAEncryption}
  NID_sha384WithRSAEncryption = 669;
  {$EXTERNALSYM NID_sha512WithRSAEncryption}
  NID_sha512WithRSAEncryption = 670;
  {$EXTERNALSYM NID_sha224WithRSAEncryption}
  NID_sha224WithRSAEncryption = 671;
  {$EXTERNALSYM NID_shaWithRSAEncryption}
  NID_shaWithRSAEncryption = 42;
  {$EXTERNALSYM NID_stateOrProvinceName}
  NID_stateOrProvinceName = 16;
  {$EXTERNALSYM NID_subject_alt_name}
  NID_subject_alt_name = 85;
  {$EXTERNALSYM NID_subject_key_identifier}
  NID_subject_key_identifier = 82;
  {$EXTERNALSYM NID_surname}
  NID_surname = 100;
  {$EXTERNALSYM NID_sxnet}
  NID_sxnet = 143;
  {$EXTERNALSYM NID_time_stamp}
  NID_time_stamp = 133;
  {$EXTERNALSYM NID_title}
  NID_title = 106;
  {$EXTERNALSYM NID_uniqueIdentifier}
  NID_uniqueIdentifier = 102;
  {$EXTERNALSYM NID_x509Certificate}
  NID_x509Certificate = 158;
  {$EXTERNALSYM NID_x509Crl}
  NID_x509Crl = 160;
  {$EXTERNALSYM NID_zlib_compression}
  NID_zlib_compression = 125;
  {$EXTERNALSYM OBJ_F_OBJ_CREATE}
  OBJ_F_OBJ_CREATE = 100;
  {$EXTERNALSYM OBJ_F_OBJ_DUP}
  OBJ_F_OBJ_DUP = 101;
  {$EXTERNALSYM OBJ_F_OBJ_NID2LN}
  OBJ_F_OBJ_NID2LN = 102;
  {$EXTERNALSYM OBJ_F_OBJ_NID2OBJ}
  OBJ_F_OBJ_NID2OBJ = 103;
  {$EXTERNALSYM OBJ_F_OBJ_NID2SN}
  OBJ_F_OBJ_NID2SN = 104;
  {$EXTERNALSYM OBJ_NAME_ALIAS}
  OBJ_NAME_ALIAS = $8000;
  {$EXTERNALSYM OBJ_NAME_TYPE_CIPHER_METH}
  OBJ_NAME_TYPE_CIPHER_METH = $02;
  {$EXTERNALSYM OBJ_NAME_TYPE_COMP_METH}
  OBJ_NAME_TYPE_COMP_METH = $04;
  {$EXTERNALSYM OBJ_NAME_TYPE_MD_METH}
  OBJ_NAME_TYPE_MD_METH = $01;
  {$EXTERNALSYM OBJ_NAME_TYPE_NUM}
  OBJ_NAME_TYPE_NUM = $05;
  {$EXTERNALSYM OBJ_NAME_TYPE_PKEY_METH}
  OBJ_NAME_TYPE_PKEY_METH = $03;
  {$EXTERNALSYM OBJ_NAME_TYPE_UNDEF}
  OBJ_NAME_TYPE_UNDEF = $00;
  {$EXTERNALSYM OBJ_R_MALLOC_FAILURE}
  OBJ_R_MALLOC_FAILURE = 100;
  {$EXTERNALSYM OBJ_R_UNKNOWN_NID}
  OBJ_R_UNKNOWN_NID = 101;
  {$EXTERNALSYM OPENSSL_VERSION_NUMBER}
  OPENSSL_VERSION_NUMBER = $1000105f;   // MMNNFFPPS Major, Minor, Fix, Patch, Status
  {$EXTERNALSYM OPENSSL_VERSION_TEXT}
{$IFDEF OPENSSL_FIPS}
  OPENSSL_VERSION_TEXT	= 'OpenSSL 1.0.1e-fips 11 Feb 2013'; {Do not localize}
{$ELSE}
  OPENSSL_VERSION_TEXT = 'OpenSSL 1.0.1e 11 Feb 2013';   {Do not localize}
{$ENDIF}
  {$EXTERNALSYM OPENSSL_VERSION_PTEXT}
  OPENSSL_VERSION_PTEXT = ' part of '+ OPENSSL_VERSION_TEXT;  {Do not localize}
  {$EXTERNALSYM PEM_BUFSIZE}
  PEM_BUFSIZE = 1024;
  {$EXTERNALSYM PEM_DEK_DES_CBC}
  PEM_DEK_DES_CBC = 40;
  {$EXTERNALSYM PEM_DEK_DES_ECB}
  PEM_DEK_DES_ECB = 60;
  {$EXTERNALSYM PEM_DEK_DES_EDE}
  PEM_DEK_DES_EDE = 50;
  {$EXTERNALSYM PEM_DEK_IDEA_CBC}
  PEM_DEK_IDEA_CBC = 45;
  {$EXTERNALSYM PEM_DEK_RSA}
  PEM_DEK_RSA = 70;
  {$EXTERNALSYM PEM_DEK_RSA_MD2}
  PEM_DEK_RSA_MD2 = 80;
  {$EXTERNALSYM PEM_DEK_RSA_MD5}
  PEM_DEK_RSA_MD5 = 90;
  {$EXTERNALSYM PEM_ERROR}
  PEM_ERROR = 30;
  {$EXTERNALSYM PEM_F_DEF_CALLBACK}
  PEM_F_DEF_CALLBACK = 100;
  {$EXTERNALSYM PEM_F_LOAD_IV}
  PEM_F_LOAD_IV = 101;
  {$EXTERNALSYM PEM_F_PEM_ASN1_READ}
  PEM_F_PEM_ASN1_READ = 102;
  {$EXTERNALSYM PEM_F_PEM_ASN1_READ_BIO}
  PEM_F_PEM_ASN1_READ_BIO = 103;
  {$EXTERNALSYM PEM_F_PEM_ASN1_WRITE}
  PEM_F_PEM_ASN1_WRITE = 104;
  {$EXTERNALSYM PEM_F_PEM_ASN1_WRITE_BIO}
  PEM_F_PEM_ASN1_WRITE_BIO = 105;
  {$EXTERNALSYM PEM_F_PEM_DO_HEADER}
  PEM_F_PEM_DO_HEADER = 106;
  {$EXTERNALSYM PEM_F_PEM_F_PEM_WRITE_PKCS8PRIVATEKEY}
  PEM_F_PEM_F_PEM_WRITE_PKCS8PRIVATEKEY = 118;
  {$EXTERNALSYM PEM_F_PEM_GET_EVP_CIPHER_INFO}
  PEM_F_PEM_GET_EVP_CIPHER_INFO = 107;
  {$EXTERNALSYM PEM_F_PEM_READ}
  PEM_F_PEM_READ = 108;
  {$EXTERNALSYM PEM_F_PEM_READ_BIO}
  PEM_F_PEM_READ_BIO = 109;
  {$EXTERNALSYM PEM_F_PEM_SEALFINAL}
  PEM_F_PEM_SEALFINAL = 110;
  {$EXTERNALSYM PEM_F_PEM_SEALINIT}
  PEM_F_PEM_SEALINIT = 111;
  {$EXTERNALSYM PEM_F_PEM_SIGNFINAL}
  PEM_F_PEM_SIGNFINAL = 112;
  {$EXTERNALSYM PEM_F_PEM_WRITE}
  PEM_F_PEM_WRITE = 113;
  {$EXTERNALSYM PEM_F_PEM_WRITE_BIO}
  PEM_F_PEM_WRITE_BIO = 114;
  {$EXTERNALSYM PEM_F_PEM_WRITE_BIO_PKCS8PRIVATEKEY}
  PEM_F_PEM_WRITE_BIO_PKCS8PRIVATEKEY = 119;
  {$EXTERNALSYM PEM_F_PEM_X509_INFO_READ}
  PEM_F_PEM_X509_INFO_READ = 115;
  {$EXTERNALSYM PEM_F_PEM_X509_INFO_READ_BIO}
  PEM_F_PEM_X509_INFO_READ_BIO = 116;
  {$EXTERNALSYM PEM_F_PEM_X509_INFO_WRITE_BIO}
  PEM_F_PEM_X509_INFO_WRITE_BIO = 117;
  {$EXTERNALSYM PEM_MD_MD2}
  PEM_MD_MD2 = NID_md2;
  {$EXTERNALSYM PEM_MD_MD2_RSA}
  PEM_MD_MD2_RSA = NID_md2WithRSAEncryption;
  {$EXTERNALSYM PEM_MD_MD5}
  PEM_MD_MD5 = NID_md5;
  {$EXTERNALSYM PEM_MD_MD5_RSA}
  PEM_MD_MD5_RSA = NID_md5WithRSAEncryption;
  {$EXTERNALSYM PEM_MD_SHA}
  PEM_MD_SHA = NID_sha;
  {$EXTERNALSYM PEM_MD_SHA_RSA}
  PEM_MD_SHA_RSA = NID_sha1WithRSAEncryption;
  {$EXTERNALSYM PEM_OBJ_UNDEF}
  PEM_OBJ_UNDEF = 0;
  {$EXTERNALSYM PEM_OBJ_X509}
  PEM_OBJ_X509 = 1;
  {$EXTERNALSYM PEM_OBJ_X509_REQ}
  PEM_OBJ_X509_REQ = 2;
  {$EXTERNALSYM PEM_OBJ_CRL}
  PEM_OBJ_CRL = 3;
  {$EXTERNALSYM PEM_OBJ_SSL_SESSION}
  PEM_OBJ_SSL_SESSION = 4;
  {$EXTERNALSYM PEM_OBJ_PRIV_KEY}
  PEM_OBJ_PRIV_KEY = 10;
  {$EXTERNALSYM PEM_OBJ_PRIV_RSA}
  PEM_OBJ_PRIV_RSA = 11;
  {$EXTERNALSYM PEM_OBJ_PRIV_DSA}
  PEM_OBJ_PRIV_DSA = 12;
  {$EXTERNALSYM PEM_OBJ_PRIV_DH}
  PEM_OBJ_PRIV_DH = 13;
  {$EXTERNALSYM PEM_OBJ_PUB_RSA}
  PEM_OBJ_PUB_RSA = 14;
  {$EXTERNALSYM PEM_OBJ_PUB_DSA}
  PEM_OBJ_PUB_DSA = 15;
  {$EXTERNALSYM PEM_OBJ_PUB_DH}
  PEM_OBJ_PUB_DH =	16;
  {$EXTERNALSYM PEM_OBJ_DHPARAMS}
  PEM_OBJ_DHPARAMS = 17;
  {$EXTERNALSYM PEM_OBJ_DSAPARAMS}
  PEM_OBJ_DSAPARAMS = 18;
  {$EXTERNALSYM PEM_OBJ_PRIV_RSA_PUBLIC}
  PEM_OBJ_PRIV_RSA_PUBLIC = 19;
  {$EXTERNALSYM PEM_OBJ_PRIV_ECDSA}
  PEM_OBJ_PRIV_ECDSA = 20;
  {$EXTERNALSYM PEM_OBJ_PUB_ECDSA}
  PEM_OBJ_PUB_ECDSA	= 21;
  {$EXTERNALSYM PEM_OBJ_ECPARAMETERS}
  PEM_OBJ_ECPARAMETERS = 22;
  {$EXTERNALSYM PEM_R_BAD_BASE64_DECODE}
  PEM_R_BAD_BASE64_DECODE = 100;
  {$EXTERNALSYM PEM_R_BAD_DECRYPT}
  PEM_R_BAD_DECRYPT = 101;
  {$EXTERNALSYM PEM_R_BAD_END_LINE}
  PEM_R_BAD_END_LINE = 102;
  {$EXTERNALSYM PEM_R_BAD_IV_CHARS}
  PEM_R_BAD_IV_CHARS = 103;
  {$EXTERNALSYM PEM_R_BAD_PASSWORD_READ}
  PEM_R_BAD_PASSWORD_READ = 104;
  {$EXTERNALSYM PEM_R_ERROR_CONVERTING_PRIVATE_KEY}
  PEM_R_ERROR_CONVERTING_PRIVATE_KEY = 115;
  {$EXTERNALSYM PEM_R_NOT_DEK_INFO}
  PEM_R_NOT_DEK_INFO = 105;
  {$EXTERNALSYM PEM_R_NOT_ENCRYPTED}
  PEM_R_NOT_ENCRYPTED = 106;
  {$EXTERNALSYM PEM_R_NOT_PROC_TYPE}
  PEM_R_NOT_PROC_TYPE = 107;
  {$EXTERNALSYM PEM_R_NO_START_LINE}
  PEM_R_NO_START_LINE = 108;
  {$EXTERNALSYM PEM_R_PROBLEMS_GETTING_PASSWORD}
  PEM_R_PROBLEMS_GETTING_PASSWORD = 109;
  {$EXTERNALSYM PEM_R_PUBLIC_KEY_NO_RSA}
  PEM_R_PUBLIC_KEY_NO_RSA = 110;
  {$EXTERNALSYM PEM_R_READ_KEY}
  PEM_R_READ_KEY = 111;
  {$EXTERNALSYM PEM_R_SHORT_HEADER}
  PEM_R_SHORT_HEADER = 112;
  {$EXTERNALSYM PEM_R_UNSUPPORTED_CIPHER}
  PEM_R_UNSUPPORTED_CIPHER = 113;
  {$EXTERNALSYM PEM_R_UNSUPPORTED_ENCRYPTION}
  PEM_R_UNSUPPORTED_ENCRYPTION = 114;
  {$EXTERNALSYM PEM_STRING_EVP_PKEY}
  PEM_STRING_EVP_PKEY = 'ANY PRIVATE KEY';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_X509_OLD}
  PEM_STRING_X509_OLD = 'X509 CERTIFICATE';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_X509}
  PEM_STRING_X509 = 'CERTIFICATE';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_X509_PAIR}
  PEM_STRING_X509_PAIR = 'CERTIFICATE PAIR'; {Do not localize}
  {$EXTERNALSYM PEM_STRING_X509_TRUSTED}
  PEM_STRING_X509_TRUSTED = 'TRUSTED CERTIFICATE'; {Do not localize}
  {$EXTERNALSYM PEM_STRING_X509_REQ_OLD}
  PEM_STRING_X509_REQ_OLD = 'NEW CERTIFICATE REQUEST';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_X509_REQ}
  PEM_STRING_X509_REQ = 'CERTIFICATE REQUEST';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_X509_CRL}
  PEM_STRING_X509_CRL = 'X509 CRL';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_PUBLIC}
  PEM_STRING_PUBLIC	= 'PUBLIC KEY';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_RSA}
  PEM_STRING_RSA = 'RSA PRIVATE KEY';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_RSA_PUBLIC}
  PEM_STRING_RSA_PUBLIC = 'RSA PUBLIC KEY';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_DSA}
  PEM_STRING_DSA = 'DSA PRIVATE KEY';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_DSA_PUBLIC}
  PEM_STRING_DSA_PUBLIC	 = 'DSA PUBLIC KEY'; {Do not localize}
  {$EXTERNALSYM PEM_STRING_PKCS7}
  PEM_STRING_PKCS7 = 'PKCS7';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_PKCS7_SIGNED}
  PEM_STRING_PKCS7_SIGNED ='PKCS #7 SIGNED DATA'; {Do not localize}
  {$EXTERNALSYM PEM_STRING_PKCS8}
  PEM_STRING_PKCS8 = 'ENCRYPTED PRIVATE KEY';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_PKCS8INF}
  PEM_STRING_PKCS8INF = 'PRIVATE KEY';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_DHPARAMS}
  PEM_STRING_DHPARAMS = 'DH PARAMETERS';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_SSL_SESSION}
  PEM_STRING_SSL_SESSION = 'SSL SESSION PARAMETERS';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_DSAPARAMS}
  PEM_STRING_DSAPARAMS = 'DSA PARAMETERS';  {Do not localize}
  {$EXTERNALSYM PEM_STRING_ECDSA_PUBLIC}
  PEM_STRING_ECDSA_PUBLIC = 'ECDSA PUBLIC KEY'; {Do not localize}
  {$EXTERNALSYM PEM_STRING_ECPARAMETERS}
  PEM_STRING_ECPARAMETERS = 'EC PARAMETERS'; {Do not localize}
  {$EXTERNALSYM PEM_STRING_ECPRIVATEKEY}
  PEM_STRING_ECPRIVATEKEY	= 'EC PRIVATE KEY'; {Do not localize}
  {$EXTERNALSYM PEM_STRING_CMS}
  PEM_STRING_CMS = 'CMS'; {Do not localize}
  {$EXTERNALSYM PEM_TYPE_CLEAR}
  PEM_TYPE_CLEAR = 40;
  {$EXTERNALSYM PEM_TYPE_ENCRYPTED}
  PEM_TYPE_ENCRYPTED = 10;
  {$EXTERNALSYM PEM_TYPE_MIC_CLEAR}
  PEM_TYPE_MIC_CLEAR = 30;
  {$EXTERNALSYM PEM_TYPE_MIC_ONLY}
  PEM_TYPE_MIC_ONLY = 20;
  {$EXTERNALSYM PKCS5_DEFAULT_ITER}
  PKCS5_DEFAULT_ITER = 2048;
  {$EXTERNALSYM PKCS5_SALT_LEN}
  PKCS5_SALT_LEN = 8;
  {$EXTERNALSYM PKCS7_F_PKCS7_ADD_CERTIFICATE}
  PKCS7_F_PKCS7_ADD_CERTIFICATE = 100;
  {$EXTERNALSYM PKCS7_F_PKCS7_ADD_CRL}
  PKCS7_F_PKCS7_ADD_CRL = 101;
  {$EXTERNALSYM PKCS7_F_PKCS7_ADD_RECIPIENT_INFO}
  PKCS7_F_PKCS7_ADD_RECIPIENT_INFO = 102;
  {$EXTERNALSYM PKCS7_F_PKCS7_ADD_SIGNER}
  PKCS7_F_PKCS7_ADD_SIGNER = 103;
  {$EXTERNALSYM PKCS7_F_PKCS7_CTRL}
  PKCS7_F_PKCS7_CTRL = 104;
  {$EXTERNALSYM PKCS7_F_PKCS7_DATADECODE}
  PKCS7_F_PKCS7_DATADECODE = 112;
  {$EXTERNALSYM PKCS7_F_PKCS7_DATAINIT}
  PKCS7_F_PKCS7_DATAINIT = 105;
  {$EXTERNALSYM PKCS7_F_PKCS7_DATASIGN}
  PKCS7_F_PKCS7_DATASIGN = 106;
  {$EXTERNALSYM PKCS7_F_PKCS7_DATAVERIFY}
  PKCS7_F_PKCS7_DATAVERIFY = 107;
  {$EXTERNALSYM PKCS7_F_PKCS7_SET_CIPHER}
  PKCS7_F_PKCS7_SET_CIPHER = 108;
  {$EXTERNALSYM PKCS7_F_PKCS7_SET_CONTENT}
  PKCS7_F_PKCS7_SET_CONTENT = 109;
  {$EXTERNALSYM PKCS7_F_PKCS7_SET_TYPE}
  PKCS7_F_PKCS7_SET_TYPE = 110;
  {$EXTERNALSYM PKCS7_F_PKCS7_SIGNATUREVERIFY}
  PKCS7_F_PKCS7_SIGNATUREVERIFY = 113;
  {$EXTERNALSYM PKCS7_OP_GET_DETACHED_SIGNATURE}
  PKCS7_OP_GET_DETACHED_SIGNATURE = 2;
  {$EXTERNALSYM PKCS7_OP_SET_DETACHED_SIGNATURE}
  PKCS7_OP_SET_DETACHED_SIGNATURE = 1;
  {$EXTERNALSYM PKCS7_R_CIPHER_NOT_INITIALIZED}
  PKCS7_R_CIPHER_NOT_INITIALIZED = 116;
  {$EXTERNALSYM PKCS7_R_DECRYPTED_KEY_IS_WRONG_LENGTH}
  PKCS7_R_DECRYPTED_KEY_IS_WRONG_LENGTH = 100;
  {$EXTERNALSYM PKCS7_R_DIGEST_FAILURE}
  PKCS7_R_DIGEST_FAILURE = 101;
  {$EXTERNALSYM PKCS7_R_INTERNAL_ERROR}
  PKCS7_R_INTERNAL_ERROR = 102;
  {$EXTERNALSYM PKCS7_R_MISSING_CERIPEND_INFO}
  PKCS7_R_MISSING_CERIPEND_INFO = 103;
  {$EXTERNALSYM PKCS7_R_NO_RECIPIENT_MATCHES_CERTIFICATE}
  PKCS7_R_NO_RECIPIENT_MATCHES_CERTIFICATE = 115;
  {$EXTERNALSYM PKCS7_R_OPERATION_NOT_SUPPORTED_ON_THIS_TYPE}
  PKCS7_R_OPERATION_NOT_SUPPORTED_ON_THIS_TYPE = 104;
  {$EXTERNALSYM PKCS7_R_SIGNATURE_FAILURE}
  PKCS7_R_SIGNATURE_FAILURE = 105;
  {$EXTERNALSYM PKCS7_R_UNABLE_TO_FIND_CERTIFICATE}
  PKCS7_R_UNABLE_TO_FIND_CERTIFICATE = 106;
  {$EXTERNALSYM PKCS7_R_UNABLE_TO_FIND_MEM_BIO}
  PKCS7_R_UNABLE_TO_FIND_MEM_BIO = 107;
  {$EXTERNALSYM PKCS7_R_UNABLE_TO_FIND_MESSAGE_DIGEST}
  PKCS7_R_UNABLE_TO_FIND_MESSAGE_DIGEST = 108;
  {$EXTERNALSYM PKCS7_R_UNKNOWN_DIGEST_TYPE}
  PKCS7_R_UNKNOWN_DIGEST_TYPE = 109;
  {$EXTERNALSYM PKCS7_R_UNKNOWN_OPERATION}
  PKCS7_R_UNKNOWN_OPERATION = 110;
  {$EXTERNALSYM PKCS7_R_UNSUPPORTED_CIPHER_TYPE}
  PKCS7_R_UNSUPPORTED_CIPHER_TYPE = 111;
  {$EXTERNALSYM PKCS7_R_UNSUPPORTED_CONTENT_TYPE}
  PKCS7_R_UNSUPPORTED_CONTENT_TYPE = 112;
  {$EXTERNALSYM PKCS7_R_WRONG_CONTENT_TYPE}
  PKCS7_R_WRONG_CONTENT_TYPE = 113;
  {$EXTERNALSYM PKCS7_R_WRONG_PKCS7_TYPE}
  PKCS7_R_WRONG_PKCS7_TYPE = 114;
  {$EXTERNALSYM PKCS7_S_BODY}
  PKCS7_S_BODY = 1;
  {$EXTERNALSYM PKCS7_S_HEADER}
  PKCS7_S_HEADER = 0;
  {$EXTERNALSYM PKCS7_S_TAIL}
  PKCS7_S_TAIL = 2;
  {$EXTERNALSYM PKCS8_NEG_PRIVKEY}
  PKCS8_NEG_PRIVKEY = 4;
  {$EXTERNALSYM PKCS8_NS_DB}
  PKCS8_NS_DB = 3;
  {$EXTERNALSYM PKCS8_EMBEDDED_PARAM}
  PKCS8_EMBEDDED_PARAM = 2;
  {$EXTERNALSYM PKCS8_NO_OCTET}
  PKCS8_NO_OCTET = 1;
  {$EXTERNALSYM PKCS8_OK}
  PKCS8_OK = 0;
  {$EXTERNALSYM P_tmpdir}
  P_tmpdir = '/tmp';  {Do not localize}
  {$EXTERNALSYM MSS_RAND_MAX}
  MSS_RAND_MAX = $7fffffff;
  {$IFNDEF OPENSSL_NO_RC2}
  {$EXTERNALSYM RC2_BLOCK}
  RC2_BLOCK = 8;
  {$EXTERNALSYM RC2_DECRYPT}
  RC2_DECRYPT = 0;
  {$EXTERNALSYM RC2_ENCRYPT}
  RC2_ENCRYPT = 1;
  {$EXTERNALSYM RC2_KEY_LENGTH}
  RC2_KEY_LENGTH = 16;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RC5}
  {$EXTERNALSYM RC5_12_ROUNDS}
  RC5_12_ROUNDS = 12;
  {$EXTERNALSYM RC5_16_ROUNDS}
  RC5_16_ROUNDS = 16;
  {$EXTERNALSYM RC5_32_BLOCK}
  RC5_32_BLOCK = 8;
  {$EXTERNALSYM RC5_32_KEY_LENGTH}
  RC5_32_KEY_LENGTH = 16;
  {$EXTERNALSYM RC5_8_ROUNDS}
  RC5_8_ROUNDS = 8;
  {$EXTERNALSYM RC5_DECRYPT}
  RC5_DECRYPT = 0;
  {$EXTERNALSYM RC5_ENCRYPT}
  RC5_ENCRYPT = 1;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_HMAC}
  {$EXTERNALSYM HMAC_MAX_MD_CBLOCK}
  HMAC_MAX_MD_CBLOCK = 128; //* largest known is SHA512 */
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RIPEMD}
  {$EXTERNALSYM RIPEMD160_BLOCK}
  RIPEMD160_BLOCK = 16;
  {$EXTERNALSYM RIPEMD160_CBLOCK}
  RIPEMD160_CBLOCK = 64;
  {$EXTERNALSYM RIPEMD160_DIGEST_LENGTH}
  RIPEMD160_DIGEST_LENGTH = 20;
  {$EXTERNALSYM RIPEMD160_LAST_BLOCK}
  RIPEMD160_LAST_BLOCK = 56;
  {$EXTERNALSYM RIPEMD160_LBLOCK}
  RIPEMD160_LBLOCK = 16;
  {$EXTERNALSYM RIPEMD160_LENGTH_BLOCK}
  RIPEMD160_LENGTH_BLOCK = 8;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RSA}
///* If this flag is set the RSA method is FIPS compliant and can be used
// * in FIPS mode. This is set in the validated module method. If an
// * application sets this flag in its own methods it is its reposibility
// * to ensure the result is compliant.
// */

  {$EXTERNALSYM RSA_FLAG_FIPS_METHOD}
  RSA_FLAG_FIPS_METHOD			= $0400;

///* If this flag is set the operations normally disabled in FIPS mode are
// * permitted it is then the applications responsibility to ensure that the
// * usage is compliant.
// */

  {$EXTERNALSYM RSA_FLAG_NON_FIPS_ALLOW}
  RSA_FLAG_NON_FIPS_ALLOW		 = $0400;

  {$EXTERNALSYM RSA_3}
  RSA_3 = $3;
  {$EXTERNALSYM RSA_F4}
  RSA_F4 = $10001;
  {$EXTERNALSYM RSA_FLAG_BLINDING}
  RSA_FLAG_BLINDING = $08;
  {$EXTERNALSYM RSA_FLAG_CACHE_PRIVATE}
  RSA_FLAG_CACHE_PRIVATE = $04;
  {$EXTERNALSYM RSA_FLAG_CACHE_PUBLIC}
  RSA_FLAG_CACHE_PUBLIC = $02;
  {$EXTERNALSYM RSA_FLAG_EXT_PKEY}
  RSA_FLAG_EXT_PKEY = $20;
  {$EXTERNALSYM RSA_FLAG_SIGN_VER}
  RSA_FLAG_SIGN_VER = $0040;
  {$EXTERNALSYM RSA_FLAG_NO_BLINDING}
  RSA_FLAG_NO_BLINDING =$0080; //* new with 0.9.6j and 0.9.7b; the built-in
                                       //* RSA implementation now uses blinding by
                                       //* default (ignoring RSA_FLAG_BLINDING),
                                       //* but other engines might not need it
                                       //*/
  {$EXTERNALSYM RSA_FLAG_NO_CONSTTIME}
  RSA_FLAG_NO_CONSTTIME = $0100; //* new with 0.9.8f; the built-in RSA
                                      //* implementation now uses constant time
                                      //* operations by default in private key operations,
                                      //* e.g., constant time modular exponentiation,
                                      //* modular inverse without leaking branches,
                                      //* division without leaking branches. This
                                      //* flag disables these constant time
                                      //* operations and results in faster RSA
                                      //* private key operations.
                                      //*/
{$IFNDEF OPENSSL_NO_DEPRECATED}
  {$EXTERNALSYM RSA_FLAG_NO_EXP_CONSTTIME}
  RSA_FLAG_NO_EXP_CONSTTIME = RSA_FLAG_NO_CONSTTIME; //* deprecated name for the flag*/
                                                //* new with 0.9.7h; the built-in RSA
                                                //* implementation now uses constant time
                                                //* modular exponentiation for secret exponents
                                                //* by default. This flag causes the
                                                //* faster variable sliding window method to
                                                //* be used for all exponents.
                                                //*/
{$ENDIF}
  //the openssl developers probably only wanted to define this if it was not already defined.
  {$EXTERNALSYM RSA_MAX_MODULUS_BITS}
  RSA_MAX_MODULUS_BITS	= 16384;
  {$EXTERNALSYM RSA_FIPS_MIN_MODULUS_BITS}
  RSA_FIPS_MIN_MODULUS_BITS = 1024;
  //the openssl developers probably only wanted to define this if it was not already defined.
  {$EXTERNALSYM RSA_SMALL_MODULUS_BITS}
  RSA_SMALL_MODULUS_BITS  =	3072;
  //the openssl developers probably only wanted to define this if it was not already defined.
  {$EXTERNALSYM RSA_MAX_PUBEXP_BITS}
  RSA_MAX_PUBEXP_BITS	= 64; //* exponent limit enforced for "large" modulus only */

  {$EXTERNALSYM RSA_FLAG_THREAD_SAFE}
  RSA_FLAG_THREAD_SAFE = $10;
  //* function codes */
  {$EXTERNALSYM RSA_F_FIPS_RSA_SIGN}
  RSA_F_FIPS_RSA_SIGN				= 140;
  {$EXTERNALSYM RSA_F_FIPS_RSA_VERIFY}
  RSA_F_FIPS_RSA_VERIFY				= 141;
  {$EXTERNALSYM RSA_F_MEMORY_LOCK}
  RSA_F_MEMORY_LOCK = 100;
  {$EXTERNALSYM RSA_F_RSA_CHECK_KEY}
  RSA_F_RSA_CHECK_KEY = 123;
  {$EXTERNALSYM RSA_F_RSA_EAY_PRIVATE_DECRYPT}
  RSA_F_RSA_EAY_PRIVATE_DECRYPT = 101;
  {$EXTERNALSYM RSA_F_RSA_EAY_PRIVATE_ENCRYPT}
  RSA_F_RSA_EAY_PRIVATE_ENCRYPT = 102;
  {$EXTERNALSYM RSA_F_RSA_EAY_PUBLIC_DECRYPT}
  RSA_F_RSA_EAY_PUBLIC_DECRYPT = 103;
  {$EXTERNALSYM RSA_F_RSA_EAY_PUBLIC_ENCRYPT}
  RSA_F_RSA_EAY_PUBLIC_ENCRYPT = 104;
  {$EXTERNALSYM RSA_F_RSA_GENERATE_KEY}
  RSA_F_RSA_GENERATE_KEY = 105;
  {$EXTERNALSYM RSA_F_RSA_NEW_METHOD}
  RSA_F_RSA_NEW_METHOD = 106;
  {$EXTERNALSYM RSA_F_RSA_PADDING_ADD_NONE}
  RSA_F_RSA_PADDING_ADD_NONE = 107;
  {$EXTERNALSYM RSA_F_RSA_PADDING_ADD_PKCS1_OAEP}
  RSA_F_RSA_PADDING_ADD_PKCS1_OAEP = 121;
  {$EXTERNALSYM RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_1}
  RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_1 = 108;
  {$EXTERNALSYM RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_2}
  RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_2 = 109;
  {$EXTERNALSYM RSA_F_RSA_PADDING_ADD_SSLV23}
  RSA_F_RSA_PADDING_ADD_SSLV23 = 110;
  {$EXTERNALSYM RSA_F_RSA_PADDING_CHECK_NONE}
  RSA_F_RSA_PADDING_CHECK_NONE = 111;
  {$EXTERNALSYM RSA_F_RSA_PADDING_CHECK_PKCS1_OAEP}
  RSA_F_RSA_PADDING_CHECK_PKCS1_OAEP = 122;
  {$EXTERNALSYM RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_1}
  RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_1 = 112;
  {$EXTERNALSYM RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_2}
  RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_2 = 113;
  {$EXTERNALSYM RSA_F_RSA_PADDING_CHECK_SSLV23}
  RSA_F_RSA_PADDING_CHECK_SSLV23 = 114;
  {$EXTERNALSYM RSA_F_RSA_PRINT}
  RSA_F_RSA_PRINT = 115;
  {$EXTERNALSYM RSA_F_RSA_PRINT_FP}
  RSA_F_RSA_PRINT_FP = 116;
  {$EXTERNALSYM RSA_F_RSA_PRIVATE_ENCRYPT}
  RSA_F_RSA_PRIVATE_ENCRYPT			 = 137;
  {$EXTERNALSYM RSA_F_RSA_PUBLIC_DECRYPT}
  RSA_F_RSA_PUBLIC_DECRYPT			 = 138;
  {$EXTERNALSYM RSA_F_RSA_SETUP_BLINDING}
  RSA_F_RSA_SETUP_BLINDING			 = 136;
  {$EXTERNALSYM RSA_F_RSA_SET_DEFAULT_METHOD}
  RSA_F_RSA_SET_DEFAULT_METHOD		 = 139;
  {$EXTERNALSYM RSA_F_RSA_SET_METHOD}
  RSA_F_RSA_SET_METHOD				 = 142;
  {$EXTERNALSYM RSA_F_RSA_SIGN}
  RSA_F_RSA_SIGN = 117;
  {$EXTERNALSYM RSA_F_RSA_SIGN_ASN1_OCTET_STRING}
  RSA_F_RSA_SIGN_ASN1_OCTET_STRING = 118;
  {$EXTERNALSYM RSA_F_RSA_VERIFY}
  RSA_F_RSA_VERIFY = 119;
  {$EXTERNALSYM RSA_F_RSA_VERIFY_ASN1_OCTET_STRING}
  RSA_F_RSA_VERIFY_ASN1_OCTET_STRING = 120;
  {$EXTERNALSYM RSA_F_RSA_VERIFY_PKCS1_PSS}
  RSA_F_RSA_VERIFY_PKCS1_PSS			= 126;
  {$EXTERNALSYM RSA_METHOD_FLAG_NO_CHECK}
  RSA_METHOD_FLAG_NO_CHECK = $01;
  {$EXTERNALSYM RSA_NO_PADDING}
  RSA_NO_PADDING = 3;
  {$EXTERNALSYM RSA_PKCS1_OAEP_PADDING}
  RSA_PKCS1_OAEP_PADDING = 4;
  {$EXTERNALSYM RSA_PKCS1_PADDING}
  RSA_PKCS1_PADDING = 1;
  {$EXTERNALSYM RSA_R_ALGORITHM_MISMATCH}
  RSA_R_ALGORITHM_MISMATCH = 100;
  {$EXTERNALSYM RSA_R_BAD_E_VALUE}
  RSA_R_BAD_E_VALUE = 101;
  {$EXTERNALSYM RSA_R_BAD_FIXED_HEADER_DECRYPT}
  RSA_R_BAD_FIXED_HEADER_DECRYPT = 102;
  {$EXTERNALSYM RSA_R_BAD_PAD_BYTE_COUNT}
  RSA_R_BAD_PAD_BYTE_COUNT = 103;
  {$EXTERNALSYM RSA_R_BAD_SIGNATURE}
  RSA_R_BAD_SIGNATURE = 104;
  {$EXTERNALSYM RSA_R_BLOCK_TYPE_IS_NOT_01}
  RSA_R_BLOCK_TYPE_IS_NOT_01 = 106;
  {$EXTERNALSYM RSA_R_BLOCK_TYPE_IS_NOT_02}
  RSA_R_BLOCK_TYPE_IS_NOT_02 = 107;
  {$EXTERNALSYM RSA_R_DATA_GREATER_THAN_MOD_LEN}
  RSA_R_DATA_GREATER_THAN_MOD_LEN = 108;
  {$EXTERNALSYM RSA_R_DATA_TOO_LARGE}
  RSA_R_DATA_TOO_LARGE = 109;
  {$EXTERNALSYM RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE}
  RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE = 110;
  {$EXTERNALSYM RSA_R_DATA_TOO_SMALL}
  RSA_R_DATA_TOO_SMALL = 111;
  {$EXTERNALSYM RSA_R_DATA_TOO_SMALL_FOR_KEY_SIZE}
  RSA_R_DATA_TOO_SMALL_FOR_KEY_SIZE = 122;
  {$EXTERNALSYM RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY}
  RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY = 112;
  {$EXTERNALSYM RSA_R_DMP1_NOT_CONGRUENT_TO_D}
  RSA_R_DMP1_NOT_CONGRUENT_TO_D = 124;
  {$EXTERNALSYM RSA_R_DMQ1_NOT_CONGRUENT_TO_D}
  RSA_R_DMQ1_NOT_CONGRUENT_TO_D = 125;
  {$EXTERNALSYM RSA_R_D_E_NOT_CONGRUENT_TO_1}
  RSA_R_D_E_NOT_CONGRUENT_TO_1 = 123;
  {$EXTERNALSYM RSA_R_IQMP_NOT_INVERSE_OF_Q}
  RSA_R_IQMP_NOT_INVERSE_OF_Q = 126;
  {$EXTERNALSYM RSA_R_KEY_SIZE_TOO_SMALL}
  RSA_R_KEY_SIZE_TOO_SMALL = 120;
  {$EXTERNALSYM RSA_R_LAST_OCTET_INVALID}
  RSA_R_LAST_OCTET_INVALID			= 134;
  {$EXTERNALSYM RSA_R_MODULUS_TOO_LARGE}
  RSA_R_MODULUS_TOO_LARGE				= 105;
  {$EXTERNALSYM RSA_R_NON_FIPS_METHOD}
  RSA_R_NON_FIPS_METHOD				= 141;
  {$EXTERNALSYM RSA_R_NO_PUBLIC_EXPONENT}
  RSA_R_NO_PUBLIC_EXPONENT			= 140;
  {$EXTERNALSYM RSA_R_NULL_BEFORE_BLOCK_MISSING}
  RSA_R_NULL_BEFORE_BLOCK_MISSING = 113;
  {$EXTERNALSYM RSA_R_N_DOES_NOT_EQUAL_P_Q}
  RSA_R_N_DOES_NOT_EQUAL_P_Q = 127;
  {$EXTERNALSYM RSA_R_OAEP_DECODING_ERROR}
  RSA_R_OAEP_DECODING_ERROR = 121;
  {$EXTERNALSYM RSA_R_OPERATION_NOT_ALLOWED_IN_FIPS_MODE}
  RSA_R_OPERATION_NOT_ALLOWED_IN_FIPS_MODE	 = 142;
  {$EXTERNALSYM RSA_R_PADDING_CHECK_FAILED}
  RSA_R_PADDING_CHECK_FAILED = 114;
  {$EXTERNALSYM RSA_R_P_NOT_PRIME}
  RSA_R_P_NOT_PRIME = 128;
  {$EXTERNALSYM RSA_R_Q_NOT_PRIME}
  RSA_R_Q_NOT_PRIME = 129;
  {$EXTERNALSYM RSA_R_SLEN_CHECK_FAILED}
  RSA_R_SLEN_CHECK_FAILED				= 136;
  {$EXTERNALSYM RSA_R_SLEN_RECOVERY_FAILED}
  RSA_R_SLEN_RECOVERY_FAILED			= 135;
  {$EXTERNALSYM RSA_R_SSLV3_ROLLBACK_ATTACK}
  RSA_R_SSLV3_ROLLBACK_ATTACK = 115;
  {$EXTERNALSYM RSA_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD}
  RSA_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD = 116;
  {$EXTERNALSYM RSA_R_UNKNOWN_ALGORITHM_TYPE}
  RSA_R_UNKNOWN_ALGORITHM_TYPE = 117;
  {$EXTERNALSYM RSA_R_UNKNOWN_PADDING_TYPE}
  RSA_R_UNKNOWN_PADDING_TYPE = 118;
  {$EXTERNALSYM RSA_R_WRONG_SIGNATURE_LENGTH}
  RSA_R_WRONG_SIGNATURE_LENGTH = 119;
  {$EXTERNALSYM RSA_SSLV23_PADDING}
  RSA_SSLV23_PADDING = 2;
  {$ENDIF}
  {$EXTERNALSYM SEEK_CUR}
  SEEK_CUR = 1;
  {$EXTERNALSYM SEEK_END}
  SEEK_END = 2;
  {$EXTERNALSYM SEEK_SET}
  SEEK_SET = 0;
  {$EXTERNALSYM SN_Algorithm}
  SN_Algorithm = 'Algorithm';  {Do not localize}
  {$EXTERNALSYM SN_SMIMECapabilities}
  SN_SMIMECapabilities = 'SMIME-CAPS';  {Do not localize}
  {$EXTERNALSYM SN_authority_key_identifier}
  SN_authority_key_identifier = 'authorityKeyIdentifier';  {Do not localize}
  {$EXTERNALSYM SN_basic_constraints}
  SN_basic_constraints = 'basicConstraints';  {Do not localize}
  {$EXTERNALSYM SN_bf_cbc}
  SN_bf_cbc = 'BF-CBC';  {Do not localize}
  {$EXTERNALSYM SN_bf_cfb64}
  SN_bf_cfb64 = 'BF-CFB';  {Do not localize}
  {$EXTERNALSYM SN_bf_ecb}
  SN_bf_ecb = 'BF-ECB';  {Do not localize}
  {$EXTERNALSYM SN_bf_ofb64}
  SN_bf_ofb64 = 'BF-OFB';  {Do not localize}
  {$EXTERNALSYM SN_cast5_cbc}
  SN_cast5_cbc = 'CAST5-CBC';  {Do not localize}
  {$EXTERNALSYM SN_cast5_cfb64}
  SN_cast5_cfb64 = 'CAST5-CFB';  {Do not localize}
  {$EXTERNALSYM SN_cast5_ecb}
  SN_cast5_ecb = 'CAST5-ECB';  {Do not localize}
  {$EXTERNALSYM SN_cast5_ofb64}
  SN_cast5_ofb64 = 'CAST5-OFB';  {Do not localize}
  {$EXTERNALSYM SN_certificate_policies}
  SN_certificate_policies = 'certificatePolicies';  {Do not localize}
  {$EXTERNALSYM SN_client_auth}
  SN_client_auth = 'clientAuth';  {Do not localize}
  {$EXTERNALSYM SN_code_sign}
  SN_code_sign = 'codeSigning';  {Do not localize}
  {$EXTERNALSYM SN_commonName}
  SN_commonName = 'CN';  {Do not localize}
  {$EXTERNALSYM SN_countryName}
  SN_countryName = 'C';  {Do not localize}
  {$EXTERNALSYM SN_crl_distribution_points}
  SN_crl_distribution_points = 'crlDistributionPoints';  {Do not localize}
  {$EXTERNALSYM SN_crl_number}
  SN_crl_number = 'crlNumber';  {Do not localize}
  {$EXTERNALSYM SN_crl_reason}
  SN_crl_reason = 'CRLReason';  {Do not localize}
  {$EXTERNALSYM SN_delta_crl}
  SN_delta_crl = 'deltaCRL';  {Do not localize}
  {$EXTERNALSYM SN_des_cbc}
  SN_des_cbc = 'DES-CBC';  {Do not localize}
  {$EXTERNALSYM SN_des_cfb64}
  SN_des_cfb64 = 'DES-CFB';  {Do not localize}
  {$EXTERNALSYM SN_des_ecb}
  SN_des_ecb = 'DES-ECB';  {Do not localize}
  {$EXTERNALSYM SN_des_ede}
  SN_des_ede = 'DES-EDE';  {Do not localize}
  {$EXTERNALSYM SN_des_ede3}
  SN_des_ede3 = 'DES-EDE3';  {Do not localize}
  {$EXTERNALSYM SN_des_ede3_cbc}
  SN_des_ede3_cbc = 'DES-EDE3-CBC';  {Do not localize}
  {$EXTERNALSYM SN_des_ede3_cfb64}
  SN_des_ede3_cfb64 = 'DES-EDE3-CFB';  {Do not localize}
  {$EXTERNALSYM SN_des_ede3_ofb64}
  SN_des_ede3_ofb64 = 'DES-EDE3-OFB';  {Do not localize}
  {$EXTERNALSYM SN_des_ede_cbc}
  SN_des_ede_cbc = 'DES-EDE-CBC';  {Do not localize}
  {$EXTERNALSYM SN_des_ede_cfb64}
  SN_des_ede_cfb64 = 'DES-EDE-CFB';  {Do not localize}
  {$EXTERNALSYM SN_des_ede_ofb64}
  SN_des_ede_ofb64 = 'DES-EDE-OFB';  {Do not localize}
  {$EXTERNALSYM SN_des_ofb64}
  SN_des_ofb64 = 'DES-OFB';  {Do not localize}
  {$EXTERNALSYM SN_description}
  SN_description = 'D';  {Do not localize}
  {$EXTERNALSYM SN_desx_cbc}
  SN_desx_cbc = 'DESX-CBC';  {Do not localize}
  {$EXTERNALSYM SN_dsa}
  SN_dsa = 'DSA';  {Do not localize}
  {$EXTERNALSYM SN_dsaWithSHA}
  SN_dsaWithSHA = 'DSA-SHA';  {Do not localize}
  {$EXTERNALSYM SN_dsaWithSHA1}
  SN_dsaWithSHA1 = 'DSA-SHA1';  {Do not localize}
  {$EXTERNALSYM SN_dsaWithSHA1_2}
  SN_dsaWithSHA1_2 = 'DSA-SHA1-old';  {Do not localize}
  {$EXTERNALSYM SN_dsa_2}
  SN_dsa_2 = 'DSA-old';  {Do not localize}
  {$EXTERNALSYM SN_X9_62_id_ecPublicKey}
  SN_X9_62_id_ecPublicKey = 'id-ecPublicKey';  {Do not localize}
  {$EXTERNALSYM SN_email_protect}
  SN_email_protect = 'emailProtection';  {Do not localize}
  {$EXTERNALSYM SN_ext_key_usage}
  SN_ext_key_usage = 'extendedKeyUsage';  {Do not localize}
  {$EXTERNALSYM SN_givenName}
  SN_givenName = 'G';  {Do not localize}
  {$EXTERNALSYM SN_id_kp}
  SN_id_kp = 'id-kp';  {Do not localize}
  {$EXTERNALSYM SN_id_pkix}
  SN_id_pkix = 'PKIX';  {Do not localize}
  {$EXTERNALSYM SN_id_qt_cps}
  SN_id_qt_cps = 'id-qt-cps';  {Do not localize}
  {$EXTERNALSYM SN_id_qt_unotice}
  SN_id_qt_unotice = 'id-qt-unotice';  {Do not localize}
  {$EXTERNALSYM SN_idea_cbc}
  SN_idea_cbc = 'IDEA-CBC';  {Do not localize}
  {$EXTERNALSYM SN_idea_cfb64}
  SN_idea_cfb64 = 'IDEA-CFB';  {Do not localize}
  {$EXTERNALSYM SN_idea_ecb}
  SN_idea_ecb = 'IDEA-ECB';  {Do not localize}
  {$EXTERNALSYM SN_idea_ofb64}
  SN_idea_ofb64 = 'IDEA-OFB';  {Do not localize}
  {$EXTERNALSYM SN_identified_organization}
  SN_identified_organization = 'identified-organization'; {Do not localize}
  {$EXTERNALSYM SN_initials}
  SN_initials = 'I';  {Do not localize}
  {$EXTERNALSYM SN_invalidity_date}
  SN_invalidity_date = 'invalidityDate';  {Do not localize}
  {$EXTERNALSYM SN_iso}
  SN_iso = 'ISO'; {Do not localize}
  {$EXTERNALSYM SN_issuer_alt_name}
  SN_issuer_alt_name = 'issuerAltName';  {Do not localize}
  {$EXTERNALSYM SN_itu_t}
  SN_itu_t = 'ITU-T'; {Do not localize}
  {$EXTERNALSYM SN_joint_iso_itu_t}
  SN_joint_iso_itu_t = 'JOINT-ISO-ITU-T'; {Do not localize}
  {$EXTERNALSYM SN_key_usage}
  SN_key_usage = 'keyUsage';  {Do not localize}
  {$EXTERNALSYM SN_ld_ce}
  SN_ld_ce = 'ld-ce';  {Do not localize}
  {$EXTERNALSYM SN_localityName}
  SN_localityName = 'L';  {Do not localize}
  {$EXTERNALSYM SN_md2}
  SN_md2 = 'MD2';  {Do not localize}
  {$EXTERNALSYM SN_md2WithRSAEncryption}
  SN_md2WithRSAEncryption = 'RSA-MD2';  {Do not localize}
  {$EXTERNALSYM SN_md5}
  SN_md5 = 'MD5';  {Do not localize}
  {$EXTERNALSYM SN_md5WithRSA}
  SN_md5WithRSA = 'RSA-NP-MD5';  {Do not localize}
  {$EXTERNALSYM SN_md5WithRSAEncryption}
  SN_md5WithRSAEncryption = 'RSA-MD5';  {Do not localize}
  {$EXTERNALSYM SN_md5_sha1}
  SN_md5_sha1 = 'MD5-SHA1';  {Do not localize}
  {$EXTERNALSYM SN_mdc2}
  SN_mdc2 = 'MDC2';  {Do not localize}
  {$EXTERNALSYM SN_mdc2WithRSA}
  SN_mdc2WithRSA = 'RSA-MDC2';  {Do not localize}
  {$EXTERNALSYM SN_member_body}
  SN_member_body	='member-body'; {Do not localize}
  {$EXTERNALSYM SN_ms_code_com}
  SN_ms_code_com = 'msCodeCom';  {Do not localize}
  {$EXTERNALSYM SN_ms_code_ind}
  SN_ms_code_ind = 'msCodeInd';  {Do not localize}
  {$EXTERNALSYM SN_ms_ctl_sign}
  SN_ms_ctl_sign = 'msCTLSign';  {Do not localize}
  {$EXTERNALSYM SN_ms_efs}
  SN_ms_efs = 'msEFS';  {Do not localize}
  {$EXTERNALSYM SN_ms_sgc}
  SN_ms_sgc = 'msSGC';  {Do not localize}
  {$EXTERNALSYM SN_netscape}
  SN_netscape = 'Netscape';  {Do not localize}
  {$EXTERNALSYM SN_netscape_base_url}
  SN_netscape_base_url = 'nsBaseUrl';  {Do not localize}
  {$EXTERNALSYM SN_netscape_ca_policy_url}
  SN_netscape_ca_policy_url = 'nsCaPolicyUrl';  {Do not localize}
  {$EXTERNALSYM SN_netscape_ca_revocation_url}
  SN_netscape_ca_revocation_url = 'nsCaRevocationUrl';  {Do not localize}
  {$EXTERNALSYM SN_netscape_cert_extension}
  SN_netscape_cert_extension = 'nsCertExt';  {Do not localize}
  {$EXTERNALSYM SN_netscape_cert_sequence}
  SN_netscape_cert_sequence = 'nsCertSequence';  {Do not localize}
  {$EXTERNALSYM SN_netscape_cert_type}
  SN_netscape_cert_type = 'nsCertType';  {Do not localize}
  {$EXTERNALSYM SN_netscape_comment}
  SN_netscape_comment = 'nsComment';  {Do not localize}
  {$EXTERNALSYM SN_netscape_data_type}
  SN_netscape_data_type = 'nsDataType';  {Do not localize}
  {$EXTERNALSYM SN_netscape_renewal_url}
  SN_netscape_renewal_url = 'nsRenewalUrl';  {Do not localize}
  {$EXTERNALSYM SN_netscape_revocation_url}
  SN_netscape_revocation_url = 'nsRevocationUrl';  {Do not localize}
  {$EXTERNALSYM SN_netscape_ssl_server_name}
  SN_netscape_ssl_server_name = 'nsSslServerName';  {Do not localize}
  {$EXTERNALSYM SN_ns_sgc}
  SN_ns_sgc = 'nsSGC';  {Do not localize}
  {$EXTERNALSYM SN_organizationName}
  SN_organizationName = 'O';  {Do not localize}
  {$EXTERNALSYM SN_organizationalUnitName}
  SN_organizationalUnitName = 'OU';  {Do not localize}
  {$EXTERNALSYM SN_pkcs9_emailAddress}
  SN_pkcs9_emailAddress = 'Email';  {Do not localize}
  {$EXTERNALSYM SN_private_key_usage_period}
  SN_private_key_usage_period = 'privateKeyUsagePeriod';  {Do not localize}
  {$EXTERNALSYM SN_rc2_40_cbc}
  SN_rc2_40_cbc = 'RC2-40-CBC';  {Do not localize}
  {$EXTERNALSYM SN_rc2_64_cbc}
  SN_rc2_64_cbc = 'RC2-64-CBC';  {Do not localize}
  {$EXTERNALSYM SN_rc2_cbc}
  SN_rc2_cbc = 'RC2-CBC';  {Do not localize}
  {$EXTERNALSYM SN_rc2_cfb64}
  SN_rc2_cfb64 = 'RC2-CFB';  {Do not localize}
  {$EXTERNALSYM SN_rc2_ecb}
  SN_rc2_ecb = 'RC2-ECB';  {Do not localize}
  {$EXTERNALSYM SN_rc2_ofb64}
  SN_rc2_ofb64 = 'RC2-OFB';  {Do not localize}
  {$EXTERNALSYM SN_rc4}
  SN_rc4 = 'RC4';  {Do not localize}
  {$EXTERNALSYM SN_rc4_40}
  SN_rc4_40 = 'RC4-40';  {Do not localize}
  {$EXTERNALSYM SN_rc5_cbc}
  SN_rc5_cbc = 'RC5-CBC';  {Do not localize}
  {$EXTERNALSYM SN_rc5_cfb64}
  SN_rc5_cfb64 = 'RC5-CFB';  {Do not localize}
  {$EXTERNALSYM SN_rc5_ecb}
  SN_rc5_ecb = 'RC5-ECB';  {Do not localize}
  {$EXTERNALSYM SN_rc5_ofb64}
  SN_rc5_ofb64 = 'RC5-OFB';  {Do not localize}
  {$EXTERNALSYM SN_ripemd160}
  SN_ripemd160 = 'RIPEMD160';  {Do not localize}
  {$EXTERNALSYM SN_ripemd160WithRSA}
  SN_ripemd160WithRSA = 'RSA-RIPEMD160';  {Do not localize}
  {$EXTERNALSYM SN_rle_compression}
  SN_rle_compression = 'RLE';  {Do not localize}
  {$EXTERNALSYM SN_rsa}
  SN_rsa = 'RSA';  {Do not localize}
  {$EXTERNALSYM SN_serialNumber}
  SN_serialNumber = 'SN';  {Do not localize}
  {$EXTERNALSYM SN_server_auth}
  SN_server_auth = 'serverAuth';  {Do not localize}
  {$EXTERNALSYM SN_sha}
  SN_sha = 'SHA';  {Do not localize}
  {$EXTERNALSYM SN_sha1}
  SN_sha1 = 'SHA1';  {Do not localize}
  {$EXTERNALSYM SN_sha1WithRSA}
  SN_sha1WithRSA = 'RSA-SHA1-2';  {Do not localize}
  {$EXTERNALSYM SN_sha1WithRSAEncryption}
  SN_sha1WithRSAEncryption = 'RSA-SHA1';  {Do not localize}
  {$EXTERNALSYM SN_shaWithRSAEncryption}
  SN_shaWithRSAEncryption = 'RSA-SHA';  {Do not localize}
  {$EXTERNALSYM SN_stateOrProvinceName}
  SN_stateOrProvinceName = 'ST';  {Do not localize}
  {$EXTERNALSYM SN_subject_alt_name}
  SN_subject_alt_name = 'subjectAltName';  {Do not localize}
  {$EXTERNALSYM SN_subject_key_identifier}
  SN_subject_key_identifier = 'subjectKeyIdentifier';  {Do not localize}
  {$EXTERNALSYM SN_surname}
  SN_surname = 'S';  {Do not localize}
  {$EXTERNALSYM SN_sxnet}
  SN_sxnet = 'SXNetID';  {Do not localize}
  {$EXTERNALSYM SN_time_stamp}
  SN_time_stamp = 'timeStamping';  {Do not localize}
  {$EXTERNALSYM SN_title}
  SN_title = 'T';  {Do not localize}
  {$EXTERNALSYM SN_undef}
  SN_undef = 'UNDEF';  {Do not localize}
  {$EXTERNALSYM SN_uniqueIdentifier}
  SN_uniqueIdentifier = 'UID';  {Do not localize}
  {$EXTERNALSYM SN_zlib_compression}
  SN_zlib_compression = 'ZLIB';  {Do not localize}
  {$EXTERNALSYM OCSP_DEFAULT_NONCE_LENGTH}
  OCSP_DEFAULT_NONCE_LENGTH	= 16;
  {$EXTERNALSYM OCSP_NOCERTS}
  OCSP_NOCERTS = $1;
  {$EXTERNALSYM OCSP_NOINTERN}
  OCSP_NOINTERN	= $2;
  {$EXTERNALSYM OCSP_NOSIGS}
  OCSP_NOSIGS	= $4;
  {$EXTERNALSYM OCSP_NOCHAIN}
  OCSP_NOCHAIN = $8;
  {$EXTERNALSYM OCSP_NOVERIFY}
  OCSP_NOVERIFY = $10;
  {$EXTERNALSYM OCSP_NOEXPLICIT}
  OCSP_NOEXPLICIT = $20;
  {$EXTERNALSYM OCSP_NOCASIGN}
  OCSP_NOCASIGN	= $40;
  {$EXTERNALSYM OCSP_NODELEGATED}
  OCSP_NODELEGATED = $80;
  {$EXTERNALSYM OCSP_NOCHECKS}
  OCSP_NOCHECKS	= $100;
  {$EXTERNALSYM OCSP_TRUSTOTHER}
  OCSP_TRUSTOTHER	= $200;
  {$EXTERNALSYM OCSP_RESPID_KEY}
  OCSP_RESPID_KEY	= $400;
  {$EXTERNALSYM OCSP_NOTIME}
  OCSP_NOTIME	= $800;
  {$EXTERNALSYM OCSP_RESPONSE_STATUS_SUCCESSFUL}
  OCSP_RESPONSE_STATUS_SUCCESSFUL          = 0;
  {$EXTERNALSYM OCSP_RESPONSE_STATUS_MALFORMEDREQUEST}
  OCSP_RESPONSE_STATUS_MALFORMEDREQUEST    = 1;
  {$EXTERNALSYM OCSP_RESPONSE_STATUS_INTERNALERROR}
  OCSP_RESPONSE_STATUS_INTERNALERROR       = 2;
  {$EXTERNALSYM OCSP_RESPONSE_STATUS_TRYLATER}
  OCSP_RESPONSE_STATUS_TRYLATER            = 3;
  {$EXTERNALSYM OCSP_RESPONSE_STATUS_SIGREQUIRED}
  OCSP_RESPONSE_STATUS_SIGREQUIRED         = 5;
  {$EXTERNALSYM OCSP_RESPONSE_STATUS_UNAUTHORIZED}
  OCSP_RESPONSE_STATUS_UNAUTHORIZED        = 6;
  {$EXTERNALSYM OCSP_REVOKED_STATUS_NOSTATUS}
  OCSP_REVOKED_STATUS_NOSTATUS             = -1;
  {$EXTERNALSYM OCSP_REVOKED_STATUS_UNSPECIFIED}
  OCSP_REVOKED_STATUS_UNSPECIFIED           = 0;
  {$EXTERNALSYM OCSP_REVOKED_STATUS_KEYCOMPROMISE}
  OCSP_REVOKED_STATUS_KEYCOMPROMISE         = 1;
  {$EXTERNALSYM OCSP_REVOKED_STATUS_CACOMPROMISE}
  OCSP_REVOKED_STATUS_CACOMPROMISE          = 2;
  {$EXTERNALSYM OCSP_REVOKED_STATUS_AFFILIATIONCHANGED}
  OCSP_REVOKED_STATUS_AFFILIATIONCHANGED    = 3;
  {$EXTERNALSYM OCSP_REVOKED_STATUS_SUPERSEDED}
  OCSP_REVOKED_STATUS_SUPERSEDED            = 4;
  {$EXTERNALSYM OCSP_REVOKED_STATUS_CESSATIONOFOPERATION}
  OCSP_REVOKED_STATUS_CESSATIONOFOPERATION  = 5;
  {$EXTERNALSYM OCSP_REVOKED_STATUS_CERTIFICATEHOLD}
  OCSP_REVOKED_STATUS_CERTIFICATEHOLD       = 6;
  {$EXTERNALSYM OCSP_REVOKED_STATUS_REMOVEFROMCRL}
  OCSP_REVOKED_STATUS_REMOVEFROMCRL         = 8;
  {$EXTERNALSYM V_OCSP_CERTSTATUS_GOOD}
  V_OCSP_CERTSTATUS_GOOD    = 0;
  {$EXTERNALSYM V_OCSP_CERTSTATUS_REVOKED}
  V_OCSP_CERTSTATUS_REVOKED = 1;
  {$EXTERNALSYM V_OCSP_CERTSTATUS_UNKNOWN}
  V_OCSP_CERTSTATUS_UNKNOWN = 2;
  {$EXTERNALSYM OCSP_F_ASN1_STRING_ENCODE}
  OCSP_F_ASN1_STRING_ENCODE		   	= 100;
  {$EXTERNALSYM OCSP_F_D2I_OCSP_NONCE}
  OCSP_F_D2I_OCSP_NONCE				    = 102;
  {$EXTERNALSYM OCSP_F_OCSP_BASIC_ADD1_STATUS}
  OCSP_F_OCSP_BASIC_ADD1_STATUS	  = 103;
  {$EXTERNALSYM OCSP_F_OCSP_BASIC_SIGN}
  OCSP_F_OCSP_BASIC_SIGN			    = 104;
  {$EXTERNALSYM OCSP_F_OCSP_BASIC_VERIFY}
  OCSP_F_OCSP_BASIC_VERIFY  		  = 105;
  {$EXTERNALSYM OCSP_F_OCSP_CERT_ID_NEW}
  OCSP_F_OCSP_CERT_ID_NEW		  	  = 101;
  {$EXTERNALSYM OCSP_F_OCSP_CHECK_DELEGATED}
  OCSP_F_OCSP_CHECK_DELEGATED	    = 106;
  {$EXTERNALSYM OCSP_F_OCSP_CHECK_IDS}
  OCSP_F_OCSP_CHECK_IDS				    = 107;
  {$EXTERNALSYM OCSP_F_OCSP_CHECK_ISSUER}
  OCSP_F_OCSP_CHECK_ISSUER		    = 108;
  {$EXTERNALSYM OCSP_F_OCSP_CHECK_VALIDITY}
  OCSP_F_OCSP_CHECK_VALIDITY	    = 115;
  {$EXTERNALSYM OCSP_F_OCSP_MATCH_ISSUERID}
  OCSP_F_OCSP_MATCH_ISSUERID	    = 109;
  {$EXTERNALSYM OCSP_F_OCSP_PARSE_URL}
  OCSP_F_OCSP_PARSE_URL				    = 114;
  {$EXTERNALSYM OCSP_F_OCSP_REQUEST_SIGN}
  OCSP_F_OCSP_REQUEST_SIGN		    = 110;
  {$EXTERNALSYM OCSP_F_OCSP_REQUEST_VERIFY}
  OCSP_F_OCSP_REQUEST_VERIFY			= 116;
  {$EXTERNALSYM OCSP_F_OCSP_RESPONSE_GET1_BASIC}
  OCSP_F_OCSP_RESPONSE_GET1_BASIC	= 111;
  {$EXTERNALSYM OCSP_F_OCSP_SENDREQ_BIO}
  OCSP_F_OCSP_SENDREQ_BIO			    = 112;
  {$EXTERNALSYM OCSP_F_PARSE_HTTP_LINE1}
  OCSP_F_PARSE_HTTP_LINE1		      = 117;
  {$EXTERNALSYM OCSP_F_REQUEST_VERIFY}
  OCSP_F_REQUEST_VERIFY	          = 113;
//* Reason codes. */
  {$EXTERNALSYM OCSP_R_BAD_DATA}
  OCSP_R_BAD_DATA					= 100;
  {$EXTERNALSYM OCSP_R_CERTIFICATE_VERIFY_ERROR}
  OCSP_R_CERTIFICATE_VERIFY_ERROR			= 101;
  {$EXTERNALSYM OCSP_R_DIGEST_ERR}
  OCSP_R_DIGEST_ERR				= 102;
  {$EXTERNALSYM OCSP_R_ERROR_IN_NEXTUPDATE_FIELD}
  OCSP_R_ERROR_IN_NEXTUPDATE_FIELD		= 122;
  {$EXTERNALSYM OCSP_R_ERROR_IN_THISUPDATE_FIELD}
  OCSP_R_ERROR_IN_THISUPDATE_FIELD		= 123;
  {$EXTERNALSYM OCSP_R_ERROR_PARSING_URL}
  OCSP_R_ERROR_PARSING_URL			= 121;
  {$EXTERNALSYM OCSP_R_MISSING_OCSPSIGNING_USAGE}
  OCSP_R_MISSING_OCSPSIGNING_USAGE		= 103;
  {$EXTERNALSYM OCSP_R_NEXTUPDATE_BEFORE_THISUPDATE}
  OCSP_R_NEXTUPDATE_BEFORE_THISUPDATE		= 124;
  {$EXTERNALSYM OCSP_R_NOT_BASIC_RESPONSE}
  OCSP_R_NOT_BASIC_RESPONSE			= 104;
  {$EXTERNALSYM OCSP_R_NO_CERTIFICATES_IN_CHAIN}
  OCSP_R_NO_CERTIFICATES_IN_CHAIN			= 105;
  {$EXTERNALSYM OCSP_R_NO_CONTENT}
  OCSP_R_NO_CONTENT				 = 106;
  {$EXTERNALSYM OCSP_R_NO_PUBLIC_KEY}
  OCSP_R_NO_PUBLIC_KEY				= 107;
  {$EXTERNALSYM OCSP_R_NO_RESPONSE_DATA}
  OCSP_R_NO_RESPONSE_DATA			= 108;
  {$EXTERNALSYM OCSP_R_NO_REVOKED_TIME}
  OCSP_R_NO_REVOKED_TIME			= 109;
  {$EXTERNALSYM OCSP_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE}
  OCSP_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE	= 110;
  {$EXTERNALSYM OCSP_R_REQUEST_NOT_SIGNED}
  OCSP_R_REQUEST_NOT_SIGNED		 = 128;
  {$EXTERNALSYM OCSP_R_RESPONSE_CONTAINS_NO_REVOCATION_DATA}
  OCSP_R_RESPONSE_CONTAINS_NO_REVOCATION_DATA	 = 111;
  {$EXTERNALSYM OCSP_R_ROOT_CA_NOT_TRUSTED}
  OCSP_R_ROOT_CA_NOT_TRUSTED		 = 112;
  {$EXTERNALSYM OCSP_R_SERVER_READ_ERROR}
  OCSP_R_SERVER_READ_ERROR			 = 113;
  {$EXTERNALSYM OCSP_R_SERVER_RESPONSE_ERROR}
  OCSP_R_SERVER_RESPONSE_ERROR	 = 114;
  {$EXTERNALSYM OCSP_R_SERVER_RESPONSE_PARSE_ERROR}
  OCSP_R_SERVER_RESPONSE_PARSE_ERROR = 115;
  {$EXTERNALSYM OCSP_R_SERVER_WRITE_ERROR}
  OCSP_R_SERVER_WRITE_ERROR		 = 116;
  {$EXTERNALSYM OCSP_R_SIGNATURE_FAILURE}
  OCSP_R_SIGNATURE_FAILURE		 = 117;
  {$EXTERNALSYM OCSP_R_SIGNER_CERTIFICATE_NOT_FOUND}
  OCSP_R_SIGNER_CERTIFICATE_NOT_FOUND		= 118;
  {$EXTERNALSYM OCSP_R_STATUS_EXPIRED}
  OCSP_R_STATUS_EXPIRED				 = 125;
  {$EXTERNALSYM OCSP_R_STATUS_NOT_YET_VALID}
  OCSP_R_STATUS_NOT_YET_VALID	 = 126;
  {$EXTERNALSYM OCSP_R_STATUS_TOO_OLD}
  OCSP_R_STATUS_TOO_OLD				 = 127;
  {$EXTERNALSYM OCSP_R_UNKNOWN_MESSAGE_DIGEST}
  OCSP_R_UNKNOWN_MESSAGE_DIGEST	= 119;
  {$EXTERNALSYM OCSP_R_UNKNOWN_NID}
  OCSP_R_UNKNOWN_NID			  = 120;
  {$EXTERNALSYM OCSP_R_UNSUPPORTED_REQUESTORNAME_TYPE}
  OCSP_R_UNSUPPORTED_REQUESTORNAME_TYPE	= 129;
  {$EXTERNALSYM SSL_ST_CONNECT}
  SSL_ST_CONNECT = $1000;
  {$EXTERNALSYM SSL_ST_ACCEPT}
  SSL_ST_ACCEPT = $2000;
  {$EXTERNALSYM SSL_ST_MASK}
  SSL_ST_MASK = $0FFF;
  {$EXTERNALSYM SSL_ST_INIT}
  SSL_ST_INIT = SSL_ST_CONNECT or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL_ST_BEFORE}
  SSL_ST_BEFORE = $4000;
  {$EXTERNALSYM SSL_ST_OK}
  SSL_ST_OK = $03;
  {$EXTERNALSYM SSL_ST_RENEGOTIATE}
  SSL_ST_RENEGOTIATE = $04 or SSL_ST_INIT;
  {$EXTERNALSYM SSL_CB_LOOP}
  SSL_CB_LOOP = $01;
  {$EXTERNALSYM SSL_CB_EXIT}
  SSL_CB_EXIT = $02;
  {$EXTERNALSYM SSL_CB_READ}
  SSL_CB_READ = $04;
  {$EXTERNALSYM SSL_CB_WRITE}
  SSL_CB_WRITE = $08;
  {$EXTERNALSYM SSL_CB_ALERT}
  SSL_CB_ALERT = $4000;

  {$EXTERNALSYM SSL_CB_READ_ALERT}
  SSL_CB_READ_ALERT = SSL_CB_ALERT or SSL_CB_READ;
  {$EXTERNALSYM SSL_CB_WRITE_ALERT}
  SSL_CB_WRITE_ALERT = SSL_CB_ALERT or SSL_CB_WRITE;
  {$EXTERNALSYM SSL_CB_ACCEPT_LOOP}
  SSL_CB_ACCEPT_LOOP = SSL_ST_ACCEPT or SSL_CB_LOOP;
  {$EXTERNALSYM SSL_CB_ACCEPT_EXIT}
  SSL_CB_ACCEPT_EXIT = SSL_ST_ACCEPT or SSL_CB_EXIT;
  {$EXTERNALSYM SSL_CB_CONNECT_LOOP}
  SSL_CB_CONNECT_LOOP = SSL_ST_CONNECT or SSL_CB_LOOP;
  {$EXTERNALSYM SSL_CB_CONNECT_EXIT}
  SSL_CB_CONNECT_EXIT = SSL_ST_CONNECT or SSL_CB_EXIT;
  {$EXTERNALSYM SSL_CB_HANDSHAKE_START}
  SSL_CB_HANDSHAKE_START = $10;
  {$EXTERNALSYM SSL_CB_HANDSHAKE_DONE}
  SSL_CB_HANDSHAKE_DONE = $20;
  {$EXTERNALSYM SSL_ST_READ_BODY}
  SSL_ST_READ_BODY = $F1;
  {$EXTERNALSYM SSL_ST_READ_DONE}
  SSL_ST_READ_DONE = $F2;
  {$EXTERNALSYM SSL_ST_READ_HEADER}
  SSL_ST_READ_HEADER = $F0;

  {$EXTERNALSYM SSL23_ST_CR_SRVR_HELLO_A}
  SSL23_ST_CR_SRVR_HELLO_A = $220 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL23_ST_CR_SRVR_HELLO_B}
  SSL23_ST_CR_SRVR_HELLO_B = $221 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL23_ST_CW_CLNT_HELLO_A}
  SSL23_ST_CW_CLNT_HELLO_A = $210 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL23_ST_CW_CLNT_HELLO_B}
  SSL23_ST_CW_CLNT_HELLO_B = $211 or SSL_ST_CONNECT;

  {$EXTERNALSYM SSL23_ST_SR_CLNT_HELLO_A}
  SSL23_ST_SR_CLNT_HELLO_A = $210 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL23_ST_SR_CLNT_HELLO_B}
  SSL23_ST_SR_CLNT_HELLO_B = $211 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_AT_MD5_WITH_RSA_ENCRYPTION}
  SSL2_AT_MD5_WITH_RSA_ENCRYPTION = $01;
  {$EXTERNALSYM SSL2_CF_5_BYTE_ENC}
  SSL2_CF_5_BYTE_ENC = $01;
  {$EXTERNALSYM SSL2_CF_8_BYTE_ENC}
  SSL2_CF_8_BYTE_ENC = $02;
  {$EXTERNALSYM SSL2_CHALLENGE_LENGTH}
  SSL2_CHALLENGE_LENGTH = 16;
  {$EXTERNALSYM SSL2_CK_DES_192_EDE3_CBC_WITH_MD5}
  SSL2_CK_DES_192_EDE3_CBC_WITH_MD5 = $020700c0;
  {$EXTERNALSYM SSL2_CK_DES_192_EDE3_CBC_WITH_SHA}
  SSL2_CK_DES_192_EDE3_CBC_WITH_SHA = $020701c0;
  {$EXTERNALSYM SSL2_CK_DES_64_CBC_WITH_MD5}
  SSL2_CK_DES_64_CBC_WITH_MD5 = $02060040;
  {$EXTERNALSYM SSL2_CK_DES_64_CBC_WITH_SHA}
  SSL2_CK_DES_64_CBC_WITH_SHA = $02060140;
  {$EXTERNALSYM SSL2_CK_DES_64_CFB64_WITH_MD5_1}
  SSL2_CK_DES_64_CFB64_WITH_MD5_1 = $02ff0800;
  {$EXTERNALSYM SSL2_CK_IDEA_128_CBC_WITH_MD5}
  SSL2_CK_IDEA_128_CBC_WITH_MD5 = $02050080;
  {$EXTERNALSYM SSL2_CK_NULL}
  SSL2_CK_NULL = $02ff0810;
  {$EXTERNALSYM SSL2_CK_NULL_WITH_MD5}
  SSL2_CK_NULL_WITH_MD5 = $02000000;
  {$EXTERNALSYM SSL2_CK_RC2_128_CBC_EXPORT40_WITH_MD5}
  SSL2_CK_RC2_128_CBC_EXPORT40_WITH_MD5 = $02040080;
  {$EXTERNALSYM SSL2_CK_RC2_128_CBC_WITH_MD5}
  SSL2_CK_RC2_128_CBC_WITH_MD5 = $02030080;
  {$EXTERNALSYM SSL2_CK_RC4_128_EXPORT40_WITH_MD5}
  SSL2_CK_RC4_128_EXPORT40_WITH_MD5 = $02020080;
  {$EXTERNALSYM SSL2_CK_RC4_128_WITH_MD5}
  SSL2_CK_RC4_128_WITH_MD5 = $02010080;
  {$EXTERNALSYM SSL2_CK_RC4_64_WITH_MD5}
  SSL2_CK_RC4_64_WITH_MD5 = $02080080;
  {$EXTERNALSYM SSL2_CONNECTION_ID_LENGTH}
  SSL2_CONNECTION_ID_LENGTH = 16;
  {$EXTERNALSYM SSL2_CT_X509_CERTIFICATE}
  SSL2_CT_X509_CERTIFICATE = $01;
  {$EXTERNALSYM SSL2_MAX_CERT_CHALLENGE_LENGTH}
  SSL2_MAX_CERT_CHALLENGE_LENGTH = 32;
  {$EXTERNALSYM SSL2_MAX_CHALLENGE_LENGTH}
  SSL2_MAX_CHALLENGE_LENGTH = 32;
  {$EXTERNALSYM SSL2_MAX_CONNECTION_ID_LENGTH}
  SSL2_MAX_CONNECTION_ID_LENGTH = 16;
  {$EXTERNALSYM SSL2_MAX_KEY_MATERIAL_LENGTH}
  SSL2_MAX_KEY_MATERIAL_LENGTH = 24;
  {$EXTERNALSYM SSL2_MAX_MASTER_KEY_LENGTH_IN_BITS}
  SSL2_MAX_MASTER_KEY_LENGTH_IN_BITS = 256;
  {$EXTERNALSYM SSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER}
  SSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER = 16383;
  {$EXTERNALSYM SSL2_MAX_SSL_SESSION_ID_LENGTH}
  SSL2_MAX_SSL_SESSION_ID_LENGTH = 32;
  {$EXTERNALSYM SSL2_MIN_CERT_CHALLENGE_LENGTH}
  SSL2_MIN_CERT_CHALLENGE_LENGTH = 16;
  {$EXTERNALSYM SSL2_MIN_CHALLENGE_LENGTH}
  SSL2_MIN_CHALLENGE_LENGTH = 16;
  {$EXTERNALSYM SSL2_MT_CLIENT_CERTIFICATE}
  SSL2_MT_CLIENT_CERTIFICATE = 8;
  {$EXTERNALSYM SSL2_MT_CLIENT_FINISHED}
  SSL2_MT_CLIENT_FINISHED = 3;
  {$EXTERNALSYM SSL2_MT_CLIENT_HELLO}
  SSL2_MT_CLIENT_HELLO = 1;
  {$EXTERNALSYM SSL2_MT_CLIENT_MASTER_KEY}
  SSL2_MT_CLIENT_MASTER_KEY = 2;
  {$EXTERNALSYM SSL2_MT_ERROR}
  SSL2_MT_ERROR = 0;
  {$EXTERNALSYM SSL2_MT_REQUEST_CERTIFICATE}
  SSL2_MT_REQUEST_CERTIFICATE = 7;
  {$EXTERNALSYM SSL2_MT_SERVER_FINISHED}
  SSL2_MT_SERVER_FINISHED = 6;
  {$EXTERNALSYM SSL2_MT_SERVER_HELLO}
  SSL2_MT_SERVER_HELLO = 4;
  {$EXTERNALSYM SSL2_MT_SERVER_VERIFY}
  SSL2_MT_SERVER_VERIFY = 5;
  {$EXTERNALSYM SSL2_PE_BAD_CERTIFICATE}
  SSL2_PE_BAD_CERTIFICATE = $0004;
  {$EXTERNALSYM SSL2_PE_NO_CERTIFICATE}
  SSL2_PE_NO_CERTIFICATE = $0002;
  {$EXTERNALSYM SSL2_PE_NO_CIPHER}
  SSL2_PE_NO_CIPHER = $0001;
  {$EXTERNALSYM SSL2_PE_UNDEFINED_ERROR}
  SSL2_PE_UNDEFINED_ERROR = $0000;
  {$EXTERNALSYM SSL2_PE_UNSUPPORTED_CERTIFICATE_TYPE}
  SSL2_PE_UNSUPPORTED_CERTIFICATE_TYPE = $0006;
  {$EXTERNALSYM SSL2_SSL_SESSION_ID_LENGTH}
  SSL2_SSL_SESSION_ID_LENGTH = 16;
  {$EXTERNALSYM SSL2_ST_CLIENT_START_ENCRYPTION}
  SSL2_ST_CLIENT_START_ENCRYPTION = $80 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_GET_CLIENT_FINISHED_A}
  SSL2_ST_GET_CLIENT_FINISHED_A = $50 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_GET_CLIENT_FINISHED_B}
  SSL2_ST_GET_CLIENT_FINISHED_B = $51 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_GET_CLIENT_HELLO_A}
  SSL2_ST_GET_CLIENT_HELLO_A = $10 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_GET_CLIENT_HELLO_B}
  SSL2_ST_GET_CLIENT_HELLO_B = $11 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_GET_CLIENT_HELLO_C}
  SSL2_ST_GET_CLIENT_HELLO_C = $12 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_GET_CLIENT_MASTER_KEY_A}
  SSL2_ST_GET_CLIENT_MASTER_KEY_A = $30 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_GET_CLIENT_MASTER_KEY_B}
  SSL2_ST_GET_CLIENT_MASTER_KEY_B = $31 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_GET_SERVER_FINISHED_A}
  SSL2_ST_GET_SERVER_FINISHED_A = $70 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_GET_SERVER_FINISHED_B}
  SSL2_ST_GET_SERVER_FINISHED_B = $71 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_GET_SERVER_HELLO_A}
  SSL2_ST_GET_SERVER_HELLO_A = $20 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_GET_SERVER_HELLO_B}
  SSL2_ST_GET_SERVER_HELLO_B = $21 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_GET_SERVER_VERIFY_A}
  SSL2_ST_GET_SERVER_VERIFY_A = $60 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_GET_SERVER_VERIFY_B}
  SSL2_ST_GET_SERVER_VERIFY_B = $61 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_CLIENT_CERTIFICATE_A}
  SSL2_ST_SEND_CLIENT_CERTIFICATE_A = $50 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_CLIENT_CERTIFICATE_B}
  SSL2_ST_SEND_CLIENT_CERTIFICATE_B = $51 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_CLIENT_CERTIFICATE_C}
  SSL2_ST_SEND_CLIENT_CERTIFICATE_C = $52 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_CLIENT_CERTIFICATE_D}
  SSL2_ST_SEND_CLIENT_CERTIFICATE_D = $53 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_CLIENT_FINISHED_A}
  SSL2_ST_SEND_CLIENT_FINISHED_A = $40 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_CLIENT_FINISHED_B}
  SSL2_ST_SEND_CLIENT_FINISHED_B = $41 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_CLIENT_HELLO_A}
  SSL2_ST_SEND_CLIENT_HELLO_A = $10 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_CLIENT_HELLO_B}
  SSL2_ST_SEND_CLIENT_HELLO_B = $11 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_CLIENT_MASTER_KEY_A}
  SSL2_ST_SEND_CLIENT_MASTER_KEY_A = $30 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_CLIENT_MASTER_KEY_B}
  SSL2_ST_SEND_CLIENT_MASTER_KEY_B = $31 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_SEND_REQUEST_CERTIFICATE_A}
  SSL2_ST_SEND_REQUEST_CERTIFICATE_A = $70 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SEND_REQUEST_CERTIFICATE_B}
  SSL2_ST_SEND_REQUEST_CERTIFICATE_B = $71 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SEND_REQUEST_CERTIFICATE_C}
  SSL2_ST_SEND_REQUEST_CERTIFICATE_C = $72 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SEND_REQUEST_CERTIFICATE_D}
  SSL2_ST_SEND_REQUEST_CERTIFICATE_D = $73 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SEND_SERVER_FINISHED_A}
  SSL2_ST_SEND_SERVER_FINISHED_A = $60 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SEND_SERVER_FINISHED_B}
  SSL2_ST_SEND_SERVER_FINISHED_B = $61 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SEND_SERVER_HELLO_A}
  SSL2_ST_SEND_SERVER_HELLO_A = $20 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SEND_SERVER_HELLO_B}
  SSL2_ST_SEND_SERVER_HELLO_B = $21 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SEND_SERVER_VERIFY_A}
  SSL2_ST_SEND_SERVER_VERIFY_A = $40 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SEND_SERVER_VERIFY_B}
  SSL2_ST_SEND_SERVER_VERIFY_B = $41 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SEND_SERVER_VERIFY_C}
  SSL2_ST_SEND_SERVER_VERIFY_C = $42 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_SERVER_START_ENCRYPTION}
  SSL2_ST_SERVER_START_ENCRYPTION = $80 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_ST_X509_GET_CLIENT_CERTIFICATE}
  SSL2_ST_X509_GET_CLIENT_CERTIFICATE = $90 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL2_ST_X509_GET_SERVER_CERTIFICATE}
  SSL2_ST_X509_GET_SERVER_CERTIFICATE = $90 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL2_TXT_DES_192_EDE3_CBC_WITH_MD5}
  SSL2_TXT_DES_192_EDE3_CBC_WITH_MD5 = 'DES-CBC3-MD5';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_DES_192_EDE3_CBC_WITH_SHA}
  SSL2_TXT_DES_192_EDE3_CBC_WITH_SHA = 'DES-CBC3-SHA';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_DES_64_CBC_WITH_MD5}
  SSL2_TXT_DES_64_CBC_WITH_MD5 = 'DES-CBC-MD5';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_DES_64_CBC_WITH_SHA}
  SSL2_TXT_DES_64_CBC_WITH_SHA = 'DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_DES_64_CFB64_WITH_MD5_1}
  SSL2_TXT_DES_64_CFB64_WITH_MD5_1 = 'DES-CFB-M1';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_IDEA_128_CBC_WITH_MD5}
  SSL2_TXT_IDEA_128_CBC_WITH_MD5 = 'IDEA-CBC-MD5';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_NULL}
  SSL2_TXT_NULL = 'NULL';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_NULL_WITH_MD5}
  SSL2_TXT_NULL_WITH_MD5 = 'NULL-MD5';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_RC2_128_CBC_EXPORT40_WITH_MD5}
  SSL2_TXT_RC2_128_CBC_EXPORT40_WITH_MD5 = 'EXP-RC2-CBC-MD5';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_RC2_128_CBC_WITH_MD5}
  SSL2_TXT_RC2_128_CBC_WITH_MD5 = 'RC2-CBC-MD5';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_RC4_128_EXPORT40_WITH_MD5}
  SSL2_TXT_RC4_128_EXPORT40_WITH_MD5 = 'EXP-RC4-MD5';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_RC4_128_WITH_MD5}
  SSL2_TXT_RC4_128_WITH_MD5 = 'RC4-MD5';  {Do not localize}
  {$EXTERNALSYM SSL2_TXT_RC4_64_WITH_MD5}
  SSL2_TXT_RC4_64_WITH_MD5 = 'RC4-64-MD5';  {Do not localize}
  {$EXTERNALSYM SSL2_VERSION}
  SSL2_VERSION = $0002;
  {$EXTERNALSYM SSL2_VERSION_MAJOR}
  SSL2_VERSION_MAJOR = $00;
  {$EXTERNALSYM SSL2_VERSION_MINOR}
  SSL2_VERSION_MINOR = $02;
  {$EXTERNALSYM SSL3_AD_BAD_CERTIFICATE}
  SSL3_AD_BAD_CERTIFICATE = 42;
  {$EXTERNALSYM SSL3_AD_BAD_RECORD_MAC}
  SSL3_AD_BAD_RECORD_MAC = 20;
  {$EXTERNALSYM SSL3_AD_CERTIFICATE_EXPIRED}
  SSL3_AD_CERTIFICATE_EXPIRED = 45;
  {$EXTERNALSYM SSL3_AD_CERTIFICATE_REVOKED}
  SSL3_AD_CERTIFICATE_REVOKED = 44;
  {$EXTERNALSYM SSL3_AD_CERTIFICATE_UNKNOWN}
  SSL3_AD_CERTIFICATE_UNKNOWN = 46;
  {$EXTERNALSYM SSL3_AD_CLOSE_NOTIFY}
  SSL3_AD_CLOSE_NOTIFY = 0;
  {$EXTERNALSYM SSL3_AD_DECOMPRESSION_FAILURE}
  SSL3_AD_DECOMPRESSION_FAILURE = 30;
  {$EXTERNALSYM SSL3_AD_HANDSHAKE_FAILURE}
  SSL3_AD_HANDSHAKE_FAILURE = 40;
  {$EXTERNALSYM SSL3_AD_ILLEGAL_PARAMETER}
  SSL3_AD_ILLEGAL_PARAMETER = 47;
  {$EXTERNALSYM TLS1_HB_REQUEST}
  TLS1_HB_REQUEST	= 1;
  {$EXTERNALSYM TLS1_HB_RESPONSE}
  TLS1_HB_RESPONSE = 2;
  {$EXTERNALSYM SSL3_AD_NO_CERTIFICATE}
  SSL3_AD_NO_CERTIFICATE = 41;
  {$EXTERNALSYM SSL3_AD_UNEXPECTED_MESSAGE}
  SSL3_AD_UNEXPECTED_MESSAGE = 10;
  {$EXTERNALSYM SSL3_AD_UNSUPPORTED_CERTIFICATE}
  SSL3_AD_UNSUPPORTED_CERTIFICATE = 43;
  {$EXTERNALSYM SSL3_AL_FATAL}
  SSL3_AL_FATAL = 2;
  {$EXTERNALSYM SSL3_AL_WARNING}
  SSL3_AL_WARNING = 1;
  {$EXTERNALSYM SSL3_CC_CLIENT}
  SSL3_CC_CLIENT = $10;
  {$EXTERNALSYM SSL3_CC_READ}
  SSL3_CC_READ = $01;
  {$EXTERNALSYM SSL3_CC_SERVER}
  SSL3_CC_SERVER = $20;
  {$EXTERNALSYM SSL3_CC_WRITE}
  SSL3_CC_WRITE = $02;
  {$EXTERNALSYM SSL3_CHANGE_CIPHER_CLIENT_READ}
  SSL3_CHANGE_CIPHER_CLIENT_READ = SSL3_CC_CLIENT or SSL3_CC_READ;
  {$EXTERNALSYM SSL3_CHANGE_CIPHER_CLIENT_WRITE}
  SSL3_CHANGE_CIPHER_CLIENT_WRITE = SSL3_CC_CLIENT or SSL3_CC_WRITE;
  {$EXTERNALSYM SSL3_CHANGE_CIPHER_SERVER_READ}
  SSL3_CHANGE_CIPHER_SERVER_READ = SSL3_CC_SERVER or SSL3_CC_READ;
  {$EXTERNALSYM SSL3_CHANGE_CIPHER_SERVER_WRITE}
  SSL3_CHANGE_CIPHER_SERVER_WRITE = SSL3_CC_SERVER or SSL3_CC_WRITE;
  {$EXTERNALSYM SSL3_CK_ADH_DES_192_CBC_SHA}
  SSL3_CK_ADH_DES_192_CBC_SHA = $0300001B;
  {$EXTERNALSYM SSL3_CK_ADH_DES_40_CBC_SHA}
  SSL3_CK_ADH_DES_40_CBC_SHA = $03000019;
  {$EXTERNALSYM SSL3_CK_ADH_DES_64_CBC_SHA}
  SSL3_CK_ADH_DES_64_CBC_SHA = $0300001A;
  {$EXTERNALSYM SSL3_CK_ADH_RC4_128_MD5}
  SSL3_CK_ADH_RC4_128_MD5 = $03000018;
  {$EXTERNALSYM SSL3_CK_ADH_RC4_40_MD5}
  SSL3_CK_ADH_RC4_40_MD5 = $03000017;
  {$EXTERNALSYM SSL3_CK_DH_DSS_DES_192_CBC3_SHA}
  SSL3_CK_DH_DSS_DES_192_CBC3_SHA = $0300000D;
  {$EXTERNALSYM SSL3_CK_DH_DSS_DES_40_CBC_SHA}
  SSL3_CK_DH_DSS_DES_40_CBC_SHA = $0300000B;
  {$EXTERNALSYM SSL3_CK_DH_DSS_DES_64_CBC_SHA}
  SSL3_CK_DH_DSS_DES_64_CBC_SHA = $0300000C;
  {$EXTERNALSYM SSL3_CK_DH_RSA_DES_192_CBC3_SHA}
  SSL3_CK_DH_RSA_DES_192_CBC3_SHA = $03000010;
  {$EXTERNALSYM SSL3_CK_DH_RSA_DES_40_CBC_SHA}
  SSL3_CK_DH_RSA_DES_40_CBC_SHA = $0300000E;
  {$EXTERNALSYM SSL3_CK_DH_RSA_DES_64_CBC_SHA}
  SSL3_CK_DH_RSA_DES_64_CBC_SHA = $0300000F;
  {$EXTERNALSYM SSL3_CK_EDH_DSS_DES_192_CBC3_SHA}
  SSL3_CK_EDH_DSS_DES_192_CBC3_SHA = $03000013;
  {$EXTERNALSYM SSL3_CK_EDH_DSS_DES_40_CBC_SHA}
  SSL3_CK_EDH_DSS_DES_40_CBC_SHA = $03000011;
  {$EXTERNALSYM SSL3_CK_EDH_DSS_DES_64_CBC_SHA}
  SSL3_CK_EDH_DSS_DES_64_CBC_SHA = $03000012;
  {$EXTERNALSYM SSL3_CK_EDH_RSA_DES_192_CBC3_SHA}
  SSL3_CK_EDH_RSA_DES_192_CBC3_SHA = $03000016;
  {$EXTERNALSYM SSL3_CK_EDH_RSA_DES_40_CBC_SHA}
  SSL3_CK_EDH_RSA_DES_40_CBC_SHA = $03000014;
  {$EXTERNALSYM SSL3_CK_EDH_RSA_DES_64_CBC_SHA}
  SSL3_CK_EDH_RSA_DES_64_CBC_SHA = $03000015;
  {$EXTERNALSYM SSL3_CK_FZA_DMS_FZA_SHA}
  SSL3_CK_FZA_DMS_FZA_SHA = $0300001D;
  {$EXTERNALSYM SSL3_CK_FZA_DMS_NULL_SHA}
  SSL3_CK_FZA_DMS_NULL_SHA = $0300001C;
  {$EXTERNALSYM SSL3_CK_FZA_DMS_RC4_SHA}
  SSL3_CK_FZA_DMS_RC4_SHA = $0300001E;
  {$EXTERNALSYM SSL3_CK_RSA_DES_192_CBC3_SHA}
  SSL3_CK_RSA_DES_192_CBC3_SHA = $0300000A;
  {$EXTERNALSYM SSL3_CK_RSA_DES_40_CBC_SHA}
  SSL3_CK_RSA_DES_40_CBC_SHA = $03000008;
  {$EXTERNALSYM SSL3_CK_RSA_DES_64_CBC_SHA}
  SSL3_CK_RSA_DES_64_CBC_SHA = $03000009;
  {$EXTERNALSYM SSL3_CK_RSA_IDEA_128_SHA}
  SSL3_CK_RSA_IDEA_128_SHA = $03000007;
  //* Signalling cipher suite value: from draft-ietf-tls-renegotiation-03.txt */
  {$EXTERNALSYM SSL3_CK_SCSV}
  SSL3_CK_SCSV	= $030000FF;

  {$EXTERNALSYM SSL3_CK_RSA_NULL_MD5}
  SSL3_CK_RSA_NULL_MD5 = $03000001;
  {$EXTERNALSYM SSL3_CK_RSA_NULL_SHA}
  SSL3_CK_RSA_NULL_SHA = $03000002;
  {$EXTERNALSYM SSL3_CK_RSA_RC2_40_MD5}
  SSL3_CK_RSA_RC2_40_MD5 = $03000006;
  {$EXTERNALSYM SSL3_CK_RSA_RC4_128_MD5}
  SSL3_CK_RSA_RC4_128_MD5 = $03000004;
  {$EXTERNALSYM SSL3_CK_RSA_RC4_128_SHA}
  SSL3_CK_RSA_RC4_128_SHA = $03000005;
  {$EXTERNALSYM SSL3_CK_RSA_RC4_40_MD5}
  SSL3_CK_RSA_RC4_40_MD5 = $03000003;

  {$EXTERNALSYM SSL3_CT_RSA_SIGN}
  SSL3_CT_RSA_SIGN = 1;
  {$EXTERNALSYM SSL3_CT_DSS_SIGN}
  SSL3_CT_DSS_SIGN = 2;
  {$EXTERNALSYM SSL3_CT_RSA_FIXED_DH}
  SSL3_CT_RSA_FIXED_DH = 3;
  {$EXTERNALSYM SSL3_CT_DSS_FIXED_DH}
  SSL3_CT_DSS_FIXED_DH = 4;
  {$EXTERNALSYM SSL3_CT_RSA_EPHEMERAL_DH}
  SSL3_CT_RSA_EPHEMERAL_DH = 5;
  {$EXTERNALSYM SSL3_CT_DSS_EPHEMERAL_DH}
  SSL3_CT_DSS_EPHEMERAL_DH = 6;

  {$EXTERNALSYM SSL3_CT_FORTEZZA_DMS}
  SSL3_CT_FORTEZZA_DMS = 20;
  {$EXTERNALSYM SSL3_CT_NUMBER}
  SSL3_CT_NUMBER = 9; //was 7;

  {$EXTERNALSYM SSL3_FLAGS_DELAY_CLIENT_FINISHED}
  SSL3_FLAGS_DELAY_CLIENT_FINISHED = $0002;
  {$EXTERNALSYM SSL3_FLAGS_NO_RENEGOTIATE_CIPHERS}
  SSL3_FLAGS_NO_RENEGOTIATE_CIPHERS = $0001;
  {$EXTERNALSYM SSL3_FLAGS_POP_BUFFER}
  SSL3_FLAGS_POP_BUFFER = $0004;
  {$EXTERNALSYM TLS1_FLAGS_TLS_PADDING_BUG}
  TLS1_FLAGS_TLS_PADDING_BUG = $0008;
  {$EXTERNALSYM TLS1_FLAGS_SKIP_CERT_VERIFY}
  TLS1_FLAGS_SKIP_CERT_VERIFY = $0010;
  {$EXTERNALSYM TLS1_FLAGS_KEEP_HANDSHAKE}
  TLS1_FLAGS_KEEP_HANDSHAKE	= $0020;

  {* SSL3_FLAGS_SGC_RESTART_DONE is set when we
 * restart a handshake because of MS SGC and so prevents us
 * from restarting the handshake in a loop. It's reset on a
 * renegotiation, so effectively limits the client to one restart
 * per negotiation. This limits the possibility of a DDoS
 * attack where the client handshakes in a loop using SGC to
 * restart. Servers which permit renegotiation can still be
 * effected, but we can't prevent that.
 *}
  {$EXTERNALSYM SSL3_FLAGS_SGC_RESTART_DONE}
  SSL3_FLAGS_SGC_RESTART_DONE = $0040;

  {$EXTERNALSYM SSL3_MASTER_SECRET_SIZE}
  SSL3_MASTER_SECRET_SIZE = 48;
  {$EXTERNALSYM SSL3_MAX_SSL_SESSION_ID_LENGTH}
  SSL3_MAX_SSL_SESSION_ID_LENGTH = 32;
  {$EXTERNALSYM SSL3_MT_HELLO_REQUEST}
  SSL3_MT_HELLO_REQUEST	= 0;
  {$EXTERNALSYM SSL3_MT_CLIENT_REQUEST}
  SSL3_MT_CLIENT_REQUEST = 0;
  {$EXTERNALSYM SSL3_MT_CLIENT_HELLO}
  SSL3_MT_CLIENT_HELLO = 1;
  {$EXTERNALSYM SSL3_MT_SERVER_HELLO}
  SSL3_MT_SERVER_HELLO = 2;
  {$EXTERNALSYM SSL3_MT_NEWSESSION_TICKET}
  SSL3_MT_NEWSESSION_TICKET = 4;
  {$EXTERNALSYM SSL3_MT_CERTIFICATE}
  SSL3_MT_CERTIFICATE = 11;
  {$EXTERNALSYM SSL3_MT_SERVER_KEY_EXCHANGE}
  SSL3_MT_SERVER_KEY_EXCHANGE = 12;
  {$EXTERNALSYM SSL3_MT_CERTIFICATE_REQUEST}
  SSL3_MT_CERTIFICATE_REQUEST = 13;
  {$EXTERNALSYM SSL3_MT_SERVER_DONE}
  SSL3_MT_SERVER_DONE = 14;
  {$EXTERNALSYM SSL3_MT_CERTIFICATE_VERIFY}
  SSL3_MT_CERTIFICATE_VERIFY = 15;
  {$EXTERNALSYM SSL3_MT_CLIENT_KEY_EXCHANGE}
  SSL3_MT_CLIENT_KEY_EXCHANGE = 16;
  {$EXTERNALSYM SSL3_MT_FINISHED}
  SSL3_MT_FINISHED = 20;
  {$EXTERNALSYM SSL3_MT_CERTIFICATE_STATUS}
  SSL3_MT_CERTIFICATE_STATUS = 22;
  {$EXTERNALSYM SSL3_MT_NEXT_PROTO}
  SSL3_MT_NEXT_PROTO = 67;
  {$EXTERNALSYM DTLS1_MT_HELLO_VERIFY_REQUEST}
  DTLS1_MT_HELLO_VERIFY_REQUEST = 3;
  {$EXTERNALSYM SSL3_MT_CCS}
  SSL3_MT_CCS = 1;
  {$EXTERNALSYM SSL3_RANDOM_SIZE}
  SSL3_RANDOM_SIZE = 32;
  {$EXTERNALSYM SSL3_RS_BLANK}
  SSL3_RS_BLANK = 1;
  {$EXTERNALSYM SSL3_RS_ENCODED}
  SSL3_RS_ENCODED = 2;
  {$EXTERNALSYM SSL3_RS_PART_READ}
  SSL3_RS_PART_READ = 4;
  {$EXTERNALSYM SSL3_RS_PART_WRITE}
  SSL3_RS_PART_WRITE = 5;
  {$EXTERNALSYM SSL3_RS_PLAIN}
  SSL3_RS_PLAIN = 3;
  {$EXTERNALSYM SSL3_RS_READ_MORE}
  SSL3_RS_READ_MORE = 3;
  {$EXTERNALSYM SSL3_RT_ALERT}
  SSL3_RT_ALERT = 21;
  {$EXTERNALSYM SSL3_RT_APPLICATION_DATA}
  SSL3_RT_APPLICATION_DATA = 23;
  {$EXTERNALSYM TLS1_RT_HEARTBEAT}
  TLS1_RT_HEARTBEAT	= 24;
  {$EXTERNALSYM SSL3_RT_CHANGE_CIPHER_SPEC}
  SSL3_RT_CHANGE_CIPHER_SPEC = 20;
  {$EXTERNALSYM SSL3_RT_HANDSHAKE}
  SSL3_RT_HANDSHAKE = 22;
  {$EXTERNALSYM SSL3_RT_HEADER_LENGTH}
  SSL3_RT_HEADER_LENGTH = 5;
  {$EXTERNALSYM SSL3_RT_MAX_MD_SIZE}
  SSL3_RT_MAX_MD_SIZE	= 64;
  {$EXTERNALSYM SSL_RT_MAX_CIPHER_BLOCK_SIZE}
  SSL_RT_MAX_CIPHER_BLOCK_SIZE = 16;
  {$EXTERNALSYM SSL3_RT_MAX_EXTRA}
  SSL3_RT_MAX_EXTRA	= (16384);

  {$EXTERNALSYM SSL3_RT_MAX_PLAIN_LENGTH}
  SSL3_RT_MAX_PLAIN_LENGTH = 16384;
  {$EXTERNALSYM SSL3_RT_MAX_COMPRESSED_OVERHEAD}
  SSL3_RT_MAX_COMPRESSED_OVERHEAD = 1024;
  {$EXTERNALSYM SSL3_RT_MAX_ENCRYPTED_OVERHEAD}
  SSL3_RT_MAX_ENCRYPTED_OVERHEAD = (256 + SSL3_RT_MAX_MD_SIZE);
  {$EXTERNALSYM SSL3_RT_SEND_MAX_ENCRYPTED_OVERHEAD}
  SSL3_RT_SEND_MAX_ENCRYPTED_OVERHEAD = (SSL_RT_MAX_CIPHER_BLOCK_SIZE + SSL3_RT_MAX_MD_SIZE);
 {$EXTERNALSYM SSL3_RT_MAX_COMPRESSED_LENGTH}
{$ifdef OPENSSL_NO_COMP}
  SSL3_RT_MAX_COMPRESSED_LENGTH = SSL3_RT_MAX_PLAIN_LENGTH;
{$else}
  SSL3_RT_MAX_COMPRESSED_LENGTH	=
		(SSL3_RT_MAX_PLAIN_LENGTH+SSL3_RT_MAX_COMPRESSED_OVERHEAD);
{$endif}
 {$EXTERNALSYM SSL3_RT_MAX_ENCRYPTED_LENGTH}
  SSL3_RT_MAX_ENCRYPTED_LENGTH =
		(SSL3_RT_MAX_ENCRYPTED_OVERHEAD+SSL3_RT_MAX_COMPRESSED_LENGTH);
 {$EXTERNALSYM SSL3_RT_MAX_PACKET_SIZE}
  SSL3_RT_MAX_PACKET_SIZE	=
		(SSL3_RT_MAX_ENCRYPTED_LENGTH+SSL3_RT_HEADER_LENGTH);

  {$EXTERNALSYM SSL3_RT_MAX_DATA_SIZE}
  SSL3_RT_MAX_DATA_SIZE = 1024*1024;

  {$EXTERNALSYM SSL3_SESSION_ID_SIZE}
  SSL3_SESSION_ID_SIZE = 32;
  {$EXTERNALSYM SSL3_SSL_SESSION_ID_LENGTH}
  SSL3_SSL_SESSION_ID_LENGTH = 32;
  {$EXTERNALSYM SSL3_ST_CR_CERT_A}
  SSL3_ST_CR_CERT_A = $130 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_CERT_B}
  SSL3_ST_CR_CERT_B = $131 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_CERT_REQ_A}
  SSL3_ST_CR_CERT_REQ_A = $150 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_CERT_REQ_B}
  SSL3_ST_CR_CERT_REQ_B = $151 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_CHANGE_A}
  SSL3_ST_CR_CHANGE_A = $1C0 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_CHANGE_B}
  SSL3_ST_CR_CHANGE_B = $1C1 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_FINISHED_A}
  SSL3_ST_CR_FINISHED_A = $1D0 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_FINISHED_B}
  SSL3_ST_CR_FINISHED_B = $1D1 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_SESSION_TICKET_A}
  SSL3_ST_CR_SESSION_TICKET_A = ($1E0 or SSL_ST_CONNECT);
  {$EXTERNALSYM SSL3_ST_CR_SESSION_TICKET_B}
  SSL3_ST_CR_SESSION_TICKET_B = ($1E1 or SSL_ST_CONNECT);
  {$EXTERNALSYM SSL3_ST_CR_CERT_STATUS_A}
  SSL3_ST_CR_CERT_STATUS_A = ($1F0 or SSL_ST_CONNECT);
  {$EXTERNALSYM SSL3_ST_CR_CERT_STATUS_B}
  SSL3_ST_CR_CERT_STATUS_B = ($1F1 or SSL_ST_CONNECT);
  {$EXTERNALSYM SSL3_ST_CR_KEY_EXCH_A}
  SSL3_ST_CR_KEY_EXCH_A = $140 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_KEY_EXCH_B}
  SSL3_ST_CR_KEY_EXCH_B = $141 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_SRVR_DONE_A}
  SSL3_ST_CR_SRVR_DONE_A = $160 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_SRVR_DONE_B}
  SSL3_ST_CR_SRVR_DONE_B = $161 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_SRVR_HELLO_A}
  SSL3_ST_CR_SRVR_HELLO_A = $120 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CR_SRVR_HELLO_B}
  SSL3_ST_CR_SRVR_HELLO_B = $121 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_CERT_A}
  SSL3_ST_CW_CERT_A = $170 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_CERT_B}
  SSL3_ST_CW_CERT_B = $171 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_CERT_C}
  SSL3_ST_CW_CERT_C = $172 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_CERT_D}
  SSL3_ST_CW_CERT_D = $173 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_CERT_VRFY_A}
  SSL3_ST_CW_CERT_VRFY_A = $190 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_CERT_VRFY_B}
  SSL3_ST_CW_CERT_VRFY_B = $191 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_CHANGE_A}
  SSL3_ST_CW_CHANGE_A = $1A0 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_CHANGE_B}
  SSL3_ST_CW_CHANGE_B = $1A1 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_NEXT_PROTO_A}
  SSL3_ST_CW_NEXT_PROTO_A	= ($200 or SSL_ST_CONNECT);
  {$EXTERNALSYM SSL3_ST_CW_NEXT_PROTO_B}
  SSL3_ST_CW_NEXT_PROTO_B	= ($201 or SSL_ST_CONNECT);

{$ifndef OPENSSL_NO_SCTP}
  {$EXTERNALSYM DTLS1_SCTP_ST_CW_WRITE_SOCK}
  DTLS1_SCTP_ST_CW_WRITE_SOCK	=	$310 or SSL_ST_CONNECT;
  {$EXTERNALSYM DTLS1_SCTP_ST_CR_READ_SOCK}
  DTLS1_SCTP_ST_CR_READ_SOCK = $320 or SSL_ST_CONNECT;
{$endif}
  {$EXTERNALSYM SSL3_ST_CW_CLNT_HELLO_A}
  SSL3_ST_CW_CLNT_HELLO_A = $110 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_CLNT_HELLO_B}
  SSL3_ST_CW_CLNT_HELLO_B = $111 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_FINISHED_A}
  SSL3_ST_CW_FINISHED_A = $1B0 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_FINISHED_B}
  SSL3_ST_CW_FINISHED_B = $1B1 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_FLUSH}
  SSL3_ST_CW_FLUSH = $100 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_KEY_EXCH_A}
  SSL3_ST_CW_KEY_EXCH_A = $180 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_CW_KEY_EXCH_B}
  SSL3_ST_CW_KEY_EXCH_B = $181 or SSL_ST_CONNECT;
  {$EXTERNALSYM SSL3_ST_SR_CERT_A}
  SSL3_ST_SR_CERT_A = $180 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_CERT_B}
  SSL3_ST_SR_CERT_B = $181 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_CERT_VRFY_A}
  SSL3_ST_SR_CERT_VRFY_A = $1A0 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_CERT_VRFY_B}
  SSL3_ST_SR_CERT_VRFY_B = $1A1 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_CHANGE_A}
  SSL3_ST_SR_CHANGE_A = $1B0 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_CHANGE_B}
  SSL3_ST_SR_CHANGE_B = $1B1 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_NEXT_PROTO_A}
  SSL3_ST_SR_NEXT_PROTO_A	= ($210 or SSL_ST_ACCEPT);
  {$EXTERNALSYM SSL3_ST_SR_NEXT_PROTO_B}
  SSL3_ST_SR_NEXT_PROTO_B	= ($211 or SSL_ST_ACCEPT);
  {$EXTERNALSYM SSL3_ST_SR_CLNT_HELLO_A}
  SSL3_ST_SR_CLNT_HELLO_A = $110 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_CLNT_HELLO_B}
  SSL3_ST_SR_CLNT_HELLO_B = $111 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_CLNT_HELLO_C}
  SSL3_ST_SR_CLNT_HELLO_C = $112 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_FINISHED_A}
  SSL3_ST_SR_FINISHED_A = $1C0 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_FINISHED_B}
  SSL3_ST_SR_FINISHED_B = $1C1 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_KEY_EXCH_A}
  SSL3_ST_SR_KEY_EXCH_A = $190 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SR_KEY_EXCH_B}
  SSL3_ST_SR_KEY_EXCH_B = $191 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_CERT_A}
  SSL3_ST_SW_CERT_A = $140 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_CERT_B}
  SSL3_ST_SW_CERT_B = $141 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_CERT_REQ_A}
  SSL3_ST_SW_CERT_REQ_A = $160 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_CERT_REQ_B}
  SSL3_ST_SW_CERT_REQ_B = $161 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_CHANGE_A}
  SSL3_ST_SW_CHANGE_A = $1D0 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_CHANGE_B}
  SSL3_ST_SW_CHANGE_B = $1D1 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_FINISHED_A}
  SSL3_ST_SW_FINISHED_A = $1E0 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_FINISHED_B}
  SSL3_ST_SW_FINISHED_B = $1E1 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_SESSION_TICKET_A}
  SSL3_ST_SW_SESSION_TICKET_A = ($1F0 or SSL_ST_ACCEPT);
  {$EXTERNALSYM SSL3_ST_SW_SESSION_TICKET_B}
  SSL3_ST_SW_SESSION_TICKET_B = ($1F1 or SSL_ST_ACCEPT);
  {$EXTERNALSYM SSL3_ST_SW_CERT_STATUS_A}
  SSL3_ST_SW_CERT_STATUS_A =	($200 or SSL_ST_ACCEPT);
  {$EXTERNALSYM SSL3_ST_SW_CERT_STATUS_B}
  SSL3_ST_SW_CERT_STATUS_B =	($201 or SSL_ST_ACCEPT);
  {$EXTERNALSYM SSL3_ST_SW_FLUSH}
  SSL3_ST_SW_FLUSH = $100 or SSL_ST_ACCEPT;
{$ifndef OPENSSL_NO_SCTP}
  {$EXTERNALSYM DTLS1_SCTP_ST_SW_WRITE_SOCK}
  DTLS1_SCTP_ST_SW_WRITE_SOCK	= ($310 or SSL_ST_ACCEPT);
  {$EXTERNALSYM DTLS1_SCTP_ST_SR_READ_SOCK}
  DTLS1_SCTP_ST_SR_READ_SOCK = ($320 or SSL_ST_ACCEPT);
{$endif}
  {$EXTERNALSYM SSL3_ST_SW_HELLO_REQ_A}
  SSL3_ST_SW_HELLO_REQ_A = $120 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_HELLO_REQ_B}
  SSL3_ST_SW_HELLO_REQ_B = $121 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_HELLO_REQ_C}
  SSL3_ST_SW_HELLO_REQ_C = $122 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_KEY_EXCH_A}
  SSL3_ST_SW_KEY_EXCH_A = $150 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_KEY_EXCH_B}
  SSL3_ST_SW_KEY_EXCH_B = $151 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_SRVR_DONE_A}
  SSL3_ST_SW_SRVR_DONE_A = $170 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_SRVR_DONE_B}
  SSL3_ST_SW_SRVR_DONE_B = $171 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_SRVR_HELLO_A}
  SSL3_ST_SW_SRVR_HELLO_A = $130 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_ST_SW_SRVR_HELLO_B}
  SSL3_ST_SW_SRVR_HELLO_B = $131 or SSL_ST_ACCEPT;
  {$EXTERNALSYM SSL3_TXT_ADH_DES_192_CBC_SHA}
  SSL3_TXT_ADH_DES_192_CBC_SHA = 'ADH-DES-CBC3-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_ADH_DES_40_CBC_SHA}
  SSL3_TXT_ADH_DES_40_CBC_SHA = 'EXP-ADH-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_ADH_DES_64_CBC_SHA}
  SSL3_TXT_ADH_DES_64_CBC_SHA = 'ADH-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_ADH_RC4_128_MD5}
  SSL3_TXT_ADH_RC4_128_MD5 = 'ADH-RC4-MD5';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_ADH_RC4_40_MD5}
  SSL3_TXT_ADH_RC4_40_MD5 = 'EXP-ADH-RC4-MD5';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_DH_DSS_DES_192_CBC3_SHA}
  SSL3_TXT_DH_DSS_DES_192_CBC3_SHA = 'DH-DSS-DES-CBC3-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_DH_DSS_DES_40_CBC_SHA}
  SSL3_TXT_DH_DSS_DES_40_CBC_SHA = 'EXP-DH-DSS-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_DH_DSS_DES_64_CBC_SHA}
  SSL3_TXT_DH_DSS_DES_64_CBC_SHA = 'DH-DSS-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_DH_RSA_DES_192_CBC3_SHA}
  SSL3_TXT_DH_RSA_DES_192_CBC3_SHA = 'DH-RSA-DES-CBC3-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_DH_RSA_DES_40_CBC_SHA}
  SSL3_TXT_DH_RSA_DES_40_CBC_SHA = 'EXP-DH-RSA-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_DH_RSA_DES_64_CBC_SHA}
  SSL3_TXT_DH_RSA_DES_64_CBC_SHA = 'DH-RSA-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_EDH_DSS_DES_192_CBC3_SHA}
  SSL3_TXT_EDH_DSS_DES_192_CBC3_SHA = 'EDH-DSS-DES-CBC3-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_EDH_DSS_DES_40_CBC_SHA}
  SSL3_TXT_EDH_DSS_DES_40_CBC_SHA = 'EXP-EDH-DSS-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_EDH_DSS_DES_64_CBC_SHA}
  SSL3_TXT_EDH_DSS_DES_64_CBC_SHA = 'EDH-DSS-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_EDH_RSA_DES_192_CBC3_SHA}
  SSL3_TXT_EDH_RSA_DES_192_CBC3_SHA = 'EDH-RSA-DES-CBC3-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_EDH_RSA_DES_40_CBC_SHA}
  SSL3_TXT_EDH_RSA_DES_40_CBC_SHA = 'EXP-EDH-RSA-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_EDH_RSA_DES_64_CBC_SHA}
  SSL3_TXT_EDH_RSA_DES_64_CBC_SHA = 'EDH-RSA-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_FZA_DMS_FZA_SHA}
  SSL3_TXT_FZA_DMS_FZA_SHA = 'FZA-FZA-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_FZA_DMS_NULL_SHA}
  SSL3_TXT_FZA_DMS_NULL_SHA = 'FZA-NULL-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_FZA_DMS_RC4_SHA}
  SSL3_TXT_FZA_DMS_RC4_SHA = 'FZA-RC4-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_RSA_DES_192_CBC3_SHA}
  SSL3_TXT_RSA_DES_192_CBC3_SHA = 'DES-CBC3-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_RSA_DES_40_CBC_SHA}
  SSL3_TXT_RSA_DES_40_CBC_SHA = 'EXP-DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_RSA_DES_64_CBC_SHA}
  SSL3_TXT_RSA_DES_64_CBC_SHA = 'DES-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_RSA_IDEA_128_SHA}
  SSL3_TXT_RSA_IDEA_128_SHA = 'IDEA-CBC-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_RSA_NULL_MD5}
  SSL3_TXT_RSA_NULL_MD5 = 'NULL-MD5';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_RSA_NULL_SHA}
  SSL3_TXT_RSA_NULL_SHA = 'NULL-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_RSA_RC2_40_MD5}
  SSL3_TXT_RSA_RC2_40_MD5 = 'EXP-RC2-CBC-MD5';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_RSA_RC4_128_MD5}
  SSL3_TXT_RSA_RC4_128_MD5 = 'RC4-MD5';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_RSA_RC4_128_SHA}
  SSL3_TXT_RSA_RC4_128_SHA = 'RC4-SHA';  {Do not localize}
  {$EXTERNALSYM SSL3_TXT_RSA_RC4_40_MD5}
  SSL3_TXT_RSA_RC4_40_MD5 = 'EXP-RC4-MD5';  {Do not localize}
  {$EXTERNALSYM SSL3_VERSION}
  SSL3_VERSION = $0300;
  {$EXTERNALSYM SSL3_VERSION_MAJOR}
  SSL3_VERSION_MAJOR = $03;
  {$EXTERNALSYM SSL3_VERSION_MINOR}
  SSL3_VERSION_MINOR = $00;
  {$EXTERNALSYM SSLEAY_VERSION}
  SSLEAY_VERSION = 0;
//* #define SSLEAY_OPTIONS 1 no longer supported */
  {$EXTERNALSYM SSLEAY_CFLAGS}
  SSLEAY_CFLAGS = 2;
  {$EXTERNALSYM SSLEAY_BUILT_ON}
  SSLEAY_BUILT_ON = 3;
  {$EXTERNALSYM SSLEAY_PLATFORM}
  SSLEAY_PLATFORM = 4;
  {$EXTERNALSYM SSLEAY_DIR}
  SSLEAY_DIR = 5;
  //tls1.h
  {$EXTERNALSYM TLS1_AD_DECRYPTION_FAILED}
  TLS1_AD_DECRYPTION_FAILED = 21;
  {$EXTERNALSYM TLS1_AD_RECORD_OVERFLOW}
  TLS1_AD_RECORD_OVERFLOW = 22;
  {$EXTERNALSYM TLS1_AD_UNKNOWN_CA}
  TLS1_AD_UNKNOWN_CA = 48;
  {$EXTERNALSYM TLS1_AD_ACCESS_DENIED}
  TLS1_AD_ACCESS_DENIED = 49;
  {$EXTERNALSYM TLS1_AD_DECODE_ERROR}
  TLS1_AD_DECODE_ERROR = 50;
  {$EXTERNALSYM TLS1_AD_DECRYPT_ERROR}
  TLS1_AD_DECRYPT_ERROR = 51;
  {$EXTERNALSYM TLS1_AD_EXPORT_RESTRICTION}
  TLS1_AD_EXPORT_RESTRICTION = 60;
  {$EXTERNALSYM TLS1_AD_PROTOCOL_VERSION}
  TLS1_AD_PROTOCOL_VERSION = 70;
  {$EXTERNALSYM TLS1_AD_INSUFFICIENT_SECURITY}
  TLS1_AD_INSUFFICIENT_SECURITY = 71;
  {$EXTERNALSYM TLS1_AD_INTERNAL_ERROR}
  TLS1_AD_INTERNAL_ERROR = 80;
  {$EXTERNALSYM TLS1_AD_USER_CANCELLED}
  TLS1_AD_USER_CANCELLED = 90;
  {$EXTERNALSYM TLS1_AD_NO_RENEGOTIATION}
  TLS1_AD_NO_RENEGOTIATION = 100;
  //* codes 110-114 are from RFC3546 */
  {$EXTERNALSYM TLS1_AD_UNSUPPORTED_EXTENSION}
  TLS1_AD_UNSUPPORTED_EXTENSION = 110;
  {$EXTERNALSYM TLS1_AD_CERTIFICATE_UNOBTAINABLE}
  TLS1_AD_CERTIFICATE_UNOBTAINABLE = 111;
  {$EXTERNALSYM TLS1_AD_UNRECOGNIZED_NAME}
  TLS1_AD_UNRECOGNIZED_NAME = 112;
  {$EXTERNALSYM TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE}
  TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE = 113;
  {$EXTERNALSYM TLS1_AD_BAD_CERTIFICATE_HASH_VALUE}
  TLS1_AD_BAD_CERTIFICATE_HASH_VALUE = 114;
  {$EXTERNALSYM TLS1_AD_UNKNOWN_PSK_IDENTITY}
  TLS1_AD_UNKNOWN_PSK_IDENTITY = 115;//* fatal */
//* ExtensionType values from RFC 3546 */
  {$EXTERNALSYM TLSEXT_TYPE_server_name}
  TLSEXT_TYPE_server_name = 0;
  {$EXTERNALSYM TLSEXT_TYPE_max_fragment_length}
  TLSEXT_TYPE_max_fragment_length = 1;
  {$EXTERNALSYM TLSEXT_TYPE_client_certificate_url}
  TLSEXT_TYPE_client_certificate_url = 2;
  {$EXTERNALSYM TLSEXT_TYPE_trusted_ca_keys}
  TLSEXT_TYPE_trusted_ca_keys = 3;
  {$EXTERNALSYM TLSEXT_TYPE_truncated_hmac}
  TLSEXT_TYPE_truncated_hmac = 4;
  {$EXTERNALSYM TLSEXT_TYPE_status_request}
  TLSEXT_TYPE_status_request =5;
  {$EXTERNALSYM TLSEXT_TYPE_user_mapping}
  TLSEXT_TYPE_user_mapping = 6;
  {$EXTERNALSYM TLSEXT_TYPE_client_authz}
  TLSEXT_TYPE_client_authz = 7;
  {$EXTERNALSYM TLSEXT_TYPE_server_authz}
  TLSEXT_TYPE_server_authz = 8;
  {$EXTERNALSYM TLSEXT_TYPE_cert_type}
  TLSEXT_TYPE_cert_type = 9;
  {$EXTERNALSYM TLSEXT_TYPE_elliptic_curves}
  TLSEXT_TYPE_elliptic_curves = 10;
  {$EXTERNALSYM TLSEXT_TYPE_ec_point_formats}
  TLSEXT_TYPE_ec_point_formats = 11;
  {$EXTERNALSYM TLSEXT_TYPE_srp}
  TLSEXT_TYPE_srp	=	12;
  {$EXTERNALSYM TLSEXT_TYPE_signature_algorithms}
  TLSEXT_TYPE_signature_algorithms = 13;
  {$EXTERNALSYM TLSEXT_TYPE_use_srtp}
  TLSEXT_TYPE_use_srtp = 14;
  {$EXTERNALSYM TLSEXT_TYPE_heartbeat}
  TLSEXT_TYPE_heartbeat = 15;
  {$EXTERNALSYM TLSEXT_TYPE_session_ticket}
  TLSEXT_TYPE_session_ticket = 35;
  {$IFNDEF OPENSSL_NO_NEXTPROTONEG}
//* This is not an IANA defined extension number */
  {$EXTERNALSYM TLSEXT_TYPE_next_proto_neg}
  TLSEXT_TYPE_next_proto_neg = 13172;
  {$ENDIF}
  //* Temporary extension type */
  {$EXTERNALSYM TLSEXT_TYPE_renegotiate}
 TLSEXT_TYPE_renegotiate = $ff01;

  //* NameType value from RFC 3546 */
  {$EXTERNALSYM TLSEXT_NAMETYPE_host_name}
  TLSEXT_NAMETYPE_host_name = 0;
//* status request value from RFC 3546 */
  {$EXTERNALSYM TLSEXT_STATUSTYPE_ocsp}
  TLSEXT_STATUSTYPE_ocsp = 1;
  {$EXTERNALSYM TLSEXT_ECPOINTFORMAT_first}
  TLSEXT_ECPOINTFORMAT_first = 0;
  {$EXTERNALSYM TLSEXT_ECPOINTFORMAT_uncompressed}
  TLSEXT_ECPOINTFORMAT_uncompressed	= 0;
  {$EXTERNALSYM TLSEXT_ECPOINTFORMAT_ansiX962_compressed_prime}
  TLSEXT_ECPOINTFORMAT_ansiX962_compressed_prime = 1;
  {$EXTERNALSYM TLSEXT_ECPOINTFORMAT_ansiX962_compressed_char2}
  TLSEXT_ECPOINTFORMAT_ansiX962_compressed_char2 = 2;
  {$EXTERNALSYM TLSEXT_ECPOINTFORMAT_last}
  TLSEXT_ECPOINTFORMAT_last	= 2;
  {$EXTERNALSYM TLSEXT_signature_anonymous}
  TLSEXT_signature_anonymous = 0;
  {$EXTERNALSYM TLSEXT_signature_rsa}
  TLSEXT_signature_rsa = 1;
  {$EXTERNALSYM TLSEXT_signature_dsa}
  TLSEXT_signature_dsa = 2;
  {$EXTERNALSYM TLSEXT_signature_ecdsa}
  TLSEXT_signature_ecdsa = 3;
  {$EXTERNALSYM TLSEXT_hash_none}
  TLSEXT_hash_none = 0;
  {$EXTERNALSYM TLSEXT_hash_md5}
  TLSEXT_hash_md5	=	1;
  {$EXTERNALSYM TLSEXT_hash_sha1}
  TLSEXT_hash_sha1 = 2;
  {$EXTERNALSYM TLSEXT_hash_sha224}
  TLSEXT_hash_sha224 = 3;
  {$EXTERNALSYM TLSEXT_hash_sha256}
  TLSEXT_hash_sha256 = 4;
  {$EXTERNALSYM TLSEXT_hash_sha384}
  TLSEXT_hash_sha384 = 5;
  {$EXTERNALSYM TLSEXT_hash_sha512}
  TLSEXT_hash_sha512 = 6;

{$IFNDEF OPENSSL_NO_TLSEXT}
  {$EXTERNALSYM TLSEXT_MAXLEN_host_name}
  TLSEXT_MAXLEN_host_name = 255;
  {$EXTERNALSYM SSL_TLSEXT_ERR_OK}
  SSL_TLSEXT_ERR_OK  = 0;
  {$EXTERNALSYM SSL_TLSEXT_ERR_ALERT_WARNING}
  SSL_TLSEXT_ERR_ALERT_WARNING = 1;
  {$EXTERNALSYM SSL_TLSEXT_ERR_ALERT_FATAL}
  SSL_TLSEXT_ERR_ALERT_FATAL = 2;
  {$EXTERNALSYM SSL_TLSEXT_ERR_NOACK}
  SSL_TLSEXT_ERR_NOACK = 3;
  {$IFDEF OPENSSL_NO_HEARTBEATS}
   {$EXTERNALSYM SSL_TLSEXT_HB_DONT_SEND_REQUESTS}
  SSL_TLSEXT_HB_ENABLED	= $01;
   {$EXTERNALSYM SSL_TLSEXT_HB_DONT_SEND_REQUESTS}
  SSL_TLSEXT_HB_DONT_SEND_REQUESTS = $02;
   {$EXTERNALSYM SSL_TLSEXT_HB_DONT_RECV_REQUESTS}
  SSL_TLSEXT_HB_DONT_RECV_REQUESTS = $04;
  {$ENDIF}
{$ENDIF}
  //
  {$EXTERNALSYM SSLEAY_VERSION_NUMBER}
  SSLEAY_VERSION_NUMBER = OPENSSL_VERSION_NUMBER;
  {$EXTERNALSYM SSL_AD_REASON_OFFSET}
  SSL_AD_REASON_OFFSET = 1000;
  {$EXTERNALSYM SSL_AD_CLOSE_NOTIFY}
  SSL_AD_CLOSE_NOTIFY = SSL3_AD_CLOSE_NOTIFY;
  {$EXTERNALSYM SSL_AD_UNEXPECTED_MESSAGE}
  SSL_AD_UNEXPECTED_MESSAGE = SSL3_AD_UNEXPECTED_MESSAGE;
  {$EXTERNALSYM SSL_AD_BAD_RECORD_MAC}
  SSL_AD_BAD_RECORD_MAC = SSL3_AD_BAD_RECORD_MAC;
  {$EXTERNALSYM SSL_AD_DECRYPTION_FAILED}
  SSL_AD_DECRYPTION_FAILED = TLS1_AD_DECRYPTION_FAILED;
  {$EXTERNALSYM SSL_AD_RECORD_OVERFLOW}
  SSL_AD_RECORD_OVERFLOW = TLS1_AD_RECORD_OVERFLOW;
  {$EXTERNALSYM SSL_AD_DECOMPRESSION_FAILURE}
  SSL_AD_DECOMPRESSION_FAILURE = SSL3_AD_DECOMPRESSION_FAILURE;
  {$EXTERNALSYM SSL_AD_HANDSHAKE_FAILURE}
  SSL_AD_HANDSHAKE_FAILURE = SSL3_AD_HANDSHAKE_FAILURE;
  {$EXTERNALSYM SSL_AD_NO_CERTIFICATE}
  SSL_AD_NO_CERTIFICATE = SSL3_AD_NO_CERTIFICATE;
  {$EXTERNALSYM SSL_AD_BAD_CERTIFICATE}
  SSL_AD_BAD_CERTIFICATE = SSL3_AD_BAD_CERTIFICATE;
  {$EXTERNALSYM SSL_AD_UNSUPPORTED_CERTIFICATE}
  SSL_AD_UNSUPPORTED_CERTIFICATE = SSL3_AD_UNSUPPORTED_CERTIFICATE;
  {$EXTERNALSYM SSL_AD_CERTIFICATE_REVOKED}
  SSL_AD_CERTIFICATE_REVOKED = SSL3_AD_CERTIFICATE_REVOKED;
  {$EXTERNALSYM SSL_AD_CERTIFICATE_EXPIRED}
  SSL_AD_CERTIFICATE_EXPIRED = SSL3_AD_CERTIFICATE_EXPIRED;
  {$EXTERNALSYM SSL_AD_CERTIFICATE_UNKNOWN}
  SSL_AD_CERTIFICATE_UNKNOWN = SSL3_AD_CERTIFICATE_UNKNOWN;
  {$EXTERNALSYM SSL_AD_ILLEGAL_PARAMETER}
  SSL_AD_ILLEGAL_PARAMETER = SSL3_AD_ILLEGAL_PARAMETER;

  {$EXTERNALSYM SSL_AD_UNKNOWN_CA}
  SSL_AD_UNKNOWN_CA = TLS1_AD_UNKNOWN_CA;
  {$EXTERNALSYM SSL_AD_ACCESS_DENIED}
  SSL_AD_ACCESS_DENIED = TLS1_AD_ACCESS_DENIED;
  {$EXTERNALSYM SSL_AD_DECODE_ERROR}
  SSL_AD_DECODE_ERROR = TLS1_AD_DECODE_ERROR;
  {$EXTERNALSYM SSL_AD_DECRYPT_ERROR}
  SSL_AD_DECRYPT_ERROR = TLS1_AD_DECRYPT_ERROR;
  {$EXTERNALSYM SSL_AD_EXPORT_RESTRICTION}
  SSL_AD_EXPORT_RESTRICTION = TLS1_AD_EXPORT_RESTRICTION;
  {$EXTERNALSYM SSL_AD_PROTOCOL_VERSION}
  SSL_AD_PROTOCOL_VERSION = TLS1_AD_PROTOCOL_VERSION;
  {$EXTERNALSYM SSL_AD_INSUFFICIENT_SECURITY}
  SSL_AD_INSUFFICIENT_SECURITY = TLS1_AD_INSUFFICIENT_SECURITY;
  {$EXTERNALSYM SSL_AD_INTERNAL_ERROR}
  SSL_AD_INTERNAL_ERROR = TLS1_AD_INTERNAL_ERROR;
  {$EXTERNALSYM SSL_AD_USER_CANCELLED}
  SSL_AD_USER_CANCELLED = TLS1_AD_USER_CANCELLED;
  {$EXTERNALSYM SSL_AD_NO_RENEGOTIATION}
  SSL_AD_NO_RENEGOTIATION = TLS1_AD_NO_RENEGOTIATION;
  {$EXTERNALSYM SSL_AD_UNSUPPORTED_EXTENSION}
  SSL_AD_UNSUPPORTED_EXTENSION = TLS1_AD_UNSUPPORTED_EXTENSION;
  {$EXTERNALSYM SSL_AD_CERTIFICATE_UNOBTAINABLE}
  SSL_AD_CERTIFICATE_UNOBTAINABLE = TLS1_AD_CERTIFICATE_UNOBTAINABLE;
  {$EXTERNALSYM SSL_AD_UNRECOGNIZED_NAME}
  SSL_AD_UNRECOGNIZED_NAME = TLS1_AD_UNRECOGNIZED_NAME;
  {$EXTERNALSYM SSL_AD_BAD_CERTIFICATE_STATUS_RESPONSE}
  SSL_AD_BAD_CERTIFICATE_STATUS_RESPONSE = TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE;
  {$EXTERNALSYM SSL_AD_BAD_CERTIFICATE_HASH_VALUE}
  SSL_AD_BAD_CERTIFICATE_HASH_VALUE = TLS1_AD_BAD_CERTIFICATE_HASH_VALUE;
  {$EXTERNALSYM SSL_AD_UNKNOWN_PSK_IDENTITY}
  SSL_AD_UNKNOWN_PSK_IDENTITY = TLS1_AD_UNKNOWN_PSK_IDENTITY; //* fatal */




  {$EXTERNALSYM SSL_CTRL_NEED_TMP_RSA}
  SSL_CTRL_NEED_TMP_RSA = 1;
  {$EXTERNALSYM SSL_CTRL_SET_TMP_RSA}
  SSL_CTRL_SET_TMP_RSA = 2;
  {$EXTERNALSYM SSL_CTRL_SET_TMP_DH}
  SSL_CTRL_SET_TMP_DH = 3;
  {$EXTERNALSYM SSL_CTRL_SET_TMP_ECDH}
  SSL_CTRL_SET_TMP_ECDH = 4;
  {$EXTERNALSYM SSL_CTRL_SET_TMP_RSA_CB}
  SSL_CTRL_SET_TMP_RSA_CB = 5;
  {$EXTERNALSYM SSL_CTRL_SET_TMP_DH_CB}
  SSL_CTRL_SET_TMP_DH_CB = 6;
  {$EXTERNALSYM SSL_CTRL_SET_TMP_ECDH_CB}
  SSL_CTRL_SET_TMP_ECDH_CB = 7;
  {$IFNDEF NO_TLSEXT}
  //* see tls1.h for macros based on these */
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_SERVERNAME_CB}
  SSL_CTRL_SET_TLSEXT_SERVERNAME_CB	= 53;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG}
  SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG = 54;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_HOSTNAME}
  SSL_CTRL_SET_TLSEXT_HOSTNAME = 55;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_DEBUG_CB}
  SSL_CTRL_SET_TLSEXT_DEBUG_CB = 56;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_DEBUG_ARG}
  SSL_CTRL_SET_TLSEXT_DEBUG_ARG	= 57;
  {$EXTERNALSYM SSL_CTRL_GET_TLSEXT_TICKET_KEYS}
  SSL_CTRL_GET_TLSEXT_TICKET_KEYS	= 58;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_TICKET_KEYS}
  SSL_CTRL_SET_TLSEXT_TICKET_KEYS	=	59;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_OPAQUE_PRF_INPUT}
  SSL_CTRL_SET_TLSEXT_OPAQUE_PRF_INPUT = 60;
   {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_OPAQUE_PRF_INPUT_CB}
  SSL_CTRL_SET_TLSEXT_OPAQUE_PRF_INPUT_CB	= 61;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_OPAQUE_PRF_INPUT_CB_ARG}
  SSL_CTRL_SET_TLSEXT_OPAQUE_PRF_INPUT_CB_ARG = 62;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB}
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB	= 63;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG}
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG	= 64;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE}
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE	= 65;
  {$EXTERNALSYM SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS}
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS	= 66;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS}
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS	= 67;
  {$EXTERNALSYM SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS}
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS = 68;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS}
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS = 69;
  {$EXTERNALSYM SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP}
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP = 70;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP}
  SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP = 71;
  {$EXTERNALSYM SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB}
  SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB	= 72;
  {$EXTERNALSYM SSL_CTRL_SET_TLS_EXT_SRP_USERNAME_CB}
  SSL_CTRL_SET_TLS_EXT_SRP_USERNAME_CB = 75;
  {$EXTERNALSYM SSL_CTRL_SET_SRP_VERIFY_PARAM_CB}
  SSL_CTRL_SET_SRP_VERIFY_PARAM_CB = 76;
   {$EXTERNALSYM SSL_CTRL_SET_SRP_GIVE_CLIENT_PWD_CB}
  SSL_CTRL_SET_SRP_GIVE_CLIENT_PWD_CB	= 77;
    {$EXTERNALSYM SSL_CTRL_SET_SRP_ARG}
  SSL_CTRL_SET_SRP_ARG = 78;
  {$EXTERNALSYM SSL_CTRL_SET_TLS_EXT_SRP_USERNAME}
  SSL_CTRL_SET_TLS_EXT_SRP_USERNAME	= 79;
  {$EXTERNALSYM SSL_CTRL_SET_TLS_EXT_SRP_STRENGTH}
  SSL_CTRL_SET_TLS_EXT_SRP_STRENGTH	= 80;
  {$EXTERNALSYM SSL_CTRL_SET_TLS_EXT_SRP_PASSWORD}
  SSL_CTRL_SET_TLS_EXT_SRP_PASSWORD	= 81;
    {$ifndef OPENSSL_NO_HEARTBEATS}
  {$EXTERNALSYM SSL_CTRL_TLS_EXT_SEND_HEARTBEAT}
  SSL_CTRL_TLS_EXT_SEND_HEARTBEAT	= 85;
  {$EXTERNALSYM SSL_CTRL_GET_TLS_EXT_HEARTBEAT_PENDING}
  SSL_CTRL_GET_TLS_EXT_HEARTBEAT_PENDING = 86;
  {$EXTERNALSYM SSL_CTRL_SET_TLS_EXT_HEARTBEAT_NO_REQUESTS}
  SSL_CTRL_SET_TLS_EXT_HEARTBEAT_NO_REQUESTS = 87;
    {$endif}
  {$ENDIF}
  {$EXTERNALSYM SSL_CTRL_SET_ECDH_AUTO}
  SSL_CTRL_SET_ECDH_AUTO = 94;

  {$EXTERNALSYM DTLS_CTRL_GET_TIMEOUT}
  DTLS_CTRL_GET_TIMEOUT	= 73;
  {$EXTERNALSYM DTLS_CTRL_HANDLE_TIMEOUT}
  DTLS_CTRL_HANDLE_TIMEOUT = 74;
  {$EXTERNALSYM DTLS_CTRL_LISTEN}
  DTLS_CTRL_LISTEN = 75;

  {$EXTERNALSYM SSL_CTRL_GET_RI_SUPPORT}
  SSL_CTRL_GET_RI_SUPPORT	= 76;
  {$EXTERNALSYM SSL_CTRL_CLEAR_OPTIONS}
  SSL_CTRL_CLEAR_OPTIONS = 77;
  {$EXTERNALSYM SSL_CTRL_CLEAR_MODE}
  SSL_CTRL_CLEAR_MODE = 78;
  {$EXTERNALSYM SSL_CTRL_GET_EXTRA_CHAIN_CERTS}
  SSL_CTRL_GET_EXTRA_CHAIN_CERTS = 82;
  {$EXTERNALSYM SSL_CTRL_CLEAR_EXTRA_CHAIN_CERTS}
  SSL_CTRL_CLEAR_EXTRA_CHAIN_CERTS = 83;
  {$EXTERNALSYM SSL_CTRL_CHAIN}  //OpenSSL 1.0.2
  SSL_CTRL_CHAIN = 88;
  {$EXTERNALSYM SSL_CTRL_CHAIN_CERT} //OpenSSL 1.0.2
  SSL_CTRL_CHAIN_CERT = 89;
  {$EXTERNALSYM SSL_CTRL_GET_CHAIN_CERTS} //OpenSSL 1.0.2
  SSL_CTRL_GET_CHAIN_CERTS = 115;
  {$EXTERNALSYM SSL_CTRL_GET_SESSION_REUSED}
  SSL_CTRL_GET_SESSION_REUSED = 8;
  {$EXTERNALSYM SSL_CTRL_GET_CLIENT_CERT_REQUEST}
  SSL_CTRL_GET_CLIENT_CERT_REQUEST = 9;
  {$EXTERNALSYM SSL_CTRL_GET_NUM_RENEGOTIATIONS}
  SSL_CTRL_GET_NUM_RENEGOTIATIONS = 10;
  {$EXTERNALSYM SSL_CTRL_CLEAR_NUM_RENEGOTIATIONS}
  SSL_CTRL_CLEAR_NUM_RENEGOTIATIONS = 11;
  {$EXTERNALSYM SSL_CTRL_GET_TOTAL_RENEGOTIATIONS}
  SSL_CTRL_GET_TOTAL_RENEGOTIATIONS = 12;
  {$EXTERNALSYM SSL_CTRL_GET_FLAGS}
  SSL_CTRL_GET_FLAGS = 13;
  {$EXTERNALSYM SSL_CTRL_EXTRA_CHAIN_CERT}
  SSL_CTRL_EXTRA_CHAIN_CERT = 14;
  {$EXTERNALSYM SSL_CTRL_SET_MSG_CALLBACK}
  SSL_CTRL_SET_MSG_CALLBACK             = 15;
  {$EXTERNALSYM SSL_CTRL_SET_MSG_CALLBACK_ARG}
  SSL_CTRL_SET_MSG_CALLBACK_ARG         = 16;
//* only applies to datagram connections */
  {$EXTERNALSYM SSL_CTRL_SET_MTU}
  SSL_CTRL_SET_MTU               = 17;
//* Stats */
  {$EXTERNALSYM SSL_CTRL_SESS_NUMBER}
  SSL_CTRL_SESS_NUMBER = 20;
  {$EXTERNALSYM SSL_CTRL_SESS_CONNECT}
  SSL_CTRL_SESS_CONNECT = 21;
  {$EXTERNALSYM SSL_CTRL_SESS_CONNECT_GOOD}
  SSL_CTRL_SESS_CONNECT_GOOD = 22;
  {$EXTERNALSYM SSL_CTRL_SESS_CONNECT_RENEGOTIATE}
  SSL_CTRL_SESS_CONNECT_RENEGOTIATE = 23;
  {$EXTERNALSYM SSL_CTRL_SESS_ACCEPT}
  SSL_CTRL_SESS_ACCEPT = 24;
  {$EXTERNALSYM SSL_CTRL_SESS_ACCEPT_GOOD}
  SSL_CTRL_SESS_ACCEPT_GOOD = 25;
  {$EXTERNALSYM SSL_CTRL_SESS_ACCEPT_RENEGOTIATE}
  SSL_CTRL_SESS_ACCEPT_RENEGOTIATE = 26;
  {$EXTERNALSYM SSL_CTRL_SESS_HIT}
  SSL_CTRL_SESS_HIT = 27;
  {$EXTERNALSYM SSL_CTRL_SESS_CB_HIT}
  SSL_CTRL_SESS_CB_HIT = 28;
  {$EXTERNALSYM SSL_CTRL_SESS_MISSES}
  SSL_CTRL_SESS_MISSES = 29;
  {$EXTERNALSYM SSL_CTRL_SESS_TIMEOUTS}
  SSL_CTRL_SESS_TIMEOUTS = 30;
  {$EXTERNALSYM SSL_CTRL_SESS_CACHE_FULL}
  SSL_CTRL_SESS_CACHE_FULL = 31;
  {$EXTERNALSYM SSL_CTRL_OPTIONS}
  SSL_CTRL_OPTIONS = 32;
  {$EXTERNALSYM SSL_CTRL_MODE}
  SSL_CTRL_MODE = 33;
  {$EXTERNALSYM SSL_CTRL_GET_READ_AHEAD}
  SSL_CTRL_GET_READ_AHEAD = 40;
  {$EXTERNALSYM SSL_CTRL_SET_READ_AHEAD}
  SSL_CTRL_SET_READ_AHEAD = 41;
  {$EXTERNALSYM SSL_CTRL_SET_SESS_CACHE_SIZE}
  SSL_CTRL_SET_SESS_CACHE_SIZE = 42;
  {$EXTERNALSYM SSL_CTRL_GET_SESS_CACHE_SIZE}
  SSL_CTRL_GET_SESS_CACHE_SIZE = 43;
  {$EXTERNALSYM SSL_CTRL_SET_SESS_CACHE_MODE}
  SSL_CTRL_SET_SESS_CACHE_MODE = 44;
  {$EXTERNALSYM SSL_CTRL_GET_SESS_CACHE_MODE}
  SSL_CTRL_GET_SESS_CACHE_MODE = 45;
  {$EXTERNALSYM SSL_CTRL_GET_MAX_CERT_LIST}
  SSL_CTRL_GET_MAX_CERT_LIST = 50;
  {$EXTERNALSYM SSL_CTRL_SET_MAX_CERT_LIST}
  SSL_CTRL_SET_MAX_CERT_LIST = 51;
  {$EXTERNALSYM SSL_CTRL_SET_MAX_SEND_FRAGMENT}
  SSL_CTRL_SET_MAX_SEND_FRAGMENT = 52;

  {$EXTERNALSYM SSL_DEFAULT_CIPHER_LIST}
  SSL_DEFAULT_CIPHER_LIST = 'AES:ALL:!aNULL:!eNULL:+RC4:@STRENGTH'; //* low priority for RC4 */
  {$EXTERNALSYM SSL_ERROR_NONE}
  SSL_ERROR_NONE = 0;
  {$EXTERNALSYM SSL_ERROR_SSL}
  SSL_ERROR_SSL = 1;
  {$EXTERNALSYM SSL_ERROR_WANT_READ}
  SSL_ERROR_WANT_READ = 2;
  {$EXTERNALSYM SSL_ERROR_WANT_WRITE}
  SSL_ERROR_WANT_WRITE = 3;
  {$EXTERNALSYM SSL_ERROR_WANT_X509_LOOKUP}
  SSL_ERROR_WANT_X509_LOOKUP = 4;
  {$EXTERNALSYM SSL_ERROR_SYSCALL}
  SSL_ERROR_SYSCALL = 5;
  {$EXTERNALSYM SSL_ERROR_ZERO_RETURN}
  SSL_ERROR_ZERO_RETURN = 6;
  {$EXTERNALSYM SSL_ERROR_WANT_CONNECT}
  SSL_ERROR_WANT_CONNECT = 7;
  {$EXTERNALSYM SSL_ERROR_WANT_ACCEPT}
  SSL_ERROR_WANT_ACCEPT = 8;
  {$EXTERNALSYM X509_FILETYPE_ASN1}
  X509_FILETYPE_ASN1 = 2;
  {$EXTERNALSYM SSL_FILETYPE_ASN1}
  SSL_FILETYPE_ASN1 = X509_FILETYPE_ASN1;
  {$EXTERNALSYM X509_FILETYPE_PEM}
  X509_FILETYPE_PEM = 1;
  {$EXTERNALSYM SSL_FILETYPE_PEM}
  SSL_FILETYPE_PEM = X509_FILETYPE_PEM;
  {$EXTERNALSYM SSL_F_CLIENT_CERTIFICATE}
  SSL_F_CLIENT_CERTIFICATE = 100;
  {$EXTERNALSYM SSL_F_CLIENT_HELLO}
  SSL_F_CLIENT_HELLO = 101;
  {$EXTERNALSYM SSL_F_CLIENT_MASTER_KEY}
  SSL_F_CLIENT_MASTER_KEY = 102;
  {$EXTERNALSYM SSL_F_D2I_SSL_SESSION}
  SSL_F_D2I_SSL_SESSION = 103;
  {$EXTERNALSYM SSL_F_DO_SSL3_WRITE}
  SSL_F_DO_SSL3_WRITE = 104;
  {$EXTERNALSYM SSL_F_DTLS1_ACCEPT}
  SSL_F_DTLS1_ACCEPT = 246;
  {$EXTERNALSYM SSL_F_DTLS1_ADD_CERT_TO_BUF}
  SSL_F_DTLS1_ADD_CERT_TO_BUF	= 295; //was 280;
  {$EXTERNALSYM SSL_F_DTLS1_BUFFER_RECORD}
  SSL_F_DTLS1_BUFFER_RECORD = 247;
  {$EXTERNALSYM SSL_F_DTLS1_CHECK_TIMEOUT_NUM}
  SSL_F_DTLS1_CHECK_TIMEOUT_NUM	= 316;
  {$EXTERNALSYM SSL_F_DTLS1_CLIENT_HELLO}
  SSL_F_DTLS1_CLIENT_HELLO = 248;
  {$EXTERNALSYM SSL_F_DTLS1_CONNECT}
  SSL_F_DTLS1_CONNECT = 249;
  {$EXTERNALSYM SSL_F_DTLS1_ENC}
  SSL_F_DTLS1_ENC = 250;
  {$EXTERNALSYM SSL_F_DTLS1_GET_HELLO_VERIFY}
  SSL_F_DTLS1_GET_HELLO_VERIFY = 251;
  {$EXTERNALSYM SSL_F_DTLS1_GET_MESSAGE}
  SSL_F_DTLS1_GET_MESSAGE = 252;
  {$EXTERNALSYM SSL_F_DTLS1_GET_MESSAGE_FRAGMENT}
  SSL_F_DTLS1_GET_MESSAGE_FRAGMENT = 253;
  {$EXTERNALSYM SSL_F_DTLS1_GET_RECORD}
  SSL_F_DTLS1_GET_RECORD = 254;
  {$EXTERNALSYM SSL_F_DTLS1_HANDLE_TIMEOUT}
  SSL_F_DTLS1_HANDLE_TIMEOUT = 297; //was 282
  {$EXTERNALSYM SSL_F_DTLS1_HEARTBEAT}
  SSL_F_DTLS1_HEARTBEAT	= 305;
  {$EXTERNALSYM SSL_F_DTLS1_OUTPUT_CERT_CHAIN}
  SSL_F_DTLS1_OUTPUT_CERT_CHAIN = 255;
  {$EXTERNALSYM SSL_F_DTLS1_PREPROCESS_FRAGMENT}
  SSL_F_DTLS1_PREPROCESS_FRAGMENT = 288; //was 277;
  {$EXTERNALSYM SSL_F_DTLS1_PROCESS_OUT_OF_SEQ_MESSAGE}
  SSL_F_DTLS1_PROCESS_OUT_OF_SEQ_MESSAGE = 256;
  {$EXTERNALSYM SSL_F_DTLS1_PROCESS_RECORD}
  SSL_F_DTLS1_PROCESS_RECORD = 257;
  {$EXTERNALSYM SSL_F_DTLS1_READ_BYTES}
  SSL_F_DTLS1_READ_BYTES = 258;
  {$EXTERNALSYM SSL_F_DTLS1_READ_FAILED}
  SSL_F_DTLS1_READ_FAILED = 259;
  {$EXTERNALSYM SSL_F_DTLS1_SEND_CERTIFICATE_REQUEST}
  SSL_F_DTLS1_SEND_CERTIFICATE_REQUEST = 260;
  {$EXTERNALSYM SSL_F_DTLS1_SEND_CLIENT_CERTIFICATE}
  SSL_F_DTLS1_SEND_CLIENT_CERTIFICATE = 261;
  {$EXTERNALSYM SSL_F_DTLS1_SEND_CLIENT_KEY_EXCHANGE}
  SSL_F_DTLS1_SEND_CLIENT_KEY_EXCHANGE = 262;
  {$EXTERNALSYM SSL_F_DTLS1_SEND_CLIENT_VERIFY}
  SSL_F_DTLS1_SEND_CLIENT_VERIFY = 263;
  {$EXTERNALSYM SSL_F_DTLS1_SEND_HELLO_VERIFY_REQUEST}
  SSL_F_DTLS1_SEND_HELLO_VERIFY_REQUEST = 264;
  {$EXTERNALSYM SSL_F_DTLS1_SEND_SERVER_CERTIFICATE}
  SSL_F_DTLS1_SEND_SERVER_CERTIFICATE = 265;
  {$EXTERNALSYM SSL_F_DTLS1_SEND_SERVER_HELLO}
  SSL_F_DTLS1_SEND_SERVER_HELLO = 266;
  {$EXTERNALSYM SSL_F_DTLS1_SEND_SERVER_KEY_EXCHANGE}
  SSL_F_DTLS1_SEND_SERVER_KEY_EXCHANGE = 267;
  {$EXTERNALSYM SSL_F_DTLS1_WRITE_APP_DATA_BYTES}
  SSL_F_DTLS1_WRITE_APP_DATA_BYTES = 268;
  {$EXTERNALSYM SSL_F_GET_CLIENT_FINISHED}
  SSL_F_GET_CLIENT_FINISHED = 105;
  {$EXTERNALSYM SSL_F_GET_CLIENT_HELLO}
  SSL_F_GET_CLIENT_HELLO = 106;
  {$EXTERNALSYM SSL_F_GET_CLIENT_MASTER_KEY}
  SSL_F_GET_CLIENT_MASTER_KEY = 107;
  {$EXTERNALSYM SSL_F_GET_SERVER_FINISHED}
  SSL_F_GET_SERVER_FINISHED = 108;
  {$EXTERNALSYM SSL_F_GET_SERVER_HELLO}
  SSL_F_GET_SERVER_HELLO = 109;
  {$EXTERNALSYM SSL_F_GET_SERVER_VERIFY}
  SSL_F_GET_SERVER_VERIFY = 110;
  {$EXTERNALSYM SSL_F_I2D_SSL_SESSION}
  SSL_F_I2D_SSL_SESSION = 111;
  {$EXTERNALSYM SSL_F_READ_N}
  SSL_F_READ_N = 112;
  {$EXTERNALSYM SSL_F_REQUEST_CERTIFICATE}
  SSL_F_REQUEST_CERTIFICATE = 113;
  {$EXTERNALSYM SSL_F_SERVER_HELLO}
  SSL_F_SERVER_HELLO = 114;
  {$EXTERNALSYM SSL_F_SSL23_ACCEPT}
  SSL_F_SSL23_ACCEPT = 115;
  {$EXTERNALSYM SSL_F_SSL3_ADD_CERT_TO_BUF}
  SSL_F_SSL3_ADD_CERT_TO_BUF = 296; //was 281;

  {$EXTERNALSYM SSL_F_SSL23_CLIENT_HELLO}
  SSL_F_SSL23_CLIENT_HELLO = 116;
  {$EXTERNALSYM SSL_F_SSL23_CONNECT}
  SSL_F_SSL23_CONNECT = 117;
  {$EXTERNALSYM SSL_F_SSL23_GET_CLIENT_HELLO}
  SSL_F_SSL23_GET_CLIENT_HELLO = 118;
  {$EXTERNALSYM SSL_F_SSL23_GET_SERVER_HELLO}
  SSL_F_SSL23_GET_SERVER_HELLO = 119;
  {$EXTERNALSYM SSL_F_SSL23_READ}
  SSL_F_SSL23_READ = 120;
  {$EXTERNALSYM SSL_F_SSL23_WRITE}
  SSL_F_SSL23_WRITE = 121;
  {$EXTERNALSYM SSL_F_SSL2_ACCEPT}
  SSL_F_SSL2_ACCEPT = 122;
  {$EXTERNALSYM SSL_F_SSL2_CONNECT}
  SSL_F_SSL2_CONNECT = 123;
  {$EXTERNALSYM SSL_F_SSL2_ENC_INIT}
  SSL_F_SSL2_ENC_INIT = 124;
  {$EXTERNALSYM SSL_F_SSL2_READ}
  SSL_F_SSL2_READ = 125;
  {$EXTERNALSYM SSL_F_SSL2_SET_CERTIFICATE}
  SSL_F_SSL2_SET_CERTIFICATE = 126;
  {$EXTERNALSYM SSL_F_SSL2_WRITE}
  SSL_F_SSL2_WRITE = 127;
  {$EXTERNALSYM SSL_F_SSL3_ACCEPT}
  SSL_F_SSL3_ACCEPT = 128;
  {$EXTERNALSYM SSL_F_SSL3_CHANGE_CIPHER_STATE}
  SSL_F_SSL3_CHANGE_CIPHER_STATE = 129;
  {$EXTERNALSYM SSL_F_SSL3_CHECK_CERT_AND_ALGORITHM}
  SSL_F_SSL3_CHECK_CERT_AND_ALGORITHM = 130;
  {$EXTERNALSYM SSL_F_SSL3_CHECK_CLIENT_HELLO}
  SSL_F_SSL3_CHECK_CLIENT_HELLO = 304;
  {$EXTERNALSYM SSL_F_SSL3_CLIENT_HELLO}
  SSL_F_SSL3_CLIENT_HELLO = 131;
  {$EXTERNALSYM SSL_F_SSL3_CONNECT}
  SSL_F_SSL3_CONNECT = 132;
  {$EXTERNALSYM SSL_F_SSL3_CTRL}
  SSL_F_SSL3_CTRL = 213;
  {$EXTERNALSYM SSL_F_SSL3_CTX_CTRL}
  SSL_F_SSL3_CTX_CTRL = 133;
  {$EXTERNALSYM SSL_F_SSL3_DIGEST_CACHED_RECORDS}
  SSL_F_SSL3_DIGEST_CACHED_RECORDS = 293;
  {$EXTERNALSYM SSL_F_SSL3_DO_CHANGE_CIPHER_SPEC}
  SSL_F_SSL3_DO_CHANGE_CIPHER_SPEC = 292;//was 279;
  {$EXTERNALSYM SSL_F_SSL3_ENC}
  SSL_F_SSL3_ENC = 134;
  {$EXTERNALSYM SSL_F_SSL3_GET_CERTIFICATE_REQUEST}
  SSL_F_SSL3_GET_CERTIFICATE_REQUEST = 135;
  {$EXTERNALSYM SSL_F_SSL3_GET_CERT_STATUS}
  SSL_F_SSL3_GET_CERT_STATUS = 289;//was 288;
  {$EXTERNALSYM SSL_F_SSL3_GET_CERT_VERIFY}
  SSL_F_SSL3_GET_CERT_VERIFY = 136;
  {$EXTERNALSYM SSL_F_SSL3_GET_CLIENT_CERTIFICATE}
  SSL_F_SSL3_GET_CLIENT_CERTIFICATE = 137;
  {$EXTERNALSYM SSL_F_SSL3_GET_CLIENT_HELLO}
  SSL_F_SSL3_GET_CLIENT_HELLO = 138;
  {$EXTERNALSYM SSL_F_SSL3_GET_CLIENT_KEY_EXCHANGE}
  SSL_F_SSL3_GET_CLIENT_KEY_EXCHANGE = 139;
  {$EXTERNALSYM SSL_F_SSL3_GET_FINISHED}
  SSL_F_SSL3_GET_FINISHED = 140;
  {$EXTERNALSYM SSL_F_SSL3_GET_KEY_EXCHANGE}
  SSL_F_SSL3_GET_KEY_EXCHANGE = 141;
  {$EXTERNALSYM SSL_F_SSL3_GET_MESSAGE}
  SSL_F_SSL3_GET_MESSAGE = 142;
  {$EXTERNALSYM SSL_F_SSL3_GET_NEW_SESSION_TICKET}
  SSL_F_SSL3_GET_NEW_SESSION_TICKET = 283;
  {$EXTERNALSYM SSL_F_SSL3_GET_NEXT_PROTO}
  SSL_F_SSL3_GET_NEXT_PROTO	= 306;
  {$EXTERNALSYM SSL_F_SSL3_GET_RECORD}
  SSL_F_SSL3_GET_RECORD = 143;
  {$EXTERNALSYM SSL_F_SSL3_GET_SERVER_CERTIFICATE}
  SSL_F_SSL3_GET_SERVER_CERTIFICATE = 144;
  {$EXTERNALSYM SSL_F_SSL3_GET_SERVER_DONE}
  SSL_F_SSL3_GET_SERVER_DONE = 145;
  {$EXTERNALSYM SSL_F_SSL3_GET_SERVER_HELLO}
  SSL_F_SSL3_GET_SERVER_HELLO = 146;
  {$EXTERNALSYM SSL_F_SSL3_HANDSHAKE_MAC}
  SSL_F_SSL3_HANDSHAKE_MAC = 285;
  {$EXTERNALSYM SSL_F_SSL3_NEW_SESSION_TICKET}
  SSL_F_SSL3_NEW_SESSION_TICKET = 287; //was 284;
  {$EXTERNALSYM SSL_F_SSL3_OUTPUT_CERT_CHAIN}
  SSL_F_SSL3_OUTPUT_CERT_CHAIN = 147;
  {$EXTERNALSYM SSL_F_SSL3_READ_BYTES}
  SSL_F_SSL3_READ_BYTES = 148;
  {$EXTERNALSYM SSL_F_SSL3_READ_N}
  SSL_F_SSL3_READ_N = 149;
  {$EXTERNALSYM SSL_F_SSL3_SEND_CERTIFICATE_REQUEST}
  SSL_F_SSL3_SEND_CERTIFICATE_REQUEST = 150;
  {$EXTERNALSYM SSL_F_SSL3_SEND_CLIENT_CERTIFICATE}
  SSL_F_SSL3_SEND_CLIENT_CERTIFICATE = 151;
  {$EXTERNALSYM SSL_F_SSL3_SEND_CLIENT_KEY_EXCHANGE}
  SSL_F_SSL3_SEND_CLIENT_KEY_EXCHANGE = 152;
  {$EXTERNALSYM SSL_F_SSL3_SEND_CLIENT_VERIFY}
  SSL_F_SSL3_SEND_CLIENT_VERIFY = 153;
  {$EXTERNALSYM SSL_F_SSL3_SEND_SERVER_CERTIFICATE}
  SSL_F_SSL3_SEND_SERVER_CERTIFICATE = 154;
  {$EXTERNALSYM SSL_F_SSL3_SEND_SERVER_KEY_EXCHANGE}
  SSL_F_SSL3_SEND_SERVER_KEY_EXCHANGE = 155;
  {$EXTERNALSYM SSL_F_SSL3_SETUP_KEY_BLOCK}
  SSL_F_SSL3_SETUP_KEY_BLOCK = 157;
  {$EXTERNALSYM SSL_F_SSL3_SETUP_READ_BUFFER}
  SSL_F_SSL3_SETUP_READ_BUFFER = 156;
  {$EXTERNALSYM SSL_F_SSL3_SETUP_WRITE_BUFFER}
  SSL_F_SSL3_SETUP_WRITE_BUFFER	= 291;
  {$EXTERNALSYM SSL_F_SSL3_WRITE_BYTES}
  SSL_F_SSL3_WRITE_BYTES = 158;
  {$EXTERNALSYM SSL_F_SSL3_WRITE_PENDING}
  SSL_F_SSL3_WRITE_PENDING = 159;
  {$EXTERNALSYM SSL_F_SSL_ADD_CLIENTHELLO_RENEGOTIATE_EXT}
  SSL_F_SSL_ADD_CLIENTHELLO_RENEGOTIATE_EXT = 298;//was 285;
  {$EXTERNALSYM SSL_F_SSL_ADD_CLIENTHELLO_TLSEXT}
  SSL_F_SSL_ADD_CLIENTHELLO_TLSEXT = 277; //was 272;
  {$EXTERNALSYM SSL_F_SSL_ADD_CLIENTHELLO_USE_SRTP_EXT}
  SSL_F_SSL_ADD_CLIENTHELLO_USE_SRTP_EXT = 307;
  {$EXTERNALSYM SSL_F_SSL_ADD_DIR_CERT_SUBJECTS_TO_STACK}
  SSL_F_SSL_ADD_DIR_CERT_SUBJECTS_TO_STACK = 215;
  {$EXTERNALSYM SSL_F_SSL_ADD_FILE_CERT_SUBJECTS_TO_STACK}
  SSL_F_SSL_ADD_FILE_CERT_SUBJECTS_TO_STACK = 216;
  {$EXTERNALSYM SSL_F_SSL_ADD_SERVERHELLO_RENEGOTIATE_EXT}
  SSL_F_SSL_ADD_SERVERHELLO_RENEGOTIATE_EXT = 299;//was 286;
  {$EXTERNALSYM SSL_F_SSL_ADD_SERVERHELLO_TLSEXT}
  SSL_F_SSL_ADD_SERVERHELLO_TLSEXT = 278; //was 273;
  {$EXTERNALSYM SSL_F_SSL_ADD_SERVERHELLO_USE_SRTP_EXT}
  SSL_F_SSL_ADD_SERVERHELLO_USE_SRTP_EXT = 308;
  {$EXTERNALSYM SSL_F_SSL_BAD_METHOD}
  SSL_F_SSL_BAD_METHOD = 160;
  {$EXTERNALSYM SSL_F_SSL_BYTES_TO_CIPHER_LIST}
  SSL_F_SSL_BYTES_TO_CIPHER_LIST = 161;
  {$EXTERNALSYM SSL_F_SSL_CERT_DUP}
  SSL_F_SSL_CERT_DUP = 221;
  {$EXTERNALSYM SSL_F_SSL_CERT_INST}
  SSL_F_SSL_CERT_INST = 222;
  {$EXTERNALSYM SSL_F_SSL_CERT_INSTANTIATE}
  SSL_F_SSL_CERT_INSTANTIATE = 214;
  {$EXTERNALSYM SSL_F_SSL_CERT_NEW}
  SSL_F_SSL_CERT_NEW = 162;
  {$EXTERNALSYM SSL_F_SSL_CHECK_PRIVATE_KEY}
  SSL_F_SSL_CHECK_PRIVATE_KEY = 163;
  {$EXTERNALSYM SSL_F_SSL_CHECK_SERVERHELLO_TLSEXT}
  SSL_F_SSL_CHECK_SERVERHELLO_TLSEXT = 280;//was 274;
  {$EXTERNALSYM SSL_F_SSL_CHECK_SRVR_ECC_CERT_AND_ALG}
  SSL_F_SSL_CHECK_SRVR_ECC_CERT_AND_ALG	= 279;
  {$EXTERNALSYM SSL_F_SSL_CIPHER_PROCESS_RULESTR}
  SSL_F_SSL_CIPHER_PROCESS_RULESTR = 230;
  {$EXTERNALSYM SSL_F_SSL_CIPHER_STRENGTH_SORT}
  SSL_F_SSL_CIPHER_STRENGTH_SORT = 231;
  {$EXTERNALSYM SSL_F_SSL_CLEAR}
  SSL_F_SSL_CLEAR = 164;
  {$EXTERNALSYM SSL_F_SSL_COMP_ADD_COMPRESSION_METHOD}
  SSL_F_SSL_COMP_ADD_COMPRESSION_METHOD = 165;
  {$EXTERNALSYM SSL_F_SSL_CREATE_CIPHER_LIST}
  SSL_F_SSL_CREATE_CIPHER_LIST = 166;
  {$EXTERNALSYM SSL_F_SSL_CTRL}
  SSL_F_SSL_CTRL = 232;
  {$EXTERNALSYM SSL_F_SSL_CTX_CHECK_PRIVATE_KEY}
  SSL_F_SSL_CTX_CHECK_PRIVATE_KEY = 168;
  {$EXTERNALSYM SSL_F_SSL_CTX_MAKE_PROFILES}
  SSL_F_SSL_CTX_MAKE_PROFILES	= 309;
  {$EXTERNALSYM SSL_F_SSL_CTX_NEW}
  SSL_F_SSL_CTX_NEW = 169;
  {$EXTERNALSYM SSL_F_SSL_CTX_SET_CIPHER_LIST}
  SSL_F_SSL_CTX_SET_CIPHER_LIST = 269;
  {$EXTERNALSYM SSL_F_SSL_CTX_SET_CLIENT_CERT_ENGINE}
  SSL_F_SSL_CTX_SET_CLIENT_CERT_ENGINE = 290; //was 278;
  {$EXTERNALSYM SSL_F_SSL_CTX_SET_PURPOSE}
  SSL_F_SSL_CTX_SET_PURPOSE = 226;
  {$EXTERNALSYM SSL_F_SSL_CTX_SET_SESSION_ID_CONTEXT}
  SSL_F_SSL_CTX_SET_SESSION_ID_CONTEXT = 219;
  {$EXTERNALSYM SSL_F_SSL_CTX_SET_SSL_VERSION}
  SSL_F_SSL_CTX_SET_SSL_VERSION = 170;
  {$EXTERNALSYM SSL_F_SSL_CTX_SET_TRUST}
  SSL_F_SSL_CTX_SET_TRUST	= 229;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_CERTIFICATE}
  SSL_F_SSL_CTX_USE_CERTIFICATE = 171;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_CERTIFICATE_ASN1}
  SSL_F_SSL_CTX_USE_CERTIFICATE_ASN1 = 172;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_CERTIFICATE_CHAIN_FILE}
  SSL_F_SSL_CTX_USE_CERTIFICATE_CHAIN_FILE = 220;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_CERTIFICATE_FILE}
  SSL_F_SSL_CTX_USE_CERTIFICATE_FILE = 173;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_PRIVATEKEY}
  SSL_F_SSL_CTX_USE_PRIVATEKEY = 174;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_PRIVATEKEY_ASN1}
  SSL_F_SSL_CTX_USE_PRIVATEKEY_ASN1 = 175;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_PRIVATEKEY_FILE}
  SSL_F_SSL_CTX_USE_PRIVATEKEY_FILE = 176;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_PSK_IDENTITY_HINT}
  SSL_F_SSL_CTX_USE_PSK_IDENTITY_HINT	= 272;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_RSAPRIVATEKEY}
  SSL_F_SSL_CTX_USE_RSAPRIVATEKEY = 177;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_RSAPRIVATEKEY_ASN1}
  SSL_F_SSL_CTX_USE_RSAPRIVATEKEY_ASN1 = 178;
  {$EXTERNALSYM SSL_F_SSL_CTX_USE_RSAPRIVATEKEY_FILE}
  SSL_F_SSL_CTX_USE_RSAPRIVATEKEY_FILE = 179;
  {$EXTERNALSYM SSL_F_SSL_DO_HANDSHAKE}
  SSL_F_SSL_DO_HANDSHAKE = 180;
  {$EXTERNALSYM SSL_F_SSL_GET_NEW_SESSION}
  SSL_F_SSL_GET_NEW_SESSION = 181;
  {$EXTERNALSYM SSL_F_SSL_GET_PREV_SESSION}
  SSL_F_SSL_GET_PREV_SESSION = 217;
  {$EXTERNALSYM SSL_F_SSL_GET_SERVER_SEND_CERT}
  SSL_F_SSL_GET_SERVER_SEND_CERT = 182;
  {$EXTERNALSYM SSL_F_SSL_GET_SERVER_SEND_PKEY}
  SSL_F_SSL_GET_SERVER_SEND_PKEY = 317;
  {$EXTERNALSYM SSL_F_SSL_GET_SIGN_PKEY}
  SSL_F_SSL_GET_SIGN_PKEY = 183;
  {$EXTERNALSYM SSL_F_SSL_INIT_WBIO_BUFFER}
  SSL_F_SSL_INIT_WBIO_BUFFER = 184;
  {$EXTERNALSYM SSL_F_SSL_LOAD_CLIENT_CA_FILE}
  SSL_F_SSL_LOAD_CLIENT_CA_FILE = 185;
  {$EXTERNALSYM SSL_F_SSL_NEW}
  SSL_F_SSL_NEW = 186;
  {$EXTERNALSYM SSL_F_SSL_PARSE_CLIENTHELLO_RENEGOTIATE_EXT}
  SSL_F_SSL_PARSE_CLIENTHELLO_RENEGOTIATE_EXT = 300; //was 287;
  {$EXTERNALSYM SSL_F_SSL_PARSE_CLIENTHELLO_TLSEXT}
  SSL_F_SSL_PARSE_CLIENTHELLO_TLSEXT = 302; //was 290;
  {$EXTERNALSYM SSL_F_SSL_PARSE_CLIENTHELLO_USE_SRTP_EXT}
  SSL_F_SSL_PARSE_CLIENTHELLO_USE_SRTP_EXT = 310;
  {$EXTERNALSYM SSL_F_SSL_PARSE_SERVERHELLO_RENEGOTIATE_EXT}
  SSL_F_SSL_PARSE_SERVERHELLO_RENEGOTIATE_EXT	= 301;//was 289;
  {$EXTERNALSYM SSL_F_SSL_PARSE_SERVERHELLO_TLSEXT}
  SSL_F_SSL_PARSE_SERVERHELLO_TLSEXT = 303; //was 291;
  {$EXTERNALSYM SSL_F_SSL_PARSE_SERVERHELLO_USE_SRTP_EXT}
  SSL_F_SSL_PARSE_SERVERHELLO_USE_SRTP_EXT = 311;
  {$EXTERNALSYM SSL_F_SSL_PEEK}
  SSL_F_SSL_PEEK = 270;
  {$EXTERNALSYM SSL_F_SSL_PREPARE_CLIENTHELLO_TLSEXT}
  SSL_F_SSL_PREPARE_CLIENTHELLO_TLSEXT = 281; //was 275;
  {$EXTERNALSYM SSL_F_SSL_PREPARE_SERVERHELLO_TLSEXT}
  SSL_F_SSL_PREPARE_SERVERHELLO_TLSEXT = 282;//was 276;
  {$EXTERNALSYM SSL_F_SSL_READ}
  SSL_F_SSL_READ = 223;
  {$EXTERNALSYM SSL_F_SSL_RSA_PRIVATE_DECRYPT}
  SSL_F_SSL_RSA_PRIVATE_DECRYPT = 187;
  {$EXTERNALSYM SSL_F_SSL_RSA_PUBLIC_ENCRYPT}
  SSL_F_SSL_RSA_PUBLIC_ENCRYPT = 188;
  {$EXTERNALSYM SSL_F_SSL_SESSION_NEW}
  SSL_F_SSL_SESSION_NEW = 189;
  {$EXTERNALSYM SSL_F_SSL_SESSION_PRINT_FP}
  SSL_F_SSL_SESSION_PRINT_FP = 190;
  {$EXTERNALSYM SSL_F_SSL_SESSION_SET1_ID_CONTEXT}
  SSL_F_SSL_SESSION_SET1_ID_CONTEXT	= 312;
  {$EXTERNALSYM SSL_F_SSL_SESS_CERT_NEW}
  SSL_F_SSL_SESS_CERT_NEW = 225;
  {$EXTERNALSYM SSL_F_SSL_SET_CERT}
  SSL_F_SSL_SET_CERT = 191;
  {$EXTERNALSYM SSL_F_SSL_SET_FD}
  SSL_F_SSL_SET_FD = 192;
  {$EXTERNALSYM SSL_F_SSL_SET_PKEY}
  SSL_F_SSL_SET_PKEY = 193;
  {$EXTERNALSYM SSL_F_SSL_SET_RFD}
  SSL_F_SSL_SET_RFD = 194;
  {$EXTERNALSYM SSL_F_SSL_SET_SESSION}
  SSL_F_SSL_SET_SESSION = 195;
  {$EXTERNALSYM SSL_F_SSL_SET_SESSION_ID_CONTEXT}
  SSL_F_SSL_SET_SESSION_ID_CONTEXT = 218;
  {$EXTERNALSYM SSL_F_SSL_SET_SESSION_TICKET_EXT}
  SSL_F_SSL_SET_SESSION_TICKET_EXT = 294;
  {$EXTERNALSYM SSL_F_SSL_SET_WFD}
  SSL_F_SSL_SET_WFD = 196;
  {$EXTERNALSYM SSL_F_SSL_SHUTDOWN}
  SSL_F_SSL_SHUTDOWN = 224;
  {$EXTERNALSYM SSL_F_SSL_SRP_CTX_INIT}
  SSL_F_SSL_SRP_CTX_INIT = 313;
  {$EXTERNALSYM SSL_F_SSL_UNDEFINED_FUNCTION}
  SSL_F_SSL_UNDEFINED_FUNCTION = 197;
  {$EXTERNALSYM SSL_F_SSL_USE_CERTIFICATE}
  SSL_F_SSL_USE_CERTIFICATE = 198;
  {$EXTERNALSYM SSL_F_SSL_USE_CERTIFICATE_ASN1}
  SSL_F_SSL_USE_CERTIFICATE_ASN1 = 199;
  {$EXTERNALSYM SSL_F_SSL_USE_CERTIFICATE_FILE}
  SSL_F_SSL_USE_CERTIFICATE_FILE = 200;
  {$EXTERNALSYM SSL_F_SSL_USE_PRIVATEKEY}
  SSL_F_SSL_USE_PRIVATEKEY = 201;
  {$EXTERNALSYM SSL_F_SSL_USE_PRIVATEKEY_ASN1}
  SSL_F_SSL_USE_PRIVATEKEY_ASN1 = 202;
  {$EXTERNALSYM SSL_F_SSL_USE_PRIVATEKEY_FILE}
  SSL_F_SSL_USE_PRIVATEKEY_FILE = 203;
  {$EXTERNALSYM SSL_F_SSL_USE_PSK_IDENTITY_HINT}
  SSL_F_SSL_USE_PSK_IDENTITY_HINT	= 273;
  {$EXTERNALSYM SSL_F_SSL_USE_RSAPRIVATEKEY}
  SSL_F_SSL_USE_RSAPRIVATEKEY = 204;
  {$EXTERNALSYM SSL_F_SSL_USE_RSAPRIVATEKEY_ASN1}
  SSL_F_SSL_USE_RSAPRIVATEKEY_ASN1 = 205;
  {$EXTERNALSYM SSL_F_SSL_USE_RSAPRIVATEKEY_FILE}
  SSL_F_SSL_USE_RSAPRIVATEKEY_FILE = 206;
  {$EXTERNALSYM SSL_F_SSL_VERIFY_CERT_CHAIN}
  SSL_F_SSL_VERIFY_CERT_CHAIN = 207;
  {$EXTERNALSYM SSL_F_SSL_WRITE}
  SSL_F_SSL_WRITE = 208;
  {$EXTERNALSYM SSL_F_TLS1_CERT_VERIFY_MAC}
  SSL_F_TLS1_CERT_VERIFY_MAC = 286;
  {$EXTERNALSYM SSL_F_TLS1_CHANGE_CIPHER_STATE}
  SSL_F_TLS1_CHANGE_CIPHER_STATE = 209;
  {$EXTERNALSYM SSL_F_TLS1_CHECK_SERVERHELLO_TLSEXT}
  SSL_F_TLS1_CHECK_SERVERHELLO_TLSEXT	= 274;
  {$EXTERNALSYM SSL_F_TLS1_ENC}
  SSL_F_TLS1_ENC = 210;
  {$EXTERNALSYM SSL_F_TLS1_EXPORT_KEYING_MATERIAL}
  SSL_F_TLS1_EXPORT_KEYING_MATERIAL = 314;
  {$EXTERNALSYM SSL_F_TLS1_HEARTBEAT}
  SSL_F_TLS1_HEARTBEAT = 315;
  {$EXTERNALSYM SSL_F_TLS1_PREPARE_CLIENTHELLO_TLSEXT}
  SSL_F_TLS1_PREPARE_CLIENTHELLO_TLSEXT	= 275;
  {$EXTERNALSYM SSL_F_TLS1_PREPARE_SERVERHELLO_TLSEXT}
  SSL_F_TLS1_PREPARE_SERVERHELLO_TLSEXT	= 276;
  {$EXTERNALSYM SSL_F_TLS1_PRF}
  SSL_F_TLS1_PRF = 284;
  {$EXTERNALSYM SSL_F_TLS1_SETUP_KEY_BLOCK}
  SSL_F_TLS1_SETUP_KEY_BLOCK = 211;
  {$EXTERNALSYM SSL_F_WRITE_PENDING}
  SSL_F_WRITE_PENDING = 212;
  {$EXTERNALSYM SSL_MAX_KEY_ARG_LENGTH}
  SSL_MAX_KEY_ARG_LENGTH = 8;
  {$EXTERNALSYM SSL_MAX_MASTER_KEY_LENGTH}
  SSL_MAX_MASTER_KEY_LENGTH = 48;
  {$EXTERNALSYM SSL_MAX_SID_CTX_LENGTH}
  SSL_MAX_SID_CTX_LENGTH = 32;
  {$EXTERNALSYM SSL_MAX_KRB5_PRINCIPAL_LENGTH}
  SSL_MAX_KRB5_PRINCIPAL_LENGTH = 256;
  {$EXTERNALSYM SSL_MAX_SSL_SESSION_ID_LENGTH}
  SSL_MAX_SSL_SESSION_ID_LENGTH = 32;
  {$EXTERNALSYM SSL_MODE_ENABLE_PARTIAL_WRITE}
  SSL_MODE_ENABLE_PARTIAL_WRITE       = $00000001;
  {$EXTERNALSYM SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER}
  SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER = $00000002;
  {$EXTERNALSYM SSL_MODE_AUTO_RETRY}
  SSL_MODE_AUTO_RETRY                 = $00000004;
  {$EXTERNALSYM SSL_MODE_NO_AUTO_CHAIN}
  SSL_MODE_NO_AUTO_CHAIN              = $00000008;
///* Save RAM by releasing read and write buffers when they're empty. (SSL3 and
// * TLS only.)  "Released" buffers are put onto a free-list in the context
// * or just freed (depending on the context's setting for freelist_max_len). */
  {$EXTERNALSYM SSL_MODE_RELEASE_BUFFERS}
  SSL_MODE_RELEASE_BUFFERS = $00000010;
  {$IFDEF OPENSSL_NO_BUF_FREELISTS}
  {$EXTERNALSYM SSL_MAX_BUF_FREELIST_LEN_DEFAULT}
  SSL_MAX_BUF_FREELIST_LEN_DEFAULT = 32;
  {$ENDIF}
  {$EXTERNALSYM SSL_NOTHING}
  SSL_NOTHING = 1;
   {$EXTERNALSYM SSL_WRITING}
  SSL_WRITING	= 2;
   {$EXTERNALSYM SSL_READING}
  SSL_READING	= 3;
   {$EXTERNALSYM SSL_X509_LOOKUP}
  SSL_X509_LOOKUP = 4;
  {$EXTERNALSYM SSL_OP_MICROSOFT_SESS_ID_BUG}
  SSL_OP_MICROSOFT_SESS_ID_BUG = $00000001;
  {$EXTERNALSYM SSL_OP_NETSCAPE_CHALLENGE_BUG}
  SSL_OP_NETSCAPE_CHALLENGE_BUG = $00000002;
//* Allow initial connection to servers that don't support RI */
  {$EXTERNALSYM SSL_OP_LEGACY_SERVER_CONNECT}
  SSL_OP_LEGACY_SERVER_CONNECT = $00000004;

  {$EXTERNALSYM SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG}
  SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG = $00000008;
  {$EXTERNALSYM SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG}
  SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG = $00000010;
  {$EXTERNALSYM SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER}
  SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER  = $00000020;
  {$EXTERNALSYM SSL_OP_MSIE_SSLV2_RSA_PADDING}
  SSL_OP_MSIE_SSLV2_RSA_PADDING      = $00000040;
  {$EXTERNALSYM SSL_OP_SSLEAY_080_CLIENT_DH_BUG}
  SSL_OP_SSLEAY_080_CLIENT_DH_BUG    = $00000080;
  {$EXTERNALSYM SSL_OP_TLS_D5_BUG}
  SSL_OP_TLS_D5_BUG                  = $00000100;
  {$EXTERNALSYM SSL_OP_TLS_BLOCK_PADDING_BUG}
  SSL_OP_TLS_BLOCK_PADDING_BUG       = $00000200;
  {$EXTERNALSYM SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS}
  SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS = $00000800;
  {$EXTERNALSYM SSL_OP_ALL}
  SSL_OP_ALL                         = $00000FFF; //this was $000FFFFF; before 0.9.7
  {$EXTERNALSYM SSL_OP_NO_QUERY_MTU}
  SSL_OP_NO_QUERY_MTU                           = $00001000;
  {$EXTERNALSYM SSL_OP_COOKIE_EXCHANGE}
  SSL_OP_COOKIE_EXCHANGE                        = $00002000;
  {$EXTERNALSYM SSL_OP_NO_TICKET}
  SSL_OP_NO_TICKET                              = $00004000;
//* Use Cisco's "speshul" version of DTLS_BAD_VER (as client)  */
  {$EXTERNALSYM SSL_OP_CISCO_ANYCONNECT}
  SSL_OP_CISCO_ANYCONNECT	= $00008000;
  {$EXTERNALSYM SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION}
  SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = $00010000;
//* Don't use compression even if supported */
  {$EXTERNALSYM SSL_OP_NO_COMPRESSION}
  SSL_OP_NO_COMPRESSION	= $00020000;
//* Permit unsafe legacy renegotiation */
  {$EXTERNALSYM SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION}
  SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION      = $00040000;

  {$EXTERNALSYM SSL_OP_SINGLE_ECDH_USE}
  SSL_OP_SINGLE_ECDH_USE                        = $00080000;
  {$EXTERNALSYM SSL_OP_SINGLE_DH_USE}
  SSL_OP_SINGLE_DH_USE                          = $00100000;
  {$EXTERNALSYM SSL_OP_EPHEMERAL_RSA}
  SSL_OP_EPHEMERAL_RSA                          = $00200000;
  {$EXTERNALSYM SSL_OP_CIPHER_SERVER_PREFERENCE}
  SSL_OP_CIPHER_SERVER_PREFERENCE               = $00400000;
  {$EXTERNALSYM SSL_OP_TLS_ROLLBACK_BUG}
  SSL_OP_TLS_ROLLBACK_BUG                       = $00800000; //was $00000400;
  {$EXTERNALSYM SSL_OP_NO_SSLv2}
  SSL_OP_NO_SSLv2 = $01000000;
  {$EXTERNALSYM SSL_OP_NO_SSLv3}
  SSL_OP_NO_SSLv3 = $02000000;
  {$EXTERNALSYM SSL_OP_NO_TLSv1}
  SSL_OP_NO_TLSv1 = $04000000;
  {$EXTERNALSYM SSL_OP_NO_TLSv1_2}
  SSL_OP_NO_TLSv1_2	= $08000000;
  {$EXTERNALSYM SSL_OP_NO_TLSv1_1}
  SSL_OP_NO_TLSv1_1	= $10000000;
  {$EXTERNALSYM SSL_OP_PKCS1_CHECK_1}
  SSL_OP_PKCS1_CHECK_1 = $00; //was $08000000;
  {$EXTERNALSYM SSL_OP_PKCS1_CHECK_2}
  SSL_OP_PKCS1_CHECK_2 = $00; //was $10000000;

  {$EXTERNALSYM SSL_OP_NETSCAPE_CA_DN_BUG}
  SSL_OP_NETSCAPE_CA_DN_BUG = $20000000;
  //OPENSSL_SSL_OP_NON_EXPORT_FIRST was removed for OpenSSL 0.9.7 (that was $40000000;)
  {$EXTERNALSYM SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG}
  SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG = $40000000;// was $80000000;
//* Make server add server-hello extension from early version of
// * cryptopro draft, when GOST ciphersuite is negotiated.
// * Required for interoperability with CryptoPro CSP 3.x
// */
  {$EXTERNALSYM SSL_OP_CRYPTOPRO_TLSEXT_BUG}
  SSL_OP_CRYPTOPRO_TLSEXT_BUG	= $80000000;

  {$EXTERNALSYM SSL_RECEIVED_SHUTDOWN}
  SSL_RECEIVED_SHUTDOWN = 2;
  {$EXTERNALSYM SSL_R_APP_DATA_IN_HANDSHAKE}
  SSL_R_APP_DATA_IN_HANDSHAKE = 100;
  {$EXTERNALSYM SSL_R_ATTEMPT_TO_REUSE_SESSION_IN_DIFFERENT_CONTEXT}
  SSL_R_ATTEMPT_TO_REUSE_SESSION_IN_DIFFERENT_CONTEXT = 272;
  {$EXTERNALSYM SSL_R_BAD_ALERT_RECORD}
  SSL_R_BAD_ALERT_RECORD = 101;
  {$EXTERNALSYM SSL_R_BAD_AUTHENTICATION_TYPE}
  SSL_R_BAD_AUTHENTICATION_TYPE = 102;
  {$EXTERNALSYM SSL_R_BAD_CHANGE_CIPHER_SPEC}
  SSL_R_BAD_CHANGE_CIPHER_SPEC = 103;
  {$EXTERNALSYM SSL_R_BAD_CHECKSUM}
  SSL_R_BAD_CHECKSUM = 104;
  {$EXTERNALSYM SSL_R_BAD_CLIENT_REQUEST}
  SSL_R_BAD_CLIENT_REQUEST = 105;
  {$EXTERNALSYM SSL_R_BAD_DATA_RETURNED_BY_CALLBACK}
  SSL_R_BAD_DATA_RETURNED_BY_CALLBACK = 106;
  {$EXTERNALSYM SSL_R_BAD_DECOMPRESSION}
  SSL_R_BAD_DECOMPRESSION = 107;
  {$EXTERNALSYM SSL_R_BAD_DH_G_LENGTH}
  SSL_R_BAD_DH_G_LENGTH = 108;
  {$EXTERNALSYM SSL_R_BAD_DH_PUB_KEY_LENGTH}
  SSL_R_BAD_DH_PUB_KEY_LENGTH = 109;
  {$EXTERNALSYM SSL_R_BAD_DH_P_LENGTH}
  SSL_R_BAD_DH_P_LENGTH = 110;
  {$EXTERNALSYM SSL_R_BAD_DIGEST_LENGTH}
  SSL_R_BAD_DIGEST_LENGTH = 111;
  {$EXTERNALSYM SSL_R_BAD_DSA_SIGNATURE}
  SSL_R_BAD_DSA_SIGNATURE = 112;
  {$EXTERNALSYM SSL_R_BAD_ECC_CERT}
  SSL_R_BAD_ECC_CERT			= 304;
  {$EXTERNALSYM SSL_R_BAD_ECDSA_SIGNATURE}
  SSL_R_BAD_ECDSA_SIGNATURE	 = 305;
  {$EXTERNALSYM SSL_R_BAD_ECPOINT}
  SSL_R_BAD_ECPOINT	 = 306;
  {$EXTERNALSYM SSL_R_BAD_HANDSHAKE_LENGTH}
  SSL_R_BAD_HANDSHAKE_LENGTH = 332;
  {$EXTERNALSYM SSL_R_BAD_HELLO_REQUEST}
  SSL_R_BAD_HELLO_REQUEST	= 105;
  {$EXTERNALSYM SSL_R_BAD_LENGTH}
  SSL_R_BAD_LENGTH = 271;
  {$EXTERNALSYM SSL_R_BAD_MAC_DECODE}
  SSL_R_BAD_MAC_DECODE = 113;
  {$EXTERNALSYM SSL_R_BAD_MAC_LENGTH}
  SSL_R_BAD_MAC_LENGTH = 333;
  {$EXTERNALSYM SSL_R_BAD_MESSAGE_TYPE}
  SSL_R_BAD_MESSAGE_TYPE = 114;
  {$EXTERNALSYM SSL_R_BAD_PACKET_LENGTH}
  SSL_R_BAD_PACKET_LENGTH = 115;
  {$EXTERNALSYM SSL_R_BAD_PROTOCOL_VERSION_NUMBER}
  SSL_R_BAD_PROTOCOL_VERSION_NUMBER = 116;
  {$EXTERNALSYM SSL_R_BAD_PSK_IDENTITY_HINT_LENGTH}
  SSL_R_BAD_PSK_IDENTITY_HINT_LENGTH = 316;
  {$EXTERNALSYM SSL_R_BAD_RESPONSE_ARGUMENT}
  SSL_R_BAD_RESPONSE_ARGUMENT = 117;
  {$EXTERNALSYM SSL_R_BAD_RSA_DECRYPT}
  SSL_R_BAD_RSA_DECRYPT = 118;
  {$EXTERNALSYM SSL_R_BAD_RSA_ENCRYPT}
  SSL_R_BAD_RSA_ENCRYPT = 119;
  {$EXTERNALSYM SSL_R_BAD_RSA_E_LENGTH}
  SSL_R_BAD_RSA_E_LENGTH = 120;
  {$EXTERNALSYM SSL_R_BAD_RSA_MODULUS_LENGTH}
  SSL_R_BAD_RSA_MODULUS_LENGTH = 121;
  {$EXTERNALSYM SSL_R_BAD_RSA_SIGNATURE}
  SSL_R_BAD_RSA_SIGNATURE = 122;
  {$EXTERNALSYM SSL_R_BAD_SIGNATURE}
  SSL_R_BAD_SIGNATURE = 123;
  {$EXTERNALSYM SSL_R_BAD_SRP_A_LENGTH}
  SSL_R_BAD_SRP_A_LENGTH = 347;
  {$EXTERNALSYM SSL_R_BAD_SRP_B_LENGTH}
  SSL_R_BAD_SRP_B_LENGTH = 348;
  {$EXTERNALSYM SSL_R_BAD_SRP_G_LENGTH}
  SSL_R_BAD_SRP_G_LENGTH = 349;
  {$EXTERNALSYM SSL_R_BAD_SRP_N_LENGTH}
  SSL_R_BAD_SRP_N_LENGTH = 350;
  {$EXTERNALSYM SSL_R_BAD_SRP_S_LENGTH}
  SSL_R_BAD_SRP_S_LENGTH = 351;
  {$EXTERNALSYM SSL_R_BAD_SRTP_MKI_VALUE}
  SSL_R_BAD_SRTP_MKI_VALUE = 352;
  {$EXTERNALSYM SSL_R_BAD_SRTP_PROTECTION_PROFILE_LIST}
  SSL_R_BAD_SRTP_PROTECTION_PROFILE_LIST = 353;

  {$EXTERNALSYM SSL_R_BAD_SSL_FILETYPE}
  SSL_R_BAD_SSL_FILETYPE = 124;
  {$EXTERNALSYM SSL_R_BAD_SSL_SESSION_ID_LENGTH}
  SSL_R_BAD_SSL_SESSION_ID_LENGTH = 125;
  {$EXTERNALSYM SSL_R_BAD_STATE}
  SSL_R_BAD_STATE = 126;
  {$EXTERNALSYM SSL_R_BAD_WRITE_RETRY}
  SSL_R_BAD_WRITE_RETRY = 127;
  {$EXTERNALSYM SSL_R_BIO_NOT_SET}
  SSL_R_BIO_NOT_SET = 128;
  {$EXTERNALSYM SSL_R_BLOCK_CIPHER_PAD_IS_WRONG}
  SSL_R_BLOCK_CIPHER_PAD_IS_WRONG = 129;
  {$EXTERNALSYM SSL_R_BN_LIB}
  SSL_R_BN_LIB = 130;
  {$EXTERNALSYM SSL_R_CA_DN_LENGTH_MISMATCH}
  SSL_R_CA_DN_LENGTH_MISMATCH = 131;
  {$EXTERNALSYM SSL_R_CA_DN_TOO_LONG}
  SSL_R_CA_DN_TOO_LONG = 132;
  {$EXTERNALSYM SSL_R_CCS_RECEIVED_EARLY}
  SSL_R_CCS_RECEIVED_EARLY = 133;
  {$EXTERNALSYM SSL_R_CERTIFICATE_VERIFY_FAILED}
  SSL_R_CERTIFICATE_VERIFY_FAILED = 134;
  {$EXTERNALSYM SSL_R_CERT_LENGTH_MISMATCH}
  SSL_R_CERT_LENGTH_MISMATCH = 135;
  {$EXTERNALSYM SSL_R_CHALLENGE_IS_DIFFERENT}
  SSL_R_CHALLENGE_IS_DIFFERENT = 136;
  {$EXTERNALSYM SSL_R_CIPHER_CODE_WRONG_LENGTH}
  SSL_R_CIPHER_CODE_WRONG_LENGTH = 137;
  {$EXTERNALSYM SSL_R_CIPHER_OR_HASH_UNAVAILABLE}
  SSL_R_CIPHER_OR_HASH_UNAVAILABLE = 138;
  {$EXTERNALSYM SSL_R_CIPHER_TABLE_SRC_ERROR}
  SSL_R_CIPHER_TABLE_SRC_ERROR = 139;
  {$EXTERNALSYM SSL_R_CLIENTHELLO_TLSEXT}
  SSL_R_CLIENTHELLO_TLSEXT = 226; //was 157;
  {$EXTERNALSYM SSL_R_COMPRESSED_LENGTH_TOO_LONG}
  SSL_R_COMPRESSED_LENGTH_TOO_LONG = 140;
  {$EXTERNALSYM SSL_R_COMPRESSION_DISABLED}
  SSL_R_COMPRESSION_DISABLED = 343;
  {$EXTERNALSYM SSL_R_COMPRESSION_FAILURE}
  SSL_R_COMPRESSION_FAILURE = 141;
  {$EXTERNALSYM SSL_R_COMPRESSION_LIBRARY_ERROR}
  SSL_R_COMPRESSION_LIBRARY_ERROR = 142;
  {$EXTERNALSYM SSL_R_CONNECTION_ID_IS_DIFFERENT}
  SSL_R_CONNECTION_ID_IS_DIFFERENT = 143;
  {$EXTERNALSYM SSL_R_CONNECTION_TYPE_NOT_SET}
  SSL_R_CONNECTION_TYPE_NOT_SET = 144;
  {$EXTERNALSYM SSL_R_DATA_BETWEEN_CCS_AND_FINISHED}
  SSL_R_DATA_BETWEEN_CCS_AND_FINISHED = 145;
  {$EXTERNALSYM SSL_R_DATA_LENGTH_TOO_LONG}
  SSL_R_DATA_LENGTH_TOO_LONG = 146;
  {$EXTERNALSYM SSL_R_DECRYPTION_FAILED}
  SSL_R_DECRYPTION_FAILED = 147;
  {$EXTERNALSYM SSL_R_DH_PUBLIC_VALUE_LENGTH_IS_WRONG}
  SSL_R_DH_PUBLIC_VALUE_LENGTH_IS_WRONG = 148;
  {$EXTERNALSYM SSL_R_DIGEST_CHECK_FAILED}
  SSL_R_DIGEST_CHECK_FAILED = 149;
  {$EXTERNALSYM SSL_R_DTLS_MESSAGE_TOO_BIG}
  SSL_R_DTLS_MESSAGE_TOO_BIG = 334; //was 318;
  {$EXTERNALSYM SSL_R_ECC_CERT_NOT_FOR_KEY_AGREEMENT}
  SSL_R_ECC_CERT_NOT_FOR_KEY_AGREEMENT = 317;
  {$EXTERNALSYM SSL_R_ECC_CERT_NOT_FOR_SIGNING}
  SSL_R_ECC_CERT_NOT_FOR_SIGNING = 318;
  {$EXTERNALSYM SSL_R_ECC_CERT_SHOULD_HAVE_RSA_SIGNATURE}
  SSL_R_ECC_CERT_SHOULD_HAVE_RSA_SIGNATURE = 322;
  {$EXTERNALSYM SSL_R_ECC_CERT_SHOULD_HAVE_SHA1_SIGNATURE}
  SSL_R_ECC_CERT_SHOULD_HAVE_SHA1_SIGNATURE = 323;
  {$EXTERNALSYM SSL_R_ECGROUP_TOO_LARGE_FOR_CIPHER}
  SSL_R_ECGROUP_TOO_LARGE_FOR_CIPHER = 310;
  {$EXTERNALSYM SSL_R_EMPTY_SRTP_PROTECTION_PROFILE_LIST}
  SSL_R_EMPTY_SRTP_PROTECTION_PROFILE_LIST = 354;
  {$EXTERNALSYM SSL_R_ENCRYPTED_LENGTH_TOO_LONG}
  SSL_R_ENCRYPTED_LENGTH_TOO_LONG = 150;
  {$EXTERNALSYM SSL_R_ERROR_IN_RECEIVED_CIPHER_LIST}
  SSL_R_ERROR_IN_RECEIVED_CIPHER_LIST = 151;
  {$EXTERNALSYM SSL_R_EXCESSIVE_MESSAGE_SIZE}
  SSL_R_EXCESSIVE_MESSAGE_SIZE = 152;
  {$EXTERNALSYM SSL_R_EXTRA_DATA_IN_MESSAGE}
  SSL_R_EXTRA_DATA_IN_MESSAGE = 153;
  {$EXTERNALSYM SSL_R_GOT_A_FIN_BEFORE_A_CCS}
  SSL_R_GOT_A_FIN_BEFORE_A_CCS = 154;
  {$EXTERNALSYM   SSL_R_GOT_NEXT_PROTO_BEFORE_A_CCS}
  SSL_R_GOT_NEXT_PROTO_BEFORE_A_CCS	= 355;
  {$EXTERNALSYM SSL_R_GOT_NEXT_PROTO_WITHOUT_EXTENSION}
  SSL_R_GOT_NEXT_PROTO_WITHOUT_EXTENSION = 356;
  {$EXTERNALSYM SSL_R_HTTPS_PROXY_REQUEST}
  SSL_R_HTTPS_PROXY_REQUEST = 155;
  {$EXTERNALSYM SSL_R_HTTP_REQUEST}
  SSL_R_HTTP_REQUEST = 156;
  {$EXTERNALSYM SSL_R_ILLEGAL_PADDING}
  SSL_R_ILLEGAL_PADDING	= 283;
  {$EXTERNALSYM SSL_R_INCONSISTENT_COMPRESSION}
  SSL_R_INCONSISTENT_COMPRESSION = 340;
  {$EXTERNALSYM SSL_R_INTERNAL_ERROR}
  SSL_R_INTERNAL_ERROR = 157;
  {$EXTERNALSYM SSL_R_INVALID_CHALLENGE_LENGTH}
  SSL_R_INVALID_CHALLENGE_LENGTH = 158;
  {$EXTERNALSYM SSL_R_INVALID_COMMAND}
  SSL_R_INVALID_COMMAND = 280;
  {$EXTERNALSYM SSL_R_INVALID_PURPOSE}
  SSL_R_INVALID_PURPOSE = 278;
  {$EXTERNALSYM SSL_R_INVALID_STATUS_RESPONSE}
  SSL_R_INVALID_STATUS_RESPONSE = 316;
  {$EXTERNALSYM SSL_R_INVALID_TICKET_KEYS_LENGTH}
  SSL_R_INVALID_TICKET_KEYS_LENGTH = 275;
  {$EXTERNALSYM SSL_R_INVALID_TRUST}
  SSL_R_INVALID_TRUST = 279;
  {$EXTERNALSYM SSL_R_LENGTH_MISMATCH}
  SSL_R_LENGTH_MISMATCH = 159;
  {$EXTERNALSYM SSL_R_LENGTH_TOO_SHORT}
  SSL_R_LENGTH_TOO_SHORT = 160;
  {$EXTERNALSYM SSL_R_LIBRARY_BUG}
  SSL_R_LIBRARY_BUG = 274;
  {$EXTERNALSYM SSL_R_LIBRARY_HAS_NO_CIPHERS}
  SSL_R_LIBRARY_HAS_NO_CIPHERS = 161;
  {$EXTERNALSYM SSL_R_MISSING_DH_DSA_CERT}
  SSL_R_MISSING_DH_DSA_CERT = 162;
  {$EXTERNALSYM SSL_R_MISSING_DH_KEY}
  SSL_R_MISSING_DH_KEY = 163;
  {$EXTERNALSYM SSL_R_MISSING_DH_RSA_CERT}
  SSL_R_MISSING_DH_RSA_CERT = 164;
  {$EXTERNALSYM SSL_R_MISSING_DSA_SIGNING_CERT}
  SSL_R_MISSING_DSA_SIGNING_CERT = 165;
  {$EXTERNALSYM SSL_R_MISSING_EXPORT_TMP_DH_KEY}
  SSL_R_MISSING_EXPORT_TMP_DH_KEY = 166;
  {$EXTERNALSYM SSL_R_MISSING_EXPORT_TMP_RSA_KEY}
  SSL_R_MISSING_EXPORT_TMP_RSA_KEY = 167;
  {$EXTERNALSYM SSL_R_MISSING_RSA_CERTIFICATE}
  SSL_R_MISSING_RSA_CERTIFICATE = 168;
  {$EXTERNALSYM SSL_R_MISSING_RSA_ENCRYPTING_CERT}
  SSL_R_MISSING_RSA_ENCRYPTING_CERT = 169;
  {$EXTERNALSYM SSL_R_MISSING_RSA_SIGNING_CERT}
  SSL_R_MISSING_RSA_SIGNING_CERT = 170;
  {$EXTERNALSYM SSL_R_MISSING_TMP_DH_KEY}
  SSL_R_MISSING_TMP_DH_KEY = 171;
  {$EXTERNALSYM SSL_R_MISSING_TMP_RSA_KEY}
  SSL_R_MISSING_TMP_RSA_KEY = 172;
  {$EXTERNALSYM SSL_R_MISSING_TMP_RSA_PKEY}
  SSL_R_MISSING_TMP_RSA_PKEY = 173;
  {$EXTERNALSYM SSL_R_MISSING_VERIFY_MESSAGE}
  SSL_R_MISSING_VERIFY_MESSAGE = 174;
  {$EXTERNALSYM SSL_R_MULTIPLE_SGC_RESTARTS}
  SSL_R_MULTIPLE_SGC_RESTARTS = 346;
  {$EXTERNALSYM SSL_R_NON_SSLV2_INITIAL_PACKET}
  SSL_R_NON_SSLV2_INITIAL_PACKET = 175;
  {$EXTERNALSYM SSL_R_NO_CERTIFICATES_RETURNED}
  SSL_R_NO_CERTIFICATES_RETURNED = 176;
  {$EXTERNALSYM SSL_R_NO_CERTIFICATE_ASSIGNED}
  SSL_R_NO_CERTIFICATE_ASSIGNED = 177;
  {$EXTERNALSYM SSL_R_NO_CERTIFICATE_RETURNED}
  SSL_R_NO_CERTIFICATE_RETURNED = 178;
  {$EXTERNALSYM SSL_R_NO_CERTIFICATE_SET}
  SSL_R_NO_CERTIFICATE_SET = 179;
  {$EXTERNALSYM SSL_R_NO_CERTIFICATE_SPECIFIED}
  SSL_R_NO_CERTIFICATE_SPECIFIED = 180;
  {$EXTERNALSYM SSL_R_NO_CIPHERS_AVAILABLE}
  SSL_R_NO_CIPHERS_AVAILABLE = 181;
  {$EXTERNALSYM SSL_R_NO_CIPHERS_PASSED}
  SSL_R_NO_CIPHERS_PASSED = 182;
  {$EXTERNALSYM SSL_R_NO_CIPHERS_SPECIFIED}
  SSL_R_NO_CIPHERS_SPECIFIED = 183;
  {$EXTERNALSYM SSL_R_NO_CIPHER_LIST}
  SSL_R_NO_CIPHER_LIST = 184;
  {$EXTERNALSYM SSL_R_NO_CIPHER_MATCH}
  SSL_R_NO_CIPHER_MATCH = 185;
  {$EXTERNALSYM SSL_R_NO_CLIENT_CERT_METHOD}
  SSL_R_NO_CLIENT_CERT_METHOD	= 317;
  {$EXTERNALSYM SSL_R_NO_CLIENT_CERT_RECEIVED}
  SSL_R_NO_CLIENT_CERT_RECEIVED = 186;
  {$EXTERNALSYM SSL_R_NO_COMPRESSION_SPECIFIED}
  SSL_R_NO_COMPRESSION_SPECIFIED = 187;
  {$EXTERNALSYM SSL_R_NO_METHOD_SPECIFIED}
  SSL_R_NO_METHOD_SPECIFIED = 188;
  {$EXTERNALSYM SSL_R_NO_PRIVATEKEY}
  SSL_R_NO_PRIVATEKEY = 189;
  {$EXTERNALSYM SSL_R_NO_PRIVATE_KEY_ASSIGNED}
  SSL_R_NO_PRIVATE_KEY_ASSIGNED = 190;
  {$EXTERNALSYM SSL_R_NO_PROTOCOLS_AVAILABLE}
  SSL_R_NO_PROTOCOLS_AVAILABLE = 191;
  {$EXTERNALSYM SSL_R_NO_PUBLICKEY}
  SSL_R_NO_PUBLICKEY = 192;
  //was 318
  {$EXTERNALSYM SSL_R_NO_RENEGOTIATION}
  SSL_R_NO_RENEGOTIATION = 319;
  {$EXTERNALSYM SSL_R_NO_SHARED_CIPHER}
  SSL_R_NO_SHARED_CIPHER = 193;
  {$EXTERNALSYM SSL_R_NO_VERIFY_CALLBACK}
  SSL_R_NO_VERIFY_CALLBACK = 194;
  {$EXTERNALSYM SSL_R_NULL_SSL_CTX}
  SSL_R_NULL_SSL_CTX = 195;
  {$EXTERNALSYM SSL_R_NULL_SSL_METHOD_PASSED}
  SSL_R_NULL_SSL_METHOD_PASSED = 196;
  {$EXTERNALSYM SSL_R_OLD_SESSION_CIPHER_NOT_RETURNED}
  SSL_R_OLD_SESSION_CIPHER_NOT_RETURNED = 197;
  {$EXTERNALSYM SSL_R_ONLY_TLS_ALLOWED_IN_FIPS_MODE}
  SSL_R_ONLY_TLS_ALLOWED_IN_FIPS_MODE = 297;
  {$EXTERNALSYM SSL_R_PACKET_LENGTH_TOO_LONG}
  SSL_R_PACKET_LENGTH_TOO_LONG = 198;
  {$EXTERNALSYM SSL_R_PARSE_TLSEXT}
  SSL_R_PARSE_TLSEXT = 223;
  {$EXTERNALSYM SSL_R_PATH_TOO_LONG}
  SSL_R_PATH_TOO_LONG = 270;
  {$EXTERNALSYM SSL_R_PEER_DID_NOT_RETURN_A_CERTIFICATE}
  SSL_R_PEER_DID_NOT_RETURN_A_CERTIFICATE = 199;
  {$EXTERNALSYM SSL_R_PEER_ERROR}
  SSL_R_PEER_ERROR = 200;
  {$EXTERNALSYM SSL_R_PEER_ERROR_CERTIFICATE}
  SSL_R_PEER_ERROR_CERTIFICATE = 201;
  {$EXTERNALSYM SSL_R_PEER_ERROR_NO_CERTIFICATE}
  SSL_R_PEER_ERROR_NO_CERTIFICATE = 202;
  {$EXTERNALSYM SSL_R_PEER_ERROR_NO_CIPHER}
  SSL_R_PEER_ERROR_NO_CIPHER = 203;
  {$EXTERNALSYM SSL_R_PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE}
  SSL_R_PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE = 204;
  {$EXTERNALSYM SSL_R_PRE_MAC_LENGTH_TOO_LONG}
  SSL_R_PRE_MAC_LENGTH_TOO_LONG = 205;
  {$EXTERNALSYM SSL_R_PROBLEMS_MAPPING_CIPHER_FUNCTIONS}
  SSL_R_PROBLEMS_MAPPING_CIPHER_FUNCTIONS = 206;
  {$EXTERNALSYM SSL_R_PROTOCOL_IS_SHUTDOWN}
  SSL_R_PROTOCOL_IS_SHUTDOWN = 207;
  {$EXTERNALSYM SSL_R_PUBLIC_KEY_ENCRYPT_ERROR}
  SSL_R_PUBLIC_KEY_ENCRYPT_ERROR = 208;
  {$EXTERNALSYM SSL_R_PUBLIC_KEY_IS_NOT_RSA}
  SSL_R_PUBLIC_KEY_IS_NOT_RSA = 209;
  {$EXTERNALSYM SSL_R_PUBLIC_KEY_NOT_RSA}
  SSL_R_PUBLIC_KEY_NOT_RSA = 210;
  {$EXTERNALSYM SSL_R_READ_BIO_NOT_SET}
  SSL_R_READ_BIO_NOT_SET = 211;
  {$EXTERNALSYM SSL_R_READ_WRONG_PACKET_TYPE}
  SSL_R_READ_WRONG_PACKET_TYPE = 212;
  {$EXTERNALSYM SSL_R_RECORD_LENGTH_MISMATCH}
  SSL_R_RECORD_LENGTH_MISMATCH = 213;
  {$EXTERNALSYM SSL_R_RECORD_TOO_LARGE}
  SSL_R_RECORD_TOO_LARGE = 214;
  {$EXTERNALSYM SSL_R_RECORD_TOO_SMALL}
  SSL_R_RECORD_TOO_SMALL = 298;
  {$EXTERNALSYM SSL_R_RENEGOTIATE_EXT_TOO_LONG}
  SSL_R_RENEGOTIATE_EXT_TOO_LONG = 320;
  {$EXTERNALSYM SSL_R_RENEGOTIATION_ENCODING_ERR}
  SSL_R_RENEGOTIATION_ENCODING_ERR = 321;
  {$EXTERNALSYM SSL_R_RENEGOTIATION_MISMATCH}
  SSL_R_RENEGOTIATION_MISMATCH = 322;
  {$EXTERNALSYM SSL_R_REQUIRED_CIPHER_MISSING}
  SSL_R_REQUIRED_CIPHER_MISSING = 215;
  {$EXTERNALSYM SSL_R_REUSE_CERT_LENGTH_NOT_ZERO}
  SSL_R_REUSE_CERT_LENGTH_NOT_ZERO = 216;
  {$EXTERNALSYM SSL_R_REUSE_CERT_TYPE_NOT_ZERO}
  SSL_R_REUSE_CERT_TYPE_NOT_ZERO = 217;
  {$EXTERNALSYM SSL_R_REUSE_CIPHER_LIST_NOT_ZERO}
  SSL_R_REUSE_CIPHER_LIST_NOT_ZERO = 218;
  {$EXTERNALSYM SSL_R_SCSV_RECEIVED_WHEN_RENEGOTIATING}
  SSL_R_SCSV_RECEIVED_WHEN_RENEGOTIATING = 324;
  {$EXTERNALSYM SSL_R_SERVERHELLO_TLSEXT}
  SSL_R_SERVERHELLO_TLSEXT = 224;
  {$EXTERNALSYM SSL_R_SESSION_ID_CONTEXT_UNINITIALIZED}
  SSL_R_SESSION_ID_CONTEXT_UNINITIALIZED = 277;
  {$EXTERNALSYM SSL_R_SHORT_READ}
  SSL_R_SHORT_READ = 219;
  {$EXTERNALSYM SSL_R_SIGNATURE_FOR_NON_SIGNING_CERTIFICATE}
  SSL_R_SIGNATURE_FOR_NON_SIGNING_CERTIFICATE = 220;
  {$EXTERNALSYM SSL_R_SSL23_DOING_SESSION_ID_REUSE}
  SSL_R_SSL23_DOING_SESSION_ID_REUSE = 221;
  {$EXTERNALSYM SSL_R_SSL2_CONNECTION_ID_TOO_LONG}
  SSL_R_SSL2_CONNECTION_ID_TOO_LONG = 299;
  {$EXTERNALSYM SSL_R_SSL3_EXT_INVALID_SERVERNAME}
  SSL_R_SSL3_EXT_INVALID_SERVERNAME = 225;
  {$EXTERNALSYM SSL_R_SSL3_EXT_INVALID_SERVERNAME_TYPE}
  SSL_R_SSL3_EXT_INVALID_SERVERNAME_TYPE = 226;
  {$EXTERNALSYM SSL_R_SSL3_SESSION_ID_TOO_LONG}
  SSL_R_SSL3_SESSION_ID_TOO_LONG = 300;
  {$EXTERNALSYM SSL_R_SSL3_SESSION_ID_TOO_SHORT}
  SSL_R_SSL3_SESSION_ID_TOO_SHORT = 222;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_BAD_CERTIFICATE}
  SSL_R_SSLV3_ALERT_BAD_CERTIFICATE = 1042;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_BAD_RECORD_MAC}
  SSL_R_SSLV3_ALERT_BAD_RECORD_MAC = 1020;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_CERTIFICATE_EXPIRED}
  SSL_R_SSLV3_ALERT_CERTIFICATE_EXPIRED = 1045;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_CERTIFICATE_REVOKED}
  SSL_R_SSLV3_ALERT_CERTIFICATE_REVOKED = 1044;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_CERTIFICATE_UNKNOWN}
  SSL_R_SSLV3_ALERT_CERTIFICATE_UNKNOWN = 1046;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_DECOMPRESSION_FAILURE}
  SSL_R_SSLV3_ALERT_DECOMPRESSION_FAILURE = 1030;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_HANDSHAKE_FAILURE}
  SSL_R_SSLV3_ALERT_HANDSHAKE_FAILURE = 1040;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_ILLEGAL_PARAMETER}
  SSL_R_SSLV3_ALERT_ILLEGAL_PARAMETER = 1047;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_NO_CERTIFICATE}
  SSL_R_SSLV3_ALERT_NO_CERTIFICATE = 1041;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_PEER_ERROR_CERTIFICATE}
  SSL_R_SSLV3_ALERT_PEER_ERROR_CERTIFICATE = 223;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_PEER_ERROR_NO_CERTIFICATE}
  SSL_R_SSLV3_ALERT_PEER_ERROR_NO_CERTIFICATE = 224;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_PEER_ERROR_NO_CIPHER}
  SSL_R_SSLV3_ALERT_PEER_ERROR_NO_CIPHER = 225;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE}
  SSL_R_SSLV3_ALERT_PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE = 226;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_UNEXPECTED_MESSAGE}
  SSL_R_SSLV3_ALERT_UNEXPECTED_MESSAGE = 1010;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_UNKNOWN_REMOTE_ERROR_TYPE}
  SSL_R_SSLV3_ALERT_UNKNOWN_REMOTE_ERROR_TYPE = 227;
  {$EXTERNALSYM SSL_R_SSLV3_ALERT_UNSUPPORTED_CERTIFICATE}
  SSL_R_SSLV3_ALERT_UNSUPPORTED_CERTIFICATE = 1043;
  {$EXTERNALSYM SSL_R_SSL_CTX_HAS_NO_DEFAULT_SSL_VERSION}
  SSL_R_SSL_CTX_HAS_NO_DEFAULT_SSL_VERSION = 228;
  {$EXTERNALSYM SSL_R_SSL_HANDSHAKE_FAILURE}
  SSL_R_SSL_HANDSHAKE_FAILURE = 229;
  {$EXTERNALSYM SSL_R_SSL_LIBRARY_HAS_NO_CIPHERS}
  SSL_R_SSL_LIBRARY_HAS_NO_CIPHERS = 230;
  {$EXTERNALSYM SSL_R_SSL_SESSION_ID_CONTEXT_TOO_LONG}
  SSL_R_SSL_SESSION_ID_CONTEXT_TOO_LONG = 273;
  {$EXTERNALSYM SSL_R_SSL_SESSION_ID_IS_DIFFERENT}
  SSL_R_SSL_SESSION_ID_IS_DIFFERENT = 231;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_ACCESS_DENIED}
  SSL_R_TLSV1_ALERT_ACCESS_DENIED = 1049;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_DECODE_ERROR}
  SSL_R_TLSV1_ALERT_DECODE_ERROR = 1050;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_DECRYPTION_FAILED}
  SSL_R_TLSV1_ALERT_DECRYPTION_FAILED = 1021;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_DECRYPT_ERROR}
  SSL_R_TLSV1_ALERT_DECRYPT_ERROR = 1051;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_EXPORT_RESTRICION}
  SSL_R_TLSV1_ALERT_EXPORT_RESTRICION = 1060;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_INSUFFICIENT_SECURITY}
  SSL_R_TLSV1_ALERT_INSUFFICIENT_SECURITY = 1071;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_INTERNAL_ERROR}
  SSL_R_TLSV1_ALERT_INTERNAL_ERROR = 1080;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_NO_RENEGOTIATION}
  SSL_R_TLSV1_ALERT_NO_RENEGOTIATION = 1100;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_PROTOCOL_VERSION}
  SSL_R_TLSV1_ALERT_PROTOCOL_VERSION = 1070;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_RECORD_OVERFLOW}
  SSL_R_TLSV1_ALERT_RECORD_OVERFLOW = 1022;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_UNKNOWN_CA}
  SSL_R_TLSV1_ALERT_UNKNOWN_CA = 1048;
  {$EXTERNALSYM SSL_R_TLSV1_ALERT_USER_CANCLED}
  SSL_R_TLSV1_ALERT_USER_CANCLED = 1090;
  {$EXTERNALSYM SSL_R_TLS_CLIENT_CERT_REQ_WITH_ANON_CIPHER}
  SSL_R_TLS_CLIENT_CERT_REQ_WITH_ANON_CIPHER = 232;
  {$EXTERNALSYM SSL_R_TLS_INVALID_ECPOINTFORMAT_LIST}
  SSL_R_TLS_INVALID_ECPOINTFORMAT_LIST = 227;
  {$EXTERNALSYM SSL_R_TLS_PEER_DID_NOT_RESPOND_WITH_CERTIFICATE_LIST}
  SSL_R_TLS_PEER_DID_NOT_RESPOND_WITH_CERTIFICATE_LIST = 233;
  {$EXTERNALSYM SSL_R_TLS_RSA_ENCRYPTED_VALUE_LENGTH_IS_WRONG}
  SSL_R_TLS_RSA_ENCRYPTED_VALUE_LENGTH_IS_WRONG = 234;
  {$EXTERNALSYM SSL_R_TRIED_TO_USE_UNSUPPORTED_CIPHER}
  SSL_R_TRIED_TO_USE_UNSUPPORTED_CIPHER = 235;
  {$EXTERNALSYM SSL_R_UNABLE_TO_DECODE_DH_CERTS}
  SSL_R_UNABLE_TO_DECODE_DH_CERTS = 236;
  {$EXTERNALSYM SSL_R_UNABLE_TO_EXTRACT_PUBLIC_KEY}
  SSL_R_UNABLE_TO_EXTRACT_PUBLIC_KEY = 237;
  {$EXTERNALSYM SSL_R_UNABLE_TO_FIND_DH_PARAMETERS}
  SSL_R_UNABLE_TO_FIND_DH_PARAMETERS = 238;
  {$EXTERNALSYM SSL_R_UNABLE_TO_FIND_PUBLIC_KEY_PARAMETERS}
  SSL_R_UNABLE_TO_FIND_PUBLIC_KEY_PARAMETERS = 239;
  {$EXTERNALSYM SSL_R_UNABLE_TO_FIND_SSL_METHOD}
  SSL_R_UNABLE_TO_FIND_SSL_METHOD = 240;
  {$EXTERNALSYM SSL_R_UNABLE_TO_LOAD_SSL2_MD5_ROUTINES}
  SSL_R_UNABLE_TO_LOAD_SSL2_MD5_ROUTINES = 241;
  {$EXTERNALSYM SSL_R_UNABLE_TO_LOAD_SSL3_MD5_ROUTINES}
  SSL_R_UNABLE_TO_LOAD_SSL3_MD5_ROUTINES = 242;
  {$EXTERNALSYM SSL_R_UNABLE_TO_LOAD_SSL3_SHA1_ROUTINES}
  SSL_R_UNABLE_TO_LOAD_SSL3_SHA1_ROUTINES = 243;
  {$EXTERNALSYM SSL_R_UNEXPECTED_MESSAGE}
  SSL_R_UNEXPECTED_MESSAGE = 244;
  {$EXTERNALSYM SSL_R_UNEXPECTED_RECORD}
  SSL_R_UNEXPECTED_RECORD = 245;
  {$EXTERNALSYM SSL_R_UNINITIALIZED}
  SSL_R_UNINITIALIZED = 276;
  {$EXTERNALSYM SSL_R_UNKNOWN_ALERT_TYPE}
  SSL_R_UNKNOWN_ALERT_TYPE = 246;
  {$EXTERNALSYM SSL_R_UNKNOWN_CERTIFICATE_TYPE}
  SSL_R_UNKNOWN_CERTIFICATE_TYPE = 247;
  {$EXTERNALSYM SSL_R_UNKNOWN_CIPHER_RETURNED}
  SSL_R_UNKNOWN_CIPHER_RETURNED = 248;
  {$EXTERNALSYM SSL_R_UNKNOWN_CIPHER_TYPE}
  SSL_R_UNKNOWN_CIPHER_TYPE = 249;
  {$EXTERNALSYM SSL_R_UNKNOWN_KEY_EXCHANGE_TYPE}
  SSL_R_UNKNOWN_KEY_EXCHANGE_TYPE = 250;
  {$EXTERNALSYM SSL_R_UNKNOWN_PKEY_TYPE}
  SSL_R_UNKNOWN_PKEY_TYPE = 251;
  {$EXTERNALSYM SSL_R_UNKNOWN_PROTOCOL}
  SSL_R_UNKNOWN_PROTOCOL = 252;
  {$EXTERNALSYM SSL_R_UNKNOWN_REMOTE_ERROR_TYPE}
  SSL_R_UNKNOWN_REMOTE_ERROR_TYPE = 253;
  {$EXTERNALSYM SSL_R_UNKNOWN_SSL_VERSION}
  SSL_R_UNKNOWN_SSL_VERSION = 254;
  {$EXTERNALSYM SSL_R_UNSUPPORTED_STATUS_TYPE}
  SSL_R_UNSUPPORTED_STATUS_TYPE = 329;
  {$EXTERNALSYM SSL_R_UNKNOWN_STATE}
  SSL_R_UNKNOWN_STATE = 255;
  {$EXTERNALSYM SSL_R_UNSAFE_LEGACY_RENEGOTIATION_DISABLED}
  SSL_R_UNSAFE_LEGACY_RENEGOTIATION_DISABLED = 323;
  {$EXTERNALSYM SSL_R_UNSUPPORTED_CIPHER}
  SSL_R_UNSUPPORTED_CIPHER = 256;
  {$EXTERNALSYM SSL_R_UNSUPPORTED_COMPRESSION_ALGORITHM}
  SSL_R_UNSUPPORTED_COMPRESSION_ALGORITHM = 257;
  {$EXTERNALSYM SSL_R_UNSUPPORTED_DIGEST_TYPE}
  SSL_R_UNSUPPORTED_DIGEST_TYPE	= 326;
  {$EXTERNALSYM SSL_R_UNSUPPORTED_PROTOCOL}
  SSL_R_UNSUPPORTED_PROTOCOL = 258;
  {$EXTERNALSYM SSL_R_UNSUPPORTED_SSL_VERSION}
  SSL_R_UNSUPPORTED_SSL_VERSION = 259;
  {$EXTERNALSYM SSL_R_USE_SRTP_NOT_NEGOTIATED}
  SSL_R_USE_SRTP_NOT_NEGOTIATED	= 369;
  {$EXTERNALSYM SSL_R_WRITE_BIO_NOT_SET}
  SSL_R_WRITE_BIO_NOT_SET = 260;
  {$EXTERNALSYM SSL_R_WRONG_CIPHER_RETURNED}
  SSL_R_WRONG_CIPHER_RETURNED = 261;
  {$EXTERNALSYM SSL_R_WRONG_MESSAGE_TYPE}
  SSL_R_WRONG_MESSAGE_TYPE = 262;
  {$EXTERNALSYM SSL_R_WRONG_NUMBER_OF_KEY_BITS}
  SSL_R_WRONG_NUMBER_OF_KEY_BITS = 263;
  {$EXTERNALSYM SSL_R_WRONG_SIGNATURE_LENGTH}
  SSL_R_WRONG_SIGNATURE_LENGTH = 264;
  {$EXTERNALSYM SSL_R_WRONG_SIGNATURE_SIZE}
  SSL_R_WRONG_SIGNATURE_SIZE = 265;
  {$EXTERNALSYM SSL_R_WRONG_SIGNATURE_TYPE}
  SSL_R_WRONG_SIGNATURE_TYPE = 370;
  {$EXTERNALSYM SSL_R_WRONG_SSL_VERSION}
  SSL_R_WRONG_SSL_VERSION = 266;
  {$EXTERNALSYM SSL_R_WRONG_VERSION_NUMBER}
  SSL_R_WRONG_VERSION_NUMBER = 267;
  {$EXTERNALSYM SSL_R_X509_LIB}
  SSL_R_X509_LIB = 268;
  {$EXTERNALSYM SSL_R_X509_VERIFICATION_SETUP_PROBLEMS}
  SSL_R_X509_VERIFICATION_SETUP_PROBLEMS = 269;
  {$EXTERNALSYM SSL_SENT_SHUTDOWN}
  SSL_SENT_SHUTDOWN = 1;
  {$EXTERNALSYM SSL_SESSION_ASN1_VERSION}
  SSL_SESSION_ASN1_VERSION = $0001;
  {$EXTERNALSYM SSL_SESSION_CACHE_MAX_SIZE_DEFAULT}
  SSL_SESSION_CACHE_MAX_SIZE_DEFAULT = 1024*20;
  {$EXTERNALSYM SSL_SESS_CACHE_CLIENT}
  SSL_SESS_CACHE_CLIENT = $0001;
  {$EXTERNALSYM SSL_SESS_CACHE_SERVER}
  SSL_SESS_CACHE_SERVER = $0002;
  {$EXTERNALSYM SSL_SESS_CACHE_BOTH}
  SSL_SESS_CACHE_BOTH = SSL_SESS_CACHE_CLIENT or SSL_SESS_CACHE_SERVER;
  {$EXTERNALSYM SSL_SESS_CACHE_NO_AUTO_CLEAR}
  SSL_SESS_CACHE_NO_AUTO_CLEAR = $0080;
  {$EXTERNALSYM SSL_SESS_CACHE_NO_INTERNAL_LOOKUP}
  SSL_SESS_CACHE_NO_INTERNAL_LOOKUP = $0100;
  {$EXTERNALSYM SSL_SESS_CACHE_OFF}
  SSL_SESS_CACHE_OFF = $0000;
  {$ifndef OPENSSL_NO_NEXTPROTONEG}
  {$EXTERNALSYM OPENSSL_NPN_UNSUPPORTED}
  OPENSSL_NPN_UNSUPPORTED = 0;
  {$EXTERNALSYM OPENSSL_NPN_NEGOTIATED}
  OPENSSL_NPN_NEGOTIATED = 1;
  {$EXTERNALSYM OPENSSL_NPN_NO_OVERLAP}
  OPENSSL_NPN_NO_OVERLAP = 2;
  {$endif}
{$ifndef OPENSSL_NO_PSK}
//* the maximum length of the buffer given to callbacks containing the
// * resulting identity/psk */
  {$EXTERNALSYM PSK_MAX_IDENTITY_LEN}
  PSK_MAX_IDENTITY_LEN = 128;
  {$EXTERNALSYM PSK_MAX_PSK_LEN}
  PSK_MAX_PSK_LEN = 256;
{$endif}



  {$EXTERNALSYM SSL_TXT_LOW}
  SSL_TXT_LOW = 'LOW';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_MEDIUM}
  SSL_TXT_MEDIUM = 'MEDIUM';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_HIGH}
  SSL_TXT_HIGH = 'HIGH';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_FIPS}
  SSL_TXT_FIPS = 'FIPS';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_kFZA}
  SSL_TXT_kFZA = 'kFZA';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_aFZA}
  SSL_TXT_aFZA = 'aFZA';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_eFZA}
  SSL_TXT_eFZA = 'eFZA';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_FZA}
  SSL_TXT_FZA = 'FZA';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_aNULL}
  SSL_TXT_aNULL = 'aNULL';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_eNULL}
  SSL_TXT_eNULL = 'eNULL';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_NULL}
  SSL_TXT_NULL = 'NULL';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_kKRB5}
  SSL_TXT_kKRB5    = 'kKRB5';{Do not localize}
  {$EXTERNALSYM SSL_TXT_aKRB5}
  SSL_TXT_aKRB5     ='aKRB5';{Do not localize}
  {$EXTERNALSYM SSL_TXT_KRB5}
  SSL_TXT_KRB5      = 'KRB5';{Do not localize}
  {$EXTERNALSYM SSL_TXT_kRSA}
  SSL_TXT_kRSA = 'kRSA';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_kDHr}
  SSL_TXT_kDHr = 'kDHr';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_kDHd}
  SSL_TXT_kDHd = 'kDHd';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_kEDH}
  SSL_TXT_kEDH = 'kEDH';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_aRSA}
  SSL_TXT_aRSA = 'aRSA';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_aDSS}
  SSL_TXT_aDSS = 'aDSS';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_aDH}
  SSL_TXT_aDH	= 'aDH';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_RSA}
  SSL_TXT_RSA = 'RSA';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_DH}
  SSL_TXT_DH = 'DH';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_EDH}
  SSL_TXT_EDH = 'EDH';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_ADH_C}
  SSL_TXT_ADH_C = 'ADH';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_aDH_S}
  SSL_TXT_aDH_S = 'aDH';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_DSS}
  SSL_TXT_DSS = 'DSS';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_DES}
  SSL_TXT_DES = 'DES';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_3DES}
  SSL_TXT_3DES = '3DES';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_RC4}
  SSL_TXT_RC4 = 'RC4';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_RC2}
  SSL_TXT_RC2 = 'RC2';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_IDEA}
  SSL_TXT_IDEA = 'IDEA';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_SEED}
  SSL_TXT_SEED = 'SEED';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_AES}
  SSL_TXT_AES = 'AES'; {Do not localize}
  {$EXTERNALSYM SSL_TXT_CAMELLIA}
  SSL_TXT_CAMELLIA = 'CAMELLIA'; {Do not localize}
  {$EXTERNALSYM SSL_TXT_MD5}
  SSL_TXT_MD5 = 'MD5';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_SHA1}
  SSL_TXT_SHA1 = 'SHA1';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_SHA}
  SSL_TXT_SHA = 'SHA';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_EXP}
  SSL_TXT_EXP = 'EXP'; {Do not localize}
  {$EXTERNALSYM SSL_TXT_EXPORT}
  SSL_TXT_EXPORT = 'EXPORT';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_EXP40}
  SSL_TXT_EXP40 = 'EXPORT40';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_EXP56}
  SSL_TXT_EXP56 = 'EXPORT56';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_SSLV2}
  SSL_TXT_SSLV2 = 'SSLv2';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_SSLV3}
  SSL_TXT_SSLV3 = 'SSLv3';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_TLSV1}
  SSL_TXT_TLSV1 = 'TLSv1';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_ALL}
  SSL_TXT_ALL = 'ALL';  {Do not localize}
  {$EXTERNALSYM SSL_TXT_ECC}
  SSL_TXT_ECC = 'ECCdraft'; //* ECC ciphersuites are not yet official */
  {$EXTERNALSYM SSL_TXT_DES_192_EDE3_CBC_WITH_MD5}
  SSL_TXT_DES_192_EDE3_CBC_WITH_MD5 = SSL2_TXT_DES_192_EDE3_CBC_WITH_MD5;
  {$EXTERNALSYM SSL_TXT_DES_192_EDE3_CBC_WITH_SHA}
  SSL_TXT_DES_192_EDE3_CBC_WITH_SHA = SSL2_TXT_DES_192_EDE3_CBC_WITH_SHA;
  {$EXTERNALSYM SSL_TXT_DES_64_CBC_WITH_MD5}
  SSL_TXT_DES_64_CBC_WITH_MD5 = SSL2_TXT_DES_64_CBC_WITH_MD5;
  {$EXTERNALSYM SSL_TXT_DES_64_CBC_WITH_SHA}
  SSL_TXT_DES_64_CBC_WITH_SHA = SSL2_TXT_DES_64_CBC_WITH_SHA;
  {$EXTERNALSYM SSL_TXT_IDEA_128_CBC_WITH_MD5}
  SSL_TXT_IDEA_128_CBC_WITH_MD5 = SSL2_TXT_IDEA_128_CBC_WITH_MD5;
  {$EXTERNALSYM SSL_TXT_NULL_WITH_MD5}
  SSL_TXT_NULL_WITH_MD5 = SSL2_TXT_NULL_WITH_MD5;
  {$EXTERNALSYM SSL_TXT_RC2_128_CBC_EXPORT40_WITH_MD5}
  SSL_TXT_RC2_128_CBC_EXPORT40_WITH_MD5 = SSL2_TXT_RC2_128_CBC_EXPORT40_WITH_MD5;
  {$EXTERNALSYM SSL_TXT_RC2_128_CBC_WITH_MD5}
  SSL_TXT_RC2_128_CBC_WITH_MD5 = SSL2_TXT_RC2_128_CBC_WITH_MD5;
  {$EXTERNALSYM SSL_TXT_RC4_128_EXPORT40_WITH_MD5}
  SSL_TXT_RC4_128_EXPORT40_WITH_MD5 = SSL2_TXT_RC4_128_EXPORT40_WITH_MD5;
  {$EXTERNALSYM SSL_TXT_RC4_128_WITH_MD5}
  SSL_TXT_RC4_128_WITH_MD5 = SSL2_TXT_RC4_128_WITH_MD5;
  {$EXTERNALSYM SSL_VERIFY_CLIENT_ONCE}
  SSL_VERIFY_CLIENT_ONCE = $04;
  {$EXTERNALSYM SSL_VERIFY_FAIL_IF_NO_PEER_CERT}
  SSL_VERIFY_FAIL_IF_NO_PEER_CERT = $02;
  {$EXTERNALSYM SSL_VERIFY_NONE}
  SSL_VERIFY_NONE = $00;
  {$EXTERNALSYM SSL_VERIFY_PEER}
  SSL_VERIFY_PEER = $01;

  {$EXTERNALSYM SSL_MAC_FLAG_READ_MAC_STREAM}
  SSL_MAC_FLAG_READ_MAC_STREAM = 1;
  {$EXTERNALSYM SSL_MAC_FLAG_WRITE_MAC_STREAM}
  SSL_MAC_FLAG_WRITE_MAC_STREAM = 2;
  {$EXTERNALSYM TLS1_ALLOW_EXPERIMENTAL_CIPHERSUITES}
  TLS1_ALLOW_EXPERIMENTAL_CIPHERSUITES = 0;
  {$EXTERNALSYM TLS1_2_VERSION}
  TLS1_2_VERSION = $0303;
  {$EXTERNALSYM TLS1_2_VERSION_MAJOR}
  TLS1_2_VERSION_MAJOR = $03;
  {$EXTERNALSYM TLS1_2_VERSION_MINOR}
  TLS1_2_VERSION_MINOR = $03;
  {$EXTERNALSYM TLS1_1_VERSION}
  TLS1_1_VERSION			= $0302;
  {$EXTERNALSYM TLS1_1_VERSION_MAJOR}
  TLS1_1_VERSION_MAJOR = $03;
  {$EXTERNALSYM TLS1_1_VERSION_MINOR}
  TLS1_1_VERSION_MINOR = $02;
  {$EXTERNALSYM TLS1_VERSION}
  TLS1_VERSION = $0301;
  {$EXTERNALSYM TLS1_VERSION_MAJOR}
  TLS1_VERSION_MAJOR = $03;
  {$EXTERNALSYM TLS1_VERSION_MINOR}
  TLS1_VERSION_MINOR = $01;

  {$IFNDEF OPENSSL_NO_HEARTBEATS}
  {$EXTERNALSYM SSL_TLSEXT_HB_ENABLED}
  SSL_TLSEXT_HB_ENABLED	= $01;
  {$EXTERNALSYM SSL_TLSEXT_HB_DONT_SEND_REQUESTS}
  SSL_TLSEXT_HB_DONT_SEND_REQUESTS = $02;
  {$EXTERNALSYM SSL_TLSEXT_HB_DONT_RECV_REQUESTS}
  SSL_TLSEXT_HB_DONT_RECV_REQUESTS = $04;

  {$ENDIF}

  //* PSK ciphersuites from 4279 */
  {$EXTERNALSYM TLS1_CK_PSK_WITH_RC4_128_SHA}
  TLS1_CK_PSK_WITH_RC4_128_SHA = $0300008A;
  {$EXTERNALSYM TLS1_CK_PSK_WITH_3DES_EDE_CBC_SHA}
  TLS1_CK_PSK_WITH_3DES_EDE_CBC_SHA = $0300008B;
  {$EXTERNALSYM TLS1_CK_PSK_WITH_AES_128_CBC_SHA}
  TLS1_CK_PSK_WITH_AES_128_CBC_SHA = $0300008C;
  {$EXTERNALSYM TLS1_CK_PSK_WITH_AES_256_CBC_SHA}
  TLS1_CK_PSK_WITH_AES_256_CBC_SHA = $0300008D;

  {$EXTERNALSYM TLS1_CK_RSA_EXPORT1024_WITH_RC4_56_MD5}
  TLS1_CK_RSA_EXPORT1024_WITH_RC4_56_MD5 = $03000060;
  {$EXTERNALSYM TLS1_CK_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5}
  TLS1_CK_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5 = $03000061;
  {$EXTERNALSYM TLS1_CK_RSA_EXPORT1024_WITH_DES_CBC_SHA}
  TLS1_CK_RSA_EXPORT1024_WITH_DES_CBC_SHA = $03000062;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA}
  TLS1_CK_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = $03000063;
  {$EXTERNALSYM TLS1_CK_RSA_EXPORT1024_WITH_RC4_56_SHA}
  TLS1_CK_RSA_EXPORT1024_WITH_RC4_56_SHA = $03000064;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA}
  TLS1_CK_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = $03000065;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_WITH_RC4_128_SHA}
  TLS1_CK_DHE_DSS_WITH_RC4_128_SHA = $03000066;
//* AES ciphersuites from RFC3268 */
  {$EXTERNALSYM TLS1_CK_RSA_WITH_AES_128_SHA}
  TLS1_CK_RSA_WITH_AES_128_SHA = $0300002F;
  {$EXTERNALSYM TLS1_CK_DH_DSS_WITH_AES_128_SHA}
  TLS1_CK_DH_DSS_WITH_AES_128_SHA  = $03000030;
  {$EXTERNALSYM TLS1_CK_DH_RSA_WITH_AES_128_SHA}
  TLS1_CK_DH_RSA_WITH_AES_128_SHA = $03000031;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_WITH_AES_128_SHA}
  TLS1_CK_DHE_DSS_WITH_AES_128_SHA = $03000032;
  {$EXTERNALSYM TLS1_CK_DHE_RSA_WITH_AES_128_SHA}
  TLS1_CK_DHE_RSA_WITH_AES_128_SHA = $03000033;
  {$EXTERNALSYM TLS1_CK_ADH_WITH_AES_128_SHA}
  TLS1_CK_ADH_WITH_AES_128_SHA = $03000034;
  {$EXTERNALSYM TLS1_CK_RSA_WITH_AES_256_SHA}
  TLS1_CK_RSA_WITH_AES_256_SHA = $03000035;
  {$EXTERNALSYM TLS1_CK_DH_DSS_WITH_AES_256_SHA}
  TLS1_CK_DH_DSS_WITH_AES_256_SHA = $03000036;
  {$EXTERNALSYM TLS1_CK_DH_RSA_WITH_AES_256_SHA}
  TLS1_CK_DH_RSA_WITH_AES_256_SHA = $03000037;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_WITH_AES_256_SHA}
  TLS1_CK_DHE_DSS_WITH_AES_256_SHA = $03000038;
  {$EXTERNALSYM TLS1_CK_DHE_RSA_WITH_AES_256_SHA}
  TLS1_CK_DHE_RSA_WITH_AES_256_SHA = $03000039;
  {$EXTERNALSYM TLS1_CK_ADH_WITH_AES_256_SHA}
  TLS1_CK_ADH_WITH_AES_256_SHA = $0300003A;
//* TLS v1.2 ciphersuites */
  {$EXTERNALSYM TLS1_CK_RSA_WITH_NULL_SHA256}
  TLS1_CK_RSA_WITH_NULL_SHA256		 = $0300003B;
  {$EXTERNALSYM TLS1_CK_RSA_WITH_AES_128_SHA256}
  TLS1_CK_RSA_WITH_AES_128_SHA256		= $0300003C;
  {$EXTERNALSYM TLS1_CK_RSA_WITH_AES_256_SHA256}
  TLS1_CK_RSA_WITH_AES_256_SHA256		= $0300003D;
  {$EXTERNALSYM TLS1_CK_DH_DSS_WITH_AES_128_SHA256}
  TLS1_CK_DH_DSS_WITH_AES_128_SHA256 = $0300003E;
  {$EXTERNALSYM TLS1_CK_DH_RSA_WITH_AES_128_SHA256}
  TLS1_CK_DH_RSA_WITH_AES_128_SHA256	= $0300003F;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_WITH_AES_128_SHA256}
  TLS1_CK_DHE_DSS_WITH_AES_128_SHA256	= $03000040;

//* Camellia ciphersuites from RFC4132 */
  {$EXTERNALSYM TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000041;
  {$EXTERNALSYM TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = $03000042;
  {$EXTERNALSYM TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000043;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = $03000044;
  {$EXTERNALSYM TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000045;
  {$EXTERNALSYM TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA = $03000046;
  {$EXTERNALSYM TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000084;
  {$EXTERNALSYM TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = $03000085;
  {$EXTERNALSYM TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000086;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = $03000087;
  {$EXTERNALSYM TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000088;
  {$EXTERNALSYM TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA = $03000089;

//* TLS v1.2 ciphersuites */
  {$EXTERNALSYM TLS1_CK_DHE_RSA_WITH_AES_128_SHA256}
  TLS1_CK_DHE_RSA_WITH_AES_128_SHA256		= $03000067;
  {$EXTERNALSYM TLS1_CK_DH_DSS_WITH_AES_256_SHA256}
  TLS1_CK_DH_DSS_WITH_AES_256_SHA256	 = $03000068;
  {$EXTERNALSYM TLS1_CK_DH_RSA_WITH_AES_256_SHA256}
  TLS1_CK_DH_RSA_WITH_AES_256_SHA256	 = $03000069;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_WITH_AES_256_SHA256}
  TLS1_CK_DHE_DSS_WITH_AES_256_SHA256	= $0300006A;
  {$EXTERNALSYM TLS1_CK_DHE_RSA_WITH_AES_256_SHA256}
  TLS1_CK_DHE_RSA_WITH_AES_256_SHA256	= $0300006B;
  {$EXTERNALSYM TLS1_CK_ADH_WITH_AES_128_SHA256}
  TLS1_CK_ADH_WITH_AES_128_SHA256			= $0300006C;
    {$EXTERNALSYM TLS1_CK_ADH_WITH_AES_256_SHA256}
  TLS1_CK_ADH_WITH_AES_256_SHA256		 = $0300006D;
  //* SEED ciphersuites from RFC4162 */
  {$EXTERNALSYM TLS1_CK_RSA_WITH_SEED_SHA}
  TLS1_CK_RSA_WITH_SEED_SHA                       = $03000096;
  {$EXTERNALSYM TLS1_CK_DH_DSS_WITH_SEED_SHA}
  TLS1_CK_DH_DSS_WITH_SEED_SHA                    = $03000097;
  {$EXTERNALSYM TLS1_CK_DH_RSA_WITH_SEED_SHA}
  TLS1_CK_DH_RSA_WITH_SEED_SHA                    = $03000098;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_WITH_SEED_SHA}
  TLS1_CK_DHE_DSS_WITH_SEED_SHA                   = $03000099;
  {$EXTERNALSYM TLS1_CK_DHE_RSA_WITH_SEED_SHA}
  TLS1_CK_DHE_RSA_WITH_SEED_SHA                   = $0300009A;
  {$EXTERNALSYM TLS1_CK_ADH_WITH_SEED_SHA}
  TLS1_CK_ADH_WITH_SEED_SHA                = $0300009B;

//* TLS v1.2 GCM ciphersuites from RFC5288 */
  {$EXTERNALSYM TLS1_CK_RSA_WITH_AES_128_GCM_SHA256}
  TLS1_CK_RSA_WITH_AES_128_GCM_SHA256	= $0300009C;
  {$EXTERNALSYM TLS1_CK_RSA_WITH_AES_256_GCM_SHA384}
  TLS1_CK_RSA_WITH_AES_256_GCM_SHA384	= $0300009D;
  {$EXTERNALSYM TLS1_CK_DHE_RSA_WITH_AES_128_GCM_SHA256}
  TLS1_CK_DHE_RSA_WITH_AES_128_GCM_SHA256 = $0300009E;
  {$EXTERNALSYM TLS1_CK_DHE_RSA_WITH_AES_256_GCM_SHA384}
  TLS1_CK_DHE_RSA_WITH_AES_256_GCM_SHA384	= $0300009F;
  {$EXTERNALSYM TLS1_CK_DH_RSA_WITH_AES_128_GCM_SHA256}
  TLS1_CK_DH_RSA_WITH_AES_128_GCM_SHA256 = $030000A0;
  {$EXTERNALSYM TLS1_CK_DH_RSA_WITH_AES_256_GCM_SHA384}
  TLS1_CK_DH_RSA_WITH_AES_256_GCM_SHA384 = $030000A1;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_WITH_AES_128_GCM_SHA256}
  TLS1_CK_DHE_DSS_WITH_AES_128_GCM_SHA256	= $030000A2;
  {$EXTERNALSYM TLS1_CK_DHE_DSS_WITH_AES_256_GCM_SHA384}
  TLS1_CK_DHE_DSS_WITH_AES_256_GCM_SHA384	=	$030000A3;
  {$EXTERNALSYM TLS1_CK_DH_DSS_WITH_AES_128_GCM_SHA256}
  TLS1_CK_DH_DSS_WITH_AES_128_GCM_SHA256 = $030000A4;
  {$EXTERNALSYM TLS1_CK_DH_DSS_WITH_AES_256_GCM_SHA384}
  TLS1_CK_DH_DSS_WITH_AES_256_GCM_SHA384 = $030000A5;
  {$EXTERNALSYM TLS1_CK_ADH_WITH_AES_128_GCM_SHA256}
  TLS1_CK_ADH_WITH_AES_128_GCM_SHA256	= $030000A6;
   {$EXTERNALSYM TLS1_CK_ADH_WITH_AES_256_GCM_SHA384}
  TLS1_CK_ADH_WITH_AES_256_GCM_SHA384	= $030000A7;
//* ECC ciphersuites from draft-ietf-tls-ecc-12.txt with changes soon to be in draft 13 */
  {$EXTERNALSYM TLS1_CK_ECDH_ECDSA_WITH_NULL_SHA}
  TLS1_CK_ECDH_ECDSA_WITH_NULL_SHA                = $0300C001;
  {$EXTERNALSYM TLS1_CK_ECDH_ECDSA_WITH_RC4_128_SHA}
  TLS1_CK_ECDH_ECDSA_WITH_RC4_128_SHA             = $0300C002;
  {$EXTERNALSYM TLS1_CK_ECDH_ECDSA_WITH_DES_192_CBC3_SHA}
  TLS1_CK_ECDH_ECDSA_WITH_DES_192_CBC3_SHA        = $0300C003;
  {$EXTERNALSYM TLS1_CK_ECDH_ECDSA_WITH_AES_128_CBC_SHA}
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_CBC_SHA         = $0300C004;
  {$EXTERNALSYM TLS1_CK_ECDH_ECDSA_WITH_AES_256_CBC_SHA}
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_CBC_SHA         = $0300C005;
  {$EXTERNALSYM TLS1_CK_ECDHE_ECDSA_WITH_NULL_SHA}
  TLS1_CK_ECDHE_ECDSA_WITH_NULL_SHA               = $0300C006;
  {$EXTERNALSYM TLS1_CK_ECDHE_ECDSA_WITH_RC4_128_SHA}
  TLS1_CK_ECDHE_ECDSA_WITH_RC4_128_SHA            = $0300C007;
  {$EXTERNALSYM TLS1_CK_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA}
  TLS1_CK_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA       = $0300C008;
  {$EXTERNALSYM TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CBC_SHA        = $0300C009;
  {$EXTERNALSYM TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CBC_SHA        = $0300C00A;
  {$EXTERNALSYM TLS1_CK_ECDH_RSA_WITH_NULL_SHA}
  TLS1_CK_ECDH_RSA_WITH_NULL_SHA                  = $0300C00B;
  {$EXTERNALSYM TLS1_CK_ECDH_RSA_WITH_RC4_128_SHA}
  TLS1_CK_ECDH_RSA_WITH_RC4_128_SHA               = $0300C00C;
  {$EXTERNALSYM TLS1_CK_ECDH_RSA_WITH_DES_192_CBC3_SHA}
  TLS1_CK_ECDH_RSA_WITH_DES_192_CBC3_SHA          = $0300C00D;
  {$EXTERNALSYM TLS1_CK_ECDH_RSA_WITH_AES_128_CBC_SHA}
  TLS1_CK_ECDH_RSA_WITH_AES_128_CBC_SHA           = $0300C00E;
  {$EXTERNALSYM TLS1_CK_ECDH_RSA_WITH_AES_256_CBC_SHA}
  TLS1_CK_ECDH_RSA_WITH_AES_256_CBC_SHA           = $0300C00F;
  {$EXTERNALSYM TLS1_CK_ECDHE_RSA_WITH_NULL_SHA}
  TLS1_CK_ECDHE_RSA_WITH_NULL_SHA                 = $0300C010;
  {$EXTERNALSYM TLS1_CK_ECDHE_RSA_WITH_RC4_128_SHA}
  TLS1_CK_ECDHE_RSA_WITH_RC4_128_SHA              = $0300C011;
  {$EXTERNALSYM TLS1_CK_ECDHE_RSA_WITH_DES_192_CBC3_SHA}
  TLS1_CK_ECDHE_RSA_WITH_DES_192_CBC3_SHA         = $0300C012;
  {$EXTERNALSYM TLS1_CK_ECDHE_RSA_WITH_AES_128_CBC_SHA}
  TLS1_CK_ECDHE_RSA_WITH_AES_128_CBC_SHA          = $0300C013;
  {$EXTERNALSYM TLS1_CK_ECDHE_RSA_WITH_AES_256_CBC_SHA}
  TLS1_CK_ECDHE_RSA_WITH_AES_256_CBC_SHA          = $0300C014;
  {$EXTERNALSYM TLS1_CK_ECDH_anon_WITH_NULL_SHA}
  TLS1_CK_ECDH_anon_WITH_NULL_SHA                 = $0300C015;
  {$EXTERNALSYM TLS1_CK_ECDH_anon_WITH_RC4_128_SHA}
  TLS1_CK_ECDH_anon_WITH_RC4_128_SHA              = $0300C016;
  {$EXTERNALSYM TLS1_CK_ECDH_anon_WITH_DES_192_CBC3_SHA}
  TLS1_CK_ECDH_anon_WITH_DES_192_CBC3_SHA         = $0300C017;
  {$EXTERNALSYM TLS1_CK_ECDH_anon_WITH_AES_128_CBC_SHA}
  TLS1_CK_ECDH_anon_WITH_AES_128_CBC_SHA          = $0300C018;
  {$EXTERNALSYM TLS1_CK_ECDH_anon_WITH_AES_256_CBC_SHA}
  TLS1_CK_ECDH_anon_WITH_AES_256_CBC_SHA          = $0300C019;
//* SRP ciphersuites from RFC 5054 */
  {$EXTERNALSYM TLS1_CK_SRP_SHA_WITH_3DES_EDE_CBC_SHA}
  TLS1_CK_SRP_SHA_WITH_3DES_EDE_CBC_SHA	= $0300C01A;
  {$EXTERNALSYM TLS1_CK_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA}
  TLS1_CK_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA	= $0300C01B;
  {$EXTERNALSYM TLS1_CK_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA}
  TLS1_CK_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA	= $0300C01C;
  {$EXTERNALSYM TLS1_CK_SRP_SHA_WITH_AES_128_CBC_SHA}
  TLS1_CK_SRP_SHA_WITH_AES_128_CBC_SHA = $0300C01D;
  {$EXTERNALSYM TLS1_CK_SRP_SHA_RSA_WITH_AES_128_CBC_SHA}
  TLS1_CK_SRP_SHA_RSA_WITH_AES_128_CBC_SHA	= $0300C01E;
  {$EXTERNALSYM TLS1_CK_SRP_SHA_DSS_WITH_AES_128_CBC_SHA}
  TLS1_CK_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = $0300C01F;
  {$EXTERNALSYM TLS1_CK_SRP_SHA_WITH_AES_256_CBC_SHA}
  TLS1_CK_SRP_SHA_WITH_AES_256_CBC_SHA = $0300C020;
  {$EXTERNALSYM TLS1_CK_SRP_SHA_RSA_WITH_AES_256_CBC_SHA}
  TLS1_CK_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = $0300C021;
  {$EXTERNALSYM TLS1_CK_SRP_SHA_DSS_WITH_AES_256_CBC_SHA}
  TLS1_CK_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = $0300C022;

//* ECDH HMAC based ciphersuites from RFC5289 */

  {$EXTERNALSYM TLS1_CK_ECDHE_ECDSA_WITH_AES_128_SHA256}
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_SHA256 = $0300C023;
  {$EXTERNALSYM TLS1_CK_ECDHE_ECDSA_WITH_AES_256_SHA384}
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_SHA384 = $0300C024;
  {$EXTERNALSYM TLS1_CK_ECDH_ECDSA_WITH_AES_128_SHA256}
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_SHA256 = $0300C025;
  {$EXTERNALSYM TLS1_CK_ECDH_ECDSA_WITH_AES_256_SHA384}
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_SHA384 = $0300C026;
  {$EXTERNALSYM TLS1_CK_ECDHE_RSA_WITH_AES_128_SHA256}
  TLS1_CK_ECDHE_RSA_WITH_AES_128_SHA256 = $0300C027;
  {$EXTERNALSYM TLS1_CK_ECDHE_RSA_WITH_AES_256_SHA384}
  TLS1_CK_ECDHE_RSA_WITH_AES_256_SHA384 = $0300C028;
  {$EXTERNALSYM TLS1_CK_ECDH_RSA_WITH_AES_128_SHA256}
  TLS1_CK_ECDH_RSA_WITH_AES_128_SHA256 = $0300C029;
  {$EXTERNALSYM TLS1_CK_ECDH_RSA_WITH_AES_256_SHA384}
  TLS1_CK_ECDH_RSA_WITH_AES_256_SHA384 = $0300C02A;

//* ECDH GCM based ciphersuites from RFC5289 */
  {$EXTERNALSYM TLS1_CK_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256	= $0300C02B;
  {$EXTERNALSYM TLS1_CK_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384	= $0300C02C;
  {$EXTERNALSYM TLS1_CK_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = $0300C02D;
  {$EXTERNALSYM TLS1_CK_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = $0300C02E;
  {$EXTERNALSYM TLS1_CK_ECDHE_RSA_WITH_AES_128_GCM_SHA256}
  TLS1_CK_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = $0300C02F;
  {$EXTERNALSYM TLS1_CK_ECDHE_RSA_WITH_AES_256_GCM_SHA384}
  TLS1_CK_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = $0300C030;
  {$EXTERNALSYM TLS1_CK_ECDH_RSA_WITH_AES_128_GCM_SHA256}
  TLS1_CK_ECDH_RSA_WITH_AES_128_GCM_SHA256 = $0300C031;
  {$EXTERNALSYM TLS1_CK_ECDH_RSA_WITH_AES_256_GCM_SHA384}
  TLS1_CK_ECDH_RSA_WITH_AES_256_GCM_SHA384 = $0300C032;


  {$EXTERNALSYM TLS1_FINISH_MAC_LENGTH}
  TLS1_FINISH_MAC_LENGTH = 12;
  {$EXTERNALSYM TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_MD5}
  TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_MD5 = 'EXP1024-RC4-MD5';
  {$EXTERNALSYM TLS1_TXT_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5}
  TLS1_TXT_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5 = 'EXP1024-RC2-CBC-MD5';
  {$EXTERNALSYM TLS1_TXT_RSA_EXPORT1024_WITH_DES_CBC_SHA}
  TLS1_TXT_RSA_EXPORT1024_WITH_DES_CBC_SHA = 'EXP1024-DES-CBC-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA}
  TLS1_TXT_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = 'EXP1024-DHE-DSS-DES-CBC-SHA';
  {$EXTERNALSYM TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_SHA}
  TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_SHA = 'EXP1024-RC4-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA}
  TLS1_TXT_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = 'EXP1024-DHE-DSS-RC4-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA}
  TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA = 'DHE-DSS-RC4-SHA';
//* AES ciphersuites from RFC3268 */
  {$EXTERNALSYM TLS1_TXT_RSA_WITH_AES_128_SHA}
  TLS1_TXT_RSA_WITH_AES_128_SHA = 'AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_DH_DSS_WITH_AES_128_SHA}
  TLS1_TXT_DH_DSS_WITH_AES_128_SHA ='DH-DSS-AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_DH_RSA_WITH_AES_128_SHA}
  TLS1_TXT_DH_RSA_WITH_AES_128_SHA = 'DH-RSA-AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_WITH_AES_128_SHA}
  TLS1_TXT_DHE_DSS_WITH_AES_128_SHA = 'DHE-DSS-AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_RSA_WITH_AES_128_SHA}
  TLS1_TXT_DHE_RSA_WITH_AES_128_SHA = 'DHE-RSA-AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_ADH_WITH_AES_128_SHA}
  TLS1_TXT_ADH_WITH_AES_128_SHA = 'ADH-AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_RSA_WITH_AES_256_SHA}
  TLS1_TXT_RSA_WITH_AES_256_SHA = 'AES256-SHA';
  {$EXTERNALSYM TLS1_TXT_DH_DSS_WITH_AES_256_SHA}
  TLS1_TXT_DH_DSS_WITH_AES_256_SHA ='DH-DSS-AES256-SHA';
  {$EXTERNALSYM TLS1_TXT_DH_RSA_WITH_AES_256_SHA}
  TLS1_TXT_DH_RSA_WITH_AES_256_SHA = 'DH-RSA-AES256-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_WITH_AES_256_SHA}
  TLS1_TXT_DHE_DSS_WITH_AES_256_SHA = 'DHE-DSS-AES256-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_RSA_WITH_AES_256_SHA}
  TLS1_TXT_DHE_RSA_WITH_AES_256_SHA ='DHE-RSA-AES256-SHA';
  {$EXTERNALSYM TLS1_TXT_ADH_WITH_AES_256_SHA}
  TLS1_TXT_ADH_WITH_AES_256_SHA = 'ADH-AES256-SHA';
//* ECC ciphersuites from draft-ietf-tls-ecc-01.txt (Mar 15, 2001) */
  {$EXTERNALSYM TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA}
  TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA               = 'ECDH-ECDSA-NULL-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA}
  TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA            = 'ECDH-ECDSA-RC4-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA}
  TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA       = 'ECDH-ECDSA-DES-CBC3-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_ECDSA_WITH_AES_128_CBC_SHA}
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_CBC_SHA        = 'ECDH-ECDSA-AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_ECDSA_WITH_AES_256_CBC_SHA}
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_CBC_SHA        = 'ECDH-ECDSA-AES256-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA}
  TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA              = 'ECDHE-ECDSA-NULL-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA}
  TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA           = 'ECDHE-ECDSA-RC4-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA}
  TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA      = 'ECDHE-ECDSA-DES-CBC3-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CBC_SHA}
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CBC_SHA       = 'ECDHE-ECDSA-AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CBC_SHA}
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CBC_SHA       = 'ECDHE-ECDSA-AES256-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_RSA_WITH_NULL_SHA}
  TLS1_TXT_ECDH_RSA_WITH_NULL_SHA                 = 'ECDH-RSA-NULL-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA}
  TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA              = 'ECDH-RSA-RC4-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA}
  TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA         = 'ECDH-RSA-DES-CBC3-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_RSA_WITH_AES_128_CBC_SHA}
  TLS1_TXT_ECDH_RSA_WITH_AES_128_CBC_SHA          = 'ECDH-RSA-AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_RSA_WITH_AES_256_CBC_SHA}
  TLS1_TXT_ECDH_RSA_WITH_AES_256_CBC_SHA          = 'ECDH-RSA-AES256-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA}
  TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA                = 'ECDHE-RSA-NULL-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA}
  TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA             = 'ECDHE-RSA-RC4-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA}
  TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA        = 'ECDHE-RSA-DES-CBC3-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDHE_RSA_WITH_AES_128_CBC_SHA}
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_CBC_SHA         = 'ECDHE-RSA-AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDHE_RSA_WITH_AES_256_CBC_SHA}
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_CBC_SHA         = 'ECDHE-RSA-AES256-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_anon_WITH_NULL_SHA}
  TLS1_TXT_ECDH_anon_WITH_NULL_SHA                = 'AECDH-NULL-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_anon_WITH_RC4_128_SHA}
  TLS1_TXT_ECDH_anon_WITH_RC4_128_SHA             = 'AECDH-RC4-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_anon_WITH_DES_192_CBC3_SHA}
  TLS1_TXT_ECDH_anon_WITH_DES_192_CBC3_SHA        = 'AECDH-DES-CBC3-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_anon_WITH_AES_128_CBC_SHA}
  TLS1_TXT_ECDH_anon_WITH_AES_128_CBC_SHA         = 'AECDH-AES128-SHA';
  {$EXTERNALSYM TLS1_TXT_ECDH_anon_WITH_AES_256_CBC_SHA}
  TLS1_TXT_ECDH_anon_WITH_AES_256_CBC_SHA         = 'AECDH-AES256-SHA';
//* Camellia ciphersuites from RFC4132 */
  {$EXTERNALSYM TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA = 'CAMELLIA128-SHA';
  {$EXTERNALSYM TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = 'DH-DSS-CAMELLIA128-SHA';
  {$EXTERNALSYM TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = 'DH-RSA-CAMELLIA128-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 'DHE-DSS-CAMELLIA128-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 'DHE-RSA-CAMELLIA128-SHA';
  {$EXTERNALSYM TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA}
  TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA = 'ADH-CAMELLIA128-SHA';
  {$EXTERNALSYM TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA = 'CAMELLIA256-SHA';
  {$EXTERNALSYM TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = 'DH-DSS-CAMELLIA256-SHA';
  {$EXTERNALSYM TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = 'DH-RSA-CAMELLIA256-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 'DHE-DSS-CAMELLIA256-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 'DHE-RSA-CAMELLIA256-SHA';
  {$EXTERNALSYM TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA}
  TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA = 'ADH-CAMELLIA256-SHA';
//* SEED ciphersuites from RFC4162 */
  {$EXTERNALSYM TLS1_TXT_RSA_WITH_SEED_SHA}
  TLS1_TXT_RSA_WITH_SEED_SHA                      = 'SEED-SHA';
  {$EXTERNALSYM TLS1_TXT_DH_DSS_WITH_SEED_SHA}
  TLS1_TXT_DH_DSS_WITH_SEED_SHA                   = 'DH-DSS-SEED-SHA';
  {$EXTERNALSYM TLS1_TXT_DH_RSA_WITH_SEED_SHA}
  TLS1_TXT_DH_RSA_WITH_SEED_SHA                   = 'DH-RSA-SEED-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_WITH_SEED_SHA}
  TLS1_TXT_DHE_DSS_WITH_SEED_SHA                  = 'DHE-DSS-SEED-SHA';
  {$EXTERNALSYM TLS1_TXT_DHE_RSA_WITH_SEED_SHA}
  TLS1_TXT_DHE_RSA_WITH_SEED_SHA                  = 'DHE-RSA-SEED-SHA';
  {$EXTERNALSYM TLS1_TXT_ADH_WITH_SEED_SHA}
  TLS1_TXT_ADH_WITH_SEED_SHA                      = 'ADH-SEED-SHA';
//* TLS v1.2 ciphersuites */
  {$EXTERNALSYM TLS1_TXT_RSA_WITH_NULL_SHA256}
  TLS1_TXT_RSA_WITH_NULL_SHA256	= 'NULL-SHA256';
  {$EXTERNALSYM TLS1_TXT_RSA_WITH_AES_128_SHA256}
  TLS1_TXT_RSA_WITH_AES_128_SHA256 = 'AES128-SHA256';
  {$EXTERNALSYM TLS1_TXT_RSA_WITH_AES_256_SHA256}
  TLS1_TXT_RSA_WITH_AES_256_SHA256 = 'AES256-SHA256';
  {$EXTERNALSYM TLS1_TXT_DH_DSS_WITH_AES_128_SHA256}
  TLS1_TXT_DH_DSS_WITH_AES_128_SHA256	= 'DH-DSS-AES128-SHA256';
  {$EXTERNALSYM TLS1_TXT_DH_RSA_WITH_AES_128_SHA256}
  TLS1_TXT_DH_RSA_WITH_AES_128_SHA256 = 'DH-RSA-AES128-SHA256';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_WITH_AES_128_SHA256}
  TLS1_TXT_DHE_DSS_WITH_AES_128_SHA256 = 'DHE-DSS-AES128-SHA256';
  {$EXTERNALSYM TLS1_TXT_DHE_RSA_WITH_AES_128_SHA256}
  TLS1_TXT_DHE_RSA_WITH_AES_128_SHA256 = 'DHE-RSA-AES128-SHA256';
  {$EXTERNALSYM TLS1_TXT_DH_DSS_WITH_AES_256_SHA256}
  TLS1_TXT_DH_DSS_WITH_AES_256_SHA256	= 'DH-DSS-AES256-SHA256';
  {$EXTERNALSYM TLS1_TXT_DH_RSA_WITH_AES_256_SHA256}
  TLS1_TXT_DH_RSA_WITH_AES_256_SHA256	= 'DH-RSA-AES256-SHA256';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_WITH_AES_256_SHA256}
  TLS1_TXT_DHE_DSS_WITH_AES_256_SHA256 = 'DHE-DSS-AES256-SHA256';
  {$EXTERNALSYM TLS1_TXT_DHE_RSA_WITH_AES_256_SHA256}
  TLS1_TXT_DHE_RSA_WITH_AES_256_SHA256 = 'DHE-RSA-AES256-SHA256';
  {$EXTERNALSYM TLS1_TXT_ADH_WITH_AES_128_SHA256}
  TLS1_TXT_ADH_WITH_AES_128_SHA256 = 'ADH-AES128-SHA256';
  {$EXTERNALSYM TLS1_TXT_ADH_WITH_AES_256_SHA256}
  TLS1_TXT_ADH_WITH_AES_256_SHA256 = 'ADH-AES256-SHA256';

//* TLS v1.2 GCM ciphersuites from RFC5288 */
  {$EXTERNALSYM TLS1_TXT_RSA_WITH_AES_128_GCM_SHA256}
  TLS1_TXT_RSA_WITH_AES_128_GCM_SHA256 = 'AES128-GCM-SHA256';
  {$EXTERNALSYM TLS1_TXT_RSA_WITH_AES_256_GCM_SHA384}
  TLS1_TXT_RSA_WITH_AES_256_GCM_SHA384 = 'AES256-GCM-SHA384';
  {$EXTERNALSYM TLS1_TXT_DHE_RSA_WITH_AES_128_GCM_SHA256}
TLS1_TXT_DHE_RSA_WITH_AES_128_GCM_SHA256 = 'DHE-RSA-AES128-GCM-SHA256';
  {$EXTERNALSYM TLS1_TXT_DHE_RSA_WITH_AES_256_GCM_SHA384}
TLS1_TXT_DHE_RSA_WITH_AES_256_GCM_SHA384 = 'DHE-RSA-AES256-GCM-SHA384';
  {$EXTERNALSYM TLS1_TXT_DH_RSA_WITH_AES_128_GCM_SHA256}
  TLS1_TXT_DH_RSA_WITH_AES_128_GCM_SHA256	= 'DH-RSA-AES128-GCM-SHA256';
  {$EXTERNALSYM TLS1_TXT_DH_RSA_WITH_AES_256_GCM_SHA384}
  TLS1_TXT_DH_RSA_WITH_AES_256_GCM_SHA384	= 'DH-RSA-AES256-GCM-SHA384';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_WITH_AES_128_GCM_SHA256}
  TLS1_TXT_DHE_DSS_WITH_AES_128_GCM_SHA256 = 'DHE-DSS-AES128-GCM-SHA256';
  {$EXTERNALSYM TLS1_TXT_DHE_DSS_WITH_AES_256_GCM_SHA384}
  TLS1_TXT_DHE_DSS_WITH_AES_256_GCM_SHA384 = 'DHE-DSS-AES256-GCM-SHA384';
  {$EXTERNALSYM TLS1_TXT_DH_DSS_WITH_AES_128_GCM_SHA256}
  TLS1_TXT_DH_DSS_WITH_AES_128_GCM_SHA256	= 'DH-DSS-AES128-GCM-SHA256';
  {$EXTERNALSYM TLS1_TXT_DH_DSS_WITH_AES_256_GCM_SHA384}
  TLS1_TXT_DH_DSS_WITH_AES_256_GCM_SHA384	=	'DH-DSS-AES256-GCM-SHA384';
  {$EXTERNALSYM TLS1_TXT_ADH_WITH_AES_128_GCM_SHA256}
  TLS1_TXT_ADH_WITH_AES_128_GCM_SHA256 = 'ADH-AES128-GCM-SHA256';
  {$EXTERNALSYM TLS1_TXT_ADH_WITH_AES_256_GCM_SHA384}
  TLS1_TXT_ADH_WITH_AES_256_GCM_SHA384 = 'ADH-AES256-GCM-SHA384';

//* ECDH HMAC based ciphersuites from RFC5289 */

  {$EXTERNALSYM TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_SHA256}
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_SHA256 = 'ECDHE-ECDSA-AES128-SHA256';
  {$EXTERNALSYM TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_SHA384}
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_SHA384 = 'ECDHE-ECDSA-AES256-SHA384';
  {$EXTERNALSYM TLS1_TXT_ECDH_ECDSA_WITH_AES_128_SHA256}
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_SHA256 = 'ECDH-ECDSA-AES128-SHA256';
  {$EXTERNALSYM TLS1_TXT_ECDH_ECDSA_WITH_AES_256_SHA384}
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_SHA384 = 'ECDH-ECDSA-AES256-SHA384';
  {$EXTERNALSYM TLS1_TXT_ECDHE_RSA_WITH_AES_128_SHA256}
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_SHA256 = 'ECDHE-RSA-AES128-SHA256';
  {$EXTERNALSYM TLS1_TXT_ECDHE_RSA_WITH_AES_256_SHA384}
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_SHA384 = 'ECDHE-RSA-AES256-SHA384';
  {$EXTERNALSYM TLS1_TXT_ECDH_RSA_WITH_AES_128_SHA256}
  TLS1_TXT_ECDH_RSA_WITH_AES_128_SHA256 = 'ECDH-RSA-AES128-SHA256';
  {$EXTERNALSYM TLS1_TXT_ECDH_RSA_WITH_AES_256_SHA384}
  TLS1_TXT_ECDH_RSA_WITH_AES_256_SHA384 = 'ECDH-RSA-AES256-SHA384';

//* ECDH GCM based ciphersuites from RFC5289 */
  {$EXTERNALSYM TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 'ECDHE-ECDSA-AES128-GCM-SHA256';
  {$EXTERNALSYM TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384}
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 'ECDHE-ECDSA-AES256-GCM-SHA384';
  {$EXTERNALSYM TLS1_TXT_ECDH_ECDSA_WITH_AES_128_GCM_SHA256}
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = 'ECDH-ECDSA-AES128-GCM-SHA256';
  {$EXTERNALSYM TLS1_TXT_ECDH_ECDSA_WITH_AES_256_GCM_SHA384}
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = 'ECDH-ECDSA-AES256-GCM-SHA384';
  {$EXTERNALSYM TLS1_TXT_ECDHE_RSA_WITH_AES_128_GCM_SHA256}
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 'ECDHE-RSA-AES128-GCM-SHA256';
  {$EXTERNALSYM TLS1_TXT_ECDHE_RSA_WITH_AES_256_GCM_SHA384}
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 'ECDHE-RSA-AES256-GCM-SHA384';
  {$EXTERNALSYM TLS1_TXT_ECDH_RSA_WITH_AES_128_GCM_SHA256}
  TLS1_TXT_ECDH_RSA_WITH_AES_128_GCM_SHA256 = 'ECDH-RSA-AES128-GCM-SHA256';
  {$EXTERNALSYM TLS1_TXT_ECDH_RSA_WITH_AES_256_GCM_SHA384}
  TLS1_TXT_ECDH_RSA_WITH_AES_256_GCM_SHA384 = 'ECDH-RSA-AES256-GCM-SHA384';

  {$EXTERNALSYM TLS_CT_RSA_SIGN}
  TLS_CT_RSA_SIGN = 1;
  {$EXTERNALSYM TLS_CT_DSS_SIGN}
  TLS_CT_DSS_SIGN = 2;
  {$EXTERNALSYM TLS_CT_RSA_FIXED_DH}
  TLS_CT_RSA_FIXED_DH = 3;
  {$EXTERNALSYM TLS_CT_DSS_FIXED_DH}
  TLS_CT_DSS_FIXED_DH = 4;
  {$EXTERNALSYM TLS_CT_ECDSA_SIGN}
  TLS_CT_ECDSA_SIGN	= 64;
  {$EXTERNALSYM TLS_CT_RSA_FIXED_ECDH}
  TLS_CT_RSA_FIXED_ECDH	= 65;
  {$EXTERNALSYM TLS_CT_ECDSA_FIXED_ECDH}
  TLS_CT_ECDSA_FIXED_ECDH = 66;
  {$EXTERNALSYM TLS_CT_GOST94_SIGN}
  TLS_CT_GOST94_SIGN = 21;
  {$EXTERNALSYM TLS_CT_GOST01_SIGN}
  TLS_CT_GOST01_SIGN = 22;
///* when correcting this number, correct also SSL3_CT_NUMBER in ssl3.h (see
// * comment there) */
  {$EXTERNALSYM TLS_CT_NUMBER}
  TLS_CT_NUMBER = 9; //was 4;

  {$EXTERNALSYM TLS_MD_CLIENT_FINISH_CONST}
  TLS_MD_CLIENT_FINISH_CONST = 'client finished';  {Do not localize}
  {$EXTERNALSYM TLS_MD_CLIENT_FINISH_CONST_SIZE}
  TLS_MD_CLIENT_FINISH_CONST_SIZE = 15;
  {$EXTERNALSYM TLS_MD_SERVER_FINISH_CONST}
  TLS_MD_SERVER_FINISH_CONST = 'server finished';  {Do not localize}
  {$EXTERNALSYM TLS_MD_SERVER_FINISH_CONST_SIZE}
  TLS_MD_SERVER_FINISH_CONST_SIZE = 15;
  {$EXTERNALSYM TLS_MD_KEY_EXPANSION_CONST}
  TLS_MD_KEY_EXPANSION_CONST = 'key expansion';  {Do not localize}
  {$EXTERNALSYM TLS_MD_KEY_EXPANSION_CONST_SIZE}
  TLS_MD_KEY_EXPANSION_CONST_SIZE = 13;
  {$EXTERNALSYM TLS_MD_CLIENT_WRITE_KEY_CONST}
  TLS_MD_CLIENT_WRITE_KEY_CONST = 'client write key';  {Do not localize}
  {$EXTERNALSYM TLS_MD_CLIENT_WRITE_KEY_CONST_SIZE}
  TLS_MD_CLIENT_WRITE_KEY_CONST_SIZE = 16;
  {$EXTERNALSYM TLS_MD_SERVER_WRITE_KEY_CONST}
  TLS_MD_SERVER_WRITE_KEY_CONST = 'server write key';  {Do not localize}
  {$EXTERNALSYM TLS_MD_SERVER_WRITE_KEY_CONST_SIZE}
  TLS_MD_SERVER_WRITE_KEY_CONST_SIZE = 16;
  {$EXTERNALSYM TLS_MD_IV_BLOCK_CONST}
  TLS_MD_IV_BLOCK_CONST = 'IV block';  {Do not localize}
  {$EXTERNALSYM TLS_MD_IV_BLOCK_CONST_SIZE}
  TLS_MD_IV_BLOCK_CONST_SIZE = 8;
  {$EXTERNALSYM TLS_MD_MASTER_SECRET_CONST}
  TLS_MD_MASTER_SECRET_CONST = 'master secret';  {Do not localize}
  {$EXTERNALSYM TLS_MD_MASTER_SECRET_CONST_SIZE}
  TLS_MD_MASTER_SECRET_CONST_SIZE = 13;
  {$EXTERNALSYM TLS_MD_MAX_CONST_SIZE}
  TLS_MD_MAX_CONST_SIZE = 20;

  {$EXTERNALSYM TMP_MAX}
  TMP_MAX = 26;
  {$EXTERNALSYM V_ASN1_APPLICATION}
  V_ASN1_APPLICATION = $40;
  {$EXTERNALSYM V_ASN1_APP_CHOOSE}
  V_ASN1_APP_CHOOSE = -2;
  {$EXTERNALSYM V_ASN1_BIT_STRING}
  V_ASN1_BIT_STRING = 3;
  {$EXTERNALSYM V_ASN1_BMPSTRING}
  V_ASN1_BMPSTRING = 30;
  {$EXTERNALSYM V_ASN1_BOOLEAN}
  V_ASN1_BOOLEAN = 1;
  {$EXTERNALSYM V_ASN1_CONSTRUCTED}
  V_ASN1_CONSTRUCTED = $20;
  {$EXTERNALSYM V_ASN1_CONTEXT_SPECIFIC}
  V_ASN1_CONTEXT_SPECIFIC = $80;
  {$EXTERNALSYM V_ASN1_ENUMERATED}
  V_ASN1_ENUMERATED = 10;
  {$EXTERNALSYM V_ASN1_EOC}
  V_ASN1_EOC = 0;
  {$EXTERNALSYM V_ASN1_EXTERNAL}
  V_ASN1_EXTERNAL = 8;
  {$EXTERNALSYM V_ASN1_GENERALIZEDTIME}
  V_ASN1_GENERALIZEDTIME = 24;
  {$EXTERNALSYM V_ASN1_GENERALSTRING}
  V_ASN1_GENERALSTRING = 27;
  {$EXTERNALSYM V_ASN1_GRAPHICSTRING}
  V_ASN1_GRAPHICSTRING = 25;
  {$EXTERNALSYM V_ASN1_IA5STRING}
  V_ASN1_IA5STRING = 22;
  {$EXTERNALSYM V_ASN1_INTEGER}
  V_ASN1_INTEGER = 2;
  {$EXTERNALSYM V_ASN1_ISO64STRING}
  V_ASN1_ISO64STRING = 26;
  {$EXTERNALSYM V_ASN1_NEG_ENUMERATED}
  V_ASN1_NEG_ENUMERATED = 10+$100;
  {$EXTERNALSYM V_ASN1_NEG_INTEGER}
  V_ASN1_NEG_INTEGER = 2+$100;
  {$EXTERNALSYM V_ASN1_NULL}
  V_ASN1_NULL = 5;
  {$EXTERNALSYM V_ASN1_NUMERICSTRING}
  V_ASN1_NUMERICSTRING = 18;
  {$EXTERNALSYM V_ASN1_OBJECT}
  V_ASN1_OBJECT = 6;
  {$EXTERNALSYM V_ASN1_OBJECT_DESCRIPTOR}
  V_ASN1_OBJECT_DESCRIPTOR = 7;
  {$EXTERNALSYM V_ASN1_OCTET_STRING}
  V_ASN1_OCTET_STRING = 4;
  {$EXTERNALSYM V_ASN1_PRIMATIVE_TAG}
  V_ASN1_PRIMATIVE_TAG = $1f;
  {$EXTERNALSYM V_ASN1_PRIMITIVE_TAG}
  V_ASN1_PRIMITIVE_TAG = $1f;
  {$EXTERNALSYM V_ASN1_PRINTABLESTRING}
  V_ASN1_PRINTABLESTRING = 19;
  {$EXTERNALSYM V_ASN1_PRIVATE}
  V_ASN1_PRIVATE = $c0;
  {$EXTERNALSYM V_ASN1_REAL}
  V_ASN1_REAL = 9;
  {$EXTERNALSYM V_ASN1_SEQUENCE}
  V_ASN1_SEQUENCE = 16;
  {$EXTERNALSYM V_ASN1_SET}
  V_ASN1_SET = 17;
  {$EXTERNALSYM V_ASN1_T61STRING}
  V_ASN1_T61STRING = 20;
  {$EXTERNALSYM V_ASN1_TELETEXSTRING}
  V_ASN1_TELETEXSTRING = 20;
  {$EXTERNALSYM V_ASN1_UNDEF}
  V_ASN1_UNDEF = -1;
  {$EXTERNALSYM V_ASN1_UNIVERSAL}
  V_ASN1_UNIVERSAL = $00;
  {$EXTERNALSYM V_ASN1_UNIVERSALSTRING}
  V_ASN1_UNIVERSALSTRING = 28;
  {$EXTERNALSYM V_ASN1_UTCTIME}
  V_ASN1_UTCTIME = 23;
  {$EXTERNALSYM V_ASN1_UTF8STRING}
  V_ASN1_UTF8STRING = 12;
  {$EXTERNALSYM V_ASN1_VIDEOTEXSTRING}
  V_ASN1_VIDEOTEXSTRING = 21;
  {$EXTERNALSYM V_ASN1_VISIBLESTRING}
  V_ASN1_VISIBLESTRING = 26;
  {$EXTERNALSYM WINNT}
  WINNT = 1;
  {$EXTERNALSYM X509_TRUST_DEFAULT}
  X509_TRUST_DEFAULT	= -1;	//* Only valid in purpose settings */
  {$EXTERNALSYM X509_TRUST_COMPAT}
  X509_TRUST_COMPAT	= 1;
  {$EXTERNALSYM X509_TRUST_SSL_CLIENT}
  X509_TRUST_SSL_CLIENT	= 2;
  {$EXTERNALSYM X509_TRUST_SSL_SERVER}
  X509_TRUST_SSL_SERVER	= 3;
  {$EXTERNALSYM X509_TRUST_EMAIL}
  X509_TRUST_EMAIL = 4;
  {$EXTERNALSYM X509_TRUST_OBJECT_SIGN}
  X509_TRUST_OBJECT_SIGN = 5;
  {$EXTERNALSYM X509_TRUST_OCSP_SIGN}
  X509_TRUST_OCSP_SIGN = 6;
  {$EXTERNALSYM X509_TRUST_OCSP_REQUEST}
  X509_TRUST_OCSP_REQUEST	= 7;
  {$EXTERNALSYM X509_TRUST_TSA}
  X509_TRUST_TSA = 8;
  {$EXTERNALSYM X509_TRUST_MIN}
  X509_TRUST_MIN = 1;
  {$EXTERNALSYM X509_TRUST_MAX}
  X509_TRUST_MAX = 8;
  {$EXTERNALSYM X509_EXT_PACK_STRING}
  X509_EXT_PACK_STRING = 2;
  {$EXTERNALSYM X509_EXT_PACK_UNKNOWN}
  X509_EXT_PACK_UNKNOWN = 1;
  {$EXTERNALSYM X509_EX_V_INIT}
  X509_EX_V_INIT = $0001;
  {$EXTERNALSYM X509_EX_V_NETSCAPE_HACK}
  X509_EX_V_NETSCAPE_HACK = $8000;
  {$EXTERNALSYM X509_FILETYPE_DEFAULT}
  X509_FILETYPE_DEFAULT = 3;
  {$EXTERNALSYM X509_F_ADD_CERT_DIR}
  X509_F_ADD_CERT_DIR                  = 100;
  {$EXTERNALSYM X509_F_BY_FILE_CTRL}
  X509_F_BY_FILE_CTRL                  = 101;
  {$EXTERNALSYM X509_F_DIR_CTRL}
  X509_F_DIR_CTRL                      = 102;
  {$EXTERNALSYM X509_F_GET_CERT_BY_SUBJECT}
  X509_F_GET_CERT_BY_SUBJECT           = 103;
  {$EXTERNALSYM X509_F_X509V3_ADD_EXT}
  X509_F_X509V3_ADD_EXT                = 104;
  {$EXTERNALSYM X509_F_X509_EXTENSION_CREATE_BY_NID}
  X509_F_X509_EXTENSION_CREATE_BY_NID  = 108;
  {$EXTERNALSYM X509_F_X509_EXTENSION_CREATE_BY_OBJ}
  X509_F_X509_EXTENSION_CREATE_BY_OBJ  = 109;

  {$EXTERNALSYM X509_F_X509_GET_PUBKEY_PARAMETERS}
  X509_F_X509_GET_PUBKEY_PARAMETERS    = 110;
  {$EXTERNALSYM X509_F_X509_LOAD_CERT_FILE}
  X509_F_X509_LOAD_CERT_FILE           = 111;
  {$EXTERNALSYM X509_F_X509_LOAD_CRL_FILE}
  X509_F_X509_LOAD_CRL_FILE            = 112;
  {$EXTERNALSYM X509_F_X509_NAME_ADD_ENTRY}
  X509_F_X509_NAME_ADD_ENTRY           = 113;
  {$EXTERNALSYM X509_F_X509_NAME_ENTRY_CREATE_BY_NID}
  X509_F_X509_NAME_ENTRY_CREATE_BY_NID = 114;
  {$EXTERNALSYM X509_F_X509_NAME_ENTRY_SET_OBJECT}
  X509_F_X509_NAME_ENTRY_SET_OBJECT    = 115;
  {$EXTERNALSYM X509_F_X509_NAME_ONELINE}
  X509_F_X509_NAME_ONELINE             = 116;
  {$EXTERNALSYM X509_F_X509_NAME_PRINT}
  X509_F_X509_NAME_PRINT               = 117;
  {$EXTERNALSYM X509_F_X509_PRINT_FP}
  X509_F_X509_PRINT_FP                 = 118;
  {$EXTERNALSYM X509_F_X509_PUBKEY_GET}
  X509_F_X509_PUBKEY_GET               = 119;

  {$EXTERNALSYM X509_F_X509_PUBKEY_SET}
  X509_F_X509_PUBKEY_SET               = 120;
  {$EXTERNALSYM X509_F_X509_REQ_PRINT}
  X509_F_X509_REQ_PRINT                = 121;
  {$EXTERNALSYM X509_F_X509_REQ_PRINT_FP}
  X509_F_X509_REQ_PRINT_FP             = 122;
  {$EXTERNALSYM X509_F_X509_REQ_TO_X509}
  X509_F_X509_REQ_TO_X509              = 123;
  {$EXTERNALSYM X509_F_X509_STORE_ADD_CERT}
  X509_F_X509_STORE_ADD_CERT           = 124;
  {$EXTERNALSYM X509_F_X509_STORE_ADD_CRL}
  X509_F_X509_STORE_ADD_CRL            = 125;
  {$EXTERNALSYM X509_F_X509_TO_X509_REQ}
  X509_F_X509_TO_X509_REQ              = 126;
  {$EXTERNALSYM X509_F_X509_VERIFY_CERT}
  X509_F_X509_VERIFY_CERT              = 127;
  {$EXTERNALSYM X509_F_X509_CHECK_PRIVATE_KEY}
  X509_F_X509_CHECK_PRIVATE_KEY        = 128;
  {$EXTERNALSYM X509_F_NETSCAPE_SPKI_B64_DECODE}
  X509_F_NETSCAPE_SPKI_B64_DECODE	     = 129;

  {$EXTERNALSYM X509_F_NETSCAPE_SPKI_B64_ENCODE}
  X509_F_NETSCAPE_SPKI_B64_ENCODE	     = 130;
  {$EXTERNALSYM X509_F_X509_NAME_ENTRY_CREATE_BY_TXT}
  X509_F_X509_NAME_ENTRY_CREATE_BY_TXT = 131;
  {$EXTERNALSYM X509_F_X509_LOAD_CERT_CRL_FILE}
  X509_F_X509_LOAD_CERT_CRL_FILE       = 132;
  {$EXTERNALSYM X509_F_X509_TRUST_ADD}
  X509_F_X509_TRUST_ADD                = 133;

  {$EXTERNALSYM X509_F_X509_STORE_CTX_PURPOSE_INHERIT}
  X509_F_X509_STORE_CTX_PURPOSE_INHERIT	= 134;
  {$EXTERNALSYM X509_F_X509AT_ADD1_ATTR}
  X509_F_X509AT_ADD1_ATTR	             = 135;
  {$EXTERNALSYM X509_F_X509_ATTRIBUTE_CREATE_BY_NID}
  X509_F_X509_ATTRIBUTE_CREATE_BY_NID  = 136;
  {$EXTERNALSYM X509_F_X509_ATTRIBUTE_CREATE_BY_OBJ}
  X509_F_X509_ATTRIBUTE_CREATE_BY_OBJ	 = 137;
  {$EXTERNALSYM X509_F_X509_ATTRIBUTE_SET1_DATA}
  X509_F_X509_ATTRIBUTE_SET1_DATA      = 138;
  {$EXTERNALSYM X509_F_X509_ATTRIBUTE_GET0_DATA}
  X509_F_X509_ATTRIBUTE_GET0_DATA      = 139;

  {$EXTERNALSYM X509_F_X509_ATTRIBUTE_CREATE_BY_TXT}
  X509_F_X509_ATTRIBUTE_CREATE_BY_TXT	 = 140;
  {$EXTERNALSYM X509_F_X509_TRUST_SET}
  X509_F_X509_TRUST_SET                = 141;
  {$EXTERNALSYM X509_F_X509_STORE_CTX_NEW}
  X509_F_X509_STORE_CTX_NEW		         = 142;
  {$EXTERNALSYM X509_F_X509_STORE_CTX_INIT}
  X509_F_X509_STORE_CTX_INIT           = 143;
  {$EXTERNALSYM X509_F_X509_REQ_CHECK_PRIVATE_KEY}
  X509_F_X509_REQ_CHECK_PRIVATE_KEY	   = 144;
  {$EXTERNALSYM X509_F_CHECK_POLICY}
  X509_F_CHECK_POLICY	                 = 145;
  {$EXTERNALSYM X509_F_X509_STORE_CTX_GET1_ISSUER}
  X509_F_X509_STORE_CTX_GET1_ISSUER		 = 146;
  {$EXTERNALSYM X509_F_X509_CRL_PRINT_FP}
  X509_F_X509_CRL_PRINT_FP             = 147;

  {$EXTERNALSYM X509_LU_CRL}
  X509_LU_CRL = 2;
  {$EXTERNALSYM X509_LU_FAIL}
  X509_LU_FAIL = 0;
  {$EXTERNALSYM X509_LU_PKEY}
  X509_LU_PKEY = 3;
  {$EXTERNALSYM X509_LU_RETRY}
  X509_LU_RETRY = -1;
  {$EXTERNALSYM X509_LU_X509}
  X509_LU_X509 = 1;
  {$EXTERNALSYM X509_L_ADD_DIR}
  X509_L_ADD_DIR = 2;
  {$EXTERNALSYM X509_L_FILE_LOAD}
  X509_L_FILE_LOAD = 1;
  {$EXTERNALSYM X509_R_BAD_X509_FILETYPE}
  X509_R_BAD_X509_FILETYPE = 100;
  {$EXTERNALSYM X509_R_BASE64_DECODE_ERROR}
  X509_R_BASE64_DECODE_ERROR = 118;
  {$EXTERNALSYM X509_R_CANT_CHECK_DH_KEY}
  X509_R_CANT_CHECK_DH_KEY = 114;
  {$EXTERNALSYM X509_R_CERT_ALREADY_IN_HASH_TABLE}
  X509_R_CERT_ALREADY_IN_HASH_TABLE = 101;
  {$EXTERNALSYM X509_R_ERR_ASN1_LIB}
  X509_R_ERR_ASN1_LIB = 102;
  {$EXTERNALSYM X509_R_INVALID_DIRECTORY}
  X509_R_INVALID_DIRECTORY = 113;
  {$EXTERNALSYM X509_R_INVALID_FIELD_NAME}
  X509_R_INVALID_FIELD_NAME = 119;
  {$EXTERNALSYM X509_R_INVALID_TRUST}
  X509_R_INVALID_TRUST = 123;
  {$EXTERNALSYM X509_R_KEY_TYPE_MISMATCH}
  X509_R_KEY_TYPE_MISMATCH = 115;
  {$EXTERNALSYM X509_R_KEY_VALUES_MISMATCH}
  X509_R_KEY_VALUES_MISMATCH = 116;
  {$EXTERNALSYM X509_R_LOADING_CERT_DIR}
  X509_R_LOADING_CERT_DIR = 103;
  {$EXTERNALSYM X509_R_LOADING_DEFAULTS}
  X509_R_LOADING_DEFAULTS = 104;
  {$EXTERNALSYM X509_R_METHOD_NOT_SUPPORTED}
  X509_R_METHOD_NOT_SUPPORTED	= 124;
  {$EXTERNALSYM X509_R_NO_CERT_SET_FOR_US_TO_VERIFY}
  X509_R_NO_CERT_SET_FOR_US_TO_VERIFY = 105;
  {$EXTERNALSYM X509_R_PUBLIC_KEY_DECODE_ERROR}
  X509_R_PUBLIC_KEY_DECODE_ERROR = 125;
  {$EXTERNALSYM X509_R_PUBLIC_KEY_ENCODE_ERROR}
  X509_R_PUBLIC_KEY_ENCODE_ERROR = 126;
  {$EXTERNALSYM X509_R_SHOULD_RETRY}
  X509_R_SHOULD_RETRY = 106;
  {$EXTERNALSYM X509_R_UNABLE_TO_FIND_PARAMETERS_IN_CHAIN}
  X509_R_UNABLE_TO_FIND_PARAMETERS_IN_CHAIN = 107;
  {$EXTERNALSYM X509_R_UNABLE_TO_GET_CERTS_PUBLIC_KEY}
  X509_R_UNABLE_TO_GET_CERTS_PUBLIC_KEY = 108;
  {$EXTERNALSYM X509_R_UNKNOWN_KEY_TYPE}
  X509_R_UNKNOWN_KEY_TYPE = 117;
  {$EXTERNALSYM X509_R_UNKNOWN_NID}
  X509_R_UNKNOWN_NID = 109;
  {$EXTERNALSYM X509_R_UNKNOWN_PURPOSE_ID}
  X509_R_UNKNOWN_PURPOSE_ID	= 121;
  {$EXTERNALSYM X509_R_UNSUPPORTED_ALGORITHM}
  X509_R_UNSUPPORTED_ALGORITHM = 111;
  {$EXTERNALSYM X509_R_WRONG_LOOKUP_TYPE}
  X509_R_WRONG_LOOKUP_TYPE = 112;
  {$EXTERNALSYM X509_R_WRONG_TYPE}
  X509_R_WRONG_TYPE = 122;

  {$EXTERNALSYM X509_V_ERR_UNSPECIFIED}
  X509_V_ERR_UNSPECIFIED = 1;
  {$EXTERNALSYM X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT}
  X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT = 2;
  {$EXTERNALSYM X509_V_ERR_UNABLE_TO_GET_CRL}
  X509_V_ERR_UNABLE_TO_GET_CRL = 3;
  {$EXTERNALSYM X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE}
  X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE = 4;
  {$EXTERNALSYM X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE}
  X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE = 5;
  {$EXTERNALSYM X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY}
  X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY = 6;
  {$EXTERNALSYM X509_V_ERR_CERT_SIGNATURE_FAILURE}
  X509_V_ERR_CERT_SIGNATURE_FAILURE = 7;
  {$EXTERNALSYM X509_V_ERR_CRL_SIGNATURE_FAILURE}
  X509_V_ERR_CRL_SIGNATURE_FAILURE = 8;
  {$EXTERNALSYM X509_V_ERR_CERT_NOT_YET_VALID}
  X509_V_ERR_CERT_NOT_YET_VALID = 9;
  {$EXTERNALSYM X509_V_ERR_CERT_HAS_EXPIRED}
  X509_V_ERR_CERT_HAS_EXPIRED = 10;
  {$EXTERNALSYM X509_V_ERR_CRL_NOT_YET_VALID}
  X509_V_ERR_CRL_NOT_YET_VALID = 11;
  {$EXTERNALSYM X509_V_ERR_CRL_HAS_EXPIRED}
  X509_V_ERR_CRL_HAS_EXPIRED = 12;
  {$EXTERNALSYM X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD}
  X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD = 13;
  {$EXTERNALSYM X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD}
  X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD = 14;
  {$EXTERNALSYM X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD}
  X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD = 15;
  {$EXTERNALSYM X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD}
  X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD = 16;
  {$EXTERNALSYM X509_V_ERR_OUT_OF_MEM}
  X509_V_ERR_OUT_OF_MEM = 17;
  {$EXTERNALSYM X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT}
  X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT = 18;
  {$EXTERNALSYM X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN}
  X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN = 19;
  {$EXTERNALSYM X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY}
  X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY = 20;
  {$EXTERNALSYM X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE}
  X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE = 21;
  {$EXTERNALSYM X509_V_ERR_CERT_CHAIN_TOO_LONG}
  X509_V_ERR_CERT_CHAIN_TOO_LONG = 22;
  {$EXTERNALSYM X509_V_ERR_CERT_REVOKED}
  X509_V_ERR_CERT_REVOKED = 23;
  {$EXTERNALSYM X509_V_ERR_INVALID_CA}
  X509_V_ERR_INVALID_CA	 = 24;
  {$EXTERNALSYM X509_V_ERR_PATH_LENGTH_EXCEEDED}
  X509_V_ERR_PATH_LENGTH_EXCEEDED	= 25;
  {$EXTERNALSYM X509_V_ERR_INVALID_PURPOSE}
  X509_V_ERR_INVALID_PURPOSE = 26;
  {$EXTERNALSYM X509_V_ERR_CERT_UNTRUSTED}
  X509_V_ERR_CERT_UNTRUSTED	= 27;
  {$EXTERNALSYM X509_V_ERR_CERT_REJECTED}
  X509_V_ERR_CERT_REJECTED = 28;
//* These are 'informational' when looking for issuer cert */
  {$EXTERNALSYM X509_V_ERR_SUBJECT_ISSUER_MISMATCH}
  X509_V_ERR_SUBJECT_ISSUER_MISMATCH = 29;
  {$EXTERNALSYM X509_V_ERR_AKID_SKID_MISMATCH}
  X509_V_ERR_AKID_SKID_MISMATCH	= 30;
  {$EXTERNALSYM X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH}
  X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH = 31;
  {$EXTERNALSYM X509_V_ERR_KEYUSAGE_NO_CERTSIGN}
  X509_V_ERR_KEYUSAGE_NO_CERTSIGN	= 32;
  {$EXTERNALSYM X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER}
  X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER	= 33;
  {$EXTERNALSYM X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION}
  X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION	= 34;
  {$EXTERNALSYM X509_V_ERR_KEYUSAGE_NO_CRL_SIGN}
  X509_V_ERR_KEYUSAGE_NO_CRL_SIGN	= 35;
  {$EXTERNALSYM X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION}
  X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION = 36;
  {$EXTERNALSYM X509_V_ERR_INVALID_NON_CA}
  X509_V_ERR_INVALID_NON_CA	= 37;
  {$EXTERNALSYM X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED}
  X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED = 38;
  {$EXTERNALSYM X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE}
  X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE = 39;
  {$EXTERNALSYM X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED}
  X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED = 40;
  {$EXTERNALSYM X509_V_ERR_INVALID_EXTENSION}
  X509_V_ERR_INVALID_EXTENSION = 41;
  {$EXTERNALSYM X509_V_ERR_INVALID_POLICY_EXTENSION}
  X509_V_ERR_INVALID_POLICY_EXTENSION = 42;
  {$EXTERNALSYM X509_V_ERR_NO_EXPLICIT_POLICY}
  X509_V_ERR_NO_EXPLICIT_POLICY = 43;
  {$EXTERNALSYM X509_V_ERR_DIFFERENT_CRL_SCOPE}
  X509_V_ERR_DIFFERENT_CRL_SCOPE = 44;
  {$EXTERNALSYM X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE}
  X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE = 45;

  {$EXTERNALSYM X509_V_ERR_UNNESTED_RESOURCE}
  X509_V_ERR_UNNESTED_RESOURCE = 46; //was 44;
  {$EXTERNALSYM X509_V_ERR_PERMITTED_VIOLATION}
  X509_V_ERR_PERMITTED_VIOLATION = 47;
  {$EXTERNALSYM X509_V_ERR_EXCLUDED_VIOLATION}
  X509_V_ERR_EXCLUDED_VIOLATION	= 48;
  {$EXTERNALSYM X509_V_ERR_SUBTREE_MINMAX}
  X509_V_ERR_SUBTREE_MINMAX = 49;
  {$EXTERNALSYM X509_V_ERR_APPLICATION_VERIFICATION}
  X509_V_ERR_APPLICATION_VERIFICATION = 50;
  {$EXTERNALSYM X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE}
  X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE = 51;
  {$EXTERNALSYM X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX}
  X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX = 52;
  {$EXTERNALSYM X509_V_ERR_UNSUPPORTED_NAME_SYNTAX}
  X509_V_ERR_UNSUPPORTED_NAME_SYNTAX = 53;
  {$EXTERNALSYM X509_V_ERR_CRL_PATH_VALIDATION_ERROR}
  X509_V_ERR_CRL_PATH_VALIDATION_ERROR = 54;
  {$EXTERNALSYM X509_V_ERR_PATH_LOOP}
  X509_V_ERR_PATH_LOOP = 55;
  {$EXTERNALSYM X509_V_ERR_SUITE_B_INVALID_VERSION}
  X509_V_ERR_SUITE_B_INVALID_VERSION = 56;
  {$EXTERNALSYM X509_V_ERR_SUITE_B_INVALID_ALGORITHM}
  X509_V_ERR_SUITE_B_INVALID_ALGORITHM = 57;
  {$EXTERNALSYM X509_V_ERR_SUITE_B_INVALID_CURVE}
  X509_V_ERR_SUITE_B_INVALID_CURVE = 58;
  {$EXTERNALSYM X509_V_ERR_SUITE_B_INVALID_SIGNATURE_ALGORITHM}
  X509_V_ERR_SUITE_B_INVALID_SIGNATURE_ALGORITHM = 59;
  {$EXTERNALSYM X509_V_ERR_SUITE_B_LOS_NOT_ALLOWED}
  X509_V_ERR_SUITE_B_LOS_NOT_ALLOWED = 60;
  {$EXTERNALSYM X509_V_ERR_SUITE_B_CANNOT_SIGN_P_384_WITH_P_256}
  X509_V_ERR_SUITE_B_CANNOT_SIGN_P_384_WITH_P_256 = 61;
  {$EXTERNALSYM X509_V_ERR_HOSTNAME_MISMATCH}
  X509_V_ERR_HOSTNAME_MISMATCH = 62;
  {$EXTERNALSYM X509_V_ERR_EMAIL_MISMATCH}
  X509_V_ERR_EMAIL_MISMATCH = 63;
  {$EXTERNALSYM X509_V_ERR_IP_ADDRESS_MISMATCH}
  X509_V_ERR_IP_ADDRESS_MISMATCH = 64;
  {$EXTERNALSYM X509_V_ERR_DANE_NO_MATCH}
  X509_V_ERR_DANE_NO_MATCH = 65;
  {$EXTERNALSYM X509_V_ERR_EE_KEY_TOO_SMALL}
  X509_V_ERR_EE_KEY_TOO_SMALL = 66;
  {$EXTERNALSYM X509_V_ERR_CA_KEY_TOO_SMALL}
  X509_V_ERR_CA_KEY_TOO_SMALL = 67;
  {$EXTERNALSYM X509_V_ERR_CA_MD_TOO_WEAK}
  X509_V_ERR_CA_MD_TOO_WEAK = 68;
  {$EXTERNALSYM X509_V_ERR_INVALID_CALL}
  X509_V_ERR_INVALID_CALL = 69;
  {$EXTERNALSYM X509_V_ERR_STORE_LOOKUP}
  X509_V_ERR_STORE_LOOKUP = 70;
  {$EXTERNALSYM X509_V_ERR_NO_VALID_SCTS}
  X509_V_ERR_NO_VALID_SCTS = 71;
  {$EXTERNALSYM X509_V_ERR_PROXY_SUBJECT_NAME_VIOLATION}
  X509_V_ERR_PROXY_SUBJECT_NAME_VIOLATION = 72;
  {$EXTERNALSYM X509_V_ERR_OCSP_VERIFY_NEEDED}
  X509_V_ERR_OCSP_VERIFY_NEEDED = 73;
  {$EXTERNALSYM X509_V_ERR_OCSP_VERIFY_FAILED}
  X509_V_ERR_OCSP_VERIFY_FAILED = 74;
  {$EXTERNALSYM X509_V_ERR_OCSP_CERT_UNKNOWN}
  X509_V_ERR_OCSP_CERT_UNKNOWN = 75;

  //* Certificate verify flags */

  //* Send issuer+subject checks to verify_cb */
  {$EXTERNALSYM X509_V_FLAG_CB_ISSUER_CHECK}
  X509_V_FLAG_CB_ISSUER_CHECK	= $1;
  //* Use check time instead of current time */
  {$EXTERNALSYM X509_V_FLAG_USE_CHECK_TIME}
  X509_V_FLAG_USE_CHECK_TIME = $2;
  //* Lookup CRLs */
  {$EXTERNALSYM X509_V_FLAG_CRL_CHECK}
  X509_V_FLAG_CRL_CHECK	 = $4;
  //* Lookup CRLs for whole chain */
  {$EXTERNALSYM X509_V_FLAG_CRL_CHECK_ALL}
  X509_V_FLAG_CRL_CHECK_ALL	= $8;
  //* Ignore unhandled critical extensions */
  {$EXTERNALSYM X509_V_FLAG_IGNORE_CRITICAL}
  X509_V_FLAG_IGNORE_CRITICAL	 = $10;
//* Disable workarounds for broken certificates */
  {$EXTERNALSYM X509_V_FLAG_X509_STRICT}
  X509_V_FLAG_X509_STRICT	= $20;
//* Enable proxy certificate validation */
  {$EXTERNALSYM X509_V_FLAG_ALLOW_PROXY_CERTS}
  X509_V_FLAG_ALLOW_PROXY_CERTS	= $40;
//* Enable policy checking */
  {$EXTERNALSYM X509_V_FLAG_POLICY_CHECK}
  X509_V_FLAG_POLICY_CHECK	= $80;
//* Policy variable require-explicit-policy */
  {$EXTERNALSYM X509_V_FLAG_EXPLICIT_POLICY}
  X509_V_FLAG_EXPLICIT_POLICY = $100;
//* Policy variable inhibit-any-policy */
  {$EXTERNALSYM X509_V_FLAG_INHIBIT_ANY}
  X509_V_FLAG_INHIBIT_ANY	= $200;
//* Policy variable inhibit-policy-mapping */
  {$EXTERNALSYM X509_V_FLAG_INHIBIT_MAP}
  X509_V_FLAG_INHIBIT_MAP	= $400;
//* Notify callback that policy is OK */
  {$EXTERNALSYM X509_V_FLAG_NOTIFY_POLICY}
  X509_V_FLAG_NOTIFY_POLICY	= $800;
//* Extended CRL features such as indirect CRLs, alternate CRL signing keys */
  {$EXTERNALSYM X509_V_FLAG_EXTENDED_CRL_SUPPORT}
  X509_V_FLAG_EXTENDED_CRL_SUPPORT = $1000;
//* Delta CRL support */
  {$EXTERNALSYM X509_V_FLAG_USE_DELTAS}
  X509_V_FLAG_USE_DELTAS = $2000;
//* Check selfsigned CA signature */
  {$EXTERNALSYM X509_V_FLAG_CHECK_SS_SIGNATURE}
  X509_V_FLAG_CHECK_SS_SIGNATURE = $4000;

  {$EXTERNALSYM X509_VP_FLAG_DEFAULT}
  X509_VP_FLAG_DEFAULT = $1;
  {$EXTERNALSYM X509_VP_FLAG_OVERWRITE}
  X509_VP_FLAG_OVERWRITE = $2;
  {$EXTERNALSYM X509_VP_FLAG_RESET_FLAGS}
  X509_VP_FLAG_RESET_FLAGS = $4;
  {$EXTERNALSYM X509_VP_FLAG_LOCKED}
  X509_VP_FLAG_LOCKED	= $8;
  {$EXTERNALSYM X509_VP_FLAG_ONCE}
  X509_VP_FLAG_ONCE	= $10;
  {$EXTERNALSYM X509_V_FLAG_POLICY_MASK}
  X509_V_FLAG_POLICY_MASK = (X509_V_FLAG_POLICY_CHECK or
    X509_V_FLAG_EXPLICIT_POLICY or
    X509_V_FLAG_INHIBIT_ANY or
    X509_V_FLAG_INHIBIT_MAP);

  {$EXTERNALSYM X509_V_OK}
  X509_V_OK = 0;
  {$EXTERNALSYM X509v3_KU_CRL_SIGN}
  X509v3_KU_CRL_SIGN = $0002;
  {$EXTERNALSYM X509v3_KU_DATA_ENCIPHERMENT}
  X509v3_KU_DATA_ENCIPHERMENT = $0010;
  {$EXTERNALSYM X509v3_KU_DECIPHER_ONLY}
  X509v3_KU_DECIPHER_ONLY = $8000;
  {$EXTERNALSYM X509v3_KU_DIGITAL_SIGNATURE}
  X509v3_KU_DIGITAL_SIGNATURE = $0080;
  {$EXTERNALSYM X509v3_KU_ENCIPHER_ONLY}
  X509v3_KU_ENCIPHER_ONLY = $0001;
  {$EXTERNALSYM X509v3_KU_KEY_AGREEMENT}
  X509v3_KU_KEY_AGREEMENT = $0008;
  {$EXTERNALSYM X509v3_KU_KEY_CERT_SIGN}
  X509v3_KU_KEY_CERT_SIGN = $0004;
  {$EXTERNALSYM X509v3_KU_KEY_ENCIPHERMENT}
  X509v3_KU_KEY_ENCIPHERMENT = $0020;
  {$EXTERNALSYM X509v3_KU_NON_REPUDIATION}
  X509v3_KU_NON_REPUDIATION = $0040;
  {$EXTERNALSYM X509v3_KU_UNDEF}
  X509v3_KU_UNDEF = $ffff;
  {$EXTERNALSYM X509V3_EXT_DYNAMIC}
  X509V3_EXT_DYNAMIC = $1;
  {$EXTERNALSYM X509V3_EXT_CTX_DEP}
  X509V3_EXT_CTX_DEP = $2;
  {$EXTERNALSYM X509V3_EXT_MULTILINE}
  X509V3_EXT_MULTILINE = $4;
  {$EXTERNALSYM GEN_OTHERNAME}
  GEN_OTHERNAME	= 0;
  {$EXTERNALSYM GEN_EMAIL}
  GEN_EMAIL	= 1;
  {$EXTERNALSYM GEN_DNS}
  GEN_DNS = 2;
  {$EXTERNALSYM GEN_X400}
  GEN_X400 = 3;
  {$EXTERNALSYM GEN_DIRNAME}
  GEN_DIRNAME = 4;
  {$EXTERNALSYM GEN_EDIPARTY}
  GEN_EDIPARTY = 5;
  {$EXTERNALSYM GEN_URI}
  GEN_URI	= 6;
  {$EXTERNALSYM GEN_IPADD}
  GEN_IPADD = 7;
  {$EXTERNALSYM GEN_RID}
  GEN_RID = 8;
  {$EXTERNALSYM CRLDP_ALL_REASONS}
  CRLDP_ALL_REASONS = $807f;
  {$EXTERNALSYM CRL_REASON_NONE}
  CRL_REASON_NONE	=	-1;
  {$EXTERNALSYM CRL_REASON_UNSPECIFIED}
  CRL_REASON_UNSPECIFIED = 0;
  {$EXTERNALSYM CRL_REASON_KEY_COMPROMISE}
  CRL_REASON_KEY_COMPROMISE	= 1;
  {$EXTERNALSYM CRL_REASON_CA_COMPROMISE}
  CRL_REASON_CA_COMPROMISE = 2;
  {$EXTERNALSYM CRL_REASON_AFFILIATION_CHANGED}
  CRL_REASON_AFFILIATION_CHANGED = 3;
  {$EXTERNALSYM CRL_REASON_SUPERSEDED}
  CRL_REASON_SUPERSEDED = 4;
  {$EXTERNALSYM CRL_REASON_CESSATION_OF_OPERATION}
  CRL_REASON_CESSATION_OF_OPERATION = 5;
  {$EXTERNALSYM CRL_REASON_CERTIFICATE_HOLD}
  CRL_REASON_CERTIFICATE_HOLD	= 6;
  {$EXTERNALSYM CRL_REASON_REMOVE_FROM_CRL}
  CRL_REASON_REMOVE_FROM_CRL = 8;
  {$EXTERNALSYM CRL_REASON_PRIVILEGE_WITHDRAWN}
  CRL_REASON_PRIVILEGE_WITHDRAWN = 9;
  {$EXTERNALSYM CRL_REASON_AA_COMPROMISE}
  CRL_REASON_AA_COMPROMISE = 10;

//* Values in idp_flags field */
//* IDP present */
  {$EXTERNALSYM IDP_PRESENT}
	IDP_PRESENT	= $1;
//* IDP values inconsistent */
  {$EXTERNALSYM IDP_INVALID}
  IDP_INVALID	= $2;
//* onlyuser true */
  {$EXTERNALSYM IDP_ONLYUSER}
  IDP_ONLYUSER = $4;
//* onlyCA true */
  {$EXTERNALSYM IDP_ONLYCA}
  IDP_ONLYCA	= $8;
//* onlyattr true */
  {$EXTERNALSYM IDP_ONLYATTR}
  IDP_ONLYATTR = $10;
//* indirectCRL true */
  {$EXTERNALSYM IDP_INDIRECT}
  IDP_INDIRECT = $20;
//* onlysomereasons present */
  {$EXTERNALSYM IDP_REASONS}
  IDP_REASONS	= $40;

  //* X509_PURPOSE stuff */
  {$EXTERNALSYM EXFLAG_BCONS}
  EXFLAG_BCONS = $1;
  {$EXTERNALSYM EXFLAG_KUSAGE}
  EXFLAG_KUSAGE	= $2;
  {$EXTERNALSYM EXFLAG_XKUSAGE}
  EXFLAG_XKUSAGE = $4;
  {$EXTERNALSYM EXFLAG_NSCERT}
  EXFLAG_NSCERT	= $8;
  {$EXTERNALSYM EXFLAG_CA}
  EXFLAG_CA = $10;
  //* Really self issued not necessarily self signed */
  {$EXTERNALSYM EXFLAG_SI}
  EXFLAG_SI	= $20;
  {$EXTERNALSYM EXFLAG_SS}
  EXFLAG_SS	= $20;
  {$EXTERNALSYM EXFLAG_V1}
  EXFLAG_V1	= $40;
  {$EXTERNALSYM EXFLAG_INVALID}
  EXFLAG_INVALID = $80;
  {$EXTERNALSYM EXFLAG_SET}
  EXFLAG_SET = $100;
  {$EXTERNALSYM EXFLAG_CRITICAL}
  EXFLAG_CRITICAL	= $200;
  {$EXTERNALSYM EXFLAG_PROXY}
  EXFLAG_PROXY = $400;
  {$EXTERNALSYM EXFLAG_INVALID_POLICY}
  EXFLAG_INVALID_POLICY = $800;
  {$EXTERNALSYM KU_DIGITAL_SIGNATURE}
  KU_DIGITAL_SIGNATURE = $0080;
  {$EXTERNALSYM KU_NON_REPUDIATION}
  KU_NON_REPUDIATION	= $0040;
  {$EXTERNALSYM KU_KEY_ENCIPHERMENT}
  KU_KEY_ENCIPHERMENT	= $0020;
  {$EXTERNALSYM KU_DATA_ENCIPHERMENT}
  KU_DATA_ENCIPHERMENT = $0010;
  {$EXTERNALSYM KU_KEY_AGREEMENT}
  KU_KEY_AGREEMENT = $0008;
  {$EXTERNALSYM KU_KEY_CERT_SIGN}
  KU_KEY_CERT_SIGN = $0004;
  {$EXTERNALSYM KU_CRL_SIGN}
  KU_CRL_SIGN	= $0002;
  {$EXTERNALSYM KU_ENCIPHER_ONLY}
  KU_ENCIPHER_ONLY = $0001;
  {$EXTERNALSYM KU_DECIPHER_ONLY}
  KU_DECIPHER_ONLY = $8000;
  {$EXTERNALSYM NS_SSL_CLIENT}
  NS_SSL_CLIENT	= $80;
  {$EXTERNALSYM NS_SSL_SERVER}
  NS_SSL_SERVER	= $40;
  {$EXTERNALSYM NS_SMIME}
  NS_SMIME = $20;
  {$EXTERNALSYM NS_OBJSIGN}
  NS_OBJSIGN = $10;
  {$EXTERNALSYM NS_SSL_CA}
  NS_SSL_CA	= $04;
  {$EXTERNALSYM NS_SMIME_CA}
  NS_SMIME_CA	= $02;
  {$EXTERNALSYM NS_OBJSIGN_CA}
  NS_OBJSIGN_CA = $01;
  {$EXTERNALSYM NS_ANY_CA}
  NS_ANY_CA	= (NS_SSL_CA or NS_SMIME_CA or
  {$EXTERNALSYM XKU_SSL_SERVER}
    NS_OBJSIGN_CA);
  {$EXTERNALSYM XKU_SSL_SERVER}
  XKU_SSL_SERVER = $1;
  {$EXTERNALSYM XKU_SSL_CLIENT}
  XKU_SSL_CLIENT = $2;
  {$EXTERNALSYM XKU_SMIME}
  XKU_SMIME	=	$4;
  {$EXTERNALSYM XKU_CODE_SIGN}
  XKU_CODE_SIGN	= $8;
  {$EXTERNALSYM XKU_SGC}
  XKU_SGC	= $10;
  {$EXTERNALSYM XKU_OCSP_SIGN}
  XKU_OCSP_SIGN = $20;
  {$EXTERNALSYM XKU_TIMESTAMP}
  XKU_TIMESTAMP = $40;
  {$EXTERNALSYM XKU_DVCS}
  XKU_DVCS = $80;
  {$EXTERNALSYM X509_PURPOSE_DYNAMIC}
  X509_PURPOSE_DYNAMIC = $1;
  {$EXTERNALSYM X509_PURPOSE_DYNAMIC_NAME}
  X509_PURPOSE_DYNAMIC_NAME = $2;

  {$EXTERNALSYM X509_PURPOSE_SSL_CLIENT}
  X509_PURPOSE_SSL_CLIENT	= 1;
  {$EXTERNALSYM X509_PURPOSE_SSL_SERVER}
  X509_PURPOSE_SSL_SERVER	= 2;
  {$EXTERNALSYM X509_PURPOSE_NS_SSL_SERVER}
  X509_PURPOSE_NS_SSL_SERVER = 3;
  {$EXTERNALSYM X509_PURPOSE_SMIME_SIGN}
  X509_PURPOSE_SMIME_SIGN	= 4;
  {$EXTERNALSYM X509_PURPOSE_SMIME_ENCRYPT}
  X509_PURPOSE_SMIME_ENCRYPT = 5;
  {$EXTERNALSYM X509_PURPOSE_CRL_SIGN}
  X509_PURPOSE_CRL_SIGN	= 6;
  {$EXTERNALSYM X509_PURPOSE_ANY}
  X509_PURPOSE_ANY = 7;
  {$EXTERNALSYM X509_PURPOSE_OCSP_HELPER}
  X509_PURPOSE_OCSP_HELPER = 8;
  {$EXTERNALSYM X509_PURPOSE_TIMESTAMP_SIGN}
  X509_PURPOSE_TIMESTAMP_SIGN = 9;

  {$EXTERNALSYM X509_PURPOSE_MIN}
  X509_PURPOSE_MIN = 1;
  {$EXTERNALSYM X509_PURPOSE_MAX}
  X509_PURPOSE_MAX = 9;


//* Flags for X509V3_EXT_print() */

  {$EXTERNALSYM X509V3_EXT_UNKNOWN_MASK}
  X509V3_EXT_UNKNOWN_MASK		= TIdC_LONG($f shl 16);
//* Return error for unknown extensions */
  {$EXTERNALSYM X509V3_EXT_DEFAULT}
  X509V3_EXT_DEFAULT		= 0;
//* Print error for unknown extensions */
  {$EXTERNALSYM X509V3_EXT_ERROR_UNKNOWN}
 X509V3_EXT_ERROR_UNKNOWN = (TIdC_LONG(1) shl 16);
//* ASN1 parse unknown extensions */
  {$EXTERNALSYM X509V3_EXT_PARSE_UNKNOWN}
  X509V3_EXT_PARSE_UNKNOWN = (TIdC_LONG(2) shl 16);
//* BIO_dump unknown extensions */
  {$EXTERNALSYM X509V3_EXT_DUMP_UNKNOWN}
  X509V3_EXT_DUMP_UNKNOWN	 = (TIdC_LONG(3) shl 16);

//* Flags for X509V3_add1_i2d */
  {$EXTERNALSYM X509V3_ADD_OP_MASK}
  X509V3_ADD_OP_MASK	 = TIdC_LONG($f);
  {$EXTERNALSYM X509V3_ADD_DEFAULT}
  X509V3_ADD_DEFAULT	 = TIdC_LONG(0);
  {$EXTERNALSYM X509V3_ADD_APPEND}
  X509V3_ADD_APPEND		= TIdC_LONG(1);
  {$EXTERNALSYM X509V3_ADD_REPLACE}
  X509V3_ADD_REPLACE	= TIdC_LONG(2);
  {$EXTERNALSYM X509V3_ADD_REPLACE_EXISTING}
  X509V3_ADD_REPLACE_EXISTING	= TIdC_LONG(3);
  {$EXTERNALSYM X509V3_ADD_KEEP_EXISTING}
  X509V3_ADD_KEEP_EXISTING	= TIdC_LONG(4);
  {$EXTERNALSYM X509V3_ADD_DELETE}
  X509V3_ADD_DELETE		= TIdC_LONG(5);
  {$EXTERNALSYM X509V3_ADD_SILENT}
  X509V3_ADD_SILENT	 = TIdC_LONG($10);

  {$IFNDEF OPENSSL_NO_RFC3779}
  {$EXTERNALSYM ASIdOrRange_id}
	ASIdOrRange_id	  =	0;
  {$EXTERNALSYM ASIdOrRange_range}
  ASIdOrRange_range	= 1;

  {$EXTERNALSYM ASIdentifierChoice_inherit}
  ASIdentifierChoice_inherit = 0;
  {$EXTERNALSYM ASIdentifierChoice_asIdsOrRanges}
  ASIdentifierChoice_asIdsOrRanges = 1;

  {$EXTERNALSYM IPAddressOrRange_addressPrefix}
  IPAddressOrRange_addressPrefix	= 0;
  {$EXTERNALSYM IPAddressOrRange_addressRange}
  IPAddressOrRange_addressRange	= 1;

  {$EXTERNALSYM IPAddressChoice_inherit}
  IPAddressChoice_inherit		 = 0;
  {$EXTERNALSYM IPAddressChoice_addressesOrRanges}
  IPAddressChoice_addressesOrRanges	= 1;

//  /*
// * API tag for elements of the ASIdentifer SEQUENCE.
// */
  {$EXTERNALSYM V3_ASID_ASNUM}
  V3_ASID_ASNUM	= 0;
  {$EXTERNALSYM V3_ASID_RDI}
  V3_ASID_RDI	= 1;

//*
// * AFI values, assigned by IANA.  It'd be nice to make the AFI
// * handling code totally generic, but there are too many little things
// * that would need to be defined for other address families for it to
// * be worth the trouble.
// */
  {$EXTERNALSYM IANA_AFI_IPV4}
  IANA_AFI_IPV4	= 1;
  {$EXTERNALSYM IANA_AFI_IPV6}
  IANA_AFI_IPV6	= 2;
  {$ENDIF}

	//* Function codes. */
  {$EXTERNALSYM X509V3_F_A2I_GENERAL_NAME}
  X509V3_F_A2I_GENERAL_NAME		 = 164;
  {$EXTERNALSYM X509V3_F_ASIDENTIFIERCHOICE_CANONIZE}
  X509V3_F_ASIDENTIFIERCHOICE_CANONIZE		= 161;
  {$EXTERNALSYM X509V3_F_ASIDENTIFIERCHOICE_IS_CANONICAL}
  X509V3_F_ASIDENTIFIERCHOICE_IS_CANONICAL	= 162;
  {$EXTERNALSYM X509V3_F_COPY_EMAIL}
  X509V3_F_COPY_EMAIL				= 122;
  {$EXTERNALSYM X509V3_F_COPY_ISSUER}
  X509V3_F_COPY_ISSUER			 = 123;
  {$EXTERNALSYM X509V3_F_DO_DIRNAME}
  X509V3_F_DO_DIRNAME				= 144;
  {$EXTERNALSYM X509V3_F_DO_EXT_CONF}
  X509V3_F_DO_EXT_CONF			 = 124;
  {$EXTERNALSYM X509V3_F_DO_EXT_I2D}
  X509V3_F_DO_EXT_I2D				= 135;
  {$EXTERNALSYM X509V3_F_DO_EXT_NCONF}
  X509V3_F_DO_EXT_NCONF				= 151;
  {$EXTERNALSYM X509V3_F_DO_I2V_NAME_CONSTRAINTS}
  X509V3_F_DO_I2V_NAME_CONSTRAINTS		= 148;
  {$EXTERNALSYM X509V3_F_GNAMES_FROM_SECTNAME}
  X509V3_F_GNAMES_FROM_SECTNAME			= 156;
  {$EXTERNALSYM X509V3_F_HEX_TO_STRING}
  X509V3_F_HEX_TO_STRING				 = 111;
  {$EXTERNALSYM X509V3_F_I2S_ASN1_ENUMERATED}
  X509V3_F_I2S_ASN1_ENUMERATED	= 121;
  {$EXTERNALSYM X509V3_F_I2S_ASN1_IA5STRING}
  X509V3_F_I2S_ASN1_IA5STRING	  = 149;
  {$EXTERNALSYM X509V3_F_I2S_ASN1_INTEGER}
  X509V3_F_I2S_ASN1_INTEGER = 120;
  {$EXTERNALSYM X509V3_F_I2V_AUTHORITY_INFO_ACCESS}
  X509V3_F_I2V_AUTHORITY_INFO_ACCESS		= 138;
  {$EXTERNALSYM X509V3_F_NOTICE_SECTION}
  X509V3_F_NOTICE_SECTION				 =132;
  {$EXTERNALSYM X509V3_F_NREF_NOS}
  X509V3_F_NREF_NOS				 =133;
  {$EXTERNALSYM X509V3_F_POLICY_SECTION}
  X509V3_F_POLICY_SECTION				 =131;
  {$EXTERNALSYM X509V3_F_PROCESS_PCI_VALUE}
  X509V3_F_PROCESS_PCI_VALUE			 =150;
  {$EXTERNALSYM X509V3_F_R2I_CERTPOL}
  X509V3_F_R2I_CERTPOL				 =130;
  {$EXTERNALSYM X509V3_F_R2I_PCI}
  X509V3_F_R2I_PCI                              = 155;
  {$EXTERNALSYM X509V3_F_S2I_ASN1_IA5STRING}
  X509V3_F_S2I_ASN1_IA5STRING                   = 100;
  {$EXTERNALSYM X509V3_F_S2I_ASN1_INTEGER}
  X509V3_F_S2I_ASN1_INTEGER                     = 108;
  {$EXTERNALSYM X509V3_F_S2I_ASN1_OCTET_STRING}
  X509V3_F_S2I_ASN1_OCTET_STRING                = 112;
  {$EXTERNALSYM X509V3_F_S2I_ASN1_SKEY_ID}
  X509V3_F_S2I_ASN1_SKEY_ID                     = 114;
  {$EXTERNALSYM X509V3_F_S2I_SKEY_ID}
  X509V3_F_S2I_SKEY_ID                          = 115;
  {$EXTERNALSYM X509V3_F_SET_DIST_POINT_NAME}
  X509V3_F_SET_DIST_POINT_NAME                  = 158;
  {$EXTERNALSYM X509V3_F_STRING_TO_HEX}
  X509V3_F_STRING_TO_HEX                        = 113;
  {$EXTERNALSYM X509V3_F_SXNET_ADD_ID_ASC}
  X509V3_F_SXNET_ADD_ID_ASC                     = 125;
  {$EXTERNALSYM X509V3_F_SXNET_ADD_ID_INTEGER}
  X509V3_F_SXNET_ADD_ID_INTEGER                 = 126;
  {$EXTERNALSYM X509V3_F_SXNET_ADD_ID_ULONG}
  X509V3_F_SXNET_ADD_ID_ULONG                   = 127;
  {$EXTERNALSYM X509V3_F_SXNET_GET_ID_ASC}
  X509V3_F_SXNET_GET_ID_ASC                     = 128;
  {$EXTERNALSYM X509V3_F_SXNET_GET_ID_ULONG}
  X509V3_F_SXNET_GET_ID_ULONG                   = 129;
  {$EXTERNALSYM X509V3_F_V2I_ASIDENTIFIERS}
  X509V3_F_V2I_ASIDENTIFIERS                    = 163;
  {$EXTERNALSYM X509V3_F_V2I_ASN1_BIT_STRING}
  X509V3_F_V2I_ASN1_BIT_STRING                  = 101;
  {$EXTERNALSYM X509V3_F_V2I_AUTHORITY_INFO_ACCESS}
  X509V3_F_V2I_AUTHORITY_INFO_ACCESS            = 139;
  {$EXTERNALSYM X509V3_F_V2I_AUTHORITY_KEYID}
  X509V3_F_V2I_AUTHORITY_KEYID                  = 119;
  {$EXTERNALSYM X509V3_F_V2I_BASIC_CONSTRAINTS}
  X509V3_F_V2I_BASIC_CONSTRAINTS                = 102;
  {$EXTERNALSYM X509V3_F_V2I_CRLD}
  X509V3_F_V2I_CRLD				= 134;
  {$EXTERNALSYM X509V3_F_V2I_EXTENDED_KEY_USAGE}
  X509V3_F_V2I_EXTENDED_KEY_USAGE               = 103;
  {$EXTERNALSYM X509V3_F_V2I_GENERAL_NAMES}
  X509V3_F_V2I_GENERAL_NAMES                    = 118;
  {$EXTERNALSYM X509V3_F_V2I_GENERAL_NAME_EX}
  X509V3_F_V2I_GENERAL_NAME_EX			= 117;
  {$EXTERNALSYM X509V3_F_V2I_IDP}
  X509V3_F_V2I_IDP				= 157;
  {$EXTERNALSYM X509V3_F_V2I_IPADDRBLOCKS}
  X509V3_F_V2I_IPADDRBLOCKS			= 159;
  {$EXTERNALSYM X509V3_F_V2I_ISSUER_ALT}
  X509V3_F_V2I_ISSUER_ALT                       = 153;
  {$EXTERNALSYM X509V3_F_V2I_NAME_CONSTRAINTS}
  X509V3_F_V2I_NAME_CONSTRAINTS			= 147;
  {$EXTERNALSYM X509V3_F_V2I_POLICY_CONSTRAINTS}
  X509V3_F_V2I_POLICY_CONSTRAINTS		= 146;
  {$EXTERNALSYM X509V3_F_V2I_POLICY_MAPPINGS}
  X509V3_F_V2I_POLICY_MAPPINGS			= 145;
  {$EXTERNALSYM X509V3_F_V2I_SUBJECT_ALT}
  X509V3_F_V2I_SUBJECT_ALT			= 154;
  {$EXTERNALSYM X509V3_F_V3_ADDR_VALIDATE_PATH_INTERNAL}
  X509V3_F_V3_ADDR_VALIDATE_PATH_INTERNAL		= 160;
  {$EXTERNALSYM X509V3_F_V3_GENERIC_EXTENSION}
  X509V3_F_V3_GENERIC_EXTENSION			= 116;
  {$EXTERNALSYM X509V3_F_X509V3_ADD1_I2D}
  X509V3_F_X509V3_ADD1_I2D			= 140;
  {$EXTERNALSYM X509V3_F_X509V3_ADD_VALUE}
  X509V3_F_X509V3_ADD_VALUE			= 105;
  {$EXTERNALSYM X509V3_F_X509V3_EXT_ADD}
  X509V3_F_X509V3_EXT_ADD				= 104;
  {$EXTERNALSYM X509V3_F_X509V3_EXT_ADD_ALIAS}
  X509V3_F_X509V3_EXT_ADD_ALIAS			= 106;
  {$EXTERNALSYM X509V3_F_X509V3_EXT_CONF}
  X509V3_F_X509V3_EXT_CONF		 = 107;
  {$EXTERNALSYM X509V3_F_X509V3_EXT_I2D}
  X509V3_F_X509V3_EXT_I2D			 = 136;
  {$EXTERNALSYM X509V3_F_X509V3_EXT_NCONF}
  X509V3_F_X509V3_EXT_NCONF		 = 152;
  {$EXTERNALSYM X509V3_F_X509V3_GET_SECTION}
  X509V3_F_X509V3_GET_SECTION			= 142;
  {$EXTERNALSYM X509V3_F_X509V3_GET_STRING}
  X509V3_F_X509V3_GET_STRING			= 143;
  {$EXTERNALSYM X509V3_F_X509V3_GET_VALUE_BOOL}
  X509V3_F_X509V3_GET_VALUE_BOOL			= 110;
  {$EXTERNALSYM X509V3_F_X509V3_PARSE_LIST}
  X509V3_F_X509V3_PARSE_LIST			= 109;
  {$EXTERNALSYM X509V3_F_X509_PURPOSE_ADD}
  X509V3_F_X509_PURPOSE_ADD			= 137;
  {$EXTERNALSYM X509V3_F_X509_PURPOSE_SET}
  X509V3_F_X509_PURPOSE_SET			= 141;

	//* Reason codes. */
  {$EXTERNALSYM X509V3_R_BAD_IP_ADDRESS}
  X509V3_R_BAD_IP_ADDRESS			 =  118;
  {$EXTERNALSYM X509V3_R_BAD_OBJECT}
  X509V3_R_BAD_OBJECT				 = 119;
  {$EXTERNALSYM X509V3_R_BN_DEC2BN_ERROR}
  X509V3_R_BN_DEC2BN_ERROR			= 100;
  {$EXTERNALSYM X509V3_R_BN_TO_ASN1_INTEGER_ERROR}
  X509V3_R_BN_TO_ASN1_INTEGER_ERROR	= 101;
  {$EXTERNALSYM X509V3_R_DIRNAME_ERROR}
  X509V3_R_DIRNAME_ERROR				 = 149;
  {$EXTERNALSYM X509V3_R_DISTPOINT_ALREADY_SET}
  X509V3_R_DISTPOINT_ALREADY_SET			= 160;
  {$EXTERNALSYM X509V3_R_DUPLICATE_ZONE_ID}
  X509V3_R_DUPLICATE_ZONE_ID			 = 133;
  {$EXTERNALSYM X509V3_R_ERROR_CONVERTING_ZONE}
  X509V3_R_ERROR_CONVERTING_ZONE			= 131;
  {$EXTERNALSYM X509V3_R_ERROR_CREATING_EXTENSION}
  X509V3_R_ERROR_CREATING_EXTENSION		= 144;
  {$EXTERNALSYM X509V3_R_ERROR_IN_EXTENSION}
  X509V3_R_ERROR_IN_EXTENSION			= 128;
  {$EXTERNALSYM X509V3_R_EXPECTED_A_SECTION_NAME}
  X509V3_R_EXPECTED_A_SECTION_NAME		= 137;
  {$EXTERNALSYM X509V3_R_EXTENSION_EXISTS}
  X509V3_R_EXTENSION_EXISTS			 = 145;
  {$EXTERNALSYM X509V3_R_EXTENSION_NAME_ERROR}
  X509V3_R_EXTENSION_NAME_ERROR		 = 115;
  {$EXTERNALSYM X509V3_R_EXTENSION_NOT_FOUND}
  X509V3_R_EXTENSION_NOT_FOUND		 =  102;
  {$EXTERNALSYM X509V3_R_EXTENSION_SETTING_NOT_SUPPORTED}
  X509V3_R_EXTENSION_SETTING_NOT_SUPPORTED	 = 103;
  {$EXTERNALSYM X509V3_R_EXTENSION_VALUE_ERROR}
  X509V3_R_EXTENSION_VALUE_ERROR		 = 116;
  {$EXTERNALSYM X509V3_R_ILLEGAL_EMPTY_EXTENSION}
  X509V3_R_ILLEGAL_EMPTY_EXTENSION		= 151;
  {$EXTERNALSYM X509V3_R_ILLEGAL_HEX_DIGIT}
  X509V3_R_ILLEGAL_HEX_DIGIT			 = 113;
  {$EXTERNALSYM X509V3_R_INCORRECT_POLICY_SYNTAX_TAG}
  X509V3_R_INCORRECT_POLICY_SYNTAX_TAG		= 152;
  {$EXTERNALSYM X509V3_R_INVALID_MULTIPLE_RDNS}
  X509V3_R_INVALID_MULTIPLE_RDNS			= 161;
  {$EXTERNALSYM X509V3_R_INVALID_ASNUMBER}
  X509V3_R_INVALID_ASNUMBER			= 162;
  {$EXTERNALSYM X509V3_R_INVALID_ASRANGE}
  X509V3_R_INVALID_ASRANGE			= 163;
  {$EXTERNALSYM X509V3_R_INVALID_BOOLEAN_STRING}
  X509V3_R_INVALID_BOOLEAN_STRING		 = 104;
  {$EXTERNALSYM X509V3_R_INVALID_EXTENSION_STRING}
  X509V3_R_INVALID_EXTENSION_STRING	 = 105;
  {$EXTERNALSYM X509V3_R_INVALID_INHERITANCE}
  X509V3_R_INVALID_INHERITANCE			= 165;
  {$EXTERNALSYM X509V3_R_INVALID_IPADDRESS}
  X509V3_R_INVALID_IPADDRESS			 = 166;
  {$EXTERNALSYM X509V3_R_INVALID_NAME}
  X509V3_R_INVALID_NAME				= 106;
  {$EXTERNALSYM X509V3_R_INVALID_NULL_ARGUMENT}
  X509V3_R_INVALID_NULL_ARGUMENT			= 107;
  {$EXTERNALSYM X509V3_R_INVALID_NULL_NAME}
  X509V3_R_INVALID_NULL_NAME		 = 108;
  {$EXTERNALSYM X509V3_R_INVALID_NULL_VALUE}
  X509V3_R_INVALID_NULL_VALUE			= 109;
  {$EXTERNALSYM X509V3_R_INVALID_NUMBER}
  X509V3_R_INVALID_NUMBER				= 140;
  {$EXTERNALSYM X509V3_R_INVALID_NUMBERS}
  X509V3_R_INVALID_NUMBERS			= 141;
  {$EXTERNALSYM X509V3_R_INVALID_OBJECT_IDENTIFIER}
  X509V3_R_INVALID_OBJECT_IDENTIFIER		= 110;
  {$EXTERNALSYM X509V3_R_INVALID_OPTION}
  X509V3_R_INVALID_OPTION				= 138;
  {$EXTERNALSYM X509V3_R_INVALID_POLICY_IDENTIFIER}
  X509V3_R_INVALID_POLICY_IDENTIFIER		= 134;
  {$EXTERNALSYM X509V3_R_INVALID_PROXY_POLICY_SETTING}
  X509V3_R_INVALID_PROXY_POLICY_SETTING	 = 153;
  {$EXTERNALSYM X509V3_R_INVALID_PURPOSE}
  X509V3_R_INVALID_PURPOSE		 = 146;
  {$EXTERNALSYM X509V3_R_INVALID_SAFI}
  X509V3_R_INVALID_SAFI				= 164;
  {$EXTERNALSYM X509V3_R_INVALID_SECTION}
  X509V3_R_INVALID_SECTION			= 135;
  {$EXTERNALSYM X509V3_R_INVALID_SYNTAX}
  X509V3_R_INVALID_SYNTAX				 = 143;
  {$EXTERNALSYM X509V3_R_ISSUER_DECODE_ERROR}
  X509V3_R_ISSUER_DECODE_ERROR		 = 126;
  {$EXTERNALSYM X509V3_R_MISSING_VALUE}
  X509V3_R_MISSING_VALUE				 = 124;
  {$EXTERNALSYM X509V3_R_NEED_ORGANIZATION_AND_NUMBERS}
  X509V3_R_NEED_ORGANIZATION_AND_NUMBERS		= 142;
  {$EXTERNALSYM X509V3_R_NO_CONFIG_DATABASE}
  X509V3_R_NO_CONFIG_DATABASE			= 136;
  {$EXTERNALSYM X509V3_R_NO_ISSUER_CERTIFICATE}
  X509V3_R_NO_ISSUER_CERTIFICATE			= 121;
  {$EXTERNALSYM X509V3_R_NO_ISSUER_DETAILS}
  X509V3_R_NO_ISSUER_DETAILS			= 127;
  {$EXTERNALSYM X509V3_R_NO_POLICY_IDENTIFIER}
  X509V3_R_NO_POLICY_IDENTIFIER			= 139;
  {$EXTERNALSYM X509V3_R_NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED}
  X509V3_R_NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED	= 154;
  {$EXTERNALSYM X509V3_R_NO_PUBLIC_KEY}
  X509V3_R_NO_PUBLIC_KEY				= 114;
  {$EXTERNALSYM X509V3_R_NO_SUBJECT_DETAILS}
  X509V3_R_NO_SUBJECT_DETAILS			= 125;
  {$EXTERNALSYM X509V3_R_ODD_NUMBER_OF_DIGITS}
  X509V3_R_ODD_NUMBER_OF_DIGITS		 = 112;
  {$EXTERNALSYM X509V3_R_OPERATION_NOT_DEFINED}
  X509V3_R_OPERATION_NOT_DEFINED			= 148;
  {$EXTERNALSYM X509V3_R_OTHERNAME_ERROR}
  X509V3_R_OTHERNAME_ERROR			 = 147;
  {$EXTERNALSYM X509V3_R_POLICY_LANGUAGE_ALREADY_DEFINED}
  X509V3_R_POLICY_LANGUAGE_ALREADY_DEFINED	= 155;
  {$EXTERNALSYM X509V3_R_POLICY_PATH_LENGTH}
  X509V3_R_POLICY_PATH_LENGTH			= 156;
  {$EXTERNALSYM X509V3_R_POLICY_PATH_LENGTH_ALREADY_DEFINED}
  X509V3_R_POLICY_PATH_LENGTH_ALREADY_DEFINED	 = 157;
  {$EXTERNALSYM X509V3_R_POLICY_SYNTAX_NOT_CURRENTLY_SUPPORTED}
  X509V3_R_POLICY_SYNTAX_NOT_CURRENTLY_SUPPORTED	= 158;
  {$EXTERNALSYM X509V3_R_POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY}
  X509V3_R_POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY = 159;
  {$EXTERNALSYM X509V3_R_SECTION_NOT_FOUND}
  X509V3_R_SECTION_NOT_FOUND			 = 150;
  {$EXTERNALSYM X509V3_R_UNABLE_TO_GET_ISSUER_DETAILS}
  X509V3_R_UNABLE_TO_GET_ISSUER_DETAILS	= 122;
  {$EXTERNALSYM X509V3_R_UNABLE_TO_GET_ISSUER_KEYID}
  X509V3_R_UNABLE_TO_GET_ISSUER_KEYID	= 123;
  {$EXTERNALSYM X509V3_R_UNKNOWN_BIT_STRING_ARGUMENT}
  X509V3_R_UNKNOWN_BIT_STRING_ARGUMENT = 111;
  {$EXTERNALSYM X509V3_R_UNKNOWN_EXTENSION}
  X509V3_R_UNKNOWN_EXTENSION = 129;
  {$EXTERNALSYM X509V3_R_UNKNOWN_EXTENSION_NAME}
  X509V3_R_UNKNOWN_EXTENSION_NAME	= 130;
  {$EXTERNALSYM X509V3_R_UNKNOWN_OPTION}
  X509V3_R_UNKNOWN_OPTION = 120;
  {$EXTERNALSYM X509V3_R_UNSUPPORTED_OPTION}
  X509V3_R_UNSUPPORTED_OPTION	= 117;
  {$EXTERNALSYM X509V3_R_UNSUPPORTED_TYPE}
  X509V3_R_UNSUPPORTED_TYPE	= 167;
  {$EXTERNALSYM X509V3_R_USER_TOO_LONG}
  X509V3_R_USER_TOO_LONG = 132;
//* Possible values for status. See ts_resp_print.c && ts_resp_verify.c. */
  {$EXTERNALSYM TS_STATUS_GRANTED}
  TS_STATUS_GRANTED		=	0;
  {$EXTERNALSYM TS_STATUS_GRANTED_WITH_MODS}
  TS_STATUS_GRANTED_WITH_MODS	 = 1;
  {$EXTERNALSYM TS_STATUS_REJECTION}
  TS_STATUS_REJECTION		 =	2;
  {$EXTERNALSYM TS_STATUS_WAITING}
  TS_STATUS_WAITING		 =	3;
  {$EXTERNALSYM TS_STATUS_REVOCATION_WARNING}
  TS_STATUS_REVOCATION_WARNING	 =	4;
  {$EXTERNALSYM TS_STATUS_REVOCATION_NOTIFICATION}
  TS_STATUS_REVOCATION_NOTIFICATION	= 5;

//* Possible values for failure_info. See ts_resp_print.c && ts_resp_verify.c */
  {$EXTERNALSYM TS_INFO_BAD_ALG}
  TS_INFO_BAD_ALG		=	0;
  {$EXTERNALSYM TS_INFO_BAD_REQUEST}
  TS_INFO_BAD_REQUEST	 =	2;
  {$EXTERNALSYM TS_INFO_BAD_DATA_FORMAT}
  TS_INFO_BAD_DATA_FORMAT	 =	5;
  {$EXTERNALSYM TS_INFO_TIME_NOT_AVAILABLE}
  TS_INFO_TIME_NOT_AVAILABLE = 14;
  {$EXTERNALSYM TS_INFO_UNACCEPTED_POLICY}
  TS_INFO_UNACCEPTED_POLICY	= 15;
  {$EXTERNALSYM TS_INFO_UNACCEPTED_EXTENSION}
  TS_INFO_UNACCEPTED_EXTENSION = 16;
  {$EXTERNALSYM TS_INFO_ADD_INFO_NOT_AVAILABLE}
  TS_INFO_ADD_INFO_NOT_AVAILABLE = 17;
  {$EXTERNALSYM TS_INFO_SYSTEM_FAILURE}
  TS_INFO_SYSTEM_FAILURE	 = 25;
//* Declarations related to response generation, defined in ts/ts_resp_sign.c. */
//* Optional flags for response generation. */
//* Don't include the TSA name in response. */
  {$EXTERNALSYM TS_TSA_NAME}
  TS_TSA_NAME		= $01;
//* Set ordering to true in response. */
  {$EXTERNALSYM TS_ORDERING}
  TS_ORDERING		= $02;
///*
// * Include the signer certificate and the other specified certificates in
// * the ESS signing certificate attribute beside the PKCS7 signed data.
// * Only the signer certificates is included by default.
// */
  {$EXTERNALSYM TS_ESS_CERT_ID_CHAIN}
  TS_ESS_CERT_ID_CHAIN	= $04;
//* At most we accept usec precision. */
  {$EXTERNALSYM TS_MAX_CLOCK_PRECISION_DIGITS}
 TS_MAX_CLOCK_PRECISION_DIGITS = 6;
//* Context structure for the generic verify method. */

//* Verify the signer's certificate and the signature of the response. */
  {$EXTERNALSYM TS_VFY_SIGNATURE}
  TS_VFY_SIGNATURE  = TIdC_ULONG(1 shl 0);
//* Verify the version number of the response. */
  {$EXTERNALSYM TS_VFY_VERSION}
  TS_VFY_VERSION	  =	TIdC_ULONG(1 shl 1);
  ///* Verify if the policy supplied by the user matches the policy of the TSA. */
  {$EXTERNALSYM TS_VFY_POLICY}
  TS_VFY_POLICY		= TIdC_ULONG(1 shl 2);

///* Verify the message imprint provided by the user. This flag should not be
//   specified with TS_VFY_DATA. */
  {$EXTERNALSYM TS_VFY_IMPRINT}
  TS_VFY_IMPRINT	 = TIdC_ULONG(1 shl 3);
///* Verify the message imprint computed by the verify method from the user
//   provided data and the MD algorithm of the response. This flag should not be
//   specified with TS_VFY_IMPRINT. */
  {$EXTERNALSYM TS_VFY_DATA}
  TS_VFY_DATA		= TIdC_ULONG(1 shl 4);
//* Verify the nonce value. */
  {$EXTERNALSYM TS_VFY_NONCE}
  TS_VFY_NONCE	 = TIdC_ULONG(1 shl 5);
//* Verify if the TSA name field matches the signer certificate. */
  {$EXTERNALSYM TS_VFY_SIGNER}
  TS_VFY_SIGNER	 = TIdC_ULONG(1 shl 6);
//* Verify if the TSA name field equals to the user provided name. */
  {$EXTERNALSYM TS_VFY_TSA_NAME}
  TS_VFY_TSA_NAME	 = TIdC_ULONG(1 shl 7);

//* You can use the following convenience constants. */
  {$EXTERNALSYM TS_VFY_ALL_IMPRINT}
  TS_VFY_ALL_IMPRINT	= (TS_VFY_SIGNATURE
			 or TS_VFY_VERSION
			 or TS_VFY_POLICY
			 or TS_VFY_IMPRINT
			 or TS_VFY_NONCE
			 or TS_VFY_SIGNER
			 or TS_VFY_TSA_NAME);
  {$EXTERNALSYM TS_VFY_ALL_DATA}
  TS_VFY_ALL_DATA       = (TS_VFY_SIGNATURE
                         or TS_VFY_VERSION
                         or TS_VFY_POLICY
                         or TS_VFY_DATA
			 or TS_VFY_NONCE
			 or TS_VFY_SIGNER
			 or TS_VFY_TSA_NAME);

//* Error codes for the TS functions. */


//* Function codes. */
  {$EXTERNALSYM TS_F_D2I_TS_RESP}
  TS_F_D2I_TS_RESP				= 147;
  {$EXTERNALSYM TS_F_DEF_SERIAL_CB}
  TS_F_DEF_SERIAL_CB				= 110;
  {$EXTERNALSYM TS_F_DEF_TIME_CB}
  TS_F_DEF_TIME_CB				= 111;
  {$EXTERNALSYM TS_F_ESS_ADD_SIGNING_CERT}
  TS_F_ESS_ADD_SIGNING_CERT			= 112;
  {$EXTERNALSYM TS_F_ESS_CERT_ID_NEW_INIT}
  TS_F_ESS_CERT_ID_NEW_INIT			= 113;
  {$EXTERNALSYM TS_F_ESS_SIGNING_CERT_NEW_INIT}
  TS_F_ESS_SIGNING_CERT_NEW_INIT                = 114;
  {$EXTERNALSYM TS_F_INT_TS_RESP_VERIFY_TOKEN}
  TS_F_INT_TS_RESP_VERIFY_TOKEN	                = 149;
  {$EXTERNALSYM TS_F_PKCS7_TO_TS_TST_INFO}
  TS_F_PKCS7_TO_TS_TST_INFO                     = 148;
  {$EXTERNALSYM TS_F_TS_ACCURACY_SET_MICROS}
  TS_F_TS_ACCURACY_SET_MICROS                   = 115;
  {$EXTERNALSYM TS_F_TS_ACCURACY_SET_MILLIS}
  TS_F_TS_ACCURACY_SET_MILLIS                   = 116;
  {$EXTERNALSYM TS_F_TS_ACCURACY_SET_SECONDS}
  TS_F_TS_ACCURACY_SET_SECONDS                  = 117;
  {$EXTERNALSYM TS_F_TS_CHECK_IMPRINTS}
  TS_F_TS_CHECK_IMPRINTS                        = 100;
  {$EXTERNALSYM TS_F_TS_CHECK_NONCES}
  TS_F_TS_CHECK_NONCES                          = 101;
  {$EXTERNALSYM TS_F_TS_CHECK_POLICY}
  TS_F_TS_CHECK_POLICY                          = 102;
  {$EXTERNALSYM TS_F_TS_CHECK_SIGNING_CERTS}
  TS_F_TS_CHECK_SIGNING_CERTS                   = 103;
  {$EXTERNALSYM TS_F_TS_CHECK_STATUS_INFO}
  TS_F_TS_CHECK_STATUS_INFO                     = 104;
  {$EXTERNALSYM TS_F_TS_COMPUTE_IMPRINT}
  TS_F_TS_COMPUTE_IMPRINT			= 145;
  {$EXTERNALSYM TS_F_TS_CONF_SET_DEFAULT_ENGINE}
  TS_F_TS_CONF_SET_DEFAULT_ENGINE               = 146;
  {$EXTERNALSYM TS_F_TS_GET_STATUS_TEXT}
  TS_F_TS_GET_STATUS_TEXT                       = 105;
  {$EXTERNALSYM TS_F_TS_MSG_IMPRINT_SET_ALGO}
  TS_F_TS_MSG_IMPRINT_SET_ALGO			= 118;
  {$EXTERNALSYM TS_F_TS_REQ_SET_MSG_IMPRINT}
  TS_F_TS_REQ_SET_MSG_IMPRINT			= 119;
  {$EXTERNALSYM TS_F_TS_REQ_SET_NONCE}
  TS_F_TS_REQ_SET_NONCE				= 120;
  {$EXTERNALSYM TS_F_TS_REQ_SET_POLICY_ID}
  TS_F_TS_REQ_SET_POLICY_ID			= 121;
  {$EXTERNALSYM TS_F_TS_RESP_CREATE_RESPONSE}
  TS_F_TS_RESP_CREATE_RESPONSE			= 122;
  {$EXTERNALSYM TS_F_TS_RESP_CREATE_TST_INFO}
  TS_F_TS_RESP_CREATE_TST_INFO			= 123;
  {$EXTERNALSYM TS_F_TS_RESP_CTX_ADD_FAILURE_INFO}
  TS_F_TS_RESP_CTX_ADD_FAILURE_INFO		= 124;
  {$EXTERNALSYM TS_F_TS_RESP_CTX_ADD_MD}
  TS_F_TS_RESP_CTX_ADD_MD                       = 125;
  {$EXTERNALSYM TS_F_TS_RESP_CTX_ADD_POLICY}
  TS_F_TS_RESP_CTX_ADD_POLICY                   = 126;
  {$EXTERNALSYM TS_F_TS_RESP_CTX_NEW}
  TS_F_TS_RESP_CTX_NEW                          = 127;
  {$EXTERNALSYM TS_F_TS_RESP_CTX_SET_ACCURACY}
  TS_F_TS_RESP_CTX_SET_ACCURACY			= 128;
  {$EXTERNALSYM TS_F_TS_RESP_CTX_SET_CERTS}
  TS_F_TS_RESP_CTX_SET_CERTS			= 129;
  {$EXTERNALSYM TS_F_TS_RESP_CTX_SET_DEF_POLICY}
  TS_F_TS_RESP_CTX_SET_DEF_POLICY		= 130;
  {$EXTERNALSYM TS_F_TS_RESP_CTX_SET_SIGNER_CERT}
  TS_F_TS_RESP_CTX_SET_SIGNER_CERT		= 131;
  {$EXTERNALSYM TS_F_TS_RESP_CTX_SET_STATUS_INFO}
  TS_F_TS_RESP_CTX_SET_STATUS_INFO		= 132;
  {$EXTERNALSYM TS_F_TS_RESP_GET_POLICY}
  TS_F_TS_RESP_GET_POLICY			= 133;
  {$EXTERNALSYM TS_F_TS_RESP_SET_GENTIME_WITH_PRECISION}
  TS_F_TS_RESP_SET_GENTIME_WITH_PRECISION	= 134;
  {$EXTERNALSYM TS_F_TS_RESP_SET_STATUS_INFO}
  TS_F_TS_RESP_SET_STATUS_INFO			= 135;
  {$EXTERNALSYM TS_F_TS_RESP_SET_TST_INFO}
  TS_F_TS_RESP_SET_TST_INFO			= 150;
  {$EXTERNALSYM TS_F_TS_RESP_SIGN}
  TS_F_TS_RESP_SIGN				= 136;
  {$EXTERNALSYM TS_F_TS_RESP_VERIFY_SIGNATURE}
  TS_F_TS_RESP_VERIFY_SIGNATURE			= 106;
  {$EXTERNALSYM TS_F_TS_RESP_VERIFY_TOKEN}
  TS_F_TS_RESP_VERIFY_TOKEN			= 107;
  {$EXTERNALSYM TS_F_TS_TST_INFO_SET_ACCURACY}
  TS_F_TS_TST_INFO_SET_ACCURACY			= 137;
  {$EXTERNALSYM TS_F_TS_TST_INFO_SET_MSG_IMPRINT}
  TS_F_TS_TST_INFO_SET_MSG_IMPRINT		= 138;
  {$EXTERNALSYM TS_F_TS_TST_INFO_SET_NONCE}
  TS_F_TS_TST_INFO_SET_NONCE			= 139;
  {$EXTERNALSYM TS_F_TS_TST_INFO_SET_POLICY_ID}
  TS_F_TS_TST_INFO_SET_POLICY_ID		= 140;
  {$EXTERNALSYM TS_F_TS_TST_INFO_SET_SERIAL}
  TS_F_TS_TST_INFO_SET_SERIAL			= 141;
  {$EXTERNALSYM TS_F_TS_TST_INFO_SET_TIME}
  TS_F_TS_TST_INFO_SET_TIME			= 142;
  {$EXTERNALSYM TS_F_TS_TST_INFO_SET_TSA}
  TS_F_TS_TST_INFO_SET_TSA			= 143;
  {$EXTERNALSYM TS_F_TS_VERIFY}
  TS_F_TS_VERIFY				= 108;
  {$EXTERNALSYM TS_F_TS_VERIFY_CERT}
  TS_F_TS_VERIFY_CERT				= 109;
  {$EXTERNALSYM TS_F_TS_VERIFY_CTX_NEW}
  TS_F_TS_VERIFY_CTX_NEW			= 144;

//* Reason codes. */
  {$EXTERNALSYM TS_R_BAD_PKCS7_TYPE}
  TS_R_BAD_PKCS7_TYPE				= 132;
  {$EXTERNALSYM TS_R_BAD_TYPE}
  TS_R_BAD_TYPE					= 133;
  {$EXTERNALSYM TS_R_CERTIFICATE_VERIFY_ERROR}
  TS_R_CERTIFICATE_VERIFY_ERROR			= 100;
  {$EXTERNALSYM TS_R_COULD_NOT_SET_ENGINE}
  TS_R_COULD_NOT_SET_ENGINE			= 127;
  {$EXTERNALSYM TS_R_COULD_NOT_SET_TIME}
  TS_R_COULD_NOT_SET_TIME				= 115;
  {$EXTERNALSYM TS_R_D2I_TS_RESP_INT_FAILED}
  TS_R_D2I_TS_RESP_INT_FAILED			= 128;
  {$EXTERNALSYM TS_R_DETACHED_CONTENT}
  TS_R_DETACHED_CONTENT				= 134;
  {$EXTERNALSYM TS_R_ESS_ADD_SIGNING_CERT_ERROR}
  TS_R_ESS_ADD_SIGNING_CERT_ERROR			= 116;
  {$EXTERNALSYM TS_R_ESS_SIGNING_CERTIFICATE_ERROR}
  TS_R_ESS_SIGNING_CERTIFICATE_ERROR		= 101;
  {$EXTERNALSYM TS_R_INVALID_NULL_POINTER}
  TS_R_INVALID_NULL_POINTER			= 102;
  {$EXTERNALSYM TS_R_INVALID_SIGNER_CERTIFICATE_PURPOSE}
  TS_R_INVALID_SIGNER_CERTIFICATE_PURPOSE		= 117;
  {$EXTERNALSYM TS_R_MESSAGE_IMPRINT_MISMATCH}
  TS_R_MESSAGE_IMPRINT_MISMATCH			= 103;
  {$EXTERNALSYM TS_R_NONCE_MISMATCH}
  TS_R_NONCE_MISMATCH				= 104;
  {$EXTERNALSYM TS_R_NONCE_NOT_RETURNED}
  TS_R_NONCE_NOT_RETURNED				= 105;
  {$EXTERNALSYM TS_R_NO_CONTENT}
  TS_R_NO_CONTENT					= 106;
  {$EXTERNALSYM TS_R_NO_TIME_STAMP_TOKEN}
  TS_R_NO_TIME_STAMP_TOKEN			= 107;
  {$EXTERNALSYM TS_R_PKCS7_ADD_SIGNATURE_ERROR}
  TS_R_PKCS7_ADD_SIGNATURE_ERROR			= 118;
  {$EXTERNALSYM TS_R_PKCS7_ADD_SIGNED_ATTR_ERROR}
  TS_R_PKCS7_ADD_SIGNED_ATTR_ERROR		= 119;
  {$EXTERNALSYM TS_R_PKCS7_TO_TS_TST_INFO_FAILED}
  TS_R_PKCS7_TO_TS_TST_INFO_FAILED		= 129;
  {$EXTERNALSYM TS_R_POLICY_MISMATCH}
  TS_R_POLICY_MISMATCH				= 108;
  {$EXTERNALSYM TS_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE}
  TS_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE	= 120;
  {$EXTERNALSYM TS_R_RESPONSE_SETUP_ERROR}
  TS_R_RESPONSE_SETUP_ERROR			= 121;
  {$EXTERNALSYM TS_R_SIGNATURE_FAILURE}
  TS_R_SIGNATURE_FAILURE				= 109;
  {$EXTERNALSYM TS_R_THERE_MUST_BE_ONE_SIGNER}
  TS_R_THERE_MUST_BE_ONE_SIGNER			= 110;
  {$EXTERNALSYM TS_R_TIME_SYSCALL_ERROR}
  TS_R_TIME_SYSCALL_ERROR				= 122;
  {$EXTERNALSYM TS_R_TOKEN_NOT_PRESENT}
  TS_R_TOKEN_NOT_PRESENT				= 130;
  {$EXTERNALSYM TS_R_TOKEN_PRESENT}
  TS_R_TOKEN_PRESENT				= 131;
  {$EXTERNALSYM TS_R_TSA_NAME_MISMATCH}
  TS_R_TSA_NAME_MISMATCH				= 111;
  {$EXTERNALSYM TS_R_TSA_UNTRUSTED}
  TS_R_TSA_UNTRUSTED				= 112;
  {$EXTERNALSYM TS_R_TST_INFO_SETUP_ERROR}
  TS_R_TST_INFO_SETUP_ERROR			= 123;
  {$EXTERNALSYM TS_R_TS_DATASIGN}
  TS_R_TS_DATASIGN				= 124;
  {$EXTERNALSYM TS_R_UNACCEPTABLE_POLICY}
  TS_R_UNACCEPTABLE_POLICY			= 125;
  {$EXTERNALSYM TS_R_UNSUPPORTED_MD_ALGORITHM}
  TS_R_UNSUPPORTED_MD_ALGORITHM			= 126;
  {$EXTERNALSYM TS_R_UNSUPPORTED_VERSION}
  TS_R_UNSUPPORTED_VERSION			= 113;
  {$EXTERNALSYM TS_R_WRONG_CONTENT_TYPE}
  TS_R_WRONG_CONTENT_TYPE				= 114;

  {$UNDEF OPENSSL_NO_CMS}
  {$IFNDEF OPENSSL_NO_CMS}
  {$EXTERNALSYM CMS_SIGNERINFO_ISSUER_SERIAL}
  CMS_SIGNERINFO_ISSUER_SERIAL	= 0;
  {$EXTERNALSYM CMS_SIGNERINFO_KEYIDENTIFIER}
  CMS_SIGNERINFO_KEYIDENTIFIER = 1;
  {$EXTERNALSYM CMS_RECIPINFO_TRANS}
  CMS_RECIPINFO_TRANS	 = 0;
  {$EXTERNALSYM CMS_RECIPINFO_AGREE}
  CMS_RECIPINFO_AGREE	 = 1;
  {$EXTERNALSYM CMS_RECIPINFO_KEK}
  CMS_RECIPINFO_KEK	 = 2;
  {$EXTERNALSYM CMS_RECIPINFO_PASS}
  CMS_RECIPINFO_PASS	 = 3;
  {$EXTERNALSYM CMS_RECIPINFO_OTHER}
  CMS_RECIPINFO_OTHER	 = 4;

//* S/MIME related flags */
  {$EXTERNALSYM CMS_TEXT}
  CMS_TEXT			= $1;
  {$EXTERNALSYM CMS_NOCERTS}
  CMS_NOCERTS			= $2;
  {$EXTERNALSYM CMS_NO_CONTENT_VERIFY}
  CMS_NO_CONTENT_VERIFY	 = $4;
  {$EXTERNALSYM CMS_NO_ATTR_VERIFY}
  CMS_NO_ATTR_VERIFY	 = $8;
  {$EXTERNALSYM CMS_NOSIGS}
  CMS_NOSIGS			= (CMS_NO_CONTENT_VERIFY or CMS_NO_ATTR_VERIFY);
  {$EXTERNALSYM CMS_NOINTERN}
  CMS_NOINTERN		 = $10;
  {$EXTERNALSYM CMS_NO_SIGNER_CERT_VERIFY}
  CMS_NO_SIGNER_CERT_VERIFY	= $20;
  {$EXTERNALSYM CMS_NOVERIFY}
  CMS_NOVERIFY			= $20;
  {$EXTERNALSYM CMS_DETACHED}
  CMS_DETACHED			= $40;
  {$EXTERNALSYM CMS_BINARY}
  CMS_BINARY			= $80;
  {$EXTERNALSYM CMS_NOATTR}
  CMS_NOATTR			= $100;
  {$EXTERNALSYM CMS_NOSMIMECAP}
  CMS_NOSMIMECAP		= $200;
  {$EXTERNALSYM CMS_NOOLDMIMETYPE}
  CMS_NOOLDMIMETYPE		= $400;
  {$EXTERNALSYM CMS_CRLFEOL}
  CMS_CRLFEOL			= $800;
  {$EXTERNALSYM CMS_STREAM}
  CMS_STREAM			= $1000;
  {$EXTERNALSYM CMS_NOCRL}
  CMS_NOCRL			= $2000;
  {$EXTERNALSYM CMS_PARTIAL}
  CMS_PARTIAL		 = $4000;
  {$EXTERNALSYM CMS_REUSE_DIGEST}
  CMS_REUSE_DIGEST		= $8000;
  {$EXTERNALSYM CMS_USE_KEYID}
  CMS_USE_KEYID		 = $10000;

//* Error codes for the CMS functions. */

//* Function codes. */
  {$EXTERNALSYM CMS_F_CHECK_CONTENT}
  CMS_F_CHECK_CONTENT				= 99;
  {$EXTERNALSYM CMS_F_CMS_ADD0_CERT}
  CMS_F_CMS_ADD0_CERT				= 164;
  {$EXTERNALSYM CMS_F_CMS_ADD0_RECIPIENT_KEY}
  CMS_F_CMS_ADD0_RECIPIENT_KEY			= 100;
  {$EXTERNALSYM CMS_F_CMS_ADD1_RECEIPTREQUEST}
  CMS_F_CMS_ADD1_RECEIPTREQUEST			= 158;
  {$EXTERNALSYM CMS_F_CMS_ADD1_RECIPIENT_CERT}
  CMS_F_CMS_ADD1_RECIPIENT_CERT			= 101;
  {$EXTERNALSYM CMS_F_CMS_ADD1_SIGNER}
  CMS_F_CMS_ADD1_SIGNER				= 102;
  {$EXTERNALSYM CMS_F_CMS_ADD1_SIGNINGTIME}
  CMS_F_CMS_ADD1_SIGNINGTIME			= 103;
  {$EXTERNALSYM CMS_F_CMS_COMPRESS}
  CMS_F_CMS_COMPRESS				= 104;
  {$EXTERNALSYM CMS_F_CMS_COMPRESSEDDATA_CREATE}
  CMS_F_CMS_COMPRESSEDDATA_CREATE			= 105;
  {$EXTERNALSYM CMS_F_CMS_COMPRESSEDDATA_INIT_BIO}
  CMS_F_CMS_COMPRESSEDDATA_INIT_BIO		= 106;
  {$EXTERNALSYM CMS_F_CMS_COPY_CONTENT}
  CMS_F_CMS_COPY_CONTENT				= 107;
  {$EXTERNALSYM CMS_F_CMS_COPY_MESSAGEDIGEST}
  CMS_F_CMS_COPY_MESSAGEDIGEST			= 108;
  {$EXTERNALSYM CMS_F_CMS_DATA}
  CMS_F_CMS_DATA					= 109;
  {$EXTERNALSYM CMS_F_CMS_DATAFINAL}
  CMS_F_CMS_DATAFINAL				= 110;
  {$EXTERNALSYM CMS_F_CMS_DATAINIT}
  CMS_F_CMS_DATAINIT				= 111;
  {$EXTERNALSYM CMS_F_CMS_DECRYPT}
  CMS_F_CMS_DECRYPT				= 112;
  {$EXTERNALSYM CMS_F_CMS_DECRYPT_SET1_KEY}
  CMS_F_CMS_DECRYPT_SET1_KEY			= 113;
  {$EXTERNALSYM CMS_F_CMS_DECRYPT_SET1_PKEY}
  CMS_F_CMS_DECRYPT_SET1_PKEY			= 114;
  {$EXTERNALSYM CMS_F_CMS_DIGESTALGORITHM_FIND_CTX}
  CMS_F_CMS_DIGESTALGORITHM_FIND_CTX		= 115;
  {$EXTERNALSYM CMS_F_CMS_DIGESTALGORITHM_INIT_BIO}
  CMS_F_CMS_DIGESTALGORITHM_INIT_BIO		= 116;
  {$EXTERNALSYM CMS_F_CMS_DIGESTEDDATA_DO_FINAL}
  CMS_F_CMS_DIGESTEDDATA_DO_FINAL			= 117;
  {$EXTERNALSYM CMS_F_CMS_DIGEST_VERIFY}
  CMS_F_CMS_DIGEST_VERIFY				= 118;
  {$EXTERNALSYM CMS_F_CMS_ENCODE_RECEIPT}
  CMS_F_CMS_ENCODE_RECEIPT			= 161;
  {$EXTERNALSYM CMS_F_CMS_ENCRYPT}
  CMS_F_CMS_ENCRYPT				= 119;
  {$EXTERNALSYM CMS_F_CMS_ENCRYPTEDCONTENT_INIT_BIO}
  CMS_F_CMS_ENCRYPTEDCONTENT_INIT_BIO		= 120;
  {$EXTERNALSYM CMS_F_CMS_ENCRYPTEDDATA_DECRYPT}
  CMS_F_CMS_ENCRYPTEDDATA_DECRYPT			= 121;
  {$EXTERNALSYM CMS_F_CMS_ENCRYPTEDDATA_ENCRYPT}
  CMS_F_CMS_ENCRYPTEDDATA_ENCRYPT			= 122;
  {$EXTERNALSYM CMS_F_CMS_ENCRYPTEDDATA_SET1_KEY}
  CMS_F_CMS_ENCRYPTEDDATA_SET1_KEY		= 123;
  {$EXTERNALSYM CMS_F_CMS_ENVELOPEDDATA_CREATE}
  CMS_F_CMS_ENVELOPEDDATA_CREATE			= 124;
  {$EXTERNALSYM CMS_F_CMS_ENVELOPEDDATA_INIT_BIO}
  CMS_F_CMS_ENVELOPEDDATA_INIT_BIO		= 125;
  {$EXTERNALSYM CMS_F_CMS_ENVELOPED_DATA_INIT}
  CMS_F_CMS_ENVELOPED_DATA_INIT			= 126;
  {$EXTERNALSYM CMS_F_CMS_FINAL}
  CMS_F_CMS_FINAL					= 127;
  {$EXTERNALSYM CMS_F_CMS_GET0_CERTIFICATE_CHOICES}
  CMS_F_CMS_GET0_CERTIFICATE_CHOICES		= 128;
  {$EXTERNALSYM CMS_F_CMS_GET0_CONTENT}
  CMS_F_CMS_GET0_CONTENT				= 129;
  {$EXTERNALSYM CMS_F_CMS_GET0_ECONTENT_TYPE}
  CMS_F_CMS_GET0_ECONTENT_TYPE			= 130;
  {$EXTERNALSYM CMS_F_CMS_GET0_ENVELOPED}
  CMS_F_CMS_GET0_ENVELOPED			= 131;
  {$EXTERNALSYM CMS_F_CMS_GET0_REVOCATION_CHOICES}
  CMS_F_CMS_GET0_REVOCATION_CHOICES		= 132;
  {$EXTERNALSYM CMS_F_CMS_GET0_SIGNED}
  CMS_F_CMS_GET0_SIGNED				= 133;
  {$EXTERNALSYM CMS_F_CMS_MSGSIGDIGEST_ADD1}
  CMS_F_CMS_MSGSIGDIGEST_ADD1			= 162;
  {$EXTERNALSYM CMS_F_CMS_RECEIPTREQUEST_CREATE0}
  CMS_F_CMS_RECEIPTREQUEST_CREATE0		= 159;
  {$EXTERNALSYM CMS_F_CMS_RECEIPT_VERIFY}
  CMS_F_CMS_RECEIPT_VERIFY			= 160;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_DECRYPT}
  CMS_F_CMS_RECIPIENTINFO_DECRYPT			= 134;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_KEKRI_DECRYPT}
  CMS_F_CMS_RECIPIENTINFO_KEKRI_DECRYPT		= 135;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_KEKRI_ENCRYPT}
  CMS_F_CMS_RECIPIENTINFO_KEKRI_ENCRYPT		= 136;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_KEKRI_GET0_ID}
  CMS_F_CMS_RECIPIENTINFO_KEKRI_GET0_ID		= 137;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_KEKRI_ID_CMP}
  CMS_F_CMS_RECIPIENTINFO_KEKRI_ID_CMP		= 138;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_KTRI_CERT_CMP}
  CMS_F_CMS_RECIPIENTINFO_KTRI_CERT_CMP		= 139;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_KTRI_DECRYPT}
  CMS_F_CMS_RECIPIENTINFO_KTRI_DECRYPT		= 140;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_KTRI_ENCRYPT}
  CMS_F_CMS_RECIPIENTINFO_KTRI_ENCRYPT		= 141;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_KTRI_GET0_ALGS}
  CMS_F_CMS_RECIPIENTINFO_KTRI_GET0_ALGS		= 142;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_KTRI_GET0_SIGNER_ID}
  CMS_F_CMS_RECIPIENTINFO_KTRI_GET0_SIGNER_ID	= 143;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_SET0_KEY}
  CMS_F_CMS_RECIPIENTINFO_SET0_KEY		= 144;
  {$EXTERNALSYM CMS_F_CMS_RECIPIENTINFO_SET0_PKEY}
  CMS_F_CMS_RECIPIENTINFO_SET0_PKEY		= 145;
  {$EXTERNALSYM CMS_F_CMS_SET1_SIGNERIDENTIFIER}
  CMS_F_CMS_SET1_SIGNERIDENTIFIER			= 146;
  {$EXTERNALSYM CMS_F_CMS_SET_DETACHED}
  CMS_F_CMS_SET_DETACHED				= 147;
  {$EXTERNALSYM CMS_F_CMS_SIGN}
  CMS_F_CMS_SIGN					= 148;
  {$EXTERNALSYM CMS_F_CMS_SIGNED_DATA_INIT}
  CMS_F_CMS_SIGNED_DATA_INIT			= 149;
  {$EXTERNALSYM CMS_F_CMS_SIGNERINFO_CONTENT_SIGN}
  CMS_F_CMS_SIGNERINFO_CONTENT_SIGN		= 150;
  {$EXTERNALSYM CMS_F_CMS_SIGNERINFO_SIGN}
  CMS_F_CMS_SIGNERINFO_SIGN			= 151;
  {$EXTERNALSYM CMS_F_CMS_SIGNERINFO_VERIFY}
  CMS_F_CMS_SIGNERINFO_VERIFY			= 152;
  {$EXTERNALSYM CMS_F_CMS_SIGNERINFO_VERIFY_CERT}
  CMS_F_CMS_SIGNERINFO_VERIFY_CERT		= 153;
  {$EXTERNALSYM CMS_F_CMS_SIGNERINFO_VERIFY_CONTENT}
  CMS_F_CMS_SIGNERINFO_VERIFY_CONTENT		= 154;
  {$EXTERNALSYM CMS_F_CMS_SIGN_RECEIPT}
  CMS_F_CMS_SIGN_RECEIPT			  = 163;
  {$EXTERNALSYM CMS_F_CMS_STREAM}
  CMS_F_CMS_STREAM				= 155;
  {$EXTERNALSYM CMS_F_CMS_UNCOMPRESS}
  CMS_F_CMS_UNCOMPRESS				= 156;
  {$EXTERNALSYM CMS_F_CMS_VERIFY}
  CMS_F_CMS_VERIFY				= 157;

//* Reason codes. */
  {$EXTERNALSYM CMS_R_ADD_SIGNER_ERROR}
  CMS_R_ADD_SIGNER_ERROR				= 99;
  {$EXTERNALSYM CMS_R_CERTIFICATE_ALREADY_PRESENT}
  CMS_R_CERTIFICATE_ALREADY_PRESENT		= 175;
  {$EXTERNALSYM CMS_R_CERTIFICATE_HAS_NO_KEYID}
  CMS_R_CERTIFICATE_HAS_NO_KEYID			= 160;
  {$EXTERNALSYM CMS_R_CERTIFICATE_VERIFY_ERROR}
  CMS_R_CERTIFICATE_VERIFY_ERROR			= 100;
  {$EXTERNALSYM CMS_R_CIPHER_INITIALISATION_ERROR}
  CMS_R_CIPHER_INITIALISATION_ERROR		= 101;
  {$EXTERNALSYM CMS_R_CIPHER_PARAMETER_INITIALISATION_ERROR}
  CMS_R_CIPHER_PARAMETER_INITIALISATION_ERROR	 = 102;
  {$EXTERNALSYM CMS_R_CMS_DATAFINAL_ERROR}
  CMS_R_CMS_DATAFINAL_ERROR			 = 103;
  {$EXTERNALSYM CMS_R_CMS_LIB}
  CMS_R_CMS_LIB					= 104;
  {$EXTERNALSYM CMS_R_CONTENTIDENTIFIER_MISMATCH}
  CMS_R_CONTENTIDENTIFIER_MISMATCH		= 170;
  {$EXTERNALSYM CMS_R_CONTENT_NOT_FOUND}
  CMS_R_CONTENT_NOT_FOUND				 = 105;
  {$EXTERNALSYM CMS_R_CONTENT_TYPE_MISMATCH}
  CMS_R_CONTENT_TYPE_MISMATCH			 = 171;
  {$EXTERNALSYM CMS_R_CONTENT_TYPE_NOT_COMPRESSED_DATA}
  CMS_R_CONTENT_TYPE_NOT_COMPRESSED_DATA		= 106;
  {$EXTERNALSYM CMS_R_CONTENT_TYPE_NOT_ENVELOPED_DATA}
  CMS_R_CONTENT_TYPE_NOT_ENVELOPED_DATA		= 107;
  {$EXTERNALSYM CMS_R_CONTENT_TYPE_NOT_SIGNED_DATA}
  CMS_R_CONTENT_TYPE_NOT_SIGNED_DATA		= 108;
  {$EXTERNALSYM CMS_R_CONTENT_VERIFY_ERROR}
  CMS_R_CONTENT_VERIFY_ERROR			= 109;
  {$EXTERNALSYM CMS_R_CTRL_ERROR}
  CMS_R_CTRL_ERROR				= 110;
  {$EXTERNALSYM CMS_R_CTRL_FAILURE}
  CMS_R_CTRL_FAILURE				= 111;
  {$EXTERNALSYM CMS_R_DECRYPT_ERROR}
  CMS_R_DECRYPT_ERROR				= 112;
  {$EXTERNALSYM CMS_R_DIGEST_ERROR}
  CMS_R_DIGEST_ERROR				= 161;
  {$EXTERNALSYM CMS_R_ERROR_GETTING_PUBLIC_KEY}
  CMS_R_ERROR_GETTING_PUBLIC_KEY			= 113;
  {$EXTERNALSYM CMS_R_ERROR_READING_MESSAGEDIGEST_ATTRIBUTE}
  CMS_R_ERROR_READING_MESSAGEDIGEST_ATTRIBUTE	= 114;
  {$EXTERNALSYM CMS_R_ERROR_SETTING_KEY}
  CMS_R_ERROR_SETTING_KEY				= 115;
  {$EXTERNALSYM CMS_R_ERROR_SETTING_RECIPIENTINFO}
  CMS_R_ERROR_SETTING_RECIPIENTINFO		= 116;
  {$EXTERNALSYM CMS_R_INVALID_ENCRYPTED_KEY_LENGTH}
  CMS_R_INVALID_ENCRYPTED_KEY_LENGTH		= 117;
  {$EXTERNALSYM CMS_R_INVALID_KEY_LENGTH}
  CMS_R_INVALID_KEY_LENGTH			= 118;
  {$EXTERNALSYM CMS_R_MD_BIO_INIT_ERROR}
  CMS_R_MD_BIO_INIT_ERROR				= 119;
  {$EXTERNALSYM CMS_R_MESSAGEDIGEST_ATTRIBUTE_WRONG_LENGTH}
  CMS_R_MESSAGEDIGEST_ATTRIBUTE_WRONG_LENGTH	= 120;
  {$EXTERNALSYM CMS_R_MESSAGEDIGEST_WRONG_LENGTH}
  CMS_R_MESSAGEDIGEST_WRONG_LENGTH		= 121;
  {$EXTERNALSYM CMS_R_MSGSIGDIGEST_ERROR}
  CMS_R_MSGSIGDIGEST_ERROR			= 172;
  {$EXTERNALSYM CMS_R_MSGSIGDIGEST_VERIFICATION_FAILURE}
  CMS_R_MSGSIGDIGEST_VERIFICATION_FAILURE		= 162;
  {$EXTERNALSYM CMS_R_MSGSIGDIGEST_WRONG_LENGTH}
  CMS_R_MSGSIGDIGEST_WRONG_LENGTH			= 163;
  {$EXTERNALSYM CMS_R_NEED_ONE_SIGNER}
  CMS_R_NEED_ONE_SIGNER				= 164;
  {$EXTERNALSYM CMS_R_NOT_A_SIGNED_RECEIPT}
  CMS_R_NOT_A_SIGNED_RECEIPT			= 165;
  {$EXTERNALSYM CMS_R_NOT_ENCRYPTED_DATA}
  CMS_R_NOT_ENCRYPTED_DATA			= 122;
  {$EXTERNALSYM CMS_R_NOT_KEK}
  CMS_R_NOT_KEK					= 123;
  {$EXTERNALSYM CMS_R_NOT_KEY_TRANSPORT}
  CMS_R_NOT_KEY_TRANSPORT				= 124;
  {$EXTERNALSYM CMS_R_NOT_SUPPORTED_FOR_THIS_KEY_TYPE}
  CMS_R_NOT_SUPPORTED_FOR_THIS_KEY_TYPE		= 125;
  {$EXTERNALSYM CMS_R_NO_CIPHER}
  CMS_R_NO_CIPHER					= 126;
  {$EXTERNALSYM CMS_R_NO_CONTENT}
  CMS_R_NO_CONTENT				= 127;
  {$EXTERNALSYM CMS_R_NO_CONTENT_TYPE}
  CMS_R_NO_CONTENT_TYPE				= 173;
  {$EXTERNALSYM CMS_R_NO_DEFAULT_DIGEST}
  CMS_R_NO_DEFAULT_DIGEST				= 128;
  {$EXTERNALSYM CMS_R_NO_DIGEST_SET}
  CMS_R_NO_DIGEST_SET				= 129;
  {$EXTERNALSYM CMS_R_NO_KEY}
  CMS_R_NO_KEY					= 130;
  {$EXTERNALSYM CMS_R_NO_KEY_OR_CERT}
  CMS_R_NO_KEY_OR_CERT				= 174;
  {$EXTERNALSYM CMS_R_NO_MATCHING_DIGEST}
  CMS_R_NO_MATCHING_DIGEST			= 131;
  {$EXTERNALSYM CMS_R_NO_MATCHING_RECIPIENT}
  CMS_R_NO_MATCHING_RECIPIENT			= 132;
  {$EXTERNALSYM CMS_R_NO_MATCHING_SIGNATURE}
  CMS_R_NO_MATCHING_SIGNATURE			= 166;
  {$EXTERNALSYM CMS_R_NO_MSGSIGDIGEST}
  CMS_R_NO_MSGSIGDIGEST				= 167;
  {$EXTERNALSYM CMS_R_NO_PRIVATE_KEY}
  CMS_R_NO_PRIVATE_KEY				= 133;
  {$EXTERNALSYM CMS_R_NO_PUBLIC_KEY}
  CMS_R_NO_PUBLIC_KEY				= 134;
  {$EXTERNALSYM CMS_R_NO_RECEIPT_REQUEST}
  CMS_R_NO_RECEIPT_REQUEST			= 168;
  {$EXTERNALSYM CMS_R_NO_SIGNERS}
  CMS_R_NO_SIGNERS				= 135;
  {$EXTERNALSYM CMS_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE}
  CMS_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE	= 136;
  {$EXTERNALSYM CMS_R_RECEIPT_DECODE_ERROR}
  CMS_R_RECEIPT_DECODE_ERROR			= 169;
  {$EXTERNALSYM CMS_R_RECIPIENT_ERROR}
  CMS_R_RECIPIENT_ERROR				= 137;
  {$EXTERNALSYM CMS_R_SIGNER_CERTIFICATE_NOT_FOUND}
  CMS_R_SIGNER_CERTIFICATE_NOT_FOUND		= 138;
  {$EXTERNALSYM CMS_R_SIGNFINAL_ERROR}
  CMS_R_SIGNFINAL_ERROR				= 139;
  {$EXTERNALSYM CMS_R_SMIME_TEXT_ERROR}
  CMS_R_SMIME_TEXT_ERROR				= 140;
  {$EXTERNALSYM CMS_R_STORE_INIT_ERROR}
  CMS_R_STORE_INIT_ERROR				= 141;
  {$EXTERNALSYM CMS_R_TYPE_NOT_COMPRESSED_DATA}
  CMS_R_TYPE_NOT_COMPRESSED_DATA			= 142;
  {$EXTERNALSYM CMS_R_TYPE_NOT_DATA}
  CMS_R_TYPE_NOT_DATA				= 143;
  {$EXTERNALSYM CMS_R_TYPE_NOT_DIGESTED_DATA}
  CMS_R_TYPE_NOT_DIGESTED_DATA			= 144;
  {$EXTERNALSYM CMS_R_TYPE_NOT_ENCRYPTED_DATA}
  CMS_R_TYPE_NOT_ENCRYPTED_DATA			= 145;
  {$EXTERNALSYM CMS_R_TYPE_NOT_ENVELOPED_DATA}
  CMS_R_TYPE_NOT_ENVELOPED_DATA			= 146;
  {$EXTERNALSYM CMS_R_UNABLE_TO_FINALIZE_CONTEXT}
  CMS_R_UNABLE_TO_FINALIZE_CONTEXT		= 147;
  {$EXTERNALSYM CMS_R_UNKNOWN_CIPHER}
  CMS_R_UNKNOWN_CIPHER				= 148;
  {$EXTERNALSYM CMS_R_UNKNOWN_DIGEST_ALGORIHM}
  CMS_R_UNKNOWN_DIGEST_ALGORIHM			= 149;
  {$EXTERNALSYM CMS_R_UNKNOWN_ID}
  CMS_R_UNKNOWN_ID				= 150;
  {$EXTERNALSYM CMS_R_UNSUPPORTED_COMPRESSION_ALGORITHM}
  CMS_R_UNSUPPORTED_COMPRESSION_ALGORITHM		= 151;
  {$EXTERNALSYM CMS_R_UNSUPPORTED_CONTENT_TYPE}
  CMS_R_UNSUPPORTED_CONTENT_TYPE			= 152;
  {$EXTERNALSYM CMS_R_UNSUPPORTED_KEK_ALGORITHM}
  CMS_R_UNSUPPORTED_KEK_ALGORITHM			= 153;
  {$EXTERNALSYM CMS_R_UNSUPPORTED_RECIPIENT_TYPE}
  CMS_R_UNSUPPORTED_RECIPIENT_TYPE		= 154;
  {$EXTERNALSYM CMS_R_UNSUPPORTED_RECPIENTINFO_TYPE}
  CMS_R_UNSUPPORTED_RECPIENTINFO_TYPE		= 155;
  {$EXTERNALSYM CMS_R_UNSUPPORTED_TYPE}
  CMS_R_UNSUPPORTED_TYPE				= 156;
  {$EXTERNALSYM CMS_R_UNWRAP_ERROR}
  CMS_R_UNWRAP_ERROR				= 157;
  {$EXTERNALSYM CMS_R_VERIFICATION_FAILURE}
  CMS_R_VERIFICATION_FAILURE			= 158;
  {$EXTERNALSYM CMS_R_WRAP_ERROR}
  CMS_R_WRAP_ERROR				= 159;

  {$ENDIF}

  {$EXTERNALSYM DSO_F_BEOS_BIND_FUNC}
  DSO_F_BEOS_BIND_FUNC = 144;
  {$EXTERNALSYM DSO_F_BEOS_BIND_VAR}
  DSO_F_BEOS_BIND_VAR	= 145;
  {$EXTERNALSYM DSO_F_BEOS_LOAD}
  DSO_F_BEOS_LOAD	= 146;
  {$EXTERNALSYM DSO_F_BEOS_NAME_CONVERTER}
  DSO_F_BEOS_NAME_CONVERTER	= 147;
  {$EXTERNALSYM DSO_F_BEOS_UNLOAD}
  DSO_F_BEOS_UNLOAD	= 148;
  {$EXTERNALSYM DSO_F_DLFCN_BIND_FUNC}
  DSO_F_DLFCN_BIND_FUNC = 100;
  {$EXTERNALSYM DSO_F_DLFCN_BIND_VAR}
  DSO_F_DLFCN_BIND_VAR = 101;
  {$EXTERNALSYM DSO_F_DLFCN_LOAD}
  DSO_F_DLFCN_LOAD = 102;
  {$EXTERNALSYM DSO_F_DLFCN_MERGER}
  DSO_F_DLFCN_MERGER = 130;
  {$EXTERNALSYM DSO_F_DLFCN_NAME_CONVERTER}
  DSO_F_DLFCN_NAME_CONVERTER = 123;
  {$EXTERNALSYM DSO_F_DLFCN_UNLOAD}
  DSO_F_DLFCN_UNLOAD = 103;
  {$EXTERNALSYM DSO_F_DL_BIND_FUNC}
  DSO_F_DL_BIND_FUNC = 104;
  {$EXTERNALSYM DSO_F_DL_BIND_VAR}
  DSO_F_DL_BIND_VAR = 105;
  {$EXTERNALSYM DSO_F_DL_LOAD}
  DSO_F_DL_LOAD	= 106;
  {$EXTERNALSYM DSO_F_DL_MERGER}
  DSO_F_DL_MERGER = 131;
  {$EXTERNALSYM DSO_F_DL_NAME_CONVERTER}
  DSO_F_DL_NAME_CONVERTER = 124;
  {$EXTERNALSYM DSO_F_DL_UNLOAD}
  DSO_F_DL_UNLOAD = 107;
  {$EXTERNALSYM DSO_F_DSO_BIND_FUNC}
  DSO_F_DSO_BIND_FUNC	= 108;
  {$EXTERNALSYM DSO_F_DSO_BIND_VAR}
  DSO_F_DSO_BIND_VAR = 109;
  {$EXTERNALSYM DSO_F_DSO_CONVERT_FILENAME}
  DSO_F_DSO_CONVERT_FILENAME = 126;
  {$EXTERNALSYM DSO_F_DSO_CTRL}
  DSO_F_DSO_CTRL = 110;
  {$EXTERNALSYM DSO_F_DSO_FREE}
  DSO_F_DSO_FREE = 111;
  {$EXTERNALSYM DSO_F_DSO_GET_FILENAME}
  DSO_F_DSO_GET_FILENAME				= 127;
  {$EXTERNALSYM DSO_F_DSO_GET_LOADED_FILENAME}
  DSO_F_DSO_GET_LOADED_FILENAME	= 128;
  {$EXTERNALSYM DSO_F_DSO_GLOBAL_LOOKUP}
  DSO_F_DSO_GLOBAL_LOOKUP				= 139;
  {$EXTERNALSYM DSO_F_DSO_LOAD}
  DSO_F_DSO_LOAD					 = 112;
  {$EXTERNALSYM DSO_F_DSO_MERGE}
  DSO_F_DSO_MERGE					 = 132;
  {$EXTERNALSYM DSO_F_DSO_NEW_METHOD}
  DSO_F_DSO_NEW_METHOD				= 113;
  {$EXTERNALSYM DSO_F_DSO_PATHBYADDR}
  DSO_F_DSO_PATHBYADDR				= 140;
  {$EXTERNALSYM DSO_F_DSO_SET_FILENAME}
  DSO_F_DSO_SET_FILENAME				= 129;
  {$EXTERNALSYM DSO_F_DSO_SET_NAME_CONVERTER}
  DSO_F_DSO_SET_NAME_CONVERTER			= 122;
  {$EXTERNALSYM DSO_F_DSO_UP_REF}
  DSO_F_DSO_UP_REF				 = 114;
  {$EXTERNALSYM DSO_F_GLOBAL_LOOKUP_FUNC}
  DSO_F_GLOBAL_LOOKUP_FUNC			= 138;
  {$EXTERNALSYM DSO_F_PATHBYADDR}
  DSO_F_PATHBYADDR				= 137;
  {$EXTERNALSYM DSO_F_VMS_BIND_SYM}
  DSO_F_VMS_BIND_SYM			 = 115;
  {$EXTERNALSYM DSO_F_VMS_LOAD}
  DSO_F_VMS_LOAD					= 116;
  {$EXTERNALSYM DSO_F_VMS_MERGER}
  DSO_F_VMS_MERGER				= 133;
  {$EXTERNALSYM DSO_F_VMS_UNLOAD}
  DSO_F_VMS_UNLOAD				= 117;
  {$EXTERNALSYM DSO_F_WIN32_BIND_FUNC}
  DSO_F_WIN32_BIND_FUNC				= 118;
  {$EXTERNALSYM DSO_F_WIN32_BIND_VAR}
  DSO_F_WIN32_BIND_VAR				= 119;
  {$EXTERNALSYM DSO_F_WIN32_GLOBALLOOKUP}
  DSO_F_WIN32_GLOBALLOOKUP			= 142;
  {$EXTERNALSYM DSO_F_WIN32_GLOBALLOOKUP_FUNC}
  DSO_F_WIN32_GLOBALLOOKUP_FUNC			= 143;
  {$EXTERNALSYM DSO_F_WIN32_JOINER}
  DSO_F_WIN32_JOINER			 = 135;
  {$EXTERNALSYM DSO_F_WIN32_LOAD}
  DSO_F_WIN32_LOAD				 = 120;
  {$EXTERNALSYM DSO_F_WIN32_MERGER}
  DSO_F_WIN32_MERGER				= 134;
  {$EXTERNALSYM DSO_F_WIN32_NAME_CONVERTER}
  DSO_F_WIN32_NAME_CONVERTER			= 125;
  {$EXTERNALSYM DSO_F_WIN32_PATHBYADDR}
  DSO_F_WIN32_PATHBYADDR			 = 141;
  {$EXTERNALSYM DSO_F_WIN32_SPLITTER}
  DSO_F_WIN32_SPLITTER			 = 136;
  {$EXTERNALSYM DSO_F_WIN32_UNLOAD}
  DSO_F_WIN32_UNLOAD				 = 121;

//* Reason codes. */
  {$EXTERNALSYM DSO_R_CTRL_FAILED}
  DSO_R_CTRL_FAILED	= 100;
  {$EXTERNALSYM DSO_R_DSO_ALREADY_LOADED}
  DSO_R_DSO_ALREADY_LOADED = 110;
  {$EXTERNALSYM DSO_R_EMPTY_FILE_STRUCTURE}
  DSO_R_EMPTY_FILE_STRUCTURE = 113;
  {$EXTERNALSYM DSO_R_FAILURE}
  DSO_R_FAILURE = 114;
  {$EXTERNALSYM DSO_R_FILENAME_TOO_BIG}
  DSO_R_FILENAME_TOO_BIG = 101;
  {$EXTERNALSYM DSO_R_FINISH_FAILED}
  DSO_R_FINISH_FAILED	= 102;
  {$EXTERNALSYM DSO_R_INCORRECT_FILE_SYNTAX}
  DSO_R_INCORRECT_FILE_SYNTAX = 115;
  {$EXTERNALSYM DSO_R_LOAD_FAILED}
  DSO_R_LOAD_FAILED	= 103;
  {$EXTERNALSYM DSO_R_NAME_TRANSLATION_FAILED}
  DSO_R_NAME_TRANSLATION_FAILED	= 109;
  {$EXTERNALSYM DSO_R_NO_FILENAME}
  DSO_R_NO_FILENAME	= 111;
  {$EXTERNALSYM DSO_R_NO_FILE_SPECIFICATION}
  DSO_R_NO_FILE_SPECIFICATION	= 116;
  {$EXTERNALSYM DSO_R_NULL_HANDLE}
  DSO_R_NULL_HANDLE			 = 104;
  {$EXTERNALSYM DSO_R_SET_FILENAME_FAILED}
  DSO_R_SET_FILENAME_FAILED		 = 112;
  {$EXTERNALSYM DSO_R_STACK_ERROR}
  DSO_R_STACK_ERROR			 = 105;
   {$EXTERNALSYM DSO_R_SYM_FAILURE}
  DSO_R_SYM_FAILURE	= 106;
   {$EXTERNALSYM DSO_R_UNLOAD_FAILED}
  DSO_R_UNLOAD_FAILED	= 107;
   {$EXTERNALSYM DSO_R_UNSUPPORTED}
  DSO_R_UNSUPPORTED = 108;

  {$ifndef OPENSSL_NO_SRP}
   {$EXTERNALSYM SRP_NO_ERROR}

   SRP_NO_ERROR = 0;
   {$EXTERNALSYM SRP_ERR_VBASE_INCOMPLETE_FILE}
   SRP_ERR_VBASE_INCOMPLETE_FILE = 1;
   {$EXTERNALSYM SRP_ERR_VBASE_BN_LIB}
   SRP_ERR_VBASE_BN_LIB = 2;
   {$EXTERNALSYM SRP_ERR_OPEN_FILE}
   SRP_ERR_OPEN_FILE = 3;
   {$EXTERNALSYM SRP_ERR_MEMORY}
   SRP_ERR_MEMORY = 4;

   {$EXTERNALSYM DB_srptype}
   DB_srptype	= 0;
   {$EXTERNALSYM DB_srpverifier}
   DB_srpverifier	= 1;
   {$EXTERNALSYM DB_srpsalt}
   DB_srpsalt = 2;
   {$EXTERNALSYM DB_srpid}
   DB_srpid = 3;
   {$EXTERNALSYM DB_srpgN}
   DB_srpgN = 4;
   {$EXTERNALSYM DB_srpinfo}
   DB_srpinfo = 5;
   {$NODEFINE DB_NUMBER}
   DB_NUMBER = 6;
   {$EXTERNALSYM DB_SRP_INDEX}
   DB_SRP_INDEX	= 'I';
   {$EXTERNALSYM DB_SRP_VALID}
   DB_SRP_VALID	= 'V';
   {$EXTERNALSYM DB_SRP_REVOKED}
   DB_SRP_REVOKED	= 'R';
   {$EXTERNALSYM DB_SRP_MODIF}
   DB_SRP_MODIF	= 'v';
  {$ENDIF}
   {$EXTERNALSYM SRTP_AES128_CM_SHA1_80}
   SRTP_AES128_CM_SHA1_80 = $0001;
   {$EXTERNALSYM SRTP_AES128_CM_SHA1_32}
   SRTP_AES128_CM_SHA1_32 = $0002;
   {$EXTERNALSYM SRTP_AES128_F8_SHA1_80}
   SRTP_AES128_F8_SHA1_80 = $0003;
   {$EXTERNALSYM SRTP_AES128_F8_SHA1_32}
   SRTP_AES128_F8_SHA1_32 = $0004;
   {$EXTERNALSYM SRTP_NULL_SHA1_80}
   SRTP_NULL_SHA1_80      = $0005;
   {$EXTERNALSYM SRTP_NULL_SHA1_32}
   SRTP_NULL_SHA1_32      = $0006;

  _ATEXIT_SIZE = 32;
  {$EXTERNALSYM _ATEXIT_SIZE}
  _IOFBF = 0;
  {$EXTERNALSYM _IOFBF}
  _IOLBF = 1;
  {$EXTERNALSYM _IOLBF}
  _IONBF = 2;
  {$EXTERNALSYM _IONBF}
  _N_LISTS = 30;
  {$EXTERNALSYM _N_LISTS}
  _MSS_WIN32 = 1;
  {$EXTERNALSYM _MSS_WIN32}
  _MSS_X86_ = 1;
  {$EXTERNALSYM _MSS_X86_}
  __CYGWIN32__ = 1;
  {$EXTERNALSYM __CYGWIN32__}
  __CYGWIN__ = 1;
  {$EXTERNALSYM __CYGWIN__}
  __GNUC_MINOR__ = 91;
  {$EXTERNALSYM __GNUC_MINOR__}
  __GNUC__ = 2;
  {$EXTERNALSYM __GNUC__}
  __SAPP = $0100;
  {$EXTERNALSYM __SAPP }
  __SEOF = $0020;
  {$EXTERNALSYM __SEOF }
  __SERR = $0040;
  {$EXTERNALSYM __SERR }
  __SLBF = $0001;
  {$EXTERNALSYM __SLBF }
  __SMBF = $0080;
  {$EXTERNALSYM __SMBF }
  __SMOD = $2000;
  {$EXTERNALSYM __SMOD }
  __SNBF = $0002;
  {$EXTERNALSYM __SNBF }
  __SNPT = $0800;
  {$EXTERNALSYM __SNPT }
  __SOFF = $1000;
  {$EXTERNALSYM __SOFF }
  __SOPT = $0400;
  {$EXTERNALSYM __SOPT }
  __SRD = $0004;
  {$EXTERNALSYM __SRD }
  __SRW = $0010;
  {$EXTERNALSYM __SRW }
  __SSTR = $0200;
  {$EXTERNALSYM __SSTR }
  __STDC__ = 1;
  {$EXTERNALSYM __STDC__}
  __SWR = $0008;
  {$EXTERNALSYM __SWR }
  __WINNT = 1;
  {$EXTERNALSYM __WINNT}
  __WINNT__ = 1;
  {$EXTERNALSYM __WINNT__}
  __i386 = 1;
  {$EXTERNALSYM __i386}
  __i386__ = 1;
  {$EXTERNALSYM __i386__}
  __i586 = 1;
  {$EXTERNALSYM __i586}
  __i586__ = 1;
  {$EXTERNALSYM __i586__}
  __pentium = 1;
  {$EXTERNALSYM __pentium}
  __pentium__ = 1;
  {$EXTERNALSYM __pentium__}
  i386 = 1;
  {$EXTERNALSYM i386}
  i586 = 1;
  {$EXTERNALSYM i586}
  pentium = 1;
  {$EXTERNALSYM pentium}
//kssl.h
{$IFNDEF OPENSSL_NO_KRB5}
{These are consts for Kerberos support.  These will not be complete because
FreePascal, Borland Delphi, and Indy don't support Kerberos.  These are here
as place holders so we get an exact OpenSSL API if Kerberos support was compiled
in.
}
  {$EXTERNALSYM KSSL_ERR_MAX}
  KSSL_ERR_MAX = 255;
  {$EXTERNALSYM KSSL_CLIENT}
  KSSL_CLIENT  = 1;
 {$EXTERNALSYM KSSL_SERVER}
  KSSL_SERVER  = 2;
 {$EXTERNALSYM KSSL_SERVICE}
  KSSL_SERVICE = 3;
  {$EXTERNALSYM KSSL_KEYTAB}
  KSSL_KEYTAB = 4;
  {$EXTERNALSYM KSSL_CTX_OK}
  KSSL_CTX_OK = 0;
 {$EXTERNALSYM KSSL_CTX_ERR}
  KSSL_CTX_ERR = 1;
  {$EXTERNALSYM KSSL_NOMEM}
  KSSL_NOMEM = 2;
{$ENDIF}

{Error - err.h }
const
  {$EXTERNALSYM ERR_TXT_MALLOCED}
  ERR_TXT_MALLOCED = $01;
  {$EXTERNALSYM ERR_TXT_STRING}
  ERR_TXT_STRING = $02;
  {$EXTERNALSYM ERR_NUM_ERRORS}
  ERR_NUM_ERRORS = 16;

const
  // library
  {$EXTERNALSYM ERR_LIB_NONE}
  ERR_LIB_NONE = 1;
  {$EXTERNALSYM ERR_LIB_SYS}
  ERR_LIB_SYS  = 2;
  {$EXTERNALSYM ERR_LIB_BN}
  ERR_LIB_BN   = 3;
  {$EXTERNALSYM ERR_LIB_RSA}
  ERR_LIB_RSA  = 4;
  {$EXTERNALSYM ERR_LIB_DH}
  ERR_LIB_DH   = 5;
  {$EXTERNALSYM ERR_LIB_EVP}
  ERR_LIB_EVP  = 6;
  {$EXTERNALSYM ERR_LIB_BUF}
  ERR_LIB_BUF  = 7;
  {$EXTERNALSYM ERR_LIB_OBJ}
  ERR_LIB_OBJ  = 8;
  {$EXTERNALSYM ERR_LIB_PEM}
  ERR_LIB_PEM  = 9;
  {$EXTERNALSYM ERR_LIB_DSA}
  ERR_LIB_DSA  = 10;
  {$EXTERNALSYM ERR_LIB_X509}
  ERR_LIB_X509 = 11;
//  ERR_LIB_METH = 12;
  {$EXTERNALSYM ERR_LIB_ASN1}
  ERR_LIB_ASN1 = 13;
  {$EXTERNALSYM ERR_LIB_CONF}
  ERR_LIB_CONF = 14;
  {$EXTERNALSYM ERR_LIB_CRYPTO}
  ERR_LIB_CRYPTO = 15;
  {$EXTERNALSYM ERR_LIB_EC}
  ERR_LIB_EC = 16;
  {$EXTERNALSYM ERR_LIB_SSL}
  ERR_LIB_SSL    = 20;
//  ERR_LIB_SSL23 = 21;
//  ERR_LIB_SSL2  = 22;
//  ERR_LIB_SSL3  = 23;
//  ERR_LIB_RSAREF = 30;
//  ERR_LIB_PROXY = 31;
  {$EXTERNALSYM ERR_LIB_BIO}
  ERR_LIB_BIO  = 32;
  {$EXTERNALSYM ERR_LIB_PKCS7}
  ERR_LIB_PKCS7 = 33;
  {$EXTERNALSYM ERR_LIB_X509V3}
  ERR_LIB_X509V3 = 34;
  {$EXTERNALSYM ERR_LIB_PKCS12}
  ERR_LIB_PKCS12  = 35;
  {$EXTERNALSYM ERR_LIB_RAND}
  ERR_LIB_RAND   = 36;
  {$EXTERNALSYM ERR_LIB_DSO}
  ERR_LIB_DSO   = 37;
  {$EXTERNALSYM ERR_LIB_ENGINE}
  ERR_LIB_ENGINE = 38;
  {$EXTERNALSYM ERR_LIB_OCSP}
  ERR_LIB_OCSP = 39;
  {$EXTERNALSYM ERR_LIB_UI}
  ERR_LIB_UI    = 40;
  {$EXTERNALSYM ERR_LIB_COMP}
  ERR_LIB_COMP  = 41;
  {$EXTERNALSYM ERR_LIB_ECDSA}
  ERR_LIB_ECDSA = 42;
  {$EXTERNALSYM ERR_LIB_ECDH}
  ERR_LIB_ECDH  = 43;
  {$EXTERNALSYM ERR_LIB_STORE}
  ERR_LIB_STORE = 44;
  {$EXTERNALSYM ERR_LIB_FIPS}
  ERR_LIB_FIPS = 45;
  {$EXTERNALSYM ERR_LIB_CMS}
  ERR_LIB_CMS = 46;
  {$EXTERNALSYM ERR_LIB_TS}
  ERR_LIB_TS	=	47;
  {$EXTERNALSYM ERR_LIB_HMAC}
  ERR_LIB_HMAC	=	48;
  {$EXTERNALSYM ERR_LIB_JPAKE}
  //OpenSSL 0.9.8n was 47
  ERR_LIB_JPAKE = 49;
//* fatal error */
  {$EXTERNALSYM ERR_R_FATAL}
  ERR_R_FATAL	= 64;
//was  ERR_R_FATAL = 32;
  {$EXTERNALSYM ERR_R_MALLOC_FAILURE}
  ERR_R_MALLOC_FAILURE = (1 or ERR_R_FATAL);
  {$EXTERNALSYM ERR_R_SHOULD_NOT_HAVE_BEEN_CALLED}
  ERR_R_SHOULD_NOT_HAVE_BEEN_CALLED = (2 or ERR_R_FATAL);
  {$EXTERNALSYM ERR_R_PASSED_NULL_PARAMETER}
  ERR_R_PASSED_NULL_PARAMETER = (3 or ERR_R_FATAL);
  {$EXTERNALSYM ERR_R_INTERNAL_ERROR}
  ERR_R_INTERNAL_ERROR = (4 or ERR_R_FATAL);
  {$EXTERNALSYM ERR_R_DISABLED}
  ERR_R_DISABLED = (5 or ERR_R_FATAL);
  {$EXTERNALSYM ERR_LIB_USER}
  ERR_LIB_USER  = 128;
  // OS functions
  {$EXTERNALSYM SYS_F_FOPEN}
  SYS_F_FOPEN = 1;
  {$EXTERNALSYM SYS_F_CONNECT}
  SYS_F_CONNECT = 2;
  {$EXTERNALSYM SYS_F_GETSERVBYNAME}
  SYS_F_GETSERVBYNAME = 3;
  {$EXTERNALSYM SYS_F_SOCKET}
  SYS_F_SOCKET = 4;
  {$EXTERNALSYM SYS_F_IOCTLSOCKET}
  SYS_F_IOCTLSOCKET = 5;
  {$EXTERNALSYM SYS_F_BIND}
  SYS_F_BIND = 6;
  {$EXTERNALSYM SYS_F_LISTEN}
  SYS_F_LISTEN = 7;
  {$EXTERNALSYM SYS_F_ACCEPT}
  SYS_F_ACCEPT = 8;
  {$EXTERNALSYM SYS_F_WSASTARTUP}
  SYS_F_WSASTARTUP = 9; { Winsock stuff }
  {$EXTERNALSYM SYS_F_OPENDIR}
  SYS_F_OPENDIR = 10;
  {$EXTERNALSYM SYS_F_FREAD}
  SYS_F_FREAD	= 11;
//* These are the possible flags.  They can be or'ed together. */
//* Use to have echoing of input */
  {$EXTERNALSYM UI_INPUT_FLAG_ECHO}
  UI_INPUT_FLAG_ECHO = $01;
///* Use a default password.  Where that password is found is completely
//   up to the application, it might for example be in the user data set
//   with UI_add_user_data().  It is not recommended to have more than
//   one input in each UI being marked with this flag, or the application
//   might get confused. */
  {$EXTERNALSYM UI_INPUT_FLAG_DEFAULT_PWD}
  UI_INPUT_FLAG_DEFAULT_PWD	= $02;

//* The user of these routines may want to define flags of their own.  The core
//   UI won't look at those, but will pass them on to the method routines.  They
//   must use higher bits so they don't get confused with the UI bits above.
//   UI_INPUT_FLAG_USER_BASE tells which is the lowest bit to use.  A good
//   example of use is this:

//	#define MY_UI_FLAG1	(0x01 << UI_INPUT_FLAG_USER_BASE)
//*/
  {$EXTERNALSYM UI_INPUT_FLAG_USER_BASE}
  UI_INPUT_FLAG_USER_BASE	= 16;
  //IO_ctrl commands
//* The commands */
//* Use UI_CONTROL_PRINT_ERRORS with the value 1 to have UI_process print the
//   OpenSSL error stack before printing any info or added error messages and
//   before any prompting. */
  {$EXTERNALSYM UI_CTRL_PRINT_ERRORS}
  UI_CTRL_PRINT_ERRORS = 1;
//* Check if a UI_process() is possible to do again with the same instance of
//   a user interface.  This makes UI_ctrl() return 1 if it is redoable, and 0
//   if not. */
  {$EXTERNALSYM UI_CTRL_IS_REDOABLE}
  UI_CTRL_IS_REDOABLE	=	2;
//* Function codes. */
  {$EXTERNALSYM UI_F_GENERAL_ALLOCATE_BOOLEAN}
  UI_F_GENERAL_ALLOCATE_BOOLEAN = 108;
  {$EXTERNALSYM UI_F_GENERAL_ALLOCATE_PROMPT}
  UI_F_GENERAL_ALLOCATE_PROMPT = 109;
  {$EXTERNALSYM UI_F_GENERAL_ALLOCATE_STRING}
  UI_F_GENERAL_ALLOCATE_STRING = 100;
  {$EXTERNALSYM UI_F_UI_CTRL}
  UI_F_UI_CTRL = 111;
  {$EXTERNALSYM UI_F_UI_DUP_ERROR_STRING}
  UI_F_UI_DUP_ERROR_STRING = 101;
  {$EXTERNALSYM UI_F_UI_DUP_INFO_STRING}
  UI_F_UI_DUP_INFO_STRING = 102;
  {$EXTERNALSYM UI_F_UI_DUP_INPUT_BOOLEAN}
  UI_F_UI_DUP_INPUT_BOOLEAN = 110;
  {$EXTERNALSYM UI_F_UI_DUP_INPUT_STRING}
  UI_F_UI_DUP_INPUT_STRING = 103;
  {$EXTERNALSYM UI_F_UI_DUP_VERIFY_STRING}
  UI_F_UI_DUP_VERIFY_STRING = 106;
  {$EXTERNALSYM UI_F_UI_GET0_RESULT}
  UI_F_UI_GET0_RESULT	= 107;
  {$EXTERNALSYM UI_F_UI_NEW_METHOD}
  UI_F_UI_NEW_METHOD = 104;
  {$EXTERNALSYM UI_F_UI_SET_RESULT}
  UI_F_UI_SET_RESULT = 105;
//* Reason codes. */
  {$EXTERNALSYM UI_R_COMMON_OK_AND_CANCEL_CHARACTERS}
  UI_R_COMMON_OK_AND_CANCEL_CHARACTERS = 104;
  {$EXTERNALSYM UI_R_INDEX_TOO_LARGE}
  UI_R_INDEX_TOO_LARGE = 102;
  {$EXTERNALSYM UI_R_INDEX_TOO_SMALL}
  UI_R_INDEX_TOO_SMALL = 103;
  {$EXTERNALSYM UI_R_NO_RESULT_BUFFER}
  UI_R_NO_RESULT_BUFFER	= 105;
  {$EXTERNALSYM UI_R_RESULT_TOO_LARGE}
  UI_R_RESULT_TOO_LARGE	= 100;
  {$EXTERNALSYM UI_R_RESULT_TOO_SMALL}
  UI_R_RESULT_TOO_SMALL	= 101;
  {$EXTERNALSYM UI_R_UNKNOWN_CONTROL_COMMAND}
  UI_R_UNKNOWN_CONTROL_COMMAND = 106;

const
  // reasons
  {$EXTERNALSYM ERR_R_SYS_LIB}
  ERR_R_SYS_LIB = ERR_LIB_SYS;
  {$EXTERNALSYM ERR_R_BN_LIB}
  ERR_R_BN_LIB  = ERR_LIB_BN;
  {$EXTERNALSYM ERR_R_RSA_LIB}
  ERR_R_RSA_LIB = ERR_LIB_RSA;
  {$EXTERNALSYM ERR_R_DH_LIB}
  ERR_R_DH_LIB = ERR_LIB_DH;
 {$EXTERNALSYM ERR_R_EVP_LIB}
  ERR_R_EVP_LIB = ERR_LIB_EVP;
  {$EXTERNALSYM ERR_R_BUF_LIB}
  ERR_R_BUF_LIB = ERR_LIB_BUF;
  {$EXTERNALSYM ERR_R_OBJ_LIB}
  ERR_R_OBJ_LIB = ERR_LIB_OBJ;
  {$EXTERNALSYM ERR_R_PEM_LIB}
  ERR_R_PEM_LIB = ERR_LIB_PEM;
  {$EXTERNALSYM ERR_R_DSA_LIB}
  ERR_R_DSA_LIB = ERR_LIB_DSA;
  {$EXTERNALSYM ERR_R_X509_LIB}
  ERR_R_X509_LIB = ERR_LIB_X509;
  {$EXTERNALSYM ERR_R_ASN1_LIB}
  ERR_R_ASN1_LIB = ERR_LIB_ASN1;
  {$EXTERNALSYM ERR_R_CONF_LIB}
  ERR_R_CONF_LIB = ERR_LIB_CONF;
  {$EXTERNALSYM ERR_R_CRYPTO_LIB}
  ERR_R_CRYPTO_LIB = ERR_LIB_CRYPTO;
  {$EXTERNALSYM ERR_R_EC_LIB}
  ERR_R_EC_LIB = ERR_LIB_EC;
  {$EXTERNALSYM ERR_R_SSL_LIB}
  ERR_R_SSL_LIB = ERR_LIB_SSL;
  {$EXTERNALSYM ERR_R_BIO_LIB}
  ERR_R_BIO_LIB = ERR_LIB_BIO;
  {$EXTERNALSYM ERR_R_PKCS7_LIB}
  ERR_R_PKCS7_LIB = ERR_LIB_PKCS7;
  {$EXTERNALSYM ERR_R_X509V3_LIB}
  ERR_R_X509V3_LIB = ERR_LIB_X509V3;
  {$EXTERNALSYM ERR_R_PKCS12_LIB}
  ERR_R_PKCS12_LIB = ERR_LIB_PKCS12;
  {$EXTERNALSYM ERR_R_RAND_LIB}
  ERR_R_RAND_LIB = ERR_LIB_RAND;
  {$EXTERNALSYM ERR_R_DSO_LIB}
  ERR_R_DSO_LIB	= ERR_LIB_DSO;
  {$EXTERNALSYM ERR_R_ENGINE_LIB}
  ERR_R_ENGINE_LIB = ERR_LIB_ENGINE;
  {$EXTERNALSYM ERR_R_OCSP_LIB}
  ERR_R_OCSP_LIB = ERR_LIB_OCSP;
  {$EXTERNALSYM ERR_R_UI_LIB}
  ERR_R_UI_LIB = ERR_LIB_UI;
  {$EXTERNALSYM ERR_R_COMP_LIB}
  ERR_R_COMP_LIB = ERR_LIB_COMP;
  {$EXTERNALSYM ERR_R_ECDSA_LIB}
  ERR_R_ECDSA_LIB = ERR_LIB_ECDSA;
  {$EXTERNALSYM ERR_R_ECDH_LIB}
  ERR_R_ECDH_LIB = ERR_LIB_ECDH;
  {$EXTERNALSYM ERR_R_STORE_LIB}
  ERR_R_STORE_LIB = ERR_LIB_STORE;
  {$EXTERNALSYM ERR_R_TS_LIB}
  ERR_R_TS_LIB = ERR_LIB_TS;       //* 45 */
  {$EXTERNALSYM ERR_R_NESTED_ASN1_ERROR}
  ERR_R_NESTED_ASN1_ERROR = 58;
  {$EXTERNALSYM ERR_R_BAD_ASN1_OBJECT_HEADER}
  ERR_R_BAD_ASN1_OBJECT_HEADER = 59;
  {$EXTERNALSYM ERR_R_BAD_GET_ASN1_OBJECT_CALL}
  ERR_R_BAD_GET_ASN1_OBJECT_CALL = 60;
  {$EXTERNALSYM ERR_R_EXPECTING_AN_ASN1_SEQUENCE}
  ERR_R_EXPECTING_AN_ASN1_SEQUENCE = 61;
  {$EXTERNALSYM ERR_R_ASN1_LENGTH_MISMATCH}
  ERR_R_ASN1_LENGTH_MISMATCH = 62;
  {$EXTERNALSYM ERR_R_MISSING_ASN1_EOS}
  ERR_R_MISSING_ASN1_EOS = 63;
  {$EXTERNALSYM DTLS1_VERSION}
  DTLS1_VERSION = $FEFF;
  {$EXTERNALSYM DTLS1_BAD_VER}
  DTLS1_BAD_VER = $0100;
{$IFNDEF USE_THIS}
//* this alert description is not specified anywhere... */
  {$EXTERNALSYM DTLS1_AD_MISSING_HANDSHAKE_MESSAGE}
 DTLS1_AD_MISSING_HANDSHAKE_MESSAGE = 110;
{$endif}
  //was 32
  {$EXTERNALSYM DTLS1_COOKIE_LENGTH}
  DTLS1_COOKIE_LENGTH = 256;
  {$EXTERNALSYM DTLS1_RT_HEADER_LENGTH}
  DTLS1_RT_HEADER_LENGTH = 13;
  {$EXTERNALSYM DTLS1_HM_HEADER_LENGTH}
  DTLS1_HM_HEADER_LENGTH = 12;
  {$EXTERNALSYM DTLS1_HM_BAD_FRAGMENT}
  DTLS1_HM_BAD_FRAGMENT = -2;
  {$EXTERNALSYM DTLS1_HM_FRAGMENT_RETRY}
  DTLS1_HM_FRAGMENT_RETRY = -3;
  {$EXTERNALSYM DTLS1_CCS_HEADER_LENGTH}
  //OpenSSL 0.9.8e defines this as OPENSSL_DTLS1_CCS_HEADER_LENGTH = 3;
  DTLS1_CCS_HEADER_LENGTH = 1;
  {$EXTERNALSYM DTLS1_AL_HEADER_LENGTH}
{$ifdef DTLS1_AD_MISSING_HANDSHAKE_MESSAGE}
  DTLS1_AL_HEADER_LENGTH = 7;
{$else}
  DTLS1_AL_HEADER_LENGTH = 2;
{$endif}

type
  {$EXTERNALSYM PPByte}
  PPByte = ^PByte;
  {$IFNDEF HAS_PPointer}
  {$EXTERNALSYM PPointer}
  PPointer = ^Pointer;
  {$ENDIF}

//This is just a synthasis since Pascal probably has what we need.
//In C, the OpenSSL developers were using the PQ_64BIT moniker
//to ensure that they had a value that is always 64bit.
//In Pascal, this is not a problem since Delphi and FreePascal have this in some form.
  {$EXTERNALSYM PQ_64BIT}
  PQ_64BIT = TIdC_UINT64;

// RLebeau - the following value was conflicting with iphlpapi.h under C++Builder
// (and possibly other headers) so using the HPPEMIT further above as a workaround
  {$EXTERNALSYM time_t}
  time_t = TIdC_LONG;
  {$EXTERNALSYM STACK}
  STACK = record
    num : TIdC_INT; //int num;
    data : PIdAnsiChar;  //char **data;
    sorted : TIdC_INT;//int sorted;
    num_alloc : TIdC_INT; //int num_alloc;
    comp : function (_para1: PPIdAnsiChar; _para2: PPIdAnsiChar):  TIdC_INT; cdecl;
    //int (*comp)(const char * const *, const char * const *);
  end;
  {$EXTERNALSYM PSTACK}
  PSTACK          = ^STACK;
  {$EXTERNALSYM PPSTACK}
  PPSTACK         = ^PSTACK;
  {$EXTERNALSYM PSTACK_OF_POINTER}
  PSTACK_OF_POINTER = Pointer;
  {$NODEFINE PSSL}
  PSSL            = ^SSL;
  //opensslconf.h
  {$IFNDEF OPENSSL_NO_MD2}
  {$EXTERNALSYM MD2_INT}
    {$IFDEF MD2_CHAR}
  MD2_INT = Char;
    {$ELSE}
      {$IFDEF MD2_LONG}
  MD2_INT = TIdC_ULONG;
      {$ELSE}
  MD2_INT = TIdC_UINT;
      {$ENDIF}
    {$ENDIF}
  {$ENDIF}

  {$IFNDEF OPENSSL_NO_RC1}
  {$EXTERNALSYM RC2_INT}
    {$IFDEF RC2_SHORT}
  RC2_INT = TIdC_USHORT;
    {$ELSE}
      {$IFDEF RC2_LONG}
  RC2_INT = TIdC_ULONG;
      {$ELSE}
  RC2_INT = TIdC_UINT;
      {$ENDIF}
    {$ENDIF}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RC4}
    {$EXTERNALSYM RC4_INT}
    {$IFDEF RC4_CHAR}
  RC4_INT = TIdC_USHORT;
    {$ELSE}
      {$IFDEF RC4_LONG}
  RC4_INT = TIdC_ULONG;
      {$ELSE}
  RC4_INT = TIdC_UINT;
      {$ENDIF}
    {$ENDIF}
    {$IFDEF RC4_CHUNK}
      {$EXTERNALSYM RC4_CHUNK}
  RC4_CHUNK = TIdC_ULONG;
      {$ELSE}
        {$IFDEF RC4_CHUNK_LL}
        {$EXTERNALSYM RC4_CHUNK}
  RC4_CHUNK = TIdC_ULONGLONG;
      {$ELSE}
        {$UNDEF RC4_CHUNK}
      {$ENDIF}
    {$ENDIF}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_IDEA}
    {$EXTERNALSYM IDEA_INT}
    {$IFDEF IDEA_SHORT}
  IDEA_INT = TIdC_USHORT;
    {$ELSE}
      {$IFDEF IDEA_LONG}
  IDEA_INT = TIdC_ULONG;
      {$ELSE}
  IDEA_INT = TIdC_UINT;
      {$ENDIF}
    {$ENDIF}
  {$ENDIF}
  //crypto.h
  //  OpenSSL 1.0.0 structure
  ///* Don't use this structure directly. */
  {$EXTERNALSYM CRYPTO_THREADID}
  CRYPTO_THREADID = record
    ptr : Pointer;
    val : TIdC_ULONG;
  end;
  {$EXTERNALSYM PCRYPTO_THREADID}
  PCRYPTO_THREADID = ^CRYPTO_THREADID;
  //  end OpenSSL 1.0.0 structures
  {$EXTERNALSYM OPENSSL_ITEM}
  OPENSSL_ITEM = record
    code : TIdC_INT;
    value : Pointer;		//* Not used for flag attributes */
    value_size : size_t;	//* Max size of value for output, length for input */
    value_length : Psize_t;	//* Returned length of value for output */
  end;
  {$EXTERNALSYM CRYPTO_EX_DATA}
  CRYPTO_EX_DATA = record
    sk : PSTACK;
    dummy : TIdC_INT; // gcc is screwing up this data structure :-(
  end;
  {$EXTERNALSYM PCRYPTO_EX_DATA}
  PCRYPTO_EX_DATA = ^CRYPTO_EX_DATA;
{
/* Some applications as well as some parts of OpenSSL need to allocate
   and deallocate locks in a dynamic fashion.  The following typedef
   makes this possible in a type-safe manner.  */
/* struct CRYPTO_dynlock_value has to be defined by the application. */
}
  {$EXTERNALSYM PCRYPTO_dynlock_value}
  PCRYPTO_dynlock_value = Pointer;
  {$EXTERNALSYM CRYPTO_dynlock}
  CRYPTO_dynlock = record
	  references : TIdC_INT;
	  data : PCRYPTO_dynlock_value;
  end;
  {$EXTERNALSYM PCRYPTO_dynlock}
  PCRYPTO_dynlock = ^CRYPTO_dynlock;
//* Callback types for crypto.h */
//typedef int CRYPTO_EX_new(void *parent, void *ptr, CRYPTO_EX_DATA *ad,
//					int idx, long argl, void *argp);
 {$EXTERNALSYM CRYPTO_EX_new}
  CRYPTO_EX_new = function(parent : Pointer; ptr : Pointer; ad : CRYPTO_EX_DATA;
    idx : TIdC_INT; arg1 : TIdC_LONG; argp : Pointer) : TIdC_INT; cdecl;
//typedef void CRYPTO_EX_free(void *parent, void *ptr, CRYPTO_EX_DATA *ad,
//					int idx, long argl, void *argp);
 {$EXTERNALSYM CRYPTO_EX_free}
  CRYPTO_EX_free = procedure (parent : Pointer; ptr : Pointer; ad : CRYPTO_EX_DATA;
    idx : TIdC_INT; arg1 : TIdC_LONG; argp : Pointer); cdecl;
//typedef int CRYPTO_EX_dup(CRYPTO_EX_DATA *to, CRYPTO_EX_DATA *from, void *from_d,
//					int idx, long argl, void *argp);
 {$EXTERNALSYM CRYPTO_EX_dup}
  CRYPTO_EX_dup = function (_to : PCRYPTO_EX_DATA; from : PCRYPTO_EX_DATA;
    from_d : Pointer; idx : TIdC_INT; arg1 : TIdC_LONG; argp : Pointer) : TIdC_INT; cdecl;
   {$EXTERNALSYM CRYPTO_EX_DATA_FUNCS}
  CRYPTO_EX_DATA_FUNCS = record
    argl : TIdC_LONG;	//* Arbitary long */
    argp : Pointer;	//* Arbitary void * */
    new_func : CRYPTO_EX_new;
    free_func : CRYPTO_EX_free;
    dup_func : CRYPTO_EX_dup;
  end;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_CRYPTO_EX_DATA_FUNCS}
  STACK_OF_CRYPTO_EX_DATA_FUNCS = record
    stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_CRYPTO_EX_DATA_FUNCS}
  PSTACK_OF_CRYPTO_EX_DATA_FUNCS = ^STACK_OF_CRYPTO_EX_DATA_FUNCS;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_CRYPTO_EX_DATA_FUNCS}
  PSTACK_OF_CRYPTO_EX_DATA_FUNCS = PSTACK;
  {$ENDIF}
  ///* An opaque type representing an implementation of "ex_data" support */
  {$EXTERNALSYM PCRYPTO_EX_DATA_IMPL}
  PCRYPTO_EX_DATA_IMPL = Pointer;
  {$EXTERNALSYM ERR_string_data}
  ERR_string_data = record
    error : TIdC_ULONG;
    _string : PIdAnsiChar;
  end;
  {$EXTERNALSYM PERR_string_data}
  PERR_string_data = ^ERR_string_data;
  {$EXTERNALSYM ERR_STATE}
  ERR_STATE = record
    tid : CRYPTO_THREADID;
   // PID: TIdC_UINT;
    err_flags : array [0..ERR_NUM_ERRORS - 1] of TIdC_INT;
    err_buffer: array[0..ERR_NUM_ERRORS-1] of TIdC_UINT;
    err_data : array [0..ERR_NUM_ERRORS -1] of PIdAnsiChar;
    err_data_flags : array [0..ERR_NUM_ERRORS -1] of TIdC_INT;
    err_file: array[0..ERR_NUM_ERRORS-1] of PIdAnsiChar;
    err_line: array[0..ERR_NUM_ERRORS-1] of TIdC_INT;
    top: TIdC_INT;
    bottom: TIdC_INT;
  end; // record
  {$EXTERNALSYM TERR_STATE}
  TERR_STATE = ERR_STATE;
  {$EXTERNALSYM PERR_FNS}
  PERR_FNS = Pointer;
  //rand.h
  {$IFDEF OPENSSL_FIPS}
  {$EXTERNALSYM FIPS_RAND_SIZE_T}
  FIPS_RAND_SIZE_T = TIdC_int;
  {$ENDIF}
  {$EXTERNALSYM RAND_METHOD}
  RAND_METHOD = record
    seed : procedure (const buf : Pointer; num : TIdC_INT) cdecl;
    bytes : function(const buf : PIdAnsiChar; num : TIdC_INT) : TIdC_INT cdecl;
    cleanup : procedure cdecl;
    add : procedure (const buf : Pointer; num : TIdC_INT; entropy : TIdC_DOUBLE) cdecl;
    pseudorand : function(buf : PIdAnsiChar; num : TIdC_INT) : TIdC_INT cdecl;
    status : function : TIdC_INT cdecl;
  end;
  //bn.h
  {$IFDEF SIXTY_FOUR_BIT_LONG}
    {$EXTERNALSYM BN_ULLONG}
    BN_ULLONG = TIdC_LONGLONG;
    {$EXTERNALSYM BN_ULONG}
    BN_ULONG = TIdC_ULONG;
    {$EXTERNALSYM BN_LONG}
    BN_LONG = TIdC_LONG;
  {$ENDIF}
  {$IFDEF SIXTY_FOUR_BIT}
    {$EXTERNALSYM BN_ULLONG}
    BN_ULLONG = TIdC_ULONGLONG;
    {$EXTERNALSYM BN_LONG}
    BN_LONG = TIdC_LONGLONG;
    {$EXTERNALSYM BN_ULONG}
    BN_ULONG = TIdC_ULONGLONG;
  {$ENDIF}
  {$IFDEF THIRTY_TWO_BIT}
    {$EXTERNALSYM BN_ULLONG}
    {$IFDEF BN_LLONG}
    BN_ULLONG = TIdC_INT64;
    {$ELSE}
    BN_ULLONG = TIdC_ULONGLONG;
    {$ENDIF}
    {$EXTERNALSYM BN_LONG}
    BN_LONG = TIdC_LONG;
    {$EXTERNALSYM BN_ULONG}
    BN_ULONG = TIdC_ULONG;
  {$ENDIF}
  {$EXTERNALSYM PBN_LONG}
  PBN_LONG = ^BN_LONG;
  {$EXTERNALSYM PBN_ULONG}
  PBN_ULONG = ^BN_ULONG;
  {$EXTERNALSYM BIGNUM}
  BIGNUM = record
    d : PBN_ULONG;	// Pointer to an array of 'BN_BITS2' bit chunks.
    top : TIdC_INT;	// Index of last used d +1.
    // The next are internal book keeping for bn_expand.
    dmax : TIdC_INT;	// Size of the d array.
    neg : TIdC_INT;	// one if the number is negative
    flags : TIdC_INT;
  end;
  {$EXTERNALSYM PBIGNUM}
  PBIGNUM = ^BIGNUM;
 // BN_CTX = record
    //This is defined internally.  I don't want to do anything with an internal structure.
 // end;
  {$EXTERNALSYM PBN_CTX}
  PBN_CTX = Pointer;//^BN_CTX;
  {$EXTERNALSYM PPBN_CTX}
  PPBN_CTX = ^PBN_CTX;
  // Used for montgomery multiplication
  {$EXTERNALSYM BN_MONT_CTX}
  BN_MONT_CTX = record
    ri : TIdC_INT;   // number of bits in R
    RR : BIGNUM;     // used to convert to montgomery form
    N : BIGNUM;      // The modulus
    Ni : BIGNUM;     // R*(1/R mod N) - N*Ni = 1
                     // (Ni is only stored for bignum algorithm)
{#if 0
	/* OpenSSL 0.9.9 preview: */
	BN_ULONG n0[2];/* least significant word(s) of Ni */
#else
	BN_ULONG n0;   /* least significant word of Ni */
#endif}
    {$IFNDEF USE_THIS}
    //* OpenSSL 0.9.9 preview: */
    n0 : array [0..1] of BN_ULONG;
    {$ELSE}
    n0 : BN_ULONG;   // least significant word of Ni
    {$ENDIF}
    flags : TIdC_INT;
  end;
  {$EXTERNALSYM PBN_MONT_CTX}
  PBN_MONT_CTX = ^BN_MONT_CTX;
//  BN_BLINDING = record
    //I can't locate any information about the record fields in this.
//  end;
  {$EXTERNALSYM PBN_BLINDING}
  PBN_BLINDING = pointer;//^BN_BLINDING;
  {$EXTERNALSYM BN_RECP_CTX}
  BN_RECP_CTX = record
    N : BIGNUM;  // the divisor
    Nr : BIGNUM; // the reciprocal
    num_bits : TIdC_INT;
    shift : TIdC_INT;
    flags : TIdC_INT;
  end;
  {$EXTERNALSYM PBN_RECP_CTX}
  PBN_RECP_CTX = ^BN_RECP_CTX;
  {$EXTERNALSYM PBN_GENCB}
  PBN_GENCB = ^BN_GENCB;
  {$EXTERNALSYM PPBN_GENCB}
  PPBN_GENCB = ^PBN_GENCB;
  {$EXTERNALSYM BN_cb_1}
  BN_cb_1 = procedure (p1, p2 : TIdC_INT; p3 : Pointer); cdecl;
  {$EXTERNALSYM BN_cb_2}
  BN_cb_2 = function (p1, p2 : TIdC_INT; p3 : PBN_GENCB): TIdC_INT; cdecl;
  {$EXTERNALSYM BN_GENCB_union}
  BN_GENCB_union = record
    case Integer of
    		// if(ver==1) - handles old style callbacks
        0 : (cb_1 : BN_cb_1);
		// if(ver==2) - new callback style
        1 : (cb_2 : BN_cb_2);
  end;
  {$EXTERNALSYM BN_GENCB}
  BN_GENCB = record
    ver : TIdC_UINT;  // To handle binary (in)compatibility
    arg : Pointer;    // callback-specific data
    cb : BN_GENCB_union;
  end;
  //aes.h

  //seed.h

  //chamellia.h
  {$IFNDEF OPENSSL_NO_CAMELLIA}
  {$EXTERNALSYM KEY_TABLE_TYPE}
  KEY_TABLE_TYPE = array [0..(CAMELLIA_TABLE_WORD_LEN - 1)] of TIdC_UINT; //* to match with WORD */
  {$EXTERNALSYM CAMELLIA_KEY_union}
  CAMELLIA_KEY_union = record
  case byte of
    0 : (d : TIdC_DOUBLE); //* ensures 64-bit align */
    1 : (rd_key : KEY_TABLE_TYPE);
  end;
  {$EXTERNALSYM CAMELLIA_KEY}
  CAMELLIA_KEY = record
    u : CAMELLIA_KEY_union;
    grand_rounds : TIdC_INT;
  end;
  {$EXTERNALSYM PCAMELLIA_KEY}
  PCAMELLIA_KEY = ^CAMELLIA_KEY;
  {$ENDIF}
  //whrlpool.h
  {$EXTERNALSYM WHIRLPOOL_CTX_union}
  WHIRLPOOL_CTX_union = record
  case byte of
    0 : (c : array [0..WHIRLPOOL_DIGEST_LENGTH - 1] of byte );
    1 : (q : array [0..(WHIRLPOOL_DIGEST_LENGTH div SizeOf(TIdC_DOUBLE))-1 ] of TIdC_DOUBLE);
  end;
  {$EXTERNALSYM WHIRLPOOL_CTX}
  WHIRLPOOL_CTX = record
    H : WHIRLPOOL_CTX_union;
    data : array [0..(WHIRLPOOL_BBLOCK div 8)-1] of byte;
    bitoff : TIdC_INT;
    bitlen : array[0..(WHIRLPOOL_COUNTER div sizeof(size_t))-1] of size_t;
  end;
  {$EXTERNALSYM PWHIRLPOOL_CTX}
  PWHIRLPOOL_CTX = ^WHIRLPOOL_CTX;

  //md2.h
  {$IFNDEF OPENSSL_NO_MD2}
  {$EXTERNALSYM MD2_CTX}
  MD2_CTX = record
    num : TIdC_UINT;
    data : array [0..MD2_BLOCK - 1] of TIdAnsiChar;
    cksm : array [0..MD2_BLOCK - 1] of MD2_INT;
    state : array[0..MD2_BLOCK -1] of MD2_INT;
  end;
  {$EXTERNALSYM PMD2_CTX}
  PMD2_CTX = ^MD2_CTX;
  {$ENDIF}
  //md4.h
  {$IFNDEF OPENSSL_NO_MD4}
  {$EXTERNALSYM MD4_LONG}
  MD4_LONG = TIdC_ULONG;
  {$EXTERNALSYM MD4_CTX}
  MD4_CTX = record
    A,B,C,D : MD4_LONG;
    Nl,Nh : MD4_LONG;
    data : array [0..(MD4_LBLOCK-1)] of MD4_LONG;
    num : TIdC_UINT;
  end;
  {$EXTERNALSYM PMD4_CTX}
  PMD4_CTX = ^MD4_CTX;
  {$ENDIF}
  //md5.h
  {$EXTERNALSYM MD5_LONG}
  MD5_LONG = TIdC_UINT;
  {$EXTERNALSYM MD5_CTX}
  MD5_CTX = record
    A,B,C,D : MD5_LONG;
    Nl,Nh : MD5_LONG;
    data : array [0..(MD5_LBLOCK - 1)] of MD5_LONG;
    num : TIdC_UINT;
  end;
  {$EXTERNALSYM PMD5_CTX}
  PMD5_CTX = ^MD5_CTX;
  //sha.h
//#if defined(OPENSSL_NO_SHA) || (defined(OPENSSL_NO_SHA0) && defined(OPENSSL_NO_SHA1))
//#error SHA is disabled.
//#endif
  {$IFDEF OPENSSL_NO_SHA}
    {$DEFINE DONTUSESHA}
  {$ENDIF}
  {$IFDEF PENSSL_NO_SHA0}
    {$IFDEF OPENSSL_NO_SHA1}
      {$DEFINE DONTUSESHA}
    {$ENDIF}
  {$ENDIF}
  {$IFNDEF DONTUSESHA}
    {$IFDEF OPENSSL_FIPS}
  {$EXTERNALSYM FIPS_SHA_SIZE_T}
      FIPS_SHA_SIZE_T  = size_t;
    {$ENDIF}
  {$ENDIF}
  {$EXTERNALSYM SHA_LONG}
  SHA_LONG  = TIdC_UINT;
  {$EXTERNALSYM SHA_CTX}
  SHA_CTX = record
    h0,h1,h2,h3,h4 : SHA_LONG;
    Nl,Nh : SHA_LONG;
    data : array [0..SHA_LBLOCK] of SHA_LONG;
    num : TIdC_INT;
  end;
  {$IFNDEF OPENSSL_NO_SHA256}
  {$EXTERNALSYM SHA256_CTX}
  SHA256_CTX = record
    h : array [0..(8 - 1)] of SHA_LONG;
    Nl,Nh : SHA_LONG;
    data : array [0..(SHA_LBLOCK -1)] of SHA_LONG;
    num,md_len : TIdC_UINT;
  end;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_SHA512}
  {$EXTERNALSYM SHA_LONG64}
  //not defined like this in sha.h but a comment
  //says that it must be 64 bit.
  SHA_LONG64 = TIdC_UINT64;
  {$EXTERNALSYM TSHA512_CTX_Union}
  TSHA512_CTX_Union = record
    case integer of
     0 : (d : array [0..(SHA_LBLOCK -1)] of SHA_LONG64);
     1 : (p : array [0..(SHA512_CBLOCK -1)] of byte);
  end;
  {$EXTERNALSYM SHA512_CTX}
  SHA512_CTX = record
    h : array[0..(8-1)]of SHA_LONG64;
    Nl,Nh : SHA_LONG64;
    u :  TSHA512_CTX_Union;
    num,md_len : TIdC_UINT;
  end;
  {$EXTERNALSYM PSHA512_CTX}
  PSHA512_CTX = ^SHA512_CTX;
  {$ENDIF}
   //ui.h
  {$EXTERNALSYM PUI_METHOD}
   PUI_METHOD = Pointer;  //^UI_METHOD
  {$EXTERNALSYM PUI_STRING}
   PUI_STRING = Pointer;  //^UI_STRING;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_UI_STRING}
  STACK_OF_UI_STRING = record
    stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_UI_STRING}
  PSTACK_OF_UI_STRING = ^STACK_OF_UI_STRING;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_UI_STRING}
  PSTACK_OF_UI_STRING = PSTACK;
  {$ENDIF}
    {$EXTERNALSYM UI_string_types}
    {$EXTERNALSYM UIT_NONE}
    {$EXTERNALSYM UIT_PROMPT}
    {$EXTERNALSYM UIT_VERIFY}
    {$EXTERNALSYM UIT_BOOLEAN}
    {$EXTERNALSYM UIT_INFO}
    {$EXTERNALSYM UIT_ERROR}
  UI_string_types = (
  	UIT_NONE,    //=0,
  	UIT_PROMPT,	 //* Prompt for a string */
   	UIT_VERIFY,	 //* Prompt for a string and verify */
   	UIT_BOOLEAN, //* Prompt for a yes/no response */
   	UIT_INFO,		 //* Send info to the user */
   	UIT_ERROR);	 //* Send an error message to the user */

  //bio.h
  //http://www.openssl.org/docs/crypto/bio.html
  {$EXTERNALSYM PBIO}
  PBIO = ^BIO;
  {$EXTERNALSYM PBIO_METHOD}
  PBIO_METHOD = ^BIO_METHOD;
  {$EXTERNALSYM Pbio_info_cb}
  Pbio_info_cb = procedure (_para1 : PBIO; _para2 : TIdC_INT; _para3 : PIdAnsiChar;
     _para4 : TIdC_INT; _para5, _para6 : TIdC_LONG); cdecl;
  {$EXTERNALSYM BIO_METHOD}
  BIO_METHOD = record
    _type : TIdC_INT;
    name : PIdAnsiChar;
    bwrite : function(_para1 : PBIO; _para2 : PIdAnsiChar; _para3 : TIdC_INT) : TIdC_INT; cdecl;
    bread : function(_para1: PBIO; _para2: PIdAnsiChar; _para3: TIdC_INT) : TIdC_INT; cdecl;
    bputs : function (_para1 : PBIO; _para2 : PIdAnsiChar) : TIdC_INT; cdecl;
    bgets : function (_para1 : PBIO; _para2 : PIdAnsiChar; _para3 : TIdC_INT) : TIdC_INT; cdecl;
    ctrl : function (_para1 : PBIO; _para2 : TIdC_INT; _para3 : TIdC_LONG; _para4 : Pointer) : TIdC_LONG; cdecl;
    create : function(_para1 : PBIO) : TIdC_INT; cdecl;
    destroy : function (_para1 : PBIO) : TIdC_INT; cdecl;
    callback_ctrl : function (_para1 : PBIO; _para2 : TIdC_INT; _para3 : pbio_info_cb): TIdC_LONG; cdecl;
  end;
  BIO = record
    method : PBIO_METHOD;
    // bio, mode, argp, argi, argl, ret
    callback : function (_para1 : PBIO; _para2 : TIdC_INT; _para3 : PIdAnsiChar;
       _para4 : TIdC_INT; _para5, _para6 : TIdC_LONG) : TIdC_LONG cdecl;
    cb_arg : PIdAnsiChar; // first argument for the callback
    init : TIdC_INT;
    shutdown : TIdC_INT;
    flags : TIdC_INT;  // extra storage
    retry_reason : TIdC_INT;
    num : TIdC_INT;
    ptr : Pointer;
    next_bio : PBIO;  // used by filter BIOs
    prev_bio : PBIO;  // used by filter BIOs
    references : TIdC_INT;
    num_read : TIdC_ULONG;
    num_write : TIdC_ULONG;
    ex_data : CRYPTO_EX_DATA;
  end;
  {$EXTERNALSYM BIO}
  {$EXTERNALSYM BIO_F_BUFFER_CTX}
  BIO_F_BUFFER_CTX = record
	{
	/* Buffers are setup like this:
	 *
	 * <---------------------- size ----------------------->
	 * +---------------------------------------------------+
	 * | consumed | remaining          | free space        |
	 * +---------------------------------------------------+
	 * <-- off --><------- len ------->
	 *}

	//* BIO *bio; */ /* this is now in the BIO struct */
    ibuf_size : TIdC_INT;	//* how big is the input buffer */
   	obuf_size : TIdC_INT;	//* how big is the output buffer */

	  ibuf : PIdAnsiChar;		//* the char array */
   	ibuf_len : TIdC_INT;		//* how many bytes are in it */
	  ibuf_off : TIdC_INT;		//* write/read offset */

	  obuf : PIdAnsiChar;		//* the char array */
	  obuf_len : TIdC_INT;		//* how many bytes are in it */
	  obuf_off : TIdC_INT;		//* write/read offset */
  end;
  {$EXTERNALSYM PBIO_F_BUFFER_CTX}
  PBIO_F_BUFFER_CTX = ^BIO_F_BUFFER_CTX;
  //* Prefix and suffix callback in ASN1 BIO *//
  {$EXTERNALSYM asn1_ps_function}
  asn1_ps_function = function (b : PBIO; pbuf : PPIdAnsiChar; plen : PIdC_INT; parg : Pointer) : TIdC_INT cdecl;
  //struct from engine.h
//  ENGINE = record
    //I don't have any info about record fields.
//  end;
  {$EXTERNALSYM PENGINE}
  PENGINE = Pointer;//^ENGINE;
  {$EXTERNALSYM PPENGINE}
  PPENGINE = ^PENGINE;
  //asn1.h
  {$EXTERNALSYM I2D_OF_void}
  //#define I2D_OF(type) int (*)(type *,unsigned char **)
  I2D_OF_void = function(_para1 : Pointer; _para2 : PPByte) : TIdC_INT cdecl;
  //D2I_OF(type) type *(*)(type **,const unsigned char **,long)
  {$EXTERNALSYM D2I_OF_void}
  D2I_OF_void = function (_para1 : PPointer;  _para2 : PPByte; _para3 : TIdC_LONG) : Pointer cdecl;
  // This is just an opaque pointer
 // ASN1_VALUE = record
 // end;
  {$EXTERNALSYM PASN1_VALUE}
  PASN1_VALUE = Pointer;//^ASN1_VALUE;
  {$EXTERNALSYM PPASN1_VALUE}
  PPASN1_VALUE = ^PASN1_VALUE;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_ASN1_VALUE}
  STACK_OF_ASN1_VALUE = record
    stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_ASN1_VALUE}
  PSTACK_OF_ASN1_VALUE = ^STACK_OF_ASN1_VALUE;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_ASN1_VALUE}
  PSTACK_OF_ASN1_VALUE = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM ASN1_OBJECT}
  ASN1_OBJECT = record
    sn, ln : PIdAnsiChar;
    nid    : TIdC_INT;
    length : TIdC_INT;
    data   : PIdAnsiChar;
    flags  : TIdC_INT; // Should we free this one
  end;
  {$EXTERNALSYM PASN1_OBJECT}
  PASN1_OBJECT = ^ASN1_OBJECT;
  {$EXTERNALSYM PPASN1_OBJECT}
  PPASN1_OBJECT = ^PASN1_OBJECT;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_ASN1_OBJECT}
  STACK_OF_ASN1_OBJECT = record
    stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_ASN1_OBJECT}
  PSTACK_OF_ASN1_OBJECT = ^STACK_OF_ASN1_OBJECT;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_ASN1_OBJECT}
  PSTACK_OF_ASN1_OBJECT = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PPSTACK_OF_ASN1_OBJECT}
  PPSTACK_OF_ASN1_OBJECT = ^PSTACK_OF_ASN1_OBJECT;
  {$EXTERNALSYM asn1_string_st}
  asn1_string_st = record
    length : TIdC_INT;
    _type : TIdC_INT;
    data : PIdAnsiChar;
    { The value of the following field depends on the type being
      held.  It is mostly being used for BIT_STRING so if the
      input data has a non-zero 'unused bits' value, it will be
      handled correctly }
    flags : TIdC_LONG;
  end;
   //moved from asn1.h section here for a type definition

  {$IFNDEF OPENSSL_EXPORT_VAR_AS_FUNCTION}
  {$EXTERNALSYM PASN1_ITEM}
  // ASN1_ITEM pointer exported type
  // typedef const ASN1_ITEM ASN1_ITEM_EXP;
  PASN1_ITEM = ^ASN1_ITEM;
  {$ELSE}
  // Platforms that can't easily handle shared global variables are declared
  // as functions returning ASN1_ITEM pointers.
  // ASN1_ITEM pointer exported type
  //typedef const ASN1_ITEM * ASN1_ITEM_EXP(void);
   {$EXTERNALSYM PASN1_ITEM_EXP}
  PASN1_ITEM_EXP = ^ASN1_ITEM_EXP;
  {$ENDIF}
//  typedef int asn1_output_data_fn(BIO *out, BIO *data, ASN1_VALUE *val, int flags,
//					const ASN1_ITEM *it);
  {$EXTERNALSYM asn1_output_data_fn}
  asn1_output_data_fn = function(AOut : PBIO; data : PBIO; val : PASN1_VALUE;
    flags : TIdC_INT; it : PASN1_ITEM): TIdC_INT; stdcall;
  {$EXTERNALSYM ASN1_STRING}
  ASN1_STRING = asn1_string_st;
  {$EXTERNALSYM PASN1_STRING}
  PASN1_STRING = ^ASN1_STRING;
  {$EXTERNALSYM PPASN1_STRING}
  PPASN1_STRING = ^PASN1_STRING;
  {$EXTERNALSYM ASN1_INTEGER}
  ASN1_INTEGER = ASN1_STRING;
  {$EXTERNALSYM PASN1_INTEGER}
  PASN1_INTEGER = ^ASN1_INTEGER;
  {$EXTERNALSYM PPASN1_INTEGER}
  PPASN1_INTEGER = ^PASN1_INTEGER;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_ASN1_INTEGER}
  STACK_OF_ASN1_INTEGER = record
    stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_ASN1_INTEGER}
  PSTACK_OF_ASN1_INTEGER = ^STACK_OF_ASN1_INTEGER;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_ASN1_INTEGER}
  PSTACK_OF_ASN1_INTEGER = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM ASN1_ENUMERATED}
  ASN1_ENUMERATED = ASN1_STRING;
  {$EXTERNALSYM PASN1_ENUMERATED}
  PASN1_ENUMERATED = ^ASN1_ENUMERATED;
  {$EXTERNALSYM PPASN1_ENUMERATED}
  PPASN1_ENUMERATED = ^PASN1_ENUMERATED;
  {$EXTERNALSYM ASN1_BIT_STRING}
  ASN1_BIT_STRING = ASN1_STRING;
  {$EXTERNALSYM PASN1_BIT_STRING}
  PASN1_BIT_STRING = ^ASN1_BIT_STRING;
  {$EXTERNALSYM PPASN1_BIT_STRING}
  PPASN1_BIT_STRING = ^PASN1_BIT_STRING;
  {$EXTERNALSYM ASN1_OCTET_STRING}
  ASN1_OCTET_STRING = ASN1_STRING;
  {$EXTERNALSYM PASN1_OCTET_STRING}
  PASN1_OCTET_STRING = ^ASN1_OCTET_STRING;
  {$EXTERNALSYM PPASN1_OCTET_STRING}
  PPASN1_OCTET_STRING = ^PASN1_OCTET_STRING;
  {$EXTERNALSYM ASN1_PRINTABLESTRING}
  ASN1_PRINTABLESTRING = ASN1_STRING;
  {$EXTERNALSYM PASN1_PRINTABLESTRING}
  PASN1_PRINTABLESTRING = ^ASN1_PRINTABLESTRING;
  {$EXTERNALSYM PPASN1_PRINTABLESTRING}
  PPASN1_PRINTABLESTRING = ^PASN1_PRINTABLESTRING;
  {$EXTERNALSYM ASN1_T61STRING}
  ASN1_T61STRING = ASN1_STRING;
  {$EXTERNALSYM PASN1_T61STRING}
  PASN1_T61STRING = ^ASN1_T61STRING;
  {$EXTERNALSYM PPASN1_T61STRING}
  PPASN1_T61STRING = ^PASN1_T61STRING;
  {$EXTERNALSYM ASN1_IA5STRING}
  ASN1_IA5STRING = ASN1_STRING;
  {$EXTERNALSYM PASN1_IA5STRING}
  PASN1_IA5STRING = ^ASN1_IA5STRING;
  {$EXTERNALSYM PPASN1_IA5STRING}
  PPASN1_IA5STRING = ^PASN1_IA5STRING;
  {$EXTERNALSYM ASN1_UTCTIME}
  ASN1_UTCTIME = ASN1_STRING;
  {$EXTERNALSYM PASN1_UTCTIME}
  PASN1_UTCTIME = ^ASN1_UTCTIME;
  {$EXTERNALSYM PPASN1_UTCTIME}
  PPASN1_UTCTIME = ^PASN1_UTCTIME;
  {$EXTERNALSYM ASN1_GENERALIZEDTIME}
  ASN1_GENERALIZEDTIME = ASN1_STRING;
  {$EXTERNALSYM PASN1_GENERALIZEDTIME}
  PASN1_GENERALIZEDTIME = ^ASN1_GENERALIZEDTIME;
  {$EXTERNALSYM PPASN1_GENERALIZEDTIME}
  PPASN1_GENERALIZEDTIME = ^PASN1_GENERALIZEDTIME;
  {$EXTERNALSYM ASN1_TIME}
  ASN1_TIME = ASN1_STRING;
  {$EXTERNALSYM PASN1_TIME}
  PASN1_TIME = ^ASN1_TIME;
  {$EXTERNALSYM PPASN1_TIME}
  PPASN1_TIME = ^PASN1_TIME;
  {$EXTERNALSYM ASN1_GENERALSTRING}
  ASN1_GENERALSTRING = ASN1_STRING;
  {$EXTERNALSYM PASN1_GENERALSTRING}
  PASN1_GENERALSTRING = ^ASN1_GENERALSTRING;
  {$EXTERNALSYM PPASN1_GENERALSTRING}
  PPASN1_GENERALSTRING = ^PASN1_GENERALSTRING;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_ASN1_GENERALSTRING}
  STACK_OF_ASN1_GENERALSTRING = record
    _stack: STACK;
  end;
  {$EXTERNALSYM PSTACK_OF_ASN1_GENERALSTRING}
  PSTACK_OF_ASN1_GENERALSTRING =^STACK_OF_ASN1_GENERALSTRING;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_ASN1_GENERALSTRING}
  PSTACK_OF_ASN1_GENERALSTRING = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM ASN1_UNIVERSALSTRING}
  ASN1_UNIVERSALSTRING = ASN1_STRING;
  {$EXTERNALSYM PASN1_UNIVERSALSTRING}
  PASN1_UNIVERSALSTRING = ^ASN1_UNIVERSALSTRING;
  {$EXTERNALSYM PPASN1_UNIVERSALSTRING}
  PPASN1_UNIVERSALSTRING = ^PASN1_UNIVERSALSTRING;
  {$EXTERNALSYM ASN1_BMPSTRING}
  ASN1_BMPSTRING = ASN1_STRING;
  {$EXTERNALSYM PASN1_BMPSTRING}
  PASN1_BMPSTRING = ^ASN1_BMPSTRING;
  {$EXTERNALSYM PPASN1_BMPSTRING}
  PPASN1_BMPSTRING = ^PASN1_BMPSTRING;
  {$EXTERNALSYM ASN1_VISIBLESTRING}
  ASN1_VISIBLESTRING = ASN1_STRING;
  {$EXTERNALSYM PASN1_VISIBLESTRING}
  PASN1_VISIBLESTRING = ^ASN1_VISIBLESTRING;
  {$EXTERNALSYM PPASN1_VISIBLESTRING}
  PPASN1_VISIBLESTRING = ^PASN1_VISIBLESTRING;
  {$EXTERNALSYM ASN1_UTF8STRING}
  ASN1_UTF8STRING = ASN1_STRING;
  {$EXTERNALSYM PASN1_UTF8STRING}
  PASN1_UTF8STRING = ^ASN1_UTF8STRING;
  {$EXTERNALSYM PPASN1_UTF8STRING}
  PPASN1_UTF8STRING = ^PASN1_UTF8STRING;
  {$EXTERNALSYM ASN1_BOOLEAN}
  ASN1_BOOLEAN = TIdC_INT;
  {$EXTERNALSYM PASN1_BOOLEAN}
  PASN1_BOOLEAN = ^ASN1_BOOLEAN;
  {$EXTERNALSYM PPASN1_BOOLEAN}
  PPASN1_BOOLEAN = ^PASN1_BOOLEAN;
  {$EXTERNALSYM ASN1_NULL}
  ASN1_NULL = TIdC_INT;
  {$EXTERNALSYM PASN1_NULL}
  PASN1_NULL = ^ASN1_NULL;
  {$EXTERNALSYM PPASN1_NULL}
  PPASN1_NULL = ^PASN1_NULL;
  {$EXTERNALSYM ASN1_TYPE}
  ASN1_TYPE = record
    case Integer of
      0:  (ptr: PIdAnsiChar);
      1:  (boolean: ASN1_BOOLEAN);
      2:  (asn1_string: PASN1_STRING);
      3:  (_object: PASN1_OBJECT);
      4:  (integer: PASN1_INTEGER);
      5:  (enumerated: PASN1_ENUMERATED);
      6:  (bit_string: PASN1_BIT_STRING);
      7:  (octet_string: PASN1_OCTET_STRING);
      8:  (printablestring: PASN1_PRINTABLESTRING);
      9:  (t61string: PASN1_T61STRING);
      10: (ia5string: PASN1_IA5STRING);
      11: (generalstring: PASN1_GENERALSTRING);
      12: (bmpstring: PASN1_BMPSTRING);
      13: (universalstring: PASN1_UNIVERSALSTRING);
      14: (utctime: PASN1_UTCTIME);
      15: (generalizedtime: PASN1_GENERALIZEDTIME);
      16: (visiblestring: PASN1_VISIBLESTRING);
      17: (utf8string: PASN1_UTF8STRING);
      { set and sequence are left complete and still
      contain the set or sequence bytes }
      18: (_set: PASN1_STRING);
      19: (sequence: PASN1_STRING);
  end;
  {$EXTERNALSYM PASN1_TYPE}
  PASN1_TYPE = ^ASN1_TYPE;
  {$EXTERNALSYM PPASN1_TYPE}
  PPASN1_TYPE = ^PASN1_TYPE;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_ASN1_TYPE}
  STACK_OF_ASN1_TYPE = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_ASN1_TYPE}
  PSTACK_OF_ASN1_TYPE = ^STACK_OF_ASN1_TYPE;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_ASN1_TYPE}
  PSTACK_OF_ASN1_TYPE = ^PSTACK;
  {$ENDIF}
  {$EXTERNALSYM ASN1_CTX}
  ASN1_CTX = record
    p : PIdAnsiChar;         // work char pointer
    eos : TIdC_INT;    // end of sequence read for indefinite encoding
    error : TIdC_INT;  // error code to use when returning an error
    inf : TIdC_INT;    // constructed if 0x20, indefinite is 0x21
    tag : TIdC_INT;    // tag from last 'get object'
    xclass : TIdC_INT; // class from last 'get object'
    slen : TIdC_LONG;  // length of last 'get object'
    max : PIdAnsiChar;       // largest value of p allowed
    q : PIdAnsiChar;         // temporary variable
    pp : PPIdAnsiChar;       // variable
    line : TIdC_INT;   // used in error processing
  end;
  {$EXTERNALSYM PASN1_CTX}
  PASN1_CTX = ^ASN1_CTX;
  {$EXTERNALSYM PPASN1_CTX}
  PPASN1_CTX = ^PASN1_CTX;
  {$EXTERNALSYM ASN1_METHOD}
  ASN1_METHOD = record
    i2d : i2d_of_void;
    d2i : i2d_of_void;
    create : function: Pointer; cdecl;
    destroy : procedure(ptr: Pointer); cdecl;
  end;
  {$EXTERNALSYM PASN1_METHOD}
  PASN1_METHOD = ^ASN1_METHOD;
  {$EXTERNALSYM PPASN1_METHOD}
  PPASN1_METHOD = ^PASN1_METHOD;
  // This is used when parsing some Netscape objects
  {$EXTERNALSYM ASN1_HEADER}
  ASN1_HEADER = record
    header : PASN1_OCTET_STRING;
    data : Pointer;
    meth : PASN1_METHOD;
  end;
  {$EXTERNALSYM PASN1_HEADER}
  PASN1_HEADER = ^ASN1_HEADER;
  {$EXTERNALSYM PPASN1_HEADER}
  PPASN1_HEADER = ^PASN1_HEADER;
  {$EXTERNALSYM ASN1_ENCODING}
  ASN1_ENCODING = record
    enc: PIdAnsiChar;
    len: TIdC_LONG;
    modified: TIdC_INT;
  end;
  {$EXTERNALSYM PASN1_ENCODING}
  PASN1_ENCODING = ^ASN1_ENCODING;
  {$EXTERNALSYM PPASN1_ENCODING}
  PPASN1_ENCODING = ^PASN1_ENCODING;
  {$EXTERNALSYM ASN1_STRING_TABLE}
  ASN1_STRING_TABLE = record
    nid : TIdC_INT;
    minsize : TIdC_LONG;
    maxsize : TIdC_LONG;
    mask : TIdC_ULONG;
    flags : TIdC_ULONG;
  end;
  {$EXTERNALSYM PASN1_STRING_TABLE}
  PASN1_STRING_TABLE = ^ASN1_STRING_TABLE;
  {$EXTERNALSYM PPASN1_STRING_TABLE}
  PPASN1_STRING_TABLE = ^ASN1_STRING_TABLE;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_ASN1_STRING_TABLE}
  STACK_OF_ASN1_STRING_TABLE = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_ASN1_STRING_TABLE}
  PSTACK_OF_ASN1_STRING_TABLE = ^STACK_OF_ASN1_STRING_TABLE;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_ASN1_STRING_TABLE}
  PSTACK_OF_ASN1_STRING_TABLE = PSTACK;
  {$ENDIF}
  {$IFNDEF OPENSSL_EXPORT_VAR_AS_FUNCTION}
  // ASN1_ITEM pointer exported type
  // typedef const ASN1_ITEM ASN1_ITEM_EXP;
  // ASN1_ITEM_EXP = ASN1_ITEM;
  // PASN1_ITEM_EXP = ^ASN1_ITEM_EXP;
   // PASN1_ITEM = ^ASN1_ITEM;
  {$EXTERNALSYM PASN1_ITEM_EXP}
    PASN1_ITEM_EXP = PASN1_ITEM;
  {$ELSE}
  // Platforms that can't easily handle shared global variables are declared
  // as functions returning ASN1_ITEM pointers.

  // ASN1_ITEM pointer exported type
  //typedef const ASN1_ITEM * ASN1_ITEM_EXP(void);
  {$EXTERNALSYM ASN1_ITEM_EXP}
  ASN1_ITEM_EXP = function : PASN1_ITEM cdecl;
//  PASN1_ITEM_EXP = ^ASN1_ITEM_EXP;
  {$ENDIF}
  //rsa.h - struct rsa_st
  {$IFNDEF OPENSSL_NO_RSA}
    {$IFDEF OPENSSL_FIPS}
  {$EXTERNALSYM FIPS_RSA_SIZE_T}
  FIPS_RSA_SIZE_T = TIdC_int;
    {$ENDIF}
  {$EXTERNALSYM PRSA}
  PRSA = ^RSA;
  {$EXTERNALSYM PPRSA}
  PPRSA =^PRSA;
  {$EXTERNALSYM RSA_METHOD}
  RSA_METHOD = record
    name : PIdAnsiChar;
    rsa_pub_enc : function (flen : TIdC_INT; const from : PIdAnsiChar;
      _to : PIdAnsiChar; rsa : PRSA; padding : TIdC_INT) : TIdC_INT; cdecl;
    rsa_pub_dec : function (flen : TIdC_INT; const from : PIdAnsiChar;
      _to : PIdAnsiChar; rsa : PRSA; padding : TIdC_INT) : TIdC_INT; cdecl;
    rsa_priv_enc : function (flen : TIdC_INT; const from : PIdAnsiChar;
      _to : PIdAnsiChar; rsa : PRSA; padding : TIdC_INT) : TIdC_INT; cdecl;
    rsa_priv_dec : function (flen : TIdC_INT; const from : PIdAnsiChar;
       _to : PIdAnsiChar; rsa : PRSA; padding : TIdC_INT) : TIdC_INT; cdecl;
    rsa_mod_exp : function (r0 : PBIGNUM; const I : PBIGNUM;
      rsa : PRSA; ctx : PBN_CTX) : TIdC_INT cdecl; // Can be null /
    bn_mod_exp : function (r : PBIGNUM; const a : PBIGNUM;
      const p : PBIGNUM; const m: PBIGNUM; ctx : PBN_CTX;
      m_ctx : PBN_MONT_CTX ) : TIdC_INT; cdecl; // Can be null
    init : function (rsa : PRSA) : TIdC_INT; cdecl; // called at new
    finish : function (rsa : PRSA) : TIdC_INT; cdecl; // called at free
    flags : TIdC_INT; // RSA_METHOD_FLAG_* things
    app_data : PIdAnsiChar;   // may be needed!
    // New sign and verify functions: some libraries don't allow arbitrary data
    // to be signed/verified: this allows them to be used. Note: for this to work
    // the RSA_public_decrypt() and RSA_private_encrypt() should *NOT* be used
    // RSA_sign(), RSA_verify() should be used instead. Note: for backwards
    // compatibility this functionality is only enabled if the RSA_FLAG_SIGN_VER
    // option is set in 'flags'.
    //
    rsa_sign : function (_type : TIdC_INT; const m : PIdAnsiChar; m_length : TIdC_UINT;
      sigret : PIdAnsiChar; siglen : PIdC_UINT; const rsa : PRSA) : TIdC_INT; cdecl;
    rsa_verify : function(dtype : TIdC_INT; const m : PIdAnsiChar; m_length : PIdC_UINT;
      sigbuf : PIdAnsiChar; siglen : PIdC_UINT; const rsa :PRSA) : TIdC_INT; cdecl;
    // If this callback is NULL, the builtin software RSA key-gen will be used.
    // This is for behavioural compatibility whilst the code gets rewired, but
    // one day it would be nice to assume there are no such things as "builtin
    // software" implementations.
    rsa_keygen : function (rsa : PRSA; bits : TIdC_INT; e : PBIGNUM; cb : PBN_GENCB) : TIdC_INT; cdecl;
  end;
  {$EXTERNALSYM PRSA_METHOD}
  PRSA_METHOD = ^RSA_METHOD;

  {$EXTERNALSYM rsa_st}
  rsa_st = record
    // The first parameter is used to pickup errors where
    // this is passed instead of aEVP_PKEY, it is set to 0
    pad : TIdC_INT;
    version : TIdC_LONG;
    meth : PRSA_METHOD; // const RSA_METHOD *meth;
    // functional reference if 'meth' is ENGINE-provided
    engine : PENGINE;
    n : PBIGNUM;
    e : PBIGNUM;
    d : PBIGNUM;
    p : PBIGNUM;
    q : PBIGNUM;
    dmp1 : PBIGNUM;
    dmq1 : PBIGNUM;
    iqmp : PBIGNUM;
    // be careful using this if the RSA structure is shared
    ex_data : CRYPTO_EX_DATA;
    references : TIdC_INT;
    flags : TIdC_INT;
    // Used to cache montgomery values
    _method_mod_n : PBN_MONT_CTX;
    _method_mod_p : PBN_MONT_CTX;
    _method_mod_q : PBN_MONT_CTX;
    // all BIGNUM values are actually in the following data, if it is not NULL
    bignum_data : PIdAnsiChar;
    blinding : PBN_BLINDING;
    mt_blinding : PBN_BLINDING;
  end;
  {$EXTERNALSYM RSA}
  RSA = rsa_st;
  {$EXTERNALSYM Prsa_st}
  Prsa_st = PRSA;
  {$ENDIF}
  //dso.h
  {$EXTERNALSYM PDSO}
  PDSO = ^DSO;
///* The function prototype used for method functions (or caller-provided
// * callbacks) that transform filenames. They are passed a DSO structure pointer
// * (or NULL if they are to be used independantly of a DSO object) and a
// * filename to transform. They should either return NULL (if there is an error
// * condition) or a newly allocated string containing the transformed form that
// * the caller will need to free with OPENSSL_free() when done. */
  {$EXTERNALSYM DSO_NAME_CONVERTER_FUNC}
  DSO_NAME_CONVERTER_FUNC = function (dso : PDSO; para1 : PIdAnsiChar) : PIdAnsiChar cdecl;
  {$EXTERNALSYM PDSO_METHOD}
  PDSO_METHOD = ^DSO_METHOD;
  {$EXTERNALSYM DSO_FUNC_TYPE}
  DSO_FUNC_TYPE = procedure cdecl;
///* The function prototype used for method functions (or caller-provided
// * callbacks) that merge two file specifications. They are passed a
// * DSO structure pointer (or NULL if they are to be used independantly of
// * a DSO object) and two file specifications to merge. They should
// * either return NULL (if there is an error condition) or a newly allocated
// * string containing the result of merging that the caller will need
// * to free with OPENSSL_free() when done.
// * Here, merging means that bits and pieces are taken from each of the
// * file specifications and added together in whatever fashion that is
// * sensible for the DSO method in question.  The only rule that really
// * applies is that if the two specification contain pieces of the same
// * type, the copy from the first string takes priority.  One could see
// * it as the first specification is the one given by the user and the
// * second being a bunch of defaults to add on if they're missing in the
// * first. */
  {$EXTERNALSYM DSO_MERGER_FUNC}
  DSO_MERGER_FUNC = function (DSO : PDSO; para1, para2 : PIdAnsiChar) : PIdAnsiChar stdcall;
  {$EXTERNALSYM DSO_METHOD}
  DSO_METHOD = record
    name : PIdAnsiChar;
	///* Loads a shared library, NB: new DSO_METHODs must ensure that a
	// * successful load populates the loaded_filename field, and likewise a
	// * successful unload OPENSSL_frees and NULLs it out. */
	  dso_load : function (dso : PDSO) : TIdC_INT cdecl;
	//* Unloads a shared library */
    dso_unload : function (dso : PDSO) : TIdC_INT cdecl;
	//* Binds a variable */
    dso_bind_var : function (dso : PDSO; symname : PIdAnsiChar) : Pointer cdecl;
	///* Binds a function - assumes a return type of DSO_FUNC_TYPE.
	// * This should be cast to the real function prototype by the
	// * caller. Platforms that don't have compatible representations
	// * for different prototypes (this is possible within ANSI C)
	// * are highly unlikely to have shared libraries at all, let
	// * alone a DSO_METHOD implemented for them. */
    dso_bind_func : function (dso : PDSO; symname : PIdAnsiChar) : DSO_FUNC_TYPE stdcall;

	///* The generic (yuck) "ctrl()" function. NB: Negative return
	// * values (rather than zero) indicate errors. */
    dso_ctrl : function (dso : PDSO; cmd : TIdC_INT; larg : TIdC_LONG; parg : Pointer) : TIdC_LONG stdcall;
	///* The default DSO_METHOD-specific function for converting filenames to
	// * a canonical native form. */
	 dso_name_converter : DSO_NAME_CONVERTER_FUNC;
	///* The default DSO_METHOD-specific function for converting filenames to
	// * a canonical native form. */
	 dso_merger : DSO_MERGER_FUNC;

	//* [De]Initialisation handlers. */
   init : function (dso : PDSO) : TIdC_INT stdcall;
   finish : function (dso : PDSO) : TIdC_INT stdcall;

	//* Return pathname of the module containing location */
    pathbyaddr : function (addr : Pointer; path : PIdAnsiChar; sz : TIdC_INT) : TIdC_INT stdcall;
	//* Perform global symbol lookup, i.e. among *all* modules */
    globallookup : function (symname : PIdAnsiChar) : Pointer stdcall;
  end;
  {$EXTERNALSYM DSO}
  DSO = record
	  meth : PDSO_METHOD;
	///* Standard dlopen uses a (void *). Win32 uses a HANDLE. VMS
	// * doesn't use anything but will need to cache the filename
	// * for use in the dso_bind handler. All in all, let each
	// * method control its own destiny. "Handles" and such go in
	// * a STACK. */
	  meth_data : PSTACK_OF_POINTER;
	  references : TIdC_INT;
   	flags : TIdC_INT;
	///* For use by applications etc ... use this for your bits'n'pieces,
	// * don't touch meth_data! */
	  ex_data : CRYPTO_EX_DATA;
	///* If this callback function pointer is set to non-NULL, then it will
	// * be used in DSO_load() in place of meth->dso_name_converter. NB: This
	// * should normally set using DSO_set_name_converter(). */
	  name_converter : DSO_NAME_CONVERTER_FUNC;
	///* If this callback function pointer is set to non-NULL, then it will
	// * be used in DSO_load() in place of meth->dso_merger. NB: This
	// * should normally set using DSO_set_merger(). */
	  merger : DSO_MERGER_FUNC;
	///* This is populated with (a copy of) the platform-independant
	// * filename used for this DSO. */
	  filename : PIdAnsiChar;
	///* This is populated with (a copy of) the translated filename by which
	// * the DSO was actually loaded. It is NULL iff the DSO is not currently
	// * loaded. NB: This is here because the filename translation process
	// * may involve a callback being invoked more than once not only to
	// * convert to a platform-specific form, but also to try different
	// * filenames in the process of trying to perform a load. As such, this
	// * variable can be used to indicate (a) whether this DSO structure
	// * corresponds to a loaded library or not, and (b) the filename with
	// * which it was actually loaded. */
	  loaded_filename : PIdAnsiChar;
  end;
  //dh.h
  {$IFNDEF OPENSSL_NO_DH}
  {$EXTERNALSYM PDH}
  PDH = ^DH;
  {$EXTERNALSYM DH_METHOD}
  DH_METHOD = record
    name : PIdAnsiChar;
    // Methods here
    generate_key : function (dh : PDH) : TIdC_INT; cdecl;
    compute_key : function (key : PIdAnsiChar; const pub_key : PBIGNUM; dh : PDH) : TIdC_INT; cdecl;
    bn_mod_exp : function (const dh : PDH; r : PBIGNUM; const e : PBIGNUM;
      const p : PBIGNUM; const m : PBIGNUM; ctx : PBN_CTX;
      m_ctx : PBN_MONT_CTX) : TIdC_INT; cdecl;  // Can be null
    init : function (dh : PDH) : TIdC_INT; cdecl;
    finish : function (dh : PDH) : TIdC_INT; cdecl;
    flags : TIdC_INT;
    app_data : PIdAnsiChar;
    // If this is non-NULL, it will be used to generate parameters
    generate_params : function(dh : PDH; prime_len, generator : TIdC_INT; cb : PBN_GENCB) : TIdC_INT; cdecl;
  end;
  {$EXTERNALSYM dh_st}
  dh_st = record
    // The first parameter is used to pickup errors where
    // this is passed instead of aEVP_PKEY, it is set to 0
    pad : TIdC_INT;
    version : TIdC_LONG;
    meth : PRSA_METHOD;
    // functional reference if 'meth' is ENGINE-provided
    engine: PENGINE;
    n : PBIGNUM;
    e : PBIGNUM;
    d : PBIGNUM;
    p : PBIGNUM;
    q : PBIGNUM;
    dmp1 : PBIGNUM;
    dmq1 : PBIGNUM;
    iqmp : PBIGNUM;
    // be careful using this if the RSA structure is shared
    ex_data : CRYPTO_EX_DATA;
    references : TIdC_INT;
    flags : TIdC_INT;
    // Used to cache montgomery values
    _method_mod_n : BN_MONT_CTX;
    _method_mod_p : BN_MONT_CTX;
    _method_mod_q : BN_MONT_CTX;
    // all BIGNUM values are actually in the following data, if it is not NULL
    bignum_data : PIdAnsiChar;
    blinding : PBN_BLINDING;
    mt_blinding : PBN_BLINDING;
  end;
  {$EXTERNALSYM DH}
  DH = dh_st;
  {$EXTERNALSYM Pdh_st}
  Pdh_st = PDH;
  {$EXTERNALSYM PPDH}
  PPDH =^PDH;
  {$ENDIF}
  // dsa.h
  {$IFNDEF OPENSSL_NO_DSA}
    {$IFDEF OPENSSL_FIPS}
  {$EXTERNALSYM FIPS_DSA_SIZE_T}
  FIPS_DSA_SIZE_T = TIdC_int;
    {$ENDIF}
  {$EXTERNALSYM DSA_SIG}
  DSA_SIG = record
    r : PBIGNUM;
    s : PBIGNUM;
  end;
  {$EXTERNALSYM PDSA_SIG}
  PDSA_SIG = ^DSA_SIG;
    {$EXTERNALSYM PDSA}
  PDSA = ^DSA;
    {$EXTERNALSYM DSA_METHOD}
  DSA_METHOD = record
    name : PIdAnsiChar;
    dsa_do_sign : function (const dgst : PIdAnsiChar; dlen : TIdC_INT; dsa : PDSA) : PDSA_SIG; cdecl;
    dsa_sign_setup : function (dsa : PDSA; ctx_in : PBN_CTX; kinvp, rp : PPBN_CTX) : TIdC_INT; cdecl;
    dsa_do_verify : function(dgst : PIdAnsiChar; dgst_len : TIdC_INT;
      sig : PDSA_SIG; dsa : PDSA) : TIdC_INT; cdecl;
    dsa_mod_exp : function(dsa : PDSA; rr, a1, p1,
       a2, p2, m : PBIGNUM; ctx : PBN_CTX;
       in_mont : PBN_MONT_CTX) : TIdC_INT; cdecl;
    bn_mod_exp : function (dsa : PDSA; r, a : PBIGNUM; const p, m : PBIGNUM;
      ctx : PBN_CTX; m_ctx : PBN_CTX): TIdC_INT; cdecl; // Can be null
    init : function (dsa : PDSA) : TIdC_INT; cdecl;
    finish : function (dsa : PDSA) : TIdC_INT; cdecl;
    flags : TIdC_INT;
    app_data : PIdAnsiChar;
    // If this is non-NULL, it is used to generate DSA parameters
     dsa_paramgen : function (dsa : PDSA; bits : TIdC_INT; seed : PIdAnsiChar;
       seed_len : TIdC_INT; counter_ret : PIdC_INT; h_ret : PIdC_ULONG;
       cb : PBN_GENCB ) : TIdC_INT; cdecl;
    // If this is non-NULL, it is used to generate DSA keys
    dsa_keygen : function(dsa : PDSA) : TIdC_INT; cdecl;
  end;
    {$EXTERNALSYM PDSA_METHOD}
  PDSA_METHOD = ^DSA_METHOD;

  {$EXTERNALSYM dsa_st}
  dsa_st = record
    // This first variable is used to pick up errors where
    // a DSA is passed instead of of a EVP_PKEY
    pad : TIdC_INT;
    version : TIdC_LONG;
    write_params : TIdC_INT;
    p : PBIGNUM;
    q : PBIGNUM; // == 20
    g : PBIGNUM;
    pub_key : PBIGNUM;  // y public key
    priv_key : PBIGNUM; // x private key
    kinv : BIGNUM; // Signing pre-calc
    r : PBIGNUM;   // Signing pre-calc
    flags : TIdC_INT;
    // Normally used to cache montgomery values
    method_mont_p : PBN_MONT_CTX;
    references : TIdC_INT;
    ex_data : CRYPTO_EX_DATA;
    meth : PDSA_METHOD;
    // functional reference if 'meth' is ENGINE-provided
    engine : PENGINE;
  end;
 {$EXTERNALSYM DSA}
  DSA = dsa_st;
  {$EXTERNALSYM Pdsa_st}
  Pdsa_st = PDSA;
  {$EXTERNALSYM PPDSA}
  PPDSA = ^PDSA;
  {$ENDIF}
  // ec.h
  {$IFNDEF OPENSSL_NO_EC}
 // EC_METHOD = record
    //The fields are internal to OpenSSL, they are not listed in the header.
 // end;
  {$EXTERNALSYM PEC_METHOD}
  PEC_METHOD = Pointer;//^EC_METHOD;
    {$EXTERNALSYM PPEC_METHOD}
  PPEC_METHOD = ^PEC_METHOD;
 // EC_GROUP = record
    //The fields are internal to OpenSSL, they are not listed in the header.
//  end;
    {$EXTERNALSYM PEC_GROUP}
  PEC_GROUP = Pointer;//^EC_GROUP;
    {$EXTERNALSYM PPEC_GROUP}
  PPEC_GROUP = ^PEC_GROUP;
//  EC_POINT = record
    //The fields are internal to OpenSSL, they are not listed in the header.
//  end;
    {$EXTERNALSYM PEC_POINT}
  PEC_POINT = Pointer;//^EC_POINT;
  {$EXTERNALSYM PPEC_POINT}
  PPEC_POINT = ^PEC_POINT;
  {$EXTERNALSYM EC_builtin_curve}
  EC_builtin_curve = record
    nid : TIdC_INT;
    comment : PIdAnsiChar;
  end;
  {$EXTERNALSYM Pec_key_st}
  Pec_key_st = Pointer;
  {$EXTERNALSYM PEC_KEY}
  PEC_KEY = Pec_key_st;//^EC_KEY;
//  EC_KEY = record
    //The fields are internal to OpenSSL, they are not listed in the header.
//  end;

  {$EXTERNALSYM PPEC_KEY}
  PPEC_KEY = ^PEC_KEY;
  {$ENDIF}
  //evp.h
//  EVP_PBE_KEYGEN = record
//  end;
  {$EXTERNALSYM PEVP_PKEY_METHOD}
  PEVP_PKEY_METHOD = pointer;  //This is not defined publically in OpenSSL 1.0.0
  {$EXTERNALSYM PEVP_PKEY_CTX}
  PEVP_PKEY_CTX = pointer; //This is not defined publically in OpenSSL 1.0.0
  {$EXTERNALSYM PPEVP_PKEY_CTX}
  PPEVP_PKEY_CTX = ^PEVP_PKEY_CTX;
  {$EXTERNALSYM PEVP_PKEY_ASN1_METHOD}
  PEVP_PKEY_ASN1_METHOD = pointer;
  {$EXTERNALSYM PEVP_PBE_KEYGEN}
  PEVP_PBE_KEYGEN = Pointer;//^EVP_PBE_KEYGEN;
  //evp.h
  //struct evp_pkey_st
  {$EXTERNALSYM PPEVP_PKEY}
  PPEVP_PKEY = ^PEVP_PKEY;
  {$EXTERNALSYM PEVP_PKEY}
  PEVP_PKEY = ^EVP_PKEY;
  {$EXTERNALSYM EVP_PKEY_union}
  EVP_PKEY_union = record
    case byte of
      0: (ptr : PIdAnsiChar);

      {$IFNDEF OPENSSL_NO_RSA}
      1: (rsa : PRSA);    // RSA
      {$ENDIF}
      {$IFNDEF OPENSSL_NO_DSA}
      2: (dsa : PDSA);    // DSA
      {$ENDIF}
      {$IFNDEF OPENSSL_NO_DH}
      3: (dh :PDH);       // DH
      {$ENDIF}
      {$IFNDEF OPENSSL_NO_EC}
      4: (ec : PEC_KEY);  // ECC
      {$ENDIF}
  end;
  {$EXTERNALSYM Pevp_pkey_st}
  Pevp_pkey_st    = PEVP_PKEY;
  //this was moved from x509 section so that something here can compile.
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_ATTRIBUTE}
  STACK_OF_X509_ATTRIBUTE = record
    _stack: STACK;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_ATTRIBUTE}
  PSTACK_OF_X509_ATTRIBUTE = ^STACK_OF_X509_ATTRIBUTE;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_ATTRIBUTE}
  PSTACK_OF_X509_ATTRIBUTE = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PPSTACK_OF_X509_ATTRIBUTE}
  PPSTACK_OF_X509_ATTRIBUTE = ^PSTACK_OF_X509_ATTRIBUTE;
  {$EXTERNALSYM EVP_PKEY}
  EVP_PKEY = record
    _type : TIdC_INT;
    save_type : TIdC_INT;
    references : TIdC_INT;
    ameth : PEVP_PKEY_ASN1_METHOD;
    pkey : EVP_PKEY_union;
    attributes : PSTACK_OF_X509_ATTRIBUTE;  // [ 0 ]
  end;
  {$EXTERNALSYM PEVP_MD}
  PEVP_MD = ^EVP_MD;
  {$EXTERNALSYM PEVP_MD_CTX}
  PEVP_MD_CTX = ^EVP_MD_CTX;
  {$EXTERNALSYM PPEVP_MD_CTX}
  PPEVP_MD_CTX = ^PEVP_MD_CTX;
  {$EXTERNALSYM EVP_MD_CTX}
  EVP_MD_CTX = record
    digest : PEVP_MD;
    engine : PENGINE; // functional reference if 'digest' is ENGINE-provided
    flags : TIdC_ULONG;
    md_data : Pointer;
	//* Public key context for sign/verify */
	  pctx : PEVP_PKEY_CTX;
	//* Update function: usually copied from EVP_MD */
//	int (*update)(EVP_MD_CTX *ctx,const void *data,size_t count);
     update : function (ctx : PEVP_MD_CTX; const data : Pointer; count : size_t) : TIdC_INT cdecl;
  end;
  {$EXTERNALSYM EVP_MD_SVCTX}
  EVP_MD_SVCTX = record
	  mctx : PEVP_MD_CTX;
	  key : Pointer;
  end;
  {$EXTERNALSYM PEVP_MD_SVCTX}
  PEVP_MD_SVCTX = ^EVP_MD_SVCTX;
  {$EXTERNALSYM EVP_MD}
  EVP_MD = record
    _type : TIdC_INT;
    pkey_type : TIdC_INT;
    md_size : TIdC_INT;
    flags : TIdC_ULONG;
    init : function (ctx : PEVP_MD_CTX) : TIdC_INT; cdecl;
    update : function (ctx : PEVP_MD_CTX; data : Pointer; count : size_t):TIdC_INT; cdecl;
    _final : function (ctx : PEVP_MD_CTX; md : PIdAnsiChar) : TIdC_INT; cdecl;
    copy : function (_to : PEVP_MD_CTX; from : PEVP_MD_CTX ) : TIdC_INT; cdecl;
    cleanup : function(ctx : PEVP_MD_CTX) : TIdC_INT; cdecl;
    // FIXME: prototype these some day
    sign : function(_type : TIdC_INT; m : PIdAnsiChar; m_length : TIdC_UINT;
      sigret : PIdAnsiChar; siglen : TIdC_UINT; key : Pointer) : TIdC_INT; cdecl;
    verify : function(_type : TIdC_INT; m : PIdAnsiChar; m_length : PIdAnsiChar;
      sigbuf : PIdAnsiChar; siglen : TIdC_UINT; key : Pointer) : TIdC_INT; cdecl;
    required_pkey_type : array [0..4] of TIdC_INT; // EVP_PKEY_xxx
    block_size : TIdC_INT;
    ctx_size : TIdC_INT; // how big does the ctx->md_data need to be
  end;
  {$EXTERNALSYM PPEVP_CIPHER_CTX}
  PPEVP_CIPHER_CTX = ^PEVP_CIPHER_CTX;
  {$EXTERNALSYM PEVP_CIPHER_CTX}
  PEVP_CIPHER_CTX = ^EVP_CIPHER_CTX;
  {$EXTERNALSYM PEVP_CIPHER}
  PEVP_CIPHER = ^EVP_CIPHER;
  {$EXTERNALSYM EVP_CIPHER}
  EVP_CIPHER = record
    nid : TIdC_INT;
    block_size : TIdC_INT;
    key_len : TIdC_INT; // Default value for variable length ciphers
    iv_len : TIdC_INT;
    flags : TIdC_UINT; // Various flags
    init : function (ctx : PEVP_CIPHER_CTX; key : PIdAnsiChar; iv : PIdAnsiChar; enc : TIdC_INT): TIdC_INT; cdecl;
    do_cipher : function (ctx : PEVP_CIPHER_CTX; _out : PIdAnsiChar; _in : PIdAnsiChar; inl : size_t) : TIdC_INT; cdecl;
    cleanup : function (_para1 : PEVP_CIPHER_CTX): TIdC_INT; cdecl; // cleanup ctx
    ctx_size : TIdC_INT;  // how big ctx->cipher_data needs to be
    set_asn1_parameters : function (_para1 : PEVP_CIPHER_CTX;
      _para2 : PASN1_TYPE) : TIdC_INT; cdecl; // Populate a ASN1_TYPE with parameters
    get_asn1_parameters :function (_para1 : PEVP_CIPHER_CTX;
      _para2 :  PASN1_TYPE) : TIdC_INT; cdecl; // Get parameters from a ASN1_TYPE
    ctrl : function (_para1 : PEVP_CIPHER_CTX; _type : TIdC_INT; arg : TIdC_INT;
      ptr : Pointer): TIdC_INT; cdecl; // Miscellaneous operations
    app_data : Pointer;  // Application data
  end;
  {$EXTERNALSYM EVP_CIPHER_CTX}
  EVP_CIPHER_CTX = record
    cipher : PEVP_CIPHER;
    engine : PENGINE;   // functional reference if 'cipher' is ENGINE-provided
    encrypt: TIdC_INT;  // encrypt or decrypt
    buf_len : TIdC_INT; // number we have left
    oiv : array [0..EVP_MAX_IV_LENGTH-1] of TIdAnsiChar; // original iv
    iv : array [0..EVP_MAX_IV_LENGTH -1] of TIdAnsiChar; // working iv
    buf : array [0..EVP_MAX_BLOCK_LENGTH -1] of TIdAnsiChar; // saved partial block
    num : TIdC_INT;     // used by cfb/ofb mode
    app_data : Pointer; // application stuff
    key_len : TIdC_INT; // May change for variable length cipher
    flags : TIdC_ULONG;	// Various flags
    cipher_data : Pointer; // per EVP data
    final_used : TIdC_INT;
    block_mask : TIdC_INT;
    _final : array [0..EVP_MAX_BLOCK_LENGTH-1] of TIdAnsiChar; // possible final block
  end;
  {$EXTERNALSYM EVP_CIPHER_INFO}
  EVP_CIPHER_INFO = record
    cipher : PEVP_CIPHER;
    iv : array [0..EVP_MAX_IV_LENGTH -1] of TIdAnsiChar;
  end;
  {$EXTERNALSYM PEVP_CIPHER_INFO}
  PEVP_CIPHER_INFO = ^EVP_CIPHER_INFO;
  {$EXTERNALSYM EVP_ENCODE_CTX}
  EVP_ENCODE_CTX = record
    num : TIdC_INT;    // number saved in a partial encode/decode
    length: TIdC_INT;  // The length is either the output line length
                       // (in input bytes) or the shortest input line
                       // length that is ok.  Once decoding begins,
                       // the length is adjusted up each time a longer
                       // line is decoded
    enc_data:array [0..79] of TIdAnsiChar;
    line_num: TIdC_INT;	// number read on current line
    expect_nl: TIdC_INT;
  end;
  {$EXTERNALSYM PEVP_ENCODE_CTX}
  PEVP_ENCODE_CTX = ^EVP_ENCODE_CTX;
  //forward declarations from x509.h to make sure this compiles.
  {$NODEFINE PX509}
  PX509 = ^X509;
  {$EXTERNALSYM PPX509}
  PPX509 = ^PX509;
  {$EXTERNALSYM PX509_CRL}
  PX509_CRL = ^X509_CRL;
  {$NODEFINE PX509_NAME}
  PX509_NAME = ^X509_NAME;
  {$EXTERNALSYM PX509_NAME_ENTRY}
  PX509_NAME_ENTRY = ^X509_NAME_ENTRY;
  {$EXTERNALSYM PX509_REQ}
  PX509_REQ = ^X509_REQ;
  {$EXTERNALSYM PX509_REQ_INFO}
  PX509_REQ_INFO = ^X509_REQ_INFO;
  {$EXTERNALSYM PPX509_REQ_INFO}
  PPX509_REQ_INFO = ^PX509_REQ_INFO;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_NAME_ENTRY}
  STACK_OF_X509_NAME_ENTRY = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_NAME_ENTRY}
  PSTACK_OF_X509_NAME_ENTRY = ^STACK_OF_X509_NAME_ENTRY;
  {$EXTERNALSYM STACK_OF_X509_REVOKED}
  STACK_OF_X509_REVOKED = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_REVOKED}
  PSTACK_OF_X509_REVOKED = ^STACK_OF_X509_REVOKED;
  {$EXTERNALSYM STACK_OF_X509_NAME}
  STACK_OF_X509_NAME = record
    _stack: STACK;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_NAME}
  PSTACK_OF_X509_NAME = ^STACK_OF_X509_NAME;
  {$ELSE}
  {$EXTERNALSYM PSTACK_OF_X509_NAME_ENTRY}
  PSTACK_OF_X509_NAME_ENTRY = PSTACK;
  {$EXTERNALSYM PSTACK_OF_X509_REVOKED}
  PSTACK_OF_X509_REVOKED = PSTACK;
  {$EXTERNALSYM PSTACK_OF_X509_NAME}
  PSTACK_OF_X509_NAME = PSTACK;
  {$ENDIF}
    {$EXTERNALSYM PPSTACK_OF_X509_REVOKED}
  PPSTACK_OF_X509_REVOKED = ^PSTACK_OF_X509_REVOKED;
  {$EXTERNALSYM PPX509_NAME}
  PPX509_NAME =^PX509_NAME;
  {$EXTERNALSYM PPSTACK_OF_X509_NAME}
  PPSTACK_OF_X509_NAME = ^PSTACK_OF_X509_NAME;
  //pcy_int.h
  //Note that anything other than PSTACK should be undefined since the record
  //members aren't exposed in the headers.
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_POLICY_DATA}
  STACK_OF_X509_POLICY_DATA = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_POLICY_DATA}
  PSTACK_OF_X509_POLICY_DATA = ^STACK_OF_X509_POLICY_DATA;
  {$EXTERNALSYM STACK_OF_X509_POLICY_REF}
  STACK_OF_X509_POLICY_REF = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_POLICY_REF}
  PSTACK_OF_X509_POLICY_REF = ^STACK_OF_X509_POLICY_DATA;
  {$EXTERNALSYM STACK_OF_X509_POLICY_NODE}
  STACK_OF_X509_POLICY_NODE = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_POLICY_NODE}
  PSTACK_OF_X509_POLICY_NODE = ^STACK_OF_X509_POLICY_NODE;
  {$EXTERNALSYM STACK_OF_POLICYQUALINFO}
  STACK_OF_POLICYQUALINFO = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_POLICYQUALINFO}
  PSTACK_OF_POLICYQUALINFO = ^STACK_OF_POLICYQUALINFO;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_POLICY_DATA}
  PSTACK_OF_X509_POLICY_DATA = PSTACK;
  {$EXTERNALSYM PSTACK_OF_X509_POLICY_REF}
  PSTACK_OF_X509_POLICY_REF = PSTACK;
  {$EXTERNALSYM PSTACK_OF_X509_POLICY_NODE}
  PSTACK_OF_X509_POLICY_NODE = PSTACK;
  {$EXTERNALSYM PSTACK_OF_POLICYQUALINFO}
  PSTACK_OF_POLICYQUALINFO = PSTACK;
  {$ENDIF}
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509V3_EXT_METHOD}
  STACK_OF_X509V3_EXT_METHOD = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_X509V3_EXT_METHOD}
  PSTACK_OF_X509V3_EXT_METHOD = ^STACK_OF_X509V3_EXT_METHOD;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509V3_EXT_METHOD}
  PSTACK_OF_X509V3_EXT_METHOD = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PPSTACK_OF_X509V3_EXT_METHOD}
  PPSTACK_OF_X509V3_EXT_METHOD = ^PSTACK_OF_X509V3_EXT_METHOD;
  {$IFDEF DEBUF_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509}
  STACK_OF_X509 = record
    _stack: STACK;
  end;
  {$EXTERNALSYM PSTACK_OF_X509}
  PSTACK_OF_X509 = ^STACK_OF_X509;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509}
  PSTACK_OF_X509 = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PPSTACK_OF_X509}
  PPSTACK_OF_X509 = ^PSTACK_OF_X509;
  //fips.h
  //engiene.h
  {$IFNDEF OPENSSL_NO_ENGINE}
  //* Generic function pointer */
//typedef int (*ENGINE_GEN_FUNC_PTR)(void);
  {$EXTERNALSYM ENGINE_GEN_FUNC_PTR}
  ENGINE_GEN_FUNC_PTR = function : TIdC_INT; cdecl;
//  typedef int (*ENGINE_GEN_INT_FUNC_PTR)(ENGINE *);
  {$EXTERNALSYM ENGINE_GEN_INT_FUNC_PTR}
  ENGINE_GEN_INT_FUNC_PTR = function(Para1 : PENGINE) : TIdC_INT; cdecl;
//typedef int (*ENGINE_CTRL_FUNC_PTR)(ENGINE *, int, long, void *, void (*f)(void));
  {$EXTERNALSYM ENGINE_CTRL_FUNC_PTR_F}
  ENGINE_CTRL_FUNC_PTR_F = procedure; cdecl;
  {$EXTERNALSYM ENGINE_CTRL_FUNC_PTR}
  ENGINE_CTRL_FUNC_PTR = function(Para1 : PENGINE; Para2 : TIdC_INT;
    Para3 : TIdC_LONG; Para4 : Pointer; f : ENGINE_CTRL_FUNC_PTR_F) : TIdC_Int; cdecl;
//typedef EVP_PKEY * (*ENGINE_LOAD_KEY_PTR)(ENGINE *, const char *,
//	UI_METHOD *ui_method, void *callback_data);
  {$EXTERNALSYM ENGINE_LOAD_KEY_PTR}
  ENGINE_LOAD_KEY_PTR = function(Para1 : PENGINE; Para2 : PIdAnsiChar;
    ui_method : PUI_METHOD; callback_data : Pointer) : PEVP_PKEY; cdecl;
//typedef int (*ENGINE_SSL_CLIENT_CERT_PTR)(ENGINE *, SSL *ssl,
//	STACK_OF(X509_NAME) *ca_dn, X509 **pcert, EVP_PKEY **pkey,
//	STACK_OF(X509) **pother, UI_METHOD *ui_method, void *callback_data);
  {$EXTERNALSYM ENGINE_SSL_CLIENT_CERT_PTR}
  ENGINE_SSL_CLIENT_CERT_PTR = function(Para1 : PENGINE; ssl : PSSL;
    ca_dn : PSTACK_OF_X509_NAME; var pcert : PX509; var pkey : PEVP_PKEY;
    var pother : PSTACK_OF_X509; ui_method : PUI_METHOD; callback_data : Pointer) : TIdC_Int; cdecl;
//typedef int (*ENGINE_CIPHERS_PTR)(ENGINE *, const EVP_CIPHER **, const int **, int);
  {$EXTERNALSYM ENGINE_CIPHERS_PTR}
  ENGINE_CIPHERS_PTR = function(para1 : PENGINE; var para2 : PEVP_CIPHER; var para3 : PIdC_Int; para4 : TIdC_Int) : TIdC_Int; cdecl;
//typedef int (*ENGINE_DIGESTS_PTR)(ENGINE *, const EVP_MD **, const int **, int);
  {$EXTERNALSYM ENGINE_DIGESTS_PTR}
  ENGINE_DIGESTS_PTR = function(para1 : PENGINE; var Para2 : PEVP_MD; var Para3 : PIdC_INT; para4 : TIdC_INT) : TIdC_INT cdecl;
//typedef int (*ENGINE_PKEY_METHS_PTR)(ENGINE *, EVP_PKEY_METHOD **, const int **, int);
  {$EXTERNALSYM ENGINE_PKEY_METHS_PTR}
  ENGINE_PKEY_METHS_PTR = function(para1 : PENGINE; var Para2 : PEVP_PKEY_METHOD; var Para3 : PIdC_INT; para4 : TIdC_INT) : TIdC_INT cdecl;
//typedef int (*ENGINE_PKEY_ASN1_METHS_PTR)(ENGINE *, EVP_PKEY_ASN1_METHOD **, const int **, int);
  {$EXTERNALSYM ENGINE_PKEY_ASN1_METHS_PTR}
  ENGINE_PKEY_ASN1_METHS_PTR = function(para1 : PENGINE; var Para2 : PEVP_PKEY_ASN1_METHOD; var Para3 : PIdC_INT; para4 : TIdC_INT) : TIdC_INT cdecl;
{
/* When compiling an ENGINE entirely as an external shared library, loadable by
 * the "dynamic" ENGINE, these types are needed. The 'dynamic_fns' structure
 * type provides the calling application's (or library's) error functionality
 * and memory management function pointers to the loaded library. These should
 * be used/set in the loaded library code so that the loading application's
 * 'state' will be used/changed in all operations. The 'static_state' pointer
 * allows the loaded library to know if it shares the same static data as the
 * calling application (or library), and thus whether these callbacks need to be
 * set or not. */
}
//typedef void *(*dyn_MEM_malloc_cb)(size_t);
  {$EXTERNALSYM dyn_MEM_malloc_cb}
  dyn_MEM_malloc_cb = function(para1 : size_t) : Pointer; cdecl;
//typedef void *(*dyn_MEM_realloc_cb)(void *, size_t);
  {$EXTERNALSYM dyn_MEM_realloc_cb}
  dyn_MEM_realloc_cb = function (para1 : Pointer; para2 : size_t): Pointer; cdecl;
//typedef void (*dyn_MEM_free_cb)(void *);
  {$EXTERNALSYM dyn_MEM_free_cb}
  dyn_MEM_free_cb = procedure (para1 : Pointer); cdecl;
  {$EXTERNALSYM dynamic_MEM_fns}
  dynamic_MEM_fns = record
    malloc_cb : dyn_MEM_malloc_cb;
    realloc_cb : dyn_MEM_realloc_cb;
    free_cb : dyn_MEM_free_cb;
  end;
///* FIXME: Perhaps the memory and locking code (crypto.h) should declare and use
// * these types so we (and any other dependant code) can simplify a bit?? */
//typedef void (*dyn_lock_locking_cb)(int,int,const char *,int);
  {$EXTERNALSYM dyn_lock_locking_cb}
  dyn_lock_locking_cb = procedure (para1, para2 : TIdC_INT; para3 : PIdAnsiChar; para4 : TIdC_INT); cdecl;
//typedef int (*dyn_lock_add_lock_cb)(int*,int,int,const char *,int);
  {$EXTERNALSYM dyn_lock_add_lock_cb}
  dyn_lock_add_lock_cb = function (var para1 : TIdC_INT; para2, para3 : TIdC_INT; para4 : PIdAnsiChar; para5 : TIdC_INT) : TIdC_INT; cdecl;
//typedef struct CRYPTO_dynlock_value *(*dyn_dynlock_create_cb)(
//						const char *,int);
  {$EXTERNALSYM dyn_dynlock_create_cb}
  dyn_dynlock_create_cb = function (para1 : PIdAnsiChar; para2 : TIdC_INT) : PCRYPTO_dynlock_value; cdecl;
//typedef void (*dyn_dynlock_lock_cb)(int,struct CRYPTO_dynlock_value *,
//						const char *,int);
  {$EXTERNALSYM dyn_dynlock_lock_cb}
  dyn_dynlock_lock_cb = procedure (para1 : TIdC_INT; para2 : PCRYPTO_dynlock_value); cdecl;
//typedef void (*dyn_dynlock_destroy_cb)(struct CRYPTO_dynlock_value *,
//						const char *,int);
  {$EXTERNALSYM dyn_dynlock_destroy_cb}
  dyn_dynlock_destroy_cb = procedure(para1 : PCRYPTO_dynlock_value; para2 : PIdAnsiChar; para3 : TIdC_INT); cdecl;
//typedef struct st_dynamic_LOCK_fns {
//	dyn_lock_locking_cb			lock_locking_cb;
//	dyn_lock_add_lock_cb			lock_add_lock_cb;
//	dyn_dynlock_create_cb			dynlock_create_cb;
//	dyn_dynlock_lock_cb			dynlock_lock_cb;
//	dyn_dynlock_destroy_cb			dynlock_destroy_cb;
//	} dynamic_LOCK_fns;
  {$EXTERNALSYM dynamic_LOCK_fns}
   dynamic_LOCK_fns = record
     lock_locking_cb : dyn_lock_locking_cb;
     lock_add_lock_cb : dyn_lock_add_lock_cb;
     dynlock_create_cb : dyn_dynlock_create_cb;
     dynlock_lock_cb : dyn_dynlock_lock_cb;
     dynlock_destroy_cb : dyn_dynlock_destroy_cb;
   end;
//* The top-level structure */
  {$EXTERNALSYM dynamic_fns}
   dynamic_fns = record
     static_state : Pointer;
     err_fns : PERR_FNS;
     ex_data_fns : PCRYPTO_EX_DATA_IMPL;
     mem_fns : dynamic_MEM_fns;
     lock_fns : dynamic_LOCK_fns;
   end;
// typedef unsigned long (*dynamic_v_check_fn)(unsigned long ossl_version);
  {$EXTERNALSYM dynamic_v_check_fn}
  dynamic_v_check_fn = function(ossl_version : TIdC_ULONG) : TIdC_ULONG; cdecl;
//typedef int (*dynamic_bind_engine)(ENGINE *e, const char *id,
//    const dynamic_fns *fns);
  {$EXTERNALSYM dynamic_bind_engine}
  dynamic_bind_engine = function(e : PENGINE; id : PIdAnsiChar; fns : dynamic_fns) : TIdC_INT; cdecl;
  {$ENDIF}
  //ecdsa.h
  {$IFNDEF OPENSSL_NO_ECDSA}
  {$EXTERNALSYM ECDSA_SIG}
  ECDSA_SIG = record
    r : PBIGNUM;
    s : PBIGNUM;
  end;
  {$EXTERNALSYM PECDSA_SIG}
  PECDSA_SIG = ^ECDSA_SIG;
  {$EXTERNALSYM PPECDSA_SIG}
  PPECDSA_SIG = ^PECDSA_SIG;
//  ECDH_METHOD = record
    //defined interally, not through the header so use function to access members
 // end;
  {$EXTERNALSYM PECDH_METHOD}
  PECDH_METHOD = Pointer;//^ECDH_METHOD;
  {$EXTERNALSYM PPECDH_METHOD}
  PPECDH_METHOD = ^PECDH_METHOD;
  {$ENDIF}
  //ecdh.h
  //aes.h
 {$IFNDEF OPENSSL_NO_AES}
   {$IFDEF OPENSSL_FIPS}
  {$EXTERNALSYM FIPS_AES_SIZE_T}
  FIPS_AES_SIZE_T	= TIdC_INT;
  {$ENDIF}
  //OpenSSL Developer's note
  // This should be a hidden type, but EVP requires that the size be known
  {$EXTERNALSYM AES_KEY}
  AES_KEY = record
    rd_key: array[0..(4 *(AES_MAXNR + 1)-1)] of TIdC_UINT;
    rounds : TIdC_INT;
  end;
  {$EXTERNALSYM PAES_KEY}
  PAES_KEY = ^AES_KEY;
  {$EXTERNALSYM PPAES_KEY}
  PPAES_KEY = ^PAES_KEY;
  {$ENDIF}
  //seed.h
  {$IFNDEF OPENSSL_NO_SEED}
  {$EXTERNALSYM SEED_KEY_SCHEDULE}
  SEED_KEY_SCHEDULE = record
    {$IFDEF SEED_LONG}
    data : array [0..(32 -1)] of TIdC_ULONG ;
    {$ELSE}
    data : array[0..(32-1)] of TIdC_UINT;
    {$ENDIF}
   end;
  {$EXTERNALSYM PSEED_KEY_SCHEDULE}
  PSEED_KEY_SCHEDULE = ^SEED_KEY_SCHEDULE;
  {$ENDIF}
  //lhash.h
  {$EXTERNALSYM PLHASH_NODE}
  PLHASH_NODE = ^LHASH_NODE;
  {$EXTERNALSYM PPLHASH_NODE}
  PPLHASH_NODE = ^PLHASH_NODE;
  {$EXTERNALSYM LHASH_NODE}
  LHASH_NODE = record
    data : Pointer;
    next : PLHASH_NODE;
    {$IFNDEF OPENSSL_NO_HASH_COMP}
    hash : TIdC_ULONG;
    {$ENDIF}
  end;
  {$EXTERNALSYM LHASH_COMP_FN_TYPE}
  LHASH_COMP_FN_TYPE = function (const p1,p2 : Pointer) : TIdC_INT; cdecl;
  {$EXTERNALSYM PLHASH_COMP_FN_TYPE}
  PLHASH_COMP_FN_TYPE = ^LHASH_COMP_FN_TYPE;
  {$EXTERNALSYM LHASH_HASH_FN_TYPE}
  LHASH_HASH_FN_TYPE = function(const p1 : Pointer) : TIdC_ULONG; cdecl;
  {$EXTERNALSYM LHASH_DOALL_FN_TYPE}
  LHASH_DOALL_FN_TYPE = procedure(p1 : Pointer); cdecl;
  {$EXTERNALSYM LHASH_DOALL_ARG_FN_TYPE}
  LHASH_DOALL_ARG_FN_TYPE = procedure(p1, p2 : Pointer); cdecl;
  {$EXTERNALSYM LHASH}
  LHASH = record
    b : PPLHASH_NODE;
    comp : LHASH_COMP_FN_TYPE;
    hash : LHASH_HASH_FN_TYPE;
    num_nodes : TIdC_UINT;
    num_alloc_nodes : TIdC_UINT;
    p : TIdC_UINT;
    pmax : TIdC_UINT;
    up_load : TIdC_ULONG; // load times 256
    down_load : TIdC_ULONG; // load times 256
    num_items : TIdC_ULONG;
    num_expands : TIdC_ULONG;
    num_expand_reallocs : TIdC_ULONG;
    num_contracts : TIdC_ULONG;
    num_contract_reallocs : TIdC_ULONG;
    num_hash_calls : TIdC_ULONG;
    num_comp_calls : TIdC_ULONG;
    num_insert : TIdC_ULONG;
    num_replace : TIdC_ULONG;
    num_delete : TIdC_ULONG;
    num_no_delete : TIdC_ULONG;
    num_retrieve : TIdC_ULONG;
    num_retrieve_miss : TIdC_ULONG;
    num_hash_comps : TIdC_ULONG;
    error : TIdC_INT;
  end;
  {$EXTERNALSYM PLHASH}
  PLHASH = ^LHASH;
  //conf.h
  {$EXTERNALSYM CONF_VALUE}
  CONF_VALUE = record
    section : PIdAnsiChar;
    name : PIdAnsiChar;
    value : PIdAnsiChar;
  end;
  {$EXTERNALSYM PCONF_VALUE}
  PCONF_VALUE = ^CONF_VALUE;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_CONF_VALUE}
  STACK_OF_CONF_VALUE = record
    stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_CONF_VALUE}
  PSTACK_OF_CONF_VALUE = ^STACK_OF_CONF_VALUE;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_CONF_VALUE}
  PSTACK_OF_CONF_VALUE = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM BIT_STRING_BITNAME}
  //* This is used to contain a list of bit names */
  BIT_STRING_BITNAME = record
    bitnum : TIdC_INT;
    lname : PIdAnsiChar;
    sname : PIdAnsiChar;
  end;
  {$EXTERNALSYM PBIT_STRING_BITNAME}
  PBIT_STRING_BITNAME = ^BIT_STRING_BITNAME;
  {$EXTERNALSYM PPBIT_STRING_BITNAME}
  PPBIT_STRING_BITNAME = ^PBIT_STRING_BITNAME;
  {$EXTERNALSYM buf_mem_st}
  buf_mem_st = record
    length : TIdC_INT; // current number of bytes
    data : PIdAnsiChar;
    max: TIdC_INT; // size of buffer
  end;
  {$EXTERNALSYM BUF_MEM}
  BUF_MEM = buf_mem_st;
  {$EXTERNALSYM PBUF_MEM}
  PBUF_MEM = ^BUF_MEM;
  {$EXTERNALSYM PPBUF_MEM}
  PPBUF_MEM = ^PBUF_MEM;
  {$EXTERNALSYM PFILE}
  PFILE = Pointer;
  //asn1t.h
  {$EXTERNALSYM ASN1_TEMPLATE}
  ASN1_TEMPLATE = record
    flags : TIdC_ULONG;   // Various flags
    tag : TIdC_LONG;      // tag, not used if no tagging
    offset : TIdC_ULONG;  // Offset of this field in structure
    {$IFNDEF NO_ASN1_FIELD_NAMES}
    field_name : PIdAnsiChar;   // Field name
    {$ENDIF}
    item : PASN1_ITEM_EXP; // Relevant ASN1_ITEM or ASN1_ADB
  end;
  {$EXTERNALSYM PASN1_TEMPLATE}
  PASN1_TEMPLATE = ^ASN1_TEMPLATE;
  {$EXTERNALSYM ASN1_ITEM}
  ASN1_ITEM = record
    itype : Char;                 // The item type, primitive, SEQUENCE, CHOICE or extern
    utype : TIdC_LONG;            // underlying type
    templates : PASN1_TEMPLATE;   // If SEQUENCE or CHOICE this contains the contents
    tcount : TIdC_LONG;           // Number of templates if SEQUENCE or CHOICE
    funcs : Pointer;              // functions that handle this type
    size : TIdC_LONG;             // Structure size (usually)
    {$IFNDEF NO_ASN1_FIELD_NAMES}
    sname : PIdAnsiChar;	  // Structure name
    {$ENDIF}
  end;
  {$EXTERNALSYM PASN1_PCTX}
  PASN1_PCTX = Pointer;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_ASN1_ADB_TABLE}
  STACK_OF_ASN1_ADB_TABLE = record
    stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_ASN1_ADB_TABLE}
  PSTACK_OF_ASN1_ADB_TABLE = ^STACK_OF_ASN1_ADB_TABLE;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_ASN1_ADB_TABLE}
  PSTACK_OF_ASN1_ADB_TABLE = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PPSTACK_OF_ASN1_ADB_TABLE}
  PPSTACK_OF_ASN1_ADB_TABLE = ^PSTACK_OF_ASN1_ADB_TABLE;
  {$EXTERNALSYM PASN1_ADB_TABLE}
  PASN1_ADB_TABLE = ^ASN1_ADB_TABLE;
  {$EXTERNALSYM PASN1_ADB}
  PASN1_ADB = ^ASN1_ADB;
  {$EXTERNALSYM ASN1_ADB}
  ASN1_ADB = record
    flags : TIdC_ULONG;          // Various flags
    offset : TIdC_ULONG;         // Offset of selector field
    app_items : PPSTACK_OF_ASN1_ADB_TABLE; // Application defined items
    tbl : PASN1_ADB_TABLE;       // Table of possible types
    tblcount : TIdC_LONG;        // Number of entries in tbl
    default_tt : PASN1_TEMPLATE; // Type to use if no match
    null_tt : PASN1_TEMPLATE;    // Type to use if selector is NULL
  end;
  {$EXTERNALSYM ASN1_ADB_TABLE}
  ASN1_ADB_TABLE = record
    flags : TIdC_LONG;            // Various flags
    offset : TIdC_LONG;	          // Offset of selector field
    app_items : PPSTACK_OF_ASN1_ADB_TABLE; // Application defined items
    tbl : PASN1_ADB_TABLE;        // Table of possible types
    tblcount : TIdC_LONG;         // Number of entries in tbl
    default_tt : PASN1_TEMPLATE;  // Type to use if no match
    null_tt : PASN1_TEMPLATE;     // Type to use if selector is NULL
  end;
  {$EXTERNALSYM PASN1_TLC}
  PASN1_TLC = ^ASN1_TLC;
  {$EXTERNALSYM ASN1_TLC}
  ASN1_TLC = record
	  valid : Byte;	//* Values below are valid */
	  ret : TIdC_INT;	//* return value */
	  plen : TIdC_LONG;	//* length */
	  ptag : TIdC_INT;	//* class value */
	  pclass : TIdC_INT;	//* class value */
	  hdrlen : TIdC_INT;	//* header length */
  end;
  ///* Typedefs for ASN1 function pointers */
  {$EXTERNALSYM ASN1_new_func}
  ASN1_new_func = function : PASN1_VALUE; cdecl;
  {$EXTERNALSYM ASN1_free_func}
  ASN1_free_func = procedure (a : PASN1_VALUE); cdecl;
//  typedef ASN1_VALUE * ASN1_d2i_func(ASN1_VALUE **a, const unsigned char ** in, long length);
  {$EXTERNALSYM ASN1_d2i_func}
  ASN1_d2i_func = function (a : PASN1_VALUE; _in : PPByte; length : TIdC_LONG ) : PASN1_VALUE; cdecl;
 // typedef int ASN1_i2d_func(ASN1_VALUE * a, unsigned char **in);
  {$EXTERNALSYM ASN1_i2d_func}
  ASN1_i2d_func = function (a : PASN1_VALUE; _in : PPByte)  : TIdC_INT; cdecl;
//  typedef int ASN1_ex_d2i(ASN1_VALUE **pval, const unsigned char **in, long len, const ASN1_ITEM *it,
//					int tag, int aclass, char opt, ASN1_TLC *ctx);
  {$EXTERNALSYM ASN1_ex_d2i}
  ASN1_ex_d2i = function(pval : PPASN1_VALUE; _in : PPByte; len : TIdC_LONG;
    it : PASN1_ITEM; tag, aclass : TIdC_INT; opt : Byte;
    ctx : PASN1_TLC) : TIdC_INT; cdecl;
//typedef int ASN1_ex_i2d(ASN1_VALUE **pval, unsigned char **out, const ASN1_ITEM *it, int tag, int aclass);
  {$EXTERNALSYM ASN1_ex_i2d}
  ASN1_ex_i2d = function(pval : PPASN1_VALUE; _out : PPByte;  it : PASN1_ITEM; tag, aclass : TIdC_INT) : TIdC_INT; cdecl;
//typedef int ASN1_ex_new_func(ASN1_VALUE **pval, const ASN1_ITEM *it);
  {$EXTERNALSYM ASN1_ex_new_func}
  ASN1_ex_new_func = function(pval : PPASN1_VALUE; it : PASN1_ITEM) : TIdC_INT; cdecl;
//typedef void ASN1_ex_free_func(ASN1_VALUE **pval, const ASN1_ITEM *it);
  {$EXTERNALSYM ASN1_ex_free_func}
  ASN1_ex_free_func = procedure( pval : PPASN1_VALUE; it : PASN1_ITEM); cdecl;
//typedef int ASN1_primitive_i2c(ASN1_VALUE **pval, unsigned char *cont, int *putype, const ASN1_ITEM *it);
  {$EXTERNALSYM ASN1_primitive_i2c}
  ASN1_primitive_i2c = function (pval : PPASN1_VALUE; cont : PByte; putype : PIdC_INT; it : PASN1_ITEM ) : TIdC_INT; cdecl;
//typedef int ASN1_primitive_c2i(ASN1_VALUE **pval, const unsigned char *cont, int len, int utype, char *free_cont, const ASN1_ITEM *it);
  {$EXTERNALSYM ASN1_primitive_c2i}
  ASN1_primitive_c2i = function (pval : PPASN1_VALUE; cont : PByte; len, utype : TIdC_INT; free_cont : PByte; it: PASN1_ITEM) : TIdC_INT; cdecl;
  ///* end typedefs
  {$EXTERNALSYM ASN1_COMPAT_FUNCS}
  ASN1_COMPAT_FUNCS = record
	  asn1_new : ASN1_new_func;
	  asn1_free : ASN1_free_func;
	  asn1_d2i : ASN1_d2i_func;
	 asn1_i2d : ASN1_i2d_func;
  end;
  {$EXTERNALSYM PASN1_COMPAT_FUNCS}
  PASN1_COMPAT_FUNCS = ^ASN1_COMPAT_FUNCS;
  {$EXTERNALSYM ASN1_EXTERN_FUNCS}
  ASN1_EXTERN_FUNCS = record
	  app_data : Pointer;
    asn1_ex_new : ASN1_ex_new_func; //	ASN1_ex_new_func *asn1_ex_new;
    asn1_ex_free : ASN1_ex_free_func; //	ASN1_ex_free_func *asn1_ex_free;
    asn1_ex_clear: ASN1_ex_free_func;//	ASN1_ex_free_func *asn1_ex_clear;
    asn1_ex_d2i : ASN1_ex_d2i;//	ASN1_ex_d2i *asn1_ex_d2i;
    asn1_ex_i2d : ASN1_ex_i2d; //	ASN1_ex_i2d *asn1_ex_i2d;
  end;
  {$EXTERNALSYM PASN1_EXTERN_FUNCS}
  PASN1_EXTERN_FUNCS = ^ASN1_EXTERN_FUNCS;
  {$EXTERNALSYM ASN1_PRIMITIVE_FUNCS}
  ASN1_PRIMITIVE_FUNCS = record
    app_data : Pointer;
    flags : TIdC_ULONG;
//	ASN1_ex_new_func *prim_new;
    prim_new : ASN1_ex_new_func;
//	ASN1_ex_free_func *prim_free;
    prim_free : ASN1_ex_free_func;
//	ASN1_ex_free_func *prim_clear;
    prim_clear : ASN1_ex_free_func;
//	ASN1_primitive_c2i *prim_c2i;
    prim_c2i : ASN1_primitive_c2i;
//	ASN1_primitive_i2c *prim_i2c;
    prim_i2c : ASN1_primitive_i2c;
  end;
  {$EXTERNALSYM PASN1_PRIMITIVE_FUNCS}
  PASN1_PRIMITIVE_FUNCS = ^ASN1_PRIMITIVE_FUNCS;
//typedef int ASN1_aux_cb(int operation, ASN1_VALUE **in, const ASN1_ITEM *it);
  {$EXTERNALSYM ASN1_aux_cb}
  ASN1_aux_cb = function (operation : TIdC_INT; _in : PPASN1_VALUE; it : PASN1_ITEM) : TIdC_INT; cdecl;
  {$EXTERNALSYM ASN1_AUX}
  ASN1_AUX = record
    app_data : Pointer;
    flags : TIdC_INT;
    ref_offset : TIdC_INT;		//* Offset of reference value */
    ref_lock : TIdC_INT;		//* Lock type to use */
    asn1_cb : ASN1_aux_cb; //ASN1_aux_cb *asn1_cb;
    enc_offset : TIdC_INT;		//* Offset of ASN1_ENCODING structure */
  end;
  {$EXTERNALSYM PASN1_AUX}
  PASN1_AUX = ^ASN1_AUX;
  //hmac.h
  //This has to come after the EVP definitions
  {$IFNDEF OPENSSL_NO_HMAC}
  {$EXTERNALSYM HMAC_CTX}
  HMAC_CTX = record
    md : PEVP_MD;
    md_ctx : EVP_MD_CTX;
    i_ctx : EVP_MD_CTX;
    o_ctx : EVP_MD_CTX;
    key_length : TIdC_UINT;
    key : array[0..(HMAC_MAX_MD_CBLOCK - 1)] of byte;
  end;
  {$EXTERNALSYM PHMAC_CTX}
  PHMAC_CTX = ^HMAC_CTX;
  {$EXTERNALSYM PPHMAC_CTX}
  PPHMAC_CTX = ^PHMAC_CTX;
  {$ENDIF}
 // X509_POLICY_DATA = record
 // end;
  {$EXTERNALSYM PX509_POLICY_DATA}
  PX509_POLICY_DATA = Pointer;//^X509_POLICY_DATA;
 // X509_POLICY_REF = record
 // end;
   {$EXTERNALSYM PX509_POLICY_REF}
  PX509_POLICY_REF = Pointer;//^X509_POLICY_REF;
 // X509_POLICY_CACHE = record
 // end;
   {$EXTERNALSYM PX509_POLICY_CACHE}
  PX509_POLICY_CACHE = Pointer; //^X509_POLICY_CACHE;
  //x509v3.h
   {$EXTERNALSYM PPX509_NAME_ENTRY}
  PPX509_NAME_ENTRY = ^PX509_NAME_ENTRY;
  //forward declarations
   {$EXTERNALSYM PV3_EXT_METHOD}
  PV3_EXT_METHOD = ^V3_EXT_METHOD;
   {$EXTERNALSYM PV3_EXT_CTX}
  PV3_EXT_CTX = ^V3_EXT_CTX;
  //
  {$EXTERNALSYM X509V3_EXT_NEW}
  X509V3_EXT_NEW = function: Pointer; cdecl;
  {$EXTERNALSYM X509V3_EXT_FREE}
  X509V3_EXT_FREE = procedure(_para1 : Pointer); cdecl;
  {$EXTERNALSYM X509V3_EXT_D2I}
  X509V3_EXT_D2I = function(_para1 : Pointer; const _para2 : PPIdAnsiChar; para3 : TIdC_LONG): Pointer; cdecl;
  {$EXTERNALSYM X509V3_EXT_I2D}
  X509V3_EXT_I2D = function (_para1 : Pointer; _para2 : PPIdAnsiChar) : TIdC_INT; cdecl;
  {$EXTERNALSYM X509V3_EXT_I2V}
  X509V3_EXT_I2V = function (method : PV3_EXT_METHOD; ext : Pointer; extlist : PSTACK_OF_CONF_VALUE) : PSTACK_OF_CONF_VALUE; cdecl;
  {$EXTERNALSYM  X509V3_EXT_V2I}
  X509V3_EXT_V2I = function (method : Pv3_ext_method; ctx : PV3_EXT_CTX; values : PSTACK_OF_CONF_VALUE): Pointer; cdecl;
  {$EXTERNALSYM X509V3_EXT_I2S}
  X509V3_EXT_I2S = function (method : Pv3_ext_method; ext : Pointer) : PIdAnsiChar; cdecl;
  {$EXTERNALSYM X509V3_EXT_S2I}
  X509V3_EXT_S2I = function (method : Pv3_ext_method; ctx : Pv3_ext_ctx; const str : PIdAnsiChar): Pointer; cdecl;
  {$EXTERNALSYM X509V3_EXT_I2R}
  X509V3_EXT_I2R = function (method : Pv3_ext_method; ext : Pointer; _out : PBIO; indent : TIdC_INT) : TIdC_INT; cdecl;
  {$EXTERNALSYM X509V3_EXT_R2I}
  X509V3_EXT_R2I = function (method : Pv3_ext_method; ctx : Pv3_ext_ctx; const str : PIdAnsiChar): Pointer; cdecl;
  {$EXTERNALSYM V3_EXT_METHOD}
  V3_EXT_METHOD = record
    ext_nid : TIdC_INT;
    ext_flags : TIdC_INT;
    // If this is set the following four fields are ignored
    // I'm not sure what the ASN1_ITEM_EXP really is.  The headers don't make it clear, JPM.
    it : PASN1_ITEM_EXP;
    // Old style ASN1 calls
    ext_new : X509V3_EXT_NEW;
    ext_free : X509V3_EXT_FREE;
    d2i : X509V3_EXT_D2I;
    i2d : X509V3_EXT_I2D;
    // The following pair is used for string extensions
    i2s : X509V3_EXT_I2S;
    s2i : X509V3_EXT_S2I;
    // The following pair is used for multi-valued extensions
    i2v : X509V3_EXT_I2V;
    v2i : X509V3_EXT_V2I;
    // The following are used for raw extensions
    i2r : X509V3_EXT_I2R;
    r2i : X509V3_EXT_R2I;
    usr_data : Pointer;  // Any extension specific data
  end;
  {$EXTERNALSYM X509V3_EXT_METHOD}
  X509V3_EXT_METHOD = V3_EXT_METHOD;
  {$EXTERNALSYM X509V3_CONF_METHOD}
  X509V3_CONF_METHOD = record
    get_string : function(db : Pointer; section, value : PIdAnsiChar) : PIdAnsiChar; cdecl;
    get_section : function(db : Pointer; section : PIdAnsiChar) : PSTACK_OF_CONF_VALUE; cdecl;
    free_string : procedure(db : Pointer; _string : PIdAnsiChar); cdecl;
    free_section : procedure (db : Pointer; section : PSTACK_OF_CONF_VALUE);
  end;
  {$EXTERNALSYM V3_EXT_CTX}
  V3_EXT_CTX = record
    flags : TIdC_INT;
    issuer_cert : PX509;
    subject_cert : PX509;
    subject_req : PX509_REQ;
    crl : PX509_CRL;
    db_meth : X509V3_CONF_METHOD;
    db : Pointer;
    // OpenSSL developer's message from header
    // Maybe more here
  end;
  {$EXTERNALSYM ENUMERATED_NAMES}
  ENUMERATED_NAMES = BIT_STRING_BITNAME;
  {$EXTERNALSYM BASIC_CONSTRAINTS}
  BASIC_CONSTRAINTS = record
   ca : TIdC_INT;
   pathlen: PASN1_INTEGER;
  end;
  {$EXTERNALSYM PBASIC_CONSTRAINTS}
  PBASIC_CONSTRAINTS = ^BASIC_CONSTRAINTS;
  {$EXTERNALSYM PKEY_USAGE_PERIOD}
  PKEY_USAGE_PERIOD = record
    notBefore : ASN1_GENERALIZEDTIME;
    notAfter : PASN1_GENERALIZEDTIME;
  end;
  {$EXTERNALSYM PPKEY_USAGE_PERIOD}
  PPKEY_USAGE_PERIOD = ^PKEY_USAGE_PERIOD;
  {$EXTERNALSYM OTHERNAME}
  OTHERNAME = record
    type_id : PASN1_OBJECT;
    value : PASN1_TYPE;
  end;
  {$EXTERNALSYM POTHERNAME}
  POTHERNAME = ^OTHERNAME;
  {$EXTERNALSYM EDIPARTYNAME}
  EDIPARTYNAME = record
    nameAssigner : PASN1_STRING;
    partyName : PASN1_STRING;
  end;
  {$EXTERNALSYM PEDIPARTYNAME}
  PEDIPARTYNAME = ^EDIPARTYNAME;
  {$EXTERNALSYM GENERAL_NAME_union}
  GENERAL_NAME_union = record
    case byte of
      0 : (ptr : PIdAnsiChar);
      1 : (otherName : POTHERNAME); // otherName
      2 : (rfc822Name : PASN1_IA5STRING);
      3 : (dNSName : PASN1_IA5STRING);
      4 : (x400Address : PASN1_TYPE);
      5 : (directoryName : PX509_NAME);
      6 : (ediPartyName : PEDIPARTYNAME);
      7 : (uniformResourceIdentifier : PASN1_IA5STRING);
      8 : (iPAddress : PASN1_OCTET_STRING);
      9 : (registeredID : PASN1_OBJECT);
     // Old names
     10 : (ip : PASN1_OCTET_STRING); // iPAddress
     11 : (dirn : PX509_NAME);       // dirn
     12 : (ia5 : PASN1_IA5STRING);   // rfc822Name, dNSName, uniformResourceIdentifier
     13 : (rid : ASN1_OBJECT);       // registeredID
     14 : (other : PASN1_TYPE);      // x400Address
  end;
  {$EXTERNALSYM GENERAL_NAME}
  GENERAL_NAME = record
    _type : TIdC_INT;
    d : GENERAL_NAME_union;
  end;
  {$EXTERNALSYM PGENERAL_NAME}
  PGENERAL_NAME = ^GENERAL_NAME;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_GENERAL_NAME}
  STACK_OF_GENERAL_NAME = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_GENERAL_NAME}
  PSTACK_OF_GENERAL_NAME = ^STACK_OF_GENERAL_NAME;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_GENERAL_NAME}
  PSTACK_OF_GENERAL_NAME = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PGENERAL_NAMES}
  PGENERAL_NAMES = PSTACK_OF_GENERAL_NAME;
  {$EXTERNALSYM ACCESS_DESCRIPTION}
  ACCESS_DESCRIPTION = record
    method : PASN1_OBJECT;
    location : PGENERAL_NAME;
  end;
  {$EXTERNALSYM PACCESS_DESCRIPTION}
  PACCESS_DESCRIPTION = ^ACCESS_DESCRIPTION;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_ACCESS_DESCRIPTION}
  STACK_OF_ACCESS_DESCRIPTION = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_ACCESS_DESCRIPTION}
  PSTACK_OF_ACCESS_DESCRIPTION = ^STACK_OF_ACCESS_DESCRIPTION;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_ACCESS_DESCRIPTION}
  PSTACK_OF_ACCESS_DESCRIPTION = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PAUTHORITY_INFO_ACCESS}
  PAUTHORITY_INFO_ACCESS = PSTACK_OF_ACCESS_DESCRIPTION;
  {$EXTERNALSYM PEXTENDED_KEY_USAGE}
  PEXTENDED_KEY_USAGE = PSTACK_OF_ASN1_OBJECT;
  {$EXTERNALSYM DIST_POINT_NAME_union}
  DIST_POINT_NAME_union = record
    case byte of
    0 : (fullname : PGENERAL_NAMES);
    1 : (relativename : PSTACK_OF_X509_NAME_ENTRY);
  end;
  {$EXTERNALSYM DIST_POINT_NAME}
  DIST_POINT_NAME = record
    _type : TIdC_INT;
    name : DIST_POINT_NAME_union;
  end;
  {$EXTERNALSYM PDIST_POINT_NAME}
  PDIST_POINT_NAME = ^DIST_POINT_NAME;
  {$EXTERNALSYM DIST_POINT}
  DIST_POINT = record
    distpoint : PDIST_POINT_NAME;
    reasons : PASN1_BIT_STRING;
    CRLissuer : PGENERAL_NAMES;
    dp_reasons : TIdC_INT;
  end;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_DIST_POINT}
  STACK_OF_DIST_POINT = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_DIST_POINT}
  PSTACK_OF_DIST_POINT = ^STACK_OF_DIST_POINT;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_DIST_POINT}
  PSTACK_OF_DIST_POINT = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM AUTHORITY_KEYID}
  AUTHORITY_KEYID = record
    keyid : PASN1_OCTET_STRING;
    issuer : PGENERAL_NAMES;
    serial : PASN1_INTEGER;
  end;
  {$EXTERNALSYM PAUTHORITY_KEYID}
  PAUTHORITY_KEYID = ^AUTHORITY_KEYID;
  // Strong extranet structures
  {$EXTERNALSYM SXNETID}
  SXNETID = record
    zone : PASN1_INTEGER;
    user : PASN1_OCTET_STRING;
  end;
  {$EXTERNALSYM PSXNETID}
  PSXNETID = ^SXNETID;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_SXNETID}
  STACK_OF_SXNETID = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_SXNETID}
  PSTACK_OF_SXNETID = ^STACK_OF_SXNETID;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_SXNETID}
  PSTACK_OF_SXNETID = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM SXNET}
  SXNET = record
    version : PASN1_INTEGER;
    ids : PSTACK_OF_SXNETID;
  end;
  {$EXTERNALSYM PSXNET}
  PSXNET = ^SXNET;
  {$EXTERNALSYM NOTICEREF}
  NOTICEREF = record
    organization : PASN1_STRING;
    noticenos : PSTACK_OF_ASN1_INTEGER;
  end;
  {$EXTERNALSYM PNOTICEREF}
  PNOTICEREF = ^NOTICEREF;
  {$EXTERNALSYM USERNOTICE}
  USERNOTICE = record
    noticeref : PNOTICEREF;
    exptext : PASN1_STRING;
  end;
  {$EXTERNALSYM PUSERNOTICE}
  PUSERNOTICE = ^USERNOTICE;
  {$EXTERNALSYM POLICYQUALINFO_union}
  POLICYQUALINFO_union = record
    case byte of
      0 : (cpsuri : PASN1_IA5STRING);
      1 : (usernotice : PUSERNOTICE);
      2 : (other : PASN1_TYPE);
  end;
  {$EXTERNALSYM POLICYQUALINFO}
  POLICYQUALINFO = record
    pqualid : PASN1_OBJECT;
    d : POLICYQUALINFO_union;
  end;
  {$EXTERNALSYM PPOLICYQUALINFO}
  PPOLICYQUALINFO = ^POLICYQUALINFO;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_POLICYINFO}
  STACK_OF_POLICYINFO = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_POLICYINFO}
  PSTACK_OF_POLICYINFO = ^STACK_OF_POLICYINFO;
  {$ELSE}
  {$EXTERNALSYM PSTACK_OF_POLICYINFO}
  PSTACK_OF_POLICYINFO = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM POLICYINFO}
  POLICYINFO = record
    policyid : PASN1_OBJECT;
    qualifiers : PSTACK_OF_POLICYQUALINFO;
  end;
  {$EXTERNALSYM CERTIFICATEPOLICIES}
  CERTIFICATEPOLICIES = PSTACK_OF_POLICYINFO;
  //typedef STACK_OF(POLICYINFO) CERTIFICATEPOLICIES;
  {$EXTERNALSYM POLICY_MAPPING}
  POLICY_MAPPING = record
    issuerDomainPolicy : PASN1_OBJECT;
    subjectDomainPolicy : PASN1_OBJECT;
  end;
  {$EXTERNALSYM PPOLICY_MAPPING}
  PPOLICY_MAPPING = ^POLICY_MAPPING;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_POLICY_MAPPING}
  STACK_OF_POLICY_MAPPING = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_POLICY_MAPPING}
  PSTACK_OF_POLICY_MAPPING = ^STACK_OF_POLICY_MAPPING;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_POLICY_MAPPING}
  PSTACK_OF_POLICY_MAPPING = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PPSTACK_OF_POLICY_MAPPING}
  PPSTACK_OF_POLICY_MAPPING = ^PSTACK_OF_POLICY_MAPPING;
  {$EXTERNALSYM GENERAL_SUBTREE}
  GENERAL_SUBTREE = record
    base : PGENERAL_NAME;
    minimum : PASN1_INTEGER;
    maximum : PASN1_INTEGER;
  end;
  {$EXTERNALSYM PGENERAL_SUBTREE}
  PGENERAL_SUBTREE = ^GENERAL_SUBTREE;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_GENERAL_SUBTREE}
  STACK_OF_GENERAL_SUBTREE = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_GENERAL_SUBTREE}
  PSTACK_OF_GENERAL_SUBTREE = ^STACK_OF_GENERAL_SUBTREE;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_GENERAL_SUBTREE}
  PSTACK_OF_GENERAL_SUBTREE = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM NAME_CONSTRAINTS}
  NAME_CONSTRAINTS = record
    permittedSubtrees : PSTACK_OF_GENERAL_SUBTREE;
    excludedSubtrees : PSTACK_OF_GENERAL_SUBTREE;
  end;
  {$EXTERNALSYM PNAME_CONSTRAINTS}
  PNAME_CONSTRAINTS = ^NAME_CONSTRAINTS;
  {$EXTERNALSYM POLICY_CONSTRAINTS}
  POLICY_CONSTRAINTS = record
    requireExplicitPolicy : PASN1_INTEGER;
    inhibitPolicyMapping : ASN1_INTEGER;
  end;
  {$EXTERNALSYM PPOLICY_CONSTRAINTS}
  PPOLICY_CONSTRAINTS = ^POLICY_CONSTRAINTS;
  // Proxy certificate structures, see RFC 3820
  {$EXTERNALSYM PROXY_POLICY}
  PROXY_POLICY = record
    policyLanguage : PASN1_OBJECT;
    policy : ASN1_OCTET_STRING;
  end;
  {$EXTERNALSYM PPROXY_POLICY}
  PPROXY_POLICY = ^PROXY_POLICY;
  {$EXTERNALSYM PROXY_CERT_INFO_EXTENSION}
  PROXY_CERT_INFO_EXTENSION = record
    pcPathLengthConstraint : PASN1_INTEGER;
    proxyPolicy : PPROXY_POLICY;
  end;
  {$EXTERNALSYM ISSUING_DIST_POINT}
  ISSUING_DIST_POINT = record
    distpoint : PDIST_POINT_NAME;
    onlyuser : TIdC_INT;
    onlyCA : TIdC_INT;
    onlysomereasons : PASN1_BIT_STRING;
    indirectCRL : TIdC_INT;
    onlyattr : TIdC_INT;
  end;
    {$IFDEF DEBUG_SAFESTACK}
  //These are cut and paste but the duplication is for type checking.
  {$EXTERNALSYM STACK_OF_CMS_SignerInfo}
  STACK_OF_CMS_SignerInfo = record
    _stack: stack;
  end;
  {$EXTERNALSYM STACK_OF_GENERAL_NAMES}
  STACK_OF_GENERAL_NAMES = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_CMS_SignerInfo}
  PSTACK_OF_CMS_SignerInfo = ^STACK_OF_CMS_SignerInfo;
  {$EXTERNALSYM PSTACK_OF_GENERAL_NAMES}
  PSTACK_OF_GENERAL_NAMES = ^STACK_OF_GENERAL_NAMES;
    {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_CMS_SignerInfo}
  PSTACK_OF_CMS_SignerInfo = PSTACK;
  {$EXTERNALSYM PSTACK_OF_GENERAL_NAMES}
  PSTACK_OF_GENERAL_NAMES = PSTACK;
    {$ENDIF}
  {.$ENDIF}
  {$EXTERNALSYM PISSUING_DIST_POINT}
  PISSUING_DIST_POINT = ^ISSUING_DIST_POINT;
  {$EXTERNALSYM PPROXY_CERT_INFO_EXTENSION}
  PPROXY_CERT_INFO_EXTENSION = ^PROXY_CERT_INFO_EXTENSION;
  {$EXTERNALSYM PX509_PURPOSE}
  PX509_PURPOSE = ^X509_PURPOSE;
  {$EXTERNALSYM X509_PURPOSE_check_purpose}
  X509_PURPOSE_check_purpose = function(const _para1 : Px509_purpose; const _para2 : PX509;
      para3 : TIdC_INT) : TIdC_INT; cdecl;
  {$EXTERNALSYM X509_PURPOSE}
  X509_PURPOSE = record
    purpose : TIdC_INT;
    trust : TIdC_INT;    // Default trust ID
    flags : TIdC_INT;
    check_purpose : X509_PURPOSE_check_purpose;
    name : PIdAnsiChar;
    sname : PIdAnsiChar;
    usr_data : Pointer;
  end;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_PURPOSE}
  STACK_OF_X509_PURPOSE = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_PURPOSE}
  PSTACK_OF_X509_PURPOSE = ^STACK_OF_X509_PURPOSE;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_PURPOSE}
  PSTACK_OF_X509_PURPOSE = PSTACK;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RFC3779}
  {$EXTERNALSYM ASRange}
  ASRange = record
    min, max : PASN1_INTEGER;
  end;
  {$EXTERNALSYM PASRange}
  PASRange = ^ASRange;
  {$EXTERNALSYM ASIdOrRange_union}
  ASIdOrRange_union = record
    case byte of
     ASIdOrRange_id : (id : PASN1_INTEGER);
     ASIdOrRange_range : (range : PASRange);
  end;
  {$EXTERNALSYM ASIdOrRange}
  ASIdOrRange = record
    _type : TIdC_INT;
    u : ASIdOrRange_union;
  end;
  {$EXTERNALSYM PASIdOrRange}
  PASIdOrRange = ^ASIdOrRange;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_ASIdOrRange}
  STACK_OF_ASIdOrRange = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_ASIdOrRange}
  PSTACK_OF_ASIdOrRange = ^STACK_OF_ASIdOrRange;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_ASIdOrRange}
  PSTACK_OF_ASIdOrRange = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PASIdOrRanges}
  PASIdOrRanges = PSTACK_OF_ASIdOrRange;
  {$EXTERNALSYM ASIdentifierChoice_union}
  ASIdentifierChoice_union = record
  case byte of
   ASIdentifierChoice_inherit : (inherit : PASN1_NULL);
   ASIdentifierChoice_asIdsOrRanges : (asIdsOrRanges : PASIdOrRanges);
  end;
  {$EXTERNALSYM ASIdentifierChoice}
  ASIdentifierChoice = record
    _type : TIdC_INT;
    u : ASIdentifierChoice_union;
  end;
  {$EXTERNALSYM PASIdentifierChoice}
  PASIdentifierChoice = ^ASIdentifierChoice;
  {$EXTERNALSYM ASIdentifiers}
  ASIdentifiers = record
    asnum : PASIdentifierChoice;
    rdi : PASIdentifierChoice;
  end;
  {$EXTERNALSYM PASIdentifiers}
  PASIdentifiers = ^ASIdentifiers;
  {$EXTERNALSYM IPAddressRange}
  IPAddressRange = record
    min, max : PASN1_BIT_STRING;
  end;
  {$EXTERNALSYM PIPAddressRange}
  PIPAddressRange = ^IPAddressRange;
  {$EXTERNALSYM IPAddressOrRange_union}
  IPAddressOrRange_union = record
  case byte of
    IPAddressOrRange_addressPrefix : (addressPrefix : PASN1_BIT_STRING);
    IPAddressOrRange_addressRange : (addressRange : PIPAddressRange);
  end;
  {$EXTERNALSYM IPAddressOrRange}
  IPAddressOrRange = record
    _type : TIdC_INT;
    u : IPAddressOrRange_union;
  end;
  {$EXTERNALSYM PIPAddressOrRange}
  PIPAddressOrRange = ^IPAddressOrRange;
    {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_IPAddressOrRange}
  STACK_OF_IPAddressOrRange = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_IPAddressOrRange}
  PSTACK_OF_IPAddressOrRange = ^STACK_OF_IPAddressOrRange;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_IPAddressOrRange}
  PSTACK_OF_IPAddressOrRange = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PIPAddressOrRanges}
  PIPAddressOrRanges = PSTACK_OF_IPAddressOrRange;
  {$EXTERNALSYM IPAddressChoice_union}
  IPAddressChoice_union = record
  case byte of
    IPAddressChoice_inherit : (inherit : PASN1_NULL);
    IPAddressChoice_addressesOrRanges : (addressesOrRanges : PIPAddressOrRanges);
  end;
  {$EXTERNALSYM IPAddressChoice}
  IPAddressChoice = record
    _type : TIdC_INT;
    u : IPAddressChoice_union;
  end;
  {$EXTERNALSYM PIPAddressChoice}
  PIPAddressChoice = ^IPAddressChoice;
  {$EXTERNALSYM IPAddressFamily}
  IPAddressFamily = record
    addressFamily : PASN1_OCTET_STRING;
    ipAddressChoice : PIPAddressChoice;
  end;
  {$EXTERNALSYM PIPAddressFamily}
  PIPAddressFamily = ^IPAddressFamily;
   {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_IPAddressFamily}
  STACK_OF_IPAddressFamily = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_IPAddressFamily}
  PSTACK_OF_IPAddressFamily = ^STACK_OF_IPAddressFamily;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_IPAddressFamily}
  PSTACK_OF_IPAddressFamily = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PIPAddrBlocks}
  PIPAddrBlocks = PSTACK_OF_IPAddressFamily;
  {$ENDIF}
  //x509.h
  {$EXTERNALSYM X509_HASH_DIR_CTX}
  X509_HASH_DIR_CTX = record
    num_dirs : TIDC_INT;
    dirs : PPIdAnsiChar;
    dirs_type : PIdC_INT;
    num_dirs_alloced : TIdC_INT;
  end;
  {$EXTERNALSYM PX509_HASH_DIR_CTX}
  PX509_HASH_DIR_CTX = ^X509_HASH_DIR_CTX;
  {$EXTERNALSYM X509_CERT_FILE_CTX}
  X509_CERT_FILE_CTX = record
    num_paths : TIdC_INT;  // number of paths to files or directories
    num_alloced : TIdC_INT;
    paths : PPIdAnsiChar;  // the list of paths or directories
    path_type : TIdC_INT;
  end;
  {$EXTERNALSYM PX509_CERT_FILE_CTX}
  PX509_CERT_FILE_CTX = ^X509_CERT_FILE_CTX;
  {$EXTERNALSYM x509_object_union}
  x509_object_union = record
    case byte of
      0: (ptr : PIdAnsiChar);
      1: (_x509 : Px509);
      2: (crl : PX509_CRL);
      3: (pkey : PEVP_PKEY);
  end;
  {$EXTERNALSYM X509_OBJECT}
  X509_OBJECT = record
    _type : TIdC_INT;
    data : x509_object_union;
  end;
  {$EXTERNALSYM PX509_OBJECT}
  PX509_OBJECT  = ^X509_OBJECT;
  {$EXTERNALSYM PPX509_OBJECT}
  PPX509_OBJECT  = ^PX509_OBJECT;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_OBJECT}
  STACK_OF_X509_OBJECT = record
    _stack: STACK;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_OBJECT}
  PSTACK_OF_X509_OBJECT = ^STACK_OF_X509_OBJECT;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_OBJECT}
  PSTACK_OF_X509_OBJECT = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM X509_ALGOR}
  X509_ALGOR = record
    algorithm : PASN1_OBJECT;
    parameter : PASN1_TYPE;
  end;
  {$EXTERNALSYM PX509_ALGOR}
  PX509_ALGOR  = ^X509_ALGOR;
  {$EXTERNALSYM PPX509_ALGOR}
  PPX509_ALGOR =^PX509_ALGOR;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_ALGOR}
  STACK_OF_X509_ALGOR = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_ALGOR}
  PSTACK_OF_X509_ALGOR = ^STACK_OF_X509_ALGOR;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_ALGOR}
  PSTACK_OF_X509_ALGOR = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PPSTACK_OF_X509_ALGOR}
  PPSTACK_OF_X509_ALGOR = ^PSTACK_OF_X509_ALGOR;
  {$EXTERNALSYM X509_VAL}
  X509_VAL = record
    notBefore : PASN1_TIME;
    notAfter : PASN1_TIME;
  end;
  {$EXTERNALSYM PX509_VAL}
  PX509_VAL = ^X509_VAL;
  {$EXTERNALSYM PPX509_VAL}
  PPX509_VAL =^PX509_VAL;
  {$EXTERNALSYM X509_PUBKEY}
  X509_PUBKEY = record
    algor : PX509_ALGOR;
    public_key : PASN1_BIT_STRING;
    pkey : PEVP_PKEY;
  end;
  {$EXTERNALSYM PX509_PUBKEY}
  PX509_PUBKEY = ^X509_PUBKEY;
  {$EXTERNALSYM PPX509_PUBKEY}
  PPX509_PUBKEY =^PX509_PUBKEY;
  {$EXTERNALSYM X509_SIG}
  X509_SIG = record
    algor : PX509_ALGOR;
    digest : PASN1_OCTET_STRING;
  end;
  {$EXTERNALSYM PX509_SIG}
  PX509_SIG = X509_SIG;
  {$EXTERNALSYM PPX509_SIG}
  PPX509_SIG =^PX509_SIG;
  {$EXTERNALSYM X509_NAME_ENTRY}
  X509_NAME_ENTRY = record
    _object : PASN1_OBJECT;
    value : PASN1_STRING;
    _set : TIdC_INT;
    size : TIdC_INT; // temp variable
  end;
  {$NODEFINE X509_NAME}
  X509_NAME = record
    entries : PSTACK_OF_X509_NAME_ENTRY;
    modified : TIdC_INT;  // true if 'bytes' needs to be built
    {$IFNDEF OPENSSL_NO_BUFFER}
    bytes : PBUF_MEM;
    {$else}
    bytes : PIdAnsiChar;
    {$ENDIF}
    //*	unsigned long hash; Keep the hash around for lookups */
    canon_enc : PIdAnsiChar;
    canon_enclen : TIdC_INT;
  end;
  {$EXTERNALSYM X509_EXTENSION}
  X509_EXTENSION = record
    _object : PASN1_OBJECT;
    critical : ASN1_BOOLEAN;
    value : PASN1_OCTET_STRING;
  end;
  {$EXTERNALSYM PX509_EXTENSION}
  PX509_EXTENSION = ^X509_EXTENSION;
  {$EXTERNALSYM PPX509_EXTENSION}
  PPX509_EXTENSION =^PX509_EXTENSION;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_EXTENSION}
  STACK_OF_X509_EXTENSION = record
    _stack: stack;
  end;
  {$EXTERNALSYM X509_EXTENSIONS}
  X509_EXTENSIONS = STACK_OF_X509_EXTENSION;
  {$EXTERNALSYM PSTACK_OF_X509_EXTENSION}
  PSTACK_OF_X509_EXTENSION = ^STACK_OF_X509_EXTENSION;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_EXTENSION}
  PSTACK_OF_X509_EXTENSION = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PPSTACK_OF_X509_EXTENSION}
  PPSTACK_OF_X509_EXTENSION = ^PSTACK_OF_X509_EXTENSION;
  {$EXTERNALSYM PX509_EXTENSIONS}
  PX509_EXTENSIONS = PPSTACK_OF_X509_EXTENSION;
  {$EXTERNALSYM x509_attributes_union}
  x509_attributes_union = record
    case Byte of
      $FF :(Ptr : PIdAnsiChar);
      0 : (_set: PSTACK_OF_ASN1_TYPE); // 0
      1  : (_single: PASN1_TYPE);
  end;
  {$EXTERNALSYM X509_ATTRIBUTE}
  X509_ATTRIBUTE = record
    _object : PASN1_OBJECT;
    single : TIdC_INT; // 0 for a set, 1 for a single item (which is wrong)
    value : x509_attributes_union;
  end;
  {$EXTERNALSYM PX509_ATTRIBUTE}
  PX509_ATTRIBUTE = ^X509_ATTRIBUTE;
  {$EXTERNALSYM PPX509_ATTRIBUTE}
  PPX509_ATTRIBUTE =^PX509_ATTRIBUTE;
  {$EXTERNALSYM X509_REQ_INFO}
  X509_REQ_INFO = record
    enc: ASN1_ENCODING;
    version: PASN1_INTEGER;
    subject: PX509_NAME;
    pubkey: PX509_PUBKEY;
    attributes: PSTACK_OF_X509_ATTRIBUTE; // [ 0 ]
  end;
  {$EXTERNALSYM X509_REQ}
  X509_REQ = record
    req_info: PX509_REQ_INFO;
    sig_alg: PX509_ALGOR;
    signature: PASN1_BIT_STRING;
    references: TIdC_INT;
  end;
  {$EXTERNALSYM PPX509_REQ}
  PPX509_REQ = ^PX509_REQ;
  {$EXTERNALSYM PX509_CINF}
  PX509_CINF = ^X509_CINF;
  {$EXTERNALSYM X509_CINF}
  X509_CINF = record
    version: PASN1_INTEGER;
    serialNumber: PASN1_INTEGER;
    signature: PX509_ALGOR;
    issuer: PX509_NAME;
    validity: PX509_VAL;
    subject: PX509_NAME;
    key: PX509_PUBKEY;
    issuerUID: PASN1_BIT_STRING; // [ 1 ] optional in v2
    subjectUID: PASN1_BIT_STRING; // [ 2 ] optional in v2
    extensions: PSTACK_OF_X509_EXTENSION;
    enc : ASN1_ENCODING;
  end;
  {$EXTERNALSYM X509_CERT_AUX}
  X509_CERT_AUX = record
    trust : PSTACK_OF_ASN1_OBJECT;  // trusted uses
    reject : PSTACK_OF_ASN1_OBJECT; // rejected uses
    alias : PASN1_UTF8STRING;       // "friendly name"
    keyid : PASN1_OCTET_STRING;	    // key id of private key
    other : PSTACK_OF_X509_ALGOR;   // other unspecified info
  end;
  {$EXTERNALSYM PX509_CERT_AUX}
  PX509_CERT_AUX = ^X509_CERT_AUX;
  {$NODEFINE X509}
  X509 = record
    cert_info: PX509_CINF;
    sig_alg : PX509_ALGOR;
    signature : PASN1_BIT_STRING;
    valid : TIdC_INT;
    references : TIdC_INT;
    name : PIdAnsiChar;
    ex_data : CRYPTO_EX_DATA;
    // These contain copies of various extension values
    ex_pathlen : TIdC_LONG;
    ex_pcpathlen : TIdC_LONG;
    ex_flags : TIdC_ULONG;
    ex_kusage : TIdC_ULONG;
    ex_xkusage : TIdC_ULONG;
    ex_nscert : TIdC_ULONG;
    skid : PASN1_OCTET_STRING;
    akid : PAUTHORITY_KEYID;
    policy_cache : PX509_POLICY_CACHE;
    crldp : PSTACK_OF_DIST_POINT;
    altname : PSTACK_OF_GENERAL_NAME;
    nc : PNAME_CONSTRAINTS;
    {$IFNDEF OPENSSL_NO_RFC3779}
    rfc3779_addr : PSTACK_OF_IPAddressFamily;
    rfc3779_asid : PASIdentifiers;
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_SHA}
    sha1_hash : array [0..SHA_DIGEST_LENGTH-1] of TIdAnsiChar;
    {$ENDIF}
    aux : PX509_CERT_AUX;
  end;
  {$EXTERNALSYM X509_CRL_INFO}
  X509_CRL_INFO = record
    version : PASN1_INTEGER;
    sig_alg : PX509_ALGOR;
    issuer : PX509_NAME;
    lastUpdate : PASN1_TIME;
    nextUpdate : PASN1_TIME;
    revoked : PSTACK_OF_X509_REVOKED;
    extensions : PSTACK_OF_X509_EXTENSION; // [0]
    enc : ASN1_ENCODING;
  end;
  {$EXTERNALSYM PX509_CRL_INFO}
  PX509_CRL_INFO     = ^X509_CRL_INFO;
  {$EXTERNALSYM PPX509_CRL_INFO}
  PPX509_CRL_INFO    =^PX509_CRL_INFO;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_CRL_INFO}
  STACK_OF_X509_CRL_INFO = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_CRL_INFO}
  PSTACK_OF_X509_CRL_INFO = ^STACK_OF_X509_CRL_INFO;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_CRL_INFO}
  PSTACK_OF_X509_CRL_INFO = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PX509_LOOKUP}
  PX509_LOOKUP = ^X509_LOOKUP;
  //This has to be declared ehre for a reference in the next type.
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_LOOKUP}
  STACK_OF_X509_LOOKUP = record
    _stack: STACK;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_LOOKUP}
  PSTACK_OF_X509_LOOKUP = ^STACK_OF_X509_LOOKUP;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_LOOKUP}
  PSTACK_OF_X509_LOOKUP = PSTACK;
  {$ENDIF}

  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_CRL}
  STACK_OF_X509_CRL = record
    _stack: STACK;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_CRL}
  PSTACK_OF_X509_CRL = ^STACK_OF_X509_CRL;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_CRL}
  PSTACK_OF_X509_CRL = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PX509_VERIFY_PARAM}
  PX509_VERIFY_PARAM = ^X509_VERIFY_PARAM;
  {$EXTERNALSYM PX509_STORE_CTX}
  PX509_STORE_CTX = ^X509_STORE_CTX;
  {$EXTERNALSYM PPX509_CRL}
  PPX509_CRL = ^PX509_CRL;
  {$EXTERNALSYM X509_STORE}
  X509_STORE = record
    // The following is a cache of trusted certs
    cache : TIdC_INT;               // if true, stash any hits
    objs : PSTACK_OF_X509_OBJECT;   // Cache of all objects
    // These are external lookup methods
    get_cert_methods : PSTACK_OF_X509_LOOKUP;
    param : PX509_VERIFY_PARAM;
    // Callbacks for various operations
    verify : function (ctx : PX509_STORE_CTX) : TIdC_INT; cdecl; // called to verify a certificate
    verify_cb : function (ok : TIdC_INT; ctx : PX509_STORE_CTX) : TIdC_INT; cdecl; // error callback
    get_issuer : function (issuer : PPX509; ctx : PX509_STORE_CTX; x : PX509) : TIdC_INT; cdecl; // get issuers cert from ctx
    check_issued : function (ctx : PX509_STORE_CTX; x : PX509; issuer : PX509) : TIdC_INT; cdecl; // check issued
    check_revocation : function (ctx : PX509_STORE_CTX) : TIdC_INT; cdecl; // Check revocation status of chain
    get_crl : function (ctx : PX509_STORE_CTX; crl : PPX509_CRL; x : PX509) : TIdC_INT; cdecl;// retrieve CRL
    check_crl : function(ctx : PX509_STORE_CTX; crl : PX509_CRL) : TIdC_INT; cdecl; // Check CRL validity
    cert_crl : function(ctx : PX509_STORE_CTX; crl : PX509_CRL; x : PX509) : TIdC_INT; cdecl; // Check certificate against CRL
    lookup_certs : function(ctx : PX509_STORE_CTX; nm : PX509_NAME) : PSTACK_OF_X509 cdecl;
    lookup_crls : function(ctx : PX509_STORE_CTX; nm : PX509_NAME) : PSTACK_OF_X509_CRL cdecl;
    cleanup : function(ctx : PX509_STORE_CTX) : TIdC_INT; cdecl;
    ex_data : CRYPTO_EX_DATA;
    references : TIdC_INT;
  end;
  {$EXTERNALSYM PX509_STORE}
  PX509_STORE = ^X509_STORE;
  {$EXTERNALSYM PX509_CRL_METHOD}
  PX509_CRL_METHOD = Pointer;
  {$EXTERNALSYM X509_CRL}
  X509_CRL = record
    crl : PX509_CRL_INFO;
    sig_alg : PX509_ALGOR;
    signature : PASN1_BIT_STRING;
    references : TIdC_INT;
    flags : TIdC_INT;
    //* Copies of various extensions */
    akid : PAUTHORITY_KEYID;
    idp : PISSUING_DIST_POINT;
    //* Convenient breakdown of IDP */
    idp_flags : TIdC_INT;
    idp_reasons : TIdC_INT;
    //* CRL and base CRL numbers for delta processing */
    crl_number : PASN1_INTEGER;
    base_crl_number : PASN1_INTEGER;
{$ifndef OPENSSL_NO_SHA}
    sha1_hash : array [0..(SHA_DIGEST_LENGTH - 1)] of byte;
{$endif}
    issuers : PSTACK_OF_GENERAL_NAMES;
    meth : PX509_CRL_METHOD;
    meth_data : Pointer;
  end;
  {$EXTERNALSYM X509_LOOKUP_METHOD}
  X509_LOOKUP_METHOD = record
    name : PIdAnsiChar;
    new_item : function (ctx : PX509_LOOKUP): TIdC_INT; cdecl;
    free : procedure (ctx : PX509_LOOKUP); cdecl;
    init : function(ctx : PX509_LOOKUP) : TIdC_INT; cdecl;
    shutdown : function(ctx : PX509_LOOKUP) : TIdC_INT; cdecl;
    ctrl: function(ctx : PX509_LOOKUP; cmd : TIdC_INT; const argc : PIdAnsiChar; argl : TIdC_LONG; out ret : PIdAnsiChar ) : TIdC_INT; cdecl;
    get_by_subject: function(ctx : PX509_LOOKUP; _type : TIdC_INT; name : PX509_NAME; ret : PX509_OBJECT ) : TIdC_INT; cdecl;
    get_by_issuer_serial : function(ctx : PX509_LOOKUP; _type : TIdC_INT; name : PX509_NAME; serial : PASN1_INTEGER; ret : PX509_OBJECT) : TIdC_INT; cdecl;
    get_by_fingerprint : function (ctx : PX509_LOOKUP; _type : TIdC_INT; bytes : PIdAnsiChar; len : TIdC_INT; ret : PX509_OBJECT): TIdC_INT; cdecl;
    get_by_alias : function(ctx : PX509_LOOKUP; _type : TIdC_INT; str : PIdAnsiChar; ret : PX509_OBJECT) : TIdC_INT; cdecl;
  end;
  {$EXTERNALSYM PX509_LOOKUP_METHOD}
  PX509_LOOKUP_METHOD      = ^X509_LOOKUP_METHOD;
  {$EXTERNALSYM PPX509_LOOKUP_METHOD}
  PPX509_LOOKUP_METHOD     = ^PX509_LOOKUP_METHOD;
  {$EXTERNALSYM X509_VERIFY_PARAM}
  X509_VERIFY_PARAM = record
    name : PIdAnsiChar;
    check_time : time_t;          // Time to use
    inh_flags : TIdC_ULONG;       // Inheritance flags
    flags : TIdC_ULONG;           // Various verify flags
    purpose : TIdC_INT;           // purpose to check untrusted certificates
    trust : TIdC_INT;             // trust setting to check
    depth : TIdC_INT;             // Verify depth
    policies : PSTACK_OF_ASN1_OBJECT; // Permissible policies
  end;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_VERIFY_PARAM}
  STACK_OF_X509_VERIFY_PARAM = record
    _stack: STACK;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_VERIFY_PARAM}
  PSTACK_OF_X509_VERIFY_PARAM = ^STACK_OF_X509_VERIFY_PARAM;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_VERIFY_PARAM}
  PSTACK_OF_X509_VERIFY_PARAM = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM X509_LOOKUP}
  X509_LOOKUP = record
    init : TIdC_INT;              // have we been started
    skip : TIdC_INT;              // don't use us.
    method : PX509_LOOKUP_METHOD; // the functions
    method_data : PIdAnsiChar;          // method data
    store_ctx : PX509_STORE;      // who owns us
  end;
  {$EXTERNALSYM PX509_POLICY_TREE}
  PX509_POLICY_TREE = Pointer;
  {$EXTERNALSYM PPSTACK_OF_X509_LOOKUP}
  PPSTACK_OF_X509_LOOKUP = ^PSTACK_OF_X509_LOOKUP;
  // This is  used when verifying cert chains.  Since the
  // gathering of the cert chain can take some time (and have to be
  // 'retried', this needs to be kept and passed around.
  X509_STORE_CTX = record   // X509_STORE_CTX
    ctx : PX509_STORE;
    current_method : TIdC_INT;  // used when looking up certs
    // The following are set by the caller
    cert : PX509;               // The cert to check
    untrusted : PSTACK_OF_X509; // chain of X509s - untrusted - passed in
    crls : PSTACK_OF_X509_CRL;  // set of CRLs passed in
    param : PX509_VERIFY_PARAM;
    other_ctx : Pointer;  // Other info for use with get_issuer()
    // Callbacks for various operations
    verify : function (ctx : PX509_STORE_CTX) : TIdC_INT; cdecl;  // called to verify a certificate
    verify_cb : function (ok : TIdC_INT; ctx : PX509_STORE_CTX) : TIdC_INT; cdecl; // error callback
    get_issuer : function (var issuer : PX509; ctx : PX509_STORE_CTX; x : PX509) : TIdC_INT; cdecl; // get issuers cert from ctx
    check_issued : function(ctx : PX509_STORE_CTX; x, issuer : PX509) : TIdC_INT; cdecl; // check issued
    check_revocation : function (ctx : PX509_STORE_CTX): TIdC_INT; cdecl; // Check revocation status of chain
    get_crl : function (ctx : PX509_STORE_CTX; var crl : X509_CRL; x : PX509): TIdC_INT; cdecl; // retrieve CRL
    check_crl : function (ctx : PX509_STORE_CTX; var crl : X509_CRL) : TIdC_INT; cdecl; // Check CRL validity
    cert_crl : function (ctx : PX509_STORE_CTX; crl : PX509_CRL; x : PX509) : TIdC_INT; cdecl; // Check certificate against CRL
    check_policy : function (ctx : PX509_STORE_CTX) : TIdC_INT;  cdecl;
    cleanup : function (ctx : PX509_STORE_CTX) : TIdC_INT;  cdecl;
    //* The following is built up */
    valid : TIdC_INT;		//* if 0, rebuild chain */
    last_untrusted : TIdC_INT;	//* index of last untrusted cert */
    chain : PSTACK_OF_X509; 		//* chain of X509s - built up and trusted */
    tree : PX509_POLICY_TREE;	//* Valid policy tree */

    explicit_policy : TIdC_INT;	//* Require explicit policy value */

    //* When something goes wrong, this is why */
    error_depth : TIdC_INT;
    error : TIdC_INT;
    current_cert : PX509;
    current_issuer : PX509;	//* cert currently being tested as valid issuer */
    current_crl : PX509_CRL;	//* current CRL */

    current_crl_score : TIdC_INT;  //* score of current CRL */
    current_reasons : TIdC_UINT;  //* Reason mask */

    parent : PX509_STORE_CTX; //* For CRL path validation: parent context */

    ex_data : CRYPTO_EX_DATA;
  end;
  {$EXTERNALSYM X509_STORE_CTX}

  {$EXTERNALSYM PX509_EXTENSION_METHOD}
  PX509_EXTENSION_METHOD   = Pointer;
  {$EXTERNALSYM PX509_TRUST}
  PX509_TRUST = ^X509_TRUST;
  {$EXTERNALSYM X509_TRUST_check_trust}
  X509_TRUST_check_trust = function(_para1 : PX509_TRUST; para2 : PX509; _para3 : TIdC_INT) : TIdC_INT; cdecl;
  {$EXTERNALSYM X509_TRUST}
  X509_TRUST = record
    trust : TIdC_INT;
    flags : TIdC_INT;
    check_trust : X509_TRUST_check_trust;
    name : PIdAnsiChar;
    arg1 : TIdC_INT;
    arg2 : Pointer;
  end;
  {$EXTERNALSYM PPX509_TRUST}
  PPX509_TRUST = ^PX509_TRUST;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_509_TRUST}
  STACK_OF_509_TRUST = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_509_TRUST}
  PSTACK_OF_509_TRUST = ^STACK_OF_509_TRUST;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_509_TRUST}
  PSTACK_OF_509_TRUST = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM X509_REVOKED}
  X509_REVOKED = record
    serialNumber: PASN1_INTEGER;
    revocationDate: PASN1_TIME;
    extensions: PSTACK_OF_X509_EXTENSION; // optional
    //* Set up if indirect CRL */
    issuer : PSTACK_OF_GENERAL_NAME;
    //* Revocation reason */
    reason : TIdC_INT;
    sequence: TIdC_INT;
  end;
  {$EXTERNALSYM PX509_REVOKED}
  PX509_REVOKED      = ^X509_REVOKED;
  {$EXTERNALSYM PPX509_REVOKED}
  PPX509_REVOKED     =^PX509_REVOKED;
  {$EXTERNALSYM PX509_PKEY}
  PX509_PKEY       = Pointer;
  {$EXTERNALSYM PPX509_PKEY}
  PPX509_PKEY      =^PX509_PKEY;
  {$EXTERNALSYM X509_INFO}
  X509_INFO = record
    x509 : PX509;
    crl : PX509_CRL;
    x_pkey : PX509_PKEY;
    enc_cipher: EVP_CIPHER_INFO;
    enc_len: TIdC_INT;
    enc_data: PIdAnsiChar;
    references: TIdC_INT;
  end;
  {$EXTERNALSYM PX509_INFO}
  PX509_INFO       = ^X509_INFO;
  {$EXTERNALSYM PPX509_INFO}
  PPX509_INFO      =^PX509_INFO;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_X509_INFO}
  STACK_OF_X509_INFO = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_X509_INFO}
  PSTACK_OF_X509_INFO = ^STACK_OF_X509_INFO;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_X509_INFO}
  PSTACK_OF_X509_INFO = PSTACK;
  {$ENDIF}
// OpenSSL Developer's note
// The next 2 structures and their 8 routines were sent to me by
// Pat Richard <patr@x509.com> and are used to manipulate
// Netscapes spki structures - useful if you are writing a CA web page
  {$EXTERNALSYM NETSCAPE_SPKAC}
  NETSCAPE_SPKAC = record
    pubkey : PX509_PUBKEY;
    challenge : PASN1_IA5STRING;  // challenge sent in atlas >= PR2
  end;
  {$EXTERNALSYM PNETSCAPE_SPKAC}
  PNETSCAPE_SPKAC = ^NETSCAPE_SPKAC;
  {$EXTERNALSYM PPNETSCAPE_SPKAC}
  PPNETSCAPE_SPKAC = ^PNETSCAPE_SPKAC;
  {$EXTERNALSYM NETSCAPE_SPKI}
  NETSCAPE_SPKI = record
    spkac : PNETSCAPE_SPKAC;  // signed public key and challenge
    sig_algor : PX509_ALGOR;
    signature : PASN1_BIT_STRING;
  end;
  {$EXTERNALSYM PNETSCAPE_SPKI}
  PNETSCAPE_SPKI = ^NETSCAPE_SPKI;
  {$EXTERNALSYM PPNETSCAPE_SPKI}
  PPNETSCAPE_SPKI = ^PNETSCAPE_SPKI;
  {$EXTERNALSYM NETSCAPE_CERT_SEQUENCE}
  NETSCAPE_CERT_SEQUENCE = record
    _type : PASN1_OBJECT;
    certs : PSTACK_OF_X509;
  end;
  {$EXTERNALSYM PNETSCAPE_CERT_SEQUENCE}
  PNETSCAPE_CERT_SEQUENCE = ^NETSCAPE_CERT_SEQUENCE;
  {$EXTERNALSYM PPNETSCAPE_CERT_SEQUENCE}
  PPNETSCAPE_CERT_SEQUENCE = ^PNETSCAPE_CERT_SEQUENCE;
  // Password based encryption structure
  {$EXTERNALSYM PBEPARAM}
  PBEPARAM = record
    salt : PASN1_OCTET_STRING;
    iter : PASN1_INTEGER;
  end;
  {$EXTERNALSYM PPBEPARAM}
  PPBEPARAM = ^PBEPARAM;
  {$EXTERNALSYM PPPBEPARAM}
  PPPBEPARAM = ^PPBEPARAM;
  // Password based encryption V2 structures
  {$EXTERNALSYM PBE2PARAM}
  PBE2PARAM = record
    keyfunc : PX509_ALGOR;
    encryption : PX509_ALGOR;
  end;
  {$EXTERNALSYM PPBE2PARAM}
  PPBE2PARAM = ^PBE2PARAM;
  {$EXTERNALSYM PBKDF2PARAM}
  PBKDF2PARAM = record
    salt : PASN1_TYPE;  // Usually OCTET STRING but could be anything
    iter : PASN1_INTEGER;
    keylength : PASN1_INTEGER;
    prf : PX509_ALGOR;
  end;
  {$EXTERNALSYM PPBKDF2PARAM}
  PPBKDF2PARAM = ^PBKDF2PARAM;
  {$EXTERNALSYM PPPBKDF2PARAM}
  PPPBKDF2PARAM = ^PPBKDF2PARAM;
  {$EXTERNALSYM PKCS8_PRIV_KEY_INFO}
  PKCS8_PRIV_KEY_INFO = record
    broken : TIdC_INT;     // Flag for various broken formats
//#define PKCS8_OK              0
//#define PKCS8_NO_OCTET        1
//#define PKCS8_EMBEDDED_PARAM  2
//#define PKCS8_NS_DB           3
    version : PASN1_INTEGER;
    pkeyalg : PX509_ALGOR;
    pkey : PASN1_TYPE; // Should be OCTET STRING but some are broken
    attributes : PSTACK_OF_X509_ATTRIBUTE;
  end;
  {$EXTERNALSYM PPKCS8_PRIV_KEY_INFO}
  PPKCS8_PRIV_KEY_INFO = ^PKCS8_PRIV_KEY_INFO;
  {$EXTERNALSYM PPPKCS8_PRIV_KEY_INFO}
  PPPKCS8_PRIV_KEY_INFO = ^PPKCS8_PRIV_KEY_INFO;
  {$EXTERNALSYM PPKCS7_RECIP_INFO}
  PPKCS7_RECIP_INFO = ^PKCS7_RECIP_INFO;
  {$EXTERNALSYM PSHA_CTX}
  PSHA_CTX = ^SHA_CTX;
  //cms.h
  {$IFDEF OPENSSL_NO_CMS}
  {$EXTERNALSYM PCMS_ContentInfo}
  PCMS_ContentInfo = Pointer;
  {$EXTERNALSYM PCMS_SignerInfo}
  PCMS_SignerInfo = Pointer;
  {$EXTERNALSYM PCMS_CertificateChoices}
  PCMS_CertificateChoices = Pointer;
  {$EXTERNALSYM PCMS_RevocationInfoChoice}
  PCMS_RevocationInfoChoice = Pointer;
  {$EXTERNALSYM PCMS_RecipientInfo}
  PCMS_RecipientInfo = Pointer;
  {$EXTERNALSYM PCMS_ReceiptRequest}
  PCMS_ReceiptRequest = Pointer;
  {$EXTERNALSYM PCMS_Receipt}
  PCMS_Receipt = Pointer;
  {$EXTERNALSYM PSTACK_OF_CMS_SignerInfo}
  {$ENDIF}
  //ripemd.h
  {$IFNDEF OPENSSL_NO_RIPEMD}
  {$EXTERNALSYM RIPEMD160_LONG}
  RIPEMD160_LONG = TIdC_UINT;
  {$EXTERNALSYM RIPEMD160_CTX}
  RIPEMD160_CTX = record
    A,B,C,D,E : RIPEMD160_LONG;
    Nl,Nh : RIPEMD160_LONG;
    data : array [0..RIPEMD160_LBLOCK -1 ] of RIPEMD160_LONG;
    num : TIdC_UINT;
  end;
  {$EXTERNALSYM PRIPEMD160_CTX}
  PRIPEMD160_CTX = ^RIPEMD160_CTX;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RC4}
  {$EXTERNALSYM RC4_KEY}
  RC4_KEY = record
    x,y : RC4_INT;
    data : array [0..(256 - 1)] of RC4_INT;
  end;
  {$EXTERNALSYM PRC4_KEY}
  PRC4_KEY = ^RC4_KEY;
  {$ENDIF}
  //rc2.h
  {$IFNDEF OPENSSL_NO_RC2}
  {$EXTERNALSYM RC2_KEY}
  RC2_KEY = record
    data : array [0..(64 - 1)] of RC2_INT;
  end;
  {$EXTERNALSYM PRC2_KEY}
  PRC2_KEY = ^RC2_KEY;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RC5}
  {$EXTERNALSYM RC5_32_INT}
  RC5_32_INT = TIdC_UINT;
  {$EXTERNALSYM RC5_32_KEY}
  RC5_32_KEY = record
    // Number of rounds
    rounds : TIdC_INT;
    data : array [0..(2*(RC5_16_ROUNDS+1)-1)] of RC5_32_INT;
  end;
  {$EXTERNALSYM PRC5_32_KEY}
  PRC5_32_KEY = ^RC5_32_KEY;
  {$ENDIF}
  //blowfish.h
  {$IFNDEF OPENSSL_NO_BF}
  {$EXTERNALSYM BF_LONG}
  BF_LONG = TIdC_UINT;
  {$EXTERNALSYM BF_KEY}
  BF_KEY = record
    P : array [0..(BF_ROUNDS+2)-1] of BF_LONG;
    S : array [0..(4*256)-1] of BF_LONG;
  end;
  {$EXTERNALSYM PBF_KEY}
  PBF_KEY = ^BF_KEY;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_CAST}
  {$EXTERNALSYM CAST_LONG}
  CAST_LONG = TIdC_ULONG;
  {$EXTERNALSYM CAST_KEY}
  CAST_KEY = record
    data : array[0..(32 -1)] of CAST_LONG;
    short_key : TIdC_INT; // Use reduced rounds for short key
  end;
  {$EXTERNALSYM PCAST_KEY}
  PCAST_KEY = ^CAST_KEY;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_IDEA}
  {$EXTERNALSYM IDEA_KEY_SCHEDULE}
  IDEA_KEY_SCHEDULE = record
    data : array [0..(9-1),0..(6-1)] of IDEA_INT;
  end;
  {$EXTERNALSYM PIDEA_KEY_SCHEDULE}
  PIDEA_KEY_SCHEDULE = ^IDEA_KEY_SCHEDULE;
  {$ENDIF}
  //ocsp.h
  //*   CertID ::= SEQUENCE {
  //*       hashAlgorithm            AlgorithmIdentifier,
  //*       issuerNameHash     OCTET STRING, -- Hash of Issuer's DN
  //*       issuerKeyHash      OCTET STRING, -- Hash of Issuers public key (excluding the tag & length fields)
  //*       serialNumber       CertificateSerialNumber }
  //*/
//typedef struct ocsp_cert_id_st
  {$EXTERNALSYM OCSP_CERTID}
  OCSP_CERTID = record
    hashAlgorithm : PX509_ALGOR;
    issuerNameHash : PASN1_OCTET_STRING;
    issuerKeyHash : PASN1_OCTET_STRING;
    serialNumber : PASN1_INTEGER;
  end;
  {$EXTERNALSYM POCSP_CERTID}
  POCSP_CERTID = ^OCSP_CERTID;
  {$EXTERNALSYM PPOCSP_CERTID}
  PPOCSP_CERTID = ^POCSP_CERTID;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_OCSP_CERTID}
  STACK_OF_OCSP_CERTID = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_OCSP_CERTID}
  PSTACK_OF_OCSP_CERTID = ^STACK_OF_OCSP_CERTID;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_OCSP_CERTID}
  PSTACK_OF_OCSP_CERTID = PSTACK;
  {$ENDIF}
// *   Request ::=     SEQUENCE {
// *       reqCert                    CertID,
// *       singleRequestExtensions    [0] EXPLICIT Extensions OPTIONAL }
// */
  {$EXTERNALSYM OCSP_ONEREQ}
  OCSP_ONEREQ = record
    reqCert : POCSP_CERTID;
    singleRequestExtensions : PSTACK_OF_X509_EXTENSION;
  end;
  {$EXTERNALSYM POCSP_ONEREQ}
  POCSP_ONEREQ = ^OCSP_ONEREQ;
  {$EXTERNALSYM PPOCSP_ONEREQ}
  PPOCSP_ONEREQ = ^POCSP_ONEREQ;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_OCSP_ONEREQ}
  STACK_OF_OCSP_ONEREQ = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_OCSP_ONEREQ}
  PSTACK_OF_OCSP_ONEREQ = ^STACK_OF_OCSP_ONEREQ;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_OCSP_ONEREQ}
  PSTACK_OF_OCSP_ONEREQ = PSTACK;
  {$ENDIF}
//*   TBSRequest      ::=     SEQUENCE {
//*       version             [0] EXPLICIT Version DEFAULT v1,
//*       requestorName       [1] EXPLICIT GeneralName OPTIONAL,
//*       requestList             SEQUENCE OF Request,
//*       requestExtensions   [2] EXPLICIT Extensions OPTIONAL }
//*/
 {$EXTERNALSYM OCSP_REQINFO}
  OCSP_REQINFO = record
   	version : PASN1_INTEGER;
    requestorName : PGENERAL_NAME;
    requestList : PSTACK_OF_OCSP_ONEREQ;
    requestExtensions : PSTACK_OF_X509_EXTENSION;
  end;
  {$EXTERNALSYM POCSP_REQINFO}
  POCSP_REQINFO = ^OCSP_REQINFO;
  {$EXTERNALSYM PPOCSP_REQINFO}
  PPOCSP_REQINFO = ^POCSP_REQINFO;
///*   Signature       ::=     SEQUENCE {
// *       signatureAlgorithm   AlgorithmIdentifier,
// *       signature            BIT STRING,
// *       certs                [0] EXPLICIT SEQUENCE OF Certificate OPTIONAL }
// */
  {$EXTERNALSYM OCSP_SIGNATURE}
  OCSP_SIGNATURE = record
    signatureAlgorithm : PX509_ALGOR;
    signature : PASN1_BIT_STRING;
    certs : PSTACK_OF_X509;
  end;
  {$EXTERNALSYM POCSP_SIGNATURE}
  POCSP_SIGNATURE = ^OCSP_SIGNATURE;
  {$EXTERNALSYM PPOCSP_SIGNATURE}
  PPOCSP_SIGNATURE = ^POCSP_SIGNATURE;
///*   OCSPRequest     ::=     SEQUENCE {
// *       tbsRequest                  TBSRequest,
// *       optionalSignature   [0]     EXPLICIT Signature OPTIONAL }
// */
  {$EXTERNALSYM OCSP_REQUEST}
  OCSP_REQUEST = record
    tbsRequest : POCSP_REQINFO;
    optionalSignature : POCSP_SIGNATURE; //* OPTIONAL */
  end;
  {$EXTERNALSYM POCSP_REQUEST}
  POCSP_REQUEST = ^OCSP_REQUEST;
  {$EXTERNALSYM PPOCSP_REQUEST}
  PPOCSP_REQUEST = ^POCSP_REQUEST;
///*   OCSPResponseStatus ::= ENUMERATED {
// *       successful            (0),      --Response has valid confirmations
// *       malformedRequest      (1),      --Illegal confirmation request
// *       internalError         (2),      --Internal error in issuer
// *       tryLater              (3),      --Try again later
// *                                       --(4) is not used
// *       sigRequired           (5),      --Must sign the request
// *       unauthorized          (6)       --Request unauthorized
// *   }
// */
///*   ResponseBytes ::=       SEQUENCE {
// *       responseType   OBJECT IDENTIFIER,
// *       response       OCTET STRING }
// */
  {$EXTERNALSYM OCSP_RESPBYTES}
  OCSP_RESPBYTES = record
    responseType : PASN1_OBJECT;
    response : PASN1_OCTET_STRING;
  end;
  {$EXTERNALSYM POCSP_RESPBYTES}
  POCSP_RESPBYTES = ^OCSP_RESPBYTES;
  {$EXTERNALSYM PPOCSP_RESPBYTES}
  PPOCSP_RESPBYTES = ^POCSP_RESPBYTES;
///*   OCSPResponse ::= SEQUENCE {
// *      responseStatus         OCSPResponseStatus,
// *      responseBytes          [0] EXPLICIT ResponseBytes OPTIONAL }
// */
  {$EXTERNALSYM OCSP_RESPONSE}
  OCSP_RESPONSE = record
    responseStatus : PASN1_ENUMERATED;
    responseBytes : POCSP_RESPBYTES;
  end;
  {$EXTERNALSYM POCSP_RESPONSE}
  POCSP_RESPONSE = ^OCSP_RESPONSE;
  {$EXTERNALSYM PPOCSP_RESPONSE}
  PPOCSP_RESPONSE = ^POCSP_RESPONSE;
// /*   ResponderID ::= CHOICE {
// *      byName   [1] Name,
// *      byKey    [2] KeyHash }
// */
  {$EXTERNALSYM OCSP_RESPID_union}
  OCSP_RESPID_union = record
    case Integer of
      0 : (byName : PX509_NAME);
      1 : (byKey : PASN1_OCTET_STRING);
  end;
  {$EXTERNALSYM OCSP_RESPID}
  OCSP_RESPID = record
    _type : TIdC_INT;
    value : OCSP_RESPID_union;
  end;
  {$EXTERNALSYM POCSP_RESPID}
  POCSP_RESPID = ^OCSP_RESPID;
  {$EXTERNALSYM PPOCSP_RESPID}
  PPOCSP_RESPID = ^POCSP_RESPID;
  //*   KeyHash ::= OCTET STRING --SHA-1 hash of responder's public key
  // *                            --(excluding the tag and length fields)
  // */
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_OCSP_RESPID}
  STACK_OF_OCSP_RESPID = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_OCSP_RESPID}
  PSTACK_OF_OCSP_RESPID = ^STACK_OF_OCSP_RESPID;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_OCSP_RESPID}
  PSTACK_OF_OCSP_RESPID = PSTACK;
  {$ENDIF}
///*   RevokedInfo ::= SEQUENCE {
// *       revocationTime              GeneralizedTime,
// *       revocationReason    [0]     EXPLICIT CRLReason OPTIONAL }
// */
  {$EXTERNALSYM OCSP_REVOKEDINFO}
  OCSP_REVOKEDINFO = record
    revocationTime : PASN1_GENERALIZEDTIME;
    revocationReason : PASN1_ENUMERATED;
  end;
 {$EXTERNALSYM POCSP_REVOKEDINFO}
  POCSP_REVOKEDINFO = ^OCSP_REVOKEDINFO;
 {$EXTERNALSYM PPOCSP_REVOKEDINFO}
  PPOCSP_REVOKEDINFO = ^POCSP_REVOKEDINFO;
///*   CertStatus ::= CHOICE {
// *       good                [0]     IMPLICIT NULL,
// *       revoked             [1]     IMPLICIT RevokedInfo,
// *       unknown             [2]     IMPLICIT UnknownInfo }
// */
  {$EXTERNALSYM OCSP_CERTSTATUS_union}
  OCSP_CERTSTATUS_union = record
    case Integer of
     0 : (good : PASN1_NULL);
     1 : (revoked : POCSP_REVOKEDINFO);
     2 : (unknown : PASN1_NULL);
  end;
  {$EXTERNALSYM OCSP_CERTSTATUS}
  OCSP_CERTSTATUS = record
    _type : TIdC_INT;
    value : OCSP_CERTSTATUS_union;
  end;
  {$EXTERNALSYM POCSP_CERTSTATUS}
  POCSP_CERTSTATUS = ^OCSP_CERTSTATUS;
  {$EXTERNALSYM PPOCSP_CERTSTATUS}
  PPOCSP_CERTSTATUS = ^POCSP_CERTSTATUS;
///*   SingleResponse ::= SEQUENCE {
// *      certID                       CertID,
// *      certStatus                   CertStatus,
// *      thisUpdate                   GeneralizedTime,
// *      nextUpdate           [0]     EXPLICIT GeneralizedTime OPTIONAL,
// *      singleExtensions     [1]     EXPLICIT Extensions OPTIONAL }
// */
  {$EXTERNALSYM OCSP_SINGLERESP}
  OCSP_SINGLERESP = record
    certId : POCSP_CERTID;
    certStatus : POCSP_CERTSTATUS;
    thisUpdate : PASN1_GENERALIZEDTIME;
    nextUpdate : PASN1_GENERALIZEDTIME;
    singleExtensions : PSTACK_OF_X509_EXTENSION;
  end;
  {$EXTERNALSYM POCSP_SINGLERESP}
  POCSP_SINGLERESP = ^OCSP_SINGLERESP;
  {$EXTERNALSYM PPOCSP_SINGLERESP}
  PPOCSP_SINGLERESP = ^POCSP_SINGLERESP;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_OCSP_SINGLERESP}
  STACK_OF_OCSP_SINGLERESP = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_OCSP_SINGLERESP}
  PSTACK_OF_OCSP_SINGLERESP = ^STACK_OF_OCSP_SINGLERESP;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_OCSP_SINGLERESP}
  PSTACK_OF_OCSP_SINGLERESP = PSTACK;
  {$ENDIF}
///*   ResponseData ::= SEQUENCE {
// *      version              [0] EXPLICIT Version DEFAULT v1,
// *      responderID              ResponderID,
// *      producedAt               GeneralizedTime,
// *      responses                SEQUENCE OF SingleResponse,
// *      responseExtensions   [1] EXPLICIT Extensions OPTIONAL }
// */
 {$EXTERNALSYM OCSP_RESPDATA}
  OCSP_RESPDATA = record
	  version : PASN1_INTEGER;
	  responderId : POCSP_RESPID;
	  producedAt : PASN1_GENERALIZEDTIME;
	  responses : PSTACK_OF_OCSP_SINGLERESP;
	  responseExtensions : PSTACK_OF_X509_EXTENSION;
	end;
 {$EXTERNALSYM POCSP_RESPDATA}
  POCSP_RESPDATA = ^OCSP_RESPDATA;
 {$EXTERNALSYM PPOCSP_RESPDATA}
  PPOCSP_RESPDATA = ^POCSP_RESPDATA;
///*   BasicOCSPResponse       ::= SEQUENCE {
// *      tbsResponseData      ResponseData,
// *      signatureAlgorithm   AlgorithmIdentifier,
// *      signature            BIT STRING,
// *      certs                [0] EXPLICIT SEQUENCE OF Certificate OPTIONAL }
// */
//  /* Note 1:
//     The value for "signature" is specified in the OCSP rfc2560 as follows:
//     "The value for the signature SHALL be computed on the hash of the DER
//     encoding ResponseData."  This means that you must hash the DER-encoded
//     tbsResponseData, and then run it through a crypto-signing function, which
//     will (at least w/RSA) do a hash-'n'-private-encrypt operation.  This seems
//     a bit odd, but that's the spec.  Also note that the data structures do not
//     leave anywhere to independently specify the algorithm used for the initial
//     hash. So, we look at the signature-specification algorithm, and try to do
//     something intelligent.	-- Kathy Weinhold, CertCo */
//  /* Note 2:
//     It seems that the mentioned passage from RFC 2560 (section 4.2.1) is open
//     for interpretation.  I've done tests against another responder, and found
//     that it doesn't do the double hashing that the RFC seems to say one
//     should.  Therefore, all relevant functions take a flag saying which
//     variant should be used.	-- Richard Levitte, OpenSSL team and CeloCom */
 {$EXTERNALSYM OCSP_BASICRESP}
  OCSP_BASICRESP = record
	  tbsResponseData : POCSP_RESPDATA;
	  signatureAlgorithm : PX509_ALGOR;
	  signature : PASN1_BIT_STRING;
	  certs : PSTACK_OF_X509;
	end;
 {$EXTERNALSYM POCSP_BASICRESP}
  POCSP_BASICRESP = ^OCSP_BASICRESP;
 {$EXTERNALSYM PPOCSP_BASICRESP}
  PPOCSP_BASICRESP = ^POCSP_BASICRESP;
///* CrlID ::= SEQUENCE {
// *     crlUrl               [0]     EXPLICIT IA5String OPTIONAL,
// *     crlNum               [1]     EXPLICIT INTEGER OPTIONAL,
// *     crlTime              [2]     EXPLICIT GeneralizedTime OPTIONAL }
// */
 {$EXTERNALSYM OCSP_CRLID}
  OCSP_CRLID = record
	  crlUrl : PASN1_IA5STRING;
	  crlNum : PASN1_INTEGER;
	  crlTime : PASN1_GENERALIZEDTIME;
	end;
 {$EXTERNALSYM POCSP_CRLID}
  POCSP_CRLID = ^OCSP_CRLID;
 {$EXTERNALSYM PPOCSP_CRLID}
  PPOCSP_CRLID = ^POCSP_CRLID;
///* ServiceLocator ::= SEQUENCE {
// *      issuer    Name,
// *      locator   AuthorityInfoAccessSyntax OPTIONAL }
// */
 {$EXTERNALSYM OCSP_SERVICELOC}
  OCSP_SERVICELOC = record
	  issuer : PX509_NAME;
	  locator : PSTACK_OF_ACCESS_DESCRIPTION;
  end;
  {$EXTERNALSYM POCSP_SERVICELOC}
  POCSP_SERVICELOC = ^OCSP_SERVICELOC;
  {$EXTERNALSYM PPOCSP_SERVICELOC}
  PPOCSP_SERVICELOC = ^POCSP_SERVICELOC;
  //mdc2.h
  //MDC2_CTX = record
    //this is not defined in headers so it's best use functions in the API to access the structure.
  //end;
  {$EXTERNALSYM PMDC2_CTX}
  PMDC2_CTX = Pointer;//^MDC2_CTX;
  //tmdiff.h
//  MS_TM = record
    //this is not defined in headers so it's best use functions in the API to access the structure.
 // end;
  {$EXTERNALSYM PMS_TM}
  PMS_TM = Pointer;//^MS_TM;
  {$EXTERNALSYM PPMS_TM}
  PPMS_TM = ^PMS_TM;
  //PEVP_PBE_KEYGEN          = Pointer;
  {$EXTERNALSYM ppem_password_cb}
  ppem_password_cb = function (buf : PIdAnsiChar; size : TIdC_INT; rwflag : TIdC_INT; userdata : Pointer) : TIdC_INT; cdecl;
  {$EXTERNALSYM PEM_ENCODE_SEAL_CTX}
  PEM_ENCODE_SEAL_CTX   = record
    encode : EVP_ENCODE_CTX;
    md : EVP_MD_CTX;
    cipher : EVP_CIPHER_CTX;
  end;
  {$EXTERNALSYM PPEM_ENCODE_SEAL_CTX}
  PPEM_ENCODE_SEAL_CTX     = ^PEM_ENCODE_SEAL_CTX;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_SSL_COMP}
  STACK_OF_SSL_COMP = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_SSL_COMP}
  PSTACK_OF_SSL_COMP = ^STACK_OF_SSL_COMP;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_SSL_COMP}
  PSTACK_OF_SSL_COMP = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PPSTACK_OF_SSL_COMP}
  PPSTACK_OF_SSL_COMP = ^PSTACK_OF_SSL_COMP;
  {$EXTERNALSYM PSSL_COMP}
  PSSL_COMP = ^SSL_COMP;
  {$EXTERNALSYM lhash_of_SSL_SESSION}
  lhash_of_SSL_SESSION = record
    dummy : TIdC_INT;
  end;
  {$EXTERNALSYM Plhash_of_SSL_SESSION}
  Plhash_of_SSL_SESSION = ^lhash_of_SSL_SESSION;

  // PASN1_UTCTIME     = Pointer;

//GREGOR - spremenjana deklaracija ker se tole
//  Phostent	  = Pointer;
  {$NODEFINE Phostent2}
  Phostent2   = Pointer;
//END GREGOR
{ This should cause problems, but I will solve them ONLY if they came ...      }
{ !!!InvalidTypes!!!                                                           }
//END REMY
   //des.h
  // des_cblock   = Integer;
  {$EXTERNALSYM DES_cblock}
  DES_cblock = array[0..7] of Byte;
  {$EXTERNALSYM PDES_cblock}
  PDES_cblock = ^DES_cblock;
  {$EXTERNALSYM const_DES_cblock}
  const_DES_cblock = DES_cblock;
  {$EXTERNALSYM Pconst_DES_cblock}
  Pconst_DES_cblock = ^const_DES_cblock;
  // des_key_schedule = Integer;
  {$EXTERNALSYM DES_LONG}
  {$IFDEF DES_INT}
   DES_LONG = TIdC_UINT;
  {$ELSE}
  DES_LONG = TIdC_ULONG;
  {$ENDIF}
  {$EXTERNALSYM des_cblock_union}
  des_cblock_union = record
    case integer of
      0: (cblock: des_cblock);
      1: (deslong: array [0..1] of DES_LONG);
  end;
  {$EXTERNALSYM des_ks_struct}
  des_ks_struct = record
    ks : des_cblock_union;
    //IMPORTANT!!!
    //Since OpenSSL 0.9.7-dev, the OpenSSL  developers
    //dropped this member.  See:
    //http://marc.info/?l=openssl-dev&m=100342566217528&w=2

    weak_key: TIdC_INT;
  end;
  {$EXTERNALSYM des_key_schedule}
  des_key_schedule = array[0..15] of des_ks_struct;
  {$EXTERNALSYM des_cblocks}
  des_cblocks     = array[0..7] of byte;
  //des_cblocks     = Integer;
  //des_old.h
  {$EXTERNALSYM _ossl_old_des_cblock}
  _ossl_old_des_cblock = array [0..7] of byte;
  {$EXTERNALSYM P_ossl_old_des_cblock}
  P_ossl_old_des_cblock = ^_ossl_old_des_cblock;
  {$EXTERNALSYM _ossl_old_des_ks_union}
  _ossl_old_des_ks_union = record
    case Integer of
       0 : (_ : _ossl_old_des_cblock);
		//* make sure things are correct size on machines with
		//* 8 byte longs */
       2 : (pad : array [0..1] of DES_LONG);
  end;
  {$EXTERNALSYM _ossl_old_des_ks_struct}
  _ossl_old_des_ks_struct = record
    ks : _ossl_old_des_ks_union;
  end;
  {$EXTERNALSYM _ossl_old_des_key_schedule}
  _ossl_old_des_key_schedule = array [0..15] of _ossl_old_des_ks_struct;
  {$EXTERNALSYM P_ossl_old_des_key_schedule}
  P_ossl_old_des_key_schedule = ^_ossl_old_des_key_schedule;
{IMPORTANT!!!

In C, symbols are case sensitive while in Pascal, they are insensitive.
Thus, when we something like this:

#define des_cblock DES_cblock

we, should do something like this:

_des_cblock = DES_cblock
}
  {$EXTERNALSYM _des_cblock}
  {$EXTERNALSYM _des_key_schedule}
  {$IFNDEF OPENSSL_DES_LIBDES_COMPATIBILITY}
  _des_cblock = DES_cblock;
  {$EXTERNALSYM _const_des_cblock}
  _const_des_cblock = const_DES_cblock;
  _des_key_schedule = DES_key_schedule;
  {$ELSE}
///* libdes compatibility */
//* Map all symbol names to _ossl_old_des_* form, so we avoid all
//   clashes with libdes */
  _des_cblock = _ossl_old_des_cblock;
  _des_key_schedule = _ossl_old_des_key_schedule;
  {$ENDIF}
  {$EXTERNALSYM TIdSslLockingCallback}
  TIdSslLockingCallback = procedure (mode, n : TIdC_INT; Afile : PIdAnsiChar; line : TIdC_INT); cdecl;
  {$EXTERNALSYM TIdSslIdCallback}
  TIdSslIdCallback = function: TIdC_ULONG; cdecl;
///ssl_locl.h structs.  These are probably internal records so don't expose
//their members as ssl_lock.h is not included in the headers
//JPM
  {$EXTERNALSYM PSSL3_ENC_METHOD}
  PSSL3_ENC_METHOD = pointer;//^SSL3_ENC_METHOD;
//  SSL3_ENC_METHOD = record
//  end;
  {$EXTERNALSYM PCERT}
  PCERT = pointer;
  {$EXTERNALSYM PPCERT}
  PPCERT = ^PCERT;
  {$EXTERNALSYM PSESS_CERT}
  PSESS_CERT = pointer;
  //pkcs7.h
  {$EXTERNALSYM PPKCS7}
  PPKCS7 = ^PKCS7;
  {$EXTERNALSYM PPPKCS7}
  PPPKCS7 = ^PPKCS7;
  {$EXTERNALSYM PKCS7_ISSUER_AND_SERIAL}
  PKCS7_ISSUER_AND_SERIAL = record
    issuer : PX509_NAME;
    serial : PASN1_INTEGER;
  end;
  {$EXTERNALSYM PPKCS7_ISSUER_AND_SERIAL}
  PPKCS7_ISSUER_AND_SERIAL = ^PKCS7_ISSUER_AND_SERIAL;
  {$EXTERNALSYM PKCS7_SIGNER_INFO}
  PKCS7_SIGNER_INFO = record
    version : PASN1_INTEGER;  // version 1
    issuer_and_serial : PPKCS7_ISSUER_AND_SERIAL;
    digest_alg : PX509_ALGOR;
    auth_attr : PSTACK_OF_X509_ATTRIBUTE; // [ 0 ]
    digest_enc_alg : PX509_ALGOR;
    enc_digest :  PASN1_OCTET_STRING;
    unauth_attr : PSTACK_OF_X509_ATTRIBUTE; // [ 1 ]
    // The private key to sign with
    pkey : PEVP_PKEY;
  end;
  {$EXTERNALSYM PPKCS7_SIGNER_INFO}
  PPKCS7_SIGNER_INFO = ^PKCS7_SIGNER_INFO;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_PKCS7_SIGNER_INFO}
  STACK_OF_PKCS7_SIGNER_INFO = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_PKCS7_SIGNER_INFO}
  PSTACK_OF_PKCS7_SIGNER_INFO = ^STACK_OF_PKCS7_SIGNER_INFO;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_PKCS7_SIGNER_INFO}
  PSTACK_OF_PKCS7_SIGNER_INFO = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PKCS7_RECIP_INFO}
  PKCS7_RECIP_INFO = record
    version : PASN1_INTEGER;  // version 0
    issuer_and_serial : PPKCS7_ISSUER_AND_SERIAL;
    key_enc_algor : PX509_ALGOR;
    enc_key : PASN1_OCTET_STRING;
    cert : PX509; // get the pub-key from this
  end;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_PKCS7_RECIP_INFO}
  STACK_OF_PKCS7_RECIP_INFO = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_PKCS7_RECIP_INFO}
  PSTACK_OF_PKCS7_RECIP_INFO = ^STACK_OF_PKCS7_RECIP_INFO;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_PKCS7_RECIP_INFO}
  PSTACK_OF_PKCS7_RECIP_INFO = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM PPSTACK_OF_PKCS7_RECIP_INFO}
  PPSTACK_OF_PKCS7_RECIP_INFO = ^PSTACK_OF_PKCS7_RECIP_INFO;
  {$EXTERNALSYM PKCS7_SIGNED}
  PKCS7_SIGNED = record
    version : PASN1_INTEGER;  // version 1
    md_algs : PSTACK_OF_X509_ALGOR; // md used
    cert : PSTACK_OF_X509;    //  [ 0 ]
    crl : PSTACK_OF_X509_CRL; //  [ 1 ]
    signer_info : PSTACK_OF_PKCS7_SIGNER_INFO;
    contents : PPKCS7;
  end;
  {$EXTERNALSYM PPKCS7_SIGNED}
  PPKCS7_SIGNED = ^PKCS7_SIGNED;
  {$EXTERNALSYM PPPKCS7_SIGNED}
  PPPKCS7_SIGNED = ^PPKCS7_SIGNED;
  {$EXTERNALSYM PKCS7_ENC_CONTENT}
  PKCS7_ENC_CONTENT = record
    content_type : PASN1_OBJECT;
    algorithm : PX509_ALGOR;
    enc_data : PASN1_OCTET_STRING;  // [ 0 ]
    cipher : PEVP_CIPHER;
  end;
  {$EXTERNALSYM PPKCS7_ENC_CONTENT}
  PPKCS7_ENC_CONTENT = ^PKCS7_ENC_CONTENT;
  {$EXTERNALSYM PKCS7_ENVELOPE}
  PKCS7_ENVELOPE = record
    version : PASN1_INTEGER;  // version 0
    recipientinfo : PSTACK_OF_PKCS7_RECIP_INFO;
    enc_data : PPKCS7_ENC_CONTENT;
  end;
  {$EXTERNALSYM PPKCS7_ENVELOPE}
  PPKCS7_ENVELOPE = ^PKCS7_ENVELOPE;
  // OpenSSL developer notes
  // The above structure is very very similar to PKCS7_SIGN_ENVELOPE.
  // How about merging the two
  {$EXTERNALSYM PKCS7_SIGN_ENVELOPE}
  PKCS7_SIGN_ENVELOPE = record
    version : PASN1_INTEGER;  // version 1
    md_algs : PSTACK_OF_X509_ALGOR; // md used
    cert : PSTACK_OF_X509;    // [ 0 ]
    crl : PSTACK_OF_X509_CRL; // [ 1 ]
    signer_info : PSTACK_OF_PKCS7_SIGNER_INFO;
    enc_data : PPKCS7_ENC_CONTENT;
    recipientinfo : PSTACK_OF_PKCS7_RECIP_INFO;
  end;
  {$EXTERNALSYM PPKCS7_SIGN_ENVELOPE}
  PPKCS7_SIGN_ENVELOPE = ^PKCS7_SIGN_ENVELOPE;
  {$EXTERNALSYM PKCS7_DIGEST}
  PKCS7_DIGEST = record
    version : PASN1_INTEGER;  // version 0
    md : PX509_ALGOR;   // md used
    contents : PPKCS7;
    digest : PASN1_OCTET_STRING;
  end;
  {$EXTERNALSYM PPKCS7_DIGEST}
  PPKCS7_DIGEST = ^PKCS7_DIGEST;
  {$EXTERNALSYM PKCS7_ENCRYPT}
  PKCS7_ENCRYPT = record
    version : PASN1_INTEGER;  // version 0
    enc_data : PPKCS7_ENC_CONTENT;
  end;
  {$EXTERNALSYM PPKCS7_ENCRYPT}
  PPKCS7_ENCRYPT = ^PKCS7_ENCRYPT;
  {$EXTERNALSYM PKCS7_union}
  PKCS7_union = record
    // content as defined by the type
    // all encryption/message digests are applied to the 'contents',
    // leaving out the 'type' field.
    case Integer of
      0 : (ptr : PIdAnsiChar);
      // NID_pkcs7_data
      1 : (data : PASN1_OCTET_STRING);
      // NID_pkcs7_signed
      2 : (sign : PPKCS7_SIGNED);
      // NID_pkcs7_enveloped
      3 : (enveloped : PPKCS7_ENVELOPE);
      // NID_pkcs7_signedAndEnveloped
      4 : (signed_and_enveloped : PPKCS7_SIGN_ENVELOPE);
      // NID_pkcs7_digest
      5 : (digest : PPKCS7_DIGEST);
      // NID_pkcs7_encrypted
      6 : (encrypted : PPKCS7_ENCRYPT);
  end;
  {$EXTERNALSYM PKCS7}
  PKCS7 = record
    // The following is non NULL if it contains ASN1 encoding of
    // this structure
    asn1 : PIdAnsiChar;
    length : TIdC_LONG;
//#define PKCS7_S_HEADER  0
//#define PKCS7_S_BODY    1
//#define PKCS7_S_TAIL    2
    state : TIdC_INT; // used during processing
    detached : TIdC_INT;
    _type : PASN1_OBJECT;
    // content as defined by the type
    // all encryption/message digests are applied to the 'contents',
    // leaving out the 'type' field.
    d : PKCS7_union;
  end;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_PKCS7}
  STACK_OF_PKCS7 = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_PKCS7}
  PSTACK_OF_PKCS7 = ^STACK_OF_PKCS7;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_PKCS7}
  PSTACK_OF_PKCS7 = PSTACK;
  {$ENDIF}
  //pkcs12.h
  {$EXTERNALSYM PKCS12_MAC_DATA}
  PKCS12_MAC_DATA = record
    dinfo : PX509_SIG;
    salt : PASN1_OCTET_STRING;
    iter : PASN1_INTEGER; // defaults to 1
  end;
  {$EXTERNALSYM PPKCS12_MAC_DATA}
  PPKCS12_MAC_DATA = ^PKCS12_MAC_DATA;
 // PSESS_CERT = ^SESS_CERT;
  {$EXTERNALSYM PPKCS12}
  PPKCS12 = ^PKCS12;
  {$EXTERNALSYM PPPKCS12}
  PPPKCS12 = ^PPKCS12;
  {$EXTERNALSYM PKCS12}
  PKCS12 = record
    version : PASN1_INTEGER;
    mac : PPKCS12_MAC_DATA;
    authsafes : PPKCS7;
  end;
  //ts.h
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_EVP_MD}
  STACK_OF_EVP_MD = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_EVP_MD}
  PSTACK_OF_EVP_MD = ^STACK_OF_EVP_MD;
  {$EXTERNALSYM STACK_OF_ASN1_UTF8STRING}
  STACK_OF_ASN1_UTF8STRING = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_ASN1_UTF8STRING}
  PSTACK_OF_ASN1_UTF8STRING = ^STACK_OF_ASN1_UTF8STRING;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_EVP_MD}
  PSTACK_OF_EVP_MD = PSTACK;
  {$EXTERNALSYM PSTACK_OF_ASN1_UTF8STRING}
  PSTACK_OF_ASN1_UTF8STRING = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM TS_MSG_IMPRINT}
  TS_MSG_IMPRINT = record
	 hash_algo : PX509_ALGOR;
	 hashed_msg : PASN1_OCTET_STRING;
  end;
  {$EXTERNALSYM PTS_MSG_IMPRINT}
  PTS_MSG_IMPRINT = ^TS_MSG_IMPRINT;
  {$EXTERNALSYM TS_REQ}
  TS_REQ = record
	  version : PASN1_INTEGER;
	  msg_imprint : PTS_MSG_IMPRINT;
	  policy_id : PASN1_OBJECT;		//* OPTIONAL */
	  nonce : PASN1_INTEGER;		//* OPTIONAL */
    cert_req : ASN1_BOOLEAN;		//* DEFAULT FALSE */
	  extensions : PSTACK_OF_X509_EXTENSION;	//* [0] OPTIONAL */
  end;
  {$EXTERNALSYM PTS_REQ}
  PTS_REQ = ^TS_REQ;
  {$EXTERNALSYM TS_ACCURACY}
  TS_ACCURACY = record
	  seconds : PASN1_INTEGER;
	  millis : PASN1_INTEGER;
	  micros : PASN1_INTEGER;
  end;
  {$EXTERNALSYM PTS_ACCURACY}
  PTS_ACCURACY = ^TS_ACCURACY;
  {$EXTERNALSYM TS_TST_INFO}
  TS_TST_INFO = record
	  version : PASN1_INTEGER;
	  policy_id : PASN1_OBJECT;
	  msg_imprint : PTS_MSG_IMPRINT;
	  serial : PASN1_INTEGER;
	  time : PASN1_GENERALIZEDTIME;
	  accuracy : PTS_ACCURACY;
	  ordering : PASN1_BOOLEAN;
	  nonce : PASN1_INTEGER;
	  tsa : PGENERAL_NAME;
    extensions : PSTACK_OF_X509_EXTENSION;
  end;
  {$EXTERNALSYM PTS_TST_INFO}
  PTS_TST_INFO = ^TS_TST_INFO;
  {$EXTERNALSYM TS_STATUS_INFO}
  TS_STATUS_INFO = record
	  status : PASN1_INTEGER;
	  text : PSTACK_OF_ASN1_UTF8STRING;
	  failure_info : PASN1_BIT_STRING;
  end;
  {$EXTERNALSYM PTS_STATUS_INFO}
  PTS_STATUS_INFO = ^TS_STATUS_INFO;
  {$EXTERNALSYM TS_RESP}
  TS_RESP = record
  	status_info : PTS_STATUS_INFO;
	  token : PPKCS7;
	  tst_info : PTS_TST_INFO;
  end;
  {$EXTERNALSYM PTS_RESP}
  PTS_RESP = ^TS_RESP;
  {$EXTERNALSYM ESS_ISSUER_SERIAL}
  ESS_ISSUER_SERIAL = record
  	issuer : PSTACK_OF_GENERAL_NAME;
    serial : PASN1_INTEGER;
  end;
  {$EXTERNALSYM PESS_ISSUER_SERIAL}
  PESS_ISSUER_SERIAL = ^ESS_ISSUER_SERIAL;
  {$EXTERNALSYM ESS_CERT_ID}
  ESS_CERT_ID = record
    hash : PASN1_OCTET_STRING;	//* Always SHA-1 digest. */
    issuer_serial : PESS_ISSUER_SERIAL;
  end;
  {$EXTERNALSYM PESS_CERT_ID}
  PESS_CERT_ID = ^ESS_CERT_ID;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_ESS_CERT_ID}
  STACK_OF_ESS_CERT_ID = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_ESS_CERT_ID}
  PSTACK_OF_ESS_CERT_ID = ^STACK_OF_ESS_CERT_ID;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_ESS_CERT_ID}
  PSTACK_OF_ESS_CERT_ID = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM ESS_SIGNING_CERT}
  ESS_SIGNING_CERT = record
	 cert_ids : PSTACK_OF_ESS_CERT_ID;
	 policy_info : PSTACK_OF_POLICYINFO;
  end;
  {$EXTERNALSYM PESS_SIGNING_CERT}
  PESS_SIGNING_CERT = ^ESS_SIGNING_CERT;
  {$EXTERNALSYM PTS_resp_ctx}
  PTS_resp_ctx = ^TS_resp_ctx;
//* This must return a unique number less than 160 bits long. */
//typedef ASN1_INTEGER *(*TS_serial_cb)(struct TS_resp_ctx *, void *);
  {$EXTERNALSYM TS_serial_cb}
  TS_serial_cb = function (p1 : PTS_resp_ctx; p2 : Pointer) : PASN1_INTEGER cdecl;
  //* This must return the seconds and microseconds since Jan 1, 1970 in
 //  the sec and usec variables allocated by the caller.
 //  Return non-zero for success and zero for failure. */
//typedef	int (*TS_time_cb)(struct TS_resp_ctx *, void *, long *sec, long *usec);
  {$EXTERNALSYM TS_time_cb}
  TS_time_cb = function (p1 : PTS_resp_ctx; p2 : Pointer; sec, usec : TIdC_LONG) : TIdC_INT cdecl;
///* This must process the given extension.
// * It can modify the TS_TST_INFO object of the context.
// * Return values: !0 (processed), 0 (error, it must set the
// * status info/failure info of the response).
// */
//typedef	int (*TS_extension_cb)(struct TS_resp_ctx *, X509_EXTENSION *, void *);
  {$EXTERNALSYM TS_extension_cb}
  TS_extension_cb = function (p1 : PTS_resp_ctx; p2 : PX509_EXTENSION; p3 : Pointer) : TIdC_INT cdecl;
  {$EXTERNALSYM TS_RESP_CTX}
  TS_RESP_CTX = record
		signer_cert : PX509;
		signer_key : PEVP_PKEY;
	  certs : PSTACK_OF_X509;	//* Certs to include in signed data. */
	  policies : PSTACK_OF_ASN1_OBJECT;	//* Acceptable policies. */
		default_policy : PASN1_OBJECT; //* It may appear in policies, too. */
	  mds : PSTACK_OF_EVP_MD;	//* Acceptable message digests. */
		seconds : PASN1_INTEGER;	//* accuracy, 0 means not specified. */
		millis : PASN1_INTEGER;	//* accuracy, 0 means not specified. */
		micros : PASN1_INTEGER;	//* accuracy, 0 means not specified. */
		clock_precision_digits : TIdC_UNSIGNED; //* fraction of seconds in
						   //time stamp token. */
		flags : TIdC_UNSIGNED;		//* Optional info, see values above. */

	//* Callback functions. */
	  serial_cb : TS_serial_cb;
	  serial_cb_data : Pointer;	//* User data for serial_cb. */

	  time_cb : TS_time_cb;
	  time_cb_data : Pointer;	//* User data for time_cb. */

	  extension_cb : TS_extension_cb;
	  extension_cb_data : Pointer;	//* User data for extension_cb. */

	//* These members are used only while creating the response. */
		request : PTS_REQ;
		response : PTS_RESP;
		tst_info : PTS_TST_INFO;
  end;
  {$EXTERNALSYM TS_VERIFY_CTX}
  TS_VERIFY_CTX = record
  	//* Set this to the union of TS_VFY_... flags you want to carry out. */
		flags : TIdC_UNSIGNED;

	//* Must be set only with TS_VFY_SIGNATURE. certs is optional. */
		store : PX509_STORE;
	  certs : PSTACK_OF_X509;

	//* Must be set only with TS_VFY_POLICY. */
		policy : PASN1_OBJECT;

//	/* Must be set only with TS_VFY_IMPRINT. If md_alg is NULL,
//	   the algorithm from the response is used. */
		md_alg : PX509_ALGOR;
	  imprint : PIdAnsiChar;
		imprint_len : TIdC_UNSIGNED;

	//* Must be set only with TS_VFY_DATA. */
	  data : PBIO;

	//* Must be set only with TS_VFY_TSA_NAME. */
		nonce : PASN1_INTEGER;

	//* Must be set only with TS_VFY_TSA_NAME. */
    tsa_name : PGENERAL_NAME;
  end;
  {$EXTERNALSYM PTS_VERIFY_CTX}
  PTS_VERIFY_CTX = ^TS_VERIFY_CTX;
  //comp.h
  {$EXTERNALSYM PCOMP_CTX}
  PCOMP_CTX = ^COMP_CTX;
  {$EXTERNALSYM COMP_METHOD}
  COMP_METHOD = record
    _type : TIdC_INT; // NID for compression library
    name : PIdAnsiChar; // A text string to identify the library
    init : function (ctx : PCOMP_CTX) : TIdC_INT; cdecl;
    finish : procedure (ctx : PCOMP_CTX); cdecl;
    compress : function (ctx : PCOMP_CTX;
      _out : PIdAnsiChar; olen : TIdC_UINT;
      _in : PIdAnsiChar; ilen : TIdC_UINT) : TIdC_INT; cdecl;
    expand : function  (ctx : PCOMP_CTX;
      _out : PIdAnsiChar; olen : TIdC_UINT;
      _in : PIdAnsiChar; ilen : TIdC_UINT) : TIdC_INT; cdecl;
    // The following two do NOTHING, but are kept for backward compatibility
    ctrl : function : TIdC_INT; cdecl;
    callback_ctrl : function : TIdC_INT; cdecl;
  end;
  {$EXTERNALSYM PCOMP_METHOD}
  PCOMP_METHOD = ^COMP_METHOD;
  {$EXTERNALSYM COMP_CTX}
  COMP_CTX = record
    meth : PCOMP_METHOD;
    compress_in : TIdC_ULONG;
    compress_out : TIdC_ULONG;
    expand_in : TIdC_ULONG;
    expand_out : TIdC_ULONG;
    ex_data : PCRYPTO_EX_DATA;
  end;
  //srp.h
   {$EXTERNALSYM SRP_gN_cache}
  SRP_gN_cache = record
    b64_bn : PIdAnsiChar;
    bn : PBIGNUM;
  end;
  {$EXTERNALSYM PSRP_gN_cache}
  PSRP_gN_cache = ^SRP_gN_cache;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_SRP_gN_cache}
  STACK_OF_SRP_gN_cache = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_SRP_gN_cache}
  PSTACK_OF_SRP_gN_cache = ^STACK_OF_SRP_gN_cache;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_SRP_gN_cache}
  PSTACK_OF_SRP_gN_cache = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM SRP_user_pwd}
  SRP_user_pwd = record
	  id  : PIdAnsiChar;
   	s : PBIGNUM;
   	v : PBIGNUM;
	  g : PBIGNUM;
	  N : PBIGNUM;
    info : PIdAnsiChar;
  end;
  {$EXTERNALSYM PSRP_user_pwd}
  PSRP_user_pwd = ^SRP_user_pwd;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_SRP_user_pwd}
  STACK_OF_SRP_user_pwd = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_SRP_user_pwd}
  PSTACK_OF_SRP_user_pwd = ^STACK_OF_SRP_user_pwd;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_SRP_user_pwd}
  PSTACK_OF_SRP_user_pwd = PSTACK;
  {$ENDIF}
  {$EXTERNALSYM SRP_VBASE}
  SRP_VBASE = record
	  users_pwd : PSTACK_OF_SRP_user_pwd;
	  gN_cache : PSTACK_OF_SRP_gN_cache;
//* to simulate a user */
    seed_key : PIdAnsiChar;
    default_g : PBIGNUM;
    default_N : PBIGNUM;
	end;
  {$EXTERNALSYM PSRP_VBASE}
  PSRP_VBASE = ^SRP_VBASE;

//*Structure interne pour retenir les couples N et g*/
  {$EXTERNALSYM SRP_gN}
  SRP_gN = record
    id : PIdAnsiChar;
    g : PBIGNUM;
    N : PBIGNUM;
  end;
  {$EXTERNALSYM PSRP_gN}
  PSRP_gN = ^SRP_gN;

  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_SRP_gN}
  STACK_OF_SRP_gN = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_SRP_gN}
  PSTACK_OF_SRP_gN = ^STACK_OF_SRP_gN;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_SRP_gN}
  PSTACK_OF_SRP_gN = PSTACK;
  {$ENDIF}
  //kssl.h
  {These are structures for Kerberos support.  These will not be complete because
  FreePascal, Borland Delphi, and Indy don't support Kerberos.  These are here
  as place holders so we get an exact OpenSSL API if Kerberos support was compiled
  in.
  }
  {$IFNDEF OPENSSL_NO_KRB5}
  {$EXTERNALSYM KSSL_ERR}
  KSSL_ERR = record
    reason : TIdC_INT;
      text : array [0..KSSL_ERR_MAX] of Char;
  end;
  {$EXTERNALSYM PKSSL_CTX}
    {I am not going to do anything to define this because it uses things in the
    Kerberos API.  Since there's no support for Kerberos, I'm leaving it empty.
    We only need the pointer anyway}

  PKSSL_CTX = Pointer; //^KSSL_CTX;
  {$ENDIF}
  //ssl.h
  {$ifndef OPENSSL_NO_SSL_INTERN}
  {$EXTERNALSYM PSSL_CIPHER}
  PSSL_CIPHER = ^SSL_CIPHER;
  {$EXTERNALSYM SSL_CIPHER}
  SSL_CIPHER = record
    valid : TIdC_INT;
    name: PIdAnsiChar;  // text name
    id: TIdC_ULONG; // id, 4 bytes, first is version

    //* changed in 0.9.9: these four used to be portions of a single value 'algorithms' */
    algorithm_mkey : TIdC_ULONG;	//* key exchange algorithm */
    algorithm_auth : TIdC_ULONG;	//* server authentication */
    algorithm_enc : TIdC_ULONG;	//* symmetric encryption */
    algorithm_mac : TIdC_ULONG;	//* symmetric authentication */
    algorithm_ssl : TIdC_ULONG;	//* (major) protocol version */
    algo_strength: TIdC_ULONG; // strength and export flags
    algorithm2: TIdC_ULONG;// Extra flags
    strength_bits: TIdC_INT;  // Number of bits really used
    alg_bits: TIdC_INT;     // Number of bits for algorithm
  end;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_SSL_CIPHER}
  STACK_OF_SSL_CIPHER = record
    _stack: STACK;
  end;
  {$EXTERNALSYM PSTACK_OF_SSL_CIPHER}
  PSTACK_OF_SSL_CIPHER = ^STACK_OF_SSL_CIPHER;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_SSL_CIPHER}
  PSTACK_OF_SSL_CIPHER = PSTACK;
  {$ENDIF}

  {$EXTERNALSYM PSSL_SESSION}
  PSSL_SESSION = ^SSL_SESSION;
  {$EXTERNALSYM SSL_SESSION}
  SSL_SESSION = record
    ssl_version : TIdC_INT; // what ssl version session info is being kept in here?
    // only really used in SSLv2
    key_arg_length: TIdC_UINT;
    key_arg: Array[0..SSL_MAX_KEY_ARG_LENGTH-1] of Byte;
    master_key_length: TIdC_INT;
    master_key: Array[0..SSL_MAX_MASTER_KEY_LENGTH-1] of Byte;
    // session_id - valid?
    session_id_length: TIdC_UINT;
    session_id: Array[0..SSL_MAX_SSL_SESSION_ID_LENGTH-1] of Byte;
    // this is used to determine whether the session is being reused in
    // the appropriate context. It is up to the application to set this,
    // via SSL_new
    sid_ctx_length: TIdC_UINT;
    sid_ctx: array[0..SSL_MAX_SID_CTX_LENGTH-1] of Byte;
    {$IFNDEF OPENSSL_NO_KRB5}
    krb5_client_princ_len: TIdC_UINT;
    krb5_client_princ: array[0..SSL_MAX_KRB5_PRINCIPAL_LENGTH-1] of Byte;
    {$ENDIF}
{$ifndef OPENSSL_NO_PSK}
	  psk_identity_hint : PIdAnsiChar;
	  psk_identity : PIdAnsiChar;
{$endif}
    not_resumable: TIdC_INT;
    // The cert is the certificate used to establish this connection
    sess_cert :  PSESS_CERT;

	//* This is the cert for the other end.
	// * On clients, it will be the same as sess_cert->peer_key->x509
	// * (the latter is not enough as sess_cert is not retained
	// * in the external representation of sessions, see ssl_asn1.c). */
	  peer : PX509;
	//* when app_verify_callback accepts a session where the peer's certificate
	// * is not ok, we must remember the error for session reuse: */
	  verify_result : TIdC_LONG; //* only for servers */
	  references : TIdC_INT;
	  timeout : TIdC_LONG;
	  time : TIdC_LONG;
	  compress_meth : TIdC_UINT;	//* Need to lookup the method */

	  cipher : PSSL_CIPHER;
	  cipher_id : TIdC_ULONG;	//* when ASN.1 loaded, this
					// * needs to be used to load
					// * the 'cipher' structure */
    ciphers : PSTACK_OF_SSL_CIPHER; //* shared ciphers? */
    ex_data : CRYPTO_EX_DATA; // application specific data */
	//* These are used to make removal of session-ids more
	// * efficient and to implement a maximum cache size. */
	  prev, next : PSSL_SESSION;

    {$IFNDEF OPENSSL_NO_TLSEXT}
    tlsext_hostname : PIdAnsiChar;
      {$IFDEF OPENSSL_NO_EC}
	  tlsext_ecpointformatlist_length : size_t;
	  tlsext_ecpointformatlist : PIdAnsiChar; //* peer's list */
	  tlsext_ellipticcurvelist_length : size_t;
	  tlsext_ellipticcurvelist : PIdAnsiChar; //* peer's list */
      {$ENDIF} //* OPENSSL_NO_EC */

 //* RFC4507 info */
    tlsext_tick : PIdAnsiChar;//* Session ticket */
    tlsext_ticklen : size_t;//* Session ticket length */
    tlsext_tick_lifetime_hint : TIdC_LONG;//* Session lifetime hint in seconds */
    {$ENDIF}
{$ifndef OPENSSL_NO_SRP}
	  srp_username : PIdAnsiChar;
{$endif}
  end;
  {$ENDIF}

{$ifndef OPENSSL_NO_SRP}

{$ifndef OPENSSL_NO_SSL_INTERN}

  {$EXTERNALSYM SRP_CTX}
  SRP_CTX = record
	//* param for all the callbacks */
	  SRP_cb_arg : Pointer;
	//* set client Hello login callback */
    TLS_ext_srp_username_callback : function(para1 : PSSL; para2 : TIdC_INT; para3 : Pointer) : TIdC_INT cdecl;
	//int (*TLS_ext_srp_username_callback)(SSL *, int *, void *);
	//* set SRP N/g param callback for verification */
    SRP_verify_param_callback : function(para1 : PSSL; para2 : Pointer) : TIdC_INT cdecl;
//	int (*SRP_verify_param_callback)(SSL *, void *);
	//* set SRP client passwd callback */
    SRP_give_srp_client_pwd_callback : function(para1 : PSSL; para2 : Pointer) : PIdAnsiChar cdecl;
  //	char *(*SRP_give_srp_client_pwd_callback)(SSL *, void *);
    login : PIdAnsiChar;
   	N, g, s, B, A : PBIGNUM;
   	_a, _b, v : PBIGNUM;
	  info : PIdAnsiChar;
	  strength : TIdC_INT;
    srp_Mask : TIdC_ULONG;
	end;
  {$EXTERNALSYM PSRP_CTX}
  PSRP_CTX = ^SRP_CTX;
{$endif}
{$ENDIF}
  // typedef struct ssl_method_st
  {$NODEFINE PSSL_CTX}
  PSSL_CTX = ^SSL_CTX;
  {$EXTERNALSYM SRTP_PROTECTION_PROFILE}
  SRTP_PROTECTION_PROFILE = record
    name : PIdAnsiChar;
    id : TIdC_ULONG;
  end;
 {$EXTERNALSYM PTLS_SESSION_TICKET_EXT}
  PTLS_SESSION_TICKET_EXT = ^TLS_SESSION_TICKET_EXT;
 {$EXTERNALSYM TLS_SESSION_TICKET_EXT}
  TLS_SESSION_TICKET_EXT = record
    length : TIdC_USHORT;
    data : Pointer;
  end;
  {$EXTERNALSYM PSRTP_PROTECTION_PROFILE}
  PSRTP_PROTECTION_PROFILE = ^SRTP_PROTECTION_PROFILE;
  {$EXTERNALSYM tls_session_ticket_ext_cb_fn}
  tls_session_ticket_ext_cb_fn = function(S : PSSL; data : PIdAnsiChar; len : TIdC_INT; arg : Pointer) : TIdC_INT cdecl;
  {$EXTERNALSYM tls_session_secret_cb_fn}
  tls_session_secret_cb_fn = function(S : PSSL;
    secret : Pointer;
    var secret_len : TIdC_INT;
    peer_ciphers : PSTACK_OF_SSL_CIPHER;
    out cipher : PSSL_CIPHER) : TIdC_INT cdecl;
  {$EXTERNALSYM SSL_METHOD_PROC}
  SSL_METHOD_PROC = procedure; cdecl;
  {$NODEFINE PSSL_METHOD}
  PSSL_METHOD = ^SSL_METHOD;
  {$NODEFINE SSL_METHOD}
  SSL_METHOD = record
     version: TIdC_INT;
     ssl_new: function(s: PSSL): TIdC_INT; cdecl;
     ssl_clear: procedure(s: PSSL); cdecl;
     ssl_free: procedure(s: PSSL); cdecl;
     ssl_accept: function(s: PSSL): TIdC_INT; cdecl;
     ssl_connect: function(s: PSSL): TIdC_INT; cdecl;
     ssl_read: function(s: PSSL; buf: Pointer; len: TIdC_INT):TIdC_INT; cdecl;
     ssl_peek: function(s: PSSL; buf: Pointer; len: TIdC_INT):TIdC_INT; cdecl;
     ssl_write: function(s: PSSL; const buf: Pointer; len:TIdC_INT): TIdC_INT; cdecl;
     ssl_shutdown: function(s: PSSL): TIdC_INT; cdecl;
     ssl_renegotiate: function(s: PSSL): TIdC_INT; cdecl;
     ssl_renegotiate_check: function(s: PSSL): TIdC_INT; cdecl;
     ssl_get_message: function(s: PSSL; st1, stn, mt: TIdC_INT; max: TIdC_LONG; ok: PIdC_INT): TIdC_LONG; cdecl;
     ssl_read_bytes: function(s: PSSL; _type: TIdC_INT; buf:PByte; len, peek: TIdC_INT): TIdC_INT; cdecl;
     ssl_write_bytes: function(s: PSSL; _type: TIdC_INT; const buf: Pointer; len: TIdC_INT): TIdC_INT; cdecl;
     ssl_dispatch_alert: function(s: PSSL): TIdC_INT; cdecl;
     ssl_ctrl: function(s: PSSL; cmd: TIdC_INT; larg: TIdC_LONG; parg: Pointer): TIdC_LONG; cdecl;
     ssl_ctx_ctrl: function(ctx: PSSL_CTX; cmd: TIdC_INT; larg:TIdC_LONG; parg: Pointer): TIdC_LONG; cdecl;
     get_cipher_by_char: function(const ptr: PByte):PSSL_CIPHER; cdecl;
     put_cipher_by_char: function(const cipher: PSSL_CIPHER;ptr: PByte): TIdC_INT; cdecl;
     ssl_pending: function(const s: PSSL): TIdC_INT; cdecl;
     num_ciphers: function: TIdC_INT; cdecl;
     get_cipher: function(ncipher: TIdC_UNSIGNED): PSSL_CIPHER;cdecl;
     get_ssl_method: function(version: TIdC_INT): PSSL_METHOD; cdecl;
     get_timeout: function : TIdC_LONG; cdecl;
     ssl3_enc: PSSL3_ENC_METHOD;
     ssl_version: function : TIdC_INT; cdecl;
     ssl_callback_ctrl: function(s: PSSL; cb_id: TIdC_INT; fp: SSL_METHOD_PROC): TIdC_LONG; cdecl;
     ssl_ctx_callback_ctrl: function(s: PSSL_CTX; cb_id:TIdC_INT; fp: SSL_METHOD_PROC): TIdC_LONG; cdecl;
  end;
  {$EXTERNALSYM PPSSL_METHOD}
  PPSSL_METHOD  =^PSSL_METHOD;
// This callback type is used inside SSL_CTX, SSL, and in the functions that set
// them. It is used to override the generation of SSL/TLS session IDs in a
// server. Return value should be zero on an error, non-zero to proceed. Also,
// callbacks should themselves check if the id they generate is unique otherwise
// the SSL handshake will fail with an error - callbacks can do this using the
// 'ssl' value they're passed by;
//      SSL_has_matching_session_id(ssl, id, *id_len)
// The length value passed in is set at the maximum size the session ID can be.
// In SSLv2 this is 16 bytes, whereas SSLv3/TLSv1 it is 32 bytes. The callback
// can alter this length to be less if desired, but under SSLv2 session IDs are
// supposed to be fixed at 16 bytes so the id will be padded after the callback
// returns in this case. It is also an error for the callback to set the size to
// zero.
  {$EXTERNALSYM PGEN_SESSION_CB}
  PGEN_SESSION_CB = function (const SSL : PSSL; id : PByte; id_len : TIdC_UINT) : TIdC_INT; cdecl;
  {$EXTERNALSYM SSL_COMP}
  SSL_COMP = record
    id : TIdC_INT;
    name : PIdAnsiChar;
    {$IFNDEF OPENSSL_NO_COMP}
    method : PCOMP_METHOD;
    {$ELSE}
    method : PIdAnsiChar;
    {$ENDIF}
  end;
  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_COMP}
  STACK_OF_COMP = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_COMP}
  PSTACK_OF_COMP = ^STACK_OF_COMP;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_COMP}
  PSTACK_OF_COMP = PSTACK;
  {$ENDIF}

  {$EXTERNALSYM PSSL_CTEX_tlsext_servername_callback}
  PSSL_CTEX_tlsext_servername_callback = function(ssl : PSSL; Para1 : TIdC_INT; Para2 : Pointer) : TIdC_INT; cdecl;
  {$EXTERNALSYM PSSL_CTX_info_callback}
  PSSL_CTX_info_callback = procedure (const ssl : PSSL; _type, val : TIdC_INT); cdecl; // used if SSL's info_callback is NULL
//int (*tlsext_ticket_key_cb)(SSL *ssl,
//					unsigned char *name, unsigned char *iv,
//					EVP_CIPHER_CTX *ectx,
//					HMAC_CTX *hctx, int enc);
  {$EXTERNALSYM Ptlsext_ticket_key_cb}
  Ptlsext_ticket_key_cb = function (ssl : PSSL; name, iv : PIdAnsiChar;
    ectx : PEVP_CIPHER_CTX;
    hctx : PHMAC_CTX; enc : TIdC_INT) : TIdC_INT; cdecl;
//	int (*tlsext_status_cb)(SSL *ssl, void *arg);
  {$EXTERNALSYM Ptlsext_status_cb}
  Ptlsext_status_cb = function (ssl : PSSL; arg : Pointer) : TIdC_INT; cdecl;
  {$EXTERNALSYM SSL_CTX_stats}
  SSL_CTX_stats = record
    sess_connect: TIdC_INT;  // SSL new conn - started
    sess_connect_renegotiate: TIdC_INT;  // SSL reneg - requested
    sess_connect_good: TIdC_INT; // SSL new conne/reneg - finished
    sess_accept: TIdC_INT;    // SSL new accept - started
    sess_accept_renegotiate: TIdC_INT; // SSL reneg - requested
    sess_accept_good: TIdC_INT;  // SSL accept/reneg - finished
    sess_miss: TIdC_INT;  // session lookup misses
    sess_timeout: TIdC_INT; // reuse attempt on timeouted session
    sess_cache_full: TIdC_INT; // session removed due to full cache
    sess_hit: TIdC_INT; // session reuse actually done
    sess_cb_hit: TIdC_INT; // session-id that was not
                          // in the cache was
                          // passed back via the callback.  This
                          // indicates that the application is
                          // supplying session-id's from other
                          // processes - spooky :-)
  end;
  {$EXTERNALSYM lash_of_SSL_SESSION}
  lash_of_SSL_SESSION = record
   dummy : TIdC_INT;
  end;
  {$EXTERNALSYM Plash_of_SSL_SESSION}
  Plash_of_SSL_SESSION = ^lash_of_SSL_SESSION;
{$ifndef OPENSSL_NO_BUF_FREELISTS}
  {$EXTERNALSYM Pssl3_buf_freelist_st}
  Pssl3_buf_freelist_st = Pointer;
{$endif}

  {$IFDEF DEBUG_SAFESTACK}
  {$EXTERNALSYM STACK_OF_SRTP_PROTECTION_PROFILE}
  STACK_OF_SRTP_PROTECTION_PROFILE = record
    _stack: stack;
  end;
  {$EXTERNALSYM PSTACK_OF_SRTP_PROTECTION_PROFILE}
  PSTACK_OF_SRTP_PROTECTION_PROFILE = ^STACK_OF_SRTP_PROTECTION_PROFILE;
  {$ELSE}
  //I think the DECLARE_STACK_OF macro is empty
  {$EXTERNALSYM PSTACK_OF_SRTP_PROTECTION_PROFILE}
  PSTACK_OF_SRTP_PROTECTION_PROFILE = PSTACK;
  {$ENDIF}
  {$NODEFINE SSL_CTX}
  SSL_CTX = record
    method: PSSL_METHOD;
    cipher_list: PSTACK_OF_SSL_CIPHER;
    // same as above but sorted for lookup
    cipher_list_by_id: PSTACK_OF_SSL_CIPHER;
    cert_store: PX509_STORE;
    sessions: Plash_of_SSL_SESSION;
    // a set of SSL_SESSIONs
    // Most session-ids that will be cached, default is
    // SSL_SESSION_CACHE_MAX_SIZE_DEFAULT. 0 is unlimited.
    session_cache_size: TIdC_ULONG;
    session_cache_head: PSSL_SESSION;
    session_cache_tail: PSSL_SESSION;
    // This can have one of 2 values, ored together,
    // SSL_SESS_CACHE_CLIENT,
    // SSL_SESS_CACHE_SERVER,
    // Default is SSL_SESSION_CACHE_SERVER, which means only
    // SSL_accept which cache SSL_SESSIONS.
    session_cache_mode: TIdC_INT;
    session_timeout: TIdC_LONG;
    // If this callback is not null, it will be called each
    // time a session id is added to the cache.  If this function
    // returns 1, it means that the callback will do a
    // SSL_SESSION_free() when it has finished using it.  Otherwise,
    // on 0, it means the callback has finished with it.
    // If remove_session_cb is not null, it will be called when
    // a session-id is removed from the cache.  After the call,
    // OpenSSL will SSL_SESSION_free() it.
    new_session_cb: function (ssl : PSSL; sess: PSSL_SESSION): TIdC_INT; cdecl;
    remove_session_cb: procedure (ctx : PSSL_CTX; sess : PSSL_SESSION); cdecl;
    get_session_cb: function (ssl : PSSL; data : PByte; len: TIdC_INT; copy : PIdC_INT) : PSSL_SESSION; cdecl;
    stats : SSL_CTX_stats;
    
    references: TIdC_INT;
    // if defined, these override the X509_verify_cert() calls
    app_verify_callback: function (_para1 : PX509_STORE_CTX; _para2 : Pointer) : TIdC_INT; cdecl;
    app_verify_arg: Pointer;
    // before OpenSSL 0.9.7, 'app_verify_arg' was ignored
    // ('app_verify_callback' was called with just one argument)
    // Default password callback.
    default_passwd_callback: ppem_password_cb;
    // Default password callback user data.
    default_passwd_callback_userdata: Pointer;
    // get client cert callback
    client_cert_cb: function (SSL : PSSL; x509 : PPX509; pkey : PPEVP_PKEY) : TIdC_INT; cdecl;
    // verify cookie callback
    app_gen_cookie_cb: function (ssl : PSSL; cookie : PByte; cookie_len : TIdC_UINT) : TIdC_INT; cdecl;
    app_verify_cookie_cb: Pointer;
    ex_data : CRYPTO_EX_DATA;
    rsa_md5 : PEVP_MD; // For SSLv2 - name is 'ssl2-md5'
    md5: PEVP_MD; // For SSLv3/TLSv1 'ssl3-md5'
    sha1: PEVP_MD; // For SSLv3/TLSv1 'ssl3->sha1'
    extra_certs: PSTACK_OF_X509;
    comp_methods: PSTACK_OF_COMP; // stack of SSL_COMP, SSLv3/TLSv1
    // Default values used when no per-SSL value is defined follow
    info_callback: PSSL_CTX_info_callback; // used if SSL's info_callback is NULL
    // what we put in client cert requests
    client_CA : PSTACK_OF_X509_NAME;
    // Default values to use in SSL structures follow (these are copied by SSL_new)
    options : TIdC_ULONG;
    mode : TIdC_ULONG;
    max_cert_list : TIdC_LONG;
    cert : PCERT;
    read_ahead : TIdC_INT;
    // callback that allows applications to peek at protocol messages
    msg_callback : procedure (write_p, version, content_type : TIdC_INT; const buf : Pointer; len : size_t; ssl : PSSL; arg : Pointer); cdecl;
    msg_callback_arg : Pointer;
    verify_mode : TIdC_INT;
    sid_ctx_length : TIdC_UINT;
    sid_ctx : array[0..SSL_MAX_SID_CTX_LENGTH - 1] of TIdAnsiChar;
    default_verify_callback : function(ok : TIdC_INT; ctx : PX509_STORE_CTX) : TIdC_INT; cdecl; // called 'verify_callback' in the SSL
    // Default generate session ID callback.
    generate_session_id : PGEN_SESSION_CB;
    param : PX509_VERIFY_PARAM;
    {$IFDEF OMIT_THIS}
    purpose : TIdC_INT;  // Purpose setting
    trust : TIdC_INT;    // Trust setting
    {$ENDIF}

    quiet_shutdown : TIdC_INT;
	//* Maximum amount of data to send in one fragment.
	// * actual record size can be more than this due to
	// * padding and MAC overheads.
	// */
	  max_send_fragment : TIdC_UINT;
    {$IFNDEF OPENSSL_ENGINE}
	///* Engine to pass requests for client certs to
	// */
	  client_cert_engine : PENGINE;
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_TLSEXT}
//* TLS extensions servername callback */
    tlsext_servername_callback : PSSL_CTEX_tlsext_servername_callback;
    tlsext_servername_arg : Pointer;
    //* RFC 4507 session ticket keys */
    tlsext_tick_key_name : array [0..(16-1)] of TIdAnsiChar;
    tlsext_tick_hmac_key : array [0..(16-1)] of TIdAnsiChar;
    tlsext_tick_aes_key : array [0..(16-1)] of TIdAnsiChar;
	//* Callback to support customisation of ticket key setting */
 //	int (*tlsext_ticket_key_cb)(SSL *ssl,
 //					unsigned char *name, unsigned char *iv,
 //					EVP_CIPHER_CTX *ectx,
 //					HMAC_CTX *hctx, int enc);
    tlsext_ticket_key_cb : Ptlsext_ticket_key_cb;
	//* certificate status request info */
	//* Callback for status request */
	//int (*tlsext_status_cb)(SSL *ssl, void *arg);
    tlsext_status_cb : Ptlsext_status_cb;
	  tlsext_status_arg : Pointer;
    {$ENDIF}
	//* draft-rescorla-tls-opaque-prf-input-00.txt information */
     tlsext_opaque_prf_input_callback : function(para1 : PSSL; peerinput : Pointer; len : size_t; arg : Pointer ) : TIdC_INT cdecl;
	//int (*tlsext_opaque_prf_input_callback)(SSL *, void *peerinput, size_t len, void *arg);
     tlsext_opaque_prf_input_callback_arg : Pointer;

{$ifndef OPENSSL_NO_PSK}
	   psk_identity_hint : PIdAnsiChar;
     psk_client_callback : function (ssl : PSSL; hint : PIdAnsiChar;
       identity : PIdAnsiChar; max_identity_len : TIdC_UINT;
       psk : PIdAnsiChar; max_psk_len : TIdC_UINT ) : TIdC_UINT cdecl;
 //	unsigned int (*psk_client_callback)(SSL *ssl, const char *hint, char *identity,
//		unsigned int max_identity_len, unsigned char *psk,
//		unsigned int max_psk_len);
     psk_server_callback : function (ssl : PSSL; identity, psk : PIdAnsiChar; max_psk_len : TIdC_UINT) : TIdC_UINT cdecl;
//	unsigned int (*psk_server_callback)(SSL *ssl, const char *identity,
//		unsigned char *psk, unsigned int max_psk_len);
{$endif}

{$ifndef OPENSSL_NO_BUF_FREELISTS}
	  freelist_max_len : TIdC_UINT;
	  wbuf_freelist : Pssl3_buf_freelist_st;
	  rbuf_freelist : Pssl3_buf_freelist_st;
{$endif}
{$ifndef OPENSSL_NO_SRP}
	  srp_ctx : SRP_CTX; //* ctx for SRP authentication */
{$endif}

{$ifndef OPENSSL_NO_TLSEXT}
//# ifndef OPENSSL_NO_NEXTPROTONEG
	//* Next protocol negotiation information */
	//* (for experimental NPN extension). */

	//* For a server, this contains a callback function by which the set of
	// * advertised protocols can be provided. */
    next_protos_advertised_cb : function(s : PSSL; out but : PIdAnsiChar;
     out len : TIdC_UINT; arg : Pointer) : TIdC_INT cdecl;
//	int (*next_protos_advertised_cb)(SSL *s, const unsigned char **buf,
//			                 unsigned int *len, void *arg);
	  next_protos_advertised_cb_arg : Pointer;
	//* For a client, this contains a callback function that selects the
	// * next protocol from the list provided by the server. */
    next_proto_select_cb : function(s : PSSL; out _out : PIdAnsiChar;
      outlen : PIdAnsiChar;
      _in : PIdAnsiChar;
      inlen : TIdC_UINT;
      arg : Pointer) : TIdC_INT cdecl;
//	int (*next_proto_select_cb)(SSL *s, unsigned char **out,
//				    unsigned char *outlen,
//				    const unsigned char *in,
//				    unsigned int inlen,
//				    void *arg);
	  next_proto_select_cb_arg : Pointer;
//# endif
        //* SRTP profiles we are willing to do from RFC 5764 */
      srtp_profiles : PSTACK_OF_SRTP_PROTECTION_PROFILE;
{$endif}
  end;
  {$EXTERNALSYM PSSL2_STATE}    
  PSSL2_STATE = ^SSL2_STATE;
  {$EXTERNALSYM PSSL3_STATE}    
  PSSL3_STATE = ^SSL3_STATE;
  {$EXTERNALSYM PDTLS1_STATE}
  PDTLS1_STATE = ^DTLS1_STATE;
//* TLS extension debug callback */
  {$EXTERNALSYM PSSL_tlsext_debug_cb} 
  PSSL_tlsext_debug_cb = procedure (s : PSSL; client_server : TIdC_INT; 
    _type : TIdC_INT; data : PIdAnsiChar; len : TIdC_INT; arg : Pointer); cdecl;
  {$NODEFINE SSL}     
  SSL = record
    // protocol version
    // (one of SSL2_VERSION, SSL3_VERSION, TLS1_VERSION, DTLS1_VERSION)
    version : TIdC_INT;
    _type : TIdC_INT; //* SSL_ST_CONNECT or SSL_ST_ACCEPT */
    method : PSSL_METHOD; //* SSLv3 */
    // There are 2 BIO's even though they are normally both the
    // same.  This is so data can be read and written to different
    // handlers
    {$IFNDEF OPENSSL_NO_BIO}
    rbio : PBIO; // used by SSL_read
    wbio : PBIO; // used by SSL_write
    bbio : PBIO; // used during session-id reuse to concatenate messages
    {$ELSE}
    rbio : PIdAnsiChar; // used by SSL_read
    wbio : PIdAnsiChar; // used by SSL_write
    bbio : PIdAnsiChar;
    {$ENDIF}
    // This holds a variable that indicates what we were doing
    // when a 0 or -1 is returned.  This is needed for
    // non-blocking IO so we know what request needs re-doing when
    // in SSL_accept or SSL_connect
    rwstate : TIdC_INT;
    // true when we are actually in SSL_accept() or SSL_connect()
    in_handshake : TIdC_INT;
    handshake_func : function (_para1 : PSSL) : TIdC_INT; cdecl;
    // Imagine that here's a boolean member "init" that is
    // switched as soon as SSL_set_{accept/connect}_state
    // is called for the first time, so that "state" and
    // handshake_func" are properly initialized.  But as
    // handshake_func is == 0 until then, we use this
    // test instead of an "init" member.
    server : TIdC_INT;  // are we the server side? - mostly used by SSL_clear
    new_session : TIdC_INT;//* Generate a new session or reuse an old one.
	                 //* NB: For servers, the 'new' session may actually be a previously
	                 //* cached session or even the previous session unless
	                 //* SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION is set */
    quiet_shutdown : TIdC_INT;  // don't send shutdown packets
    shutdown : TIdC_INT;        // we have shut things down, 0x01 sent, 0x02
                                // for received
    state : TIdC_INT;   // where we are
    rstate : TIdC_INT;  // where we are when reading
    init_buf : PBUF_MEM;    // buffer used during init
    init_msg : Pointer;     // pointer to handshake message body, set by ssl3_get_message()
    init_num : TIdC_INT;    // amount read/written
    init_off : TIdC_INT;    // amount read/written
    // used internally to point at a raw packet
    packet : PIdAnsiChar;
    packet_length : TIdC_UINT;
    s2 : Pssl2_state;   // SSLv2 variables
    s3 : Pssl3_state;   // SSLv3 variables
    d1 : Pdtls1_state;  // DTLSv1 variables
    read_ahead : TIdC_INT;  // Read as many input bytes as possible (for non-blocking reads)
    // callback that allows applications to peek at protocol messages
    msg_callback : procedure(write_p, version, content_type : TIdC_INT;
      const buf : Pointer; len : size_t; ssl : PSSL; arg : Pointer); cdecl;
    msg_callback_arg : Pointer;
    hit : TIdC_INT;    //* reusing a previous session */
    param : PX509_VERIFY_PARAM;
    {$IFDEF OMIT_THIS}
    purpose : TIdC_INT; // Purpose setting
    trust : TIdC_INT;   // Trust setting
    {$ENDIF}
    // crypto
    cipher_list : PSTACK_OF_SSL_CIPHER;
    cipher_list_by_id : PSTACK_OF_SSL_CIPHER;

	//* These are the ones being used, the ones in SSL_SESSION are
	// * the ones to be 'copied' into these ones */
	  mac_flags : TIdC_INT;
    // These are the ones being used, the ones in SSL_SESSION are
    // the ones to be 'copied' into these ones
    enc_read_ctx : PEVP_CIPHER_CTX;  // cryptographic state
    read_hash : PEVP_MD_CTX;    // used for mac generation
    {$IFNDEF OPENSSL_NO_COMP}
    expand : PCOMP_CTX;             // uncompress
    {$ELSE}
    expand : PIdAnsiChar;
    {$ENDIF}
    enc_write_ctx : PEVP_CIPHER_CTX;   // cryptographic state
    write_hash : PEVP_MD_CTX;          // used for mac generation
    {$IFNDEF OPENSSL_NO_COMP}
    compress : PCOMP_CTX;              // compression
    {$ELSE}
    compress : PIdAnsiChar;
    {$ENDIF}
    // session info
    // client cert?
    // This is used to hold the server certificate used
    cert : PCERT;
    // the session_id_context is used to ensure sessions are only reused
    // in the appropriate context
    sid_ctx_length : TIdC_UINT;
    sid_ctx : array [0..SSL_MAX_SID_CTX_LENGTH -1] of TIdAnsiChar;
    // This can also be in the session once a session is established
    session : PSSL_SESSION;
    // Default generate session ID callback.
    generate_session_id : PGEN_SESSION_CB;
    // Used in SSL2 and SSL3
    verify_mode : TIdC_INT; // 0 don't care about verify failure.
                            // 1 fail if verify fails
    verify_callback : function (ok : TIdC_INT; ctx : PX509_STORE_CTX) : TIdC_INT; cdecl; // fail if callback returns 0
    info_callback : procedure(const ssl : PSSL; _type, val : TIdC_INT) ; cdecl;
    error : TIdC_INT;       // error bytes to be written
    error_code : TIdC_INT;  // actual code
    {$IFNDEF OPENSSL_NO_KRB5}
    kssl_ctx : PKSSL_CTX;     // Kerberos 5 context
    {$ENDIF}
{$ifndef OPENSSL_NO_PSK}
    psk_client_callback : function(ssl : PSSL; hint : PIdAnsiChar;
      identity : PIdAnsiChar;
      max_identity_len : TIdC_UINT;
      psk : PIdAnsiChar;
      max_psk_len : TIdC_UINT) : TIdC_UINT cdecl;
//	unsigned int (*psk_client_callback)(SSL *ssl, const char *hint, char *identity,
//		unsigned int max_identity_len, unsigned char *psk,
//		unsigned int max_psk_len);
      psk_server_callback : function(ssl : PSSL; identity : PIdAnsiChar;
        psk : PIdAnsiChar; max_psk_len : TIdC_UINT) : TIdC_UINT cdecl;
//	unsigned int (*psk_server_callback)(SSL *ssl, const char *identity,
//		unsigned char *psk, unsigned int max_psk_len);
{$endif}
    ctx : PSSL_CTX;
    // set this flag to 1 and a sleep(1) is put into all SSL_read()
    // and SSL_write() calls, good for nbio debuging :-)
    debug : TIdC_INT;
    //  extra application data
    verify_result : TIdC_LONG;
    ex_data : CRYPTO_EX_DATA;
    // for server side, keep the list of CA_dn we can use
    client_CA : PSTACK_OF_X509_NAME;
    references : TIdC_INT;
    options : TIdC_ULONG; // protocol behaviour
    mode : TIdC_ULONG; // API behaviour
    max_cert_list : TIdC_LONG;
    first_packet : TIdC_INT;
    client_version : TIdC_INT; // what was passed, used for
    // SSLv3/TLS rollback check
    max_send_fragment : TIdC_UINT;
    {$IFNDEF OPENSSL_NO_TLSEXT}
    //* TLS extension debug callback */
    tlsext_debug_cb : PSSL_tlsext_debug_cb;
    tlsext_debug_arg : Pointer;
    tlsext_hostname : PIdAnsiChar;
    servername_done : TIdC_INT;   //* no further mod of servername 
                       //   0 : call the servername extension callback.
                       //   1 : prepare 2, allow last ack just after in server callback.
                       //   2 : don't call servername callback, no ack in server hello
                       //*/
	//* certificate status request info */
	//* Status type or -1 if no status type */
	  tlsext_status_type : TIdC_INT;
	//* Expect OCSP CertificateStatus message */
	  tlsext_status_expected : TIdC_INT;

{$ifndef OPENSSL_NO_EC}
	  tlsext_ecpointformatlist_length : size_t;
	  tlsext_ecpointformatlist : PIdAnsiChar; //* our list */
    tlsext_ellipticcurvelist_length : size_t;
    tlsext_ellipticcurvelist : PIdAnsiChar; //* our list */
{$endif} //* OPENSSL_NO_EC */


	//* draft-rescorla-tls-opaque-prf-input-00.txt information to be used for handshakes */
	tlsext_opaque_prf_input : Pointer;
	 tlsext_opaque_prf_input_len : size_t;

	//* TLS Session Ticket extension override */
	 tlsext_session_ticket : PTLS_SESSION_TICKET_EXT;

	//* TLS Session Ticket extension callback */
	 tls_session_ticket_ext_cb : tls_session_ticket_ext_cb_fn;
	 tls_session_ticket_ext_cb_arg : Pointer;

	//* TLS pre-shared secret session resumption */
	 tls_session_secret_cb : tls_session_secret_cb_fn;
	 tls_session_secret_cb_arg : Pointer;

	initial_ctx : PSSL_CTX; //* initial ctx, used to store sessions */

{$ifndef OPENSSL_NO_NEXTPROTONEG}
	///* Next protocol negotiation. For the client, this is the protocol that
	// * we sent in NextProtocol and is set when handling ServerHello
	// * extensions.
	// *
	// * For a server, this is the client's selected_protocol from
	// * NextProtocol and is set when handling the NextProtocol message,
	// * before the Finished message. */
	next_proto_negotiated : PIdAnsiChar;
	next_proto_negotiated_len : Byte;
{$endif}

	//* OCSP status request only */
    tlsext_ocsp_ids : PSTACK_OF_OCSP_RESPID;//STACK_OF(OCSP_RESPID) *tlsext_ocsp_ids;
	  tlsext_ocsp_exts : PX509_EXTENSIONS;
	//* OCSP response received or to be sent */
	  tlsext_ocsp_resp : PIdAnsiChar;
	  tlsext_ocsp_resplen : TIdC_INT;
    //* RFC4507 session ticket expected to be received or sent */
    tlsext_ticket_expected : TIdC_INT;
    _initial_ctx : PSSL_CTX; //* initial ctx, used to store sessions */
   {$DEFINE session_ctx} 
   {$DEFINE initial_ctx}
{$ELSE}
   {$DEFINE ctx}
   {$DEFINE session_ctx}
{$ENDIF}
  end;
  //ssl2.h
  {$EXTERNALSYM SSL2_STATE}   
  SSL2_STATE = record
    three_byte_header : TIdC_INT;
    clear_text : TIdC_INT;    // clear text
    escape : TIdC_INT;        // not used in SSLv2
    ssl2_rollback : TIdC_INT; // used if SSLv23 rolled back to SSLv2
    // non-blocking io info, used to make sure the same
    // args were passwd
    wnum : TIdC_UINT; // number of bytes sent so far
    wpend_tot : TIdC_INT;
    wpend_buf : PByte;
    wpend_off : TIdC_INT; // offset to data to write
    wpend_len : TIdC_INT; // number of bytes passwd to write
    wpend_ret : TIdC_INT; // number of bytes to return to caller
    // buffer raw data
    rbuf_left : TIdC_INT;
    rbuf_offs : TIdC_INT;
    rbuf : PIdAnsiChar;
    wbuf : PIdAnsiChar;
    write_ptr : PIdAnsiChar; // used to point to the start due to 2/3 byte header. */
    padding : TIdC_UINT;
    rlength : TIdC_UINT; // passed to ssl2_enc
    ract_data_length : TIdC_INT; // Set when things are encrypted.
    wlength : TIdC_UINT; // passed to ssl2_enc
    wact_data_length : TIdC_INT; // Set when things are decrypted.
    ract_data : PIdAnsiChar;
    wact_data : PIdAnsiChar;
    mac_data : PIdAnsiChar;
    read_key : PIdAnsiChar;
    write_key : PIdAnsiChar;
    // Stuff specifically to do with this SSL session
    challenge_length : TIdC_UINT;
    challenge : array [0..SSL2_MAX_CHALLENGE_LENGTH -1] of TIdAnsiChar;
    conn_id_length : TIdC_UINT;
    conn_id : array [0..SSL2_MAX_CONNECTION_ID_LENGTH -1] of TIdAnsiChar;
    key_material_length : TIdC_UINT;
    key_material : array[0..(SSL2_MAX_KEY_MATERIAL_LENGTH*2)-1] of TIdAnsiChar;
    read_sequence : TIdC_ULONG;
    write_sequence : TIdC_ULONG;
    tmp_conn_id_length : TIdC_UINT;
    tmp_cert_type : TIdC_UINT;
    tmp_cert_length : TIdC_UINT;
    tmp_csl : TIdC_UINT;
    tmp_clear : TIdC_UINT;
    tmp_enc : TIdC_UINT;
    tmp_ccl : array [0..SSL2_MAX_CERT_CHALLENGE_LENGTH -1] of TIdAnsiChar;
    tmp_cipher_spec_length : TIdC_UINT;
    tmp_session_id_length : TIdC_UINT;
    tmp_clen : TIdC_UINT;
    tmp_rlen : TIdC_UINT;
  end;
  //sl3.h
  {$IFNDEF OPENSSL_NO_SSL_INTERN}
  {$EXTERNALSYM PSSL3_RECORD}     
  PSSL3_RECORD = ^SSL3_RECORD;
  {$EXTERNALSYM SSL3_RECORD}   
  SSL3_RECORD = record
    {*r *}  _type : TIdC_INT;   // type of record
    {*rw*}  length : TIdC_UINT; // How many bytes available
    {*r *}  off : TIdC_UINT;    // read/write offset into 'buf'
    {*rw*}  data : PIdAnsiChar;       // pointer to the record data
    {*rw*}  input : PIdAnsiChar;      // where the decode bytes are
    {*r *}  comp : PIdAnsiChar;       // only used with decompression - malloc()ed
    {*r *}  epoch : TIdC_ULONG; // epoch number, needed by DTLS1
    {*r *}  seq_num : array [0..7] of Byte; //* sequence number, needed by DTLS1 */
  end;
  {$EXTERNALSYM PSSL3_BUFFER}   
  PSSL3_BUFFER = ^SSL3_BUFFER;
  {$EXTERNALSYM SSL3_BUFFER}     
  SSL3_BUFFER = record
    buf : PIdAnsiChar;            // at least SSL3_RT_MAX_PACKET_SIZE bytes,
                            // see ssl3_setup_buffers()
    len : size_t;           // buffer size
    offset : TIdC_INT;      // where to 'copy from'
    left : TIdC_INT;        // how many bytes left
  end;

  {$EXTERNALSYM SSL3_STATE}   
  SSL3_STATE = record
    flags : TIdC_LONG;
    delay_buf_pop_ret : TIdC_INT;

    read_sequence : array [0..7] of TIdAnsiChar;
    read_mac_secret_size : TIdC_INT;
    read_mac_secret : array [0..EVP_MAX_MD_SIZE -1] of TIdAnsiChar;
    write_sequence : array [0..7] of TIdAnsiChar;
    write_mac_secret_size : TIdC_INT;
    write_mac_secret : array [0..EVP_MAX_MD_SIZE - 1] of TIdAnsiChar;
    server_random : array [0..SSL3_RANDOM_SIZE - 1] of TIdAnsiChar;
    client_random : array [0..SSL3_RANDOM_SIZE -1] of TIdAnsiChar;
    // flags for countermeasure against known-IV weakness
    need_empty_fragments : TIdC_INT;
    empty_fragment_done : TIdC_INT;

    //* The value of 'extra' when the buffers were initialized */
    init_extra : TIdC_INT;
    rbuf : PSSL3_BUFFER;    //* read IO goes into here */
    wbuf : PSSL3_BUFFER;	//* write IO goes into here */
    rrec : PSSL3_RECORD;    //* each decoded record goes in here */
    wrec : PSSL3_RECORD;    //* goes out from here */
    // storage for Alert/Handshake protocol data received but not
    // yet processed by ssl3_read_bytes:
    alert_fragment : array [0..1] of PIdAnsiChar;
    alert_fragment_len : TIdC_UINT;
    handshake_fragment : array [0..3] of PIdAnsiChar;
    handshake_fragment_len : TIdC_UINT;
    // partial write - check the numbers match
    wnum : TIdC_UINT; // number of bytes sent so far
    wpend_tot : TIdC_INT;  // number bytes written
    wpend_type : TIdC_INT;
    wpend_ret : TIdC_INT; // number of bytes submitted
    wpend_buf : PByte;
    // used during startup, digest all incoming/outgoing packets */
    handshake_buffer : PBIO;
    //* When set of handshake digests is determined, buffer is hashed
    // * and freed and MD_CTX-es for all required digests are stored in
    // * this array */
    handshake_dgst : PPEVP_MD_CTX;

    finish_dgst2 : PEVP_MD_CTX;
    // this is set whenerver we see a change_cipher_spec message
    // come in when we are not looking for one
    change_cipher_spec : TIdC_INT;
    warn_alert : TIdC_INT;
    fatal_alert : TIdC_INT;
    // we allow one fatal and one warning alert to be outstanding,
    // send close alert via the warning alert */
    alert_dispatch : TIdC_INT;
    send_alert : array [0..1] of TIdAnsiChar;
    // This flag is set when we should renegotiate ASAP, basically when
    // there is no more data in the read or write buffers
    renegotiate : TIdC_INT;
    total_renegotiations : TIdC_INT;
    num_renegotiations : TIdC_INT;
    in_read_app_data : TIdC_INT;

    //* Opaque PRF input as used for the current handshake.
    // * These fields are used only if TLSEXT_TYPE_opaque_prf_input is defined
    // * (otherwise, they are merely present to improve binary compatibility) */
    client_opaque_prf_input : Pointer;
    client_opaque_prf_input_len : size_t;
    server_opaque_prf_input : Pointer;
    server_opaque_prf_input_len : size_t;
    // actually only needs to be 16+20
    tmp_cert_verify_md: array [0..(EVP_MAX_MD_SIZE*2)-1] of TIdAnsiChar;
    // actually only need to be 16+20 for SSLv3 and 12 for TLS
    tmp_finish_md : array[0..(EVP_MAX_MD_SIZE*2)-1] of TIdAnsiChar;
    tmp_finish_md_len : TIdC_INT;
    tmp_peer_finish_md : array[0..(EVP_MAX_MD_SIZE*2)-1] of TIdAnsiChar;
    tmp_peer_finish_md_len : TIdC_INT;
    tmp_message_size : TIdC_UINT;
    tmp_message_type : TIdC_INT;
    // used to hold the new cipher we are going to use
    tmp_new_cipher : PSSL_CIPHER;
    {$IFNDEF OPENSSL_NO_DH}
    tmp_dh : PDH;
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_ECDH}
    tmp_ecdh : PEC_KEY; // holds short lived ECDH key
    {$ENDIF}
    // used when SSL_ST_FLUSH_DATA is entered
    tmp_next_state : TIdC_INT;
    tmp_reuse_message : TIdC_INT;
    // used for certificate requests
    tmp_cert_req : TIdC_INT;
    tmp_ctype_num : TIdC_INT;
    tmp_ctype : array [0..SSL3_CT_NUMBER -1] of TIdAnsiChar;
    tmp_ca_names : PSTACK_OF_X509_NAME;
    tmp_use_rsa_tmp : TIdC_INT;
    tmp_key_block_length : TIdC_INT;
    tmp_key_block : PIdAnsiChar;
    tmp_new_sym_enc : PEVP_CIPHER;
    tmp_new_hash : PEVP_MD;
    new_mac_pkey_type : TIdC_INT;
    new_mac_secret_size : TIdC_INT;
    {$IFNDEF OPENSSL_NO_COMP}
    tmp_new_compression : PSSL_COMP;
    {$ELSE}
    tmp_new_compression : PIdAnsiChar;
    {$ENDIF}
    tmp_cert_request : TIdC_INT;

    //* Connection binding to prevent renegotiation attacks */
    previous_client_finished : array [0..EVP_MAX_MD_SIZE - 1] of TIdAnsiChar;
    previous_client_finished_len : Byte;
    previous_server_finished : array [0..EVP_MAX_MD_SIZE - 1] of TIdAnsiChar;
    previous_server_finished_len : Byte;
    send_connection_binding : TIdC_INT; //* TODOEKR */
{$ifndef OPENSSL_NO_NEXTPROTONEG}
    //* Set if we saw the Next Protocol Negotiation extension from our peer. */
    next_proto_neg_seen : TIdC_INT;
{$endif}
  end;
  {$ENDIF}
  //openssl/pq_compat.h
  {$EXTERNALSYM ppitem}  
  ppitem = ^pitem;
  {$EXTERNALSYM pitem}    
  pitem = record
    priority : PQ_64BIT;
    data : Pointer;
    next : ppitem;
  end;
  //ssl/dtls1.h
  //for some reason, this header is refering to crypto/pqueue/pqueue.c
  //which is in the OpenSSL headers.
  {$EXTERNALSYM pqueue}     
  pqueue = record
    items : ppitem;
    count : TIdC_INT;
  end;
  //
  {$EXTERNALSYM dtls1_retransmit_state} 
  dtls1_retransmit_state = record
	  enc_write_ctx : PEVP_CIPHER_CTX;	//* cryptographic state */
   	write_hash : PEVP_MD;		//* used for mac generation */
{$IFNDEF OPENSSL_NO_COMP}
   	compress : COMP_CTX;				//* compression */
{$ELSE}
   	compress : PIdAnsiChar;
{$ENDIF}
   	session : PSSL_SESSION;
	  epoch : TIdC_USHORT;
  end;
  {$EXTERNALSYM Pdtls1_retransmit_state}   
  Pdtls1_retransmit_state = ^dtls1_retransmit_state;
  {$EXTERNALSYM DTLS1_BITMAP}    
  DTLS1_BITMAP = record
    map : PQ_64BIT;
    length : TIdC_ULONG;     // sizeof the bitmap in bits
    max_seq_num : PQ_64BIT;  // max record number seen so far
  end;
  {$EXTERNALSYM PDTLS1_BITMAP}     
  PDTLS1_BITMAP = ^DTLS1_BITMAP;
  {$EXTERNALSYM hm_header}     
  hm_header = record
    _type : PIdAnsiChar;
    msg_len : TIdC_ULONG;
    seq : TIdC_USHORT;
    frag_off : TIdC_ULONG;
    frag_len : TIdC_ULONG;
    is_ccs : TIdC_UINT;
    //	struct dtls1_retransmit_state saved_retransmit_state;
    saved_retransmit_state : dtls1_retransmit_state;
  end;
  {$EXTERNALSYM ccs_header_st}    
  ccs_header_st = record
    _type : PIdAnsiChar;
    seq : TIdC_USHORT;
  end;
  {$EXTERNALSYM dtls1_timeout_st}      
  dtls1_timeout_st = record
    // Number of read timeouts so far
    read_timeouts : TIdC_UINT;
    // Number of write timeouts so far
    write_timeouts : TIdC_UINT;
    // Number of alerts received so far
    num_alerts : TIdC_UINT;
  end;
  {$EXTERNALSYM record_pqueue}     
  record_pqueue = record
    epoch : TIdC_USHORT;
    q : pqueue;
  end;
  {$EXTERNALSYM hm_fragment}   
  hm_fragment = record
    msg_header : hm_header;
    fragment : PIdAnsiChar;
    reassembly : PIdAnsiChar;
  end;
  {$EXTERNALSYM DTLS1_STATE}     
  DTLS1_STATE = record
    send_cookie : TIdC_UINT;
    cookie : array [0..DTLS1_COOKIE_LENGTH - 1 ] of TIdAnsiChar;
    rcvd_cookie : array [0..DTLS1_COOKIE_LENGTH -1] of TIdAnsiChar;
    cookie_len : TIdC_UINT;
    // The current data and handshake epoch.  This is initially
    // undefined, and starts at zero once the initial handshake is
    // completed
    r_epoch : TIdC_USHORT;
    w_epoch : TIdC_USHORT;
    // records being received in the current epoch
    bitmap : DTLS1_BITMAP;
    // renegotiation starts a new set of sequence numbers
    next_bitmap : DTLS1_BITMAP;
    // handshake message numbers
    handshake_write_seq : TIdC_USHORT;
    next_handshake_write_seq : TIdC_USHORT;
    handshake_read_seq : TIdC_USHORT;
	//* save last sequence number for retransmissions */
   	last_write_sequence : array [0..8-1] of byte;

    // Received handshake records (processed and unprocessed)
    unprocessed_rcds : record_pqueue;
    processed_rcds : record_pqueue;
    // Buffered handshake messages
    buffered_messages : pqueue;
    // Buffered (sent) handshake records
    sent_messages : pqueue;
   ///* Buffered application records.
	 //* Only for records between CCS and Finished
	 //* to prevent either protocol violation or
	 //* unnecessary message loss.
	 //*/
	  buffered_app_data : record_pqueue;

	///* Is set when listening for new connections with dtls1_listen() */
	  listen : TIdC_UINT;

    mtu : TIdC_UINT; // max wire packet size
    w_msg_hdr : hm_header;
    r_msg_hdr : hm_header;
    timeout :  dtls1_timeout_st;
    	//* Indicates when the last handshake msg sent will timeout */
    next_timeout : timeval;

	//* Timeout duration */
	   timeout_duration : TIdC_USHORT;

    // storage for Alert/Handshake protocol data received but not
    // yet processed by ssl3_read_bytes:
    alert_fragment : array [0..DTLS1_AL_HEADER_LENGTH-1] of TIdAnsiChar;
    alert_fragment_len : TIdC_UINT;
    handshake_fragment : array[0..DTLS1_HM_HEADER_LENGTH -1] of TIdAnsiChar;
    handshake_fragment_len : TIdC_UINT;
    retransmitting : TIdC_UINT;
    change_cipher_spec_ok : TIdC_UINT;
  end;

  {$EXTERNALSYM X509V3_CTX}    
  X509V3_CTX = V3_EXT_CTX;
  {$EXTERNALSYM PX509V3_CTX}      
  PX509V3_CTX = ^X509V3_CTX;

type
  {$EXTERNALSYM Tsk_new_cmp}
  Tsk_new_cmp = function (const a, b : PIdAnsiChar; const c : PIdAnsiChar) : TIdC_INT cdecl;
  {$EXTERNALSYM TRSA_generate_key_callback}
  TRSA_generate_key_callback = procedure (p1, p2 : TIdC_INT; p3 : Pointer); cdecl;
  {$EXTERNALSYM TCRYPTO_set_mem_functions_m}
  TCRYPTO_set_mem_functions_m = function (size : size_t) : Pointer; cdecl;
  {$EXTERNALSYM TCRYPTO_set_mem_functions_r}
  TCRYPTO_set_mem_functions_r = function (ptr : Pointer; size : size_t) : Pointer; cdecl;
  {$EXTERNALSYM TCRYPTO_set_mem_functions_f}
  TCRYPTO_set_mem_functions_f = procedure (ptr : Pointer); cdecl;
  {$EXTERNALSYM TCRYPTO_set_mem_ex_functions_m}
  TCRYPTO_set_mem_ex_functions_m = function(size : size_t; const c : PIdAnsiChar; i : TIdC_INT) : Pointer; cdecl;
  {$EXTERNALSYM TCRYPTO_set_mem_ex_functions_r}
  TCRYPTO_set_mem_ex_functions_r = function(ptr : Pointer; size : size_t; const c : PIdAnsiChar; i : TIdC_INT) : Pointer; cdecl;
  {$EXTERNALSYM TCRYPTO_set_mem_ex_functions_f}
  TCRYPTO_set_mem_ex_functions_f = procedure (ptr : Pointer); cdecl;
  {$EXTERNALSYM Tset_mem_debug_functions_m}
  Tset_mem_debug_functions_m = procedure (addr : Pointer; num : TIdC_INT; const _file : PIdAnsiChar; line, before_p : TIdC_INT); cdecl;
  {$EXTERNALSYM Tset_mem_debug_functions_r}
  Tset_mem_debug_functions_r = procedure (addr1, addr2 : Pointer; num : TIdC_INT; const _file : PIdAnsiChar; line, before_p : TIdC_INT); cdecl;
  {$EXTERNALSYM Tset_mem_debug_functions_f}
  Tset_mem_debug_functions_f = procedure (addr : Pointer; before_p : TIdC_INT); cdecl;
  {$EXTERNALSYM Tset_mem_debug_functions_so}
  Tset_mem_debug_functions_so = procedure (bits : TIdC_LONG); cdecl;
  {$EXTERNALSYM Tset_mem_debug_functions_go}
  Tset_mem_debug_functions_go = function : TIdC_LONG; cdecl;
  {$EXTERNALSYM TSSL_CTX_set_verify_callback}
  TSSL_CTX_set_verify_callback = function (ok : TIdC_INT; ctx : PX509_STORE_CTX) : TIdC_INT; cdecl;
  {$EXTERNALSYM Tsk_pop_free_func}
  Tsk_pop_free_func = procedure (p : Pointer); cdecl;
  {$EXTERNALSYM SSL_callback_ctrl_fp}
  SSL_callback_ctrl_fp = procedure (para1 : PBIO; para2 : TIdC_INT;
    para3 : PIdAnsiChar; para4 : TIdC_INT; para5, para6 : TIdC_LONG); cdecl;
  {$EXTERNALSYM TCRYPTO_THREADID_set_callback_threadid_func}
  TCRYPTO_THREADID_set_callback_threadid_func = procedure (id : PCRYPTO_THREADID) cdecl;
  {$EXTERNALSYM TSSL_CTX_set_tlsext_status_cb}
  TSSL_CTX_set_tlsext_status_cb = function(SSL : PSSL; Arg : Pointer) : TIdC_INT cdecl;
  {$EXTERNALSYM TSSL_CTX_set_tlsext_opaque_prf_input_callback_cb}
  TSSL_CTX_set_tlsext_opaque_prf_input_callback_cb = function(ssl : PSSL; peerinput : Pointer; len : size_t; arg : Pointer) : TIdC_INT cdecl;
  {$EXTERNALSYM TSSL_CTX_set_tlsext_ticket_key_cb_fp}
  TSSL_CTX_set_tlsext_ticket_key_cb_fp = function(SSL : PSSL; keyname, iv : PIdAnsiChar; ctx : PEVP_CIPHER_CTX; hctx : PHMAC_CTX; enc : TIdC_INT) : TIdC_INT cdecl;

  {$EXTERNALSYM EVP_CIPHER_do_all_fn}
  EVP_CIPHER_do_all_fn = procedure(ciph : PEVP_CIPHER;
		from : PIdAnsiChar; _to : PIdAnsiChar; x : Pointer) cdecl;
  {$EXTERNALSYM EVP_MD_do_all_fn}
  EVP_MD_do_all_fn = procedure(ciph : PEVP_CIPHER;
		from: PIdAnsiChar; _to: PIdAnsiChar; x : Pointer) cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_public_pub_decode}
  EVP_PKEY_asn1_set_public_pub_decode = function(pk : PEVP_PKEY; pub : PX509_PUBKEY) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_public_pub_encode}
  EVP_PKEY_asn1_set_public_pub_encode = function(pub : PX509_PUBKEY; pk : PX509_PUBKEY) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_public_pub_cmp}
  EVP_PKEY_asn1_set_public_pub_cmp = function (a : PEVP_PKEY; b : PEVP_PKEY) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_public_pub_print}
  EVP_PKEY_asn1_set_public_pub_print = function(_out : PBIO; pkey : PEVP_PKEY;  indent : TIdC_INT;
		pctx : PASN1_PCTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_public_pub_pkey_size}
  EVP_PKEY_asn1_set_public_pub_pkey_size = function(pk : PEVP_PKEY) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_public_pkey_bits}
  EVP_PKEY_asn1_set_public_pkey_bits = function(pk : PEVP_PKEY) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_private_priv_decode}
  EVP_PKEY_asn1_set_private_priv_decode = function (pk : PEVP_PKEY; p8inf : PPKCS8_PRIV_KEY_INFO) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_private_priv_encode}
  EVP_PKEY_asn1_set_private_priv_encode = function (p8 : PPKCS8_PRIV_KEY_INFO; pk : PEVP_PKEY): TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_private_priv_print}
  EVP_PKEY_asn1_set_private_priv_print = function (_out : PBIO; pkey : PEVP_PKEY; indent : TIdC_INT;
	  pctx : PASN1_PCTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_param_param_decode}
  EVP_PKEY_asn1_set_param_param_decode = function(pkey : PEVP_PKEY;
		pder : PPIdAnsiChar; derlen : TIdC_INT): TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_param_param_encode}
  EVP_PKEY_asn1_set_param_param_encode = function(pkey : PEVP_PKEY; pder : PPIdAnsiChar) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_param_param_missing}
  EVP_PKEY_asn1_set_param_param_missing = function(pk : EVP_PKEY) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_param_param_copy}
  EVP_PKEY_asn1_set_param_param_copy = function(_to : PEVP_PKEY; from : PEVP_PKEY) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_param_param_cmp}
  EVP_PKEY_asn1_set_param_param_cmp = function(a : PEVP_PKEY; b : PEVP_PKEY): TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_param_param_print}
  EVP_PKEY_asn1_set_param_param_print = function(_out : PBIO; pkey : PEVP_PKEY; indent : TIdC_INT;
		pctx : PASN1_PCTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_free_pkey_free}
  EVP_PKEY_asn1_set_free_pkey_free = procedure(pkey : PEVP_PKEY) cdecl;
  {$EXTERNALSYM EVP_PKEY_asn1_set_ctr_pkey_ctrl}
  EVP_PKEY_asn1_set_ctr_pkey_ctrl = function(pkey : PEVP_PKEY; op : TIdC_INT;
							arg1 : TIdC_LONG; arg2 : Pointer) : TIdC_INT cdecl;

  {$EXTERNALSYM EVP_PKEY_gen_cb}

  EVP_PKEY_gen_cb = function( ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_init_init}

  EVP_PKEY_meth_set_init_init = function (ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_copy_copy}
  EVP_PKEY_meth_set_copy_copy = function (dst : PEVP_PKEY_CTX; src : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_cleanup_cleanup}
  EVP_PKEY_meth_set_cleanup_cleanup = procedure(ctx : PEVP_PKEY_CTX) cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_paramgen_paramgen_init}
  EVP_PKEY_meth_set_paramgen_paramgen_init = function (ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_paramgen_paramgen}
  EVP_PKEY_meth_set_paramgen_paramgen = function (ctx : PEVP_PKEY_CTX; pkey : PEVP_PKEY) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_keygen_keygen_init}
  EVP_PKEY_meth_set_keygen_keygen_init = function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_keygen_keygen}
  EVP_PKEY_meth_set_keygen_keygen = function(ctx : PEVP_PKEY_CTX; pkey : PEVP_PKEY) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_sign_sign_init}
  EVP_PKEY_meth_set_sign_sign_init = function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_sign_sign}
  EVP_PKEY_meth_set_sign_sign = function(ctx : PEVP_PKEY_CTX; sig : PIdAnsiChar; siglen : Psize_t;
    tbs : PIdAnsiChar;  tbslen : size_t) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_verify_verify_init}
  EVP_PKEY_meth_set_verify_verify_init = function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_verify_verify}
  EVP_PKEY_meth_set_verify_verify = function(ctx : PEVP_PKEY_CTX; sig : PIdAnsiChar;  siglen : size_t;
					tbs : PIdAnsiChar;  tbslen : size_t) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_verify_recover_verify_recover_init}
  EVP_PKEY_meth_set_verify_recover_verify_recover_init = function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_verify_recover_verify_recover}
  EVP_PKEY_meth_set_verify_recover_verify_recover = function(ctx : PEVP_PKEY_CTX;
					sig : PIdAnsiChar; siglen : Psize_t;
					tbs: PIdAnsiChar;  tbslen : size_t) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_signctx_signctx_init}
  EVP_PKEY_meth_set_signctx_signctx_init = function(ctx : PEVP_PKEY_CTX; mctx : PEVP_MD_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_signctx_signctx}
  EVP_PKEY_meth_set_signctx_signctx = function(ctx : PEVP_PKEY_CTX; sig : PIdAnsiChar; siglen : size_t;
					 mctx : PEVP_MD_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_verifyctx_verifyctx_init}
  EVP_PKEY_meth_set_verifyctx_verifyctx_init = function : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_verifyctx_verifyctx}
  EVP_PKEY_meth_set_verifyctx_verifyctx = function : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_encrypt_encrypt_init}
  EVP_PKEY_meth_set_encrypt_encrypt_init = function( ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_encrypt_encryptfn}
  EVP_PKEY_meth_set_encrypt_encryptfn = function(ctx : PEVP_PKEY_CTX; _out : PIdAnsiChar; outlen : psize_t;
	 _in : PIdAnsiChar;  inlen : size_t) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_decrypt_decrypt_init}
  EVP_PKEY_meth_set_decrypt_decrypt_init = function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_decrypt_decrypt}
  EVP_PKEY_meth_set_decrypt_decrypt = function(ctx : PEVP_PKEY_CTX; _out : PIdAnsiChar; outlen : psize_t;
	 _in : PIdAnsiChar;  inlen : size_t) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_derive_derive_init}
  EVP_PKEY_meth_set_derive_derive_init = function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;

  {$EXTERNALSYM EVP_PKEY_meth_set_derive_derive}
  EVP_PKEY_meth_set_derive_derive = function (ctx : PEVP_PKEY_CTX; key : PIdAnsiChar; keylen : psize_t) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_ctrl_ctrl}
  EVP_PKEY_meth_set_ctrl_ctrl = function(ctx : PEVP_PKEY_CTX; _type : TIdC_INT; p1 : TIdC_INT; p2 : Pointer) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_meth_set_ctrlctrl_str}
  EVP_PKEY_meth_set_ctrlctrl_str = function(ctx : PEVP_PKEY_CTX;
	  _type : PIdAnsiChar; value : PIdAnsiChar) : TIdC_INT cdecl;


var
  {$EXTERNALSYM OpenSSL_add_all_algorithms}
  OpenSSL_add_all_algorithms : procedure cdecl = nil;
  {$EXTERNALSYM OpenSSL_add_all_ciphers}
  OpenSSL_add_all_ciphers : procedure cdecl = nil;
  {$EXTERNALSYM OpenSSL_add_all_digests}
  OpenSSL_add_all_digests : procedure cdecl = nil;
  {$EXTERNALSYM EVP_cleanup}
  EVP_cleanup : procedure cdecl = nil;
  //SSL Version function
  {$EXTERNALSYM _SSLeay_version}
  _SSLeay_version : function(_type : TIdC_INT) : PIdAnsiChar cdecl = nil;
  //SSLeay
  {$EXTERNALSYM SSLeay}
  SSLeay : function : TIdC_ULONG cdecl = nil;
  {$EXTERNALSYM _CRYPTO_lock}
  _CRYPTO_lock : procedure(mode, _type : TIdC_INT; const _file : PIdAnsiChar; line : TIdC_INT) cdecl = nil;

  //CRYPTO_set_mem_ex_functions
  {$EXTERNALSYM CRYPTO_set_mem_functions}
  CRYPTO_set_mem_functions : function(
    m: TCRYPTO_set_mem_functions_m;
    r: TCRYPTO_set_mem_functions_r;
    f: TCRYPTO_set_mem_functions_f): TIdC_INT cdecl = nil;
  {$EXTERNALSYM CRYPTO_malloc}
  CRYPTO_malloc : function(num: TIdC_INT; const _file: PIdAnsiChar; line: TIdC_INT): Pointer cdecl = nil;
  {$EXTERNALSYM CRYPTO_free}
  CRYPTO_free : procedure(ptr : Pointer) cdecl = nil;
  {$EXTERNALSYM CRYPTO_mem_leaks}
  CRYPTO_mem_leaks : procedure(b:PBIO) cdecl = nil;
  {$EXTERNALSYM CRYPTO_mem_ctrl}
  CRYPTO_mem_ctrl : function(mode: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM CRYPTO_set_mem_debug_functions}
  CRYPTO_set_mem_debug_functions : procedure (
      m: Tset_mem_debug_functions_m;
      r: Tset_mem_debug_functions_r;
      f : Tset_mem_debug_functions_f;
      so : Tset_mem_debug_functions_so;
      go : Tset_mem_debug_functions_go) cdecl = nil;
  {$EXTERNALSYM CRYPTO_dbg_malloc}
  CRYPTO_dbg_malloc : procedure(addr: Pointer; num: TIdC_INT; const _file: PIdAnsiChar; line, before: TIdC_INT) cdecl = nil;
  {$EXTERNALSYM CRYPTO_dbg_realloc}
  CRYPTO_dbg_realloc : procedure(arrd1, addr2: Pointer; num: TIdC_INT; const _file: PIdAnsiChar; line, before: TIdC_INT) cdecl = nil;
  {$EXTERNALSYM CRYPTO_dbg_free}
  CRYPTO_dbg_free : procedure(addr: Pointer; before: TIdC_INT) cdecl = nil;
  {$EXTERNALSYM CRYPTO_dbg_set_options}
  CRYPTO_dbg_set_options : procedure(bits: TIdC_LONG) cdecl = nil;
  {$EXTERNALSYM CRYPTO_dbg_get_options}
  CRYPTO_dbg_get_options : function: TIdC_LONG cdecl = nil;
  {$EXTERNALSYM CRYPTO_THREADID_set_numeric}
  CRYPTO_THREADID_set_numeric : procedure(id : PCRYPTO_THREADID; val : TIdC_ULONG) cdecl = nil;
  {$EXTERNALSYM CRYPTO_THREADID_set_pointer}
  CRYPTO_THREADID_set_pointer : procedure(id : PCRYPTO_THREADID; ptr : Pointer) cdecl = nil;
  {$EXTERNALSYM CRYPTO_THREADID_set_callback}
  CRYPTO_THREADID_set_callback : function(threadid_func : TCRYPTO_THREADID_set_callback_threadid_func) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM sk_num}
  sk_num : function (const x : PSTACK) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM sk_value}
  sk_value : function (x : PSTACK; i : TIdC_INT) : PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM sk_new}
  sk_new : function ( cmp : Tsk_new_cmp) : PStack cdecl = nil;
  {$EXTERNALSYM sk_new_null}
  sk_new_null : function: PSTACK cdecl = nil;
  {$EXTERNALSYM sk_free}
  sk_free : procedure (st : PSTACK) cdecl = nil;
  {$EXTERNALSYM sk_push}
  sk_push : function(st: PSTACK; data: PIdAnsiChar): TIdC_INT cdecl = nil;
  {$EXTERNALSYM RSA_new}
  RSA_new: function: PRSA cdecl = nil;
  {$EXTERNALSYM RSA_size}
  RSA_size: function(key: PRSA): TIdC_INT cdecl = nil;
  //This function is depreciated.
  {$EXTERNALSYM RSA_generate_key}
  RSA_generate_key : function(bits: TIdC_INT; e: TIdC_ULONG; callback: TRSA_generate_key_callback; cb_arg: Pointer): PRSA cdecl = nil;
  {$EXTERNALSYM RSA_generate_key_ex}
  RSA_generate_key_ex : function(rsa : PRSA; bits : TIdC_INT; e : PBIGNUM; cb : PBN_GENCB) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM RSA_free}
  RSA_free : procedure(rsa: PRSA) cdecl = nil;
  {$EXTERNALSYM RSA_check_key}
  RSA_check_key : function(const rsa: PRSA): TIdC_INT cdecl = nil;
  {$EXTERNALSYM RSA_private_decrypt}
  RSA_private_decrypt: function(flen: TIdC_INT; from: PByte; _to: PByte; rsa: PRSA; padding: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM RSA_public_encrypt}
  RSA_public_encrypt: function(flen: TIdC_INT; from: PByte; _to: PByte; rsa: PRSA; padding: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_get_default_cert_file}
  X509_get_default_cert_file : function : PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM X509_get_default_cert_file_env}
  X509_get_default_cert_file_env : function : PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM BIO_set_flags}
  BIO_set_flags : procedure(b: PBIO; flags: integer) cdecl = nil;
  {$EXTERNALSYM BIO_new}
  BIO_new : function(_type: PBIO_METHOD): PBIO cdecl = nil;
  {$EXTERNALSYM BIO_new_mem_buf}
  BIO_new_mem_buf : function (buf : Pointer; len : TIdC_INT) : PBIO cdecl = nil;
  {$EXTERNALSYM BIO_push}
  BIO_push : function(b: PBIO; append: PBIO): PBIO cdecl = nil;
  {$EXTERNALSYM BIO_pop}
  BIO_pop : function(b: PBIO): PBIO cdecl = nil;
  {$EXTERNALSYM BIO_set_next}
  BIO_set_next : procedure(b: PBIO; next: PBIO) cdecl = nil;
  {$EXTERNALSYM BIO_free}
  BIO_free : function(bio: PBIO): TIdC_INT cdecl = nil;
  {$EXTERNALSYM BIO_free_all}
  BIO_free_all : procedure(bio: PBIO) cdecl = nil;
  {$EXTERNALSYM BIO_s_mem}
  BIO_s_mem : function: PBIO_METHOD cdecl = nil;
  {$EXTERNALSYM BIO_s_file}
  BIO_s_file : function: PBIO_METHOD cdecl = nil;
  {$EXTERNALSYM BIO_set_ex_data}
  BIO_set_ex_data : function(bio : PBIO; idx : TIdC_INT; data : Pointer) : TidC_INT cdecl = nil;
  {$EXTERNALSYM BIO_get_ex_data}
  BIO_get_ex_data: function(bio : PBIO; idx : TIdC_INT) : Pointer cdecl = nil;
  {$EXTERNALSYM BIO_ctrl}
  BIO_ctrl : function(bp: PBIO; cmd: TIdC_INT; larg: TIdC_LONG; parg: Pointer): TIdC_LONG cdecl = nil;
  {$EXTERNALSYM BIO_ptr_ctrl}
  BIO_ptr_ctrl : function(bp : PBIO; cmd : TIdC_INT; larg : TIdC_LONG) : PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM BIO_int_ctrl}
  BIO_int_ctrl : function(bp : PBIO; cmd : TIdC_INT; larg : TIdC_LONG; iArg : TIdC_INT) : TIdC_LONG cdecl = nil;
  {$EXTERNALSYM BIO_callback_ctrl}
  BIO_callback_ctrl : function(b : PBIO; cmd : TIdC_INT; fp : SSL_callback_ctrl_fp ) : TIdC_LONG cdecl = nil;
  {$EXTERNALSYM BIO_new_file}
  BIO_new_file : function(const filename: PIdAnsiChar; const mode: PIdAnsiChar): PBIO cdecl = nil;
  {$EXTERNALSYM BIO_puts}
  BIO_puts : function(b: PBIO; const txt: PIdAnsiChar): TIdC_INT cdecl = nil;
  {$EXTERNALSYM BIO_read}
  BIO_read : function(b: PBIO; data: Pointer; len: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM BIO_write}
  BIO_write : function(b: PBIO; const buf: Pointer; len: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM BN_hex2bn}
  BN_hex2bn: function(var n:PBIGNUM; const Str: PIdAnsiChar): TIdC_INT cdecl = nil;
  {$EXTERNALSYM BN_new}
  BN_new : function(): PBIGNUM cdecl = nil;
  {$EXTERNALSYM BN_free}
  BN_free : procedure(a: PBIGNUM) cdecl = nil;
  {$EXTERNALSYM BN_bn2dec}
  BN_bn2dec: function(const n:PBIGNUM): PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM BN_bn2hex}
  BN_bn2hex: function(const n:PBIGNUM): PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM BN_set_word}
  BN_set_word: function(a: PBIGNUM; w: TIdC_ULONG): TIdC_INT cdecl = nil;
  {$EXTERNALSYM DH_free}
  DH_free : procedure(dh: PDH) cdecl = nil;

  {$IFNDEF SSLEAY_MACROS}
  //Note that these are defined as a pointer to a pointer to a structure.
  //This is done because the pointer being passed could be nil.  The pointer is probably
  //more of a template than anything.  If it is used, it should be initialized to nil.
  {$EXTERNALSYM _PEM_read_bio_X509}
  _PEM_read_bio_X509 : function(bp: PBIO; x: PPX509; cb: ppem_password_cb; u: Pointer): PX509 cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_X509_REQ}
  _PEM_read_bio_X509_REQ : function(bp :PBIO; x : PPX509_REQ; cb :ppem_password_cb; u: PIdAnsiChar) : PX509_REQ cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_X509_CRL}
  _PEM_read_bio_X509_CRL : function(bp : PBIO; x : PPX509_CRL;cb : ppem_password_cb; u: Pointer) : PX509_CRL cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_RSAPrivateKey}
  _PEM_read_bio_RSAPrivateKey : function(bp : PBIO; x : PPRSA; cb : ppem_password_cb; u: Pointer) : PRSA cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_RSAPublicKey}
  _PEM_read_bio_RSAPublicKey : function(bp : PBIO; x : PPRSA; cb : ppem_password_cb; u: Pointer) : PRSA cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_DSAPrivateKey}
  _PEM_read_bio_DSAPrivateKey : function(bp : PBIO; x : PPDSA; cb : ppem_password_cb; u : Pointer) : PDSA cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_PrivateKey}
  _PEM_read_bio_PrivateKey : function(bp : PBIO; x : PPEVP_PKEY; cb : ppem_password_cb; u : Pointer) : PEVP_PKEY cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_PKCS7}
  _PEM_read_bio_PKCS7 : function(bp : PBIO; x : PPPKCS7; cb : ppem_password_cb; u : Pointer) : PPKCS7 cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_DHparams}
  _PEM_read_bio_DHparams : function(bp : PBIO; x : PPDH; cb : ppem_password_cb; u : Pointer) : PDH cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_DSAparams}
  _PEM_read_bio_DSAparams : function(bp : PBIO; x : PPDSA; cb : ppem_password_cb; u : Pointer) : PDSA cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_NETSCAPE_CERT_SEQUENCE}
  _PEM_read_bio_NETSCAPE_CERT_SEQUENCE : function(bp : PBIO; x : PPNETSCAPE_CERT_SEQUENCE;
    cb : ppem_password_cb; u : Pointer) : PNETSCAPE_CERT_SEQUENCE cdecl = nil;
  {$EXTERNALSYM _PEM_read_bio_PUBKEY}
  _PEM_read_bio_PUBKEY : function(bp : PBIO; x : PPEVP_PKEY; cb : ppem_password_cb; u : Pointer) : PEVP_PKEY cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_X509}
  _PEM_write_bio_X509 : function(b: PBIO; x: PX509): TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_X509_REQ}
  _PEM_write_bio_X509_REQ : function(bp: PBIO; x: PX509_REQ): TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_X509_CRL}
  _PEM_write_bio_X509_CRL : function(bp : PBIO; x : PX509_CRL) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_RSAPublicKey}
  _PEM_write_bio_RSAPublicKey : function(bp : PBIO; x : PRSA) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_RSAPrivateKey}
  _PEM_write_bio_RSAPrivateKey : function(bp : PBIO; x : PRSA; const enc : PEVP_CIPHER;
     kstr : PIdAnsiChar; klen : TIdC_INT; cb : ppem_password_cb; u : POinter) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_DSAPrivateKey}
  _PEM_write_bio_DSAPrivateKey : function(bp : PBIO; x : PDSA; const enc : PEVP_CIPHER;
    kstr : PIdAnsiChar; klen : TIdC_INT; cb : Ppem_password_cb; u : Pointer) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_PrivateKey}
  _PEM_write_bio_PrivateKey : function(bp : PBIO; x : PEVP_PKEY; const enc : PEVP_CIPHER;
    kstr : PIdAnsiChar; klen : TIdC_INT; cb : Ppem_password_cb; u : Pointer) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_PKCS7}
  _PEM_write_bio_PKCS7 : function(bp : PBIO; x : PPKCS7) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_DHparams}
  _PEM_write_bio_DHparams : function(bp : PBIO; x : PDH): TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_DSAparams}
  _PEM_write_bio_DSAparams : function(bp : PBIO; x : PDSA) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_NETSCAPE_CERT_SEQUENCE}
  _PEM_write_bio_NETSCAPE_CERT_SEQUENCE : function(bp : PBIO; x : PDSA) : TIdC_INT cdecl = nil;
    {$IFNDEF OPENSSL_NO_BIO}
  {$EXTERNALSYM _PEM_write_bio_PKCS8PrivateKey}
  _PEM_write_bio_PKCS8PrivateKey : function(bp: PBIO; key: PEVP_PKEY; enc: PEVP_CIPHER;
      kstr: PIdAnsiChar; klen: TIdC_INT; cb: ppem_password_cb; u: Pointer): TIdC_INT cdecl = nil;
  {$EXTERNALSYM _PEM_write_bio_PUBKEY}
  _PEM_write_bio_PUBKEY : function(bp: PBIO; x: PEVP_PKEY): TIdC_INT cdecl = nil;
    {$ENDIF}
  {$ELSE}
    {$IFNDEF OPENSSL_NO_BIO}
  {$EXTERNALSYM PEM_ASN1_write_bio}
  PEM_ASN1_write_bio : function(i2d: i2d_of_void; const name: PIdAnsiChar;
    bp: PBIO; x: PIdAnsiChar; const enc: PEVP_CIPHER; kstr: PIdAnsiChar; klen: TIdC_INT;
    cb: ppem_password_cb; u: Pointer):TIdC_INT cdecl = nil;
  {$EXTERNALSYM PEM_ASN1_read_bio}
  PEM_ASN1_read_bio : function(d2i: d2i_OF_void; name: PIdAnsiChar; bp: PBIO;
      x: PPointer; cb: ppem_password_cb; u:Pointer): Pointer cdecl = nil;
    {$ENDIF}
  {$ENDIF}
  {$EXTERNALSYM PEM_X509_INFO_read_bio}
  PEM_X509_INFO_read_bio : function (bp : PBIO; sk : PSTACK_OF_X509_INFO;
    cb : ppem_password_cb; u : Pointer) : PSTACK_OF_X509_INFO cdecl = nil;
  {$EXTERNALSYM PEM_read_bio_X509_AUX}
  PEM_read_bio_X509_AUX : function (bp : PBIO; x : PPX509;
    cb : ppem_password_cb; u : Pointer) : PX509 cdecl = nil;
  {$EXTERNALSYM EVP_DigestInit}
  EVP_DigestInit : function(ctx : PEVP_MD_CTX; _type : PEVP_MD) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DigestFinal}
  EVP_DigestFinal : function(ctx : PEVP_MD_CTX;md : PIdAnsiChar; s : TIdC_UINT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DigestInit_ex}
  EVP_DigestInit_ex : function (ctx : PEVP_MD_CTX; const AType : PEVP_MD; impl : PENGINE) : TIdC_Int cdecl = nil;
  {$EXTERNALSYM EVP_DigestUpdate}
  EVP_DigestUpdate : function (ctx : PEVP_MD_CTX; d : Pointer; cnt : size_t) : TIdC_Int cdecl = nil;
  {$EXTERNALSYM EVP_DigestFinal_ex}
  EVP_DigestFinal_ex : function(ctx : PEVP_MD_CTX; md : PIdAnsiChar; var s : TIdC_UInt) : TIdC_Int cdecl = nil;
   {$EXTERNALSYM EVP_EncryptInit}
  EVP_EncryptInit : function(ctx : PEVP_CIPHER_CTX;cipher : PEVP_CIPHER;
		key : PIdAnsiChar; iv : PIdAnsiChar) : TIdC_INT cdecl = nil;
   {$EXTERNALSYM EVP_EncryptInit_ex}
  EVP_EncryptInit_ex : function(ctx : PEVP_CIPHER_CTX; cipher : PEVP_CIPHER; impl : PENGINE;
		key : PIdAnsiChar; iv : PIdAnsiChar) : TIdC_INT cdecl = nil;
   {$EXTERNALSYM EVP_EncryptUpdate}
  	EVP_EncryptUpdate : function(ctx : PEVP_CIPHER_CTX; _out : PIdAnsiChar;
		outl : PIdC_INT; _in : PIdAnsiChar; inl : TIdC_INT) : TIdC_INT cdecl = nil;
   {$EXTERNALSYM EVP_EncryptFinal_ex}
	EVP_EncryptFinal_ex : function(ctx : PEVP_CIPHER_CTX; _out : PIdAnsiChar; outl : PIdC_INT) : TIdC_INT cdecl = nil;
   {$EXTERNALSYM EVP_EncryptFinal}
	EVP_EncryptFinal : function(ctx : PEVP_CIPHER_CTX; _out : PIdAnsiChar; outl: PIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DecryptInit}
	EVP_DecryptInit : function(ctx : PEVP_CIPHER_CTX; cipher : PEVP_CIPHER;
		key : PIdAnsiChar; iv : PIdAnsiChar) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DecryptInit_ex}
  EVP_DecryptInit_ex : function(ctx : PEVP_CIPHER_CTX; cipher : PEVP_CIPHER; impl : PENGINE;
		key : PIdAnsiChar; iv : PIdAnsiChar) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DecryptUpdate}
  EVP_DecryptUpdate : function(ctx : PEVP_CIPHER_CTX; _out : PIdAnsiChar;
		outl : PIdC_INT; _in : PIdAnsiChar; inl : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DecryptFinal}
  EVP_DecryptFinal : function(ctx : PEVP_CIPHER_CTX; outm : PIdAnsiChar; outl : PIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DecryptFinal_ex}
  EVP_DecryptFinal_ex : function(ctx : PEVP_CIPHER_CTX; outm: PIdAnsiChar; outl : PIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CipherInit}
  EVP_CipherInit : function(ctx : PEVP_CIPHER_CTX; cipher : PEVP_CIPHER;
	  key : PIdAnsiChar; iv : PIdAnsiChar;
		enc : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CipherInit_ex}
  EVP_CipherInit_ex : function(ctx : PEVP_CIPHER_CTX; cipher: PEVP_CIPHER; impl : PENGINE;
		key : PIdAnsiChar; iv : PIdAnsiChar;
		enc : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CipherUpdate}
  EVP_CipherUpdate : function(ctx : PEVP_CIPHER_CTX; _out : PIdAnsiChar;
		outl : PIdC_INT; _in : PIdAnsiChar; inl : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CipherFinal}
  EVP_CipherFinal : function(ctx : PEVP_CIPHER_CTX; outm : PIdAnsiChar; outl : PIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CipherFinal_ex}
  EVP_CipherFinal_ex: function(ctx : PEVP_CIPHER_CTX; outm : PIdAnsiChar; outl : PIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_SignFinal}
  EVP_SignFinal : function(ctx : PEVP_MD_CTX; md : PIdAnsiChar; s : PIdC_INT;
		pkey : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_VerifyFinal}
  EVP_VerifyFinal : function(ctx : PEVP_MD_CTX; sigbuf : PIdAnsiChar;
	  siglen : TIdC_UINT; pkey : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DigestSignInit}
  EVP_DigestSignInit : function(ctx : PEVP_MD_CTX; pctx : PPEVP_PKEY_CTX;
    _type : PEVP_MD; e : PENGINE; pkey : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DigestSignFinal}
  EVP_DigestSignFinal : function(ctx : PEVP_MD_CTX;
    sigret : PIdAnsiChar; siglen : Psize_t) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DigestVerifyInit}
  EVP_DigestVerifyInit : function(ctx : PEVP_MD_CTX; pctx : PPEVP_PKEY_CTX;
    _type : PEVP_MD;e : PENGINE; pkey : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DigestVerifyFinal}
	EVP_DigestVerifyFinal: function(ctx : PEVP_MD_CTX;
    sig : PIdAnsiChar;  siglen : size_t) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_OpenInit}
  EVP_OpenInit : function(ctx : PEVP_CIPHER_CTX; _type : PEVP_CIPHER;
		ek : PIdAnsiChar; ekl : TIdC_INT; iv : PIdAnsiChar;
		priv : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_OpenFinal}
	EVP_OpenFinal : function (ctx : PEVP_CIPHER_CTX; _out : PIdAnsiChar; outl : PIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_SealInit}
  EVP_SealInit : function(ctx : PEVP_CIPHER_CTX; _type : PEVP_CIPHER;
	  ek : PPIdAnsiChar; ekl : PIdC_INT; iv : PIdAnsiChar;
		pubk : PPEVP_PKEY; npubk : TIdC_INT) : TIdC_INT cdecl = nil;
   {$EXTERNALSYM EVP_SealFinal}
  EVP_SealFinal : function(ctx : PEVP_CIPHER_CTX; _out : PIdAnsiChar; outl : PIdC_INT) : TIdC_INT cdecl = nil;
   {$EXTERNALSYM EVP_EncodeInit}
  EVP_EncodeInit : procedure(ctx : PEVP_ENCODE_CTX) cdecl = nil;
  {$EXTERNALSYM EVP_EncodeUpdate}
  EVP_EncodeUpdate : procedure(ctx : PEVP_ENCODE_CTX; _out : PIdAnsiChar; outl : PIdC_INT;
		_in : PIdAnsiChar; inl : TIdC_INT) cdecl = nil;
  {$EXTERNALSYM EVP_EncodeFinal}
  EVP_EncodeFinal : procedure(ctx : PEVP_ENCODE_CTX; _out: PIdAnsiChar; outl : PIdC_INT) cdecl = nil;
    {$EXTERNALSYM EVP_EncodeBlock}
  EVP_EncodeBlock : function(t: PIdAnsiChar; f: PIdAnsiChar; n : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DecodeInit}
	EVP_DecodeInit : procedure(ctx : PEVP_ENCODE_CTX) cdecl = nil;
   {$EXTERNALSYM EVP_DecodeUpdate}
  EVP_DecodeUpdate : function(ctx : PEVP_ENCODE_CTX; _out : PIdAnsiChar; outl : PIdC_INT;
		_in  : PIdAnsiChar; inl : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DecodeFinal}
  EVP_DecodeFinal: function(ctx : PEVP_ENCODE_CTX; _out : PIdAnsiChar; outl : PIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_DecodeBlock}
  EVP_DecodeBlock : function(t: PIdAnsiChar; f: PIdAnsiChar; n : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_init}
  EVP_CIPHER_CTX_init : procedure(a : PEVP_CIPHER_CTX) cdecl = nil;
   {$EXTERNALSYM EVP_CIPHER_CTX_cleanup}
  EVP_CIPHER_CTX_cleanup : function(a : PEVP_CIPHER_CTX) : TIdC_INT cdecl = nil;
   {$EXTERNALSYM EVP_CIPHER_CTX_new}
  EVP_CIPHER_CTX_new : function : PEVP_CIPHER_CTX cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_free}
  EVP_CIPHER_CTX_free: procedure(a : PEVP_CIPHER_CTX) cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_set_key_length}
  EVP_CIPHER_CTX_set_key_length : function(x : PEVP_CIPHER_CTX; keylen : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_set_padding}
  EVP_CIPHER_CTX_set_padding : function(c : PEVP_CIPHER_CTX; pad : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_ctrl}
  EVP_CIPHER_CTX_ctrl : function(ctx : PEVP_CIPHER_CTX; _type : TIdC_INT; arg : TIdC_INT; ptr : Pointer) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_rand_key}
  EVP_CIPHER_CTX_rand_key : function(ctx : PEVP_CIPHER_CTX; key : PIdAnsiChar) : TIdC_INT cdecl = nil;
  {$ifndef OPENSSL_NO_BIO}
  {$EXTERNALSYM BIO_f_md}
  BIO_f_md : function : PBIO_METHOD cdecl = nil;
  {$EXTERNALSYM BIO_f_base64}
  BIO_f_base64 : function : PBIO_METHOD cdecl = nil;
  {$EXTERNALSYM BIO_f_cipher}
  BIO_f_cipher : function : PBIO_METHOD cdecl = nil;
  {$EXTERNALSYM BIO_f_reliable}
  BIO_f_reliable : function : PBIO_METHOD cdecl = nil;
  {$EXTERNALSYM BIO_set_cipher}
  BIO_set_cipher : procedure (b : PBIO; c : PEVP_CIPHER; k : PIdAnsiChar;
		i : PIdAnsiChar; enc : TIdC_INT) cdecl = nil;
  {$endif}
  {$EXTERNALSYM EVP_MD_CTX_init}
  EVP_MD_CTX_init : procedure(ctx : PEVP_MD_CTX) cdecl = nil;
  {$EXTERNALSYM EVP_MD_CTX_cleanup}
  EVP_MD_CTX_cleanup : function(ctx : PEVP_MD_CTX) : TIdC_Int cdecl = nil;
  {$EXTERNALSYM EVP_MD_CTX_create}
  EVP_MD_CTX_create: function : PEVP_MD_CTX cdecl = nil;
  {$EXTERNALSYM EVP_MD_CTX_destroy}
  EVP_MD_CTX_destroy : procedure(ctx : PEVP_MD_CTX) cdecl = nil;
  {$EXTERNALSYM EVP_MD_CTX_copy}
  EVP_MD_CTX_copy : function(_out : PEVP_MD_CTX; _in: PEVP_MD_CTX): TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_MD_CTX_copy_ex}
  EVP_MD_CTX_copy_ex : function (_out : PEVP_MD_CTX; const _in: PEVP_MD_CTX): TIdC_INT cdecl = nil;

  {$IFNDEF OPENSSL_NO_DES}
  {$EXTERNALSYM EVP_des_ede3_cbc}
  EVP_des_ede3_cbc : function: PEVP_CIPHER cdecl = nil;
  {$ENDIF}
  {$EXTERNALSYM EVP_PKEY_new}
  EVP_PKEY_new : function : PEVP_PKEY cdecl = nil;

  {$EXTERNALSYM EVP_PKEY_free}
  EVP_PKEY_free : procedure(pkey: PEVP_PKEY) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_assign}
  EVP_PKEY_assign : function(pkey: PEVP_PKEY; _type: TIdC_INT; key: Pointer): TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_get_cipherbyname}
  EVP_get_cipherbyname : function(const name : PIdAnsiChar): PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_get_digestbyname}
  EVP_get_digestbyname : function(const name: PIdAnsiChar): PEVP_MD cdecl = nil;
  {$EXTERNALSYM EVP_MD_type}
  EVP_MD_type : function (md : PEVP_MD) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_MD_size}
  EVP_MD_size : function (md : PEVP_MD) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_MD_block_size}
  EVP_MD_block_size : function (md : PEVP_MD) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_MD_flags}
  EVP_MD_flags : function (md : PEVP_MD) : TIdC_ULONG cdecl = nil;
  {$EXTERNALSYM EVP_MD_CTX_md}
  EVP_MD_CTX_md : function (ctx : PEVP_MD_CTX) : PEVP_MD cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_nid}
  EVP_CIPHER_nid : function (cipher : PEVP_CIPHER) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_block_size}
  EVP_CIPHER_block_size : function(cipher : PEVP_CIPHER) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_key_length}
  EVP_CIPHER_key_length : function(cipher : EVP_CIPHER) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_iv_length}
  EVP_CIPHER_iv_length : function(cipher: PEVP_CIPHER) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_flags}
  EVP_CIPHER_flags : function(cipher : PEVP_CIPHER) : TIdC_ULONG cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_type}
  EVP_CIPHER_type : function(ctx : PEVP_CIPHER) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_cipher}
  EVP_CIPHER_CTX_cipher : function (ctx : PEVP_CIPHER_CTX) : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_nid}
  EVP_CIPHER_CTX_nid : function (ctx : PEVP_CIPHER_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_block_size}
  EVP_CIPHER_CTX_block_size : function(ctx : PEVP_CIPHER_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_key_length}
  EVP_CIPHER_CTX_key_length : function(ctx : PEVP_CIPHER_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_iv_length}
  EVP_CIPHER_CTX_iv_length : function(ctx : PEVP_CIPHER_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_copy}
  EVP_CIPHER_CTX_copy : function(_out : PEVP_CIPHER_CTX; _in : PEVP_CIPHER_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_get_app_data}
  EVP_CIPHER_CTX_get_app_data : function(ctx : PEVP_CIPHER_CTX) : Pointer cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_set_app_data}
  EVP_CIPHER_CTX_set_app_data : procedure(ctx : PEVP_CIPHER_CTX; data : Pointer) cdecl =nil;
  {$EXTERNALSYM EVP_CIPHER_CTX_flags}
  EVP_CIPHER_CTX_flags : function(ctx : PEVP_CIPHER_CTX) : TIdC_ULONG cdecl = nil;
  {$EXTERNALSYM ASN1_INTEGER_set}
  ASN1_INTEGER_set : function(a: PASN1_INTEGER; v: TIdC_LONG): TIdC_INT cdecl = nil;
  {$EXTERNALSYM ASN1_INTEGER_get}
  ASN1_INTEGER_get : function(a: PASN1_INTEGER) : TIdC_LONG cdecl = nil;
  //IdSslAsn1UtcTimeNew : function: Pointer cdecl = nil;
  {$EXTERNALSYM ASN1_INTEGER_to_BN}
  ASN1_INTEGER_to_BN : function(a: PASN1_INTEGER; bn: PBIGNUM) : PBIGNUM cdecl = nil;
  {$EXTERNALSYM ASN1_STRING_type_new}
  ASN1_STRING_type_new : function(_type: TIdC_INT): PASN1_STRING cdecl = nil;
  {$EXTERNALSYM ASN1_STRING_free}
  ASN1_STRING_free : procedure(a: PASN1_STRING) cdecl = nil;
  {$EXTERNALSYM ASN1_dup}
  ASN1_dup : function (i2d : i2d_of_void; d2i : d2i_of_void; x : PIdAnsiChar) : Pointer cdecl = nil;
  {$EXTERNALSYM i2d_X509}
  i2d_X509 : function(x: PX509;  buf: PPByte) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_X509}
  d2i_X509 : function(pr : PX509; _in : PPByte; len : TIdC_INT): PX509 cdecl = nil;
  {$EXTERNALSYM i2d_X509_NAME}
  i2d_X509_NAME : function(x : PX509_NAME; buf : PPByte) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_X509_NAME}
  d2i_X509_NAME : function(pr : PPX509_NAME; _in : PPByte; length : TIdC_LONG):PX509_NAME cdecl = nil;
  {$EXTERNALSYM i2d_X509_REQ}
  i2d_X509_REQ : function(x: PX509_REQ;  buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_X509_REQ}
  d2i_X509_REQ : function(pr : PX509_REQ; _in : PPByte; len : TIdC_INT): PX509_REQ cdecl = nil;
  {$EXTERNALSYM i2d_X509_CRL}
  i2d_X509_CRL : function(x: PX509_CRL; buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_X509_CRL}
  d2i_X509_CRL : function(pr : PX509_CRL; _in : PPByte; len : TIdC_INT): PX509_REQ cdecl = nil;
  {$EXTERNALSYM i2d_RSAPrivateKey}
  i2d_RSAPrivateKey : function(x: PRSA; buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_RSAPrivateKey}
  d2i_RSAPrivateKey : function(pr : PRSA; _in : PPByte; len : TIdC_INT): PRSA cdecl = nil;
  {$EXTERNALSYM i2d_RSAPublicKey}
  i2d_RSAPublicKey : function(x: PRSA; buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_RSAPublicKey}
  d2i_RSAPublicKey : function(pr : PRSA; _in : PPByte; len : TIdC_INT): PRSA cdecl = nil;
  {$EXTERNALSYM i2d_DSAPrivateKey}
  i2d_DSAPrivateKey : function(x: PDSA; buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_DSAPrivateKey}
  d2i_DSAPrivateKey : function(pr : PDSA; _in : PPByte; len : TIdC_INT): PDSA cdecl = nil;
  {$EXTERNALSYM i2d_PrivateKey}
  i2d_PrivateKey : function(x: PEVP_PKEY; buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_PrivateKey}
  d2i_PrivateKey : function(pr : PEVP_PKEY; _in : PPByte; len : TIdC_INT): PEVP_PKEY cdecl = nil;
  {$EXTERNALSYM i2d_PKCS7}
  i2d_PKCS7 : function(x: PPKCS7; buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_PKCS7}
  d2i_PKCS7 : function(pr : PPKCS7; _in : PPByte; len : TIdC_INT): PPKCS7 cdecl = nil;
  {$EXTERNALSYM i2d_DHparams}
  i2d_DHparams : function(x: PDH; buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_DHparams}
  d2i_DHparams : function(pr : PDH; _in : PPByte; len : TIdC_INT): PDH cdecl = nil;
  {$EXTERNALSYM i2d_DSAparams}
  i2d_DSAparams : function(x: PDSA; buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_DSAparams}
  d2i_DSAparams : function(pr : PDSA; _in : PPByte; len : TIdC_INT): PDSA cdecl = nil;
//NETSCAPE_CERT_SEQUENCE
  {$EXTERNALSYM i2d_NETSCAPE_CERT_SEQUENCE}
  i2d_NETSCAPE_CERT_SEQUENCE : function(x: PNETSCAPE_CERT_SEQUENCE; buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_NETSCAPE_CERT_SEQUENCE}
  d2i_NETSCAPE_CERT_SEQUENCE : function(pr : PNETSCAPE_CERT_SEQUENCE; _in : PPByte; len : TIdC_INT): PNETSCAPE_CERT_SEQUENCE cdecl = nil;
  {$EXTERNALSYM i2d_PUBKEY}
  i2d_PUBKEY : function(x: PEVP_PKEY; buf: PPByte): TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_PUBKEY}
  d2i_PUBKEY : function(pr : PEVP_PKEY; _in : PPByte; len : TIdC_INT): PEVP_PKEY cdecl = nil;

  {$IFNDEF OPENSSL_NO_BIO}
  {$EXTERNALSYM d2i_X509_bio}
  d2i_X509_bio : function(bp: PBIO; x: PPx509): PX509 cdecl = nil;
  {$EXTERNALSYM i2d_X509_REQ_bio}
  i2d_X509_REQ_bio : function(bp: PBIO; x: PX509_REQ): TIdC_INT cdecl = nil;
  {$EXTERNALSYM i2d_X509_bio}
  i2d_X509_bio : function(bp: PBIO; x: PX509): TIdC_INT cdecl = nil;
  {$EXTERNALSYM i2d_PrivateKey_bio}
  i2d_PrivateKey_bio : function(b: PBIO; pkey: PEVP_PKEY): TIdC_INT cdecl = nil;
  //P12 additions
  {$EXTERNALSYM d2i_PKCS12_bio}
  d2i_PKCS12_bio: function(bp: PBIO; x: PPPKCS12): PPKCS12 cdecl = nil;
  {$EXTERNALSYM PKCS12_parse}
  PKCS12_parse: function(P12: PPKCS12; Password: PIdAnsiChar; out PrivateKey: PEVP_PKEY; out Cert: PX509; CertChain: PPSTACK_OF_X509): TIdC_INT cdecl = nil;
  {$ENDIF}

  {$EXTERNALSYM X509_new}
  X509_new : function: PX509 cdecl = nil;
  {$EXTERNALSYM X509_free}
  X509_free : procedure(x: PX509) cdecl = nil;
  {$EXTERNALSYM X509_NAME_new}
  X509_NAME_new : function :PX509_NAME cdecl = nil;
  {$EXTERNALSYM X509_NAME_free}
  X509_NAME_free : procedure(x:PX509_NAME) cdecl = nil;
  {$EXTERNALSYM X509_REQ_new}
  X509_REQ_new : function :PX509_REQ cdecl = nil;
  {$EXTERNALSYM X509_REQ_free}
  X509_REQ_free : procedure(x:PX509_REQ) cdecl = nil;
  {$EXTERNALSYM X509_to_X509_REQ}
  X509_to_X509_REQ : function(x: PX509; pkey: PEVP_PKEY; const md: PEVP_MD): PX509_REQ cdecl = nil;
  {$EXTERNALSYM X509_NAME_add_entry_by_txt}
  X509_NAME_add_entry_by_txt : function(name: PX509_NAME; const field: PIdAnsiChar; _type: TIdC_INT;
    const bytes: PIdAnsiChar; len, loc, _set: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_INFO_free}
  X509_INFO_free : procedure (a : PX509_INFO) cdecl = nil;
  {$EXTERNALSYM X509_set_version}
  X509_set_version : function(x: PX509; version: TIdC_LONG): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_get_serialNumber}
  X509_get_serialNumber : function(x: PX509): PASN1_INTEGER cdecl = nil;
  {$EXTERNALSYM X509_gmtime_adj}
  X509_gmtime_adj : function(s: PASN1_TIME; adj: TIdC_LONG): PASN1_TIME cdecl = nil;
  {$EXTERNALSYM X509_set_notBefore}
  X509_set_notBefore : function(x: PX509; tm: PASN1_TIME): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_set_notAfter}
  X509_set_notAfter : function(x: PX509; tm: PASN1_TIME): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_set_pubkey}
  X509_set_pubkey : function(x: PX509; pkey: PEVP_PKEY): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_REQ_set_pubkey}
  X509_REQ_set_pubkey : function(x: PX509_REQ; pkey: PEVP_PKEY): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_PUBKEY_get}
  X509_PUBKEY_get : function(key: PX509_PUBKEY): PEVP_PKEY cdecl = nil;
  {$EXTERNALSYM X509_verify}
  X509_verify : function(x509: PX509; pkey: PEVP_PKEY): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_sign}
  X509_sign : function(x: PX509; pkey: PEVP_PKEY; const md: PEVP_MD): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_REQ_sign}
  X509_REQ_sign : function(x: PX509_REQ; pkey: PEVP_PKEY; const md: PEVP_MD): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_REQ_add_extensions}
  X509_REQ_add_extensions : function(req: PX509_REQ; exts: PSTACK_OF_X509_EXTENSION): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509V3_EXT_conf_nid}
  X509V3_EXT_conf_nid : function(conf: PLHASH; ctx: PX509V3_CTX; ext_nid: TIdC_INT; value: PIdAnsiChar): PX509_EXTENSION cdecl = nil;
  {$EXTERNALSYM X509_EXTENSION_create_by_NID}
  X509_EXTENSION_create_by_NID : function(ex: PPX509_EXTENSION; nid: TIdC_INT;
    crit: TIdC_INT; data: PASN1_OCTET_STRING): PX509_EXTENSION cdecl = nil;
  {$EXTERNALSYM X509V3_set_ctx}
  X509V3_set_ctx : procedure(ctx: PX509V3_CTX; issuer, subject: PX509; req: PX509_REQ; crl: PX509_CRL; flags: TIdC_INT) cdecl = nil;
  {$EXTERNALSYM X509_EXTENSION_free}
  X509_EXTENSION_free : procedure(ex: PX509_EXTENSION) cdecl = nil;
  {$EXTERNALSYM X509_add_ext}
  X509_add_ext : function(cert: PX509; ext: PX509_EXTENSION; loc: TIdC_INT): TIdC_INT cdecl = nil;
  {$IFNDEF OPENSSL_NO_BIO}
  {$EXTERNALSYM X509_print}
  X509_print : function(bp : PBIO; x : PX509) : TIdC_INT cdecl = nil;
  {$ENDIF}
  {$EXTERNALSYM X509_STORE_add_lookup}
  X509_STORE_add_lookup : function (v : PX509_STORE; m : PX509_LOOKUP_METHOD) : PX509_LOOKUP cdecl = nil;
  {$EXTERNALSYM X509_STORE_load_locations}
  X509_STORE_load_locations : function ( ctx : PX509_STORE; const _file, path : PIdAnsiChar) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_CTX_set_cipher_list}
  SSL_CTX_set_cipher_list : function(_para1: PSSL_CTX; const str: PIdAnsiChar): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_CTX_new}
  SSL_CTX_new : function(meth: PSSL_METHOD): PSSL_CTX cdecl = nil;
  {$EXTERNALSYM SSL_CTX_free}
  SSL_CTX_free : procedure(_para1: PSSL_CTX) cdecl = nil;
  {$EXTERNALSYM SSL_set_fd}
  SSL_set_fd : function(s: PSSL; fd: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_CTX_use_PrivateKey_file}
  SSL_CTX_use_PrivateKey_file : function(ctx: PSSL_CTX; const _file: PIdAnsiChar; _type: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_CTX_use_PrivateKey}
  SSL_CTX_use_PrivateKey : function(ctx: PSSL_CTX; pkey: PEVP_PKEY): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_CTX_use_certificate}
  SSL_CTX_use_certificate : function(ctx: PSSL_CTX; x: PX509): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_CTX_use_certificate_file}
  SSL_CTX_use_certificate_file : function(ctx: PSSL_CTX; const _file: PIdAnsiChar; _type: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_CTX_use_certificate_chain_file}   //OpenSSL 1.0.2
  SSL_CTX_use_certificate_chain_file : function(ctx : PSSL_CTX; _file : PIdAnsiChar) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_load_error_strings}
  SSL_load_error_strings : procedure cdecl = nil;
  {$EXTERNALSYM SSL_state_string_long}
  SSL_state_string_long : function(s: PSSL): PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM SSL_alert_desc_string_long}
  SSL_alert_desc_string_long : function(value : TIdC_INT) : PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM SSL_alert_type_string_long}
  SSL_alert_type_string_long : function(value : TIdC_INT) : PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM SSL_get_peer_certificate}
  SSL_get_peer_certificate : function(s: PSSL): PX509 cdecl = nil;
  {$EXTERNALSYM SSL_CTX_set_verify}
  SSL_CTX_set_verify : procedure(ctx: PSSL_CTX; mode: TIdC_INT; callback: TSSL_CTX_set_verify_callback) cdecl = nil;
  {$EXTERNALSYM SSL_CTX_set_verify_depth}
  SSL_CTX_set_verify_depth : procedure(ctx: PSSL_CTX; depth: TIdC_INT) cdecl = nil;
  {$EXTERNALSYM SSL_CTX_get_verify_depth}
  SSL_CTX_get_verify_depth : function (ctx: PSSL_CTX): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_CTX_set_default_passwd_cb}
  SSL_CTX_set_default_passwd_cb : procedure(ctx: PSSL_CTX; cb: ppem_password_cb) cdecl = nil;
  {$EXTERNALSYM SSL_CTX_set_default_passwd_cb_userdata}
  SSL_CTX_set_default_passwd_cb_userdata: procedure(ctx: PSSL_CTX; u: Pointer) cdecl = nil;
  {$EXTERNALSYM SSL_CTX_check_private_key}
  SSL_CTX_check_private_key : function(ctx: PSSL_CTX): TIdC_INT cdecl = nil;


  {$EXTERNALSYM SSL_new}
  SSL_new : function(ctx: PSSL_CTX): PSSL cdecl = nil;
  {$EXTERNALSYM SSL_free}
  SSL_free : procedure(ssl: PSSL) cdecl = nil;
  {$EXTERNALSYM SSL_accept}
  SSL_accept : function(ssl: PSSL): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_connect}
  SSL_connect : function(ssl: PSSL): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_read}
  SSL_read : function(ssl: PSSL; buf: Pointer; num: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_peek}
  SSL_peek : function(ssl: PSSL; buf: Pointer; num: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_write}
  SSL_write : function(ssl: PSSL; const buf: Pointer; num: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_pending}
  SSL_pending : function(ssl : PSSL) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_CTX_ctrl}
  //long  SSL_CTX_ctrl(SSL_CTX *ctx,int cmd, long larg, void *parg);
  SSL_CTX_ctrl : function(ssl: PSSL_CTX; cmd: TIdC_INT; larg: TIdC_LONG; parg: Pointer): TIdC_LONG cdecl = nil;
  {$EXTERNALSYM SSL_ctrl}
  //long	SSL_ctrl(SSL *ssl,int cmd, long larg, void *parg);
  SSL_ctrl : function(ssl : PSSL; cmd : TIdC_INT; larg : TIdC_LONG; parg : Pointer) : TIdC_LONG cdecl = nil;
  {$EXTERNALSYM SSL_callback_ctrl}
  //long	SSL_callback_ctrl(SSL *, int, void (*)(void));
  SSL_callback_ctrl : function(ssl : PSSL; cmd : TIdC_INT; fp : SSL_callback_ctrl_fp) : TIdC_LONG cdecl = nil;
  {$EXTERNALSYM SSL_CTX_callback_ctrl}
  //long	SSL_CTX_callback_ctrl(SSL_CTX *, int, void (*)(void));
  SSL_CTX_callback_ctrl : function(ssl : PSSL_CTX; cmd : TIdC_INT; fp : SSL_callback_ctrl_fp) : TIdC_LONG cdecl = nil;
  {$EXTERNALSYM SSL_get_error}
  SSL_get_error : function(s: PSSL; ret_code: TIdC_INT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSLv2_method}
  SSLv2_method : function: PSSL_METHOD cdecl = nil; // SSLv2
  {$EXTERNALSYM SSLv2_server_method}
  SSLv2_server_method : function: PSSL_METHOD cdecl = nil; // SSLv2
  {$EXTERNALSYM SSLv2_client_method}
  SSLv2_client_method : function: PSSL_METHOD cdecl = nil; // SSLv2
  {$EXTERNALSYM SSLv3_method}
  SSLv3_method : function: PSSL_METHOD cdecl = nil; // SSLv3
  {$EXTERNALSYM SSLv3_server_method}
  SSLv3_server_method : function: PSSL_METHOD cdecl = nil; // SSLv3
  {$EXTERNALSYM SSLv3_client_method}
  SSLv3_client_method : function: PSSL_METHOD cdecl = nil; // SSLv3
  {$EXTERNALSYM SSLv23_method}
  SSLv23_method : function: PSSL_METHOD cdecl = nil; // SSLv3 but can rollback to v2
  {$EXTERNALSYM SSLv23_server_method}
  SSLv23_server_method : function: PSSL_METHOD cdecl = nil; // SSLv3 but can rollback to v2
  {$EXTERNALSYM SSLv23_client_method}
  SSLv23_client_method : function: PSSL_METHOD cdecl = nil; // SSLv3 but can rollback to v2
  {$EXTERNALSYM TLSv1_method}
  TLSv1_method : function: PSSL_METHOD cdecl = nil; // TLSv1.0
  {$EXTERNALSYM TLSv1_server_method}
  TLSv1_server_method : function: PSSL_METHOD cdecl = nil; // TLSv1.0
  {$EXTERNALSYM TLSv1_client_method}
  TLSv1_client_method : function: PSSL_METHOD cdecl = nil; // TLSv1.0
  {$EXTERNALSYM TLSv1_1_method}
  TLSv1_1_method : function : PSSL_METHOD cdecl = nil; //TLS1.1
  {$EXTERNALSYM TLSv1_1_server_method}
  TLSv1_1_server_method : function : PSSL_METHOD cdecl = nil; //TLS1.1
  {$EXTERNALSYM TLSv1_1_client_method}
  TLSv1_1_client_method : function : PSSL_METHOD cdecl = nil; //TLS1.1
  {$EXTERNALSYM TLSv1_2_method}
  TLSv1_2_method : function : PSSL_METHOD cdecl = nil;		//* TLSv1.2 */
  {$EXTERNALSYM TLSv1_2_server_method}
  TLSv1_2_server_method : function : PSSL_METHOD cdecl = nil;	//* TLSv1.2 */
  {$EXTERNALSYM TLSv1_2_client_method}
  TLSv1_2_client_method : function : PSSL_METHOD cdecl = nil;	//* TLSv1.2 */

  {$EXTERNALSYM DTLSv1_method}
  DTLSv1_method : function: PSSL_METHOD cdecl = nil; // DTLSv1.0
  {$EXTERNALSYM DTLSv1_server_method}
  DTLSv1_server_method : function: PSSL_METHOD cdecl = nil; // DTLSv1.0
  {$EXTERNALSYM DTLSv1_client_method}
  DTLSv1_client_method : function: PSSL_METHOD cdecl = nil; // DTLSv1.0
  {$EXTERNALSYM SSL_shutdown}
  SSL_shutdown : function(s: PSSL): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_set_connect_state}
  SSL_set_connect_state : procedure(s: PSSL) cdecl = nil;
  {$EXTERNALSYM SSL_set_accept_state}
  SSL_set_accept_state : procedure(s: PSSL) cdecl = nil;
  {$EXTERNALSYM SSL_set_shutdown}
  SSL_set_shutdown : procedure(ssl: PSSL; mode: TIdC_INT) cdecl = nil;
  {$EXTERNALSYM SSL_CTX_load_verify_locations}
  SSL_CTX_load_verify_locations : function(ctx: PSSL_CTX; const CAfile: PIdAnsiChar; const CApath: PIdAnsiChar): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_get_session}
  SSL_get_session : function(const ssl: PSSL): PSSL_SESSION cdecl = nil;
  {$EXTERNALSYM SSLeay_add_ssl_algorithms}
  SSLeay_add_ssl_algorithms : function: TIdC_INT cdecl = nil;
  // SSL_set_app_data : function(s: PSSL; arg: Pointer): Integer cdecl = nil;
  // SSL_get_app_data : function(s: PSSL): Pointer cdecl = nil;
  {$EXTERNALSYM SSL_SESSION_get_id}
  SSL_SESSION_get_id : function(const s: PSSL_SESSION; length: PIdC_UINT): PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM SSL_copy_session_id}
  SSL_copy_session_id : procedure(sslTo: PSSL; const sslFrom: PSSL) cdecl = nil;
  {$EXTERNALSYM X509_NAME_oneline}
  X509_NAME_oneline : function(a: PX509_NAME; buf: PIdAnsiChar; size: TIdC_INT): PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM X509_NAME_cmp}
  X509_NAME_cmp : function(const a, b: PX509_NAME): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_NAME_hash}
  X509_NAME_hash : function(x: PX509_NAME): TIdC_ULONG cdecl = nil;
  {$EXTERNALSYM X509_set_issuer_name}
  X509_set_issuer_name : function(x: PX509; name: PX509_NAME): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_get_issuer_name}
  X509_get_issuer_name : function(a: PX509): PX509_NAME cdecl = nil;
  {$EXTERNALSYM X509_set_subject_name}
  X509_set_subject_name : function(x: PX509; name: PX509_NAME): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_get_subject_name}
  X509_get_subject_name : function(a: PX509): PX509_NAME cdecl = nil;
  {$EXTERNALSYM OBJ_obj2nid}
  OBJ_obj2nid  : function (const o: PASN1_OBJECT): TIdC_INT cdecl = nil;
  {$EXTERNALSYM OBJ_nid2obj}
  OBJ_nid2obj : function (n : TIdC_INT) : PASN1_OBJECT cdecl = nil;
  {$EXTERNALSYM OBJ_nid2ln}
  OBJ_nid2ln : function (n : TIdC_INT) : PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM OBJ_nid2sn}
   OBJ_nid2sn : function (n : TIdC_INT) : PIdAnsiChar cdecl = nil;
  {$EXTERNALSYM X509_digest}
  X509_digest : function(const data: PX509; const _type: PEVP_MD;
      md: PByte; var len: TIdC_UINT): TIdC_INT cdecl = nil;
  {$IFNDEF OPENSSL_NO_SHA512}
  {$EXTERNALSYM EVP_sha512}
  EVP_sha512 : function : PEVP_MD cdecl = nil;
  {$EXTERNALSYM EVP_sha384}
  EVP_sha384 : function : PEVP_MD cdecl = nil;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_SHA256}
  {$EXTERNALSYM EVP_sha256}
  EVP_sha256 : function : PEVP_MD cdecl = nil;
  {$EXTERNALSYM EVP_sha224}
  EVP_sha224 : function : PEVP_MD cdecl = nil;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_SHA}
  {$EXTERNALSYM EVP_sha}
  EVP_sha : function : PEVP_MD cdecl = nil;
  {$EXTERNALSYM EVP_sha1}
  EVP_sha1 : function: PEVP_MD cdecl = nil;
  {$EXTERNALSYM EVP_dss}
  EVP_dss : function : PEVP_MD cdecl = nil;
  {$EXTERNALSYM EVP_dss1}
  EVP_dss1 : function : PEVP_MD cdecl = nil;
  {$EXTERNALSYM EVP_ecdsa}
  EVP_ecdsa : function : PEVP_MD cdecl = nil;
  {$ENDIF}
  {$ifndef OPENSSL_NO_MDC2}
  {$EXTERNALSYM EVP_mdc2}
  EVP_mdc2 : function : PEVP_MD cdecl = nil;
  {$endif}
  {$IFNDEF OPENSSL_NO_MD5}
  {$EXTERNALSYM EVP_md5}
  EVP_md5 : function: PEVP_MD cdecl = nil;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MD4}
  {$EXTERNALSYM EVP_md4}
  EVP_md4 : function: PEVP_MD cdecl = nil;
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MD2}
  {$EXTERNALSYM EVP_md2}
  EVP_md2 : function: PEVP_MD cdecl = nil;
  {$ENDIF}
  {$ifndef OPENSSL_NO_RIPEMD}
  {$EXTERNALSYM EVP_ripemd160}
  EVP_ripemd160: function: PEVP_MD cdecl = nil;
  {$endif}
  {$ifndef OPENSSL_NO_WHIRLPOOL}
  {$EXTERNALSYM EVP_whirlpool}
  EVP_whirlpool: function: PEVP_MD cdecl = nil;
  {$endif}
  {$EXTERNALSYM EVP_md_null}
  EVP_md_null : function : PEVP_MD cdecl = nil;
  {$ifndef OPENSSL_NO_DES}
  {$EXTERNALSYM EVP_des_ecb}
  EVP_des_ecb : function : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_ede}
  EVP_des_ede : function : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_ede3}
  EVP_des_ede3 : function : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_ede_ecb}
  EVP_des_ede_ecb : function : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_ede3_ecb}
  EVP_des_ede3_ecb  : function : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_cfb64}
  EVP_des_cfb64: function : PEVP_CIPHER cdecl = nil;
//  # define EVP_des_cfb EVP_des_cfb64
  {$EXTERNALSYM EVP_des_cfb1}
  EVP_des_cfb1: function : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_cfb8}
  EVP_des_cfb8 : function : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_ede_cfb64}
  EVP_des_ede_cfb64 :function :  PEVP_CIPHER cdecl = nil;
//# define EVP_des_ede_cfb EVP_des_ede_cfb64
//#if 0
  {/$EXTERNALSYM EVP_des_ede_cfb1}
  //EVP_des_ede_cfb1  :function :  PEVP_CIPHER cdecl = nil;
  {/$EXTERNALSYM EVP_des_ede_cfb8}
  //EVP_des_ede_cfb8 : function : PEVP_CIPHER cdecl = nil;
//#endif
  {$EXTERNALSYM EVP_des_ede3_cfb64}
  EVP_des_ede3_cfb64  :function :  PEVP_CIPHER cdecl = nil;
//# define EVP_des_ede3_cfb EVP_des_ede3_cfb64
  {$EXTERNALSYM EVP_des_ede3_cfb1}
  EVP_des_ede3_cfb1 :function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_ede3_cfb8}
  EVP_des_ede3_cfb8 :function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_ofb}
  EVP_des_ofb :function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_ede_ofb}
  EVP_des_ede_ofb :function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_ede3_ofb}
  EVP_des_ede3_ofb :function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_cbc}
  EVP_des_cbc :function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_des_ede_cbc}
  EVP_des_ede_cbc :function :  PEVP_CIPHER cdecl = nil;
//  EVP_des_ede3_cbc :function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_desx_cbc}
  EVP_desx_cbc :function :  PEVP_CIPHER cdecl = nil;
//* This should now be supported through the dev_crypto ENGINE. But also, why are
// * rc4 and md5 declarations made here inside a "NO_DES" precompiler branch? */
//#if 0
    {$ifdef OPENSSL_OPENBSD_DEV_CRYPTO}
  {$EXTERNALSYM EVP_dev_crypto_des_ede3_cbc}
  EVP_dev_crypto_des_ede3_cbc : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_dev_crypto_rc4}
  EVP_dev_crypto_rc4 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_dev_crypto_md5}
  EVP_dev_crypto_md5 : function :  PEVP_MD cdecl = nil;
    {$endif}
//#endif
  {$endif}
  {$ifndef OPENSSL_NO_RC4}
  {$EXTERNALSYM EVP_rc4}
  EVP_rc4: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_rc4_40}
  EVP_rc4_40: function :  PEVP_CIPHER cdecl = nil;
    {$ifndef OPENSSL_NO_MD5}
  {$EXTERNALSYM EVP_rc4_hmac_md5}
  EVP_rc4_hmac_md5: function :  PEVP_CIPHER cdecl = nil;
    {$endif}
  {$endif}
  {$ifndef OPENSSL_NO_IDEA}
  {$EXTERNALSYM EVP_idea_ecb}
  EVP_idea_ecb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_idea_cfb64}
  EVP_idea_cfb64: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_idea_ofb}
  EVP_idea_ofb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_idea_cbc}
  EVP_idea_cbc: function :  PEVP_CIPHER cdecl = nil;
  {$endif}
  {$ifndef OPENSSL_NO_RC2}
  {$EXTERNALSYM EVP_rc2_ecb}
  EVP_rc2_ecb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_rc2_cbc}
  EVP_rc2_cbc: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_rc2_40_cbc}
  EVP_rc2_40_cbc: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_rc2_64_cbc}
  EVP_rc2_64_cbc: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_rc2_cfb64}
  EVP_rc2_cfb64: function :  PEVP_CIPHER cdecl = nil;
//# define EVP_rc2_cfb EVP_rc2_cfb64
  {$EXTERNALSYM EVP_rc2_ofb}
  EVP_rc2_ofb: function :  PEVP_CIPHER cdecl = nil;
  {$endif}
  {$ifndef OPENSSL_NO_BF}
  {$EXTERNALSYM EVP_bf_ecb}
  EVP_bf_ecb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_bf_cbc}
  EVP_bf_cbc: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_bf_cfb64}
  EVP_bf_cfb64: function :  PEVP_CIPHER cdecl = nil;
//# define EVP_bf_cfb EVP_bf_cfb64
  {$EXTERNALSYM EVP_bf_ofb}
  EVP_bf_ofb: function :  PEVP_CIPHER cdecl = nil;
  {$endif}
  {$ifndef OPENSSL_NO_CAST}
  {$EXTERNALSYM EVP_cast5_ecb}
  EVP_cast5_ecb : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_cast5_cbc}
  EVP_cast5_cbc : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_cast5_cfb64}
  EVP_cast5_cfb64: function :  PEVP_CIPHER cdecl = nil;
//# define EVP_cast5_cfb EVP_cast5_cfb64
  {$EXTERNALSYM EVP_cast5_ofb}
  EVP_cast5_ofb: function :  PEVP_CIPHER cdecl = nil;
  {$endif}
  {$ifndef OPENSSL_NO_RC5}
  {$EXTERNALSYM EVP_rc5_32_12_16_cb}
  EVP_rc5_32_12_16_cbc: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_rc5_32_12_16_ecb}
  EVP_rc5_32_12_16_ecb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_rc5_32_12_16_cfb64}
  EVP_rc5_32_12_16_cfb64: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_rc5_32_12_16_ofb\}
  EVP_rc5_32_12_16_ofb: function :  PEVP_CIPHER cdecl = nil;
  {$endif}
  {$ifndef OPENSSL_NO_AES}
  {$EXTERNALSYM EVP_aes_128_ecb}
  EVP_aes_128_ecb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_128_cbc}
  EVP_aes_128_cbc: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_128_cfb1}
  EVP_aes_128_cfb1: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_128_cfb8}
  EVP_aes_128_cfb8: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_128_cfb128}
  EVP_aes_128_cfb128: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_128_ofb}
  EVP_aes_128_ofb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_128_ctr}
  EVP_aes_128_ctr: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_128_gcm}
  EVP_aes_128_gcm: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_128_ccm}
  EVP_aes_128_ccm: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_128_xts}
  EVP_aes_128_xts: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_192_ecb}
  EVP_aes_192_ecb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_192_cbc}
  EVP_aes_192_cbc: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_192_cfb1}
  EVP_aes_192_cfb1: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_192_cfb8}
  EVP_aes_192_cfb8: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_192_cfb128}
  EVP_aes_192_cfb128: function :  PEVP_CIPHER cdecl = nil;
//# define EVP_aes_192_cfb EVP_aes_192_cfb128
  {$EXTERNALSYM EVP_aes_192_ofb}
  EVP_aes_192_ofb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_192_ctr}
  EVP_aes_192_ctr: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_192_gcm}
  EVP_aes_192_gcm: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_192_ccm}
  EVP_aes_192_ccm: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_ecb}
  EVP_aes_256_ecb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_cbc}
  EVP_aes_256_cbc: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_cfb1}
  EVP_aes_256_cfb1: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_cfb8}
  EVP_aes_256_cfb8: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_cfb128}
  EVP_aes_256_cfb128: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_ofb}
  EVP_aes_256_ofb: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_ctr}
  EVP_aes_256_ctr: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_gcm}
  EVP_aes_256_gcm: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_ccm}
  EVP_aes_256_ccm: function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_xts}
  EVP_aes_256_xts: function :  PEVP_CIPHER cdecl = nil;
    {$ifndef OPENSSL_NO_SHA}
      {$ifndef OPENSSL_NO_SHA1}
  {$EXTERNALSYM EVP_aes_128_cbc_hmac_sha1}
  EVP_aes_128_cbc_hmac_sha1 : function : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_aes_256_cbc_hmac_sha1}
  EVP_aes_256_cbc_hmac_sha1 : function : PEVP_CIPHER cdecl = nil;
      {$endif}
    {$endif}
  {$endif}
  {$ifndef OPENSSL_NO_CAMELLIA}
  {$EXTERNALSYM EVP_camellia_128_ecb}
  EVP_camellia_128_ecb : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_128_cbc}
  EVP_camellia_128_cbc : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_128_cfb1}
  EVP_camellia_128_cfb1 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_128_cfb8}
  EVP_camellia_128_cfb8 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_128_cfb128}
  EVP_camellia_128_cfb128 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_128_ofb}
  EVP_camellia_128_ofb : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_192_ecb}
  EVP_camellia_192_ecb : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_192_cbc}
  EVP_camellia_192_cbc : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_192_cfb1}
  EVP_camellia_192_cfb1 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_192_cfb8}
  EVP_camellia_192_cfb8 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_192_cfb128}
  EVP_camellia_192_cfb128 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_192_ofb}
  EVP_camellia_192_ofb : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_256_ecb}
  EVP_camellia_256_ecb : function : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_256_cbc}
  EVP_camellia_256_cbc : function : PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_256_cfb1}
  EVP_camellia_256_cfb1 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_256_cfb8}
  EVP_camellia_256_cfb8 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_256_cfb128}
  EVP_camellia_256_cfb128 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_camellia_256_ofb}
  EVP_camellia_256_ofb : function :  PEVP_CIPHER cdecl = nil;
  {$endif}

  {$ifndef OPENSSL_NO_SEED}
  {$EXTERNALSYM EVP_seed_ecb}
  EVP_seed_ecb : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_seed_cbc}
  EVP_seed_cbc : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_seed_cfb128}
  EVP_seed_cfb128 : function :  PEVP_CIPHER cdecl = nil;
  {$EXTERNALSYM EVP_seed_ofb}
  EVP_seed_ofb : function :  PEVP_CIPHER cdecl = nil;
  {$endif}
  {$EXTERNALSYM EVP_add_cipher}
  EVP_add_cipher : function (cipher : PEVP_CIPHER) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_add_digest}
  EVP_add_digest : function(digest : PEVP_MD) : TIdC_INT cdecl = nil;

  {$EXTERNALSYM EVP_CIPHER_do_all}
  EVP_CIPHER_do_all : procedure(fn : EVP_CIPHER_do_all_fn; arg : Pointer) cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_do_all_sorted}
  EVP_CIPHER_do_all_sorted : procedure(fn : EVP_CIPHER_do_all_fn; arg : Pointer) cdecl = nil;
  {$EXTERNALSYM EVP_MD_do_all}
  EVP_MD_do_all : procedure(fn : EVP_MD_do_all_fn; arg : Pointer) cdecl = nil;
  {$EXTERNALSYM EVP_MD_do_all_sorted}
  EVP_MD_do_all_sorted : procedure(fn : EVP_MD_do_all_fn; arg : Pointer) cdecl = nil;

  {$EXTERNALSYM EVP_PKEY_decrypt_old}
  EVP_PKEY_decrypt_old : function(dec_key : PIdAnsiChar;
			enc_key : PIdAnsiChar; enc_key_len : TIdC_INT;
			private_key : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_encrypt_old}
  EVP_PKEY_encrypt_old : function(enc_key : PIdAnsiChar;
			key : PIdAnsiChar; key_len : TIdC_INT;
			pub_key : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_type}
  EVP_PKEY_type : function(_type : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_id}
  EVP_PKEY_id : function(pkey : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_base_id}
  EVP_PKEY_base_id : function(pkey : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_bits}
  EVP_PKEY_bits : function(pkey : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_size}
  EVP_PKEY_size : function(pkey : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_set_type}
  EVP_PKEY_set_type : function(pkey : PEVP_PKEY;_type : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_set_type_str}
  EVP_PKEY_set_type_str : function(pkey: PEVP_PKEY; str : PIdAnsiChar; len : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_get0}
  EVP_PKEY_get0 : function(pkey : PEVP_PKEY) : Pointer cdecl = nil;

  {$ifndef OPENSSL_NO_RSA}
//struct rsa_st;
  {$EXTERNALSYM EVP_PKEY_set1_RSA}
  EVP_PKEY_set1_RSA: function(pkey : PEVP_PKEY;key : Prsa_st) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_get1_RSA}
  EVP_PKEY_get1_RSA: function(pkey: PEVP_PKEY) : Prsa_st cdecl = nil;
  {$endif}
  {$ifndef OPENSSL_NO_DSA}
//  struct dsa_st;
  {$EXTERNALSYM EVP_PKEY_set1_DSA}
  EVP_PKEY_set1_DSA: function(pkey : PEVP_PKEY; key : Pdsa_st) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_get1_DSA}
  EVP_PKEY_get1_DSA: function(pkey : PEVP_PKEY) : Pdsa_st cdecl = nil;
  {$endif}
  {$ifndef OPENSSL_NO_DH}
//  struct dh_st;
  {$EXTERNALSYM EVP_PKEY_set1_DH}
  EVP_PKEY_set1_DH: function(pkey : PEVP_PKEY; key : Pdh_st) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_get1_DH}
  EVP_PKEY_get1_DH: function(pkey : PEVP_PKEY) : Pdh_st cdecl = nil;
  {$endif}
  {$ifndef OPENSSL_NO_EC}
//  struct ec_key_st;
  {$EXTERNALSYM EVP_PKEY_set1_EC_KEY}
  EVP_PKEY_set1_EC_KEY : function(pkey : PEVP_PKEY; key : Pec_key_st) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_get1_EC_KEY}
  EVP_PKEY_get1_EC_KEY : function(pkey : PEVP_PKEY) : Pec_key_st cdecl = nil;
  {$endif}

  {$EXTERNALSYM d2i_PublicKey}
  d2i_PublicKey : function(_type : TIdC_INT; a :PPEVP_PKEY; pp : PPIdAnsiChar;
			length : TIdC_LONG) : PEVP_PKEY cdecl = nil;
  {$EXTERNALSYM i2d_PublicKey}
  i2d_PublicKey : function(a : PEVP_PKEY; pp : PPIdAnsiChar) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM d2i_AutoPrivateKey}
  d2i_AutoPrivateKey : function(a : PPEVP_PKEY; pp : PPIdAnsiChar;
	 length : TIdC_LONG) : PEVP_PKEY cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_copy_parameters}
  EVP_PKEY_copy_parameters : function(_to : PEVP_PKEY; from : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_missing_parameters}
  EVP_PKEY_missing_parameters : function(pkey : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_save_parameters}
  EVP_PKEY_save_parameters : function(pkey : PEVP_PKEY;mode : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_cmp_parameters}
  EVP_PKEY_cmp_parameters : function(a : PEVP_PKEY; b : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_cmp}
  EVP_PKEY_cmp : function(a : PEVP_PKEY; b : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM   EVP_PKEY_print_public}
  EVP_PKEY_print_public : function(_out : PBIO; pkey : PEVP_PKEY;
				indent : TIdC_INT; pctx : PASN1_PCTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_print_private}
  EVP_PKEY_print_private : function(_out : PBIO; pkey : PEVP_PKEY;
				indent : TIdC_INT; pctx : PASN1_PCTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_print_params}
  EVP_PKEY_print_params : function(_out : PBIO; pkey : PEVP_PKEY;
				indent : TIdC_INT;  pctx : PASN1_PCTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_get_default_digest_nid}
  EVP_PKEY_get_default_digest_nid : function(pkey : PEVP_PKEY; pnid : PIdC_INT) : TIdC_INT cdecl = nil;

//* calls methods */
  {$EXTERNALSYM EVP_CIPHER_param_to_asn1}
  EVP_CIPHER_param_to_asn1 : function(c : PEVP_CIPHER_CTX; _type : PASN1_TYPE) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_asn1_to_param}
  EVP_CIPHER_asn1_to_param : function(c : PEVP_CIPHER_CTX; _type : PASN1_TYPE) : TIdC_INT cdecl = nil;

//* These are used by EVP_CIPHER methods */
  {$EXTERNALSYM EVP_CIPHER_set_asn1_iv}
  EVP_CIPHER_set_asn1_iv : function(c : PEVP_CIPHER_CTX; _type : PASN1_TYPE) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_CIPHER_get_asn1_iv}
  EVP_CIPHER_get_asn1_iv : function(c : PEVP_CIPHER_CTX; _type : PASN1_TYPE) : TIdC_INT cdecl = nil;

//* PKCS5 password based encryption */
  {$EXTERNALSYM PKCS5_PBE_keyivgen}
  PKCS5_PBE_keyivgen : function(ctx : PEVP_CIPHER_CTX; pass : PIdAnsiChar; passlen : TIdC_INT;
			  param : PASN1_TYPE; cipher : PEVP_CIPHER; md : PEVP_MD;
			 en_de : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM PKCS5_PBKDF2_HMAC_SHA1}
  PKCS5_PBKDF2_HMAC_SHA1 : function(pass : PIdAnsiChar; passlen : TIdC_INT;
			   salt : PIdAnsiChar; saltlen : TIdC_INT; iter : TIdC_INT;
			   keylen : TIdC_INT; _out : PIdAnsiChar) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM PKCS5_PBKDF2_HMAC}
  PKCS5_PBKDF2_HMAC : function(pass : PIdAnsiChar; passlen : TIdC_INT;
			   salt : PIdAnsiChar; saltlen : TIdC_INT; iter : TIdC_INT;
			   digest : PEVP_MD;
		     keylen : TIdC_INT; _out : PIdAnsiChar) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM PKCS5_v2_PBE_keyivgen}
  PKCS5_v2_PBE_keyivgen : function(ctx : PEVP_CIPHER_CTX; pass : PIdAnsiChar; passlen : TIdC_INT;
		param : PASN1_TYPE; cipher : PEVP_CIPHER; md : PEVP_MD;
		en_de : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM PKCS5_PBE_add}
  PKCS5_PBE_add : procedure cdecl = nil;
  {$EXTERNALSYM EVP_PBE_CipherInit}
  EVP_PBE_CipherInit : function (pbe_obj : PASN1_OBJECT; pass : PIdAnsiChar; passlen : TIdC_INT;
	  param : PASN1_TYPE; ctx : PEVP_CIPHER_CTX; en_de : TIdC_INT) : TIdC_INT cdecl = nil;

  {$EXTERNALSYM  EVP_PBE_alg_add_type}

  EVP_PBE_alg_add_type : function(pbe_type : TIdC_INT; pbe_nid : TIdC_INT; cipher_nid : TIdC_INT; md_nid : TIdC_INT;
	  keygen : PEVP_PBE_KEYGEN) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM  EVP_PBE_alg_add}
  EVP_PBE_alg_add : function(nid : TIdC_INT; cipher : PEVP_CIPHER; md : PEVP_MD;
		keygen :PEVP_PBE_KEYGEN) : TIdC_INT cdecl = nil;
    {$EXTERNALSYM EVP_PBE_find}
  EVP_PBE_find : function(_type : TIdC_INT; pbe_nid : TIdC_INT;
			pcnid : PIdC_INT; pmnid : PIdC_INT; var pkeygen : PEVP_PBE_KEYGEN) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PBE_cleanup}
  EVP_PBE_cleanup : procedure cdecl = nil;

  {$EXTERNALSYM EVP_PKEY_asn1_get_count}
  EVP_PKEY_asn1_get_count : function : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_get0}
  EVP_PKEY_asn1_get0 : function(idx : TIdC_INT) : PEVP_PKEY_ASN1_METHOD cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_find}
  EVP_PKEY_asn1_find : function(pe :PPENGINE; _type : TIdC_INT) : PEVP_PKEY_ASN1_METHOD cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_find_str}
  EVP_PKEY_asn1_find_str : function(pe : PPENGINE;
	  str : PIdAnsiChar; len : TIdC_INT) : PEVP_PKEY_ASN1_METHOD cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_add0}
  EVP_PKEY_asn1_add0 : function(ameth : PEVP_PKEY_ASN1_METHOD) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_add_alias}
  EVP_PKEY_asn1_add_alias : function(_to : TIdC_INT; from : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_get0_info}
  EVP_PKEY_asn1_get0_info : function(ppkey_id : PIdC_int; pkey_base_id : PIdC_INT; ppkey_flags : PIdC_INT;
	  pinfo : PPIdAnsiChar; ppem_str : PPIdAnsiChar;
		ameth : PEVP_PKEY_ASN1_METHOD) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_get0_asn1}
  EVP_PKEY_get0_asn1 : function(pkey : PEVP_PKEY) : PEVP_PKEY_ASN1_METHOD cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_new}
  EVP_PKEY_asn1_new : function(id : TIdC_INT; flags : TIdC_INT;
	  pem_str : PIdAnsiChar; info : PIdAnsiChar) : PEVP_PKEY_ASN1_METHOD cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_copy}
  EVP_PKEY_asn1_copy : procedure(dst : PEVP_PKEY_ASN1_METHOD;
	  src : PEVP_PKEY_ASN1_METHOD) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_free}
  EVP_PKEY_asn1_free : procedure(ameth : PEVP_PKEY_ASN1_METHOD) cdecl = nil;

  {$EXTERNALSYM EVP_PKEY_asn1_set_public}
  EVP_PKEY_asn1_set_public : procedure(ameth : PEVP_PKEY_ASN1_METHOD;
		pub_decode : EVP_PKEY_asn1_set_public_pub_decode;
		pub_encode : EVP_PKEY_asn1_set_public_pub_encode;
    pub_cmp : EVP_PKEY_asn1_set_public_pub_cmp;
		pub_print : EVP_PKEY_asn1_set_public_pub_print;
		pkey_size : EVP_PKEY_asn1_set_public_pub_pkey_size;
		pkey_bits : EVP_PKEY_asn1_set_public_pkey_bits) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_set_private}
  EVP_PKEY_asn1_set_private : procedure(ameth : PEVP_PKEY_ASN1_METHOD;
		priv_decode : EVP_PKEY_asn1_set_private_priv_decode;
		priv_encode : EVP_PKEY_asn1_set_private_priv_encode;
		priv_print : EVP_PKEY_asn1_set_private_priv_print) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_set_param}
  EVP_PKEY_asn1_set_param : procedure(ameth : PEVP_PKEY_ASN1_METHOD;
		param_decode : EVP_PKEY_asn1_set_param_param_decode;
		param_encode : EVP_PKEY_asn1_set_param_param_encode;
		param_missing : EVP_PKEY_asn1_set_param_param_missing;
		param_copy : EVP_PKEY_asn1_set_param_param_copy;
		param_cmp : EVP_PKEY_asn1_set_param_param_cmp;
		param_print : EVP_PKEY_asn1_set_param_param_print) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_set_free}
  EVP_PKEY_asn1_set_free : procedure(ameth : PEVP_PKEY_ASN1_METHOD;
		pkey_free : EVP_PKEY_asn1_set_free_pkey_free) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_asn1_set_ctrl}
  EVP_PKEY_asn1_set_ctrl : procedure(ameth : PEVP_PKEY_ASN1_METHOD;
		pkey_ctrl : EVP_PKEY_asn1_set_ctr_pkey_ctrl) cdecl = nil;

  {$EXTERNALSYM EVP_PKEY_meth_find}
  EVP_PKEY_meth_find : function (_type : TIdC_INT) : PEVP_PKEY_METHOD cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_new}
  EVP_PKEY_meth_new : function(id : TIdC_INT; flags : TIdC_INT) : PEVP_PKEY_METHOD cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_get0_info}
  EVP_PKEY_meth_get0_info : procedure(ppkey_id : PIdC_INT; pflags : PIdC_INT;
	 meth : PEVP_PKEY_METHOD) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_copy}
  EVP_PKEY_meth_copy : procedure(dst : PEVP_PKEY_METHOD; src : PEVP_PKEY_METHOD) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_free}
  EVP_PKEY_meth_free : procedure(pmeth : PEVP_PKEY_METHOD) cdecl =nil;
  {$EXTERNALSYM EVP_PKEY_meth_add0}
  EVP_PKEY_meth_add0 : function(pmeth : PEVP_PKEY_METHOD) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_new}
  EVP_PKEY_CTX_new : function(pkey : PEVP_PKEY; e : PENGINE) : PEVP_PKEY_CTX cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_new_id}
  EVP_PKEY_CTX_new_id : function(id : TIdC_INT; e : PENGINE) : PEVP_PKEY_CTX cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_dup}
  EVP_PKEY_CTX_dup : function(ctx : PEVP_PKEY_CTX) : PEVP_PKEY_CTX cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_free}
  EVP_PKEY_CTX_free : procedure(ctx : PEVP_PKEY_CTX) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_ctrl}
  EVP_PKEY_CTX_ctrl : function(ctx : PEVP_PKEY_CTX; keytype : TIdC_INT; optype : TIdC_INT;
	  cmd : TIdC_INT; p1 : TIdC_INT; p2 : Pointer) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_ctrl_str}
  EVP_PKEY_CTX_ctrl_str : function(ctx : PEVP_PKEY_CTX; _type : PIdAnsiChar;
						value : PIdAnsiChar) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_get_operation}
  EVP_PKEY_CTX_get_operation : function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_set0_keygen_info}
  EVP_PKEY_CTX_set0_keygen_info : procedure(ctx : PEVP_PKEY_CTX; dat : PIdC_INT; datlen : TIdC_INT) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_new_mac_key}
  EVP_PKEY_new_mac_key : function(_type : TIdC_INT; e : PENGINE;
	   key : PIdAnsiChar; keylen : TIdC_INT) : PEVP_PKEY cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_set_data}
  EVP_PKEY_CTX_set_data : procedure(ctx : PEVP_PKEY_CTX; data : Pointer) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_get_data}
  EVP_PKEY_CTX_get_data : function(ctx : PEVP_PKEY_CTX) : Pointer cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_get0_pkey}
  EVP_PKEY_CTX_get0_pkey : function(ctx : PEVP_PKEY_CTX) : PEVP_PKEY cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_get0_peerkey}
  EVP_PKEY_CTX_get0_peerkey : function(ctx : PEVP_PKEY_CTX) : PEVP_PKEY cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_set_app_data}
  EVP_PKEY_CTX_set_app_data : procedure(ctx : PEVP_PKEY_CTX; data : Pointer) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_get_app_data}
  EVP_PKEY_CTX_get_app_data : function(ctx : PEVP_PKEY_CTX) : Pointer cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_sign_init}
  EVP_PKEY_sign_init : function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_sign}
  EVP_PKEY_sign : function(ctx : PEVP_PKEY_CTX;
	  sig : PIdAnsiChar; siglen : Psize_t;
	  tbs : PIdAnsiChar; tbslen : size_t) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_verify_init}
  EVP_PKEY_verify_init : function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_verify}
  EVP_PKEY_verify : function(ctx : PEVP_PKEY_CTX;
			sig : PIdAnsiChar; siglen : size_t;
			tbs : PIdAnsiChar; tbslen : size_t) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_verify_recover_init}
  EVP_PKEY_verify_recover_init : function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_verify_recover}
  EVP_PKEY_verify_recover : function(ctx : PEVP_PKEY_CTX;
			rout : PIdAnsiChar;  routlen : Psize_t;
			sig : PIdAnsiChar; siglen : size_t) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_encrypt_init}
  EVP_PKEY_encrypt_init : function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_encrypt}
  EVP_PKEY_encrypt : function(ctx : PEVP_PKEY_CTX;
    _out : PIdAnsiChar; outlen : Psize_t;
    _in : PIdAnsiChar; inlen : size_t) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_decrypt_init}
  EVP_PKEY_decrypt_init : function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_decrypt}
  EVP_PKEY_decrypt : function(ctx : PEVP_PKEY_CTX;
    _out : PIdAnsiChar; outlen : Psize_t;
    _in : PIdAnsiChar; inlen : size_t) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_derive_init}
  EVP_PKEY_derive_init : function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_derive_set_peer}
  EVP_PKEY_derive_set_peer : function(ctx : PEVP_PKEY_CTX; peer : PEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_derive}
  EVP_PKEY_derive : function(ctx : PEVP_PKEY_CTX; key : PIdAnsiChar; keylen : Psize_t) : TIdC_INT cdecl = nil;


  {$EXTERNALSYM EVP_PKEY_paramgen_init}
  EVP_PKEY_paramgen_init: function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl;
  {$EXTERNALSYM EVP_PKEY_paramgen}
  EVP_PKEY_paramgen : function(ctx : PEVP_PKEY_CTX; ppkey : PPEVP_PKEY) : TIdC_INT;
  {$EXTERNALSYM EVP_PKEY_keygen_init}
  EVP_PKEY_keygen_init : function(ctx : PEVP_PKEY_CTX) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_keygen}
  EVP_PKEY_keygen : function(ctx : PEVP_PKEY_CTX; ppkey : PPEVP_PKEY) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_set_cb}
  EVP_PKEY_CTX_set_cb : procedure(ctx : PEVP_PKEY_CTX; cb : EVP_PKEY_gen_cb) cdecl = nil;
   {$EXTERNALSYM EVP_PKEY_CTX_get_cb}
  EVP_PKEY_CTX_get_cb : function(ctx : PEVP_PKEY_CTX) : EVP_PKEY_gen_cb cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_CTX_get_keygen_info}
  EVP_PKEY_CTX_get_keygen_info : function(ctx : PEVP_PKEY_CTX; idx : TIdC_INT) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_init}
  EVP_PKEY_meth_set_init : procedure(pmeth : PEVP_PKEY_METHOD;
  init : EVP_PKEY_meth_set_init_init) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_copy}
  EVP_PKEY_meth_set_copy : procedure (pmeth : PEVP_PKEY_METHOD;
    copy : EVP_PKEY_meth_set_copy_copy) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_cleanup}
  EVP_PKEY_meth_set_cleanup : procedure(pmeth : PEVP_PKEY_METHOD;
   	cleanup : EVP_PKEY_meth_set_cleanup_cleanup) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_paramgen}
  EVP_PKEY_meth_set_paramgen : procedure(pmeth : PEVP_PKEY_METHOD;
    paramgen_init : EVP_PKEY_meth_set_paramgen_paramgen_init;
    paramgen : EVP_PKEY_meth_set_paramgen_paramgen);
  {$EXTERNALSYM EVP_PKEY_meth_set_keygen}
  EVP_PKEY_meth_set_keygen : procedure(pmeth : PEVP_PKEY_METHOD;
	  keygen_init : EVP_PKEY_meth_set_keygen_keygen_init;
  	keygen : EVP_PKEY_meth_set_keygen_keygen) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_sign}
  EVP_PKEY_meth_set_sign : procedure(pmeth : PEVP_PKEY_METHOD;
	  sign_init : EVP_PKEY_meth_set_sign_sign_init;
	  sign : EVP_PKEY_meth_set_sign_sign) cdecl = nil;
  {$EXTERNALSYM   EVP_PKEY_meth_set_verify}
  EVP_PKEY_meth_set_verify : procedure(pmeth : PEVP_PKEY_METHOD;
	  verify_init : EVP_PKEY_meth_set_verify_verify_init;
	  verify : EVP_PKEY_meth_set_verify_verify) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_verify_recover}
  EVP_PKEY_meth_set_verify_recover : procedure(pmeth : PEVP_PKEY_METHOD;
	 verify_recover_init : EVP_PKEY_meth_set_verify_recover_verify_recover_init;
	 verify_recover : EVP_PKEY_meth_set_verify_recover_verify_recover) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_signctx}
  EVP_PKEY_meth_set_signctx : procedure(pmeth : PEVP_PKEY_METHOD;
  	signctx_init : EVP_PKEY_meth_set_signctx_signctx_init;
    signctx : EVP_PKEY_meth_set_signctx_signctx) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_verifyctx}
  EVP_PKEY_meth_set_verifyctx : procedure(pmeth : PEVP_PKEY_METHOD;
	verifyctx_init : EVP_PKEY_meth_set_verifyctx_verifyctx_init;
	verifyctx : EVP_PKEY_meth_set_verifyctx_verifyctx) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_encrypt}
  EVP_PKEY_meth_set_encrypt : procedure(pmeth : PEVP_PKEY_METHOD;
	encrypt_init : EVP_PKEY_meth_set_encrypt_encrypt_init;
	encryptfn : EVP_PKEY_meth_set_encrypt_encryptfn) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_decrypt}
  EVP_PKEY_meth_set_decrypt : procedure(pmeth : PEVP_PKEY_METHOD;
	  decrypt_init : EVP_PKEY_meth_set_decrypt_decrypt_init;
	  decrypt : EVP_PKEY_meth_set_decrypt_decrypt);
  {$EXTERNALSYM EVP_PKEY_meth_set_derive}
  EVP_PKEY_meth_set_derive : procedure(pmeth : PEVP_PKEY_METHOD;
    derive_init : EVP_PKEY_meth_set_derive_derive_init;
    derive : EVP_PKEY_meth_set_derive_derive) cdecl = nil;
  {$EXTERNALSYM EVP_PKEY_meth_set_ctrl}
  EVP_PKEY_meth_set_ctrl : procedure(pmeth : PEVP_PKEY_METHOD;
    ctrl : EVP_PKEY_meth_set_ctrl_ctrl;
    ctrl_str : EVP_PKEY_meth_set_ctrlctrl_str) cdecl = nil;

  {$EXTERNALSYM d2i_PrivateKey_bio}
  d2i_PrivateKey_bio : function(bp : PBIO; a : PPEVP_PKEY) : PEVP_PKEY cdecl = nil;
  {$EXTERNALSYM X509_LOOKUP_ctrl}
  X509_LOOKUP_ctrl : function(ctx : PX509_LOOKUP; cmd : TIdC_INT; argc : PIdAnsiChar; arg1 : TIdC_LONG; ret : PPIdAnsiChar) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_STORE_add_cert}
  X509_STORE_add_cert : function (ctx : PX509_STORE; x : PX509) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_STORE_add_crl}
  X509_STORE_add_crl : function (ctx : PX509_STORE; x : PX509_CRL) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_STORE_CTX_get_ex_data}
  X509_STORE_CTX_get_ex_data : function(ctx: PX509_STORE_CTX; idx: TIdC_INT): Pointer cdecl = nil;
  {$EXTERNALSYM X509_STORE_CTX_get_error}
  X509_STORE_CTX_get_error : function(ctx: PX509_STORE_CTX): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_STORE_CTX_set_error}
  X509_STORE_CTX_set_error : procedure(ctx: PX509_STORE_CTX; s: TIdC_INT) cdecl = nil;
  {$EXTERNALSYM X509_STORE_CTX_get_error_depth}
  X509_STORE_CTX_get_error_depth : function(ctx: PX509_STORE_CTX): TIdC_INT cdecl = nil;
  {$EXTERNALSYM X509_STORE_CTX_get_current_cert}
  X509_STORE_CTX_get_current_cert : function(ctx: PX509_STORE_CTX): PX509 cdecl = nil;
  {$EXTERNALSYM _CRYPTO_num_locks}
  _CRYPTO_num_locks : function: TIdC_INT cdecl = nil; // return CRYPTO_NUM_LOCKS (shared libs!)
  {$EXTERNALSYM CRYPTO_set_locking_callback}
  CRYPTO_set_locking_callback : procedure(func: TIdSslLockingCallback) cdecl = nil;
  {$EXTERNALSYM CRYPTO_set_id_callback}
  CRYPTO_set_id_callback : procedure(func: TIdSslIdCallback) cdecl = nil;
  // 3DES functions
  {$EXTERNALSYM DES_set_odd_parity}
  DES_set_odd_parity: procedure(key: Pdes_cblock) cdecl = nil;
  {$EXTERNALSYM DES_set_key}
  DES_set_key: function(key: Pconst_DES_cblock; schedule: DES_key_schedule): TIdC_INT cdecl = nil;
  {$EXTERNALSYM DES_ecb_encrypt}
  DES_ecb_encrypt: procedure(input, output: Pconst_DES_cblock; ks: DES_key_schedule; enc: TIdC_INT) cdecl = nil;
  //old DES functions
  {$EXTERNALSYM Id_ossl_old_des_set_odd_parity}
  Id_ossl_old_des_set_odd_parity : procedure (key : p_ossl_old_des_cblock) cdecl = nil;
  {$EXTERNALSYM Id_ossl_old_des_set_key}
  Id_ossl_old_des_set_key : function (key : P_ossl_old_des_cblock; schedule : _ossl_old_des_key_schedule) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM Id_ossl_old_des_ecb_encrypt}
  Id_ossl_old_des_ecb_encrypt : procedure ( input : p_ossl_old_des_cblock; output : p_ossl_old_des_cblock; ks : p_ossl_old_des_key_schedule; enc : TIdC_int) cdecl = nil;
  //More SSL functions
  {$EXTERNALSYM SSL_set_ex_data}
  SSL_set_ex_data: function(ssl: PSSL; idx: TIdC_INT; data: Pointer): TIdC_INT cdecl = nil;
  {$EXTERNALSYM SSL_get_ex_data}
  SSL_get_ex_data: function(ssl: PSSL; idx: TIdC_INT): Pointer cdecl = nil;
  {$EXTERNALSYM PKCS12_create}
  PKCS12_create: function(pass, name: PIdAnsiChar; pkey: PEVP_PKEY; cert : PX509;
    ca: PSTACK_OF_X509; nid_key, nid_cert, iter, mac_iter, keytype : TIdC_INT) : PPKCS12 cdecl = nil;
  {$EXTERNALSYM i2d_PKCS12_bio}
  i2d_PKCS12_bio: function(b: PBIO; p12: PPKCS12) : TIdC_INT cdecl = nil;
  {$EXTERNALSYM PKCS12_free}
  PKCS12_free: procedure(p12: PPKCS12) cdecl = nil;
  {$EXTERNALSYM SSL_load_client_CA_file}
  SSL_load_client_CA_file: function(const _file: PIdAnsiChar): PSTACK_OF_X509_NAME cdecl = nil;
  {$EXTERNALSYM SSL_CTX_set_client_CA_list}
  SSL_CTX_set_client_CA_list: procedure(ctx: PSSL_CTX; list: PSTACK_OF_X509_NAME) cdecl = nil;
  {$EXTERNALSYM SSL_CTX_set_default_verify_paths}
  SSL_CTX_set_default_verify_paths: function(ctx: PSSL_CTX): TIdC_INT cdecl = nil;
 {$EXTERNALSYM SSL_CTX_set_session_id_context}
  SSL_CTX_set_session_id_context: function(ctx: PSSL_CTX; const sid_ctx: PByte; sid_ctx_len: TIdC_UINT): TIdC_INT cdecl = nil;
 {$EXTERNALSYM SSL_CIPHER_description}
  SSL_CIPHER_description: function(_para1: PSSL_CIPHER; buf: PIdAnsiChar; size: TIdC_INT): PIdAnsiChar cdecl = nil;
 {$EXTERNALSYM SSL_get_current_cipher}
  SSL_get_current_cipher: function(const s: PSSL): PSSL_CIPHER cdecl = nil;
 {$EXTERNALSYM SSL_CIPHER_get_name}
  SSL_CIPHER_get_name: function(const c: PSSL_CIPHER): PIdAnsiChar cdecl = nil;
 {$EXTERNALSYM SSL_CIPHER_get_version}
  SSL_CIPHER_get_version: function(const c: PSSL_CIPHER): PIdAnsiChar cdecl = nil;
 {$EXTERNALSYM SSL_CIPHER_get_bits}
  SSL_CIPHER_get_bits: function(const c: PSSL_CIPHER; var alg_bits: TIdC_INT): TIdC_INT cdecl = nil;
  //experimental
 {$EXTERNALSYM ERR_error_string_n}
  ERR_error_string_n: procedure(e: TIdC_ULONG; buf: PIdAnsiChar; len : size_t) cdecl = nil;
 {$EXTERNALSYM ERR_put_error}
  ERR_put_error : procedure (lib, func, reason : TIdC_INT; _file : PIdAnsiChar; line : TIdC_INT) cdecl = nil;
 {$EXTERNALSYM ERR_get_error}
  ERR_get_error : function: TIdC_ULONG cdecl = nil;
 {$EXTERNALSYM ERR_peek_error}
  ERR_peek_error : function: TIdC_ULONG cdecl = nil;
 {$EXTERNALSYM ERR_peek_last_error}
  ERR_peek_last_error : function : TIdC_ULONG cdecl = nil;
 {$EXTERNALSYM ERR_clear_error}
  ERR_clear_error : procedure cdecl = nil;
 {$EXTERNALSYM ERR_error_string}
  ERR_error_string : function (e: TIdC_ULONG; buf: PIdAnsiChar): PIdAnsiChar cdecl = nil;
 {$EXTERNALSYM ERR_lib_error_string}
  ERR_lib_error_string : function(e : TIdC_ULONG): PIdAnsiChar cdecl = nil;
 {$EXTERNALSYM ERR_func_error_string}
  ERR_func_error_string : function(e : TIdC_ULONG): PIdAnsiChar cdecl = nil;
 {$EXTERNALSYM ERR_reason_error_string}
  ERR_reason_error_string : function(e : TIdC_ULONG): PIdAnsiChar cdecl = nil;
 {$EXTERNALSYM ERR_load_ERR_strings}
  ERR_load_ERR_strings : procedure cdecl = nil;
 {$EXTERNALSYM ERR_load_crypto_strings}
  ERR_load_crypto_strings : procedure cdecl = nil;
 {$EXTERNALSYM ERR_free_strings}
  ERR_free_strings : procedure cdecl = nil;
 {$EXTERNALSYM ERR_remove_thread_state}
  ERR_remove_thread_state : procedure(const tId : PCRYPTO_THREADID) cdecl = nil;

 {$EXTERNALSYM ERR_remove_state}
  ERR_remove_state : procedure(pid: TIdC_ULONG) cdecl = nil;
 {$EXTERNALSYM CRYPTO_cleanup_all_ex_data}
  CRYPTO_cleanup_all_ex_data : procedure cdecl = nil;
 {$EXTERNALSYM SSL_COMP_get_compression_methods}
  SSL_COMP_get_compression_methods : function: PSTACK_OF_SSL_COMP cdecl = nil;
 {$EXTERNALSYM SSL_COMP_free_compression_methods}
  SSL_COMP_free_compression_methods : procedure; cdecl = nil;
 {$EXTERNALSYM sk_pop_free}
  sk_pop_free : procedure(st: PSTACK; func: Tsk_pop_free_func) cdecl = nil;
 {$EXTERNALSYM sk_dup}
  sk_dup : function (st : PSTACK) : PSTACK cdecl = nil;
  {$EXTERNALSYM sk_find}
  sk_find : function (st : PSTACK; Data : PIdAnsiChar) : TIdC_INT cdecl = nil;
{$IFDEF OPENSSL_FIPS}
{Note that I'm doing things this way so that we can have wrapper functions that hide
any IFDEF's and cases where the FIPS functions aren't in the .DLL}
 {$EXTERNALSYM _FIPS_mode_set}
  _FIPS_mode_set : function(onoff : TIdC_INT) : TIdC_INT cdecl = nil;
 {$EXTERNALSYM _FIPS_mode}
  _FIPS_mode : function () : TIdC_INT cdecl = nil;
{$ENDIF}

{$IFNDEF OPENSSL_NO_HMAC}
{
NOTE:

There is breakage between OpenSSL 0.9.x and OpenSSL 1.0x.  Some HMAC functions
were changed to return a result code.  MOst of this is ugly but necessary to
work around the issues involved.  Basically, the result of the C functions is
changed from "void" to "int" so that they can return failure.
}
//void HMAC_CTX_init(HMAC_CTX *ctx);
 {$EXTERNALSYM HMAC_CTX_init}
  HMAC_CTX_init : procedure(ctx : PHMAC_CTX) cdecl = nil;

//void HMAC_Init_ex(HMAC_CTX *ctx, const void *key, int len,
//		  const EVP_MD *md, ENGINE *impl);
 {$EXTERNALSYM _HMAC_Init_ex}
  _HMAC_Init_ex : procedure(ctx : PHMAC_CTX; key : Pointer; len : TIdC_INT;
    md : PEVP_MD; impl : PENGINE) cdecl = nil;
//OpenSSL 1.0
//int HMAC_Init_ex(HMAC_CTX *ctx, const void *key, int len,
//		  const EVP_MD *md, ENGINE *impl);
 {$EXTERNALSYM _1_0_HMAC_Init_ex}
  _1_0_HMAC_Init_ex : function(ctx : PHMAC_CTX; key : Pointer; len : TIdC_INT;
    md : PEVP_MD; impl : PENGINE) : TIdC_INT cdecl = nil;
//void HMAC_Update(HMAC_CTX *ctx, const unsigned char *data, size_t len);
 {$EXTERNALSYM _HMAC_Update}
  _HMAC_Update : procedure(ctx : PHMAC_CTX; data : PIdAnsiChar; len : size_t) cdecl = nil;
  //OpenSSL 1.0
 {$EXTERNALSYM _1_0_HMAC_Update}
//int HMAC_Update(HMAC_CTX *ctx, const unsigned char *data, size_t len);
  _1_0_HMAC_Update : function(ctx : PHMAC_CTX; data : PIdAnsiChar; len : size_t) : TIdC_INT cdecl = nil;
  //void HMAC_Final(HMAC_CTX *ctx, unsigned char *md, unsigned int *len);
 {$EXTERNALSYM _HMAC_Final}
  _HMAC_Final : procedure(ctx : PHMAC_CTX; md : PIdAnsiChar; len : PIdC_UINT) cdecl = nil;
//OpenSSL 1.0
 {$EXTERNALSYM _1_0_HMAC_Final}
//   int HMAC_Final(HMAC_CTX *ctx, unsigned char *md, unsigned int *len);
  _1_0_HMAC_Final : function(ctx : PHMAC_CTX; md : PIdAnsiChar; len : PIdC_UINT) : TIdC_INT cdecl = nil;
//void HMAC_CTX_cleanup(HMAC_CTX *ctx);
 {$EXTERNALSYM HMAC_CTX_cleanup}
  HMAC_CTX_cleanup : procedure (ctx : PHMAC_CTX) cdecl = nil;

 {$EXTERNALSYM HMAC_Init_ex}
procedure HMAC_Init_ex(ctx : PHMAC_CTX; key : Pointer; len : TIdC_INT;
    md : PEVP_MD; impl : PENGINE);
 {$EXTERNALSYM HMAC_Update}
procedure HMAC_Update(ctx : PHMAC_CTX; data : PIdAnsiChar; len : size_t);
 {$EXTERNALSYM HMAC_Final}
procedure HMAC_Final(ctx : PHMAC_CTX; md : PIdAnsiChar; len : PIdC_UINT);
{$ENDIF}

{begin stack fancy stuff}
{
For the sk functions having a type, you have to typecase one procedural pointer
as another procedural pointer.   In the headers, these are defined in
safestack.h.
}
type
 {$EXTERNALSYM Tsk_X509_NAME_new}
  Tsk_X509_NAME_new = function(cmp : Tsk_new_cmp) : PSTACK_OF_X509_NAME cdecl;
 {$EXTERNALSYM Tsk_X509_NAME_new_null}
  Tsk_X509_NAME_new_null = function : PSTACK_OF_X509_NAME cdecl;
 {$EXTERNALSYM Tsk_X509_NAME_free}
  Tsk_X509_NAME_free = procedure(st : PSTACK_OF_X509_NAME) cdecl;
 {$EXTERNALSYM Tsk_X509_NAME_num}
  Tsk_X509_NAME_num = function (const sk : PSTACK_OF_X509_NAME) : TIdC_INT cdecl;
 {$EXTERNALSYM Tsk_X509_NAME_value}
  Tsk_X509_NAME_value = function (const sk : PSTACK_OF_X509_NAME; i : TIdC_INT) : PX509_NAME cdecl;
 {$EXTERNALSYM Tsk_X509_NAME_push}
  Tsk_X509_NAME_push = function (sk : PSTACK_OF_X509_NAME; st : PX509_NAME) : TIdC_INT cdecl;
 {$EXTERNALSYM Tsk_X509_NAME_dup}
  Tsk_X509_NAME_dup = function (sk : PSTACK_OF_X509_NAME) : PSTACK_OF_X509_NAME cdecl;
 {$EXTERNALSYM Tsk_X509_NAME_find}
  Tsk_X509_NAME_find = function (sk : PSTACK_OF_X509_NAME; val : PX509_NAME) : TIdC_INT cdecl;
 {$EXTERNALSYM Tsk_X509_NAME_pop_free}
  Tsk_X509_NAME_pop_free = procedure (sk : PSTACK_OF_X509_NAME; func: Tsk_pop_free_func) cdecl;

 {$EXTERNALSYM Tsk_X509_INFO_num}
  Tsk_X509_INFO_num = function (const sk : PSTACK_OF_X509_INFO) : TIdC_INT cdecl;
 {$EXTERNALSYM Tsk_X509_INFO_value}
  Tsk_X509_INFO_value = function (const sk : PSTACK_OF_X509_INFO; i : TIdC_INT) : PX509_INFO cdecl;
 {$EXTERNALSYM Tsk_X509_INFO_push}
  Tsk_X509_INFO_push = function (sk : PSTACK_OF_X509_INFO; st : PX509_INFO) : TIdC_INT cdecl;
 {$EXTERNALSYM Tsk_X509_INFO_dup}
  Tsk_X509_INFO_dup = function (sk : PSTACK_OF_X509_INFO) : PSTACK_OF_X509_INFO cdecl;
 {$EXTERNALSYM Tsk_X509_INFO_find}
  Tsk_X509_INFO_find = function (sk : PSTACK_OF_X509_INFO; val : PX509_INFO) : TIdC_INT cdecl;
 {$EXTERNALSYM Tsk_X509_INFO_pop_free}
  Tsk_X509_INFO_pop_free = procedure (sk : PSTACK_OF_X509_INFO; func: Tsk_pop_free_func) cdecl;

var
 {$EXTERNALSYM sk_X509_NAME_new}
  sk_X509_NAME_new: Tsk_X509_NAME_new absolute sk_new;
  {$EXTERNALSYM sk_X509_NAME_new_null}
  sk_X509_NAME_new_null : Tsk_X509_NAME_new_null absolute sk_new_null;
 {$EXTERNALSYM sk_X509_NAME_free}
  sk_X509_NAME_free : Tsk_X509_NAME_free absolute sk_free;
 {$EXTERNALSYM sk_X509_NAME_num}
  sk_X509_NAME_num : Tsk_X509_NAME_num absolute sk_num;
 {$EXTERNALSYM sk_X509_NAME_value}
  sk_X509_NAME_value : Tsk_X509_NAME_value absolute sk_value;
 {$EXTERNALSYM sk_X509_NAME_push}
  sk_X509_NAME_push : Tsk_X509_NAME_push absolute sk_push;
 {$EXTERNALSYM sk_X509_NAME_dup}
  sk_X509_NAME_dup : Tsk_X509_NAME_dup absolute sk_dup;
 {$EXTERNALSYM sk_X509_NAME_find}
  sk_X509_NAME_find : Tsk_X509_NAME_find absolute sk_find;
 {$EXTERNALSYM sk_X509_NAME_pop_free}
  sk_X509_NAME_pop_free :  Tsk_X509_NAME_pop_free absolute sk_pop_free;
 {$EXTERNALSYM sk_X509_INFO_num}
  sk_X509_INFO_num : Tsk_X509_INFO_num absolute sk_num;
 {$EXTERNALSYM sk_X509_INFO_value}
  sk_X509_INFO_value : Tsk_X509_INFO_value absolute sk_value;
 {$EXTERNALSYM sk_X509_INFO_push}
  sk_X509_INFO_push : Tsk_X509_INFO_push absolute sk_push;
 {$EXTERNALSYM sk_X509_INFO_dup}
  sk_X509_INFO_dup : Tsk_X509_INFO_dup absolute sk_dup;
 {$EXTERNALSYM sk_X509_INFO_find}
  sk_X509_INFO_find : Tsk_X509_INFO_find absolute sk_find;
 {$EXTERNALSYM sk_X509_INFO_pop_free}
  sk_X509_INFO_pop_free : Tsk_X509_INFO_pop_free absolute sk_pop_free;
{end}

 {$EXTERNALSYM FIPS_mode_set}
function FIPS_mode_set(onoff : TIdC_INT) : TIdC_INT;  {$IFDEF INLINE}inline;{$ENDIF}
 {$EXTERNALSYM FIPS_mode}
function FIPS_mode() : TIdC_INT;  {$IFDEF INLINE}inline;{$ENDIF}


{begin other stuff}
 {$EXTERNALSYM UTC_Time_Decode}
function UTC_Time_Decode(UCTtime : PASN1_UTCTIME; var year, month, day, hour, min, sec: Word;
  var tz_hour, tz_min: Integer): Integer;
 {$EXTERNALSYM SSL_set_app_data}
function SSL_set_app_data(s: PSSL; arg: Pointer): TIdC_INT;
 {$EXTERNALSYM SSL_get_app_data}
function SSL_get_app_data(s: PSSL): Pointer;
//
function Load: Boolean;
procedure Unload;
{$IFNDEF STATICLOAD_OPENSSL}
function WhichFailedToLoad: String;
function GetSSLLibHandle : TIdLibHandle;
function GetCryptLibHandle : TIdLibHandle;
procedure IdOpenSSLSetLibPath(const APath: String);
  {$IFDEF UNIX}
procedure IdOpenSSLSetCanLoadSymLinks(ACanLoad: Boolean);
procedure IdOpenSSLSetLoadSymLinksFirst(ALoadFirst: Boolean);
  {$ENDIF}
{$ENDIF}
//
procedure InitializeRandom;
procedure CleanupRandom;

 {$EXTERNALSYM M_ASN1_STRING_length}
function M_ASN1_STRING_length(x : PASN1_STRING): TIdC_INT;
 {$EXTERNALSYM M_ASN1_STRING_length_set}
procedure M_ASN1_STRING_length_set(x : PASN1_STRING; n : TIdC_INT);
 {$EXTERNALSYM M_ASN1_STRING_type}
function M_ASN1_STRING_type(x : PASN1_STRING) : TIdC_INT;
 {$EXTERNALSYM M_ASN1_STRING_data}
function M_ASN1_STRING_data(x : PASN1_STRING) : PIdAnsiChar;
 {$EXTERNALSYM X509_NAME_dup}
function X509_NAME_dup(xn : PX509_NAME) : PX509_NAME;
 {$EXTERNALSYM X509_STORE_CTX_get_app_data}
function X509_STORE_CTX_get_app_data(ctx: PX509_STORE_CTX):Pointer;
 {$EXTERNALSYM X509_get_version}
function X509_get_version(x : PX509): TIdC_LONG;
 {$EXTERNALSYM X509_get_signature_type}
function X509_get_signature_type(x : PX509) : TIdC_INT;
 {$EXTERNALSYM X509_REQ_get_subject_name}
function X509_REQ_get_subject_name(x:PX509_REQ):PX509_NAME;
 {$EXTERNALSYM X509_get_notBefore}
function X509_get_notBefore(x509: PX509):PASN1_TIME;
 {$EXTERNALSYM X509_get_notAfter}
function X509_get_notAfter(x509: PX509):PASN1_TIME;
 {$EXTERNALSYM X509_REQ_get_version}
function X509_REQ_get_version(x : PX509_REQ): TIdC_LONG;
 {$EXTERNALSYM X509_CRL_get_version}
function X509_CRL_get_version(x : PX509_CRL) : TIdC_LONG;
 {$EXTERNALSYM X509_CRL_get_lastUpdate}
function X509_CRL_get_lastUpdate(x : PX509_CRL) : PASN1_TIME;
 {$EXTERNALSYM X509_CRL_get_nextUpdate}
function X509_CRL_get_nextUpdate(x : PX509_CRL) : PASN1_TIME;
 {$EXTERNALSYM X509_CRL_get_issuer}
function X509_CRL_get_issuer(x : PX509_CRL) : PX509_NAME;
 {$EXTERNALSYM X509_CRL_get_REVOKED}
function X509_CRL_get_REVOKED(x : PX509_CRL) : PSTACK_OF_X509_REVOKED;
 {$EXTERNALSYM SSL_CTX_set_info_callback}
procedure SSL_CTX_set_info_callback(ctx: PSSL_CTX; cb: PSSL_CTX_info_callback);
 {$EXTERNALSYM SSL_CTX_set_options}
function SSL_CTX_set_options(ctx: PSSL_CTX; op: TIdC_LONG):TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_clear_options}
function SSL_CTX_clear_options(ctx : PSSL_CTX; op : TIdC_LONG):TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_get_options}
function SSL_CTX_get_options(ctx: PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_options}
function SSL_set_options(ssl: PSSL; op : TIdC_LONG): TIdC_LONG;
 {$EXTERNALSYM SSL_clear_mode}
function SSL_clear_mode(ssl : PSSL; op : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM SSL_get_options}
function SSL_get_options(ssl : PSSL): TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_mode}
function SSL_CTX_set_mode(ctx : PSSL_CTX; op : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_clear_mode}
function SSL_CTX_clear_mode(ctx : PSSL_CTX; op : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_get_mode}
function SSL_CTX_get_mode(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_mtu}
function SSL_set_mtu(ssl : PSSL; mtu : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM SSL_get_secure_renegotiation_support}
function SSL_get_secure_renegotiation_support(ssl : PSSL) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_number}
function SSL_CTX_sess_number(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_connect}
function SSL_CTX_sess_connect(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_connect_good}
function SSL_CTX_sess_connect_good(ctx : PSSL_CTX): TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_connect_renegotiate}
function SSL_CTX_sess_connect_renegotiate(ctx : PSSL_CTX): TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_accept}
function SSL_CTX_sess_accept(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_accept_renegotiate}
function SSL_CTX_sess_accept_renegotiate(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_accept_good}
function SSL_CTX_sess_accept_good(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_hits}
function SSL_CTX_sess_hits(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_cb_hits}
function SSL_CTX_sess_cb_hits(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_misses}
function SSL_CTX_sess_misses(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_timeouts}
function SSL_CTX_sess_timeouts(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_cache_full}
function SSL_CTX_sess_cache_full(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_set_cache_size}
function SSL_CTX_sess_set_cache_size(ctx : PSSL_CTX; t : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_sess_get_cache_size}
function SSL_CTX_sess_get_cache_size(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_session_cache_mode}
function SSL_CTX_set_session_cache_mode(ctx : PSSL_CTX; m : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_get_session_cache_mode}
function SSL_CTX_get_session_cache_mode(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_get_read_ahead}
function SSL_CTX_get_read_ahead(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_read_ahead}
function SSL_CTX_set_read_ahead(ctx : PSSL_CTX; m : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_get_max_cert_list}
function SSL_CTX_get_max_cert_list(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_max_cert_list}
function SSL_CTX_set_max_cert_list(ctx : PSSL_CTX; m : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM SSL_get_max_cert_list}
function SSL_get_max_cert_list(ssl : PSSL) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_max_cert_list}
function SSL_set_max_cert_list(ssl : PSSL; m : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM DTLSv1_get_timeout}
function DTLSv1_get_timeout(ssl : PSSL; var arg : timeval) : TIdC_LONG;
 {$EXTERNALSYM DTLSv1_handle_timeout}
function DTLSv1_handle_timeout(ssl : PSSL) : TIdC_LONG;
 {$EXTERNALSYM DTLSv1_listen}
function DTLSv1_listen(ssl : PSSL; var peer : sockaddr) : TIdC_LONG;
 {$EXTERNALSYM SSL_session_reused}
function SSL_session_reused(ssl : PSSL) : TIdC_LONG;
 {$EXTERNALSYM SSL_num_renegotiations}
function SSL_num_renegotiations(ssl : PSSL) : TIdC_LONG;
 {$EXTERNALSYM SSL_clear_num_renegotiations}
function SSL_clear_num_renegotiations(ssl : PSSL) : TIdC_LONG;
 {$EXTERNALSYM SSL_total_renegotiations}
function SSL_total_renegotiations(ssl : PSSL) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_need_tmp_RSA}
function SSL_CTX_need_tmp_RSA(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_tmp_rsa}
function SSL_CTX_set_tmp_rsa(ctx  : PSSL_CTX; rsa : PRSA) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_tmp_dh}
function SSL_CTX_set_tmp_dh(ctx : PSSL_CTX; dh : PDH) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_tmp_ecdh}
function SSL_CTX_set_tmp_ecdh(ctx : PSSL_CTX; ecdh : PEC_KEY) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_ecdh_auto}
function SSL_CTX_set_ecdh_auto(ctx : PSSL_CTX; m : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM SSL_need_tmp_RSA}
function SSL_need_tmp_RSA(ssl : PSSL) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_tmp_rsa}
procedure SSL_set_tmp_rsa(ssl : PSSL; rsa : PRSA);
 {$EXTERNALSYM SSL_set_tmp_dh}
function SSL_set_tmp_dh(ssl : PSSL;dh : PDH) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_tmp_ecdh}
function SSL_set_tmp_ecdh(ssl : PSSL; ecdh : PEC_KEY) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_add0_chain_cert}  //OpenSSL 1.0.2
function SSL_CTX_add0_chain_cert(ctx : PSSL_CTX; x509 : PX509) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_add1_chain_cert}  //OpenSSL 1.0.2
function SSL_CTX_add1_chain_cert(ctx : PSSL_CTX; x509 : PX509) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_add_extra_chain_cert}
function SSL_CTX_add_extra_chain_cert(ctx : PSSL_CTX; x509 : PX509) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_get_extra_chain_certs}
function SSL_CTX_get_extra_chain_certs(ctx : PSSL_CTX; var px509 : px509) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_get_extra_chain_certs_only}
function SSL_CTX_get_extra_chain_certs_only(ctx: PSSL_CTX;var PX509 :PX509) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_clear_extra_chain_certs}
function SSL_CTX_clear_extra_chain_certs(ctx : PSSL_CTX) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set0_chain} //OpenSSL 1.0.2
function SSL_CTX_set0_chain(ctx:PSSL_CTX; sk : PSTACK_OF_X509) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set1_chain}  //OpenSSL 1.0.2
function SSL_CTX_set1_chain(ctx:PSSL_CTX; sk : PSTACK_OF_X509) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_get0_chain_certs} //OpenSSL 1.0.2
function SSL_CTX_get0_chain_certs(ctx :PSSL_CTX; var px509 :PX509) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_clear_chain_certs} //OpenSSL 1.0.2
function SSL_CTX_clear_chain_certs(ctx :PSSL_CTX) : TIdC_LONG;

{$IFNDEF OPENSSL_NO_TLSEXT}
 {$EXTERNALSYM SSL_set_tlsext_host_name}
function SSL_set_tlsext_host_name(s : PSSL; name : string) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_tlsext_debug_callback}
function SSL_set_tlsext_debug_callback(ssl : PSSL; cb : SSL_callback_ctrl_fp) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_tlsext_debug_arg}
function SSL_set_tlsext_debug_arg(ssl : PSSL; arg : Pointer) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_tlsext_status_type}
function SSL_set_tlsext_status_type(ssl : PSSL; _type : TIdC_LONG):TIdC_LONG;
 {$EXTERNALSYM SSL_get_tlsext_status_exts}
function SSL_get_tlsext_status_exts(ssl : PSSL; arg : Pointer): TIdC_LONG;
 {$EXTERNALSYM SSL_set_tlsext_status_exts}
function SSL_set_tlsext_status_exts(ssl : PSSL; arg : Pointer):TIdC_LONG;
 {$EXTERNALSYM SSL_get_tlsext_status_ids}
function SSL_get_tlsext_status_ids(ssl : PSSL; arg : Pointer) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_tlsext_status_ids}
function SSL_set_tlsext_status_ids(ssl : PSSL; arg : Pointer) : TIdC_LONG;
 {$EXTERNALSYM SSL_get_tlsext_status_ocsp_resp}
function SSL_get_tlsext_status_ocsp_resp(ssl : PSSL; arg : Pointer) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_tlsext_status_ocsp_resp}
function SSL_set_tlsext_status_ocsp_resp(ssl : PSSL; arg : Pointer; arglen : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_tlsext_servername_callback}
function SSL_CTX_set_tlsext_servername_callback(ctx : PSSL_CTX; cb :SSL_callback_ctrl_fp):TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_get_tlsext_ticket_keys}
function SSL_CTX_get_tlsext_ticket_keys(ctx : PSSL_CTX; keys : PIdAnsiChar; keylen : TIdC_LONG ) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_tlsext_status_cb}
function SSL_CTX_set_tlsext_status_cb(ssl : PSSL_CTX; cb : TSSL_CTX_set_tlsext_status_cb) :TIdC_LONG;
 {$EXTERNALSYM SSL_set_tlsext_opaque_prf_input}
function SSL_set_tlsext_opaque_prf_input(s : PSSL; src : PIdAnsiChar; len : TIdC_LONG ) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_tlsext_opaque_prf_input_callback}
function SSL_CTX_set_tlsext_opaque_prf_input_callback(ctx : PSSL_CTX; cb : TSSL_CTX_set_tlsext_opaque_prf_input_callback_cb) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_tlsext_opaque_prf_input_callback_arg}
function SSL_CTX_set_tlsext_opaque_prf_input_callback_arg(ctx : PSSL_CTX; arg : Pointer) : TIdC_LONG;
 {$EXTERNALSYM SSL_CTX_set_tlsext_ticket_key_cb}
function SSL_CTX_set_tlsext_ticket_key_cb(ssl : PSSL_CTX; cb : TSSL_CTX_set_tlsext_ticket_key_cb_fp) : TIdC_LONG;
{$ifndef OPENSSL_NO_HEARTBEATS}
 {$EXTERNALSYM SSL_heartbeat}
function SSL_heartbeat(ssl : PSSL) : TIdC_LONG;
 {$EXTERNALSYM SSL_get_tlsext_heartbeat_pending}
function SSL_get_tlsext_heartbeat_pending(ssl : PSSL) : TIdC_LONG;
 {$EXTERNALSYM SSL_set_tlsext_heartbeat_no_requests}
function SSL_set_tlsext_heartbeat_no_requests(ssl : PSSL; arg : TIdC_LONG) : TIdC_LONG;
{$endif}
{$ENDIF}

 {$EXTERNALSYM TLS1_get_version}
function TLS1_get_version(s : PSSL) : TIdC_INT;
 {$EXTERNALSYM TLS1_get_client_version}
function TLS1_get_client_version(s : PSSL) : TIdC_INT;
 {$EXTERNALSYM SSL_CTX_get_version}
function SSL_CTX_get_version(ctx: PSSL_CTX):TIdC_INT;
//* BIO_s_connect() and BIO_s_socks4a_connect() */
 {$EXTERNALSYM BIO_set_conn_hostname}
function BIO_set_conn_hostname(b : PBIO; name : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_conn_port}
function BIO_set_conn_port(b : PBIO; port : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_conn_ip}
function BIO_set_conn_ip(b : PBIO; ip : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_conn_int_port}
function BIO_set_conn_int_port(b : PBIO; port : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_conn_hostname}
function BIO_get_conn_hostname(b : PBIO) : PIdAnsiChar;
 {$EXTERNALSYM BIO_get_conn_port}
function BIO_get_conn_port(b : PBIO) : PIdAnsiChar;
 {$EXTERNALSYM BIO_get_conn_ip}
function BIO_get_conn_ip(b : PBIO) : PIdAnsiChar;
 {$EXTERNALSYM BIO_get_conn_int_port}
function BIO_get_conn_int_port(b : PBIO) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_nbio}
function BIO_set_nbio(b : PBIO; n : TIdC_LONG) : TIdC_LONG;
//* BIO_s_accept_socket() */
 {$EXTERNALSYM BIO_set_accept_port}
function BIO_set_accept_port(b : PBIO; name : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_accept_port}
function BIO_get_accept_port(b : PBIO) : PIdAnsiChar;
 {$EXTERNALSYM BIO_set_nbio_accept}
function BIO_set_nbio_accept(b : PBIO; n : TIdC_INT) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_accept_bios}
function BIO_set_accept_bios(b : PBIO; bio : PBIO) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_bind_mode}
function BIO_set_bind_mode(b : PBIO; mode : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_bind_mode}
function BIO_get_bind_mode(b : PBIO; mode : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM BIO_do_handshake}
function BIO_do_handshake(b : PBIO) : TIdC_LONG;
 {$EXTERNALSYM BIO_do_connect}
function BIO_do_connect(b : PBIO) : TIdC_LONG;
 {$EXTERNALSYM BIO_do_accept}
function BIO_do_accept(b : PBIO) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_url}
function BIO_set_url(b : PBIO; url : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_proxies}
function BIO_set_proxies(b : PBIO; p : PIdAnsiChar) : TIdC_LONG;

//* BIO_set_nbio(b,n) */
 {$EXTERNALSYM BIO_set_filter_bio}
function BIO_set_filter_bio(b : PBIO; s : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_proxy_header}
function BIO_set_proxy_header(b : PBIO; sk : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_no_connect_return}
function BIO_set_no_connect_return(b : PBIO; b2 : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_proxy_header}
function BIO_get_proxy_header(b : PBIO; var skp : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_proxies}
function BIO_get_proxies(b : PBIO; var pxy_p : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_url}
function BIO_get_url(b : PBIO; var url : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_no_connect_return}
function BIO_get_no_connect_return(b : PBIO) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_fd}
function BIO_set_fd(b : PBIO; fd,c : TIdC_INT) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_fd}
function BIO_get_fd(b : PBIO; c : PIdC_INT) : TIdC_LONG;
 {$EXTERNALSYM BIO_seek}
function BIO_seek(b : PBIO; ofs : TIdC_LONG) : TIdC_INT;
 {$EXTERNALSYM BIO_tell}
function BIO_tell(b : PBIO) : TIdC_INT;
{$IFDEF CONST_STRICT}
{$ELSE}
 {$EXTERNALSYM BIO_read_filename}
function BIO_read_filename(b : PBIO; name : PIdAnsiChar) : TIdC_LONG;
{$ENDIF}
 {$EXTERNALSYM BIO_get_md}
function BIO_get_md(b : PBIO; var mdp : PEVP_MD) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_md_ctx}
function BIO_get_md_ctx(b : PBIO; var mdcp : PEVP_MD_CTX) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_md_ctx}
function BIO_set_md_ctx(b : PBIO; mdcp : PEVP_MD_CTX) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_cipher_status}
function BIO_get_cipher_status(b : PBIO) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_cipher_ctx}
function BIO_get_cipher_ctx(b : PBIO; var c_pp : PEVP_CIPHER_CTX): TIdC_LONG;

 {$EXTERNALSYM BIO_write_filename}
function BIO_write_filename(b : PBIO; name : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_append_filename}
function BIO_append_filename(b : PBIO; name : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_rw_filename}
function BIO_rw_filename(b : PBIO; name : PIdAnsiChar) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_ssl}
function BIO_set_ssl(b : PBIO; ssl : PSSL; c : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_ssl}
function BIO_get_ssl(b : PBIO; var sslp : PSSL) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_ssl_mode}
function BIO_set_ssl_mode(b : PBIO; client : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_ssl_renegotiate_bytes}
function BIO_set_ssl_renegotiate_bytes(b : PBIO; num : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_num_renegotiates}
function BIO_get_num_renegotiates(b : PBIO) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_ssl_renegotiate_timeout}
function BIO_set_ssl_renegotiate_timeout(b : PBIO; seconds : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM BIO_get_mem_data}
function BIO_get_mem_data(b : PBIO; var pp : PIdAnsiChar) : TIdC_INT;
 {$EXTERNALSYM BIO_set_mem_buf}
function BIO_set_mem_buf(b : PBIO; bm : PBUF_MEM; c : TIdC_INT) : TIdC_INT;
 {$EXTERNALSYM BIO_get_mem_ptr}
function BIO_get_mem_ptr(b: PBIO; var pp: PBUF_MEM) : TIdC_INT;
 {$EXTERNALSYM BIO_set_mem_eof_return}
procedure BIO_set_mem_eof_return(b : PBIO; const v : TIdC_INT);
//* For the BIO_f_buffer() type */
 {$EXTERNALSYM BIO_get_buffer_num_lines}
function BIO_get_buffer_num_lines(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_set_buffer_size}
procedure BIO_set_buffer_size(b : PBIO; const size : TIdC_INT);
//* Don't use the next one unless you know what you are doing :-) */
 {$EXTERNALSYM BIO_dup_state}
function BIO_dup_state(b : PBIO; ret : PBIO) : TIdC_LONG;
 {$EXTERNALSYM BIO_reset}
function BIO_reset(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_eof}
function BIO_eof(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_set_close}
function BIO_set_close(b: PBIO; c: TIdC_LONG): TIdC_INT;
 {$EXTERNALSYM BIO_get_close}
function BIO_get_close(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_pending}
function BIO_pending(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_wpending}
function BIO_wpending(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_flush}
function BIO_flush(b : PBIO) : TIdC_INT;
//* For the BIO_f_buffer() type */
 {$EXTERNALSYM BIO_buffer_get_num_lines}
function BIO_buffer_get_num_lines(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_get_info_callback}
function BIO_get_info_callback(b : PBIO; var cbp : Pbio_info_cb) : TIdC_INT;
 {$EXTERNALSYM BIO_set_info_callback}
function BIO_set_info_callback(b : PBIO; cb : Pbio_info_cb) : TIdC_INT;
 {$EXTERNALSYM BIO_set_read_buffer_size}
function BIO_set_read_buffer_size(b : PBIO; size : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM BIO_set_write_buffer_size}
function BIO_set_write_buffer_size(b : PBIO; size : TIdC_LONG) : TIdC_LONG;
 {$EXTERNALSYM BIO_make_bio_pair}
function BIO_make_bio_pair(b1, b2 : PBIO ): TIdC_INT;
 {$EXTERNALSYM BIO_destroy_bio_pair}
function BIO_destroy_bio_pair(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_shutdown_wr}
function BIO_shutdown_wr(b : PBIO) : TIdC_INT;
///* macros with inappropriate type -- but ...pending macros use int too: */
 {$EXTERNALSYM BIO_get_write_guarantee}
function BIO_get_write_guarantee(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_get_read_request}
function BIO_get_read_request(b : PBIO) : TIdC_INT;
//* ctrl macros for dgram */
 {$EXTERNALSYM _BIO_ctrl_dgram_connect}
function _BIO_ctrl_dgram_connect(b : PBIO; peer : Sockaddr) : TIdC_INT;
 {$EXTERNALSYM BIO_ctrl_set_connected}
function BIO_ctrl_set_connected(b : PBIO; state : TIdC_INT; peer : Sockaddr) : TIdC_INT;
 {$EXTERNALSYM BIO_dgram_recv_timedout}
function BIO_dgram_recv_timedout(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_dgram_send_timedout}
function BIO_dgram_send_timedout(b : PBIO) : TIdC_INT;
 {$EXTERNALSYM BIO_dgram_get_peer}
function BIO_dgram_get_peer(b : PBIO; peer : PSockAddr) : TIdC_INT;
 {$EXTERNALSYM BIO_dgram_set_peer}
function BIO_dgram_set_peer(b : PBIO; peer : PSockAddr) : TIdC_INT;

 {$EXTERNALSYM PEM_read_bio_X509}
function PEM_read_bio_X509(bp: PBIO; x: PPX509; cb: ppem_password_cb; u: Pointer): PX509;
 {$EXTERNALSYM PEM_read_bio_X509_REQ}
function PEM_read_bio_X509_REQ(bp :PBIO; x : PPX509_REQ; cb :ppem_password_cb; u: Pointer) : PX509_REQ;
 {$EXTERNALSYM PEM_read_bio_X509_CRL}
function PEM_read_bio_X509_CRL(bp : PBIO; x : PPX509_CRL;cb : ppem_password_cb; u: Pointer) : PX509_CRL;
 {$EXTERNALSYM PEM_read_bio_RSAPrivateKey}
function PEM_read_bio_RSAPrivateKey(bp : PBIO; x : PPRSA; cb : ppem_password_cb; u: Pointer) : PRSA;
 {$EXTERNALSYM PEM_read_bio_RSAPublicKey}
function PEM_read_bio_RSAPublicKey(bp : PBIO; x : PPRSA; cb : ppem_password_cb; u: Pointer) : PRSA;
 {$EXTERNALSYM PEM_read_bio_DSAPrivateKey}
function PEM_read_bio_DSAPrivateKey(bp : PBIO; x : PPDSA; cb : ppem_password_cb; u : Pointer) : PDSA;
 {$EXTERNALSYM PEM_read_bio_PrivateKey}
function PEM_read_bio_PrivateKey(bp : PBIO; x : PPEVP_PKEY; cb : ppem_password_cb; u : Pointer) : PEVP_PKEY;
 {$EXTERNALSYM PEM_read_bio_PKCS7}
function PEM_read_bio_PKCS7(bp : PBIO; x : PPPKCS7; cb : ppem_password_cb; u : Pointer) : PPKCS7;
 {$EXTERNALSYM PEM_read_bio_DHparams}
function PEM_read_bio_DHparams(bp : PBIO; x : PPDH; cb : ppem_password_cb; u : Pointer) : PDH;
 {$EXTERNALSYM PEM_read_bio_DSAparams}
function PEM_read_bio_DSAparams(bp : PBIO; x : PPDSA; cb : ppem_password_cb; u : Pointer) : PDSA;
 {$EXTERNALSYM PEM_read_bio_NETSCAPE_CERT_SEQUENCE}
function PEM_read_bio_NETSCAPE_CERT_SEQUENCE(bp : PBIO; x : PPNETSCAPE_CERT_SEQUENCE;
  cb : ppem_password_cb; u : Pointer) : PNETSCAPE_CERT_SEQUENCE;
 {$EXTERNALSYM PEM_read_bio_PUBKEY}
function PEM_read_bio_PUBKEY(bp : PBIO; x : PPEVP_PKEY; cb : ppem_password_cb; u : Pointer) : PEVP_PKEY;
 {$EXTERNALSYM PEM_write_bio_X509}
function PEM_write_bio_X509(bp: PBIO; x: PX509): TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_X509_REQ}
function PEM_write_bio_X509_REQ(bp: PBIO; x: PX509_REQ): TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_X509_CRL}
function PEM_write_bio_X509_CRL(bp : PBIO; x : PX509_CRL) : TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_RSAPrivateKey}
function  PEM_write_bio_RSAPrivateKey(bp : PBIO; x : PRSA; const enc : PEVP_CIPHER;
  kstr : PIdAnsiChar; klen : TIdC_INT; cb : ppem_password_cb; u : POinter) : TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_RSAPublicKey}
function PEM_write_bio_RSAPublicKey(bp : PBIO; x : PRSA) : TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_DSAPrivateKey}
function PEM_write_bio_DSAPrivateKey( bp : PBIO; x : PDSA; const enc : PEVP_CIPHER;
  kstr : PIdAnsiChar; klen : TIdC_INT; cb : Ppem_password_cb; u : Pointer) : TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_PrivateKey}
function PEM_write_bio_PrivateKey(bp : PBIO; x : PEVP_PKEY; const enc : PEVP_CIPHER;
  kstr : PIdAnsiChar; klen : TIdC_INT; cb : Ppem_password_cb; u : Pointer) : TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_PKCS7}
function PEM_write_bio_PKCS7(bp : PBIO; x : PPKCS7) : TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_DHparams}
function PEM_write_bio_DHparams(bp : PBIO; x : PDH): TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_DSAparams}
function PEM_write_bio_DSAparams(bp : PBIO; x : PDSA) : TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_NETSCAPE_CERT_SEQUENCE}
function PEM_write_bio_NETSCAPE_CERT_SEQUENCE(bp : PBIO; x : PDSA) : TIdC_INT;
 {$EXTERNALSYM PEM_write_bio_PUBKEY}
function PEM_write_bio_PUBKEY(bp : PBIO; x : PEVP_PKEY) : TIdC_INT;

 {$EXTERNALSYM OPENSSL_malloc} 
function OPENSSL_malloc(aSize:TIdC_INT):Pointer;
 {$EXTERNALSYM CRYPTO_SetMemCheck} 
procedure CRYPTO_SetMemCheck(const aEnabled: Boolean);

{$IFNDEF OPENSSL_NO_RSA}
 {$EXTERNALSYM EVP_PKEY_assign_RSA} 
function EVP_PKEY_assign_RSA(pkey: PEVP_PKEY; rsa: PRSA): TIdC_INT;
{$ENDIF}

{$IFNDEF OPENSSL_NO_DSA}
 {$EXTERNALSYM EVP_PKEY_assign_DSA}
function EVP_PKEY_assign_DSA(pkey : PEVP_PKEY; dsa : PDSA) : TIdC_INT;
{$ENDIF}

{$IFNDEF OPENSSL_NO_DH}
 {$EXTERNALSYM EVP_PKEY_assign_DH} 
function EVP_PKEY_assign_DH(pkey : PEVP_PKEY; dh : PDH) : TIdC_INT;
{$ENDIF}

{$IFNDEF OPENSSL_NO_EC}
 {$EXTERNALSYM EVP_PKEY_assign_EC_KEY}
function EVP_PKEY_assign_EC_KEY(pkey : PEVP_PKEY; eckey : PEC_KEY) : TIdC_INT;
{$ENDIF}

//* Add some extra combinations */
 {$EXTERNALSYM EVP_get_digestbynid}
function EVP_get_digestbynid(a : TIdC_INT) : PEVP_MD;
 {$EXTERNALSYM EVP_get_digestbyobj}
function EVP_get_digestbyobj(a : PASN1_OBJECT) : PEVP_MD;
 {$EXTERNALSYM EVP_get_cipherbynid}
function EVP_get_cipherbynid(a : TIdC_INT) : PEVP_CIPHER;
 {$EXTERNALSYM EVP_get_cipherbyobj}
function EVP_get_cipherbyobj(a : PASN1_OBJECT) : PEVP_CIPHER;
 {$EXTERNALSYM EVP_MD_nid}
function EVP_MD_nid(e : PEVP_MD) : TIdC_INT;
 {$EXTERNALSYM EVP_MD_name}
function EVP_MD_name(e : PEVP_MD) : PIdAnsiChar;
 {$EXTERNALSYM EVP_MD_CTX_size}
function EVP_MD_CTX_size(e : PEVP_MD_CTX) : TIdC_INT;
 {$EXTERNALSYM EVP_MD_CTX_block_size}
function EVP_MD_CTX_block_size(e : PEVP_MD_CTX) : TIdC_INT;
 {$EXTERNALSYM EVP_MD_CTX_type}
function EVP_MD_CTX_type(e : PEVP_MD_CTX) : TIdC_INT;
 {$EXTERNALSYM EVP_CIPHER_name}
function EVP_CIPHER_name(e : PEVP_CIPHER) : PIdAnsiChar;
 {$EXTERNALSYM EVP_CIPHER_mode}
function EVP_CIPHER_mode(e : PEVP_CIPHER) : TIdC_ULONG;
 {$EXTERNALSYM EVP_CIPHER_CTX_type}
function EVP_CIPHER_CTX_type(c : PEVP_CIPHER_CTX) : TIdC_INT;
 {$EXTERNALSYM EVP_CIPHER_CTX_mode}
function EVP_CIPHER_CTX_mode(e : PEVP_CIPHER_CTX) : TIdC_ULONG;
 {$EXTERNALSYM EVP_ENCODE_LENGTH}
function EVP_ENCODE_LENGTH(l : Integer) : Integer;
 {$EXTERNALSYM EVP_DECODE_LENGTH}
function EVP_DECODE_LENGTH(l : Integer) : Integer;
 {$EXTERNALSYM EVP_SignInit_ex}
function EVP_SignInit_ex(a: PEVP_MD_CTX; b : PEVP_MD; c : PENGINE) : TIdC_INT;
 {$EXTERNALSYM EVP_SignInit}
function EVP_SignInit(a : PEVP_MD_CTX; b : PEVP_MD) : TIdC_INT;
 {$EXTERNALSYM EVP_SignUpdate}
function EVP_SignUpdate(a: PEVP_MD_CTX; b : Pointer; c : size_t) : TIdC_INT;
 {$EXTERNALSYM EVP_VerifyInit_ex}
function EVP_VerifyInit_ex(a: PEVP_MD_CTX; b: PEVP_MD; c: PENGINE) : TIdC_INT;
 {$EXTERNALSYM EVP_VerifyInit}
function EVP_VerifyInit(a: PEVP_MD_CTX; b: PEVP_MD) : TIdC_INT;
 {$EXTERNALSYM EVP_VerifyUpdate}
function EVP_VerifyUpdate(a: PEVP_MD_CTX; b: Pointer; c : size_t) : TIdC_INT;
 {$EXTERNALSYM EVP_OpenUpdate}
function EVP_OpenUpdate(a: PEVP_CIPHER_CTX; _out : PIdAnsiChar; outl : PIdC_INT;
  _in : PIdAnsiChar; inl : TIdC_INT) : TIdC_INT;
 {$EXTERNALSYM EVP_SealUpdate}
function EVP_SealUpdate(a : PEVP_CIPHER_CTX; b: PIdAnsiChar; c : PIdC_INT;
  d: PIdAnsiChar; e : TIdC_INT) : TIdC_INT;
 {$EXTERNALSYM EVP_DigestSignUpdate}
function EVP_DigestSignUpdate(a : PEVP_MD_CTX; b : Pointer; c : size_t) : TIdC_Int;
 {$EXTERNALSYM EVP_DigestVerifyUpdate}
function EVP_DigestVerifyUpdate(a : PEVP_MD_CTX; b : Pointer; c : size_t) : TIdC_INT;
{$ifndef OPENSSL_NO_DES}
 {$EXTERNALSYM EVP_des_cfb}
function EVP_des_cfb : PEVP_CIPHER;
 {$EXTERNALSYM EVP_des_ede_cfb}
function EVP_des_ede_cfb: PEVP_CIPHER;
 {$EXTERNALSYM EVP_des_ede3_cfb}
function EVP_des_ede3_cfb: PEVP_CIPHER;
{$endif}
{$ifndef OPENSSL_NO_IDEA}
 {$EXTERNALSYM EVP_idea_cfb}
function EVP_idea_cfb: PEVP_CIPHER;
{$endif}
{$ifndef OPENSSL_NO_RC2}
 {$EXTERNALSYM EVP_rc2_cfb}
function EVP_rc2_cfb: PEVP_CIPHER;
{$endif}
{$ifndef OPENSSL_NO_BF}
 {$EXTERNALSYM EVP_bf_cfb}
function EVP_bf_cfb: PEVP_CIPHER;
{$endif}
{$ifndef OPENSSL_NO_CAST}
 {$EXTERNALSYM EVP_cast5_cfb}
function EVP_cast5_cfb: PEVP_CIPHER;
{$endif}
{$ifndef OPENSSL_NO_RC5}
 {$EXTERNALSYM EVP_rc5_32_12_16_cfb}
function EVP_rc5_32_12_16_cfb: PEVP_CIPHER;
{$endif}
{$ifndef OPENSSL_NO_AES}
 {$EXTERNALSYM EVP_aes_128_cfb}
function EVP_aes_128_cfb: PEVP_CIPHER;
 {$EXTERNALSYM EVP_aes_192_cfb}
function EVP_aes_192_cfb: PEVP_CIPHER;
 {$EXTERNALSYM EVP_aes_256_cfb}
function EVP_aes_256_cfb: PEVP_CIPHER;
{$endif}
{$ifndef OPENSSL_NO_CAMELLIA}
 {$EXTERNALSYM EVP_camellia_128_cfb}
function EVP_camellia_128_cfb: PEVP_CIPHER;
 {$EXTERNALSYM EVP_camellia_192_cfb}
function EVP_camellia_192_cfb: PEVP_CIPHER;
 {$EXTERNALSYM EVP_camellia_256_cfb}
function EVP_camellia_256_cfb: PEVP_CIPHER;
{$endif}
{$ifndef OPENSSL_NO_SEED}
 {$EXTERNALSYM EVP_seed_cfb}
function EVP_seed_cfb: PEVP_CIPHER;
{$endif}
 {$EXTERNALSYM EVP_PKEY_CTX_set_signature_md}
function EVP_PKEY_CTX_set_signature_md(ctx : PEVP_PKEY_CTX;md : PEVP_PKEY_CTX) : TIdC_INT;
 {$EXTERNALSYM SSLeay_add_all_algorithms}
procedure SSLeay_add_all_algorithms;
 {$EXTERNALSYM SSLeay_add_all_ciphers}
procedure SSLeay_add_all_ciphers;
 {$EXTERNALSYM SSLeay_add_all_digests}
procedure SSLeay_add_all_digests;

 {$EXTERNALSYM X509V3_set_ctx_nodb}
procedure X509V3_set_ctx_nodb(ctx: X509V3_CTX);
//
 {$EXTERNALSYM ErrMsg} 
function ErrMsg(AErr : TIdC_ULONG) : string;
 {$EXTERNALSYM ERR_PACK} 
function ERR_PACK(l, f, r : TIdC_INT) : TIdC_ULONG;
 {$EXTERNALSYM ERR_GET_LIB} 
function ERR_GET_LIB(const l : TIdC_INT) : TIdC_ULONG;
 {$EXTERNALSYM ERR_GET_FUNC} 
function ERR_GET_FUNC(const l : TIdC_INT) : TIdC_ULONG;
 {$EXTERNALSYM ERR_FATAL_ERROR} 
function ERR_FATAL_ERROR(const l : TIdC_INT) : Boolean;
 {$EXTERNALSYM ERR_GET_REASON} 
function ERR_GET_REASON(const l : TIdC_INT) : TIdC_INT;
 {$EXTERNALSYM SYSerr} 
procedure SYSerr(const f,r : TIdC_INT);
 {$EXTERNALSYM BNerr}
procedure BNerr(const f,r : TIdC_INT);
 {$EXTERNALSYM RSAerr} 
procedure RSAerr(const f,r : TIdC_INT);
 {$EXTERNALSYM DHerrr} 
procedure DHerrr(const f,r : TIdC_INT);
 {$EXTERNALSYM EVPerr} 
procedure EVPerr(const f,r : TIdC_INT);
 {$EXTERNALSYM BUFerr} 
procedure BUFerr(const f,r : TIdC_INT);
 {$EXTERNALSYM OBJerr} 
procedure OBJerr(const f,r : TIdC_INT);
 {$EXTERNALSYM PEMerr} 
procedure PEMerr(const f,r : TIdC_INT);
 {$EXTERNALSYM DSAerr}
procedure DSAerr(const f,r : TIdC_INT);
 {$EXTERNALSYM X509err}
procedure X509err(const f,r : TIdC_INT);
 {$EXTERNALSYM ASN1err}
procedure ASN1err(const f,r : TIdC_INT);
 {$EXTERNALSYM CONFerr}
procedure CONFerr(const f,r : TIdC_INT);
 {$EXTERNALSYM CRYPTOerr}
procedure CRYPTOerr(const f,r : TIdC_INT);
 {$EXTERNALSYM ECerr}
procedure ECerr(const f,r : TIdC_INT);
 {$EXTERNALSYM SSLerr}
procedure SSLerr(const f,r : TIdC_INT);
 {$EXTERNALSYM BIOerr}
procedure BIOerr(const f,r : TIdC_INT);
 {$EXTERNALSYM PKCS7err}
procedure PKCS7err(const f,r : TIdC_INT);
 {$EXTERNALSYM X509V3err}
procedure X509V3err(const f,r : TIdC_INT);
 {$EXTERNALSYM PKCS12err}
procedure PKCS12err(const f,r : TIdC_INT);
 {$EXTERNALSYM RANDerr}
procedure RANDerr(const f,r : TIdC_INT);
 {$EXTERNALSYM DSOerr}
procedure DSOerr(const f,r : TIdC_INT);
 {$EXTERNALSYM ENGINEerr}
procedure ENGINEerr(const f,r : TIdC_INT);
 {$EXTERNALSYM OCSPerr}
procedure OCSPerr(const f,r : TIdC_INT);
 {$EXTERNALSYM UIerr}
procedure UIerr(const f,r : TIdC_INT);
 {$EXTERNALSYM COMPerr}
procedure COMPerr(const f,r : TIdC_INT);
 {$EXTERNALSYM ECDSAerr}
procedure ECDSAerr(const f,r : TIdC_INT);
 {$EXTERNALSYM ECDHerr}
procedure ECDHerr(const f,r : TIdC_INT);
 {$EXTERNALSYM STOREerr}
procedure STOREerr(const f,r : TIdC_INT);
 {$EXTERNALSYM FIPSerr}
procedure FIPSerr(const f,r : TIdC_INT);
 {$EXTERNALSYM CMSerr}
procedure CMSerr(const f,r : TIdC_INT);
 {$EXTERNALSYM TSerr}
procedure TSerr(const f,r : TIdC_INT);
 {$EXTERNALSYM HMACerr}
procedure HMACerr(const f,r : TIdC_INT);
 {$EXTERNALSYM JPAKEerr}
procedure JPAKEerr(const f,r : TIdC_INT);
 {$EXTERNALSYM X509_LOOKUP_load_file}
function X509_LOOKUP_load_file(x : PX509_LOOKUP; name : PIdAnsiChar; _type : TIdC_LONG) : TIdC_INT;
 {$EXTERNALSYM X509_LOOKUP_add_dir}
function X509_LOOKUP_add_dir(x : PX509_LOOKUP; name : PIdAnsiChar; _type : TIdC_LONG) : TIdC_INT;

type
//moved from IdSSLOpenSSL so we can use these classes in other places
  EIdOpenSSLError               = class(EIdException);
  TIdOpenSSLAPISSLError = class of EIdOpenSSLAPISSLError;

  EIdOpenSSLAPISSLError = class(EIdOpenSSLError)
  protected
    FErrorCode : TIdC_INT;
    FRetCode : TIdC_INT;
  public
    class procedure RaiseException(ASSL: Pointer; const ARetCode : TIdC_INT; const AMsg : String = '');
    class procedure RaiseExceptionCode(const AErrCode, ARetCode : TIdC_INT; const AMsg : String = '');
    property ErrorCode : TIdC_INT read FErrorCode;
    property RetCode : TIdC_INT read FRetCode;
  end;

  TIdOpenSSLAPICryptoError = class of EIdOpenSSLAPICryptoError;
  EIdOpenSSLAPICryptoError = class(EIdOpenSSLError)
  protected
    FErrorCode : TIdC_ULONG;
  public
    class procedure RaiseExceptionCode(const AErrCode : TIdC_ULONG; const AMsg : String = '');
    class procedure RaiseException(const AMsg : String = '');
    property ErrorCode : TIdC_ULONG read FErrorCode;
  end;
  EIdOSSLUnderlyingCryptoError = class(EIdOpenSSLAPICryptoError);

  EIdDigestError = class(EIdOpenSSLAPICryptoError);
  EIdDigestFinalEx = class(EIdDigestError);
  EIdDigestInitEx = class(EIdDigestError);
  EIdDigestUpdate = class(EIdDigestError);

function IsOpenSSL_1x : Boolean;
function IsOpenSSL_SSLv2_Available : Boolean;
function IsOpenSSL_SSLv3_Available : Boolean;
function IsOpenSSL_SSLv23_Available : Boolean;
function IsOpenSSL_TLSv1_0_Available : Boolean;
function IsOpenSSL_TLSv1_1_Available : Boolean;
function IsOpenSSL_TLSv1_2_Available : Boolean;
function IsOpenSSL_DTLSv1_Available : Boolean;

// RLebeau: should these be declared as EXTERNALSYM?
procedure RAND_cleanup;
function RAND_bytes(buf : PIdAnsiChar; num : integer) : integer;
function RAND_pseudo_bytes(buf : PIdAnsiChar; num : integer) : integer;
procedure RAND_seed(buf : PIdAnsiChar; num : integer);
procedure RAND_add(buf : PIdAnsiChar; num : integer; entropy : integer);
function RAND_status() : integer;
{$IFDEF SYS_WIN}
function RAND_event(iMsg : UINT; wp : wparam; lp : lparam) : integer;
procedure RAND_screen();
{$ENDIF}

implementation

uses
  Classes,
  IdFIPS,
  IdGlobalProtocols,
  IdResourceStringsProtocols,
  IdResourceStringsOpenSSL,
  IdStack
  {$IFDEF FPC}
    {$IFNDEF WINDOWS}
      , DynLibs  // needed for FreeLibrary
    {$ENDIF}
  {$ENDIF};

{$IFNDEF OPENSSL_NO_HMAC}
procedure HMAC_Init_ex(ctx : PHMAC_CTX; key : Pointer; len : TIdC_INT;
    md : PEVP_MD; impl : PENGINE);
  {$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  if Assigned(_HMAC_Init_ex) then begin
    _HMAC_Init_ex(ctx, key, len, md, impl );
  end else begin
    if Assigned(_1_0_HMAC_Init_ex) then begin
      _1_0_HMAC_Init_ex(ctx, key, len, md, impl );
    end;
  end;
end;

procedure HMAC_Update(ctx : PHMAC_CTX; data : PIdAnsiChar; len : size_t);
  {$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  if Assigned(_HMAC_Update) then begin
    _HMAC_Update(ctx, data, len );
  end else begin
    if Assigned(_1_0_HMAC_Update) then begin
      _1_0_HMAC_Update(ctx, data, len );
    end;
  end;
end;

procedure HMAC_Final(ctx : PHMAC_CTX; md : PIdAnsiChar; len : PIdC_UINT);
  {$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  if Assigned(_HMAC_Final) then begin
    _HMAC_Final(ctx, md, len );
  end else begin
    if Assigned(_1_0_HMAC_Update) then begin
      _1_0_HMAC_Final(ctx, md, len );
    end;
  end;
end;
{$ENDIF}

function IsOpenSSL_1x : Boolean;
  {$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  if Assigned( SSLeay ) then begin
    Result := (SSLeay and $F0000000) = $10000000;
  end else begin
    Result := False;
  end;
end;

function IsOpenSSL_SSLv2_Available : Boolean;
{$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  Result := Assigned(SSLv2_method) and
    Assigned(SSLv2_server_method) and
    Assigned(SSLv2_client_method);
end;

function IsOpenSSL_SSLv3_Available : Boolean;
{$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  Result := Assigned(SSLv3_method) and
    Assigned(SSLv3_server_method) and
    Assigned(SSLv3_client_method);
end;

function IsOpenSSL_SSLv23_Available : Boolean;
{$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  Result := Assigned(SSLv23_method) and
    Assigned(SSLv23_server_method) and
    Assigned(SSLv23_client_method);
end;

function IsOpenSSL_TLSv1_0_Available : Boolean;
{$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  Result := Assigned(TLSv1_method) and
    Assigned(TLSv1_server_method) and
    Assigned(TLSv1_client_method);
end;

function IsOpenSSL_TLSv1_1_Available : Boolean;
{$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  Result := Assigned(TLSv1_1_method) and
    Assigned(TLSv1_1_server_method) and
    Assigned(TLSv1_1_client_method);
end;

function IsOpenSSL_TLSv1_2_Available : Boolean;
{$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  Result := Assigned(TLSv1_2_method) and
    Assigned(TLSv1_2_server_method) and
    Assigned(TLSv1_2_client_method);
end;

function IsOpenSSL_DTLSv1_Available : Boolean;
{$IFDEF USE_INLINE} inline; {$ENDIF}
begin
  Result := Assigned(DTLSv1_method) and
    Assigned(DTLSv1_server_method) and
    Assigned(DTLSv1_client_method);
end;

//**************** FIPS Support backend *******************
function OpenSSLIsHashingIntfAvail : Boolean;
begin
  Result := Assigned(EVP_DigestInit_ex) and
            Assigned(EVP_DigestUpdate) and
            Assigned(EVP_DigestFinal_ex) ;
end;

function OpenSSLGetFIPSMode : Boolean;
begin
  Result := FIPS_mode <> 0;
end;

function OpenSSLSetFIPSMode(const AMode : Boolean) : Boolean;
begin
  //leave this empty as we may not be using something that supports FIPS
  if AMode then begin
    Result := FIPS_mode_set(1) = 1;
  end else begin
    Result := FIPS_mode_set(0) = 1;
  end;
end;

function OpenSSLGetDigestCtx( AInst : PEVP_MD) : TIdHashIntCtx;
  {$IFDEF USE_INLINE} inline; {$ENDIF}
var LRet : Integer;
begin
  Result := AllocMem(SizeOf(EVP_MD_CTX));
  EVP_MD_CTX_init(Result);

  LRet := EVP_DigestInit_ex(Result, AInst, nil);
  if LRet <> 1 then begin
    EIdDigestInitEx.RaiseException('EVP_DigestInit_ex error');
  end;
end;

function OpenSSLIsMD2HashIntfAvail: Boolean;
begin
  {$IFDEF OPENSSL_NO_MD2}
  Result := False;
  {$ELSE}
  Result := Assigned(EVP_md2);
  {$ENDIF}
end;

function OpenSSLGetMD2HashInst : TIdHashIntCtx;
{$IFNDEF OPENSSL_NO_MD2}
var
  LRet : PEVP_MD;
{$ENDIF}
begin
  {$IFDEF OPENSSL_NO_MD2}
  Result := nil;
  {$ELSE}
  LRet := EVP_md2;
  Result := OpenSSLGetDigestCtx(LRet);
  {$ENDIF}
end;

function OpenSSLIsMD4HashIntfAvail: Boolean;
begin
  Result := Assigned(EVP_md4);
end;

function OpenSSLGetMD4HashInst : TIdHashIntCtx;
var
  LRet : PEVP_MD;
begin
  LRet := EVP_md4;
  Result := OpenSSLGetDigestCtx(LRet);
end;

function OpenSSLIsMD5HashIntfAvail: Boolean;
begin
  Result := Assigned(EVP_md5);
end;

function OpenSSLGetMD5HashInst : TIdHashIntCtx;
var
  LRet : PEVP_MD;
begin
  LRet := EVP_md5;
  Result := OpenSSLGetDigestCtx(LRet);
end;

function OpenSSLIsSHA1HashIntfAvail: Boolean;
begin
  {$IFDEF OPENSSL_NO_SHA}
  Result := False;
  {$ELSE}
  Result := Assigned(EVP_sha1);
  {$ENDIF}
end;

function OpenSSLGetSHA1HashInst : TIdHashIntCtx;
{$IFNDEF OPENSSL_NO_SHA}
var
  LRet : PEVP_MD;
{$ENDIF}
begin
  {$IFDEF OPENSSL_NO_SHA}
  Result := nil;
  {$ELSE}
  LRet := EVP_sha1;
  Result := OpenSSLGetDigestCtx(LRet);
  {$ENDIF}
end;

function OpenSSLIsSHA224HashIntfAvail: Boolean;
begin
  {$IFDEF OPENSSL_NO_SHA256}
  Result := False;
  {$ELSE}
  Result := Assigned(EVP_sha224);
  {$ENDIF}
end;

function OpenSSLGetSHA224HashInst : TIdHashIntCtx;
{$IFNDEF OPENSSL_NO_SHA256}
var
  LRet : PEVP_MD;
{$ENDIF}
begin
  {$IFDEF OPENSSL_NO_SHA256}
  Result := nil;
  {$ELSE}
  LRet := EVP_sha224;
  Result := OpenSSLGetDigestCtx(LRet);
  {$ENDIF}
end;

function OpenSSLIsSHA256HashIntfAvail: Boolean;
begin
  {$IFDEF OPENSSL_NO_SHA256}
  Result := False;
  {$ELSE}
  Result := Assigned(EVP_sha256);
  {$ENDIF}
end;

function OpenSSLGetSHA256HashInst : TIdHashIntCtx;
{$IFNDEF OPENSSL_NO_SHA256}
var
  LRet : PEVP_MD;
{$ENDIF}
begin
  {$IFDEF OPENSSL_NO_SHA256}
  Result := nil;
  {$ELSE}
  LRet := EVP_sha256;
  Result := OpenSSLGetDigestCtx(LRet);
  {$ENDIF}
end;

function OpenSSLIsSHA384HashIntfAvail: Boolean;
begin
  {$IFDEF OPENSSL_NO_SHA512}
  Result := False;
  {$ELSE}
  Result := Assigned(EVP_sha384);
  {$ENDIF}
end;

function OpenSSLGetSHA384HashInst : TIdHashIntCtx;
{$IFNDEF OPENSSL_NO_SHA512}
var
  LRet : PEVP_MD;
{$ENDIF}
begin
  {$IFDEF OPENSSL_NO_SHA512}
  Result := nil;
  {$ELSE}
  LRet := EVP_sha384;
  Result := OpenSSLGetDigestCtx(LRet);
  {$ENDIF}
end;

function OpenSSLIsSHA512HashIntfAvail: Boolean;
begin
  {$IFDEF OPENSSL_NO_SHA512}
  Result := nil;
  {$ELSE}
  Result := Assigned(EVP_sha512);
  {$ENDIF}
end;

function OpenSSLGetSHA512HashInst : TIdHashIntCtx;
{$IFNDEF OPENSSL_NO_SHA512}
var
  LRet : PEVP_MD;
{$ENDIF}
begin
  {$IFDEF OPENSSL_NO_SHA512}
  Result := nil;
  {$ELSE}
  LRet := EVP_sha512;
  Result := OpenSSLGetDigestCtx(LRet);
{$ENDIF}
end;

procedure OpenSSLUpdateHashInst(ACtx: TIdHashIntCtx; const AIn: TIdBytes);
var
  LRet : TIdC_Int;
begin
  LRet := EVP_DigestUpdate(ACtx, PByte(Ain), Length(AIn));
  if LRet <> 1 then begin
    EIdDigestInitEx.RaiseException('EVP_DigestUpdate error');
  end;
end;

function OpenSSLFinalHashInst(ACtx: TIdHashIntCtx): TIdBytes;
var
  LLen : TIdC_UInt;
  LRet : TIdC_Int;
begin
  SetLength(Result,EVP_MAX_MD_SIZE);
  LRet := EVP_DigestFinal_ex(ACtx, PIdAnsiChar(@Result[0]), LLen);
  if LRet <> 1 then begin
    EIdDigestFinalEx.RaiseException('EVP_DigestFinal_ex error');
  end;
  SetLength(Result,LLen);
  EVP_MD_CTX_cleanup(ACtx);
  FreeMem(ACtx,SizeOf(EVP_MD_CTX));
end;

function OpenSSLIsHMACAvail : Boolean;
begin
  {$IFDEF OPENSSL_NO_HMAC}
  Result := False;
  {$ELSE}
  Result := Assigned(HMAC_CTX_init) and
            ( Assigned(_HMAC_Init_ex) or Assigned(_1_0_HMAC_Init_ex) ) and
            ( Assigned(_HMAC_Update) or Assigned(_1_0_HMAC_Update) ) and
            ( Assigned(_HMAC_Final) or Assigned(_1_0_HMAC_Final) ) and
            Assigned(HMAC_CTX_cleanup);
  {$ENDIF}
end;

function OpenSSLIsHMACMD5Avail: Boolean;
begin
 {$IFDEF OPENSSL_NO_MD5}
 Result := False;
 {$ELSE}
 Result := Assigned(EVP_md5);
 {$ENDIF}
end;

function OpenSSLGetHMACMD5Inst(const AKey : TIdBytes) : TIdHMACIntCtx;
begin
  {$IFDEF OPENSSL_NO_MD5}
  Result := nil;
  {$ELSE}
  Result := AllocMem(SizeOf(HMAC_CTX));
  HMAC_CTX_init(Result);
  HMAC_Init_ex(Result, PByte(AKey), Length(AKey), EVP_md5, nil);
  {$ENDIF}
end;

function OpenSSLIsHMACSHA1Avail: Boolean;
begin
  {$IFDEF OPENSSL_NO_SHA}
  Result := False;
  {$ELSE}
  Result := Assigned(EVP_sha1);
  {$ENDIF}
end;

function OpenSSLGetHMACSHA1Inst(const AKey : TIdBytes) : TIdHMACIntCtx;
begin
  {$IFDEF OPENSSL_NO_SHA}
  Result := nil;
  {$ELSE}
  Result := AllocMem(SizeOf(HMAC_CTX));
  HMAC_CTX_init(Result);
  HMAC_Init_ex(Result, PByte(AKey), Length(AKey), EVP_sha1, nil);
  {$ENDIF}
end;

function OpenSSLIsHMACSHA224Avail: Boolean;

begin
  {$IFDEF OPENSSL_NO_SHA256}
  Result := False;
  {$ELSE}
  Result := Assigned(EVP_sha224);
  {$ENDIF}
end;

function OpenSSLGetHMACSHA224Inst(const AKey : TIdBytes) : TIdHMACIntCtx;
begin
  {$IFDEF OPENSSL_NO_SHA256}
  Result := nil;
  {$ELSE}
  Result := AllocMem(SizeOf(HMAC_CTX));
  HMAC_CTX_init(Result);
  HMAC_Init_ex(Result, PByte(AKey), Length(AKey), EVP_sha224, nil);
  {$ENDIF}
end;

function OpenSSLIsHMACSHA256Avail: Boolean;
begin
  {$IFDEF OPENSSL_NO_SHA256}
  Result := False;
  {$ELSE}
  Result := Assigned(EVP_sha256);
  {$ENDIF}
end;

function OpenSSLGetHMACSHA256Inst(const AKey : TIdBytes) : TIdHMACIntCtx;
begin
  {$IFDEF OPENSSL_NO_SHA256}
  Result := nil;
  {$ELSE}
  Result := AllocMem(SizeOf(HMAC_CTX));
  HMAC_CTX_init(Result);
  HMAC_Init_ex(Result, PByte(AKey), Length(AKey), EVP_sha256, nil);
  {$ENDIF}
end;

function OpenSSLIsHMACSHA384Avail: Boolean;
begin
  {$IFDEF OPENSSL_NO_SHA512}
  Result := False;
  {$ELSE}
  Result := Assigned(EVP_sha384);
  {$ENDIF}
end;

function OpenSSLGetHMACSHA384Inst(const AKey : TIdBytes) : TIdHMACIntCtx;
begin
  {$IFDEF OPENSSL_NO_SHA512}
  Result := nil;
  {$ELSE}
  Result := AllocMem(SizeOf(HMAC_CTX));
  HMAC_CTX_init(Result);
  HMAC_Init_ex(Result, PByte(AKey), Length(AKey), EVP_sha384, nil);
  {$ENDIF}
end;

function OpenSSLIsHMACSHA512Avail: Boolean;
begin
  {$IFDEF OPENSSL_NO_SHA512}
  Result := False;
  {$ELSE}
  Result := Assigned(EVP_sha512);
  {$ENDIF}
end;

function OpenSSLGetHMACSHA512Inst(const AKey : TIdBytes) : TIdHMACIntCtx;
begin
  {$IFDEF OPENSSL_NO_SHA512}
  Result := nil;
  {$ELSE}
  Result := AllocMem(SizeOf(HMAC_CTX));
  HMAC_CTX_init(Result);
  HMAC_Init_ex(Result, PByte(AKey), Length(AKey), EVP_sha512, nil);
  {$ENDIF}
end;

procedure OpenSSLUpdateHMACInst(ACtx : TIdHMACIntCtx; const AIn: TIdBytes);
begin
  HMAC_Update(ACtx, PIdAnsiChar(PByte(AIn)), Length(AIn));
end;

function OpenSSLFinalHMACInst(ACtx: TIdHMACIntCtx): TIdBytes;
var
  LLen : TIdC_UInt;
begin
  LLen := EVP_MAX_MD_SIZE;
  SetLength(Result,LLen);
  HMAC_Final(ACtx, PIdAnsiChar(@Result[0]), @LLen);
  SetLength(Result,LLen);
  HMAC_CTX_cleanup(ACtx);
  FreeMem(ACtx,SizeOf(HMAC_CTX));
end;

//****************************************************
function FIPS_mode_set(onoff : TIdC_INT) : TIdC_INT;  {$IFDEF INLINE}inline;{$ENDIF}
begin
  Result := 0;
  {$IFDEF OPENSSL_FIPS}
  if Assigned(_FIPS_mode_set) then begin
    Result := _FIPS_mode_set(onoff);
  end;
  {$ENDIF}
end;

function FIPS_mode() : TIdC_INT;  {$IFDEF INLINE}inline;{$ENDIF}
begin
  Result := 0;
  {$IFDEF OPENSSL_FIPS}
  if Assigned(_FIPS_mode) then begin
    Result := _FIPS_mode;
  end;
  {$ENDIF}
end;

function GetErrorMessage(const AErr : TIdC_ULONG) : String;
{$IFDEF USE_INLINE} inline; {$ENDIF}
const
  sMaxErrMsg = 160;
var
  LErrMsg: array [0..sMaxErrMsg] of TIdAnsiChar;
  {$IFDEF USE_MARSHALLED_PTRS}
  LErrMsgPtr: TPtrWrapper;
  {$ENDIF}
begin
  {$IFDEF USE_MARSHALLED_PTRS}
  LErrMsgPtr := TPtrWrapper.Create(@LErrMsg[0]);
  {$ENDIF}
  ERR_error_string_n(AErr,
    {$IFDEF USE_MARSHALLED_PTRS}
    LErrMsgPtr.ToPointer
    {$ELSE}
    LErrMsg
    {$ENDIF}, sMaxErrMsg);
  LErrMsg[sMaxErrMsg] := TIdAnsiChar(0);
  {$IFDEF USE_MARSHALLED_PTRS}
  Result := TMarshal.ReadStringAsAnsi(LErrMsgPtr);
  {$ELSE}
  Result := String(LErrMsg);
  {$ENDIF}
end;

{ EIdOpenSSLAPICryptoError }
class procedure EIdOpenSSLAPICryptoError.RaiseException(const AMsg : String = '');
begin
  RaiseExceptionCode(ERR_get_error(), AMsg);
end;

class procedure EIdOpenSSLAPICryptoError.RaiseExceptionCode(
  const AErrCode: TIdC_ULONG; const AMsg: String);
var
  LMsg: String;
  LException : EIdOpenSSLAPICryptoError;
begin
  if AMsg <> '' then begin
    LMsg := AMsg + sLineBreak + String(GetErrorMessage(AErrCode));
  end else begin
    LMsg := String(GetErrorMessage(AErrCode));
  end;
  LException := Create(LMsg);
  LException.FErrorCode := AErrCode;
  raise LException;
end;

{ EIdOpenSSLAPISSLError }

class procedure EIdOpenSSLAPISSLError.RaiseException(ASSL: Pointer; const ARetCode: TIdC_INT;
  const AMsg: String);
begin
  RaiseExceptionCode(SSL_get_error(PSSL(ASSL), ARetCode), ARetCode, AMsg);
end;

class procedure EIdOpenSSLAPISSLError.RaiseExceptionCode(const AErrCode, ARetCode: TIdC_INT;
  const AMsg: String);
var
  LErrQueue : TIdC_ULONG;
  LException : EIdOpenSSLAPISSLError;
  LErrStr : String;
begin
  if AMsg <> '' then begin
    LErrStr := AMsg + sLineBreak;
  end else begin
    LErrStr := '';
  end;
  case AErrCode of
    SSL_ERROR_SYSCALL :
    begin
      LErrQueue := ERR_get_error;
      if LErrQueue <> 0 then begin
        EIdOSSLUnderlyingCryptoError.RaiseExceptionCode(LErrQueue, AMsg);
      end;
      if ARetCode = 0 then begin
        LException := Create(LErrStr + RSSSLEOFViolation);
        LException.FErrorCode := AErrCode;
        LException.FRetCode := ARetCode;
        raise LException;
      end;
      {Note that if LErrQueue returns 0 and ARetCode = -1, there probably
      is an error in the underlying socket so you should raise a socket error}
      if ARetCode = -1 then begin
        // TODO: catch the socket exception and re-raise it as the InnerException
        // for an EIdOpenSSLAPISSLError exception...
        GStack.RaiseLastSocketError;
      end;
    end;
    SSL_ERROR_SSL : begin
      EIdOSSLUnderlyingCryptoError.RaiseException(AMsg);
    end
  end;
  // everything else...
  LException := Create(LErrStr + String(GetErrorMessage(AErrCode)));
  LException.FErrorCode := AErrCode;
  LException.FRetCode := ARetCode;
  raise LException;
end;

type
  TRAND_bytes = function(buf : PIdAnsiChar; num : integer) : integer; cdecl;
  TRAND_pseudo_bytes = function(buf : PIdAnsiChar; num : integer) : integer; cdecl;
  TRAND_seed = procedure(buf : PIdAnsiChar; num : integer); cdecl;
  TRAND_add = procedure(buf : PIdAnsiChar; num : integer; entropy : integer); cdecl;
  TRAND_status = function() : integer; cdecl;
  {$IFDEF SYS_WIN}
  TRAND_event = function(iMsg : UINT; wp : wparam; lp : lparam) : integer; cdecl;
  {$ENDIF}
  TRAND_cleanup = procedure; cdecl;

{$IFDEF STATICLOAD_OPENSSL}
const
  SSL_LIB_name         = 'libssl.a'; {Do not Localize}
  SSLCLIB_LIB_name     = 'libcrypto.a'; {Do not Localize}
{$ELSE}
  {$IFDEF UNIX}
const
  {This is a workaround for some Linux distributions and a few other things
  where the symbolic link libbsl.so and libcrypto.so do not exist}
  SSL_DLL_name         = 'libssl'; {Do not localize}
  SSLCLIB_DLL_name     = 'libcrypto'; {Do not localize}
  SSLDLLVers : array [0..10] of string = (
    '.10',
    '.1.0.2','.1.0.1',
    // TODO: IFDEF the following for OSX only?
    '.44',              // MacOS LibreSSL forked from which OpenSSL version? Sometimes found ...
    '.43',              // MacOS LibreSSL forked from which OpenSSL version? Sometimes found ...
                        // TODO: Add '.41' as well?
    '.35',              // MacOS LibreSSL forked from OpenSSL version 1.0.1, almost always found
    //
    '.1.0.0','.0.9.9','.0.9.8','.0.9.7','.0.9.6'
  );
  SSLDLLVersChar : array [0..26] of string = ('','a','b','c','d','e','f','g','h','i',
                                                 'j','k','l','m','n','o','p','q','r',
                                                 's','t','u','v','w','x','y','z');
  {$ENDIF}
  {$IFDEF WINDOWS}
const
  SSL_DLL_name         = 'ssleay32.dll';  {Do not localize}
  //The following is a workaround for an alternative name for
  //one of the OpenSSL .DLL's.  If you compile the .DLL's using
  //mingw32, the SSL .dll might be named 'libssl32.dll' instead of
  //ssleay32.dll like you would expect.
  SSL_DLL_name_alt     = 'libssl32.dll';  {Do not localize}
  SSLCLIB_DLL_name     = 'libeay32.dll';  {Do not localize}
  {$ENDIF}
{$ENDIF}

var
  {$IFDEF STATICLOAD_OPENSSL}
  bIsLoaded : Boolean = False;
  {$ELSE}
  hIdSSL    : TIdLibHandle = IdNilHandle;
  hIdCrypto : TIdLibHandle = IdNilHandle;
  FFailedLoadList : TStringList;
  {$ENDIF}

  _RAND_cleanup : TRAND_cleanup = nil;
  _RAND_bytes : TRAND_bytes = nil;
  _RAND_pseudo_bytes : TRAND_pseudo_bytes = nil;
  _RAND_seed : TRAND_seed = nil;
  _RAND_add : TRAND_add = nil;
  _RAND_status : TRAND_status = nil;
  {$IFDEF SYS_WIN}
  // LIBEAY functions - open SSL 0.9.6a
  _RAND_screen : procedure cdecl = nil;
  _RAND_event : TRAND_event = nil;
  {$ENDIF}

{$IFNDEF STATICLOAD_OPENSSL}
function GetSSLLibHandle : TIdLibHandle;
begin
  Result := hIdSSL;
end;

function GetCryptLibHandle : TIdLibHandle;
begin
  Result := hIdCrypto;
end;

{ This constant's are used twice. First time in Load function and second time  }  {Do not localize}
{ in function WhichFailedToLoad. I belive that this reduce size of final       }
{ compiled file.                                                               }
const
{most of these are commented out because we aren't using them now.  I am keeping
them in case we use them later.}
  fn_sk_num = 'sk_num';   {Do not localize}
  fn_sk_value = 'sk_value';   {Do not localize}
  {CH fn_sk_set = 'sk_set'; }  {Do not localize}
  fn_sk_new = 'sk_new';   {Do not localize}
  fn_sk_new_null = 'sk_new_null'; {Do not localize}
  fn_sk_free = 'sk_free';   {Do not localize}
  fn_sk_pop_free = 'sk_pop_free';  {Do not localize}
  {CH fn_sk_insert = 'sk_insert'; }  {Do not localize}
  {CH fn_sk_delete = 'sk_delete'; }  {Do not localize}
  {CH fn_sk_delete_ptr = 'sk_delete_ptr'; }  {Do not localize}
  fn_sk_find = 'sk_find';  {Do not localize}
  fn_sk_push = 'sk_push';  {Do not localize}
  {CH fn_sk_unshift = 'sk_unshift'; }  {Do not localize}
  {CH fn_sk_shift = 'sk_shift'; }  {Do not localize}
  {CH fn_sk_pop = 'sk_pop'; }  {Do not localize}
  {CH fn_sk_zero = 'sk_zero'; }  {Do not localize}
  fn_sk_dup = 'sk_dup';  {Do not localize}
  {CH fn_sk_sort = 'sk_sort'; }  {Do not localize}
  fn_SSLeay_version = 'SSLeay_version';  {Do not localize}
  fn_SSLeay = 'SSLeay';   {Do not localize}
  {CH fn_OPENSSL_issetugid = 'OPENSSL_issetugid'; }{Do not localize}
  {CH fn_CONF_set_default_method = 'CONF_set_default_method'; } {Do not localize}
  {CH fn_CONF_set_nconf = 'CONF_set_nconf'; } {Do not localize}
  {CH fn_CONF_load = 'CONF_load'; } {Do not localize}
{$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_CONF_load_fp = 'CONF_load_fp'; } {Do not localize}
{$ENDIF}
  {CH fn_CONF_load_bio = 'CONF_load_bio'; } {Do not localize}
  {CH fn_CONF_get_section = 'CONF_get_section'; } {Do not localize}
  {CH fn_CONF_get_string = 'CONF_get_string'; } {Do not localize}
  {CH fn_CONF_get_number = 'CONF_get_number'; } {Do not localize}
  {CH fn_CONF_free = 'CONF_free'; }{Do not localize}
  {CH fn_CONF_dump_fp = 'CONF_dump_fp'; } {Do not localize}
  {CH fn_CONF_dump_bio = 'CONF_dump_bio'; } {Do not localize}
  {CH fn_NCONF_new = 'NCONF_new'; } {Do not localize}
  {CH fn_NCONF_default = 'NCONF_default'; } {Do not localize}
  {CH fn_NCONF_WIN32 = 'NCONF_WIN32'; } {Do not localize}
{$IFDEF OMIT_THIS} //* Just to give you an idea of what I have in mind */
  {CH fn_NCONF_XML = 'NCONF_XML''; } {Do not localize}
{$ENDIF}
  {CH fn_NCONF_free = 'NCONF_free'; } {Do not localize}
  {CH fn_NCONF_free_data = 'NCONF_free_data'; } {Do not localize}
  {CH fn_NCONF_load = 'NCONF_load'; } {Do not localize}
{$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_NCONF_load_fp = 'NCONF_load_fp'; }{Do not localize}
{$ENDIF}
  {CH fn_NCONF_load_bio = 'NCONF_load_bio'; {Do not localize}
  {CH fn_NCONF_get_section = 'NCONF_get_section'; {Do not localize}
  {CH fn_NCONF_get_string = 'NCONF_get_string'; {Do not localize}
  {CH fn_NCONF_get_number_e = 'NCONF_get_number_e'; {Do not localize}
  {CH fn_NCONF_dump_fp = 'NCONF_dump_fp'; } {Do not localize}
  {CH fn_NCONF_dump_bio = 'NCONF_dump_bio'; }{Do not localize}
  {CH fn_CONF_modules_load = 'CONF_modules_load'; } {Do not localize}
  {CH fn_CONF_modules_load_file = 'CONF_modules_load_file'; } {Do not localize}
  {CH fn_CONF_modules_unload = 'CONF_modules_unload'; } {Do not localize}
  {CH fn_CONF_modules_finish = 'CONF_modules_finish'; } {Do not localize}
  {CH fn_CONF_modules_free = 'CONF_modules_free'; } {Do not localize}
  {CH fn_CONF_module_add = 'CONF_module_add'; } {Do not localize}
  {CH fn_CONF_imodule_get_name = 'CONF_imodule_get_name'; } {Do not localize}
  {CH fn_CONF_imodule_get_value = 'CONF_imodule_get_value'; } {Do not localize}
  {CH fn_CONF_imodule_get_usr_data = 'CONF_imodule_get_usr_data'; } {Do not localize}
  {CH fn_CONF_imodule_set_usr_data = 'CONF_imodule_set_usr_data'; } {Do not localize}
  {CH fn_CONF_imodule_get_module = 'CONF_imodule_get_module'; } {Do not localize}
  {CH fn_CONF_imodule_get_flags = 'CONF_imodule_get_flags'; } {Do not localize}
  {CH fn_CONF_imodule_set_flags = 'CONF_imodule_set_flags'; } {Do not localize}
  {CH fn_CONF_module_get_usr_data = 'CONF_module_get_usr_data'; } {Do not localize}
  {CH fn_CONF_module_set_usr_data = 'CONF_module_set_usr_data'; } {Do not localize}
  {CH fn_ERR_load_CONF_strings = 'ERR_load_CONF_strings'; } {Do not localize}
  {CH fn_CONF_get1_default_config_file = 'CONF_get1_default_config_file'; } {Do not localize}
  {CH fn_CONF_parse_list = 'CONF_parse_list' ; }
  {CH fn_OPENSSL_load_builtin_modules = 'OPENSSL_load_builtin_modules'; } {Do not localize}
  {CH fn_CRYPTO_get_ex_new_index = 'CRYPTO_get_ex_new_index'; }  {Do not localize}
  {CH fn_CRYPTO_set_ex_data = 'CRYPTO_set_ex_data'; }  {Do not localize}
  {CH fn_CRYPTO_get_ex_data = 'CRYPTO_get_ex_data'; }  {Do not localize}
  {CH fn_CRYPTO_dup_ex_data = 'CRYPTO_dup_ex_data'; }  {Do not localize}
  {CH fn_CRYPTO_free_ex_data = 'CRYPTO_free_ex_data'; }  {Do not localize}
  {CH fn_CRYPTO_new_ex_data = 'CRYPTO_new_ex_data'; }  {Do not localize}
  fn_CRYPTO_mem_ctrl = 'CRYPTO_mem_ctrl';  {Do not localize}
  {CH fn_OPENSSL_issetugid = 'OPENSSL_issetugid'; } {Do not localize}
  {CH fn_CRYPTO_get_ex_data_implementation = 'CRYPTO_get_ex_data_implementation'; } {Do not localize}
  {CH fn_CRYPTO_set_ex_data_implementation = 'CRYPTO_set_ex_data_implementation'; } {Do not localize}
  {CH fn_CRYPTO_ex_data_new_class = 'CRYPTO_ex_data_new_class'; } {Do not localize}
  {CH fn_CRYPTO_get_locking_callback = 'CRYPTO_get_locking_callback'; } {Do not localize}
  {CH fn_CRYPTO_get_add_lock_callback = 'CRYPTO_get_add_lock_callback'; } {Do not localize}
  {CH fn_CRYPTO_get_new_dynlockid = 'CRYPTO_get_new_dynlockid'; } {Do not localize}
  {CH fn_CRYPTO_destroy_dynlockid = 'CRYPTO_destroy_dynlockid'; }  {Do not localize}
  {CH fn_CRYPTO_get_dynlock_value = 'CRYPTO_get_dynlock_value'; }  {Do not localize}
  {CH fn_CRYPTO_set_dynlock_create_callback = 'CRYPTO_set_dynlock_create_callback'; }  {Do not localize}
  {CH fn_CRYPTO_set_dynlock_lock_callback = 'CRYPTO_set_dynlock_lock_callback'; } {Do not localize}
  {CH fn_CRYPTO_set_dynlock_destroy_callback = 'CRYPTO_set_dynlock_destroy_callback'; } {Do not localize}
  {CH fn_CRYPTO_set_locked_mem_ex_functions = 'CRYPTO_set_locked_mem_ex_functions'; }  {Do not localize}
  {CH fn_CRYPTO_get_mem_ex_functions = 'CRYPTO_get_mem_ex_functions'; }  {Do not localize}
  {CH fn_CRYPTO_get_locked_mem_ex_functions = 'CRYPTO_get_locked_mem_ex_functions'; } {Do not localize}
  {CH fn_CRYPTO_get_mem_debug_functions = 'CRYPTO_get_mem_debug_functions'; }{Do not localize}
  {CH fn_CRYPTO_realloc_clean = 'CRYPTO_realloc_clean'; } {Do not localize}
  {CH fn_OPENSSL_cleanse = 'OPENSSL_cleanse'; } {Do not localize}
  {CH fn_CRYPTO_set_mem_debug_options = 'CRYPTO_set_mem_debug_options'; } {Do not localize}
  {CH fn_CRYPTO_get_mem_debug_options = 'CRYPTO_get_mem_debug_options'; } {Do not localize}
  {CH fn_CRYPTO_push_info_ = 'CRYPTO_push_info_'; } {Do not localize}
  {CH fn_CRYPTO_pop_info = 'CRYPTO_pop_info'; } {Do not localize}
  {CH fn_CRYPTO_remove_all_info = 'CRYPTO_remove_all_info'; } {Do not localize}
  {CH fn_OpenSSLDie = 'OpenSSLDie'; } {Do not localize}
  {CH fn_OPENSSL_ia32cap_loc = 'OPENSSL_ia32cap_loc'; { {Do not localize}
  {CH fn_CRYPTO_get_new_lockid = 'CRYPTO_get_new_lockid'; }  {Do not localize}
  fn_CRYPTO_num_locks = 'CRYPTO_num_locks';  {Do not localize}
  fn_CRYPTO_lock = 'CRYPTO_lock';   {Do not localize}
  fn_CRYPTO_set_locking_callback = 'CRYPTO_set_locking_callback';  {Do not localize}
  {CH fn_CRYPTO_set_add_lock_callback = 'CRYPTO_set_add_lock_callback'; }  {Do not localize}
  fn_CRYPTO_set_id_callback = 'CRYPTO_set_id_callback';  {Do not localize}
  {CH fn_CRYPTO_thread_id = 'CRYPTO_thread_id'; }  {Do not localize}
  {CH fn_CRYPTO_get_lock_name = 'CRYPTO_get_lock_name'; }  {Do not localize}
  {CH fn_CRYPTO_add_lock = 'CRYPTO_add_lock'; }  {Do not localize}
  {CH fn_int_CRYPTO_set_do_dynlock_callback = 'int_CRYPTO_set_do_dynlock_callback'; } {Do not localize}
  //OpenSSL 1.0.0 - use these instead of the depreciated CRYPTO_set_id_callback
  fn_CRYPTO_THREADID_set_numeric = 'CRYPTO_THREADID_set_numeric';  {Do not localize}
  fn_CRYPTO_THREADID_set_pointer = 'CRYPTO_THREADID_set_pointer';  {Do not localize}
  fn_CRYPTO_THREADID_set_callback = 'CRYPTO_THREADID_set_callback'; {Do not localize}
  //end section
  fn_CRYPTO_set_mem_functions = 'CRYPTO_set_mem_functions';  {Do not localize}
  {CH fn_CRYPTO_set_mem_info_functions = 'CRYPTO_set_mem_info_functions'; } {Do not localize}
  {CH fn_CRYPTO_get_mem_functions = 'CRYPTO_get_mem_functions'; }  {Do not localize}
  {CH fn_CRYPTO_set_locked_mem_functions = 'CRYPTO_set_locked_mem_functions'; }  {Do not localize}
  {CH fn_CRYPTO_get_locked_mem_functions = 'CRYPTO_get_locked_mem_functions'; }  {Do not localize}
  {CH fn_CRYPTO_malloc_locked = 'CRYPTO_malloc_locked'; }  {Do not localize}
  {CH fn_CRYPTO_free_locked = 'CRYPTO_free_locked'; }  {Do not localize}
  fn_CRYPTO_malloc = 'CRYPTO_malloc';  {Do not localize}
  fn_CRYPTO_free = 'CRYPTO_free';  {Do not localize}
  {CH fn_CRYPTO_realloc = 'CRYPTO_realloc'; }  {Do not localize}
  {CH fn_CRYPTO_remalloc = 'CRYPTO_remalloc'; }  {Do not localize}
  {CH fn_CRYPTO_dbg_malloc = 'CRYPTO_dbg_malloc'; }  {Do not localize}
  {CH fn_CRYPTO_dbg_realloc = 'CRYPTO_dbg_realloc'; }  {Do not localize}
  {CH fn_CRYPTO_dbg_free = 'CRYPTO_dbg_free'; }  {Do not localize}
  {CH fn_CRYPTO_dbg_remalloc = 'CRYPTO_dbg_remalloc'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_CRYPTO_mem_leaks_fp = 'CRYPTO_mem_leaks_fp'; }  {Do not localize}
  {$ENDIF}
  fn_CRYPTO_mem_leaks = 'CRYPTO_mem_leaks';  {Do not localize}
  {CH fn_CRYPTO_mem_leaks_cb = 'CRYPTO_mem_leaks_cb'; }  {Do not localize}
  fn_CRYPTO_cleanup_all_ex_data = 'CRYPTO_cleanup_all_ex_data'; {Do not localize}
  fn_CRYPTO_set_mem_debug_functions = 'CRYPTO_set_mem_debug_functions'; {Do not localize}
  {CH fn_CRYPTO_dbg_set_options = 'CRYPTO_dbg_set_options'; } {Do not localize}
  {CH fn_CRYPTO_dbg_get_options = 'CRYPTO_dbg_get_options'; } {Do not localize}
  {CH fn_CRYPTO_dbg_push_info = 'CRYPTO_dbg_push_info'; } {Do not localize}
  {CH fn_CRYPTO_dbg_pop_info = 'CRYPTO_dbg_pop_info'; } {Do not localize}
  {CH fn_CRYPTO_dbg_remove_all_info = 'CRYPTO_dbg_remove_all_info'; } {Do not localize}
  {CH fn_CRYPTO_memcmp = 'CRYPTO_memcmp'; } {Do not localize}
  fn_ERR_load_CRYPTO_strings = 'ERR_load_CRYPTO_strings';  {Do not localize}
  {CH fn_OPENSSL_init = 'OPENSSL_init';  } {Do not localize}
  {CH fn_lh_new = 'lh_new'; }  {Do not localize}
  {CH fn_lh_free = 'lh_free'; }  {Do not localize}
  {CH fn_lh_insert = 'lh_insert'; }  {Do not localize}
  {CH fn_lh_delete = 'lh_delete'; }  {Do not localize}
  {CH fn_lh_retrieve = 'lh_retrieve'; }  {Do not localize}
  {CH fn_lh_doall = 'lh_doall'; }  {Do not localize}
  {CH fn_lh_doall_arg = 'lh_doall_arg'; }  {Do not localize}
  {CH fn_lh_strhash = 'lh_strhash'; }  {Do not localize}
  {CH fn_lh_stats = 'lh_stats'; }  {Do not localize}
  {CH fn_lh_node_stats = 'lh_node_stats'; }  {Do not localize}
  {CH fn_lh_node_usage_stats = 'lh_node_usage_stats'; }  {Do not localize}
  {CH fn_BUF_MEM_new = 'BUF_MEM_new'; }  {Do not localize}
  {CH fn_BUF_MEM_free = 'BUF_MEM_free'; }  {Do not localize}
  {CH fn_BUF_MEM_grow = 'BUF_MEM_grow'; }  {Do not localize}
  {CH fn_BUF_strdup = 'BUF_strdup'; }  {Do not localize}
  {CH fn_ERR_load_BUF_strings = 'ERR_load_BUF_strings'; }  {Do not localize}
  {CH fn_BIO_ctrl_pending = 'BIO_ctrl_pending'; }  {Do not localize}
  {CH fn_BIO_ctrl_wpending = 'BIO_ctrl_wpending'; }  {Do not localize}
  {CH fn_BIO_ctrl_get_write_guarantee = 'BIO_ctrl_get_write_guarantee'; }  {Do not localize}
  {CH fn_BIO_ctrl_get_read_request = 'BIO_ctrl_get_read_request'; }  {Do not localize}
  fn_BIO_set_ex_data = 'BIO_set_ex_data';  {Do not localize}
  fn_BIO_get_ex_data = 'BIO_get_ex_data';  {Do not localize}
  {CH fn_BIO_get_ex_new_index = 'BIO_get_ex_new_index'; }  {Do not localize}
  fn_BIO_s_file = 'BIO_s_file';  {Do not localize}
  fn_BIO_new_file = 'BIO_new_file';  {Do not localize}
  {CH fn_BIO_new_fp = 'BIO_new_fp'; }  {Do not localize}
  fn_BIO_new = 'BIO_new';  {Do not localize}
  fn_BIO_set_flags = 'BIO_set_flags';  {Do not localize}
  fn_BIO_new_mem_buf = 'BIO_new_mem_buf'; {Do not localize}
  {CH fn_BIO_set = 'BIO_set'; }  {Do not localize}
  fn_BIO_free = 'BIO_free';  {Do not localize}
  fn_BIO_read = 'BIO_read';  {Do not localize}
  {CH fn_BIO_gets = 'BIO_gets'; }  {Do not localize}
  fn_BIO_write = 'BIO_write';  {Do not localize}
  fn_BIO_puts = 'BIO_puts';  {Do not localize}
  fn_BIO_ctrl = 'BIO_ctrl';  {Do not localize}
  fn_BIO_ptr_ctrl = 'BIO_ptr_ctrl';   {Do not localize}
  fn_BIO_int_ctrl = 'BIO_int_ctrl';  {Do not localize}
  fn_BIO_push = 'BIO_push';  {Do not localize}
  fn_BIO_pop = 'BIO_pop';  {Do not localize}
  fn_BIO_set_next = 'BIO_set_next';  {Do not localize}
  fn_BIO_free_all = 'BIO_free_all';  {Do not localize}
  {CH fn_BIO_find_type = 'BIO_find_type'; }  {Do not localize}
  {CH fn_BIO_get_retry_BIO = 'BIO_get_retry_BIO'; }  {Do not localize}
  {CH fn_BIO_get_retry_reason = 'BIO_get_retry_reason'; }  {Do not localize}
  {CH fn_BIO_dup_chain = 'BIO_dup_chain'; }  {Do not localize}
  {CH fn_BIO_debug_callback = 'BIO_debug_callback'; }  {Do not localize}

  fn_BIO_s_mem = 'BIO_s_mem';  {Do not localize}
  {CH fn_BIO_s_socket = 'BIO_s_socket'; }  {Do not localize}
  {CH fn_BIO_s_connect = 'BIO_s_connect'; }  {Do not localize}
  {CH fn_BIO_s_accept = 'BIO_s_accept'; }  {Do not localize}
  {CH fn_BIO_s_fd = 'BIO_s_fd'; }  {Do not localize}
  {CH fn_BIO_s_bio = 'BIO_s_bio'; }  {Do not localize}
  {CH fn_BIO_s_null = 'BIO_s_null'; }  {Do not localize}
  {CH fn_BIO_f_null = 'BIO_f_null'; }  {Do not localize}
  {CH fn_BIO_f_buffer = 'BIO_f_buffer'; }  {Do not localize}
  {CH fn_BIO_f_nbio_test = 'BIO_f_nbio_test'; }  {Do not localize}
  {CH fn_BIO_sock_should_retry = 'BIO_sock_should_retry'; }  {Do not localize}
  {CH fn_BIO_sock_non_fatal_error = 'BIO_sock_non_fatal_error'; }  {Do not localize}
  {CH fn_BIO_fd_should_retry = 'BIO_fd_should_retry'; }  {Do not localize}
  {CH fn_BIO_fd_non_fatal_error = 'BIO_fd_non_fatal_error'; }  {Do not localize}
  {CH fn_BIO_dump = 'BIO_dump'; }  {Do not localize}
  {CH fn_BIO_gethostbyname = 'BIO_gethostbyname'; }  {Do not localize}
  {CH fn_BIO_sock_error = 'BIO_sock_error'; }  {Do not localize}
  {CH fn_BIO_socket_ioctl = 'BIO_socket_ioctl'; }  {Do not localize}
  {CH fn_BIO_socket_nbio = 'BIO_socket_nbio'; }  {Do not localize}
  {CH fn_BIO_get_port = 'BIO_get_port'; }  {Do not localize}
  {CH fn_BIO_get_host_ip = 'BIO_get_host_ip'; }  {Do not localize}
  {CH fn_BIO_get_accept_socket = 'BIO_get_accept_socket'; }  {Do not localize}
  {CH fn_BIO_accept = 'BIO_accept'; }  {Do not localize}
  {CH fn_BIO_sock_init = 'BIO_sock_init'; }  {Do not localize}
  {CH fn_BIO_sock_cleanup = 'BIO_sock_cleanup'; }  {Do not localize}
  {CH fn_BIO_set_tcp_ndelay = 'BIO_set_tcp_ndelay'; }  {Do not localize}
  {CH fn_ERR_load_BIO_strings = 'ERR_load_BIO_strings'; }  {Do not localize}
  {CH fn_BIO_new_socket = 'BIO_new_socket'; }  {Do not localize}
  {CH fn_BIO_new_fd = 'BIO_new_fd'; }  {Do not localize}
  {CH fn_BIO_new_connect = 'BIO_new_connect'; }  {Do not localize}
  {CH fn_BIO_new_accept = 'BIO_new_accept'; }  {Do not localize}
  {CH fn_BIO_new_bio_pair = 'BIO_new_bio_pair'; }  {Do not localize}
  {CH fn_BIO_copy_next_retry = 'BIO_copy_next_retry'; }  {Do not localize}
  {CH fn_BIO_ghbn_ctrl = 'BIO_ghbn_ctrl'; }  {Do not localize}
  {CH fn_COMP_CTX_new = 'COMP_CTX_new';} {Do not localize}
  {CH fn_COMP_CTX_free = 'COMP_CTX_free'; } {Do not localize}
  {CH fn_COMP_compress_block = 'COMP_compress_block'; } {Do not localize}
  {CH fn_COMP_expand_block = 'COMP_expand_block'; } {Do not localize}
  {CH fn_COMP_rle = 'COMP_rle'; } {Do not localize}
  {CH fn_COMP_zlib = 'COMP_zlib'; } {Do not localize}
  {CH fn_COMP_zlib_cleanup = 'COMP_zlib_cleanup'; } {Do not localized}
  {$IFDEF HEADER_BIO_H}
    {$IFDEF ZLIB}
  {CH fn_BIO_f_zlib = 'BIO_f_zlib'; } {Do not localize}
    {$ENDIF}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MD2}
  {CH fn_MD2_options = 'MD2_options'; }  {Do not localize}
    {$IFDEF OPENSSL_FIPS}
  {CH fn_private_MD2_Init = 'private_MD2_Init'; } {Do not localize}
    {$ENDIF}
  {CH fn_MD2_Init = 'MD2_Init'; }  {Do not localize}
  {CH fn_MD2_Update = 'MD2_Update'; }  {Do not localize}
  {CH fn_MD2_Final = 'MD2_Final'; }  {Do not localize}
  {CH fn_MD2 = 'MD2'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MD4}
    {$IFDEF OPENSSL_FIPS}
  {CH fn_private_MD4_Init = 'private_MD4_Init'; } {Do not localize}
    {$ENDIF}
  {CH fn_MD4_Init = 'MD4_Init'; } {Do not localize}
  {CH fn_MD4_Update = 'MD4_Update'; } {Do not localize}
  {CH fn_MD4_Final = 'MD4_Final'; } {Do not localize}
  {CH fn_MD4 = 'MD4'; } {Do not localize}
  {CH fn_MD4_Transform = 'MD4_Transform'; } {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MD5}
    {$IFDEF OPENSSL_FIPS}
  {CH fn_private_MD5_Init = 'private_MD5_Init'; } {Do not localize}
    {$ENDIF}
  {CH fn_MD5_Init = 'MD5_Init'; }  {Do not localize}
  {CH fn_MD5_Update = 'MD5_Update'; }  {Do not localize}
  {CH fn_MD5_Final = 'MD5_Final'; }  {Do not localize}
  {CH fn_MD5 = 'MD5'; }  {Do not localize}
  {CH fn_MD5_Transform = 'MD5_Transform'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_SHA}
    {$IFNDEF OPENSSL_NO_SHA0}
      {$IFDEF OPENSSL_FIPS}
  {CH fn_private_SHA_Init = 'private_SHA_Init'; } {Do not localize}
      {$ENDIF}
  {CH fn_SHA_Init = 'SHA_Init'; }  {Do not localize}
  {CH fn_SHA_Update = 'SHA_Update'; }  {Do not localize}
  {CH fn_SHA_Final = 'SHA_Final'; }  {Do not localize}
  {CH fn_SHA = 'SHA'; }  {Do not localize}
  {CH fn_SHA_Transform = 'SHA_Transform'; }  {Do not localize}
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_SHA1}
  {CH fn_SHA1_Init = 'SHA1_Init'; }  {Do not localize}
  {CH fn_SHA1_Update = 'SHA1_Update'; }  {Do not localize}
  {CH fn_SHA1_Final = 'SHA1_Final'; }  {Do not localize}
  {CH fn_SHA1 = 'SHA1'; }  {Do not localize}
  {CH fn_SHA1_Transform = 'SHA1_Transform'; }  {Do not localize}
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_SHA256}
  {CH fn_SHA224_Init = 'SHA224_Init'; } {Do not localize}
  {CH fn_SHA224_Update = 'SHA224_Update'; } {Do not localize}
  {CH fn_SHA224_Final = 'SHA224_Final'; } {Do not localize}
  {CH fn_SHA224 = 'SHA224'; } {Do not localize}
  {CH fn_SHA256_Init = 'SHA256_Init'; } {Do not localize}
  {CH fn_SHA256_Update = 'SHA256_Update'; } {Do not localize}
  {CH fn_SHA256_Final = 'SHA256_Final'; } {Do not localize}
  {CH fn_SHA256 = 'SHA256'; } {Do not localize}
  {CH fn_SHA256_Transform = 'SHA256_Transform'; } {Do not localize}
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_SHA512}
  {CH fn_SHA384_Init = 'SHA384_Init'; } {Do not localize}
  {CH fn_SHA384_Update = 'SHA384_Update'; } {Do not localize}
  {CH fn_SHA384_Final = 'SHA384_Final'; } {Do not localize}
  {CH fn_SHA384 = 'SHA384'; } {Do not localize}
  {CH fn_SHA512_Init = 'SHA512_Init'; } {Do not localize}
  {CH fn_SHA512_Update = 'SHA512_Update'; } {Do not localize}
  {CH fn_SHA512_Final = 'SHA512_Final'; } {Do not localize}
  {CH fn_SHA512 = 'SHA512'; } {Do not localize}
  {CH fn_SHA512_Transform = 'SHA512_Transform'; } {Do not localize}
    {$ENDIF}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RIPEMD}
    {$IFDEF OPENSSL_FIPS}
  {CH fn_private_RIPEMD160_Init = 'private_RIPEMD160_Init'; } {Do not localize}
     {$ENDIF}
  {CH fn_RIPEMD160_Init = 'RIPEMD160_Init'; }  {Do not localize}
  {CH fn_RIPEMD160_Update = 'RIPEMD160_Update'; }  {Do not localize}
  {CH fn_RIPEMD160_Final = 'RIPEMD160_Final'; }  {Do not localize}
  {CH fn_RIPEMD160 = 'RIPEMD160'; }  {Do not localize}
  {CH fn_RIPEMD160_Transform = 'RIPEMD160_Transform'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_HMAC}
  fn_HMAC_CTX_init = 'HMAC_CTX_init';  {Do not localize}
  fn_HMAC_CTX_cleanup = 'HMAC_CTX_cleanup';  {Do not localize}
  {CH fn_HMAC_Init = 'HMAC_Init'; } {Do not localize}
  fn_HMAC_Init_ex = 'HMAC_Init_ex';  {Do not localize}
  fn_HMAC_Update = 'HMAC_Update';  {Do not localize}
  fn_HMAC_Final = 'HMAC_Final';  {Do not localize}
  {CH fn_HMAC = 'HMAC'; } {Do not localize}
  {CH fn_HMAC_CTX_set_flags = 'HMAC_CTX_set_flags'; } {Do not localize}
  {$ENDIF}
  {$IFNDEF HEADER_TMDIFF_H}
  {CH fn_ms_time_new = 'ms_time_new'; } {Do not localize}
  {CH fn_ms_time_free = 'ms_time_free'; } {Do not localize}
  {CH fn_ms_time_get = 'ms_time_get'; } {Do not localize}
  {CH fn_ms_time_diff = 'ms_time_diff'; } {Do not localize}
  {CH fn_ms_time_cmp = 'ms_time_cmp'; } {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_AES}
  {CH fn_AES_options = 'AES_options'; }{Do not localize}
  {CH fn_AES_set_encrypt_key = 'AES_set_encrypt_key'; }{Do not localize}
  {CH fn_AES_set_decrypt_key = 'AES_set_decrypt_key'; }{Do not localize}
  {CH fn_AES_encrypt = 'AES_encrypt'; }{Do not localize}
  {CH fn_AES_decrypt = 'AES_decrypt'; } {Do not localize}
  {CH fn_AES_ecb_encrypt = 'AES_ecb_encrypt'; } {Do not localize}
  {CH fn_AES_cbc_encrypt = 'AES_cbc_encrypt'; } {Do not localize}
  {CH fn_AES_cfb128_encrypt = 'AES_cfb128_encrypt'; } {Do not localize}
  {CH fn_AES_cfb1_encrypt = 'AES_cfb1_encrypt'; } {Do not localize}
  {CH fn_AES_cfb8_encrypt = 'AES_cfb8_encrypt'; } {Do not localize}
  {CH fn_AES_cfbr_encrypt_block = 'AES_cfbr_encrypt_block'; } {Do not localize}
  {CH fn_AES_ofb128_encrypt = 'AES_ofb128_encrypt'; } {Do not localize}
  {CH fn_AES_ctr128_encrypt = 'AES_ctr128_encrypt'; } {Do not localize}
  {CH fn_AES_ige_encrypt = 'AES_ige_encrypt'; } {Do not localize}
  {CH fn_AES_bi_ige_encrypt = 'AES_bi_ige_encrypt'; } {Do not localize}
  {CH fn_AES_wrap_key = 'AES_wrap_key'; } {Do not localize}
  {CH fn_AES_unwrap_key = 'AES_unwrap_key'; } {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_DES}
  {CH fn_des_options = 'DES_options'; }  {Do not localize}
  {CH fn_des_ecb3_encrypt = 'DES_ecb3_encrypt'; }  {Do not localize}
  {CH fn_des_cbc_cksum = 'DES_cbc_cksum'; }  {Do not localize}
  {CH fn_des_cbc_encrypt = 'DES_cbc_encrypt'; }  {Do not localize}
  {CH fn_des_ncbc_encrypt = 'DES_ncbc_encrypt'; }  {Do not localize}
  {CH fn_des_xcbc_encrypt = 'DES_xcbc_encrypt'; }  {Do not localize}
  {CH fn_des_cfb_encrypt = 'DES_cfb_encrypt'; }  {Do not localize}
  fn_des_ecb_encrypt = 'DES_ecb_encrypt';  {Do not localize}
  fnold_des_ecb_encrypt = 'DES_ecb_encrypt'; {Do not localize}
  {CH fn_des_encrypt = 'DES_encrypt'; }  {Do not localize}
  {CH fn_des_encrypt2 = 'DES_encrypt2'; }  {Do not localize}
  {CH fn_des_encrypt3 = 'DES_encrypt3'; }  {Do not localize}
  {CH fn_des_decrypt3 = 'DES_decrypt3'; }  {Do not localize}
  {CH fn_des_ede3_cbc_encrypt = 'DES_ede3_cbc_encrypt'; }  {Do not localize}
  {CH fn_des_ede3_cbcm_encrypt = 'DES_ede3_cbcm_encrypt'; }  {Do not localize}
  {CH fn_des_ede3_cfb64_encrypt = 'DES_ede3_cfb64_encrypt'; }  {Do not localize}
  {CH fn_des_ede3_ofb64_encrypt = 'DES_ede3_ofb64_encrypt'; }  {Do not localize}
  {$IFDEF USE_THIS}
  {CH fn_des_xwhite_in2out = 'DES_xwhite_in2out'; }  {Do not localize}
  {$ENDIF}
  {CH fn_des_enc_read = 'DES_enc_read'; }  {Do not localize}
  {CH fn_des_enc_write = 'DES_enc_write'; }  {Do not localize}
  {CH fn_des_fcrypt = 'DES_fcrypt'; }  {Do not localize}
  {CH fn_crypt = 'crypt'; }  {Do not localize}
  {CH fn_des_ofb_encrypt = 'DES_ofb_encrypt'; }  {Do not localize}
  {CH fn_des_pcbc_encrypt = 'DES_pcbc_encrypt'; }  {Do not localize}
  {CH fn_des_quad_cksum = 'DES_quad_cksum'; }  {Do not localize}
  {CH fn_des_random_seed = 'DES_random_seed'; }  {Do not localize}
  {CH fn_des_random_key = 'DES_random_key'; }  {Do not localize}
  {CH fn_des_read_password = 'DES_read_password'; }  {Do not localize}
  {CH fn_des_read_2passwords = 'DES_read_2passwords'; }  {Do not localize}
  {CH fn_des_read_pw_string = 'DES_read_pw_string'; }  {Do not localize}
  fn_des_set_odd_parity = 'DES_set_odd_parity';  {Do not localize}
  fnold_des_set_odd_parity = 'DES_set_odd_parity';  {Do not localize}
  {CH fn_des_is_weak_key = 'DES_is_weak_key'; }  {Do not localize}
  fn_des_set_key = 'DES_set_key';  {Do not localize}
  fnold_des_set_key = '_ossl_old_des_set_key'; {Do not localize}
  {CH fn_des_key_sched = 'DES_key_sched'; }  {Do not localize}
  {CH fn_des_string_to_key = 'DES_string_to_key'; }  {Do not localize}
  {CH fn_des_string_to_2keys = 'DES_string_to_2keys'; }  {Do not localize}
  {CH fn_des_cfb64_encrypt = 'DES_cfb64_encrypt'; }  {Do not localize}
  {CH fn_des_ofb64_encrypt = 'DES_ofb64_encrypt'; }  {Do not localize}
  {CH fn_des_read_pw = 'DES_read_pw'; }  {Do not localize}
  {CH fn_des_cblock_print_file = 'DES_cblock_print_file'; }  {Do not localize}
   //des_old.h
  {CH fn__ossl_old_des_options = '_ossl_old_des_options'; {Do not localize}
  {CH fn__ossl_old_des_ecb3_encrypt = '_ossl_old_des_ecb3_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_cbc_cksum = '_ossl_old_des_cbc_cksum'; {Do not localize}
  {CH fn__ossl_old_des_cbc_encrypt = '_ossl_old_des_cbc_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_ncbc_encrypt = '_ossl_old_des_ncbc_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_xcbc_encrypt = '_ossl_old_des_xcbc_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_cfb_encrypt = '_ossl_old_des_cfb_encrypt'; {Do not localize}
  fn__ossl_old_des_ecb_encrypt = '_ossl_old_des_ecb_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_encrypt = '_ossl_old_des_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_encrypt2 = '_ossl_old_des_encrypt2'; {Do not localize}
  {CH fn__ossl_old_des_encrypt3 = '_ossl_old_des_encrypt3'; {Do not localize}
  {CH fn__ossl_old_des_decrypt3 = '_ossl_old_des_decrypt3'; {Do not localize}
  {CH fn__ossl_old_des_ede3_cbc_encrypt = '_ossl_old_des_ede3_cbc_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_ede3_cfb64_encrypt = '_ossl_old_des_ede3_cfb64_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_ede3_ofb64_encrypt = '_ossl_old_des_ede3_ofb64_encrypt'; {Do not localize}
    {$IFDEF USE_THIS}
  {CH fn__ossl_old_des_xwhite_in2out = '_ossl_old_des_xwhite_in2out'; {Do not localize}
    {$ENDIF}
  {CH fn__ossl_old_des_enc_read = '_ossl_old_des_enc_read'; {Do not localize}
  {CH fn__ossl_old_des_enc_write = '_ossl_old_des_enc_write'; {Do not localize}
  {CH fn__ossl_old_des_fcrypt = '_ossl_old_des_fcrypt'; {Do not localize}
  {CH fn__ossl_old_des_crypt = '_ossl_old_des_crypt'; {Do not localize}
    {$IFNDEF PERL5}
      {$IFNDEF NeXT}
  {CH fn__ossl_old_crypt = '_ossl_old_crypt'; {Do not localize}
      {$ENDIF}
    {$ENDIF}
  {CH fn__ossl_old_des_ofb_encrypt = '_ossl_old_des_ofb_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_pcbc_encrypt = '_ossl_old_des_pcbc_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_quad_cksum = '_ossl_old_des_quad_cksum'; {Do not localize}
  {CH fn__ossl_old_des_random_seed = '_ossl_old_des_random_seed'; {Do not localize}
  {CH fn__ossl_old_des_random_key = '_ossl_old_des_random_key'; {Do not localize}
  {CH fn__ossl_old_des_read_password = '_ossl_old_des_read_password'; {Do not localize}
  {CH fn__ossl_old_des_read_2passwords = '_ossl_old_des_read_2passwords'; {Do not localize}
  fn__ossl_old_des_set_odd_parity = '_ossl_old_des_set_odd_parity'; {Do not localize}
  {CH fn__ossl_old_des_is_weak_key = '_ossl_old_des_is_weak_key'; {Do not localize}
  fn__ossl_old_des_set_key = '_ossl_old_des_set_key'; {Do not localize}
  {CH fn__ossl_old_des_key_sched = '_ossl_old_des_key_sched'; {Do not localize}
  {CH fn__ossl_old_des_string_to_key = '_ossl_old_des_string_to_key'; {Do not localize}
  {CH fn__ossl_old_des_string_to_2keys = '_ossl_old_des_string_to_2keys'; {Do not localize}
  {CH fn__ossl_old_des_cfb64_encrypt = '_ossl_old_des_cfb64_encrypt'; {Do not localize}
  {CH fn__ossl_old_des_ofb64_encrypt = '_ossl_old_des_ofb64_encrypt'; {Do not localize}
  {CH fn__ossl_096_des_random_seed = '_ossl_096_des_random_seed'; {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RC4}
  {CH fn_RC4_options = 'RC4_options'; } {Do not localize}
    {$IFDEF OPENSSL_FIPS}
  {CH private_RC4_set_key = 'private_RC4_set_key'; } {Do not localize}
    {$ENDIF}
  {CH fn_RC4_set_key = 'RC4_set_key'; }  {Do not localize}
  {CH fn_RC4 = 'RC4'; } {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RC2}
    {$IFDEF OPENSSL_FIPS}
  {CH fn_private_RC2_set_key = 'private_RC2_set_key'; } {Do not localize}
    {$ENDIF}
  {CH fn_RC2_set_key = 'RC2_set_key'; }  {Do not localize}
  {CH fn_RC2_ecb_encrypt = 'RC2_ecb_encrypt'; }  {Do not localize}
  {CH fn_RC2_encrypt = 'RC2_encrypt'; }  {Do not localize}
  {CH fn_RC2_decrypt = 'RC2_decrypt'; }  {Do not localize}
  {CH fn_RC2_cbc_encrypt = 'RC2_cbc_encrypt'; }  {Do not localize}
  {CH fn_RC2_cfb64_encrypt = 'RC2_cfb64_encrypt'; }  {Do not localize}
  {CH fn_RC2_ofb64_encrypt = 'RC2_ofb64_encrypt'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RC5}
  {CH fn_RC5_32_set_key = 'RC5_32_set_key'; }  {Do not localize}
  {CH fn_RC5_32_ecb_encrypt = 'RC5_32_ecb_encrypt'; }  {Do not localize}
  {CH fn_RC5_32_encrypt = 'RC5_32_encrypt'; }  {Do not localize}
  {CH fn_RC5_32_decrypt = 'RC5_32_decrypt'; }  {Do not localize}
  {CH fn_RC5_32_cbc_encrypt = 'RC5_32_cbc_encrypt'; }  {Do not localize}
  {CH fn_RC5_32_cfb64_encrypt = 'RC5_32_cfb64_encrypt'; }  {Do not localize}
  {CH fn_RC5_32_ofb64_encrypt = 'RC5_32_ofb64_encrypt'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_BF}
    {$IFDEF FIPS}
  {CH fn_private_BF_set_key = 'private_BF_set_key'; } {Do not localize}
    {$ENDIF}
  {CH fn_BF_set_key = 'BF_set_key'; }  {Do not localize}
  {CH fn_BF_ecb_encrypt = 'BF_ecb_encrypt'; }  {Do not localize}
  {CH fn_BF_encrypt = 'BF_encrypt'; }  {Do not localize}
  {CH fn_BF_decrypt = 'BF_decrypt'; }  {Do not localize}
  {CH fn_BF_cbc_encrypt = 'BF_cbc_encrypt'; }  {Do not localize}
  {CH fn_BF_cfb64_encrypt = 'BF_cfb64_encrypt'; }  {Do not localize}
  {CH fn_BF_ofb64_encrypt = 'BF_ofb64_encrypt'; }  {Do not localize}
  {CH fn_BF_options = 'BF_options'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_CAST}
     {$IFDEF OPENSSL_FIPS}
  {CH fn_private_CAST_set_key = 'private_CAST_set_key';  } {Do not localize}
     {$ENDIF}
  {CH fn_CAST_set_key = 'CAST_set_key'; }  {Do not localize}
  {CH fn_CAST_ecb_encrypt = 'CAST_ecb_encrypt'; }  {Do not localize}
  {CH fn_CAST_encrypt = 'CAST_encrypt'; }  {Do not localize}
  {CH fn_CAST_decrypt = 'CAST_decrypt'; }  {Do not localize}
  {CH fn_CAST_cbc_encrypt = 'CAST_cbc_encrypt'; }  {Do not localize}
  {CH fn_CAST_cfb64_encrypt = 'CAST_cfb64_encrypt'; }  {Do not localize}
  {CH fn_CAST_ofb64_encrypt = 'CAST_ofb64_encrypt'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_IDEA}
  {CH fn_idea_options = 'idea_options'; }  {Do not localize}
  {CH fn_idea_ecb_encrypt = 'idea_ecb_encrypt'; }  {Do not localize}
  {CH fn_idea_set_encrypt_key = 'idea_set_encrypt_key'; }  {Do not localize}
  {CH fn_idea_set_decrypt_key = 'idea_set_decrypt_key'; }  {Do not localize}
  {CH fn_idea_cbc_encrypt = 'idea_cbc_encrypt'; }  {Do not localize}
  {CH fn_idea_cfb64_encrypt = 'idea_cfb64_encrypt'; }  {Do not localize}
  {CH fn_idea_ofb64_encrypt = 'idea_ofb64_encrypt'; }  {Do not localize}
  {CH fn_idea_encrypt = 'idea_encrypt'; }  {Do not localize}
    {$IFDEF OPENSSL_FIPS}
  {CH fn_private_idea_set_encrypt_key = 'private_idea_set_encrypt_key'; } {Do not localize}
    {$ENDIF}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MD2}
  {CH fn_MDC2_Init = 'MDC2_Init'; }  {Do not localize}
  {CH fn_MDC2_Update = 'MDC2_Update'; }  {Do not localize}
  {CH fn_MDC2_Final = 'MDC2_Final'; }  {Do not localize}
  {CH fn_MDC2 = 'MDC2'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RSA}
  fn_RSA_new = 'RSA_new';   {Do not localize}
  {CH fn_RSA_new_method = 'RSA_new_method'; }  {Do not localize}
  fn_RSA_size = 'RSA_size';  {Do not localize}
  fn_RSA_generate_key = 'RSA_generate_key';  {Do not localize}
  fn_RSA_generate_key_ex = 'RSA_generate_key_ex';  {Do not localize}
  {CH fn_RSA_X931_derive_ex = 'RSA_X931_derive_ex'; } {Do not localize}
  {CH fn_RSA_X931_generate_key_ex = 'RSA_X931_generate_key_ex'; } {Do not localize}
  fn_RSA_check_key = 'RSA_check_key';  {Do not localize}
  fn_RSA_public_encrypt = 'RSA_public_encrypt';   {Do not localize}
  {CH fn_RSA_private_encrypt = 'RSA_private_encrypt'; }  {Do not localize}
  {CH fn_RSA_public_decrypt = 'RSA_public_decrypt'; }  {Do not localize}
  fn_RSA_private_decrypt = 'RSA_private_decrypt';   {Do not localize}
  fn_RSA_free = 'RSA_free';  {Do not localize}
  {CH fn_RSA_flags = 'RSA_flags'; }  {Do not localize}
  {$IFDEF OPENSSL_FIPS}
  {CH fn_FIPS_rsa_new = 'FIPS_rsa_new'; } {Do not localize}
  {CH fn_FIPS_rsa_free = 'FIPS_rsa_free'; } {Do not localize}
  {$ENDIF}
  {CH fn_RSA_set_default_method = 'RSA_set_default_method'; }  {Do not localize}
  {CH fn_RSA_get_default_method = 'RSA_get_default_method'; }  {Do not localize}
  {CH fn_RSA_get_method = 'RSA_get_method'; }  {Do not localize}
  {CH fn_RSA_set_method = 'RSA_set_method'; }  {Do not localize}
  {CH fn_RSA_memory_lock = 'RSA_memory_lock'; }  {Do not localize}
  {CH fn_RSA_PKCS1_SSLeay = 'RSA_PKCS1_SSLeay'; }  {Do not localize}
  {CH fn_ERR_load_RSA_strings = 'ERR_load_RSA_strings'; }  {Do not localize}
  fn_d2i_RSAPublicKey = 'd2i_RSAPublicKey';   {Do not localize}
  fn_i2d_RSAPublicKey = 'i2d_RSAPublicKey';   {Do not localize}
  fn_d2i_RSAPrivateKey = 'd2i_RSAPrivateKey';   {Do not localize}
  fn_i2d_RSAPrivateKey = 'i2d_RSAPrivateKey';   {Do not localize}
    {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_RSA_print_fp = 'RSA_print_fp'; }  {Do not localize}
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_BIO}
  {CH fn_RSA_print = 'RSA_print'; }  {Do not localize}
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_RC4}
  {CH fn_i2d_RSA_NET = 'i2d_RSA_NET'; }{Do not localize}
  {CH fn_d2i_RSA_NET = 'd2i_RSA_NET'; }{Do not localize}
  {CH fn_i2d_Netscape_RSA = 'i2d_Netscape_RSA'; }  {Do not localize}
  {CH fn_d2i_Netscape_RSA = 'd2i_Netscape_RSA'; }  {Do not localize}
    {$ENDIF}
  {CH fn_d2i_Netscape_RSA_2 = 'd2i_Netscape_RSA_2'; }  {Do not localize}
  {CH fn_RSA_sign = 'RSA_sign'; }  {Do not localize}
  {CH fn_RSA_verify = 'RSA_verify'; }  {Do not localize}
  {CH fn_RSA_sign_ASN1_OCTET_STRING = 'RSA_sign_ASN1_OCTET_STRING'; }  {Do not localize}
  {CH fn_RSA_verify_ASN1_OCTET_STRING = 'RSA_verify_ASN1_OCTET_STRING'; }  {Do not localize}
  {CH fn_RSA_blinding_on = 'RSA_blinding_on'; }  {Do not localize}
  {CH fn_RSA_blinding_off = 'RSA_blinding_off'; }  {Do not localize}
  {CH fn_RSA_padding_add_PKCS1_type_1 = 'RSA_padding_add_PKCS1_type_1'; }  {Do not localize}
  {CH fn_RSA_padding_check_PKCS1_type_1 = 'RSA_padding_check_PKCS1_type_1'; }  {Do not localize}
  {CH fn_RSA_padding_add_PKCS1_type_2 = 'RSA_padding_add_PKCS1_type_2'; }  {Do not localize}
  {CH fn_RSA_padding_check_PKCS1_type_2 = 'RSA_padding_check_PKCS1_type_2'; }  {Do not localize}
  {CH fn_RSA_padding_add_PKCS1_OAEP = 'RSA_padding_add_PKCS1_OAEP'; }  {Do not localize}
  {CH fn_RSA_padding_check_PKCS1_OAEP = 'RSA_padding_check_PKCS1_OAEP'; }  {Do not localize}
  {CH fn_RSA_padding_add_SSLv23 = 'RSA_padding_add_SSLv23'; }  {Do not localize}
  {CH fn_RSA_padding_check_SSLv23 = 'RSA_padding_check_SSLv23'; }  {Do not localize}
  {CH fn_RSA_padding_add_none = 'RSA_padding_add_none'; }  {Do not localize}
  {CH fn_RSA_padding_check_none = 'RSA_padding_check_none'; }  {Do not localize}
  {CH fn_RSA_get_ex_new_index = 'RSA_get_ex_new_index'; }  {Do not localize}
  {CH fn_RSA_set_ex_data = 'RSA_set_ex_data'; }  {Do not localize}
  {CH fn_RSA_get_ex_data = 'RSA_get_ex_data'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_DH}
  {CH fn_DH_OpenSSL = 'DH_OpenSSL'; } {Do not localize}
  {CH fn_DH_set_default_method = 'DH_set_default_method'; } {Do not localize}
  {CH fn_DH_set_method = 'DH_set_method'; } {Do not localize}
  {CH fn_DH_new_method = 'DH_new_method'; } {Do not localize}
  {CH fn_DH_new = 'DH_new'; }  {Do not localize}
  {CH fn_DH_up_ref = 'DH_up_ref'; } {Do not localize}
  fn_DH_free = 'DH_free';   {Do not localize}
  {CH fn_DH_size = 'DH_size'; }  {Do not localize}
    {$IFNDEF OPENSSL_NO_DEPRECATED}
  {CH fn_DH_generate_parameters = 'DH_generate_parameters'; }  {Do not localize}
    {$ENDIF}
  {CH fn_DH_generate_parameters_ex = 'DH_generate_parameters_ex'; } {Do not localize}
  {CH fn_DH_get_ex_new_index = 'DH_get_ex_new_index'; } {Do not localize}
  {CH fn_DH_set_ex_data = 'DH_set_ex_data'; } {Do not localize}
  {CH fn_DH_get_ex_data = 'DH_get_ex_data'; } {Do not localize}
  {CH fn_DH_check = 'DH_check'; }  {Do not localize}
  {CH fn_DH_check_pub_key = 'DH_check_pub_key'; } {Do not localize}
  {CH fn_DH_generate_key = 'DH_generate_key'; }  {Do not localize}
  {CH fn_DH_compute_key = 'DH_compute_key'; }  {Do not localize}
  fn_d2i_DHparams = 'd2i_DHparams';   {Do not localize}
  fn_i2d_DHparams = 'i2d_DHparams';   {Do not localize}
  {CH fn_DH_OpenSSL = 'DH_OpenSSL'; } {Do not localize}
  {$IFDEF OPENSSL_FIPS}
  {CH fn_FIPS_dh_new = 'FIPS_dh_new'; } {Do not localize}
  {CH fn_FIPS_dh_free = 'FIPS_dh_free'; } {Do not localize}
  {$ENDIF}
    {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_DHparams_print_fp = 'DHparams_print_fp'; }  {Do not localize}
    {$ENDIF}
  {CH fn_DHparams_print = 'DHparams_print'; }  {Do not localize}
  {$ENDIF}
  {CH fn_ERR_load_DH_strings = 'ERR_load_DH_strings'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_DSA}
  {CH fn_DSA_SIG_new = 'DSA_SIG_new'; }  {Do not localize}
  {CH fn_DSA_SIG_free = 'DSA_SIG_free'; }  {Do not localize}
  {CH fn_i2d_DSA_SIG = 'i2d_DSA_SIG'; }  {Do not localize}
  {CH fn_d2i_DSA_SIG = 'd2i_DSA_SIG'; }  {Do not localize}
  {CH fn_DSA_do_sign = 'DSA_do_sign'; }  {Do not localize}
  {CH fn_DSA_do_verify = 'DSA_do_verify'; }  {Do not localize}
    {$IFDEF OPENSSL_FIPS}
  {CH fn_FIPS_dsa_new = 'FIPS_dsa_new'; } {Do not localize}
  {CH fn_FIPS_dsa_free = 'FIPS_dsa_free'; } {Co not localize}
    {$ENDIF}
  {CH fn_DSA_new = 'DSA_new'; }  {Do not localize}
  {CH fn_DSA_size = 'DSA_size'; }  {Do not localize}
  {CH fn_DSA_sign_setup = 'DSA_sign_setup'; }  {Do not localize}
  {CH fn_DSA_sign = 'DSA_sign'; }  {Do not localize}
  {CH fn_DSA_verify = 'DSA_verify'; }  {Do not localize}
  {CH fn_DSA_free = 'DSA_free'; }  {Do not localize}
  {CH fn_ERR_load_DSA_strings = 'ERR_load_DSA_strings'; }  {Do not localize}

    {$IFNDEF OPENSSL_NO_DEPRECATED}
  {CH fn_DSA_generate_parameters = 'DSA_generate_parameters'; }  {Do not localize}
    {$ENDIF}
  {CH fn_DSA_generate_parameters_ex = 'DSA_generate_parameters_ex'; } {Do not localize}
  {CH fn_DSA_generate_key = 'DSA_generate_key'; }  {Do not localize}
   fn_d2i_DSAPublicKey = 'd2i_DSAPublicKey';  {Do not localize}
   fn_i2d_DSAPublicKey = 'i2d_DSAPublicKey';   {Do not localize}
   fn_d2i_DSAPrivateKey = 'd2i_DSAPrivateKey';   {Do not localize}
  fn_i2d_DSAPrivateKey = 'i2d_DSAPrivateKey';   {Do not localize}
  fn_i2d_DSAparams = 'i2d_DSAparams';   {Do not localize}
  fn_d2i_DSAparams = 'd2i_DSAparams';   {Do not localize}
    {$IFNDEF OPENSSL_NO_BIO}
  {CH fn_DSAparams_print = 'DSAparams_print'; }  {Do not localize}
  {CH fn_DSA_print = 'DSA_print'; }  {Do not localize}
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_DSAparams_print_fp = 'DSAparams_print_fp'; }  {Do not localize}
  {CH fn_DSA_print_fp = 'DSA_print_fp'; }  {Do not localize}
    {$ENDIF}
  {CH fn_DSA_is_prime = 'DSA_is_prime'; }  {Do not localize}
    {$IFNDEF OPENSSL_NO_DH}
  {CH fn_DSA_dup_DH = 'DSA_dup_DH'; }  {Do not localize}
    {$ENDIF}
    {$IFDEF OPENSSL_FIPS}
  {CH fn_FIPS_dsa_sig_encode = 'FIPS_dsa_sig_encode'; } {Do not localize}
  {CH fn_FIPS_dsa_sig_decode = 'FIPS_dsa_sig_decode'; } {Do not localize}
    {$ENDIF}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_EC}
  {CH fn_EC_GFp_simple_method = 'EC_GFp_simple_method'; } {Do not localize}
  {CH fn_EC_GFp_mont_method = 'EC_GFp_mont_method'; } {Do not localize}
  {CH fn_EC_GFp_nist_method = 'EC_GFp_nist_method'; } {Do not localize}
  {CH fn_EC_GF2m_simple_method = 'EC_GF2m_simple_method'; } {Do not localize}
  {CH fn_EC_GROUP_new = 'EC_GROUP_new'; } {Do not localize}
  {CH fn_EC_GROUP_free = 'EC_GROUP_free'; } {Do not localize}
  {CH fn_EC_GROUP_clear_free = 'EC_GROUP_clear_free'; } {Do not localize}
  {CH fn_EC_GROUP_copy = 'EC_GROUP_copy'; } {Do not localize}
  {CH fn_EC_GROUP_dup = 'EC_GROUP_dup'; } {Do not localize}
  {CH fn_EC_GROUP_method_of = 'EC_GROUP_method_of'; } {Do not localize}
  {CH fn_EC_METHOD_get_field_type = 'EC_METHOD_get_field_type'; } {Do not localize}
  {CH fn_EC_GROUP_set_generator = 'EC_GROUP_set_generator'; } {Do not localize}
  {CH fn_EC_GROUP_get0_generator = 'EC_GROUP_get0_generator'; } {Do not localize}
  {CH fn_EC_GROUP_get_order = 'EC_GROUP_get_order'; } {Do not localize}
  {CH fn_EC_GROUP_get_cofactor = 'EC_GROUP_get_cofactor'; } {Do not localize}
  {CH fn_EC_GROUP_set_curve_name ='EC_GROUP_set_curve_name'; } {Do not localize}
  {CH fn_EC_GROUP_get_curve_name = 'EC_GROUP_get_curve_name'; } {Do not localize}
  {CH fn_EC_GROUP_set_asn1_flag = 'EC_GROUP_set_asn1_flag'; } {Do not localize}
  {CH fn_EC_GROUP_get_asn1_flag = 'EC_GROUP_get_asn1_flag'; } {Do not localize}
  {CH fn_EC_GROUP_set_point_conversion_form = 'EC_GROUP_set_point_conversion_form'; } {Do not localize}
  {CH fn_EC_GROUP_get_point_conversion_form = 'EC_GROUP_get_point_conversion_form'; } {Do not localize}
  {CH fn_EC_GROUP_get0_seed = 'EC_GROUP_get0_seed'; } {Do not localize}
  {CH fn_EC_GROUP_get_seed_len = 'EC_GROUP_get_seed_len'; } {Do not localize}
  {CH fn_EC_GROUP_set_seed = 'EC_GROUP_set_seed'; } {Do not localize}
  {CH fn_EC_GROUP_set_curve_GFp = 'EC_GROUP_set_curve_GFp'; } {Do not localize}
  {CH fn_EC_GROUP_get_curve_GFp = 'EC_GROUP_get_curve_GFp'; } {Do not localize}
  {CH fn_EC_GROUP_set_curve_GF2m = 'EC_GROUP_set_curve_GF2m'; } {Do not localize}
  {CH fn_EC_GROUP_get_curve_GF2m = 'EC_GROUP_get_curve_GF2m'; } {Do not localize}
  {CH fn_EC_GROUP_get_degree = 'EC_GROUP_get_degree'; } {Do not localize}
  {CH fn_EC_GROUP_check = 'EC_GROUP_check'; } {Do not localize}
  {CH fn_EC_GROUP_check_discriminant = 'EC_GROUP_check_discriminant'; } {Do not localize}
  {CH fn_EC_GROUP_cmp = 'EC_GROUP_cmp'; } {Do not localize}
  {CH fn_EC_GROUP_new_curve_GFp = 'EC_GROUP_new_curve_GFp'; } {Do not localize}
  {CH fn_EC_GROUP_new_curve_GF2m = 'EC_GROUP_new_curve_GF2m'; } {Do not localize}
  {CH fn_EC_GROUP_new_by_curve_name = 'EC_GROUP_new_by_curve_name'; } {Do not localize}
  {CH fn_EC_get_builtin_curves = 'EC_get_builtin_curves'; } {Do not localize}
  {CH fn_EC_POINT_new = 'EC_POINT_new'; } {Do not localize}
  {CH fn_EC_POINT_free  = 'EC_POINT_free'; } {Do not localize}
  {CH fn_EC_POINT_clear_free  = 'EC_POINT_clear_free'; } {Do not localize}
  {CH fn_EC_POINT_copy = 'EC_POINT_copy'; } {Do not localize}
  {CH fn_EC_POINT_dup = 'EC_POINT_dup'; } {Do not localize}
  {CH fn_EC_POINT_method_of = 'EC_POINT_method_of'; } {Do not localize}
  {CH fn_EC_POINT_set_to_infinity = 'EC_POINT_set_to_infinity'; } {Do not localize}
  {CH fn_EC_POINT_set_Jprojective_coordinates_GFp = 'EC_POINT_set_Jprojective_coordinates_GFp'; } {Do not localize}
  {CH fn_EC_POINT_get_Jprojective_coordinates_GFp = 'EC_POINT_get_Jprojective_coordinates_GFp'; } {Do not localize}
  {CH fn_EC_POINT_set_affine_coordinates_GFp = 'EC_POINT_set_affine_coordinates_GFp'; } {Do not localize}
  {CH fn_EC_POINT_get_affine_coordinates_GFp = 'EC_POINT_get_affine_coordinates_GFp'; } {Do not localize}
  {CH fn_EC_POINT_set_compressed_coordinates_GFp = 'EC_POINT_set_compressed_coordinates_GFp'; } {Do not localize}
  {CH fn_EC_POINT_set_affine_coordinates_GF2m = 'EC_POINT_set_affine_coordinates_GF2m'; } {Do not localize}
  {CH fn_EC_POINT_set_compressed_coordinates_GF2m = 'EC_POINT_set_compressed_coordinates_GF2m'; } {Do not localize}
  {CH fn_EC_POINT_point2oct = 'EC_POINT_point2oct'; } {Do not localize}
  {CH fn_EC_POINT_oct2point = 'EC_POINT_oct2point'; } {Do not localize}
  {CH fn_EC_POINT_point2bn = 'EC_POINT_point2bn'; } {Do not localize}
  {CH fn_EC_POINT_bn2point = 'EC_POINT_bn2point'; } {Do not localize}
  {CH fn_EC_POINT_point2hex = 'EC_POINT_point2hex'; } {Do not localize}
  {CH fn_EC_POINT_hex2point = 'EC_POINT_hex2point'; } {Do not localize}
  {CH fn_EC_POINT_add = 'EC_POINT_add'; } {Do not localize}
  {CH fn_EC_POINT_dbl = 'EC_POINT_dbl'; } {Do not localize}
  {CH fn_EC_POINT_invert = 'EC_POINT_invert'; } {Do not localize}
  {CH fn_EC_POINT_is_at_infinity = 'EC_POINT_is_at_infinity'; } {Do not localize}
  {CH fn_EC_POINT_is_on_curve = 'EC_POINT_is_on_curve'; } {Do not localize}
  {CH fn_EC_POINT_cmp = 'EC_POINT_cmp'; } {Do not localize}
  {CH fn_EC_POINT_make_affine = 'EC_POINT_make_affine'; } {Do not localize}
  {CH fn_EC_POINTs_make_affine = 'EC_POINTs_make_affine'; } {Do not localize}
  {CH fn_EC_POINTs_mul = 'EC_POINTs_mul'; } {Do not localize}
  {CH fn_EC_POINT_mul = 'EC_POINT_mul'; } {Do not localize}
  {CH fn_EC_GROUP_precompute_mult = 'EC_GROUP_precompute_mult'; } {Do not localize}
  {CH fn_EC_GROUP_have_precompute_mult = 'EC_GROUP_have_precompute_mult'; } {Do not localize}
  {CH fn_EC_GROUP_get_basis_type = 'EC_GROUP_get_basis_type'; } {Do not localize}
  {CH fn_EC_GROUP_get_trinomial_basis = 'EC_GROUP_get_trinomial_basis'; } {Do not localize}
  {CH fn_EC_GROUP_get_pentanomial_basis = 'EC_GROUP_get_pentanomial_basis'; } {Do not localize}
  {CH fn_d2i_ECPKParameters = 'd2i_ECPKParameters'; } {Do not localize}
  {CH fn_i2d_ECPKParameters = 'i2d_ECPKParameters'; } {Do not localize}
    {$IFNDEF OPENSSL_NO_BIO}
  {CH fn_ECPKParameters_print = 'ECPKParameters_print'; } {Do not localize}
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_ECPKParameters_print_fp = 'ECPKParameters_print_fp'; }  {Do not localize}
    {$ENDIF}
  {CH fn_EC_KEY_new = 'EC_KEY_new'; } {Do not localize}
  {CH fn_EC_KEY_new_by_curve_name = 'EC_KEY_new_by_curve_name'; } {Do not localize}
  {CH fn_EC_KEY_free = 'EC_KEY_free'; } {Do not localize}
  {CH fn_EC_KEY_copy = 'EC_KEY_copy'; } {Do not localize}
  {CH fn_EC_KEY_dup = 'EC_KEY_dup'; } {Do not localize}
  {CH fn_EC_KEY_up_ref = 'EC_KEY_up_ref'; } {Do not localize}
  {CH fn_EC_KEY_get0_group = 'EC_KEY_get0_group'; } {Do not localize}
  {CH fn_EC_KEY_set_group = 'EC_KEY_set_group'; } {Do not localize}
  {CH fn_EC_KEY_get0_private_key = 'EC_KEY_get0_private_key'; } {Do not localize}
  {CH fn_EC_KEY_set_private_key = 'EC_KEY_set_private_key'; } {Do not localize}
  {CH fn_EC_KEY_get0_public_key = 'EC_KEY_get0_public_key'; } {Do not localize}
  {CH fn_EC_KEY_set_public_key = 'EC_KEY_set_public_key'; } {Do not localize}
  {CH fn_EC_KEY_get_enc_flags = 'EC_KEY_get_enc_flags'; } {Do not localize}
  {CH fn_EC_KEY_set_enc_flags = 'EC_KEY_set_enc_flags'; } {Do not localize}
  {CH fn_EC_KEY_get_conv_form = 'EC_KEY_get_conv_form'; } {Do not localize}
  {CH fn_EC_KEY_set_conv_form = 'EC_KEY_set_conv_form'; } {Do not localize}
  {CH fn_EC_KEY_get_key_method_data = 'EC_KEY_get_key_method_data'; } {Do not localize}
  {CH fn_EC_KEY_insert_key_method_data = 'EC_KEY_insert_key_method_data'; } {Do not localize}
  {CH fn_EC_KEY_set_asn1_flag = 'EC_KEY_set_asn1_flag'; } {Do not localize}
  {CH fn_EC_KEY_precompute_mult = 'EC_KEY_precompute_mult'; } {Do not localize}
  {CH fn_EC_KEY_generate_key  = 'EC_KEY_generate_key'; } {Do not localize}
  {CH fn_EC_KEY_check_key = 'EC_KEY_check_key'; } {Do not localize}
  {CH fn_d2i_ECPrivateKey = 'd2i_ECPrivateKey'; } {Do not localize}
  {CH fn_i2d_ECPrivateKey = 'i2d_ECPrivateKey'; } {Do not localize}
  {CH fn_d2i_ECParameters = 'd2i_ECParameters'; } {Do not localize}
  {CH fn_i2d_ECParameters = 'i2d_ECParameters'; } {Do not localize}
  {CH fn_o2i_ECPublicKey = 'o2i_ECPublicKey'; } {Do not localize}
  {CH fn_i2o_ECPublicKey = 'i2o_ECPublicKey'; } {Do not localize}
    {$IFNDEF OPENSSL_NO_BIO}
  {CH fn_ECParameters_print = 'ECParameters_print'; } {Do not localize}
  {CH fn_EC_KEY_print = 'EC_KEY_print'; } {Do not localize}
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_ECParameters_print_fp = 'ECParameters_print_fp'; } {Do not localize}
  {CH fn_EC_KEY_print_fp = 'EC_KEY_print_fp'; } {Do not localize}
    {$ENDIF}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_ECDSA}
  {CH fn_ECDSA_SIG_new = 'ECDSA_SIG_new'; } {Do not localize}
  {CH fn_ECDSA_SIG_free = 'ECDSA_SIG_free'; } {Do not localize}
  {CH fn_i2d_ECDSA_SIG = 'i2d_ECDSA_SIG'; } {Do not localize}
  {CH fn_d2i_ECDSA_SIG = 'd2i_ECDSA_SIG'; } {Do not localize}
  {CH fn_ECDSA_do_sign = 'ECDSA_do_sign'; } {Do not localize}
  {CH fn_ECDSA_do_sign_ex = 'ECDSA_do_sign_ex'; } {Do not localize}
  {CH fn_ECDSA_do_verify = 'ECDSA_do_verify'; } {Do not localize}
  {CH fn_ECDSA_OpenSSL = 'ECDSA_OpenSSL'; } {Do not localize}
  {CH fn_ECDSA_set_default_method = 'ECDSA_set_default_method'; } {Do not localize}
  {CH fn_ECDSA_get_default_method = 'ECDSA_get_default_method'; } {Do not localize}
  {CH fn_ECDSA_set_method = 'ECDSA_set_method'; } {Do not localize}
  {CH fn_ECDSA_size = 'ECDSA_size'; } {Do not localize}
  {CH fn_ECDSA_sign_setup = 'ECDSA_sign_setup'; } {Do not localize}
  {CH fn_ECDSA_sign = 'ECDSA_sign'; } {Do not localize}
  {CH fn_ECDSA_sign_ex = 'ECDSA_sign_ex'; } {Do not localize}
  {CH fn_ECDSA_verify = 'ECDSA_verify'; } {Do not localize}
  {CH fn_ECDSA_get_ex_new_index = 'ECDSA_get_ex_new_index'; } {Do not localize}
  {CH fn_ECDSA_set_ex_data = 'ECDSA_set_ex_data'; } {Do not localize}
  {CH fn_ECDSA_get_ex_data = 'ECDSA_get_ex_data'; } {Do not localize}
  {CH fn_ERR_load_ECDSA_strings = 'ERR_load_ECDSA_strings'; } {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_ECDH}
  {CH fn_ECDH_OpenSSL = 'ECDH_OpenSSL'; } {Do not localize}
  {CH fn_ECDH_set_default_method = 'ECDH_set_default_method'; } {Do not localize}
  {CH fn_ECDH_get_default_method = 'ECDH_get_default_method'; } {Do not localize}
  {CH fn_ECDH_set_method = 'ECDH_set_method'; } {Do not localize}
  {CH fn_ECDH_compute_key = 'ECDH_compute_key'; } {Do not localize}
  {CH fn_ECDH_get_ex_new_index = 'ECDH_get_ex_new_index'; } {Do not localize}
  {CH fn_ECDH_set_ex_data = 'ECDH_set_ex_data'; } {Do not localize}
  {CH fn_ECDH_get_ex_data = 'ECDH_get_ex_data'; } {Do not localize}
  {CH fn_ERR_load_ECDH_strings = 'ERR_load_ECDH_strings'; } {Do not localize}
  {$ENDIF}
  {CH fn_BN_value_one = 'BN_value_one'; }  {Do not localize}
  {CH fn_BN_options = 'BN_options'; }  {Do not localize}
  {CH fn_BN_CTX_new = 'BN_CTX_new'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_DEPRECATED}
  {CH fn_BN_CTX_init = 'BN_CTX_init'; }  {Do not localize}
  {$ENDIF}
  {CH fn_BN_CTX_free = 'BN_CTX_free'; }  {Do not localize}
  {CH fn_BN_rand = 'BN_rand'; }  {Do not localize}
  {CH fn_BN_pseudo_rand = 'BN_pseudo_rand';  } {Do not localize}
  {CH fn_BN_rand_range = 'BN_rand_range';  } {Do not localize}
  {CH fn_BN_pseudo_rand_range = 'BN_pseudo_rand_range';  } {Do not localize}
  {CH fn_BN_num_bits = 'BN_num_bits'; }  {Do not localize}
  {CH fn_BN_num_bits_word = 'BN_num_bits_word'; }  {Do not localize}
  fn_BN_new = 'BN_new';   {Do not localize}
  {CH fn_BN_init = 'BN_init'; }  {Do not localize}
  {CH fn_BN_clear_free = 'BN_clear_free'; }  {Do not localize}
  {CH fn_BN_copy = 'BN_copy'; }  {Do not localize}
  {CH fn_BN_bin2bn = 'BN_bin2bn'; } {Do not localize}
  {CH fn_BN_bn2bin = 'BN_bn2bin'; }  {Do not localize}
  {CH fn_BN_mpi2bn = 'BN_mpi2bn'; }  {Do not localize}
  {CH fn_BN_bn2mpi = 'BN_bn2mpi'; }  {Do not localize}
  {CH fn_BN_sub = 'BN_sub'; }  {Do not localize}
  {CH fn_BN_usub = 'BN_usub'; }  {Do not localize}
  {CH fn_BN_uadd = 'BN_uadd'; }  {Do not localize}
  {CH fn_BN_add = 'BN_add'; }  {Do not localize}
  {CH fn_BN_mod = 'BN_mod'; }  {Do not localize}
  {CH fn_BN_div = 'BN_div'; }  {Do not localize}
  {CH fn_BN_mul = 'BN_mul'; }  {Do not localize}
  {CH fn_BN_sqr = 'BN_sqr'; }  {Do not localize}
  {CH fn_BN_mod_word = 'BN_mod_word'; }  {Do not localize}
  {CH fn_BN_div_word = 'BN_div_word'; }  {Do not localize}
  {CH fn_BN_mul_word = 'BN_mul_word'; }  {Do not localize}
  {CH fn_BN_add_word = 'BN_add_word'; }  {Do not localize}
  {CH fn_BN_sub_word = 'BN_sub_word'; }  {Do not localize}
  fn_BN_set_word = 'BN_set_word';   {Do not localize}
  {CH fn_BN_get_word = 'BN_get_word'; }  {Do not localize}
  {CH fn_BN_cmp = 'BN_cmp'; }  {Do not localize}
  fn_BN_free = 'BN_free';   {Do not localize}
  {CH fn_BN_is_bit_set = 'BN_is_bit_set'; }  {Do not localize}
  {CH fn_BN_lshift = 'BN_lshift'; }  {Do not localize}
  {CH fn_BN_lshift1 = 'BN_lshift1'; }  {Do not localize}
  {CH fn_BN_exp = 'BN_exp'; }  {Do not localize}
  {CH fn_BN_mod_exp = 'BN_mod_exp'; }  {Do not localize}
  {CH fn_BN_mod_exp_mont = 'BN_mod_exp_mont'; }  {Do not localize}
  {CH fn_BN_mod_exp2_mont = 'BN_mod_exp2_mont'; }  {Do not localize}
  {CH fn_BN_mod_exp_simple = 'BN_mod_exp_simple'; }  {Do not localize}
  {CH fn_BN_mask_bits = 'BN_mask_bits'; }  {Do not localize}
  {CH fn_BN_mod_mul = 'BN_mod_mul'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_BN_print_fp = 'BN_print_fp'; }  {Do not localize}
  {$ENDIF}
  {CH fn_BN_print = 'BN_print'; }  {Do not localize}
  {CH fn_BN_reciprocal = 'BN_reciprocal'; }  {Do not localize}
  {CH fn_BN_rshift = 'BN_rshift'; }  {Do not localize}
  {CH fn_BN_rshift1 = 'BN_rshift1'; }  {Do not localize}
  {CH fn_BN_clear = 'BN_clear'; }  {Do not localize}
  {CH fn_bn_expand2 = 'bn_expand2'; }  {Do not localize}
  {CH fn_BN_dup = 'BN_dup'; }  {Do not localize}
  {CH fn_BN_ucmp = 'BN_ucmp'; }  {Do not localize}
  {CH fn_BN_set_bit = 'BN_set_bit'; }  {Do not localize}
  {CH fn_BN_clear_bit = 'BN_clear_bit'; }  {Do not localize}
  fn_BN_bn2hex = 'BN_bn2hex';   {Do not localize}
  fn_BN_bn2dec = 'BN_bn2dec';   {Do not localize}
  fn_BN_hex2bn = 'BN_hex2bn';   {Do not localize}
  {CH fn_BN_dec2bn = 'BN_dec2bn'; }  {Do not localize}
  {CH fn_BN_gcd = 'BN_gcd'; }  {Do not localize}
  {CH fn_BN_mod_inverse = 'BN_mod_inverse'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_DEPRECATED}
  {CH fn_BN_generate_prime = 'BN_generate_prime'; }  {Do not localize}
  {CH fn_BN_is_prime = 'BN_is_prime'; }  {Do not localize}
  {CH fn_BN_is_prime_fasttest = 'BN_is_prime_fasttest'; } {Do not localize}
  {$ENDIF}
  {CH fn_ERR_load_BN_strings = 'ERR_load_BN_strings'; }  {Do not localize}
  {CH fn_bn_mul_add_words = 'bn_mul_add_words'; }  {Do not localize}
  {CH fn_bn_mul_words = 'bn_mul_words'; }  {Do not localize}
  {CH fn_bn_sqr_words = 'bn_sqr_words'; }  {Do not localize}
  {CH fn_bn_div_words = 'bn_div_words'; }  {Do not localize}
  {CH fn_bn_add_words = 'bn_add_words'; }  {Do not localize}
  {CH fn_bn_sub_words = 'bn_sub_words'; }  {Do not localize}
  {CH fn_BN_MONT_CTX_new = 'BN_MONT_CTX_new'; }  {Do not localize}
  {CH fn_BN_MONT_CTX_init = 'BN_MONT_CTX_init'; }  {Do not localize}
  {CH fn_BN_mod_mul_montgomery = 'BN_mod_mul_montgomery'; }  {Do not localize}
  {CH fn_BN_from_montgomery = 'BN_from_montgomery'; }  {Do not localize}
  {CH fn_BN_MONT_CTX_free = 'BN_MONT_CTX_free'; }  {Do not localize}
  {CH fn_BN_MONT_CTX_set = 'BN_MONT_CTX_set'; }  {Do not localize}
  {CH fn_BN_MONT_CTX_copy = 'BN_MONT_CTX_copy'; }  {Do not localize}
  {CH fn_BN_BLINDING_new = 'BN_BLINDING_new'; }  {Do not localize}
  {CH fn_BN_BLINDING_free = 'BN_BLINDING_free'; }  {Do not localize}
  {CH fn_BN_BLINDING_update = 'BN_BLINDING_update'; }  {Do not localize}
  {CH fn_BN_BLINDING_convert = 'BN_BLINDING_convert'; }  {Do not localize}
  {CH fn_BN_BLINDING_invert = 'BN_BLINDING_invert'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_DEPRECATED}
  {CH fn_BN_set_params = 'BN_set_params'; }  {Do not localize}
  {CH fn_BN_get_params = 'BN_get_params'; }  {Do not localize}
  {$ENDIF}
  {CH fn_BN_RECP_CTX_init = 'BN_RECP_CTX_init'; }  {Do not localize}
  {CH fn_BN_RECP_CTX_new = 'BN_RECP_CTX_new'; }  {Do not localize}
  {CH fn_BN_RECP_CTX_free = 'BN_RECP_CTX_free'; }  {Do not localize}
  {CH fn_BN_RECP_CTX_set = 'BN_RECP_CTX_set'; }  {Do not localize}
  {CH fn_BN_mod_mul_reciprocal = 'BN_mod_mul_reciprocal'; }  {Do not localize}
  {CH fn_BN_mod_exp_recp = 'BN_mod_exp_recp'; }  {Do not localize}

  {CH fn_BN_div_recp = 'BN_div_recp'; }  {Do not localize}
  {CH fn_BN_GF2m_add = 'BN_GF2m_add'; } {Do not localize}
  {CH fn_BN_GF2m_mod = 'BN_GF2m_mod'; } {Do not localize}
  {CH fn_BN_GF2m_mod_mul = 'BN_GF2m_mod_mul'; } {Do not localize}
  {CH fn_BN_GF2m_mod_sqr = 'BN_GF2m_mod_sqr'; } {Do not localize}
  {CH fn_BN_GF2m_mod_inv = 'BN_GF2m_mod_inv'; } {Do not localize}
  {CH fn_BN_GF2m_mod_div = 'BN_GF2m_mod_div'; } {Do not localize}
  {CH fn_BN_GF2m_mod_exp = 'BN_GF2m_mod_exp'; } {Do not localize}
  {CH fn_BN_GF2m_mod_sqrt = 'BN_GF2m_mod_sqrt'; } {Do not localize}
  {CH fn_BN_GF2m_mod_solve_quad = 'BN_GF2m_mod_solve_quad'; } {Do not localize}
  {CH fn_BN_GF2m_mod_arr = 'BN_GF2m_mod_arr'; } {Do not localize}
  {CH fn_BN_GF2m_mod_mul_arr = 'BN_GF2m_mod_mul_arr'; } {Do not localize}
  {CH fn_BN_GF2m_mod_sqr_arr = 'BN_GF2m_mod_sqr_arr'; } {Do not localize}
  {CH fn_BN_GF2m_mod_inv_arr = 'BN_GF2m_mod_inv_arr'; } {Do not localize}
  {CH fn_BN_GF2m_mod_div_arr = 'BN_GF2m_mod_div_arr'; } {Do not localize}
  {CH fn_BN_GF2m_mod_exp_arr = 'BN_GF2m_mod_exp_arr'; } {Do not localize}
  {CH fn_BN_GF2m_mod_sqrt_arr = 'BN_GF2m_mod_sqrt_arr'; } {Do not localize}
  {CH fn_BN_GF2m_mod_solve_quad_arr = 'BN_GF2m_mod_solve_quad_arr'; } {Do not localize}
  {CH fn_BN_GF2m_poly2arr = 'BN_GF2m_poly2arr'; } {Do not localize}
  {CH fn_BN_GF2m_arr2poly = 'BN_GF2m_arr2poly'; } {Do not localize}
  // faster mod functions for the 'NIST primes'
  // 0 <= a < p^2
  {CH fn_BN_nist_mod_192 = 'BN_nist_mod_192'; } {Do not localize}
  {CH fn_BN_nist_mod_224 = 'BN_nist_mod_224'; } {Do not localize}
  {CH fn_BN_nist_mod_256 = 'BN_nist_mod_256'; } {Do not localize}
  {CH fn_BN_nist_mod_384 = 'BN_nist_mod_384'; } {Do not localize}
  {CH fn_BN_nist_mod_521 = 'BN_nist_mod_521'; } {Do not localize}
  {CH fn_BN_get0_nist_prime_192 = 'BN_get0_nist_prime_192'; } {Do not localize}
  {CH fn_BN_get0_nist_prime_224 = 'BN_get0_nist_prime_224'; } {Do not localize}
  {CH fn_BN_get0_nist_prime_256 = 'BN_get0_nist_prime_256'; } {Do not localize}
  {CH fn_BN_get0_nist_prime_384 = 'BN_get0_nist_prime_384'; } {Do not localize}
  {CH fn_BN_get0_nist_prime_521 = 'BN_get0_nist_prime_521'; } {Do not localize}
  //
  {CH fn_get_rfc2409_prime_768 = 'get_rfc2409_prime_768'; } {Do not localize}
  {CH fn_get_rfc2409_prime_1024 = 'get_rfc2409_prime_1024'; } {Do not localize}
  {CH fn_get_rfc3526_prime_1536 = 'get_rfc3526_prime_1536'; } {Do not localize}
  {CH fn_get_rfc3526_prime_2048 = 'get_rfc3526_prime_2048'; } {Do not localize}
  {CH fn_get_rfc3526_prime_3072 = 'get_rfc3526_prime_3072'; } {Do not localize}
  {CH fn_get_rfc3526_prime_4096 = 'get_rfc3526_prime_4096'; } {Do not localize}
  {CH fn_get_rfc3526_prime_6144 = 'get_rfc3526_prime_6144'; } {Do not localize}
  {CH fn_get_rfc3526_prime_8192 = 'get_rfc3526_prime_8192'; } {Do not localize}
  {CH fn_BN_bntest_rand = 'BN_bntest_rand'; } {Do not localize}
  {CH fn_sk_ASN1_TYPE_new = 'sk_ASN1_TYPE_new'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_new_null = 'sk_ASN1_TYPE_new_null'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_free = 'sk_ASN1_TYPE_free'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_num = 'sk_ASN1_TYPE_num'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_value = 'sk_ASN1_TYPE_value'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_set = 'sk_ASN1_TYPE_set'; }  {Do not localize}
  {CH fn_ASN1_TYPE_set1 = 'ASN1_TYPE_set1'; } {Do not localize}
  {CH fn_sk_ASN1_TYPE_zero = 'sk_ASN1_TYPE_zero'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_push = 'sk_ASN1_TYPE_push'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_unshift = 'sk_ASN1_TYPE_unshift'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_find = 'sk_ASN1_TYPE_find'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_delete = 'sk_ASN1_TYPE_delete'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_delete_ptr = 'sk_ASN1_TYPE_delete_ptr'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_insert = 'sk_ASN1_TYPE_insert'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_dup = 'sk_ASN1_TYPE_dup'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_pop_free = 'sk_ASN1_TYPE_pop_free'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_shift = 'sk_ASN1_TYPE_shift'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_pop = 'sk_ASN1_TYPE_pop'; }  {Do not localize}
  {CH fn_sk_ASN1_TYPE_sort = 'sk_ASN1_TYPE_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_ASN1_TYPE = 'i2d_ASN1_SET_OF_ASN1_TYPE'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_ASN1_TYPE = 'd2i_ASN1_SET_OF_ASN1_TYPE'; }  {Do not localize}
  {CH fn_ASN1_TYPE_new = 'ASN1_TYPE_new'; }  {Do not localize}
  {CH fn_ASN1_TYPE_free = 'ASN1_TYPE_free'; }  {Do not localize}
  {CH fn_i2d_ASN1_TYPE = 'i2d_ASN1_TYPE'; }  {Do not localize}
  {CH fn_d2i_ASN1_TYPE = 'd2i_ASN1_TYPE'; }  {Do not localize}
  {CH fn_ASN1_TYPE_get = 'ASN1_TYPE_get'; }  {Do not localize}
  {CH fn_ASN1_TYPE_set = 'ASN1_TYPE_set'; }  {Do not localize}
  {CH fn_ASN1_TYPE_set1 = 'ASN1_TYPE_set1'; } {Do not localize}
  {CH fn_ASN1_OBJECT_new = 'ASN1_OBJECT_new'; }  {Do not localize}
  {CH fn_ASN1_OBJECT_free = 'ASN1_OBJECT_free'; }  {Do not localize}
  {CH fn_i2d_ASN1_OBJECT = 'i2d_ASN1_OBJECT'; }  {Do not localize}
  {CH fn_d2i_ASN1_OBJECT = 'd2i_ASN1_OBJECT'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_new = 'sk_ASN1_OBJECT_new'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_new_null = 'sk_ASN1_OBJECT_new_null'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_free = 'sk_ASN1_OBJECT_free'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_num = 'sk_ASN1_OBJECT_num'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_value = 'sk_ASN1_OBJECT_value'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_set = 'sk_ASN1_OBJECT_set'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_zero = 'sk_ASN1_OBJECT_zero'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_push = 'sk_ASN1_OBJECT_push'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_unshift = 'sk_ASN1_OBJECT_unshift'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_find = 'sk_ASN1_OBJECT_find'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_delete = 'sk_ASN1_OBJECT_delete'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_delete_ptr = 'sk_ASN1_OBJECT_delete_ptr'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_insert = 'sk_ASN1_OBJECT_insert'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_dup = 'sk_ASN1_OBJECT_dup'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_pop_free = 'sk_ASN1_OBJECT_pop_free'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_shift = 'sk_ASN1_OBJECT_shift'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_pop = 'sk_ASN1_OBJECT_pop'; }  {Do not localize}
  {CH fn_sk_ASN1_OBJECT_sort = 'sk_ASN1_OBJECT_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_ASN1_OBJECT = 'i2d_ASN1_SET_OF_ASN1_OBJECT'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_ASN1_OBJECT = 'd2i_ASN1_SET_OF_ASN1_OBJECT'; }  {Do not localize}
  {CH fn_ASN1_STRING_new = 'ASN1_STRING_new'; }  {Do not localize}
  fn_ASN1_STRING_free = 'ASN1_STRING_free';  {Do not localize}
  {CH fn_ASN1_STRING_dup = 'ASN1_STRING_dup'; }  {Do not localize}
  fn_ASN1_STRING_type_new = 'ASN1_STRING_type_new';  {Do not localize}
  {CH fn_ASN1_STRING_cmp = 'ASN1_STRING_cmp'; }  {Do not localize}
  {CH fn_ASN1_STRING_set = 'ASN1_STRING_set'; }  {Do not localize}
  {CH fn_ASN1_STRING_set0 = 'ASN1_STRING_set0'; } {Do not localize}
  {CH fn_i2d_ASN1_BIT_STRING = 'i2d_ASN1_BIT_STRING'; }  {Do not localize}
  {CH fn_d2i_ASN1_BIT_STRING = 'd2i_ASN1_BIT_STRING'; }  {Do not localize}
  {CH fn_ASN1_BIT_STRING_set_bit = 'ASN1_BIT_STRING_set_bit'; }  {Do not localize}
  {CH fn_ASN1_BIT_STRING_get_bit = 'ASN1_BIT_STRING_get_bit'; }  {Do not localize}
  {CH fn_i2d_ASN1_BOOLEAN = 'i2d_ASN1_BOOLEAN'; }  {Do not localize}
  {CH fn_d2i_ASN1_BOOLEAN = 'd2i_ASN1_BOOLEAN'; }  {Do not localize}
  {CH fn_i2d_ASN1_INTEGER = 'i2d_ASN1_INTEGER'; }  {Do not localize}
  {CH fn_d2i_ASN1_INTEGER = 'd2i_ASN1_INTEGER'; }  {Do not localize}
  {CH fn_d2i_ASN1_UINTEGER = 'd2i_ASN1_UINTEGER'; }  {Do not localize}
  {CH fn_i2d_ASN1_ENUMERATED = 'i2d_ASN1_ENUMERATED'; }  {Do not localize}
  {CH fn_d2i_ASN1_ENUMERATED = 'd2i_ASN1_ENUMERATED'; }  {Do not localize}
  {CH fn_ASN1_UTCTIME_check = 'ASN1_UTCTIME_check'; }  {Do not localize}
  {CH fn_ASN1_UTCTIME_set = 'ASN1_UTCTIME_set'; }  {Do not localize}
  {CH fn_ASN1_UTCTIME_set_string = 'ASN1_UTCTIME_set_string'; }  {Do not localize}
  {CH fn_ASN1_GENERALIZEDTIME_check = 'ASN1_GENERALIZEDTIME_check'; }  {Do not localize}
  {CH fn_ASN1_GENERALIZEDTIME_set = 'ASN1_GENERALIZEDTIME_set'; }  {Do not localize}
  {CH fn_ASN1_GENERALIZEDTIME_set_string = 'ASN1_GENERALIZEDTIME_set_string'; }  {Do not localize}
  {CH fn_i2d_ASN1_OCTET_STRING = 'i2d_ASN1_OCTET_STRING'; }  {Do not localize}
  {CH fn_d2i_ASN1_OCTET_STRING = 'd2i_ASN1_OCTET_STRING'; }  {Do not localize}
  {CH fn_i2d_ASN1_VISIBLESTRING = 'i2d_ASN1_VISIBLESTRING'; }  {Do not localize}
  {CH fn_d2i_ASN1_VISIBLESTRING = 'd2i_ASN1_VISIBLESTRING'; }  {Do not localize}
  {CH fn_i2d_ASN1_UTF8STRING = 'i2d_ASN1_UTF8STRING'; }  {Do not localize}
  {CH fn_d2i_ASN1_UTF8STRING = 'd2i_ASN1_UTF8STRING'; }  {Do not localize}
  {CH fn_i2d_ASN1_BMPSTRING = 'i2d_ASN1_BMPSTRING'; }  {Do not localize}
  {CH fn_d2i_ASN1_BMPSTRING = 'd2i_ASN1_BMPSTRING'; }  {Do not localize}
  {CH fn_i2d_ASN1_PRINTABLE = 'i2d_ASN1_PRINTABLE'; }  {Do not localize}
  {CH fn_d2i_ASN1_PRINTABLE = 'd2i_ASN1_PRINTABLE'; }  {Do not localize}
  {CH fn_d2i_ASN1_PRINTABLESTRING = 'd2i_ASN1_PRINTABLESTRING'; }  {Do not localize}
  {CH fn_i2d_DIRECTORYSTRING = 'i2d_DIRECTORYSTRING'; }  {Do not localize}
  {CH fn_d2i_DIRECTORYSTRING = 'd2i_DIRECTORYSTRING'; }  {Do not localize}
  {CH fn_i2d_DISPLAYTEXT = 'i2d_DISPLAYTEXT'; }  {Do not localize}
  {CH fn_d2i_DISPLAYTEXT = 'd2i_DISPLAYTEXT'; }  {Do not localize}
  {CH fn_d2i_ASN1_T61STRING = 'd2i_ASN1_T61STRING'; }  {Do not localize}
  {CH fn_i2d_ASN1_IA5STRING = 'i2d_ASN1_IA5STRING'; }  {Do not localize}
  {CH fn_d2i_ASN1_IA5STRING = 'd2i_ASN1_IA5STRING'; }  {Do not localize}
  {CH fn_i2d_ASN1_UTCTIME = 'i2d_ASN1_UTCTIME'; }  {Do not localize}
  {CH fn_d2i_ASN1_UTCTIME = 'd2i_ASN1_UTCTIME'; }  {Do not localize}
  {CH fn_i2d_ASN1_GENERALIZEDTIME = 'i2d_ASN1_GENERALIZEDTIME'; }  {Do not localize}
  {CH fn_d2i_ASN1_GENERALIZEDTIME = 'd2i_ASN1_GENERALIZEDTIME'; }  {Do not localize}
  {CH fn_i2d_ASN1_TIME = 'i2d_ASN1_TIME'; }  {Do not localize}
  {CH fn_d2i_ASN1_TIME = 'd2i_ASN1_TIME'; }  {Do not localize}
  {CH fn_ASN1_TIME_set = 'ASN1_TIME_set'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET = 'i2d_ASN1_SET'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET = 'd2i_ASN1_SET'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_BIO}
  {CH fn_i2a_ASN1_INTEGER = 'i2a_ASN1_INTEGER'; }  {Do not localize}
  {CH fn_a2i_ASN1_INTEGER = 'a2i_ASN1_INTEGER'; }  {Do not localize}
  {CH fn_i2a_ASN1_ENUMERATED = 'i2a_ASN1_ENUMERATED'; }  {Do not localize}
  {CH fn_a2i_ASN1_ENUMERATED = 'a2i_ASN1_ENUMERATED'; }  {Do not localize}
  {CH fn_i2a_ASN1_OBJECT = 'i2a_ASN1_OBJECT'; }  {Do not localize}
  {CH fn_a2i_ASN1_STRING = 'a2i_ASN1_STRING'; }  {Do not localize}
  {CH fn_i2a_ASN1_STRING = 'i2a_ASN1_STRING'; }  {Do not localize}
  {$ENDIF}
  {CH fn_i2t_ASN1_OBJECT = 'i2t_ASN1_OBJECT'; }  {Do not localize}
  {CH fn_a2d_ASN1_OBJECT = 'a2d_ASN1_OBJECT'; }  {Do not localize}
  {CH fn_ASN1_OBJECT_create = 'ASN1_OBJECT_create'; }  {Do not localize}
  fn_ASN1_INTEGER_set = 'ASN1_INTEGER_set';  {Do not localize}
  fn_ASN1_INTEGER_get = 'ASN1_INTEGER_get';  {Do not localize}
  {CH fn_BN_to_ASN1_INTEGER = 'BN_to_ASN1_INTEGER'; }  {Do not localize}
  fn_ASN1_INTEGER_to_BN = 'ASN1_INTEGER_to_BN';  {Do not localize}
  {CH fn_ASN1_ENUMERATED_set = 'ASN1_ENUMERATED_set'; }  {Do not localize}
  {CH fn_ASN1_ENUMERATED_get = 'ASN1_ENUMERATED_get'; }  {Do not localize}
  {CH fn_BN_to_ASN1_ENUMERATED = 'BN_to_ASN1_ENUMERATED'; }  {Do not localize}
  {CH fn_ASN1_ENUMERATED_to_BN = 'ASN1_ENUMERATED_to_BN'; }  {Do not localize}
  {CH fn_ASN1_PRINTABLE_type = 'ASN1_PRINTABLE_type'; }  {Do not localize}
  {CH fn_i2d_ASN1_bytes = 'i2d_ASN1_bytes'; }  {Do not localize}
  {CH fn_d2i_ASN1_bytes = 'd2i_ASN1_bytes'; }  {Do not localize}
  {CH fn_d2i_ASN1_type_bytes = 'd2i_ASN1_type_bytes'; }  {Do not localize}
  {CH fn_asn1_Finish = 'asn1_Finish'; }  {Do not localize}
  {CH fn_ASN1_get_object = 'ASN1_get_object'; }  {Do not localize}
  {CH fn_ASN1_check_infinite_end = 'ASN1_check_infinite_end'; }  {Do not localize}
  {CH fn_ASN1_put_object = 'ASN1_put_object'; }  {Do not localize}
  {CH fn_ASN1_object_size = 'ASN1_object_size'; }  {Do not localize}
   fn_ASN1_dup = 'ASN1_dup';   {Do not localize}
  {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_ASN1_d2i_fp = 'ASN1_d2i_fp'; }  {Do not localize}
  {CH fn_ASN1_i2d_fp = 'ASN1_i2d_fp'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_BIO}
  {CH fn_ASN1_d2i_bio = 'ASN1_d2i_bio'; }  {Do not localize}
  {CH fn_ASN1_item_d2i_bio = 'ASN1_item_d2i_bio'; } {Do not localize}
  {CH fn_ASN1_i2d_bio = 'ASN1_i2d_bio'; }  {Do not localize}
  {CH fn_ASN1_item_i2d_bio = 'ASN1_item_i2d_bio'; } {Do not localize}
  {CH fn_ASN1_UTCTIME_print = 'ASN1_UTCTIME_print'; }  {Do not localize}
  {CH fn_ASN1_GENERALIZEDTIME_print = 'ASN1_GENERALIZEDTIME_print'; }  {Do not localize}
  {CH fn_ASN1_TIME_print = 'ASN1_TIME_print'; }  {Do not localize}
  {CH fn_ASN1_STRING_print = 'ASN1_STRING_print'; }  {Do not localize}
  {CH fn_ASN1_STRING_print_ex = 'ASN1_STRING_print_ex'; } {Do not localize}
  {CH fn_ASN1_parse = 'ASN1_parse'; }  {Do not localize}
  {CH fn_ASN1_parse_dump = 'ASN1_parse_dump'; } {Do not localize}
  {$ENDIF}
  {CH fn_ASN1_tag2str = 'ASN1_tag2str'; } {Do not localize}
  {CH fn_i2d_ASN1_HEADER = 'i2d_ASN1_HEADER'; }  {Do not localize}
  {CH fn_d2i_ASN1_HEADER = 'd2i_ASN1_HEADER'; }  {Do not localize}
  {CH fn_ASN1_HEADER_new = 'ASN1_HEADER_new'; }  {Do not localize}
  {CH fn_ASN1_HEADER_free = 'ASN1_HEADER_free'; }  {Do not localize}
  {CH fn_ASN1_UNIVERSALSTRING_to_string = 'ASN1_UNIVERSALSTRING_to_string'; }  {Do not localize}
  {CH fn_ERR_load_ASN1_strings = 'ERR_load_ASN1_strings'; }  {Do not localize}
  {CH fn_X509_asn1_meth = 'X509_asn1_meth'; }  {Do not localize}
  {CH fn_RSAPrivateKey_asn1_meth = 'RSAPrivateKey_asn1_meth'; }  {Do not localize}
  {CH fn_ASN1_IA5STRING_asn1_meth = 'ASN1_IA5STRING_asn1_meth'; }  {Do not localize}
  {CH fn_ASN1_BIT_STRING_asn1_meth = 'ASN1_BIT_STRING_asn1_meth'; }  {Do not localize}
  {CH fn_ASN1_TYPE_set_octetstring = 'ASN1_TYPE_set_octetstring'; }  {Do not localize}
  {CH fn_ASN1_TYPE_get_octetstring = 'ASN1_TYPE_get_octetstring'; }  {Do not localize}
  {CH fn_ASN1_TYPE_set_int_octetstring = 'ASN1_TYPE_set_int_octetstring'; }  {Do not localize}
  {CH fn_ASN1_TYPE_get_int_octetstring = 'ASN1_TYPE_get_int_octetstring'; }  {Do not localize}
  {CH fn_ASN1_seq_unpack = 'ASN1_seq_unpack'; }  {Do not localize}
  {CH fn_ASN1_seq_pack = 'ASN1_seq_pack'; }  {Do not localize}
  {CH fn_ASN1_unpack_string = 'ASN1_unpack_string'; }  {Do not localize}
  {CH fn_ASN1_pack_string = 'ASN1_pack_string'; }  {Do not localize}
  {CH fn_ASN1_item_unpack = 'ASN1_item_unpack'; } {Do not localize}
  {CH fn_ASN1_item_pack = 'ASN1_item_pack'; } {Do not localize}
  {CH fn_ASN1_STRING_set_default_mask = 'ASN1_STRING_set_default_mask'; } {Do not localize}
  {CH fn_ASN1_STRING_set_default_mask_asc = 'ASN1_STRING_set_default_mask_asc'; } {Do not localize}
  {CH fn_ASN1_STRING_get_default_mask = 'ASN1_STRING_get_default_mask'; } {Do not localize}
  {CH fn_ASN1_mbstring_copy = 'ASN1_mbstring_copy'; } {Do not localize}
  {CH fn_ASN1_mbstring_ncopy = 'ASN1_mbstring_ncopy'; } {Do not localize}
  {CH fn_ASN1_STRING_set_by_NID = 'ASN1_STRING_set_by_NID'; } {Do not localize}
  {CH fn_ASN1_STRING_TABLE_get = 'ASN1_STRING_TABLE_get'; {Do not localize}
  {CH fn_ASN1_STRING_TABLE_add = 'ASN1_STRING_TABLE_add'; } {Do not localize}
  {CH fn_ASN1_STRING_TABLE_cleanup = 'ASN1_STRING_TABLE_cleanup'; } {Do not localize}
  {CH fn_ASN1_item_new = 'ASN1_item_new'; } {Do not localize}
  {CH fn_ASN1_item_free = 'ASN1_item_free'; } {Do not localize}
  {CH fn_ASN1_item_d2i = 'ASN1_item_d2i'; } {Do not localize}
  {CH fn_ASN1_item_i2d = 'ASN1_item_i2d'; } {Do not localize}
  {CH fn_ASN1_item_ndef_i2d = 'ASN1_item_ndef_i2d'; } {Do not localize}
  {CH fn_ASN1_add_oid_module = 'ASN1_add_oid_module'; } {Do not localize}
  {CH fn_ASN1_generate_nconf = 'ASN1_generate_nconf'; } {Do not localize}
  {CH fn_ASN1_generate_v3 = 'ASN1_generate_v3'; } {Do not localize}
  {CH fn_int_smime_write_ASN1 = 'int_smime_write_ASN1'; } {Do not localize}
  {CH fn_SMIME_read_ASN1 = 'SMIME_read_ASN1'; } {Do not localize}
  {CH fn_OBJ_NAME_init = 'OBJ_NAME_init'; }  {Do not localize}
  {CH fn_OBJ_NAME_new_index = 'OBJ_NAME_new_index'; }  {Do not localize}
  {CH fn_OBJ_NAME_get = 'OBJ_NAME_get'; }  {Do not localize}
  {CH fn_OBJ_NAME_add = 'OBJ_NAME_add'; }  {Do not localize}
  {CH fn_OBJ_NAME_remove = 'OBJ_NAME_remove'; }  {Do not localize}
  {CH fn_OBJ_NAME_cleanup = 'OBJ_NAME_cleanup'; }  {Do not localize}
  {CH fn_OBJ_dup = 'OBJ_dup'; }  {Do not localize}
  fn_OBJ_nid2obj = 'OBJ_nid2obj';  {Do not localize}
  fn_OBJ_nid2ln = 'OBJ_nid2ln';  {Do not localize}
  fn_OBJ_nid2sn = 'OBJ_nid2sn';  {Do not localize}
  fn_OBJ_obj2nid = 'OBJ_obj2nid';  {Do not localize}
  {CH fn_OBJ_txt2obj = 'OBJ_txt2obj'; }  {Do not localize}
  {CH fn_OBJ_obj2txt = 'OBJ_obj2txt'; }  {Do not localize}
  {CH fn_OBJ_txt2nid = 'OBJ_txt2nid'; }  {Do not localize}
  {CH fn_OBJ_ln2nid = 'OBJ_ln2nid'; }  {Do not localize}
  {CH fn_OBJ_sn2nid = 'OBJ_sn2nid'; }  {Do not localize}
  {CH fn_OBJ_cmp = 'OBJ_cmp'; }  {Do not localize}
  {CH fn_OBJ_bsearch = 'OBJ_bsearch'; }  {Do not localize}
  {CH fn_ERR_load_OBJ_strings = 'ERR_load_OBJ_strings'; }  {Do not localize}
  {CH fn_OBJ_new_nid = 'OBJ_new_nid'; }  {Do not localize}
  {CH fn_OBJ_add_object = 'OBJ_add_object'; }  {Do not localize}
  {CH fn_OBJ_create = 'OBJ_create'; }  {Do not localize}
  {CH fn_OBJ_cleanup = 'OBJ_cleanup'; }  {Do not localize}
  {CH fn_OBJ_create_objects = 'OBJ_create_objects'; }  {Do not localize}
  {===}
   fn_EVP_MD_type = 'EVP_MD_type'; {Do not localize}
   fn_EVP_MD_pkey_type = 'EVP_MD_pkey_type';  {Do not localize}
   fn_EVP_MD_size = 'EVP_MD_size'; {Do not localize}
   fn_EVP_MD_block_size = 'EVP_MD_block_size';  {Do not localize}
   fn_EVP_MD_flags = 'EVP_MD_flags'; {Do not localize}
   fn_EVP_MD_CTX_md = 'EVP_MD_CTX_md';   {Do not localize}
   fn_EVP_CIPHER_nid = 'EVP_CIPHER_nid';  {Do not localize}
   fn_EVP_CIPHER_block_size = 'EVP_CIPHER_block_size';   {Do not localize}
   fn_EVP_CIPHER_key_length = 'EVP_CIPHER_key_length';  {Do not localize}
   fn_EVP_CIPHER_iv_length = 'EVP_CIPHER_iv_length';  {Do not localize}
   fn_EVP_CIPHER_flags = 'EVP_CIPHER_flags';  {Do not localize}
   fn_EVP_CIPHER_CTX_cipher = 'EVP_CIPHER_CTX_cipher';  {Do not localize}
   fn_EVP_CIPHER_CTX_nid = 'EVP_CIPHER_CTX_nid';  {Do not localize}
   fn_EVP_CIPHER_CTX_block_size = 'EVP_CIPHER_CTX_block_size';  {Do not localize}
   fn_EVP_CIPHER_CTX_key_length = 'EVP_CIPHER_CTX_key_length';  {Do not localize}
   fn_EVP_CIPHER_CTX_iv_length = 'EVP_CIPHER_CTX_iv_length';  {Do not localize}
   fn_EVP_CIPHER_CTX_get_app_data = 'EVP_CIPHER_CTX_get_app_data';  {Do not localize}
   fn_EVP_CIPHER_CTX_set_app_data = 'EVP_CIPHER_CTX_set_app_data';  {Do not localize}
   fn_EVP_CIPHER_CTX_flags = 'EVP_CIPHER_CTX_flags';  {Do not localize}
   fn_EVP_Cipher = 'EVP_Cipher';  {Do not localize}
   fn_EVP_MD_CTX_init = 'EVP_MD_CTX_init'; {Do not localize}
   fn_EVP_MD_CTX_cleanup = 'EVP_MD_CTX_cleanup';  {Do not localize}
   fn_EVP_MD_CTX_create = 'EVP_MD_CTX_create';  {Do not localize}
   fn_EVP_MD_CTX_destroy = 'EVP_MD_CTX_destroy';  {Do not localize}
   fn_EVP_MD_CTX_copy_ex = 'EVP_MD_CTX_copy_ex';  {Do not localize}
   fn_EVP_MD_CTX_set_flags = 'EVP_MD_CTX_set_flags';  {Do not localize}
   fn_EVP_MD_CTX_clear_flags = 'EVP_MD_CTX_clear_flags';  {Do not localize}
   fn_EVP_MD_CTX_test_flags = 'EVP_MD_CTX_test_flags';  {Do not localize}
   fn_EVP_DigestInit_ex = 'EVP_DigestInit_ex';  {Do not localize}
   fn_EVP_DigestUpdate = 'EVP_DigestUpdate';  {Do not localize}
   fn_EVP_DigestFinal_ex = 'EVP_DigestFinal_ex';  {Do not localize}
   fn_EVP_Digest = 'EVP_Digest';  {Do not localize}
  fn_EVP_MD_CTX_copy = 'EVP_MD_CTX_copy';  {Do not localize}
   fn_EVP_DigestInit = 'EVP_DigestInit';   {Do not localize}
  fn_EVP_DigestFinal = 'EVP_DigestFinal';   {Do not localize}
  fn_EVP_read_pw_string = 'EVP_read_pw_string';  {Do not localize}
  fn_EVP_set_pw_prompt = 'EVP_set_pw_prompt';  {Do not localize}
  fn_EVP_get_pw_prompt = 'EVP_get_pw_prompt';   {Do not localize}
  fn_EVP_BytesToKey = 'EVP_BytesToKey';   {Do not localize}
  fn_EVP_CIPHER_CTX_set_flags = 'EVP_CIPHER_CTX_set_flags'; {Do not localize}
  fn_EVP_CIPHER_CTX_clear_flags = 'EVP_CIPHER_CTX_clear_flags'; {Do not localize}
  fn_EVP_CIPHER_CTX_test_flags = 'EVP_CIPHER_CTX_test_flags';  {Do not localize}
  fn_EVP_EncryptInit = 'EVP_EncryptInit';  {Do not localize}
   fn_EVP_EncryptInit_ex = 'EVP_EncryptInit_ex'; {Do not localize}
  fn_EVP_EncryptUpdate = 'EVP_EncryptUpdate';  {Do not localize}
  fn_EVP_EncryptFinal = 'EVP_EncryptFinal';  {Do not localize}
  fn_EVP_EncryptFinal_ex = 'EVP_EncryptFinal_ex'; {Do not localize}
  fn_EVP_DecryptInit = 'EVP_DecryptInit';   {Do not localize}
  fn_EVP_DecryptInit_ex = 'EVP_DecryptInit_ex';   {Do not localize}
  fn_EVP_DecryptUpdate = 'EVP_DecryptUpdate';   {Do not localize}
  fn_EVP_DecryptFinal = 'EVP_DecryptFinal';  {Do not localize}
  fn_EVP_DecryptFinal_ex = 'EVP_DecryptFinal_ex'; {Do not localize}
  fn_EVP_CipherInit = 'EVP_CipherInit';   {Do not localize}
  fn_EVP_CipherInit_ex = 'EVP_CipherInit_ex'; {Do not localize}
  fn_EVP_CipherUpdate = 'EVP_CipherUpdate';  {Do not localize}
  fn_EVP_CipherFinal = 'EVP_CipherFinal';  {Do not localize}
  fn_EVP_CipherFinal_ex = 'EVP_CipherFinal_ex';  {Do not localize}

  fn_EVP_DigestSignInit = 'EVP_DigestSignInit';  {Do not localize}
  fn_EVP_DigestSignFinal = 'EVP_DigestSignFinal'; {Do not localize}
  fn_EVP_DigestVerifyInit = 'EVP_DigestVerifyInit'; {Do not localize}
  fn_EVP_DigestVerifyFinal = 'EVP_DigestVerifyFinal'; {Do not localize}

  fn_EVP_SignFinal = 'EVP_SignFinal';   {Do not localize}
  fn_EVP_VerifyFinal = 'EVP_VerifyFinal';   {Do not localize}
  fn_EVP_OpenInit = 'EVP_OpenInit';   {Do not localize}
  fn_EVP_OpenFinal = 'EVP_OpenFinal';  {Do not localize}
  fn_EVP_SealInit = 'EVP_SealInit';   {Do not localize}
  fn_EVP_SealFinal = 'EVP_SealFinal';  {Do not localize}
  fn_EVP_EncodeInit = 'EVP_EncodeInit';  {Do not localize}
  fn_EVP_EncodeUpdate = 'EVP_EncodeUpdate';  {Do not localize}
  fn_EVP_EncodeFinal = 'EVP_EncodeFinal';   {Do not localize}
  fn_EVP_EncodeBlock = 'EVP_EncodeBlock';   {Do not localize}
  fn_EVP_DecodeInit = 'EVP_DecodeInit';   {Do not localize}
  fn_EVP_DecodeUpdate = 'EVP_DecodeUpdate';   {Do not localize}
  fn_EVP_DecodeFinal = 'EVP_DecodeFinal';   {Do not localize}
  fn_EVP_DecodeBlock = 'EVP_DecodeBlock';   {Do not localize}
  fn_EVP_CIPHER_CTX_init = 'EVP_CIPHER_CTX_init';  {Do not localize}
  fn_EVP_CIPHER_CTX_cleanup = 'EVP_CIPHER_CTX_cleanup';  {Do not localize}
  fn_EVP_CIPHER_CTX_new = 'EVP_CIPHER_CTX_new';  {Do not localize}
  fn_EVP_CIPHER_CTX_set_key_length = 'EVP_CIPHER_CTX_set_key_length'; {Do not localize}
  fn_EVP_CIPHER_CTX_ctrl = 'EVP_CIPHER_CTX_ctrl'; {Do not localize}
  fn_EVP_CIPHER_CTX_rand_key = 'EVP_CIPHER_CTX_rand_key'; {Do not localize}
  fn_EVP_CIPHER_CTX_copy = 'EVP_CIPHER_CTX_copy'; {Do not localize}
  fn_EVP_CIPHER_CTX_free = 'EVP_CIPHER_CTX_free'; {Do not localize}
  fn_EVP_CIPHER_CTX_set_padding = 'EVP_CIPHER_CTX_set_padding'; {Do not localize}
  {$IFNDEF OPENSSL_NO_BIO}
  fn_BIO_f_md = 'BIO_f_md';   {Do not localize}
  fn_BIO_f_base64 = 'BIO_f_base64';   {Do not localize}
  fn_BIO_f_cipher = 'BIO_f_cipher';   {Do not localize}
  fn_BIO_f_reliable = 'BIO_f_reliable';   {Do not localize}
  fn_BIO_set_cipher = 'BIO_set_cipher';   {Do not localize}
  {$ENDIF}
 fn_EVP_md_null = 'EVP_md_null';   {Do not localize}
  {$IFNDEF OPENSSL_NO_MD2}
   fn_EVP_md2 = 'EVP_md2';   {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MD4}
  fn_EVP_md4 = 'EVP_md4';   {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MD5}
  fn_EVP_md5 = 'EVP_md5';  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_SHA}
  fn_EVP_sha = 'EVP_sha';  {Do not localize}
  fn_EVP_sha1 = 'EVP_sha1';  {Do not localize}
  fn_EVP_dss = 'EVP_dss';  {Do not localize}
  fn_EVP_dss1 = 'EVP_dss1';  {Do not localize}
  fn_EVP_ecdsa = 'EVP_ecdsa'; {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_SHA256}
  fn_EVP_sha512 = 'EVP_sha512'; {Do not localize}
  fn_EVP_sha384 = 'EVP_sha384'; {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_SHA512}
  fn_EVP_sha256 = 'EVP_sha256'; {Do not localize}
  fn_EVP_sha224 = 'EVP_sha224'; {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_MDC2}
  fn_EVP_mdc2 = 'EVP_mdc2';   {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RIPEMD}
  fn_EVP_ripemd160 = 'EVP_ripemd160';  {Do not localize}
  {$ENDIF}
  {$ifndef OPENSSL_NO_WHIRLPOOL}
  fn_EVP_whirlpool = 'EVP_whirlpool'; {Do not localize}
  {$ENDIF}
  fn_EVP_enc_null = 'EVP_enc_null';  {Do not localize}
  {$IFNDEF OPENSSL_NO_DES}
  fn_EVP_des_ecb = 'EVP_des_ecb'; {Do not localize}
  fn_EVP_des_ede = 'EVP_des_ede';  {Do not localize}
  fn_EVP_des_ede3 = 'EVP_des_ede3'; {Do not localize}
  fn_EVP_des_cfb = 'EVP_des_cfb';  {Do not localize}
  fn_EVP_des_ede_cfb = 'EVP_des_ede_cfb';  {Do not localize}
  fn_EVP_des_ede3_cfb = 'EVP_des_ede3_cfb';  {Do not localize}
  fn_EVP_des_ofb = 'EVP_des_ofb';  {Do not localize}
  fn_EVP_des_ede_ofb = 'EVP_des_ede_ofb';  {Do not localize}
  fn_EVP_des_ede3_ofb = 'EVP_des_ede3_ofb';  {Do not localize}
  fn_EVP_des_cbc = 'EVP_des_cbc';  {Do not localize}
  fn_EVP_des_ede_cbc = 'EVP_des_ede_cbc';  {Do not localize}
  fn_EVP_des_ede3_cbc = 'EVP_des_ede3_cbc';  {Do not localize}
  fn_EVP_desx_cbc = 'EVP_desx_cbc';  {Do not localize}
  fn_EVP_des_ede3_cfb8 = 'EVP_des_ede3_cfb8'; {Do not localize}
  fn_EVP_des_ede_ecb = 'EVP_des_ede_ecb'; {Do not localize}
  fn_EVP_des_ede3_ecb = 'EVP_des_ede3_ecb';
  fn_EVP_des_cfb64 = 'EVP_des_cfb64';

  fn_EVP_des_cfb1 = 'EVP_des_cfb1';
  fn_EVP_des_cfb8 = 'EVP_des_cfb8';
  fn_EVP_des_ede_cfb64 = 'EVP_des_ede_cfb64';
//#if 0
  fn_EVP_des_ede_cfb1 = 'EVP_des_ede_cfb1';
  fn_EVP_des_ede_cfb8 = 'EVP_des_ede_cfb8';
  //#endif
  fn_EVP_des_ede3_cfb64 = 'EVP_des_ede3_cfb64';
  fn_EVP_des_ede3_cfb1 = 'EVP_des_ede3_cfb1';
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RC4}
  fn_EVP_rc4 = 'EVP_rc4';  {Do not localize}
  fn_EVP_rc4_40 = 'EVP_rc4_40';  {Do not localize}
    {$ifndef OPENSSL_NO_MD5}
  fn_EVP_rc4_hmac_md5 = 'EVP_rc4_hmac_md5'; {Do not localize}
    {$endif}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_IDEA}
  fn_EVP_idea_ecb = 'EVP_idea_ecb';  {Do not localize}
  fn_EVP_idea_cfb64 = 'EVP_idea_cfb64'; {Do not localize}
  fn_EVP_idea_cfb = 'EVP_idea_cfb';  {Do not localize}
  fn_EVP_idea_ofb = 'EVP_idea_ofb';  {Do not localize}
  fn_EVP_idea_cbc = 'EVP_idea_cbc';  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RC2}
  fn_EVP_rc2_ecb = 'EVP_rc2_ecb';  {Do not localize}
  fn_EVP_rc2_cbc = 'EVP_rc2_cbc';  {Do not localize}
  fn_EVP_rc2_40_cbc = 'EVP_rc2_40_cbc';  {Do not localize}
  fn_EVP_rc2_64_cbc = 'EVP_rc2_64_cbc';  {Do not localize}
  fn_EVP_rc2_cfb64 = 'EVP_rc2_cfb64'; {Do not localize}
  fn_EVP_rc2_cfb = 'EVP_rc2_cfb';  {Do not localize}
  fn_EVP_rc2_ofb = 'EVP_rc2_ofb';  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_BF}
  fn_EVP_bf_ecb = 'EVP_bf_ecb';  {Do not localize}
  fn_EVP_bf_cbc = 'EVP_bf_cbc';  {Do not localize}
  fn_EVP_bf_cfb = 'EVP_bf_cfb';  {Do not localize}
  fn_EVP_bf_cfb64 = 'EVP_bf_cfb64'; {Do not localize}
  fn_EVP_bf_ofb = 'EVP_bf_ofb';  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_CAST}
   fn_EVP_cast5_ecb = 'EVP_cast5_ecb';  {Do not localize}
  fn_EVP_cast5_cbc = 'EVP_cast5_cbc';  {Do not localize}
  fn_EVP_cast5_cfb = 'EVP_cast5_cfb';  {Do not localize}
  fn_EVP_cast5_cfb64 = 'EVP_cast5_cfb64'; {Do not localize}
  fn_EVP_cast5_ofb = 'EVP_cast5_ofb';  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_RC5 }
  fn_EVP_rc5_32_12_16_cbc = 'EVP_rc5_32_12_16_cbc';  {Do not localize}
  fn_EVP_rc5_32_12_16_ecb = 'EVP_rc5_32_12_16_ecb';  {Do not localize}
  fn_EVP_rc5_32_12_16_cfb = 'EVP_rc5_32_12_16_cfb';  {Do not localize}
  fn_EVP_rc5_32_12_16_cfb64 = 'EVP_rc5_32_12_16_cfb64'; {Do not localize}
  fn_EVP_rc5_32_12_16_ofb = 'EVP_rc5_32_12_16_ofb';  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_AES}
  fn_EVP_aes_128_ecb = 'EVP_aes_128_ecb'; {do not localize}
  fn_EVP_aes_128_cbc = 'EVP_aes_128_cbc'; {do not localize}
  fn_EVP_aes_128_cfb1 = 'EVP_aes_128_cfb1'; {do not localize}
  fn_EVP_aes_128_cfb8 = 'EVP_aes_128_cfb8';{do not localize}
  fn_EVP_aes_128_cfb128 = 'EVP_aes_128_cfb128'; {do not localize}
  fn_EVP_aes_128_ofb = 'EVP_aes_128_ofb'; {do not localize}
  fn_EVP_aes_128_ctr = 'EVP_aes_128_ctr'; {Do not localize}
  fn_EVP_aes_128_gcm = 'EVP_aes_128_gcm'; {Do not localize}
  fn_EVP_aes_128_ccm = 'EVP_aes_128_ccm'; {Do not localize}
  fn_EVP_aes_128_xts = 'EVP_aes_128_xts'; {Do not localize}
  fn_EVP_aes_192_ecb = 'EVP_aes_192_ecb'; {Do not localize}
  fn_EVP_aes_192_cbc = 'EVP_aes_192_cbc'; {Do not localize}
  fn_EVP_aes_192_cfb1 = 'EVP_aes_192_cfb1'; {Do not localize}
  fn_EVP_aes_192_cfb8 = 'EVP_aes_192_cfb8'; {Do not localize}
  fn_EVP_aes_192_cfb128 = 'EVP_aes_192_cfb128'; {Do not localize}
  fn_EVP_aes_192_ctr = 'EVP_aes_192_ctr';  {Do not localize}
  fn_EVP_aes_192_gcm = 'EVP_aes_192_gcm';  {Do not localize}
  fn_EVP_aes_192_ccm = 'EVP_aes_192_ccm';  {Do not localize}
  fn_EVP_aes_192_ofb = 'EVP_aes_192_ofb'; {Do not localize}
  fn_EVP_aes_256_ecb = 'EVP_aes_256_ecb'; {Do not localize}
  fn_EVP_aes_256_cbc = 'EVP_aes_256_cbc'; {Do not localize}
  fn_EVP_aes_256_cfb1 = 'EVP_aes_256_cfb1'; {Do not localize}
  fn_EVP_aes_256_cfb8 = 'EVP_aes_256_cfb8'; {Do not localize}
  fn_EVP_aes_256_cfb128 = 'EVP_aes_256_cfb128'; {Do not localize}
  fn_EVP_aes_256_ofb = 'EVP_aes_256_ofb'; {Do not localize}
  fn_EVP_aes_256_ctr = 'EVP_aes_256_ctr';  {Do not localize}
  fn_EVP_aes_256_gcm = 'EVP_aes_256_gcm';  {Do not localize}
  fn_EVP_aes_256_ccm = 'EVP_aes_256_ccm';  {Do not localize}
  fn_EVP_aes_256_xts = 'EVP_aes_256_xts';  {Do not localize}
    {$ifndef OPENSSL_NO_SHA}
      {$ifndef OPENSSL_NO_SHA1}
  fn_EVP_aes_128_cbc_hmac_sha1 = 'EVP_aes_128_cbc_hmac_sha1';  {Do not localize}
  fn_EVP_aes_256_cbc_hmac_sha1 = 'EVP_aes_256_cbc_hmac_sha1';  {do not localize}
      {$endif}
    {$endif}
  {$endif}
  {$IFNDEF OPENSSL_NO_CAMELLIA}
  fn_EVP_camellia_128_ecb = 'EVP_camellia_128_ecb'; {Do not localize}
  fn_EVP_camellia_128_cbc = 'EVP_camellia_128_cbc'; {Do not localize}
  fn_EVP_camellia_128_cfb1 = 'EVP_camellia_128_cfb1'; {Do not localize}
  fn_EVP_camellia_128_cfb8 = 'EVP_camellia_128_cfb8'; {Do not localize}
  fn_EVP_camellia_128_cfb128 = 'EVP_camellia_128_cfb128'; {Do not localize}
  fn_EVP_camellia_128_ofb = 'EVP_camellia_128_ofb'; {Do not localize}
  fn_EVP_camellia_192_ecb = 'EVP_camellia_192_ecb'; {Do not localize}
  fn_EVP_camellia_192_cbc = 'EVP_camellia_192_cbc'; {Do not localize}
  fn_EVP_camellia_192_cfb1 = 'EVP_camellia_192_cfb1'; {Do not localize}
  fn_EVP_camellia_192_cfb8 = 'EVP_camellia_192_cfb8'; {Do not localize}
  fn_EVP_camellia_192_cfb128 = 'EVP_camellia_192_cfb128'; {Do not localize}
  fn_EVP_camellia_192_ofb = 'EVP_camellia_192_ofb'; {Do not localize}
  fn_EVP_camellia_256_ecb = 'EVP_camellia_256_ecb'; {Do not localize}
  fn_EVP_camellia_256_cbc = 'EVP_camellia_256_cbc'; {Do not localize}
  fn_EVP_camellia_256_cfb1 = 'EVP_camellia_256_cfb1'; {Do not localize}
  fn_EVP_camellia_256_cfb8 = 'EVP_camellia_256_cfb8'; {Do not localize}
  fn_EVP_camellia_256_cfb128 = 'EVP_camellia_256_cfb128'; {Do not localize}
  fn_EVP_camellia_256_ofb = 'EVP_camellia_256_ofb'; {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_SEED}
  fn_EVP_seed_ecb = 'EVP_seed_ecb'; {Do not localize}
  fn_EVP_seed_cbc = 'EVP_seed_cbc'; {Do not localize}
  fn_EVP_seed_cfb128 = 'EVP_seed_cfb128'; {Do not localize}
  fn_EVP_seed_ofb = 'EVP_seed_ofb'; {Do not localize}
  {$ENDIF}
  fn_OPENSSL_add_all_algorithms_noconf = 'OPENSSL_add_all_algorithms_noconf';  {Do not localize}
  { fn_OPENSSL_add_all_algorithms_conf = 'OPENSSL_add_all_algorithms_conf'; }{Do not localize}
  fn_OpenSSL_add_all_algorithms = 'OpenSSL_add_all_algorithms';
  fn_OpenSSL_add_all_ciphers = 'OpenSSL_add_all_ciphers'; {Do not localize}
  fn_OpenSSL_add_all_digests = 'OpenSSL_add_all_digests'; {Do not localize}
  fn_EVP_add_cipher = 'EVP_add_cipher';  {Do not localize}
  fn_EVP_add_digest = 'EVP_add_digest';  {Do not localize}
  fn_EVP_CIPHER_do_all = 'EVP_CIPHER_do_all'; {Do not localize}
  fn_EVP_CIPHER_do_all_sorted = 'EVP_CIPHER_do_all_sorted'; {do not localize}
  fn_EVP_MD_do_all = 'EVP_MD_do_all'; {Do not localize}
  fn_EVP_MD_do_all_sorted = 'EVP_MD_do_all_sorted'; {Do not localize}
  fn_EVP_get_cipherbyname = 'EVP_get_cipherbyname';  {Do not localize}
  fn_EVP_get_digestbyname = 'EVP_get_digestbyname';  {Do not localize}
  fn_EVP_PKEY_decrypt_old = 'EVP_PKEY_decrypt_old'; {Do not localize}
  fn_EVP_PKEY_encrypt_old = 'EVP_PKEY_encrypt_old'; {Do not localize}

  fn_EVP_cleanup = 'EVP_cleanup';  {Do not localize}
  fn_EVP_PKEY_decrypt = 'EVP_PKEY_decrypt';   {Do not localize}
  fn_EVP_PKEY_encrypt = 'EVP_PKEY_encrypt';   {Do not localize}
  fn_EVP_PKEY_type = 'EVP_PKEY_type';  {Do not localize}
  fn_EVP_PKEY_id = 'EVP_PKEY_id'; {Do not localize}
  fn_EVP_PKEY_bits = 'EVP_PKEY_bits';   {Do not localize}
  fn_EVP_PKEY_base_id = 'EVP_PKEY_base_id'; {Do not localize}
  fn_EVP_PKEY_set_type = 'EVP_PKEY_set_type'; {Do not localize}
  fn_EVP_PKEY_set_type_str = 'EVP_PKEY_set_type_str'; {Do not localize}
  fn_EVP_PKEY_size = 'EVP_PKEY_size';   {Do not localize}
  fn_EVP_PKEY_assign = 'EVP_PKEY_assign';  {Do not localize}
  fn_EVP_PKEY_get0 = 'EVP_PKEY_get0'; {Do not localize}
  {$IFNDEF OPENSSL_NO_RSA}
  fn_EVP_PKEY_set1_RSA = 'EVP_PKEY_set1_RSA';  {Do not localize}
  fn_EVP_PKEY_get1_RSA = 'EVP_PKEY_get1_RSA';  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_DSA}
  fn_EVP_PKEY_set1_DSA = 'EVP_PKEY_set1_DSA';  {Do not localize}
  fn_EVP_PKEY_get1_DSA = 'EVP_PKEY_get1_DSA';  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_DH}
  fn_EVP_PKEY_set1_DH = 'EVP_PKEY_set1_DH';  {Do not localize}
  fn_EVP_PKEY_get1_DH = 'EVP_PKEY_get1_DH';  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_EC}
  fn_EVP_PKEY_set1_EC_KEY = 'EVP_PKEY_set1_EC_KEY';  {Do not localize}
  fn_EVP_PKEY_get1_EC_KEY = 'EVP_PKEY_get1_EC_KEY';  {Do not localize}
  {$ENDIF}
  fn_EVP_PKEY_new = 'EVP_PKEY_new';  {Do not localize}
  fn_EVP_PKEY_free = 'EVP_PKEY_free';  {Do not localize}
  fn_d2i_PublicKey = 'd2i_PublicKey';   {Do not localize}
  fn_i2d_PublicKey = 'i2d_PublicKey';   {Do not localize}
  fn_d2i_PrivateKey = 'd2i_PrivateKey';   {Do not localize}
  fn_d2i_AutoPrivateKey = 'd2i_AutoPrivateKey';  {Do not localize}
  fn_i2d_PrivateKey = 'i2d_PrivateKey';   {Do not localize}
  fn_EVP_PKEY_copy_parameters = 'EVP_PKEY_copy_parameters';   {Do not localize}
  fn_EVP_PKEY_missing_parameters = 'EVP_PKEY_missing_parameters';  {Do not localize}
  fn_EVP_PKEY_save_parameters = 'EVP_PKEY_save_parameters';   {Do not localize}
  fn_EVP_PKEY_cmp_parameters = 'EVP_PKEY_cmp_parameters';   {Do not localize}
  fn_EVP_PKEY_cmp = 'EVP_PKEY_cmp'; {Do not localize}
  fn_EVP_PKEY_print_public = 'EVP_PKEY_print_public'; {Do not localize}
  fn_EVP_PKEY_print_private = 'EVP_PKEY_print_private'; {Do not localize}
  fn_EVP_PKEY_print_params = 'EVP_PKEY_print_params'; {Do not localize}
  fn_EVP_PKEY_get_default_digest_nid = 'EVP_PKEY_get_default_digest_nid'; {Do not localize}
  fn_EVP_CIPHER_type = 'EVP_CIPHER_type';  {Do not localize}
  fn_EVP_CIPHER_param_to_asn1 = 'EVP_CIPHER_param_to_asn1';  {Do not localize}
  fn_EVP_CIPHER_asn1_to_param = 'EVP_CIPHER_asn1_to_param';  {Do not localize}
  fn_EVP_CIPHER_set_asn1_iv = 'EVP_CIPHER_set_asn1_iv';  {Do not localize}
  fn_EVP_CIPHER_get_asn1_iv = 'EVP_CIPHER_get_asn1_iv';  {Do not localize}
  fn_PKCS5_PBE_keyivgen = 'PKCS5_PBE_keyivgen';  {Do not localize}
  fn_PKCS5_PBKDF2_HMAC = 'PKCS5_PBKDF2_HMAC'; {Do not lozalize}
  fn_PKCS5_PBKDF2_HMAC_SHA1 = 'PKCS5_PBKDF2_HMAC_SHA1';  {Do not localize}
  fn_PKCS5_v2_PBE_keyivgen = 'PKCS5_v2_PBE_keyivgen';  {Do not localize}
  fn_PKCS5_PBE_add = 'PKCS5_PBE_add';  {Do not localize}
  fn_EVP_PBE_CipherInit = 'EVP_PBE_CipherInit';  {Do not localize}
  fn_EVP_PBE_alg_add = 'EVP_PBE_alg_add';  {Do not localize}
  fn_EVP_PBE_alg_add_type = 'EVP_PBE_alg_add_type'; {Do not localize}
  fn_EVP_PBE_find = 'EVP_PBE_find'; {Do not localize}
  fn_EVP_PBE_cleanup = 'EVP_PBE_cleanup';  {Do not localize}
  fn_EVP_PKEY_asn1_get_count = 'EVP_PKEY_asn1_get_count';
  fn_EVP_PKEY_asn1_get0 = 'EVP_PKEY_asn1_get0';
  fn_EVP_PKEY_asn1_find = 'EVP_PKEY_asn1_find';
  fn_EVP_PKEY_asn1_find_str = 'EVP_PKEY_asn1_find_str';
  fn_EVP_PKEY_asn1_add0 = 'EVP_PKEY_asn1_add0';
  fn_EVP_PKEY_asn1_add_alias = 'EVP_PKEY_asn1_add_alias';
  fn_EVP_PKEY_asn1_get0_info = 'EVP_PKEY_asn1_get0_info';
  fn_EVP_PKEY_get0_asn1 = 'EVP_PKEY_get0_asn1';
  fn_EVP_PKEY_asn1_new = 'EVP_PKEY_asn1_new';
  fn_EVP_PKEY_asn1_copy = 'EVP_PKEY_asn1_copy';
  fn_EVP_PKEY_asn1_free = 'EVP_PKEY_asn1_free';
  fn_EVP_PKEY_asn1_set_public = 'EVP_PKEY_asn1_set_public';
  fn_EVP_PKEY_asn1_set_private = 'EVP_PKEY_asn1_set_private';
  fn_EVP_PKEY_asn1_set_param = 'EVP_PKEY_asn1_set_param';
  fn_EVP_PKEY_asn1_set_free = 'EVP_PKEY_asn1_set_free';
  fn_EVP_PKEY_asn1_set_ctrl = 'EVP_PKEY_asn1_set_ctrl';
  fn_EVP_PKEY_meth_find = 'EVP_PKEY_meth_find';
  fn_EVP_PKEY_meth_new = 'EVP_PKEY_meth_new';
  fn_EVP_PKEY_meth_get0_info = 'EVP_PKEY_meth_get0_info';
  fn_EVP_PKEY_meth_copy = 'EVP_PKEY_meth_copy';
  fn_EVP_PKEY_meth_free = 'EVP_PKEY_meth_free';
  fn_EVP_PKEY_meth_add0 = 'EVP_PKEY_meth_add0';
  fn_EVP_PKEY_CTX_new = 'EVP_PKEY_CTX_new';
  fn_EVP_PKEY_CTX_new_id = 'EVP_PKEY_CTX_new_id';
  fn_EVP_PKEY_CTX_dup = 'EVP_PKEY_CTX_dup';
  fn_EVP_PKEY_CTX_free = 'EVP_PKEY_CTX_free';
  fn_EVP_PKEY_CTX_ctrl = 'EVP_PKEY_CTX_ctrl';
  fn_EVP_PKEY_CTX_ctrl_str = 'EVP_PKEY_CTX_ctrl_str';
  fn_EVP_PKEY_CTX_get_operation = 'EVP_PKEY_CTX_get_operation';
  fn_EVP_PKEY_CTX_set0_keygen_info = 'EVP_PKEY_CTX_set0_keygen_info';
  fn_EVP_PKEY_new_mac_key = 'EVP_PKEY_new_mac_key';
  fn_EVP_PKEY_CTX_set_data = 'EVP_PKEY_CTX_set_data';
  fn_EVP_PKEY_CTX_get_data = 'EVP_PKEY_CTX_get_data';
  fn_EVP_PKEY_CTX_get0_pkey = 'EVP_PKEY_CTX_get0_pkey';
  fn_EVP_PKEY_CTX_get0_peerkey = 'EVP_PKEY_CTX_get0_peerkey';
  fn_EVP_PKEY_CTX_set_app_data = 'EVP_PKEY_CTX_set_app_data';
  fn_EVP_PKEY_CTX_get_app_data = 'EVP_PKEY_CTX_get_app_data';
  fn_EVP_PKEY_sign_init = 'EVP_PKEY_sign_init';
  fn_EVP_PKEY_sign = 'EVP_PKEY_sign';
  fn_EVP_PKEY_verify_init = 'EVP_PKEY_verify_init';
  fn_EVP_PKEY_verify = 'EVP_PKEY_verify';
  fn_EVP_PKEY_verify_recover_init = 'EVP_PKEY_verify_recover_init';
  fn_EVP_PKEY_verify_recover = 'EVP_PKEY_verify_recover';
  fn_EVP_PKEY_encrypt_init = 'EVP_PKEY_encrypt_init';
  fn_EVP_PKEY_decrypt_init = 'EVP_PKEY_decrypt_init';
  fn_EVP_PKEY_derive_init = 'EVP_PKEY_derive_init';
  fn_EVP_PKEY_derive_set_peer = 'EVP_PKEY_derive_set_peer';
  fn_EVP_PKEY_derive = 'EVP_PKEY_derive';
  fn_EVP_PKEY_paramgen_init = 'EVP_PKEY_paramgen_init';
  fn_EVP_PKEY_paramgen = 'EVP_PKEY_paramgen';
  fn_EVP_PKEY_keygen_init = 'EVP_PKEY_keygen_init';
  fn_EVP_PKEY_keygen = 'EVP_PKEY_keygen';
  fn_EVP_PKEY_CTX_set_cb = 'EVP_PKEY_CTX_set_cb';
  fn_EVP_PKEY_CTX_get_cb = 'EVP_PKEY_CTX_get_cb';
  fn_EVP_PKEY_CTX_get_keygen_info = 'EVP_PKEY_CTX_get_keygen_info';
  fn_EVP_PKEY_meth_set_init = 'EVP_PKEY_meth_set_init';
  fn_EVP_PKEY_meth_set_copy = 'EVP_PKEY_meth_set_copy';
  fn_EVP_PKEY_meth_set_cleanup = 'EVP_PKEY_meth_set_cleanup';
  fn_EVP_PKEY_meth_set_paramgen = 'EVP_PKEY_meth_set_paramgen';
  fn_EVP_PKEY_meth_set_keygen = 'EVP_PKEY_meth_set_keygen';
  fn_EVP_PKEY_meth_set_sign = 'EVP_PKEY_meth_set_sign';
  fn_EVP_PKEY_meth_set_verify = 'EVP_PKEY_meth_set_verify';
  fn_EVP_PKEY_meth_set_verify_recover = 'EVP_PKEY_meth_set_verify_recover';
  fn_EVP_PKEY_meth_set_signctx = 'EVP_PKEY_meth_set_signctx';
  fn_EVP_PKEY_meth_set_verifyctx = 'EVP_PKEY_meth_set_verifyctx';
  fn_EVP_PKEY_meth_set_encrypt = 'EVP_PKEY_meth_set_encrypt';
  fn_EVP_PKEY_meth_set_decrypt = 'EVP_PKEY_meth_set_decrypt';
  fn_EVP_PKEY_meth_set_derive = 'EVP_PKEY_meth_set_derive';
  fn_EVP_PKEY_meth_set_ctrl = 'EVP_PKEY_meth_set_ctrl';

  {$IFDEF OPENSSL_FIPS}
    {$IFNDEF OPENSSL_NO_ENGINE}
  fn_EVP_MD_set_engine_callbacks = 'EVP_MD_set_engine_callbacks'; {Do not localize}
  fn_int_EVP_MD_init_engine_callbacks = 'int_EVP_MD_init_engine_callbacks'; {Do not localize}
  fn_int_EVP_CIPHER_set_engine_callbacks = 'int_EVP_CIPHER_set_engine_callbacks'; {Do not localize}
  fn_int_EVP_CIPHER_init_engine_callbacks = 'int_EVP_CIPHER_init_engine_callbacks'; {Do not localize}
    {$ENDIF}
  {$ENDIF}
  fn_EVP_add_alg_module = 'EVP_add_alg_module'; {Do not localize}
  {CH fn_ERR_load_EVP_strings = 'ERR_load_EVP_strings'; }  {Do not localize}
  {$IFDEF OPENSSL_FIPS}
  fn_FIPS_mode_set = 'FIPS_mode_set'; {Do not localize}
  fn_FIPS_mode = 'FIPS_mode'; {Do not localize}
   {CH fn_FIPS_rand_check = 'FIPS_rand_check'; } {Do not localize}
   {CH fn_FIPS_selftest_failed = 'FIPS_selftest_failed'; } {Do not localize}
  fn_FIPS_selftest_check = 'FIPS_selftest_check';  {Do not localize}
  {CH fn_FIPS_corrupt_sha1 = 'FIPS_corrupt_sha1'; } {Do not localize}
  {CH fn_FIPS_selftest_sha1 = 'FIPS_selftest_sha1'; } {Do not localize}
  {CH fb_FIPS_corrupt_aes = 'FIPS_corrupt_aes'; } {Do not localize}
  {CH fn_FIPS_selftest_aes = 'FIPS_selftest_aes'; } {Do not localize}
  {CH fn_FIPS_corrupt_des = 'FIPS_corrupt_des'; } {Do not localize}
  {CH fn_FIPS_selftest_des = 'FIPS_selftest_des'; } {Do not localize}
  {CH fn_FIPS_corrupt_rsa = 'FIPS_corrupt_rsa'; } {Do not localize}
  {CH fn_FIPS_corrupt_rsa_keygen = 'FIPS_corrupt_rsa_keygen'; } {Do not localize}
  {CH fn_FIPS_selftest_rsa = 'FIPS_selftest_rsa'; } {Do not localize}
  {CH fn_FIPS_corrupt_dsa = 'FIPS_corrupt_dsa'; } {Do not localize}
  {CH fn_FIPS_corrupt_dsa_keygen = 'FIPS_corrupt_dsa_keygen'; } {Do not localize}
  {CH fn_FIPS_selftest_dsa = 'FIPS_selftest_dsa'; } {Do not localize}
  {CH fn_FIPS_corrupt_rng = 'FIPS_corrupt_rng'; } {Do not localize}
  {CH fn_FIPS_rng_stick = 'FIPS_rng_stick'; } {Do not localize}
  {CH fn_FIPS_selftest_rng = 'FIPS_selftest_rng'; } {Do not localize}
  {CH fn_FIPS_selftest_hmac = 'FIPS_selftest_hmac'; } {Do not localize}
  {CH fn_fips_pkey_signature_test = 'fips_pkey_signature_test'; } {Do not localize}
  {CH fn_fips_cipher_test = 'fips_cipher_test';  } {Do not localize}
  //fips_rand.h
  {CH fn_FIPS_rand_set_key = 'FIPS_rand_set_key'; } {Do not localize}
  {CH fn_FIPS_rand_seed = 'FIPS_rand_seed; } {Do not localize}
  {CH fn_FIPS_rand_bytes = 'FIPS_rand_bytes'; } {Do not localize}
  {CH fn_FIPS_rand_test_mode = 'FIPS_rand_test_mode'; } {Do not localize}
  {CH fn_FIPS_rand_reset = 'FIPS_rand_reset'; } {Do not localize}
  {CH fn_FIPS_rand_set_dt = 'FIPS_rand_set_dt'; } {Do not localize}
  {CH fn_FIPS_rand_status = 'FIPS_rand_status';  } {Do not localize}
  {CH fn_FIPS_rand_method = 'FIPS_rand_method'; } {Do not localize}
  {$ENDIF}
  {CH fn_sk_X509_ALGOR_new = 'sk_X509_ALGOR_new'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_new_null = 'sk_X509_ALGOR_new_null'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_free = 'sk_X509_ALGOR_free'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_num = 'sk_X509_ALGOR_num'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_value = 'sk_X509_ALGOR_value'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_set = 'sk_X509_ALGOR_set'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_zero = 'sk_X509_ALGOR_zero'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_push = 'sk_X509_ALGOR_push'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_unshift = 'sk_X509_ALGOR_unshift'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_find = 'sk_X509_ALGOR_find'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_delete = 'sk_X509_ALGOR_delete'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_delete_ptr = 'sk_X509_ALGOR_delete_ptr'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_insert = 'sk_X509_ALGOR_insert'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_dup = 'sk_X509_ALGOR_dup'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_pop_free = 'sk_X509_ALGOR_pop_free'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_shift = 'sk_X509_ALGOR_shift'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_pop = 'sk_X509_ALGOR_pop'; }  {Do not localize}
  {CH fn_sk_X509_ALGOR_sort = 'sk_X509_ALGOR_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_X509_ALGOR = 'i2d_ASN1_SET_OF_X509_ALGOR'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_X509_ALGOR = 'd2i_ASN1_SET_OF_X509_ALGOR'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_new = 'sk_X509_NAME_ENTRY_new'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_new_null = 'sk_X509_NAME_ENTRY_new_null'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_free = 'sk_X509_NAME_ENTRY_free'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_num = 'sk_X509_NAME_ENTRY_num'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_value = 'sk_X509_NAME_ENTRY_value'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_set = 'sk_X509_NAME_ENTRY_set'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_zero = 'sk_X509_NAME_ENTRY_zero'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_push = 'sk_X509_NAME_ENTRY_push'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_unshift = 'sk_X509_NAME_ENTRY_unshift'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_find = 'sk_X509_NAME_ENTRY_find'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_delete = 'sk_X509_NAME_ENTRY_delete'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_delete_ptr = 'sk_X509_NAME_ENTRY_delete_ptr'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_insert = 'sk_X509_NAME_ENTRY_insert'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_dup = 'sk_X509_NAME_ENTRY_dup'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_pop_free = 'sk_X509_NAME_ENTRY_pop_free'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_shift = 'sk_X509_NAME_ENTRY_shift'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_pop = 'sk_X509_NAME_ENTRY_pop'; }  {Do not localize}
  {CH fn_sk_X509_NAME_ENTRY_sort = 'sk_X509_NAME_ENTRY_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_X509_NAME_ENTRY = 'i2d_ASN1_SET_OF_X509_NAME_ENTRY'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_X509_NAME_ENTRY = 'd2i_ASN1_SET_OF_X509_NAME_ENTRY'; }  {Do not localize}
  {CH fn_sk_X509_NAME_new = 'sk_X509_NAME_new'; }  {Do not localize}
  {CH fn_sk_X509_NAME_new_null = 'sk_X509_NAME_new_null'; }  {Do not localize}
  {CH fn_sk_X509_NAME_free = 'sk_X509_NAME_free'; }  {Do not localize}
  {CH fn_sk_X509_NAME_num = 'sk_X509_NAME_num'; }  {Do not localize}
  {CH fn_sk_X509_NAME_value = 'sk_X509_NAME_value'; }  {Do not localize}
  {CH fn_sk_X509_NAME_set = 'sk_X509_NAME_set'; }  {Do not localize}
  {CH fn_sk_X509_NAME_zero = 'sk_X509_NAME_zero'; }  {Do not localize}
  {CH fn_sk_X509_NAME_push = 'sk_X509_NAME_push'; }  {Do not localize}
  {CH fn_sk_X509_NAME_unshift = 'sk_X509_NAME_unshift'; }  {Do not localize}
  {CH fn_sk_X509_NAME_find = 'sk_X509_NAME_find'; }  {Do not localize}
  {CH fn_sk_X509_NAME_delete = 'sk_X509_NAME_delete'; }  {Do not localize}
  {CH fn_sk_X509_NAME_delete_ptr = 'sk_X509_NAME_delete_ptr'; }  {Do not localize}
  {CH fn_sk_X509_NAME_insert = 'sk_X509_NAME_insert'; }  {Do not localize}
  {CH fn_sk_X509_NAME_dup = 'sk_X509_NAME_dup'; }  {Do not localize}
  {CH fn_sk_X509_NAME_pop_free = 'sk_X509_NAME_pop_free'; }  {Do not localize}
  {CH fn_sk_X509_NAME_shift = 'sk_X509_NAME_shift'; }  {Do not localize}
  {CH fn_sk_X509_NAME_pop = 'sk_X509_NAME_pop'; }  {Do not localize}
  {CH fn_sk_X509_NAME_sort = 'sk_X509_NAME_sort'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_new = 'sk_X509_EXTENSION_new'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_new_null = 'sk_X509_EXTENSION_new_null'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_free = 'sk_X509_EXTENSION_free'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_num = 'sk_X509_EXTENSION_num'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_value = 'sk_X509_EXTENSION_value'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_set = 'sk_X509_EXTENSION_set'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_zero = 'sk_X509_EXTENSION_zero'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_push = 'sk_X509_EXTENSION_push'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_unshift = 'sk_X509_EXTENSION_unshift'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_find = 'sk_X509_EXTENSION_find'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_delete = 'sk_X509_EXTENSION_delete'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_delete_ptr = 'sk_X509_EXTENSION_delete_ptr'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_insert = 'sk_X509_EXTENSION_insert'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_dup = 'sk_X509_EXTENSION_dup'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_pop_free = 'sk_X509_EXTENSION_pop_free'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_shift = 'sk_X509_EXTENSION_shift'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_pop = 'sk_X509_EXTENSION_pop'; }  {Do not localize}
  {CH fn_sk_X509_EXTENSION_sort = 'sk_X509_EXTENSION_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_X509_EXTENSION = 'i2d_ASN1_SET_OF_X509_EXTENSION'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_X509_EXTENSION = 'd2i_ASN1_SET_OF_X509_EXTENSION'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_new = 'sk_X509_ATTRIBUTE_new'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_new_null = 'sk_X509_ATTRIBUTE_new_null'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_free = 'sk_X509_ATTRIBUTE_free'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_num = 'sk_X509_ATTRIBUTE_num'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_value = 'sk_X509_ATTRIBUTE_value'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_set = 'sk_X509_ATTRIBUTE_set'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_zero = 'sk_X509_ATTRIBUTE_zero'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_push = 'sk_X509_ATTRIBUTE_push'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_unshift = 'sk_X509_ATTRIBUTE_unshift'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_find = 'sk_X509_ATTRIBUTE_find'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_delete = 'sk_X509_ATTRIBUTE_delete'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_delete_ptr = 'sk_X509_ATTRIBUTE_delete_ptr'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_insert = 'sk_X509_ATTRIBUTE_insert'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_dup = 'sk_X509_ATTRIBUTE_dup'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_pop_free = 'sk_X509_ATTRIBUTE_pop_free'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_shift = 'sk_X509_ATTRIBUTE_shift'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_pop = 'sk_X509_ATTRIBUTE_pop'; }  {Do not localize}
  {CH fn_sk_X509_ATTRIBUTE_sort = 'sk_X509_ATTRIBUTE_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_X509_ATTRIBUTE = 'i2d_ASN1_SET_OF_X509_ATTRIBUTE'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_X509_ATTRIBUTE = 'd2i_ASN1_SET_OF_X509_ATTRIBUTE'; }  {Do not localize}
  {CH fn_sk_X509_new = 'sk_X509_new'; }  {Do not localize}
  {CH fn_sk_X509_new_null = 'sk_X509_new_null'; }  {Do not localize}
  {CH fn_sk_X509_free = 'sk_X509_free'; }  {Do not localize}
  {CH fn_sk_X509_num = 'sk_X509_num'; }  {Do not localize}
  {CH fn_sk_X509_value = 'sk_X509_value'; }  {Do not localize}
  {CH fn_sk_X509_set = 'sk_X509_set'; }  {Do not localize}
  {CH fn_sk_X509_zero = 'sk_X509_zero'; }  {Do not localize}
  {CH fn_sk_X509_push = 'sk_X509_push'; }  {Do not localize}
  {CH fn_sk_X509_unshift = 'sk_X509_unshift'; }  {Do not localize}
  {CH fn_sk_X509_find = 'sk_X509_find'; }  {Do not localize}
  {CH fn_sk_X509_delete = 'sk_X509_delete'; }  {Do not localize}
  {CH fn_sk_X509_delete_ptr = 'sk_X509_delete_ptr'; }  {Do not localize}
  {CH fn_sk_X509_insert = 'sk_X509_insert'; }  {Do not localize}
  {CH fn_sk_X509_dup = 'sk_X509_dup'; }  {Do not localize}
  {CH fn_sk_X509_pop_free = 'sk_X509_pop_free'; }  {Do not localize}
  {CH fn_sk_X509_shift = 'sk_X509_shift'; }  {Do not localize}
  {CH fn_sk_X509_pop = 'sk_X509_pop'; }  {Do not localize}
  {CH fn_sk_X509_sort = 'sk_X509_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_X509 = 'i2d_ASN1_SET_OF_X509'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_X509 = 'd2i_ASN1_SET_OF_X509'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_new = 'sk_X509_REVOKED_new'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_new_null = 'sk_X509_REVOKED_new_null'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_free = 'sk_X509_REVOKED_free'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_num = 'sk_X509_REVOKED_num'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_value = 'sk_X509_REVOKED_value'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_set = 'sk_X509_REVOKED_set'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_zero = 'sk_X509_REVOKED_zero'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_push = 'sk_X509_REVOKED_push'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_unshift = 'sk_X509_REVOKED_unshift'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_find = 'sk_X509_REVOKED_find'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_delete = 'sk_X509_REVOKED_delete'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_delete_ptr = 'sk_X509_REVOKED_delete_ptr'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_insert = 'sk_X509_REVOKED_insert'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_dup = 'sk_X509_REVOKED_dup'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_pop_free = 'sk_X509_REVOKED_pop_free'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_shift = 'sk_X509_REVOKED_shift'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_pop = 'sk_X509_REVOKED_pop'; }  {Do not localize}
  {CH fn_sk_X509_REVOKED_sort = 'sk_X509_REVOKED_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_X509_REVOKED = 'i2d_ASN1_SET_OF_X509_REVOKED'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_X509_REVOKED = 'd2i_ASN1_SET_OF_X509_REVOKED'; }  {Do not localize}
  {CH fn_sk_X509_CRL_new = 'sk_X509_CRL_new'; }  {Do not localize}
  {CH fn_sk_X509_CRL_new_null = 'sk_X509_CRL_new_null'; }  {Do not localize}
  {CH fn_sk_X509_CRL_free = 'sk_X509_CRL_free'; }  {Do not localize}
  {CH fn_sk_X509_CRL_num = 'sk_X509_CRL_num'; }  {Do not localize}
  {CH fn_sk_X509_CRL_value = 'sk_X509_CRL_value'; }  {Do not localize}
  {CH fn_sk_X509_CRL_set = 'sk_X509_CRL_set'; }  {Do not localize}
  {CH fn_sk_X509_CRL_zero = 'sk_X509_CRL_zero'; }  {Do not localize}
  {CH fn_sk_X509_CRL_push = 'sk_X509_CRL_push'; }  {Do not localize}
  {CH fn_sk_X509_CRL_unshift = 'sk_X509_CRL_unshift'; }  {Do not localize}
  {CH fn_sk_X509_CRL_find = 'sk_X509_CRL_find'; }  {Do not localize}
  {CH fn_sk_X509_CRL_delete = 'sk_X509_CRL_delete'; }  {Do not localize}
  {CH fn_sk_X509_CRL_delete_ptr = 'sk_X509_CRL_delete_ptr'; }  {Do not localize}
  {CH fn_sk_X509_CRL_insert = 'sk_X509_CRL_insert'; }  {Do not localize}
  {CH fn_sk_X509_CRL_dup = 'sk_X509_CRL_dup'; }  {Do not localize}
  {CH fn_sk_X509_CRL_pop_free = 'sk_X509_CRL_pop_free'; }  {Do not localize}
  {CH fn_sk_X509_CRL_shift = 'sk_X509_CRL_shift'; }  {Do not localize}
  {CH fn_sk_X509_CRL_pop = 'sk_X509_CRL_pop'; }  {Do not localize}
  {CH fn_sk_X509_CRL_sort = 'sk_X509_CRL_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_X509_CRL = 'i2d_ASN1_SET_OF_X509_CRL'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_X509_CRL = 'd2i_ASN1_SET_OF_X509_CRL'; }  {Do not localize}
  {CH fn_sk_X509_INFO_new = 'sk_X509_INFO_new'; }  {Do not localize}
  {CH fn_sk_X509_INFO_new_null = 'sk_X509_INFO_new_null'; }  {Do not localize}
  {CH fn_sk_X509_INFO_free = 'sk_X509_INFO_free'; }  {Do not localize}
  {CH fn_sk_X509_INFO_num = 'sk_X509_INFO_num'; }  {Do not localize}
  {CH fn_sk_X509_INFO_value = 'sk_X509_INFO_value'; }  {Do not localize}
  {CH fn_sk_X509_INFO_set = 'sk_X509_INFO_set'; }  {Do not localize}
  {CH fn_sk_X509_INFO_zero = 'sk_X509_INFO_zero'; }  {Do not localize}
  {CH fn_sk_X509_INFO_push = 'sk_X509_INFO_push'; }  {Do not localize}
  {CH fn_sk_X509_INFO_unshift = 'sk_X509_INFO_unshift'; }  {Do not localize}
  {CH fn_sk_X509_INFO_find = 'sk_X509_INFO_find'; }  {Do not localize}
  {CH fn_sk_X509_INFO_delete = 'sk_X509_INFO_delete'; }  {Do not localize}
  {CH fn_sk_X509_INFO_delete_ptr = 'sk_X509_INFO_delete_ptr'; }  {Do not localize}
  {CH fn_sk_X509_INFO_insert = 'sk_X509_INFO_insert'; }  {Do not localize}
  {CH fn_sk_X509_INFO_dup = 'sk_X509_INFO_dup'; }  {Do not localize}
  {CH fn_sk_X509_INFO_pop_free = 'sk_X509_INFO_pop_free'; }  {Do not localize}
  {CH fn_sk_X509_INFO_shift = 'sk_X509_INFO_shift'; }  {Do not localize}
  {CH fn_sk_X509_INFO_pop = 'sk_X509_INFO_pop'; }  {Do not localize}
  {CH fn_sk_X509_INFO_sort = 'sk_X509_INFO_sort'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_new = 'sk_X509_LOOKUP_new'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_new_null = 'sk_X509_LOOKUP_new_null'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_free = 'sk_X509_LOOKUP_free'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_num = 'sk_X509_LOOKUP_num'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_value = 'sk_X509_LOOKUP_value'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_set = 'sk_X509_LOOKUP_set'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_zero = 'sk_X509_LOOKUP_zero'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_push = 'sk_X509_LOOKUP_push'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_unshift = 'sk_X509_LOOKUP_unshift'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_find = 'sk_X509_LOOKUP_find'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_delete = 'sk_X509_LOOKUP_delete'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_delete_ptr = 'sk_X509_LOOKUP_delete_ptr'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_insert = 'sk_X509_LOOKUP_insert'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_dup = 'sk_X509_LOOKUP_dup'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_pop_free = 'sk_X509_LOOKUP_pop_free'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_shift = 'sk_X509_LOOKUP_shift'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_pop = 'sk_X509_LOOKUP_pop'; }  {Do not localize}
  {CH fn_sk_X509_LOOKUP_sort = 'sk_X509_LOOKUP_sort'; }  {Do not localize}
  {CH fn_X509_OBJECT_retrieve_by_subject = 'X509_OBJECT_retrieve_by_subject'; }  {Do not localize}
  {CH fn_X509_OBJECT_up_ref_count = 'X509_OBJECT_up_ref_count'; }  {Do not localize}
  {CH fn_X509_OBJECT_free_contents = 'X509_OBJECT_free_contents'; }  {Do not localize}
  {CH fn_X509_STORE_new = 'X509_STORE_new'; }  {Do not localize}
  {CH fn_X509_STORE_free = 'X509_STORE_free'; }  {Do not localize}
  {CH fn_X509_STORE_CTX_init = 'X509_STORE_CTX_init'; }  {Do not localize}
  {CH fn_X509_STORE_CTX_cleanup = 'X509_STORE_CTX_cleanup'; }  {Do not localize}
  fn_X509_STORE_add_lookup = 'X509_STORE_add_lookup';   {Do not localize}
  {CH fn_X509_LOOKUP_hash_dir = 'X509_LOOKUP_hash_dir'; }  {Do not localize}
  {CH fn_X509_LOOKUP_file = 'X509_LOOKUP_file'; }  {Do not localize}
  fn_X509_STORE_add_cert = 'X509_STORE_add_cert';   {Do not localize}
  fn_X509_STORE_add_crl = 'X509_STORE_add_crl';   {Do not localize}
  {CH fn_X509_STORE_get_by_subject = 'X509_STORE_get_by_subject'; }  {Do not localize}
   fn_X509_LOOKUP_ctrl = 'X509_LOOKUP_ctrl';   {Do not localize}
  {CH fn_X509_load_cert_file = 'X509_load_cert_file'; }  {Do not localize}
  {CH fn_X509_load_crl_file = 'X509_load_crl_file'; }  {Do not localize}
  {CH fn_X509_LOOKUP_new = 'X509_LOOKUP_new'; }  {Do not localize}
  {CH fn_X509_LOOKUP_free = 'X509_LOOKUP_free'; }  {Do not localize}
  {CH fn_X509_LOOKUP_init = 'X509_LOOKUP_init'; }  {Do not localize}
  {CH fn_X509_LOOKUP_by_subject = 'X509_LOOKUP_by_subject'; }  {Do not localize}
  {CH fn_X509_LOOKUP_by_issuer_serial = 'X509_LOOKUP_by_issuer_serial'; }  {Do not localize}
  {CH fn_X509_LOOKUP_by_fingerprint = 'X509_LOOKUP_by_fingerprint'; }  {Do not localize}
  {CH fn_X509_LOOKUP_by_alias = 'X509_LOOKUP_by_alias'; }  {Do not localize}
  {CH fn_X509_LOOKUP_shutdown = 'X509_LOOKUP_shutdown'; }  {Do not localize}
  fn_X509_STORE_load_locations = 'X509_STORE_load_locations';   {Do not localize}
  {CH fn_X509_STORE_set_default_paths = 'X509_STORE_set_default_paths'; }  {Do not localize}
  {CH fn_X509_STORE_CTX_get_ex_new_index = 'X509_STORE_CTX_get_ex_new_index'; }  {Do not localize}
  {CH fn_X509_STORE_CTX_set_ex_data = 'X509_STORE_CTX_set_ex_data'; }  {Do not localize}
  fn_X509_STORE_CTX_get_ex_data = 'X509_STORE_CTX_get_ex_data';  {Do not localize}
  fn_X509_STORE_CTX_get_error = 'X509_STORE_CTX_get_error';  {Do not localize}
  fn_X509_STORE_CTX_set_error = 'X509_STORE_CTX_set_error';  {Do not localize}
  fn_X509_STORE_CTX_get_error_depth = 'X509_STORE_CTX_get_error_depth';  {Do not localize}
  fn_X509_STORE_CTX_get_current_cert = 'X509_STORE_CTX_get_current_cert';  {Do not localize}
  {CH fn_X509_STORE_CTX_get_chain = 'X509_STORE_CTX_get_chain'; }  {Do not localize}
  {CH fn_X509_STORE_CTX_set_cert = 'X509_STORE_CTX_set_cert'; }  {Do not localize}
  {CH fn_X509_STORE_CTX_set_chain = 'X509_STORE_CTX_set_chain'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_new = 'sk_PKCS7_SIGNER_INFO_new'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_new_null = 'sk_PKCS7_SIGNER_INFO_new_null'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_free = 'sk_PKCS7_SIGNER_INFO_free'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_num = 'sk_PKCS7_SIGNER_INFO_num'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_value = 'sk_PKCS7_SIGNER_INFO_value'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_set = 'sk_PKCS7_SIGNER_INFO_set'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_zero = 'sk_PKCS7_SIGNER_INFO_zero'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_push = 'sk_PKCS7_SIGNER_INFO_push'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_unshift = 'sk_PKCS7_SIGNER_INFO_unshift'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_find = 'sk_PKCS7_SIGNER_INFO_find'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_delete = 'sk_PKCS7_SIGNER_INFO_delete'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_delete_ptr = 'sk_PKCS7_SIGNER_INFO_delete_ptr'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_insert = 'sk_PKCS7_SIGNER_INFO_insert'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_dup = 'sk_PKCS7_SIGNER_INFO_dup'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_pop_free = 'sk_PKCS7_SIGNER_INFO_pop_free'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_shift = 'sk_PKCS7_SIGNER_INFO_shift'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_pop = 'sk_PKCS7_SIGNER_INFO_pop'; }  {Do not localize}
  {CH fn_sk_PKCS7_SIGNER_INFO_sort = 'sk_PKCS7_SIGNER_INFO_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_PKCS7_SIGNER_INFO = 'i2d_ASN1_SET_OF_PKCS7_SIGNER_INFO'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_PKCS7_SIGNER_INFO = 'd2i_ASN1_SET_OF_PKCS7_SIGNER_INFO'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_new = 'sk_PKCS7_RECIP_INFO_new'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_new_null = 'sk_PKCS7_RECIP_INFO_new_null'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_free = 'sk_PKCS7_RECIP_INFO_free'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_num = 'sk_PKCS7_RECIP_INFO_num'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_value = 'sk_PKCS7_RECIP_INFO_value'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_set = 'sk_PKCS7_RECIP_INFO_set'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_zero = 'sk_PKCS7_RECIP_INFO_zero'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_push = 'sk_PKCS7_RECIP_INFO_push'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_unshift = 'sk_PKCS7_RECIP_INFO_unshift'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_find = 'sk_PKCS7_RECIP_INFO_find'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_delete = 'sk_PKCS7_RECIP_INFO_delete'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_delete_ptr = 'sk_PKCS7_RECIP_INFO_delete_ptr'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_insert = 'sk_PKCS7_RECIP_INFO_insert'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_dup = 'sk_PKCS7_RECIP_INFO_dup'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_pop_free = 'sk_PKCS7_RECIP_INFO_pop_free'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_shift = 'sk_PKCS7_RECIP_INFO_shift'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_pop = 'sk_PKCS7_RECIP_INFO_pop'; }  {Do not localize}
  {CH fn_sk_PKCS7_RECIP_INFO_sort = 'sk_PKCS7_RECIP_INFO_sort'; }  {Do not localize}
  {CH fn_i2d_ASN1_SET_OF_PKCS7_RECIP_INFO = 'i2d_ASN1_SET_OF_PKCS7_RECIP_INFO'; }  {Do not localize}
  {CH fn_d2i_ASN1_SET_OF_PKCS7_RECIP_INFO = 'd2i_ASN1_SET_OF_PKCS7_RECIP_INFO'; }  {Do not localize}
  {CH fn_PKCS7_ISSUER_AND_SERIAL_new = 'PKCS7_ISSUER_AND_SERIAL_new'; }  {Do not localize}
  {CH fn_PKCS7_ISSUER_AND_SERIAL_free = 'PKCS7_ISSUER_AND_SERIAL_free'; }  {Do not localize}
  {CH fn_i2d_PKCS7_ISSUER_AND_SERIAL = 'i2d_PKCS7_ISSUER_AND_SERIAL'; }  {Do not localize}
  {CH fn_d2i_PKCS7_ISSUER_AND_SERIAL = 'd2i_PKCS7_ISSUER_AND_SERIAL'; }  {Do not localize}
  {CH fn_PKCS7_ISSUER_AND_SERIAL_digest = 'PKCS7_ISSUER_AND_SERIAL_digest'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_d2i_PKCS7_fp = 'd2i_PKCS7_fp'; }  {Do not localize}
  {CH fn_i2d_PKCS7_fp = 'i2d_PKCS7_fp'; }  {Do not localize}
  {$ENDIF}
  {CH fn_PKCS7_dup = 'PKCS7_dup'; }  {Do not localize}
  {CH fn_d2i_PKCS7_bio = 'd2i_PKCS7_bio'; }  {Do not localize}
  {CH fn_i2d_PKCS7_bio = 'i2d_PKCS7_bio'; }  {Do not localize}
  {CH fn_PKCS7_SIGNER_INFO_new = 'PKCS7_SIGNER_INFO_new'; }  {Do not localize}
  {CH fn_PKCS7_SIGNER_INFO_free = 'PKCS7_SIGNER_INFO_free'; }  {Do not localize}
  {CH fn_i2d_PKCS7_SIGNER_INFO = 'i2d_PKCS7_SIGNER_INFO'; }  {Do not localize}
  {CH fn_d2i_PKCS7_SIGNER_INFO = 'd2i_PKCS7_SIGNER_INFO'; }  {Do not localize}
  {CH fn_PKCS7_RECIP_INFO_new = 'PKCS7_RECIP_INFO_new'; }  {Do not localize}
  {CH fn_PKCS7_RECIP_INFO_free = 'PKCS7_RECIP_INFO_free'; }  {Do not localize}
  {CH fn_i2d_PKCS7_RECIP_INFO = 'i2d_PKCS7_RECIP_INFO'; }  {Do not localize}
  {CH fn_d2i_PKCS7_RECIP_INFO = 'd2i_PKCS7_RECIP_INFO'; }  {Do not localize}
  {CH fn_PKCS7_SIGNED_new = 'PKCS7_SIGNED_new'; }  {Do not localize}
  {CH fn_PKCS7_SIGNED_free = 'PKCS7_SIGNED_free'; }  {Do not localize}
  {CH fn_i2d_PKCS7_SIGNED = 'i2d_PKCS7_SIGNED'; }  {Do not localize}
  {CH fn_d2i_PKCS7_SIGNED = 'd2i_PKCS7_SIGNED'; }  {Do not localize}
  {CH fn_PKCS7_ENC_CONTENT_new = 'PKCS7_ENC_CONTENT_new'; }  {Do not localize}
  {CH fn_PKCS7_ENC_CONTENT_free = 'PKCS7_ENC_CONTENT_free'; }  {Do not localize}
  {CH fn_i2d_PKCS7_ENC_CONTENT = 'i2d_PKCS7_ENC_CONTENT'; }  {Do not localize}
  {CH fn_d2i_PKCS7_ENC_CONTENT = 'd2i_PKCS7_ENC_CONTENT'; }  {Do not localize}
  {CH fn_PKCS7_ENVELOPE_new = 'PKCS7_ENVELOPE_new'; }  {Do not localize}
  {CH fn_PKCS7_ENVELOPE_free = 'PKCS7_ENVELOPE_free'; }  {Do not localize}
  {CH fn_i2d_PKCS7_ENVELOPE = 'i2d_PKCS7_ENVELOPE'; }  {Do not localize}
  {CH fn_d2i_PKCS7_ENVELOPE = 'd2i_PKCS7_ENVELOPE'; }  {Do not localize}
  {CH fn_PKCS7_SIGN_ENVELOPE_new = 'PKCS7_SIGN_ENVELOPE_new'; }  {Do not localize}
  {CH fn_PKCS7_SIGN_ENVELOPE_free = 'PKCS7_SIGN_ENVELOPE_free'; }  {Do not localize}
  {CH fn_i2d_PKCS7_SIGN_ENVELOPE = 'i2d_PKCS7_SIGN_ENVELOPE'; }  {Do not localize}
  {CH fn_d2i_PKCS7_SIGN_ENVELOPE = 'd2i_PKCS7_SIGN_ENVELOPE'; }  {Do not localize}
  {CH fn_PKCS7_DIGEST_new = 'PKCS7_DIGEST_new'; }  {Do not localize}
  {CH fn_PKCS7_DIGEST_free = 'PKCS7_DIGEST_free'; }  {Do not localize}
  {CH fn_i2d_PKCS7_DIGEST = 'i2d_PKCS7_DIGEST'; }  {Do not localize}
  {CH fn_d2i_PKCS7_DIGEST = 'd2i_PKCS7_DIGEST'; }  {Do not localize}
  {CH fn_PKCS7_ENCRYPT_new = 'PKCS7_ENCRYPT_new'; }  {Do not localize}
  {CH fn_PKCS7_ENCRYPT_free = 'PKCS7_ENCRYPT_free'; }  {Do not localize}
  {CH fn_i2d_PKCS7_ENCRYPT = 'i2d_PKCS7_ENCRYPT'; }  {Do not localize}
  {CH fn_d2i_PKCS7_ENCRYPT = 'd2i_PKCS7_ENCRYPT'; }  {Do not localize}
  {CH fn_PKCS7_new = 'PKCS7_new'; }  {Do not localize}
  {CH fn_PKCS7_free = 'PKCS7_free'; }  {Do not localize}
  {CH fn_PKCS7_content_free = 'PKCS7_content_free'; }  {Do not localize}
  fn_i2d_PKCS7 = 'i2d_PKCS7';   {Do not localize}
   fn_d2i_PKCS7 = 'd2i_PKCS7';   {Do not localize}
  {CH fn_ERR_load_PKCS7_strings = 'ERR_load_PKCS7_strings'; }  {Do not localize}
  {CH fn_PKCS7_ctrl = 'PKCS7_ctrl'; }  {Do not localize}
  {CH fn_PKCS7_set_type = 'PKCS7_set_type'; }  {Do not localize}
  {CH fn_PKCS7_set_content = 'PKCS7_set_content'; }  {Do not localize}
  {CH fn_PKCS7_SIGNER_INFO_set = 'PKCS7_SIGNER_INFO_set'; }  {Do not localize}
  {CH fn_PKCS7_add_signer = 'PKCS7_add_signer'; }  {Do not localize}
  {CH fn_PKCS7_add_certificate = 'PKCS7_add_certificate'; }  {Do not localize}
  {CH fn_PKCS7_add_crl = 'PKCS7_add_crl'; }  {Do not localize}
  {CH fn_PKCS7_content_new = 'PKCS7_content_new'; }  {Do not localize}
  {CH fn_PKCS7_dataVerify = 'PKCS7_dataVerify'; }  {Do not localize}
  {CH fn_PKCS7_signatureVerify = 'PKCS7_signatureVerify'; }  {Do not localize}
  {CH fn_PKCS7_dataInit = 'PKCS7_dataInit'; }  {Do not localize}
  {CH fn_PKCS7_dataFinal = 'PKCS7_dataFinal'; }  {Do not localize}
  {CH fn_PKCS7_dataDecode = 'PKCS7_dataDecode'; }  {Do not localize}
  {CH fn_PKCS7_add_signature = 'PKCS7_add_signature'; }  {Do not localize}
  {CH fn_PKCS7_cert_from_signer_info = 'PKCS7_cert_from_signer_info'; }  {Do not localize}
  {CH fn_PKCS7_get_signer_info = 'PKCS7_get_signer_info'; }  {Do not localize}
  {CH fn_PKCS7_add_recipient = 'PKCS7_add_recipient'; }  {Do not localize}
  {CH fn_PKCS7_add_recipient_info = 'PKCS7_add_recipient_info'; }  {Do not localize}
  {CH fn_PKCS7_RECIP_INFO_set = 'PKCS7_RECIP_INFO_set'; }  {Do not localize}
  {CH fn_PKCS7_set_cipher = 'PKCS7_set_cipher'; }  {Do not localize}
  {CH fn_PKCS7_get_issuer_and_serial = 'PKCS7_get_issuer_and_serial'; }  {Do not localize}
  {CH fn_PKCS7_digest_from_attributes = 'PKCS7_digest_from_attributes'; }  {Do not localize}
  {CH fn_PKCS7_add_signed_attribute = 'PKCS7_add_signed_attribute'; }  {Do not localize}
  {CH fn_PKCS7_add_attribute = 'PKCS7_add_attribute'; }  {Do not localize}
  {CH fn_PKCS7_get_attribute = 'PKCS7_get_attribute'; }  {Do not localize}
  {CH fn_PKCS7_get_signed_attribute = 'PKCS7_get_signed_attribute'; }  {Do not localize}
  {CH fn_PKCS7_set_signed_attributes = 'PKCS7_set_signed_attributes'; }  {Do not localize}
  {CH fn_PKCS7_set_attributes = 'PKCS7_set_attributes'; }  {Do not localize}
  {CH fn_X509_verify_cert_error_string = 'X509_verify_cert_error_string'; }  {Do not localize}
  fn_X509_verify = 'X509_verify';   {Do not localize}
  {CH fn_X509_REQ_verify = 'X509_REQ_verify'; }  {Do not localize}
  {CH fn_X509_CRL_verify = 'X509_CRL_verify'; }  {Do not localize}
  {CH fn_NETSCAPE_SPKI_verify = 'NETSCAPE_SPKI_verify'; }  {Do not localize}
  fn_X509_sign = 'X509_sign';  {Do not localize}
  fn_X509_REQ_sign = 'X509_REQ_sign';  {Do not localize}
  fn_X509V3_set_ctx = 'X509V3_set_ctx'; {Do not localize}
  fn_X509V3_EXT_conf_nid = 'X509V3_EXT_conf_nid'; {Do not localize}
  fn_X509_REQ_add_extensions = 'X509_REQ_add_extensions'; {Do not localize}
  {CH fn_X509_CRL_sign = 'X509_CRL_sign'; }  {Do not localize}
  {CH fn_NETSCAPE_SPKI_sign = 'NETSCAPE_SPKI_sign'; }  {Do not localize}
  fn_X509_digest = 'X509_digest';  {Do not localize}
  {CH fn_X509_NAME_digest = 'X509_NAME_digest'; }  {Do not localize}
  {CH fn_d2i_X509_fp = 'd2i_X509_fp'; }  {Do not localize}
  {CH fn_i2d_X509_fp = 'i2d_X509_fp'; }  {Do not localize}
  {CH fn_d2i_X509_CRL_fp = 'd2i_X509_CRL_fp'; }  {Do not localize}
  {CH fn_i2d_X509_CRL_fp = 'i2d_X509_CRL_fp'; }  {Do not localize}
  {CH fn_d2i_X509_REQ_fp = 'd2i_X509_REQ_fp'; }  {Do not localize}
  {CH fn_i2d_X509_REQ_fp = 'i2d_X509_REQ_fp'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_RSA}
  {CH fn_d2i_RSAPrivateKey_fp = 'd2i_RSAPrivateKey_fp'; }  {Do not localize}
  {CH fn_i2d_RSAPrivateKey_fp = 'i2d_RSAPrivateKey_fp'; }  {Do not localize}
  {CH fn_d2i_RSAPublicKey_fp = 'd2i_RSAPublicKey_fp'; }  {Do not localize}
  {CH fn_i2d_RSAPublicKey_fp = 'i2d_RSAPublicKey_fp'; }  {Do not localize}
  {CH fn_d2i_RSA_PUBKEY_fp = 'd2i_RSA_PUBKEY_fp'; } {Do not localize}
  {CH fn_i2d_RSA_PUBKEY_fp = 'i2d_RSA_PUBKEY_fp'; } {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_DSA}
  {CH fn_d2i_DSA_PUBKEY_fp = 'd2i_DSA_PUBKEY_fp'; } {Do not localize}
  {CH fn_i2d_DSA_PUBKEY_fp = 'i2d_DSA_PUBKEY_fp'; } {Do not localize}
  {CH fn_d2i_DSAPrivateKey_fp = 'd2i_DSAPrivateKey_fp'; }  {Do not localize}
  {CH fn_i2d_DSAPrivateKey_fp = 'i2d_DSAPrivateKey_fp'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_EC}
  {CH fn_d2i_EC_PUBKEY_fp = 'd2i_EC_PUBKEY_fp'; } {Do not localize}
  {CH fn_i2d_EC_PUBKEY_fp = 'i2d_EC_PUBKEY_fp'; } {Do not localize}
  {CH fn_d2i_ECPrivateKey_fp = 'd2i_ECPrivateKey_fp'; } {Do not localize}
  {CH fn_i2d_ECPrivateKey_fp = 'i2d_ECPrivateKey_fp'; } {Do not localize}
  {$ENDIF}
  {CH fn_d2i_PKCS8_fp = 'd2i_PKCS8_fp'; }  {Do not localize}
  {CH fn_i2d_PKCS8_fp = 'i2d_PKCS8_fp'; }  {Do not localize}
  {CH fn_d2i_PKCS8_PRIV_KEY_INFO_fp = 'd2i_PKCS8_PRIV_KEY_INFO_fp'; }  {Do not localize}
  {CH fn_i2d_PKCS8_PRIV_KEY_INFO_fp = 'i2d_PKCS8_PRIV_KEY_INFO_fp'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_BIO}
  fn_d2i_X509_bio = 'd2i_X509_bio';  {Do not localize}
  fn_i2d_X509_bio = 'i2d_X509_bio';  {Do not localize}
  fn_d2i_PKCS12_bio = 'd2i_PKCS12_bio';  {Do not localize}
  fn_PKCS12_parse = 'PKCS12_parse';  {Do not localize}
  fn_i2d_PrivateKey_bio = 'i2d_PrivateKey_bio'; {Do not localize}
  fn_d2i_X509_CRL_bio = 'd2i_X509_CRL_bio';   {Do not localize}
  fn_i2d_X509_CRL_bio = 'i2d_X509_CRL_bio';   {Do not localize}
  fn_d2i_X509_REQ_bio = 'd2i_X509_REQ_bio';   {Do not localize}
  fn_i2d_X509_REQ_bio = 'i2d_X509_REQ_bio';  {Do not localize}
    {$IFNDEF OPENSSL_NO_RSA}
  fn_d2i_RSAPrivateKey_bio = 'd2i_RSAPrivateKey_bio';  {Do not localize}
  fn_i2d_RSAPrivateKey_bio = 'i2d_RSAPrivateKey_bio';  {Do not localize}
  fn_d2i_RSAPublicKey_bio = 'd2i_RSAPublicKey_bio';   {Do not localize}
  fn_i2d_RSAPublicKey_bio = 'i2d_RSAPublicKey_bio';   {Do not localize}
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_DSA}
  {CH fn_d2i_DSA_PUBKEY_bio = 'd2i_DSA_PUBKEY_bio'; } {Do not localize}
  {CH fn_i2d_DSA_PUBKEY_bio = 'i2d_DSA_PUBKEY_bio'; } {Do not localize}
  {CH fn_d2i_DSAPrivateKey_bio = 'd2i_DSAPrivateKey_bio'; }  {Do not localize}
  {CH fn_i2d_DSAPrivateKey_bio = 'i2d_DSAPrivateKey_bio'; }  {Do not localize}
    {$ENDIF}
    {$IFNDEF OPENSSL_NO_EC}
  {CH fn_d2i_EC_PUBKEY_bio = 'd2i_EC_PUBKEY_bio'; } {Do not localize}
  {CH fn_i2d_EC_PUBKEY_bio = 'i2d_EC_PUBKEY_bio'; } {Do not localize}
  {CH fn_d2i_ECPrivateKey_bio = 'd2i_ECPrivateKey_bio'; } {Do not localize}
  {CH fn_i2d_ECPrivateKey_bio = 'i2d_ECPrivateKey_bio'; } {Do not localize}
    {$ENDIF}
  {CH fn_d2i_PKCS8_bio = 'd2i_PKCS8_bio'; }  {Do not localize}
  {CH fn_i2d_PKCS8_bio = 'i2d_PKCS8_bio'; }  {Do not localize}
  {CH fn_d2i_PKCS8_PRIV_KEY_INFO_bio = 'd2i_PKCS8_PRIV_KEY_INFO_bio'; }  {Do not localize}
  {CH fn_i2d_PKCS8_PRIV_KEY_INFO_bio = 'i2d_PKCS8_PRIV_KEY_INFO_bio'; }  {Do not localize}
  fn_d2i_PrivateKey_bio = 'd2i_PrivateKey_bio';  {Do not localize}
  {CH fn_i2d_PUBKEY_bio = 'i2d_PUBKEY_bio'; } {Do not localize}
  {CH fn_d2i_PUBKEY_bio = 'd2i_PUBKEY_bio'; } {Do not localize}
  {$ENDIF}
  {CH fn_X509_dup = 'X509_dup'; }  {Do not localize}
  {CH fn_X509_ATTRIBUTE_dup = 'X509_ATTRIBUTE_dup'; }  {Do not localize}
  {CH fn_X509_EXTENSION_dup = 'X509_EXTENSION_dup'; }  {Do not localize}
  {CH fn_X509_CRL_dup = 'X509_CRL_dup'; }  {Do not localize}
  {CH fn_X509_REQ_dup = 'X509_REQ_dup'; }  {Do not localize}
  {CH fn_X509_ALGOR_dup = 'X509_ALGOR_dup'; }  {Do not localize}
  {CH fn_X509_NAME_dup = 'X509_NAME_dup'; }  {Do not localize}
  {CH fn_X509_NAME_ENTRY_dup = 'X509_NAME_ENTRY_dup'; }  {Do not localize}
  {CH fn_RSAPublicKey_dup = 'RSAPublicKey_dup'; }  {Do not localize}
  {CH fn_RSAPrivateKey_dup = 'RSAPrivateKey_dup'; }  {Do not localize}
  {CH fn_X509_cmp_current_time = 'X509_cmp_current_time'; }  {Do not localize}
  fn_X509_gmtime_adj = 'X509_gmtime_adj';  {Do not localize}
  {CH fn_X509_get_default_cert_area = 'X509_get_default_cert_area'; }  {Do not localize}
  {CH fn_X509_get_default_cert_dir = 'X509_get_default_cert_dir'; }  {Do not localize}
   fn_X509_get_default_cert_file = 'X509_get_default_cert_file';   {Do not localize}
  {CH fn_X509_get_default_cert_dir_env = 'X509_get_default_cert_dir_env'; }  {Do not localize}
  fn_X509_get_default_cert_file_env = 'X509_get_default_cert_file_env';   {Do not localize}
  {CH fn_X509_get_default_private_dir = 'X509_get_default_private_dir'; }  {Do not localize}
  fn_X509_to_X509_REQ = 'X509_to_X509_REQ';  {Do not localize}
  {CH fn_X509_REQ_to_X509 = 'X509_REQ_to_X509'; }  {Do not localize}
  fn_X509_NAME_add_entry_by_txt = 'X509_NAME_add_entry_by_txt'; {Do not localize}
  {CH fn_ERR_load_X509_strings = 'ERR_load_X509_strings'; }  {Do not localize}
  {CH fn_X509_ALGOR_new = 'X509_ALGOR_new'; }  {Do not localize}
  {CH fn_X509_ALGOR_free = 'X509_ALGOR_free'; }  {Do not localize}
  {CH fn_i2d_X509_ALGOR = 'i2d_X509_ALGOR'; }  {Do not localize}
  {CH fn_d2i_X509_ALGOR = 'd2i_X509_ALGOR'; }  {Do not localize}
  {CH fn_X509_VAL_new = 'X509_VAL_new'; }  {Do not localize}
  {CH fn_X509_VAL_free = 'X509_VAL_free'; }  {Do not localize}
  {CH fn_i2d_X509_VAL = 'i2d_X509_VAL'; }  {Do not localize}
  {CH fn_d2i_X509_VAL = 'd2i_X509_VAL'; }  {Do not localize}
  {CH fn_X509_PUBKEY_new = 'X509_PUBKEY_new'; }  {Do not localize}
  {CH fn_X509_PUBKEY_free = 'X509_PUBKEY_free'; }  {Do not localize}
  {CH fn_i2d_X509_PUBKEY = 'i2d_X509_PUBKEY'; }  {Do not localize}
  {CH fn_d2i_X509_PUBKEY = 'd2i_X509_PUBKEY'; }  {Do not localize}
  {CH fn_X509_PUBKEY_set = 'X509_PUBKEY_set'; }  {Do not localize}
  fn_X509_PUBKEY_get = 'X509_PUBKEY_get';   {Do not localize}
  {CH fn_X509_get_pubkey_parameters = 'X509_get_pubkey_parameters'; }  {Do not localize}
  {CH fn_X509_SIG_new = 'X509_SIG_new'; }  {Do not localize}
  {CH fn_X509_SIG_free = 'X509_SIG_free'; }  {Do not localize}
  {CH fn_i2d_X509_SIG = 'i2d_X509_SIG'; }  {Do not localize}
  {CH fn_d2i_X509_SIG = 'd2i_X509_SIG'; }  {Do not localize}
  {CH fn_X509_REQ_INFO_new = 'X509_REQ_INFO_new'; }  {Do not localize}
  {CH fn_X509_REQ_INFO_free = 'X509_REQ_INFO_free'; }  {Do not localize}
  {CH fn_i2d_X509_REQ_INFO = 'i2d_X509_REQ_INFO'; }  {Do not localize}
  {CH fn_d2i_X509_REQ_INFO = 'd2i_X509_REQ_INFO'; }  {Do not localize}
  fn_X509_REQ_new = 'X509_REQ_new';  {Do not localize}
  fn_X509_REQ_free = 'X509_REQ_free';  {Do not localize}
  fn_i2d_X509_REQ = 'i2d_X509_REQ';   {Do not localize}
  fn_d2i_X509_REQ = 'd2i_X509_REQ';   {Do not localize}
  {CH fn_X509_ATTRIBUTE_new = 'X509_ATTRIBUTE_new'; }  {Do not localize}
  {CH fn_X509_ATTRIBUTE_free = 'X509_ATTRIBUTE_free'; }  {Do not localize}
  {CH fn_i2d_X509_ATTRIBUTE = 'i2d_X509_ATTRIBUTE'; }  {Do not localize}
  {CH fn_d2i_X509_ATTRIBUTE = 'd2i_X509_ATTRIBUTE'; }  {Do not localize}
  {CH fn_X509_ATTRIBUTE_create = 'X509_ATTRIBUTE_create'; }  {Do not localize}
  {CH fn_X509_EXTENSION_new = 'X509_EXTENSION_new'; }  {Do not localize}
  fn_X509_EXTENSION_free = 'X509_EXTENSION_free';  {Do not localize}
  {CH fn_i2d_X509_EXTENSION = 'i2d_X509_EXTENSION'; }  {Do not localize}
  {CH fn_d2i_X509_EXTENSION = 'd2i_X509_EXTENSION'; }  {Do not localize}
  {CH fn_X509_NAME_ENTRY_new = 'X509_NAME_ENTRY_new'; }  {Do not localize}
  {CH fn_X509_NAME_ENTRY_free = 'X509_NAME_ENTRY_free'; }  {Do not localize}
  fn_i2d_X509_NAME_ENTRY = 'i2d_X509_NAME_ENTRY';   {Do not localize}
  fn_d2i_X509_NAME_ENTRY = 'd2i_X509_NAME_ENTRY';   {Do not localize}
  fn_X509_NAME_new = 'X509_NAME_new';   {Do not localize}
  fn_X509_NAME_free = 'X509_NAME_free';   {Do not localize}
   fn_i2d_X509_NAME = 'i2d_X509_NAME';   {Do not localize}
  fn_d2i_X509_NAME = 'd2i_X509_NAME';   {Do not localize}
  {CH fn_X509_NAME_set = 'X509_NAME_set'; }  {Do not localize}
  {CH fn_X509_CINF_new = 'X509_CINF_new'; }  {Do not localize}
  {CH fn_X509_CINF_free = 'X509_CINF_free'; }  {Do not localize}
  {CH fn_i2d_X509_CINF = 'i2d_X509_CINF'; }  {Do not localize}
  {CH fn_d2i_X509_CINF = 'd2i_X509_CINF'; }  {Do not localize}
  fn_X509_new = 'X509_new';  {Do not localize}
  fn_X509_free = 'X509_free';  {Do not localize}
  fn_i2d_X509 = 'i2d_X509';  {Do not localize}
  fn_d2i_X509 = 'd2i_X509';  {Do not localize}
  {CH fn_X509_REVOKED_new = 'X509_REVOKED_new'; }  {Do not localize}
  {CH fn_X509_REVOKED_free = 'X509_REVOKED_free'; }  {Do not localize}
  {CH fn_i2d_X509_REVOKED = 'i2d_X509_REVOKED'; }  {Do not localize}
  {CH fn_d2i_X509_REVOKED = 'd2i_X509_REVOKED'; }  {Do not localize}
  {CH fn_X509_CRL_INFO_new = 'X509_CRL_INFO_new'; }  {Do not localize}
  {CH fn_X509_CRL_INFO_free = 'X509_CRL_INFO_free'; }  {Do not localize}
  {CH fn_i2d_X509_CRL_INFO = 'i2d_X509_CRL_INFO'; }  {Do not localize}
  {CH fn_d2i_X509_CRL_INFO = 'd2i_X509_CRL_INFO'; }  {Do not localize}
  {CH fn_X509_CRL_new = 'X509_CRL_new'; }  {Do not localize}
  {CH fn_X509_CRL_free = 'X509_CRL_free'; }  {Do not localize}
  fn_i2d_X509_CRL = 'i2d_X509_CRL';   {Do not localize}
  fn_d2i_X509_CRL = 'd2i_X509_CRL';   {Do not localize}
  {CH fn_X509_PKEY_new = 'X509_PKEY_new'; }  {Do not localize}
  {CH fn_X509_PKEY_free = 'X509_PKEY_free'; }  {Do not localize}
  {CH fn_i2d_X509_PKEY = 'i2d_X509_PKEY'; }  {Do not localize}
  {CH fn_d2i_X509_PKEY = 'd2i_X509_PKEY'; }  {Do not localize}
  {CH fn_NETSCAPE_SPKI_new = 'NETSCAPE_SPKI_new'; }  {Do not localize}
  {CH fn_NETSCAPE_SPKI_free = 'NETSCAPE_SPKI_free'; }  {Do not localize}
  {CH fn_i2d_NETSCAPE_SPKI = 'i2d_NETSCAPE_SPKI'; }  {Do not localize}
  {CH fn_d2i_NETSCAPE_SPKI = 'd2i_NETSCAPE_SPKI'; }  {Do not localize}
  {CH fn_NETSCAPE_SPKAC_new = 'NETSCAPE_SPKAC_new'; }  {Do not localize}
  {CH fn_NETSCAPE_SPKAC_free = 'NETSCAPE_SPKAC_free'; }  {Do not localize}
  {CH fn_i2d_NETSCAPE_SPKAC = 'i2d_NETSCAPE_SPKAC'; }  {Do not localize}
  {CH fn_d2i_NETSCAPE_SPKAC = 'd2i_NETSCAPE_SPKAC'; }  {Do not localize}
   fn_i2d_NETSCAPE_CERT_SEQUENCE = 'i2d_NETSCAPE_CERT_SEQUENCE';   {Do not localize}
   fn_d2i_NETSCAPE_CERT_SEQUENCE = 'd2i_NETSCAPE_CERT_SEQUENCE';   {Do not localize}
   fn_i2d_PUBKEY = 'i2d_PUBKEY';   {Do not localize}
   fn_d2i_PUBKEY = 'd2i_PUBKEY';   {Do not localize}

  {CH fn_NETSCAPE_CERT_SEQUENCE_new = 'NETSCAPE_CERT_SEQUENCE_new'; }  {Do not localize}
  {CH fn_NETSCAPE_CERT_SEQUENCE_free = 'NETSCAPE_CERT_SEQUENCE_free'; }  {Do not localize}
  {CH fn_X509_INFO_new = 'X509_INFO_new'; }  {Do not localize}
  fn_X509_INFO_free = 'X509_INFO_free';   {Do not localize}
  fn_X509_NAME_oneline = 'X509_NAME_oneline';  {Do not localize}
  {CH fn_ASN1_verify = 'ASN1_verify'; }  {Do not localize}
  {CH fn_ASN1_digest = 'ASN1_digest'; }  {Do not localize}
  {CH fn_ASN1_sign = 'ASN1_sign'; }  {Do not localize}
  fn_X509_set_version = 'X509_set_version';  {Do not localize}
  {CH fn_X509_set_serialNumber = 'X509_set_serialNumber'; }  {Do not localize}
  fn_X509_get_serialNumber = 'X509_get_serialNumber';  {Do not localize}
  fn_X509_set_issuer_name = 'X509_set_issuer_name';  {Do not localize}
  fn_X509_get_issuer_name = 'X509_get_issuer_name';  {Do not localize}
  fn_X509_set_subject_name = 'X509_set_subject_name';  {Do not localize}
  fn_X509_get_subject_name = 'X509_get_subject_name';  {Do not localize}
  fn_X509_set_notBefore = 'X509_set_notBefore';  {Do not localize}
  fn_X509_set_notAfter = 'X509_set_notAfter';  {Do not localize}
  fn_X509_set_pubkey = 'X509_set_pubkey';  {Do not localize}
  {CH fn_X509_get_pubkey = 'X509_get_pubkey'; }  {Do not localize}
  {CH fn_X509_certificate_type = 'X509_certificate_type'; }  {Do not localize}
  {CH fn_X509_REQ_set_version = 'X509_REQ_set_version'; }  {Do not localize}
  {CH fn_X509_REQ_set_subject_name = 'X509_REQ_set_subject_name'; }  {Do not localize}
  fn_X509_REQ_set_pubkey = 'X509_REQ_set_pubkey';  {Do not localize}
  {CH fn_X509_REQ_get_pubkey = 'X509_REQ_get_pubkey'; }  {Do not localize}
  {CH fn_X509_check_private_key = 'X509_check_private_key'; }  {Do not localize}
  {CH fn_X509_issuer_and_serial_cmp = 'X509_issuer_and_serial_cmp'; }  {Do not localize}
  {CH fn_X509_issuer_and_serial_hash = 'X509_issuer_and_serial_hash'; }  {Do not localize}
  {CH fn_X509_issuer_name_cmp = 'X509_issuer_name_cmp'; }  {Do not localize}
  {CH fn_X509_issuer_name_hash = 'X509_issuer_name_hash'; }  {Do not localize}
  {CH fn_X509_subject_name_cmp = 'X509_subject_name_cmp'; }  {Do not localize}
  {CH fn_X509_subject_name_hash = 'X509_subject_name_hash'; }  {Do not localize}
  fn_X509_NAME_cmp = 'X509_NAME_cmp';  {Do not localize}
  fn_X509_NAME_hash = 'X509_NAME_hash';  {Do not localize}
  {CH fn_X509_CRL_cmp = 'X509_CRL_cmp'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_X509_print_ex_fp = 'X509_print_ex_fp'; } {Do not localize}
  {CH fn_X509_print_fp = 'X509_print_fp'; } {Do not localize}
  {CH fn_X509_CRL_print_fp = 'X509_CRL_print_fp'; }  {Do not localize}
  {CH fn_X509_REQ_print_fp = 'X509_REQ_print_fp'; }  {Do not localize}
  {CH fn_X509_NAME_print_ex_fp = 'X509_NAME_print_ex_fp'; } {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_BIO}
  {CH fn_X509_NAME_print = 'X509_NAME_print'; }  {Do not localize}
  {CH fn_X509_NAME_print_ex = 'X509_NAME_print_ex'; } {Do not localize}
  {CH fn_X509_print_ex = 'X509_print_ex'; } {Do not localize}
  fn_X509_print = 'X509_print';  {Do not localize}
  {CH fn_X509_ocspid_print = 'X509_ocspid_print'; } {Do not localize}
  {CH fn_X509_CERT_AUX_print = 'X509_CERT_AUX_print'; } {Do not localize}
  {CH fn_X509_CRL_print = 'X509_CRL_print'; }  {Do not localize}
  {CH fn_X509_REQ_print = 'X509_REQ_print'; }  {Do not localize}
  {CH fn_X509_REQ_print_ex = 'X509_REQ_print_ex'; } {Do not localize}
  {$ENDIF}
  {CH fn_X509_NAME_entry_count = 'X509_NAME_entry_count'; }  {Do not localize}
  {CH fn_X509_NAME_get_text_by_NID = 'X509_NAME_get_text_by_NID'; }  {Do not localize}
  {CH fn_X509_NAME_get_text_by_OBJ = 'X509_NAME_get_text_by_OBJ'; }  {Do not localize}
  {CH fn_X509_NAME_get_index_by_NID = 'X509_NAME_get_index_by_NID'; }  {Do not localize}
  {CH fn_X509_NAME_get_index_by_OBJ = 'X509_NAME_get_index_by_OBJ'; }  {Do not localize}
  {CH fn_X509_NAME_get_entry = 'X509_NAME_get_entry'; }  {Do not localize}
  {CH fn_X509_NAME_delete_entry = 'X509_NAME_delete_entry'; }  {Do not localize}
  {CH fn_X509_NAME_add_entry = 'X509_NAME_add_entry'; }  {Do not localize}
  {CH fn_X509_NAME_ENTRY_create_by_NID = 'X509_NAME_ENTRY_create_by_NID'; }  {Do not localize}
  {CH fn_X509_NAME_ENTRY_create_by_OBJ = 'X509_NAME_ENTRY_create_by_OBJ'; }  {Do not localize}
  {CH fn_X509_NAME_ENTRY_set_object = 'X509_NAME_ENTRY_set_object'; }  {Do not localize}
  {CH fn_X509_NAME_ENTRY_set_data = 'X509_NAME_ENTRY_set_data'; }  {Do not localize}
  {CH fn_X509_NAME_ENTRY_get_object = 'X509_NAME_ENTRY_get_object'; }  {Do not localize}
  {CH fn_X509_NAME_ENTRY_get_data = 'X509_NAME_ENTRY_get_data'; }  {Do not localize}
  {CH fn_X509v3_get_ext_count = 'X509v3_get_ext_count'; }  {Do not localize}
  {CH fn_X509v3_get_ext_by_NID = 'X509v3_get_ext_by_NID'; }  {Do not localize}
  {CH fn_X509v3_get_ext_by_OBJ = 'X509v3_get_ext_by_OBJ'; }  {Do not localize}
  {CH fn_X509v3_get_ext_by_critical = 'X509v3_get_ext_by_critical'; }  {Do not localize}
  {CH fn_X509v3_get_ext = 'X509v3_get_ext'; }  {Do not localize}
  {CH fn_X509v3_delete_ext = 'X509v3_delete_ext'; }  {Do not localize}
  {CH fn_X509v3_add_ext = 'X509v3_add_ext'; }  {Do not localize}
  {CH fn_X509_get_ext_count = 'X509_get_ext_count'; }  {Do not localize}
  {CH fn_X509_get_ext_by_NID = 'X509_get_ext_by_NID'; }  {Do not localize}
  {CH fn_X509_get_ext_by_OBJ = 'X509_get_ext_by_OBJ'; }  {Do not localize}
  {CH fn_X509_get_ext_by_critical = 'X509_get_ext_by_critical'; }  {Do not localize}
  {CH fn_X509_get_ext = 'X509_get_ext'; }  {Do not localize}
  {CH fn_X509_delete_ext = 'X509_delete_ext'; }  {Do not localize}
  fn_X509_add_ext = 'X509_add_ext';  {Do not localize}
  {CH fn_X509_CRL_get_ext_count = 'X509_CRL_get_ext_count'; }  {Do not localize}
  {CH fn_X509_CRL_get_ext_by_NID = 'X509_CRL_get_ext_by_NID'; }  {Do not localize}
  {CH fn_X509_CRL_get_ext_by_OBJ = 'X509_CRL_get_ext_by_OBJ'; }  {Do not localize}
  {CH fn_X509_CRL_get_ext_by_critical = 'X509_CRL_get_ext_by_critical'; }  {Do not localize}
  {CH fn_X509_CRL_get_ext = 'X509_CRL_get_ext'; }  {Do not localize}
  {CH fn_X509_CRL_delete_ext = 'X509_CRL_delete_ext'; }  {Do not localize}
  {CH fn_X509_CRL_add_ext = 'X509_CRL_add_ext'; }  {Do not localize}
  {CH fn_X509_REVOKED_get_ext_count = 'X509_REVOKED_get_ext_count'; }  {Do not localize}
  {CH fn_X509_REVOKED_get_ext_by_NID = 'X509_REVOKED_get_ext_by_NID'; }  {Do not localize}
  {CH fn_X509_REVOKED_get_ext_by_OBJ = 'X509_REVOKED_get_ext_by_OBJ'; }  {Do not localize}
  {CH fn_X509_REVOKED_get_ext_by_critical = 'X509_REVOKED_get_ext_by_critical'; }  {Do not localize}
  {CH fn_X509_REVOKED_get_ext = 'X509_REVOKED_get_ext'; }  {Do not localize}
  {CH fn_X509_REVOKED_delete_ext = 'X509_REVOKED_delete_ext'; }  {Do not localize}
  {CH fn_X509_REVOKED_add_ext = 'X509_REVOKED_add_ext'; }  {Do not localize}
  fn_X509_EXTENSION_create_by_NID = 'X509_EXTENSION_create_by_NID';  {Do not localize}
  {CH fn_X509_EXTENSION_create_by_OBJ = 'X509_EXTENSION_create_by_OBJ'; }  {Do not localize}
  {CH fn_X509_EXTENSION_set_object = 'X509_EXTENSION_set_object'; }  {Do not localize}
  {CH fn_X509_EXTENSION_set_critical = 'X509_EXTENSION_set_critical'; }  {Do not localize}
  {CH fn_X509_EXTENSION_set_data = 'X509_EXTENSION_set_data'; }  {Do not localize}
  {CH fn_X509_EXTENSION_get_object = 'X509_EXTENSION_get_object'; }  {Do not localize}
  {CH fn_X509_EXTENSION_get_data = 'X509_EXTENSION_get_data'; }  {Do not localize}
  {CH fn_X509_EXTENSION_get_critical = 'X509_EXTENSION_get_critical'; }  {Do not localize}
  {CH fn_X509_verify_cert = 'X509_verify_cert'; }  {Do not localize}
  {CH fn_X509_find_by_issuer_and_serial = 'X509_find_by_issuer_and_serial'; }  {Do not localize}
  {CH fn_X509_find_by_subject = 'X509_find_by_subject'; }  {Do not localize}
  {CH fn_i2d_PBEPARAM = 'i2d_PBEPARAM'; }  {Do not localize}
  {CH fn_PBEPARAM_new = 'PBEPARAM_new'; }  {Do not localize}
  {CH fn_d2i_PBEPARAM = 'd2i_PBEPARAM'; }  {Do not localize}
  {CH fn_PBEPARAM_free = 'PBEPARAM_free'; }  {Do not localize}
  {CH fn_PKCS5_pbe_set = 'PKCS5_pbe_set'; }  {Do not localize}
  {CH fn_PKCS5_pbe2_set = 'PKCS5_pbe2_set'; }  {Do not localize}
  {CH fn_i2d_PBKDF2PARAM = 'i2d_PBKDF2PARAM'; }  {Do not localize}
  {CH fn_PBKDF2PARAM_new = 'PBKDF2PARAM_new'; }  {Do not localize}
  {CH fn_d2i_PBKDF2PARAM = 'd2i_PBKDF2PARAM'; }  {Do not localize}
  {CH fn_PBKDF2PARAM_free = 'PBKDF2PARAM_free'; }  {Do not localize}
  {CH fn_i2d_PBE2PARAM = 'i2d_PBE2PARAM'; }  {Do not localize}
  {CH fn_PBE2PARAM_new = 'PBE2PARAM_new'; }  {Do not localize}
  {CH fn_d2i_PBE2PARAM = 'd2i_PBE2PARAM'; }  {Do not localize}
  {CH fn_PBE2PARAM_free = 'PBE2PARAM_free'; }  {Do not localize}
  {CH fn_i2d_PKCS8_PRIV_KEY_INFO = 'i2d_PKCS8_PRIV_KEY_INFO'; }  {Do not localize}
  {CH fn_PKCS8_PRIV_KEY_INFO_new = 'PKCS8_PRIV_KEY_INFO_new'; }  {Do not localize}
  {CH fn_d2i_PKCS8_PRIV_KEY_INFO = 'd2i_PKCS8_PRIV_KEY_INFO'; }  {Do not localize}
  {CH fn_PKCS8_PRIV_KEY_INFO_free = 'PKCS8_PRIV_KEY_INFO_free'; }  {Do not localize}
  {CH fn_EVP_PKCS82PKEY = 'EVP_PKCS82PKEY'; }  {Do not localize}
  {CH fn_EVP_PKEY2PKCS8 = 'EVP_PKEY2PKCS8'; }  {Do not localize}
  {CH fn_PKCS8_set_broken = 'PKCS8_set_broken'; }  {Do not localize}
  {CH fn_ERR_load_PEM_strings = 'ERR_load_PEM_strings'; }  {Do not localize}
  {CH fn_PEM_get_EVP_CIPHER_INFO = 'PEM_get_EVP_CIPHER_INFO'; }  {Do not localize}
  {CH fn_PEM_do_header = 'PEM_do_header'; }  {Do not localize}
  {CH fn_PEM_read_bio = 'PEM_read_bio'; }  {Do not localize}
  {CH fn_PEM_write_bio = 'PEM_write_bio'; }  {Do not localize}
  fn_PEM_ASN1_read_bio = 'PEM_ASN1_read_bio';  {Do not localize}
  fn_PEM_ASN1_write_bio = 'PEM_ASN1_write_bio';  {Do not localize}
  fn_PEM_X509_INFO_read_bio = 'PEM_X509_INFO_read_bio';   {Do not localize}
  {CH fn_PEM_X509_INFO_write_bio = 'PEM_X509_INFO_write_bio'; }  {Do not localize}
  {CH fn_PEM_read = 'PEM_read'; }  {Do not localize}
  {CH fn_PEM_write = 'PEM_write'; }  {Do not localize}
  {CH fn_PEM_ASN1_read = 'PEM_ASN1_read'; }  {Do not localize}
  {CH fn_PEM_ASN1_write = 'PEM_ASN1_write'; }  {Do not localize}
  {CH fn_PEM_X509_INFO_read = 'PEM_X509_INFO_read'; }  {Do not localize}
  {CH fn_PEM_SealInit = 'PEM_SealInit'; }  {Do not localize}
  {CH fn_PEM_SealUpdate = 'PEM_SealUpdate'; }  {Do not localize}
  {CH fn_PEM_SealFinal = 'PEM_SealFinal'; }  {Do not localize}
  {CH fn_PEM_SignInit = 'PEM_SignInit'; }  {Do not localize}
  {CH fn_PEM_SignUpdate = 'PEM_SignUpdate'; }  {Do not localize}
  {CH fn_PEM_SignFinal = 'PEM_SignFinal'; }  {Do not localize}
  {CH fn_PEM_proc_type = 'PEM_proc_type'; }  {Do not localize}
  {CH fn_PEM_dek_info = 'PEM_dek_info'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_BIO}
    {$IFNDEF SSLEAY_MACROS}
  fn_PEM_read_bio_X509 = 'PEM_read_bio_X509';   {Do not localize}
  fn_PEM_write_bio_X509 = 'PEM_write_bio_X509';   {Do not localize}
  fn_PEM_read_bio_X509_REQ = 'PEM_read_bio_X509_REQ';   {Do not localize}
  fn_PEM_write_bio_X509_REQ = 'PEM_write_bio_X509_REQ';  {Do not localize}
  fn_PEM_read_bio_X509_CRL = 'PEM_read_bio_X509_CRL';   {Do not localize}
  fn_PEM_write_bio_X509_CRL = 'PEM_write_bio_X509_CRL';   {Do not localize}
  fn_PEM_read_bio_PKCS7 = 'PEM_read_bio_PKCS7';   {Do not localize}
  fn_PEM_write_bio_PKCS7 = 'PEM_write_bio_PKCS7';   {Do not localize}
  fn_PEM_read_bio_NETSCAPE_CERT_SEQUENCE = 'PEM_read_bio_NETSCAPE_CERT_SEQUENCE';   {Do not localize}
  fn_PEM_write_bio_NETSCAPE_CERT_SEQUENCE = 'PEM_write_bio_NETSCAPE_CERT_SEQUENCE';   {Do not localize}
  fn_PEM_read_bio_PKCS8 = 'PEM_read_bio_PKCS8';   {Do not localize}
  fn_PEM_write_bio_PKCS8 = 'PEM_write_bio_PKCS8';   {Do not localize}
  fn_PEM_read_bio_PKCS8_PRIV_KEY_INFO = 'PEM_read_bio_PKCS8_PRIV_KEY_INFO';   {Do not localize}
  fn_PEM_write_bio_PKCS8_PRIV_KEY_INFO = 'PEM_write_bio_PKCS8_PRIV_KEY_INFO';   {Do not localize}
  fn_PEM_read_bio_RSAPrivateKey = 'PEM_read_bio_RSAPrivateKey';   {Do not localize}
  fn_PEM_write_bio_RSAPrivateKey = 'PEM_write_bio_RSAPrivateKey';   {Do not localize}
  fn_PEM_read_bio_RSAPublicKey = 'PEM_read_bio_RSAPublicKey';   {Do not localize}
  fn_PEM_write_bio_RSAPublicKey = 'PEM_write_bio_RSAPublicKey';   {Do not localize}
  fn_PEM_read_bio_DSAPrivateKey = 'PEM_read_bio_DSAPrivateKey';   {Do not localize}
  fn_PEM_write_bio_DSAPrivateKey = 'PEM_write_bio_DSAPrivateKey';   {Do not localize}
  fn_PEM_read_bio_DSAparams = 'PEM_read_bio_DSAparams';  {Do not localize}
  fn_PEM_write_bio_DSAparams = 'PEM_write_bio_DSAparams';   {Do not localize}
  fn_PEM_read_bio_DHparams = 'PEM_read_bio_DHparams';   {Do not localize}
  fn_PEM_write_bio_DHparams = 'PEM_write_bio_DHparams';   {Do not localize}
  fn_PEM_read_bio_PrivateKey = 'PEM_read_bio_PrivateKey';  {Do not localize}
  fn_PEM_write_bio_PrivateKey = 'PEM_write_bio_PrivateKey';   {Do not localize}
  fn_PEM_write_bio_PKCS8PrivateKey = 'PEM_write_bio_PKCS8PrivateKey';  {Do not localize}
  fn_PEM_read_bio_PUBKEY = 'PEM_read_bio_PUBKEY';  {Do not localize}
  fn_PEM_write_bio_PUBKEY = 'PEM_write_bio_PUBKEY';  {Do not localize}
    {$ENDIF}
  {$ENDIF}
  fn_PEM_read_bio_X509_AUX = 'PEM_read_bio_X509_AUX';  {Do not localize}
  {CH fn_PEM_read_X509 = 'PEM_read_X509'; }  {Do not localize}
  {CH fn_PEM_write_X509 = 'PEM_write_X509'; }  {Do not localize}
  {CH fn_PEM_read_X509_REQ = 'PEM_read_X509_REQ'; }  {Do not localize}
  {CH fn_PEM_write_X509_REQ = 'PEM_write_X509_REQ'; }  {Do not localize}
  {CH fn_PEM_read_X509_CRL = 'PEM_read_X509_CRL'; }  {Do not localize}
  {CH fn_PEM_write_X509_CRL = 'PEM_write_X509_CRL'; }  {Do not localize}
  {CH fn_PEM_read_PKCS7 = 'PEM_read_PKCS7'; }  {Do not localize}
  {CH fn_PEM_write_PKCS7 = 'PEM_write_PKCS7'; }  {Do not localize}
  {CH fn_PEM_read_NETSCAPE_CERT_SEQUENCE = 'PEM_read_NETSCAPE_CERT_SEQUENCE'; }  {Do not localize}
  {CH fn_PEM_write_NETSCAPE_CERT_SEQUENCE = 'PEM_write_NETSCAPE_CERT_SEQUENCE'; }  {Do not localize}
  {CH fn_PEM_read_PKCS8 = 'PEM_read_PKCS8'; }  {Do not localize}
  {CH fn_PEM_write_PKCS8 = 'PEM_write_PKCS8'; }  {Do not localize}
  {CH fn_PEM_read_PKCS8_PRIV_KEY_INFO = 'PEM_read_PKCS8_PRIV_KEY_INFO'; }  {Do not localize}
  {CH fn_PEM_write_PKCS8_PRIV_KEY_INFO = 'PEM_write_PKCS8_PRIV_KEY_INFO'; }  {Do not localize}
  {CH fn_PEM_read_RSAPrivateKey = 'PEM_read_RSAPrivateKey'; }  {Do not localize}
  {CH fn_PEM_write_RSAPrivateKey = 'PEM_write_RSAPrivateKey'; }  {Do not localize}
  {CH fn_PEM_read_RSAPublicKey = 'PEM_read_RSAPublicKey'; }  {Do not localize}
  {CH fn_PEM_write_RSAPublicKey = 'PEM_write_RSAPublicKey'; }  {Do not localize}
  {CH fn_PEM_read_DSAPrivateKey = 'PEM_read_DSAPrivateKey'; }  {Do not localize}
  {CH fn_PEM_write_DSAPrivateKey = 'PEM_write_DSAPrivateKey'; }  {Do not localize}
  {CH fn_PEM_read_DSAparams = 'PEM_read_DSAparams'; }  {Do not localize}
  {CH fn_PEM_write_DSAparams = 'PEM_write_DSAparams'; }  {Do not localize}
  {CH fn_PEM_read_DHparams = 'PEM_read_DHparams'; }  {Do not localize}
  {CH fn_PEM_write_DHparams = 'PEM_write_DHparams'; }  {Do not localize}
  {CH fn_PEM_read_PrivateKey = 'PEM_read_PrivateKey'; }  {Do not localize}
  {CH fn_PEM_write_PrivateKey = 'PEM_write_PrivateKey'; }  {Do not localize}
  {CH fn_PEM_write_PKCS8PrivateKey = 'PEM_write_PKCS8PrivateKey'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_new = 'sk_SSL_CIPHER_new'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_new_null = 'sk_SSL_CIPHER_new_null'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_free = 'sk_SSL_CIPHER_free'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_num = 'sk_SSL_CIPHER_num'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_value = 'sk_SSL_CIPHER_value'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_set = 'sk_SSL_CIPHER_set'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_zero = 'sk_SSL_CIPHER_zero'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_push = 'sk_SSL_CIPHER_push'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_unshift = 'sk_SSL_CIPHER_unshift'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_find = 'sk_SSL_CIPHER_find'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_delete = 'sk_SSL_CIPHER_delete'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_delete_ptr = 'sk_SSL_CIPHER_delete_ptr'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_insert = 'sk_SSL_CIPHER_insert'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_dup = 'sk_SSL_CIPHER_dup'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_pop_free = 'sk_SSL_CIPHER_pop_free'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_shift = 'sk_SSL_CIPHER_shift'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_pop = 'sk_SSL_CIPHER_pop'; }  {Do not localize}
  {CH fn_sk_SSL_CIPHER_sort = 'sk_SSL_CIPHER_sort'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_new = 'sk_SSL_COMP_new'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_new_null = 'sk_SSL_COMP_new_null'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_free = 'sk_SSL_COMP_free'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_num = 'sk_SSL_COMP_num'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_value = 'sk_SSL_COMP_value'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_set = 'sk_SSL_COMP_set'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_zero = 'sk_SSL_COMP_zero'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_push = 'sk_SSL_COMP_push'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_unshift = 'sk_SSL_COMP_unshift'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_find = 'sk_SSL_COMP_find'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_delete = 'sk_SSL_COMP_delete'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_delete_ptr = 'sk_SSL_COMP_delete_ptr'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_insert = 'sk_SSL_COMP_insert'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_dup = 'sk_SSL_COMP_dup'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_pop_free = 'sk_SSL_COMP_pop_free'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_shift = 'sk_SSL_COMP_shift'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_pop = 'sk_SSL_COMP_pop'; }  {Do not localize}
  {CH fn_sk_SSL_COMP_sort = 'sk_SSL_COMP_sort'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_BIO}
  {CH fn_BIO_f_ssl = 'BIO_f_ssl'; }  {Do not localize}
  {CH fn_BIO_new_ssl = 'BIO_new_ssl'; }  {Do not localize}
  {CH fn_BIO_new_ssl_connect = 'BIO_new_ssl_connect'; }  {Do not localize}
  {CH fn_BIO_new_buffer_ssl_connect = 'BIO_new_buffer_ssl_connect'; }  {Do not localize}
  {CH fn_BIO_ssl_copy_session_id = 'BIO_ssl_copy_session_id'; }  {Do not localize}
  {CH fn_BIO_ssl_shutdown = 'BIO_ssl_shutdown'; }  {Do not localize}
  {$ENDIF}
  fn_SSL_CTX_set_cipher_list = 'SSL_CTX_set_cipher_list';  {Do not localize}
  fn_SSL_CTX_new = 'SSL_CTX_new';  {Do not localize}
  fn_SSL_CTX_free = 'SSL_CTX_free';  {Do not localize}
  fn_SSL_callback_ctrl = 'SSL_callback_ctrl';  {Do not localize}
  fn_SSL_CTX_callback_ctrl = 'SSL_CTX_callback_ctrl'; {Do not localize}
  {CH fn_SSL_CTX_set_timeout = 'SSL_CTX_set_timeout'; }  {Do not localize}
  {CH fn_SSL_CTX_get_timeout = 'SSL_CTX_get_timeout'; }  {Do not localize}
  {CH fn_SSL_CTX_get_cert_store = 'SSL_CTX_get_cert_store'; }  {Do not localize}
  {CH fn_SSL_CTX_set_cert_store = 'SSL_CTX_set_cert_store'; }  {Do not localize}
  {CH fn_SSL_want = 'SSL_want'; }  {Do not localize}
  {CH fn_SSL_clear = 'SSL_clear'; }  {Do not localize}
  {CH fn_SSL_CTX_flush_sessions = 'SSL_CTX_flush_sessions'; }  {Do not localize}
  fn_SSL_get_current_cipher = 'SSL_get_current_cipher';  {Do not localize}
  fn_SSL_CIPHER_get_bits = 'SSL_CIPHER_get_bits';  {Do not localize}
  fn_SSL_CIPHER_get_version = 'SSL_CIPHER_get_version';  {Do not localize}
  fn_SSL_CIPHER_get_name = 'SSL_CIPHER_get_name';  {Do not localize}
  {CH fn_SSL_get_fd = 'SSL_get_fd'; }  {Do not localize}
  {CH fn_SSL_get_cipher_list = 'SSL_get_cipher_list'; }  {Do not localize}
  {CH fn_SSL_get_shared_ciphers = 'SSL_get_shared_ciphers'; }  {Do not localize}
  {CH fn_SSL_get_read_ahead = 'SSL_get_read_ahead'; }  {Do not localize}
  fn_SSL_pending = 'SSL_pending';  {Do not localize}
  {$IFNDEF OPENSSL_NO_SOCK}
  fn_SSL_set_fd = 'SSL_set_fd';  {Do not localize}
  {CH fn_SSL_set_rfd = 'SSL_set_rfd'; }  {Do not localize}
  {CH fn_SSL_set_wfd = 'SSL_set_wfd'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_BIO}
  {CH fn_SSL_set_bio = 'SSL_set_bio'; }  {Do not localize}
  {CH fn_SSL_get_rbio = 'SSL_get_rbio'; }  {Do not localize}
  {CH fn_SSL_get_wbio = 'SSL_get_wbio'; }  {Do not localize}
  {$ENDIF}
  {CH fn_SSL_set_cipher_list = 'SSL_set_cipher_list'; }  {Do not localize}
  {CH fn_SSL_set_read_ahead = 'SSL_set_read_ahead'; }  {Do not localize}
  {CH fn_SSL_get_verify_mode = 'SSL_get_verify_mode'; }  {Do not localize}
  {CH fn_SSL_get_verify_depth = 'SSL_get_verify_depth'; }  {Do not localize}
  {CH fn_SSL_set_verify = 'SSL_set_verify'; }  {Do not localize}
  {CH fn_SSL_set_verify_depth = 'SSL_set_verify_depth'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_RSA}
  {CH fn_SSL_use_RSAPrivateKey = 'SSL_use_RSAPrivateKey'; }  {Do not localize}
  {CH fn_SSL_use_RSAPrivateKey_ASN1 = 'SSL_use_RSAPrivateKey_ASN1'; }  {Do not localize}
  {$ENDIF}
  {CH fn_SSL_use_PrivateKey = 'SSL_use_PrivateKey'; }  {Do not localize}
  {CH fn_SSL_use_PrivateKey_ASN1 = 'SSL_use_PrivateKey_ASN1'; {Do not localize}
  {CH fn_SSL_use_certificate = 'SSL_use_certificate'; }  {Do not localize}
  {CH fn_SSL_use_certificate_ASN1 = 'SSL_use_certificate_ASN1'; }  {Do not localize}
  {CH fn_SSL_use_RSAPrivateKey_file = 'SSL_use_RSAPrivateKey_file'; }  {Do not localize}
  {CH fn_SSL_use_PrivateKey_file = 'SSL_use_PrivateKey_file'; }  {Do not localize}
  {CH fn_SSL_use_certificate_file = 'SSL_use_certificate_file'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_RSA}
  {CH fn_SSL_CTX_use_RSAPrivateKey_file = 'SSL_CTX_use_RSAPrivateKey_file'; }  {Do not localize}
  {$ENDIF}
  fn_SSL_CTX_use_PrivateKey_file = 'SSL_CTX_use_PrivateKey_file';  {Do not localize}
  fn_SSL_CTX_use_certificate_file = 'SSL_CTX_use_certificate_file';  {Do not localize}
  fn_SSL_CTX_use_certificate_chain_file = 'SSL_CTX_use_certificate_chain_file'; {Do not localize}
  {$ifndef OPENSSL_NO_ENGINE}
  {CH fn_SSL_CTX_set_client_cert_engine = 'SSL_CTX_set_client_cert_engine'; } {Do not localize}
  {$endif}
  {CH fn_SSL_CTX_use_certificate_chain_file = 'SSL_CTX_use_certificate_chain_file'; }  {Do not localize}
  fn_SSL_load_client_CA_file = 'SSL_load_client_CA_file';  {Do not localize}
  {CH fn_SSL_add_file_cert_subjects_to_stack = 'SSL_add_file_cert_subjects_to_stack'; }  {Do not localize}
  {CH fn_ERR_load_SSL_strings = 'ERR_load_SSL_strings'; }  {Do not localize}
  fn_SSL_load_error_strings = 'SSL_load_error_strings';  {Do not localize}
  {CH fn_SSL_state_string = 'SSL_state_string'; }  {Do not localize}
  {CH fn_SSL_rstate_string = 'SSL_rstate_string'; }  {Do not localize}
  fn_SSL_state_string_long = 'SSL_state_string_long';  {Do not localize}
  {CH fn_SSL_rstate_string_long = 'SSL_rstate_string_long'; }  {Do not localize}
  {CH fn_SSL_SESSION_get_time = 'SSL_SESSION_get_time'; }  {Do not localize}
  {CH fn_SSL_SESSION_set_time = 'SSL_SESSION_set_time'; }  {Do not localize}
  {CH fn_SSL_SESSION_get_timeout = 'SSL_SESSION_get_timeout'; }  {Do not localize}
  {CH fn_SSL_SESSION_set_timeout = 'SSL_SESSION_set_timeout'; }  {Do not localize}
  fn_SSL_copy_session_id = 'SSL_copy_session_id'; {Do not localize}
  {CH fn_SSL_SESSION_new = 'SSL_SESSION_new'; }  {Do not localize}
  {CH fn_SSL_SESSION_hash = 'SSL_SESSION_hash'; }  {Do not localize}
  {CH fn_SSL_SESSION_cmp = 'SSL_SESSION_cmp'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_FP_API}
  {CH fn_SSL_SESSION_print_fp = 'SSL_SESSION_print_fp'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_BIO}
  {CH fn_SSL_SESSION_print = 'SSL_SESSION_print'; }  {Do not localize}
  {$ENDIF}
  {CH fn_SSL_SESSION_free = 'SSL_SESSION_free'; }  {Do not localize}
  {CH fn_i2d_SSL_SESSION = 'i2d_SSL_SESSION'; }  {Do not localize}
  {CH fn_SSL_set_session = 'SSL_set_session'; }  {Do not localize}
  {CH fn_SSL_CTX_add_session = 'SSL_CTX_add_session'; }  {Do not localize}
  {CH fn_SSL_CTX_remove_session = 'SSL_CTX_remove_session'; }  {Do not localize}
  {CH fn_d2i_SSL_SESSION = 'd2i_SSL_SESSION'; }  {Do not localize}
  fn_SSL_get_peer_certificate = 'SSL_get_peer_certificate';  {Do not localize}
  {CH fn_SSL_get_peer_cert_chain = 'SSL_get_peer_cert_chain'; }  {Do not localize}
  {CH fn_SSL_CTX_get_verify_mode = 'SSL_CTX_get_verify_mode'; }  {Do not localize}
  fn_SSL_CTX_get_verify_depth = 'SSL_CTX_get_verify_depth';  {Do not localize}
  fn_SSL_CTX_set_verify = 'SSL_CTX_set_verify';  {Do not localize}
  fn_SSL_CTX_set_verify_depth = 'SSL_CTX_set_verify_depth';  {Do not localize}
  {CH fn_SSL_CTX_set_cert_verify_callback = 'SSL_CTX_set_cert_verify_callback'; }  {Do not localize}
  {CH fn_SSL_CTX_use_RSAPrivateKey = 'SSL_CTX_use_RSAPrivateKey'; }  {Do not localize}
  {CH fn_SSL_CTX_use_RSAPrivateKey_ASN1 = 'SSL_CTX_use_RSAPrivateKey_ASN1'; }  {Do not localize}
  fn_SSL_CTX_use_PrivateKey = 'SSL_CTX_use_PrivateKey';  {Do not localize}
  {CH fn_SSL_CTX_use_PrivateKey_ASN1 = 'SSL_CTX_use_PrivateKey_ASN1'; }  {Do not localize}
  fn_SSL_CTX_use_certificate = 'SSL_CTX_use_certificate';  {Do not localize}
  {CH fn_SSL_CTX_use_certificate_ASN1 = 'SSL_CTX_use_certificate_ASN1'; }  {Do not localize}
  fn_SSL_CTX_set_default_passwd_cb = 'SSL_CTX_set_default_passwd_cb';  {Do not localize}
  fn_SSL_CTX_set_default_passwd_cb_userdata = 'SSL_CTX_set_default_passwd_cb_userdata';  {Do not localize}
  fn_SSL_CTX_check_private_key = 'SSL_CTX_check_private_key';  {Do not localize}
  {CH fn_SSL_check_private_key = 'SSL_check_private_key'; }  {Do not localize}
  fn_SSL_CTX_set_session_id_context = 'SSL_CTX_set_session_id_context';  {Do not localize}
  fn_SSL_new = 'SSL_new';  {Do not localize}
  {CH fn_SSL_set_session_id_context = 'SSL_set_session_id_context'; }  {Do not localize}
  fn_SSL_free = 'SSL_free';  {Do not localize}
  fn_SSL_accept = 'SSL_accept';  {Do not localize}
  fn_SSL_connect = 'SSL_connect';  {Do not localize}
  fn_SSL_read = 'SSL_read';  {Do not localize}
  fn_SSL_peek = 'SSL_peek';  {Do not localize}
  fn_SSL_write = 'SSL_write';  {Do not localize}
  fn_SSL_ctrl = 'SSL_ctrl';   {Do not localize}
  fn_SSL_CTX_ctrl = 'SSL_CTX_ctrl';  {Do not localize}
  fn_SSL_get_error = 'SSL_get_error';  {Do not localize}
  {CH fn_SSL_get_version = 'SSL_get_version'; }  {Do not localize}
  {CH fn_SSL_CTX_set_ssl_version = 'SSL_CTX_set_ssl_version'; }  {Do not localize}
  fn_SSLv2_method = 'SSLv2_method';  {Do not localize}
  fn_SSLv2_server_method = 'SSLv2_server_method';  {Do not localize}
  fn_SSLv2_client_method = 'SSLv2_client_method';  {Do not localize}
  fn_SSLv3_method = 'SSLv3_method';  {Do not localize}
  fn_SSLv3_server_method = 'SSLv3_server_method';  {Do not localize}
  fn_SSLv3_client_method = 'SSLv3_client_method';  {Do not localize}
  fn_SSLv23_method = 'SSLv23_method';  {Do not localize}
  fn_SSLv23_server_method = 'SSLv23_server_method';  {Do not localize}
  fn_SSLv23_client_method = 'SSLv23_client_method';  {Do not localize}
  fn_TLSv1_method = 'TLSv1_method';  {Do not localize}
  fn_TLSv1_server_method = 'TLSv1_server_method';  {Do not localize}
  fn_TLSv1_client_method = 'TLSv1_client_method';  {Do not localize}
  fn_TLSv1_1_method = 'TLSv1_1_method'; {Do not localize}
  fn_TLSv1_1_server_method = 'TLSv1_1_server_method'; {Do not localize}
  fn_TLSv1_1_client_method = 'TLSv1_1_client_method'; {Do not localize}
  fn_TLSv1_2_method = 'TLSv1_2_method'; {Do not localize}
  fn_TLSv1_2_server_method = 'TLSv1_2_server_method'; {Do not localize}
  fn_TLSv1_2_client_method = 'TLSv1_2_client_method'; {Do not localize}
  fn_DTLSv1_method = 'DTLSv1_method'; {Do not localize}
  fn_DTLSv1_server_method = 'DTLSv1_server_method'; {Do not localize}
  fn_DTLSv1_client_method = 'DTLSv1_client_method'; {Do not localize}
  {CH fn_SSL_get_ciphers = 'SSL_get_ciphers'; }  {Do not localize}
  {CH fn_SSL_do_handshake = 'SSL_do_handshake'; }  {Do not localize}
  {CH fn_SSL_renegotiate = 'SSL_renegotiate'; }  {Do not localize}
  fn_SSL_shutdown = 'SSL_shutdown';  {Do not localize}
  {CH fn_SSL_get_ssl_method = 'SSL_get_ssl_method'; }  {Do not localize}
  {CH fn_SSL_set_ssl_method = 'SSL_set_ssl_method'; }  {Do not localize}
   fn_SSL_alert_type_string_long = 'SSL_alert_type_string_long';   {Do not localize}
  {CH fn_SSL_alert_type_string = 'SSL_alert_type_string'; }  {Do not localize}
  fn_SSL_alert_desc_string_long = 'SSL_alert_desc_string_long';   {Do not localize}
  {CH fn_SSL_alert_desc_string = 'SSL_alert_desc_string'; }  {Do not localize}
  {CH fn_SSL_set_client_CA_list = 'SSL_set_client_CA_list'; }  {Do not localize}
  fn_SSL_CTX_set_client_CA_list = 'SSL_CTX_set_client_CA_list';  {Do not localize}
  {CH fn_SSL_get_client_CA_list = 'SSL_get_client_CA_list'; }  {Do not localize}
  {CH fn_SSL_CTX_get_client_CA_list = 'SSL_CTX_get_client_CA_list'; }  {Do not localize}
  {CH fn_SSL_add_client_CA = 'SSL_add_client_CA'; }  {Do not localize}
  {CH fn_SSL_CTX_add_client_CA = 'SSL_CTX_add_client_CA'; }  {Do not localize}
  fn_SSL_set_connect_state = 'SSL_set_connect_state';  {Do not localize}
  fn_SSL_set_accept_state = 'SSL_set_accept_state';  {Do not localize}
  {CH fn_SSL_get_default_timeout = 'SSL_get_default_timeout'; }  {Do not localize}
  {CH fn_SSL_library_init = 'SSL_library_init'; }  {Do not localize}
  fn_SSL_CIPHER_description = 'SSL_CIPHER_description';  {Do not localize}
  {CH fn_SSL_dup_CA_list = 'SSL_dup_CA_list'; }  {Do not localize}
  {CH fn_SSL_dup = 'SSL_dup'; }  {Do not localize}
  {CH fn_SSL_get_certificate = 'SSL_get_certificate'; }  {Do not localize}
  {CH fn_SSL_get_privatekey = 'SSL_get_privatekey'; }  {Do not localize}
  {CH fn_SSL_CTX_set_quiet_shutdown = 'SSL_CTX_set_quiet_shutdown'; }  {Do not localize}
  {CH fn_SSL_CTX_get_quiet_shutdown = 'SSL_CTX_get_quiet_shutdown'; }  {Do not localize}
  {CH fn_SSL_set_quiet_shutdown = 'SSL_set_quiet_shutdown'; }  {Do not localize}
  {CH fn_SSL_get_quiet_shutdown = 'SSL_get_quiet_shutdown'; }  {Do not localize}
  fn_SSL_set_shutdown = 'SSL_set_shutdown';  {Do not localize}
  {CH fn_SSL_get_shutdown = 'SSL_get_shutdown'; }  {Do not localize}
  {CH fn_SSL_version = 'SSL_version'; }  {Do not localize}
  fn_SSL_CTX_set_default_verify_paths = 'SSL_CTX_set_default_verify_paths';  {Do not localize}
  fn_SSL_CTX_load_verify_locations = 'SSL_CTX_load_verify_locations';  {Do not localize}
  fn_SSL_get_session = 'SSL_get_session';  {Do not localize}
  {CH fn_SSL_get_SSL_CTX = 'SSL_get_SSL_CTX'; }  {Do not localize}
  {CH fn_SSL_set_SSL_CTX = 'SSL_set_SSL_CTX'; }  {Do not localize}
  {CH fn_OPENSSL_isservice = 'OPENSSL_isservice'; }{Do not localize}
  {CH fn_SSL_set_info_callback = 'SSL_set_info_callback'; }  {Do not localize}
  {CH fn_SSL_state = 'SSL_state'; }  {Do not localize}

  fn_SSL_set_verify_result = 'SSL_set_verify_result';  {Do not localize}
  fn_SSL_get_verify_result = 'SSL_get_verify_result';  {Do not localize}
  fn_SSL_set_ex_data = 'SSL_set_ex_data';  {Do not localize}
  fn_SSL_get_ex_data = 'SSL_get_ex_data';  {Do not localize}
  {CH fn_SSL_get_ex_new_index = 'SSL_get_ex_new_index'; }  {Do not localize}
  {CH fn_SSL_SESSION_set_ex_data = 'SSL_SESSION_set_ex_data'; }  {Do not localize}
  {CH fn_SSL_SESSION_get_ex_data = 'SSL_SESSION_get_ex_data'; }  {Do not localize}
  {CH fn_SSL_SESSION_get_ex_new_index = 'SSL_SESSION_get_ex_new_index'; }  {Do not localize}
  {CH fn_SSL_CTX_set_ex_data = 'SSL_CTX_set_ex_data'; }  {Do not localize}
  {CH fn_SSL_CTX_get_ex_data = 'SSL_CTX_get_ex_data'; }  {Do not localize}
  {CH fn_SSL_CTX_get_ex_new_index = 'SSL_CTX_get_ex_new_index'; }  {Do not localize}
  {CH fn_SSL_get_ex_data_X509_STORE_CTX_idx = 'SSL_get_ex_data_X509_STORE_CTX_idx'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_RSA}
  {CH fn_SSL_CTX_set_tmp_rsa_callback = 'SSL_CTX_set_tmp_rsa_callback'; }  {Do not localize}
  {CH fn_SSL_set_tmp_rsa_callback = 'SSL_set_tmp_rsa_callback'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_DH}
  {CH fn_SSL_CTX_set_tmp_dh_callback = 'SSL_CTX_set_tmp_dh_callback'; }  {Do not localize}
  {CH fn_SSL_set_tmp_dh_callback = 'SSL_set_tmp_dh_callback'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_ECDH}
  {CH fn_SSL_CTX_set_tmp_ecdh_callback = 'SSL_CTX_set_tmp_ecdh_callback'; } {Do not localize}
  {CH fn_SSL_set_tmp_ecdh_callback = 'SSL_set_tmp_ecdh_callback'; } {Do not localize}
  {$ENDIF}
  {CH fn_SSL_COMP_add_compression_method = 'SSL_COMP_add_compression_method'; }  {Do not localize}
  {CH fn_SSL_get_current_expansion = 'SSL_get_current_expansion'; } {Do not localize}
  {CH fn_SSL_COMP_get_name = 'SSL_COMP_get_name'; } {Do not localize}
  fn_SSL_COMP_get_compression_methods = 'SSL_COMP_get_compression_methods'; {Do not localize}
  fn_SSL_COMP_free_compression_methods = 'SSL_COMP_free_compression_methods'; {Do not localize}
  // GREGOR
  //fn_SSLeay_add_ssl_algorithms = 'mi_SSLeay_add_ssl_algorithms';  {Do not localize}
  //why does the function name not match?
  //
  // RLebeau: because it is not an actual function of its own to begin with.
  // It is a precompiler macro that maps to another function
  fn_SSLeay_add_ssl_algorithms = 'SSL_library_init';   {Do not localize}
  fn_SSL_SESSION_get_id = 'SSL_SESSION_get_id';  {Do not localize}
  {CH fn_SSL_is_init_finished = 'mi_SSL_is_init_finished'; }  {Do not localize}
  {CH fn_SSL_in_init = 'mi_SSL_in_init'; }  {Do not localize}
  {CH fn_SSL_in_before = 'mi_SSL_in_before'; }  {Do not localize}
  {CH fn_SSL_in_connect_init = 'mi_SSL_in_connect_init'; }  {Do not localize}
  {CH fn_SSL_in_accept_init = 'mi_SSL_in_accept_init'; }  {Do not localize}
  {CH fn_fopen = 'mi_fopen'; }  {Do not localize}
  {CH fn_fclose = 'mi_fclose'; }  {Do not localize}
  //
  fn_PKCS12_create = 'PKCS12_create'; {Do not localize}
  fn_i2d_PKCS12_bio = 'i2d_PKCS12_bio'; {Do not localize}
  fn_PKCS12_free = 'PKCS12_free'; {Do not localize}
  {CH fn_RAND_set_rand_method = 'RAND_set_rand_method'; } {Do not localize}
  {CH fn_RAND_get_rand_method = 'RAND_get_rand_method'; } {Do not localize}
  {$IFNDEF OPENSSL_NO_ENGINE}
  {CH fn_RAND_set_rand_engine = 'RAND_set_rand_engine'; } {Do not localize}
  {$ENDIF}
  {CH fn_RAND_SSLeay = 'RAND_SSLeay'; } {Do not localize}
  fn_RAND_cleanup = 'RAND_cleanup'; {Do not localize}
  fn_RAND_bytes = 'RAND_bytes'; {Do not localize}
  fn_RAND_pseudo_bytes = 'RAND_pseudo_bytes'; {Do not localize}
  fn_RAND_seed = 'RAND_seed'; {Do not localize}
  fn_RAND_add = 'RAND_add'; {Do not localize}
  {CH fn_RAND_load_file = 'RAND_load_file'; } {Do not localize}
  {CH fn_RAND_write_file = 'RAND_write_file'; } {Do not localize}
  {CH fn_RAND_file_name = 'RAND_file_name'; } {Do not localize}
  fn_RAND_status = 'RAND_status'; {Do not localize}
  {CH fn_RAND_query_egd_bytes = 'RAND_query_egd_bytes'; } {Do not localize}
  {CH fn_RAND_egd = 'RAND_egd'; } {Do not localize}
  {CH fn_RAND_egd_bytes = 'RAND_egd_bytes'; } {Do not localize}
  {CH fn_RAND_poll = 'RAND_poll'; } {Do not localize}
  {$IFDEF SYS_WIN}
  //GREGOR
  fn_RAND_screen = 'RAND_screen';  {Do not localize}
  fn_RAND_event = 'RAND_event'; {Do not localize}
  {$ENDIF}
  {CH fn_ERR_load_RAND_strings = 'ERR_load_RAND_strings'; } {Do not localize}
  //experimental
  fn_ERR_put_error = 'ERR_put_error';  {Do not localize}
  fn_ERR_get_error = 'ERR_get_error';  {Do not localize}
{CH fn_ERR_get_error_line = 'ERR_get_error_line'; }  {Do not localize}
{CH fn_ERR_get_error_line_data = 'ERR_get_error_line_data'; }  {Do not localize}
  fn_ERR_peek_error = 'ERR_peek_error';  {Do not localize}
  fn_ERR_peek_last_error = 'ERR_peek_last_error'; {Do not localize}
  {CH fn_ERR_peek_error_line = 'ERR_peek_error_line'; } {Do not localize}
{CH fn_ERR_peek_error_line_data = 'ERR_peek_error_line_data'; } {Do not localize}
  fn_ERR_peek_last_error_line = 'ERR_peek_last_error_line'; {Do not localize}
{CH fn_ERR_peek_last_error_line_data = 'ERR_peek_last_error_line_data'; } {Do not localize}
  fn_ERR_clear_error = 'ERR_clear_error';  {Do not localize}
  fn_ERR_error_string = 'ERR_error_string';  {Do not localize}
  fn_ERR_error_string_n = 'ERR_error_string_n';  {Do not localize}
  fn_ERR_lib_error_string = 'ERR_lib_error_string';  {Do not localize}
  fn_ERR_func_error_string = 'ERR_func_error_string';  {Do not localize}
  fn_ERR_reason_error_string = 'ERR_reason_error_string'; {Do not localize}
{CH fn_ERR_print_errors_cb = 'ERR_print_errors_cb'; } {Do not localize}
  {$IFNDEF OPENSSL_NO_FP_API}
{CH fn_ERR_print_errors_fp = 'ERR_print_errors_fp'; }  {Do not localize}
  {$ENDIF}
  {$IFNDEF OPENSSL_NO_BIO}
{CH fn_ERR_print_errors = 'ERR_print_errors'; }  {Do not localize}
{CH fn_ERR_add_error_data = 'ERR_add_error_data'; }  {Do not localize}
  {$ENDIF}
  fn_ERR_load_ERR_strings = 'ERR_load_ERR_strings';  {Do not localize}
  fn_ERR_free_strings = 'ERR_free_strings';  {do not localize}
  fn_ERR_remove_thread_state = 'ERR_remove_thread_state';  {Do not localize}
  fn_ERR_remove_state = 'ERR_remove_state';  {do not localize}
{CH fn_ERR_unload_strings = 'ERR_unload_strings'; } {Do not localize}
{CH fn_ERR_remove_thread_state = 'ERR_remove_thread_state'; } {Do not localize}
{CH fn_ERR_load_ERR_strings = 'ERR_load_ERR_strings'; } {Do not localize}
{CH fn_ERR_load_crypto_strings = 'ERR_load_crypto_strings'; } {Do not localize}
{CH fn_ERR_free_strings = 'ERR_free_strings'; } {Do not localize}
{CH fn_ERR_add_error_vdata = 'ERR_add_error_vdata'; } {Do not localize}
{CH fn_ERR_remove_state = 'ERR_remove_state'; }  {Do not localize}
{CH fn_ERR_get_state = 'ERR_get_state'; }  {Do not localize}
  {$IFNDEF OPENSSL_NO_LHASH}
  {CH fn_ERR_get_string_table = 'ERR_get_string_table';  } {Do not localize}
  {CH fn_ERR_get_err_state_table = 'ERR_get_err_state_table'; } {Do not localize}
  {CH fn_ERR_release_err_state_table = 'ERR_release_err_state_table'; } {Do not localize}
  {$ENDIF}
  {CH fn_ERR_get_next_error_library = 'ERR_get_next_error_library'; } {Do not localize}
  {CH fn_ERR_set_mark = 'ERR_set_mark'; } {Do not localize}
  {CH fn_ERR_pop_to_mark = 'ERR_pop_to_mark'; } {Do not localize}
  {$IFDEF OPENSSL_FIPS}
  {CH fn_int_ERR_set_state_func = 'int_ERR_set_state_func'; } {Do not localize}
  {CH fn_int_ERR_lib_init = 'int_ERR_lib_init'; } {Do not localize}
  {$ENDIF}
  {CH fn_UI_new = 'UI_new'; } {Do not localize}
  {CH fn_UI_new_method = 'UI_new_method'; } {Do not localize}
  {CH fn_UI_free = 'UI_free'; } {Do not localize}
  {CH fn_UI_add_input_string = 'UI_add_input_string'; } {Do not localize}
  {CH fn_UI_dup_input_string = 'UI_dup_input_string'; } {Do not localize}
  {CH fn_UI_add_verify_string = 'UI_add_verify_string'; } {Do not localize}
  {CH fn_UI_dup_verify_string = 'UI_dup_verify_string'; } {Do not localize}
  {CH fn_UI_add_input_boolean = 'UI_add_input_boolean'; } {Do not localize}
  {CH fn_UI_dup_input_boolean = 'UI_dup_input_boolean'; } {Do not localize}
  {CH fn_UI_add_info_string = 'UI_add_info_string'; } {Do not localize}
  {CH fn_UI_dup_info_string = 'UI_dup_info_string'; } {Do not localize}
  {CH fn_UI_add_error_string = 'UI_add_error_string'; } {Do not localize}
  {CH fn_UI_dup_error_string = 'UI_dup_error_string'; } {Do not localize}
  {CH fn_UI_construct_prompt = 'UI_construct_prompt'; } {Do not localize}
  {CH fn_UI_add_user_data = 'UI_add_user_data'; } {Do not localize}
  {CH fn_UI_get0_user_data = 'UI_get0_user_data'; } {Do not localize}
  {CH fn_UI_get0_resul = 'UI_get0_resul'; } {Do not localize}
  {CH fn_UI_process = 'UI_process'; } {Do not localize}
  {CH fn_UI_ctrl = 'UI_ctrl'; } {Do not localize}
  {CH fn_UI_get_ex_new_index = 'UI_get_ex_new_index'; } {Do not localize}
  {CH fn_UI_set_ex_data = 'UI_set_ex_data'; } {Do not localize}
  {CH fn_UI_get_ex_data = 'UI_get_ex_data'; } {Do not localize}
  {CH fn_UI_set_default_method = 'UI_set_default_method'; } {Do not localize}
  {CH fn_UI_get_method = 'UI_get_method'; } {Do not localize}
  {CH fn_UI_set_method = 'UI_set_method'; } {Do not localize}
  {CH fn_UI_OpenSSL = 'UI_OpenSSL'; } {Do not localize}
  {CH fn_UI_create_method = 'UI_create_method'; } {Do not localize}
  {CH fn_UI_destroy_method = 'UI_destroy_method'; } {Do not localize}
  {CH fn_UI_method_set_opener = 'UI_method_set_opener'; } {Do not localize}
  {CH fn_UI_method_set_writer = 'UI_method_set_writer'; } {Do not localize}
  {CH fn_UI_method_set_flusher = 'UI_method_set_flusher'; } {Do not localize}
  {CH fn_UI_method_set_reader = 'UI_method_set_reader'; } {Do not localize}
  {CH fn_UI_method_set_closer = 'UI_method_set_closer'; } {Do not localize}
  {CH fn_UI_get_string_type = 'UI_get_string_type'; } {Do not localize}
  {CH fn_UI_get_input_flags = 'UI_get_input_flags'; } {Do not localize}
  {CH fn_UI_get0_output_string = 'UI_get0_output_string'; } {Do not localize}
  {CH fn_UI_get0_action_string = 'UI_get0_action_string'; } {Do not localize}
  {CH fn_UI_get0_result_string = 'UI_get0_result_string'; } {Do not localize}
  {CH fn_UI_get0_test_string = 'UI_get0_test_string'; } {Do not localize}
  {CH fn_UI_get_result_minsize = 'UI_get_result_minsize'; } {Do not localize}
  {CH fn_UI_get_result_maxsize = 'UI_get_result_maxsize'; } {Do not localize}
  {CH fn_UI_set_result = 'UI_set_result'; } {Do not localize}
  {CH fn_UI_UTIL_read_pw_string = 'UI_UTIL_read_pw_string'; } {Do not localize}
  {CH fn_UI_UTIL_read_pw = 'UI_UTIL_read_pw'; } {Do not localize}
  {CH fn_ERR_load_UI_strings = 'ERR_load_UI_strings'; } {Do not localize}
  {$IFNDEF OPENSSL_NO_ENGINE}
  {CH fn_ENGINE_get_first = 'ENGINE_get_first'; } {Do not localize}
  {CH fn_ENGINE_get_last = 'ENGINE_get_last'; }  {Do not localize}
  {CH fn_ENGINE_get_next = 'ENGINE_get_next'; }  {Do not localize}
  {CH fn_ENGINE_get_prev = 'ENGINE_get_prev'; }  {Do not localize}
  {CH fn_ENGINE_add = 'ENGINE_add'; } {Do not localize}
  {CH fn_ENGINE_remove = 'ENGINE_remove'; } {Do not localize}
  {CH fn_ENGINE_by_id = 'ENGINE_by_id'; } {Do not localize}
  {CH fn_ENGINE_load_openssl = 'ENGINE_load_openssl'; } {Do not localize}
  {CH fn_ENGINE_load_dynamic = 'ENGINE_load_dynamic'; } {Do not localize}
  {$IFNDEF OPENSSL_NO_STATIC_ENGINE}
  {CH fn_ENGINE_load_4758cca = 'ENGINE_load_4758cca'; }  {Do not localize}
  {CH fn_ENGINE_load_aep = 'ENGINE_load_aep'; } {Do not localize}
  {CH fn_ENGINE_load_atalla = 'ENGINE_load_atalla'; } {Do not localize}
  {CH fn_ENGINE_load_chil = 'ENGINE_load_chil'; } {Do not localize}
  {CH fn_ENGINE_load_cswift = 'ENGINE_load_cswift'; }  {Do not localize}
    {$IFNDEF OPENSSL_NO_GMP}
  {CH fn_ENGINE_load_gmp = 'ENGINE_load_gmp'; }  {Do not localize}
    {$ENDIF}
  {CH fn_ENGINE_load_nuron = 'ENGINE_load_nuron'; }  {Do not localize}
  {CH fn_ENGINE_load_sureware = 'ENGINE_load_sureware'; }  {Do not localize}
  {CH fn_ENGINE_load_ubsec = 'ENGINE_load_ubsec'; } {Do not localize}
  {$ENDIF}
  {CH fn_ENGINE_load_cryptodev = 'ENGINE_load_cryptodev'; } {Do not localize}
  {CH fn_ENGINE_load_padlock = 'ENGINE_load_padlock'; } {Do not localize}
  {CH fn_ENGINE_load_builtin_engines = 'ENGINE_load_builtin_engines'; } {Do not localize}
  {$IFDEF WIN32_OR_WIN64}
    {$IFNDEF OPENSSL_NO_CAPIENG}
  {CH fn_ENGINE_load_capi = 'ENGINE_load_capi'; } {Do not localize}
    {$ENDIF}
  {$ENDIF}
  {CH fn_ENGINE_get_table_flags = 'ENGINE_get_table_flags'; } {Do not localize}
  {CH fn_ENGINE_set_table_flags = 'ENGINE_set_table_flags'; }  {Do not localize}
  {CH fn_ENGINE_register_RSA = 'ENGINE_register_RSA'; } {Do not localize}
  {CH fn_ENGINE_unregister_RSA = 'ENGINE_unregister_RSA'; } {Do not localize}
  {CH fn_ENGINE_register_all_RSA = 'ENGINE_register_all_RSA'; } {Do not localize}
  {CH fn_ENGINE_register_DSA = 'ENGINE_register_DSA'; } {Do not localize}
  {CH fn_ENGINE_unregister_DSA = 'ENGINE_unregister_DSA'; } {Do not localize}
  {CH fn_ENGINE_register_all_DSA = 'ENGINE_register_all_DSA'; } {Do not localize}
  {CH fn_ENGINE_register_ECDH = 'ENGINE_register_ECDH'; } {Do not localize}
  {CH fn_ENGINE_unregister_ECDH = 'ENGINE_unregister_ECDH'; } {Do not localize}
  {CH fn_ENGINE_register_all_ECDH = 'ENGINE_register_all_ECDH'; } {Do not localize}
  {CH fn_ENGINE_register_ECDSA = 'ENGINE_register_ECDSA'; } {Do not localize}
  {CH fn_ENGINE_unregister_ECDSA = 'ENGINE_unregister_ECDSA'; } {Do not localize}
  {CH fn_ENGINE_register_all_ECDSA = 'ENGINE_register_all_ECDSA'; } {Do not localize}
  {CH fn_ENGINE_register_DH = 'ENGINE_register_DH'; } {Do not localize}
  {CH fn_ENGINE_unregister_DH = 'ENGINE_unregister_DH'; } {Do not localize}
  {CH fn_ENGINE_register_all_DH = 'ENGINE_register_all_DH'; } {Do not localize}
  {CH fn_ENGINE_register_RAND = 'ENGINE_register_RAND'; } {Do not localize}
  {CH fn_ENGINE_unregister_RAND = 'ENGINE_unregister_RAND'; } {Do not localize}
  {CH fn_ENGINE_register_all_RAND = 'ENGINE_register_all_RAND'; } {Do not localize}
  {CH fn_ENGINE_register_STORE = 'ENGINE_register_STORE'; { {Do not localize}
  {CH fn_ENGINE_unregister_STORE = 'ENGINE_unregister_STORE'; } {Do not localize}
  {CH fn_ENGINE_register_all_STORE = 'ENGINE_register_all_STORE'; } {Do not localize}
  {CH fn_ENGINE_register_ciphers = 'ENGINE_register_ciphers'; } {Do not localize}
  {CH fn_ENGINE_unregister_ciphers = 'ENGINE_unregister_ciphers'; } {Do not localize}
  {CH fn_ENGINE_register_all_ciphers = 'ENGINE_register_all_ciphers'; } {Do not localize}
  {CH fn_ENGINE_register_digests = 'ENGINE_register_digests'; } {Do not localize}
  {CH fn_ENGINE_unregister_digests = 'ENGINE_unregister_digests'; } {Do not localize}
  {CH fn_ENGINE_register_all_digests= 'ENGINE_register_all_digests'; } {Do not localize}
  {CH fn_ENGINE_register_complete = 'ENGINE_register_complete'; } {Do not localize}
  {CH fn_ENGINE_register_all_complete = 'ENGINE_register_all_complete'; } {Do not localize}
  {CH fn_ENGINE_ctrl = 'ENGINE_ctrl'; } {Do not localize}
  {CH fn_ENGINE_cmd_is_executable = 'ENGINE_cmd_is_executable'; } {Do not localize}
  {CH fn_ENGINE_ctrl_cmd = 'ENGINE_ctrl_cmd'; } {Do not localize}
  {CH fn_ENGINE_ctrl_cmd_string = 'ENGINE_ctrl_cmd_string'; }  {Do not localize}
  {CH fn_ENGINE_new = 'ENGINE_new'; } {Do not localize}
  {CH fn_ENGINE_free = 'ENGINE_free'; } {Do not localize}
  {CH fn_ENGINE_up_ref = 'ENGINE_up_ref'; } {Do not localize}
  {CH fn_ENGINE_set_id = 'ENGINE_set_id'; } {Do not localize}
  {CH fn_ENGINE_set_name = 'ENGINE_set_name'; } {Do not localize}
  {CH fn_ENGINE_set_RSA = 'ENGINE_set_RSA'; } {Do not localize}
  {CH fn_ENGINE_set_DSA = 'ENGINE_set_DSA'; } {Do not localize}
  {CH fn_ENGINE_set_ECDH = 'ENGINE_set_ECDH'; } {Do not localize}
  {CH fn_ENGINE_set_ECDSA = 'ENGINE_set_ECDSA'; } {Do not localize}
  {CH fn_ENGINE_set_DH = 'ENGINE_set_DH'; }  {Do not localize}
  {CH fn_ENGINE_set_RAND = 'ENGINE_set_RAND'; }  {Do not localize}
  {CH fn_ENGINE_set_STORE = 'ENGINE_set_STORE'; }  {Do not localize}
  {CH fn_ENGINE_set_destroy_function = 'ENGINE_set_destroy_function'; }  {Do not localize}
  {CH fn_ENGINE_set_init_function = 'ENGINE_set_init_function'; } {Do not localize}
  {CH fn_ENGINE_set_finish_function = 'ENGINE_set_finish_function'; }  {Do not localize}
  {CH fn_ENGINE_set_ctrl_function = 'ENGINE_set_ctrl_function'; }  {Do not localize}
  {CH fn_ENGINE_set_load_privkey_function = 'ENGINE_set_load_privkey_function'; }  {Do not localize}
  {CH fn_ENGINE_set_load_pubkey_function = 'ENGINE_set_load_pubkey_function'; }  {Do not localize}
  {CH fn_ENGINE_set_load_ssl_client_cert_function = 'ENGINE_set_load_ssl_client_cert_function'; } {Do not localize}
  {CH fn_ENGINE_set_ciphers = 'ENGINE_set_ciphers'; } {Do not localize}
  {CH fn_ENGINE_set_digests = 'ENGINE_set_digests'; } {Do not localize}
  {CH fn_ENGINE_set_flags = 'ENGINE_set_flags'; } {Do not localize}
  {CH fn_ENGINE_set_cmd_defns = 'ENGINE_set_cmd_defns'; } {Do not localize}
  {CH fn_ENGINE_get_ex_new_index = 'ENGINE_get_ex_new_index'; } {Do not localize}
  {CH fn_ENGINE_set_ex_data = 'ENGINE_set_ex_data'; } {Do not localize}
  {CH fn_ENGINE_get_ex_data = 'ENGINE_get_ex_data'; }  {Do not localize}
  {CH fn_ENGINE_cleanup = 'ENGINE_cleanup'; } {Do not localize}
  {CH fn_ENGINE_get_id = 'ENGINE_get_id'; }  {Do not localize}
  {CH fn_ENGINE_get_name = 'ENGINE_get_name'; }  {Do not localize}
  {CH fn_ENGINE_get_RSA = 'ENGINE_get_RSA'; }  {Do not localize}
  {CH fn_ENGINE_get_DSA = 'ENGINE_get_DSA'; }   {Do not localize}
  {CH fn_ENGINE_get_ECDH = 'ENGINE_get_ECDH'; }  {Do not localize}
  {CH fn_ENGINE_get_ECDSA = 'ENGINE_get_ECDSA'; }  {Do not localize}
  {CH fn_ENGINE_get_DH = 'ENGINE_get_DH'; }  {Do not localize}
  {CH fn_ENGINE_get_RAND = 'ENGINE_get_RAND'; }  {Do not localize}
  {CH fn_ENGINE_get_STORE = 'ENGINE_get_STORE'; }  {Do not localize}
  {CH fn_ENGINE_get_destroy_function = 'ENGINE_get_destroy_function'; } {Do not localize}
  {CH fn_ENGINE_get_init_function = 'ENGINE_get_init_function'; }  {Do not localize}
  {CH fn_ENGINE_get_finish_function = 'ENGINE_get_finish_function'; }   {Do not localize}
  {CH fn_ENGINE_get_ctrl_function = 'ENGINE_get_ctrl_function'; }  {Do not localize}
  {CH fn_ENGINE_get_load_privkey_function = 'ENGINE_get_load_privkey_function'; }  {Do not localize}
  {CH fn_ENGINE_get_load_pubkey_function = 'ENGINE_get_load_pubkey_function'; }  {Do not localize}
  {CH fn_ENGINE_get_ssl_client_cert_function = 'ENGINE_get_ssl_client_cert_function'; }  {Do not localize}
  {CH fn_ENGINE_get_ciphers = 'ENGINE_get_ciphers'; }  {Do not localize}
  {CH fn_ENGINE_get_digests = 'ENGINE_get_digests'; }   {Do not localize}
  {CH fn_ENGINE_get_cipher = 'ENGINE_get_cipher'; }  {Do not localize}
  {CH fn_ENGINE_get_digest = 'ENGINE_get_digest'; }  {Do not localize}
  {CH fn_ENGINE_get_cmd_defns = 'ENGINE_get_cmd_defns'; }  {Do not localize}
  {CH fn_ENGINE_get_flags = 'ENGINE_get_flags'; }  {Do not localize}
  {CH fn_ENGINE_init = 'ENGINE_init'; }  {Do not localize}
  {CH fn_ENGINE_finish = 'ENGINE_finish'; }  {Do not localize}
  {CH fn_ENGINE_load_private_key = 'ENGINE_load_private_key'; } {Do not localize}
  {CH fn_ENGINE_load_public_key = 'ENGINE_load_public_key'; }  {Do not localize}
  {CH fn_ENGINE_load_ssl_client_cert = 'ENGINE_load_ssl_client_cert'; }  {Do not localize}
  {CH fn_ENGINE_get_default_RSA = 'ENGINE_get_default_RSA'; }  {Do not localize}
  {CH fn_ENGINE_get_default_DSA = 'ENGINE_get_default_DSA'; }  {Do not localize}
  {CH fn_ENGINE_get_default_ECDH = 'ENGINE_get_default_ECDH'; }  {Do not localize}
  {CH fn_ENGINE_get_default_ECDSA = 'ENGINE_get_default_ECDSA'; }  {Do not localize}
  {CH fn_ENGINE_get_default_DH = 'ENGINE_get_default_DH'; }  {Do not localize}
  {CH fn_ENGINE_get_default_RAND = 'ENGINE_get_default_RAND'; }  {Do not localize}
  {CH fn_ENGINE_get_cipher_engine = 'ENGINE_get_cipher_engine'; }  {Do not localize}
  {CH fn_ENGINE_get_digest_engine = 'ENGINE_get_digest_engine'; }  {Do not localize}
  {CH fn_ENGINE_set_default_RSA = 'ENGINE_set_default_RSA'; }  {Do not localize}
  {CH fn_ENGINE_set_default_string = 'ENGINE_set_default_string'; } {Do not localize}
  {CH fn_ENGINE_set_default_DSA = 'ENGINE_set_default_DSA'; }  {Do not localize}
  {CH fn_ENGINE_set_default_ECDH = 'ENGINE_set_default_ECDH'; }  {Do not localize}
  {CH fn_ENGINE_set_default_ECDSA = 'ENGINE_set_default_ECDSA'; }  {Do not localize}
  {CH fn_ENGINE_set_default_DH = 'ENGINE_set_default_DH'; }  {do not localize}
  {CH fn_ENGINE_set_default_RAND = 'ENGINE_set_default_RAND'; }  {Do not localize}
  {CH fn_ENGINE_set_default_ciphers = 'ENGINE_set_default_ciphers'; }  {Do not localize}
  {CH fn_ENGINE_set_default_digests = 'ENGINE_set_default_digests'; }  {Do not localize}
  {CH fn_ENGINE_set_default = 'ENGINE_set_default'; }   {Do not localize}
  {CH fn_ENGINE_add_conf_module = 'ENGINE_add_conf_module'; }  {Do not localize}
  {CH fn_ENGINE_get_static_state = 'ENGINE_get_static_state'; }  {Do not localize}
  {$IFDEF OPENBSD}
  {CH fn_ENGINE_setup_bsd_cryptodev = 'ENGINE_setup_bsd_cryptodev'; }  {Do not localize}
  {$ENDIF}
  {$IFDEF FREEBSD}
  {CH fn_ENGINE_setup_bsd_cryptodev = 'ENGINE_setup_bsd_cryptodev'; }  {Do not localize}
  {$ENDIF}
  {CH fn_ERR_load_ENGINE_strings = 'ERR_load_ENGINE_strings'; }  {Do not localize}
  {$ENDIF}
  {$IFDEF OPENSSL_EXPORT_VAR_AS_FUNCTION}
  //These have a gl prefix because they may not be functions in some platforms.
  //They are functions in Win32 because DLL's can't export global variables
  //while Unix shared objects may expose them.
  {CH gl_ASN1_OBJECT_it = 'ASN1_OBJECT_it'; } {do not localize}
  {CH gl_ASN1_OCTET_STRING_NDEF_it = 'ASN1_OCTET_STRING_NDEF_it'; } {Do not localize}
  {CH gl_ASN1_BOOLEAN_it = 'ASN1_BOOLEAN_it'; } {Do not localize}
  {CH gl_ASN1_SEQUENCE_it = 'ASN1_SEQUENCE_it'; } {Do not localize}
  {CH gl_CBIGNUM_it = 'CBIGNUM_it'; } {Do not localize}
  {CH gl_BIGNUM_it = 'BIGNUM_it'; } {Do not localize}
  {CH gl_LONG_it = 'LONG_it'; } {Do not localize}
  {CH gl_ZLONG_it = 'ZLONG_it'; } {Do not localize}
  {CH gl_POLICY_MAPPING_it = 'POLICY_MAPPING_it'; } {Do not localize}
  {CH gl_POLICY_MAPPINGS_it = 'POLICY_MAPPINGS_it'; }  {Do not localize}
  {CH gl_GENERAL_SUBTREE_it = 'GENERAL_SUBTREE_it'; } {Do not localize}
  {CH gl_NAME_CONSTRAINTS_it = 'NAME_CONSTRAINTS_it'; } {Do not localize}
  {CH gl_POLICY_CONSTRAINTS_it = 'POLICY_CONSTRAINTS_it'; } {Do not localize}
  {$ENDIF}


function LoadFunction(const FceName: TIdLibFuncName; const ACritical : Boolean = True): Pointer;
{$IFDEF WINDOWS}
var
  Err: DWORD;
{$ENDIF}
begin
  Result := LoadLibFunction(hIdSSL, FceName);
  if (Result <> nil) or (not ACritical) then begin
    Exit;
  end;
  {$IFDEF WINDOWS}
  Err := GetLastError();
  if Err <> ERROR_PROC_NOT_FOUND then begin
    FFailedLoadList.Add(IndyFormat(RSOSSMissingExport_WithErrCode, [FceName, Err]));
    Exit;
  end;
  {$ELSE}
  // TODO: add error code to message...
  {$ENDIF}
  FFailedLoadList.Add(FceName);
end;

function LoadFunctionCLib(const FceName: TIdLibFuncName; const ACritical : Boolean = True): Pointer;
{$IFDEF WINDOWS}
var
  Err: DWORD;
{$ENDIF}
begin
  Result := LoadLibFunction(hIdCrypto, FceName);
  if (Result <> nil) or (not ACritical) then begin
    Exit;
  end;
  {$IFDEF WINDOWS}
  Err := GetLastError();
  if Err <> ERROR_PROC_NOT_FOUND then begin
    FFailedLoadList.Add(IndyFormat(RSOSSMissingExport_WithErrCode, [FceName, Err]));
    Exit;
  end;
  {$ELSE}
  // TODO: add error code to message...
  {$ENDIF}
  FFailedLoadList.Add(FceName);
end;

// Id_ossl_old_des_set_odd_parity
{
IMPORTANT!!!

Indy DES support probably had been written to use some old "des_" functions.
The OpenSSL developers changed that interface to a new "des_*" API.  They have some
 "_ossl_old_des_*" for backwards compatability with the old functions
 which are defined in des_old.h. 
}
function LoadOldCLib(const AOldName, ANewName : TIdLibFuncName; const ACritical : Boolean = True): Pointer;
{$IFDEF WINDOWS}
var
  Err: DWORD;
{$ENDIF}
begin
  Result := LoadLibFunction(hIdCrypto, AOldName);
  if Result <> nil then begin
    Exit;
  end;
  {$IFDEF WINDOWS}
  if ACritical then begin
    Err := GetLastError();
    if Err <> ERROR_PROC_NOT_FOUND then begin
      FFailedLoadList.Add(IndyFormat(RSOSSMissingExport_WithErrCode, [AOldName, Err]));
      Exit;
    end;
  end;
  {$ENDIF}
  Result := LoadLibFunction(hIdCrypto, ANewName);
  if (Result <> nil) or (not ACritical) then begin
    Exit;
  end;
  {$IFDEF WINDOWS}
  Err := GetLastError();
  if Err <> ERROR_PROC_NOT_FOUND then begin
    FFailedLoadList.Add(IndyFormat(RSOSSMissingExport_WithErrCode, [ANewName, Err]));
    Exit;
  end;
  {$ELSE}
  // TODO: add error code to message...
  {$ENDIF}
  FFailedLoadList.Add(AOldName);
end;

{$ENDIF} // STATICLOAD_OPENSSL

// remove this function, it is not used
function ErrMsg(AErr : TIdC_ULONG) : string;
const
  sMaxErrStr = 300;
var
  LString: array[0..sMaxErrStr] of TIdAnsiChar;
  {$IFDEF USE_MARSHALLED_PTRS}
  LStringPtr: TPtrWrapper;
  {$ENDIF}
begin
  {$IFDEF USE_MARSHALLED_PTRS}
  LStringPtr := TPtrWrapper.Create(@LString[0]);
  {$ENDIF}
  ERR_error_string_n(AErr,
    {$IFDEF USE_MARSHALLED_PTRS}
    LStringPtr.ToPointer
    {$ELSE}
    LString
    {$ENDIF}, sMaxErrStr);
  LString[sMaxErrStr] := TIdAnsiChar(0);
  {$IFDEF USE_MARSHALLED_PTRS}
  Result := TMarshal.ReadStringAsAnsi(LStringPtr);
  {$ELSE}
  Result := String(LString);
  {$ENDIF}
end;

{$IFNDEF STATICLOAD_OPENSSL}

{$UNDEF USE_BASEUNIX_OR_VCL_POSIX}
{$IFDEF USE_BASEUNIX}
  {$DEFINE USE_BASEUNIX_OR_VCL_POSIX}
{$ENDIF}
{$IFDEF USE_VCL_POSIX}
  {$DEFINE USE_BASEUNIX_OR_VCL_POSIX}
{$ENDIF}

{$UNDEF USE_BASEUNIX_OR_VCL_POSIX_OR_KYLIXCOMPAT}
{$IFDEF USE_BASEUNIX_OR_VCL_POSIX}
  {$DEFINE USE_BASEUNIX_OR_VCL_POSIX_OR_KYLIXCOMPAT}
{$ENDIF}
{$IFDEF KYLIXCOMPAT}
  {$DEFINE USE_BASEUNIX_OR_VCL_POSIX_OR_KYLIXCOMPAT}
{$ENDIF}

var
  GIdOpenSSLPath: String = '';

procedure IdOpenSSLSetLibPath(const APath: String);
begin
  if APath <> '' then begin
    GIdOpenSSLPath := IndyIncludeTrailingPathDelimiter(APath);
  end else begin
    GIdOpenSSLPath := '';
  end;
end;

  {$IFDEF UNIX}
var
  // TODO: default these to False instead, as modern systems now
  // use symlinks that point to OpenSSL 1.1.x+, which is not
  // compatible with this unit...
  GIdCanLoadSymLinks: Boolean = True;
  GIdLoadSymLinksFirst: Boolean = True;

procedure IdOpenSSLSetCanLoadSymLinks(ACanLoad: Boolean);
begin
  GIdCanLoadSymLinks := ACanLoad;
end;

procedure IdOpenSSLSetLoadSymLinksFirst(ALoadFirst: Boolean);
begin
  GIdLoadSymLinksFirst := ALoadFirst;
end;
  {$ENDIF}

function LoadSSLCryptoLibrary: TIdLibHandle;
{$IFDEF WINDOWS}
var
  Err: DWORD;
{$ELSE}
  {$IFDEF USE_BASEUNIX_OR_VCL_POSIX_OR_KYLIXCOMPAT} // TODO: use {$IF DEFINED(UNIX)} instead?
var
  i, j: Integer;
  LLibVersions: array [0..26] of string;
  LCanLoadSymLinks, LLoadSymLinksFirst: Boolean;
  {$ENDIF}
{$ENDIF}
begin
  {$IFDEF WINDOWS}
  //On Windows, you should use SafeLoadLibrary because
  //the LoadLibrary API call messes with the FPU control word.
  Result := SafeLoadLibrary(GIdOpenSSLPath + SSLCLIB_DLL_name);
  if Result <> IdNilHandle then begin
    Exit;
  end;
  {$ELSE}
    {$IFDEF USE_BASEUNIX_OR_VCL_POSIX_OR_KYLIXCOMPAT} // TODO: use {$IF DEFINED(UNIX)} instead?
  // Workaround that is required under Linux (changed RTLD_GLOBAL with RTLD_LAZY Note: also work with LoadLibrary())
  Result := IdNilHandle;
  LCanLoadSymLinks := GIdCanLoadSymLinks;
  LLoadSymLinksFirst := GIdLoadSymLinksFirst;
  if LCanLoadSymLinks and LLoadSymLinksFirst then begin
    Result := HackLoad(GIdOpenSSLPath + SSLCLIB_DLL_name, []);
    if Result <> IdNilHandle then begin
      Exit;
    end;
    // TODO: exit here if the error is anything other than the file not being found...
  end;
  for i := Low(SSLDLLVers) to High(SSLDLLVers) do begin
    for j := Low(SSLDLLVersChar) to High(SSLDLLVersChar) do begin
      LLibVersions[j] := SSLDLLVers[i] + SSLDLLVersChar[j];
    end;
    Result := HackLoad(GIdOpenSSLPath + SSLCLIB_DLL_name, LLibVersions);
    if Result <> IdNilHandle then begin
      Exit;
    end;
    // TODO: exit here if the error is anything other than the file not being found...
  end;
  if LCanLoadSymLinks and (not LLoadSymLinksFirst) then begin
    Result := HackLoad(GIdOpenSSLPath + SSLCLIB_DLL_name, []);
    if Result <> IdNilHandle then begin
      Exit;
    end;
    // TODO: exit here if the error is anything other than the file not being found...
  end;
    {$ELSE}
  Result := IdNilHandle;
    {$ENDIF}
  {$ENDIF}
  {$IFDEF WINDOWS}
  Err := GetLastError;
  FFailedLoadList.Add(IndyFormat(RSOSSFailedToLoad_WithErrCode, [GIdOpenSSLPath + SSLCLIB_DLL_name, Err]));
  {$ELSE}
  // TODO: add error code to message...
  FFailedLoadList.Add(IndyFormat(RSOSSFailedToLoad, [GIdOpenSSLPath + SSLCLIB_DLL_name {$IFDEF UNIX}+ LIBEXT{$ENDIF}]));
  {$ENDIF}
end;

function LoadSSLLibrary: TIdLibHandle;
{$IFDEF WINDOWS}
var
  Err: DWORD;
{$ELSE}
  {$IFDEF USE_BASEUNIX_OR_VCL_POSIX_OR_KYLIXCOMPAT} // TODO: use {$IF DEFINED(UNIX)} instead?
var
  i, j: Integer;
  LLibVersions: array [0..26] of string;
  LCanLoadSymLinks, LLoadSymLinksFirst: Boolean;
  {$ENDIF}
{$ENDIF}
begin
  {$IFDEF WINDOWS}
  //On Windows, you should use SafeLoadLibrary because
  //the LoadLibrary API call messes with the FPU control word.
  Result := SafeLoadLibrary(GIdOpenSSLPath + SSL_DLL_name);
  if Result <> IdNilHandle then begin
    Exit;
  end;
  // TODO: exit here if the error is anything other than the file not being found...
  //This is a workaround for mingw32-compiled SSL .DLL which
  //might be named 'libssl32.dll'.
  Result := SafeLoadLibrary(GIdOpenSSLPath + SSL_DLL_name_alt);
  if Result <> IdNilHandle then begin
    Exit;
  end;
  {$ELSE}
    {$IFDEF USE_BASEUNIX_OR_VCL_POSIX_OR_KYLIXCOMPAT} // TODO: use {$IF DEFINED(UNIX)} instead?
  // Workaround that is required under Linux (changed RTLD_GLOBAL with RTLD_LAZY Note: also work with LoadLibrary())
  Result := IdNilHandle;
  LCanLoadSymLinks := GIdCanLoadSymLinks;
  LLoadSymLinksFirst := GIdLoadSymLinksFirst;
  if LCanLoadSymLinks and LLoadSymLinksFirst then begin
    Result := HackLoad(GIdOpenSSLPath + SSL_DLL_name, []);
    if Result <> IdNilHandle then begin
      Exit;
    end;
    // TODO: exit here if the error is anything other than the file not being found...
  end;
  for i := Low(SSLDLLVers) to High(SSLDLLVers) do begin
    for j := Low(SSLDLLVersChar) to High(SSLDLLVersChar) do begin
      LLibVersions[j] := SSLDLLVers[i] + SSLDLLVersChar[j];
    end;
    Result := HackLoad(GIdOpenSSLPath + SSL_DLL_name, LLibVersions);
    if Result <> IdNilHandle then begin
      Exit;
    end;
    // TODO: exit here if the error is anything other than the file not being found...
  end;
  if LCanLoadSymLinks and (not LLoadSymLinksFirst) then begin
    Result := HackLoad(GIdOpenSSLPath + SSL_DLL_name, []);
    if Result <> IdNilHandle then begin
      Exit;
    end;
    // TODO: exit here if the error is anything other than the file not being found...
  end;
    {$ELSE}
  Result := IdNilHandle;
    {$ENDIF}
  {$ENDIF}
  {$IFDEF WINDOWS}
  Err := GetLastError;
  FFailedLoadList.Add(IndyFormat(RSOSSFailedToLoad_WithErrCode, [GIdOpenSSLPath + SSL_DLL_name, Err]));
  {$ELSE}
  // TODO: add error code to message...
  FFailedLoadList.Add(IndyFormat(RSOSSFailedToLoad, [GIdOpenSSLPath + SSL_DLL_name {$IFDEF UNIX}+ LIBEXT{$ENDIF}]));
  {$ENDIF}
end;

{$ENDIF} // STATICLOAD_OPENSSL

{$IFDEF ANDROID}
// In Android 6, Google replaced OpenSSL with BoringSSL, which is a fork of
// OpenSSL and does not export many functions, including the following...

type
  msg_callback_proc = procedure(write_p, version, content_type : TIdC_INT; const buf : Pointer; len: size_t; ssl: PSSL; arg: Pointer); cdecl;

function Indy_ssl_callback_ctrl(s: PSSL; cb_id: TIdC_INT; fp: SSL_METHOD_PROC): TIdC_LONG; cdecl;
begin
  if cb_id = SSL_CTRL_SET_MSG_CALLBACK then begin
    s.msg_callback := msg_callback_proc(fp);
    Result := 1;
  end else begin
    Result := s.method.ssl_callback_ctrl(s, cb_id, fp);
  end;
end;

function Indy_SSL_CTX_callback_ctrl(ctx: PSSL_CTX; cmd: TIdC_INT; fp: SSL_METHOD_PROC): TIdC_LONG; cdecl;
begin
  if cmd = SSL_CTRL_SET_MSG_CALLBACK then begin
    ctx.msg_callback := msg_callback_proc(fp);
    Result := 1;
  end else begin
    Result := ctx.method.ssl_ctx_callback_ctrl(ctx, cmd, fp);
  end;
end;

procedure Indy_SSL_copy_session_id(sslTo: PSSL; const sslFrom: PSSL) cdecl;
begin
  // TODO: what to do here?
end;

procedure Indy_CRYPTO_lock(mode, _type : TIdC_INT; const _file : PIdAnsiChar; line : TIdC_INT) cdecl;
begin
  // TODO: what to do here?
end;
{$ENDIF}

{$IFDEF STATICLOAD_OPENSSL}

function Load: Boolean;
begin
  bIsLoaded := True;
  Result := True;
end;

{$ELSE}

function Load: Boolean;
var
  LVersion, LMajor, LMinor: TIdC_ULONG;
  LVersionStr: string;
begin
  Result := False;
  Assert(FFailedLoadList<>nil);

  if (hIdCrypto <> IdNilHandle) and (hIdSSL <> IdNilHandle) and (FFailedLoadList.Count = 0) then begin
    Result := True;
    Exit;
  end;

  FFailedLoadList.Clear;

  if hIdCrypto = IdNilHandle then begin
    hIdCrypto := LoadSSLCryptoLibrary;
    if hIdCrypto = IdNilHandle then begin
      Exit;
    end;
  end;

  if hIdSSL = IdNilHandle then begin
    hIdSSL := LoadSSLLibrary;
    if hIdSSL = IdNilHandle then begin
      Exit;
    end;
  end;

  // RLebeau 6/8/2021: verify the type of library is supported...

  @_SSLeay_version := LoadOldCLib(fn_SSLeay_version, 'OpenSSL_version'); {Do not localize} //Used by Indy 
  @SSLeay := LoadOldCLib(fn_SSLeay, 'OpenSSL_version_num'); {Do not localize} //Used by Indy 

  if Assigned(_SSLeay_version) then begin
    LVersionStr := String(_SSLeay_version(SSLEAY_VERSION));
  end;

  if TextStartsWith(LVersionStr, 'LibreSSL') then {do not localize}
  begin
    {
    According to the LibreSSL Portable GitHub repo:
    https://github.com/libressl-portable/portable

    LibreSSL is API compatible with OpenSSL 1.0.1, but does not yet include all new APIs from OpenSSL 1.0.2 and later.
    LibreSSL also includes APIs not yet present in OpenSSL. The current common API subset is OpenSSL 1.0.1.

    LibreSSL is not ABI compatible with any release of OpenSSL, or necessarily earlier releases of LibreSSL.
    You will need to relink your programs to LibreSSL in order to use it, just as in moving between major versions
    of OpenSSL. LibreSSL's installed library version numbers are incremented to account for ABI and API changes.
    }
    // TODO: add version checking?
  end
  else if TextStartsWith(LVersionStr, 'OpenSSL') or (LVersionStr = '') then {do not localize}
  begin
    // RLebeau 2/2/2021: verify the version is OpenSSL 1.0.2 or earlier, as OpenSSL 1.1.0 made MAJOR changes that we do not support yet...
    if Assigned(SSLeay) then
    begin
      LVersion := SSLeay;
      LMajor := (LVersion and $F0000000) shr 28;
      LMinor := (LVersion and $0FF00000) shr 20;
      if (LMajor = 0) and (LMinor = 0) then begin // < 0.9.3
        LMajor := (LVersion and $F000) shr 12;
        LMinor := (LVersion and $0F00) shr 8;
      end;
      if (LMajor > 1) or ((LMajor = 1) and (LMinor > 0)) then // OpenSSL 1.1.0 or higher
      begin
        FFailedLoadList.Add(IndyFormat(RSOSSUnsupportedVersion, [LVersion]));
        Exit;
      end;
    end;
  end else 
  begin
    FFailedLoadList.Add(IndyFormat(RSOSSUnsupportedLibrary, [LVersionStr]));
    Exit;
  end;

  // TODO: stop loading non-critical functions here.  We should use per-function
  // stubs instead, similar to the approach used in IdWinsock2.pas, so functions
  // are not loaded until they are actually used for the first time...

  @SSL_CTX_set_cipher_list := LoadFunction(fn_SSL_CTX_set_cipher_list);  //Used by Indy
  @SSL_CTX_new := LoadFunction(fn_SSL_CTX_new); //Used by Indy
  @SSL_CTX_free := LoadFunction(fn_SSL_CTX_free); //Used by Indy
  @SSL_set_fd := LoadFunction(fn_SSL_set_fd);  //Used by Indy
  @SSL_CTX_use_PrivateKey_file := LoadFunction(fn_SSL_CTX_use_PrivateKey_file);   //Used by Indy
  @SSL_CTX_use_PrivateKey := LoadFunction(fn_SSL_CTX_use_PrivateKey);  //Used by Indy
  @SSL_CTX_use_certificate := LoadFunction(fn_SSL_CTX_use_certificate); //Used by Indy
  @SSL_CTX_use_certificate_file := LoadFunction(fn_SSL_CTX_use_certificate_file);   //Used by Indy
  @SSL_CTX_use_certificate_chain_file := LoadFunction(fn_SSL_CTX_use_certificate_chain_file,False); //Used by Indy
  @SSL_load_error_strings := LoadFunction(fn_SSL_load_error_strings); //Used by Indy
  @SSL_state_string_long := LoadFunction(fn_SSL_state_string_long); //Used by Indy
  @SSL_alert_desc_string_long := LoadFunction(fn_SSL_alert_desc_string_long);  //Used by Indy
  @SSL_alert_type_string_long := LoadFunction(fn_SSL_alert_type_string_long);  //Used by Indy

  @SSL_get_peer_certificate := LoadFunction(fn_SSL_get_peer_certificate); //Used by Indy
  @SSL_CTX_set_verify := LoadFunction(fn_SSL_CTX_set_verify); //Used by Indy
  @SSL_CTX_set_verify_depth := LoadFunction(fn_SSL_CTX_set_verify_depth); //Used by Indy
  @SSL_CTX_get_verify_depth := LoadFunction(fn_SSL_CTX_get_verify_depth);
  @SSL_CTX_set_default_passwd_cb := LoadFunction(fn_SSL_CTX_set_default_passwd_cb);   //Used by Indy
  @SSL_CTX_set_default_passwd_cb_userdata:= LoadFunction(fn_SSL_CTX_set_default_passwd_cb_userdata); //Used by Indy
  @SSL_CTX_check_private_key := LoadFunction(fn_SSL_CTX_check_private_key);   //Used by Indy
  @SSL_new := LoadFunction(fn_SSL_new);   //Used by Indy
  @SSL_free := LoadFunction(fn_SSL_free);  //Used by Indy
  @SSL_accept := LoadFunction(fn_SSL_accept);    //Used by Indy
  @SSL_connect := LoadFunction(fn_SSL_connect);  //Used by Indy
  @SSL_read := LoadFunction(fn_SSL_read);     //Used by Indy
  @SSL_peek := LoadFunction(fn_SSL_peek,False);
  @SSL_pending := LoadFunction(fn_SSL_pending,False);
  @SSL_write := LoadFunction(fn_SSL_write);      //Used by Indy
  @SSL_ctrl := LoadFunction(fn_SSL_ctrl);
  @SSL_callback_ctrl := LoadFunction(fn_SSL_callback_ctrl{$IFDEF ANDROID}, False{$ENDIF});
  {$IFDEF ANDROID}
  if not Assigned(SSL_callback_ctrl) then begin
    @SSL_callback_ctrl := @Indy_SSL_callback_ctrl;
  end;
  {$ENDIF}
  @SSL_CTX_ctrl := LoadFunction(fn_SSL_CTX_ctrl);
  @SSL_CTX_callback_ctrl := LoadFunction(fn_SSL_CTX_callback_ctrl{$IFDEF ANDROID}, False{$ENDIF});
  {$IFDEF 