unit TestTree;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  {$IFDEF FPC}fpcunit, testutils, testregistry,
  {$ELSE}TestFramework,{$ENDIF}
  Classes, mTrees;

type

  TTestTree = class(TTestCase)
  strict private
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestSimpleTree;
  end;


implementation

uses
  SysUtils, Dialogs, Forms;


procedure TTestTree.SetUp;
begin
  inherited;
end;

procedure TTestTree.TearDown;
begin
  inherited;
end;

procedure TTestTree.TestSimpleTree;
var
  TempTree : TmTree;
begin
  TempTree := TmTree.Create;
  try
    TempTree.CreateRoot;
    CheckTrue(Assigned(TempTree.Root));
    TempTree.Root.Childs.Add.Childs.Add;
    CheckEquals(TempTree.Root.Childs.Count, 1);
    CheckEquals(TempTree.Root.Childs.Get(0).Childs.Count, 1);
    CheckEquals(TempTree.Root.Childs.Get(0).Childs.Get(0).Childs.Count, 0);
  finally
    TempTree.Free;
  end;
end;

initialization
  Randomize;
  // Register any test cases with the test runner
  {$IFDEF FPC}
  RegisterTest(TTestTree);
  {$ELSE}
  RegisterTest(TTestTree.Suite);
  {$ENDIF}

end.

