unit testmustache;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  {$IFDEF FPC}fpcunit, testutils, testregistry,
  {$ELSE}TestFramework,{$ENDIF}
  Classes, mMicroMustache;

type

  { TTestmMicroMustache }

  TTestmMicroMustache = class(TTestCase)
  strict private
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestSimple;
  end;


implementation

uses
  SysUtils;


{ TestMapReduce }

procedure TTestmMicroMustache.SetUp;
begin
  inherited;

end;

procedure TTestmMicroMustache.TearDown;
begin
  inherited;

end;


procedure TTestmMicroMustache.TestSimple;
var
  mustache : TmMicroMustache;
  str : String;
begin
  mustache := TmMicroMustache.Create;
  try
    mustache.AddValue('name', 'Mimmo');
    CheckEquals(mustache.Render('My name is {{name}}' + sLineBreak), 'My name is Mimmo' + sLineBreak);
    CheckEquals(mustache.Render('My name is {{name'), 'My name is {{name');
    CheckEquals(mustache.Render('My name is {{name}}}'), 'My name is Mimmo}');
  finally
    mustache.Free;
  end;
end;


initialization
  Randomize;
  // Register any test cases with the test runner
  {$IFDEF FPC}
  RegisterTest(TTestmMicroMustache);
  {$ELSE}
  RegisterTest(TTestmMicroMustache.Suite);
  {$ENDIF}

end.

