unit TestMapReduce;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  {$IFDEF FPC}fpcunit, testutils, testregistry,
  {$ELSE}TestFramework,{$ENDIF}
  Classes, mMapReduce;

type
  // Test methods for class TCustomIntegerList

  TTestMapReduce = class(TTestCase)
  strict private
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestAdd;
  end;
  // Test methods for class TIntegerList


implementation

uses
  SysUtils;


{ TestMapReduce }

procedure TTestMapReduce.SetUp;
begin
  inherited;

end;

procedure TTestMapReduce.TearDown;
begin
  inherited;

end;

function DoubleMySelf(a : Integer) : Integer;
begin
  Result := a * 2;
end;


procedure TTestMapReduce.TestAdd;
var
  i : integer;
  a : TIntegerArray;
begin
  SetLength(a, 1000);
  for i := 0 to 999 do
  begin
    a[i] := i;
  end;
  IntMap(DoubleMySelf, a);
  for i := 0 to 999 do
  begin
    CheckEquals(a[i], i * 2);
  end;
  SetLength(a, 0);
  Finalize(a);

end;

initialization
  Randomize;
  // Register any test cases with the test runner
  {$IFDEF FPC}
  RegisterTest(TTestMapReduce);
  {$ELSE}
  RegisterTest(TTestMapReduce.Suite);
  {$ENDIF}

end.

