unit TestParser;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

{$IFDEF FPC}
  {$MODE DELPHI}
{$ENDIF}

interface

uses
  {$IFDEF FPC}fpcunit, testutils, testregistry,
  {$ELSE}TestFramework,{$ENDIF}
  Classes, KAParser;

type

  { TTestmParser }

  TTestmParser = class(TTestCase)
  strict private
    procedure GetValue (Sender: TObject; const valueName: string; var Value: Double; out Successfull : boolean);
  public
    procedure SetUp; override;
    procedure TearDown; override;

  published
    procedure TestSimple;
    procedure TestSimpleStr;
    procedure TestIf;
  end;


implementation

uses
  SysUtils;


{ TestMapReduce }

procedure TTestmParser.GetValue(Sender: TObject; const valueName: string; var Value: Double; out Successfull: boolean);
begin
  if ValueName = 'TEMP' then
  begin
    Value := 5;
    Successfull:= true;
  end;
end;

procedure TTestmParser.SetUp;
begin
  inherited;

end;

procedure TTestmParser.TearDown;
begin
  inherited;

end;


procedure TTestmParser.TestSimple;
var
  parser : TKAParser;
  value : double;
begin
  parser := TKAParser.Create;
  try
    parser.Calculate('1+1', value);
    CheckEquals(value, 2);
    parser.Calculate('(1+1)', value);
    CheckEquals(value, 2);
    parser.Calculate('(1+2+1-2)', value);
    CheckEquals(value, 2);
    parser.Calculate('2*2', value);
    CheckEquals(value, 4);
    parser.Calculate('8/2', value);
    CheckEquals(value, 4);
    parser.Calculate('8.4/2', value);
    CheckTrue(abs(value - 4.2) < 0.0001);
    parser.Calculate('8,4/2', value);
    CheckTrue(abs(value - 4.2) < 0.0001);

    parser.Calculate('sin(pi/2)', value);
    CheckTrue (value = 1);
  finally
    parser.Free;
  end;
end;

procedure TTestmParser.TestSimpleStr;
var
  parser : TKAParser;
  value : double;
  valuestr : string;
begin
  parser := TKAParser.Create;
  try
    parser.Calculate('CompareText("pippo", "pippo")==0', value);
    CheckEquals(value, 1);
    parser.Calculate('CompareText("pippo", "pluto")==0', value);
    CheckEquals(value, 0);
    parser.Calculate('pos("p", "pluto")', value);
    CheckEquals(value, 1);
    parser.Calculate('pos("U", uppercase("pluto"))', value);
    CheckEquals(value, 3);
    parser.CalculateString('uppercase(''ciccio'')', valuestr);
    CheckEquals(valuestr, 'CICCIO');
  finally
    parser.Free;
  end;

end;

procedure TTestmParser.TestIf;
var
  parser : TKAParser;
  value : double;
begin
  parser := TKAParser.Create;
  try
    parser.OnGetValue:= Self.GetValue;
    parser.Calculate('IF(1,4,2)', value);
    CheckEquals(trunc(value), 4);
    parser.Calculate('IF(0,4,2)', value);
    CheckEquals(trunc(value), 2);
    parser.Calculate('IF(TEMP>0, TEMP + 2, 0)', value);
    CheckEquals(trunc(value), 7);
  finally
    parser.Free;
  end;

end;

initialization
  Randomize;
  // Register any test cases with the test runner
  {$IFDEF FPC}
  RegisterTest(TTestmParser);
  {$ELSE}
  RegisterTest(TTestmParser.Suite);
  {$ENDIF}

end.

