# Welcome to Django-CRM!

## Thank you for your interest in contributing to the project! 

<a href="https://github.com/DjangoCRM/django-crm" target="_blank">CRM software</a> published recently. So for now, just briefly.

Code contributions are not the only way to help the project. There are many opportunities to support and contribute:

- Just add a star ⭐️ and fork the repository, this will already be a valuable help for the project.
- Submit GitHub issues about bugs or desired new features.
  - Please follow the <a href="https://github.com/DjangoCRM/django-crm?tab=security-ov-file#security-ov-file" target="_blank">security policy</a>.
- Improving <a href="https://django-crm-admin.readthedocs.io/" target="_blank">Documentation</a> and help pages.
- Localization - performing translation (in context) CRM interface and help pages.
- Taking part in creating the project website on the github.io

### Writing Code

Now we are focused on improving the functionality that has already been created. 
Making it more convenient and understandable for a wide audience of users.  
Then we will start adding new features.  

- It's easier to start by working with issues marked with a <a href="https://github.com/DjangoCRM/django-crm/labels/good%20first%20issue" target="_blank">“good first issue”</a> label. They are supplied with instructions.
- Create a draft PR when starting work on bigger changes for discussion and assistance.  

> [!IMPORTANT]
> **Run tests before creating a Pull Request!**  
> 
> ```cmd
>   python manage.py test tests/ --noinput
> ```
