To change the language of the TTS, simply pass the corresponding
ISO 639-3 code to the `set_language` method of the `ToucanTTSInterface` instance.
This will change both the language the text is assumed to be in, and the accent.

If you want to change the language of the text and the accent independent of
one another, you can do so by passing the respective ISO 639-3 codes to the
`set_phonemizer_language` and `set_accent_language` methods individually.

<br><br>

| ISO 639-3 Code | Full Name of the Language                   |
|----------------|---------------------------------------------|
| aaa            | Ghotuo                                      | 
| aab            | Alumu-Tesu                                  | 
| aac            | Ari                                         | 
| aad            | Amal                                        | 
| aae            | Arbëreshë Albanian                          | 
| aaf            | Aranadan                                    | 
| aag            | Ambrak                                      | 
| aah            | Abu' Arapesh                                | 
| aai            | Arifama-Miniafia                            | 
| aak            | Ankave                                      | 
| aal            | Afade                                       | 
| aan            | Anambé                                      | 
| aao            | Algerian Saharan Arabic                     | 
| aap            | Pará Arára                                  | 
| aaq            | Eastern Abnaki                              | 
| aar            | Afar                                        | 
| aas            | Aasáx                                       | 
| aat            | Arvanitika Albanian                         | 
| aau            | Abau                                        | 
| aaw            | Solong                                      | 
| aax            | Mandobo Atas                                | 
| aaz            | Amarasi                                     | 
| aba            | Abé                                         | 
| abb            | Bankon                                      | 
| abc            | Ambala Ayta                                 | 
| abd            | Manide                                      | 
| abe            | Western Abnaki                              | 
| abf            | Abai Sungai                                 | 
| abg            | Abaga                                       | 
| abh            | Tajiki Arabic                               | 
| abi            | Abidji                                      | 
| abj            | Aka-Bea                                     | 
| abk            | Abkhazian                                   | 
| abl            | Lampung Nyo                                 | 
| abm            | Abanyom                                     | 
| abn            | Abua                                        | 
| abo            | Abon                                        | 
| abp            | Abellen Ayta                                | 
| abq            | Abaza                                       | 
| abr            | Abron                                       | 
| abs            | Ambonese Malay                              | 
| abt            | Ambulas                                     | 
| abu            | Abure                                       | 
| abv            | Baharna Arabic                              | 
| abw            | Pal                                         | 
| abx            | Inabaknon                                   | 
| aby            | Aneme Wake                                  | 
| abz            | Abui                                        | 
| aca            | Achagua                                     | 
| acd            | Gikyode                                     | 
| ace            | Achinese                                    | 
| acf            | Saint Lucian Creole French                  | 
| ach            | Acoli                                       | 
| aci            | Aka-Cari                                    | 
| ack            | Aka-Kora                                    | 
| acl            | Akar-Bale                                   | 
| acm            | Mesopotamian Arabic                         | 
| acn            | Achang                                      | 
| acp            | Eastern Acipa                               | 
| acq            | Ta'izzi-Adeni Arabic                        | 
| acr            | Achi                                        | 
| acs            | Acroá                                       | 
| act            | Achterhoeks                                 | 
| acu            | Achuar-Shiwiar                              | 
| acv            | Achumawi                                    | 
| acw            | Hijazi Arabic                               | 
| acx            | Omani Arabic                                | 
| acy            | Cypriot Arabic                              | 
| acz            | Acheron                                     | 
| ada            | Adangme                                     | 
| add            | Lidzonka                                    | 
| ade            | Adele                                       | 
| adf            | Dhofari Arabic                              | 
| adg            | Andegerebinha                               | 
| adh            | Adhola                                      | 
| adi            | Adi                                         | 
| adj            | Adioukrou                                   | 
| adl            | Galo                                        | 
| adn            | Adang                                       | 
| ado            | Abu                                         | 
| adq            | Adangbe                                     | 
| adr            | Adonara                                     | 
| adt            | Adnyamathanha                               | 
| adw            | Amundava                                    | 
| adx            | Amdo Tibetan                                | 
| ady            | Adyghe                                      | 
| adz            | Adzera                                      | 
| aea            | Areba                                       | 
| aeb            | Tunisian Arabic                             | 
| aec            | Saidi Arabic                                | 
| aee            | Northeast Pashayi                           | 
| aek            | Haeke                                       | 
| ael            | Ambele                                      | 
| aem            | Arem                                        | 
| aeq            | Aer                                         | 
| aer            | Eastern Arrernte                            | 
| aes            | Alsea                                       | 
| aeu            | Akeu                                        | 
| aew            | Ambakich                                    | 
| aey            | Amele                                       | 
| aez            | Aeka                                        | 
| afb            | Gulf Arabic                                 | 
| afd            | Andai                                       | 
| afe            | Putukwam                                    | 
| afi            | Chini                                       | 
| afk            | Nanubae                                     | 
| afn            | Defaka                                      | 
| afo            | Eloyi                                       | 
| afp            | Tapei                                       | 
| afr            | Afrikaans                                   | 
| afs            | Afro-Seminole Creole                        | 
| aft            | Afitti                                      | 
| afu            | Awutu                                       | 
| afz            | Obokuitai                                   | 
| agb            | Legbo                                       | 
| agc            | Agatu                                       | 
| agd            | Agarabi                                     | 
| age            | Angal                                       | 
| agf            | Arguni                                      | 
| agg            | Angor                                       | 
| agh            | Ngelima                                     | 
| agj            | Argobba                                     | 
| agk            | Isarog Agta                                 | 
| agl            | Fembe                                       | 
| agm            | Angaataha                                   | 
| agn            | Agutaynen                                   | 
| ago            | Tainae                                      | 
| agq            | Aghem                                       | 
| agr            | Aguaruna                                    | 
| ags            | Esimbi                                      | 
| agt            | Central Cagayan Agta                        | 
| agu            | Aguacateco                                  | 
| agv            | Remontado Dumagat                           | 
| agw            | Kahua                                       | 
| agx            | Aghul                                       | 
| agy            | Southern Alta                               | 
| agz            | Mt. Iriga Agta                              | 
| aha            | Ahanta                                      | 
| ahb            | Axamb                                       | 
| ahg            | Qimant                                      | 
| ahh            | Aghu                                        | 
| ahi            | Tiagbamrin Aizi                             | 
| ahk            | Akha                                        | 
| ahl            | Igo                                         | 
| ahm            | Mobumrin Aizi                               | 
| ahn            | Àhàn                                        | 
| aho            | Ahom                                        | 
| ahp            | Aproumu Aizi                                | 
| ahs            | Ashe                                        | 
| aht            | Ahtena                                      | 
| aia            | Arosi                                       | 
| aib            | Ainu (China)                                | 
| aic            | Ainbai                                      | 
| aid            | Alngith                                     | 
| aie            | Amara                                       | 
| aif            | Agi                                         | 
| aig            | Antigua and Barbuda Creole English          | 
| aih            | Ai-Cham                                     | 
| aii            | Assyrian Neo-Aramaic                        | 
| aij            | Lishanid Noshan                             | 
| aik            | Ake                                         | 
| ail            | Aimele                                      | 
| aim            | Aimol                                       | 
| ain            | Ainu (Japan)                                | 
| aio            | Aiton                                       | 
| aip            | Burumakok                                   | 
| aiq            | Aimaq                                       | 
| air            | Airoran                                     | 
| ait            | Arikem                                      | 
| aiw            | Aari                                        | 
| aix            | Aighon                                      | 
| aiy            | Ali                                         | 
| aja            | Aja (South Sudan)                           | 
| ajg            | Aja (Benin)                                 | 
| aji            | Ajië                                        | 
| ajn            | Andajin                                     | 
| ajp            | South Levantine Arabic                      | 
| ajt            | Judeo-Tunisian Arabic                       | 
| aju            | Judeo-Moroccan Arabic                       | 
| ajw            | Ajawa                                       | 
| ajz            | Amri Karbi                                  | 
| aka            | Akan                                        | 
| akb            | Batak Angkola                               | 
| akc            | Mpur                                        | 
| akd            | Ukpet-Ehom                                  | 
| ake            | Akawaio                                     | 
| akf            | Akpa                                        | 
| akg            | Anakalangu                                  | 
| akh            | Angal Heneng                                | 
| aki            | Aiome                                       | 
| akj            | Aka-Jeru                                    | 
| akk            | Akkadian                                    | 
| akl            | Aklanon                                     | 
| akm            | Aka-Bo                                      | 
| ako            | Akurio                                      | 
| akp            | Siwu                                        | 
| akq            | Ak                                          | 
| akr            | Araki                                       | 
| aks            | Akaselem                                    | 
| akt            | Akolet                                      | 
| aku            | Akum                                        | 
| akv            | Akhvakh                                     | 
| akw            | Akwa                                        | 
| akx            | Aka-Kede                                    | 
| aky            | Aka-Kol                                     | 
| akz            | Alabama                                     | 
| ala            | Alago                                       | 
| alc            | Qawasqar                                    | 
| ald            | Alladian                                    | 
| ale            | Aleut                                       | 
| alf            | Alege                                       | 
| alh            | Alawa                                       | 
| ali            | Amaimon                                     | 
| alj            | Alangan                                     | 
| alk            | Alak                                        | 
| all            | Allar                                       | 
| alm            | Amblong                                     | 
| aln            | Albanian                                    | 
| alo            | Larike-Wakasihu                             | 
| alp            | Alune                                       | 
| alq            | Algonquin                                   | 
| alr            | Alutor                                      | 
| als            | Tosk Albanian                               | 
| alt            | Southern Altai                              | 
| alu            | 'Are'are                                    | 
| alw            | Wanbasana                                   | 
| alx            | Amol                                        | 
| aly            | Alyawarr                                    | 
| alz            | Alur                                        | 
| ama            | Amanayé                                     | 
| amb            | Ambo                                        | 
| amc            | Amahuaca                                    | 
| ame            | Yanesha'                                    | 
| amf            | Hamer-Banna                                 | 
| amg            | Amurdak                                     | 
| amh            | Amharic                                     | 
| ami            | Amis                                        | 
| amj            | Amdang                                      | 
| amk            | Ambai                                       | 
| aml            | War-Jaintia                                 | 
| amm            | Ama (Papua New Guinea)                      | 
| amn            | Amanab                                      | 
| amo            | Amo                                         | 
| amp            | Alamblak                                    | 
| amq            | Amahai                                      | 
| amr            | Amarakaeri                                  | 
| ams            | Southern Amami-Oshima                       | 
| amt            | Amto                                        | 
| amu            | Guerrero Amuzgo                             | 
| amv            | Ambelau                                     | 
| amw            | Western Neo-Aramaic                         | 
| amx            | Anmatyerre                                  | 
| amy            | Ami                                         | 
| amz            | Atampaya                                    | 
| ana            | Andaqui                                     | 
| anb            | Andoa                                       | 
| anc            | Ngas                                        | 
| and            | Ansus                                       | 
| ane            | Xârâcùù                                     | 
| anf            | Animere                                     | 
| ang            | Old English (ca. 450-1100)                  | 
| anh            | Nend                                        | 
| ani            | Andi                                        | 
| anj            | Anor                                        | 
| ank            | Goemai                                      | 
| anl            | Anu-Hkongso Chin                            | 
| anm            | Anal                                        | 
| ann            | Obolo                                       | 
| ano            | Andoque                                     | 
| anp            | Angika                                      | 
| anq            | Jarawa (India)                              | 
| anr            | Andh                                        | 
| ans            | Anserma                                     | 
| ant            | Antikarinya                                 | 
| anu            | Anuak                                       | 
| anv            | Denya                                       | 
| anw            | Anaang                                      | 
| anx            | Andra-Hus                                   | 
| any            | Anyin                                       | 
| anz            | Anem                                        | 
| aoa            | Angolar                                     | 
| aob            | Abom                                        | 
| aoc            | Pemon                                       | 
| aod            | Andarum                                     | 
| aoe            | Angal Enen                                  | 
| aof            | Bragat                                      | 
| aog            | Angoram                                     | 
| aoi            | Anindilyakwa                                | 
| aoj            | Mufian                                      | 
| aok            | Arhö                                        | 
| aol            | Alor                                        | 
| aom            | Ömie                                        | 
| aon            | Bumbita Arapesh                             | 
| aor            | Aore                                        | 
| aos            | Taikat                                      | 
| aot            | Atong (India)                               | 
| aou            | A'ou                                        | 
| aox            | Atorada                                     | 
| aoz            | Uab Meto                                    | 
| apb            | Sa'a                                        | 
| apc            | North Levantine Arabic                      | 
| apd            | Sudanese Arabic                             | 
| ape            | Bukiyip                                     | 
| apf            | Pahanan Agta                                | 
| apg            | Ampanang                                    | 
| aph            | Athpariya                                   | 
| api            | Apiaká                                      | 
| apj            | Jicarilla Apache                            | 
| apk            | Kiowa Apache                                | 
| apl            | Lipan Apache                                | 
| apm            | Mescalero-Chiricahua Apache                 | 
| apn            | Apinayé                                     | 
| apo            | Ambul                                       | 
| app            | Apma                                        | 
| apq            | A-Pucikwar                                  | 
| apr            | Arop-Lokep                                  | 
| aps            | Arop-Sissano                                | 
| apt            | Apatani                                     | 
| apu            | Apurinã                                     | 
| apw            | Western Apache                              | 
| apx            | Aputai                                      | 
| apy            | Apalaí                                      | 
| apz            | Safeyoka                                    | 
| aqc            | Archi                                       | 
| aqd            | Ampari Dogon                                | 
| aqg            | Arigidi                                     | 
| aqk            | Aninka                                      | 
| aqm            | Atohwaim                                    | 
| aqn            | Northern Alta                               | 
| aqp            | Atakapa                                     | 
| aqr            | Arhâ                                        | 
| aqt            | Angaité                                     | 
| aqz            | Akuntsu                                     | 
| arb            | Standard Arabic                             | 
| arc            | Official Aramaic (700-300 BCE)              | 
| ard            | Arabana                                     | 
| are            | Western Arrarnta                            | 
| arg            | Aragonese                                   | 
| arh            | Arhuaco                                     | 
| ari            | Arikara                                     | 
| arj            | Arapaso                                     | 
| ark            | Arikapú                                     | 
| arl            | Arabela                                     | 
| arn            | Mapudungun                                  | 
| aro            | Araona                                      | 
| arp            | Arapaho                                     | 
| arq            | Algerian Arabic                             | 
| arr            | Karo (Brazil)                               | 
| ars            | Najdi Arabic                                | 
| aru            | Aruá (Amazonas State)                       | 
| arv            | Arbore                                      | 
| arw            | Arawak                                      | 
| arx            | Aruá (Rodonia State)                        | 
| ary            | Moroccan Arabic                             | 
| arz            | Egyptian Arabic                             | 
| asa            | Asu (Tanzania)                              | 
| asb            | Assiniboine                                 | 
| asc            | Casuarina Coast Asmat                       | 
| asg            | Cishingini                                  | 
| ash            | Abishira                                    | 
| asi            | Buruwai                                     | 
| asj            | Sari                                        | 
| ask            | Ashkun                                      | 
| asl            | Asilulu                                     | 
| asm            | Assamese                                    | 
| asn            | Xingú Asuriní                               | 
| aso            | Dano                                        | 
| asr            | Asuri                                       | 
| ass            | Ipulo                                       | 
| ast            | Leonese                                     | 
| asu            | Tocantins Asurini                           | 
| asv            | Asoa                                        | 
| asx            | Muratayak                                   | 
| asy            | Yaosakor Asmat                              | 
| asz            | As                                          | 
| ata            | Pele-Ata                                    | 
| atb            | Zaiwa                                       | 
| atc            | Atsahuaca                                   | 
| atd            | Ata Manobo                                  | 
| ate            | Atemble                                     | 
| atg            | Ivbie North-Okpela-Arhe                     | 
| ati            | Attié                                       | 
| atj            | Atikamekw                                   | 
| atk            | Ati                                         | 
| atl            | Mt. Iraya Agta                              | 
| atm            | Ata                                         | 
| atn            | Ashtiani                                    | 
| ato            | Atong (Cameroon)                            | 
| atp            | Pudtol Atta                                 | 
| atq            | Aralle-Tabulahan                            | 
| atr            | Waimiri-Atroari                             | 
| ats            | Gros Ventre                                 | 
| att            | Pamplona Atta                               | 
| atu            | Reel                                        | 
| atv            | Northern Altai                              | 
| atw            | Atsugewi                                    | 
| atx            | Arutani                                     | 
| aty            | Aneityum                                    | 
| atz            | Arta                                        | 
| aua            | Asumboa                                     | 
| aub            | Alugu                                       | 
| auc            | Waorani                                     | 
| aud            | Anuta                                       | 
| aug            | Aguna                                       | 
| auh            | Aushi                                       | 
| aui            | Anuki                                       | 
| auj            | Awjilah                                     | 
| auk            | Heyo                                        | 
| aul            | Aulua                                       | 
| aum            | Asu (Nigeria)                               | 
| aun            | Molmo One                                   | 
| auo            | Auyokawa                                    | 
| aup            | Makayam                                     | 
| auq            | Korur                                       | 
| aur            | Aruek                                       | 
| aut            | Austral                                     | 
| auu            | Auye                                        | 
| auw            | Awyi                                        | 
| aux            | Aurá                                        | 
| auy            | Awiyaana                                    | 
| auz            | Uzbeki Arabic                               | 
| ava            | Avaric                                      | 
| avb            | Avau                                        | 
| avd            | Alviri-Vidari                               | 
| ave            | Avestan                                     | 
| avi            | Avikam                                      | 
| avl            | Eastern Egyptian Bedawi Arabic              | 
| avm            | Angkamuthi                                  | 
| avn            | Avatime                                     | 
| avs            | Aushiri                                     | 
| avt            | Au                                          | 
| avu            | Avokaya                                     | 
| avv            | Avá-Canoeiro                                | 
| awa            | Awadhi                                      | 
| awb            | Awa (Papua New Guinea)                      | 
| awc            | Cicipu                                      | 
| awe            | Awetí                                       | 
| awg            | Anguthimri                                  | 
| awh            | Awbono                                      | 
| awi            | Aekyom                                      | 
| awk            | Awabakal                                    | 
| awm            | Arawum                                      | 
| awn            | Awngi                                       | 
| awo            | Awak                                        | 
| awr            | Awera                                       | 
| aws            | South Awyu                                  | 
| awt            | Araweté                                     | 
| awu            | Central Awyu                                | 
| awv            | Jair Awyu                                   | 
| aww            | Awun                                        | 
| awx            | Awara                                       | 
| awy            | Edera Awyu                                  | 
| axb            | Abipon                                      | 
| axg            | Mato Grosso Arára                           | 
| axk            | Yaka (Central African Republic)             | 
| axl            | Lower Southern Aranda                       | 
| axx            | Xârâgurè                                    | 
| aya            | Awar                                        | 
| ayb            | Ayizo Gbe                                   | 
| ayc            | Southern Aymara                             | 
| ayd            | Ayabadhu                                    | 
| aye            | Ayere                                       | 
| ayg            | Ginyanga                                    | 
| ayh            | Hadrami Arabic                              | 
| ayi            | Leyigha                                     | 
| ayk            | Akuku                                       | 
| ayl            | Libyan Arabic                               | 
| ayn            | Sanaani Arabic                              | 
| ayo            | Ayoreo                                      | 
| ayp            | North Mesopotamian Arabic                   | 
| ayq            | Ayi (Papua New Guinea)                      | 
| ayr            | Central Aymara                              | 
| ayt            | Magbukun Ayta                               | 
| ayu            | Ayu                                         | 
| ayz            | Mai Brat                                    | 
| aza            | Azha                                        | 
| azb            | South Azerbaijani                           | 
| azd            | Eastern Durango Nahuatl                     | 
| azg            | San Pedro Amuzgos Amuzgo                    | 
| azj            | Azerbaijani                                 | 
| azm            | Ipalapa Amuzgo                              | 
| azn            | Western Durango Nahuatl                     | 
| azo            | Awing                                       | 
| azt            | Faire Atta                                  | 
| azz            | Highland Puebla Nahuatl                     | 
| baa            | Babatana                                    | 
| bab            | Bainouk-Gunyuño                             | 
| bac            | Badui                                       | 
| bae            | Baré                                        | 
| baf            | Nubaca                                      | 
| bag            | Tuki                                        | 
| bah            | Bahamas Creole English                      | 
| baj            | Barakai                                     | 
| bak            | Bashkir                                     | 
| bam            | Bambara                                     | 
| ban            | Balinese                                    | 
| bao            | Waimaha                                     | 
| bap            | Bantawa                                     | 
| bar            | Bavarian                                    | 
| bas            | Basa (Cameroon)                             | 
| bau            | Bada (Nigeria)                              | 
| bav            | Vengo                                       | 
| baw            | Bambili-Bambui                              | 
| bax            | Bamun                                       | 
| bay            | Batuley                                     | 
| bba            | Baatonum                                    | 
| bbb            | Barai                                       | 
| bbc            | Batak Toba                                  | 
| bbd            | Bau                                         | 
| bbe            | Bangba                                      | 
| bbf            | Baibai                                      | 
| bbg            | Barama                                      | 
| bbh            | Bugan                                       | 
| bbi            | Barombi                                     | 
| bbj            | Ghomálá'                                    | 
| bbk            | Babanki                                     | 
| bbl            | Bats                                        | 
| bbm            | Babango                                     | 
| bbn            | Uneapa                                      | 
| bbo            | Northern Bobo Madaré                        | 
| bbp            | West Central Banda                          | 
| bbq            | Bamali                                      | 
| bbr            | Girawa                                      | 
| bbs            | Bakpinka                                    | 
| bbt            | Mburku                                      | 
| bbu            | Kulung (Nigeria)                            | 
| bbv            | Karnai                                      | 
| bbw            | Baba                                        | 
| bby            | Befang                                      | 
| bca            | Central Bai                                 | 
| bcc            | Southern Balochi                            | 
| bcd            | North Babar                                 | 
| bce            | Bamenyam                                    | 
| bcf            | Bamu                                        | 
| bcg            | Baga Pokur                                  | 
| bch            | Bariai                                      | 
| bci            | Baoulé                                      | 
| bcj            | Bardi                                       | 
| bck            | Bunuba                                      | 
| bcl            | Central Bikol                               | 
| bcm            | Bannoni                                     | 
| bcn            | Bali (Nigeria)                              | 
| bco            | Kaluli                                      | 
| bcp            | Bali (Democratic Republic of Congo)         | 
| bcq            | Bench                                       | 
| bcr            | Babine                                      | 
| bcs            | Kohumono                                    | 
| bct            | Bendi                                       | 
| bcu            | Awad Bing                                   | 
| bcv            | Shoo-Minda-Nye                              | 
| bcw            | Bana                                        | 
| bcy            | Bacama                                      | 
| bcz            | Bainouk-Gunyaamolo                          | 
| bda            | Bayot                                       | 
| bdb            | Basap                                       | 
| bdc            | Emberá-Baudó                                | 
| bdd            | Bunama                                      | 
| bde            | Bade                                        | 
| bdf            | Biage                                       | 
| bdg            | Bonggi                                      | 
| bdh            | Baka (South Sudan)                          | 
| bdi            | Burun                                       | 
| bdj            | Bai (South Sudan)                           | 
| bdk            | Budukh                                      | 
| bdl            | Indonesian Bajau                            | 
| bdm            | Buduma                                      | 
| bdn            | Baldemu                                     | 
| bdo            | Morom                                       | 
| bdp            | Bende                                       | 
| bdq            | Bahnar                                      | 
| bdr            | West Coast Bajau                            | 
| bds            | Burunge                                     | 
| bdt            | Bokoto                                      | 
| bdu            | Oroko                                       | 
| bdv            | Bodo Parja                                  | 
| bdw            | Baham                                       | 
| bdx            | Budong-Budong                               | 
| bdy            | Bandjalang                                  | 
| bea            | Beaver                                      | 
| beb            | Bebele                                      | 
| bec            | Iceve-Maci                                  | 
| bed            | Bedoanas                                    | 
| bee            | Byangsi                                     | 
| bef            | Benabena                                    | 
| beg            | Belait                                      | 
| beh            | Biali                                       | 
| bei            | Bekati'                                     | 
| bej            | Beja                                        | 
| bek            | Bebeli                                      | 
| bel            | Belarusian                                  | 
| bem            | Bemba (Zambia)                              | 
| ben            | Bengali                                     | 
| beo            | Beami                                       | 
| bep            | Besoa                                       | 
| beq            | Beembe                                      | 
| bes            | Besme                                       | 
| bet            | Guiberoua Béte                              | 
| beu            | Blagar                                      | 
| bev            | Daloa Bété                                  | 
| bew            | Betawi                                      | 
| bex            | Jur Modo                                    | 
| bey            | Beli (Papua New Guinea)                     | 
| bez            | Bena (Tanzania)                             | 
| bfa            | Bari                                        | 
| bfb            | Pauri Bareli                                | 
| bfc            | Panyi Bai                                   | 
| bfd            | Bafut                                       | 
| bfe            | Tena                                        | 
| bff            | Bofi                                        | 
| bfg            | Busang Kayan                                | 
| bfh            | Blafe                                       | 
| bfj            | Bafanji                                     | 
| bfl            | Banda-Ndélé                                 | 
| bfm            | Mmen                                        | 
| bfn            | Bunak                                       | 
| bfo            | Malba Birifor                               | 
| bfp            | Beba                                        | 
| bfq            | Badaga                                      | 
| bfs            | Southern Bai                                | 
| bft            | Balti                                       | 
| bfu            | Gahri                                       | 
| bfw            | Bondo                                       | 
| bfx            | Bantayanon                                  | 
| bfy            | Bagheli                                     | 
| bfz            | Mahasu Pahari                               | 
| bga            | Gwamhi-Wuri                                 | 
| bgb            | Bobongko                                    | 
| bgc            | Haryanvi                                    | 
| bgd            | Rathwi Bareli                               | 
| bge            | Bauria                                      | 
| bgf            | Bangandu                                    | 
| bgg            | Bugun                                       | 
| bgi            | Giangan                                     | 
| bgj            | Bangolan                                    | 
| bgk            | Buxinhua                                    | 
| bgl            | Bo (Laos)                                   | 
| bgn            | Western Balochi                             | 
| bgo            | Baga Koga                                   | 
| bgp            | Eastern Balochi                             | 
| bgq            | Bagri                                       | 
| bgr            | Bawm Chin                                   | 
| bgs            | Tagabawa                                    | 
| bgt            | Bughotu                                     | 
| bgu            | Mbongno                                     | 
| bgv            | Warkay-Bipim                                | 
| bgw            | Bhatri                                      | 
| bgx            | Balkan Gagauz Turkish                       | 
| bgy            | Benggoi                                     | 
| bgz            | Banggai                                     | 
| bha            | Bharia                                      | 
| bhb            | Bhili                                       | 
| bhc            | Biga                                        | 
| bhd            | Bhadrawahi                                  | 
| bhe            | Bhaya                                       | 
| bhf            | Odiai                                       | 
| bhg            | Binandere                                   | 
| bhh            | Bukharic                                    | 
| bhi            | Bhilali                                     | 
| bhj            | Bahing                                      | 
| bhl            | Bimin                                       | 
| bhm            | Bathari                                     | 
| bhn            | Bohtan Neo-Aramaic                          | 
| bho            | Bhojpuri                                    | 
| bhp            | Bima                                        | 
| bhq            | Tukang Besi South                           | 
| bhr            | Bara Malagasy                               | 
| bhs            | Buwal                                       | 
| bht            | Bhattiyali                                  | 
| bhu            | Bhunjia                                     | 
| bhv            | Bahau                                       | 
| bhw            | Biak                                        | 
| bhy            | Bhele                                       | 
| bhz            | Bada (Indonesia)                            | 
| bia            | Badimaya                                    | 
| bib            | Bissa                                       | 
| bid            | Bidiyo                                      | 
| bie            | Bepour                                      | 
| bif            | Biafada                                     | 
| big            | Biangai                                     | 
| bil            | Bile                                        | 
| bim            | Bimoba                                      | 
| bin            | Edo                                         | 
| bio            | Nai                                         | 
| bip            | Bila                                        | 
| biq            | Bipi                                        | 
| bir            | Bisorio                                     | 
| bis            | Bislama                                     | 
| bit            | Berinomo                                    | 
| biu            | Biete                                       | 
| biv            | Southern Birifor                            | 
| biw            | Kol (Cameroon)                              | 
| bix            | Bijori                                      | 
| biy            | Birhor                                      | 
| biz            | Baloi                                       | 
| bja            | Budza                                       | 
| bjb            | Banggarla                                   | 
| bjc            | Bariji                                      | 
| bje            | Biao-Jiao Mien                              | 
| bjf            | Barzani Jewish Neo-Aramaic                  | 
| bjg            | Bidyogo                                     | 
| bjh            | Bahinemo                                    | 
| bji            | Burji                                       | 
| bjj            | Kanauji                                     | 
| bjk            | Barok                                       | 
| bjl            | Bulu (Papua New Guinea)                     | 
| bjm            | Bajelani                                    | 
| bjn            | Banjar                                      | 
| bjo            | Mid-Southern Banda                          | 
| bjr            | Binumarien                                  | 
| bjs            | Bajan                                       | 
| bjt            | Balanta-Ganja                               | 
| bju            | Busuu                                       | 
| bjv            | Bedjond                                     | 
| bjw            | Bakwé                                       | 
| bjx            | Banao Itneg                                 | 
| bjy            | Bayali                                      | 
| bjz            | Baruga                                      | 
| bka            | Kyak                                        | 
| bkc            | Baka (Cameroon)                             | 
| bkd            | Talaandig                                   | 
| bkf            | Beeke                                       | 
| bkh            | Bakoko                                      | 
| bki            | Baki                                        | 
| bkj            | Pande                                       | 
| bkk            | Brokskat                                    | 
| bkl            | Berik                                       | 
| bkm            | Kom (Cameroon)                              | 
| bkn            | Bukitan                                     | 
| bko            | Kwa'                                        | 
| bkp            | Boko (Democratic Republic of Congo)         | 
| bkq            | Bakairí                                     | 
| bkr            | Bakumpai                                    | 
| bks            | Northern Sorsoganon                         | 
| bkt            | Boloki                                      | 
| bku            | Buhid                                       | 
| bkv            | Bekwarra                                    | 
| bkw            | Bekwel                                      | 
| bkx            | Baikeno                                     | 
| bky            | Bokyi                                       | 
| bkz            | Bungku                                      | 
| bla            | Siksika                                     | 
| blb            | Bilua                                       | 
| blc            | Bella Coola                                 | 
| bld            | Bolango                                     | 
| ble            | Balanta-Kentohe                             | 
| blf            | Buol                                        | 
| blh            | Kuwaa                                       | 
| bli            | Bolia                                       | 
| blj            | Bolongan                                    | 
| blk            | Pa'o Karen                                  | 
| bll            | Biloxi                                      | 
| blm            | Beli (South Sudan)                          | 
| bln            | Southern Catanduanes Bikol                  | 
| blo            | Anii                                        | 
| blp            | Blablanga                                   | 
| blq            | Baluan-Pam                                  | 
| blr            | Blang                                       | 
| bls            | Balaesang                                   | 
| blt            | Tai Dam                                     | 
| blv            | Kibala                                      | 
| blw            | Balangao                                    | 
| blx            | Mag-Indi Ayta                               | 
| bly            | Notre                                       | 
| blz            | Balantak                                    | 
| bma            | Lame                                        | 
| bmb            | Bembe                                       | 
| bmc            | Biem                                        | 
| bmd            | Baga Manduri                                | 
| bme            | Limassa                                     | 
| bmf            | Bom-Kim                                     | 
| bmg            | Bamwe                                       | 
| bmh            | Kein                                        | 
| bmi            | Bagirmi                                     | 
| bmj            | Bote-Majhi                                  | 
| bmk            | Ghayavi                                     | 
| bml            | Bomboli                                     | 
| bmm            | Northern Betsimisaraka Malagasy             | 
| bmn            | Bina (Papua New Guinea)                     | 
| bmo            | Bambalang                                   | 
| bmp            | Bulgebi                                     | 
| bmq            | Bomu                                        | 
| bmr            | Muinane                                     | 
| bms            | Bilma Kanuri                                | 
| bmt            | Biao Mon                                    | 
| bmu            | Somba-Siawari                               | 
| bmv            | Bum                                         | 
| bmw            | Bomwali                                     | 
| bmx            | Baimak                                      | 
| bmz            | Baramu                                      | 
| bna            | Bonerate                                    | 
| bnb            | Bookan                                      | 
| bnc            | Bontok                                      | 
| bnd            | Banda (Indonesia)                           | 
| bne            | Bintauna                                    | 
| bnf            | Masiwang                                    | 
| bng            | Benga                                       | 
| bni            | Bangi                                       | 
| bnj            | Eastern Tawbuid                             | 
| bnk            | Bierebo                                     | 
| bnl            | Boon                                        | 
| bnm            | Batanga                                     | 
| bnn            | Bunun                                       | 
| bno            | Bantoanon                                   | 
| bnp            | Bola                                        | 
| bnq            | Bantik                                      | 
| bnr            | Butmas-Tur                                  | 
| bns            | Bundeli                                     | 
| bnu            | Bentong                                     | 
| bnv            | Edwas                                       | 
| bnw            | Bisis                                       | 
| bnx            | Bangubangu                                  | 
| bny            | Bintulu                                     | 
| bnz            | Beezen                                      | 
| boa            | Bora                                        | 
| bob            | Aweer                                       | 
| bod            | Tibetan                                     | 
| boe            | Mundabli                                    | 
| bof            | Bolon                                       | 
| boh            | Boma                                        | 
| boi            | Barbareño                                   | 
| boj            | Anjam                                       | 
| bok            | Bonjo                                       | 
| bol            | Bole                                        | 
| bom            | Berom                                       | 
| bon            | Bine                                        | 
| boo            | Tiemacèwè Bozo                              | 
| bop            | Bonkiman                                    | 
| boq            | Bogaya                                      | 
| bor            | Borôro                                      | 
| bos            | Bosnian                                     | 
| bot            | Bongo                                       | 
| bou            | Bondei                                      | 
| bov            | Tuwuli                                      | 
| bow            | Rema                                        | 
| box            | Buamu                                       | 
| boy            | Bodo (Central African Republic)             | 
| boz            | Tiéyaxo Bozo                                | 
| bpa            | Daakaka                                     | 
| bpd            | Banda-Banda                                 | 
| bpe            | Bauni                                       | 
| bpg            | Bonggo                                      | 
| bph            | Botlikh                                     | 
| bpi            | Bagupi                                      | 
| bpj            | Binji                                       | 
| bpk            | Orowe                                       | 
| bpm            | Biyom                                       | 
| bpn            | Dzao Min                                    | 
| bpp            | Kaure                                       | 
| bpq            | Banda Malay                                 | 
| bpr            | Koronadal Blaan                             | 
| bps            | Sarangani Blaan                             | 
| bpt            | Barrow Point                                | 
| bpu            | Bongu                                       | 
| bpv            | Bian Marind                                 | 
| bpw            | Bo (Papua New Guinea)                       | 
| bpx            | Palya Bareli                                | 
| bpy            | Bishnupriya                                 | 
| bpz            | Bilba                                       | 
| bqa            | Tchumbuli                                   | 
| bqb            | Bagusa                                      | 
| bqc            | Boo                                         | 
| bqd            | Bung                                        | 
| bqg            | Bago-Kusuntu                                | 
| bqh            | Baima                                       | 
| bqi            | Bakhtiari                                   | 
| bqj            | Bandial                                     | 
| bqk            | Banda-Mbrès                                 | 
| bql            | Bilakura                                    | 
| bqm            | Wumboko                                     | 
| bqo            | Balo                                        | 
| bqp            | Busa                                        | 
| bqq            | Biritai                                     | 
| bqr            | Burusu                                      | 
| bqs            | Bosngun                                     | 
| bqt            | Bamukumbit                                  | 
| bqu            | Boguru                                      | 
| bqv            | Koro Wachi                                  | 
| bqw            | Buru (Nigeria)                              | 
| bqx            | Baangi                                      | 
| bqz            | Bakaka                                      | 
| bra            | Braj                                        | 
| brb            | Lave                                        | 
| brc            | Berbice Creole Dutch                        | 
| brd            | Baraamu                                     | 
| bre            | Breton                                      | 
| brf            | Bira                                        | 
| brg            | Baure                                       | 
| brh            | Brahui                                      | 
| bri            | Mokpwe                                      | 
| brj            | Bieria                                      | 
| brk            | Birked                                      | 
| brl            | Birwa                                       | 
| brm            | Barambu                                     | 
| brn            | Boruca                                      | 
| bro            | Brokkat                                     | 
| brp            | Barapasi                                    | 
| brq            | Breri                                       | 
| brr            | Birao                                       | 
| brs            | Baras                                       | 
| brt            | Bitare                                      | 
| bru            | Eastern Bru                                 | 
| brv            | Western Bru                                 | 
| brw            | Bellari                                     | 
| brx            | Bodo (India)                                | 
| bry            | Burui                                       | 
| brz            | Bilbil                                      | 
| bsa            | Abinomn                                     | 
| bsb            | Brunei Bisaya                               | 
| bsc            | Oniyan                                      | 
| bse            | Wushi                                       | 
| bsf            | Bauchi                                      | 
| bsg            | Bashkardi                                   | 
| bsh            | Kati                                        | 
| bsi            | Bassossi                                    | 
| bsj            | Bangwinji                                   | 
| bsk            | Burushaski                                  | 
| bsl            | Basa-Gumna                                  | 
| bsm            | Busami                                      | 
| bsn            | Barasana-Eduria                             | 
| bsp            | Baga Sitemu                                 | 
| bsq            | Bassa                                       | 
| bsr            | Bassa-Kontagora                             | 
| bss            | Akoose                                      | 
| bst            | Basketo                                     | 
| bsu            | Bahonsuai                                   | 
| bsw            | Baiso                                       | 
| bsx            | Yangkam                                     | 
| bsy            | Sabah Bisaya                                | 
| bta            | Bata                                        | 
| btc            | Bati (Cameroon)                             | 
| btd            | Batak Dairi                                 | 
| bte            | Gamo-Ningi                                  | 
| btf            | Birgit                                      | 
| btg            | Gagnoa Bété                                 | 
| bth            | Biatah Bidayuh                              | 
| bti            | Burate                                      | 
| btj            | Bacanese Malay                              | 
| btm            | Batak Mandailing                            | 
| btn            | Ratagnon                                    | 
| bto            | Rinconada Bikol                             | 
| btp            | Budibud                                     | 
| btq            | Batek                                       | 
| btr            | Baetora                                     | 
| bts            | Batak Simalungun                            | 
| btt            | Bete-Bendi                                  | 
| btu            | Batu                                        | 
| btv            | Bateri                                      | 
| btw            | Butuanon                                    | 
| btx            | Batak Karo                                  | 
| bty            | Bobot                                       | 
| btz            | Batak Alas-Kluet                            | 
| bub            | Bua                                         | 
| buc            | Bushi                                       | 
| bud            | Ntcham                                      | 
| bue            | Beothuk                                     | 
| buf            | Bushoong                                    | 
| bug            | Buginese                                    | 
| buh            | Younuo Bunu                                 | 
| bui            | Bongili                                     | 
| buj            | Basa-Gurmana                                | 
| buk            | Bugawac                                     | 
| bul            | Bulgarian                                   | 
| bum            | Bulu (Cameroon)                             | 
| bun            | Sherbro                                     | 
| buo            | Terei                                       | 
| bup            | Busoa                                       | 
| buq            | Brem                                        | 
| bus            | Bokobaru                                    | 
| but            | Bungain                                     | 
| buu            | Budu                                        | 
| buv            | Bun                                         | 
| buw            | Bubi                                        | 
| bux            | Boghom                                      | 
| buy            | Bullom So                                   | 
| buz            | Bukwen                                      | 
| bva            | Barein                                      | 
| bvb            | Bube                                        | 
| bvc            | Baelelea                                    | 
| bvd            | Baeggu                                      | 
| bve            | Berau Malay                                 | 
| bvf            | Boor                                        | 
| bvg            | Bonkeng                                     | 
| bvh            | Bure                                        | 
| bvi            | Belanda Viri                                | 
| bvj            | Baan                                        | 
| bvk            | Bukat                                       | 
| bvm            | Bamunka                                     | 
| bvn            | Buna                                        | 
| bvo            | Bolgo                                       | 
| bvq            | Birri                                       | 
| bvr            | Burarra                                     | 
| bvt            | Bati (Indonesia)                            | 
| bvu            | Bukit Malay                                 | 
| bvv            | Baniva                                      | 
| bvw            | Boga                                        | 
| bvx            | Dibole                                      | 
| bvy            | Baybayanon                                  | 
| bvz            | Bauzi                                       | 
| bwa            | Bwatoo                                      | 
| bwb            | Namosi-Naitasiri-Serua                      | 
| bwc            | Bwile                                       | 
| bwd            | Bwaidoka                                    | 
| bwe            | Bwe Karen                                   | 
| bwf            | Boselewa                                    | 
| bwg            | Barwe                                       | 
| bwh            | Bishuo                                      | 
| bwi            | Baniwa                                      | 
| bwj            | Láá Láá Bwamu                               | 
| bwk            | Bauwaki                                     | 
| bwl            | Bwela                                       | 
| bwm            | Biwat                                       | 
| bwn            | Wunai Bunu                                  | 
| bwo            | Boro (Ethiopia)                             | 
| bwp            | Mandobo Bawah                               | 
| bwq            | Southern Bobo Madaré                        | 
| bwr            | Bura-Pabir                                  | 
| bws            | Bomboma                                     | 
| bwt            | Bafaw-Balong                                | 
| bwu            | Buli (Ghana)                                | 
| bww            | Bwa                                         | 
| bwx            | Bu-Nao Bunu                                 | 
| bwy            | Cwi Bwamu                                   | 
| bwz            | Bwisi                                       | 
| bxa            | Tairaha                                     | 
| bxb            | Belanda Bor                                 | 
| bxc            | Molengue                                    | 
| bxd            | Pela                                        | 
| bxe            | Birale                                      | 
| bxf            | Minigir                                     | 
| bxg            | Bangala                                     | 
| bxh            | Buhutu                                      | 
| bxi            | Pirlatapa                                   | 
| bxj            | Bayungu                                     | 
| bxk            | Lubukusu                                    | 
| bxl            | Jalkunan                                    | 
| bxm            | Mongolia Buriat                             | 
| bxn            | Burduna                                     | 
| bxp            | Bebil                                       | 
| bxq            | Beele                                       | 
| bxr            | Russia Buriat                               | 
| bxs            | Busam                                       | 
| bxu            | China Buriat                                | 
| bxv            | Berakou                                     | 
| bxw            | Bankagooma                                  | 
| bxz            | Binahari                                    | 
| bya            | Batak                                       | 
| byb            | Bikya                                       | 
| byc            | Ubaghara                                    | 
| byd            | Benyadu'                                    | 
| bye            | Pouye                                       | 
| byf            | Bete                                        | 
| byg            | Baygo                                       | 
| byh            | Bhujel                                      | 
| byi            | Buyu                                        | 
| byj            | Bina (Nigeria)                              | 
| byk            | Biao                                        | 
| byl            | Bayono                                      | 
| bym            | Bidjara                                     | 
| byn            | Blin                                        | 
| byo            | Biyo                                        | 
| byp            | Bumaji                                      | 
| byq            | Basay                                       | 
| byr            | Yipma                                       | 
| bys            | Burak                                       | 
| byt            | Berti                                       | 
| byv            | Medumba                                     | 
| byw            | Belhariya                                   | 
| byx            | Qaqet                                       | 
| byz            | Banaro                                      | 
| bza            | Bandi                                       | 
| bzb            | Andio                                       | 
| bzc            | Southern Betsimisaraka Malagasy             | 
| bzd            | Bribri                                      | 
| bze            | Jenaama Bozo                                | 
| bzf            | Boikin                                      | 
| bzg            | Babuza                                      | 
| bzh            | Mapos Buang                                 | 
| bzi            | Bisu                                        | 
| bzj            | Belize Kriol English                        | 
| bzk            | Nicaragua Creole English                    | 
| bzl            | Boano (Sulawesi)                            | 
| bzm            | Bolondo                                     | 
| bzn            | Boano (Maluku)                              | 
| bzo            | Bozaba                                      | 
| bzp            | Kemberano                                   | 
| bzq            | Buli (Indonesia)                            | 
| bzr            | Biri                                        | 
| bzu            | Burmeso                                     | 
| bzv            | Naami                                       | 
| bzw            | Basa (Nigeria)                              | 
| bzx            | Kɛlɛngaxo Bozo                              | 
| bzy            | Obanliku                                    | 
| bzz            | Evant                                       | 
| caa            | Chortí                                      | 
| cab            | Garifuna                                    | 
| cac            | Chuj                                        | 
| cad            | Caddo                                       | 
| cae            | Lehar                                       | 
| caf            | Southern Carrier                            | 
| cag            | Nivaclé                                     | 
| cah            | Cahuarano                                   | 
| caj            | Chané                                       | 
| cak            | Kaqchikel                                   | 
| cal            | Carolinian                                  | 
| cam            | Cemuhî                                      | 
| can            | Chambri                                     | 
| cao            | Chácobo                                     | 
| cap            | Chipaya                                     | 
| caq            | Car Nicobarese                              | 
| car            | Galibi Carib                                | 
| cas            | Tsimané                                     | 
| cat            | Valencian                                   | 
| cav            | Cavineña                                    | 
| cax            | Chiquitano                                  | 
| cay            | Cayuga                                      | 
| caz            | Canichana                                   | 
| cbb            | Cabiyarí                                    | 
| cbc            | Carapana                                    | 
| cbd            | Carijona                                    | 
| cbg            | Chimila                                     | 
| cbi            | Chachi                                      | 
| cbj            | Ede Cabe                                    | 
| cbk            | Chavacano                                   | 
| cbl            | Bualkhaw Chin                               | 
| cbn            | Nyahkur                                     | 
| cbo            | Izora                                       | 
| cbq            | Tsucuba                                     | 
| cbr            | Cashibo-Cacataibo                           | 
| cbs            | Cashinahua                                  | 
| cbt            | Chayahuita                                  | 
| cbu            | Candoshi-Shapra                             | 
| cbv            | Cacua                                       | 
| cbw            | Kinabalian                                  | 
| ccc            | Chamicuro                                   | 
| ccd            | Cafundo Creole                              | 
| cce            | Chopi                                       | 
| ccg            | Samba Daka                                  | 
| cch            | Atsam                                       | 
| ccj            | Kasanga                                     | 
| ccl            | Cutchi-Swahili                              | 
| ccm            | Malaccan Creole Malay                       | 
| cco            | Comaltepec Chinantec                        | 
| ccp            | Chakma                                      | 
| ccr            | Cacaopera                                   | 
| cda            | Choni                                       | 
| cde            | Chenchu                                     | 
| cdf            | Chiru                                       | 
| cdh            | Chambeali                                   | 
| cdi            | Chodri                                      | 
| cdj            | Churahi                                     | 
| cdm            | Chepang                                     | 
| cdn            | Chaudangsi                                  | 
| cdo            | Min Dong Chinese                            | 
| cdr            | Cinda-Regi-Tiyal                            | 
| cdy            | Chadong                                     | 
| cdz            | Koda                                        | 
| cea            | Lower Chehalis                              | 
| ceb            | Cebuano                                     | 
| ceg            | Chamacoco                                   | 
| cek            | Eastern Khumi Chin                          | 
| cen            | Cen                                         | 
| ces            | Czech                                       | 
| cet            | Centúúm                                     | 
| cfa            | Dijim-Bwilim                                | 
| cfd            | Cara                                        | 
| cfg            | Como Karim                                  | 
| cfm            | Falam Chin                                  | 
| cga            | Changriwa                                   | 
| cgc            | Kagayanen                                   | 
| cgg            | Chiga                                       | 
| cgk            | Chocangacakha                               | 
| cha            | Chamorro                                    | 
| chb            | Chibcha                                     | 
| chc            | Catawba                                     | 
| chd            | Highland Oaxaca Chontal                     | 
| che            | Chechen                                     | 
| chf            | Tabasco Chontal                             | 
| chg            | Chagatai                                    | 
| chh            | Chinook                                     | 
| chj            | Ojitlán Chinantec                           | 
| chk            | Chuukese                                    | 
| chl            | Cahuilla                                    | 
| chn            | Chinook jargon                              | 
| cho            | Choctaw                                     | 
| chp            | Dene Suline                                 | 
| chq            | Quiotepec Chinantec                         | 
| chr            | Cherokee                                    | 
| cht            | Cholón                                      | 
| chu            | Old Slavonic                                | 
| chv            | Chuvash                                     | 
| chw            | Chuwabu                                     | 
| chx            | Chantyal                                    | 
| chy            | Cheyenne                                    | 
| chz            | Ozumacín Chinantec                          | 
| cia            | Cia-Cia                                     | 
| cib            | Ci Gbe                                      | 
| cic            | Chickasaw                                   | 
| cid            | Chimariko                                   | 
| cie            | Cineni                                      | 
| cih            | Chinali                                     | 
| cik            | Chitkuli Kinnauri                           | 
| cim            | Cimbrian                                    | 
| cin            | Cinta Larga                                 | 
| cip            | Chiapanec                                   | 
| cir            | Tiri                                        | 
| ciw            | Chippewa                                    | 
| ciy            | Chaima                                      | 
| cja            | Western Cham                                | 
| cje            | Chru                                        | 
| cjh            | Upper Chehalis                              | 
| cji            | Chamalal                                    | 
| cjk            | Chokwe                                      | 
| cjm            | Eastern Cham                                | 
| cjn            | Chenapian                                   | 
| cjo            | Ashéninka Pajonal                           | 
| cjp            | Cabécar                                     | 
| cjs            | Shor                                        | 
| cjv            | Chuave                                      | 
| cjy            | Jinyu Chinese                               | 
| ckb            | Kurdish                                     | 
| ckh            | Chak                                        | 
| ckl            | Cibak                                       | 
| cko            | Anufo                                       | 
| ckq            | Kajakse                                     | 
| ckr            | Kairak                                      | 
| cks            | Tayo                                        | 
| ckt            | Chukot                                      | 
| cku            | Koasati                                     | 
| ckv            | Kavalan                                     | 
| ckx            | Caka                                        | 
| cky            | Cakfem-Mushere                              | 
| cla            | Ron                                         | 
| clc            | Chilcotin                                   | 
| cld            | Chaldean Neo-Aramaic                        | 
| cle            | Lealao Chinantec                            | 
| clh            | Chilisso                                    | 
| cli            | Chakali                                     | 
| clk            | Idu-Mishmi                                  | 
| cll            | Chala                                       | 
| clm            | Clallam                                     | 
| clo            | Lowland Oaxaca Chontal                      | 
| clt            | Lautu Chin                                  | 
| clu            | Caluyanun                                   | 
| clw            | Chulym                                      | 
| cly            | Eastern Highland Chatino                    | 
| cma            | Maa                                         | 
| cme            | Cerma                                       | 
| cmi            | Emberá-Chamí                                | 
| cml            | Campalagian                                 | 
| cmn            | Mandarin Chinese                            | 
| cmo            | Central Mnong                               | 
| cmr            | Mro-Khimi Chin                              | 
| cms            | Messapic                                    | 
| cna            | Changthang                                  | 
| cnb            | Chinbon Chin                                | 
| cnc            | Côông                                       | 
| cng            | Northern Qiang                              | 
| cnh            | Hakha Chin                                  | 
| cni            | Asháninka                                   | 
| cnk            | Khumi Chin                                  | 
| cnl            | Lalana Chinantec                            | 
| cnp            | Northern Pinghua                            | 
| cns            | Central Asmat                               | 
| cnt            | Tepetotutla Chinantec                       | 
| cnu            | Chenoua                                     | 
| cnw            | Ngawn Chin                                  | 
| coa            | Cocos Islands Malay                         | 
| cob            | Chicomuceltec                               | 
| coc            | Cocopa                                      | 
| cod            | Cocama-Cocamilla                            | 
| coe            | Koreguaje                                   | 
| cof            | Colorado                                    | 
| cog            | Chong                                       | 
| coh            | Chonyi-Dzihana-Kauma                        | 
| coj            | Cochimi                                     | 
| cok            | Santa Teresa Cora                           | 
| col            | Columbia-Wenatchi                           | 
| com            | Comanche                                    | 
| con            | Cofán                                       | 
| coo            | Comox                                       | 
| cop            | Coptic                                      | 
| coq            | Coquille                                    | 
| cor            | Cornish                                     | 
| cos            | Corsican                                    | 
| cot            | Caquinte                                    | 
| cou            | Wamey                                       | 
| cov            | Cao Miao                                    | 
| cow            | Cowlitz                                     | 
| cox            | Nanti                                       | 
| coz            | Chochotec                                   | 
| cpa            | Palantla Chinantec                          | 
| cpb            | Ucayali-Yurúa Ashéninka                     | 
| cpc            | Ajyíninka Apurucayali                       | 
| cpg            | Cappadocian Greek                           | 
| cpn            | Cherepon                                    | 
| cpo            | Kpeego                                      | 
| cps            | Capiznon                                    | 
| cpu            | Pichis Ashéninka                            | 
| cpx            | Pu-Xian Chinese                             | 
| cpy            | South Ucayali Ashéninka                     | 
| cra            | Chara                                       | 
| crb            | Island Carib                                | 
| crc            | Lonwolwol                                   | 
| crd            | Coeur d'Alene                               | 
| crf            | Caramanta                                   | 
| crg            | Michif                                      | 
| crh            | Crimean Turkish                             | 
| cri            | Sãotomense                                  | 
| crj            | Southern East Cree                          | 
| crk            | Plains Cree                                 | 
| crl            | Northern East Cree                          | 
| crm            | Moose Cree                                  | 
| crn            | El Nayar Cora                               | 
| cro            | Crow                                        | 
| crq            | Iyo'wujwa Chorote                           | 
| crr            | Carolina Algonquian                         | 
| crs            | Seselwa Creole French                       | 
| crt            | Iyojwa'ja Chorote                           | 
| crv            | Chaura                                      | 
| crw            | Chrau                                       | 
| crx            | Carrier                                     | 
| cry            | Cori                                        | 
| crz            | Cruzeño                                     | 
| csa            | Chiltepec Chinantec                         | 
| csb            | Kashubian                                   | 
| csh            | Asho Chin                                   | 
| csi            | Coast Miwok                                 | 
| csk            | Jola-Kasa                                   | 
| csm            | Central Sierra Miwok                        | 
| cso            | Sochiapan Chinantec                         | 
| csp            | Southern Pinghua                            | 
| css            | Southern Ohlone                             | 
| cst            | Northern Ohlone                             | 
| csv            | Sumtu Chin                                  | 
| csw            | Swampy Cree                                 | 
| csy            | Siyin Chin                                  | 
| csz            | Coos                                        | 
| cta            | Tataltepec Chatino                          | 
| ctd            | Tedim Chin                                  | 
| cte            | Tepinapa Chinantec                          | 
| ctg            | Chittagonian                                | 
| ctl            | Tlacoatzintepec Chinantec                   | 
| ctm            | Chitimacha                                  | 
| ctn            | Chhintange                                  | 
| cto            | Emberá-Catío                                | 
| ctp            | Western Highland Chatino                    | 
| cts            | Northern Catanduanes Bikol                  | 
| ctt            | Wayanad Chetti                              | 
| ctu            | Chol                                        | 
| ctz            | Zacatepec Chatino                           | 
| cua            | Cua                                         | 
| cub            | Cubeo                                       | 
| cuc            | Usila Chinantec                             | 
| cuh            | Gichuka                                     | 
| cui            | Cuiba                                       | 
| cuj            | Mashco Piro                                 | 
| cuk            | San Blas Kuna                               | 
| cul            | Kulina                                      | 
| cuo            | Cumanagoto                                  | 
| cup            | Cupeño                                      | 
| cuq            | Cun                                         | 
| cur            | Chhulung                                    | 
| cut            | Teutila Cuicatec                            | 
| cuu            | Tai Ya                                      | 
| cuv            | Cuvok                                       | 
| cuw            | Chukwa                                      | 
| cux            | Tepeuxila Cuicatec                          | 
| cuy            | Cuitlatec                                   | 
| cvg            | Chug                                        | 
| cvn            | Valle Nacional Chinantec                    | 
| cwa            | Kabwa                                       | 
| cwb            | Maindo                                      | 
| cwd            | Woods Cree                                  | 
| cwe            | Kwere                                       | 
| cwg            | Chewong                                     | 
| cwt            | Kuwaataay                                   | 
| cya            | Nopala Chatino                              | 
| cyb            | Cayubaba                                    | 
| cym            | Welsh                                       | 
| cyo            | Cuyonon                                     | 
| czh            | Huizhou Chinese                             | 
| czn            | Zenzontepec Chatino                         | 
| czo            | Min Zhong Chinese                           | 
| czt            | Zotung Chin                                 | 
| daa            | Dangaléat                                   | 
| dac            | Dambi                                       | 
| dad            | Marik                                       | 
| dae            | Duupa                                       | 
| dag            | Dagbani                                     | 
| dah            | Gwahatike                                   | 
| dai            | Day                                         | 
| daj            | Dar Fur Daju                                | 
| dak            | Dakota                                      | 
| dal            | Dahalo                                      | 
| dam            | Damakawa                                    | 
| dan            | Danish                                      | 
| dao            | Daai Chin                                   | 
| daq            | Dandami Maria                               | 
| dar            | Dargwa                                      | 
| das            | Daho-Doo                                    | 
| dau            | Dar Sila Daju                               | 
| dav            | Taita                                       | 
| daw            | Davawenyo                                   | 
| dax            | Dayi                                        | 
| daz            | Dao                                         | 
| dba            | Bangime                                     | 
| dbb            | Deno                                        | 
| dbd            | Dadiya                                      | 
| dbe            | Dabe                                        | 
| dbf            | Edopi                                       | 
| dbg            | Dogul Dom Dogon                             | 
| dbi            | Doka                                        | 
| dbj            | Ida'an                                      | 
| dbl            | Dyirbal                                     | 
| dbm            | Duguri                                      | 
| dbn            | Duriankere                                  | 
| dbo            | Dulbu                                       | 
| dbp            | Duwai                                       | 
| dbq            | Daba                                        | 
| dbr            | Dabarre                                     | 
| dbt            | Ben Tey Dogon                               | 
| dbu            | Bondum Dom Dogon                            | 
| dbw            | Bankan Tey Dogon                            | 
| dby            | Dibiyaso                                    | 
| dcc            | Deccan                                      | 
| dcr            | Negerhollands                               | 
| ddd            | Dongotono                                   | 
| dde            | Doondo                                      | 
| ddg            | Fataluku                                    | 
| ddi            | West Goodenough                             | 
| ddj            | Jaru                                        | 
| ddn            | Dendi (Benin)                               | 
| ddo            | Dido                                        | 
| ddr            | Dhudhuroa                                   | 
| dds            | Donno So Dogon                              | 
| ddw            | Dawera-Daweloor                             | 
| dec            | Dagik                                       | 
| ded            | Dedua                                       | 
| dee            | Dewoin                                      | 
| def            | Dezfuli                                     | 
| deg            | Degema                                      | 
| deh            | Dehwari                                     | 
| dei            | Demisa                                      | 
| dem            | Dem                                         | 
| deq            | Dendi (Central African Republic)            | 
| der            | Deori                                       | 
| des            | Desano                                      | 
| deu            | German                                      | 
| dev            | Domung                                      | 
| dez            | Dengese                                     | 
| dga            | Southern Dagaare                            | 
| dgb            | Bunoge Dogon                                | 
| dgc            | Casiguran Dumagat Agta                      | 
| dgd            | Dagaari Dioula                              | 
| dge            | Degenan                                     | 
| dgg            | Doga                                        | 
| dgh            | Dghwede                                     | 
| dgi            | Northern Dagara                             | 
| dgk            | Dagba                                       | 
| dgl            | Dongolawi                                   | 
| dgn            | Dagoman                                     | 
| dgo            | Dogri                                       | 
| dgr            | Tłı̨chǫ                                    | 
| dgs            | Dogoso                                      | 
| dgw            | Daungwurrung                                | 
| dgx            | Doghoro                                     | 
| dgz            | Daga                                        | 
| dhd            | Dhundari                                    | 
| dhg            | Djangu                                      | 
| dhi            | Dhimal                                      | 
| dhl            | Dhalandji                                   | 
| dhm            | Zemba                                       | 
| dhn            | Dhanki                                      | 
| dho            | Dhodia                                      | 
| dhr            | Dhargari                                    | 
| dhs            | Dhaiso                                      | 
| dhu            | Dhurga                                      | 
| dhv            | Drehu                                       | 
| dhw            | Dhanwar (Nepal)                             | 
| dia            | Dia                                         | 
| dib            | South Central Dinka                         | 
| dic            | Lakota Dida                                 | 
| did            | Didinga                                     | 
| dif            | Diyari                                      | 
| dig            | Digo                                        | 
| dih            | Kumiai                                      | 
| dii            | Dimbong                                     | 
| dij            | Dai                                         | 
| dik            | Southwestern Dinka                          | 
| dil            | Dilling                                     | 
| dim            | Dime                                        | 
| dio            | Dibo                                        | 
| dip            | Northeastern Dinka                          | 
| diq            | Dimli                                       | 
| dir            | Dirim                                       | 
| dis            | Dimasa                                      | 
| diu            | Diriku                                      | 
| div            | Maldivian                                   | 
| diw            | Northwestern Dinka                          | 
| dix            | Dixon Reef                                  | 
| diy            | Diuwe                                       | 
| diz            | Ding                                        | 
| djb            | Djinba                                      | 
| djc            | Dar Daju Daju                               | 
| djd            | Ngaliwurru                                  | 
| dje            | Zarma                                       | 
| djf            | Djangun                                     | 
| dji            | Djinang                                     | 
| djj            | Djeebbana                                   | 
| djk            | Nenge                                       | 
| djm            | Jamsay Dogon                                | 
| djn            | Jawoyn                                      | 
| djo            | Jangkang                                    | 
| djr            | Djambarrpuyngu                              | 
| dju            | Kapriman                                    | 
| djw            | Djawi                                       | 
| dka            | Dakpakha                                    | 
| dkk            | Dakka                                       | 
| dkr            | Kuijau                                      | 
| dks            | Southeastern Dinka                          | 
| dkx            | Mazagway                                    | 
| dlg            | Dolgan                                      | 
| dlk            | Dahalik                                     | 
| dlm            | Dalmatian                                   | 
| dln            | Darlong                                     | 
| dma            | Duma                                        | 
| dmb            | Mombo Dogon                                 | 
| dmc            | Gavak                                       | 
| dmd            | Madhi Madhi                                 | 
| dme            | Dugwor                                      | 
| dmg            | Upper Kinabatangan                          | 
| dmk            | Domaaki                                     | 
| dml            | Dameli                                      | 
| dmm            | Dama                                        | 
| dmo            | Kemedzung                                   | 
| dmr            | East Damar                                  | 
| dms            | Dampelas                                    | 
| dmu            | Tebi                                        | 
| dmv            | Dumpas                                      | 
| dmx            | Dema                                        | 
| dmy            | Sowari                                      | 
| dna            | Upper Grand Valley Dani                     | 
| dnd            | Daonda                                      | 
| dne            | Ndendeule                                   | 
| dng            | Dungan                                      | 
| dni            | Lower Grand Valley Dani                     | 
| dnj            | Dan                                         | 
| dnk            | Dengka                                      | 
| dnn            | Dzùùngoo                                    | 
| dno            | Northern Lendu                              | 
| dnr            | Danaru                                      | 
| dnt            | Mid Grand Valley Dani                       | 
| dnu            | Danau                                       | 
| dnw            | Western Dani                                | 
| dny            | Dení                                        | 
| doa            | Dom                                         | 
| dob            | Dobu                                        | 
| doc            | Northern Dong                               | 
| doe            | Doe                                         | 
| dof            | Domu                                        | 
| doh            | Dong                                        | 
| dok            | Dondo                                       | 
| dol            | Doso                                        | 
| don            | Toura (Papua New Guinea)                    | 
| doo            | Dongo                                       | 
| dop            | Lukpa                                       | 
| dor            | Dori'o                                      | 
| dos            | Dogosé                                      | 
| dot            | Dass                                        | 
| dov            | Dombe                                       | 
| dow            | Doyayo                                      | 
| dox            | Bussa                                       | 
| doy            | Dompo                                       | 
| doz            | Dorze                                       | 
| dpp            | Papar                                       | 
| drb            | Dair                                        | 
| drc            | Minderico                                   | 
| drd            | Darmiya                                     | 
| dre            | Dolpo                                       | 
| drg            | Rungus                                      | 
| dri            | C'Lela                                      | 
| drl            | Paakantyi                                   | 
| drn            | West Damar                                  | 
| dro            | Daro-Matu Melanau                           | 
| drq            | Dura                                        | 
| drs            | Gedeo                                       | 
| drt            | Drents                                      | 
| dru            | Rukai                                       | 
| dry            | Darai                                       | 
| dsb            | Lower Sorbian                               | 
| dsh            | Daasanach                                   | 
| dsi            | Disa                                        | 
| dsn            | Dusner                                      | 
| dsq            | Tadaksahak                                  | 
| dta            | Daur                                        | 
| dtb            | Labuk-Kinabatangan Kadazan                  | 
| dtd            | Ditidaht                                    | 
| dth            | Adithinngithigh                             | 
| dti            | Ana Tinga Dogon                             | 
| dtk            | Tene Kan Dogon                              | 
| dtm            | Tomo Kan Dogon                              | 
| dtn            | Daatsʼíin                                  | 
| dto            | Tommo So Dogon                              | 
| dtp            | Kadazan Dusun                               | 
| dtr            | Lotud                                       | 
| dts            | Toro So Dogon                               | 
| dtt            | Toro Tegu Dogon                             | 
| dtu            | Tebul Ure Dogon                             | 
| dty            | Dotyali                                     | 
| dua            | Duala                                       | 
| dub            | Dubli                                       | 
| duc            | Duna                                        | 
| due            | Umiray Dumaget Agta                         | 
| duf            | Dumbea                                      | 
| dug            | Duruma                                      | 
| duh            | Dungra Bhil                                 | 
| dui            | Dumun                                       | 
| duk            | Uyajitaya                                   | 
| dul            | Alabat Island Agta                          | 
| dum            | Middle Dutch (ca. 1050-1350)                | 
| dun            | Dusun Deyah                                 | 
| duo            | Dupaninan Agta                              | 
| dup            | Duano                                       | 
| duq            | Dusun Malang                                | 
| dur            | Dii                                         | 
| dus            | Dumi                                        | 
| duu            | Drung                                       | 
| duv            | Duvle                                       | 
| duw            | Dusun Witu                                  | 
| dux            | Duungooma                                   | 
| duy            | Dicamay Agta                                | 
| duz            | Duli-Gey                                    | 
| dva            | Duau                                        | 
| dwa            | Diri                                        | 
| dwr            | Dawro                                       | 
| dww            | Dawawa                                      | 
| dwz            | Dewas Rai                                   | 
| dya            | Dyan                                        | 
| dyb            | Dyaberdyaber                                | 
| dyd            | Dyugun                                      | 
| dyi            | Djimini Senoufo                             | 
| dym            | Yanda Dom Dogon                             | 
| dyn            | Dyangadi                                    | 
| dyo            | Jola-Fonyi                                  | 
| dyu            | Dyula                                       | 
| dyy            | Dyaabugay                                   | 
| dza            | Tunzu                                       | 
| dze            | Djiwarli                                    | 
| dzg            | Dazaga                                      | 
| dzl            | Dzalakha                                    | 
| dzn            | Dzando                                      | 
| dzo            | Dzongkha                                    | 
| ebg            | Ebughu                                      | 
| ebo            | Teke-Ebo                                    | 
| ebr            | Ebrié                                       | 
| ebu            | Kiembu                                      | 
| eee            | E                                           | 
| efa            | Efai                                        | 
| efe            | Efe                                         | 
| efi            | Efik                                        | 
| ega            | Ega                                         | 
| egl            | Emilian                                     | 
| ego            | Eggon                                       | 
| egy            | Egyptian (Ancient)                          | 
| ehu            | Ehueun                                      | 
| eip            | Eipomek                                     | 
| eit            | Eitiep                                      | 
| eiv            | Askopan                                     | 
| eja            | Ejamat                                      | 
| eka            | Ekajuk                                      | 
| eke            | Ekit                                        | 
| ekg            | Ekari                                       | 
| eki            | Eki                                         | 
| ekk            | Estonian                                    | 
| ekl            | Kol (Bangladesh)                            | 
| ekm            | Elip                                        | 
| eko            | Koti                                        | 
| ekp            | Ekpeye                                      | 
| ekr            | Yace                                        | 
| eky            | Eastern Kayah                               | 
| ele            | Elepi                                       | 
| elh            | El Hugeirat                                 | 
| eli            | Nding                                       | 
| elk            | Elkei                                       | 
| ell            | Greek                                       | 
| elm            | Eleme                                       | 
| elo            | El Molo                                     | 
| elu            | Elu                                         | 
| elx            | Elamite                                     | 
| ema            | Emai-Iuleha-Ora                             | 
| emb            | Embaloh                                     | 
| eme            | Emerillon                                   | 
| emg            | Eastern Meohang                             | 
| emi            | Mussau-Emira                                | 
| emk            | Eastern Maninkakan                          | 
| emn            | Eman                                        | 
| emp            | Northern Emberá                             | 
| emq            | Eastern Minyag                              | 
| ems            | Pacific Gulf Yupik                          | 
| emu            | Eastern Muria                               | 
| emw            | Emplawas                                    | 
| emy            | Epigraphic Mayan                            | 
| emz            | Mbessa                                      | 
| ena            | Apali                                       | 
| enb            | Markweeta                                   | 
| enc            | En                                          | 
| end            | Ende                                        | 
| enf            | Forest Enets                                | 
| eng            | English                                     | 
| enh            | Tundra Enets                                | 
| enl            | Enlhet                                      | 
| enm            | Middle English (1100-1500)                  | 
| enn            | Engenni                                     | 
| eno            | Enggano                                     | 
| enq            | Enga                                        | 
| enr            | Emumu                                       | 
| enu            | Enu                                         | 
| env            | Enwan (Edu State)                           | 
| enw            | Enwan (Akwa Ibom State)                     | 
| enx            | Enxet                                       | 
| eot            | Beti (Côte d'Ivoire)                        | 
| epi            | Epie                                        | 
| era            | Eravallan                                   | 
| erg            | Sie                                         | 
| erh            | Eruwa                                       | 
| eri            | Ogea                                        | 
| erk            | South Efate                                 | 
| ero            | Horpa                                       | 
| err            | Erre                                        | 
| ers            | Ersu                                        | 
| ert            | Eritai                                      | 
| erw            | Erokwanas                                   | 
| ese            | Ese Ejja                                    | 
| esh            | Eshtehardi                                  | 
| esi            | North Alaskan Inupiatun                     | 
| esk            | Northwest Alaska Inupiatun                  | 
| esq            | Esselen                                     | 
| ess            | Central Siberian Yupik                      | 
| esu            | Central Yupik                               | 
| etb            | Etebi                                       | 
| etn            | Eton (Vanuatu)                              | 
| eto            | Eton (Cameroon)                             | 
| etr            | Edolo                                       | 
| ets            | Yekhee                                      | 
| ett            | Etruscan                                    | 
| etu            | Ejagham                                     | 
| etx            | Eten                                        | 
| etz            | Semimi                                      | 
| eus            | Basque                                      | 
| eve            | Even                                        | 
| evh            | Uvbie                                       | 
| evn            | Evenki                                      | 
| ewe            | Ewe                                         | 
| ewo            | Ewondo                                      | 
| ext            | Extremaduran                                | 
| eya            | Eyak                                        | 
| eyo            | Keiyo                                       | 
| eze            | Uzekwe                                      | 
| faa            | Fasu                                        | 
| fab            | Fa d'Ambu                                   | 
| fad            | Wagi                                        | 
| faf            | Fagani                                      | 
| fag            | Finongan                                    | 
| fah            | Baissa Fali                                 | 
| fai            | Faiwol                                      | 
| faj            | Faita                                       | 
| fak            | Fang (Cameroon)                             | 
| fal            | South Fali                                  | 
| fam            | Fam                                         | 
| fan            | Fang (Equatorial Guinea)                    | 
| fao            | Faroese                                     | 
| fap            | Paloor                                      | 
| far            | Fataleka                                    | 
| fau            | Fayu                                        | 
| fax            | Fala                                        | 
| fay            | Southwestern Fars                           | 
| fer            | Feroge                                      | 
| ffm            | Maasina Fulfulde                            | 
| fgr            | Fongoro                                     | 
| fia            | Nobiin                                      | 
| fie            | Fyer                                        | 
| fif            | Faifi                                       | 
| fij            | Fijian                                      | 
| fil            | Pilipino                                    | 
| fin            | Finnish                                     | 
| fip            | Fipa                                        | 
| fir            | Firan                                       | 
| fit            | Tornedalen Finnish                          | 
| fiw            | Fiwaga                                      | 
| fkk            | Kirya-Konzəl                                | 
| fkv            | Kven Finnish                                | 
| fla            | Kalispel-Pend d'Oreille                     | 
| flh            | Foau                                        | 
| fli            | Fali                                        | 
| fll            | North Fali                                  | 
| fln            | Flinders Island                             | 
| flr            | Fuliiru                                     | 
| fmp            | Fe'fe'                                      | 
| fmu            | Far Western Muria                           | 
| fnb            | Fanbak                                      | 
| fni            | Fania                                       | 
| fod            | Foodo                                       | 
| foi            | Foi                                         | 
| fon            | Fon                                         | 
| for            | Fore                                        | 
| fos            | Siraya                                      | 
| fpe            | Fernando Po Creole English                  | 
| fqs            | Fas                                         | 
| fra            | French                                      | 
| frc            | Cajun French                                | 
| frd            | Fordata                                     | 
| frk            | Frankish                                    | 
| fro            | Old French (842-ca. 1400)                   | 
| frp            | Francoprovençal                             | 
| frq            | Forak                                       | 
| frr            | Northern Frisian                            | 
| frs            | Eastern Frisian                             | 
| frt            | Fortsenal                                   | 
| fry            | Western Frisian                             | 
| fss            | suomenruotsalainen viittomakieli            | 
| fub            | Adamawa Fulfulde                            | 
| fuc            | Pulaar                                      | 
| fud            | East Futuna                                 | 
| fue            | Borgu Fulfulde                              | 
| fuf            | Pular                                       | 
| fuh            | Western Niger Fulfulde                      | 
| fui            | Bagirmi Fulfulde                            | 
| fuj            | Ko                                          | 
| fun            | Fulniô                                      | 
| fuq            | Central-Eastern Niger Fulfulde              | 
| fur            | Friulian                                    | 
| fut            | Futuna-Aniwa                                | 
| fuu            | Furu                                        | 
| fuv            | Nigerian Fulfulde                           | 
| fuy            | Fuyug                                       | 
| fvr            | Fur                                         | 
| fwa            | Fwâi                                        | 
| fwe            | Fwe                                         | 
| gaa            | Ga                                          | 
| gab            | Gabri                                       | 
| gac            | Mixed Great Andamanese                      | 
| gad            | Gaddang                                     | 
| gae            | Guarequena                                  | 
| gaf            | Gende                                       | 
| gag            | Gagauz                                      | 
| gah            | Alekano                                     | 
| gai            | Borei                                       | 
| gaj            | Gadsup                                      | 
| gak            | Gamkonora                                   | 
| gal            | Galolen                                     | 
| gam            | Kandawo                                     | 
| gan            | Gan Chinese                                 | 
| gao            | Gants                                       | 
| gap            | Gal                                         | 
| gaq            | Gata'                                       | 
| gar            | Galeya                                      | 
| gas            | Adiwasi Garasia                             | 
| gat            | Kenati                                      | 
| gau            | Mudhili Gadaba                              | 
| gaw            | Nobonob                                     | 
| gax            | Borana-Arsi-Guji Oromo                      | 
| gay            | Gayo                                        | 
| gaz            | Oromo                                       | 
| gbb            | Kaytetye                                    | 
| gbd            | Karajarri                                   | 
| gbe            | Niksek                                      | 
| gbf            | Gaikundi                                    | 
| gbg            | Gbanziri                                    | 
| gbh            | Defi Gbe                                    | 
| gbi            | Galela                                      | 
| gbj            | Bodo Gadaba                                 | 
| gbk            | Gaddi                                       | 
| gbl            | Gamit                                       | 
| gbm            | Garhwali                                    | 
| gbn            | Mo'da                                       | 
| gbo            | Northern Grebo                              | 
| gbp            | Gbaya-Bossangoa                             | 
| gbq            | Gbaya-Bozoum                                | 
| gbr            | Gbagyi                                      | 
| gbs            | Gbesi Gbe                                   | 
| gbu            | Gagadu                                      | 
| gbv            | Gbanu                                       | 
| gbw            | Gabi-Gabi                                   | 
| gbx            | Eastern Xwla Gbe                            | 
| gby            | Gbari                                       | 
| gbz            | Zoroastrian Dari                            | 
| gcc            | Mali                                        | 
| gcd            | Ganggalida                                  | 
| gce            | Galice                                      | 
| gcf            | Guadeloupean Creole French                  | 
| gcl            | Grenadian Creole English                    | 
| gcn            | Gaina                                       | 
| gcr            | Guianese Creole French                      | 
| gct            | Colonia Tovar German                        | 
| gda            | Gade Lohar                                  | 
| gdb            | Pottangi Ollar Gadaba                       | 
| gdc            | Gugu Badhun                                 | 
| gdd            | Gedaged                                     | 
| gde            | Gude                                        | 
| gdf            | Guduf-Gava                                  | 
| gdg            | Ga'dang                                     | 
| gdh            | Gajirrabeng                                 | 
| gdi            | Gundi                                       | 
| gdj            | Gurdjar                                     | 
| gdk            | Gadang                                      | 
| gdl            | Dirasha                                     | 
| gdm            | Laal                                        | 
| gdn            | Umanakaina                                  | 
| gdo            | Ghodoberi                                   | 
| gdq            | Mehri                                       | 
| gdr            | Wipi                                        | 
| gdu            | Gudu                                        | 
| gdx            | Godwari                                     | 
| gea            | Geruma                                      | 
| geb            | Kire                                        | 
| gec            | Gboloo Grebo                                | 
| ged            | Gade                                        | 
| geh            | Hutterite German                            | 
| gei            | Gebe                                        | 
| gej            | Gen                                         | 
| gek            | Ywom                                        | 
| gel            | ut-Ma'in                                    | 
| geq            | Geme                                        | 
| ges            | Geser-Gorom                                 | 
| gev            | Eviya                                       | 
| gew            | Gera                                        | 
| gex            | Garre                                       | 
| gey            | Enya                                        | 
| gez            | Geez                                        | 
| gfk            | Patpatar                                    | 
| gft            | Gafat                                       | 
| gga            | Gao                                         | 
| ggb            | Gbii                                        | 
| ggd            | Gugadj                                      | 
| gge            | Gurr-goni                                   | 
| ggg            | Gurgula                                     | 
| ggk            | Kungarakany                                 | 
| ggl            | Ganglau                                     | 
| ggt            | Gitua                                       | 
| ggu            | Gban                                        | 
| ggw            | Gogodala                                    | 
| gha            | Ghadamès                                    | 
| ghc            | Hiberno-Scottish Gaelic                     | 
| ghe            | Southern Ghale                              | 
| ghh            | Northern Ghale                              | 
| ghk            | Geko Karen                                  | 
| ghl            | Ghulfan                                     | 
| ghn            | Ghanongga                                   | 
| gho            | Ghomara                                     | 
| ghr            | Ghera                                       | 
| ghs            | Guhu-Samane                                 | 
| ght            | Kutang Ghale                                | 
| gia            | Kija                                        | 
| gid            | Gidar                                       | 
| gie            | Guébie                                      | 
| gig            | Goaria                                      | 
| gih            | Githabul                                    | 
| gii            | Girirra                                     | 
| gil            | Gilbertese                                  | 
| gim            | Gimi (Eastern Highlands)                    | 
| gin            | Hinukh                                      | 
| gip            | Gimi (West New Britain)                     | 
| giq            | Green Gelao                                 | 
| gir            | Red Gelao                                   | 
| gis            | North Giziga                                | 
| git            | Gitxsan                                     | 
| giu            | Mulao                                       | 
| giw            | White Gelao                                 | 
| gix            | Gilima                                      | 
| giz            | South Giziga                                | 
| gjk            | Kachi Koli                                  | 
| gjm            | Gunditjmara                                 | 
| gjn            | Gonja                                       | 
| gju            | Gujari                                      | 
| gka            | Guya                                        | 
| gkd            | Magɨ (Madang Province)                      | 
| gke            | Ndai                                        | 
| gkn            | Gokana                                      | 
| gko            | Kok-Nar                                     | 
| gkp            | Guinea Kpelle                               | 
| gku            | ǂUngkue                                     | 
| gla            | Scottish Gaelic                             | 
| glb            | Belning                                     | 
| glc            | Bon Gula                                    | 
| gld            | Nanai                                       | 
| gle            | Irish                                       | 
| glg            | Galician                                    | 
| glh            | Northwest Pashayi                           | 
| glj            | Gula Iro                                    | 
| glk            | Gilaki                                      | 
| gll            | Garlali                                     | 
| glo            | Galambu                                     | 
| glr            | Glaro-Twabo                                 | 
| glu            | Gula (Chad)                                 | 
| glv            | Manx                                        | 
| glw            | Glavda                                      | 
| gly            | Gule                                        | 
| gma            | Gambera                                     | 
| gmb            | Gula'alaa                                   | 
| gmd            | Mághdì                                      | 
| gmg            | Magɨyi                                      | 
| gmh            | Middle High German (ca. 1050-1500)          | 
| gml            | Middle Low German                           | 
| gmm            | Gbaya-Mbodomo                               | 
| gmn            | Gimnime                                     | 
| gmu            | Gumalu                                      | 
| gmv            | Gamo                                        | 
| gmx            | Magoma                                      | 
| gmy            | Mycenaean Greek                             | 
| gna            | Kaansa                                      | 
| gnb            | Gangte                                      | 
| gnc            | Guanche                                     | 
| gnd            | Zulgo-Gemzek                                | 
| gne            | Ganang                                      | 
| gng            | Ngangam                                     | 
| gnh            | Lere                                        | 
| gni            | Gooniyandi                                  | 
| gnj            | Ngen                                        | 
| gnk            | ǁGana                                       | 
| gnl            | Gangulu                                     | 
| gnm            | Ginuman                                     | 
| gnn            | Gumatj                                      | 
| gno            | Northern Gondi                              | 
| gnq            | Gana                                        | 
| gnr            | Gureng Gureng                               | 
| gnt            | Guntai                                      | 
| gnu            | Gnau                                        | 
| gnw            | Western Bolivian Guaraní                    | 
| gnz            | Ganzi                                       | 
| goa            | Guro                                        | 
| gob            | Playero                                     | 
| goc            | Gorakor                                     | 
| god            | Godié                                       | 
| goe            | Gongduk                                     | 
| gof            | Gofa                                        | 
| gog            | Gogo                                        | 
| goh            | Old High German (ca. 750-1050)              | 
| goi            | Gobasi                                      | 
| gol            | Gola                                        | 
| gom            | Goan Konkani                                | 
| goo            | Gone Dau                                    | 
| gop            | Yeretuar                                    | 
| goq            | Gorap                                       | 
| gor            | Gorontalo                                   | 
| gos            | Gronings                                    | 
| got            | Gothic                                      | 
| gou            | Gavar                                       | 
| gow            | Gorowa                                      | 
| gox            | Gobu                                        | 
| goy            | Goundo                                      | 
| goz            | Gozarkhani                                  | 
| gpa            | Gupa-Abawa                                  | 
| gpe            | Ghanaian Pidgin English                     | 
| gpn            | Taiap                                       | 
| gqa            | Ga'anda                                     | 
| gqi            | Guiqiong                                    | 
| gqn            | Guana (Brazil)                              | 
| gqr            | Gor                                         | 
| gqu            | Qau                                         | 
| gra            | Rajput Garasia                              | 
| grc            | Ancient Greek                               | 
| grd            | Guruntum-Mbaaru                             | 
| grg            | Madi                                        | 
| grh            | Gbiri-Niragu                                | 
| gri            | Ghari                                       | 
| grj            | Southern Grebo                              | 
| grm            | Kota Marudu Talantang                       | 
| gro            | Groma                                       | 
| grq            | Gorovu                                      | 
| grr            | Taznatit                                    | 
| grs            | Gresi                                       | 
| grt            | Garo                                        | 
| gru            | Kistane                                     | 
| grv            | Central Grebo                               | 
| grw            | Gweda                                       | 
| grx            | Guriaso                                     | 
| gry            | Barclayville Grebo                          | 
| grz            | Guramalum                                   | 
| gsl            | Gusilay                                     | 
| gsn            | Nema                                        | 
| gso            | Southwest Gbaya                             | 
| gsp            | Wasembo                                     | 
| gsw            | Swiss German                                | 
| gta            | Guató                                       | 
| gua            | Shiki                                       | 
| gub            | Guajajára                                   | 
| guc            | Wayuu                                       | 
| gud            | Yocoboué Dida                               | 
| gue            | Gurindji                                    | 
| guf            | Gupapuyngu                                  | 
| gug            | Paraguayan Guaraní                          | 
| guh            | Guahibo                                     | 
| gui            | Eastern Bolivian Guaraní                    | 
| guj            | Gujarati                                    | 
| guk            | Gumuz                                       | 
| gul            | Sea Island Creole English                   | 
| gum            | Guambiano                                   | 
| gun            | Mbyá Guaraní                                | 
| guo            | Guayabero                                   | 
| gup            | Gunwinggu                                   | 
| guq            | Aché                                        | 
| gur            | Farefare                                    | 
| gut            | Maléku Jaíka                                | 
| guu            | Yanomamö                                    | 
| guw            | Gun                                         | 
| gux            | Gourmanchéma                                | 
| guz            | Gusii                                       | 
| gva            | Guana (Paraguay)                            | 
| gvc            | Guanano                                     | 
| gve            | Duwet                                       | 
| gvf            | Golin                                       | 
| gvj            | Guajá                                       | 
| gvl            | Gulay                                       | 
| gvm            | Gurmana                                     | 
| gvn            | Kuku-Yalanji                                | 
| gvo            | Gavião Do Jiparaná                          | 
| gvp            | Pará Gavião                                 | 
| gvr            | Gurung                                      | 
| gvs            | Gumawana                                    | 
| gvy            | Guyani                                      | 
| gwa            | Mbato                                       | 
| gwb            | Gwa                                         | 
| gwc            | Kalami                                      | 
| gwd            | Gawwada                                     | 
| gwe            | Gweno                                       | 
| gwf            | Gowro                                       | 
| gwg            | Moo                                         | 
| gwi            | Gwichʼin                                    | 
| gwj            | ǀGwi                                        | 
| gwm            | Awngthim                                    | 
| gwn            | Gwandara                                    | 
| gwr            | Gwere                                       | 
| gwt            | Gawar-Bati                                  | 
| gwu            | Guwamu                                      | 
| gww            | Kwini                                       | 
| gwx            | Gua                                         | 
| gxx            | Wè Southern                                 | 
| gya            | Northwest Gbaya                             | 
| gyb            | Garus                                       | 
| gyd            | Kayardild                                   | 
| gye            | Gyem                                        | 
| gyf            | Gungabula                                   | 
| gyg            | Gbayi                                       | 
| gyi            | Gyele                                       | 
| gyl            | Gayil                                       | 
| gym            | Ngäbere                                     | 
| gyn            | Guyanese Creole English                     | 
| gyo            | Gyalsumdo                                   | 
| gyr            | Guarayu                                     | 
| gyy            | Gunya                                       | 
| gyz            | Gyaazi                                      | 
| gza            | Ganza                                       | 
| gzi            | Gazi                                        | 
| gzn            | Gane                                        | 
| haa            | Han                                         | 
| hac            | Gurani                                      | 
| had            | Hatam                                       | 
| hae            | Eastern Oromo                               | 
| hag            | Hanga                                       | 
| hah            | Hahon                                       | 
| haj            | Hajong                                      | 
| hak            | Hakka Chinese                               | 
| hal            | Halang                                      | 
| ham            | Hewa                                        | 
| han            | Hangaza                                     | 
| hao            | Hakö                                        | 
| hap            | Hupla                                       | 
| haq            | Ha                                          | 
| har            | Harari                                      | 
| has            | Haisla                                      | 
| hat            | Haitian Creole                              | 
| hau            | Hausa                                       | 
| hav            | Havu                                        | 
| haw            | Hawaiian                                    | 
| hax            | Southern Haida                              | 
| hay            | Haya                                        | 
| haz            | Hazaragi                                    | 
| hba            | Hamba                                       | 
| hbb            | Huba                                        | 
| hbn            | Heiban                                      | 
| hbo            | Ancient Hebrew                              | 
| hbs            | Serbo-Croatian                              | 
| hbu            | Habu                                        | 
| hca            | Andaman Creole Hindi                        | 
| hch            | Huichol                                     | 
| hdn            | Northern Haida                              | 
| hdy            | Hadiyya                                     | 
| hea            | Northern Qiandong Miao                      | 
| heb            | Hebrew                                      | 
| hed            | Herdé                                       | 
| heg            | Helong                                      | 
| heh            | Hehe                                        | 
| hei            | Heiltsuk                                    | 
| hem            | Hemba                                       | 
| her            | Herero                                      | 
| hgm            | Haiǁom                                      | 
| hgw            | Haigwai                                     | 
| hhi            | Hoia Hoia                                   | 
| hhr            | Kerak                                       | 
| hhy            | Hoyahoya                                    | 
| hia            | Lamang                                      | 
| hib            | Hibito                                      | 
| hid            | Hidatsa                                     | 
| hif            | Fiji Hindi                                  | 
| hig            | Kamwe                                       | 
| hih            | Pamosu                                      | 
| hii            | Hinduri                                     | 
| hij            | Hijuk                                       | 
| hik            | Seit-Kaitetu                                | 
| hil            | Hiligaynon                                  | 
| hin            | Hindi                                       | 
| hio            | Tsoa                                        | 
| hit            | Hittite                                     | 
| hiw            | Hiw                                         | 
| hix            | Hixkaryána                                  | 
| hji            | Haji                                        | 
| hka            | Kahe                                        | 
| hke            | Hunde                                       | 
| hkh            | Poguli                                      | 
| hkk            | Hunjara-Kaina Ke                            | 
| hla            | Halia                                       | 
| hlb            | Halbi                                       | 
| hld            | Halang Doan                                 | 
| hle            | Hlersu                                      | 
| hlt            | Matu Chin                                   | 
| hlu            | Hieroglyphic Luwian                         | 
| hma            | Southern Mashan Miao                        | 
| hmb            | Humburi Senni Songhay                       | 
| hmc            | Central Huishui Miao                        | 
| hmd            | Large Flowery Miao                          | 
| hme            | Eastern Huishui Miao                        | 
| hmf            | Hmong Don                                   | 
| hmg            | Southwestern Guiyang Hmong                  | 
| hmh            | Southwestern Huishui Miao                   | 
| hmi            | Northern Huishui Miao                       | 
| hmj            | Gejia                                       | 
| hml            | Luopohe Miao                                | 
| hmm            | Central Mashan Miao                         | 
| hmp            | Northern Mashan Miao                        | 
| hmq            | Eastern Qiandong Miao                       | 
| hmr            | Hmar                                        | 
| hms            | Southern Qiandong Miao                      | 
| hmt            | Hamtai                                      | 
| hmu            | Hamap                                       | 
| hmv            | Hmong Dô                                    | 
| hmw            | Western Mashan Miao                         | 
| hmy            | Southern Guiyang Miao                       | 
| hmz            | Sinicized Miao                              | 
| hna            | Mina (Cameroon)                             | 
| hnd            | Southern Hindko                             | 
| hne            | Chhattisgarhi                               | 
| hng            | Hungu                                       | 
| hnh            | ǁAni                                        | 
| hni            | Hani                                        | 
| hnj            | Mong Njua                                   | 
| hnn            | Hanunoo                                     | 
| hno            | Northern Hindko                             | 
| hns            | Caribbean Hindustani                        | 
| hnu            | Hung                                        | 
| hoa            | Hoava                                       | 
| hob            | Mari (Madang Province)                      | 
| hoc            | Ho                                          | 
| hod            | Holma                                       | 
| hoe            | Horom                                       | 
| hoh            | Hobyót                                      | 
| hoi            | Holikachuk                                  | 
| hoj            | Haroti                                      | 
| hol            | Holu                                        | 
| hom            | Homa                                        | 
| hoo            | Holoholo                                    | 
| hop            | Hopi                                        | 
| hor            | Horo                                        | 
| hot            | Malê                                        | 
| hov            | Hovongan                                    | 
| how            | Honi                                        | 
| hoy            | Holiya                                      | 
| hoz            | Hozo                                        | 
| hpo            | Hpon                                        | 
| hra            | Hrangkhol                                   | 
| hrc            | Niwer Mil                                   | 
| hre            | Hre                                         | 
| hrk            | Haruku                                      | 
| hrm            | Horned Miao                                 | 
| hro            | Haroi                                       | 
| hrp            | Nhirrpi                                     | 
| hrt            | Hértevin                                    | 
| hru            | Hruso                                       | 
| hrv            | Croatian                                    | 
| hrx            | Hunsrik                                     | 
| hrz            | Harzani                                     | 
| hsb            | Upper Sorbian                               | 
| hsn            | Xiang Chinese                               | 
| hss            | Harsusi                                     | 
| hti            | Hoti                                        | 
| hto            | Minica Huitoto                              | 
| hts            | Hadza                                       | 
| htu            | Hitu                                        | 
| hub            | Huambisa                                    | 
| huc            | ǂHua                                        | 
| hud            | Huaulu                                      | 
| hue            | San Francisco Del Mar Huave                 | 
| huf            | Humene                                      | 
| hug            | Huachipaeri                                 | 
| huh            | Huilliche                                   | 
| hui            | Huli                                        | 
| huj            | Northern Guiyang Miao                       | 
| huk            | Hulung                                      | 
| hul            | Hula                                        | 
| hum            | Hungana                                     | 
| hun            | Hungarian                                   | 
| huo            | Hu                                          | 
| hup            | Hupa                                        | 
| huq            | Tsat                                        | 
| hur            | Halkomelem                                  | 
| hus            | Huastec                                     | 
| hut            | Humla                                       | 
| huu            | Murui Huitoto                               | 
| huv            | San Mateo Del Mar Huave                     | 
| huw            | Hukumina                                    | 
| hux            | Nüpode Huitoto                              | 
| huy            | Hulaulá                                     | 
| huz            | Hunzib                                      | 
| hve            | San Dionisio Del Mar Huave                  | 
| hvk            | Haveke                                      | 
| hvn            | Sabu                                        | 
| hvv            | Santa María Del Mar Huave                   | 
| hwa            | Wané                                        | 
| hwc            | Hawai'i Pidgin                              | 
| hwo            | Hwana                                       | 
| hya            | Hya                                         | 
| hye            | Armenian                                    | 
| hyw            | Western Armenian                            | 
| iai            | Iaai                                        | 
| ian            | Iatmul                                      | 
| iar            | Purari                                      | 
| iba            | Iban                                        | 
| ibb            | Ibibio                                      | 
| ibd            | Iwaidja                                     | 
| ibe            | Akpes                                       | 
| ibg            | Ibanag                                      | 
| ibh            | Bih                                         | 
| ibl            | Ibaloi                                      | 
| ibm            | Agoi                                        | 
| ibn            | Ibino                                       | 
| ibo            | Igbo                                        | 
| ibr            | Ibuoro                                      | 
| ibu            | Ibu                                         | 
| iby            | Ibani                                       | 
| ica            | Ede Ica                                     | 
| ich            | Etkywan                                     | 
| icr            | Islander Creole English                     | 
| ida            | Luidakho-Luisukha-Lutirichi                 | 
| idb            | Indo-Portuguese                             | 
| idc            | Idon                                        | 
| idd            | Ede Idaca                                   | 
| ide            | Idere                                       | 
| idi            | Idi                                         | 
| idr            | Indri                                       | 
| idt            | Idaté                                       | 
| idu            | Idoma                                       | 
| ifa            | Amganad Ifugao                              | 
| ifb            | Batad Ifugao                                | 
| ife            | Ifè                                         | 
| iff            | Ifo                                         | 
| ifk            | Tuwali Ifugao                               | 
| ifm            | Teke-Fuumu                                  | 
| ifu            | Mayoyao Ifugao                              | 
| ify            | Keley-I Kallahan                            | 
| igb            | Ebira                                       | 
| ige            | Igede                                       | 
| igg            | Igana                                       | 
| igl            | Igala                                       | 
| igm            | Kanggape                                    | 
| ign            | Ignaciano                                   | 
| igo            | Isebe                                       | 
| igw            | Igwe                                        | 
| ihp            | Iha                                         | 
| ihw            | Bidhawal                                    | 
| iii            | Sichuan Yi                                  | 
| iin            | Thiin                                       | 
| ijc            | Izon                                        | 
| ije            | Biseni                                      | 
| ijj            | Ede Ije                                     | 
| ijn            | Kalabari                                    | 
| ijs            | Southeast Ijo                               | 
| ike            | Eastern Canadian Inuktitut                  | 
| iki            | Iko                                         | 
| ikk            | Ika                                         | 
| ikl            | Ikulu                                       | 
| iko            | Olulumo-Ikom                                | 
| ikp            | Ikpeshi                                     | 
| ikr            | Ikaranggal                                  | 
| ikt            | Western Canadian Inuktitut                  | 
| ikv            | Iku-Gora-Ankwa                              | 
| ikw            | Ikwere                                      | 
| ikx            | Ik                                          | 
| ikz            | Ikizu                                       | 
| ila            | Ile Ape                                     | 
| ilb            | Ila                                         | 
| ilg            | Garig-Ilgar                                 | 
| ili            | Ili Turki                                   | 
| ilk            | Ilongot                                     | 
| ilo            | Iloko                                       | 
| ilu            | Ili'uun                                     | 
| ilv            | Ilue                                        | 
| ima            | Mala Malasar                                | 
| imi            | Anamgura                                    | 
| iml            | Miluk                                       | 
| imn            | Imonda                                      | 
| imo            | Imbongu                                     | 
| imr            | Imroing                                     | 
| imy            | Milyan                                      | 
| inb            | Inga                                        | 
| ind            | Indonesian                                  | 
| ing            | Degexit'an                                  | 
| inh            | Ingush                                      | 
| inj            | Jungle Inga                                 | 
| inm            | Minaean                                     | 
| inn            | Isinai                                      | 
| ino            | Inoke-Yate                                  | 
| inp            | Iñapari                                     | 
| int            | Intha                                       | 
| inz            | Ineseño                                     | 
| ior            | Inor                                        | 
| iou            | Tuma-Irumu                                  | 
| iow            | Iowa-Oto                                    | 
| ipi            | Ipili                                       | 
| ipo            | Ipiko                                       | 
| iqu            | Iquito                                      | 
| ire            | Iresim                                      | 
| irh            | Irarutu                                     | 
| iri            | Rigwe                                       | 
| irk            | Iraqw                                       | 
| irn            | Irántxe                                     | 
| iru            | Irula                                       | 
| irx            | Kamberau                                    | 
| iry            | Iraya                                       | 
| isa            | Isabi                                       | 
| isc            | Isconahua                                   | 
| isd            | Isnag                                       | 
| ish            | Esan                                        | 
| isi            | Nkem-Nkum                                   | 
| isk            | Ishkashimi                                  | 
| isl            | Icelandic                                   | 
| ism            | Masimasi                                    | 
| isn            | Isanzu                                      | 
| iso            | Isoko                                       | 
| ist            | Istriot                                     | 
| isu            | Isu (Menchum Division)                      | 
| ita            | Italian                                     | 
| itb            | Binongan Itneg                              | 
| itd            | Southern Tidung                             | 
| ite            | Itene                                       | 
| iti            | Inlaod Itneg                                | 
| itk            | Judeo-Italian                               | 
| itl            | Itelmen                                     | 
| itm            | Itu Mbon Uzo                                | 
| ito            | Itonama                                     | 
| itr            | Iteri                                       | 
| its            | Isekiri                                     | 
| itt            | Maeng Itneg                                 | 
| itv            | Itawit                                      | 
| itw            | Ito                                         | 
| itx            | Itik                                        | 
| ity            | Moyadan Itneg                               | 
| itz            | Itzá                                        | 
| ium            | Iu Mien                                     | 
| ivb            | Ibatan                                      | 
| ivv            | Ivatan                                      | 
| iwk            | I-Wak                                       | 
| iwm            | Iwam                                        | 
| iwo            | Iwur                                        | 
| iws            | Sepik Iwam                                  | 
| ixc            | Ixcatec                                     | 
| ixl            | Ixil                                        | 
| iya            | Iyayu                                       | 
| iyo            | Mesaka                                      | 
| iyx            | Yaka (Congo)                                | 
| izh            | Ingrian                                     | 
| izr            | Izere                                       | 
| izz            | Izii                                        | 
| jaa            | Jamamadí                                    | 
| jab            | Hyam                                        | 
| jac            | Popti'                                      | 
| jad            | Jahanka                                     | 
| jae            | Yabem                                       | 
| jaf            | Jara                                        | 
| jah            | Jah Hut                                     | 
| jaj            | Zazao                                       | 
| jak            | Jakun                                       | 
| jal            | Yalahatan                                   | 
| jam            | Jamaican Creole English                     | 
| jan            | Jandai                                      | 
| jao            | Yanyuwa                                     | 
| jaq            | Yaqay                                       | 
| jas            | New Caledonian Javanese                     | 
| jat            | Jakati                                      | 
| jau            | Yaur                                        | 
| jav            | Javanese                                    | 
| jax            | Jambi Malay                                 | 
| jay            | Yan-nhangu                                  | 
| jaz            | Jawe                                        | 
| jbi            | Badjiri                                     | 
| jbj            | Arandai                                     | 
| jbk            | Barikewa                                    | 
| jbn            | Nafusi                                      | 
| jbr            | Jofotek-Bromnya                             | 
| jbt            | Jabutí                                      | 
| jbu            | Jukun Takum                                 | 
| jbw            | Yawijibaya                                  | 
| jct            | Krymchak                                    | 
| jda            | Jad                                         | 
| jdg            | Jadgali                                     | 
| jdt            | Judeo-Tat                                   | 
| jeb            | Jebero                                      | 
| jee            | Jerung                                      | 
| jeh            | Jeh                                         | 
| jei            | Yei                                         | 
| jek            | Jeri Kuo                                    | 
| jel            | Yelmek                                      | 
| jen            | Dza                                         | 
| jer            | Jere                                        | 
| jet            | Manem                                       | 
| jeu            | Jonkor Bourmataguil                         | 
| jgb            | Ngbee                                       | 
| jge            | Judeo-Georgian                              | 
| jgo            | Ngomba                                      | 
| jhi            | Jehai                                       | 
| jia            | Jina                                        | 
| jib            | Jibu                                        | 
| jic            | Tol                                         | 
| jid            | Bu (Kaduna State)                           | 
| jie            | Jilbe                                       | 
| jig            | Jingulu                                     | 
| jih            | sTodsde                                     | 
| jii            | Jiiddu                                      | 
| jil            | Jilim                                       | 
| jim            | Jimi (Cameroon)                             | 
| jio            | Jiamao                                      | 
| jiq            | Lavrung                                     | 
| jit            | Jita                                        | 
| jiu            | Youle Jinuo                                 | 
| jiv            | Shuar                                       | 
| jiy            | Buyuan Jinuo                                | 
| jje            | Jejueo                                      | 
| jka            | Kaera                                       | 
| jkm            | Mobwa Karen                                 | 
| jko            | Kubo                                        | 
| jkr            | Koro (India)                                | 
| jku            | Labir                                       | 
| jle            | Ngile                                       | 
| jma            | Dima                                        | 
| jmb            | Zumbun                                      | 
| jmc            | Machame                                     | 
| jmd            | Yamdena                                     | 
| jmi            | Jimi (Nigeria)                              | 
| jml            | Jumli                                       | 
| jmn            | Makuri Naga                                 | 
| jmr            | Kamara                                      | 
| jms            | Mashi (Nigeria)                             | 
| jmw            | Mouwase                                     | 
| jmx            | Western Juxtlahuaca Mixtec                  | 
| jna            | Jangshung                                   | 
| jnd            | Jandavra                                    | 
| jng            | Yangman                                     | 
| jni            | Janji                                       | 
| jnj            | Yemsa                                       | 
| jnl            | Rawat                                       | 
| jns            | Jaunsari                                    | 
| job            | Joba                                        | 
| jod            | Wojenaka                                    | 
| jor            | Jorá                                        | 
| jow            | Jowulu                                      | 
| jpn            | Japanese                                    | 
| jpr            | Judeo-Persian                               | 
| jqr            | Jaqaru                                      | 
| jra            | Jarai                                       | 
| jrr            | Jiru                                        | 
| jru            | Japrería                                    | 
| jua            | Júma                                        | 
| jub            | Wannu                                       | 
| juc            | Jurchen                                     | 
| jud            | Worodougou                                  | 
| juh            | Hõne                                        | 
| jui            | Ngadjuri                                    | 
| juk            | Wapan                                       | 
| jul            | Jirel                                       | 
| jum            | Jumjum                                      | 
| jun            | Juang                                       | 
| juo            | Jiba                                        | 
| jup            | Hupdë                                       | 
| jur            | Jurúna                                      | 
| jut            | Jutish                                      | 
| juu            | Ju                                          | 
| juw            | Wãpha                                       | 
| juy            | Juray                                       | 
| jvd            | Javindo                                     | 
| jvn            | Caribbean Javanese                          | 
| jwi            | Jwira-Pepesa                                | 
| jya            | Jiarong                                     | 
| jye            | Judeo-Yemeni Arabic                         | 
| jyy            | Jaya                                        | 
| kaa            | Kara-Kalpak                                 | 
| kab            | Kabyle                                      | 
| kac            | Kachin                                      | 
| kad            | Adara                                       | 
| kae            | Ketangalan                                  | 
| kaf            | Katso                                       | 
| kag            | Kajaman                                     | 
| kah            | Kara (Central African Republic)             | 
| kai            | Karekare                                    | 
| kaj            | Jju                                         | 
| kak            | Kayapa Kallahan                             | 
| kal            | Greenlandic                                 | 
| kam            | Kamba (Kenya)                               | 
| kan            | Kannada                                     | 
| kao            | Xaasongaxango                               | 
| kap            | Bezhta                                      | 
| kaq            | Capanahua                                   | 
| kas            | Kashmiri                                    | 
| kat            | Georgian                                    | 
| kaw            | Kawi                                        | 
| kax            | Kao                                         | 
| kay            | Kamayurá                                    | 
| kaz            | Kazakh                                      | 
| kba            | Kalarko                                     | 
| kbb            | Kaxuiâna                                    | 
| kbc            | Kadiwéu                                     | 
| kbd            | Kabardian                                   | 
| kbe            | Kanju                                       | 
| kbg            | Khamba                                      | 
| kbh            | Camsá                                       | 
| kbi            | Kaptiau                                     | 
| kbj            | Kari                                        | 
| kbk            | Grass Koiari                                | 
| kbl            | Kanembu                                     | 
| kbm            | Iwal                                        | 
| kbn            | Kare (Central African Republic)             | 
| kbo            | Keliko                                      | 
| kbp            | Kabiyè                                      | 
| kbq            | Kamano                                      | 
| kbr            | Kafa                                        | 
| kbs            | Kande                                       | 
| kbt            | Abadi                                       | 
| kbu            | Kabutra                                     | 
| kbv            | Dera (Indonesia)                            | 
| kbw            | Kaiep                                       | 
| kbx            | Ap Ma                                       | 
| kby            | Manga Kanuri                                | 
| kbz            | Duhwa                                       | 
| kca            | Khanty                                      | 
| kcb            | Kawacha                                     | 
| kcc            | Lubila                                      | 
| kcd            | Ngkâlmpw Kanum                              | 
| kcf            | Ukaan                                       | 
| kcg            | Tyap                                        | 
| kci            | Kamantan                                    | 
| kcj            | Kobiana                                     | 
| kck            | Kalanga                                     | 
| kcl            | Kela (Papua New Guinea)                     | 
| kcm            | Gula (Central African Republic)             | 
| kcn            | Nubi                                        | 
| kco            | Kinalakna                                   | 
| kcp            | Kanga                                       | 
| kcq            | Kamo                                        | 
| kcr            | Katla                                       | 
| kcs            | Koenoem                                     | 
| kct            | Kaian                                       | 
| kcu            | Kami (Tanzania)                             | 
| kcv            | Kete                                        | 
| kcw            | Kabwari                                     | 
| kcx            | Kachama-Ganjule                             | 
| kcy            | Korandje                                    | 
| kcz            | Konongo                                     | 
| kda            | Worimi                                      | 
| kdc            | Kutu                                        | 
| kdd            | Yankunytjatjara                             | 
| kde            | Makonde                                     | 
| kdf            | Mamusi                                      | 
| kdg            | Seba                                        | 
| kdh            | Tem                                         | 
| kdi            | Kumam                                       | 
| kdj            | Karamojong                                  | 
| kdk            | Numèè                                       | 
| kdl            | Tsikimba                                    | 
| kdm            | Kagoma                                      | 
| kdn            | Kunda                                       | 
| kdp            | Kaningdon-Nindem                            | 
| kdq            | Koch                                        | 
| kdr            | Karaim                                      | 
| kdt            | Kuy                                         | 
| kdu            | Kadaru                                      | 
| kdw            | Koneraw                                     | 
| kdx            | Kam                                         | 
| kdy            | Keijar                                      | 
| kdz            | Kwaja                                       | 
| kea            | Kabuverdianu                                | 
| keb            | Kélé                                        | 
| kec            | Keiga                                       | 
| ked            | Kerewe                                      | 
| kee            | Eastern Keres                               | 
| kef            | Kpessi                                      | 
| keg            | Tese                                        | 
| keh            | Keak                                        | 
| kei            | Kei                                         | 
| kej            | Kadar                                       | 
| kek            | Kekchí                                      | 
| kel            | Kela (Democratic Republic of Congo)         | 
| kem            | Kemak                                       | 
| ken            | Kenyang                                     | 
| keo            | Kakwa                                       | 
| kep            | Kaikadi                                     | 
| keq            | Kamar                                       | 
| ker            | Kera                                        | 
| kes            | Kugbo                                       | 
| ket            | Ket                                         | 
| keu            | Akebu                                       | 
| kev            | Kanikkaran                                  | 
| kew            | West Kewa                                   | 
| key            | Kupia                                       | 
| kez            | Kukele                                      | 
| kfa            | Kodava                                      | 
| kfb            | Northwestern Kolami                         | 
| kfc            | Konda-Dora                                  | 
| kfd            | Korra Koraga                                | 
| kfe            | Kota (India)                                | 
| kff            | Koya                                        | 
| kfg            | Kudiya                                      | 
| kfh            | Kurichiya                                   | 
| kfk            | Kinnauri                                    | 
| kfl            | Kung                                        | 
| kfm            | Khunsari                                    | 
| kfn            | Kuk                                         | 
| kfo            | Koro (Côte d'Ivoire)                        | 
| kfp            | Korwa                                       | 
| kfq            | Korku                                       | 
| kfr            | Kutchi                                      | 
| kfs            | Bilaspuri                                   | 
| kft            | Kanjari                                     | 
| kfu            | Katkari                                     | 
| kfv            | Kurmukar                                    | 
| kfw            | Kharam Naga                                 | 
| kfx            | Kullu Pahari                                | 
| kfy            | Kumaoni                                     | 
| kfz            | Koromfé                                     | 
| kga            | Koyaga                                      | 
| kgb            | Kawe                                        | 
| kge            | Komering                                    | 
| kgf            | Kube                                        | 
| kgg            | Kusunda                                     | 
| kgj            | Gamale Kham                                 | 
| kgk            | Kaiwá                                       | 
| kgl            | Kunggari                                    | 
| kgn            | Karingani                                   | 
| kgo            | Krongo                                      | 
| kgp            | Kaingang                                    | 
| kgq            | Kamoro                                      | 
| kgr            | Abun                                        | 
| kgs            | Kumbainggar                                 | 
| kgt            | Somyev                                      | 
| kgu            | Kobol                                       | 
| kgv            | Karas                                       | 
| kgw            | Karon Dori                                  | 
| kgx            | Kamaru                                      | 
| kgy            | Kyerung                                     | 
| kha            | Khasi                                       | 
| khb            | Lü                                          | 
| khc            | Tukang Besi North                           | 
| khd            | Bädi Kanum                                  | 
| khe            | Korowai                                     | 
| khf            | Khuen                                       | 
| khg            | Khams Tibetan                               | 
| khh            | Kehu                                        | 
| khj            | Kuturmi                                     | 
| khk            | Halh Mongolian                              | 
| khl            | Lusi                                        | 
| khm            | Khmer                                       | 
| khn            | Khandesi                                    | 
| kho            | Sakan                                       | 
| khp            | Kapori                                      | 
| khq            | Koyra Chiini Songhay                        | 
| khr            | Kharia                                      | 
| khs            | Kasua                                       | 
| kht            | Khamti                                      | 
| khu            | Nkhumbi                                     | 
| khv            | Khvarshi                                    | 
| khw            | Khowar                                      | 
| khx            | Kanu                                        | 
| khy            | Kele (Democratic Republic of Congo)         | 
| khz            | Keapara                                     | 
| kia            | Kim                                         | 
| kib            | Koalib                                      | 
| kic            | Kickapoo                                    | 
| kid            | Koshin                                      | 
| kie            | Kibet                                       | 
| kif            | Eastern Parbate Kham                        | 
| kig            | Kimaghima                                   | 
| kih            | Kilmeri                                     | 
| kii            | Kitsai                                      | 
| kij            | Kilivila                                    | 
| kik            | Kikuyu                                      | 
| kil            | Kariya                                      | 
| kim            | Karagas                                     | 
| kin            | Kinyarwanda                                 | 
| kio            | Kiowa                                       | 
| kip            | Sheshi Kham                                 | 
| kiq            | Kosare                                      | 
| kir            | Kyrgyz                                      | 
| kis            | Kis                                         | 
| kit            | Agob                                        | 
| kiu            | Kirmanjki                                   | 
| kiv            | Kimbu                                       | 
| kiw            | Northeast Kiwai                             | 
| kix            | Khiamniungan Naga                           | 
| kiy            | Kirikiri                                    | 
| kiz            | Kisi                                        | 
| kja            | Mlap                                        | 
| kjb            | Q'anjob'al                                  | 
| kjc            | Coastal Konjo                               | 
| kjd            | Southern Kiwai                              | 
| kje            | Kisar                                       | 
| kjg            | Khmu                                        | 
| kjh            | Khakas                                      | 
| kji            | Zabana                                      | 
| kjj            | Khinalugh                                   | 
| kjk            | Highland Konjo                              | 
| kjl            | Western Parbate Kham                        | 
| kjm            | Kháng                                       | 
| kjn            | Kunjen                                      | 
| kjo            | Harijan Kinnauri                            | 
| kjp            | Pwo Eastern Karen                           | 
| kjq            | Western Keres                               | 
| kjr            | Kurudu                                      | 
| kjs            | East Kewa                                   | 
| kjt            | Phrae Pwo Karen                             | 
| kju            | Kashaya                                     | 
| kjv            | Kaikavian Literary Language                 | 
| kjx            | Ramopa                                      | 
| kjy            | Erave                                       | 
| kjz            | Bumthangkha                                 | 
| kka            | Kakanda                                     | 
| kkb            | Kwerisa                                     | 
| kkc            | Odoodee                                     | 
| kkd            | Kinuku                                      | 
| kke            | Kakabe                                      | 
| kkf            | Kalaktang Monpa                             | 
| kkg            | Mabaka Valley Kalinga                       | 
| kkh            | Khün                                        | 
| kki            | Kagulu                                      | 
| kkj            | Kako                                        | 
| kkk            | Kokota                                      | 
| kkl            | Kosarek Yale                                | 
| kkm            | Kiong                                       | 
| kko            | Karko                                       | 
| kkp            | Koko-Bera                                   | 
| kkq            | Kaeku                                       | 
| kkr            | Kir-Balar                                   | 
| kks            | Giiwo                                       | 
| kkt            | Koi                                         | 
| kkv            | Kangean                                     | 
| kkw            | Teke-Kukuya                                 | 
| kkx            | Kohin                                       | 
| kky            | Guugu Yimidhirr                             | 
| kkz            | Kaska                                       | 
| kla            | Klamath-Modoc                               | 
| klb            | Kiliwa                                      | 
| klc            | Kolbila                                     | 
| kld            | Gamilaraay                                  | 
| kle            | Kulung (Nepal)                              | 
| klf            | Kendeje                                     | 
| klg            | Tagakaulo                                   | 
| klh            | Weliki                                      | 
| kli            | Kalumpang                                   | 
| klj            | Khalaj                                      | 
| klk            | Kono (Nigeria)                              | 
| kll            | Kagan Kalagan                               | 
| klm            | Migum                                       | 
| kln            | Kalenjin                                    | 
| klo            | Kapya                                       | 
| klp            | Kamasa                                      | 
| klq            | Rumu                                        | 
| klr            | Khaling                                     | 
| kls            | Kalasha                                     | 
| klt            | Nukna                                       | 
| klu            | Klao                                        | 
| klv            | Maskelynes                                  | 
| klw            | Tado                                        | 
| klx            | Koluwawa                                    | 
| kly            | Kalao                                       | 
| klz            | Kabola                                      | 
| kma            | Konni                                       | 
| kmb            | Kimbundu                                    | 
| kmc            | Southern Dong                               | 
| kmd            | Majukayang Kalinga                          | 
| kme            | Bakole                                      | 
| kmf            | Kare (Papua New Guinea)                     | 
| kmg            | Kâte                                        | 
| kmh            | Kalam                                       | 
| kmi            | Kami (Nigeria)                              | 
| kmj            | Kumarbhag Paharia                           | 
| kmk            | Limos Kalinga                               | 
| kml            | Tanudan Kalinga                             | 
| kmm            | Kom (India)                                 | 
| kmn            | Awtuw                                       | 
| kmo            | Kwoma                                       | 
| kmp            | Gimme                                       | 
| kmq            | Kwama                                       | 
| kmr            | Northern Kurdish                            | 
| kms            | Kamasau                                     | 
| kmt            | Kemtuik                                     | 
| kmu            | Kanite                                      | 
| kmv            | Karipúna Creole French                      | 
| kmw            | Komo (Democratic Republic of Congo)         | 
| kmx            | Waboda                                      | 
| kmy            | Koma                                        | 
| kmz            | Khorasani Turkish                           | 
| kna            | Dera (Nigeria)                              | 
| knb            | Lubuagan Kalinga                            | 
| knc            | Central Kanuri                              | 
| knd            | Konda                                       | 
| kne            | Kankanaey                                   | 
| knf            | Mankanya                                    | 
| kng            | Koongo                                      | 
| kni            | Kanufi                                      | 
| knj            | Western Kanjobal                            | 
| knk            | Kuranko                                     | 
| knl            | Keninjal                                    | 
| knm            | Kanamarí                                    | 
| knn            | Konkani                                     | 
| kno            | Kono (Sierra Leone)                         | 
| knp            | Kwanja                                      | 
| knq            | Kintaq                                      | 
| knr            | Kaningra                                    | 
| kns            | Kensiu                                      | 
| knt            | Panoan Katukína                             | 
| knu            | Kono (Guinea)                               | 
| knv            | Tabo                                        | 
| knw            | Kung-Ekoka                                  | 
| knx            | Salako                                      | 
| kny            | Kanyok                                      | 
| knz            | Kalamsé                                     | 
| koa            | Konomala                                    | 
| koc            | Kpati                                       | 
| kod            | Kodi                                        | 
| koe            | Kacipo-Bale Suri                            | 
| kof            | Kubi                                        | 
| kog            | Kogi                                        | 
| koh            | Koyo                                        | 
| koi            | Komi-Permyak                                | 
| kol            | Kol (Papua New Guinea)                      | 
| koo            | Konzo                                       | 
| kop            | Waube                                       | 
| koq            | Kota (Gabon)                                | 
| kor            | Korean                                      | 
| kos            | Kosraean                                    | 
| kot            | Lagwan                                      | 
| kou            | Koke                                        | 
| kov            | Kudu-Camo                                   | 
| kow            | Kugama                                      | 
| koy            | Koyukon                                     | 
| koz            | Korak                                       | 
| kpa            | Kutto                                       | 
| kpb            | Mullu Kurumba                               | 
| kpc            | Curripaco                                   | 
| kpd            | Koba                                        | 
| kpf            | Komba                                       | 
| kpg            | Kapingamarangi                              | 
| kph            | Kplang                                      | 
| kpi            | Kofei                                       | 
| kpj            | Karajá                                      | 
| kpk            | Kpan                                        | 
| kpl            | Kpala                                       | 
| kpm            | Koho                                        | 
| kpn            | Kepkiriwát                                  | 
| kpo            | Ikposo                                      | 
| kpq            | Korupun-Sela                                | 
| kpr            | Korafe-Yegha                                | 
| kps            | Tehit                                       | 
| kpt            | Karata                                      | 
| kpu            | Kafoa                                       | 
| kpv            | Komi-Zyrian                                 | 
| kpw            | Kobon                                       | 
| kpx            | Mountain Koiali                             | 
| kpy            | Koryak                                      | 
| kpz            | Kupsabiny                                   | 
| kqa            | Mum                                         | 
| kqb            | Kovai                                       | 
| kqc            | Doromu-Koki                                 | 
| kqd            | Koy Sanjaq Surat                            | 
| kqe            | Kalagan                                     | 
| kqf            | Kakabai                                     | 
| kqg            | Khe                                         | 
| kqi            | Koitabu                                     | 
| kqj            | Koromira                                    | 
| kqk            | Kotafon Gbe                                 | 
| kql            | Kyenele                                     | 
| kqm            | Khisa                                       | 
| kqn            | Kaonde                                      | 
| kqo            | Eastern Krahn                               | 
| kqp            | Kimré                                       | 
| kqq            | Krenak                                      | 
| kqr            | Kimaragang                                  | 
| kqs            | Northern Kissi                              | 
| kqt            | Klias River Kadazan                         | 
| kqu            | Seroa                                       | 
| kqv            | Okolod                                      | 
| kqw            | Kandas                                      | 
| kqx            | Mser                                        | 
| kqy            | Koorete                                     | 
| kqz            | Korana                                      | 
| kra            | Kumhali                                     | 
| krb            | Karkin                                      | 
| krc            | Karachay-Balkar                             | 
| krd            | Kairui-Midiki                               | 
| kre            | Panará                                      | 
| krf            | Koro (Vanuatu)                              | 
| krh            | Kurama                                      | 
| kri            | Krio                                        | 
| krj            | Kinaray-A                                   | 
| krk            | Kerek                                       | 
| krl            | Karelian                                    | 
| krn            | Sapo                                        | 
| krp            | Korop                                       | 
| krr            | Krung                                       | 
| krs            | Gbaya (Sudan)                               | 
| krt            | Tumari Kanuri                               | 
| kru            | Kurukh                                      | 
| krv            | Kavet                                       | 
| krw            | Western Krahn                               | 
| krx            | Karon                                       | 
| kry            | Kryts                                       | 
| krz            | Sota Kanum                                  | 
| ksb            | Shambala                                    | 
| ksc            | Southern Kalinga                            | 
| ksd            | Kuanua                                      | 
| kse            | Kuni                                        | 
| ksf            | Bafia                                       | 
| ksg            | Kusaghe                                     | 
| ksh            | Kölsch                                      | 
| ksi            | Krisa                                       | 
| ksj            | Uare                                        | 
| ksk            | Kansa                                       | 
| ksl            | Kumalu                                      | 
| ksm            | Kumba                                       | 
| ksn            | Kasiguranin                                 | 
| ksp            | Kaba                                        | 
| ksq            | Kwaami                                      | 
| ksr            | Borong                                      | 
| kss            | Southern Kisi                               | 
| kst            | Winyé                                       | 
| ksu            | Khamyang                                    | 
| ksv            | Kusu                                        | 
| ksw            | S'gaw Karen                                 | 
| ksx            | Kedang                                      | 
| ksy            | Kharia Thar                                 | 
| ksz            | Kodaku                                      | 
| kta            | Katua                                       | 
| ktb            | Kambaata                                    | 
| ktc            | Kholok                                      | 
| ktd            | Kukatha                                     | 
| kte            | Nubri                                       | 
| ktf            | Kwami                                       | 
| ktg            | Kalkutung                                   | 
| kth            | Karanga                                     | 
| kti            | North Muyu                                  | 
| ktj            | Plapo Krumen                                | 
| ktk            | Kaniet                                      | 
| ktl            | Koroshi                                     | 
| ktm            | Kurti                                       | 
| ktn            | Karitiâna                                   | 
| kto            | Kuot                                        | 
| ktp            | Kaduo                                       | 
| kts            | South Muyu                                  | 
| ktt            | Ketum                                       | 
| ktu            | Kituba (Democratic Republic of Congo)       | 
| ktv            | Eastern Katu                                | 
| ktw            | Kato                                        | 
| ktx            | Kaxararí                                    | 
| kty            | Kango (Bas-Uélé District)                   | 
| ktz            | Juǀʼhoansi                                  | 
| kua            | Kwanyama                                    | 
| kub            | Kutep                                       | 
| kuc            | Kwinsu                                      | 
| kud            | 'Auhelawa                                   | 
| kue            | Kuman (Papua New Guinea)                    | 
| kuf            | Western Katu                                | 
| kug            | Kupa                                        | 
| kuh            | Kushi                                       | 
| kui            | Kuikúro-Kalapálo                            | 
| kuj            | Kuria                                       | 
| kuk            | Kepo'                                       | 
| kul            | Kulere                                      | 
| kum            | Kumyk                                       | 
| kun            | Kunama                                      | 
| kuo            | Kumukio                                     | 
| kup            | Kunimaipa                                   | 
| kuq            | Karipuna                                    | 
| kus            | Kusaal                                      | 
| kut            | Kutenai                                     | 
| kuu            | Upper Kuskokwim                             | 
| kuv            | Kur                                         | 
| kuw            | Kpagua                                      | 
| kux            | Kukatja                                     | 
| kuy            | Kuuku-Ya'u                                  | 
| kuz            | Kunza                                       | 
| kva            | Bagvalal                                    | 
| kvb            | Kubu                                        | 
| kvc            | Kove                                        | 
| kvd            | Kui (Indonesia)                             | 
| kve            | Kalabakan                                   | 
| kvf            | Kabalai                                     | 
| kvg            | Kuni-Boazi                                  | 
| kvh            | Komodo                                      | 
| kvi            | Kwang                                       | 
| kvj            | Psikye                                      | 
| kvl            | Kayaw                                       | 
| kvm            | Kendem                                      | 
| kvn            | Border Kuna                                 | 
| kvo            | Dobel                                       | 
| kvp            | Kompane                                     | 
| kvq            | Geba Karen                                  | 
| kvr            | Kerinci                                     | 
| kvu            | Yinbaw Karen                                | 
| kvv            | Kola                                        | 
| kvw            | Wersing                                     | 
| kvx            | Parkari Koli                                | 
| kvy            | Yintale Karen                               | 
| kvz            | Tsaukambo                                   | 
| kwa            | Dâw                                         | 
| kwb            | Kwa                                         | 
| kwc            | Likwala                                     | 
| kwd            | Kwaio                                       | 
| kwe            | Kwerba                                      | 
| kwf            | Kwara'ae                                    | 
| kwg            | Sara Kaba Deme                              | 
| kwh            | Kowiai                                      | 
| kwi            | Awa-Cuaiquer                                | 
| kwj            | Kwanga                                      | 
| kwk            | Kwakiutl                                    | 
| kwl            | Kofyar                                      | 
| kwm            | Kwambi                                      | 
| kwn            | Kwangali                                    | 
| kwo            | Kwomtari                                    | 
| kwp            | Kodia                                       | 
| kwr            | Kwer                                        | 
| kws            | Kwese                                       | 
| kwt            | Kwesten                                     | 
| kwu            | Kwakum                                      | 
| kwv            | Sara Kaba Náà                               | 
| kww            | Kwinti                                      | 
| kwx            | Khirwar                                     | 
| kwy            | San Salvador Kongo                          | 
| kwz            | Kwadi                                       | 
| kxa            | Kairiru                                     | 
| kxb            | Krobu                                       | 
| kxc            | Konso                                       | 
| kxd            | Brunei                                      | 
| kxf            | Manumanaw Karen                             | 
| kxh            | Karo (Ethiopia)                             | 
| kxi            | Keningau Murut                              | 
| kxj            | Kulfa                                       | 
| kxk            | Zayein Karen                                | 
| kxm            | Northern Khmer                              | 
| kxn            | Kanowit-Tanjong Melanau                     | 
| kxo            | Kanoé                                       | 
| kxp            | Wadiyara Koli                               | 
| kxq            | Smärky Kanum                                | 
| kxr            | Koro (Papua New Guinea)                     | 
| kxs            | Kangjia                                     | 
| kxt            | Koiwat                                      | 
| kxv            | Kuvi                                        | 
| kxw            | Konai                                       | 
| kxx            | Likuba                                      | 
| kxy            | Kayong                                      | 
| kxz            | Kerewo                                      | 
| kya            | Kwaya                                       | 
| kyb            | Butbut Kalinga                              | 
| kyc            | Kyaka                                       | 
| kyd            | Karey                                       | 
| kye            | Krache                                      | 
| kyf            | Kouya                                       | 
| kyg            | Keyagana                                    | 
| kyh            | Karok                                       | 
| kyi            | Kiput                                       | 
| kyj            | Karao                                       | 
| kyk            | Kamayo                                      | 
| kyl            | Kalapuya                                    | 
| kyn            | Northern Binukidnon                         | 
| kyo            | Kelon                                       | 
| kyq            | Kenga                                       | 
| kyr            | Kuruáya                                     | 
| kys            | Baram Kayan                                 | 
| kyt            | Kayagar                                     | 
| kyu            | Western Kayah                               | 
| kyw            | Kudmali                                     | 
| kyx            | Rapoisi                                     | 
| kyy            | Kambaira                                    | 
| kyz            | Kayabí                                      | 
| kza            | Western Karaboro                            | 
| kzb            | Kaibobo                                     | 
| kzc            | Bondoukou Kulango                           | 
| kzd            | Kadai                                       | 
| kzf            | Da'a Kaili                                  | 
| kzg            | Kikai                                       | 
| kzi            | Kelabit                                     | 
| kzk            | Kazukuru                                    | 
| kzl            | Kayeli                                      | 
| kzm            | Kais                                        | 
| kzn            | Kokola                                      | 
| kzo            | Kaningi                                     | 
| kzp            | Kaidipang                                   | 
| kzq            | Kaike                                       | 
| kzr            | Karang                                      | 
| kzs            | Sugut Dusun                                 | 
| kzu            | Kayupulau                                   | 
| kzv            | Komyandaret                                 | 
| kzx            | Kamarian                                    | 
| kzy            | Kango (Tshopo District)                     | 
| kzz            | Kalabra                                     | 
| laa            | Southern Subanen                            | 
| lac            | Lacandon                                    | 
| lad            | Ladino                                      | 
| lae            | Pattani                                     | 
| laf            | Lafofa                                      | 
| lag            | Langi                                       | 
| lai            | Lambya                                      | 
| laj            | Lango (Uganda)                              | 
| lak            | Laka (Nigeria)                              | 
| lal            | Lalia                                       | 
| lam            | Lamba                                       | 
| lan            | Laru                                        | 
| lao            | Lao                                         | 
| lap            | Laka (Chad)                                 | 
| laq            | Qabiao                                      | 
| lar            | Larteh                                      | 
| las            | Lama (Togo)                                 | 
| lat            | Latin                                       | 
| lav            | Latvian Russian                             | 
| law            | Lauje                                       | 
| lax            | Tiwa                                        | 
| laz            | Aribwatsa                                   | 
| lbb            | Label                                       | 
| lbc            | Lakkia                                      | 
| lbe            | Lak                                         | 
| lbf            | Tinani                                      | 
| lbj            | Ladakhi                                     | 
| lbk            | Central Bontok                              | 
| lbl            | Libon Bikol                                 | 
| lbm            | Lodhi                                       | 
| lbn            | Rmeet                                       | 
| lbo            | Laven                                       | 
| lbq            | Wampar                                      | 
| lbr            | Lohorung                                    | 
| lbt            | Lachi                                       | 
| lbu            | Labu                                        | 
| lbv            | Lavatbura-Lamusong                          | 
| lbw            | Tolaki                                      | 
| lbx            | Lawangan                                    | 
| lby            | Lamu-Lamu                                   | 
| lbz            | Lardil                                      | 
| lcc            | Legenyem                                    | 
| lcd            | Lola                                        | 
| lce            | Sekak                                       | 
| lcf            | Lubu                                        | 
| lch            | Luchazi                                     | 
| lcl            | Lisela                                      | 
| lcm            | Tungag                                      | 
| lcp            | Western Lawa                                | 
| lcq            | Luhu                                        | 
| lcs            | Lisabata-Nuniali                            | 
| ldb            | Dũya                                       | 
| ldd            | Luri                                        | 
| ldg            | Lenyima                                     | 
| ldh            | Lamja-Dengsa-Tola                           | 
| ldi            | Laari                                       | 
| ldj            | Lemoro                                      | 
| ldk            | Leelau                                      | 
| ldl            | Kaan                                        | 
| ldm            | Landoma                                     | 
| ldo            | Loo                                         | 
| ldp            | Tso                                         | 
| ldq            | Lufu                                        | 
| lea            | Lega-Shabunda                               | 
| leb            | Lala-Bisa                                   | 
| lec            | Leco                                        | 
| led            | Lendu                                       | 
| lee            | Lyélé                                       | 
| lef            | Lelemi                                      | 
| leh            | Lenje                                       | 
| lei            | Lemio                                       | 
| lej            | Lengola                                     | 
| lek            | Leipon                                      | 
| lel            | Lele (Democratic Republic of Congo)         | 
| lem            | Nomaande                                    | 
| leo            | Leti (Cameroon)                             | 
| lep            | Lepcha                                      | 
| leq            | Lembena                                     | 
| ler            | Lenkau                                      | 
| les            | Lese                                        | 
| let            | Lesing-Gelimi                               | 
| leu            | Kara (Papua New Guinea)                     | 
| lev            | Lamma                                       | 
| lew            | Ledo Kaili                                  | 
| lex            | Luang                                       | 
| ley            | Lemolang                                    | 
| lez            | Lezghian                                    | 
| lfa            | Lefa                                        | 
| lga            | Lungga                                      | 
| lgb            | Laghu                                       | 
| lgg            | Lugbara                                     | 
| lgh            | Laghuu                                      | 
| lgi            | Lengilu                                     | 
| lgk            | Neverver                                    | 
| lgl            | Wala                                        | 
| lgm            | Lega-Mwenga                                 | 
| lgn            | T'apo                                       | 
| lgq            | Logba                                       | 
| lgr            | Lengo                                       | 
| lgt            | Pahi                                        | 
| lgu            | Longgu                                      | 
| lgz            | Ligenza                                     | 
| lha            | Laha (Viet Nam)                             | 
| lhh            | Laha (Indonesia)                            | 
| lhi            | Lahu Shi                                    | 
| lhl            | Lahul Lohar                                 | 
| lhm            | Lhomi                                       | 
| lhn            | Lahanan                                     | 
| lhp            | Lhokpu                                      | 
| lhs            | Mlahsö                                      | 
| lht            | Lo-Toga                                     | 
| lhu            | Lahu                                        | 
| lia            | West-Central Limba                          | 
| lib            | Likum                                       | 
| lic            | Hlai                                        | 
| lid            | Nyindrou                                    | 
| lie            | Likila                                      | 
| lif            | Limbu                                       | 
| lig            | Ligbi                                       | 
| lih            | Lihir                                       | 
| lij            | Ligurian                                    | 
| lik            | Lika                                        | 
| lil            | Lillooet                                    | 
| lim            | Limburgish                                  | 
| lin            | Lingala                                     | 
| lio            | Liki                                        | 
| lip            | Sekpele                                     | 
| liq            | Libido                                      | 
| lis            | Lisu                                        | 
| lit            | Lithuanian                                  | 
| liu            | Logorik                                     | 
| liv            | Liv                                         | 
| liw            | Col                                         | 
| lix            | Liabuku                                     | 
| liy            | Banda-Bambari                               | 
| liz            | Libinza                                     | 
| lja            | Golpa                                       | 
| lje            | Rampi                                       | 
| lji            | Laiyolo                                     | 
| ljl            | Li'o                                        | 
| ljp            | Lampung Api                                 | 
| ljw            | Yirandali                                   | 
| ljx            | Yuru                                        | 
| lka            | Lakalei                                     | 
| lkb            | Lukabaras                                   | 
| lkc            | Kucong                                      | 
| lkd            | Lakondê                                     | 
| lke            | Kenyi                                       | 
| lkh            | Lakha                                       | 
| lki            | Laki                                        | 
| lkj            | Remun                                       | 
| lkl            | Laeko-Libuat                                | 
| lkm            | Kalaamaya                                   | 
| lkn            | Vure                                        | 
| lko            | Olukhayo                                    | 
| lkr            | Päri                                        | 
| lks            | Olushisa                                    | 
| lkt            | Lakota                                      | 
| lku            | Kungkari                                    | 
| lky            | Lokoya                                      | 
| lla            | Lala-Roba                                   | 
| llb            | Lolo                                        | 
| llc            | Lele (Guinea)                               | 
| lld            | Ladin                                       | 
| lle            | Lele (Papua New Guinea)                     | 
| llf            | Hermit                                      | 
| llg            | Lole                                        | 
| llh            | Lamu                                        | 
| lli            | Teke-Laali                                  | 
| llk            | Lelak                                       | 
| lll            | Lilau                                       | 
| llm            | Lasalimu                                    | 
| lln            | Lele (Chad)                                 | 
| llp            | North Efate                                 | 
| llq            | Lolak                                       | 
| llu            | Lau                                         | 
| llx            | Lauan                                       | 
| lma            | East Limba                                  | 
| lmb            | Merei                                       | 
| lmc            | Limilngan                                   | 
| lmd            | Lumun                                       | 
| lme            | Pévé                                        | 
| lmf            | South Lembata                               | 
| lmg            | Lamogai                                     | 
| lmi            | Lombi                                       | 
| lmj            | West Lembata                                | 
| lmk            | Lamkang                                     | 
| lml            | Hano                                        | 
| lmn            | Lambadi                                     | 
| lmo            | Lombard                                     | 
| lmp            | Limbum                                      | 
| lmq            | Lamatuka                                    | 
| lmr            | Lamalera                                    | 
| lmu            | Lamenu                                      | 
| lmv            | Lomaiviti                                   | 
| lmw            | Lake Miwok                                  | 
| lmx            | Laimbue                                     | 
| lmy            | Lamboya                                     | 
| lna            | Langbashe                                   | 
| lnb            | Mbalanhu                                    | 
| lnd            | Lundayeh                                    | 
| lnh            | Lanoh                                       | 
| lni            | Daantanai'                                  | 
| lnj            | Leningitij                                  | 
| lnl            | South Central Banda                         | 
| lnm            | Langam                                      | 
| lnn            | Lorediakarkar                               | 
| lno            | Lango (South Sudan)                         | 
| lns            | Lamnso'                                     | 
| lnu            | Longuda                                     | 
| lnz            | Lonzo                                       | 
| loa            | Loloda                                      | 
| lob            | Lobi                                        | 
| loc            | Inonhan                                     | 
| loe            | Saluan                                      | 
| lof            | Logol                                       | 
| log            | Logo                                        | 
| loh            | Narim                                       | 
| loi            | Loma (Côte d'Ivoire)                        | 
| loj            | Lou                                         | 
| lok            | Loko                                        | 
| lol            | Mongo                                       | 
| lom            | Loma (Liberia)                              | 
| lon            | Malawi Lomwe                                | 
| loo            | Lombo                                       | 
| lop            | Lopa                                        | 
| loq            | Lobala                                      | 
| lor            | Téén                                        | 
| los            | Loniu                                       | 
| lot            | Otuho                                       | 
| lou            | Louisiana Creole                            | 
| low            | Tampias Lobu                                | 
| lox            | Loun                                        | 
| loy            | Loke                                        | 
| loz            | Lozi                                        | 
| lpa            | Lelepa                                      | 
| lpe            | Lepki                                       | 
| lpn            | Long Phuri Naga                             | 
| lpo            | Lipo                                        | 
| lpx            | Lopit                                       | 
| lra            | Rara Bakati'                                | 
| lrc            | Northern Luri                               | 
| lre            | Laurentian                                  | 
| lrg            | Laragia                                     | 
| lri            | Olumarachi                                  | 
| lrl            | Lari                                        | 
| lrm            | Olumarama                                   | 
| lrn            | Lorang                                      | 
| lro            | Laro                                        | 
| lrr            | Southern Yamphu                             | 
| lrt            | Larantuka Malay                             | 
| lrv            | Larevat                                     | 
| lrz            | Lemerig                                     | 
| lsa            | Lasgerdi                                    | 
| lsd            | Lishana Deni                                | 
| lse            | Lusengo                                     | 
| lsh            | Lish                                        | 
| lsi            | Lashi                                       | 
| lsm            | Saamia                                      | 
| lsr            | Aruop                                       | 
| lss            | Lasi                                        | 
| ltc            | Late Middle Chinese                         | 
| lth            | Thur                                        | 
| lti            | Leti (Indonesia)                            | 
| ltn            | Latundê                                     | 
| lto            | Tsotso                                      | 
| lts            | Tachoni                                     | 
| ltu            | Latu                                        | 
| ltz            | Luxembourgish                               | 
| lua            | Luba-Lulua                                  | 
| lub            | Luba-Katanga                                | 
| luc            | Aringa                                      | 
| lud            | Ludian                                      | 
| lue            | Luvale                                      | 
| luf            | Laua                                        | 
| lug            | Ganda                                       | 
| lui            | Luiseno                                     | 
| luj            | Luna                                        | 
| luk            | Lunanakha                                   | 
| lul            | Olu'bo                                      | 
| lum            | Luimbi                                      | 
| lun            | Lunda                                       | 
| luo            | Luo (Kenya and Tanzania)                    | 
| lup            | Lumbu                                       | 
| luq            | Lucumi                                      | 
| lur            | Laura                                       | 
| lus            | Lushai                                      | 
| lut            | Lushootseed                                 | 
| luv            | Luwati                                      | 
| luw            | Luo (Cameroon)                              | 
| luz            | Southern Luri                               | 
| lva            | Maku'a                                      | 
| lvi            | Lavi                                        | 
| lvk            | Lavukaleve                                  | 
| lvs            | Latvian                                     | 
| lvu            | Levuka                                      | 
| lwa            | Lwalu                                       | 
| lwe            | Lewo Eleng                                  | 
| lwg            | Wanga                                       | 
| lwh            | White Lachi                                 | 
| lwl            | Eastern Lawa                                | 
| lwm            | Laomian                                     | 
| lwo            | Luwo                                        | 
| lwt            | Lewotobi                                    | 
| lwu            | Lawu                                        | 
| lww            | Lewo                                        | 
| lxm            | Lakurumau                                   | 
| lya            | Layakha                                     | 
| lyg            | Lyngngam                                    | 
| lyn            | Luyana                                      | 
| lzh            | Literary Chinese                            | 
| lzl            | Litzlitz                                    | 
| lzn            | Leinong Naga                                | 
| lzz            | Laz                                         | 
| maa            | San Jerónimo Tecóatl Mazatec                | 
| mab            | Yutanduchi Mixtec                           | 
| mad            | Madurese                                    | 
| mae            | Bo-Rukul                                    | 
| maf            | Mafa                                        | 
| mag            | Magahi                                      | 
| mah            | Marshallese                                 | 
| mai            | Maithili                                    | 
| maj            | Jalapa De Díaz Mazatec                      | 
| mak            | Makasar                                     | 
| mal            | Malayalam                                   | 
| mam            | Mam                                         | 
| maq            | Chiquihuitlán Mazatec                       | 
| mar            | Marathi                                     | 
| mas            | Masai                                       | 
| mat            | San Francisco Matlatzinca                   | 
| mau            | Huautla Mazatec                             | 
| mav            | Sateré-Mawé                                 | 
| maw            | Mampruli                                    | 
| max            | North Moluccan Malay                        | 
| maz            | Central Mazahua                             | 
| mba            | Higaonon                                    | 
| mbb            | Western Bukidnon Manobo                     | 
| mbc            | Macushi                                     | 
| mbd            | Dibabawon Manobo                            | 
| mbe            | Molale                                      | 
| mbf            | Baba Malay                                  | 
| mbh            | Mangseng                                    | 
| mbi            | Ilianen Manobo                              | 
| mbj            | Nadëb                                       | 
| mbk            | Malol                                       | 
| mbl            | Maxakalí                                    | 
| mbm            | Ombamba                                     | 
| mbn            | Macaguán                                    | 
| mbo            | Mbo (Cameroon)                              | 
| mbp            | Malayo                                      | 
| mbq            | Maisin                                      | 
| mbr            | Nukak Makú                                  | 
| mbs            | Sarangani Manobo                            | 
| mbt            | Matigsalug Manobo                           | 
| mbu            | Mbula-Bwazza                                | 
| mbv            | Mbulungish                                  | 
| mbw            | Maring                                      | 
| mbx            | Mari (East Sepik Province)                  | 
| mby            | Memoni                                      | 
| mbz            | Amoltepec Mixtec                            | 
| mca            | Maca                                        | 
| mcb            | Machiguenga                                 | 
| mcc            | Bitur                                       | 
| mcd            | Sharanahua                                  | 
| mce            | Itundujia Mixtec                            | 
| mcf            | Matsés                                      | 
| mcg            | Mapoyo                                      | 
| mch            | Maquiritari                                 | 
| mci            | Mese                                        | 
| mcj            | Mvanip                                      | 
| mck            | Mbunda                                      | 
| mcl            | Macaguaje                                   | 
| mcm            | Malaccan Creole Portuguese                  | 
| mcn            | Masana                                      | 
| mco            | Coatlán Mixe                                | 
| mcp            | Makaa                                       | 
| mcq            | Ese                                         | 
| mcr            | Menya                                       | 
| mcs            | Mambai                                      | 
| mct            | Mengisa                                     | 
| mcu            | Cameroon Mambila                            | 
| mcv            | Minanibai                                   | 
| mcw            | Mawa (Chad)                                 | 
| mcx            | Mpiemo                                      | 
| mcy            | South Watut                                 | 
| mcz            | Mawan                                       | 
| mda            | Mada (Nigeria)                              | 
| mdb            | Morigi                                      | 
| mdc            | Male (Papua New Guinea)                     | 
| mdd            | Mbum                                        | 
| mde            | Maba (Chad)                                 | 
| mdf            | Moksha                                      | 
| mdg            | Massalat                                    | 
| mdh            | Maguindanaon                                | 
| mdi            | Mamvu                                       | 
| mdj            | Mangbetu                                    | 
| mdk            | Mangbutu                                    | 
| mdm            | Mayogo                                      | 
| mdn            | Mbati                                       | 
| mdp            | Mbala                                       | 
| mdq            | Mbole                                       | 
| mdr            | Mandar                                      | 
| mds            | Maria (Papua New Guinea)                    | 
| mdt            | Mbere                                       | 
| mdu            | Mboko                                       | 
| mdv            | Santa Lucía Monteverde Mixtec               | 
| mdw            | Mbosi                                       | 
| mdx            | Dizin                                       | 
| mdy            | Male (Ethiopia)                             | 
| mdz            | Suruí Do Pará                               | 
| mea            | Menka                                       | 
| meb            | Ikobi                                       | 
| mec            | Marra                                       | 
| med            | Melpa                                       | 
| mee            | Mengen                                      | 
| mef            | Megam                                       | 
| meh            | Southwestern Tlaxiaco Mixtec                | 
| mei            | Midob                                       | 
| mej            | Meyah                                       | 
| mek            | Mekeo                                       | 
| mel            | Central Melanau                             | 
| mem            | Mangala                                     | 
| men            | Mende (Sierra Leone)                        | 
| meo            | Kedah Malay                                 | 
| mep            | Miriwoong                                   | 
| meq            | Merey                                       | 
| mer            | Meru                                        | 
| mes            | Masmaje                                     | 
| met            | Mato                                        | 
| meu            | Motu                                        | 
| mev            | Mano                                        | 
| mew            | Maaka                                       | 
| mey            | Hassaniyya                                  | 
| mez            | Menominee                                   | 
| mfa            | Pattani Malay                               | 
| mfb            | Bangka                                      | 
| mfc            | Mba                                         | 
| mfd            | Mendankwe-Nkwen                             | 
| mfe            | Morisyen                                    | 
| mff            | Naki                                        | 
| mfg            | Mogofin                                     | 
| mfh            | Matal                                       | 
| mfi            | Wandala                                     | 
| mfj            | Mefele                                      | 
| mfk            | North Mofu                                  | 
| mfl            | Putai                                       | 
| mfm            | Marghi South                                | 
| mfn            | Cross River Mbembe                          | 
| mfo            | Mbe                                         | 
| mfp            | Makassar Malay                              | 
| mfq            | Moba                                        | 
| mfr            | Marrithiyel                                 | 
| mft            | Mokerang                                    | 
| mfu            | Mbwela                                      | 
| mfv            | Mandjak                                     | 
| mfw            | Mulaha                                      | 
| mfx            | Melo                                        | 
| mfy            | Mayo                                        | 
| mfz            | Mabaan                                      | 
| mgb            | Mararit                                     | 
| mgc            | Morokodo                                    | 
| mgd            | Moru                                        | 
| mge            | Mango                                       | 
| mgf            | Maklew                                      | 
| mgg            | Mpumpong                                    | 
| mgh            | Makhuwa-Meetto                              | 
| mgi            | Lijili                                      | 
| mgj            | Abureni                                     | 
| mgk            | Mawes                                       | 
| mgl            | Maleu-Kilenge                               | 
| mgm            | Mambae                                      | 
| mgn            | Mbangi                                      | 
| mgo            | Meta'                                       | 
| mgp            | Eastern Magar                               | 
| mgq            | Malila                                      | 
| mgr            | Mambwe-Lungu                                | 
| mgs            | Manda (Tanzania)                            | 
| mgt            | Mongol                                      | 
| mgu            | Mailu                                       | 
| mgv            | Matengo                                     | 
| mgw            | Matumbi                                     | 
| mgy            | Mbunga                                      | 
| mgz            | Mbugwe                                      | 
| mha            | Manda (India)                               | 
| mhb            | Mahongwe                                    | 
| mhc            | Mocho                                       | 
| mhd            | Mbugu                                       | 
| mhe            | Mah Meri                                    | 
| mhf            | Mamaa                                       | 
| mhg            | Margu                                       | 
| mhi            | Ma'di                                       | 
| mhj            | Mogholi                                     | 
| mhk            | Mungaka                                     | 
| mhl            | Mauwake                                     | 
| mhm            | Makhuwa-Moniga                              | 
| mhn            | Mócheno                                     | 
| mho            | Mashi (Zambia)                              | 
| mhp            | Balinese Malay                              | 
| mhq            | Mandan                                      | 
| mhr            | Eastern Mari                                | 
| mhs            | Buru (Indonesia)                            | 
| mht            | Mandahuaca                                  | 
| mhu            | Digaro-Mishmi                               | 
| mhw            | Mbukushu                                    | 
| mhx            | Maru                                        | 
| mhy            | Ma'anyan                                    | 
| mhz            | Mor (Mor Islands)                           | 
| mia            | Miami                                       | 
| mib            | Atatláhuca Mixtec                           | 
| mic            | Mi'kmaq                                     | 
| mid            | Mandaic                                     | 
| mie            | Ocotepec Mixtec                             | 
| mif            | Mofu-Gudur                                  | 
| mig            | San Miguel El Grande Mixtec                 | 
| mih            | Chayuco Mixtec                              | 
| mii            | Chigmecatitlán Mixtec                       | 
| mij            | Mungbam                                     | 
| mik            | Mikasuki                                    | 
| mil            | Peñoles Mixtec                              | 
| mim            | Alacatlatzala Mixtec                        | 
| min            | Minangkabau                                 | 
| mio            | Pinotepa Nacional Mixtec                    | 
| mip            | Apasco-Apoala Mixtec                        | 
| miq            | Mískito                                     | 
| mir            | Isthmus Mixe                                | 
| mit            | Southern Puebla Mixtec                      | 
| miu            | Cacaloxtepec Mixtec                         | 
| miw            | Akoye                                       | 
| mix            | Mixtepec Mixtec                             | 
| miy            | Ayutla Mixtec                               | 
| miz            | Coatzospan Mixtec                           | 
| mjc            | San Juan Colorado Mixtec                    | 
| mjd            | Northwest Maidu                             | 
| mje            | Muskum                                      | 
| mjg            | Tu                                          | 
| mjh            | Mwera (Nyasa)                               | 
| mji            | Kim Mun                                     | 
| mjj            | Mawak                                       | 
| mjk            | Matukar                                     | 
| mjl            | Mandeali                                    | 
| mjm            | Medebur                                     | 
| mjn            | Ma (Papua New Guinea)                       | 
| mjo            | Malankuravan                                | 
| mjp            | Malapandaram                                | 
| mjq            | Malaryan                                    | 
| mjr            | Malavedan                                   | 
| mjs            | Miship                                      | 
| mjt            | Sauria Paharia                              | 
| mju            | Manna-Dora                                  | 
| mjv            | Mannan                                      | 
| mjw            | Karbi                                       | 
| mjx            | Mahali                                      | 
| mjy            | Mahican                                     | 
| mjz            | Majhi                                       | 
| mka            | Mbre                                        | 
| mkb            | Mal Paharia                                 | 
| mkc            | Siliput                                     | 
| mkd            | Macedonian                                  | 
| mke            | Mawchi                                      | 
| mkf            | Miya                                        | 
| mkg            | Mak (China)                                 | 
| mki            | Dhatki                                      | 
| mkj            | Mokilese                                    | 
| mkk            | Byep                                        | 
| mkl            | Mokole                                      | 
| mkm            | Moklen                                      | 
| mkn            | Kupang Malay                                | 
| mko            | Mingang Doso                                | 
| mkp            | Moikodi                                     | 
| mkq            | Bay Miwok                                   | 
| mkr            | Malas                                       | 
| mks            | Silacayoapan Mixtec                         | 
| mkt            | Vamale                                      | 
| mku            | Konyanka Maninka                            | 
| mkv            | Mafea                                       | 
| mkw            | Kituba (Congo)                              | 
| mkx            | Kinamiging Manobo                           | 
| mky            | East Makian                                 | 
| mkz            | Makasae                                     | 
| mla            | Malo                                        | 
| mlb            | Mbule                                       | 
| mlc            | Cao Lan                                     | 
| mle            | Manambu                                     | 
| mlf            | Mal                                         | 
| mlh            | Mape                                        | 
| mli            | Malimpung                                   | 
| mlj            | Miltu                                       | 
| mlk            | Kiwilwana                                   | 
| mll            | Malua Bay                                   | 
| mlm            | Mulam                                       | 
| mln            | Malango                                     | 
| mlo            | Mlomp                                       | 
| mlp            | Bargam                                      | 
| mlq            | Western Maninkakan                          | 
| mlr            | Vame                                        | 
| mls            | Masalit                                     | 
| mlt            | Maltese                                     | 
| mlu            | To'abaita                                   | 
| mlv            | Mwotlap                                     | 
| mlw            | Moloko                                      | 
| mlx            | Naha'ai                                     | 
| mlz            | Malaynon                                    | 
| mma            | Mama                                        | 
| mmb            | Momina                                      | 
| mmc            | Michoacán Mazahua                           | 
| mmd            | Maonan                                      | 
| mme            | Mae                                         | 
| mmf            | Mundat                                      | 
| mmg            | North Ambrym                                | 
| mmh            | Mehináku                                    | 
| mmi            | Musar                                       | 
| mmj            | Majhwar                                     | 
| mmk            | Mukha-Dora                                  | 
| mml            | Man Met                                     | 
| mmm            | Maii                                        | 
| mmn            | Mamanwa                                     | 
| mmo            | Mangga Buang                                | 
| mmp            | Siawi                                       | 
| mmq            | Musak                                       | 
| mmr            | Western Xiangxi Miao                        | 
| mmt            | Malalamai                                   | 
| mmu            | Mmaala                                      | 
| mmv            | Miriti                                      | 
| mmw            | Emae                                        | 
| mmx            | Madak                                       | 
| mmy            | Migaama                                     | 
| mmz            | Mabaale                                     | 
| mna            | Mbula                                       | 
| mnb            | Muna                                        | 
| mnc            | Manchu                                      | 
| mnd            | Mondé                                       | 
| mne            | Naba                                        | 
| mnf            | Mundani                                     | 
| mng            | Eastern Mnong                               | 
| mnh            | Mono (Democratic Republic of Congo)         | 
| mni            | Manipuri                                    | 
| mnj            | Munji                                       | 
| mnk            | Mandinka                                    | 
| mnl            | Tiale                                       | 
| mnm            | Mapena                                      | 
| mnn            | Southern Mnong                              | 
| mnp            | Min Bei Chinese                             | 
| mnq            | Minriq                                      | 
| mnr            | Mono (USA)                                  | 
| mns            | Mansi                                       | 
| mnu            | Mer                                         | 
| mnv            | Rennell-Bellona                             | 
| mnw            | Mon                                         | 
| mnx            | Manikion                                    | 
| mny            | Manyawa                                     | 
| mnz            | Moni                                        | 
| moa            | Mwan                                        | 
| moc            | Mocoví                                      | 
| moe            | Montagnais                                  | 
| mog            | Mongondow                                   | 
| moh            | Mohawk                                      | 
| moi            | Mboi                                        | 
| moj            | Monzombo                                    | 
| mok            | Morori                                      | 
| mom            | Mangue                                      | 
| moo            | Monom                                       | 
| mop            | Mopán Maya                                  | 
| moq            | Mor (Bomberai Peninsula)                    | 
| mor            | Moro                                        | 
| mos            | Mossi                                       | 
| mot            | Barí                                        | 
| mou            | Mogum                                       | 
| mov            | Mohave                                      | 
| mow            | Moi (Congo)                                 | 
| mox            | Molima                                      | 
| moy            | Shekkacho                                   | 
| moz            | Mukulu                                      | 
| mpa            | Mpoto                                       | 
| mpb            | Mullukmulluk                                | 
| mpc            | Mangarrayi                                  | 
| mpd            | Machinere                                   | 
| mpe            | Majang                                      | 
| mpg            | Marba                                       | 
| mph            | Maung                                       | 
| mpi            | Mpade                                       | 
| mpj            | Wangkajunga                                 | 
| mpk            | Mbara (Chad)                                | 
| mpl            | Middle Watut                                | 
| mpm            | Yosondúa Mixtec                             | 
| mpn            | Mindiri                                     | 
| mpo            | Miu                                         | 
| mpp            | Migabac                                     | 
| mpq            | Matís                                       | 
| mpr            | Vangunu                                     | 
| mps            | Dadibi                                      | 
| mpt            | Mian                                        | 
| mpu            | Makuráp                                     | 
| mpv            | Mungkip                                     | 
| mpw            | Mapidian                                    | 
| mpx            | Misima-Panaeati                             | 
| mpy            | Mapia                                       | 
| mpz            | Mpi                                         | 
| mqa            | Maba (Indonesia)                            | 
| mqb            | Mbuko                                       | 
| mqc            | Mangole                                     | 
| mqe            | Matepi                                      | 
| mqf            | Momuna                                      | 
| mqg            | Kota Bangun Kutai Malay                     | 
| mqh            | Tlazoyaltepec Mixtec                        | 
| mqi            | Mariri                                      | 
| mqj            | Mamasa                                      | 
| mqk            | Rajah Kabunsuwan Manobo                     | 
| mql            | Mbelime                                     | 
| mqm            | South Marquesan                             | 
| mqn            | Moronene                                    | 
| mqo            | Modole                                      | 
| mqp            | Manipa                                      | 
| mqq            | Minokok                                     | 
| mqr            | Mander                                      | 
| mqs            | West Makian                                 | 
| mqt            | Mok                                         | 
| mqu            | Mandari                                     | 
| mqv            | Mosimo                                      | 
| mqw            | Murupi                                      | 
| mqx            | Mamuju                                      | 
| mqy            | Manggarai                                   | 
| mqz            | Pano                                        | 
| mra            | Mlabri                                      | 
| mrb            | Marino                                      | 
| mrc            | Maricopa                                    | 
| mrd            | Western Magar                               | 
| mrf            | Elseng                                      | 
| mrg            | Mising                                      | 
| mrh            | Mara Chin                                   | 
| mri            | Māori                                       | 
| mrj            | Western Mari                                | 
| mrk            | Hmwaveke                                    | 
| mrl            | Mortlockese                                 | 
| mrm            | Mwerlap                                     | 
| mrn            | Cheke Holo                                  | 
| mro            | Mru                                         | 
| mrp            | Morouas                                     | 
| mrq            | North Marquesan                             | 
| mrr            | Maria (India)                               | 
| mrs            | Maragus                                     | 
| mrt            | Marghi Central                              | 
| mru            | Mono (Cameroon)                             | 
| mrv            | Mangareva                                   | 
| mrw            | Maranao                                     | 
| mrx            | Maremgi                                     | 
| mry            | Mandaya                                     | 
| mrz            | Marind                                      | 
| msb            | Masbatenyo                                  | 
| msc            | Sankaran Maninka                            | 
| mse            | Musey                                       | 
| msf            | Mekwei                                      | 
| msg            | Moraid                                      | 
| msh            | Masikoro Malagasy                           | 
| msi            | Sabah Malay                                 | 
| msj            | Ma (Democratic Republic of Congo)           | 
| msk            | Mansaka                                     | 
| msl            | Poule                                       | 
| msm            | Agusan Manobo                               | 
| msn            | Vurës                                       | 
| mso            | Mombum                                      | 
| msp            | Maritsauá                                   | 
| msq            | Caac                                        | 
| mss            | West Masela                                 | 
| msu            | Musom                                       | 
| msv            | Maslam                                      | 
| msw            | Mansoanka                                   | 
| msx            | Moresada                                    | 
| msy            | Aruamu                                      | 
| msz            | Momare                                      | 
| mta            | Cotabato Manobo                             | 
| mtb            | Anyin Morofo                                | 
| mtc            | Munit                                       | 
| mtd            | Mualang                                     | 
| mte            | Mono (Solomon Islands)                      | 
| mtf            | Murik (Papua New Guinea)                    | 
| mtg            | Una                                         | 
| mth            | Munggui                                     | 
| mti            | Maiwa (Papua New Guinea)                    | 
| mtj            | Moskona                                     | 
| mtk            | Mbe'                                        | 
| mtl            | Montol                                      | 
| mtm            | Mator                                       | 
| mtn            | Matagalpa                                   | 
| mto            | Totontepec Mixe                             | 
| mtp            | Wichí Lhamtés Nocten                        | 
| mtq            | Muong                                       | 
| mtr            | Mewari                                      | 
| mts            | Yora                                        | 
| mtt            | Mota                                        | 
| mtu            | Tututepec Mixtec                            | 
| mtv            | Asaro'o                                     | 
| mtw            | Southern Binukidnon                         | 
| mtx            | Tidaá Mixtec                                | 
| mty            | Nabi                                        | 
| mua            | Mundang                                     | 
| mub            | Mubi                                        | 
| muc            | Ajumbu                                      | 
| mud            | Mednyj Aleut                                | 
| mug            | Musgu                                       | 
| muh            | Mündü                                       | 
| mui            | Musi                                        | 
| muj            | Mabire                                      | 
| muk            | Mugom                                       | 
| mum            | Maiwala                                     | 
| muo            | Nyong                                       | 
| mup            | Malvi                                       | 
| muq            | Eastern Xiangxi Miao                        | 
| mur            | Murle                                       | 
| mus            | Creek                                       | 
| mut            | Western Muria                               | 
| muu            | Yaaku                                       | 
| muv            | Muthuvan                                    | 
| mux            | Bo-Ung                                      | 
| muy            | Muyang                                      | 
| muz            | Mursi                                       | 
| mva            | Manam                                       | 
| mvb            | Mattole                                     | 
| mvd            | Mamboru                                     | 
| mve            | Marwari (Pakistan)                          | 
| mvf            | Peripheral Mongolian                        | 
| mvg            | Yucuañe Mixtec                              | 
| mvh            | Mulgi                                       | 
| mvi            | Miyako                                      | 
| mvk            | Mekmek                                      | 
| mvl            | Mbara (Australia)                           | 
| mvn            | Minaveha                                    | 
| mvo            | Marovo                                      | 
| mvp            | Duri                                        | 
| mvq            | Moere                                       | 
| mvr            | Marau                                       | 
| mvs            | Massep                                      | 
| mvt            | Mpotovoro                                   | 
| mvu            | Marfa                                       | 
| mvv            | Tagal Murut                                 | 
| mvw            | Machinga                                    | 
| mvx            | Meoswar                                     | 
| mvy            | Indus Kohistani                             | 
| mvz            | Mesqan                                      | 
| mwa            | Mwatebu                                     | 
| mwb            | Juwal                                       | 
| mwc            | Are                                         | 
| mwe            | Mwera (Chimwera)                            | 
| mwf            | Murrinh-Patha                               | 
| mwg            | Aiklep                                      | 
| mwh            | Mouk-Aria                                   | 
| mwi            | Ninde                                       | 
| mwk            | Kita Maninkakan                             | 
| mwl            | Mirandese                                   | 
| mwm            | Sar                                         | 
| mwn            | Nyamwanga                                   | 
| mwo            | Central Maewo                               | 
| mwp            | Kala Lagaw Ya                               | 
| mwq            | Mün Chin                                    | 
| mws            | Mwimbi-Muthambi                             | 
| mwt            | Moken                                       | 
| mwu            | Mittu                                       | 
| mwv            | Mentawai                                    | 
| mww            | Hmong Daw                                   | 
| mwz            | Moingi                                      | 
| mxa            | Northwest Oaxaca Mixtec                     | 
| mxb            | Tezoatlán Mixtec                            | 
| mxc            | Manyika                                     | 
| mxd            | Modang                                      | 
| mxe            | Mele-Fila                                   | 
| mxf            | Malgbe                                      | 
| mxg            | Mbangala                                    | 
| mxh            | Mvuba                                       | 
| mxi            | Mozarabic                                   | 
| mxj            | Miju-Mishmi                                 | 
| mxk            | Monumbo                                     | 
| mxl            | Maxi Gbe                                    | 
| mxm            | Meramera                                    | 
| mxn            | Moi (Indonesia)                             | 
| mxo            | Mbowe                                       | 
| mxp            | Tlahuitoltepec Mixe                         | 
| mxq            | Juquila Mixe                                | 
| mxr            | Murik (Malaysia)                            | 
| mxs            | Huitepec Mixtec                             | 
| mxt            | Jamiltepec Mixtec                           | 
| mxu            | Mada (Cameroon)                             | 
| mxv            | Metlatónoc Mixtec                           | 
| mxw            | Namo                                        | 
| mxx            | Mawukakan                                   | 
| mxy            | Southeastern Nochixtlán Mixtec              | 
| mxz            | Central Masela                              | 
| mya            | Burmese                                     | 
| myb            | Mbay                                        | 
| myc            | Mayeka                                      | 
| mye            | Myene                                       | 
| myf            | Bambassi                                    | 
| myg            | Manta                                       | 
| myh            | Makah                                       | 
| myj            | Mangayat                                    | 
| myk            | Mamara Senoufo                              | 
| myl            | Moma                                        | 
| mym            | Me'en                                       | 
| myo            | Anfillo                                     | 
| myp            | Pirahã                                      | 
| myr            | Muniche                                     | 
| mys            | Mesmes                                      | 
| myu            | Mundurukú                                   | 
| myv            | Erzya                                       | 
| myw            | Muyuw                                       | 
| myx            | Masaaba                                     | 
| myy            | Macuna                                      | 
| myz            | Classical Mandaic                           | 
| mza            | Santa María Zacatepec Mixtec                | 
| mzb            | Tumzabt                                     | 
| mzd            | Malimba                                     | 
| mze            | Morawa                                      | 
| mzh            | Wichí Lhamtés Güisnay                       | 
| mzi            | Ixcatlán Mazatec                            | 
| mzj            | Manya                                       | 
| mzk            | Nigeria Mambila                             | 
| mzl            | Mazatlán Mixe                               | 
| mzm            | Mumuye                                      | 
| mzn            | Mazanderani                                 | 
| mzo            | Matipuhy                                    | 
| mzp            | Movima                                      | 
| mzq            | Mori Atas                                   | 
| mzr            | Marúbo                                      | 
| mzs            | Macanese                                    | 
| mzt            | Mintil                                      | 
| mzu            | Inapang                                     | 
| mzv            | Manza                                       | 
| mzw            | Deg                                         | 
| mzz            | Maiadomu                                    | 
| naa            | Namla                                       | 
| nab            | Southern Nambikuára                         | 
| nac            | Narak                                       | 
| nae            | Naka'ela                                    | 
| naf            | Nabak                                       | 
| nag            | Naga Pidgin                                 | 
| naj            | Nalu                                        | 
| nak            | Nakanai                                     | 
| nal            | Nalik                                       | 
| nam            | Ngan'gityemerri                             | 
| nan            | Min Nan Chinese                             | 
| nao            | Naaba                                       | 
| nap            | Neapolitan                                  | 
| naq            | Nama (Namibia)                              | 
| nar            | Iguta                                       | 
| nas            | Naasioi                                     | 
| nat            | Hungworo                                    | 
| nau            | Nauru                                       | 
| nav            | Navajo                                      | 
| naw            | Nawuri                                      | 
| nax            | Nakwi                                       | 
| nay            | Ngarrindjeri                                | 
| naz            | Coatepec Nahuatl                            | 
| nba            | Nyemba                                      | 
| nbb            | Ndoe                                        | 
| nbc            | Chang Naga                                  | 
| nbd            | Ngbinda                                     | 
| nbe            | Konyak Naga                                 | 
| nbh            | Ngamo                                       | 
| nbi            | Mao Naga                                    | 
| nbj            | Ngarinyman                                  | 
| nbk            | Nake                                        | 
| nbm            | Ngbaka Ma'bo                                | 
| nbn            | Kuri                                        | 
| nbo            | Nkukoli                                     | 
| nbp            | Nnam                                        | 
| nbq            | Nggem                                       | 
| nbr            | Numana                                      | 
| nbt            | Na                                          | 
| nbu            | Rongmei Naga                                | 
| nbv            | Ngamambo                                    | 
| nbw            | Southern Ngbandi                            | 
| nby            | Ningera                                     | 
| nca            | Iyo                                         | 
| ncb            | Central Nicobarese                          | 
| ncc            | Ponam                                       | 
| ncd            | Nachering                                   | 
| nce            | Yale                                        | 
| ncf            | Notsi                                       | 
| ncg            | Nisga'a                                     | 
| nch            | Central Huasteca Nahuatl                    | 
| nci            | Nahuatl                                     | 
| ncj            | Northern Puebla Nahuatl                     | 
| nck            | Na-kara                                     | 
| ncl            | Michoacán Nahuatl                           | 
| ncm            | Nambo                                       | 
| ncn            | Nauna                                       | 
| nco            | Sibe                                        | 
| ncq            | Northern Katang                             | 
| ncr            | Ncane                                       | 
| nct            | Chothe Naga                                 | 
| ncu            | Chumburung                                  | 
| ncx            | Central Puebla Nahuatl                      | 
| ncz            | Natchez                                     | 
| nda            | Ndasa                                       | 
| ndb            | Kenswei Nsei                                | 
| ndc            | Ndau                                        | 
| ndd            | Nde-Nsele-Nta                               | 
| nde            | North Ndebele                               | 
| ndg            | Ndengereko                                  | 
| ndh            | Ndali                                       | 
| ndi            | Samba Leko                                  | 
| ndj            | Ndamba                                      | 
| ndk            | Ndaka                                       | 
| ndl            | Ndolo                                       | 
| ndm            | Ndam                                        | 
| ndn            | Ngundi                                      | 
| ndo            | Ndonga                                      | 
| ndp            | Ndo                                         | 
| ndq            | Ndombe                                      | 
| ndr            | Ndoola                                      | 
| nds            | Low Saxon                                   | 
| ndt            | Ndunga                                      | 
| ndu            | Dugun                                       | 
| ndv            | Ndut                                        | 
| ndw            | Ndobo                                       | 
| ndx            | Nduga                                       | 
| ndy            | Lutos                                       | 
| ndz            | Ndogo                                       | 
| nea            | Eastern Ngad'a                              | 
| neb            | Toura (Côte d'Ivoire)                       | 
| nec            | Nedebang                                    | 
| nee            | Nêlêmwa-Nixumwak                            | 
| neg            | Negidal                                     | 
| neh            | Nyenkha                                     | 
| nej            | Neko                                        | 
| nek            | Neku                                        | 
| nem            | Nemi                                        | 
| nen            | Nengone                                     | 
| nep            | Nepali (macrolanguage)                      | 
| neq            | North Central Mixe                          | 
| ner            | Yahadian                                    | 
| nes            | Bhoti Kinnauri                              | 
| net            | Nete                                        | 
| nev            | Nyaheun                                     | 
| new            | Newari                                      | 
| nex            | Neme                                        | 
| ney            | Neyo                                        | 
| nez            | Nez Perce                                   | 
| nfa            | Dhao                                        | 
| nfd            | Ahwai                                       | 
| nfl            | Ayiwo                                       | 
| nfr            | Nafaanra                                    | 
| nfu            | Mfumte                                      | 
| nga            | Ngbaka                                      | 
| ngb            | Northern Ngbandi                            | 
| ngc            | Ngombe (Democratic Republic of Congo)       | 
| ngd            | Ngando (Central African Republic)           | 
| nge            | Ngemba                                      | 
| ngg            | Ngbaka Manza                                | 
| ngh            | Nǁng                                        | 
| ngi            | Ngizim                                      | 
| ngj            | Ngie                                        | 
| ngk            | Dalabon                                     | 
| ngl            | Lomwe                                       | 
| ngn            | Ngwo                                        | 
| ngp            | Ngulu                                       | 
| ngq            | Ngurimi                                     | 
| ngr            | Engdewu                                     | 
| ngs            | Gvoko                                       | 
| ngt            | Ngeq                                        | 
| ngu            | Guerrero Nahuatl                            | 
| ngv            | Nagumi                                      | 
| ngw            | Ngwaba                                      | 
| ngx            | Nggwahyi                                    | 
| ngy            | Tibea                                       | 
| ngz            | Ngungwel                                    | 
| nha            | Nhanda                                      | 
| nhb            | Beng                                        | 
| nhc            | Tabasco Nahuatl                             | 
| nhd            | Chiripá                                     | 
| nhe            | Eastern Huasteca Nahuatl                    | 
| nhf            | Nhuwala                                     | 
| nhg            | Tetelcingo Nahuatl                          | 
| nhh            | Nahari                                      | 
| nhi            | Zacatlán-Ahuacatlán-Tepetzintla Nahuatl     | 
| nhk            | Isthmus-Cosoleacaque Nahuatl                | 
| nhm            | Morelos Nahuatl                             | 
| nhn            | Central Nahuatl                             | 
| nho            | Takuu                                       | 
| nhp            | Isthmus-Pajapan Nahuatl                     | 
| nhq            | Huaxcaleca Nahuatl                          | 
| nhr            | Naro                                        | 
| nht            | Ometepec Nahuatl                            | 
| nhu            | Noone                                       | 
| nhv            | Temascaltepec Nahuatl                       | 
| nhw            | Western Huasteca Nahuatl                    | 
| nhx            | Isthmus-Mecayapan Nahuatl                   | 
| nhy            | Northern Oaxaca Nahuatl                     | 
| nhz            | Santa María La Alta Nahuatl                 | 
| nia            | Nias                                        | 
| nib            | Nakame                                      | 
| nid            | Ngandi                                      | 
| nie            | Niellim                                     | 
| nif            | Nek                                         | 
| nig            | Ngalakgan                                   | 
| nih            | Nyiha (Tanzania)                            | 
| nii            | Nii                                         | 
| nij            | Ngaju                                       | 
| nik            | Southern Nicobarese                         | 
| nil            | Nila                                        | 
| nim            | Nilamba                                     | 
| nin            | Ninzo                                       | 
| nio            | Nganasan                                    | 
| niq            | Nandi                                       | 
| nir            | Nimboran                                    | 
| nis            | Nimi                                        | 
| nit            | Southeastern Kolami                         | 
| niu            | Niuean                                      | 
| niv            | Gilyak                                      | 
| niw            | Nimo                                        | 
| nix            | Hema                                        | 
| niy            | Ngiti                                       | 
| niz            | Ningil                                      | 
| nja            | Nzanyi                                      | 
| njb            | Nocte Naga                                  | 
| njh            | Lotha Naga                                  | 
| nji            | Gudanji                                     | 
| njj            | Njen                                        | 
| njl            | Njalgulgule                                 | 
| njm            | Angami Naga                                 | 
| njn            | Liangmai Naga                               | 
| njo            | Ao Naga                                     | 
| njr            | Njerep                                      | 
| njs            | Nisa                                        | 
| nju            | Ngadjunmaya                                 | 
| njx            | Kunyi                                       | 
| njy            | Njyem                                       | 
| njz            | Nyishi                                      | 
| nka            | Nkoya                                       | 
| nkb            | Khoibu Naga                                 | 
| nkc            | Nkongho                                     | 
| nkd            | Koireng                                     | 
| nke            | Duke                                        | 
| nkg            | Nekgini                                     | 
| nkh            | Khezha Naga                                 | 
| nki            | Thangal Naga                                | 
| nkj            | Nakai                                       | 
| nkk            | Nokuku                                      | 
| nkm            | Namat                                       | 
| nkn            | Nkangala                                    | 
| nko            | Nkonya                                      | 
| nkp            | Niuatoputapu                                | 
| nkq            | Nkami                                       | 
| nkr            | Nukuoro                                     | 
| nks            | North Asmat                                 | 
| nkt            | Nyika (Tanzania)                            | 
| nku            | Bouna Kulango                               | 
| nkv            | Nyika (Malawi and Zambia)                   | 
| nkw            | Nkutu                                       | 
| nkx            | Nkoroo                                      | 
| nkz            | Nkari                                       | 
| nla            | Ngombale                                    | 
| nlc            | Nalca                                       | 
| nld            | Dutch                                       | 
| nle            | East Nyala                                  | 
| nlg            | Gela                                        | 
| nli            | Grangali                                    | 
| nlj            | Nyali                                       | 
| nlk            | Ninia Yali                                  | 
| nll            | Nihali                                      | 
| nlm            | Mankiyali                                   | 
| nlo            | Ngul                                        | 
| nlu            | Nchumbulu                                   | 
| nlv            | Orizaba Nahuatl                             | 
| nlx            | Nahali                                      | 
| nly            | Nyamal                                      | 
| nlz            | Nalögo                                      | 
| nma            | Maram Naga                                  | 
| nmb            | V'ënen Taut                                 | 
| nmc            | Ngam                                        | 
| nmd            | Ndumu                                       | 
| nme            | Mzieme Naga                                 | 
| nmf            | Tangkhul Naga (India)                       | 
| nmg            | Kwasio                                      | 
| nmh            | Monsang Naga                                | 
| nmi            | Nyam                                        | 
| nmk            | Namakura                                    | 
| nml            | Ndemli                                      | 
| nmm            | Manangba                                    | 
| nmn            | ǃXóõ                                        | 
| nmo            | Moyon Naga                                  | 
| nmp            | Nimanbur                                    | 
| nmq            | Nambya                                      | 
| nmr            | Nimbari                                     | 
| nms            | Letemboi                                    | 
| nmt            | Namonuito                                   | 
| nmu            | Northeast Maidu                             | 
| nmv            | Ngamini                                     | 
| nmw            | Rifao                                       | 
| nmx            | Nama (Papua New Guinea)                     | 
| nmy            | Namuyi                                      | 
| nmz            | Nawdm                                       | 
| nna            | Nyangumarta                                 | 
| nnb            | Nande                                       | 
| nnc            | Nancere                                     | 
| nnd            | West Ambae                                  | 
| nne            | Ngandyera                                   | 
| nnf            | Ngaing                                      | 
| nng            | Maring Naga                                 | 
| nnh            | Ngiemboon                                   | 
| nni            | North Nuaulu                                | 
| nnj            | Nyangatom                                   | 
| nnk            | Nankina                                     | 
| nnl            | Northern Rengma Naga                        | 
| nnm            | Namia                                       | 
| nnn            | Ngete                                       | 
| nnp            | Wancho Naga                                 | 
| nnq            | Ngindo                                      | 
| nnr            | Narungga                                    | 
| nnt            | Nanticoke                                   | 
| nnu            | Dwang                                       | 
| nnv            | Nugunu (Australia)                          | 
| nnw            | Southern Nuni                               | 
| nny            | Nyangga                                     | 
| nnz            | Nda'nda'                                    | 
| noa            | Woun Meu                                    | 
| nob            | Norwegian Bokmål                            | 
| noc            | Nuk                                         | 
| nod            | Northern Thai                               | 
| noe            | Nimadi                                      | 
| nof            | Nomane                                      | 
| nog            | Nogai                                       | 
| noh            | Nomu                                        | 
| noi            | Noiri                                       | 
| noj            | Nonuya                                      | 
| nok            | Nooksack                                    | 
| non            | Old Norse                                   | 
| nop            | Numanggang                                  | 
| noq            | Ngongo                                      | 
| nor            | Norwegian                                   | 
| nos            | Eastern Nisu                                | 
| not            | Nomatsiguenga                               | 
| nou            | Ewage-Notu                                  | 
| now            | Nyambo                                      | 
| noy            | Noy                                         | 
| noz            | Nayi                                        | 
| npa            | Nar Phu                                     | 
| nph            | Phom Naga                                   | 
| npi            | Nepali                                      | 
| npl            | Southeastern Puebla Nahuatl                 | 
| npn            | Mondropolon                                 | 
| npo            | Pochuri Naga                                | 
| nps            | Nipsan                                      | 
| npy            | Napu                                        | 
| nqg            | Southern Nago                               | 
| nqk            | Kura Ede Nago                               | 
| nql            | Ngendelengo                                 | 
| nqm            | Ndom                                        | 
| nqn            | Nen                                         | 
| nqt            | Nteng                                       | 
| nra            | Ngom                                        | 
| nrb            | Nara                                        | 
| nrc            | Noric                                       | 
| nre            | Southern Rengma Naga                        | 
| nrf            | Jèrriais                                    | 
| nrg            | Narango                                     | 
| nri            | Chokri Naga                                 | 
| nrk            | Ngarla                                      | 
| nrl            | Ngarluma                                    | 
| nrm            | Narom                                       | 
| nrt            | Northern Kalapuya                           | 
| nru            | Narua                                       | 
| nrz            | Lala                                        | 
| nsa            | Sangtam Naga                                | 
| nsb            | Lower Nossob                                | 
| nsd            | Southern Nisu                               | 
| nse            | Nsenga                                      | 
| nsf            | Northwestern Nisu                           | 
| nsg            | Ngasa                                       | 
| nsh            | Ngoshie                                     | 
| nsk            | Naskapi                                     | 
| nsm            | Sumi Naga                                   | 
| nsn            | Nehan                                       | 
| nso            | Sepedi                                      | 
| nsq            | Northern Sierra Miwok                       | 
| nss            | Nali                                        | 
| nst            | Tase Naga                                   | 
| nsu            | Sierra Negra Nahuatl                        | 
| nsw            | Navut                                       | 
| nsx            | Nsongo                                      | 
| nsy            | Nasal                                       | 
| nsz            | Nisenan                                     | 
| ntd            | Northern Tidung                             | 
| nte            | Nathembo                                    | 
| nti            | Natioro                                     | 
| ntj            | Ngaanyatjarra                               | 
| ntk            | Ikoma-Nata-Isenye                           | 
| ntm            | Nateni                                      | 
| nto            | Ntomba                                      | 
| ntp            | Northern Tepehuan                           | 
| ntr            | Delo                                        | 
| ntu            | Natügu                                      | 
| ntw            | Nottoway                                    | 
| nty            | Mantsi                                      | 
| ntz            | Natanzi                                     | 
| nua            | Yuanga                                      | 
| nuc            | Nukuini                                     | 
| nud            | Ngala                                       | 
| nue            | Ngundu                                      | 
| nuf            | Nusu                                        | 
| nug            | Nungali                                     | 
| nuh            | Ndunda                                      | 
| nui            | Ngumbi                                      | 
| nuj            | Nyole                                       | 
| nuk            | Nuu-chah-nulth                              | 
| nul            | Nusa Laut                                   | 
| num            | Niuafo'ou                                   | 
| nun            | Anong                                       | 
| nuo            | Nguôn                                       | 
| nup            | Nupe-Nupe-Tako                              | 
| nuq            | Nukumanu                                    | 
| nur            | Nukuria                                     | 
| nus            | Nuer                                        | 
| nut            | Nung (Viet Nam)                             | 
| nuu            | Ngbundu                                     | 
| nuv            | Northern Nuni                               | 
| nuw            | Nguluwan                                    | 
| nux            | Mehek                                       | 
| nuy            | Nunggubuyu                                  | 
| nuz            | Tlamacazapa Nahuatl                         | 
| nvh            | Nasarian                                    | 
| nvm            | Namiae                                      | 
| nvo            | Nyokon                                      | 
| nwa            | Nawathinehena                               | 
| nwb            | Nyabwa                                      | 
| nwe            | Ngwe                                        | 
| nwi            | Southwest Tanna                             | 
| nwm            | Nyamusa-Molo                                | 
| nwo            | Nauo                                        | 
| nwr            | Nawaru                                      | 
| nxa            | Nauete                                      | 
| nxd            | Ngando (Democratic Republic of Congo)       | 
| nxe            | Nage                                        | 
| nxg            | Ngad'a                                      | 
| nxi            | Nindi                                       | 
| nxl            | South Nuaulu                                | 
| nxn            | Ngawun                                      | 
| nxo            | Ndambomo                                    | 
| nxq            | Naxi                                        | 
| nxr            | Ninggerum                                   | 
| nxx            | Nafri                                       | 
| nya            | Nyanja                                      | 
| nyb            | Nyangbo                                     | 
| nyc            | Nyanga-li                                   | 
| nyd            | Olunyole                                    | 
| nye            | Nyengo                                      | 
| nyf            | Kigiryama                                   | 
| nyg            | Nyindu                                      | 
| nyh            | Nyikina                                     | 
| nyi            | Ama (Sudan)                                 | 
| nyj            | Nyanga                                      | 
| nyk            | Nyaneka                                     | 
| nyl            | Nyeu                                        | 
| nym            | Nyamwezi                                    | 
| nyn            | Nyankole                                    | 
| nyo            | Nyoro                                       | 
| nyp            | Nyang'i                                     | 
| nyq            | Nayini                                      | 
| nyr            | Nyiha (Malawi)                              | 
| nys            | Nyungar                                     | 
| nyt            | Nyawaygi                                    | 
| nyu            | Nyungwe                                     | 
| nyv            | Nyulnyul                                    | 
| nyw            | Nyaw                                        | 
| nyx            | Nganyaywana                                 | 
| nyy            | Nyakyusa-Ngonde                             | 
| nza            | Tigon Mbembe                                | 
| nzb            | Njebi                                       | 
| nzd            | Nzadi                                       | 
| nzi            | Nzima                                       | 
| nzk            | Nzakara                                     | 
| nzm            | Zeme Naga                                   | 
| nzu            | Teke-Nzikou                                 | 
| nzy            | Nzakambay                                   | 
| nzz            | Nanga Dama Dogon                            | 
| oaa            | Orok                                        | 
| oac            | Oroch                                       | 
| oar            | Old Aramaic (up to 700 BCE)                 | 
| obi            | Obispeño                                    | 
| obl            | Oblo                                        | 
| obo            | Obo Manobo                                  | 
| obr            | Old Burmese                                 | 
| obu            | Obulom                                      | 
| oca            | Ocaina                                      | 
| och            | Old Chinese                                 | 
| oci            | Occitan                                     | 
| ocu            | Atzingo Matlatzinca                         | 
| odk            | Od                                          | 
| odt            | Old Dutch                                   | 
| odu            | Odual                                       | 
| ofo            | Ofo                                         | 
| ofs            | Old Frisian                                 | 
| ofu            | Efutop                                      | 
| ogb            | Ogbia                                       | 
| ogc            | Ogbah                                       | 
| oge            | Old Georgian                                | 
| ogg            | Ogbogolo                                    | 
| ogo            | Khana                                       | 
| ogu            | Ogbronuagum                                 | 
| oia            | Oirata                                      | 
| oin            | Inebu One                                   | 
| ojb            | Northwestern Ojibwa                         | 
| ojc            | Central Ojibwa                              | 
| ojg            | Eastern Ojibwa                              | 
| ojp            | Old Japanese                                | 
| ojs            | Severn Ojibwa                               | 
| ojv            | Ontong Java                                 | 
| ojw            | Western Ojibwa                              | 
| oka            | Okanagan                                    | 
| okb            | Okobo                                       | 
| okd            | Okodia                                      | 
| oke            | Okpe (Southwestern Edo)                     | 
| okh            | Koresh-e Rostam                             | 
| oki            | Okiek                                       | 
| okj            | Oko-Juwoi                                   | 
| okk            | Kwamtim One                                 | 
| okn            | Oki-No-Erabu                                | 
| okr            | Kirike                                      | 
| oks            | Oko-Eni-Osayen                              | 
| oku            | Oku                                         | 
| okv            | Orokaiva                                    | 
| okx            | Okpe (Northwestern Edo)                     | 
| ola            | Walungge                                    | 
| old            | Mochi                                       | 
| ole            | Olekha                                      | 
| olm            | Oloma                                       | 
| olo            | Livvi                                       | 
| olr            | Olrat                                       | 
| olu            | Kuvale                                      | 
| oma            | Omaha-Ponca                                 | 
| omb            | East Ambae                                  | 
| omc            | Mochica                                     | 
| omg            | Omagua                                      | 
| omi            | Omi                                         | 
| omk            | Omok                                        | 
| oml            | Ombo                                        | 
| omo            | Utarmbung                                   | 
| omr            | Old Marathi                                 | 
| omt            | Omotik                                      | 
| omu            | Omurano                                     | 
| omw            | South Tairora                               | 
| omx            | Old Mon                                     | 
| ona            | Ona                                         | 
| onb            | Lingao                                      | 
| one            | Oneida                                      | 
| ong            | Olo                                         | 
| oni            | Onin                                        | 
| onj            | Onjob                                       | 
| onk            | Kabore One                                  | 
| onn            | Onobasulu                                   | 
| ono            | Onondaga                                    | 
| onp            | Sartang                                     | 
| onr            | Northern One                                | 
| ons            | Ono                                         | 
| onu            | Unua                                        | 
| onw            | Old Nubian                                  | 
| ood            | Tohono O'odham                              | 
| oog            | Ong                                         | 
| oon            | Önge                                        | 
| oor            | Oorlams                                     | 
| oos            | Old Ossetic                                 | 
| opa            | Okpamheri                                   | 
| opk            | Kopkaka                                     | 
| opm            | Oksapmin                                    | 
| opo            | Opao                                        | 
| opt            | Opata                                       | 
| opy            | Ofayé                                       | 
| ora            | Oroha                                       | 
| orc            | Orma                                        | 
| ore            | Orejón                                      | 
| org            | Oring                                       | 
| orh            | Oroqen                                      | 
| orn            | Orang Kanaq                                 | 
| oro            | Orokolo                                     | 
| orr            | Oruma                                       | 
| ors            | Orang Seletar                               | 
| ort            | Adivasi Oriya                               | 
| oru            | Ormuri                                      | 
| orv            | Old Russian                                 | 
| orw            | Oro Win                                     | 
| orx            | Oro                                         | 
| ory            | Oriya                                       | 
| orz            | Ormu                                        | 
| osa            | Osage                                       | 
| osc            | Oscan                                       | 
| osi            | Osing                                       | 
| oso            | Ososo                                       | 
| osp            | Old Spanish                                 | 
| oss            | Ossetic                                     | 
| ost            | Osatu                                       | 
| osu            | Southern One                                | 
| osx            | Old Saxon                                   | 
| otd            | Ot Danum                                    | 
| ote            | Mezquital Otomi                             | 
| oti            | Oti                                         | 
| otl            | Tilapa Otomi                                | 
| otm            | Eastern Highland Otomi                      | 
| otn            | Tenango Otomi                               | 
| otq            | Querétaro Otomi                             | 
| otr            | Otoro                                       | 
| ots            | Estado de México Otomi                      | 
| ott            | Temoaya Otomi                               | 
| otu            | Otuke                                       | 
| otw            | Ottawa                                      | 
| otx            | Texcatepec Otomi                            | 
| oty            | Old Tamil                                   | 
| otz            | Ixtenco Otomi                               | 
| oua            | Tagargrent                                  | 
| oub            | Glio-Oubi                                   | 
| oue            | Oune                                        | 
| oui            | Old Uighur                                  | 
| oum            | Ouma                                        | 
| owi            | Owiniga                                     | 
| owl            | Old Welsh                                   | 
| oyb            | Oy                                          | 
| oyd            | Oyda                                        | 
| oym            | Wayampi                                     | 
| oyy            | Oya'oya                                     | 
| ozm            | Koonzime                                    | 
| pab            | Parecís                                     | 
| pac            | Pacoh                                       | 
| pad            | Paumarí                                     | 
| pae            | Pagibete                                    | 
| paf            | Paranawát                                   | 
| pag            | Pangasinan                                  | 
| pah            | Tenharim                                    | 
| pai            | Pe                                          | 
| pak            | Parakanã                                    | 
| pal            | Pahlavi                                     | 
| pam            | Pampanga                                    | 
| pan            | Punjabi                                     | 
| pao            | Northern Paiute                             | 
| pap            | Papiamento                                  | 
| paq            | Parya                                       | 
| par            | Timbisha                                    | 
| pas            | Papasena                                    | 
| pau            | Palauan                                     | 
| pav            | Pakaásnovos                                 | 
| paw            | Pawnee                                      | 
| pay            | Pech                                        | 
| paz            | Pankararú                                   | 
| pbb            | Páez                                        | 
| pbc            | Patamona                                    | 
| pbe            | Mezontla Popoloca                           | 
| pbf            | Coyotepec Popoloca                          | 
| pbg            | Paraujano                                   | 
| pbh            | E'ñapa Woromaipu                            | 
| pbi            | Parkwa                                      | 
| pbl            | Mak (Nigeria)                               | 
| pbn            | Kpasam                                      | 
| pbo            | Papel                                       | 
| pbp            | Badyara                                     | 
| pbr            | Pangwa                                      | 
| pbs            | Central Pame                                | 
| pbt            | Southern Pashto                             | 
| pbu            | Northern Pashto                             | 
| pbv            | Pnar                                        | 
| pby            | Pyu (Papua New Guinea)                      | 
| pca            | Santa Inés Ahuatempan Popoloca              | 
| pcb            | Pear                                        | 
| pcc            | Bouyei                                      | 
| pcd            | Picard                                      | 
| pce            | Ruching Palaung                             | 
| pcf            | Paliyan                                     | 
| pcg            | Paniya                                      | 
| pci            | Duruwa                                      | 
| pcj            | Parenga                                     | 
| pck            | Paite Chin                                  | 
| pcl            | Pardhi                                      | 
| pcm            | Nigerian Pidgin                             | 
| pcn            | Piti                                        | 
| pcp            | Pacahuara                                   | 
| pcw            | Pyapun                                      | 
| pda            | Anam                                        | 
| pdc            | Pennsylvania German                         | 
| pdi            | Pa Di                                       | 
| pdn            | Podena                                      | 
| pdo            | Padoe                                       | 
| pdt            | Plautdietsch                                | 
| pdu            | Kayan                                       | 
| pea            | Peranakan Indonesian                        | 
| peb            | Eastern Pomo                                | 
| ped            | Mala (Papua New Guinea)                     | 
| pee            | Taje                                        | 
| pef            | Northeastern Pomo                           | 
| peg            | Pengo                                       | 
| peh            | Bonan                                       | 
| pei            | Chichimeca-Jonaz                            | 
| pej            | Northern Pomo                               | 
| pek            | Penchal                                     | 
| pel            | Pekal                                       | 
| pem            | Phende                                      | 
| peo            | Old Persian (ca. 600-400 B.C.)              | 
| pep            | Kunja                                       | 
| peq            | Southern Pomo                               | 
| pes            | Persian                                     | 
| pev            | Pémono                                      | 
| pex            | Petats                                      | 
| pey            | Petjo                                       | 
| pez            | Eastern Penan                               | 
| pfa            | Pááfang                                     | 
| pfe            | Pere                                        | 
| pfl            | Pfaelzisch                                  | 
| pga            | Sudanese Creole Arabic                      | 
| pgg            | Pangwali                                    | 
| pgi            | Pagi                                        | 
| pgk            | Rerep                                       | 
| pgs            | Pangseng                                    | 
| pgu            | Pagu                                        | 
| pha            | Pa-Hng                                      | 
| phd            | Phudagi                                     | 
| phg            | Phuong                                      | 
| phh            | Phukha                                      | 
| phk            | Phake                                       | 
| phl            | Phalura                                     | 
| phm            | Phimbi                                      | 
| phn            | Phoenician                                  | 
| pho            | Phunoi                                      | 
| phq            | Phana'                                      | 
| phr            | Pahari-Potwari                              | 
| pht            | Phu Thai                                    | 
| phu            | Phuan                                       | 
| phv            | Pahlavani                                   | 
| pia            | Pima Bajo                                   | 
| pib            | Yine                                        | 
| pic            | Pinji                                       | 
| pid            | Piaroa                                      | 
| pie            | Piro                                        | 
| pif            | Pingelapese                                 | 
| pih            | Pitcairn-Norfolk                            | 
| pii            | Pini                                        | 
| pil            | Yom                                         | 
| pim            | Powhatan                                    | 
| pin            | Piame                                       | 
| pio            | Piapoco                                     | 
| pip            | Pero                                        | 
| pir            | Piratapuyo                                  | 
| pis            | Pijin                                       | 
| pit            | Pitta Pitta                                 | 
| piu            | Pintupi-Luritja                             | 
| piv            | Vaeakau-Taumako                             | 
| piw            | Pimbwe                                      | 
| pix            | Piu                                         | 
| piy            | Piya-Kwonci                                 | 
| piz            | Pije                                        | 
| pjt            | Pitjantjatjara                              | 
| pkb            | Pokomo                                      | 
| pkg            | Pak-Tong                                    | 
| pkh            | Pankhu                                      | 
| pkn            | Pakanha                                     | 
| pko            | Pökoot                                      | 
| pkp            | Pukapuka                                    | 
| pkr            | Attapady Kurumba                            | 
| pkt            | Maleng                                      | 
| pku            | Paku                                        | 
| pla            | Miani                                       | 
| plb            | Polonombauk                                 | 
| plc            | Central Palawano                            | 
| ple            | Palu'e                                      | 
| plg            | Pilagá                                      | 
| plh            | Paulohi                                     | 
| pli            | Pali                                        | 
| plj            | Polci                                       | 
| plk            | Kohistani Shina                             | 
| pll            | Shwe Palaung                                | 
| pln            | Palenquero                                  | 
| plo            | Oluta Popoluca                              | 
| plq            | Palaic                                      | 
| plr            | Palaka Senoufo                              | 
| pls            | San Marcos Tlalcoyalco Popoloca             | 
| plt            | Plateau Malagasy                            | 
| plu            | Palikúr                                     | 
| plv            | Southwest Palawano                          | 
| plw            | Brooke's Point Palawano                     | 
| ply            | Bolyu                                       | 
| plz            | Paluan                                      | 
| pma            | Paama                                       | 
| pmb            | Pambia                                      | 
| pmd            | Pallanganmiddang                            | 
| pme            | Pwaamei                                     | 
| pmf            | Pamona                                      | 
| pmh            | Māhārāṣṭri Prākrit                          | 
| pmi            | Northern Pumi                               | 
| pmj            | Southern Pumi                               | 
| pmm            | Pomo                                        | 
| pmn            | Pam                                         | 
| pmo            | Pom                                         | 
| pmq            | Northern Pame                               | 
| pmr            | Paynamar                                    | 
| pms            | Piemontese                                  | 
| pmt            | Tuamotuan                                   | 
| pmw            | Plains Miwok                                | 
| pmx            | Poumei Naga                                 | 
| pmy            | Papuan Malay                                | 
| pmz            | Southern Pame                               | 
| pna            | Punan Bah-Biau                              | 
| pnb            | Western Panjabi                             | 
| pnc            | Pannei                                      | 
| pnd            | Mpinda                                      | 
| pne            | Western Penan                               | 
| png            | Pongu                                       | 
| pnh            | Penrhyn                                     | 
| pni            | Aoheng                                      | 
| pnj            | Pinjarup                                    | 
| pnk            | Paunaka                                     | 
| pnl            | Paleni                                      | 
| pnm            | Punan Batu 1                                | 
| pnn            | Pinai-Hagahai                               | 
| pno            | Panobo                                      | 
| pnp            | Pancana                                     | 
| pnq            | Pana (Burkina Faso)                         | 
| pnr            | Panim                                       | 
| pns            | Ponosakan                                   | 
| pnt            | Pontic                                      | 
| pnu            | Jiongnai Bunu                               | 
| pnv            | Pinigura                                    | 
| pnw            | Panytyima                                   | 
| pnx            | Phong-Kniang                                | 
| pny            | Pinyin                                      | 
| pnz            | Pana (Central African Republic)             | 
| poc            | Poqomam                                     | 
| poe            | San Juan Atzingo Popoloca                   | 
| pof            | Poke                                        | 
| pog            | Potiguára                                   | 
| poh            | Poqomchi'                                   | 
| poi            | Highland Popoluca                           | 
| pol            | Polish                                      | 
| pom            | Southeastern Pomo                           | 
| pon            | Pohnpeian                                   | 
| poo            | Central Pomo                                | 
| pop            | Pwapwâ                                      | 
| poq            | Texistepec Popoluca                         | 
| por            | Portuguese                                  | 
| pos            | Sayula Popoluca                             | 
| pot            | Potawatomi                                  | 
| pov            | Upper Guinea Crioulo                        | 
| pow            | San Felipe Otlaltepec Popoloca              | 
| pox            | Polabian                                    | 
| poy            | Pogolo                                      | 
| ppe            | Papi                                        | 
| ppi            | Paipai                                      | 
| ppk            | Uma                                         | 
| ppl            | Pipil                                       | 
| ppm            | Papuma                                      | 
| ppn            | Papapana                                    | 
| ppo            | Folopa                                      | 
| ppp            | Pelende                                     | 
| ppq            | Pei                                         | 
| pps            | San Luís Temalacayuca Popoloca              | 
| ppt            | Pare                                        | 
| ppu            | Papora                                      | 
| pqa            | Pa'a                                        | 
| pqm            | Malecite-Passamaquoddy                      | 
| prc            | Parachi                                     | 
| pre            | Principense                                 | 
| prf            | Paranan                                     | 
| prg            | Prussian                                    | 
| prh            | Porohanon                                   | 
| pri            | Paicî                                       | 
| prk            | Parauk                                      | 
| prm            | Kibiri                                      | 
| prn            | Prasuni                                     | 
| pro            | Old Provençal (to 1500)                     | 
| prq            | Ashéninka Perené                            | 
| prr            | Puri                                        | 
| prs            | Dari                                        | 
| prt            | Phai                                        | 
| pru            | Puragi                                      | 
| prw            | Parawen                                     | 
| prx            | Purik                                       | 
| psa            | Asue Awyu                                   | 
| pse            | Central Malay                               | 
| psh            | Southwest Pashayi                           | 
| psi            | Southeast Pashayi                           | 
| psm            | Pauserna                                    | 
| psn            | Panasuan                                    | 
| psq            | Pasi                                        | 
| pss            | Kaulong                                     | 
| pst            | Central Pashto                              | 
| psu            | Sauraseni Prākrit                           | 
| psw            | Port Sandwich                               | 
| psy            | Piscataway                                  | 
| pta            | Pai Tavytera                                | 
| pth            | Pataxó Hã-Ha-Hãe                            | 
| pti            | Wangkatha                                   | 
| ptn            | Patani                                      | 
| pto            | Zo'é                                        | 
| ptp            | Patep                                       | 
| ptr            | Piamatsina                                  | 
| ptt            | Enrekang                                    | 
| ptu            | Bambam                                      | 
| ptv            | Port Vato                                   | 
| ptw            | Pentlatch                                   | 
| pty            | Pathiya                                     | 
| pua            | Western Highland Purepecha                  | 
| pub            | Purum                                       | 
| pud            | Punan Aput                                  | 
| pue            | Puelche                                     | 
| puf            | Punan Merah                                 | 
| pug            | Phuie                                       | 
| pui            | Puinave                                     | 
| puj            | Punan Tubu                                  | 
| pum            | Puma                                        | 
| puo            | Puoc                                        | 
| pup            | Pulabu                                      | 
| puq            | Puquina                                     | 
| pur            | Puruborá                                    | 
| puu            | Punu                                        | 
| puw            | Puluwatese                                  | 
| pux            | Puare                                       | 
| puy            | Purisimeño                                  | 
| pwa            | Pawaia                                      | 
| pwb            | Panawa                                      | 
| pwg            | Gapapaiwa                                   | 
| pwi            | Patwin                                      | 
| pwm            | Molbog                                      | 
| pwn            | Paiwan                                      | 
| pwo            | Pwo Western Karen                           | 
| pwr            | Powari                                      | 
| pww            | Pwo Northern Karen                          | 
| pye            | Pye Krumen                                  | 
| pym            | Fyam                                        | 
| pyn            | Poyanáwa                                    | 
| pyu            | Puyuma                                      | 
| pyx            | Pyu (Myanmar)                               | 
| pyy            | Pyen                                        | 
| pzn            | Para Naga                                   | 
| qua            | Quapaw                                      | 
| qub            | Huallaga Huánuco Quechua                    | 
| quc            | Quiché                                      | 
| qud            | Calderón Highland Quichua                   | 
| quf            | Lambayeque Quechua                          | 
| qug            | Chimborazo Highland Quichua                 | 
| quh            | South Bolivian Quechua                      | 
| qui            | Quileute                                    | 
| quk            | Chachapoyas Quechua                         | 
| qul            | North Bolivian Quechua                      | 
| qum            | Sipacapense                                 | 
| qun            | Quinault                                    | 
| qup            | Southern Pastaza Quechua                    | 
| qur            | Yanahuanca Pasco Quechua                    | 
| qus            | Santiago del Estero Quichua                 | 
| quv            | Sacapulteco                                 | 
| quw            | Tena Lowland Quichua                        | 
| qux            | Yauyos Quechua                              | 
| quy            | Ayacucho Quechua                            | 
| quz            | Cusco Quechua                               | 
| qva            | Ambo-Pasco Quechua                          | 
| qvc            | Cajamarca Quechua                           | 
| qve            | Eastern Apurímac Quechua                    | 
| qvh            | Huamalíes-Dos de Mayo Huánuco Quechua       | 
| qvi            | Imbabura Highland Quichua                   | 
| qvj            | Loja Highland Quichua                       | 
| qvl            | Cajatambo North Lima Quechua                | 
| qvm            | Margos-Yarowilca-Lauricocha Quechua         | 
| qvn            | North Junín Quechua                         | 
| qvo            | Napo Lowland Quechua                        | 
| qvp            | Pacaraos Quechua                            | 
| qvs            | San Martín Quechua                          | 
| qvw            | Huaylla Wanca Quechua                       | 
| qvy            | Queyu                                       | 
| qvz            | Northern Pastaza Quichua                    | 
| qwa            | Corongo Ancash Quechua                      | 
| qwc            | Classical Quechua                           | 
| qwh            | Huaylas Ancash Quechua                      | 
| qws            | Sihuas Ancash Quechua                       | 
| qwt            | Kwalhioqua-Tlatskanai                       | 
| qxa            | Chiquián Ancash Quechua                     | 
| qxc            | Chincha Quechua                             | 
| qxh            | Panao Huánuco Quechua                       | 
| qxl            | Salasaca Highland Quichua                   | 
| qxn            | Northern Conchucos Ancash Quechua           | 
| qxo            | Southern Conchucos Ancash Quechua           | 
| qxp            | Puno Quechua                                | 
| qxq            | Qashqa'i                                    | 
| qxr            | Cañar Highland Quichua                      | 
| qxs            | Southern Qiang                              | 
| qxt            | Santa Ana de Tusi Pasco Quechua             | 
| qxu            | Arequipa-La Unión Quechua                   | 
| qxw            | Jauja Wanca Quechua                         | 
| qyp            | Quiripi                                     | 
| raa            | Dungmali                                    | 
| rab            | Camling                                     | 
| rac            | Rasawa                                      | 
| rad            | Rade                                        | 
| raf            | Western Meohang                             | 
| rag            | Lulogooli                                   | 
| rah            | Rabha                                       | 
| rai            | Ramoaaina                                   | 
| rak            | Tulu-Bohuai                                 | 
| ral            | Ralte                                       | 
| ram            | Canela                                      | 
| ran            | Riantana                                    | 
| rao            | Rao                                         | 
| rap            | Rapanui                                     | 
| raq            | Saam                                        | 
| rar            | Rarotongan                                  | 
| ras            | Tegali                                      | 
| rat            | Razajerdi                                   | 
| rau            | Raute                                       | 
| rav            | Sampang                                     | 
| raw            | Rawang                                      | 
| rax            | Rang                                        | 
| ray            | Rapa                                        | 
| raz            | Rahambuu                                    | 
| rbb            | Rumai Palaung                               | 
| rcf            | Réunion Creole French                       | 
| rdb            | Rudbari                                     | 
| rea            | Rerau                                       | 
| reb            | Rembong                                     | 
| ree            | Rejang Kayan                                | 
| reg            | Kara (Tanzania)                             | 
| rei            | Reli                                        | 
| rej            | Rejang                                      | 
| rel            | Rendille                                    | 
| rem            | Remo                                        | 
| ren            | Rengao                                      | 
| res            | Reshe                                       | 
| ret            | Retta                                       | 
| rey            | Reyesano                                    | 
| rga            | Roria                                       | 
| rge            | Romano-Greek                                | 
| rgk            | Rangkas                                     | 
| rgn            | Romagnol                                    | 
| rgr            | Resígaro                                    | 
| rgs            | Southern Roglai                             | 
| rgu            | Ringgou                                     | 
| rhg            | Rohingya                                    | 
| rhp            | Yahang                                      | 
| ria            | Riang (India)                               | 
| rif            | Tarifit                                     | 
| ril            | Riang Lang                                  | 
| rim            | Nyaturu                                     | 
| rin            | Nungu                                       | 
| rir            | Ribun                                       | 
| rit            | Ritharrngu                                  | 
| riu            | Riung                                       | 
| rjg            | Rajong                                      | 
| rji            | Raji                                        | 
| rjs            | Rajbanshi                                   | 
| rka            | Kraol                                       | 
| rkb            | Rikbaktsa                                   | 
| rkh            | Rakahanga-Manihiki                          | 
| rki            | Rakhine                                     | 
| rkm            | Marka                                       | 
| rkt            | Rangpuri                                    | 
| rma            | Rama                                        | 
| rmb            | Rembarrnga                                  | 
| rmc            | Carpathian Romani                           | 
| rme            | Angloromani                                 | 
| rmf            | Kalo Finnish Romani                         | 
| rmh            | Murkim                                      | 
| rmi            | Lomavren                                    | 
| rmk            | Romkun                                      | 
| rml            | Baltic Romani                               | 
| rmm            | Roma                                        | 
| rmn            | Balkan Romani                               | 
| rmo            | Sinte Romani                                | 
| rmp            | Rempi                                       | 
| rmq            | Caló                                        | 
| rmt            | Domari                                      | 
| rmw            | Welsh Romani                                | 
| rmx            | Romam                                       | 
| rmy            | Vlax Romani                                 | 
| rmz            | Marma                                       | 
| rnd            | Ruund                                       | 
| rng            | Ronga                                       | 
| rnl            | Ranglong                                    | 
| rnn            | Roon                                        | 
| rnp            | Rongpo                                      | 
| rnr            | Nari Nari                                   | 
| rnw            | Rungwa                                      | 
| rob            | Tae'                                        | 
| roc            | Cacgia Roglai                               | 
| rod            | Rogo                                        | 
| roe            | Ronji                                       | 
| rof            | Rombo                                       | 
| rog            | Northern Roglai                             | 
| roh            | Romansh                                     | 
| rol            | Romblomanon                                 | 
| ron            | Romanian                                    | 
| roo            | Rotokas                                     | 
| rop            | Kriol                                       | 
| ror            | Rongga                                      | 
| rou            | Runga                                       | 
| row            | Dela-Oenale                                 | 
| rpn            | Repanbitip                                  | 
| rpt            | Rapting                                     | 
| rri            | Ririo                                       | 
| rro            | Waima                                       | 
| rth            | Ratahan                                     | 
| rtm            | Rotuman                                     | 
| rtw            | Rathawi                                     | 
| rub            | Gungu                                       | 
| ruc            | Ruuli                                       | 
| rue            | Rusyn                                       | 
| ruf            | Luguru                                      | 
| rug            | Roviana                                     | 
| ruh            | Ruga                                        | 
| ruk            | Che                                         | 
| run            | Rundi                                       | 
| ruo            | Istro Romanian                              | 
| rup            | Macedo-Romanian                             | 
| ruq            | Megleno Romanian                            | 
| rus            | Russian                                     | 
| rut            | Rutul                                       | 
| ruu            | Lanas Lobu                                  | 
| rwa            | Rawo                                        | 
| rwk            | Rwa                                         | 
| rwm            | Amba (Uganda)                               | 
| rwo            | Rawa                                        | 
| rwr            | Marwari (India)                             | 
| rxd            | Ngardi                                      | 
| rxw            | Karuwali                                    | 
| ryn            | Northern Amami-Oshima                       | 
| rys            | Yaeyama                                     | 
| ryu            | Central Okinawan                            | 
| rzh            | Rāziḥī                                      | 
| saa            | Saba                                        | 
| sab            | Buglere                                     | 
| sac            | Meskwaki                                    | 
| sad            | Sandawe                                     | 
| sae            | Sabanê                                      | 
| saf            | Safaliba                                    | 
| sag            | Sango                                       | 
| sah            | Yakut                                       | 
| saj            | Sahu                                        | 
| sak            | Sake                                        | 
| sam            | Samaritan Aramaic                           | 
| san            | Sanskrit                                    | 
| sao            | Sause                                       | 
| saq            | Samburu                                     | 
| sar            | Saraveca                                    | 
| sas            | Sasak                                       | 
| sat            | Santali                                     | 
| sau            | Saleman                                     | 
| sav            | Saafi-Saafi                                 | 
| saw            | Sawi                                        | 
| sax            | Sa                                          | 
| say            | Saya                                        | 
| saz            | Saurashtra                                  | 
| sba            | Ngambay                                     | 
| sbb            | Simbo                                       | 
| sbc            | Kele (Papua New Guinea)                     | 
| sbd            | Southern Samo                               | 
| sbe            | Saliba                                      | 
| sbf            | Shabo                                       | 
| sbg            | Seget                                       | 
| sbh            | Sori-Harengan                               | 
| sbi            | Seti                                        | 
| sbj            | Surbakhal                                   | 
| sbk            | Safwa                                       | 
| sbl            | Botolan Sambal                              | 
| sbm            | Sagala                                      | 
| sbn            | Sindhi Bhil                                 | 
| sbo            | Sabüm                                       | 
| sbp            | Sangu (Tanzania)                            | 
| sbq            | Sileibi                                     | 
| sbr            | Sembakung Murut                             | 
| sbs            | Subiya                                      | 
| sbt            | Kimki                                       | 
| sbu            | Stod Bhoti                                  | 
| sbw            | Simba                                       | 
| sbx            | Seberuang                                   | 
| sby            | Soli                                        | 
| sbz            | Sara Kaba                                   | 
| scb            | Chut                                        | 
| sce            | Dongxiang                                   | 
| scf            | San Miguel Creole French                    | 
| scg            | Sanggau                                     | 
| sch            | Sakachep                                    | 
| sci            | Sri Lankan Creole Malay                     | 
| sck            | Sadri                                       | 
| scl            | Shina                                       | 
| scn            | Sicilian                                    | 
| sco            | Scots                                       | 
| scp            | Hyolmo                                      | 
| scq            | Sa'och                                      | 
| scs            | North Slavey                                | 
| sct            | Southern Katang                             | 
| scu            | Shumcho                                     | 
| scv            | Sheni                                       | 
| scw            | Sha                                         | 
| sda            | Toraja-Sa'dan                               | 
| sdb            | Shabak                                      | 
| sdc            | Sassarese Sardinian                         | 
| sde            | Surubu                                      | 
| sdf            | Sarli                                       | 
| sdg            | Savi                                        | 
| sdh            | Southern Kurdish                            | 
| sdj            | Suundi                                      | 
| sdk            | Sos Kundi                                   | 
| sdn            | Gallurese Sardinian                         | 
| sdo            | Bukar-Sadung Bidayuh                        | 
| sdp            | Sherdukpen                                  | 
| sdr            | Oraon Sadri                                 | 
| sds            | Sened                                       | 
| sdu            | Sarudu                                      | 
| sdx            | Sibu Melanau                                | 
| sdz            | Sallands                                    | 
| sea            | Semai                                       | 
| seb            | Shempire Senoufo                            | 
| sec            | Sechelt                                     | 
| sed            | Sedang                                      | 
| see            | Seneca                                      | 
| sef            | Cebaara Senoufo                             | 
| seg            | Segeju                                      | 
| seh            | Sena                                        | 
| sei            | Seri                                        | 
| sej            | Sene                                        | 
| sek            | Sekani                                      | 
| sel            | Selkup                                      | 
| sen            | Nanerigé Sénoufo                            | 
| seo            | Suarmin                                     | 
| sep            | Sìcìté Sénoufo                              | 
| seq            | Senara Sénoufo                              | 
| ser            | Serrano                                     | 
| ses            | Koyraboro Senni Songhai                     | 
| set            | Sentani                                     | 
| seu            | Serui-Laut                                  | 
| sev            | Nyarafolo Senoufo                           | 
| sew            | Sewa Bay                                    | 
| sey            | Secoya                                      | 
| sez            | Senthang Chin                               | 
| sfe            | Eastern Subanen                             | 
| sfm            | Small Flowery Miao                          | 
| sfw            | Sehwi                                       | 
| sga            | Old Irish (to 900)                          | 
| sgb            | Mag-antsi Ayta                              | 
| sgc            | Kipsigis                                    | 
| sgd            | Surigaonon                                  | 
| sge            | Segai                                       | 
| sgh            | Shughni                                     | 
| sgi            | Suga                                        | 
| sgk            | Sangkong                                    | 
| sgm            | Singa                                       | 
| sgp            | Singpho                                     | 
| sgr            | Sangisari                                   | 
| sgt            | Brokpake                                    | 
| sgu            | Salas                                       | 
| sgw            | Sebat Bet Gurage                            | 
| sgy            | Sanglechi                                   | 
| sgz            | Sursurunga                                  | 
| sha            | Shall-Zwall                                 | 
| shb            | Ninam                                       | 
| shc            | Sonde                                       | 
| shd            | Kundal Shahi                                | 
| she            | Sheko                                       | 
| shg            | Shua                                        | 
| shh            | Shoshoni                                    | 
| shi            | Tachelhit                                   | 
| shj            | Shatt                                       | 
| shk            | Shilluk                                     | 
| shl            | Shendu                                      | 
| shm            | Shahrudi                                    | 
| shn            | Shan                                        | 
| sho            | Shanga                                      | 
| shp            | Shipibo-Conibo                              | 
| shq            | Sala                                        | 
| shr            | Shi                                         | 
| shs            | Shuswap                                     | 
| sht            | Shasta                                      | 
| shu            | Chadian Arabic                              | 
| shv            | Shehri                                      | 
| shw            | Shwai                                       | 
| shx            | She                                         | 
| shy            | Tachawit                                    | 
| shz            | Syenara Senoufo                             | 
| sia            | Akkala Sami                                 | 
| sib            | Sebop                                       | 
| sid            | Sidamo                                      | 
| sie            | Simaa                                       | 
| sif            | Siamou                                      | 
| sig            | Paasaal                                     | 
| sih            | Zire                                        | 
| sii            | Shom Peng                                   | 
| sij            | Numbami                                     | 
| sil            | Tumulung Sisaala                            | 
| sim            | Mende (Papua New Guinea)                    | 
| sin            | Sinhalese                                   | 
| sip            | Sikkimese                                   | 
| siq            | Sonia                                       | 
| sir            | Siri                                        | 
| sis            | Siuslaw                                     | 
| siu            | Sinagen                                     | 
| siv            | Sumariup                                    | 
| siw            | Siwai                                       | 
| six            | Sumau                                       | 
| siy            | Sivandi                                     | 
| siz            | Siwi                                        | 
| sja            | Epena                                       | 
| sjb            | Sajau Basap                                 | 
| sjd            | Kildin Sami                                 | 
| sje            | Pite Sami                                   | 
| sjg            | Assangori                                   | 
| sjk            | Kemi Sami                                   | 
| sjl            | Sajalong                                    | 
| sjm            | Mapun                                       | 
| sjo            | Xibe                                        | 
| sjp            | Surjapuri                                   | 
| sjr            | Siar-Lak                                    | 
| sjs            | Senhaja De Srair                            | 
| sjt            | Ter Sami                                    | 
| sju            | Ume Sami                                    | 
| sjw            | Shawnee                                     | 
| ska            | Skagit                                      | 
| skb            | Saek                                        | 
| skc            | Ma Manda                                    | 
| skd            | Southern Sierra Miwok                       | 
| ske            | Seke (Vanuatu)                              | 
| skf            | Sakirabiá                                   | 
| skg            | Sakalava Malagasy                           | 
| skh            | Sikule                                      | 
| ski            | Sika                                        | 
| skj            | Seke (Nepal)                                | 
| skm            | Kutong                                      | 
| skn            | Kolibugan Subanon                           | 
| sko            | Seko Tengah                                 | 
| skp            | Sekapan                                     | 
| skq            | Sininkere                                   | 
| skr            | Seraiki                                     | 
| sks            | Maia                                        | 
| skt            | Sakata                                      | 
| sku            | Sakao                                       | 
| skv            | Skou                                        | 
| skw            | Skepi Creole Dutch                          | 
| skx            | Seko Padang                                 | 
| sky            | Sikaiana                                    | 
| skz            | Sekar                                       | 
| slc            | Sáliba                                      | 
| sld            | Sissala                                     | 
| sle            | Sholaga                                     | 
| slg            | Selungai Murut                              | 
| slh            | Southern Puget Sound Salish                 | 
| sli            | Lower Silesian                              | 
| slk            | Slovak                                      | 
| sll            | Salt-Yui                                    | 
| slm            | Pangutaran Sama                             | 
| sln            | Salinan                                     | 
| slp            | Lamaholot                                   | 
| slq            | Salchuq                                     | 
| slr            | Salar                                       | 
| slt            | Sila                                        | 
| slu            | Selaru                                      | 
| slv            | Slovenian                                   | 
| slw            | Sialum                                      | 
| slx            | Salampasu                                   | 
| sly            | Selayar                                     | 
| slz            | Ma'ya                                       | 
| sma            | Southern Sami                               | 
| smb            | Simbari                                     | 
| smc            | Som                                         | 
| smd            | Sama                                        | 
| sme            | Northern Sami                               | 
| smf            | Auwe                                        | 
| smg            | Simbali                                     | 
| smh            | Samei                                       | 
| smj            | Lule Saami                                  | 
| smk            | Bolinao                                     | 
| sml            | Central Sama                                | 
| smm            | Musasa                                      | 
| smn            | Inari Sami                                  | 
| smo            | Samoan                                      | 
| smp            | Samaritan                                   | 
| smq            | Samo                                        | 
| smr            | Simeulue                                    | 
| sms            | Skolt Sami                                  | 
| smt            | Simte                                       | 
| smu            | Somray                                      | 
| smv            | Samvedi                                     | 
| smw            | Sumbawa                                     | 
| smx            | Samba                                       | 
| smy            | Semnani                                     | 
| smz            | Simeku                                      | 
| sna            | Shona                                       | 
| snb            | Sebuyau                                     | 
| snc            | Sinaugoro                                   | 
| snd            | Sindhi                                      | 
| sne            | Bau Bidayuh                                 | 
| snf            | Noon                                        | 
| sng            | Sanga (Democratic Republic of Congo)        | 
| sni            | Sensi                                       | 
| snj            | Riverain Sango                              | 
| snk            | Soninke                                     | 
| snl            | Sangil                                      | 
| snm            | Southern Ma'di                              | 
| snn            | Siona                                       | 
| sno            | Snohomish                                   | 
| snp            | Siane                                       | 
| snq            | Sangu (Gabon)                               | 
| snr            | Sihan                                       | 
| sns            | South West Bay                              | 
| snu            | Viid                                        | 
| snv            | Sa'ban                                      | 
| snw            | Selee                                       | 
| snx            | Sam                                         | 
| sny            | Saniyo-Hiyewe                               | 
| snz            | Kou                                         | 
| soa            | Thai Song                                   | 
| sob            | Sobei                                       | 
| soc            | So (Democratic Republic of Congo)           | 
| sod            | Songoora                                    | 
| soe            | Songomeno                                   | 
| sog            | Sogdian                                     | 
| soh            | Aka                                         | 
| soi            | Sonha                                       | 
| soj            | Soi                                         | 
| sok            | Sokoro                                      | 
| sol            | Solos                                       | 
| som            | Somali                                      | 
| soo            | Songo                                       | 
| sop            | Songe                                       | 
| soq            | Kanasi                                      | 
| sor            | Somrai                                      | 
| sos            | Seeku                                       | 
| sot            | Southern Sotho                              | 
| sou            | Southern Thai                               | 
| sov            | Sonsorol                                    | 
| sow            | Sowanda                                     | 
| sox            | Swo                                         | 
| soy            | Miyobe                                      | 
| soz            | Temi                                        | 
| spa            | Spanish                                     | 
| spb            | Sepa (Indonesia)                            | 
| spc            | Sapé                                        | 
| spd            | Saep                                        | 
| spe            | Sepa (Papua New Guinea)                     | 
| spg            | Sian                                        | 
| spi            | Saponi                                      | 
| spk            | Sengo                                       | 
| spl            | Selepet                                     | 
| spm            | Akukem                                      | 
| spn            | Sanapaná                                    | 
| spo            | Spokane                                     | 
| spp            | Supyire Senoufo                             | 
| spq            | Loreto-Ucayali Spanish                      | 
| spr            | Saparua                                     | 
| sps            | Saposa                                      | 
| spt            | Spiti Bhoti                                 | 
| spu            | Sapuan                                      | 
| spv            | Sambalpuri                                  | 
| spy            | Sabaot                                      | 
| sqa            | Shama-Sambuga                               | 
| sqh            | Shau                                        | 
| sqm            | Suma                                        | 
| sqn            | Susquehannock                               | 
| sqo            | Sorkhei                                     | 
| sqq            | Sou                                         | 
| sqt            | Soqotri                                     | 
| squ            | Squamish                                    | 
| sra            | Saruga                                      | 
| srb            | Sora                                        | 
| src            | Logudorese Sardinian                        | 
| sre            | Sara                                        | 
| srf            | Nafi                                        | 
| srg            | Sulod                                       | 
| srh            | Sarikoli                                    | 
| sri            | Siriano                                     | 
| srk            | Serudung Murut                              | 
| srl            | Isirawa                                     | 
| srm            | Saramaccan                                  | 
| srn            | Sranan Tongo                                | 
| sro            | Campidanese Sardinian                       | 
| srp            | Serbian                                     | 
| srq            | Sirionó                                     | 
| srr            | Serer                                       | 
| srs            | Sarsi                                       | 
| srt            | Sauri                                       | 
| sru            | Suruí                                       | 
| srv            | Southern Sorsoganon                         | 
| srw            | Serua                                       | 
| srx            | Sirmauri                                    | 
| sry            | Sera                                        | 
| srz            | Shahmirzadi                                 | 
| ssb            | Southern Sama                               | 
| ssc            | Suba-Simbiti                                | 
| ssd            | Siroi                                       | 
| sse            | Bangingih Sama                              | 
| ssf            | Thao                                        | 
| ssg            | Seimat                                      | 
| ssh            | Shihhi Arabic                               | 
| ssi            | Sansi                                       | 
| ssj            | Sausi                                       | 
| ssk            | Sunam                                       | 
| ssl            | Western Sisaala                             | 
| ssm            | Semnam                                      | 
| ssn            | Waata                                       | 
| sso            | Sissano                                     | 
| ssq            | So'a                                        | 
| sss            | Sô                                          | 
| sst            | Sinasina                                    | 
| ssu            | Susuami                                     | 
| ssv            | Shark Bay                                   | 
| ssw            | Swati                                       | 
| ssx            | Samberigi                                   | 
| ssy            | Saho                                        | 
| ssz            | Sengseng                                    | 
| stb            | Northern Subanen                            | 
| ste            | Liana-Seti                                  | 
| stf            | Seta                                        | 
| stg            | Trieng                                      | 
| sti            | Bulo Stieng                                 | 
| stj            | Matya Samo                                  | 
| stk            | Arammba                                     | 
| stl            | Stellingwerfs                               | 
| stm            | Setaman                                     | 
| stn            | Owa                                         | 
| sto            | Stoney                                      | 
| stp            | Southeastern Tepehuan                       | 
| stq            | Saterfriesisch                              | 
| str            | Straits Salish                              | 
| sts            | Shumashti                                   | 
| stt            | Budeh Stieng                                | 
| stu            | Samtao                                      | 
| stv            | Silt'e                                      | 
| stw            | Satawalese                                  | 
| sty            | Siberian Tatar                              | 
| sua            | Sulka                                       | 
| sub            | Suku                                        | 
| suc            | Western Subanon                             | 
| sue            | Suena                                       | 
| sug            | Suganga                                     | 
| sui            | Suki                                        | 
| suj            | Shubi                                       | 
| suk            | Sukuma                                      | 
| sun            | Sundanese                                   | 
| suo            | Bouni                                       | 
| suq            | Tirmaga-Chai Suri                           | 
| sur            | Mwaghavul                                   | 
| sus            | Susu                                        | 
| sut            | Subtiaba                                    | 
| suv            | Puroik                                      | 
| suw            | Sumbwa                                      | 
| sux            | Sumerian                                    | 
| suy            | Suyá                                        | 
| suz            | Sunwar                                      | 
| sva            | Svan                                        | 
| svb            | Ulau-Suain                                  | 
| svc            | Vincentian Creole English                   | 
| sve            | Serili                                      | 
| svm            | Slavomolisano                               | 
| svs            | Savosavo                                    | 
| swb            | Maore Comorian                              | 
| swc            | Congo Swahili                               | 
| swe            | Swedish                                     | 
| swf            | Sere                                        | 
| swg            | Swabian                                     | 
| swh            | Swahili                                     | 
| swi            | Sui                                         | 
| swj            | Sira                                        | 
| swk            | Malawi Sena                                 | 
| swm            | Samosa                                      | 
| swn            | Sawknah                                     | 
| swo            | Shanenawa                                   | 
| swp            | Suau                                        | 
| swq            | Sharwa                                      | 
| swr            | Saweru                                      | 
| sws            | Seluwasan                                   | 
| swt            | Sawila                                      | 
| swu            | Suwawa                                      | 
| swv            | Shekhawati                                  | 
| sww            | Sowa                                        | 
| swx            | Suruahá                                     | 
| swy            | Sarua                                       | 
| sxb            | Suba                                        | 
| sxe            | Sighu                                       | 
| sxg            | Shuhi                                       | 
| sxk            | Southern Kalapuya                           | 
| sxn            | Sangir                                      | 
| sxr            | Saaroa                                      | 
| sxs            | Sasaru                                      | 
| sxu            | Upper Saxon                                 | 
| sxw            | Saxwe Gbe                                   | 
| sya            | Siang                                       | 
| syb            | Central Subanen                             | 
| syc            | Classical Syriac                            | 
| syi            | Seki                                        | 
| syk            | Sukur                                       | 
| syl            | Sylheti                                     | 
| sym            | Maya Samo                                   | 
| syn            | Senaya                                      | 
| syo            | Suoy                                        | 
| sys            | Sinyar                                      | 
| syw            | Kagate                                      | 
| syx            | Samay                                       | 
| sza            | Semelai                                     | 
| szb            | Ngalum                                      | 
| szc            | Semaq Beri                                  | 
| sze            | Seze                                        | 
| szg            | Sengele                                     | 
| szl            | Silesian                                    | 
| szn            | Sula                                        | 
| szp            | Suabo                                       | 
| szv            | Isu (Fako Division)                         | 
| szw            | Sawai                                       | 
| szy            | Sakizaya                                    | 
| taa            | Lower Tanana                                | 
| tab            | Tabassaran                                  | 
| tac            | Lowland Tarahumara                          | 
| tad            | Tause                                       | 
| tae            | Tariana                                     | 
| taf            | Tapirapé                                    | 
| tag            | Tagoi                                       | 
| tah            | Tahitian                                    | 
| taj            | Eastern Tamang                              | 
| tak            | Tala                                        | 
| tal            | Tal                                         | 
| tam            | Tamil                                       | 
| tan            | Tangale                                     | 
| tao            | Yami                                        | 
| tap            | Taabwa                                      | 
| taq            | Tamasheq                                    | 
| tar            | Central Tarahumara                          | 
| tat            | Tatar                                       | 
| tau            | Upper Tanana                                | 
| tav            | Tatuyo                                      | 
| taw            | Tai                                         | 
| tax            | Tamki                                       | 
| tay            | Atayal                                      | 
| taz            | Tocho                                       | 
| tba            | Aikanã                                      | 
| tbc            | Takia                                       | 
| tbd            | Kaki Ae                                     | 
| tbe            | Tanimbili                                   | 
| tbf            | Mandara                                     | 
| tbg            | North Tairora                               | 
| tbh            | Thurawal                                    | 
| tbi            | Gaam                                        | 
| tbj            | Tiang                                       | 
| tbk            | Calamian Tagbanwa                           | 
| tbl            | Tboli                                       | 
| tbm            | Tagbu                                       | 
| tbn            | Barro Negro Tunebo                          | 
| tbo            | Tawala                                      | 
| tbp            | Taworta                                     | 
| tbr            | Tumtum                                      | 
| tbs            | Tanguat                                     | 
| tbt            | Tembo (Kitembo)                             | 
| tbu            | Tubar                                       | 
| tbv            | Tobo                                        | 
| tbw            | Tagbanwa                                    | 
| tbx            | Kapin                                       | 
| tby            | Tabaru                                      | 
| tbz            | Ditammari                                   | 
| tca            | Ticuna                                      | 
| tcb            | Tanacross                                   | 
| tcc            | Datooga                                     | 
| tcd            | Tafi                                        | 
| tce            | Southern Tutchone                           | 
| tcf            | Malinaltepec Tlapanec                       | 
| tcg            | Tamagario                                   | 
| tch            | Turks And Caicos Creole English             | 
| tci            | Wára                                        | 
| tck            | Tchitchege                                  | 
| tcl            | Taman (Myanmar)                             | 
| tcm            | Tanahmerah                                  | 
| tcn            | Tichurong                                   | 
| tco            | Taungyo                                     | 
| tcp            | Tawr Chin                                   | 
| tcq            | Kaiy                                        | 
| tcs            | Yumplatok                                   | 
| tct            | T'en                                        | 
| tcu            | Southeastern Tarahumara                     | 
| tcw            | Tecpatlán Totonac                           | 
| tcx            | Toda                                        | 
| tcy            | Tulu                                        | 
| tcz            | Thado Chin                                  | 
| tda            | Tagdal                                      | 
| tdb            | Panchpargania                               | 
| tdc            | Emberá-Tadó                                 | 
| tdd            | Tai Nüa                                     | 
| tde            | Tiranige Diga Dogon                         | 
| tdf            | Talieng                                     | 
| tdg            | Western Tamang                              | 
| tdh            | Thulung                                     | 
| tdi            | Tomadino                                    | 
| tdj            | Tajio                                       | 
| tdk            | Tambas                                      | 
| tdl            | Sur                                         | 
| tdm            | Taruma                                      | 
| tdn            | Tondano                                     | 
| tdo            | Teme                                        | 
| tdq            | Tita                                        | 
| tdr            | Todrah                                      | 
| tds            | Doutai                                      | 
| tdt            | Tetun Dili                                  | 
| tdv            | Toro                                        | 
| tdx            | Tandroy-Mahafaly Malagasy                   | 
| tdy            | Tadyawan                                    | 
| tea            | Temiar                                      | 
| tec            | Terik                                       | 
| ted            | Tepo Krumen                                 | 
| tee            | Huehuetla Tepehua                           | 
| tef            | Teressa                                     | 
| teg            | Teke-Tege                                   | 
| teh            | Tehuelche                                   | 
| tei            | Torricelli                                  | 
| tek            | Ibali Teke                                  | 
| tel            | Telugu                                      | 
| tem            | Timne                                       | 
| ten            | Tama (Colombia)                             | 
| teo            | Teso                                        | 
| tep            | Tepecano                                    | 
| teq            | Temein                                      | 
| ter            | Tereno                                      | 
| tes            | Tengger                                     | 
| tet            | Tetum                                       | 
| teu            | Soo                                         | 
| tev            | Teor                                        | 
| tew            | Tewa (USA)                                  | 
| tex            | Tennet                                      | 
| tey            | Tulishi                                     | 
| tez            | Tetserret                                   | 
| tfi            | Tofin Gbe                                   | 
| tfn            | Tanaina                                     | 
| tfo            | Tefaro                                      | 
| tfr            | Teribe                                      | 
| tft            | Ternate                                     | 
| tga            | Sagalla                                     | 
| tgb            | Tobilung                                    | 
| tgc            | Tigak                                       | 
| tgd            | Ciwogai                                     | 
| tge            | Eastern Gorkha Tamang                       | 
| tgf            | Chalikha                                    | 
| tgh            | Tobagonian Creole English                   | 
| tgi            | Lawunuia                                    | 
| tgj            | Tagin                                       | 
| tgk            | Tajik                                       | 
| tgl            | Tagalog                                     | 
| tgn            | Tandaganon                                  | 
| tgo            | Sudest                                      | 
| tgp            | Tangoa                                      | 
| tgq            | Tring                                       | 
| tgs            | Nume                                        | 
| tgt            | Central Tagbanwa                            | 
| tgu            | Tanggu                                      | 
| tgw            | Tagwana Senoufo                             | 
| tgx            | Tagish                                      | 
| tgy            | Togoyo                                      | 
| tgz            | Tagalaka                                    | 
| tha            | Thai                                        | 
| thd            | Thayore                                     | 
| the            | Chitwania Tharu                             | 
| thf            | Thangmi                                     | 
| thh            | Northern Tarahumara                         | 
| thi            | Tai Long                                    | 
| thk            | Tharaka                                     | 
| thl            | Dangaura Tharu                              | 
| thm            | Aheu                                        | 
| thn            | Thachanadan                                 | 
| thp            | Thompson                                    | 
| thq            | Kochila Tharu                               | 
| thr            | Rana Tharu                                  | 
| ths            | Thakali                                     | 
| tht            | Tahltan                                     | 
| thu            | Thuri                                       | 
| thv            | Tahaggart Tamahaq                           | 
| thy            | Tha                                         | 
| thz            | Tayart Tamajeq                              | 
| tia            | Tidikelt Tamazight                          | 
| tic            | Tira                                        | 
| tif            | Tifal                                       | 
| tig            | Tigre                                       | 
| tih            | Timugon Murut                               | 
| tii            | Tiene                                       | 
| tij            | Tilung                                      | 
| tik            | Tikar                                       | 
| til            | Tillamook                                   | 
| tim            | Timbe                                       | 
| tin            | Tindi                                       | 
| tio            | Teop                                        | 
| tip            | Trimuris                                    | 
| tiq            | Tiéfo                                       | 
| tir            | Tigrinya                                    | 
| tis            | Masadiit Itneg                              | 
| tit            | Tinigua                                     | 
| tiu            | Adasen                                      | 
| tiv            | Tiv                                         | 
| tiw            | Tiwi                                        | 
| tix            | Southern Tiwa                               | 
| tiy            | Tiruray                                     | 
| tiz            | Tai Hongjin                                 | 
| tja            | Tajuasohn                                   | 
| tjg            | Tunjung                                     | 
| tji            | Northern Tujia                              | 
| tjj            | Tjungundji                                  | 
| tjl            | Tai Laing                                   | 
| tjm            | Timucua                                     | 
| tjn            | Tonjon                                      | 
| tjo            | Temacine Tamazight                          | 
| tjp            | Tjupany                                     | 
| tjs            | Southern Tujia                              | 
| tju            | Tjurruru                                    | 
| tkb            | Buksa                                       | 
| tkd            | Tukudede                                    | 
| tke            | Takwane                                     | 
| tkg            | Tesaka Malagasy                             | 
| tkl            | Tokelau                                     | 
| tkm            | Takelma                                     | 
| tkn            | Toku-No-Shima                               | 
| tkp            | Tikopia                                     | 
| tkq            | Tee                                         | 
| tkr            | Tsakhur                                     | 
| tks            | Takestani                                   | 
| tkt            | Kathoriya Tharu                             | 
| tku            | Upper Necaxa Totonac                        | 
| tkv            | Mur Pano                                    | 
| tkw            | Teanu                                       | 
| tkx            | Tangko                                      | 
| tkz            | Takua                                       | 
| tla            | Southwestern Tepehuan                       | 
| tlb            | Tobelo                                      | 
| tlc            | Yecuatla Totonac                            | 
| tld            | Talaud                                      | 
| tlf            | Telefol                                     | 
| tlg            | Tofanma                                     | 
| tli            | Tlingit                                     | 
| tlj            | Talinga-Bwisi                               | 
| tlk            | Taloki                                      | 
| tll            | Tetela                                      | 
| tlm            | Tolomako                                    | 
| tln            | Talondo'                                    | 
| tlo            | Talodi                                      | 
| tlp            | Filomena Mata-Coahuitlán Totonac            | 
| tlq            | Tai Loi                                     | 
| tlr            | Talise                                      | 
| tls            | Tambotalo                                   | 
| tlt            | Teluti                                      | 
| tlu            | Tulehu                                      | 
| tlv            | Taliabu                                     | 
| tlx            | Khehek                                      | 
| tly            | Talysh                                      | 
| tma            | Tama (Chad)                                 | 
| tmb            | Katbol                                      | 
| tmc            | Tumak                                       | 
| tmd            | Haruai                                      | 
| tmf            | Toba-Maskoy                                 | 
| tmg            | Ternateño                                   | 
| tmi            | Tutuba                                      | 
| tmj            | Samarokena                                  | 
| tml            | Tamnim Citak                                | 
| tmm            | Tai Thanh                                   | 
| tmn            | Taman (Indonesia)                           | 
| tmo            | Temoq                                       | 
| tmq            | Tumleo                                      | 
| tmr            | Jewish Babylonian Aramaic (ca. 200-1200 CE) | 
| tms            | Tima                                        | 
| tmt            | Tasmate                                     | 
| tmu            | Iau                                         | 
| tmv            | Tembo (Motembo)                             | 
| tmw            | Temuan                                      | 
| tmy            | Tami                                        | 
| tmz            | Tamanaku                                    | 
| tna            | Tacana                                      | 
| tnb            | Western Tunebo                              | 
| tnc            | Tanimuca-Retuarã                            | 
| tnd            | Angosturas Tunebo                           | 
| tng            | Tobanga                                     | 
| tnh            | Maiani                                      | 
| tni            | Tandia                                      | 
| tnk            | Kwamera                                     | 
| tnl            | Lenakel                                     | 
| tnm            | Tabla                                       | 
| tnn            | North Tanna                                 | 
| tno            | Toromono                                    | 
| tnp            | Whitesands                                  | 
| tnq            | Taino                                       | 
| tnr            | Ménik                                       | 
| tns            | Tenis                                       | 
| tnt            | Tontemboan                                  | 
| tnu            | Tay Khang                                   | 
| tnv            | Tangchangya                                 | 
| tnw            | Tonsawang                                   | 
| tnx            | Tanema                                      | 
| tny            | Tongwe                                      | 
| tnz            | Ten'edn                                     | 
| tob            | Toba                                        | 
| toc            | Coyutla Totonac                             | 
| tod            | Toma                                        | 
| tof            | Gizrra                                      | 
| tog            | Tonga (Nyasa)                               | 
| toh            | Gitonga                                     | 
| toi            | Tonga (Zambia)                              | 
| toj            | Tojolabal                                   | 
| tol            | Tolowa                                      | 
| tom            | Tombulu                                     | 
| ton            | Tonga (Tonga Islands)                       | 
| too            | Xicotepec De Juárez Totonac                 | 
| top            | Papantla Totonac                            | 
| toq            | Toposa                                      | 
| tor            | Togbo-Vara Banda                            | 
| tos            | Highland Totonac                            | 
| tou            | Tho                                         | 
| tov            | Upper Taromi                                | 
| tow            | Jemez                                       | 
| tox            | Tobian                                      | 
| toy            | Topoiyo                                     | 
| toz            | To                                          | 
| tpa            | Taupota                                     | 
| tpc            | Azoyú Tlapanec                              | 
| tpe            | Tippera                                     | 
| tpf            | Tarpia                                      | 
| tpg            | Kula                                        | 
| tpi            | Tok Pisin                                   | 
| tpj            | Tapieté                                     | 
| tpk            | Tupinikin                                   | 
| tpl            | Tlacoapa Tlapanec                           | 
| tpm            | Tampulma                                    | 
| tpn            | Tupinambá                                   | 
| tpo            | Tai Pao                                     | 
| tpp            | Pisaflores Tepehua                          | 
| tpq            | Tukpa                                       | 
| tpr            | Tuparí                                      | 
| tpt            | Tlachichilco Tepehua                        | 
| tpu            | Tampuan                                     | 
| tpv            | Tanapag                                     | 
| tpw            | Tupí                                        | 
| tpx            | Acatepec Tlapanec                           | 
| tpy            | Trumai                                      | 
| tpz            | Tinputz                                     | 
| tqb            | Tembé                                       | 
| tql            | Lehali                                      | 
| tqm            | Turumsa                                     | 
| tqn            | Tenino                                      | 
| tqo            | Toaripi                                     | 
| tqp            | Tomoip                                      | 
| tqq            | Tunni                                       | 
| tqr            | Torona                                      | 
| tqt            | Western Totonac                             | 
| tqu            | Touo                                        | 
| tqw            | Tonkawa                                     | 
| tra            | Tirahi                                      | 
| trb            | Terebu                                      | 
| trc            | Copala Triqui                               | 
| trd            | Turi                                        | 
| tre            | East Tarangan                               | 
| trf            | Trinidadian Creole English                  | 
| trg            | Lishán Didán                                | 
| trh            | Turaka                                      | 
| tri            | Trió                                        | 
| trj            | Toram                                       | 
| trm            | Tregami                                     | 
| trn            | Trinitario                                  | 
| tro            | Tarao Naga                                  | 
| trp            | Kok Borok                                   | 
| trq            | San Martín Itunyoso Triqui                  | 
| trr            | Taushiro                                    | 
| trs            | Chicahuaxtla Triqui                         | 
| trt            | Tunggare                                    | 
| tru            | Turoyo                                      | 
| trv            | Taroko                                      | 
| trw            | Torwali                                     | 
| trx            | Tringgus-Sembaan Bidayuh                    | 
| try            | Turung                                      | 
| trz            | Torá                                        | 
| tsa            | Tsaangi                                     | 
| tsb            | Tsamai                                      | 
| tsc            | Tswa                                        | 
| tsd            | Tsakonian                                   | 
| tsg            | Tausug                                      | 
| tsh            | Tsuvan                                      | 
| tsi            | Tsimshian                                   | 
| tsj            | Tshangla                                    | 
| tsk            | Tseku                                       | 
| tsl            | Ts'ün-Lao                                   | 
| tsn            | Setswana                                    | 
| tso            | Tsonga                                      | 
| tsp            | Northern Toussian                           | 
| tsr            | Akei                                        | 
| tst            | Tondi Songway Kiini                         | 
| tsu            | Tsou                                        | 
| tsv            | Tsogo                                       | 
| tsw            | Tsishingini                                 | 
| tsx            | Mubami                                      | 
| tsz            | Purepecha                                   | 
| tta            | Tutelo                                      | 
| ttb            | Gaa                                         | 
| ttc            | Tektiteko                                   | 
| ttd            | Tauade                                      | 
| tte            | Bwanabwana                                  | 
| ttf            | Tuotomb                                     | 
| ttg            | Tutong                                      | 
| tth            | Upper Ta'oih                                | 
| tti            | Tobati                                      | 
| ttj            | Tooro                                       | 
| ttk            | Totoro                                      | 
| ttl            | Totela                                      | 
| ttm            | Northern Tutchone                           | 
| ttn            | Towei                                       | 
| tto            | Lower Ta'oih                                | 
| ttp            | Tombelala                                   | 
| ttq            | Tawallammat Tamajaq                         | 
| ttr            | Tera                                        | 
| tts            | Northeastern Thai                           | 
| ttt            | Muslim Tat                                  | 
| ttu            | Torau                                       | 
| ttv            | Titan                                       | 
| ttw            | Long Wat                                    | 
| tty            | Sikaritai                                   | 
| ttz            | Tsum                                        | 
| tua            | Wiarumus                                    | 
| tub            | Tübatulabal                                 | 
| tuc            | Mutu                                        | 
| tud            | Tuxá                                        | 
| tue            | Tuyuca                                      | 
| tuf            | Central Tunebo                              | 
| tug            | Tunia                                       | 
| tuh            | Taulil                                      | 
| tui            | Tupuri                                      | 
| tuj            | Tugutil                                     | 
| tuk            | Turkmen                                     | 
| tul            | Tula                                        | 
| tum            | Tumbuka                                     | 
| tun            | Tunica                                      | 
| tuo            | Tucano                                      | 
| tuq            | Tedaga                                      | 
| tur            | Turkish                                     | 
| tus            | Tuscarora                                   | 
| tuu            | Tututni                                     | 
| tuv            | Turkana                                     | 
| tux            | Tuxináwa                                    | 
| tuy            | Tugen                                       | 
| tuz            | Turka                                       | 
| tva            | Vaghua                                      | 
| tvd            | Tsuvadi                                     | 
| tve            | Te'un                                       | 
| tvk            | Southeast Ambrym                            | 
| tvl            | Tuvalu                                      | 
| tvm            | Tela-Masbuar                                | 
| tvn            | Tavoyan                                     | 
| tvo            | Tidore                                      | 
| tvs            | Taveta                                      | 
| tvt            | Tutsa Naga                                  | 
| tvu            | Tunen                                       | 
| tvw            | Sedoa                                       | 
| tvy            | Timor Pidgin                                | 
| twa            | Twana                                       | 
| twb            | Western Tawbuid                             | 
| twc            | Teshenawa                                   | 
| twd            | Twents                                      | 
| twe            | Tewa (Indonesia)                            | 
| twf            | Northern Tiwa                               | 
| twg            | Tereweng                                    | 
| twh            | Tai Dón                                     | 
| twl            | Tawara                                      | 
| twn            | Twendi                                      | 
| two            | Tswapong                                    | 
| twp            | Ere                                         | 
| twq            | Tasawaq                                     | 
| twr            | Southwestern Tarahumara                     | 
| twt            | Turiwára                                    | 
| twu            | Termanu                                     | 
| tww            | Tuwari                                      | 
| twx            | Tewe                                        | 
| twy            | Tawoyan                                     | 
| txa            | Tombonuo                                    | 
| txb            | Tokharian B                                 | 
| txc            | Tsetsaut                                    | 
| txe            | Totoli                                      | 
| txg            | Tangut                                      | 
| txh            | Thracian                                    | 
| txi            | Ikpeng                                      | 
| txj            | Tarjumo                                     | 
| txm            | Tomini                                      | 
| txn            | West Tarangan                               | 
| txo            | Toto                                        | 
| txq            | Tii                                         | 
| txs            | Tonsea                                      | 
| txt            | Citak                                       | 
| txu            | Kayapó                                      | 
| txx            | Tatana                                      | 
| txy            | Tanosy Malagasy                             | 
| tya            | Tauya                                       | 
| tye            | Kyanga                                      | 
| tyh            | O'du                                        | 
| tyi            | Teke-Tsaayi                                 | 
| tyj            | Tai Yo                                      | 
| tyn            | Kombai                                      | 
| typ            | Thaypan                                     | 
| tyr            | Tai Daeng                                   | 
| tys            | Tày Sa Pa                                   | 
| tyt            | Tày Tac                                     | 
| tyu            | Kua                                         | 
| tyv            | Tuvinian                                    | 
| tyx            | Teke-Tyee                                   | 
| tyz            | Tày                                         | 
| tzh            | Tzeltal                                     | 
| tzj            | Tz'utujil                                   | 
| tzm            | Central Atlas Tamazight                     | 
| tzn            | Tugun                                       | 
| tzo            | Tzotzil                                     | 
| tzx            | Tabriak                                     | 
| uan            | Kuan                                        | 
| uar            | Tairuma                                     | 
| uba            | Ubang                                       | 
| ubi            | Ubi                                         | 
| ubl            | Buhi'non Bikol                              | 
| ubr            | Ubir                                        | 
| ubu            | Umbu-Ungu                                   | 
| uby            | Ubykh                                       | 
| uda            | Uda                                         | 
| ude            | Udihe                                       | 
| udg            | Muduga                                      | 
| udi            | Udi                                         | 
| udj            | Ujir                                        | 
| udl            | Wuzlam                                      | 
| udm            | Udmurt                                      | 
| udu            | Uduk                                        | 
| ues            | Kioko                                       | 
| ufi            | Ufim                                        | 
| uga            | Ugaritic                                    | 
| ugb            | Kuku-Ugbanh                                 | 
| uge            | Ughele                                      | 
| ugo            | Ugong                                       | 
| uha            | Uhami                                       | 
| uhn            | Damal                                       | 
| uig            | Uyghur                                      | 
| uis            | Uisai                                       | 
| uiv            | Iyive                                       | 
| uji            | Tanjijili                                   | 
| uka            | Kaburi                                      | 
| ukg            | Ukuriguma                                   | 
| ukh            | Ukhwejo                                     | 
| ukp            | Ukpe-Bayobiri                               | 
| ukq            | Ukwa                                        | 
| ukr            | Ukrainian                                   | 
| uku            | Ukue                                        | 
| ukv            | Kuku                                        | 
| ukw            | Ukwuani-Aboh-Ndoni                          | 
| uky            | Kuuk-Yak                                    | 
| ula            | Fungwa                                      | 
| ulb            | Ulukwumi                                    | 
| ulc            | Ulch                                        | 
| ule            | Lule                                        | 
| ulf            | Usku                                        | 
| uli            | Ulithian                                    | 
| ulk            | Meriam Mir                                  | 
| ull            | Ullatan                                     | 
| ulm            | Ulumanda'                                   | 
| uln            | Unserdeutsch                                | 
| ulu            | Uma' Lung                                   | 
| ulw            | Ulwa                                        | 
| uma            | Umatilla                                    | 
| umb            | Umbundu                                     | 
| umd            | Umbindhamu                                  | 
| umg            | Umbuygamu                                   | 
| umi            | Ukit                                        | 
| umm            | Umon                                        | 
| umn            | Makyan Naga                                 | 
| umo            | Umotína                                     | 
| ump            | Umpila                                      | 
| umr            | Umbugarla                                   | 
| ums            | Pendau                                      | 
| umu            | Munsee                                      | 
| una            | North Watut                                 | 
| une            | Uneme                                       | 
| ung            | Ngarinyin                                   | 
| uni            | Uni                                         | 
| unk            | Enawené-Nawé                                | 
| unm            | Unami                                       | 
| unn            | Kurnai                                      | 
| unr            | Mundari                                     | 
| unu            | Unubahe                                     | 
| unz            | Unde Kaili                                  | 
| upi            | Umeda                                       | 
| upv            | Uripiv-Wala-Rano-Atchin                     | 
| ura            | Urarina                                     | 
| urb            | Urubú-Kaapor                                | 
| urc            | Urningangg                                  | 
| urd            | Urdu                                        | 
| ure            | Uru                                         | 
| urg            | Urigina                                     | 
| urh            | Urhobo                                      | 
| uri            | Urim                                        | 
| urk            | Urak Lawoi'                                 | 
| url            | Urali                                       | 
| urm            | Urapmin                                     | 
| urn            | Uruangnirin                                 | 
| uro            | Ura (Papua New Guinea)                      | 
| urr            | Löyöp                                       | 
| urt            | Urat                                        | 
| uru            | Urumi                                       | 
| urv            | Uruava                                      | 
| urw            | Sop                                         | 
| urx            | Urimo                                       | 
| ury            | Orya                                        | 
| urz            | Uru-Eu-Wau-Wau                              | 
| usa            | Usarufa                                     | 
| ush            | Ushojo                                      | 
| usi            | Usui                                        | 
| usk            | Usaghade                                    | 
| usp            | Uspanteco                                   | 
| usu            | Uya                                         | 
| uta            | Otank                                       | 
| ute            | Ute-Southern Paiute                         | 
| utp            | Amba (Solomon Islands)                      | 
| utr            | Etulo                                       | 
| utu            | Utu                                         | 
| uum            | Urum                                        | 
| uur            | Ura (Vanuatu)                               | 
| uuu            | U                                           | 
| uve            | West Uvean                                  | 
| uvh            | Uri                                         | 
| uvl            | Lote                                        | 
| uwa            | Kuku-Uwanh                                  | 
| uya            | Doko-Uyanga                                 | 
| uzn            | Uzbek                                       | 
| uzs            | Southern Uzbek                              | 
| vaa            | Vaagri Booli                                | 
| vae            | Vale                                        | 
| vaf            | Vafsi                                       | 
| vag            | Vagla                                       | 
| vah            | Varhadi-Nagpuri                             | 
| vai            | Vai                                         | 
| vaj            | Vasekele                                    | 
| val            | Vehes                                       | 
| vam            | Vanimo                                      | 
| van            | Valman                                      | 
| vao            | Vao                                         | 
| vap            | Vaiphei                                     | 
| var            | Huarijio                                    | 
| vas            | Vasavi                                      | 
| vau            | Vanuma                                      | 
| vav            | Varli                                       | 
| vay            | Wayu                                        | 
| vbb            | Southeast Babar                             | 
| vec            | Venetian                                    | 
| ved            | Veddah                                      | 
| vel            | Veluws                                      | 
| vem            | Vemgo-Mabas                                 | 
| ven            | Venda                                       | 
| veo            | Ventureño                                   | 
| vep            | Veps                                        | 
| ver            | Mom Jango                                   | 
| vgr            | Vaghri                                      | 
| vgt            | Vlaamse Gebarentaal                         | 
| vic            | Virgin Islands Creole English               | 
| vid            | Vidunda                                     | 
| vie            | Northern Vietnamese                         | 
| vif            | Vili                                        | 
| vig            | Viemo                                       | 
| vil            | Vilela                                      | 
| vin            | Vinza                                       | 
| vis            | Vishavan                                    | 
| vit            | Viti                                        | 
| viv            | Iduna                                       | 
| vka            | Kariyarra                                   | 
| vkj            | Kujarge                                     | 
| vkk            | Kaur                                        | 
| vkl            | Kulisusu                                    | 
| vkm            | Kamakan                                     | 
| vko            | Kodeoha                                     | 
| vkp            | Korlai Creole Portuguese                    | 
| vkt            | Tenggarong Kutai Malay                      | 
| vku            | Kurrama                                     | 
| vlp            | Valpei                                      | 
| vls            | Vlaams                                      | 
| vma            | Martuyhunira                                | 
| vmb            | Barbaram                                    | 
| vmc            | Juxtlahuaca Mixtec                          | 
| vmd            | Mudu Koraga                                 | 
| vme            | East Masela                                 | 
| vmf            | Mainfränkisch                               | 
| vmg            | Lungalunga                                  | 
| vmh            | Maraghei                                    | 
| vmi            | Miwa                                        | 
| vmj            | Ixtayutla Mixtec                            | 
| vmk            | Makhuwa-Shirima                             | 
| vml            | Malgana                                     | 
| vmm            | Mitlatongo Mixtec                           | 
| vmp            | Soyaltepec Mazatec                          | 
| vmq            | Soyaltepec Mixtec                           | 
| vmr            | Marenje                                     | 
| vmu            | Muluridyi                                   | 
| vmv            | Valley Maidu                                | 
| vmw            | Makhuwa                                     | 
| vmx            | Tamazola Mixtec                             | 
| vmy            | Ayautla Mazatec                             | 
| vmz            | Mazatlán Mazatec                            | 
| vnk            | Vano                                        | 
| vnm            | Vinmavis                                    | 
| vnp            | Vunapu                                      | 
| vor            | Voro                                        | 
| vot            | Votic                                       | 
| vra            | Vera'a                                      | 
| vro            | Võro                                        | 
| vrs            | Varisi                                      | 
| vrt            | Burmbar                                     | 
| vto            | Vitou                                       | 
| vum            | Vumbu                                       | 
| vun            | Vunjo                                       | 
| vut            | Vute                                        | 
| vwa            | Awa (China)                                 | 
| waa            | Walla Walla                                 | 
| wab            | Wab                                         | 
| wac            | Wasco-Wishram                               | 
| wad            | Wondama                                     | 
| wae            | Walser                                      | 
| wag            | Wa'ema                                      | 
| wah            | Watubela                                    | 
| waj            | Waffa                                       | 
| wal            | Wolaytta                                    | 
| wam            | Wampanoag                                   | 
| wan            | Wan                                         | 
| wao            | Wappo                                       | 
| wap            | Wapishana                                   | 
| waq            | Wagiman                                     | 
| war            | Waray (Philippines)                         | 
| was            | Washo                                       | 
| wat            | Kaninuwa                                    | 
| wau            | Waurá                                       | 
| wav            | Waka                                        | 
| waw            | Waiwai                                      | 
| wax            | Watam                                       | 
| way            | Wayana                                      | 
| waz            | Wampur                                      | 
| wba            | Warao                                       | 
| wbb            | Wabo                                        | 
| wbe            | Waritai                                     | 
| wbf            | Wara                                        | 
| wbh            | Wanda                                       | 
| wbi            | Vwanji                                      | 
| wbj            | Alagwa                                      | 
| wbk            | Waigali                                     | 
| wbl            | Wakhi                                       | 
| wbm            | Wa                                          | 
| wbp            | Warlpiri                                    | 
| wbq            | Waddar                                      | 
| wbr            | Wagdi                                       | 
| wbt            | Warnman                                     | 
| wbv            | Wajarri                                     | 
| wbw            | Woi                                         | 
| wca            | Yanomámi                                    | 
| wci            | Waci Gbe                                    | 
| wdd            | Wandji                                      | 
| wdg            | Wadaginam                                   | 
| wdj            | Wadjiginy                                   | 
| wdu            | Wadjigu                                     | 
| wea            | Wewaw                                       | 
| wec            | Wè Western                                  | 
| wed            | Wedau                                       | 
| weh            | Weh                                         | 
| wei            | Kiunum                                      | 
| wem            | Weme Gbe                                    | 
| weo            | Wemale                                      | 
| wep            | Westphalien                                 | 
| wer            | Weri                                        | 
| wes            | Cameroon Pidgin                             | 
| wet            | Perai                                       | 
| wew            | Wejewa                                      | 
| wfg            | Zorop                                       | 
| wga            | Wagaya                                      | 
| wgb            | Wagawaga                                    | 
| wgg            | Wangkangurru                                | 
| wgi            | Wahgi                                       | 
| wgo            | Waigeo                                      | 
| wgu            | Wirangu                                     | 
| wgy            | Warrgamay                                   | 
| wha            | Sou Upaa                                    | 
| whg            | North Wahgi                                 | 
| whk            | Wahau Kenyah                                | 
| wib            | Southern Toussian                           | 
| wic            | Wichita                                     | 
| wie            | Wik-Epa                                     | 
| wig            | Wik Ngathan                                 | 
| wih            | Wik-Me'anha                                 | 
| wii            | Minidien                                    | 
| wij            | Wik-Iiyanh                                  | 
| wik            | Wikalkan                                    | 
| wil            | Wilawila                                    | 
| wim            | Wik-Mungkan                                 | 
| win            | Ho-Chunk                                    | 
| wir            | Wiraféd                                     | 
| wiu            | Wiru                                        | 
| wiv            | Vitu                                        | 
| wiy            | Wiyot                                       | 
| wja            | Waja                                        | 
| wji            | Warji                                       | 
| wka            | Kw'adza                                     | 
| wkd            | Wakde                                       | 
| wkl            | Kalanadi                                    | 
| wku            | Kunduvadi                                   | 
| wkw            | Wakawaka                                    | 
| wla            | Walio                                       | 
| wlc            | Mwali Comorian                              | 
| wle            | Wolane                                      | 
| wlg            | Kunbarlang                                  | 
| wlh            | Welaun                                      | 
| wli            | Waioli                                      | 
| wlk            | Wailaki                                     | 
| wll            | Wali (Sudan)                                | 
| wln            | Walloon                                     | 
| wlo            | Wolio                                       | 
| wlr            | Wailapa                                     | 
| wls            | Wallisian                                   | 
| wlu            | Wuliwuli                                    | 
| wlv            | Wichí Lhamtés Vejoz                         | 
| wlw            | Walak                                       | 
| wlx            | Wali (Ghana)                                | 
| wly            | Waling                                      | 
| wmb            | Wambaya                                     | 
| wmc            | Wamas                                       | 
| wmd            | Mamaindé                                    | 
| wme            | Wambule                                     | 
| wmg            | Western Minyag                              | 
| wmh            | Waima'a                                     | 
| wmi            | Wamin                                       | 
| wmm            | Maiwa (Indonesia)                           | 
| wmn            | Waamwang                                    | 
| wmo            | Wom (Papua New Guinea)                      | 
| wms            | Wambon                                      | 
| wmt            | Walmajarri                                  | 
| wmw            | Mwani                                       | 
| wmx            | Womo                                        | 
| wnb            | Wanambre                                    | 
| wnc            | Wantoat                                     | 
| wnd            | Wandarang                                   | 
| wne            | Waneci                                      | 
| wng            | Wanggom                                     | 
| wni            | Ndzwani Comorian                            | 
| wnk            | Wanukaka                                    | 
| wnm            | Wanggamala                                  | 
| wno            | Wano                                        | 
| wnp            | Wanap                                       | 
| wnu            | Usan                                        | 
| wnw            | Wintu                                       | 
| wny            | Wanyi                                       | 
| woa            | Tyaraity                                    | 
| wob            | Wè Northern                                 | 
| woc            | Wogeo                                       | 
| wod            | Wolani                                      | 
| woe            | Woleaian                                    | 
| wof            | Gambian Wolof                               | 
| wog            | Wogamusin                                   | 
| woi            | Kamang                                      | 
| wok            | Longto                                      | 
| wol            | Wolof                                       | 
| wom            | Wom (Nigeria)                               | 
| won            | Wongo                                       | 
| woo            | Manombai                                    | 
| wor            | Woria                                       | 
| wos            | Hanga Hundi                                 | 
| wow            | Wawonii                                     | 
| wpc            | Maco                                        | 
| wrb            | Warluwara                                   | 
| wrg            | Warungu                                     | 
| wrh            | Wiradjuri                                   | 
| wri            | Wariyangga                                  | 
| wrk            | Garrwa                                      | 
| wrl            | Warlmanpa                                   | 
| wrm            | Warumungu                                   | 
| wrn            | Warnang                                     | 
| wro            | Worrorra                                    | 
| wrp            | Waropen                                     | 
| wrr            | Wardaman                                    | 
| wrs            | Waris                                       | 
| wru            | Waru                                        | 
| wrv            | Waruna                                      | 
| wrw            | Gugu Warra                                  | 
| wrx            | Wae Rana                                    | 
| wry            | Merwari                                     | 
| wrz            | Waray (Australia)                           | 
| wsa            | Warembori                                   | 
| wsi            | Wusi                                        | 
| wsk            | Waskia                                      | 
| wsr            | Owenia                                      | 
| wss            | Wasa                                        | 
| wsv            | Wotapuri-Katarqalai                         | 
| wtf            | Watiwa                                      | 
| wth            | Wathawurrung                                | 
| wti            | Berta                                       | 
| wtk            | Watakataui                                  | 
| wtm            | Mewati                                      | 
| wtw            | Wotu                                        | 
| wua            | Wikngenchera                                | 
| wub            | Wunambal                                    | 
| wud            | Wudu                                        | 
| wuh            | Wutunhua                                    | 
| wul            | Silimo                                      | 
| wum            | Wumbvu                                      | 
| wun            | Bungu                                       | 
| wur            | Wurrugu                                     | 
| wut            | Wutung                                      | 
| wuu            | Wu Chinese                                  | 
| wuv            | Wuvulu-Aua                                  | 
| wux            | Wulna                                       | 
| wuy            | Wauyai                                      | 
| wwa            | Waama                                       | 
| wwo            | Wetamut                                     | 
| wwr            | Warrwa                                      | 
| www            | Wawa                                        | 
| wxa            | Waxianghua                                  | 
| wxw            | Wardandi                                    | 
| wya            | Wyandot                                     | 
| wyb            | Wangaaybuwan-Ngiyambaa                      | 
| wyi            | Woiwurrung                                  | 
| wym            | Wymysorys                                   | 
| wyr            | Wayoró                                      | 
| wyy            | Western Fijian                              | 
| xaa            | Andalusian Arabic                           | 
| xab            | Sambe                                       | 
| xac            | Kachari                                     | 
| xad            | Adai                                        | 
| xag            | Aghwan                                      | 
| xak            | Máku                                        | 
| xal            | Oirat                                       | 
| xam            | ǀXam                                        | 
| xan            | Xamtanga                                    | 
| xap            | Apalachee                                   | 
| xar            | Karami                                      | 
| xas            | Kamas                                       | 
| xat            | Katawixi                                    | 
| xau            | Kauwera                                     | 
| xav            | Xavánte                                     | 
| xaw            | Kawaiisu                                    | 
| xay            | Kayan Mahakam                               | 
| xbc            | Bactrian                                    | 
| xbe            | Bigambal                                    | 
| xbg            | Bunganditj                                  | 
| xbi            | Kombio                                      | 
| xbn            | Kenaboi                                     | 
| xbo            | Bolgarian                                   | 
| xbp            | Bibbulman                                   | 
| xbr            | Kambera                                     | 
| xby            | Batyala                                     | 
| xce            | Celtiberian                                 | 
| xcg            | Cisalpine Gaulish                           | 
| xch            | Chimakum                                    | 
| xcl            | Classical Armenian                          | 
| xcm            | Comecrudo                                   | 
| xcn            | Cotoname                                    | 
| xco            | Chorasmian                                  | 
| xcr            | Carian                                      | 
| xct            | Classical Tibetan                           | 
| xcv            | Chuvantsy                                   | 
| xcw            | Coahuilteco                                 | 
| xcy            | Cayuse                                      | 
| xda            | Darkinyung                                  | 
| xdc            | Dacian                                      | 
| xdk            | Dharuk                                      | 
| xdo            | Kwandu                                      | 
| xdy            | Malayic Dayak                               | 
| xeb            | Eblan                                       | 
| xed            | Hdi                                         | 
| xeg            | ǁXegwi                                      | 
| xel            | Kelo                                        | 
| xem            | Kembayan                                    | 
| xer            | Xerénte                                     | 
| xes            | Kesawai                                     | 
| xet            | Xetá                                        | 
| xeu            | Keoru-Ahia                                  | 
| xfa            | Faliscan                                    | 
| xga            | Galatian                                    | 
| xgb            | Gbin                                        | 
| xgd            | Gudang                                      | 
| xgf            | Gabrielino-Fernandeño                       | 
| xgg            | Goreng                                      | 
| xgm            | Guwinmal                                    | 
| xgu            | Unggumi                                     | 
| xgw            | Guwa                                        | 
| xhd            | Hadrami                                     | 
| xhe            | Khetrani                                    | 
| xho            | Xhosa                                       | 
| xht            | Hattic                                      | 
| xhu            | Hurrian                                     | 
| xib            | Iberian                                     | 
| xii            | Xiri                                        | 
| xir            | Xiriâna                                     | 
| xiy            | Xipaya                                      | 
| xjb            | Minjungbal                                  | 
| xka            | Kalkoti                                     | 
| xkb            | Northern Nago                               | 
| xkc            | Kho'ini                                     | 
| xkd            | Mendalam Kayan                              | 
| xke            | Kereho                                      | 
| xkf            | Khengkha                                    | 
| xkg            | Kagoro                                      | 
| xkj            | Kajali                                      | 
| xkk            | Kaco'                                       | 
| xkl            | Mainstream Kenyah                           | 
| xkn            | Kayan River Kayan                           | 
| xkp            | Kabatei                                     | 
| xkq            | Koroni                                      | 
| xkr            | Xakriabá                                    | 
| xks            | Kumbewaha                                   | 
| xkt            | Kantosi                                     | 
| xku            | Kaamba                                      | 
| xkv            | Kgalagadi                                   | 
| xkw            | Kembra                                      | 
| xkx            | Karore                                      | 
| xky            | Uma' Lasan                                  | 
| xkz            | Kurtokha                                    | 
| xla            | Kamula                                      | 
| xlc            | Lycian                                      | 
| xld            | Lydian                                      | 
| xlo            | Loup A                                      | 
| xlp            | Lepontic                                    | 
| xls            | Lusitanian                                  | 
| xlu            | Cuneiform Luwian                            | 
| xma            | Mushungulu                                  | 
| xmb            | Mbonga                                      | 
| xmc            | Makhuwa-Marrevone                           | 
| xmd            | Mbudum                                      | 
| xmf            | Mingrelian                                  | 
| xmg            | Mengaka                                     | 
| xmh            | Kugu-Muminh                                 | 
| xmj            | Majera                                      | 
| xmm            | Manado Malay                                | 
| xmp            | Kuku-Mu'inh                                 | 
| xmr            | Meroitic                                    | 
| xmt            | Matbat                                      | 
| xmu            | Kamu                                        | 
| xmv            | Tankarana Malagasy                          | 
| xmw            | Tsimihety Malagasy                          | 
| xmx            | Maden                                       | 
| xmy            | Mayaguduna                                  | 
| xmz            | Mori Bawah                                  | 
| xna            | Ancient North Arabian                       | 
| xnb            | Kanakanabu                                  | 
| xng            | Middle Mongolian                            | 
| xni            | Ngarigu                                     | 
| xnj            | Ngoni (Tanzania)                            | 
| xnm            | Ngumbarl                                    | 
| xnn            | Northern Kankanay                           | 
| xnq            | Ngoni (Mozambique)                          | 
| xnr            | Kangri                                      | 
| xns            | Kanashi                                     | 
| xny            | Nyiyaparli                                  | 
| xnz            | Mattoki                                     | 
| xoc            | O'chi'chi'                                  | 
| xod            | Kokoda                                      | 
| xog            | Soga                                        | 
| xoi            | Kominimung                                  | 
| xok            | Xokleng                                     | 
| xom            | Komo (Sudan)                                | 
| xon            | Konkomba                                    | 
| xoo            | Xukurú                                      | 
| xop            | Kopar                                       | 
| xor            | Korubo                                      | 
| xow            | Kowaki                                      | 
| xpa            | Pirriya                                     | 
| xpc            | Pecheneg                                    | 
| xpe            | Liberia Kpelle                              | 
| xpg            | Phrygian                                    | 
| xpk            | Kulina Pano                                 | 
| xpm            | Pumpokol                                    | 
| xpo            | Pochutec                                    | 
| xpq            | Mohegan-Pequot                              | 
| xpr            | Parthian                                    | 
| xps            | Pisidian                                    | 
| xpt            | Punthamara                                  | 
| xpu            | Punic                                       | 
| xqt            | Qatabanian                                  | 
| xra            | Krahô                                       | 
| xrb            | Eastern Karaboro                            | 
| xrd            | Gundungurra                                 | 
| xre            | Kreye                                       | 
| xri            | Krikati-Timbira                             | 
| xrn            | Arin                                        | 
| xru            | Marriammu                                   | 
| xrw            | Karawa                                      | 
| xsa            | Sabaean                                     | 
| xsb            | Sambal                                      | 
| xsd            | Sidetic                                     | 
| xse            | Sempan                                      | 
| xsh            | Shamang                                     | 
| xsi            | Sio                                         | 
| xsl            | South Slavey                                | 
| xsm            | Kasem                                       | 
| xsn            | Sanga (Nigeria)                             | 
| xsp            | Silopi                                      | 
| xsq            | Makhuwa-Saka                                | 
| xsr            | Sherpa                                      | 
| xsu            | Sanumá                                      | 
| xsy            | Saisiyat                                    | 
| xta            | Alcozauca Mixtec                            | 
| xtb            | Chazumba Mixtec                             | 
| xtc            | Katcha-Kadugli-Miri                         | 
| xtd            | Diuxi-Tilantongo Mixtec                     | 
| xte            | Ketengban                                   | 
| xtg            | Transalpine Gaulish                         | 
| xth            | Yitha Yitha                                 | 
| xti            | Sinicahua Mixtec                            | 
| xtj            | San Juan Teita Mixtec                       | 
| xtl            | Tijaltepec Mixtec                           | 
| xtm            | Magdalena Peñasco Mixtec                    | 
| xtn            | Northern Tlaxiaco Mixtec                    | 
| xto            | Tokharian A                                 | 
| xtp            | San Miguel Piedras Mixtec                   | 
| xtq            | Tumshuqese                                  | 
| xts            | Sindihui Mixtec                             | 
| xtt            | Tacahua Mixtec                              | 
| xtu            | Cuyamecalco Mixtec                          | 
| xtv            | Thawa                                       | 
| xtw            | Tawandê                                     | 
| xty            | Yoloxochitl Mixtec                          | 
| xua            | Alu Kurumba                                 | 
| xub            | Betta Kurumba                               | 
| xud            | Umiida                                      | 
| xug            | Kunigami                                    | 
| xuj            | Jennu Kurumba                               | 
| xul            | Nunukul                                     | 
| xum            | Umbrian                                     | 
| xun            | Unggaranggu                                 | 
| xuo            | Kuo                                         | 
| xup            | Upper Umpqua                                | 
| xur            | Urartian                                    | 
| xut            | Kuthant                                     | 
| xuu            | Kxoe                                        | 
| xve            | Venetic                                     | 
| xvi            | Kamviri                                     | 
| xwa            | Kwaza                                       | 
| xwc            | Woccon                                      | 
| xwe            | Xwela Gbe                                   | 
| xwg            | Kwegu                                       | 
| xwk            | Wangkumara                                  | 
| xwl            | Western Xwla Gbe                            | 
| xwr            | Kwerba Mamberamo                            | 
| xwt            | Wotjobaluk                                  | 
| xww            | Wemba Wemba                                 | 
| xxb            | Boro (Ghana)                                | 
| xxk            | Ke'o                                        | 
| xxm            | Minkin                                      | 
| xxr            | Koropó                                      | 
| xxt            | Tambora                                     | 
| xya            | Yaygir                                      | 
| xyb            | Yandjibara                                  | 
| xyj            | Mayi-Yapi                                   | 
| xyk            | Mayi-Kulan                                  | 
| xyt            | Mayi-Thakurti                               | 
| xyy            | Yorta Yorta                                 | 
| xzh            | Zhang-Zhung                                 | 
| yaa            | Yaminahua                                   | 
| yab            | Yuhup                                       | 
| yac            | Pass Valley Yali                            | 
| yad            | Yagua                                       | 
| yae            | Pumé                                        | 
| yaf            | Yaka (Democratic Republic of Congo)         | 
| yag            | Yámana                                      | 
| yah            | Yazgulyam                                   | 
| yai            | Yagnobi                                     | 
| yaj            | Banda-Yangere                               | 
| yak            | Yakama                                      | 
| yal            | Yalunka                                     | 
| yam            | Yamba                                       | 
| yan            | Mayangna                                    | 
| yao            | Yao                                         | 
| yap            | Yapese                                      | 
| yaq            | Yaqui                                       | 
| yar            | Yabarana                                    | 
| yas            | Nugunu (Cameroon)                           | 
| yat            | Yambeta                                     | 
| yau            | Yuwana                                      | 
| yav            | Yangben                                     | 
| yaw            | Yawalapití                                  | 
| yay            | Agwagwune                                   | 
| yaz            | Lokaa                                       | 
| yba            | Yala                                        | 
| ybb            | Yemba                                       | 
| ybe            | West Yugur                                  | 
| ybh            | Yakha                                       | 
| ybi            | Yamphu                                      | 
| ybj            | Hasha                                       | 
| ybk            | Bokha                                       | 
| ybl            | Yukuben                                     | 
| ybm            | Yaben                                       | 
| ybn            | Yabaâna                                     | 
| ybo            | Yabong                                      | 
| ybx            | Yawiyo                                      | 
| yby            | Yaweyuha                                    | 
| ych            | Chesu                                       | 
| ycl            | Lolopo                                      | 
| ycn            | Yucuna                                      | 
| ycp            | Chepya                                      | 
| yda            | Yanda                                       | 
| ydd            | Eastern Yiddish                             | 
| yde            | Yangum Dey                                  | 
| ydg            | Yidgha                                      | 
| ydk            | Yoidik                                      | 
| yea            | Ravula                                      | 
| yee            | Yimas                                       | 
| yei            | Yeni                                        | 
| yej            | Yevanic                                     | 
| yel            | Yela                                        | 
| yer            | Tarok                                       | 
| yes            | Nyankpa                                     | 
| yet            | Yetfa                                       | 
| yeu            | Yerukula                                    | 
| yev            | Yapunda                                     | 
| yey            | Yeyi                                        | 
| yga            | Malyangapa                                  | 
| ygl            | Yangum Gel                                  | 
| ygm            | Yagomi                                      | 
| ygp            | Gepo                                        | 
| ygr            | Yagaria                                     | 
| ygw            | Yagwoia                                     | 
| yha            | Baha Buyang                                 | 
| yhd            | Judeo-Iraqi Arabic                          | 
| yhl            | Hlepho Phowa                                | 
| yia            | Yinggarda                                   | 
| yif            | Ache                                        | 
| yig            | Wusa Nasu                                   | 
| yih            | Western Yiddish                             | 
| yii            | Yidiny                                      | 
| yij            | Yindjibarndi                                | 
| yik            | Dongshanba Lalo                             | 
| yil            | Yindjilandji                                | 
| yim            | Yimchungru Naga                             | 
| yin            | Yinchia                                     | 
| yip            | Pholo                                       | 
| yiq            | Miqie                                       | 
| yir            | North Awyu                                  | 
| yis            | Yis                                         | 
| yit            | Eastern Lalu                                | 
| yiu            | Awu                                         | 
| yiv            | Northern Nisu                               | 
| yix            | Axi Yi                                      | 
| yiz            | Azhe                                        | 
| yka            | Yakan                                       | 
| ykg            | Northern Yukaghir                           | 
| yki            | Yoke                                        | 
| ykk            | Yakaikeke                                   | 
| ykl            | Khlula                                      | 
| ykm            | Kap                                         | 
| ykn            | Kua-nsi                                     | 
| yko            | Yasa                                        | 
| ykr            | Yekora                                      | 
| ykt            | Kathu                                       | 
| yku            | Kuamasi                                     | 
| yky            | Yakoma                                      | 
| yla            | Yaul                                        | 
| yle            | Yele                                        | 
| ylg            | Yelogu                                      | 
| yli            | Angguruk Yali                               | 
| yll            | Yil                                         | 
| ylm            | Limi                                        | 
| yln            | Langnian Buyang                             | 
| ylo            | Naluo Yi                                    | 
| ylr            | Yalarnnga                                   | 
| ylu            | Aribwaung                                   | 
| yly            | Nyelâyu                                     | 
| ymb            | Yambes                                      | 
| ymc            | Southern Muji                               | 
| ymd            | Muda                                        | 
| yme            | Yameo                                       | 
| ymh            | Mili                                        | 
| ymi            | Moji                                        | 
| ymk            | Makwe                                       | 
| yml            | Iamalele                                    | 
| ymm            | Maay                                        | 
| ymn            | Yamna                                       | 
| ymo            | Yangum Mon                                  | 
| ymp            | Yamap                                       | 
| ymq            | Qila Muji                                   | 
| ymr            | Malasar                                     | 
| ymx            | Northern Muji                               | 
| ymz            | Muzi                                        | 
| yna            | Aluo                                        | 
| ynd            | Yandruwandha                                | 
| yng            | Yango                                       | 
| ynk            | Naukan Yupik                                | 
| ynl            | Yangulam                                    | 
| ynn            | Yana                                        | 
| yno            | Yong                                        | 
| ynq            | Yendang                                     | 
| yns            | Yansi                                       | 
| ynu            | Yahuna                                      | 
| yob            | Yoba                                        | 
| yog            | Yogad                                       | 
| yoi            | Yonaguni                                    | 
| yok            | Yokuts                                      | 
| yom            | Yombe                                       | 
| yon            | Yongkom                                     | 
| yor            | Yoruba                                      | 
| yot            | Yotti                                       | 
| yox            | Yoron                                       | 
| yoy            | Yoy                                         | 
| ypa            | Phala                                       | 
| ypb            | Labo Phowa                                  | 
| ypg            | Phola                                       | 
| yph            | Phupha                                      | 
| ypm            | Phuma                                       | 
| ypn            | Ani Phowa                                   | 
| ypo            | Alo Phola                                   | 
| ypp            | Phupa                                       | 
| ypz            | Phuza                                       | 
| yra            | Yerakai                                     | 
| yrb            | Yareba                                      | 
| yre            | Yaouré                                      | 
| yrk            | Nenets                                      | 
| yrl            | Nhengatu                                    | 
| yrn            | Yerong                                      | 
| yro            | Yaroamë                                     | 
| yrw            | Yarawata                                    | 
| yry            | Yarluyandi                                  | 
| ysd            | Samatao                                     | 
| ysg            | Sonaga                                      | 
| ysn            | Sani                                        | 
| yso            | Nisi (China)                                | 
| ysr            | Sirenik Yupik                               | 
| yss            | Yessan-Mayo                                 | 
| ysy            | Sanie                                       | 
| yta            | Talu                                        | 
| ytl            | Tanglang                                    | 
| ytp            | Thopho                                      | 
| ytw            | Yout Wam                                    | 
| yua            | Yucateco                                    | 
| yub            | Yugambal                                    | 
| yuc            | Yuchi                                       | 
| yud            | Judeo-Tripolitanian Arabic                  | 
| yue            | Cantonese Chinese                           | 
| yuf            | Havasupai-Walapai-Yavapai                   | 
| yug            | Yug                                         | 
| yui            | Yurutí                                      | 
| yuj            | Karkar-Yuri                                 | 
| yuk            | Yuki                                        | 
| yul            | Yulu                                        | 
| yum            | Quechan                                     | 
| yun            | Bena (Nigeria)                              | 
| yup            | Yukpa                                       | 
| yuq            | Yuqui                                       | 
| yur            | Yurok                                       | 
| yut            | Yopno                                       | 
| yuw            | Yau (Morobe Province)                       | 
| yux            | Southern Yukaghir                           | 
| yuy            | East Yugur                                  | 
| yuz            | Yuracare                                    | 
| yva            | Yawa                                        | 
| yvt            | Yavitero                                    | 
| ywa            | Kalou                                       | 
| ywg            | Yinhawangka                                 | 
| ywl            | Western Lalu                                | 
| ywn            | Yawanawa                                    | 
| ywq            | Wuding-Luquan Yi                            | 
| ywr            | Yawuru                                      | 
| ywt            | Xishanba Lalo                               | 
| ywu            | Wumeng Nasu                                 | 
| yww            | Yawarawarga                                 | 
| yxg            | Yagara                                      | 
| yxl            | Yardliyawarra                               | 
| yxm            | Yinwum                                      | 
| yxy            | Yabula Yabula                               | 
| yyr            | Yir Yoront                                  | 
| yyu            | Yau (Sandaun Province)                      | 
| yyz            | Ayizi                                       | 
| yzg            | E'ma Buyang                                 | 
| yzk            | Zokhuo                                      | 
| zaa            | Sierra de Juárez Zapotec                    | 
| zab            | Western Tlacolula Valley Zapotec            | 
| zac            | Ocotlán Zapotec                             | 
| zad            | Cajonos Zapotec                             | 
| zae            | Yareni Zapotec                              | 
| zaf            | Ayoquesco Zapotec                           | 
| zag            | Zaghawa                                     | 
| zah            | Zangwal                                     | 
| zai            | Isthmus Zapotec                             | 
| zaj            | Zaramo                                      | 
| zak            | Zanaki                                      | 
| zal            | Zauzou                                      | 
| zam            | Miahuatlán Zapotec                          | 
| zao            | Ozolotepec Zapotec                          | 
| zaq            | Aloápam Zapotec                             | 
| zar            | Rincón Zapotec                              | 
| zas            | Santo Domingo Albarradas Zapotec            | 
| zat            | Tabaa Zapotec                               | 
| zau            | Zangskari                                   | 
| zav            | Yatzachi Zapotec                            | 
| zaw            | Mitla Zapotec                               | 
| zax            | Xadani Zapotec                              | 
| zay            | Zayse-Zergulla                              | 
| zaz            | Zari                                        | 
| zbc            | Central Berawan                             | 
| zbe            | East Berawan                                | 
| zbt            | Batui                                       | 
| zbu            | Bu (Bauchi State)                           | 
| zbw            | West Berawan                                | 
| zca            | Coatecas Altas Zapotec                      | 
| zch            | Central Hongshuihe Zhuang                   | 
| zdj            | Ngazidja Comorian                           | 
| zea            | Zeeuws                                      | 
| zeg            | Zenag                                       | 
| zeh            | Eastern Hongshuihe Zhuang                   | 
| zen            | Zenaga                                      | 
| zga            | Kinga                                       | 
| zgb            | Guibei Zhuang                               | 
| zgm            | Minz Zhuang                                 | 
| zgn            | Guibian Zhuang                              | 
| zgr            | Magori                                      | 
| zhb            | Zhaba                                       | 
| zhd            | Dai Zhuang                                  | 
| zhi            | Zhire                                       | 
| zhn            | Nong Zhuang                                 | 
| zhw            | Zhoa                                        | 
| zia            | Zia                                         | 
| zik            | Zimakani                                    | 
| zil            | Zialo                                       | 
| zim            | Mesme                                       | 
| zin            | Zinza                                       | 
| ziw            | Zigula                                      | 
| ziz            | Zizilivakan                                 | 
| zka            | Kaimbulawa                                  | 
| zkk            | Karankawa                                   | 
| zko            | Kott                                        | 
| zkp            | São Paulo Kaingáng                          | 
| zkr            | Zakhring                                    | 
| zkt            | Kitan                                       | 
| zku            | Kaurna                                      | 
| zla            | Zula                                        | 
| zlj            | Liujiang Zhuang                             | 
| zlm            | Malay                                       | 
| zln            | Lianshan Zhuang                             | 
| zlq            | Liuqian Zhuang                              | 
| zma            | Manda (Australia)                           | 
| zmb            | Zimba                                       | 
| zmc            | Margany                                     | 
| zmd            | Maridan                                     | 
| zme            | Mangerr                                     | 
| zmf            | Mfinu                                       | 
| zmg            | Marti Ke                                    | 
| zmh            | Makolkol                                    | 
| zmi            | Negeri Sembilan Malay                       | 
| zmj            | Maridjabin                                  | 
| zmk            | Mandandanyi                                 | 
| zml            | Matngala                                    | 
| zmm            | Marramaninyshi                              | 
| zmn            | Mbangwe                                     | 
| zmo            | Molo                                        | 
| zmp            | Mpuono                                      | 
| zmq            | Mituku                                      | 
| zmr            | Maranunggu                                  | 
| zms            | Mbesa                                       | 
| zmt            | Maringarr                                   | 
| zmu            | Muruwari                                    | 
| zmv            | Mbariman-Gudhinma                           | 
| zmw            | Mbo (Democratic Republic of Congo)          | 
| zmx            | Bomitaba                                    | 
| zmy            | Mariyedi                                    | 
| zmz            | Mbandja                                     | 
| zna            | Zan Gula                                    | 
| zne            | Zande                                       | 
| zng            | Mang                                        | 
| zns            | Mangas                                      | 
| zoc            | Copainalá Zoque                             | 
| zoh            | Chimalapa Zoque                             | 
| zom            | Zou                                         | 
| zoo            | Asunción Mixtepec Zapotec                   | 
| zoq            | Tabasco Zoque                               | 
| zor            | Rayón Zoque                                 | 
| zos            | Francisco León Zoque                        | 
| zpa            | Lachiguiri Zapotec                          | 
| zpb            | Yautepec Zapotec                            | 
| zpc            | Choapan Zapotec                             | 
| zpd            | Southeastern Ixtlán Zapotec                 | 
| zpe            | Petapa Zapotec                              | 
| zpf            | San Pedro Quiatoni Zapotec                  | 
| zpg            | Guevea De Humboldt Zapotec                  | 
| zph            | Totomachapan Zapotec                        | 
| zpi            | Santa María Quiegolani Zapotec              | 
| zpj            | Quiavicuzas Zapotec                         | 
| zpk            | Tlacolulita Zapotec                         | 
| zpl            | Lachixío Zapotec                            | 
| zpm            | Mixtepec Zapotec                            | 
| zpn            | Santa Inés Yatzechi Zapotec                 | 
| zpo            | Amatlán Zapotec                             | 
| zpp            | El Alto Zapotec                             | 
| zpq            | Zoogocho Zapotec                            | 
| zpr            | Santiago Xanica Zapotec                     | 
| zps            | Coatlán Zapotec                             | 
| zpt            | San Vicente Coatlán Zapotec                 | 
| zpu            | Yalálag Zapotec                             | 
| zpv            | Chichicapan Zapotec                         | 
| zpw            | Zaniza Zapotec                              | 
| zpx            | San Baltazar Loxicha Zapotec                | 
| zpy            | Mazaltepec Zapotec                          | 
| zpz            | Texmelucan Zapotec                          | 
| zqe            | Qiubei Zhuang                               | 
| zrn            | Zerenkel                                    | 
| zro            | Záparo                                      | 
| zrs            | Mairasi                                     | 
| zsa            | Sarasira                                    | 
| zsm            | Standard Malay                              | 
| zsr            | Southern Rincon Zapotec                     | 
| zsu            | Sukurum                                     | 
| zte            | Elotepec Zapotec                            | 
| ztg            | Xanaguía Zapotec                            | 
| ztl            | Lapaguía-Guivini Zapotec                    | 
| ztm            | San Agustín Mixtepec Zapotec                | 
| ztn            | Santa Catarina Albarradas Zapotec           | 
| ztp            | Loxicha Zapotec                             | 
| ztq            | Quioquitani-Quierí Zapotec                  | 
| zts            | Tilquiapan Zapotec                          | 
| ztt            | Tejalapan Zapotec                           | 
| ztu            | Güilá Zapotec                               | 
| ztx            | Zaachila Zapotec                            | 
| zty            | Yatee Zapotec                               | 
| zua            | Zeem                                        | 
| zuh            | Tokano                                      | 
| zul            | Zulu                                        | 
| zum            | Kumzari                                     | 
| zun            | Zuni                                        | 
| zuy            | Zumaya                                      | 
| zwa            | Zay                                         | 
| zyb            | Yongbei Zhuang                              | 
| zyg            | Yang Zhuang                                 | 
| zyj            | Youjiang Zhuang                             | 
| zyn            | Yongnan Zhuang                              | 
| zyp            | Zyphe Chin                                  | 
| zzj            | Zuojiang Zhuang                             | 
| en-us          | American English                            | 
| en-sc          | Scottish English                            | 
| fr-be          | Belgian French                              | 
| fr-sw          | Swiss French                                | 
| pt-br          | Brazilian Portuguese                        | 
| spa-lat        | Latin American Spanish                      | 
| vi-ctr         | Central Vietnamese                          | 
| vi-so          | Southern Vietnamese                         |