# All public DeveloppeurPascal game projects in one code repository

[Cette page en français.](LISEZMOI.md)

All the source codes of the games released on [my GitHub account](https://github.com/DeveloppeurPascal). They are mainly programmed in Delphi.

Some of them were developed [live on Twitch](https://www.twitch.tv/patrickpremartin) during game coding sessions. You can see [replays on Serial Streameur](https://serialstreameur.fr/jeux-video.php).

This code repository contains projects developed in Object Pascal language under Delphi. You don't know what Delphi is and where to download it ? You'll learn more [on this web site](https://delphi-resources.developpeur-pascal.fr/).

## Talks and conferences

### Twitch

Follow my development streams of software, video games, mobile applications and websites on [my Twitch channel](https://www.twitch.tv/patrickpremartin) or as replays on [Serial Streameur](https://serialstreameur.fr) mostly in French.

## Games list

Making games isn't as complicated as it sounds. It can be fun, and it's educational (even if it sometimes takes a lot of stamina and courage not to give up on the party in mid-journey).

Delphi is fairly simple to use and learn. FireMonkey offers everything you need to create games. Try your hand at it, using [Delphi Game Engine](https://github.com/DeveloppeurPascal/Delphi-Game-Engine) for the basic functions, or directly using [this video game starter kit](https://github.com/DeveloppeurPascal/Gamolf-FMX-Game-Starter-Kit).

### Blufo
https://github.com/DeveloppeurPascal/Blufo

Clear the ground for an unobstructed landing.

### Bricks breaker
https://github.com/DeveloppeurPascal/Casse-Briques

Basic version of a "brick breaker" type game.

### Champter
https://github.com/DeveloppeurPascal/Champter

Arcade game where you have to collect mushrooms while avoiding traps, enemies and obstacles through dozens of levels.

### Christmas Game (Code Rage 2018)
https://github.com/DeveloppeurPascal/CodeRage2018-ChristmasGame

Simple game of targets that you have to hit while avoiding the bad ones in a festive Christmas atmosphere.

### Colarvest (Ludum Dare 52 "Harvest")
https://github.com/DeveloppeurPascal/LDJAM52-Harvest
 
A multi platform game for [Ludum Dare 52](https://ldjam.com/events/ludum-dare/52) theme "Harvest" made in Delphi with FireMonkey.

### Egg Hunter
https://github.com/DeveloppeurPascal/Egg-Hunter
 
Go on an egg hunt and grow the duck farm that will make you rich.

### Moo box
https://github.com/DeveloppeurPascal/BoiteAMeuh

A game of association rather intended for children. You have to recognize the animal whose sound you hear.

### Pairpix
https://github.com/DeveloppeurPascal/Pairpix

A memory game for children and adults.

### Ploumtris (Kenney Jam 2024)
https://github.com/DeveloppeurPascal/Ploumtris-KenneyJam2024

A Tetris like game for plumbers who love video games without water leaks.

### Pompach
https://github.com/DeveloppeurPascal/Pompach

A game of reflexes. Recharge batteries by pushing the right switches.

### Pumpkin Killer
https://github.com/DeveloppeurPascal/Pumpkin-Killer

Halloween brings out all the pumpkins. Some are smiling and cheerful, others sneaky and nasty. Can you get rid of the bad ones?

### Spooch
https://github.com/DeveloppeurPascal/Spooch

Travel through space avoiding enemy fire and ships.

### Sporgloo
https://github.com/DeveloppeurPascal/Sporgloo

Real-time multiplayer game where you simply set off to discover the forest you've arrived in.

### Taquin DX Books
https://github.com/DeveloppeurPascal/TaquinDXBooks

Cross-platform Taquin game developed in Delphi and using the API of [Delphi Books](https://delphi-books.com).

### Tetris Like
https://github.com/DeveloppeurPascal/TetrisLike

A Tetris playable with keyboard or touch.

### Where Is Bernie (Global Game Jam 2021)
https://github.com/DeveloppeurPascal/WhereIsBernie-GGJ21

Another click-to-target game made during a winter game jam.

## Install

If you download a ZIP file from GitHub it will be empty. You must use "git" command or a GUI to clone or fork this code repository with its submodules.

After cloning this repository, don't forget to update all projects with the command :

```bash
git submodule update --remote
```

If you didn't clone the project with its sub modules, use those git commands : 

```bash
git submodule init
git submodule update --remote
```

[This repository](https://github.com/DeveloppeurPascal/DevPas-Games-Pack) and all projects are available on [my GitHub account](https://github.com/DeveloppeurPascal).

## License

This project is under the MIT license. It's not the case for all of my other projects. Take a look at every LICENSE and README.md file before doing garbage.

## How to ask a new feature, report a bug or a security issue ?

If you want an answer from the project owner the best way to ask for a new feature or report a bug is to go to [the GitHub repository](https://github.com/DeveloppeurPascal/DevPas-Games-Pack) and [open a new issue](https://github.com/DeveloppeurPascal/DevPas-Games-Pack/issues).

If you found a security issue please don't report it publicly before a patch is available. Explain the case by [sending a private message to the author](https://developpeur-pascal.fr/nous-contacter.php).

## Support the project and its author

If you think this project is useful and want to support it, please make a donation to [its author](https://github.com/DeveloppeurPascal). It will help to maintain the code and binaries.

You can use one of those services :

* [GitHub Sponsors](https://github.com/sponsors/DeveloppeurPascal)
* [Liberapay](https://liberapay.com/PatrickPremartin)
* [Patreon](https://www.patreon.com/patrickpremartin)
* [Paypal](https://www.paypal.com/paypalme/patrickpremartin)

or if you speack french you can [subscribe to Zone Abo](https://zone-abo.fr/nos-abonnements.php) on a monthly or yearly basis and get a lot of resources as videos and articles.

## Project packages

To simplify GitHub account backups or local installation of projects, I offer several thematic repository packs. You can use them to download the relevant projects and check them out. They're probably not compilable as is, but they'll give you an idea of the open source projects available on [my GitHub account](https://github.com/DeveloppeurPascal), and you'll still be able to access them directly.

* [video games](https://github.com/DeveloppeurPascal/DevPas-Games-Pack)
* [utilities and mobile applications](https://github.com/DeveloppeurPascal/DevPas-WorkingPrograms-Pack)
* [libraries and components](https://github.com/DeveloppeurPascal/DevPas-Components-Pack)
* [repo templates and starter kits](https://github.com/DeveloppeurPascal/DevPas-TemplatesAndStarterKits-Pack)
* [all the public projects in my account](https://github.com/DeveloppeurPascal/_AllProjects)

To prepare my Delphi developer work environment on a new Windows computer or VM, I've also included [an installation script](https://github.com/DeveloppeurPascal/__MyMinimalDependenciesForWorkingWithDelphi). You can use it as is, or take inspiration from it if you're using my libraries or components.

If you're looking for examples and demos of how to use certain Delphi features, take a look at [this code repository](https://github.com/DeveloppeurPascal/Delphi-samples) and [its list of other example repositories](https://github.com/DeveloppeurPascal/Delphi-samples/blob/main/OtherDelphiSampleRepositories.md).
