# Tous les jeux vidéo publics de DeveloppeurPascal en un seul dépôt

[This page in English.](README.md)

Ensemble des codes sources des jeux diffusés sur [mon compte GitHub](https://github.com/DeveloppeurPascal). Ils sont essentiellement programmés en Delphi.

Certains ont été développés [en direct sur Twitch](https://www.twitch.tv/patrickpremartin) lors de sessions de game coding. Vous pouvez en voir [les rediffusions sur Serial Streameur](https://serialstreameur.fr/jeux-video.php).

Ce dépôt de code contient des projets développés en langage Pascal Objet sous Delphi. Vous ne savez pas ce qu'est Dephi ni où le télécharger ? Vous en saurez plus [sur ce site web](https://delphi-resources.developpeur-pascal.fr/).

## Présentations et conférences

### Twitch

Suivez mes streams de développement de logiciels, jeux vidéo, applications mobiles et sites web sur [ma chaîne Twitch](https://www.twitch.tv/patrickpremartin) ou en rediffusion sur [Serial Streameur](https://serialstreameur.fr) la plupart du temps en français.

## Liste des jeux

Faire des jeux n'est pas aussi compliqué qu'il n'y parait. Ca peut être fun et c'est formateur (même s'il faut parfois beaucoup d'endurance et de courage pour ne pas abandonner la partie en cours de route).

Delphi est assez simple à utiliser et apprendre. FireMonkey propose tout ce qu'il faut pour créer des jeux. Tentez l'aventure en vous aidant de [Delphi Game Engine](https://github.com/DeveloppeurPascal/Delphi-Game-Engine) pour les fonctions de base ou en utilisant directement [ce kit de démarrage pour jeux vidéo](https://github.com/DeveloppeurPascal/Gamolf-FMX-Game-Starter-Kit).

### Blufo
https://github.com/DeveloppeurPascal/Blufo

Dégagez le terrain pour pouvoir atterrir sans obstacle.

### Boite à meuh
https://github.com/DeveloppeurPascal/BoiteAMeuh

Un jeu d'association plutôt destiné aux enfants. Il faut reconnaître l'animal dont on entend le son.

### Casse-Briques
https://github.com/DeveloppeurPascal/Casse-Briques

Version de base d'un jeu de type "casse briques".

### Champter
https://github.com/DeveloppeurPascal/Champter

Jeu d'arcade où on doit ramasser des champignons en évitant les pièges, ennemis et obstacles à travers des dizaines de niveaux.

### Christmas Game (Code Rage 2018)
https://github.com/DeveloppeurPascal/CodeRage2018-ChristmasGame

Simple jeu de cibles qu'il faut toucher en évitant les mauvaises dans une ambiance festive de Noël.

### Colarvest (Ludum Dare 52 "Harvest")
https://github.com/DeveloppeurPascal/LDJAM52-Harvest
 
Un jeu multiplateforme développé lors de la [Ludum Dare 52](https://ldjam.com/events/ludum-dare/52) ayant pour thème "Harvest".

### Egg Hunter
https://github.com/DeveloppeurPascal/Egg-Hunter
 
Partez à la chasse aux oeufs et faites prospérer l'élevage de canards qui vous rendra riche.

### Où est Bernie (Global Game Jam 2021)
https://github.com/DeveloppeurPascal/WhereIsBernie-GGJ21

Un autre jeu de clic sur cibles réalisé lors d'une game jam hivernale.

### Pairpix
https://github.com/DeveloppeurPascal/Pairpix

Un jeu de mémoire pour les enfants et les adultes.

### Ploumtris (Kenney Jam 2024)
https://github.com/DeveloppeurPascal/Ploumtris-KenneyJam2024

Un jeu de type Tetris pour les plombiers qui aiment les jeux vidéo sans fuites d'eau.

### Pompach
https://github.com/DeveloppeurPascal/Pompach

Un jeu de réflexes. Rechargez des batteries en poussant les bons interrupteurs.

### Pumpkin Killer
https://github.com/DeveloppeurPascal/Pumpkin-Killer

A Halloween toutes les citrouilles sont de sortie. Certaines sont souriantes et gentielles, d'autres sournoises et méchantes. Saurez-vous éliminer les mauvaises ?

### Spooch
https://github.com/DeveloppeurPascal/Spooch

Parcourrez l'espace en évitant les tirs et vaisseaux enemis.

### Sporgloo
https://github.com/DeveloppeurPascal/Sporgloo

Jeu multijoueurs en temps réel où vous devez simplement vous partir à la découverte de la forêt dans laquelle vous êtes arrivé.

### Taquin DX Books
https://github.com/DeveloppeurPascal/TaquinDXBooks

Jeu de taquin multiplateforme développé en Delphi et utilisant l'API de [Delphi Books](https://delphi-books.com).

### Tetris Like
https://github.com/DeveloppeurPascal/TetrisLike

Un Tetris jouable au clavier ou en tactile.

## Installation

Si vous téléchargez un fichier ZIP depuis GitHub il sera vide. Vous devez utiliser la commande "git" ou une interface utilisateur dédiée pour cloner ou dupliquer ce dépôt et ses sous-modules.

Après avoir cloné le dépôt n'oubliez pas de mettre à jour les projets liés avec cette commande :

```bash
git submodule update --remote
```

Si vous n'avez pas cloné le projet avec ses sous-modules vous devrez saisir les commandes suivantes :

```bash
git submodule init
git submodule update --remote
```

[Ce dépôt de code](https://github.com/DeveloppeurPascal/DevPas-Games-Pack) et tous ses sous-projets sont disponibles sur [mon compte GitHub](https://github.com/DeveloppeurPascal).

## Licence

Ce projet est sous licence MIT. Ce n'est pas le cas de mes autres projets. Regardez leurs fichiers LICENSE et README.md (ou LISEZMOI.md) avant de faire des bêtises.

## Comment demander une nouvelle fonctionnalité, signaler un bogue ou une faille de sécurité ?

Si vous voulez une réponse du propriétaire de ce dépôt la meilleure façon de procéder pour demander une nouvelle fonctionnalité ou signaler une anomalie est d'aller sur [le dépôt de code sur GitHub](https://github.com/DeveloppeurPascal/DevPas-Games-Pack) et [d'ouvrir un ticket](https://github.com/DeveloppeurPascal/DevPas-Games-Pack/issues).

Si vous avez trouvé une faille de sécurité n'en parlez pas en public avant qu'un correctif n'ait été déployé ou soit disponible. [Contactez l'auteur du dépôt en privé](https://developpeur-pascal.fr/nous-contacter.php) pour expliquer votre trouvaille.

## Supportez ce projet et son auteur

Si vous trouvez ce dépôt de code utile et voulez le montrer, merci de faire une donation [à son auteur](https://github.com/DeveloppeurPascal). Ca aidera à maintenir le projet (codes sources et binaires).

Vous pouvez utiliser l'un de ces services :

* [GitHub Sponsors](https://github.com/sponsors/DeveloppeurPascal)
* [Liberapay](https://liberapay.com/PatrickPremartin)
* [Patreon](https://www.patreon.com/patrickpremartin)
* [Paypal](https://www.paypal.com/paypalme/patrickpremartin)

ou si vous parlez français vous pouvez [vous abonner à Zone Abo](https://zone-abo.fr/nos-abonnements.php) sur une base mensuelle ou annuelle et avoir en plus accès à de nombreuses ressources en ligne (vidéos et articles).

## Packs de projets

Afin de me simplifier les sauvegardes du compte GitHub ou l'installation locale de projets je propose plusieurs packs de dépôts thématiques. Vous pouvez les utiliser pour télécharger les projets concernés et les consulter. Il est probable qu'ils ne soient pas compilables tels quels mais ça vous donnera une idée des projets open sources disponibles sur [mon compte GitHub](https://github.com/DeveloppeurPascal) et vous pourrez toujours y accéder directement.

* [jeux vidéos](https://github.com/DeveloppeurPascal/DevPas-Games-Pack)
* [utilitaires et applications mobiles](https://github.com/DeveloppeurPascal/DevPas-WorkingPrograms-Pack)
* [librairies et composants](https://github.com/DeveloppeurPascal/DevPas-Components-Pack)
* [modèles de dépôts de code et kits de démarrage de projets](https://github.com/DeveloppeurPascal/DevPas-TemplatesAndStarterKits-Pack)
* [l'intégralité des projets publics de mon compte](https://github.com/DeveloppeurPascal/_AllProjects)

Pour préparer mon environnement de travail de développeur Delphi sur un nouvel ordinateur ou une nouvelle VM sous Windows j'ai également prévu [un script d'installation](https://github.com/DeveloppeurPascal/__MyMinimalDependenciesForWorkingWithDelphi). Vous pouvez l'utiliser tel quel ou vous en inspirer si vous utilisez mes librairies ou composants.

Si vous êtes plutôt à la recherche d'exemples et de démos pour savoir comment utiliser certaines fonctionnalités de Delphi regardez [ce dépôt de code](https://github.com/DeveloppeurPascal/Delphi-samples) et [sa liste d'autres dépôts d'exemples](https://github.com/DeveloppeurPascal/Delphi-samples/blob/main/OtherDelphiSampleRepositories.md).
