# Apprendre la programmation avec Delphi

Projets Delphi d'exemples développés pendant la formation en ligne gratuite pour apprendre à programmer en utilisant le langage Pascal dans Delphi réalisée en direct entre le 23 mars 2020 et le 5 mai 2020 durant le premier confinement quasi mondial lié à la pandémie du virus COVID-19.

## A propos de la formation

Cette formation est destinée à tou(te)s, même aux non informaticien(ne)s.

Les bases de la programmation ont été abordées en utilisant [le langage Pascal](https://developpeur-pascal.fr/pascal-objet.html) et [Delphi](https://developpeur-pascal.fr/delphi.html) comme supports. Les frameworks [VCL](https://developpeur-pascal.fr/vcl.html) et [FireMonkey (FMX)](https://developpeur-pascal.fr/fmx.html) de Delphi ont été traités pour finir avec le déploiement des logiciels et leur diffusion. Le développement de logiciels pour Windows, macOS et Linux, comme d'applications mobiles pour iOS et Android a été traité.

La formation a été faite sur la version 10.3.3 Rio de Delphi. Vous pouvez la suivre avec la version [Community Edition](https://www.embarcadero.com/fr/products/delphi/starter), une version d'évaluation ou une version payante en téléchargement depuis [le site d'Embarcadero](https://www.embarcadero.com).

Les rediffusions des 27 sessions de direct sont disponibles sur 
* [une playlist](https://www.youtube.com/playlist?list=PLHLdMyq6m8_s-OxVA_qZ4O_YvVgl_1nOp) de [la chaîne YouTube de Barnsten France](https://www.youtube.com/@BarnstenFrance),
* [en accès libre sans publicités](https://apprendre-delphi.fr/apprendre-la-programmation-avec-delphi-2020.php) depuis [Apprendre Delphi](https://apprendre-delphi.fr) où vous trouverez d'autres cours de programmation sur Delphi et des outils liés.

Un "guide de la formation", sous forme de livre en impression à la demande et en version numérique, sortira un jour. Il est pour le moment [en précommande](https://boutique.olfsoftware.fr/l/ApprendreLaProgrammationAvecDelphi).

## C'est quoi Delphi ?

Si vous ne connaissez pas Delphi et le langage Pascal, profitez de [la version Academic](https://www.embarcadero.com/development-tools-for-education) (pour les étudiants, enseignants et établissements d'enseignement) ou [Community Edition](https://www.embarcadero.com/fr/products/delphi/starter) (gratuite pour une utilisation personnelle) disponibles chez [Embarcadero](https://www.embarcadero.com).

Professionnels ou en entreprise vous pouvez aussi tester Delphi avec [la version d'évaluation](https://www.embarcadero.com/products/delphi).

## Des ressources en ligne en français

Des conférences en ligne et des webinaires (points techniques sur des sujets précis) sont organisés régulièrement. Consultez [le planning de ces webinaires](https://developpeur-pascal.fr/webinaires.html) et suivez les [rediffusions des webinaires Delphi](https://serialstreameur.fr/webinaires-delphi.php).

Des sessions de [live coding sur Twitch](https://www.twitch.tv/patrickpremartin) sont proposées de temps en temps par Patrick Prémartin. Consultez [son planning hebdomadaire](https://www.twitch.tv/patrickpremartin/schedule) et [l'actualité](https://developpeur-pascal.fr/actualite.html) du [blog Developpeur Pascal](https://developpeur-pascal.fr/) pour en savoir plus.

Les rediffusions des directs sur Twitch sont mises en ligne sur [Serial Streameur](https://serialstreameur.fr/) où vous trouverez aussi des vidéos en français à destination des développeurs de [logiciels](https://serialstreameur.fr/logiciels.php), [applications mobiles](https://serialstreameur.fr/applications-mobiles.php), [sites web](https://serialstreameur.fr/sites-web.php) et [jeux vidéo](https://serialstreameur.fr/jeux-video.php).

Si vous préférez la lecture à la vidéo vous trouverez tous les livres récents publiés sur Delphi et le langage Pascal sur [Delphi Books](https://delphi-books.com).

Côté web suivez les aggrégateurs de liens [Begin End](https://www.beginend.net) et [Delphi Feeds](https://www.delphifeeds.com) ou consultez ces annuaires communautaires de [liens dédiés au Pascal](https://pascal-resources.developpeur-pascal.fr) et [à Delphi](https://delphi-resources.developpeur-pascal.fr).

Et pour finir vous trouverez de nombreux exemples de projets Delphi complets ou d'utilisations de fonctionnalités sur [ce dépôt de code](https://github.com/DeveloppeurPascal/Delphi-samples) qui [en liste plein d'autres](https://github.com/DeveloppeurPascal/Delphi-samples/blob/main/OtherDelphiSampleRepositories.md).

## Licence d'utilisation de ce dépôt de code et de son contenu

Ces codes sources sont distribués sous [licence MIT](LICENSE).

Vous êtes globalement libre d'utiliser le contenu de ce dépôt de code n'importe où à condition :
* d'en faire mention dans vos projets
* de diffuser les modifications apportées aux fichiers fournis dans ce projet sous licence MIT (en y laissant les mentions de copyright d'origine (auteur, lien vers ce dépôt, licence) obligatoirement complétées par les vôtres)
* de diffuser les codes sources de vos créations sous licence MIT

Si cette licence ne convient pas à vos besoins vous pouvez acheter un droit d'utilisation de ce projet sous la licence [Apache License 2.0](https://choosealicense.com/licenses/apache-2.0/) ou une licence commerciale dédiée ([contactez l'auteur](https://developpeur-pascal.fr/nous-contacter.php) pour discuter de vos besoins).

Ces codes sources sont fournis en l'état sans garantie d'aucune sorte.

Certains éléments inclus dans ce dépôt peuvent dépendre de droits d'utilisation de tiers (images, sons, ...). Ils ne sont pas réutilisables dans vos projets sauf mention contraire.

## Comment demander une nouvelle fonctionnalité, signaler un bogue ou une faille de sécurité ?

Si vous voulez une réponse du propriétaire de ce dépôt la meilleure façon de procéder pour demander une nouvelle fonctionnalité ou signaler une anomalie est d'aller sur [le dépôt de code sur GitHub](https://github.com/DeveloppeurPascal/Apprendre-la-programmation-avec-Delphi) et [d'ouvrir un ticket](https://github.com/DeveloppeurPascal/Apprendre-la-programmation-avec-Delphi/issues).

Si vous avez trouvé une faille de sécurité n'en parlez pas en public avant qu'un correctif n'ait été déployé ou soit disponible. [Contactez l'auteur du dépôt en privé](https://developpeur-pascal.fr/nous-contacter.php) pour expliquer votre trouvaille.

Vous pouvez aussi cloner ce dépôt de code et participer à ses évolutions en soumettant vos modifications si vous le désirez. Lisez les explications dans le fichier [CONTRIBUTING.md](CONTRIBUTING.md).

## Supportez ce projet et son auteur

Si vous trouvez ce dépôt de code utile et voulez le montrer, merci de faire une donation [à son auteur](https://github.com/DeveloppeurPascal). Ca aidera à maintenir le projet (codes sources et binaires).

Vous pouvez utiliser l'un de ces services :

* [GitHub Sponsors](https://github.com/sponsors/DeveloppeurPascal)
* [Liberapay](https://liberapay.com/PatrickPremartin)
* [Patreon](https://www.patreon.com/patrickpremartin)
* [Paypal](https://www.paypal.com/paypalme/patrickpremartin)

ou si vous parlez français vous pouvez [vous abonner à Zone Abo](https://zone-abo.fr/nos-abonnements.php) sur une base mensuelle ou annuelle et avoir en plus accès à de nombreuses ressources en ligne (vidéos et articles).
