/// <summary>
/// ***************************************************************************
///
/// Apprendre la programmation avec Delphi
///
/// Copyright 2020-2024 Patrick Prmartin under AGPL 3.0 license.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
/// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
/// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
/// DEALINGS IN THE SOFTWARE.
///
/// ***************************************************************************
///
/// Projets Delphi d'exemples dvelopps pendant la formation en ligne gratuite pour apprendre  programmer en utilisant le langage Pascal dans Delphi ralise en direct entre le 23 mars 2020 et le 5 mai 2020 durant le premier confinement quasi mondial li  la pandmie du virus COVID-19.
///
/// ***************************************************************************
///
/// Author(s) :
///      Patrick PREMARTIN
///
/// Site :
///      https://apprendre-delphi.fr/apprendre-la-programmation-avec-delphi-2020.php
///
/// Project site :
///      https://github.com/DeveloppeurPascal/Apprendre-la-programmation-avec-Delphi
///
/// ***************************************************************************
/// File last update : 30/05/2024 20:10:12
/// Signature : 9813bb04b021dddf01926927641241e6a2b516b7
/// ***************************************************************************
/// </summary>

unit uDM;

interface

uses
  System.SysUtils, System.Classes, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Error, FireDAC.UI.Intf, FireDAC.Phys.Intf, FireDAC.Stan.Def,
  FireDAC.Stan.Pool, FireDAC.Stan.Async, FireDAC.Phys, FireDAC.Phys.SQLite,
  FireDAC.Phys.SQLiteDef, FireDAC.Stan.ExprFuncs, FireDAC.FMXUI.Wait,
  FireDAC.Stan.Param, FireDAC.DatS, FireDAC.DApt.Intf, FireDAC.DApt, Data.DB,
  FireDAC.Comp.DataSet, FireDAC.Comp.Client;

type
  Tdm = class(TDataModule)
    dbContacts: TFDConnection;
    tabContacts: TFDTable;
    tabContactsid: TFDAutoIncField;
    tabContactsnom: TStringField;
    tabContactsprenom: TStringField;
    tabContactstelephone: TStringField;
    tabContactsemail: TStringField;
    tabContactsurl: TStringField;
    tabContactsNomPrenom: TStringField;
    procedure tabContactsCalcFields(DataSet: TDataSet);
    procedure dbContactsBeforeConnect(Sender: TObject);
    procedure DataModuleCreate(Sender: TObject);
    procedure dbContactsAfterConnect(Sender: TObject);
  private
    { Dclarations prives }
    BaseExistante: boolean;
  public
    { Dclarations publiques }
  end;

var
  dm: Tdm;

implementation

{%CLASSGROUP 'FMX.Controls.TControl'}
{$R *.dfm}

uses System.IOutils;

procedure Tdm.DataModuleCreate(Sender: TObject);
begin
  if not dbContacts.Connected then
    dbContacts.Open;
end;

procedure Tdm.dbContactsAfterConnect(Sender: TObject);
begin
  if not BaseExistante then
  begin
    dbContacts.ExecSQL('CREATE TABLE contacts (' +
      'id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,' +
      'nom VARCHAR(255) NULL,' + 'prenom VARCHAR(255) NULL,' +
      'telephone VARCHAR(255) NULL,' + 'email VARCHAR(255) NULL,' +
      'url VARCHAR(255) NULL);');
    dbContacts.ExecSQL('CREATE UNIQUE INDEX nomprenom ON contacts' +
      '(nom,prenom,id);');
  end;
  tabContacts.Open;
end;

procedure Tdm.dbContactsBeforeConnect(Sender: TObject);
var
  NomFichierDB: string;
begin
  NomFichierDB := tpath.Combine(tpath.getdocumentspath, 'DelphiBootCamp');
  if not tdirectory.Exists(NomFichierDB) then
    tdirectory.CreateDirectory(NomFichierDB);
  dbContacts.Params.Clear;
  dbContacts.Params.addpair('DriverID', 'SQLite');
{$IFDEF RELEASE}
  NomFichierDB := tpath.Combine(NomFichierDB, 'GestionContacts.db');
  dbContacts.Params.addpair('LockingMode', 'Exclusive');
{$ELSE}
  NomFichierDB := tpath.Combine(NomFichierDB, 'GestionContacts-debug.db');
  dbContacts.Params.addpair('LockingMode', 'Normal');
{$ENDIF}
  dbContacts.Params.addpair('Database', NomFichierDB);
  BaseExistante := tfile.Exists(NomFichierDB);
end;

procedure Tdm.tabContactsCalcFields(DataSet: TDataSet);
begin
  DataSet.FieldByName('NomPrenom').AsString := DataSet.FieldByName('nom')
    .AsString + ' ' + DataSet.FieldByName('prenom').AsString;
end;

end.
