# Contributing guidelines

## Before contributing

Welcome to [Web Scraping](https://github.com/Developer-Student-Clubs-MMDU/Web-Scraping) repository! Before sending your pull requests, make sure that you __read the below mentioned guidelines carefully__. If you have any doubt on the contributing guide, please feel free to _state it clearly in an issue_ or ask the community in _our discord channel_.


### Contributor

We are very happy that you consider implementing Web Scraping for others! This repository is referenced and used by learners from all over the globe. Being one of our contributors, you agree and confirm that:

- You own your work
- Any plagiarized work will not be merged.
- Your work will be distributed under [MIT License](https://github.com/Developer-Student-Clubs-MMDU/Hacktoberfest/blob/master/LICENSE.md)
- Your work should follow our styles and standards

### Contribution

We appreciate every contribution, from contributing documentation to implementing different web automation.

Please help us keep our issue list small by adding `fixes: #{$ISSUE_NO}` to the commit message of pull requests that resolve open issues. GitHub will use this tag to auto-close the issue when the PR is merged.

### Topics included in this repository:

- Web Scraping
- Web Automation
- Selenium
- Beautiful Soup

### Coding Style

We want your work to be readable by others; therefore, we encourage you to note the following:

- Please focus hard on the naming of functions, classes, and variables.
- Help your reader by using __descriptive names__ that can help you to remove redundant comments.
- Please follow the [Python Naming Conventions](https://pep8.org/#prescriptive-naming-conventions)
- Add the `autopep8` package to your project.

### Other Requirements for Submissions
- The file extension for code files should be `.py`
- Strictly use snake_case (underscore_separated) in your file_name, as it will be easy to parse in future using scripts.
- Please create new directories with your project name.
- If you have modified/added code work, make sure the code compiles before submitting.
- If you have modified/added documentation work, ensure your language is concise and contains no grammar errors.
