# BLoC Design Patterns in Applications Development with Flutter

<strong> Exploring `BLoC Pattern` to manage `states in Flutter` applications </strong><br>
Version: 1.0.1<br>
Author (Learn & Share): <em>Nguyen Truong Thinh</em><br> 

## References :wave:
<em>A few resources to get you started if this is your first Flutter project:<em>
- [Lab: Write your first Flutter app](https://flutter.dev/docs/get-started/codelab)
- [Cookbook: Useful Flutter samples](https://flutter.dev/docs/cookbook)

<em>For help getting started with Flutter, view our:<em>
- [online documentation](https://flutter.dev/docs), which offers tutorials,
samples, guidance on mobile development, and a full API reference.<br>

<em>To help grasp our project's source code:<em>
- [Pragmatic Flutter: Building Cross-Platform Mobile Apps for Android, iOS, Web & Desktop](https://www.routledge.com/Pragmatic-Flutter-Building-Cross-Platform-Mobile-Apps-for-Android-iOS/Tyagi/p/book/9780367612092)
- [Beginning Flutter: A Hands On Guide to App Development](https://www.wiley.com/en-sg/Beginning+Flutter%3A+A+Hands+On+Guide+to+App+Development-p-9781119550853)
- [Flutter Complete Reference](https://fluttercompletereference.com/buy)
- [Managing State in Flutter Pragmatically](https://www.packtpub.com/product/managing-state-in-flutter-pragmatically/9781801070775)

## Notes :cook:
 - BLoC - Business Logic Component: is a design pattern to facilitate data flow to Flutter Widgets & vice versa.<br>The BLoC receives streams of the event(s) from data sources and/ or widgets, perform business logic on events received and emits corresponding states.
 1. Basic BLoC Pattern: Use Dart's built-in data types to manages the state
 2. Improvised BLoC Pattern: Create classes representing event(s) and state(s)
 3. BLoC Library: Use the `flutter_bloc` library to implement the BLoC pattern.

## Improve us :handshake:
<strong><em>:star: Please give me a STAR! :star:<em><strong>