![Logo](https://i.imgur.com/l4lJokp.png)

# Learn-Flutter

- An super list that curates the nice Flutter libraries, equipment, tutorials, articles and more.
- [Flutter](https://flutter.dev/) is Google’s UI toolkit for building beautiful, natively compiled applications for mobile, web, and desktop from a single codebase.

## Official Documentation: 

* [Installation](https://flutter.dev/docs/get-started/install)
* [IDE Support](https://flutter.dev/docs/get-started/editor)
* [Widgets Catalog](https://flutter.dev/docs/development/ui/widgets)
* [Codelabs](https://flutter.dev/docs/codelabs)
* [Cookbook](https://flutter.dev/docs/cookbook)
* [Tutorials](https://flutter.dev/docs/reference/tutorials)
* [Flutter API Reference](https://api.flutter.dev/)

## Roadmap

<a href="https://whimsical.com/flutter-roadmap-2022-PC4hELGBR3mhLQdsnvBC9j" target="_blank"><img src="https://raw.githubusercontent.com/Dev-Adnani/Learn-Flutter/main/rmap.png"></a>

Check The Full Roadmap : [Roadmap](https://whimsical.com/flutter-roadmap-2022-PC4hELGBR3mhLQdsnvBC9j)


## Youtube Channels & Playlists:

- [Flutter](https://www.youtube.com/c/flutterdev) - The official flutter channel is the best place to get started
- [The Net Ninja](https://www.youtube.com/c/TheNetNinja) - One of the best channels for flutter in English
- [Sanskar Tiwari](https://www.youtube.com/channel/UCsPdgUIoOBTBI1UmulW1pdw) - A channel for beautiful UI and API integration.
- [Devefy](https://www.youtube.com/channel/UC9dwxEAvy-zCMAS7rdox46w) - A channel for UI and flutter web tutorials
- [Raja Yogan](https://www.youtube.com/channel/UCjBxAm226XZvgrkO-JyjJgQ) - A channel for logical and Backend tutorials for flutter
- [The Flutter Way](https://www.youtube.com/channel/UCJm7i4g4z7ZGcJA_HKHLCVw) - A channel for creating beautiful UIs
- [Reso Coder](https://www.youtube.com/c/ResoCoder) - Reso Coder by [Matt Rešetár] Matt is an app developer with a knack for teaching others. Working as a Flutter freelancer and most importantly developer educator
- [Mtechviral](https://www.youtube.com/c/MTechViral) - First Indian YouTuber who started flutter tutorials
- [Easy Approach](https://www.youtube.com/channel/UC4hWRtPpBaq72ERUuKsvO7g) - A great channel which teaches complex flutter concepts in a simple manner with short and crisp videos.
- [RetroPortal Studio](https://www.youtube.com/channel/UCW2ATgwtNrsBrE-piE2TIrA) - An amazing channel for UI and custom widgets development
- [Santos Enoque](https://www.youtube.com/watch?v=Dy_zBF6rJFc&list=PLmnT6naTGy2SC82FMSCrvZNogg5T1H7iF) - Building an E-commerce app in Flutter
- [Academind](https://www.youtube.com/watch?v=x0uinJvhNxI) - An entire crash course for beginners in Flutter
- [FreeCodeCamp.org](https://www.youtube.com/watch?v=pTJJsmejUOQ) - A full tutorial for building iOS and Android apps in Flutter
- [Google Developers](https://www.youtube.com/watch?v=fq4N0hgOWzU&list=PLOU2XLYxmsIJ7dsVN4iRuA7BT8XHzGtCr) - A playlist of Flutter guides from Google themselves
- [Afgprogrammer](https://www.youtube.com/channel/UCuXm84E6yWF0dIKmwvwc9sQ) - An extremely helpful channel for user interface design.
- [Techie Blossom](https://www.youtube.com/channel/UC3wqIkiaOUpO6EjJoCwH6_Q) - Showing tutorial videos for industry standard apps using flutter.
- [FilledStacks](https://www.youtube.com/c/FilledStacks/playlists) - A Channel for Flutter Production Code
- [ReactBits](https://www.youtube.com/c/ReactBits/playlists) - Flutter + Appwrite Tutorial Series
- [Flutter Explained](https://www.youtube.com/c/FlutterExplained) - The Wikipedia For Flutter development
- [Flutter in Practice](https://www.youtube.com/playlist?list=PLhXZp00uXBk5TSY6YOdmpzp1yG3QbFvrN) - Practical programming course for beginners
- [Desi programmer](https://www.youtube.com/c/DesiProgrammer) - Here you can also get some tutorials in Hindi
- [Ovidius Mazuru](https://www.youtube.com/channel/UCJW25d8mW8ciz0DQC-5XNsQ/featured) - A Channel for beginners in Flutter to have a strong fundamental understanding
- [CodeX](https://www.youtube.com/c/CodeXdev/playlists) - CodeX shares tutorial videos related to Mobile Application Development and other programming aspects. If you're student, beginner programmer or even expert developer consider subscribing the channel to be updated with latest of Mobile development.
- [Reso Coder](https://www.youtube.com/channel/UCSIvrn68cUk8CS8MbtBmBkA) - Reso Coder by [Matt Rešetár] Matt is an app developer with a knack for teaching others. Working as a Flutter freelancer and most importantly developer educator.
- [Babbar CODE HELP](https://www.youtube.com/channel/UCldyi11QYNXYXiLjVbyw5dA) - Have a Flutter Series 2020 playlist in Hindi (Project Based Learning) .
- [Marcus Ng](https://www.youtube.com/c/MarcusNg/videos) - Marcus gives amazing tutorials for web & mobile responsive UI.
- [Mitch Koko](https://www.youtube.com/c/MitchKoko/videos) - This channel has some awesome small games implemented in Flutter with really cool UIs.
- [Raja Yogan](https://www.youtube.com/watch?v=p3YNDjaCgxc) - A channel for flutter + firebase tutorials, you will learn how to make automated push notification.
- [Johannes Milke](https://www.youtube.com/channel/UC0FD2apauvegCcsvqIBceLA) - A useful channel with short, helpful videos to learn about Flutter widgets & other cool stuff.
- [Code With Andrea](https://www.youtube.com/channel/UCrTnsT4OYZ53l0QGKqLeD5Q) - A helpful channel to learn Dart & Flutter. Andrea, the instructor explains well.
- [Osama Asif](https://www.youtube.com/channel/UC9rZnxaqFwTZYMzuJUEKOLQ) - This channel has some awesome content in Flutter.
- [London App Brewery](https://www.youtube.com/channel/UCVD5Vh9LhLBxp3o1vRNyf_w) - The best channel to learn Flutter.
- [Tech with Tim](https://www.youtube.com/playlist?list=PLzMcBGfZo4-knQWGK2IC49Q_5AnQrFpzv) - Great tutorials for beginners.


## Articles, Tutorials, Blogs etc.

* [Flutter-io @ Medium](https://medium.com/flutter-io)
* [Zero to one with Flutter @ Medium](https://medium.com/flutter-io/zero-to-one-with-flutter-43b13fd7b354)
* [Planets-Flutter: From design to app](https://sergiandreplace.com//tags/flutter/)
* [Flutter routes and Navigation @ Medium](https://proandroiddev.com/flutter-routes-and-navigation-69f128a9ea8f)
* [Translating App from RN to Flutter](https://blog.geekyants.com/we-rebuilt-a-react-native-app-with-flutter-4160f0499a82)
* [How to build a Simple App in Under an Hour From Scratch @ Medium](https://proandroiddev.com/flutter-how-i-built-a-simple-app-in-under-an-hour-from-scratch-and-how-you-can-do-it-too-6d8e7fe6c91b)
* [Creating medium’s clap animation in flutter](https://medium.com/@Kartik1607/flutter-animation-creating-mediums-clap-animation-in-flutter-3168f047421e)
* [Build your own plugin for flutter](https://proandroiddev.com/build-your-own-plugin-for-flutter-cfee1a08ea3a)
* [Flutter, ListView and GridView with TabBar](https://medium.com/@vigneshprakash15/flutter-listview-and-gridview-with-tabbar-221516518c75)
* [Getting Your Hands Dirty with Flutter: Basic Animations](https://proandroiddev.com/getting-your-hands-dirty-with-flutter-basic-animations-6b9f21fa7d17)
* [Pinterest-Style Photo Grids](https://medium.com/@ezra_69528/flutter-pinterest-style-photo-grids-b99289584b71)
* [Forms in Flutter](https://medium.com/@anilcan/forms-in-flutter-6e1364eafdb5)
* [Login Form Animation](https://blog.geekyants.com/flutter-login-animation-ab3e6ed4bd19)
* [Animating Appbar like Instagram](https://flutterdoc.com/animating-app-bars-in-flutter-cf034cd6c68b)
* [Dynamic Home Page](https://medium.com/@anilcan/how-to-use-dynamic-home-page-in-flutter-83080da07012)
* [Bubble tab indicator for TabBar](https://android.jlelse.eu/flutter-bubble-tab-indicator-for-tabbar-dd038f1076d3)
* [Input widgets](http://tphangout.com/flutter-input-widgets/)
* [Building a snapchat-like interface in Flutter](https://medium.com/@kr1uz/building-a-snapchat-like-interface-in-flutter-aafb7e59c8a5)
* [Flutter Layouts Walkthrough: Row, Column, Stack, Expanded, Padding](https://github.com/bizz84/layout-demo-flutter)
* [Localization tutorial](https://proandroiddev.com/flutter-localization-step-by-step-30f95d06018d)
* [BoxDecoration Cheat Sheet](https://medium.com/jlouage/flutter-boxdecoration-cheat-sheet-72cedaa1ba20)
* [How to dynamically change the theme in Flutter](https://proandroiddev.com/how-to-dynamically-change-the-theme-in-flutter-698bd022d0f0)
* [Simple Milky Way animation with Flutter](https://medium.com/@duytq94/simple-milky-way-animation-with-flutter-1ea936c145bf)
* [Bottom Modal Sheets](https://flutterdoc.com/bottom-sheets-in-flutter-ec05c90453e7)
* [Launching Flutter Task Listing App Theme](https://blog.geekyants.com/launching-flutter-task-listing-app-75ab70cfd713)
* [Restaurant animation with Flutter](https://medium.com/@duytq94/restaurant-animation-with-flutter-cbe704b4e20f)
* [Text & Barcode Scanner App with Firebase ML Kit](https://medium.com/@alfianlosari/flutter-text-barcode-scanner-app-with-firebase-ml-kit-103db6b6dad7)
* [Steppers and Form in Flutter](https://medium.com/@aseemwangoo/steppers-and-form-in-flutter-49cda857230c)
* [Easily navigate through your Flutter code by separating view and view-model](https://blog.usejournal.com/easily-navigate-through-your-flutter-code-by-separating-view-and-view-model-240026191106)
* [Creating draggable scrollbar](https://medium.com/flutter-community/creating-draggable-scrollbar-in-flutter-a0ae8cf3143b)
* [Animations in Flutter](https://proandroiddev.com/animations-in-flutter-6e02ee91a0b2)
* [Swipe for more action widget](https://medium.com/@info_67212/flutter-swipe-your-widget-for-more-action-items-2b85866ca238)
* [Beautiful List UI and Detail page](https://proandroiddev.com/flutter-thursday-02-beautiful-list-ui-and-detail-page-a9245f5ceaf0)
* [Displaying Dynamic Contents using ListView.builder](https://medium.com/@DakshHub/flutter-displaying-dynamic-contents-using-listview-builder-f2cedb1a19fb)
* [Unit and Widget Tests in Depth](https://medium.com/coding-with-flutter/flutter-unit-and-widget-tests-in-depth-b059b09bc692)
* [UI CHALLENGE – FLIGHT SEARCH](https://marcinszalek.pl/flutter/ui-challenge-flight-search/)
* [Mapbox and Polylines](http://tphangout.com/flutter-mapbox-and-polylines/)
* [Flutter Crush](https://medium.com/flutter-community/flutter-crush-debee5f389c3)
* [Adding Google Maps to Flutter](https://medium.com/flutter-io/google-maps-and-flutter-cfb330f9a245)
* [GPS Geolocation Tutorial](https://morioh.com/p/832f968ed090/flutter-gps-geolocation-tutorial)
* [Get A User’s Location In Flutter](https://medium.com/flutter-community/get-a-users-location-in-flutter-20f488ac8043)
* [How to code sign & publish iOS apps](https://blog.codemagic.io/how-to-code-sign-publish-ios-apps/)
* [Continuous Integration and Deployment with Flutter and Fastlane](https://medium.com/@arneolaim/continuous-integration-and-deployment-with-flutter-and-fastlane-a927014723e1)
* [Using SharedPreferences in Flutter](https://medium.com/flutterdevs/using-sharedpreferences-in-flutter-251755f07127)
* [How to parse Json in Flutter for Beginners](https://medium.com/flutter-community/how-to-parse-json-in-flutter-for-beginners-8074a68d7a79)
* [Create Custom Component](https://santoshanand.me/2019/05/04/create-custom-component/)
* [A Guide to Using Futures in Flutter for Beginners](https://medium.com/flutter-community/a-guide-to-using-futures-in-flutter-for-beginners-ebeddfbfb967)
* [Build a Location Service in Flutter](https://medium.com/flutter-community/build-a-location-service-in-flutter-367a1b212f7a)
* [Stateful vs Stateless Widgets](https://medium.com/flutter-community/flutter-stateful-vs-stateless-db325309deae)
* [Flutter Passwordless Authentication](https://medium.com/@hajola/flutter-passwordless-authentication-a-guide-for-phone-email-login-6759252f4e)
* [To-do List in Flutter with SQLite as local database](https://medium.com/@abeythilakeudara3/to-do-list-in-flutter-with-sqlite-as-local-database-8b26ba2b060e)
* [The Ultimate Javascript vs Dart Syntax Guide](https://flutterigniter.com/ultimate-javascript-dart-syntax-guide/)
* [Implement Real-time Location Updates on Google Maps in your Flutter Apps](https://medium.com/flutter-community/implement-real-time-location-updates-on-google-maps-in-flutter-235c8a09173e)
* [Monitor Your Flutter App’s Health End to End With GitHub Actions](https://medium.com/better-programming/monitor-your-flutter-apps-health-end-to-end-with-github-actions-8a9fb1889c6a)
* [Using MQTT With Flutter to Build a Location Sharing App](https://medium.com/swlh/using-mqtt-with-flutter-to-build-a-location-sharing-app-24e7307b21d3)
* [Apple Sign In with Flutter & Firebase Authentication](https://codewithandrea.com/videos/2020-01-20-apple-sign-in-flutter-firebase/)

## Books

- [Flutter Complete Reference](https://fluttercompletereference.com/) - Complete reference to Flutter developement, including examples.
- [Beginning App Development with Flutter](https://www.amazon.com/Beginning-App-Development-Flutter-Cross-Platform/dp/1484251806) - Easy to understand starter book.
- [Flutter for Beginners](https://www.amazon.com/Flutter-Beginners-introductory-cross-platform-applications/dp/1788996089) - A step-by-step guide to learning Flutter and Dart 2.X
- [Learn Google Flutter Fast: 65 Example Apps](https://www.amazon.com/Learn-Google-Flutter-Fast-Example/dp/1092297375) - Learn Google Flutter by example. Over 65 example mini-apps.
- [Practical Flutter Improve your Mobile Development with Google’s Latest Open-Source SDK](https://www.amazon.com/Practical-Flutter-Improve-Development-Open-Source-ebook/dp/B07VJ7FDN5) - Concise practical examples for quick and easy build

## Courses

* [Udacity - Build Native Mobile Apps With Flutter](https://www.udacity.com/course/build-native-mobile-apps-with-flutter--ud905) 
* [Angela Yu on Youtube - How to Build Flutter Apps for iOS and Android](https://www.youtube.com/playlist?list=PLSzsOkUDsvdtl3Pw48-R8lcK2oYkk40cm)  
* [Udemy - Learn Flutter Begginers Course](https://www.udemy.com/learn-flutter-beginners-course/)
* [Udemy - Learn Flutter & Dart to Build iOS & Android Apps](https://www.udemy.com/course/learn-flutter-dart-to-build-ios-android-apps/) 
* [Udemy - The Complete 2020 Flutter Development Bootcamp with Dart](https://www.udemy.com/course/flutter-bootcamp-with-dart/)  
* [Udemy - Flutter & Firebase: Build a Complete App for iOS & Android](https://www.udemy.com/course/flutter-firebase-build-a-complete-app-for-ios-android/) 


## State management

- [Bloc](https://github.com/felangel/bloc)  - Collection of packages that help implement the BLoC design pattern by [Felix Angelov](https://github.com/felangel).
- [MobX](https://github.com/mobxjs/mobx.dart)  - Supercharge the state-management in your apps with Transparent Functional Reactive Programming (TFRP). Port of MobX from the Js/React land.
- [Provider](https://github.com/rrousselGit/provider)  - State-management library for Flutter by [Remi Rousselet](https://github.com/rrousselGit).
- [RiverPod](https://github.com/rrousselGit/river_pod)  - Provider, but different by [Remi Rousselet](https://github.com/rrousselGit).
- [GetX](https://github.com/jonataslaw/getx) - Contextless, State-management & navigation by [Jonny Borges](https://github.com/jonataslaw).

## Testing

- [Testing Flutter Apps](https://medium.com/flutter-community/flutter-scalable-folder-files-structure-8f860faafebd)
- [How to Test Flutter Apps](https://codelabs.developers.google.com/codelabs/flutter-app-testing#0)
- [Flutter Testing For Beginners - The Ultimate Guide](https://www.youtube.com/watch?v=RDY6UYh-nyg)
- [Testing Flutter Apps: Making Sure Your Code Works](https://www.youtube.com/watch?v=bj-oMYyLZEY)
- [Unit Testing With Flutter: Getting Started](https://www.raywenderlich.com/6926998-unit-testing-with-flutter-getting-started)
- [Unit and Widget Testing in Flutter](https://www.youtube.com/watch?v=SNv0cX0-6h8)
- [Flutter: Deep Dive with Widget Tests and Mockito](https://www.youtube.com/watch?v=75i5VmTI6A0)
- [Integration Testing](https://flutter.dev/docs/testing/integration-tests)
- [Updates on Flutter Testing](https://medium.com/flutter/updates-on-flutter-testing-f54aa9f74c7e)

## Useful Blogs/Websites
- [Flutter Dev's](http://flutterdevs.com/blog/) 
- [Flutter Medium](https://medium.com/flutter) 
- [Dev Flutter](https://dev.to/t/flutter?utm_source=devglan) 
- [Geeky Ant's Flutter](https://blog.geekyants.com/flutter/home)
- [Flutter Gems](https://fluttergems.dev/)

## Guidelines

* Please make an individual pull request for each suggestion
* Use the following format for links: \[Resource\]\(URL\)
* New categories or improvements to the existing categorization are welcome


## Support Me

<a href="https://www.buymeacoffee.com/DevAdnani" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png" alt="Buy Me A Coffee" style="height: 41px !important;width: 174px !important;box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;-webkit-box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;" ></a>

