/*
 * The MIT License (MIT)
 *
 * Copyright (c) Despector <https://despector.voxelgenesis.com>
 * Copyright (c) contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.spongepowered.despector.emitter.java.statement;

import org.spongepowered.despector.ast.stmt.branch.TryCatch;
import org.spongepowered.despector.ast.stmt.branch.TryCatch.CatchBlock;
import org.spongepowered.despector.emitter.StatementEmitter;
import org.spongepowered.despector.emitter.java.JavaEmitterContext;

public class TryCatchEmitter implements StatementEmitter<JavaEmitterContext, TryCatch> {

    @Override
    public void emit(JavaEmitterContext ctx, TryCatch try_block, boolean semicolon) {
        ctx.printString("try {");
        ctx.newLine();
        ctx.indent();
        ctx.emitBody(try_block.getTryBlock());
        ctx.dedent();
        ctx.newLine();
        for (CatchBlock c : try_block.getCatchBlocks()) {
            ctx.printIndentation();
            if (ctx.getFormat().insert_new_line_before_catch_in_try_statement) {
                ctx.printString("}");
                ctx.newIndentedLine();
                ctx.printString("catch (");
            } else {
                ctx.printString("} catch (");
            }
            for (int i = 0; i < c.getExceptions().size(); i++) {
                ctx.emitType(c.getExceptions().get(i));
                if (i < c.getExceptions().size() - 1) {
                    ctx.printString(" | ");
                }
            }
            ctx.printString(" ");
            if (c.getExceptionLocal() != null) {
                ctx.printString(c.getExceptionLocal().getName());
                ctx.isDefined(c.getExceptionLocal());
            } else {
                ctx.printString(c.getDummyName());
            }
            ctx.printString(") {");
            ctx.newLine();
            ctx.indent();
            ctx.emitBody(c.getBlock());
            ctx.dedent();
            ctx.newLine();
        }
        ctx.printIndentation();
        ctx.printString("}");
    }

}
