## External Repositories

This is a listing of external repositories, projects, and libraries that maybe helpful to researchers who work with mobile data. The repositories linked here are the independent work of their corresponding authors, who retain all copyright and may use different licenses. They are simply linked here for convenience.

## Project Listing
+ [@Arcascope **Circadian**](https://github.com/Arcascope/circadian). A computational package for the simulation and analysis of circadian rhythms.
+ [@Arcascope **Device_Calendar**](https://github.com/Arcascope/device_calendar). A cross platform plugin for modifying calendars on the user's device.
+ [@Arcascope **Screen-Scrape**](https://github.com/Arcascope/screen-scrape). Open source script for scraping screen time from screenshots of iPhones.
+ [@DepressionCenter **SleepDataAutomation**](https://github.com/DepressionCenter/SleepDataAutomation). Automated sleep data cleanup and processing to harmonize Fitbit data obtained via Fitabase with self-reported sleep diary entries sent via SMS-to-Email. [10.6084/m9.figshare.25669173.v1].
+ [@faranalytics **Memoiz**](https://github.com/faranalytics/memoiz). Memoiz provides a function decorator that adds memoization to a function or method. It makes reasonable assumptions about how and if to cache the return value of a function or method based on the arguments passed to the callable.
+ [@faranalytics **Flatten It**](https://github.com/faranalytics/flatten_iterables). Flatten It uses iteration (no recursion) to flatten iterables into a dictionary where each key is a reference path and each value is the value at the respective path.
+ [@irinagain **iglu**](https://github.com/irinagain/iglu). R package for Interpreting GLUcose data from CGMs (Continuous Glucose Monitors).
+ [@IrinaStatsLab **GlucoBench**](https://github.com/IrinaStatsLab/GlucoBench). The official implementation of the paper "GlucoBench: Curated List of Continuous Glucose Monitoring Datasets with Prediction Benchmarks." The README is a great example of how to ensure a study is reproducible.
+ [@IrinaStatsLab **Awesome-CGM**](https://github.com/IrinaStatsLab/Awesome-CGM). A collection of links to publicly available continuous glucose monitoring (CGM) data, and pre-processing libraries.
+ [@jamieyap **CountSMART**](https://github.com/jamieyap/CountSMART). Code to estimate sample size needed to compare dynamic treatment regimens using longitudinal count outcomes from a Sequential Multiple Assignment Randomized Trial (SMART).
+ [@manateelab **EMAeval-R-Package**](https://github.com/manateelab/EMAeval-R-Package). The R package EMAeval contains functions created to help researchers identify careless responses as well as responders in Ecological Momentary Assessment (EMA) data.
+ [@ojwalch **actigraphy-scripts**](https://github.com/ojwalch/actigraphy-scripts). Open-source scripts for processing actigraphy data.
+ [@ojwalch **predicting_dlmo**](https://github.com/ojwalch/predicting_dlmo). Source code for predictdlmo.com. It implements the 2007 St. Hilaire model of the human circadian clock to predict DLMO on the last day of a recording in response to uploaded actigraphy data.
+ [@sobradob **shinyapp (ShinyGPS)**](https://github.com/sobradob/shinyapp). An R Shiny App for visualising human movements over time using sensor data from Android devices.
+ [@SRI-Human-Sleep **Sleep-Trackers-Performance**](https://github.com/SRI-human-sleep/sleep-trackers-performance). Analytical pipeline and R functions for testing the performance of sleep-tracking technology.
+ [@Stanford-Health **Wearipedia**](https://github.com/Stanford-Health/wearipedia). A one-stop shop for wearable device data extraction and simulation.
+ [@Standord-STAGES **SleepStagePrediction**](https://github.com/Stanford-STAGES/SleepStagePrediction). Deep learning-based prediction of sleep stages using wearable accelerometry and photoplethysmography.
+ [@tokern **PIIcatcher**](https://github.com/tokern/piicatcher). Scan databases and data warehouses for PII data. Tag tables and columns in data catalogs like Amundsen and Datahub.
+ [@trackthatsleep **snoozr**](https://github.com/trackthatsleep/snoozr). Scraping your Fitbit data for scientific discovery (and longitudinal sleep analyses).
+ [@tryVital **vital-python**](https://github.com/tryVital/vital-python). The Vital Python library provides access to the Vital API (commercial wearable data aggregator) from applications written in Python.
+ [@wadpac **GGIR**](https://github.com/wadpac/GGIR). R package GGIR for raw accelerometer data analysis. A tool to process and analyse data collected with wearable raw acceleration sensors.


## Contributing
If you have a library, re-usable code, or even code snippets that you believe could be helpful for working with mobile data, please send us a pull request or [email us](mailto:efdc-mobiletech@umich.edu) to get added to this list.

