"""Initial migration

Revision ID: 4f57cda68ec2
Revises: 
Create Date: 2024-09-24 23:40:33.832363

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '4f57cda68ec2'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade():
    # 添加 updated_at 字段
    op.add_column('websites', sa.Column('updated_at', sa.DateTime(), nullable=True))

    # 批量将现有数据的 updated_at 设置为当前时间
    connection = op.get_bind()
    connection.execute(
        sa.text("UPDATE websites SET updated_at = CURRENT_TIMESTAMP")  # 修改此行
    )


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('websites', 'updated_at')
    # ### end Alembic commands ###
