{*****************************************************************}
{                                                                 }
{ The contents of this file are subject to the Mozilla Public     }
{ License Version 1.1 (the "License"). you may not use this file  }
{ except in compliance with the License. You may obtain a copy of }
{ the License at http://www.mozilla.org/MPL/MPL-1.1.html          }
{                                                                 }
{ Software distributed under the License is distributed on an     }
{ "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or  }
{ implied. See the License for the specific language governing    }
{ rights and limitations under the License.                       }
{                                                                 }
{ The original code is: JwaIads.h, released .                     }
{                                                                 }
{ The initial developer of the original translation is            }
{ Remko Weijnen ().                                               }
{                                                                 }
{ Portions created by Remko Weijnen are                           }
{ Copyright (C) 2010 Remko Weijnen.                               }
{                                                                 }
{ Portions created by Microsoft are                               }
{ Copyright (C)  Microsoft.                                       }
{                                                                 }
{ All Rights Reserved.                                            }
{                                                                 }
{ Contributor(s):                                                 }
{                                                                 }
{ Notes:                                                          }
{ Remko 25-02-2010:                                               }
{ This file is composed of the header Iads.h from the SDK 7.0 and }
{ the imported typelib from ActiveDs.Tlb. This was necessary      }
{ because the generated pas file from the tlb is incomplete and   }
{ and sometimes totally wrong and causes exceptions.              }
{ Please note that Iads.h was generated by the MIDL compiler with }
{ option Zp8 so all records are aligned on 8 byte boundaries so   }
{ padding is sometimes necessary. I verified the records where it }
{ is explicitly commented so.                                     }
{                                                                 }
{ Modification history:                                           }
{                                                                 }
{ Known Issues:                                                   }
{                                                                 }
{*****************************************************************}
{$IFNDEF JWA_OMIT_SECTIONS}
unit JwaAdsTLB;
{$ENDIF JWA_OMIT_SECTIONS}

{.$I JediAPILib.inc}

{$IFNDEF JWA_OMIT_SECTIONS}
interface
{$I ..\Includes\JediAPILib.inc}
uses
  ActiveX,
  JwaWinType, JwaWinBase;

{$ENDIF JWA_OMIT_SECTIONS}

{$IFNDEF JWA_IMPLEMENTATIONSECTION}

// *********************************************************************//
// GUIDS declared in the TypeLibrary. Following prefixes are used:
//   Type Libraries     : LIBID_xxxx
//   CoClasses          : CLASS_xxxx
//   DISPInterfaces     : DIID_xxxx
//   Non-DISP interfaces: IID_xxxx
// *********************************************************************//
const
  // TypeLibrary Major and minor versions
  ActiveDsMajorVersion = 1;
  ActiveDsMinorVersion = 0;

  LIBID_ActiveDs: TGUID = '{97D25DB0-0363-11CF-ABC4-02608C9E7553}';

  IID_IADs: TGUID = '{FD8256D0-FD15-11CE-ABC4-02608C9E7553}';
  IID_IADsContainer: TGUID = '{001677D0-FD16-11CE-ABC4-02608C9E7553}';
  IID_IADsCollection: TGUID = '{72B945E0-253B-11CF-A988-00AA006BC149}';
  IID_IADsMembers: TGUID = '{451A0030-72EC-11CF-B03B-00AA006E0975}';
  IID_IADsPropertyList: TGUID = '{C6F602B6-8F69-11D0-8528-00C04FD8D503}';
  IID_IADsPropertyEntry: TGUID = '{05792C8E-941F-11D0-8529-00C04FD8D503}';
  CLASS_PropertyEntry: TGUID = '{72D3EDC2-A4C4-11D0-8533-00C04FD8D503}';
  IID_IADsPropertyValue: TGUID = '{79FA9AD0-A97C-11D0-8534-00C04FD8D503}';
  IID_IADsPropertyValue2: TGUID = '{306E831C-5BC7-11D1-A3B8-00C04FB950DC}';
  CLASS_PropertyValue: TGUID = '{7B9E38B0-A97C-11D0-8534-00C04FD8D503}';
  IID_IPrivateDispatch: TGUID = '{86AB4BBE-65F6-11D1-8C13-00C04FD8D503}';
  IID_ITypeInfo: TGUID = '{00020401-0000-0000-C000-000000000046}';
  IID_ITypeComp: TGUID = '{00020403-0000-0000-C000-000000000046}';
  IID_ITypeLib: TGUID = '{00020402-0000-0000-C000-000000000046}';
  IID_IPrivateUnknown: TGUID = '{89126BAB-6EAD-11D1-8C18-00C04FD8D503}';
  IID_IADsExtension: TGUID = '{3D35553C-D2B0-11D1-B17B-0000F87593A0}';
  IID_IADsDeleteOps: TGUID = '{B2BD0902-8878-11D1-8C21-00C04FD8D503}';
  IID_IADsNamespaces: TGUID = '{28B96BA0-B330-11CF-A9AD-00AA006BC149}';
  IID_IADsClass: TGUID = '{C8F93DD0-4AE0-11CF-9E73-00AA004A5691}';
  IID_IADsProperty: TGUID = '{C8F93DD3-4AE0-11CF-9E73-00AA004A5691}';
  IID_IADsSyntax: TGUID = '{C8F93DD2-4AE0-11CF-9E73-00AA004A5691}';
  IID_IADsLocality: TGUID = '{A05E03A2-EFFE-11CF-8ABC-00C04FD8D503}';
  IID_IADsO: TGUID = '{A1CD2DC6-EFFE-11CF-8ABC-00C04FD8D503}';
  IID_IADsOU: TGUID = '{A2F733B8-EFFE-11CF-8ABC-00C04FD8D503}';
  IID_IADsDomain: TGUID = '{00E4C220-FD16-11CE-ABC4-02608C9E7553}';
  IID_IADsComputer: TGUID = '{EFE3CC70-1D9F-11CF-B1F3-02608C9E7553}';
  IID_IADsComputerOperations: TGUID = '{EF497680-1D9F-11CF-B1F3-02608C9E7553}';
  IID_IADsGroup: TGUID = '{27636B00-410F-11CF-B1FF-02608C9E7553}';
  IID_IADsUser: TGUID = '{3E37E320-17E2-11CF-ABC4-02608C9E7553}';
  IID_IADsPrintQueue: TGUID = '{B15160D0-1226-11CF-A985-00AA006BC149}';
  IID_IADsPrintQueueOperations: TGUID = '{124BE5C0-156E-11CF-A986-00AA006BC149}';
  IID_IADsPrintJob: TGUID = '{32FB6780-1ED0-11CF-A988-00AA006BC149}';
  IID_IADsPrintJobOperations: TGUID = '{9A52DB30-1ECF-11CF-A988-00AA006BC149}';
  IID_IADsService: TGUID = '{68AF66E0-31CA-11CF-A98A-00AA006BC149}';
  IID_IADsServiceOperations: TGUID = '{5D7B33F0-31CA-11CF-A98A-00AA006BC149}';
  IID_IADsFileService: TGUID = '{A89D1900-31CA-11CF-A98A-00AA006BC149}';
  IID_IADsFileServiceOperations: TGUID = '{A02DED10-31CA-11CF-A98A-00AA006BC149}';
  IID_IADsFileShare: TGUID = '{EB6DCAF0-4B83-11CF-A995-00AA006BC149}';
  IID_IADsSession: TGUID = '{398B7DA0-4AAB-11CF-AE2C-00AA006EBFB9}';
  IID_IADsResource: TGUID = '{34A05B20-4AAB-11CF-AE2C-00AA006EBFB9}';
  IID_IADsOpenDSObject: TGUID = '{DDF2891E-0F9C-11D0-8AD4-00C04FD8D503}';
  IID_IDirectoryObject: TGUID = '{E798DE2C-22E4-11D0-84FE-00C04FD8D503}';
  IID_IDirectorySearch: TGUID = '{109BA8EC-92F0-11D0-A790-00C04FD8D5A8}';
  IID_IDirectorySchemaMgmt: TGUID = '{75DB3B9C-A4D8-11D0-A79C-00C04FD8D5A8}';
  IID_IADsAggregatee: TGUID = '{1346CE8C-9039-11D0-8528-00C04FD8D503}';
  IID_IADsAggregator: TGUID = '{52DB5FB0-941F-11D0-8529-00C04FD8D503}';
  IID_IADsAccessControlEntry: TGUID = '{B4F3A14C-9BDD-11D0-852C-00C04FD8D503}';
  CLASS_AccessControlEntry: TGUID = '{B75AC000-9BDD-11D0-852C-00C04FD8D503}';
  IID_IADsAccessControlList: TGUID = '{B7EE91CC-9BDD-11D0-852C-00C04FD8D503}';
  CLASS_AccessControlList: TGUID = '{B85EA052-9BDD-11D0-852C-00C04FD8D503}';
  IID_IADsSecurityDescriptor: TGUID = '{B8C787CA-9BDD-11D0-852C-00C04FD8D503}';
  CLASS_SecurityDescriptor: TGUID = '{B958F73C-9BDD-11D0-852C-00C04FD8D503}';
  IID_IADsLargeInteger: TGUID = '{9068270B-0939-11D1-8BE1-00C04FD8D503}';
  CLASS_LargeInteger: TGUID = '{927971F5-0939-11D1-8BE1-00C04FD8D503}';
  IID_IADsNameTranslate: TGUID = '{B1B272A3-3625-11D1-A3A4-00C04FB950DC}';
  CLASS_NameTranslate: TGUID = '{274FAE1F-3626-11D1-A3A4-00C04FB950DC}';
  IID_IADsCaseIgnoreList: TGUID = '{7B66B533-4680-11D1-A3B4-00C04FB950DC}';
  CLASS_CaseIgnoreList: TGUID = '{15F88A55-4680-11D1-A3B4-00C04FB950DC}';
  IID_IADsFaxNumber: TGUID = '{A910DEA9-4680-11D1-A3B4-00C04FB950DC}';
  CLASS_FaxNumber: TGUID = '{A5062215-4681-11D1-A3B4-00C04FB950DC}';
  IID_IADsNetAddress: TGUID = '{B21A50A9-4080-11D1-A3AC-00C04FB950DC}';
  CLASS_NetAddress: TGUID = '{B0B71247-4080-11D1-A3AC-00C04FB950DC}';
  IID_IADsOctetList: TGUID = '{7B28B80F-4680-11D1-A3B4-00C04FB950DC}';
  CLASS_OctetList: TGUID = '{1241400F-4680-11D1-A3B4-00C04FB950DC}';
  IID_IADsEmail: TGUID = '{97AF011A-478E-11D1-A3B4-00C04FB950DC}';
  CLASS_Email: TGUID = '{8F92A857-478E-11D1-A3B4-00C04FB950DC}';
  IID_IADsPath: TGUID = '{B287FCD5-4080-11D1-A3AC-00C04FB950DC}';
  CLASS_Path: TGUID = '{B2538919-4080-11D1-A3AC-00C04FB950DC}';
  IID_IADsReplicaPointer: TGUID = '{F60FB803-4080-11D1-A3AC-00C04FB950DC}';
  CLASS_ReplicaPointer: TGUID = '{F5D1BADF-4080-11D1-A3AC-00C04FB950DC}';
  IID_IADsAcl: TGUID = '{8452D3AB-0869-11D1-A377-00C04FB950DC}';
  IID_IADsTimestamp: TGUID = '{B2F5A901-4080-11D1-A3AC-00C04FB950DC}';
  CLASS_Timestamp: TGUID = '{B2BED2EB-4080-11D1-A3AC-00C04FB950DC}';
  IID_IADsPostalAddress: TGUID = '{7ADECF29-4680-11D1-A3B4-00C04FB950DC}';
  CLASS_PostalAddress: TGUID = '{0A75AFCD-4680-11D1-A3B4-00C04FB950DC}';
  IID_IADsBackLink: TGUID = '{FD1302BD-4080-11D1-A3AC-00C04FB950DC}';
  CLASS_BackLink: TGUID = '{FCBF906F-4080-11D1-A3AC-00C04FB950DC}';
  IID_IADsTypedName: TGUID = '{B371A349-4080-11D1-A3AC-00C04FB950DC}';
  CLASS_TypedName: TGUID = '{B33143CB-4080-11D1-A3AC-00C04FB950DC}';
  IID_IADsHold: TGUID = '{B3EB3B37-4080-11D1-A3AC-00C04FB950DC}';
  CLASS_Hold: TGUID = '{B3AD3E13-4080-11D1-A3AC-00C04FB950DC}';
  IID_IADsObjectOptions: TGUID = '{46F14FDA-232B-11D1-A808-00C04FD8D5A8}';
  IID_IADsPathname: TGUID = '{D592AED4-F420-11D0-A36E-00C04FB950DC}';
  CLASS_Pathname: TGUID = '{080D0D78-F421-11D0-A36E-00C04FB950DC}';
  IID_IADsADSystemInfo: TGUID = '{5BB11929-AFD1-11D2-9CB9-0000F87A369E}';
  CLASS_ADSystemInfo: TGUID = '{50B6327F-AFD1-11D2-9CB9-0000F87A369E}';
  IID_IADsWinNTSystemInfo: TGUID = '{6C6D65DC-AFD1-11D2-9CB9-0000F87A369E}';
  CLASS_WinNTSystemInfo: TGUID = '{66182EC4-AFD1-11D2-9CB9-0000F87A369E}';
  IID_IADsDNWithBinary: TGUID = '{7E99C0A2-F935-11D2-BA96-00C04FB6D0D1}';
  CLASS_DNWithBinary: TGUID = '{7E99C0A3-F935-11D2-BA96-00C04FB6D0D1}';
  IID_IADsDNWithString: TGUID = '{370DF02E-F934-11D2-BA96-00C04FB6D0D1}';
  CLASS_DNWithString: TGUID = '{334857CC-F934-11D2-BA96-00C04FB6D0D1}';
  IID_IADsSecurityUtility: TGUID = '{A63251B2-5F21-474B-AB52-4A8EFAD10895}';
  CLASS_ADsSecurityUtility: TGUID = '{F270C64A-FFB8-4AE4-85FE-3A75E5347966}';

// *********************************************************************//
// Declaration of Enumerations defined in Type Library
// *********************************************************************//
type
  ADSTYPEENUM = (
    ADSTYPE_INVALID                = 0,
    ADSTYPE_DN_STRING              = (ADSTYPE_INVALID  + 1),
    ADSTYPE_CASE_EXACT_STRING      = (ADSTYPE_DN_STRING  + 1),
    ADSTYPE_CASE_IGNORE_STRING     = (ADSTYPE_CASE_EXACT_STRING  + 1),
    ADSTYPE_PRINTABLE_STRING       = (ADSTYPE_CASE_IGNORE_STRING  + 1),
    ADSTYPE_NUMERIC_STRING         = (ADSTYPE_PRINTABLE_STRING  + 1),
    ADSTYPE_BOOLEAN                = (ADSTYPE_NUMERIC_STRING  + 1),
    ADSTYPE_INTEGER                = (ADSTYPE_BOOLEAN  + 1),
    ADSTYPE_OCTET_STRING           = (ADSTYPE_INTEGER  + 1),
    ADSTYPE_UTC_TIME               = (ADSTYPE_OCTET_STRING  + 1),
    ADSTYPE_LARGE_INTEGER          = (ADSTYPE_UTC_TIME  + 1),
    ADSTYPE_PROV_SPECIFIC          = (ADSTYPE_LARGE_INTEGER  + 1),
    ADSTYPE_OBJECT_CLASS           = (ADSTYPE_PROV_SPECIFIC  + 1),
    ADSTYPE_CASEIGNORE_LIST        = (ADSTYPE_OBJECT_CLASS  + 1),
    ADSTYPE_OCTET_LIST             = (ADSTYPE_CASEIGNORE_LIST  + 1),
    ADSTYPE_PATH                   = (ADSTYPE_OCTET_LIST  + 1),
    ADSTYPE_POSTALADDRESS          = (ADSTYPE_PATH  + 1),
    ADSTYPE_TIMESTAMP              = (ADSTYPE_POSTALADDRESS  + 1),
    ADSTYPE_BACKLINK               = (ADSTYPE_TIMESTAMP  + 1),
    ADSTYPE_TYPEDNAME              = (ADSTYPE_BACKLINK  + 1),
    ADSTYPE_HOLD                   = (ADSTYPE_TYPEDNAME  + 1),
    ADSTYPE_NETADDRESS             = (ADSTYPE_HOLD  + 1),
    ADSTYPE_REPLICAPOINTER         = (ADSTYPE_NETADDRESS  + 1),
    ADSTYPE_FAXNUMBER              = (ADSTYPE_REPLICAPOINTER  + 1),
    ADSTYPE_EMAIL                  = (ADSTYPE_FAXNUMBER  + 1),
    ADSTYPE_NT_SECURITY_DESCRIPTOR = (ADSTYPE_EMAIL  + 1),
    ADSTYPE_UNKNOWN                = (ADSTYPE_NT_SECURITY_DESCRIPTOR  + 1),
    ADSTYPE_DN_WITH_BINARY         = (ADSTYPE_UNKNOWN  + 1),
    ADSTYPE_DN_WITH_STRING         = (ADSTYPE_DN_WITH_BINARY  + 1)
  );
  __MIDL___MIDL_itf_ads_0000_0000_0001 = ADSTYPEENUM;
  ADSTYPE = ADSTYPEENUM;

  ADS_DN_STRING = LPWSTR;
  PADS_DN_STRING = ^ADS_DN_STRING;

  ADS_CASE_EXACT_STRING = LPWSTR;
  PADS_CASE_EXACT_STRING = ^ADS_CASE_EXACT_STRING;

  ADS_CASE_IGNORE_STRING = LPWSTR;
  PADS_CASE_IGNORE_STRING = ^ADS_CASE_IGNORE_STRING;

  ADS_PRINTABLE_STRING = LPWSTR;
  PADS_PRINTABLE_STRING = ^ADS_PRINTABLE_STRING;

  ADS_NUMERIC_STRING = LPWSTR;
  PADS_NUMERIC_STRING = ^ADS_NUMERIC_STRING;

  ADS_BOOLEAN = DWORD;
  LPNDS_BOOLEAN = ^ADS_BOOLEAN;

  ADS_INTEGER = DWORD;
  PADS_INTEGER = ^ADS_INTEGER;

  ADS_OCTET_STRING = record
    dwLength: DWORD;
    lpValue: LPBYTE;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0002 = ADS_OCTET_STRING;
  PADS_OCTET_STRING = ^ADS_OCTET_STRING;

  ADS_NT_SECURITY_DESCRIPTOR = record
    dwLength: DWORD;
    lpValue: LPBYTE;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0003 = ADS_NT_SECURITY_DESCRIPTOR;
  PADS_NT_SECURITY_DESCRIPTOR = ^ADS_NT_SECURITY_DESCRIPTOR;

{$IFNDEF JWA_INCLUDEMODE}
  SYSTEMTIME = packed record
    wYear: Word;
    wMonth: Word;
    wDayOfWeek: Word;
    wDay: Word;
    wHour: Word;
    wMinute: Word;
    wSecond: Word;
    wMilliseconds: Word;
  end;
  _SYSTEMTIME = SYSTEMTIME;

  LARGE_INTEGER = packed record
    QuadPart: Int64;
  end;
  _LARGE_INTEGER = LARGE_INTEGER;
{$ENDIF JWA_INCLUDEMODE}

  ADS_UTC_TIME = SYSTEMTIME;
  PADS_UTC_TIME = ^ADS_UTC_TIME;

  ADS_LARGE_INTEGER = LARGE_INTEGER;
  PADS_LARGE_INTEGER = ^LARGE_INTEGER;

  ADS_OBJECT_CLASS = LPWSTR;
  PADS_OBJECT_CLASS = ^ADS_OBJECT_CLASS;

  ADS_PROV_SPECIFIC = record
    dwLength: DWORD;
    lpValue: LPBYTE;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0004 = ADS_PROV_SPECIFIC;
  PADS_PROV_SPECIFIC = ^ADS_PROV_SPECIFIC;

  PADS_CASEIGNORE_LIST = ^_ADS_CASEIGNORE_LIST;
  _ADS_CASEIGNORE_LIST = record
    Next: PADS_CASEIGNORE_LIST;
    String_: LPWSTR;
  end;
  ADS_CASEIGNORE_LIST = _ADS_CASEIGNORE_LIST;


  PADS_OCTET_LIST = ^_ADS_OCTET_LIST;
  _ADS_OCTET_LIST = record
    Next: PADS_OCTET_LIST;
    Length: DWORD;
    Data: PByte;
  end;
  ADS_OCTET_LIST = _ADS_OCTET_LIST;

  ADS_PATH = record
    Type_: DWORD;
    VolumeName: LPWSTR;
    Path: LPWSTR;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0005 = ADS_PATH;
  PADS_PATH = ^ADS_PATH;

  ADS_POSTALADDRESS = record
    PostalAddress: array[0..5] of LPWSTR;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0006 = ADS_POSTALADDRESS;
  PADS_POSTALADDRESS = ^ADS_POSTALADDRESS;

  ADS_TIMESTAMP = record
    WholeSeconds: DWORD;
    EventID: DWORD;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0007 = ADS_TIMESTAMP;
    PADS_TIMESTAMP = ^ADS_TIMESTAMP;

  __MIDL___MIDL_itf_ads_0000_0000_0008 = record
    RemoteID: DWORD;
    ObjectName: LPWSTR;
  end;
  ADS_BACKLINK = __MIDL___MIDL_itf_ads_0000_0000_0008;

  PADS_BACKLINK = ^__MIDL___MIDL_itf_ads_0000_0000_0008;

  ADS_TYPEDNAME = record
    ObjectName: LPWSTR;
    Level: DWORD;
    Interval: DWORD;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0009 = ADS_TYPEDNAME;
  PADS_TYPEDNAME = ^ADS_TYPEDNAME;

  ADS_HOLD = record
    ObjectName: LPWSTR;
    Amount: DWORD;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0010 = ADS_HOLD;
  PADS_HOLD = ^ADS_HOLD;

  ADS_NETADDRESS = record
    AddressType: DWORD;
    AddressLength: DWORD;
    Address: PByte;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0011 = ADS_NETADDRESS;
  PADS_NETADDRESS = ^ADS_NETADDRESS;

  __MIDL___MIDL_itf_ads_0000_0000_0012 = record
    ServerName: LPWSTR;
    ReplicaType: DWORD;
    ReplicaNumber: DWORD;
    Count: DWORD;
    ReplicaAddressHints: PADS_NETADDRESS;
  end;
  ADS_REPLICAPOINTER = __MIDL___MIDL_itf_ads_0000_0000_0012;

  PADS_REPLICAPOINTER = ^__MIDL___MIDL_itf_ads_0000_0000_0012;

  ADS_FAXNUMBER = record
    TelephoneNumber: LPWSTR;
    NumberOfBits: DWORD;
    Parameters: LPBYTE;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0013 = ADS_FAXNUMBER;
  PADS_FAXNUMBER = ^ADS_FAXNUMBER;

  ADS_EMAIL = record
    Address: LPWSTR;
    Type_: DWORD;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0014 = ADS_EMAIL;
  PADS_EMAIL = ^ADS_EMAIL;

  ADS_DN_WITH_BINARY = record
    dwLength: DWORD;
    lpBinaryValue: LPBYTE;
    pszDNString: LPWSTR;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0015 = ADS_DN_WITH_BINARY;
  PADS_DN_WITH_BINARY = ^ADS_DN_WITH_BINARY;

  ADS_DN_WITH_STRING = record
    pszStringValue: LPWSTR;
    pszDNString: LPWSTR;
  end;
  __MIDL___MIDL_itf_ads_0000_0000_0016 = ADS_DN_WITH_STRING;
  PADS_DN_WITH_STRING = ^ADS_DN_WITH_STRING;

  // Remko@23.02.2010 - conversion: checked size : OK
  ADSVALUE = packed record
  case Byte of  // Padding
    0: (
      dwType: ADSTYPE;
      case _Padding1: ADSTYPE of // Padding
        ADSTYPE_DN_STRING: (DNString: ADS_DN_STRING);
        ADSTYPE_CASE_EXACT_STRING: (CaseExactString: ADS_CASE_EXACT_STRING);
        ADSTYPE_CASE_IGNORE_STRING: (CaseIgnoreString: ADS_CASE_IGNORE_STRING);
        ADSTYPE_PRINTABLE_STRING: (PrintableString: ADS_PRINTABLE_STRING);
        ADSTYPE_NUMERIC_STRING: (NumericString: ADS_NUMERIC_STRING);
        ADSTYPE_BOOLEAN: (Boolean: ADS_BOOLEAN);
        ADSTYPE_INTEGER: (Integer: ADS_INTEGER);
        ADSTYPE_OCTET_STRING: (OctetString: ADS_OCTET_STRING);
        ADSTYPE_UTC_TIME: (UTCTime: ADS_UTC_TIME);
        ADSTYPE_LARGE_INTEGER: (LargeInteger: ADS_LARGE_INTEGER);
        ADSTYPE_OBJECT_CLASS: (ClassName: ADS_PROV_SPECIFIC);
        ADSTYPE_PROV_SPECIFIC: (ProviderSpecific: ADS_PROV_SPECIFIC);
        ADSTYPE_CASEIGNORE_LIST: (pCaseIgnoreList: PADS_CASEIGNORE_LIST);
        ADSTYPE_OCTET_LIST: (pOctetList: PADS_OCTET_LIST);
        ADSTYPE_PATH: (pPath: PADS_PATH);
        ADSTYPE_POSTALADDRESS: (pPostalAddress: PADS_POSTALADDRESS);
        ADSTYPE_TIMESTAMP: (Timestamp: ADS_TIMESTAMP);
        ADSTYPE_BACKLINK: (BackLink: ADS_BACKLINK);
        ADSTYPE_TYPEDNAME: (pTypedName: PADS_TYPEDNAME);
        ADSTYPE_HOLD: (Hold: ADS_HOLD);
        ADSTYPE_NETADDRESS: (pNetAddress: PADS_NETADDRESS);
        ADSTYPE_REPLICAPOINTER: (pReplicaPointer: PADS_REPLICAPOINTER);
        ADSTYPE_FAXNUMBER: (pFaxNumber: PADS_FAXNUMBER);
        ADSTYPE_EMAIL: (Email: ADS_EMAIL);
        ADSTYPE_NT_SECURITY_DESCRIPTOR: (SecurityDescriptor: ADS_NT_SECURITY_DESCRIPTOR);
        ADSTYPE_DN_WITH_BINARY: (pDNWithBinary: PADS_DN_WITH_BINARY);
        ADSTYPE_DN_WITH_STRING: (pDNWithString: PADS_DN_WITH_STRING)
      );
  end;
  _adsvalue = ADSVALUE;
  PADSVALUE = ^ADSVALUE;
  LPADSVALUE = PADSVALUE;

  ADS_ATTR_INFO = record
    pszAttrName: LPWSTR;
    dwControlCode: DWORD;
    dwADsType: ADSTYPE;
    pADsValues: PADSVALUE;
    dwNumValues: DWORD;
  end;
  _ads_attr_info = ADS_ATTR_INFO;
  PADS_ATTR_INFO = ^ADS_ATTR_INFO;

  ADS_AUTHENTICATION_ENUM = TOleEnum;
    __MIDL___MIDL_itf_ads_0000_0000_0018 = ADS_AUTHENTICATION_ENUM;

const
  ADS_SECURE_AUTHENTICATION = $1;
  ADS_USE_ENCRYPTION        = $2;
  ADS_USE_SSL               = $2;
  ADS_READONLY_SERVER       = $4;
  ADS_PROMPT_CREDENTIALS    = $8;
  ADS_NO_AUTHENTICATION     = $10;
  ADS_FAST_BIND             = $20;
  ADS_USE_SIGNING           = $40;
  ADS_USE_SEALING           = $80;
  ADS_USE_DELEGATION        = $100;
  ADS_SERVER_BIND           = $200;
  ADS_NO_REFERRAL_CHASING   = $400;
  ADS_AUTH_RESERVED         = $80000000;


  ADS_ATTR_CLEAR = 1;
  ADS_ATTR_UPDATE = 2;
  ADS_ATTR_APPEND = 3;
  ADS_ATTR_DELETE = 4;

type
  ADS_OBJECT_INFO = record
    pszRDN: LPWSTR;
    pszObjectDN: LPWSTR;
    pszParentDN: LPWSTR;
    pszSchemaDN: LPWSTR;
    pszClassName: LPWSTR;
  end;
  _ads_object_info = ADS_OBJECT_INFO;
  PADS_OBJECT_INFO = ^ADS_OBJECT_INFO;

  ADS_STATUSENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0000_0000_0019 = ADS_STATUSENUM;
  ADS_STATUS = ADS_STATUSENUM;
  PADS_STATUS = ^ADS_STATUSENUM;

const
  ADS_STATUS_S_OK                    = 0;
  ADS_STATUS_INVALID_SEARCHPREF      = (ADS_STATUS_S_OK  + 1);
  ADS_STATUS_INVALID_SEARCHPREFVALUE = (ADS_STATUS_INVALID_SEARCHPREF  + 1);

type
  ADS_DEREFENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0000_0000_0020 = ADS_DEREFENUM;

const
  ADS_DEREF_NEVER     = 0;
  ADS_DEREF_SEARCHING = 1;
  ADS_DEREF_FINDING   = 2;
  ADS_DEREF_ALWAYS    = 3;

type
  ADS_SCOPEENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0000_0000_0021 = ADS_SCOPEENUM;

const
  ADS_SCOPE_BASE     = 0;
  ADS_SCOPE_ONELEVEL = 1;
  ADS_SCOPE_SUBTREE  = 2;

type
  ADS_PREFERENCES_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0000_0000_0022 = ADS_PREFERENCES_ENUM;

const
  ADSIPROP_ASYNCHRONOUS     = 0;
  ADSIPROP_DEREF_ALIASES    = $1;
  ADSIPROP_SIZE_LIMIT       = $2;
  ADSIPROP_TIME_LIMIT       = $3;
  ADSIPROP_ATTRIBTYPES_ONLY = $4;
  ADSIPROP_SEARCH_SCOPE     = $5;
  ADSIPROP_TIMEOUT          = $6;
  ADSIPROP_PAGESIZE         = $7;
  ADSIPROP_PAGED_TIME_LIMIT = $8;
  ADSIPROP_CHASE_REFERRALS  = $9;
  ADSIPROP_SORT_ON          = $A;
  ADSIPROP_CACHE_RESULTS    = $B;
  ADSIPROP_ADSIFLAG         = $C;

type
  ADSI_DIALECT_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0000_0000_0023 = ADSI_DIALECT_ENUM;

const
  ADSI_DIALECT_LDAP = 0;
  ADSI_DIALECT_SQL  = $1;

type
  ADS_CHASE_REFERRALS_ENUM = TOleEnum;

const
  ADS_CHASE_REFERRALS_NEVER       = 0;
  ADS_CHASE_REFERRALS_SUBORDINATE = $20;
  ADS_CHASE_REFERRALS_EXTERNAL    = $40;
  ADS_CHASE_REFERRALS_ALWAYS      = (ADS_CHASE_REFERRALS_SUBORDINATE  or ADS_CHASE_REFERRALS_EXTERNAL);

type
  ADS_SEARCHPREF_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0000_0000_0025 = ADS_SEARCHPREF_ENUM;

const
  ADS_SEARCHPREF_ASYNCHRONOUS     = 0;
  ADS_SEARCHPREF_DEREF_ALIASES    = (ADS_SEARCHPREF_ASYNCHRONOUS  + 1);
  ADS_SEARCHPREF_SIZE_LIMIT       = (ADS_SEARCHPREF_DEREF_ALIASES  + 1);
  ADS_SEARCHPREF_TIME_LIMIT       = (ADS_SEARCHPREF_SIZE_LIMIT  + 1);
  ADS_SEARCHPREF_ATTRIBTYPES_ONLY = (ADS_SEARCHPREF_TIME_LIMIT  + 1);
  ADS_SEARCHPREF_SEARCH_SCOPE     = (ADS_SEARCHPREF_ATTRIBTYPES_ONLY  + 1);
  ADS_SEARCHPREF_TIMEOUT          = (ADS_SEARCHPREF_SEARCH_SCOPE  + 1);
  ADS_SEARCHPREF_PAGESIZE         = (ADS_SEARCHPREF_TIMEOUT  + 1);
  ADS_SEARCHPREF_PAGED_TIME_LIMIT = (ADS_SEARCHPREF_PAGESIZE  + 1);
  ADS_SEARCHPREF_CHASE_REFERRALS  = (ADS_SEARCHPREF_PAGED_TIME_LIMIT  + 1);
  ADS_SEARCHPREF_SORT_ON          = (ADS_SEARCHPREF_CHASE_REFERRALS  + 1);
  ADS_SEARCHPREF_CACHE_RESULTS    = (ADS_SEARCHPREF_SORT_ON  + 1);
  ADS_SEARCHPREF_DIRSYNC          = (ADS_SEARCHPREF_CACHE_RESULTS  + 1);
  ADS_SEARCHPREF_TOMBSTONE        = (ADS_SEARCHPREF_DIRSYNC  + 1);
  ADS_SEARCHPREF_VLV              = (ADS_SEARCHPREF_TOMBSTONE  + 1);
  ADS_SEARCHPREF_ATTRIBUTE_QUERY  = (ADS_SEARCHPREF_VLV  + 1);
  ADS_SEARCHPREF_SECURITY_MASK    = (ADS_SEARCHPREF_ATTRIBUTE_QUERY  + 1);
  ADS_SEARCHPREF_DIRSYNC_FLAG     = (ADS_SEARCHPREF_SECURITY_MASK  + 1);
  ADS_SEARCHPREF_EXTENDED_DN      = (ADS_SEARCHPREF_DIRSYNC_FLAG  + 1);

type
  ADS_PASSWORD_ENCODING_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0000_0000_0026 = ADS_PASSWORD_ENCODING_ENUM;

const
  ADS_PASSWORD_ENCODE_REQUIRE_SSL = 0;
  ADS_PASSWORD_ENCODE_CLEAR       = 1;

type
  ADS_SEARCHPREF = ADS_SEARCHPREF_ENUM;

  // Remko@25.02.2010 - conversion: checked size : OK
  ADS_SEARCHPREF_INFO = packed record
    dwSearchPref: ADS_SEARCHPREF;
    _Padding1: DWORD;
    vValue: ADSVALUE;
    dwStatus: ADS_STATUS;
    _Padding3: DWORD;
  end;
  PADS_SEARCHPREF_INFO = ^ADS_SEARCHPREF_INFO;
  LPADS_SEARCHPREF_INFO = ^ADS_SEARCHPREF_INFO;

const
  ADS_DIRSYNC_COOKIE: PWideChar = 'fc8cb04d-311d-406c-8cb9-1ae8b843b418';
  ADS_VLV_RESPONSE: PWideChar = 'fc8cb04d-311d-406c-8cb9-1ae8b843b419';

type
  ADS_SEARCH_HANDLE = HANDLE;
  PADS_SEARCH_HANDLE = ^ADS_SEARCH_HANDLE;

  ADS_SEARCH_COLUMN = record
    pszAttrName: LPWSTR;
    dwADsType: ADSTYPE;
    pADsValues: PADSVALUE;
    dwNumValues: DWORD;
    hReserved: HANDLE;
  end;
  PADS_SEARCH_COLUMN = ^ADS_SEARCH_COLUMN;

  ADS_ATTR_DEF = record
    pszAttrName: LPWSTR;
    dwADsType: ADSTYPE;
    dwMinRange: DWORD;
    dwMaxRange: DWORD;
    fMultiValued: BOOL;
  end;
  _ads_attr_def = ADS_ATTR_DEF;
  PADS_ATTR_DEF = ^ADS_ATTR_DEF;

  ADS_CLASS_DEF = record
    pszClassName: LPWSTR;
    dwMandatoryAttrs: DWORD;
    ppszMandatoryAttrs: PLPWSTR;
    optionalAttrs: DWORD;
    ppszOptionalAttrs: PLPWSTR;
    dwNamingAttrs: DWORD;
    ppszNamingAttrs: PLPWSTR;
    dwSuperClasses: DWORD;
    ppszSuperClasses: PLPWSTR;
    fIsContainer: BOOL;
  end;
  _ads_class_def = ADS_CLASS_DEF;
  PADS_CLASS_DEF = ^ADS_CLASS_DEF;

  ADS_SORTKEY = record
    pszAttrType: LPWSTR;
    pszReserved: LPWSTR;
    fReverseorder: BOOLEAN;
  end;
  _ads_sortkey = ADS_SORTKEY;
  PADS_SORTKEY = ^ADS_SORTKEY;

  ADS_VLV = record
    dwBeforeCount: DWORD;
    dwAfterCount: DWORD;
    dwOffset: DWORD;
    dwContentCount: DWORD;
    pszTarget: LPWSTR;
    dwContextIDLength: DWORD;
    lpContextID: LPBYTE;
  end;
  _ads_vlv= ADS_VLV;
  PADS_VLV = ^_ADS_VLV;

const
  ADS_EXT_MINEXTDISPID  = 1;
  ADS_EXT_MAXEXTDISPID = 16777215;
  ADS_EXT_INITCREDENTIALS = 1;
  ADS_EXT_INITIALIZE_COMPLETE = 2;

type
  ADS_PROPERTY_OPERATION_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0000_0000_0027 = ADS_PROPERTY_OPERATION_ENUM;

const
  ADS_PROPERTY_CLEAR  = 1;
  ADS_PROPERTY_UPDATE = 2;
  ADS_PROPERTY_APPEND = 3;
  ADS_PROPERTY_DELETE = 4;

type
  ADS_SYSTEMFLAG_ENUM       = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0015_0001 = ADS_SYSTEMFLAG_ENUM;

const
  ADS_SYSTEMFLAG_DISALLOW_DELETE           = $80000000;
  ADS_SYSTEMFLAG_CONFIG_ALLOW_RENAME       = $40000000;
  ADS_SYSTEMFLAG_CONFIG_ALLOW_MOVE         = $20000000;
  ADS_SYSTEMFLAG_CONFIG_ALLOW_LIMITED_MOVE = $10000000;
  ADS_SYSTEMFLAG_DOMAIN_DISALLOW_RENAME    = $8000000;
  ADS_SYSTEMFLAG_DOMAIN_DISALLOW_MOVE      = $4000000;
  ADS_SYSTEMFLAG_CR_NTDS_NC                = $1;
  ADS_SYSTEMFLAG_CR_NTDS_DOMAIN            = $2;
  ADS_SYSTEMFLAG_ATTR_NOT_REPLICATED       = $1;
  ADS_SYSTEMFLAG_ATTR_IS_CONSTRUCTED       = $4;

type
  ADS_GROUP_TYPE_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0021_0001 = ADS_GROUP_TYPE_ENUM;

const
  ADS_GROUP_TYPE_GLOBAL_GROUP       = $2;
  ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP = $4;
  ADS_GROUP_TYPE_LOCAL_GROUP        = $4;
  ADS_GROUP_TYPE_UNIVERSAL_GROUP    = $8;
  ADS_GROUP_TYPE_SECURITY_ENABLED   = $80000000;

type
  ADS_USER_FLAG = TOleEnum;
  ADS_USER_FLAG_ENUM = ADS_USER_FLAG;

const
  ADS_UF_SCRIPT                                 = $1;
  ADS_UF_ACCOUNTDISABLE                         = $2;
  ADS_UF_HOMEDIR_REQUIRED                       = $8;
  ADS_UF_LOCKOUT                                = $10;
  ADS_UF_PASSWD_NOTREQD                         = $20;
  ADS_UF_PASSWD_CANT_CHANGE                     = $40;
  ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED        = $80;
  ADS_UF_TEMP_DUPLICATE_ACCOUNT                 = $100;
  ADS_UF_NORMAL_ACCOUNT                         = $200;
  ADS_UF_INTERDOMAIN_TRUST_ACCOUNT              = $800;
  ADS_UF_WORKSTATION_TRUST_ACCOUNT              = $1000;
  ADS_UF_SERVER_TRUST_ACCOUNT                   = $2000;
  ADS_UF_DONT_EXPIRE_PASSWD                     = $10000;
  ADS_UF_MNS_LOGON_ACCOUNT                      = $20000;
  ADS_UF_SMARTCARD_REQUIRED                     = $40000;
  ADS_UF_TRUSTED_FOR_DELEGATION                 = $80000;
  ADS_UF_NOT_DELEGATED                          = $100000;
  ADS_UF_USE_DES_KEY_ONLY                       = $200000;
  ADS_UF_DONT_REQUIRE_PREAUTH                   = $400000;
  ADS_UF_PASSWORD_EXPIRED                       = $800000;
  ADS_UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION = $1000000;

type
  ADS_RIGHTS_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0043_0001 = ADS_RIGHTS_ENUM;

const
  ADS_RIGHT_DELETE                 = $10000;
  ADS_RIGHT_READ_CONTROL           = $20000;
  ADS_RIGHT_WRITE_DAC              = $40000;
  ADS_RIGHT_WRITE_OWNER            = $80000;
  ADS_RIGHT_SYNCHRONIZE            = $100000;
  ADS_RIGHT_ACCESS_SYSTEM_SECURITY = $1000000;
  ADS_RIGHT_GENERIC_READ           = $80000000;
  ADS_RIGHT_GENERIC_WRITE          = $40000000;
  ADS_RIGHT_GENERIC_EXECUTE        = $20000000;
  ADS_RIGHT_GENERIC_ALL            = $10000000;
  ADS_RIGHT_DS_CREATE_CHILD        = $1;
  ADS_RIGHT_DS_DELETE_CHILD        = $2;
  ADS_RIGHT_ACTRL_DS_LIST          = $4;
  ADS_RIGHT_DS_SELF                = $8;
  ADS_RIGHT_DS_READ_PROP           = $10;
  ADS_RIGHT_DS_WRITE_PROP          = $20;
  ADS_RIGHT_DS_DELETE_TREE         = $40;
  ADS_RIGHT_DS_LIST_OBJECT         = $80;
  ADS_RIGHT_DS_CONTROL_ACCESS      = $100;

type
  ADS_ACETYPE_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0043_0002 = ADS_ACETYPE_ENUM;

const
  ADS_ACETYPE_ACCESS_ALLOWED                 = 0;
  ADS_ACETYPE_ACCESS_DENIED                  = $1;
  ADS_ACETYPE_SYSTEM_AUDIT                   = $2;
  ADS_ACETYPE_ACCESS_ALLOWED_OBJECT          = $5;
  ADS_ACETYPE_ACCESS_DENIED_OBJECT           = $6;
  ADS_ACETYPE_SYSTEM_AUDIT_OBJECT            = $7;
  ADS_ACETYPE_SYSTEM_ALARM_OBJECT            = $8;
  ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK        = $9;
  ADS_ACETYPE_ACCESS_DENIED_CALLBACK         = $A;
  ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK_OBJECT = $B;
  ADS_ACETYPE_ACCESS_DENIED_CALLBACK_OBJECT  = $C;
  ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK          = $D;
  ADS_ACETYPE_SYSTEM_ALARM_CALLBACK          = $E;
  ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK_OBJECT   = $F;
  ADS_ACETYPE_SYSTEM_ALARM_CALLBACK_OBJECT   = $10;

type
  ADS_ACEFLAG_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0043_0003 = ADS_ACEFLAG_ENUM;

const
  ADS_ACEFLAG_INHERIT_ACE              = $2;
  ADS_ACEFLAG_NO_PROPAGATE_INHERIT_ACE = $4;
  ADS_ACEFLAG_INHERIT_ONLY_ACE         = $8;
  ADS_ACEFLAG_INHERITED_ACE            = $10;
  ADS_ACEFLAG_VALID_INHERIT_FLAGS      = $1F;
  ADS_ACEFLAG_SUCCESSFUL_ACCESS        = $40;
  ADS_ACEFLAG_FAILED_ACCESS            = $80;

  { [public] }
type
  ADS_FLAGTYPE_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0043_0004 = ADS_FLAGTYPE_ENUM;

const
  ADS_FLAG_OBJECT_TYPE_PRESENT           = $1;
  ADS_FLAG_INHERITED_OBJECT_TYPE_PRESENT = $2;

type
  ADS_SD_CONTROL_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0043_0005 = ADS_SD_CONTROL_ENUM;

const
  ADS_SD_CONTROL_SE_OWNER_DEFAULTED       = $1;
  ADS_SD_CONTROL_SE_GROUP_DEFAULTED       = $2;
  ADS_SD_CONTROL_SE_DACL_PRESENT          = $4;
  ADS_SD_CONTROL_SE_DACL_DEFAULTED        = $8;
  ADS_SD_CONTROL_SE_SACL_PRESENT          = $10;
  ADS_SD_CONTROL_SE_SACL_DEFAULTED        = $20;
  ADS_SD_CONTROL_SE_DACL_AUTO_INHERIT_REQ = $100;
  ADS_SD_CONTROL_SE_SACL_AUTO_INHERIT_REQ = $200;
  ADS_SD_CONTROL_SE_DACL_AUTO_INHERITED   = $400;
  ADS_SD_CONTROL_SE_SACL_AUTO_INHERITED   = $800;
  ADS_SD_CONTROL_SE_DACL_PROTECTED        = $1000;
  ADS_SD_CONTROL_SE_SACL_PROTECTED        = $2000;
  ADS_SD_CONTROL_SE_SELF_RELATIVE         = $8000;

type
  ADS_SD_REVISION_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0043_0006 = ADS_SD_REVISION_ENUM;

const
  ADS_SD_REVISION_DS = 4;

type
  ADS_NAME_TYPE_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0044_0001 = ADS_NAME_TYPE_ENUM;

const
  ADS_NAME_TYPE_1779                    = 1;
  ADS_NAME_TYPE_CANONICAL               = 2;
  ADS_NAME_TYPE_NT4                     = 3;
  ADS_NAME_TYPE_DISPLAY                 = 4;
  ADS_NAME_TYPE_DOMAIN_SIMPLE           = 5;
  ADS_NAME_TYPE_ENTERPRISE_SIMPLE       = 6;
  ADS_NAME_TYPE_GUID                    = 7;
  ADS_NAME_TYPE_UNKNOWN                 = 8;
  ADS_NAME_TYPE_USER_PRINCIPAL_NAME     = 9;
  ADS_NAME_TYPE_CANONICAL_EX            = 10;
  ADS_NAME_TYPE_SERVICE_PRINCIPAL_NAME  = 11;
  ADS_NAME_TYPE_SID_OR_SID_HISTORY_NAME = 12;

type
  ADS_NAME_INITTYPE_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0044_0002 = ADS_NAME_INITTYPE_ENUM;

const
  ADS_NAME_INITTYPE_DOMAIN = 1;
  ADS_NAME_INITTYPE_SERVER = 2;
  ADS_NAME_INITTYPE_GC     = 3;

type
  ADS_OPTION_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0058_0001   = ADS_OPTION_ENUM;

const
  ADS_OPTION_SERVERNAME                = 0;
  ADS_OPTION_REFERRALS                 = (ADS_OPTION_SERVERNAME  + 1);
  ADS_OPTION_PAGE_SIZE                 = (ADS_OPTION_REFERRALS  + 1);
  ADS_OPTION_SECURITY_MASK             = (ADS_OPTION_PAGE_SIZE  + 1);
  ADS_OPTION_MUTUAL_AUTH_STATUS        = (ADS_OPTION_SECURITY_MASK  + 1);
  ADS_OPTION_QUOTA                     = (ADS_OPTION_MUTUAL_AUTH_STATUS  + 1);
  ADS_OPTION_PASSWORD_PORTNUMBER       = (ADS_OPTION_QUOTA  + 1);
  ADS_OPTION_PASSWORD_METHOD           = (ADS_OPTION_PASSWORD_PORTNUMBER  + 1);
  ADS_OPTION_ACCUMULATIVE_MODIFICATION = (ADS_OPTION_PASSWORD_METHOD  + 1);
  ADS_OPTION_SKIP_SID_LOOKUP           = (ADS_OPTION_ACCUMULATIVE_MODIFICATION  + 1);

type
  ADS_SECURITY_INFO_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0058_0002 = ADS_SECURITY_INFO_ENUM;

const
  ADS_SECURITY_INFO_OWNER = $1;
  ADS_SECURITY_INFO_GROUP = $2;
  ADS_SECURITY_INFO_DACL  = $4;
  ADS_SECURITY_INFO_SACL  = $8;

type
  ADS_SETTYPE_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0059_0001 = ADS_SETTYPE_ENUM;

const
  ADS_SETTYPE_FULL     = 1;
  ADS_SETTYPE_PROVIDER = 2;
  ADS_SETTYPE_SERVER   = 3;
  ADS_SETTYPE_DN       = 4;

type
  ADS_FORMAT_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0059_0002 = ADS_FORMAT_ENUM;

const
  ADS_FORMAT_WINDOWS           = 1;
  ADS_FORMAT_WINDOWS_NO_SERVER = 2;
  ADS_FORMAT_WINDOWS_DN        = 3;
  ADS_FORMAT_WINDOWS_PARENT    = 4;
  ADS_FORMAT_X500              = 5;
  ADS_FORMAT_X500_NO_SERVER    = 6;
  ADS_FORMAT_X500_DN           = 7;
  ADS_FORMAT_X500_PARENT       = 8;
  ADS_FORMAT_SERVER            = 9;
  ADS_FORMAT_PROVIDER          = 10;
  ADS_FORMAT_LEAF              = 11;

type
  ADS_DISPLAY_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0059_0003 = ADS_DISPLAY_ENUM;

const
  ADS_DISPLAY_FULL       = 1;
  ADS_DISPLAY_VALUE_ONLY = 2;

type
  ADS_ESCAPE_MODE_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0059_0004 = ADS_ESCAPE_MODE_ENUM;

const
  ADS_ESCAPEDMODE_DEFAULT = 1;
  ADS_ESCAPEDMODE_ON      = 2;
  ADS_ESCAPEDMODE_OFF     = 3;
  ADS_ESCAPEDMODE_OFF_EX  = 4;

type
  ADS_PATHTYPE_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0064_0001 = ADS_PATHTYPE_ENUM;

const
  ADS_PATH_FILE      = 1;
  ADS_PATH_FILESHARE = 2;
  ADS_PATH_REGISTRY  = 3;

type
  ADS_SD_FORMAT_ENUM = TOleEnum;
  __MIDL___MIDL_itf_ads_0001_0064_0002 = ADS_SD_FORMAT_ENUM;

const
  ADS_SD_FORMAT_IID       = 1;
  ADS_SD_FORMAT_RAW       = 2;
  ADS_SD_FORMAT_HEXSTRING = 3;

type
// *********************************************************************//
// Forward declaration of types defined in TypeLibrary
// *********************************************************************//
  IADs = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsDisp = dispinterface;
{$ENDIF}
  IADsContainer = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsContainerDisp = dispinterface;
{$ENDIF}
  IADsCollection = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsCollectionDisp = dispinterface;
{$ENDIF}
  IADsMembers = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsMembersDisp = dispinterface;
{$ENDIF}
  IADsPropertyList = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPropertyListDisp = dispinterface;
{$ENDIF}
  IADsPropertyEntry = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPropertyEntryDisp = dispinterface;
{$ENDIF}
  IADsPropertyValue = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPropertyValueDisp = dispinterface;
{$ENDIF}
  IADsPropertyValue2 = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPropertyValue2Disp = dispinterface;
{$ENDIF}
  IPrivateDispatch = interface;
  IADsExtension = interface;
  IADsDeleteOps = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsDeleteOpsDisp = dispinterface;
{$ENDIF}
  IADsNamespaces = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsNamespacesDisp = dispinterface;
{$ENDIF}
  IADsClass = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsClassDisp = dispinterface;
{$ENDIF}
  IADsProperty = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPropertyDisp = dispinterface;
{$ENDIF}
  IADsSyntax = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsSyntaxDisp = dispinterface;
{$ENDIF}
  IADsLocality = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsLocalityDisp = dispinterface;
{$ENDIF}
  IADsO = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsODisp = dispinterface;
{$ENDIF}
  IADsOU = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsOUDisp = dispinterface;
{$ENDIF}
  IADsDomain = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsDomainDisp = dispinterface;
{$ENDIF}
  IADsComputer = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsComputerDisp = dispinterface;
{$ENDIF}
  IADsComputerOperations = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsComputerOperationsDisp = dispinterface;
{$ENDIF}
  IADsGroup = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsGroupDisp = dispinterface;
{$ENDIF}
  IADsUser = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsUserDisp = dispinterface;
{$ENDIF}
  IADsPrintQueue = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPrintQueueDisp = dispinterface;
{$ENDIF}
  IADsPrintQueueOperations = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPrintQueueOperationsDisp = dispinterface;
{$ENDIF}
  IADsPrintJob = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPrintJobDisp = dispinterface;
{$ENDIF}
  IADsPrintJobOperations = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPrintJobOperationsDisp = dispinterface;
{$ENDIF}
  IADsService = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsServiceDisp = dispinterface;
{$ENDIF}
  IADsServiceOperations = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsServiceOperationsDisp = dispinterface;
{$ENDIF}
  IADsFileService = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsFileServiceDisp = dispinterface;
{$ENDIF}
  IADsFileServiceOperations = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsFileServiceOperationsDisp = dispinterface;
{$ENDIF}
  IADsFileShare = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsFileShareDisp = dispinterface;
{$ENDIF}
  IADsSession = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsSessionDisp = dispinterface;
{$ENDIF}
  IADsResource = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsResourceDisp = dispinterface;
{$ENDIF}
  IADsOpenDSObject = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsOpenDSObjectDisp = dispinterface;
{$ENDIF}
  IDirectoryObject = interface;
  IDirectorySearch = interface;
  IDirectorySchemaMgmt = interface;
  IADsAggregatee = interface;
  IADsAggregator = interface;
  IADsAccessControlEntry = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsAccessControlEntryDisp = dispinterface;
{$ENDIF}
  IADsAccessControlList = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsAccessControlListDisp = dispinterface;
{$ENDIF}
  IADsSecurityDescriptor = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsSecurityDescriptorDisp = dispinterface;
{$ENDIF}
  IADsLargeInteger = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsLargeIntegerDisp = dispinterface;
{$ENDIF}
  IADsNameTranslate = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsNameTranslateDisp = dispinterface;
{$ENDIF}
  IADsCaseIgnoreList = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsCaseIgnoreListDisp = dispinterface;
{$ENDIF}
  IADsFaxNumber = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsFaxNumberDisp = dispinterface;
{$ENDIF}
  IADsNetAddress = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsNetAddressDisp = dispinterface;
{$ENDIF}
  IADsOctetList = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsOctetListDisp = dispinterface;
{$ENDIF}
  IADsEmail = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsEmailDisp = dispinterface;
{$ENDIF}
  IADsPath = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPathDisp = dispinterface;
{$ENDIF}
  IADsReplicaPointer = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsReplicaPointerDisp = dispinterface;
{$ENDIF}
  IADsAcl = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsAclDisp = dispinterface;
{$ENDIF}
  IADsTimestamp = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsTimestampDisp = dispinterface;
{$ENDIF}
  IADsPostalAddress = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPostalAddressDisp = dispinterface;
{$ENDIF}
  IADsBackLink = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsBackLinkDisp = dispinterface;
{$ENDIF}
  IADsTypedName = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsTypedNameDisp = dispinterface;
{$ENDIF}
  IADsHold = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsHoldDisp = dispinterface;
{$ENDIF}
  IADsObjectOptions = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsObjectOptionsDisp = dispinterface;
{$ENDIF}
  IADsPathname = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsPathnameDisp = dispinterface;
{$ENDIF}
  IADsADSystemInfo = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsADSystemInfoDisp = dispinterface;
{$ENDIF}
  IADsWinNTSystemInfo = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsWinNTSystemInfoDisp = dispinterface;
{$ENDIF}
  IADsDNWithBinary = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsDNWithBinaryDisp = dispinterface;
{$ENDIF}
  IADsDNWithString = interface;
{$IFDEF SUPPORTS_DISPINTERFACE}
  IADsDNWithStringDisp = dispinterface;
{$ENDIF}

// *********************************************************************//
// Declaration of CoClasses defined in Type Library
// (NOTE: Here we map each CoClass to its Default Interface)
// *********************************************************************//
  PropertyEntry = IADsPropertyEntry;
  PropertyValue = IADsPropertyValue;
  AccessControlEntry = IADsAccessControlEntry;
  AccessControlList = IADsAccessControlList;
  SecurityDescriptor = IADsSecurityDescriptor;
  LargeInteger = IADsLargeInteger;
  NameTranslate = IADsNameTranslate;
  CaseIgnoreList = IADsCaseIgnoreList;
  FaxNumber = IADsFaxNumber;
  NetAddress = IADsNetAddress;
  OctetList = IADsOctetList;
  Email = IADsEmail;
  Path = IADsPath;
  ReplicaPointer = IADsReplicaPointer;
{$IFNDEF JWA_INCLUDEMODE}
  Acl = IADsAcl;
{$ENDIF JWA_INCLUDEMODE}
  Timestamp = IADsTimestamp;
  PostalAddress = IADsPostalAddress;
  BackLink = IADsBackLink;
  TypedName = IADsTypedName;
  Hold = IADsHold;
  Pathname = IADsPathname;
  ADSystemInfo = IADsADSystemInfo;
  WinNTSystemInfo = IADsWinNTSystemInfo;
  DNWithBinary = IADsDNWithBinary;
  DNWithString = IADsDNWithString;

// *********************************************************************//
// Interface: IADs
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {FD8256D0-FD15-11CE-ABC4-02608C9E7553}
// *********************************************************************//
  IADs = interface(IDispatch)
    ['{FD8256D0-FD15-11CE-ABC4-02608C9E7553}']
    function Get_Name: WideString; safecall;
    function Get_Class_: WideString; safecall;
    function Get_GUID: WideString; safecall;
    function Get_ADsPath: WideString; safecall;
    function Get_Parent: WideString; safecall;
    function Get_Schema: WideString; safecall;
    procedure GetInfo; safecall;
    procedure SetInfo; safecall;
    function Get(const bstrName: WideString): OleVariant; safecall;
    procedure Put(const bstrName: WideString; vProp: OleVariant); safecall;
    function GetEx(const bstrName: WideString): OleVariant; safecall;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); safecall;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); safecall;
    property Name: WideString read Get_Name;
    property Class_: WideString read Get_Class_;
    property GUID: WideString read Get_GUID;
    property ADsPath: WideString read Get_ADsPath;
    property Parent: WideString read Get_Parent;
    property Schema: WideString read Get_Schema;
  end;

// *********************************************************************//
// DispIntf:  IADsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {FD8256D0-FD15-11CE-ABC4-02608C9E7553}
// *********************************************************************//
  IADsDisp = dispinterface
    ['{FD8256D0-FD15-11CE-ABC4-02608C9E7553}']
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsContainer
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {001677D0-FD16-11CE-ABC4-02608C9E7553}
// *********************************************************************//
  IADsContainer = interface(IDispatch)
    ['{001677D0-FD16-11CE-ABC4-02608C9E7553}']
    function Get_Count: Integer; safecall;
    function Get__NewEnum: IUnknown; safecall;
    function Get_Filter: OleVariant; safecall;
    procedure Set_Filter(pVar: OleVariant); safecall;
    function Get_Hints: OleVariant; safecall;
    procedure Set_Hints(pvFilter: OleVariant); safecall;
    function GetObject(const ClassName: WideString; const RelativeName: WideString): IDispatch; safecall;
    function Create(const ClassName: WideString; const RelativeName: WideString): IDispatch; safecall;
    procedure Delete(const bstrClassName: WideString; const bstrRelativeName: WideString); safecall;
    function CopyHere(const SourceName: WideString; const NewName: WideString): IDispatch; safecall;
    function MoveHere(const SourceName: WideString; const NewName: WideString): IDispatch; safecall;
    property Count: Integer read Get_Count;
    property _NewEnum: IUnknown read Get__NewEnum;
    property Filter: OleVariant read Get_Filter write Set_Filter;
    property Hints: OleVariant read Get_Hints write Set_Hints;
  end;

// *********************************************************************//
// DispIntf:  IADsContainerDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {001677D0-FD16-11CE-ABC4-02608C9E7553}
// *********************************************************************//
  IADsContainerDisp = dispinterface
    ['{001677D0-FD16-11CE-ABC4-02608C9E7553}']
    property Count: Integer readonly dispid 2;
    property _NewEnum: IUnknown readonly dispid -4;
    property Filter: OleVariant dispid 3;
    property Hints: OleVariant dispid 4;
    function GetObject(const ClassName: WideString; const RelativeName: WideString): IDispatch; dispid 5;
    function Create(const ClassName: WideString; const RelativeName: WideString): IDispatch; dispid 6;
    procedure Delete(const bstrClassName: WideString; const bstrRelativeName: WideString); dispid 7;
    function CopyHere(const SourceName: WideString; const NewName: WideString): IDispatch; dispid 8;
    function MoveHere(const SourceName: WideString; const NewName: WideString): IDispatch; dispid 9;
  end;

// *********************************************************************//
// Interface: IADsCollection
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {72B945E0-253B-11CF-A988-00AA006BC149}
// *********************************************************************//
  IADsCollection = interface(IDispatch)
    ['{72B945E0-253B-11CF-A988-00AA006BC149}']
    function Get__NewEnum: IUnknown; safecall;
    procedure Add(const bstrName: WideString; vItem: OleVariant); safecall;
    procedure Remove(const bstrItemToBeRemoved: WideString); safecall;
    function GetObject(const bstrName: WideString): OleVariant; safecall;
    property _NewEnum: IUnknown read Get__NewEnum;
  end;

// *********************************************************************//
// DispIntf:  IADsCollectionDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {72B945E0-253B-11CF-A988-00AA006BC149}
// *********************************************************************//
  IADsCollectionDisp = dispinterface
    ['{72B945E0-253B-11CF-A988-00AA006BC149}']
    property _NewEnum: IUnknown readonly dispid -4;
    procedure Add(const bstrName: WideString; vItem: OleVariant); dispid 4;
    procedure Remove(const bstrItemToBeRemoved: WideString); dispid 5;
    function GetObject(const bstrName: WideString): OleVariant; dispid 6;
  end;

// *********************************************************************//
// Interface: IADsMembers
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {451A0030-72EC-11CF-B03B-00AA006E0975}
// *********************************************************************//
  IADsMembers = interface(IDispatch)
    ['{451A0030-72EC-11CF-B03B-00AA006E0975}']
    function Get_Count: Integer; safecall;
    function Get__NewEnum: IUnknown; safecall;
    function Get_Filter: OleVariant; safecall;
    procedure Set_Filter(pvFilter: OleVariant); safecall;
    property Count: Integer read Get_Count;
    property _NewEnum: IUnknown read Get__NewEnum;
    property Filter: OleVariant read Get_Filter write Set_Filter;
  end;

// *********************************************************************//
// DispIntf:  IADsMembersDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {451A0030-72EC-11CF-B03B-00AA006E0975}
// *********************************************************************//
  IADsMembersDisp = dispinterface
    ['{451A0030-72EC-11CF-B03B-00AA006E0975}']
    property Count: Integer readonly dispid 2;
    property _NewEnum: IUnknown readonly dispid -4;
    property Filter: OleVariant dispid 3;
  end;

// *********************************************************************//
// Interface: IADsPropertyList
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {C6F602B6-8F69-11D0-8528-00C04FD8D503}
// *********************************************************************//
  IADsPropertyList = interface(IDispatch)
    ['{C6F602B6-8F69-11D0-8528-00C04FD8D503}']
    function Get_PropertyCount: Integer; safecall;
    function Next: OleVariant; safecall;
    procedure Skip(cElements: Integer); safecall;
    procedure Reset; safecall;
    function Item(varIndex: OleVariant): OleVariant; safecall;
    function GetPropertyItem(const bstrName: WideString; lnADsType: Integer): OleVariant; safecall;
    procedure PutPropertyItem(varData: OleVariant); safecall;
    procedure ResetPropertyItem(varEntry: OleVariant); safecall;
    procedure PurgePropertyList; safecall;
    property PropertyCount: Integer read Get_PropertyCount;
  end;

// *********************************************************************//
// DispIntf:  IADsPropertyListDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {C6F602B6-8F69-11D0-8528-00C04FD8D503}
// *********************************************************************//
  IADsPropertyListDisp = dispinterface
    ['{C6F602B6-8F69-11D0-8528-00C04FD8D503}']
    property PropertyCount: Integer readonly dispid 2;
    function Next: OleVariant; dispid 3;
    procedure Skip(cElements: Integer); dispid 4;
    procedure Reset; dispid 5;
    function Item(varIndex: OleVariant): OleVariant; dispid 0;
    function GetPropertyItem(const bstrName: WideString; lnADsType: Integer): OleVariant; dispid 6;
    procedure PutPropertyItem(varData: OleVariant); dispid 7;
    procedure ResetPropertyItem(varEntry: OleVariant); dispid 8;
    procedure PurgePropertyList; dispid 9;
  end;

// *********************************************************************//
// Interface: IADsPropertyEntry
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {05792C8E-941F-11D0-8529-00C04FD8D503}
// *********************************************************************//
  IADsPropertyEntry = interface(IDispatch)
    ['{05792C8E-941F-11D0-8529-00C04FD8D503}']
    procedure Clear; safecall;
    function Get_Name: WideString; safecall;
    procedure Set_Name(const retval: WideString); safecall;
    function Get_ADsType: Integer; safecall;
    procedure Set_ADsType(retval: Integer); safecall;
    function Get_ControlCode: Integer; safecall;
    procedure Set_ControlCode(retval: Integer); safecall;
    function Get_Values: OleVariant; safecall;
    procedure Set_Values(retval: OleVariant); safecall;
    property Name: WideString read Get_Name write Set_Name;
    property ADsType: Integer read Get_ADsType write Set_ADsType;
    property ControlCode: Integer read Get_ControlCode write Set_ControlCode;
    property Values: OleVariant read Get_Values write Set_Values;
  end;

// *********************************************************************//
// DispIntf:  IADsPropertyEntryDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {05792C8E-941F-11D0-8529-00C04FD8D503}
// *********************************************************************//
  IADsPropertyEntryDisp = dispinterface
    ['{05792C8E-941F-11D0-8529-00C04FD8D503}']
    procedure Clear; dispid 1;
    property Name: WideString dispid 2;
    property ADsType: Integer dispid 3;
    property ControlCode: Integer dispid 4;
    property Values: OleVariant dispid 5;
  end;

// *********************************************************************//
// Interface: IADsPropertyValue
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {79FA9AD0-A97C-11D0-8534-00C04FD8D503}
// *********************************************************************//
  IADsPropertyValue = interface(IDispatch)
    ['{79FA9AD0-A97C-11D0-8534-00C04FD8D503}']
    procedure Clear; safecall;
    function Get_ADsType: Integer; safecall;
    procedure Set_ADsType(retval: Integer); safecall;
    function Get_DNString: WideString; safecall;
    procedure Set_DNString(const retval: WideString); safecall;
    function Get_CaseExactString: WideString; safecall;
    procedure Set_CaseExactString(const retval: WideString); safecall;
    function Get_CaseIgnoreString: WideString; safecall;
    procedure Set_CaseIgnoreString(const retval: WideString); safecall;
    function Get_PrintableString: WideString; safecall;
    procedure Set_PrintableString(const retval: WideString); safecall;
    function Get_NumericString: WideString; safecall;
    procedure Set_NumericString(const retval: WideString); safecall;
    function Get_Boolean: Integer; safecall;
    procedure Set_Boolean(retval: Integer); safecall;
    function Get_Integer: Integer; safecall;
    procedure Set_Integer(retval: Integer); safecall;
    function Get_OctetString: OleVariant; safecall;
    procedure Set_OctetString(retval: OleVariant); safecall;
    function Get_SecurityDescriptor: IDispatch; safecall;
    procedure Set_SecurityDescriptor(const retval: IDispatch); safecall;
    function Get_LargeInteger: IDispatch; safecall;
    procedure Set_LargeInteger(const retval: IDispatch); safecall;
    function Get_UTCTime: TDateTime; safecall;
    procedure Set_UTCTime(retval: TDateTime); safecall;
    property ADsType: Integer read Get_ADsType write Set_ADsType;
    property DNString: WideString read Get_DNString write Set_DNString;
    property CaseExactString: WideString read Get_CaseExactString write Set_CaseExactString;
    property CaseIgnoreString: WideString read Get_CaseIgnoreString write Set_CaseIgnoreString;
    property PrintableString: WideString read Get_PrintableString write Set_PrintableString;
    property NumericString: WideString read Get_NumericString write Set_NumericString;
    property Boolean: Integer read Get_Boolean write Set_Boolean;
    property Integer: Integer read Get_Integer write Set_Integer;
    property OctetString: OleVariant read Get_OctetString write Set_OctetString;
    property SecurityDescriptor: IDispatch read Get_SecurityDescriptor write Set_SecurityDescriptor;
    property LargeInteger: IDispatch read Get_LargeInteger write Set_LargeInteger;
    property UTCTime: TDateTime read Get_UTCTime write Set_UTCTime;
  end;

// *********************************************************************//
// DispIntf:  IADsPropertyValueDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {79FA9AD0-A97C-11D0-8534-00C04FD8D503}
// *********************************************************************//
  IADsPropertyValueDisp = dispinterface
    ['{79FA9AD0-A97C-11D0-8534-00C04FD8D503}']
    procedure Clear; dispid 1;
    property ADsType: Integer dispid 2;
    property DNString: WideString dispid 3;
    property CaseExactString: WideString dispid 4;
    property CaseIgnoreString: WideString dispid 5;
    property PrintableString: WideString dispid 6;
    property NumericString: WideString dispid 7;
    property Boolean: Integer dispid 8;
    property Integer: Integer dispid 9;
    property OctetString: OleVariant dispid 10;
    property SecurityDescriptor: IDispatch dispid 11;
    property LargeInteger: IDispatch dispid 12;
    property UTCTime: TDateTime dispid 13;
  end;

// *********************************************************************//
// Interface: IADsPropertyValue2
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {306E831C-5BC7-11D1-A3B8-00C04FB950DC}
// *********************************************************************//
  IADsPropertyValue2 = interface(IDispatch)
    ['{306E831C-5BC7-11D1-A3B8-00C04FB950DC}']
    function GetObjectProperty(var lnADsType: Integer): OleVariant; safecall;
    procedure PutObjectProperty(lnADsType: Integer; vProp: OleVariant); safecall;
  end;

// *********************************************************************//
// DispIntf:  IADsPropertyValue2Disp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {306E831C-5BC7-11D1-A3B8-00C04FB950DC}
// *********************************************************************//
  IADsPropertyValue2Disp = dispinterface
    ['{306E831C-5BC7-11D1-A3B8-00C04FB950DC}']
    function GetObjectProperty(var lnADsType: Integer): OleVariant; dispid 1;
    procedure PutObjectProperty(lnADsType: Integer; vProp: OleVariant); dispid 2;
  end;

// *********************************************************************//
// Interface: IPrivateDispatch
// Flags:     (0)
// GUID:      {86AB4BBE-65F6-11D1-8C13-00C04FD8D503}
// *********************************************************************//
  IPrivateDispatch = interface(IUnknown)
    ['{86AB4BBE-65F6-11D1-8C13-00C04FD8D503}']
    function ADSIInitializeDispatchManager(dwExtensionId: Integer): HResult; stdcall;
    function ADSIGetTypeInfoCount(out pctinfo: SYSUINT): HResult; stdcall;
    function ADSIGetTypeInfo(itinfo: SYSUINT; lcid: LongWord; out ppTInfo: ITypeInfo): HResult; stdcall;
    function ADSIGetIDsOfNames(var riid: TGUID; rgszNames: PWideChar; cNames: SYSUINT;
                               lcid: LongWord; out rgdispid: Integer): HResult; stdcall;
    function ADSIInvoke(dispidMember: Integer; var riid: TGUID; lcid: LongWord; wFlags: Word;
                        var pdispparams: DISPPARAMS; out pvarResult: OleVariant;
                        out pexcepinfo: EXCEPINFO; out puArgErr: SYSUINT): HResult; stdcall;
  end;


// *********************************************************************//
// Interface: IADsExtension
// Flags:     (0)
// GUID:      {3D35553C-D2B0-11D1-B17B-0000F87593A0}
// *********************************************************************//
  IADsExtension = interface(IUnknown)
    ['{3D35553C-D2B0-11D1-B17B-0000F87593A0}']
    function Operate(dwCode: LongWord; varData1: OleVariant; varData2: OleVariant;
                     varData3: OleVariant): HResult; stdcall;
    function PrivateGetIDsOfNames(var riid: TGUID; rgszNames: PWideChar; cNames: SYSUINT;
                                  lcid: LongWord; out rgdispid: Integer): HResult; stdcall;
    function PrivateInvoke(dispidMember: Integer; var riid: TGUID; lcid: LongWord; wFlags: Word;
                           var pdispparams: DISPPARAMS; out pvarResult: OleVariant;
                           out pexcepinfo: EXCEPINFO; out puArgErr: SYSUINT): HResult; stdcall;
  end;

// *********************************************************************//
// Interface: IADsDeleteOps
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B2BD0902-8878-11D1-8C21-00C04FD8D503}
// *********************************************************************//
  IADsDeleteOps = interface(IDispatch)
    ['{B2BD0902-8878-11D1-8C21-00C04FD8D503}']
    procedure DeleteObject(lnFlags: Integer); safecall;
  end;

// *********************************************************************//
// DispIntf:  IADsDeleteOpsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B2BD0902-8878-11D1-8C21-00C04FD8D503}
// *********************************************************************//
  IADsDeleteOpsDisp = dispinterface
    ['{B2BD0902-8878-11D1-8C21-00C04FD8D503}']
    procedure DeleteObject(lnFlags: Integer); dispid 2;
  end;

// *********************************************************************//
// Interface: IADsNamespaces
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {28B96BA0-B330-11CF-A9AD-00AA006BC149}
// *********************************************************************//
  IADsNamespaces = interface(IADs)
    ['{28B96BA0-B330-11CF-A9AD-00AA006BC149}']
    function Get_DefaultContainer: WideString; safecall;
    procedure Set_DefaultContainer(const retval: WideString); safecall;
    property DefaultContainer: WideString read Get_DefaultContainer write Set_DefaultContainer;
  end;

// *********************************************************************//
// DispIntf:  IADsNamespacesDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {28B96BA0-B330-11CF-A9AD-00AA006BC149}
// *********************************************************************//
  IADsNamespacesDisp = dispinterface
    ['{28B96BA0-B330-11CF-A9AD-00AA006BC149}']
    property DefaultContainer: WideString dispid 1;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsClass
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {C8F93DD0-4AE0-11CF-9E73-00AA004A5691}
// *********************************************************************//
  IADsClass = interface(IADs)
    ['{C8F93DD0-4AE0-11CF-9E73-00AA004A5691}']
    function Get_PrimaryInterface: WideString; safecall;
    function Get_CLSID: WideString; safecall;
    procedure Set_CLSID(const retval: WideString); safecall;
    function Get_OID: WideString; safecall;
    procedure Set_OID(const retval: WideString); safecall;
    function Get_Abstract: WordBool; safecall;
    procedure Set_Abstract(retval: WordBool); safecall;
    function Get_Auxiliary: WordBool; safecall;
    procedure Set_Auxiliary(retval: WordBool); safecall;
    function Get_MandatoryProperties: OleVariant; safecall;
    procedure Set_MandatoryProperties(retval: OleVariant); safecall;
    function Get_OptionalProperties: OleVariant; safecall;
    procedure Set_OptionalProperties(retval: OleVariant); safecall;
    function Get_NamingProperties: OleVariant; safecall;
    procedure Set_NamingProperties(retval: OleVariant); safecall;
    function Get_DerivedFrom: OleVariant; safecall;
    procedure Set_DerivedFrom(retval: OleVariant); safecall;
    function Get_AuxDerivedFrom: OleVariant; safecall;
    procedure Set_AuxDerivedFrom(retval: OleVariant); safecall;
    function Get_PossibleSuperiors: OleVariant; safecall;
    procedure Set_PossibleSuperiors(retval: OleVariant); safecall;
    function Get_Containment: OleVariant; safecall;
    procedure Set_Containment(retval: OleVariant); safecall;
    function Get_Container: WordBool; safecall;
    procedure Set_Container(retval: WordBool); safecall;
    function Get_HelpFileName: WideString; safecall;
    procedure Set_HelpFileName(const retval: WideString); safecall;
    function Get_HelpFileContext: Integer; safecall;
    procedure Set_HelpFileContext(retval: Integer); safecall;
    function Qualifiers: IADsCollection; safecall;
    property PrimaryInterface: WideString read Get_PrimaryInterface;
    property CLSID: WideString read Get_CLSID write Set_CLSID;
    property OID: WideString read Get_OID write Set_OID;
    property Abstract: WordBool read Get_Abstract write Set_Abstract;
    property Auxiliary: WordBool read Get_Auxiliary write Set_Auxiliary;
    property MandatoryProperties: OleVariant read Get_MandatoryProperties write Set_MandatoryProperties;
    property OptionalProperties: OleVariant read Get_OptionalProperties write Set_OptionalProperties;
    property NamingProperties: OleVariant read Get_NamingProperties write Set_NamingProperties;
    property DerivedFrom: OleVariant read Get_DerivedFrom write Set_DerivedFrom;
    property AuxDerivedFrom: OleVariant read Get_AuxDerivedFrom write Set_AuxDerivedFrom;
    property PossibleSuperiors: OleVariant read Get_PossibleSuperiors write Set_PossibleSuperiors;
    property Containment: OleVariant read Get_Containment write Set_Containment;
    property Container: WordBool read Get_Container write Set_Container;
    property HelpFileName: WideString read Get_HelpFileName write Set_HelpFileName;
    property HelpFileContext: Integer read Get_HelpFileContext write Set_HelpFileContext;
  end;

// *********************************************************************//
// DispIntf:  IADsClassDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {C8F93DD0-4AE0-11CF-9E73-00AA004A5691}
// *********************************************************************//
  IADsClassDisp = dispinterface
    ['{C8F93DD0-4AE0-11CF-9E73-00AA004A5691}']
    property PrimaryInterface: WideString readonly dispid 15;
    property CLSID: WideString dispid 16;
    property OID: WideString dispid 17;
    property Abstract: WordBool dispid 18;
    property Auxiliary: WordBool dispid 26;
    property MandatoryProperties: OleVariant dispid 19;
    property OptionalProperties: OleVariant dispid 29;
    property NamingProperties: OleVariant dispid 30;
    property DerivedFrom: OleVariant dispid 20;
    property AuxDerivedFrom: OleVariant dispid 27;
    property PossibleSuperiors: OleVariant dispid 28;
    property Containment: OleVariant dispid 21;
    property Container: WordBool dispid 22;
    property HelpFileName: WideString dispid 23;
    property HelpFileContext: Integer dispid 24;
    function Qualifiers: IADsCollection; dispid 25;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsProperty
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {C8F93DD3-4AE0-11CF-9E73-00AA004A5691}
// *********************************************************************//
  IADsProperty = interface(IADs)
    ['{C8F93DD3-4AE0-11CF-9E73-00AA004A5691}']
    function Get_OID: WideString; safecall;
    procedure Set_OID(const retval: WideString); safecall;
    function Get_Syntax: WideString; safecall;
    procedure Set_Syntax(const retval: WideString); safecall;
    function Get_MaxRange: Integer; safecall;
    procedure Set_MaxRange(retval: Integer); safecall;
    function Get_MinRange: Integer; safecall;
    procedure Set_MinRange(retval: Integer); safecall;
    function Get_MultiValued: WordBool; safecall;
    procedure Set_MultiValued(retval: WordBool); safecall;
    function Qualifiers: IADsCollection; safecall;
    property OID: WideString read Get_OID write Set_OID;
    property Syntax: WideString read Get_Syntax write Set_Syntax;
    property MaxRange: Integer read Get_MaxRange write Set_MaxRange;
    property MinRange: Integer read Get_MinRange write Set_MinRange;
    property MultiValued: WordBool read Get_MultiValued write Set_MultiValued;
  end;

// *********************************************************************//
// DispIntf:  IADsPropertyDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {C8F93DD3-4AE0-11CF-9E73-00AA004A5691}
// *********************************************************************//
  IADsPropertyDisp = dispinterface
    ['{C8F93DD3-4AE0-11CF-9E73-00AA004A5691}']
    property OID: WideString dispid 17;
    property Syntax: WideString dispid 18;
    property MaxRange: Integer dispid 19;
    property MinRange: Integer dispid 20;
    property MultiValued: WordBool dispid 21;
    function Qualifiers: IADsCollection; dispid 22;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsSyntax
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {C8F93DD2-4AE0-11CF-9E73-00AA004A5691}
// *********************************************************************//
  IADsSyntax = interface(IADs)
    ['{C8F93DD2-4AE0-11CF-9E73-00AA004A5691}']
    function Get_OleAutoDataType: Integer; safecall;
    procedure Set_OleAutoDataType(retval: Integer); safecall;
    property OleAutoDataType: Integer read Get_OleAutoDataType write Set_OleAutoDataType;
  end;

// *********************************************************************//
// DispIntf:  IADsSyntaxDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {C8F93DD2-4AE0-11CF-9E73-00AA004A5691}
// *********************************************************************//
  IADsSyntaxDisp = dispinterface
    ['{C8F93DD2-4AE0-11CF-9E73-00AA004A5691}']
    property OleAutoDataType: Integer dispid 15;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsLocality
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A05E03A2-EFFE-11CF-8ABC-00C04FD8D503}
// *********************************************************************//
  IADsLocality = interface(IADs)
    ['{A05E03A2-EFFE-11CF-8ABC-00C04FD8D503}']
    function Get_Description: WideString; safecall;
    procedure Set_Description(const retval: WideString); safecall;
    function Get_LocalityName: WideString; safecall;
    procedure Set_LocalityName(const retval: WideString); safecall;
    function Get_PostalAddress: WideString; safecall;
    procedure Set_PostalAddress(const retval: WideString); safecall;
    function Get_SeeAlso: OleVariant; safecall;
    procedure Set_SeeAlso(retval: OleVariant); safecall;
    property Description: WideString read Get_Description write Set_Description;
    property LocalityName: WideString read Get_LocalityName write Set_LocalityName;
    property PostalAddress: WideString read Get_PostalAddress write Set_PostalAddress;
    property SeeAlso: OleVariant read Get_SeeAlso write Set_SeeAlso;
  end;

// *********************************************************************//
// DispIntf:  IADsLocalityDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A05E03A2-EFFE-11CF-8ABC-00C04FD8D503}
// *********************************************************************//
  IADsLocalityDisp = dispinterface
    ['{A05E03A2-EFFE-11CF-8ABC-00C04FD8D503}']
    property Description: WideString dispid 15;
    property LocalityName: WideString dispid 16;
    property PostalAddress: WideString dispid 17;
    property SeeAlso: OleVariant dispid 18;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsO
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A1CD2DC6-EFFE-11CF-8ABC-00C04FD8D503}
// *********************************************************************//
  IADsO = interface(IADs)
    ['{A1CD2DC6-EFFE-11CF-8ABC-00C04FD8D503}']
    function Get_Description: WideString; safecall;
    procedure Set_Description(const retval: WideString); safecall;
    function Get_LocalityName: WideString; safecall;
    procedure Set_LocalityName(const retval: WideString); safecall;
    function Get_PostalAddress: WideString; safecall;
    procedure Set_PostalAddress(const retval: WideString); safecall;
    function Get_TelephoneNumber: WideString; safecall;
    procedure Set_TelephoneNumber(const retval: WideString); safecall;
    function Get_FaxNumber: WideString; safecall;
    procedure Set_FaxNumber(const retval: WideString); safecall;
    function Get_SeeAlso: OleVariant; safecall;
    procedure Set_SeeAlso(retval: OleVariant); safecall;
    property Description: WideString read Get_Description write Set_Description;
    property LocalityName: WideString read Get_LocalityName write Set_LocalityName;
    property PostalAddress: WideString read Get_PostalAddress write Set_PostalAddress;
    property TelephoneNumber: WideString read Get_TelephoneNumber write Set_TelephoneNumber;
    property FaxNumber: WideString read Get_FaxNumber write Set_FaxNumber;
    property SeeAlso: OleVariant read Get_SeeAlso write Set_SeeAlso;
  end;

// *********************************************************************//
// DispIntf:  IADsODisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A1CD2DC6-EFFE-11CF-8ABC-00C04FD8D503}
// *********************************************************************//
  IADsODisp = dispinterface
    ['{A1CD2DC6-EFFE-11CF-8ABC-00C04FD8D503}']
    property Description: WideString dispid 15;
    property LocalityName: WideString dispid 16;
    property PostalAddress: WideString dispid 17;
    property TelephoneNumber: WideString dispid 18;
    property FaxNumber: WideString dispid 19;
    property SeeAlso: OleVariant dispid 20;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsOU
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A2F733B8-EFFE-11CF-8ABC-00C04FD8D503}
// *********************************************************************//
  IADsOU = interface(IADs)
    ['{A2F733B8-EFFE-11CF-8ABC-00C04FD8D503}']
    function Get_Description: WideString; safecall;
    procedure Set_Description(const retval: WideString); safecall;
    function Get_LocalityName: WideString; safecall;
    procedure Set_LocalityName(const retval: WideString); safecall;
    function Get_PostalAddress: WideString; safecall;
    procedure Set_PostalAddress(const retval: WideString); safecall;
    function Get_TelephoneNumber: WideString; safecall;
    procedure Set_TelephoneNumber(const retval: WideString); safecall;
    function Get_FaxNumber: WideString; safecall;
    procedure Set_FaxNumber(const retval: WideString); safecall;
    function Get_SeeAlso: OleVariant; safecall;
    procedure Set_SeeAlso(retval: OleVariant); safecall;
    function Get_BusinessCategory: WideString; safecall;
    procedure Set_BusinessCategory(const retval: WideString); safecall;
    property Description: WideString read Get_Description write Set_Description;
    property LocalityName: WideString read Get_LocalityName write Set_LocalityName;
    property PostalAddress: WideString read Get_PostalAddress write Set_PostalAddress;
    property TelephoneNumber: WideString read Get_TelephoneNumber write Set_TelephoneNumber;
    property FaxNumber: WideString read Get_FaxNumber write Set_FaxNumber;
    property SeeAlso: OleVariant read Get_SeeAlso write Set_SeeAlso;
    property BusinessCategory: WideString read Get_BusinessCategory write Set_BusinessCategory;
  end;

// *********************************************************************//
// DispIntf:  IADsOUDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A2F733B8-EFFE-11CF-8ABC-00C04FD8D503}
// *********************************************************************//
  IADsOUDisp = dispinterface
    ['{A2F733B8-EFFE-11CF-8ABC-00C04FD8D503}']
    property Description: WideString dispid 15;
    property LocalityName: WideString dispid 16;
    property PostalAddress: WideString dispid 17;
    property TelephoneNumber: WideString dispid 18;
    property FaxNumber: WideString dispid 19;
    property SeeAlso: OleVariant dispid 20;
    property BusinessCategory: WideString dispid 21;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsDomain
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {00E4C220-FD16-11CE-ABC4-02608C9E7553}
// *********************************************************************//
  IADsDomain = interface(IADs)
    ['{00E4C220-FD16-11CE-ABC4-02608C9E7553}']
    function Get_IsWorkgroup: WordBool; safecall;
    function Get_MinPasswordLength: Integer; safecall;
    procedure Set_MinPasswordLength(retval: Integer); safecall;
    function Get_MinPasswordAge: Integer; safecall;
    procedure Set_MinPasswordAge(retval: Integer); safecall;
    function Get_MaxPasswordAge: Integer; safecall;
    procedure Set_MaxPasswordAge(retval: Integer); safecall;
    function Get_MaxBadPasswordsAllowed: Integer; safecall;
    procedure Set_MaxBadPasswordsAllowed(retval: Integer); safecall;
    function Get_PasswordHistoryLength: Integer; safecall;
    procedure Set_PasswordHistoryLength(retval: Integer); safecall;
    function Get_PasswordAttributes: Integer; safecall;
    procedure Set_PasswordAttributes(retval: Integer); safecall;
    function Get_AutoUnlockInterval: Integer; safecall;
    procedure Set_AutoUnlockInterval(retval: Integer); safecall;
    function Get_LockoutObservationInterval: Integer; safecall;
    procedure Set_LockoutObservationInterval(retval: Integer); safecall;
    property IsWorkgroup: WordBool read Get_IsWorkgroup;
    property MinPasswordLength: Integer read Get_MinPasswordLength write Set_MinPasswordLength;
    property MinPasswordAge: Integer read Get_MinPasswordAge write Set_MinPasswordAge;
    property MaxPasswordAge: Integer read Get_MaxPasswordAge write Set_MaxPasswordAge;
    property MaxBadPasswordsAllowed: Integer read Get_MaxBadPasswordsAllowed write Set_MaxBadPasswordsAllowed;
    property PasswordHistoryLength: Integer read Get_PasswordHistoryLength write Set_PasswordHistoryLength;
    property PasswordAttributes: Integer read Get_PasswordAttributes write Set_PasswordAttributes;
    property AutoUnlockInterval: Integer read Get_AutoUnlockInterval write Set_AutoUnlockInterval;
    property LockoutObservationInterval: Integer read Get_LockoutObservationInterval write Set_LockoutObservationInterval;
  end;

// *********************************************************************//
// DispIntf:  IADsDomainDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {00E4C220-FD16-11CE-ABC4-02608C9E7553}
// *********************************************************************//
  IADsDomainDisp = dispinterface
    ['{00E4C220-FD16-11CE-ABC4-02608C9E7553}']
    property IsWorkgroup: WordBool readonly dispid 15;
    property MinPasswordLength: Integer dispid 16;
    property MinPasswordAge: Integer dispid 17;
    property MaxPasswordAge: Integer dispid 18;
    property MaxBadPasswordsAllowed: Integer dispid 19;
    property PasswordHistoryLength: Integer dispid 20;
    property PasswordAttributes: Integer dispid 21;
    property AutoUnlockInterval: Integer dispid 22;
    property LockoutObservationInterval: Integer dispid 23;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsComputer
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {EFE3CC70-1D9F-11CF-B1F3-02608C9E7553}
// *********************************************************************//
  IADsComputer = interface(IADs)
    ['{EFE3CC70-1D9F-11CF-B1F3-02608C9E7553}']
    function Get_ComputerID: WideString; safecall;
    function Get_Site: WideString; safecall;
    function Get_Description: WideString; safecall;
    procedure Set_Description(const retval: WideString); safecall;
    function Get_Location: WideString; safecall;
    procedure Set_Location(const retval: WideString); safecall;
    function Get_PrimaryUser: WideString; safecall;
    procedure Set_PrimaryUser(const retval: WideString); safecall;
    function Get_Owner: WideString; safecall;
    procedure Set_Owner(const retval: WideString); safecall;
    function Get_Division: WideString; safecall;
    procedure Set_Division(const retval: WideString); safecall;
    function Get_Department: WideString; safecall;
    procedure Set_Department(const retval: WideString); safecall;
    function Get_Role: WideString; safecall;
    procedure Set_Role(const retval: WideString); safecall;
    function Get_OperatingSystem: WideString; safecall;
    procedure Set_OperatingSystem(const retval: WideString); safecall;
    function Get_OperatingSystemVersion: WideString; safecall;
    procedure Set_OperatingSystemVersion(const retval: WideString); safecall;
    function Get_Model: WideString; safecall;
    procedure Set_Model(const retval: WideString); safecall;
    function Get_Processor: WideString; safecall;
    procedure Set_Processor(const retval: WideString); safecall;
    function Get_ProcessorCount: WideString; safecall;
    procedure Set_ProcessorCount(const retval: WideString); safecall;
    function Get_MemorySize: WideString; safecall;
    procedure Set_MemorySize(const retval: WideString); safecall;
    function Get_StorageCapacity: WideString; safecall;
    procedure Set_StorageCapacity(const retval: WideString); safecall;
    function Get_NetAddresses: OleVariant; safecall;
    procedure Set_NetAddresses(retval: OleVariant); safecall;
    property ComputerID: WideString read Get_ComputerID;
    property Site: WideString read Get_Site;
    property Description: WideString read Get_Description write Set_Description;
    property Location: WideString read Get_Location write Set_Location;
    property PrimaryUser: WideString read Get_PrimaryUser write Set_PrimaryUser;
    property Owner: WideString read Get_Owner write Set_Owner;
    property Division: WideString read Get_Division write Set_Division;
    property Department: WideString read Get_Department write Set_Department;
    property Role: WideString read Get_Role write Set_Role;
    property OperatingSystem: WideString read Get_OperatingSystem write Set_OperatingSystem;
    property OperatingSystemVersion: WideString read Get_OperatingSystemVersion write Set_OperatingSystemVersion;
    property Model: WideString read Get_Model write Set_Model;
    property Processor: WideString read Get_Processor write Set_Processor;
    property ProcessorCount: WideString read Get_ProcessorCount write Set_ProcessorCount;
    property MemorySize: WideString read Get_MemorySize write Set_MemorySize;
    property StorageCapacity: WideString read Get_StorageCapacity write Set_StorageCapacity;
    property NetAddresses: OleVariant read Get_NetAddresses write Set_NetAddresses;
  end;

// *********************************************************************//
// DispIntf:  IADsComputerDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {EFE3CC70-1D9F-11CF-B1F3-02608C9E7553}
// *********************************************************************//
  IADsComputerDisp = dispinterface
    ['{EFE3CC70-1D9F-11CF-B1F3-02608C9E7553}']
    property ComputerID: WideString readonly dispid 16;
    property Site: WideString readonly dispid 18;
    property Description: WideString dispid 19;
    property Location: WideString dispid 20;
    property PrimaryUser: WideString dispid 21;
    property Owner: WideString dispid 22;
    property Division: WideString dispid 23;
    property Department: WideString dispid 24;
    property Role: WideString dispid 25;
    property OperatingSystem: WideString dispid 26;
    property OperatingSystemVersion: WideString dispid 27;
    property Model: WideString dispid 28;
    property Processor: WideString dispid 29;
    property ProcessorCount: WideString dispid 30;
    property MemorySize: WideString dispid 31;
    property StorageCapacity: WideString dispid 32;
    property NetAddresses: OleVariant dispid 17;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsComputerOperations
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {EF497680-1D9F-11CF-B1F3-02608C9E7553}
// *********************************************************************//
  IADsComputerOperations = interface(IADs)
    ['{EF497680-1D9F-11CF-B1F3-02608C9E7553}']
    function Status: IDispatch; safecall;
    procedure Shutdown(bReboot: WordBool); safecall;
  end;

// *********************************************************************//
// DispIntf:  IADsComputerOperationsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {EF497680-1D9F-11CF-B1F3-02608C9E7553}
// *********************************************************************//
  IADsComputerOperationsDisp = dispinterface
    ['{EF497680-1D9F-11CF-B1F3-02608C9E7553}']
    function Status: IDispatch; dispid 33;
    procedure Shutdown(bReboot: WordBool); dispid 34;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsGroup
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {27636B00-410F-11CF-B1FF-02608C9E7553}
// *********************************************************************//
  IADsGroup = interface(IADs)
    ['{27636B00-410F-11CF-B1FF-02608C9E7553}']
    function Get_Description: WideString; safecall;
    procedure Set_Description(const retval: WideString); safecall;
    function Members: IADsMembers; safecall;
    function IsMember(const bstrMember: WideString): WordBool; safecall;
    procedure Add(const bstrNewItem: WideString); safecall;
    procedure Remove(const bstrItemToBeRemoved: WideString); safecall;
    property Description: WideString read Get_Description write Set_Description;
  end;

// *********************************************************************//
// DispIntf:  IADsGroupDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {27636B00-410F-11CF-B1FF-02608C9E7553}
// *********************************************************************//
  IADsGroupDisp = dispinterface
    ['{27636B00-410F-11CF-B1FF-02608C9E7553}']
    property Description: WideString dispid 15;
    function Members: IADsMembers; dispid 16;
    function IsMember(const bstrMember: WideString): WordBool; dispid 17;
    procedure Add(const bstrNewItem: WideString); dispid 18;
    procedure Remove(const bstrItemToBeRemoved: WideString); dispid 19;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsUser
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {3E37E320-17E2-11CF-ABC4-02608C9E7553}
// *********************************************************************//
  IADsUser = interface(IADs)
    ['{3E37E320-17E2-11CF-ABC4-02608C9E7553}']
    function Get_BadLoginAddress: WideString; safecall;
    function Get_BadLoginCount: Integer; safecall;
    function Get_LastLogin: TDateTime; safecall;
    function Get_LastLogoff: TDateTime; safecall;
    function Get_LastFailedLogin: TDateTime; safecall;
    function Get_PasswordLastChanged: TDateTime; safecall;
    function Get_Description: WideString; safecall;
    procedure Set_Description(const retval: WideString); safecall;
    function Get_Division: WideString; safecall;
    procedure Set_Division(const retval: WideString); safecall;
    function Get_Department: WideString; safecall;
    procedure Set_Department(const retval: WideString); safecall;
    function Get_EmployeeID: WideString; safecall;
    procedure Set_EmployeeID(const retval: WideString); safecall;
    function Get_FullName: WideString; safecall;
    procedure Set_FullName(const retval: WideString); safecall;
    function Get_FirstName: WideString; safecall;
    procedure Set_FirstName(const retval: WideString); safecall;
    function Get_LastName: WideString; safecall;
    procedure Set_LastName(const retval: WideString); safecall;
    function Get_OtherName: WideString; safecall;
    procedure Set_OtherName(const retval: WideString); safecall;
    function Get_NamePrefix: WideString; safecall;
    procedure Set_NamePrefix(const retval: WideString); safecall;
    function Get_NameSuffix: WideString; safecall;
    procedure Set_NameSuffix(const retval: WideString); safecall;
    function Get_Title: WideString; safecall;
    procedure Set_Title(const retval: WideString); safecall;
    function Get_Manager: WideString; safecall;
    procedure Set_Manager(const retval: WideString); safecall;
    function Get_TelephoneHome: OleVariant; safecall;
    procedure Set_TelephoneHome(retval: OleVariant); safecall;
    function Get_TelephoneMobile: OleVariant; safecall;
    procedure Set_TelephoneMobile(retval: OleVariant); safecall;
    function Get_TelephoneNumber: OleVariant; safecall;
    procedure Set_TelephoneNumber(retval: OleVariant); safecall;
    function Get_TelephonePager: OleVariant; safecall;
    procedure Set_TelephonePager(retval: OleVariant); safecall;
    function Get_FaxNumber: OleVariant; safecall;
    procedure Set_FaxNumber(retval: OleVariant); safecall;
    function Get_OfficeLocations: OleVariant; safecall;
    procedure Set_OfficeLocations(retval: OleVariant); safecall;
    function Get_PostalAddresses: OleVariant; safecall;
    procedure Set_PostalAddresses(retval: OleVariant); safecall;
    function Get_PostalCodes: OleVariant; safecall;
    procedure Set_PostalCodes(retval: OleVariant); safecall;
    function Get_SeeAlso: OleVariant; safecall;
    procedure Set_SeeAlso(retval: OleVariant); safecall;
    function Get_AccountDisabled: WordBool; safecall;
    procedure Set_AccountDisabled(retval: WordBool); safecall;
    function Get_AccountExpirationDate: TDateTime; safecall;
    procedure Set_AccountExpirationDate(retval: TDateTime); safecall;
    function Get_GraceLoginsAllowed: Integer; safecall;
    procedure Set_GraceLoginsAllowed(retval: Integer); safecall;
    function Get_GraceLoginsRemaining: Integer; safecall;
    procedure Set_GraceLoginsRemaining(retval: Integer); safecall;
    function Get_IsAccountLocked: WordBool; safecall;
    procedure Set_IsAccountLocked(retval: WordBool); safecall;
    function Get_LoginHours: OleVariant; safecall;
    procedure Set_LoginHours(retval: OleVariant); safecall;
    function Get_LoginWorkstations: OleVariant; safecall;
    procedure Set_LoginWorkstations(retval: OleVariant); safecall;
    function Get_MaxLogins: Integer; safecall;
    procedure Set_MaxLogins(retval: Integer); safecall;
    function Get_MaxStorage: Integer; safecall;
    procedure Set_MaxStorage(retval: Integer); safecall;
    function Get_PasswordExpirationDate: TDateTime; safecall;
    procedure Set_PasswordExpirationDate(retval: TDateTime); safecall;
    function Get_PasswordMinimumLength: Integer; safecall;
    procedure Set_PasswordMinimumLength(retval: Integer); safecall;
    function Get_PasswordRequired: WordBool; safecall;
    procedure Set_PasswordRequired(retval: WordBool); safecall;
    function Get_RequireUniquePassword: WordBool; safecall;
    procedure Set_RequireUniquePassword(retval: WordBool); safecall;
    function Get_EmailAddress: WideString; safecall;
    procedure Set_EmailAddress(const retval: WideString); safecall;
    function Get_HomeDirectory: WideString; safecall;
    procedure Set_HomeDirectory(const retval: WideString); safecall;
    function Get_Languages: OleVariant; safecall;
    procedure Set_Languages(retval: OleVariant); safecall;
    function Get_Profile: WideString; safecall;
    procedure Set_Profile(const retval: WideString); safecall;
    function Get_LoginScript: WideString; safecall;
    procedure Set_LoginScript(const retval: WideString); safecall;
    function Get_Picture: OleVariant; safecall;
    procedure Set_Picture(retval: OleVariant); safecall;
    function Get_HomePage: WideString; safecall;
    procedure Set_HomePage(const retval: WideString); safecall;
    function Groups: IADsMembers; safecall;
    procedure SetPassword(const NewPassword: WideString); safecall;
    procedure ChangePassword(const bstrOldPassword: WideString; const bstrNewPassword: WideString); safecall;
    property BadLoginAddress: WideString read Get_BadLoginAddress;
    property BadLoginCount: Integer read Get_BadLoginCount;
    property LastLogin: TDateTime read Get_LastLogin;
    property LastLogoff: TDateTime read Get_LastLogoff;
    property LastFailedLogin: TDateTime read Get_LastFailedLogin;
    property PasswordLastChanged: TDateTime read Get_PasswordLastChanged;
    property Description: WideString read Get_Description write Set_Description;
    property Division: WideString read Get_Division write Set_Division;
    property Department: WideString read Get_Department write Set_Department;
    property EmployeeID: WideString read Get_EmployeeID write Set_EmployeeID;
    property FullName: WideString read Get_FullName write Set_FullName;
    property FirstName: WideString read Get_FirstName write Set_FirstName;
    property LastName: WideString read Get_LastName write Set_LastName;
    property OtherName: WideString read Get_OtherName write Set_OtherName;
    property NamePrefix: WideString read Get_NamePrefix write Set_NamePrefix;
    property NameSuffix: WideString read Get_NameSuffix write Set_NameSuffix;
    property Title: WideString read Get_Title write Set_Title;
    property Manager: WideString read Get_Manager write Set_Manager;
    property TelephoneHome: OleVariant read Get_TelephoneHome write Set_TelephoneHome;
    property TelephoneMobile: OleVariant read Get_TelephoneMobile write Set_TelephoneMobile;
    property TelephoneNumber: OleVariant read Get_TelephoneNumber write Set_TelephoneNumber;
    property TelephonePager: OleVariant read Get_TelephonePager write Set_TelephonePager;
    property FaxNumber: OleVariant read Get_FaxNumber write Set_FaxNumber;
    property OfficeLocations: OleVariant read Get_OfficeLocations write Set_OfficeLocations;
    property PostalAddresses: OleVariant read Get_PostalAddresses write Set_PostalAddresses;
    property PostalCodes: OleVariant read Get_PostalCodes write Set_PostalCodes;
    property SeeAlso: OleVariant read Get_SeeAlso write Set_SeeAlso;
    property AccountDisabled: WordBool read Get_AccountDisabled write Set_AccountDisabled;
    property AccountExpirationDate: TDateTime read Get_AccountExpirationDate write Set_AccountExpirationDate;
    property GraceLoginsAllowed: Integer read Get_GraceLoginsAllowed write Set_GraceLoginsAllowed;
    property GraceLoginsRemaining: Integer read Get_GraceLoginsRemaining write Set_GraceLoginsRemaining;
    property IsAccountLocked: WordBool read Get_IsAccountLocked write Set_IsAccountLocked;
    property LoginHours: OleVariant read Get_LoginHours write Set_LoginHours;
    property LoginWorkstations: OleVariant read Get_LoginWorkstations write Set_LoginWorkstations;
    property MaxLogins: Integer read Get_MaxLogins write Set_MaxLogins;
    property MaxStorage: Integer read Get_MaxStorage write Set_MaxStorage;
    property PasswordExpirationDate: TDateTime read Get_PasswordExpirationDate write Set_PasswordExpirationDate;
    property PasswordMinimumLength: Integer read Get_PasswordMinimumLength write Set_PasswordMinimumLength;
    property PasswordRequired: WordBool read Get_PasswordRequired write Set_PasswordRequired;
    property RequireUniquePassword: WordBool read Get_RequireUniquePassword write Set_RequireUniquePassword;
    property EmailAddress: WideString read Get_EmailAddress write Set_EmailAddress;
    property HomeDirectory: WideString read Get_HomeDirectory write Set_HomeDirectory;
    property Languages: OleVariant read Get_Languages write Set_Languages;
    property Profile: WideString read Get_Profile write Set_Profile;
    property LoginScript: WideString read Get_LoginScript write Set_LoginScript;
    property Picture: OleVariant read Get_Picture write Set_Picture;
    property HomePage: WideString read Get_HomePage write Set_HomePage;
  end;

// *********************************************************************//
// DispIntf:  IADsUserDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {3E37E320-17E2-11CF-ABC4-02608C9E7553}
// *********************************************************************//
  IADsUserDisp = dispinterface
    ['{3E37E320-17E2-11CF-ABC4-02608C9E7553}']
    property BadLoginAddress: WideString readonly dispid 53;
    property BadLoginCount: Integer readonly dispid 54;
    property LastLogin: TDateTime readonly dispid 56;
    property LastLogoff: TDateTime readonly dispid 57;
    property LastFailedLogin: TDateTime readonly dispid 58;
    property PasswordLastChanged: TDateTime readonly dispid 59;
    property Description: WideString dispid 15;
    property Division: WideString dispid 19;
    property Department: WideString dispid 122;
    property EmployeeID: WideString dispid 20;
    property FullName: WideString dispid 23;
    property FirstName: WideString dispid 22;
    property LastName: WideString dispid 25;
    property OtherName: WideString dispid 27;
    property NamePrefix: WideString dispid 114;
    property NameSuffix: WideString dispid 115;
    property Title: WideString dispid 36;
    property Manager: WideString dispid 26;
    property TelephoneHome: OleVariant dispid 32;
    property TelephoneMobile: OleVariant dispid 33;
    property TelephoneNumber: OleVariant dispid 34;
    property TelephonePager: OleVariant dispid 17;
    property FaxNumber: OleVariant dispid 16;
    property OfficeLocations: OleVariant dispid 28;
    property PostalAddresses: OleVariant dispid 30;
    property PostalCodes: OleVariant dispid 31;
    property SeeAlso: OleVariant dispid 117;
    property AccountDisabled: WordBool dispid 37;
    property AccountExpirationDate: TDateTime dispid 38;
    property GraceLoginsAllowed: Integer dispid 41;
    property GraceLoginsRemaining: Integer dispid 42;
    property IsAccountLocked: WordBool dispid 43;
    property LoginHours: OleVariant dispid 45;
    property LoginWorkstations: OleVariant dispid 46;
    property MaxLogins: Integer dispid 47;
    property MaxStorage: Integer dispid 48;
    property PasswordExpirationDate: TDateTime dispid 49;
    property PasswordMinimumLength: Integer dispid 50;
    property PasswordRequired: WordBool dispid 51;
    property RequireUniquePassword: WordBool dispid 52;
    property EmailAddress: WideString dispid 60;
    property HomeDirectory: WideString dispid 61;
    property Languages: OleVariant dispid 62;
    property Profile: WideString dispid 63;
    property LoginScript: WideString dispid 64;
    property Picture: OleVariant dispid 65;
    property HomePage: WideString dispid 120;
    function Groups: IADsMembers; dispid 66;
    procedure SetPassword(const NewPassword: WideString); dispid 67;
    procedure ChangePassword(const bstrOldPassword: WideString; const bstrNewPassword: WideString); dispid 68;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsPrintQueue
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B15160D0-1226-11CF-A985-00AA006BC149}
// *********************************************************************//
  IADsPrintQueue = interface(IADs)
    ['{B15160D0-1226-11CF-A985-00AA006BC149}']
    function Get_PrinterPath: WideString; safecall;
    procedure Set_PrinterPath(const retval: WideString); safecall;
    function Get_Model: WideString; safecall;
    procedure Set_Model(const retval: WideString); safecall;
    function Get_Datatype: WideString; safecall;
    procedure Set_Datatype(const retval: WideString); safecall;
    function Get_PrintProcessor: WideString; safecall;
    procedure Set_PrintProcessor(const retval: WideString); safecall;
    function Get_Description: WideString; safecall;
    procedure Set_Description(const retval: WideString); safecall;
    function Get_Location: WideString; safecall;
    procedure Set_Location(const retval: WideString); safecall;
    function Get_StartTime: TDateTime; safecall;
    procedure Set_StartTime(retval: TDateTime); safecall;
    function Get_UntilTime: TDateTime; safecall;
    procedure Set_UntilTime(retval: TDateTime); safecall;
    function Get_DefaultJobPriority: Integer; safecall;
    procedure Set_DefaultJobPriority(retval: Integer); safecall;
    function Get_Priority: Integer; safecall;
    procedure Set_Priority(retval: Integer); safecall;
    function Get_BannerPage: WideString; safecall;
    procedure Set_BannerPage(const retval: WideString); safecall;
    function Get_PrintDevices: OleVariant; safecall;
    procedure Set_PrintDevices(retval: OleVariant); safecall;
    function Get_NetAddresses: OleVariant; safecall;
    procedure Set_NetAddresses(retval: OleVariant); safecall;
    property PrinterPath: WideString read Get_PrinterPath write Set_PrinterPath;
    property Model: WideString read Get_Model write Set_Model;
    property Datatype: WideString read Get_Datatype write Set_Datatype;
    property PrintProcessor: WideString read Get_PrintProcessor write Set_PrintProcessor;
    property Description: WideString read Get_Description write Set_Description;
    property Location: WideString read Get_Location write Set_Location;
    property StartTime: TDateTime read Get_StartTime write Set_StartTime;
    property UntilTime: TDateTime read Get_UntilTime write Set_UntilTime;
    property DefaultJobPriority: Integer read Get_DefaultJobPriority write Set_DefaultJobPriority;
    property Priority: Integer read Get_Priority write Set_Priority;
    property BannerPage: WideString read Get_BannerPage write Set_BannerPage;
    property PrintDevices: OleVariant read Get_PrintDevices write Set_PrintDevices;
    property NetAddresses: OleVariant read Get_NetAddresses write Set_NetAddresses;
  end;

// *********************************************************************//
// DispIntf:  IADsPrintQueueDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B15160D0-1226-11CF-A985-00AA006BC149}
// *********************************************************************//
  IADsPrintQueueDisp = dispinterface
    ['{B15160D0-1226-11CF-A985-00AA006BC149}']
    property PrinterPath: WideString dispid 15;
    property Model: WideString dispid 16;
    property Datatype: WideString dispid 17;
    property PrintProcessor: WideString dispid 18;
    property Description: WideString dispid 19;
    property Location: WideString dispid 20;
    property StartTime: TDateTime dispid 21;
    property UntilTime: TDateTime dispid 22;
    property DefaultJobPriority: Integer dispid 23;
    property Priority: Integer dispid 24;
    property BannerPage: WideString dispid 25;
    property PrintDevices: OleVariant dispid 26;
    property NetAddresses: OleVariant dispid 27;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsPrintQueueOperations
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {124BE5C0-156E-11CF-A986-00AA006BC149}
// *********************************************************************//
  IADsPrintQueueOperations = interface(IADs)
    ['{124BE5C0-156E-11CF-A986-00AA006BC149}']
    function Get_Status: Integer; safecall;
    function PrintJobs: IADsCollection; safecall;
    procedure Pause; safecall;
    procedure Resume; safecall;
    procedure Purge; safecall;
    property Status: Integer read Get_Status;
  end;

// *********************************************************************//
// DispIntf:  IADsPrintQueueOperationsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {124BE5C0-156E-11CF-A986-00AA006BC149}
// *********************************************************************//
  IADsPrintQueueOperationsDisp = dispinterface
    ['{124BE5C0-156E-11CF-A986-00AA006BC149}']
    property Status: Integer readonly dispid 27;
    function PrintJobs: IADsCollection; dispid 28;
    procedure Pause; dispid 29;
    procedure Resume; dispid 30;
    procedure Purge; dispid 31;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsPrintJob
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {32FB6780-1ED0-11CF-A988-00AA006BC149}
// *********************************************************************//
  IADsPrintJob = interface(IADs)
    ['{32FB6780-1ED0-11CF-A988-00AA006BC149}']
    function Get_HostPrintQueue: WideString; safecall;
    function Get_User: WideString; safecall;
    function Get_UserPath: WideString; safecall;
    function Get_TimeSubmitted: TDateTime; safecall;
    function Get_TotalPages: Integer; safecall;
    function Get_Size: Integer; safecall;
    function Get_Description: WideString; safecall;
    procedure Set_Description(const retval: WideString); safecall;
    function Get_Priority: Integer; safecall;
    procedure Set_Priority(retval: Integer); safecall;
    function Get_StartTime: TDateTime; safecall;
    procedure Set_StartTime(retval: TDateTime); safecall;
    function Get_UntilTime: TDateTime; safecall;
    procedure Set_UntilTime(retval: TDateTime); safecall;
    function Get_Notify: WideString; safecall;
    procedure Set_Notify(const retval: WideString); safecall;
    function Get_NotifyPath: WideString; safecall;
    procedure Set_NotifyPath(const retval: WideString); safecall;
    property HostPrintQueue: WideString read Get_HostPrintQueue;
    property User: WideString read Get_User;
    property UserPath: WideString read Get_UserPath;
    property TimeSubmitted: TDateTime read Get_TimeSubmitted;
    property TotalPages: Integer read Get_TotalPages;
    property Size: Integer read Get_Size;
    property Description: WideString read Get_Description write Set_Description;
    property Priority: Integer read Get_Priority write Set_Priority;
    property StartTime: TDateTime read Get_StartTime write Set_StartTime;
    property UntilTime: TDateTime read Get_UntilTime write Set_UntilTime;
    property Notify: WideString read Get_Notify write Set_Notify;
    property NotifyPath: WideString read Get_NotifyPath write Set_NotifyPath;
  end;

// *********************************************************************//
// DispIntf:  IADsPrintJobDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {32FB6780-1ED0-11CF-A988-00AA006BC149}
// *********************************************************************//
  IADsPrintJobDisp = dispinterface
    ['{32FB6780-1ED0-11CF-A988-00AA006BC149}']
    property HostPrintQueue: WideString readonly dispid 15;
    property User: WideString readonly dispid 16;
    property UserPath: WideString readonly dispid 17;
    property TimeSubmitted: TDateTime readonly dispid 18;
    property TotalPages: Integer readonly dispid 19;
    property Size: Integer readonly dispid 234;
    property Description: WideString dispid 20;
    property Priority: Integer dispid 21;
    property StartTime: TDateTime dispid 22;
    property UntilTime: TDateTime dispid 23;
    property Notify: WideString dispid 24;
    property NotifyPath: WideString dispid 25;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsPrintJobOperations
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {9A52DB30-1ECF-11CF-A988-00AA006BC149}
// *********************************************************************//
  IADsPrintJobOperations = interface(IADs)
    ['{9A52DB30-1ECF-11CF-A988-00AA006BC149}']
    function Get_Status: Integer; safecall;
    function Get_TimeElapsed: Integer; safecall;
    function Get_PagesPrinted: Integer; safecall;
    function Get_Position: Integer; safecall;
    procedure Set_Position(retval: Integer); safecall;
    procedure Pause; safecall;
    procedure Resume; safecall;
    property Status: Integer read Get_Status;
    property TimeElapsed: Integer read Get_TimeElapsed;
    property PagesPrinted: Integer read Get_PagesPrinted;
    property Position: Integer read Get_Position write Set_Position;
  end;

// *********************************************************************//
// DispIntf:  IADsPrintJobOperationsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {9A52DB30-1ECF-11CF-A988-00AA006BC149}
// *********************************************************************//
  IADsPrintJobOperationsDisp = dispinterface
    ['{9A52DB30-1ECF-11CF-A988-00AA006BC149}']
    property Status: Integer readonly dispid 26;
    property TimeElapsed: Integer readonly dispid 27;
    property PagesPrinted: Integer readonly dispid 28;
    property Position: Integer dispid 29;
    procedure Pause; dispid 30;
    procedure Resume; dispid 31;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsService
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {68AF66E0-31CA-11CF-A98A-00AA006BC149}
// *********************************************************************//
  IADsService = interface(IADs)
    ['{68AF66E0-31CA-11CF-A98A-00AA006BC149}']
    function Get_HostComputer: WideString; safecall;
    procedure Set_HostComputer(const retval: WideString); safecall;
    function Get_DisplayName: WideString; safecall;
    procedure Set_DisplayName(const retval: WideString); safecall;
    function Get_Version: WideString; safecall;
    procedure Set_Version(const retval: WideString); safecall;
    function Get_ServiceType: Integer; safecall;
    procedure Set_ServiceType(retval: Integer); safecall;
    function Get_StartType: Integer; safecall;
    procedure Set_StartType(retval: Integer); safecall;
    function Get_Path: WideString; safecall;
    procedure Set_Path(const retval: WideString); safecall;
    function Get_StartupParameters: WideString; safecall;
    procedure Set_StartupParameters(const retval: WideString); safecall;
    function Get_ErrorControl: Integer; safecall;
    procedure Set_ErrorControl(retval: Integer); safecall;
    function Get_LoadOrderGroup: WideString; safecall;
    procedure Set_LoadOrderGroup(const retval: WideString); safecall;
    function Get_ServiceAccountName: WideString; safecall;
    procedure Set_ServiceAccountName(const retval: WideString); safecall;
    function Get_ServiceAccountPath: WideString; safecall;
    procedure Set_ServiceAccountPath(const retval: WideString); safecall;
    function Get_Dependencies: OleVariant; safecall;
    procedure Set_Dependencies(retval: OleVariant); safecall;
    property HostComputer: WideString read Get_HostComputer write Set_HostComputer;
    property DisplayName: WideString read Get_DisplayName write Set_DisplayName;
    property Version: WideString read Get_Version write Set_Version;
    property ServiceType: Integer read Get_ServiceType write Set_ServiceType;
    property StartType: Integer read Get_StartType write Set_StartType;
    property Path: WideString read Get_Path write Set_Path;
    property StartupParameters: WideString read Get_StartupParameters write Set_StartupParameters;
    property ErrorControl: Integer read Get_ErrorControl write Set_ErrorControl;
    property LoadOrderGroup: WideString read Get_LoadOrderGroup write Set_LoadOrderGroup;
    property ServiceAccountName: WideString read Get_ServiceAccountName write Set_ServiceAccountName;
    property ServiceAccountPath: WideString read Get_ServiceAccountPath write Set_ServiceAccountPath;
    property Dependencies: OleVariant read Get_Dependencies write Set_Dependencies;
  end;

// *********************************************************************//
// DispIntf:  IADsServiceDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {68AF66E0-31CA-11CF-A98A-00AA006BC149}
// *********************************************************************//
  IADsServiceDisp = dispinterface
    ['{68AF66E0-31CA-11CF-A98A-00AA006BC149}']
    property HostComputer: WideString dispid 15;
    property DisplayName: WideString dispid 16;
    property Version: WideString dispid 17;
    property ServiceType: Integer dispid 18;
    property StartType: Integer dispid 19;
    property Path: WideString dispid 20;
    property StartupParameters: WideString dispid 21;
    property ErrorControl: Integer dispid 22;
    property LoadOrderGroup: WideString dispid 23;
    property ServiceAccountName: WideString dispid 24;
    property ServiceAccountPath: WideString dispid 25;
    property Dependencies: OleVariant dispid 26;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsServiceOperations
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {5D7B33F0-31CA-11CF-A98A-00AA006BC149}
// *********************************************************************//
  IADsServiceOperations = interface(IADs)
    ['{5D7B33F0-31CA-11CF-A98A-00AA006BC149}']
    function Get_Status: Integer; safecall;
    procedure Start; safecall;
    procedure Stop; safecall;
    procedure Pause; safecall;
    procedure Continue; safecall;
    procedure SetPassword(const bstrNewPassword: WideString); safecall;
    property Status: Integer read Get_Status;
  end;

// *********************************************************************//
// DispIntf:  IADsServiceOperationsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {5D7B33F0-31CA-11CF-A98A-00AA006BC149}
// *********************************************************************//
  IADsServiceOperationsDisp = dispinterface
    ['{5D7B33F0-31CA-11CF-A98A-00AA006BC149}']
    property Status: Integer readonly dispid 27;
    procedure Start; dispid 28;
    procedure Stop; dispid 29;
    procedure Pause; dispid 30;
    procedure Continue; dispid 31;
    procedure SetPassword(const bstrNewPassword: WideString); dispid 32;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsFileService
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A89D1900-31CA-11CF-A98A-00AA006BC149}
// *********************************************************************//
  IADsFileService = interface(IADsService)
    ['{A89D1900-31CA-11CF-A98A-00AA006BC149}']
    function Get_Description: WideString; safecall;
    procedure Set_Description(const retval: WideString); safecall;
    function Get_MaxUserCount: Integer; safecall;
    procedure Set_MaxUserCount(retval: Integer); safecall;
    property Description: WideString read Get_Description write Set_Description;
    property MaxUserCount: Integer read Get_MaxUserCount write Set_MaxUserCount;
  end;

// *********************************************************************//
// DispIntf:  IADsFileServiceDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A89D1900-31CA-11CF-A98A-00AA006BC149}
// *********************************************************************//
  IADsFileServiceDisp = dispinterface
    ['{A89D1900-31CA-11CF-A98A-00AA006BC149}']
    property Description: WideString dispid 33;
    property MaxUserCount: Integer dispid 34;
    property HostComputer: WideString dispid 15;
    property DisplayName: WideString dispid 16;
    property Version: WideString dispid 17;
    property ServiceType: Integer dispid 18;
    property StartType: Integer dispid 19;
    property Path: WideString dispid 20;
    property StartupParameters: WideString dispid 21;
    property ErrorControl: Integer dispid 22;
    property LoadOrderGroup: WideString dispid 23;
    property ServiceAccountName: WideString dispid 24;
    property ServiceAccountPath: WideString dispid 25;
    property Dependencies: OleVariant dispid 26;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsFileServiceOperations
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A02DED10-31CA-11CF-A98A-00AA006BC149}
// *********************************************************************//
  IADsFileServiceOperations = interface(IADsServiceOperations)
    ['{A02DED10-31CA-11CF-A98A-00AA006BC149}']
    function Sessions: IADsCollection; safecall;
    function Resources: IADsCollection; safecall;
  end;

// *********************************************************************//
// DispIntf:  IADsFileServiceOperationsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A02DED10-31CA-11CF-A98A-00AA006BC149}
// *********************************************************************//
  IADsFileServiceOperationsDisp = dispinterface
    ['{A02DED10-31CA-11CF-A98A-00AA006BC149}']
    function Sessions: IADsCollection; dispid 35;
    function Resources: IADsCollection; dispid 36;
    property Status: Integer readonly dispid 27;
    procedure Start; dispid 28;
    procedure Stop; dispid 29;
    procedure Pause; dispid 30;
    procedure Continue; dispid 31;
    procedure SetPassword(const bstrNewPassword: WideString); dispid 32;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsFileShare
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {EB6DCAF0-4B83-11CF-A995-00AA006BC149}
// *********************************************************************//
  IADsFileShare = interface(IADs)
    ['{EB6DCAF0-4B83-11CF-A995-00AA006BC149}']
    function Get_CurrentUserCount: Integer; safecall;
    function Get_Description: WideString; safecall;
    procedure Set_Description(const retval: WideString); safecall;
    function Get_HostComputer: WideString; safecall;
    procedure Set_HostComputer(const retval: WideString); safecall;
    function Get_Path: WideString; safecall;
    procedure Set_Path(const retval: WideString); safecall;
    function Get_MaxUserCount: Integer; safecall;
    procedure Set_MaxUserCount(retval: Integer); safecall;
    property CurrentUserCount: Integer read Get_CurrentUserCount;
    property Description: WideString read Get_Description write Set_Description;
    property HostComputer: WideString read Get_HostComputer write Set_HostComputer;
    property Path: WideString read Get_Path write Set_Path;
    property MaxUserCount: Integer read Get_MaxUserCount write Set_MaxUserCount;
  end;

// *********************************************************************//
// DispIntf:  IADsFileShareDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {EB6DCAF0-4B83-11CF-A995-00AA006BC149}
// *********************************************************************//
  IADsFileShareDisp = dispinterface
    ['{EB6DCAF0-4B83-11CF-A995-00AA006BC149}']
    property CurrentUserCount: Integer readonly dispid 15;
    property Description: WideString dispid 16;
    property HostComputer: WideString dispid 17;
    property Path: WideString dispid 18;
    property MaxUserCount: Integer dispid 19;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsSession
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {398B7DA0-4AAB-11CF-AE2C-00AA006EBFB9}
// *********************************************************************//
  IADsSession = interface(IADs)
    ['{398B7DA0-4AAB-11CF-AE2C-00AA006EBFB9}']
    function Get_User: WideString; safecall;
    function Get_UserPath: WideString; safecall;
    function Get_Computer: WideString; safecall;
    function Get_ComputerPath: WideString; safecall;
    function Get_ConnectTime: Integer; safecall;
    function Get_IdleTime: Integer; safecall;
    property User: WideString read Get_User;
    property UserPath: WideString read Get_UserPath;
    property Computer: WideString read Get_Computer;
    property ComputerPath: WideString read Get_ComputerPath;
    property ConnectTime: Integer read Get_ConnectTime;
    property IdleTime: Integer read Get_IdleTime;
  end;

// *********************************************************************//
// DispIntf:  IADsSessionDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {398B7DA0-4AAB-11CF-AE2C-00AA006EBFB9}
// *********************************************************************//
  IADsSessionDisp = dispinterface
    ['{398B7DA0-4AAB-11CF-AE2C-00AA006EBFB9}']
    property User: WideString readonly dispid 15;
    property UserPath: WideString readonly dispid 16;
    property Computer: WideString readonly dispid 17;
    property ComputerPath: WideString readonly dispid 18;
    property ConnectTime: Integer readonly dispid 19;
    property IdleTime: Integer readonly dispid 20;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsResource
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {34A05B20-4AAB-11CF-AE2C-00AA006EBFB9}
// *********************************************************************//
  IADsResource = interface(IADs)
    ['{34A05B20-4AAB-11CF-AE2C-00AA006EBFB9}']
    function Get_User: WideString; safecall;
    function Get_UserPath: WideString; safecall;
    function Get_Path: WideString; safecall;
    function Get_LockCount: Integer; safecall;
    property User: WideString read Get_User;
    property UserPath: WideString read Get_UserPath;
    property Path: WideString read Get_Path;
    property LockCount: Integer read Get_LockCount;
  end;

// *********************************************************************//
// DispIntf:  IADsResourceDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {34A05B20-4AAB-11CF-AE2C-00AA006EBFB9}
// *********************************************************************//
  IADsResourceDisp = dispinterface
    ['{34A05B20-4AAB-11CF-AE2C-00AA006EBFB9}']
    property User: WideString readonly dispid 15;
    property UserPath: WideString readonly dispid 16;
    property Path: WideString readonly dispid 17;
    property LockCount: Integer readonly dispid 18;
    property Name: WideString readonly dispid 2;
    property Class_: WideString readonly dispid 3;
    property GUID: WideString readonly dispid 4;
    property ADsPath: WideString readonly dispid 5;
    property Parent: WideString readonly dispid 6;
    property Schema: WideString readonly dispid 7;
    procedure GetInfo; dispid 8;
    procedure SetInfo; dispid 9;
    function Get(const bstrName: WideString): OleVariant; dispid 10;
    procedure Put(const bstrName: WideString; vProp: OleVariant); dispid 11;
    function GetEx(const bstrName: WideString): OleVariant; dispid 12;
    procedure PutEx(lnControlCode: Integer; const bstrName: WideString; vProp: OleVariant); dispid 13;
    procedure GetInfoEx(vProperties: OleVariant; lnReserved: Integer); dispid 14;
  end;

// *********************************************************************//
// Interface: IADsOpenDSObject
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {DDF2891E-0F9C-11D0-8AD4-00C04FD8D503}
// *********************************************************************//
  IADsOpenDSObject = interface(IDispatch)
    ['{DDF2891E-0F9C-11D0-8AD4-00C04FD8D503}']
    function OpenDSObject(const lpszDNName: WideString; const lpszUserName: WideString;
                          const lpszPassword: WideString; lnReserved: Integer): IDispatch; safecall;
  end;

// *********************************************************************//
// DispIntf:  IADsOpenDSObjectDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {DDF2891E-0F9C-11D0-8AD4-00C04FD8D503}
// *********************************************************************//
  IADsOpenDSObjectDisp = dispinterface
    ['{DDF2891E-0F9C-11D0-8AD4-00C04FD8D503}']
    function OpenDSObject(const lpszDNName: WideString; const lpszUserName: WideString;
                          const lpszPassword: WideString; lnReserved: Integer): IDispatch; dispid 1;
  end;

// *********************************************************************//
// Interface: IDirectoryObject
// Flags:     (0)
// GUID:      {E798DE2C-22E4-11D0-84FE-00C04FD8D503}
// *********************************************************************//
  IDirectoryObject = interface(IUnknown)
    ['{E798DE2C-22E4-11D0-84FE-00C04FD8D503}']
    function GetObjectInformation(var ppObjInfo: PADS_OBJECT_INFO): HResult; stdcall;
    function GetObjectAttributes(pAttributeNames: PPWideChar; dwNumberAttributes: LongWord;
                                 out ppAttributeEntries: PADS_ATTR_INFO;
                                 out pdwNumAttributesReturned: LongWord): HResult; stdcall;
    function SetObjectAttributes(pAttributeEntries: PADS_ATTR_INFO; dwNumAttributes: LongWord;
                                 out pdwNumAttributesModified: DWORD): HResult; stdcall;
    function CreateDSObject(pszRDNName: PWideChar; pAttributeEntries: PADS_ATTR_INFO;
                            dwNumAttributes: LongWord; out ppObject: IDispatch): HResult; stdcall;
    function DeleteDSObject(pszRDNName: PWideChar): HResult; stdcall;
  end;

// *********************************************************************//
// Interface: IDirectorySearch
// Flags:     (0)
// GUID:      {109BA8EC-92F0-11D0-A790-00C04FD8D5A8}
// *********************************************************************//
  IDirectorySearch = interface(IUnknown)
    ['{109BA8EC-92F0-11D0-A790-00C04FD8D5A8}']
    function  SetSearchPreference(pSearchPrefs: PADS_SEARCHPREF_INFO; dwNumPrefs: LongWord): HResult; stdcall;
    function  ExecuteSearch(pszSearchFilter: PWideChar; pAttributeNames: PWideChar;
                            dwNumberAttributes: LongWord; var phSearchResult: ADS_SEARCH_HANDLE): HResult; stdcall;
    function  AbandonSearch(phSearchResult: ADS_SEARCH_HANDLE): HResult; stdcall;
    function  GetFirstRow(hSearchResult: ADS_SEARCH_HANDLE): HResult; stdcall;
    function  GetNextRow(hSearchResult: ADS_SEARCH_HANDLE): HResult; stdcall;
    function  GetPreviousRow(hSearchResult: ADS_SEARCH_HANDLE): HResult; stdcall;
    function  GetNextColumnName(hSearchHandle: ADS_SEARCH_HANDLE; out ppszColumnName: PWideChar): HResult; stdcall;
    function  GetColumn(hSearchResult: ADS_SEARCH_HANDLE; szColumnName: PWideChar;
                        var pSearchColumn: ADS_SEARCH_COLUMN): HResult; stdcall;
    function  FreeColumn(pSearchColumn: PADS_SEARCH_COLUMN): HResult; stdcall;
    function  CloseSearchHandle(hSearchResult: ADS_SEARCH_HANDLE): HResult; stdcall;
  end;

// *********************************************************************//
// Interface: IDirectorySchemaMgmt
// Flags:     (0)
// GUID:      {75DB3B9C-A4D8-11D0-A79C-00C04FD8D5A8}
// *********************************************************************//
  IDirectorySchemaMgmt = interface(IUnknown)
    ['{75DB3B9C-A4D8-11D0-A79C-00C04FD8D5A8}']
    function EnumAttributes(var ppszAttrNames: PWideChar; dwNumAttributes: LongWord;
                            ppAttrDefinition: Pointer; var pdwNumAttributes: LongWord): HResult; stdcall;
    function CreateAttributeDefinition(pszAttributeName: PWideChar;
                                       var pAttributeDefinition: ADS_ATTR_DEF): HResult; stdcall;
    function WriteAttributeDefinition(pszAttributeName: PWideChar;
                                      var pAttributeDefinition: ADS_ATTR_DEF): HResult; stdcall;
    function DeleteAttributeDefinition(pszAttributeName: PWideChar): HResult; stdcall;
    function EnumClasses(var ppszClassNames: PWideChar; dwNumClasses: LongWord;
                         ppClassDefinition: Pointer; var pdwNumClasses: LongWord): HResult; stdcall;
    function WriteClassDefinition(pszClassName: PWideChar; var pClassDefinition: ADS_CLASS_DEF): HResult; stdcall;
    function CreateClassDefinition(pszClassName: PWideChar; var pClassDefinition: ADS_CLASS_DEF): HResult; stdcall;
    function DeleteClassDefinition(pszClassName: PWideChar): HResult; stdcall;
  end;

// *********************************************************************//
// Interface: IADsAggregatee
// Flags:     (0)
// GUID:      {1346CE8C-9039-11D0-8528-00C04FD8D503}
// *********************************************************************//
  IADsAggregatee = interface(IUnknown)
    ['{1346CE8C-9039-11D0-8528-00C04FD8D503}']
    function ConnectAsAggregatee(const pOuterUnknown: IUnknown): HResult; stdcall;
    function DisconnectAsAggregatee: HResult; stdcall;
    function RelinquishInterface(var riid: TGUID): HResult; stdcall;
    function RestoreInterface(var riid: TGUID): HResult; stdcall;
  end;

// *********************************************************************//
// Interface: IADsAggregator
// Flags:     (0)
// GUID:      {52DB5FB0-941F-11D0-8529-00C04FD8D503}
// *********************************************************************//
  IADsAggregator = interface(IUnknown)
    ['{52DB5FB0-941F-11D0-8529-00C04FD8D503}']
    function ConnectAsAggregator(const pAggregatee: IUnknown): HResult; stdcall;
    function DisconnectAsAggregator: HResult; stdcall;
  end;

// *********************************************************************//
// Interface: IADsAccessControlEntry
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B4F3A14C-9BDD-11D0-852C-00C04FD8D503}
// *********************************************************************//
  IADsAccessControlEntry = interface(IDispatch)
    ['{B4F3A14C-9BDD-11D0-852C-00C04FD8D503}']
    function Get_AccessMask: Integer; safecall;
    procedure Set_AccessMask(retval: Integer); safecall;
    function Get_AceType: Integer; safecall;
    procedure Set_AceType(retval: Integer); safecall;
    function Get_AceFlags: Integer; safecall;
    procedure Set_AceFlags(retval: Integer); safecall;
    function Get_Flags: Integer; safecall;
    procedure Set_Flags(retval: Integer); safecall;
    function Get_ObjectType: WideString; safecall;
    procedure Set_ObjectType(const retval: WideString); safecall;
    function Get_InheritedObjectType: WideString; safecall;
    procedure Set_InheritedObjectType(const retval: WideString); safecall;
    function Get_Trustee: WideString; safecall;
    procedure Set_Trustee(const retval: WideString); safecall;
    property AccessMask: Integer read Get_AccessMask write Set_AccessMask;
    property AceType: Integer read Get_AceType write Set_AceType;
    property AceFlags: Integer read Get_AceFlags write Set_AceFlags;
    property Flags: Integer read Get_Flags write Set_Flags;
    property ObjectType: WideString read Get_ObjectType write Set_ObjectType;
    property InheritedObjectType: WideString read Get_InheritedObjectType write Set_InheritedObjectType;
    property Trustee: WideString read Get_Trustee write Set_Trustee;
  end;

// *********************************************************************//
// DispIntf:  IADsAccessControlEntryDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B4F3A14C-9BDD-11D0-852C-00C04FD8D503}
// *********************************************************************//
  IADsAccessControlEntryDisp = dispinterface
    ['{B4F3A14C-9BDD-11D0-852C-00C04FD8D503}']
    property AccessMask: Integer dispid 2;
    property AceType: Integer dispid 3;
    property AceFlags: Integer dispid 4;
    property Flags: Integer dispid 5;
    property ObjectType: WideString dispid 6;
    property InheritedObjectType: WideString dispid 7;
    property Trustee: WideString dispid 8;
  end;

// *********************************************************************//
// Interface: IADsAccessControlList
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B7EE91CC-9BDD-11D0-852C-00C04FD8D503}
// *********************************************************************//
  IADsAccessControlList = interface(IDispatch)
    ['{B7EE91CC-9BDD-11D0-852C-00C04FD8D503}']
    function Get_AclRevision: Integer; safecall;
    procedure Set_AclRevision(retval: Integer); safecall;
    function Get_AceCount: Integer; safecall;
    procedure Set_AceCount(retval: Integer); safecall;
    procedure AddAce(const pAccessControlEntry: IDispatch); safecall;
    procedure RemoveAce(const pAccessControlEntry: IDispatch); safecall;
    function CopyAccessList: IDispatch; safecall;
    function Get__NewEnum: IUnknown; safecall;
    property AclRevision: Integer read Get_AclRevision write Set_AclRevision;
    property AceCount: Integer read Get_AceCount write Set_AceCount;
    property _NewEnum: IUnknown read Get__NewEnum;
  end;

// *********************************************************************//
// DispIntf:  IADsAccessControlListDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B7EE91CC-9BDD-11D0-852C-00C04FD8D503}
// *********************************************************************//
  IADsAccessControlListDisp = dispinterface
    ['{B7EE91CC-9BDD-11D0-852C-00C04FD8D503}']
    property AclRevision: Integer dispid 3;
    property AceCount: Integer dispid 4;
    procedure AddAce(const pAccessControlEntry: IDispatch); dispid 5;
    procedure RemoveAce(const pAccessControlEntry: IDispatch); dispid 6;
    function CopyAccessList: IDispatch; dispid 7;
    property _NewEnum: IUnknown readonly dispid -4;
  end;

// *********************************************************************//
// Interface: IADsSecurityDescriptor
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B8C787CA-9BDD-11D0-852C-00C04FD8D503}
// *********************************************************************//
  IADsSecurityDescriptor = interface(IDispatch)
    ['{B8C787CA-9BDD-11D0-852C-00C04FD8D503}']
    function Get_Revision: Integer; safecall;
    procedure Set_Revision(retval: Integer); safecall;
    function Get_Control: Integer; safecall;
    procedure Set_Control(retval: Integer); safecall;
    function Get_Owner: WideString; safecall;
    procedure Set_Owner(const retval: WideString); safecall;
    function Get_OwnerDefaulted: WordBool; safecall;
    procedure Set_OwnerDefaulted(retval: WordBool); safecall;
    function Get_Group: WideString; safecall;
    procedure Set_Group(const retval: WideString); safecall;
    function Get_GroupDefaulted: WordBool; safecall;
    procedure Set_GroupDefaulted(retval: WordBool); safecall;
    function Get_DiscretionaryAcl: IDispatch; safecall;
    procedure Set_DiscretionaryAcl(const retval: IDispatch); safecall;
    function Get_DaclDefaulted: WordBool; safecall;
    procedure Set_DaclDefaulted(retval: WordBool); safecall;
    function Get_SystemAcl: IDispatch; safecall;
    procedure Set_SystemAcl(const retval: IDispatch); safecall;
    function Get_SaclDefaulted: WordBool; safecall;
    procedure Set_SaclDefaulted(retval: WordBool); safecall;
    function CopySecurityDescriptor: IDispatch; safecall;
    property Revision: Integer read Get_Revision write Set_Revision;
    property Control: Integer read Get_Control write Set_Control;
    property Owner: WideString read Get_Owner write Set_Owner;
    property OwnerDefaulted: WordBool read Get_OwnerDefaulted write Set_OwnerDefaulted;
    property Group: WideString read Get_Group write Set_Group;
    property GroupDefaulted: WordBool read Get_GroupDefaulted write Set_GroupDefaulted;
    property DiscretionaryAcl: IDispatch read Get_DiscretionaryAcl write Set_DiscretionaryAcl;
    property DaclDefaulted: WordBool read Get_DaclDefaulted write Set_DaclDefaulted;
    property SystemAcl: IDispatch read Get_SystemAcl write Set_SystemAcl;
    property SaclDefaulted: WordBool read Get_SaclDefaulted write Set_SaclDefaulted;
  end;

// *********************************************************************//
// DispIntf:  IADsSecurityDescriptorDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B8C787CA-9BDD-11D0-852C-00C04FD8D503}
// *********************************************************************//
  IADsSecurityDescriptorDisp = dispinterface
    ['{B8C787CA-9BDD-11D0-852C-00C04FD8D503}']
    property Revision: Integer dispid 2;
    property Control: Integer dispid 3;
    property Owner: WideString dispid 4;
    property OwnerDefaulted: WordBool dispid 5;
    property Group: WideString dispid 6;
    property GroupDefaulted: WordBool dispid 7;
    property DiscretionaryAcl: IDispatch dispid 8;
    property DaclDefaulted: WordBool dispid 9;
    property SystemAcl: IDispatch dispid 10;
    property SaclDefaulted: WordBool dispid 11;
    function CopySecurityDescriptor: IDispatch; dispid 12;
  end;

// *********************************************************************//
// Interface: IADsLargeInteger
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {9068270B-0939-11D1-8BE1-00C04FD8D503}
// *********************************************************************//
  IADsLargeInteger = interface(IDispatch)
    ['{9068270B-0939-11D1-8BE1-00C04FD8D503}']
    function Get_HighPart: Integer; safecall;
    procedure Set_HighPart(retval: Integer); safecall;
    function Get_LowPart: Integer; safecall;
    procedure Set_LowPart(retval: Integer); safecall;
    property HighPart: Integer read Get_HighPart write Set_HighPart;
    property LowPart: Integer read Get_LowPart write Set_LowPart;
  end;

// *********************************************************************//
// DispIntf:  IADsLargeIntegerDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {9068270B-0939-11D1-8BE1-00C04FD8D503}
// *********************************************************************//
  IADsLargeIntegerDisp = dispinterface
    ['{9068270B-0939-11D1-8BE1-00C04FD8D503}']
    property HighPart: Integer dispid 2;
    property LowPart: Integer dispid 3;
  end;

// *********************************************************************//
// Interface: IADsNameTranslate
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B1B272A3-3625-11D1-A3A4-00C04FB950DC}
// *********************************************************************//
  IADsNameTranslate = interface(IDispatch)
    ['{B1B272A3-3625-11D1-A3A4-00C04FB950DC}']
    procedure Set_ChaseReferral(Param1: Integer); safecall;
    procedure Init(lnSetType: Integer; const bstrADsPath: WideString); safecall;
    procedure InitEx(lnSetType: Integer; const bstrADsPath: WideString;
                     const bstrUserID: WideString; const bstrDomain: WideString;
                     const bstrPassword: WideString); safecall;
    procedure Set_(lnSetType: Integer; const bstrADsPath: WideString); safecall;
    function Get(lnFormatType: Integer): WideString; safecall;
    procedure SetEx(lnFormatType: Integer; pVar: OleVariant); safecall;
    function GetEx(lnFormatType: Integer): OleVariant; safecall;
    property ChaseReferral: Integer write Set_ChaseReferral;
  end;

// *********************************************************************//
// DispIntf:  IADsNameTranslateDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B1B272A3-3625-11D1-A3A4-00C04FB950DC}
// *********************************************************************//
  IADsNameTranslateDisp = dispinterface
    ['{B1B272A3-3625-11D1-A3A4-00C04FB950DC}']
    property ChaseReferral: Integer writeonly dispid 1;
    procedure Init(lnSetType: Integer; const bstrADsPath: WideString); dispid 2;
    procedure InitEx(lnSetType: Integer; const bstrADsPath: WideString;
                     const bstrUserID: WideString; const bstrDomain: WideString;
                     const bstrPassword: WideString); dispid 3;
    procedure Set_(lnSetType: Integer; const bstrADsPath: WideString); dispid 4;
    function Get(lnFormatType: Integer): WideString; dispid 5;
    procedure SetEx(lnFormatType: Integer; pVar: OleVariant); dispid 6;
    function GetEx(lnFormatType: Integer): OleVariant; dispid 7;
  end;

// *********************************************************************//
// Interface: IADsCaseIgnoreList
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {7B66B533-4680-11D1-A3B4-00C04FB950DC}
// *********************************************************************//
  IADsCaseIgnoreList = interface(IDispatch)
    ['{7B66B533-4680-11D1-A3B4-00C04FB950DC}']
    function Get_CaseIgnoreList: OleVariant; safecall;
    procedure Set_CaseIgnoreList(retval: OleVariant); safecall;
    property CaseIgnoreList: OleVariant read Get_CaseIgnoreList write Set_CaseIgnoreList;
  end;

// *********************************************************************//
// DispIntf:  IADsCaseIgnoreListDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {7B66B533-4680-11D1-A3B4-00C04FB950DC}
// *********************************************************************//
  IADsCaseIgnoreListDisp = dispinterface
    ['{7B66B533-4680-11D1-A3B4-00C04FB950DC}']
    property CaseIgnoreList: OleVariant dispid 2;
  end;

// *********************************************************************//
// Interface: IADsFaxNumber
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A910DEA9-4680-11D1-A3B4-00C04FB950DC}
// *********************************************************************//
  IADsFaxNumber = interface(IDispatch)
    ['{A910DEA9-4680-11D1-A3B4-00C04FB950DC}']
    function Get_TelephoneNumber: WideString; safecall;
    procedure Set_TelephoneNumber(const retval: WideString); safecall;
    function Get_Parameters: OleVariant; safecall;
    procedure Set_Parameters(retval: OleVariant); safecall;
    property TelephoneNumber: WideString read Get_TelephoneNumber write Set_TelephoneNumber;
    property Parameters: OleVariant read Get_Parameters write Set_Parameters;
  end;

// *********************************************************************//
// DispIntf:  IADsFaxNumberDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A910DEA9-4680-11D1-A3B4-00C04FB950DC}
// *********************************************************************//
  IADsFaxNumberDisp = dispinterface
    ['{A910DEA9-4680-11D1-A3B4-00C04FB950DC}']
    property TelephoneNumber: WideString dispid 2;
    property Parameters: OleVariant dispid 3;
  end;

// *********************************************************************//
// Interface: IADsNetAddress
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B21A50A9-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsNetAddress = interface(IDispatch)
    ['{B21A50A9-4080-11D1-A3AC-00C04FB950DC}']
    function Get_AddressType: Integer; safecall;
    procedure Set_AddressType(retval: Integer); safecall;
    function Get_Address: OleVariant; safecall;
    procedure Set_Address(retval: OleVariant); safecall;
    property AddressType: Integer read Get_AddressType write Set_AddressType;
    property Address: OleVariant read Get_Address write Set_Address;
  end;

// *********************************************************************//
// DispIntf:  IADsNetAddressDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B21A50A9-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsNetAddressDisp = dispinterface
    ['{B21A50A9-4080-11D1-A3AC-00C04FB950DC}']
    property AddressType: Integer dispid 2;
    property Address: OleVariant dispid 3;
  end;

// *********************************************************************//
// Interface: IADsOctetList
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {7B28B80F-4680-11D1-A3B4-00C04FB950DC}
// *********************************************************************//
  IADsOctetList = interface(IDispatch)
    ['{7B28B80F-4680-11D1-A3B4-00C04FB950DC}']
    function Get_OctetList: OleVariant; safecall;
    procedure Set_OctetList(retval: OleVariant); safecall;
    property OctetList: OleVariant read Get_OctetList write Set_OctetList;
  end;

// *********************************************************************//
// DispIntf:  IADsOctetListDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {7B28B80F-4680-11D1-A3B4-00C04FB950DC}
// *********************************************************************//
  IADsOctetListDisp = dispinterface
    ['{7B28B80F-4680-11D1-A3B4-00C04FB950DC}']
    property OctetList: OleVariant dispid 2;
  end;

// *********************************************************************//
// Interface: IADsEmail
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {97AF011A-478E-11D1-A3B4-00C04FB950DC}
// *********************************************************************//
  IADsEmail = interface(IDispatch)
    ['{97AF011A-478E-11D1-A3B4-00C04FB950DC}']
    function Get_type_: Integer; safecall;
    procedure Set_type_(retval: Integer); safecall;
    function Get_Address: WideString; safecall;
    procedure Set_Address(const retval: WideString); safecall;
    property type_: Integer read Get_type_ write Set_type_;
    property Address: WideString read Get_Address write Set_Address;
  end;

// *********************************************************************//
// DispIntf:  IADsEmailDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {97AF011A-478E-11D1-A3B4-00C04FB950DC}
// *********************************************************************//
  IADsEmailDisp = dispinterface
    ['{97AF011A-478E-11D1-A3B4-00C04FB950DC}']
    property type_: Integer dispid 2;
    property Address: WideString dispid 3;
  end;

// *********************************************************************//
// Interface: IADsPath
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B287FCD5-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsPath = interface(IDispatch)
    ['{B287FCD5-4080-11D1-A3AC-00C04FB950DC}']
    function Get_type_: Integer; safecall;
    procedure Set_type_(retval: Integer); safecall;
    function Get_VolumeName: WideString; safecall;
    procedure Set_VolumeName(const retval: WideString); safecall;
    function Get_Path: WideString; safecall;
    procedure Set_Path(const retval: WideString); safecall;
    property type_: Integer read Get_type_ write Set_type_;
    property VolumeName: WideString read Get_VolumeName write Set_VolumeName;
    property Path: WideString read Get_Path write Set_Path;
  end;

// *********************************************************************//
// DispIntf:  IADsPathDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B287FCD5-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsPathDisp = dispinterface
    ['{B287FCD5-4080-11D1-A3AC-00C04FB950DC}']
    property type_: Integer dispid 2;
    property VolumeName: WideString dispid 3;
    property Path: WideString dispid 4;
  end;

// *********************************************************************//
// Interface: IADsReplicaPointer
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {F60FB803-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsReplicaPointer = interface(IDispatch)
    ['{F60FB803-4080-11D1-A3AC-00C04FB950DC}']
    function Get_ServerName: WideString; safecall;
    procedure Set_ServerName(const retval: WideString); safecall;
    function Get_ReplicaType: Integer; safecall;
    procedure Set_ReplicaType(retval: Integer); safecall;
    function Get_ReplicaNumber: Integer; safecall;
    procedure Set_ReplicaNumber(retval: Integer); safecall;
    function Get_Count: Integer; safecall;
    procedure Set_Count(retval: Integer); safecall;
    function Get_ReplicaAddressHints: OleVariant; safecall;
    procedure Set_ReplicaAddressHints(retval: OleVariant); safecall;
    property ServerName: WideString read Get_ServerName write Set_ServerName;
    property ReplicaType: Integer read Get_ReplicaType write Set_ReplicaType;
    property ReplicaNumber: Integer read Get_ReplicaNumber write Set_ReplicaNumber;
    property Count: Integer read Get_Count write Set_Count;
    property ReplicaAddressHints: OleVariant read Get_ReplicaAddressHints write Set_ReplicaAddressHints;
  end;

// *********************************************************************//
// DispIntf:  IADsReplicaPointerDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {F60FB803-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsReplicaPointerDisp = dispinterface
    ['{F60FB803-4080-11D1-A3AC-00C04FB950DC}']
    property ServerName: WideString dispid 2;
    property ReplicaType: Integer dispid 3;
    property ReplicaNumber: Integer dispid 4;
    property Count: Integer dispid 5;
    property ReplicaAddressHints: OleVariant dispid 6;
  end;

// *********************************************************************//
// Interface: IADsAcl
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {8452D3AB-0869-11D1-A377-00C04FB950DC}
// *********************************************************************//
  IADsAcl = interface(IDispatch)
    ['{8452D3AB-0869-11D1-A377-00C04FB950DC}']
    function Get_ProtectedAttrName: WideString; safecall;
    procedure Set_ProtectedAttrName(const retval: WideString); safecall;
    function Get_SubjectName: WideString; safecall;
    procedure Set_SubjectName(const retval: WideString); safecall;
    function Get_Privileges: Integer; safecall;
    procedure Set_Privileges(retval: Integer); safecall;
    function CopyAcl: IDispatch; safecall;
    property ProtectedAttrName: WideString read Get_ProtectedAttrName write Set_ProtectedAttrName;
    property SubjectName: WideString read Get_SubjectName write Set_SubjectName;
    property Privileges: Integer read Get_Privileges write Set_Privileges;
  end;

// *********************************************************************//
// DispIntf:  IADsAclDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {8452D3AB-0869-11D1-A377-00C04FB950DC}
// *********************************************************************//
  IADsAclDisp = dispinterface
    ['{8452D3AB-0869-11D1-A377-00C04FB950DC}']
    property ProtectedAttrName: WideString dispid 2;
    property SubjectName: WideString dispid 3;
    property Privileges: Integer dispid 4;
    function CopyAcl: IDispatch; dispid 5;
  end;

// *********************************************************************//
// Interface: IADsTimestamp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B2F5A901-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsTimestamp = interface(IDispatch)
    ['{B2F5A901-4080-11D1-A3AC-00C04FB950DC}']
    function Get_WholeSeconds: Integer; safecall;
    procedure Set_WholeSeconds(retval: Integer); safecall;
    function Get_EventID: Integer; safecall;
    procedure Set_EventID(retval: Integer); safecall;
    property WholeSeconds: Integer read Get_WholeSeconds write Set_WholeSeconds;
    property EventID: Integer read Get_EventID write Set_EventID;
  end;

// *********************************************************************//
// DispIntf:  IADsTimestampDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B2F5A901-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsTimestampDisp = dispinterface
    ['{B2F5A901-4080-11D1-A3AC-00C04FB950DC}']
    property WholeSeconds: Integer dispid 2;
    property EventID: Integer dispid 3;
  end;

// *********************************************************************//
// Interface: IADsPostalAddress
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {7ADECF29-4680-11D1-A3B4-00C04FB950DC}
// *********************************************************************//
  IADsPostalAddress = interface(IDispatch)
    ['{7ADECF29-4680-11D1-A3B4-00C04FB950DC}']
    function Get_PostalAddress: OleVariant; safecall;
    procedure Set_PostalAddress(retval: OleVariant); safecall;
    property PostalAddress: OleVariant read Get_PostalAddress write Set_PostalAddress;
  end;

// *********************************************************************//
// DispIntf:  IADsPostalAddressDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {7ADECF29-4680-11D1-A3B4-00C04FB950DC}
// *********************************************************************//
  IADsPostalAddressDisp = dispinterface
    ['{7ADECF29-4680-11D1-A3B4-00C04FB950DC}']
    property PostalAddress: OleVariant dispid 2;
  end;

// *********************************************************************//
// Interface: IADsBackLink
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {FD1302BD-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsBackLink = interface(IDispatch)
    ['{FD1302BD-4080-11D1-A3AC-00C04FB950DC}']
    function Get_RemoteID: Integer; safecall;
    procedure Set_RemoteID(retval: Integer); safecall;
    function Get_ObjectName: WideString; safecall;
    procedure Set_ObjectName(const retval: WideString); safecall;
    property RemoteID: Integer read Get_RemoteID write Set_RemoteID;
    property ObjectName: WideString read Get_ObjectName write Set_ObjectName;
  end;

// *********************************************************************//
// DispIntf:  IADsBackLinkDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {FD1302BD-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsBackLinkDisp = dispinterface
    ['{FD1302BD-4080-11D1-A3AC-00C04FB950DC}']
    property RemoteID: Integer dispid 2;
    property ObjectName: WideString dispid 3;
  end;

// *********************************************************************//
// Interface: IADsTypedName
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B371A349-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsTypedName = interface(IDispatch)
    ['{B371A349-4080-11D1-A3AC-00C04FB950DC}']
    function Get_ObjectName: WideString; safecall;
    procedure Set_ObjectName(const retval: WideString); safecall;
    function Get_Level: Integer; safecall;
    procedure Set_Level(retval: Integer); safecall;
    function Get_Interval: Integer; safecall;
    procedure Set_Interval(retval: Integer); safecall;
    property ObjectName: WideString read Get_ObjectName write Set_ObjectName;
    property Level: Integer read Get_Level write Set_Level;
    property Interval: Integer read Get_Interval write Set_Interval;
  end;

// *********************************************************************//
// DispIntf:  IADsTypedNameDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B371A349-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsTypedNameDisp = dispinterface
    ['{B371A349-4080-11D1-A3AC-00C04FB950DC}']
    property ObjectName: WideString dispid 2;
    property Level: Integer dispid 3;
    property Interval: Integer dispid 4;
  end;

// *********************************************************************//
// Interface: IADsHold
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B3EB3B37-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsHold = interface(IDispatch)
    ['{B3EB3B37-4080-11D1-A3AC-00C04FB950DC}']
    function Get_ObjectName: WideString; safecall;
    procedure Set_ObjectName(const retval: WideString); safecall;
    function Get_Amount: Integer; safecall;
    procedure Set_Amount(retval: Integer); safecall;
    property ObjectName: WideString read Get_ObjectName write Set_ObjectName;
    property Amount: Integer read Get_Amount write Set_Amount;
  end;

// *********************************************************************//
// DispIntf:  IADsHoldDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {B3EB3B37-4080-11D1-A3AC-00C04FB950DC}
// *********************************************************************//
  IADsHoldDisp = dispinterface
    ['{B3EB3B37-4080-11D1-A3AC-00C04FB950DC}']
    property ObjectName: WideString dispid 2;
    property Amount: Integer dispid 3;
  end;

// *********************************************************************//
// Interface: IADsObjectOptions
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {46F14FDA-232B-11D1-A808-00C04FD8D5A8}
// *********************************************************************//
  IADsObjectOptions = interface(IDispatch)
    ['{46F14FDA-232B-11D1-A808-00C04FD8D5A8}']
    function GetOption(lnOption: Integer): OleVariant; safecall;
    procedure SetOption(lnOption: Integer; vValue: OleVariant); safecall;
  end;

// *********************************************************************//
// DispIntf:  IADsObjectOptionsDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {46F14FDA-232B-11D1-A808-00C04FD8D5A8}
// *********************************************************************//
  IADsObjectOptionsDisp = dispinterface
    ['{46F14FDA-232B-11D1-A808-00C04FD8D5A8}']
    function GetOption(lnOption: Integer): OleVariant; dispid 2;
    procedure SetOption(lnOption: Integer; vValue: OleVariant); dispid 3;
  end;

// *********************************************************************//
// Interface: IADsPathname
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {D592AED4-F420-11D0-A36E-00C04FB950DC}
// *********************************************************************//
  IADsPathname = interface(IDispatch)
    ['{D592AED4-F420-11D0-A36E-00C04FB950DC}']
    procedure Set_(const bstrADsPath: WideString; lnSetType: Integer); safecall;
    procedure SetDisplayType(lnDisplayType: Integer); safecall;
    function Retrieve(lnFormatType: Integer): WideString; safecall;
    function GetNumElements: Integer; safecall;
    function GetElement(lnElementIndex: Integer): WideString; safecall;
    procedure AddLeafElement(const bstrLeafElement: WideString); safecall;
    procedure RemoveLeafElement; safecall;
    function CopyPath: IDispatch; safecall;
    function GetEscapedElement(lnReserved: Integer; const bstrInStr: WideString): WideString; safecall;
    function Get_EscapedMode: Integer; safecall;
    procedure Set_EscapedMode(retval: Integer); safecall;
    property EscapedMode: Integer read Get_EscapedMode write Set_EscapedMode;
  end;

// *********************************************************************//
// DispIntf:  IADsPathnameDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {D592AED4-F420-11D0-A36E-00C04FB950DC}
// *********************************************************************//
  IADsPathnameDisp = dispinterface
    ['{D592AED4-F420-11D0-A36E-00C04FB950DC}']
    procedure Set_(const bstrADsPath: WideString; lnSetType: Integer); dispid 2;
    procedure SetDisplayType(lnDisplayType: Integer); dispid 3;
    function Retrieve(lnFormatType: Integer): WideString; dispid 4;
    function GetNumElements: Integer; dispid 5;
    function GetElement(lnElementIndex: Integer): WideString; dispid 6;
    procedure AddLeafElement(const bstrLeafElement: WideString); dispid 7;
    procedure RemoveLeafElement; dispid 8;
    function CopyPath: IDispatch; dispid 9;
    function GetEscapedElement(lnReserved: Integer; const bstrInStr: WideString): WideString; dispid 10;
    property EscapedMode: Integer dispid 11;
  end;

// *********************************************************************//
// Interface: IADsADSystemInfo
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {5BB11929-AFD1-11D2-9CB9-0000F87A369E}
// *********************************************************************//
  IADsADSystemInfo = interface(IDispatch)
    ['{5BB11929-AFD1-11D2-9CB9-0000F87A369E}']
    function Get_UserName: WideString; safecall;
    function Get_ComputerName: WideString; safecall;
    function Get_SiteName: WideString; safecall;
    function Get_DomainShortName: WideString; safecall;
    function Get_DomainDNSName: WideString; safecall;
    function Get_ForestDNSName: WideString; safecall;
    function Get_PDCRoleOwner: WideString; safecall;
    function Get_SchemaRoleOwner: WideString; safecall;
    function Get_IsNativeMode: WordBool; safecall;
    function GetAnyDCName: WideString; safecall;
    function GetDCSiteName(const szServer: WideString): WideString; safecall;
    procedure RefreshSchemaCache; safecall;
    function GetTrees: OleVariant; safecall;
    property UserName: WideString read Get_UserName;
    property ComputerName: WideString read Get_ComputerName;
    property SiteName: WideString read Get_SiteName;
    property DomainShortName: WideString read Get_DomainShortName;
    property DomainDNSName: WideString read Get_DomainDNSName;
    property ForestDNSName: WideString read Get_ForestDNSName;
    property PDCRoleOwner: WideString read Get_PDCRoleOwner;
    property SchemaRoleOwner: WideString read Get_SchemaRoleOwner;
    property IsNativeMode: WordBool read Get_IsNativeMode;
  end;

// *********************************************************************//
// DispIntf:  IADsADSystemInfoDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {5BB11929-AFD1-11D2-9CB9-0000F87A369E}
// *********************************************************************//
  IADsADSystemInfoDisp = dispinterface
    ['{5BB11929-AFD1-11D2-9CB9-0000F87A369E}']
    property UserName: WideString readonly dispid 2;
    property ComputerName: WideString readonly dispid 3;
    property SiteName: WideString readonly dispid 4;
    property DomainShortName: WideString readonly dispid 5;
    property DomainDNSName: WideString readonly dispid 6;
    property ForestDNSName: WideString readonly dispid 7;
    property PDCRoleOwner: WideString readonly dispid 8;
    property SchemaRoleOwner: WideString readonly dispid 9;
    property IsNativeMode: WordBool readonly dispid 10;
    function GetAnyDCName: WideString; dispid 11;
    function GetDCSiteName(const szServer: WideString): WideString; dispid 12;
    procedure RefreshSchemaCache; dispid 13;
    function GetTrees: OleVariant; dispid 14;
  end;

// *********************************************************************//
// Interface: IADsWinNTSystemInfo
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {6C6D65DC-AFD1-11D2-9CB9-0000F87A369E}
// *********************************************************************//
  IADsWinNTSystemInfo = interface(IDispatch)
    ['{6C6D65DC-AFD1-11D2-9CB9-0000F87A369E}']
    function Get_UserName: WideString; safecall;
    function Get_ComputerName: WideString; safecall;
    function Get_DomainName: WideString; safecall;
    function Get_PDC: WideString; safecall;
    property UserName: WideString read Get_UserName;
    property ComputerName: WideString read Get_ComputerName;
    property DomainName: WideString read Get_DomainName;
    property PDC: WideString read Get_PDC;
  end;

// *********************************************************************//
// DispIntf:  IADsWinNTSystemInfoDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {6C6D65DC-AFD1-11D2-9CB9-0000F87A369E}
// *********************************************************************//
  IADsWinNTSystemInfoDisp = dispinterface
    ['{6C6D65DC-AFD1-11D2-9CB9-0000F87A369E}']
    property UserName: WideString readonly dispid 2;
    property ComputerName: WideString readonly dispid 3;
    property DomainName: WideString readonly dispid 4;
    property PDC: WideString readonly dispid 5;
  end;

// *********************************************************************//
// Interface: IADsDNWithBinary
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {7E99C0A2-F935-11D2-BA96-00C04FB6D0D1}
// *********************************************************************//
  IADsDNWithBinary = interface(IDispatch)
    ['{7E99C0A2-F935-11D2-BA96-00C04FB6D0D1}']
    function Get_BinaryValue: OleVariant; safecall;
    procedure Set_BinaryValue(retval: OleVariant); safecall;
    function Get_DNString: WideString; safecall;
    procedure Set_DNString(const retval: WideString); safecall;
    property BinaryValue: OleVariant read Get_BinaryValue write Set_BinaryValue;
    property DNString: WideString read Get_DNString write Set_DNString;
  end;

// *********************************************************************//
// DispIntf:  IADsDNWithBinaryDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {7E99C0A2-F935-11D2-BA96-00C04FB6D0D1}
// *********************************************************************//
  IADsDNWithBinaryDisp = dispinterface
    ['{7E99C0A2-F935-11D2-BA96-00C04FB6D0D1}']
    property BinaryValue: OleVariant dispid 2;
    property DNString: WideString dispid 3;
  end;

// *********************************************************************//
// Interface: IADsDNWithString
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {370DF02E-F934-11D2-BA96-00C04FB6D0D1}
// *********************************************************************//
  IADsDNWithString = interface(IDispatch)
    ['{370DF02E-F934-11D2-BA96-00C04FB6D0D1}']
    function Get_StringValue: WideString; safecall;
    procedure Set_StringValue(const retval: WideString); safecall;
    function Get_DNString: WideString; safecall;
    procedure Set_DNString(const retval: WideString); safecall;
    property StringValue: WideString read Get_StringValue write Set_StringValue;
    property DNString: WideString read Get_DNString write Set_DNString;
  end;

// *********************************************************************//
// DispIntf:  IADsDNWithStringDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {370DF02E-F934-11D2-BA96-00C04FB6D0D1}
// *********************************************************************//
  IADsDNWithStringDisp = dispinterface
    ['{370DF02E-F934-11D2-BA96-00C04FB6D0D1}']
    property StringValue: WideString dispid 2;
    property DNString: WideString dispid 3;
  end;

// *********************************************************************//
// Interface: IADsSecurityUtility
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A63251B2-5F21-474B-AB52-4A8EFAD10895}
// *********************************************************************//
  IADsSecurityUtility = interface(IDispatch)
    ['{A63251B2-5F21-474B-AB52-4A8EFAD10895}']
    function GetSecurityDescriptor(varPath: OleVariant; lPathFormat: Integer; lFormat: Integer): OleVariant; safecall;
    procedure SetSecurityDescriptor(varPath: OleVariant; lPathFormat: Integer; varData: OleVariant;
                                    lDataFormat: Integer); safecall;
    function ConvertSecurityDescriptor(varSD: OleVariant; lDataFormat: Integer; lOutFormat: Integer): OleVariant; safecall;
    function Get_SecurityMask: Integer; safecall;
    procedure Set_SecurityMask(retval: Integer); safecall;
    property SecurityMask: Integer read Get_SecurityMask write Set_SecurityMask;
  end;

// *********************************************************************//
// DispIntf:  IADsSecurityUtilityDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {A63251B2-5F21-474B-AB52-4A8EFAD10895}
// *********************************************************************//
  IADsSecurityUtilityDisp = dispinterface
    ['{A63251B2-5F21-474B-AB52-4A8EFAD10895}']
    function GetSecurityDescriptor(varPath: OleVariant; lPathFormat: Integer; lFormat: Integer): OleVariant; dispid 2;
    procedure SetSecurityDescriptor(varPath: OleVariant; lPathFormat: Integer; varData: OleVariant;
                                    lDataFormat: Integer); dispid 3;
    function ConvertSecurityDescriptor(varSD: OleVariant; lDataFormat: Integer; lOutFormat: Integer): OleVariant; dispid 4;
    property SecurityMask: Integer dispid 5;
  end;

{$ENDIF JWA_IMPLEMENTATIONSECTION}

{$IFNDEF JWA_OMIT_SECTIONS}
implementation
{$ENDIF JWA_OMIT_SECTIONS}

{$IFNDEF JWA_INTERFACESECTION}

{$ENDIF JWA_OMIT_SECTIONS}

{$IFNDEF JWA_OMIT_SECTIONS}
end.
{$ENDIF JWA_OMIT_SECTIONS}
