# Contributing Guidelines

[AnimePedia](https://github.com/DecodersCommunity/animepedia) is [MIT](https://github.com/DecodersCommunity/animepedia/blob/main/LICENSE) licensed and accepts contributions via GitHub pull requests. This document outlines some of the conventions on development workflow, commit message formatting, contact points, and other resources to make it easier to get your contribution accepted.

## Getting Started

- Fork the repository on GitHub.
- Clone the forked repository, onto your local system:
  - [Getting started with GitHub Desktop](https://docs.github.com/en/desktop/installing-and-configuring-github-desktop/getting-started-with-github-desktop) will guide you through setting up Desktop.
  - Once Desktop is set up, you can use it to [fork the repo](https://docs.github.com/en/desktop/contributing-and-collaborating-using-github-desktop/cloning-and-forking-repositories-from-github-desktop)!
- Create a working branch and start with your changes!

## Design Guide

- If you want to update the User Interface you can check out the [Design Guide](DESIGNGUIDE.md) for ideas.
- You can also help improve the design guide!


## Contribution Flow

This is a outline of what a contributor's workflow looks like:

- Create a separate branch from `master` branch to base your work.
- Make commits of logical units.
- Make sure your commit messages are in the standard format (see below).
- Push your changes to a topic branch in your fork of the repository.
- Make sure to proofread the content before submitting.
- Fetch Upstream & make sure your fork / branch is conflict free
- Submit a pull request to the original repository.

#### Commit Messages

Please follow the below format while writing commit messages:

```
  title: One line description about your change
  <Blank Line>
  description: An optional description of your changes
```

## Pull Request

When you're finished with the changes, create a pull request, also known as a PR.

- Enable the checkbox to [allow maintainer edits](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/allowing-changes-to-a-pull-request-branch-created-from-a-fork) so the branch can be updated for a merge. Once you submit your PR, a Docs team member will review your proposal. We may ask questions or request for additional information.
- We may ask for changes to be made before a PR can be merged, either using [suggested changes](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/incorporating-feedback-in-your-pull-request) or pull request comments. You can apply suggested changes directly through the UI. You can make any other changes in your fork, then commit them to your branch.
- As you update your PR and apply changes, mark each conversation as [resolved](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/commenting-on-a-pull-request#resolving-conversations).
- If you run into any merge issues, checkout this [git tutorial](https://github.com/skills/resolve-merge-conflicts) to help you resolve merge conflicts and other issues.


Thanks for your contributions!

## Code of Conduct

### Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to make participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation.

### Our Responsibilities

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.
