﻿
#ifndef DFPSR_SOUND_API
#define DFPSR_SOUND_API

#include "../DFPSR/includeEssentials.h"

// Call this function from a separate thread in a sound engine to initialize the sound system, call back with sound output requests and terminate when the callback returns false.
// The sound_streamToSpeakers function returns false if the backend could not be created, and true iff the backend completed all work and terminated safely.
// Channels: The number of virtual speakers to send data to.
//   How this is mapped to physical speakers depends on the system, because surround speakers may choose to play mono and stereo sound using only the front speakers.
// sampleRate: The number of ticks per second for each channel.
// soundOutput: A callback that requests length number of ticks generated by the sound engine and written in a packed format into the data array.
//   The soundOutput function returns true iff the audio backend should keep fetching sound samples, and false iff the engine is done and ready for the call to sound_streamToSpeakers to return.
//   data: The data array should be filled with sound samples in the -1.0f to 1.0f range, in indices from 0 to (length * channels) - 1.
//     The audio backend is responsible for converting the 32-bit float samples into a bit-depth chosen by the backend.
//     The backend is supposed to padd the SafePointer's range to at least be divisible by DSR_FLOAT_ALIGNMENT, which allow using both X vectors and F vectors.
//       The F vector can be larger than the X vector if building for a SIMD extension that only supports the widest vector length for floating-point operations.
//     Padding elements will not add to the time passed in the sound engine, for only played elements increment time.
//   length: The number of ticks per channel. The total number of elements to write into data is channels * length.
// How to use:
//   Call sound_streamToSpeakers with desired channels and sampleRate from a separate thread.
//   Handle callbacks to soundOutput by feeding the next packed sound samples and letting it return false when done.
//   Close the thread and let the sound engine clean up resources.
bool sound_streamToSpeakers(int channels, int sampleRate, std::function<bool(dsr::SafePointer<float> data, int length)> soundOutput);

#endif
