### Code Style Guide

We adhere to the principles outlined
in [PEP 8](https://peps.python.org/pep-0008/#:~:text=Use%20the%20function%20naming%20rules,invoke%20Python's%20name%20mangling%20rules)

Thank you for your interest in contributing to our Python project! Below are the steps to guide you through becoming a
part of our developer community.

#### 1. Fork the Project

Visit the repository page on GitHub and click the "Fork" button in the upper right corner. This action will create a
copy of the project in your account.

#### 2. Clone the Repository

```sh
$ git clone https://github.com/DavidRomanovizc/DatingBot.git
```

#### 3. Project Setup

Refer to the instructions above for deploying the project on a local
computer ([Development Guide](docs/DEVELOPMENT.md)).

#### 4. Create a Branch

Create a new branch for your changes:

```sh
$ git checkout -b branch-name
```

#### 5. Make Changes

Make the necessary adjustments to the project code while adhering to the project's structure, coding style, and
development guidelines.

After making changes, execute the following commands to maintain code formatting:

- Run isort to organize imports.
- Run black to ensure consistent code style.
- Run ruff for additional code quality checks.

These steps help maintain a clean and consistent codebase.

#### 6. Commit and Push

```sh
$ git commit -m "Description of your changes"
$ git push origin your-branch-name
```

#### 7. Create a Pull Request

Navigate to your repository on GitHub and click the "New Pull Request" button. Specify the base branch of the project
and the branch with your changes.

#### 8. Discussion and Review

Engage in discussions about your Pull Request with community members. Make necessary changes based on the feedback
received.

#### 9. Merge the Pull Request

Upon approval, your code will be merged into the main branch of the project.

#### 10. Celebration 🎉

Congratulations! You have successfully contributed to the Python project. Thank you for your invaluable help!
