# The Data Engineering Handbook

This repo has all the resources you need to become an amazing data engineer!

## Getting started

If you are new to data engineering, start by following this [2024 breaking into data engineering roadmap](https://blog.dataengineer.io/p/the-2024-breaking-into-data-engineering)

If you are here for the [6-week free YouTube boot camp](https://youtu.be/myhe0LXpCeo) you can check out
- [introduction](bootcamp/introduction.md)
- [software needed](bootcamp/software.md)


For more applied learning:
- Check out the [projects](projects.md) section for more hands-on examples!
- Check out the [interviews](interviews.md) section for more advice on how to pass data engineering interviews!
- Check out the [books](books.md) section for a list of high quality data engineering books
- Check out the [communities](communities.md) section for a list of high quality data engineering communities to join
- Check out the [newsletter](newsletters.md) section to learn via email 


## Resources

### Great [list of over 25 books](books.md)

Top 3 must read books are:
- [Fundamentals of Data Engineering](https://www.amazon.com/Fundamentals-Data-Engineering-Robust-Systems/dp/1098108302/)
- [Designing Data-Intensive Applications](https://www.amazon.com/Designing-Data-Intensive-Applications-Reliable-Maintainable/dp/1449373321/)
- [Designing Machine Learning Systems](https://www.amazon.com/Designing-Machine-Learning-Systems-Production-Ready/dp/1098107969)

### Great [list of over 10 communities to join](communities.md):

Top must-join communities for DE:
- [EcZachly Data Engineering Discord](https://discord.gg/JGumAXncAK)
- [Data Talks Club Slack](https://datatalks.club/slack)
- [Data Engineer Things Community](https://www.dataengineerthings.org/aboutus/)

Top must-join communities for ML:
- [AdalFlow Discord](https://discord.com/invite/ezzszrRZvT)
- [Chip Huyen MLOps Discord](https://discord.gg/dzh728c5t3)

### Companies:

- Orchestration  
  - [Mage](https://www.mage.ai)
  - [Astronomer](https://www.astronomer.io)
  - [Prefect](https://www.prefect.io)
  - [Dagster](https://www.dagster.io)
  - [Airflow](https://airflow.apache.org/)
  - [Kestra](https://kestra.io/) 
  - [Shipyard](https://www.shipyardapp.com/)
  - [Hamilton](https://github.com/dagworks-inc/hamilton)
- Data Lake / Cloud
  - [Tabular](https://www.tabular.io)
  - [Microsoft](https://www.microsoft.com)
  - [Databricks](https://www.databricks.com/company/about-us)
  - [Onehouse](https://www.onehouse.ai)
  - [Delta Lake](https://delta.io/)
- Data Warehouse
  - [Snowflake](https://www.snowflake.com/en/)
  - [Firebolt](https://www.firebolt.io/)
- Data Quality
  - [dbt](https://www.getdbt.com/)
  - [Gable](https://www.gable.ai)
  - [Great Expectations](https://www.greatexpectations.io)
  - [Streamdal](https://streamdal.com)
  - [Coalesce](https://coalesce.io/)
  - [Soda](https://www.soda.io/)
  - [DQOps](https://dqops.com/)
  - [HEDDA.IO](https://hedda.io)
- Education Companies
  - [DataExpert.io](https://www.dataexpert.io)
  - [LearnDataEngineering.com](https://www.learndataengineering.com)
  - [AlgoExpert](https://www.algoexpert.io)
  - [ByteByteGo](https://www.bytebytego.com)
- Analytics / Visualization
  - [Preset](https://www.preset.io)
  - [Starburst](https://www.starburst.io)
  - [Metabase](https://www.metabase.com/)
  - [Looker Studio](https://lookerstudio.google.com/overview)
  - [Tableau](https://www.tableau.com/)
  - [Power BI](https://powerbi.microsoft.com/)
  - [Apache Superset](https://superset.apache.org/)
  - [Evidence](https://evidence.dev)
- Data Integration
  - [Cube](https://cube.dev)
  - [Fivetran](https://www.fivetran.com)
  - [Airbyte](https://airbyte.io)
  - [dlt](https://dlthub.com/)
  - [Sling](https://slingdata.io/)
  - [Meltano](https://meltano.com/)
- Modern OLAP
  - [Apache Druid](https://druid.apache.org/)
  - [ClickHouse](https://clickhouse.com/)
  - [Apache Pinot](https://pinot.apache.org/)
  - [Apache Kylin](https://kylin.apache.org/)
  - [DuckDB](https://duckdb.org/)
  - [QuestDB](https://questdb.io/)
- LLM application library
  - [AdalFlow](https://github.com/SylphAI-Inc/AdalFlow)
  - [LangChain](https://github.com/langchain-ai/langchain)
  - [LlamaIndex](https://github.com/run-llama/llama_index)
- Real-Time Data
  - [Aggregations.io](https://aggregations.io)
  - [Responsive](https://www.responsive.dev/)
  - [RisingWave](https://risingwave.com/)
  - [Striim](https://www.striim.com/)


### Data Engineering blogs of companies:

- [Netflix](https://netflixtechblog.com/tagged/big-data)
- [Uber](https://www.uber.com/blog/houston/data/?uclick_id=b2f43229-f3f4-4bae-bd5d-10a05db2f70c)
- [Databricks](https://www.databricks.com/blog/category/engineering/data-engineering)
- [Airbnb](https://medium.com/airbnb-engineering/data/home)
- [Amazon AWS Blog](https://aws.amazon.com/blogs/big-data/)
- [Microsoft Data Architecture Blogs](https://techcommunity.microsoft.com/t5/data-architecture-blog/bg-p/DataArchitectureBlog)
- [Microsoft Fabric Blog](https://blog.fabric.microsoft.com/)
- [Oracle](https://blogs.oracle.com/datawarehousing/)
- [Meta](https://engineering.fb.com/category/data-infrastructure/)
- [Onehouse](https://www.onehouse.ai/blog)

### Data Engineering Whitepapers:

- [A Five-Layered Business Intelligence Architecture](https://ibimapublishing.com/articles/CIBIMA/2011/695619/695619.pdf)
- [Lakehouse:A New Generation of Open Platforms that Unify Data Warehousing and Advanced Analytics](https://www.cidrdb.org/cidr2021/papers/cidr2021_paper17.pdf)
- [Big Data Quality: A Data Quality Profiling Model](https://link.springer.com/chapter/10.1007/978-3-030-23381-5_5)
- [The Data Lakehouse: Data Warehousing and More](https://arxiv.org/abs/2310.08697)
- [Spark: Cluster Computing with Working Sets](https://dl.acm.org/doi/10.5555/1863103.1863113)
- [The Google File System](https://research.google/pubs/the-google-file-system/)
- [Building a Universal Data Lakehouse](https://www.onehouse.ai/whitepaper/onehouse-universal-data-lakehouse-whitepaper)
- [XTable in Action: Seamless Interoperability in Data Lakes](https://arxiv.org/abs/2401.09621)
- [MapReduce: Simplified Data Processing on Large Clusters](https://research.google/pubs/mapreduce-simplified-data-processing-on-large-clusters/)

## Social Media Accounts

Here's the mostly comprehensive list of data engineering creators: 
**(You have to have at least 5k followers somewhere to be added!)**

| Name                 | <img src="https://upload.wikimedia.org/wikipedia/commons/4/42/YouTube_icon_%282013-2017%29.png" width="50"/><br/> YouTube | <img src="https://upload.wikimedia.org/wikipedia/commons/c/ca/LinkedIn_logo_initials.png" width="50" height="50"/> <br/> LinkedIn | <img src="https://icon2.cleanpng.com/20240402/kzp/transparent-x-logo-woman-black-and-white-photography-street-fa-woman-in-dark-clothing-walking-determinedly660c4b50383a25.14507568.webp" width="50"><br/> X/Twitter | <img src="https://upload.wikimedia.org/wikipedia/commons/a/a5/Instagram_icon.png" width="50"> <br/> Instagram | <img src="https://icon2.cleanpng.com/20240214/kxl/transparent-tiktok-logo-tiktok-logo-blue-and-pink-lettering-re-retro-style-tiktok-logo-evoking-1950s-1710878265139.webp" width="50"> <br/> TikTok |
|----------------------|---------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Zach Wilson          | [Data with Zach](https://www.youtube.com/@eczachly_) (70k+)                                                               | [Zach Wilson](https://www.linkedin.com/in/eczachly) (400k+)                                                                       | [EcZachly](https://www.twitter.com/EcZachly) (30k+)                                                                                                                             | [eczachly](https://www.instagram.com/eczachly) (150k+)                                                        | [@eczachly](https://www.tiktok.com/@eczachly) (70k+)                                                                                                                                                |
| Shashank Mishra      | [E-learning Bridge](https://www.youtube.com/@shashank_mishra) (100k+)                                                     | [Shashank Mishra](https://www.linkedin.com/in/shashank219/) (100k+)                                                               |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Seattle Data Guy     | [Seattle Data Guy](https://www.youtube.com/c/SeattleDataGuy) (100k+)                                                      | [Ben Rogojan](https://www.linkedin.com/in/benjaminrogojan) (100k+)                                                                | [SeattleDataGuy](https://www.twitter.com/SeattleDataGuy) (10k+)                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| TrendyTech           | [TrendyTech](https://www.youtube.com/c/TrendytechInsights) (100k+)                                                        | [Sumit Mittal](https://www.linkedin.com/in/bigdatabysumit/) (100k+)                                                               |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Darshil Parmar       | [Darshil Parmar](https://www.youtube.com/@DarshilParmar) (100k+)                                                          | [Darshil Parmar](https://www.linkedin.com/in/darshil-parmar/) (100k+)                                                             |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Andreas Kretz        | [Andreas Kretz](https://www.youtube.com/c/andreaskayy) (100k+)                                                            | [Andreas Kretz](https://www.linkedin.com/in/andreas-kretz) (100k+)                                                                |                                                                                                                                                                                 | [learndataengineering](https://www.instagram.com/learndataengineering) (5k+)                                  |                                                                                                                                                                                                     |
| ByteByteGo           | [ByteByteGo](https://www.youtube.com/c/ByteByteGo) (1m+)                                                                  | [Alex Xu](https://www.linkedin.com/in/alexxubyte) (100k+)                                                                         | [alexxubyte](https://twitter.com/alexxubyte/) (100k+)                                                                                                                           |                                                                                                               |                                                                                                                                                                                                     |
| The Ravit Show       | [The Ravit Show](https://youtube.com/@theravitshow) (100k+)                                                               |                                                                                                                                   |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Guy in a Cube        | [Guy in a Cube](https://www.youtube.com/@GuyInACube) (100k+)                                                              |                                                                                                                                   |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Adam Marczak         | [Adam Marczak](https://www.youtube.com/@AdamMarczakYT) (100k+)                                                            |                                                                                                                                   |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| nullQueries          | [nullQueries](https://www.youtube.com/@nullQueries) (100k+)                                                               |                                                                                                                                   |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| TECHTFQ by Thoufiq   | [TECHTFQ by Thoufiq](https://www.youtube.com/@techTFQ) (100k+)                                                            |                                                                                                                                   |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| SQLBI                | [SQLBI](https://www.youtube.com/@SQLBI) (100k+)                                                                           | [Marco Russo](https://www.linkedin.com/in/sqlbi) (50k+)                                                                           | [marcorus](https://x.com/marcorus) (10k+)                                                                                                                                       |                                                                                                               |                                                                                                                                                                                                     |
| Azure Lib            | [Azure Lib](https://www.youtube.com/@azurelib-academy) (10k+)                                                             | [Deepak Goyal](https://www.linkedin.com/in/deepak-goyal-93805a17/) (100k+)                                                        |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Advancing Analytics  | [Advancing Analytics](https://www.youtube.com/@AdvancingAnalytics) (10k+)                                                 | [Simon Whiteley](https://www.linkedin.com/in/simon-whiteley-uk/) (10k+)                                                           |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Kahan Data Solutions | [Kahan Data Solutions](https://www.youtube.com/@KahanDataSolutions) (10k+)                                                |                                                                                                                                   |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Ankit Bansal         | [Ankit Bansal](https://youtube.com/@ankitbansal6) (10k+)                                                                  | [Ankit Bansal](https://www.linkedin.com/in/ankitbansal6/) (50k+)                                                                  |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Mr. K Talks Tech     | [Mr. K Talks Tech](https://www.youtube.com/channel/UCzdOan4AmF65PmLLks8Lmww) (10k+)                                       |                                                                                                                                   |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Li Yin               |                                                                                                                           | [Li Yin](https://www.linkedin.com/in/li-yin-ai/) (10k+)                                                                           |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Jaco van Gelder      |                                                                                                                           | [Jaco van Gelder](https://www.linkedin.com/in/jwvangelder/) (10k+)                                                                |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Joseph Machado       |                                                                                                                           | [Joseph Machado](https://www.linkedin.com/in/josephmachado1991/) (10k+)                                                           | [startdataeng](https://twitter.com/startdataeng) (5k+)                                                                                                                          |                                                                                                               |                                                                                                                                                                                                     |
| Eric Roby            |                                                                                                                           | [Eric Roby](https://www.linkedin.com/in/codingwithroby/) (10k+)                                                                   |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Simon Späti          |                                                                                                                           | [Simon Späti](https://www.linkedin.com/in/sspaeti/) (10k+)                                                                        |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Dipankar Mazumdar    |                                                                                                                           | [Dipankar Mazumdar](https://www.linkedin.com/in/dipankar-mazumdar/) (5k+)                                                         |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Daniel Ciocirlan     |                                                                                                                           | [Daniel Ciocirlan](https://www.linkedin.com/in/danielciocirlan) (5k+)                                                             |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Hugo Lu              |                                                                                                                           | [Hugo Lu](https://www.linkedin.com/in/hugo-lu-confirmed/) (5k+)                                                                   |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Tobias Macey         |                                                                                                                           | [Tobias Macey](https://www.linkedin.com/in/tmacey) (5k+)                                                                          |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Marcos Ortiz         |                                                                                                                           | [Marcos Ortiz](https://www.linkedin.com/in/mlortiz) (5k+)                                                                         |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Julien Hurault       |                                                                                                                           | [Julien Hurault](https://www.linkedin.com/in/julienhuraultanalytics/) (5k+)                                                       |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Alex Freberg         | [Alex The Analyst](https://www.youtube.com/@AlexTheAnalyst)   (100k+)                                                     | [Alex Freberg](https://www.linkedin.com/in/alex-freberg/)  (100k+)                                                                |                                                                                                                                                                                 |                                                                                                               | [@alex_the_analyst](https://www.tiktok.com/@alex_the_analyst) (10k+)                                                                                                                                |
| Marc Lamberti        |                                                                                                                           | [Marc Lamberti](https://www.linkedin.com/in/marclamberti) (50k+)                                                                  |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Chip Huyen           |                                                                                                                           | [Chip Huyen](https://www.linkedin.com/in/chiphuyen/) (250k+)                                                                  |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Alex Merced          | [Alex Merced Data](https://www.youtube.com/@alexmerceddata_)                                                               | [Alex Merced](https://www.linkedin.com/in/alexmerced) (30k+)                                                                       | [@amdatalakehouse](https://www.twitter.com/amdatalakehouse)                                                                                                                             | [@alexmercedcoder](https://www.instagram.com/alexmercedcoder)                                                        | |  
| John Kutay           | [John Kutay](https://www.youtube.com/watch?v=7K09lxNbF3Q&list=PL1EXPn7cSg91KLnk2P26Fh8OnGrh6eFmx&pp=iAQB)                 | [John Kutay](https://www.linkedin.com/in/johnkutay/) (5k+)                                                                        | [@JohnKutay](https://x.com/JohnKutay)                                                                                                                                           |                                                                                                               |                                                                                                                                                                                                     |
| Lakshmi Sontenam     |                                                                                                                           | [Lakshmi Sontenam](https://www.linkedin.com/in/shivaga9esh) (9.5k+) |  |  | |
| Hassaan Akbar        |                                                                                                                           | [Hassaan Akbar](https://www.linkedin.com/in/ehassaan) (5k+)                                                                       |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Samuel Focht         | [Python Basics ](https://www.youtube.com/@PythonBasics)   (10k+)                                                           |                                                                                                                                  |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Constantin Lungu     |                                                                                                                            | [Constantin Lungu](https://www.linkedin.com/in/constantin-lungu-668b8756) (10k+)                                                 |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     | 
| Ijaz Ali             |                                                                                                                           | [Ijaz Ali](https://www.linkedin.com/in/ijaz-ali-6aaa87122/) (24K+)   
| Subhankar            |                                                                                                                           | [Subhankar](https://www.linkedin.com/in/subhankarumass/) (5k+)                                                                    |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Ankur Ranjan            |    [Big Data Show](https://www.youtube.com/@TheBigDataShow) (100k+)                                                                                                                       | [Ankur Ranjan](https://www.linkedin.com/in/thebigdatashow/) (48k+)                                                                    |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Lenny            |                                                                                                                           | [Lenny A](https://www.linkedin.com/in/lennyardiles/) (6k+)                                                                    |                                                                                                                                                                                 |                                                                                                               |                                                                                                                                                                                                     |
| Mehdi Ouazza | [Mehdio DataTV](https://www.youtube.com/@mehdio) (3k+)                                                               | [Mehdi Ouazza](https://www.linkedin.com/in/mehd-io/) (20k+)                                                                       | [mehd_io](https://x.com/mehd_io)                                                                                                                             |                                                  | [@mehdio_datatv](https://www.tiktok.com/@mehdio_datatv)                                                                                                                                                 |
| ITVersity           | [ITVersity](https://www.youtube.com/@itversity) (67k+)                                                        | [Durga Gadiraju](https://www.linkedin.com/in/durga0gadiraju/) (48k+)                                                               |                                                                                                                                                                                 |                                                                                                               |                                                                  

### Great Podcasts

- [The Data Engineering Show](https://www.dataengineeringshow.com/)
- [Data Engineering Podcast](https://www.dataengineeringpodcast.com/)
- [DataTopics](https://www.datatopics.io/)
- [The Data Engineering Side Of Data](https://podcasts.apple.com/us/podcast/the-engineering-side-of-data/id1566999533)
- [DataWare](https://www.ascend.io/dataaware-podcast/)
- [The Data Coffee Break Podcast](https://www.deezer.com/us/show/5293247)
- [The Datastack show](https://datastackshow.com/)
- [Intricity101 Data Sharks Podcast](https://www.intricity.com/learningcenter/podcast)
- [Drill to Detail with Mark Rittman](https://www.rittmananalytics.com/drilltodetail/)
- [Analytics Power Hour](https://analyticshour.io/)
- [Catalog & cocktails](https://listen.casted.us/public/127/Catalog-%26-Cocktails-2fcf8728)
- [Datatalks](https://datatalks.club/podcast.html)
- [Data Brew by Databricks](https://www.databricks.com/discover/data-brew)
- [The Data Cloud Podcast by Snowflake](https://rise-of-the-data-cloud.simplecast.com/)
- [What's New in Data](https://www.striim.com/podcast/)
- [Open||Source||Data by Datastax](https://www.datastax.com/resources/podcast/open-source-data)
- [Streaming Audio by confluent](https://developer.confluent.io/podcast/)
- [The Data Scientist Show](https://podcasts.apple.com/us/podcast/the-data-scientist-show/id1584430381)
- [MLOps.community](https://podcast.mlops.community/)
- [Monday Morning Data Chat](https://open.spotify.com/show/3Km3lBNzJpc1nOTJUtbtMh)
- [The Data Chief](https://www.thoughtspot.com/data-chief/podcast)

### Great [list of 20+ newsletters](newsletters.md)

Top must follow newsletters for data engineering:
- [DataEngineer.io Newsletter](https://blog.dataengineer.io)
- [Joe Reis](https://joereis.substack.com)
- [Start Data Engineering](https://www.startdataengineering.com)
- [Data Engineering Weekly](https://www.dataengineeringweekly.com)

### Glossaries:
- [Data Engineering Vault](https://www.ssp.sh/brain/data-engineering/)
- [Airbyte Data Glossary](https://glossary.airbyte.com/)
- [Data Engineering Wiki by Reddit](https://dataengineering.wiki/Index)
- [Seconda Glossary](https://www.secoda.co/glossary/)
- [Glossary Databricks](https://www.databricks.com/glossary)
- [Airtable Glossary](https://airtable.com/shrGh8BqZbkfkbrfk/tbluZ3ayLHC3CKsDb)
- [Data Engineering Glossary by Dagster](https://dagster.io/glossary)


### Design Patterns

- [Cumulative Table Design](https://www.github.com/DataExpert-io/cumulative-table-design)
- [Microbatch Deduplication](https://www.github.com/EcZachly/microbatch-hourly-deduped-tutorial)
- [The Little Book of Pipelines](https://www.github.com/EcZachly/little-book-of-pipelines)
- [Data Developer Platform](https://datadeveloperplatform.org/architecture/)

### Courses / Academies

- [DataExpert.io course](https://www.dataexpert.io) use code **HANDBOOK10** for a discount!
- [LearnDataEngineering.com](https://www.learndataengineering.com)
- [Technical Freelancer Academy](https://www.technicalfreelanceracademy.com/) Use code **zwtech** for a discount!
- [IBM Data Engineering for Everyone](https://www.edx.org/learn/data-engineering/ibm-data-engineering-basics-for-everyone)
- [Qwiklabs](https://www.qwiklabs.com/)
- [DataCamp](https://www.datacamp.com/)
- [Udemy Courses from Shruti Mantri](https://www.udemy.com/user/shruti-mantri-5/)
- [Rock the JVM](https://rockthejvm.com/) teaches Spark (in Scala), Flink and others
- [Data Engineering Zoomcamp by DataTalksClub](https://datatalks.club/)
- [Efficient Data Processing in Spark](https://josephmachado.podia.com/efficient-data-processing-in-spark)
- [Scaler](https://www.scaler.com/)
- [DataTeams - Data Engingeer hiring platform](https://www.datateams.ai/)
- [Udemy Courses from Daniel Blanco](https://danielblanco.dev/links)

### Certifications Courses

- [Google Cloud Certified - Professional Data Engineer](https://cloud.google.com/certification/data-engineer)
- [Databricks - Certified Associate Developer for Apache Spark](https://www.databricks.com/learn/certification/apache-spark-developer-associate)
- [Databricks - Data Engineer Associate](https://www.databricks.com/learn/certification/data-engineer-associate)
- [Databricks - Data Engineer Professional](https://www.databricks.com/learn/certification/data-engineer-professional)
- [Exam DP-203: Data Engineering on Microsoft Azure](https://learn.microsoft.com/en-us/credentials/certifications/exams/dp-203/?tab=tab-learning-paths)
- [Microsoft Fabric Analytics Engineer Associate](https://learn.microsoft.com/credentials/certifications/fabric-analytics-engineer-associate/)
- [AWS Certified Data Engineer - Associate](https://aws.amazon.com/certification/certified-data-engineer-associate/)
