## Generating the SARIF output file is slow
 
This can occur is you are using the option `-g` and generate a SARIF file. The `-g` option
attempts to get the last commit for a file/line. In some case, git can be very slow and the
generation of the file can take a long time.

If you try to generate a SARIF file with the `-g` and have a slow file generation, consider
trying without the `-g` flag.

## How to make the analyzer exit if there is at least one violation?

Use the `--fail-on-any-violation` option.

To make the analyzer exit if there is at least one violation at any level, use the following command

```shell
datadog-static-analyzer --directory /path/to/code -o results.json -f sarif --fail-on-any-violation=none,notice,warning,error
```

To exit only if you have a violation with error, use:

```shell
datadog-static-analyzer --directory /path/to/code -o results.json -f sarif --fail-on-any-violation=error
```

## Do you support Alpine Linux/musl libc?

If you tried to run the analyzer on Alpine and/or got the following error:

```
Error relocating /lib/ld-linux-x86-64.so.2: unsupported relocation
```

it means you are not using glibc. Unfortunately, we do not support Alpine Linux
at this time. We plan to support it in the future, the issue is tracked [here](https://github.com/DataDog/datadog-static-analyzer/issues/245).


## How to produce a CSV file?

Use the `--format csv` option like this

```shell
datadog-static-analyzer --directory /path/to/code -o results.csv -f csv
```

## Diff-aware scan fails

If you get the error `diff aware not enabled (unable to generate diff-aware request data), proceeding with full scan`, it
is generally because the user running the scan and the user owning the repository are different.

To fix this issue you can disable the `safe_directory` Git option. To do so, run the following command:

```shell

git config --global --add safe.directory /path/to/repository

```

You can learn more about diff-aware scanning in our [dedicated documentation](doc/diff-aware.md).


## How to scan generated files?

By default, the static analyzer skip generated files (like files generated by protobuf).
This is implemented in [generated_content.rs](crates/static-analysis-kernel/src/analysis/generated_content.rs).

If you want to force the analysis of generated code, add the directive 
`ignore-generated-files` in your `static-analysis.datadog.yml` file as shown below.

```yaml
rulesets:
  - ruleset1
ignore-generated-files: false
```


## I have a bug to report

Please send us a bug report, either by [creating an issue](https://github.com/DataDog/datadog-static-analyzer/issues) 
on this repository or by contacting your Datadog Customer Success Manager (if you are a Datadog customer).

You can find complete information on how to report a bug in the
[dedicated documentation page](doc/report-issue.md).


## I do not see an answer to my question

Please ask your question in the [discussions section](https://github.com/DataDog/datadog-static-analyzer/discussions).

