# Contributing to Random Quotes Generator

Thanks for your interest in contributing! Here’s how you can help:

## How to Contribute
1. **Fork the repository**:
  
   Click the "Fork" button on the top-right corner of the repository page.
2. **Clone your forked repository** locally:
   ```sh
   git clone https://github.com/your-username/random-quotes-generator.git
   ```
3. Create a new branch for your feature or bug fix.
   ```sh
     git switch -c MY_BRANCH/FEATURE_NAME
   ```
4. Commit your changes and push to your fork.
   ```sh
     git commit -m "Add feature name or fix bug"
     git push origin feature-name
    ```
5. Open a pull request:

   Describe your changes in detail. Reference any issues you worked on.

## Starting up the Project

1. **Install Live Server Extension**
   - Ensure you have the Live Server (Five Server) extension by Yannick installed in VS Code.
   - ![Five Server Extension](/assets/images/five-server.png)

2. **Activate the Extension**
   - The extension should already be activated. If it isn't, click the enable button.

3. **Start the Live Server**
   - Open the `index.html` file.
   - At the bottom corner of the screen, click the **Go Live** button to start the server.
   - ![Go Live Button](/assets/images/bottom-live-server.png)

## Code Style
- Follow standard HTML, CSS, and JavaScript practices.
- Keep your code clean and readable.
- Use comments to explain complex logic.

## Reporting Bugs
- Go to the [Issues](https://github.com/DanonymousCoder/Random-quotes-generator/issues) tab.
- Click New Issue and provide a detailed description of the bug, including steps to reproduce it, if possible.

## Feature Requests
- Open an issue for a feature request with the title "Feature Request."
- Be as specific as possible in your description.

## Pull Request Process
- Make sure your branch is up to date with the main branch.
- Before submitting a PR, ensure there are no merge conflicts.
- Provide a clear description of the changes you’ve made and link it to any relevant issues.
- Provide images if necessary
