/*
 * Enum_PGN.h
 *
 *  Created on: 9 juli 2021
 *      Author: Daniel Mårtensson
 */

#ifndef SAE_J1939_ENUMS_SAE_J1939_ENUM_PGN_H_
#define SAE_J1939_ENUMS_SAE_J1939_ENUM_PGN_H_

/* PGN enums */
typedef enum {
	PGN_ADDRESS_DELETE = 0x000002U,	/* NOT SAE J1939 standard. If you find the correct PGN number, please do a pull request */
	PGN_REQUEST = 0x00EA00U,
	PGN_ACKNOWLEDGEMENT = 0x00E800U,
	PGN_TP_CM = 0x00EC00U,
	PGN_TP_DT = 0x00EB00U,
	PGN_ADDRESS_CLAIMED = 0x00EE00U,
	PGN_PROPRIETARY_A = 0x00EF00U,
	PGN_COMMANDED_ADDRESS = 0x00FED8U,
	PGN_DM1 = 0x00FECAU,
	PGN_DM2 = 0x00FECBU,
	PGN_DM3 = 0x00FECCU,
	PGN_DM14 = 0x00D900U,
	PGN_DM15 = 0x00D800U,
	PGN_DM16 = 0x00D700U,
	PGN_SOFTWARE_IDENTIFICATION = 0x00FEDAU,
	PGN_ECU_IDENTIFICATION = 0x00FDC5U,
	PGN_COMPONENT_IDENTIFICATION = 0x00FEEBU,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_0 = 0x00FE10U,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_1 = 0x00FE11U,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_2 = 0x00FE12U,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_3 = 0x00FE13U,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_4 = 0x00FE14U,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_5 = 0x00FE15U,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_6 = 0x00FE16U,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_7 = 0x00FE17U,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_8 = 0x00FE18U,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_9 = 0x00FE19U,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_10 = 0x00FE1AU,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_11 = 0x00FE1BU,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_12 = 0x00FE1CU,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_13 = 0x00FE1DU,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_14 = 0x00FE1EU,
	PGN_AUXILIARY_VALVE_ESTIMATED_FLOW_15 = 0x00FE1FU,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_0 = 0x00FF20U,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_1 = 0x00FF21U,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_2 = 0x00FF22U,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_3 = 0x00FF23U,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_4 = 0x00FF24U,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_5 = 0x00FF25U,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_6 = 0x00FF26U,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_7 = 0x00FF27U,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_8 = 0x00FF28U,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_9 = 0x00FF29U,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_10 = 0x00FF2AU,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_11 = 0x00FF2BU,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_12 = 0x00FF2CU,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_13 = 0x00FF2DU,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_14 = 0x00FF2EU,
	PGN_AUXILIARY_VALVE_MEASURED_POSITION_15 = 0x00FF2FU,
	PGN_AUXILIARY_VALVE_COMMAND_0 = 0x00FE30U,
	PGN_AUXILIARY_VALVE_COMMAND_1 = 0x00FE31U,
	PGN_AUXILIARY_VALVE_COMMAND_2 = 0x00FE32U,
	PGN_AUXILIARY_VALVE_COMMAND_3 = 0x00FE33U,
	PGN_AUXILIARY_VALVE_COMMAND_4 = 0x00FE34U,
	PGN_AUXILIARY_VALVE_COMMAND_5 = 0x00FE35U,
	PGN_AUXILIARY_VALVE_COMMAND_6 = 0x00FE36U,
	PGN_AUXILIARY_VALVE_COMMAND_7 = 0x00FE37U,
	PGN_AUXILIARY_VALVE_COMMAND_8 = 0x00FE38U,
	PGN_AUXILIARY_VALVE_COMMAND_9 = 0x00FE39U,
	PGN_AUXILIARY_VALVE_COMMAND_10 = 0x00FE3AU,
	PGN_AUXILIARY_VALVE_COMMAND_11 = 0x00FE3BU,
	PGN_AUXILIARY_VALVE_COMMAND_12 = 0x00FE3CU,
	PGN_AUXILIARY_VALVE_COMMAND_13 = 0x00FE3DU,
	PGN_AUXILIARY_VALVE_COMMAND_14 = 0x00FE3EU,
	PGN_AUXILIARY_VALVE_COMMAND_15 = 0x00FE3FU,
	PGN_GENERAL_PURPOSE_VALVE_ESTIMATED_FLOW = 0x00C600U,
	PGN_ENGINE_HOURS_65253 = 0x00FE3FU,
	PGN_ENGINE_TEMPERATURE_1_65262 = 0x00FEEEU,
	PGN_VEHICLE_ELECTRICAL_POWER_1_65271 = 0x00FEF7U,
	PGN_ELECTRONIC_ENGINE_CONTROLLER_1_61444 = 0x00F004U,
	PGN_COLD_START_AIDS_64966 = 0x00FDC6U,
	PGN_FUEL_CONSUMPTION_65257 = 0x00FEE9U,
	PGN_FUEL_ECONOMY_65266 = 0x00FEF2U,
	PGN_ENGINE_FLUIDS_LEVEL_PRESSURE_1_65263 = 0x00FEEFU,
	PGN_ELECTRONIC_ENGINE_CONTROLLER_2_61443 = 0x00F003U,
	PGN_AMBIENT_CONDITIONS_65269 = 0x00FEF5U,
	PGN_ENGINE_FUEL_LUBE_SYSTEMS_65130 = 0x00FE6AU,
	PGN_AUXILIARY_ANALOG_INFORMATION_65164 = 0x00FE8CU,
	PGN_AFTERTREATMENT_1_DEF_TANK_1_65110 = 0x00FE56U,
	PGN_SHUTDOWN_65252 = 0x00FEE4U,
	PGN_ELECTRONIC_ENGINE_CONTROLLER_3_65247 = 0x00FEDFU,
	PGN_ENGINE_FLUIDS_LEVEL_PRESSURE_12_64735 = 0x00FCDFU,
	PGN_INTAKE_MANIFOLD_INFO_1_65190 = 0x00FEA6U,
	PGN_DASH_DISPLAY_65276 = 0x00FEFCU,
	PGN_DIRECT_LAMP_CONTROL_COMMAND_1_64775 = 0x00FD07U,
	PGN_TORQUE_SPEED_CONTROL_1_0 = 0x000000U,
	PGN_ELECTRONIC_BRAKE_CONTROLLER_1_61441 = 0x00F001U,
	PGN_PROPRIETARY_B_START= 0x00FF00U,
	PGN_PROPRIETARY_B_END= 0x00FFFFU,
	// Same as proprietary B but with DP (data page = 1)
	PGN_PROPRIETARY_B2_START= 0x01FF00U, /* This range is not officially support by the standard */
	PGN_PROPRIETARY_B2_END= 0x01FFFFU	 /* but it is very commonly used, so it's supported here */
	
	/* Add more here */
}ENUM_PGN_CODES;

#endif /* SAE_J1939_ENUMS_SAE_J1939_ENUM_PGN_H_ */
